---
name: First Timer Only Issue
about: Create an issue to welcome a new contributor into the community.
title: ''
labels: first-timer-only
assignees: ''

---

## Background

Overview of your issue here.

## Instructions
Hi, this is a `first-timer-only` issue. This means we've worked to make it more legible to people who either **haven't contributed to our codebase before, or even folks who haven't contributed to open source before**.

We're interested in helping you take the first step, and can answer questions and help you out along the way. Note that we're especially interested in contributions from underrepresented groups!

We know that creating a pull request is the biggest barrier for new contributors. This issue is for you 💝

If you have contributed before, **consider leaving this PR for someone new**, and looking through our general [bug](https://github.com/moveit/moveit/labels/bug) issues. Thanks!

### 🤔 What you will need to know.

Nothing. This issue is meant to welcome you to Open Source :) We are happy to walk you through the process.

### 📋 Step by Step

- [ ] 🙋 **Claim this issue**: Comment below. If someone else has claimed it, ask if they've opened a pull request already and if they're stuck -- maybe you can help them solve a problem or move it along!

- [ ] 🗄️ **Create a local workspace** for making your changes and testing [following these instructions](https://moveit.ros.org/install/source/)

- [ ] 🍴 **Fork the repository** using the handy button at the top of the repository page and **clone** it into `~/ws_moveit/src/moveit`, [here is a guide that you can follow](https://guides.github.com/activities/forking/) (You will have to remove or empty the existing `moveit` folder before cloning your own fork)

- [ ] 📝 **Update** the file(s) `$FILENAME`by applying the change shown in the diff below.

```diff
$DIFF
```

- [ ] 🤖 **Apply `clang-format-10`** auto formatting, [following these instructions](https://moveit.ros.org//documentation/contributing/code/?#clang-format-auto-code-formatting)

- [ ] 💾 **Commit and Push** your changes

- [ ] 🔀 **Start a Pull Request** to request to merge your code into `master`. There are two ways that you can start a pull request:
1. If you are not familiar with GitHub or how to create a pull request, [here is a guide you can follow](https://guides.github.com/activities/hello-world/) on how GitHub works.
2. If you are familiar with the terminal or would like to learn to use it, [here is a great tutorial](https://egghead.io/series/how-to-contribute-to-an-open-source-project-on-github) on how to send a pull request using the terminal.

- [ ] 🏁 **Done** Ask in comments for a review :)

### Is someone else already working on this?

🔗- We encourage contributors to link to the original issue in their pull request so all users can easily see if someone's already started on it.

👥- **If someone seems stuck, offer them some help!**

### 🤔❓ Questions?

Don’t hesitate to ask questions or to get help if you feel like you are getting stuck. For example leave a comment below!

💬️ - You can even ping us by using an `@mention` in the comments.

Furthermore, you find helpful resources here:
* [MoveIt FAQ](https://moveit.ros.org/documentation/faqs/)
* [MoveIt Tutorials](https://moveit.github.io/moveit_tutorials/)
* [MoveIt contribution guide](https://moveit.ros.org/documentation/contributing/)
* [ROS Tutorials](https://wiki.ros.org/ROS/Tutorials)
* [ROS Answers](https://answers.ros.org/questions/)

**Good luck with your first issue!**
