import unittest, logging
import pyncm, pyncm.apis

logging.basicConfig(level=0)
# Account from https://github.com/Binaryify/NeteaseCloudMusicApi/blob/master/test/login.test.js
pyncm.SetCurrentSession(
    pyncm.LoadSessionFromString(
        "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"
    )
)


class APITest(unittest.TestCase):
    def test_set_like(self):
        self.assertEqual(
            pyncm.apis.track.SetLikeTrack(31140560, like=True).get("code", 0), 200
        )

    def test_set_like_revert(self):
        self.assertEqual(
            pyncm.apis.track.SetLikeTrack(31140560, like=False).get("code", 0), 200
        )

    def test_manipulate_playlist(self):
        playlist = pyncm.apis.playlist.SetCreatePlaylist("Playlist")
        self.assertEqual(playlist.get("code", 0), 200, "Cannot create Playlist")
        self.assertEqual(
            pyncm.apis.playlist.SetManipulatePlaylistTracks(
                31140560, playlist.get("id", 0)
            ).get("code", 0),
            200,
            "Cannot add track to playlist created",
        )
        self.assertEqual(
            pyncm.apis.playlist.SetRemovePlaylist(playlist.get("id", 0)).get("code", 0),
            200,
            "Cannot remove track from playlist created",
        )


if __name__ == "__main__":
    unittest.main()
