/** Strings created from cli with command: `npx mini-svg-data-uri <svg-file>` **/

export function dataUriOrders(color: string) {
  return `data:image/svg+xml,%3csvg width='14' height='18' viewBox='0 0 14 18' fill='none' xmlns='http://www.w3.org/2000/svg'%3e %3cg clip-path='url(%23clip0_132_44)'%3e %3cpath d='M2.55499 18C2.31908 17.933 2.07745 17.8834 1.84869 17.796C0.634846 17.3282 -0.105759 16.0764 0.0129098 14.7649C0.128719 13.4884 0.214503 12.2089 0.314585 10.9309C0.413237 9.67618 0.511889 8.42148 0.610541 7.16679C0.672019 6.38424 0.737787 5.60315 0.792117 4.82061C0.845018 4.05409 1.35115 3.55571 2.10319 3.55134C2.58072 3.54843 3.05682 3.55134 3.53436 3.54843C3.54579 3.54843 3.5558 3.5426 3.58297 3.53531C3.60584 2.35931 4.05621 1.38586 4.99412 0.674721C5.65609 0.171968 6.4067 -0.0437055 7.2288 0.00729839C8.85441 0.106392 10.4114 1.47767 10.43 3.54843C10.5887 3.54843 10.7474 3.54843 10.9061 3.54843C11.2449 3.54843 11.5838 3.54551 11.9241 3.54843C12.6547 3.55425 13.1622 4.05846 13.218 4.79875C13.3338 6.35801 13.4625 7.91582 13.584 9.47362C13.6812 10.7283 13.777 11.9845 13.8728 13.2392C13.9171 13.8235 13.9857 14.4064 14 14.9908C14.0372 16.4903 13.0035 17.7304 11.5495 17.9636C11.518 17.9694 11.4866 17.9854 11.4565 17.9971H2.55499V18ZM4.62525 4.61222C4.62525 5.04794 4.62811 5.46471 4.62525 5.88003C4.62239 6.19626 4.40221 6.4265 4.1134 6.42942C3.82602 6.43233 3.59869 6.20208 3.59297 5.88877C3.58726 5.57255 3.59155 5.25633 3.59155 4.9401C3.59155 4.83081 3.59155 4.72297 3.59155 4.60639C3.06254 4.60639 2.55641 4.60348 2.05172 4.60639C1.88158 4.60639 1.83869 4.72589 1.82725 4.8789C1.75862 5.80134 1.6857 6.72378 1.61279 7.64622C1.51414 8.90675 1.41405 10.1687 1.3154 11.4293C1.22676 12.5557 1.15098 13.6836 1.04804 14.8101C0.93938 15.9919 1.75862 16.9435 2.92243 16.945C5.64751 16.9479 8.37259 16.9479 11.0977 16.945C12.2386 16.9435 13.0607 16.0167 12.9663 14.8567C12.8648 13.6137 12.7676 12.3692 12.6704 11.1261C12.5074 9.04227 12.3458 6.95694 12.1843 4.87307C12.1685 4.66614 12.1071 4.60639 11.904 4.60493C11.4494 4.60348 10.9962 4.60493 10.5415 4.60493C10.5043 4.60493 10.4657 4.61514 10.4286 4.61951C10.4257 4.65302 10.4228 4.67634 10.4228 4.69966C10.4228 5.10332 10.4286 5.50843 10.4185 5.91209C10.4114 6.21083 10.1726 6.43525 9.89383 6.42796C9.61789 6.42067 9.40057 6.20063 9.38914 5.90772C9.38342 5.76199 9.38771 5.61481 9.38771 5.46763C9.38771 5.18346 9.38771 4.89784 9.38771 4.61076H4.62811L4.62525 4.61222ZM9.38771 3.54114C9.36769 2.59247 8.99167 1.85072 8.18816 1.3844C7.3203 0.881651 6.44244 0.928283 5.6232 1.5141C4.94408 1.99936 4.62954 2.69302 4.62525 3.54114H9.38771Z' fill='${color}'/%3e %3cpath d='M6.29099 11.2952C6.60553 10.9731 6.91007 10.6642 7.2146 10.3538C7.66926 9.8904 8.12106 9.42262 8.58 8.96358C8.89883 8.6459 9.37208 8.77268 9.47216 9.19674C9.52077 9.40513 9.44214 9.57417 9.30059 9.7199C9.04038 9.98512 8.7816 10.2503 8.52138 10.5141C7.92804 11.1189 7.33613 11.7236 6.74279 12.3269C6.42968 12.6461 6.16231 12.6475 5.85063 12.3313C5.4646 11.9378 5.07714 11.5458 4.69397 11.1509C4.54671 10.9994 4.48237 10.8201 4.54957 10.6059C4.61391 10.4033 4.75116 10.2824 4.95276 10.2416C5.15149 10.2022 5.31019 10.2868 5.44745 10.4281C5.72481 10.7152 6.00504 11.0008 6.29099 11.2952Z' fill='${color}'/%3e %3c/g%3e %3cdefs%3e %3cclipPath id='clip0_132_44'%3e %3crect width='14' height='18' fill='white'/%3e %3c/clipPath%3e %3c/defs%3e %3c/svg%3e`;
}

export function dataUriProducts(color: string) {
  return `data:image/svg+xml,%3csvg width='17' height='17' viewBox='0 0 17 17' fill='none' xmlns='http://www.w3.org/2000/svg'%3e %3cg clip-path='url(%23clip0_109_121)'%3e %3cpath d='M16.9954 8.51509C16.9954 9.82191 16.9909 11.1287 16.9977 12.4355C16.9977 12.6983 16.8996 12.8582 16.6644 12.9747C14.0392 14.2861 11.414 15.602 8.79334 16.9226C8.58332 17.0277 8.40526 17.0231 8.19753 16.918C5.57003 15.5952 2.94024 14.277 0.308178 12.961C0.0935947 12.8536 0 12.7028 0 12.4629C0.0045656 9.81962 0.0045656 7.17629 0 4.53068C0 4.29765 0.0913119 4.14915 0.301329 4.04405C2.94253 2.72582 5.58372 1.40073 8.22264 0.0733508C8.42124 -0.0271733 8.59017 -0.0203194 8.78649 0.0779201C11.414 1.40073 14.0415 2.71896 16.6736 4.03263C16.9041 4.14686 17 4.30222 17 4.5581C16.9932 5.87633 16.9977 7.19686 16.9977 8.51509H16.9954ZM0.792131 5.07443C0.787565 5.14525 0.780717 5.19094 0.780717 5.23892C0.780717 7.55097 0.780717 9.86074 0.776151 12.1728C0.776151 12.3099 0.835504 12.3601 0.940513 12.4127C3.2644 13.5756 5.58601 14.7407 7.90761 15.9036C7.96468 15.9333 8.02404 15.9562 8.1085 15.995C8.1085 15.9036 8.1085 15.8396 8.1085 15.7757C8.1085 13.4956 8.1085 11.2133 8.11307 8.93318C8.11307 8.78239 8.06056 8.71157 7.93272 8.6476C5.6134 7.48929 3.29636 6.32641 0.979321 5.16353C0.922251 5.13383 0.862898 5.11098 0.789848 5.07671L0.792131 5.07443ZM10.6264 7.87768C10.542 7.91423 10.4895 7.93708 10.4347 7.96449C9.97583 8.19296 9.52155 8.42828 9.05814 8.64989C8.92346 8.71386 8.88237 8.79382 8.88465 8.94004C8.88922 11.2201 8.88693 13.5025 8.88693 15.7825C8.88693 15.8465 8.88693 15.9105 8.88693 15.9996C8.96912 15.963 9.0239 15.9402 9.07412 15.915C11.4026 14.7476 13.731 13.5801 16.0595 12.4173C16.1805 12.3579 16.2193 12.287 16.2193 12.1545C16.2147 9.86075 16.217 7.56925 16.217 5.27547C16.217 5.21836 16.2124 5.15896 16.2079 5.08128C16.1371 5.11326 16.0823 5.13611 16.0298 5.16124C15.5664 5.39199 15.1053 5.62959 14.6373 5.85349C14.5163 5.9106 14.4752 5.98143 14.4752 6.11394C14.4798 7.3248 14.4775 8.53337 14.4775 9.74423C14.4775 9.9567 14.5049 10.1783 14.2675 10.2994C14.0324 10.4182 13.868 10.272 13.6968 10.1463C13.416 9.94299 13.1307 9.74194 12.8407 9.53404C12.786 9.60943 12.7426 9.66655 12.7015 9.72595C12.2563 10.3725 11.8112 11.0191 11.3638 11.6656C11.2245 11.8667 11.0739 11.9306 10.8889 11.8735C10.7132 11.821 10.6219 11.6747 10.6219 11.4303C10.6219 10.6261 10.6219 9.82191 10.6219 9.01543C10.6219 8.6476 10.6219 8.27749 10.6219 7.87996L10.6264 7.87768ZM3.87847 3.12563C3.9287 3.15533 3.94696 3.17132 3.9675 3.18046C6.31422 4.35933 8.66322 5.53592 11.0122 6.71023C11.0693 6.73764 11.1652 6.7285 11.2245 6.6988C11.7336 6.44978 12.2381 6.1939 12.7449 5.9403C12.9321 5.84663 13.117 5.75296 13.3201 5.65244C13.2768 5.62502 13.2539 5.60675 13.2265 5.59532C10.8844 4.42102 8.54223 3.24443 6.1978 2.07469C6.13388 2.04271 6.02202 2.05185 5.95354 2.08612C5.36229 2.37398 4.7779 2.67099 4.19122 2.9657C4.09534 3.01368 4.00175 3.06394 3.87847 3.12563ZM10.2338 7.19914C10.1767 7.16487 10.1562 7.15116 10.1356 7.13974C7.79119 5.96315 5.44904 4.78656 3.10232 3.61683C3.04525 3.58941 2.94938 3.59398 2.89002 3.6214C2.57271 3.7699 2.26225 3.92982 1.94951 4.08746C1.73036 4.19712 1.5135 4.30907 1.26924 4.43244C1.35142 4.47813 1.4062 4.5124 1.46327 4.53982C3.67759 5.65016 5.89419 6.75592 8.10165 7.87996C8.39613 8.02846 8.63126 8.06502 8.9052 7.87082C9.04216 7.77487 9.20424 7.71547 9.35491 7.64008C9.63797 7.49843 9.92104 7.35678 10.2338 7.19914ZM15.7353 4.4393C15.6623 4.39817 15.6166 4.37076 15.571 4.34791C13.2539 3.18503 10.9392 2.02215 8.61985 0.866121C8.55365 0.834136 8.44407 0.838705 8.37559 0.87069C7.95099 1.07174 7.53323 1.28649 7.1132 1.49668C7.06754 1.51953 7.02417 1.54923 6.96482 1.5835C7.04243 1.62462 7.10179 1.65432 7.16114 1.68402C9.29784 2.75552 11.4368 3.8293 13.5735 4.90079C13.7767 5.0036 13.9867 5.17952 14.1899 5.17723C14.4022 5.17495 14.6145 4.99903 14.8245 4.89622C15.119 4.75001 15.4112 4.60151 15.7308 4.4393H15.7353ZM11.398 10.1966L11.4323 10.2126C11.713 9.80591 11.9915 9.40153 12.2723 8.99487C12.6102 8.50595 12.7129 8.48768 13.1923 8.82809C13.3567 8.9446 13.5233 9.06112 13.7036 9.18906V6.32869C12.9435 6.71023 12.2016 7.08034 11.4619 7.45502C11.4277 7.4733 11.4003 7.54184 11.4003 7.58753C11.3957 8.45798 11.398 9.32842 11.398 10.1989V10.1966Z' fill='${color}'/%3e %3c/g%3e %3cdefs%3e %3cclipPath id='clip0_109_121'%3e %3crect width='17' height='17' fill='white'/%3e %3c/clipPath%3e %3c/defs%3e %3c/svg%3e`;
}

export function dataUriPayouts(color: string) {
  return `data:image/svg+xml,%3csvg width='21' height='15' viewBox='0 0 21 15' fill='none' xmlns='http://www.w3.org/2000/svg'%3e %3cg clip-path='url(%23clip0_109_150)'%3e %3cpath d='M21.0002 9.54545C20.9102 9.74786 20.7548 9.8544 20.5313 9.88103C20.3349 9.905 20.1441 9.96093 19.9478 9.98756C19.6669 10.0249 19.4624 9.88369 19.4188 9.636C19.3779 9.40163 19.5415 9.19921 19.8196 9.14328C19.8932 9.12996 19.9641 9.11132 20.0514 9.09268C19.5197 6.37339 18.988 3.66743 18.4509 0.932166C18.091 0.99875 17.7393 1.06001 17.3875 1.12659C13.2241 1.90962 9.06333 2.69264 4.89986 3.473C4.80716 3.49165 4.709 3.50763 4.6163 3.5023C4.40635 3.48898 4.24549 3.32652 4.22367 3.12943C4.20186 2.90837 4.32456 2.72194 4.55904 2.66867C4.95167 2.58344 5.34975 2.5142 5.7451 2.43962C8.05722 2.0055 10.3694 1.57137 12.6842 1.13724C14.6828 0.761712 16.6786 0.386179 18.6772 0.0106464C18.9744 -0.045284 19.1789 0.0932103 19.2389 0.391506C19.5824 2.136 19.9232 3.8805 20.2668 5.62766C20.5013 6.82883 20.7358 8.03 20.973 9.22851C20.9784 9.25248 20.9948 9.27645 21.0057 9.30042V9.54012L21.0002 9.54545Z' fill='${color}'/%3e %3cpath d='M8.63503 4.96448C11.3152 4.96448 13.9927 4.96448 16.6729 4.96448C17.1228 4.96448 17.2619 5.10031 17.2619 5.5371C17.2619 8.50141 17.2619 11.4657 17.2619 14.4274C17.2619 14.8482 17.1092 14.9973 16.6838 14.9973C11.3125 14.9973 5.93846 14.9973 0.567125 14.9973C0.152688 14.9973 0 14.8482 0 14.4407C0 11.4631 0 8.48543 0 5.51047C0 5.1083 0.144508 4.96448 0.553493 4.96448C3.24734 4.96448 5.94118 4.96448 8.6323 4.96448H8.63503ZM0.872501 5.8274V6.06444C0.872501 8.67453 0.875227 11.2819 0.867048 13.892C0.867048 14.0998 0.927032 14.1451 1.1288 14.1451C6.12659 14.1397 11.1217 14.1397 16.1194 14.1397H16.3703V5.8274H0.872501Z' fill='${color}'/%3e %3cpath d='M18.3198 11.6308C18.0226 8.86362 17.7281 6.1257 17.4337 3.36646C16.9865 3.41174 16.5557 3.45169 16.1222 3.49697C14.7235 3.64079 13.322 3.78195 11.9233 3.92843C10.6936 4.05627 9.46393 4.18411 8.23425 4.31195C6.87642 4.45311 5.51587 4.58894 4.15804 4.7301C3.91265 4.75407 3.66998 4.78603 3.42459 4.80734C3.10558 4.83397 2.89564 4.69015 2.8711 4.43713C2.84383 4.17346 3.00743 3.99501 3.32643 3.96039C4.72516 3.81391 6.12389 3.67008 7.52534 3.52626C8.89135 3.38511 10.2574 3.24395 11.6206 3.10279C12.9921 2.96163 14.3663 2.82314 15.7378 2.68198C16.3894 2.6154 17.0411 2.54349 17.6954 2.48223C18.069 2.44761 18.2217 2.57811 18.2626 2.94832C18.4398 4.58361 18.6143 6.21891 18.7915 7.85421C18.936 9.19121 19.0805 10.5282 19.2278 11.8626C19.2687 12.2301 19.1405 12.4085 18.7697 12.4565C18.4861 12.4938 18.1998 12.5231 17.9136 12.547C17.6654 12.5683 17.4582 12.4032 17.431 12.1795C17.401 11.9398 17.54 11.756 17.7936 11.7028C17.8808 11.6841 17.9708 11.6841 18.0581 11.6735C18.1371 11.6628 18.2189 11.6495 18.3198 11.6362V11.6308Z' fill='${color}'/%3e %3cpath d='M8.62687 6.25887C10.3637 6.25887 12.0978 6.25887 13.8346 6.25887C14.279 6.25887 14.3908 6.35741 14.4426 6.77822C14.4917 7.18838 14.8189 7.50265 15.2388 7.53994C15.6178 7.57456 15.7487 7.71039 15.7487 8.07527C15.7487 9.34569 15.7487 10.6161 15.7487 11.8865C15.7487 12.2328 15.626 12.3686 15.2715 12.4112C14.7589 12.4751 14.4808 12.7574 14.4345 13.2635C14.4099 13.5298 14.2627 13.6736 13.99 13.6976C13.9355 13.7029 13.881 13.7003 13.8264 13.7003C10.361 13.7003 6.89823 13.7003 3.43277 13.6976C3.29371 13.6976 3.12739 13.687 3.02378 13.6124C2.9229 13.5431 2.84656 13.3887 2.8302 13.2635C2.76476 12.7601 2.4921 12.4725 1.98496 12.4112C1.62778 12.3659 1.50781 12.2408 1.50781 11.8892C1.50781 10.6108 1.50781 9.33504 1.50781 8.05663C1.50781 7.71039 1.64414 7.56924 1.99314 7.53994C2.45393 7.49999 2.77021 7.1937 2.82202 6.74093C2.86292 6.37339 2.99924 6.25354 3.37824 6.25354C5.12869 6.25354 6.87642 6.25354 8.62687 6.25354V6.25887ZM8.62687 12.8427C10.2274 12.8427 11.8251 12.8427 13.4256 12.8427C13.5565 12.8427 13.6247 12.8187 13.6765 12.6802C13.8592 12.1902 14.2054 11.8439 14.7098 11.6655C14.8434 11.6175 14.8816 11.5536 14.8816 11.4204C14.8762 10.4563 14.8762 9.49484 14.8816 8.53071C14.8816 8.40819 14.8543 8.34427 14.7235 8.29899C14.2109 8.12055 13.8564 7.77431 13.6683 7.27627C13.6219 7.15109 13.562 7.11647 13.4338 7.11647C10.2274 7.11913 7.02365 7.11913 3.81721 7.11647C3.68634 7.11647 3.62908 7.15375 3.58273 7.27627C3.3946 7.77431 3.04014 8.12055 2.52755 8.29899C2.41303 8.33895 2.37213 8.38955 2.37486 8.5094C2.38031 9.48685 2.38031 10.4616 2.37486 11.4391C2.37486 11.5723 2.42666 11.6202 2.54391 11.6628C3.04014 11.8413 3.38914 12.1742 3.57182 12.6589C3.62635 12.8027 3.69452 12.8453 3.84993 12.8453C5.44225 12.84 7.03456 12.8427 8.62687 12.8427Z' fill='${color}'/%3e %3cpath d='M6.22217 9.97428C6.2249 8.66924 7.30462 7.61721 8.63518 7.61988C9.9712 7.61988 11.0427 8.68522 11.0373 10.0062C11.0318 11.282 9.94939 12.3393 8.64336 12.342C7.30462 12.3473 6.21945 11.2847 6.22217 9.97428ZM8.61882 11.4791C9.47497 11.4791 10.1675 10.8132 10.1675 9.98494C10.1675 9.15663 9.48042 8.4828 8.627 8.47481C7.7954 8.46682 7.0974 9.14598 7.09467 9.96629C7.08922 10.8052 7.76814 11.4764 8.61882 11.4791Z' fill='${color}'/%3e %3c/g%3e %3cdefs%3e %3cclipPath id='clip0_109_150'%3e %3crect width='21' height='15' fill='white'/%3e %3c/clipPath%3e %3c/defs%3e %3c/svg%3e`;
}

export function dataUriReporting(color: string) {
  return `data:image/svg+xml,%3csvg width='16' height='18' viewBox='0 0 16 18' fill='none' xmlns='http://www.w3.org/2000/svg'%3e %3cg clip-path='url(%23clip0_109_133)'%3e %3cpath d='M14.2157 18H1.78657C1.77015 17.9921 1.75577 17.9781 1.73935 17.9762C0.878976 17.8748 -0.012194 17.1061 0.000126301 15.9141C0.0206602 13.87 0.00628647 11.8258 0.00628647 9.7817C0.00628647 7.19921 0.00628647 4.61472 0.00628647 2.03223C0.00628647 1.24556 0.351256 0.639664 1.05967 0.25229C1.28144 0.133098 1.54222 0.081448 1.78657 0C5.11717 0 8.44982 0 11.7804 0C11.9139 0.0973402 12.0597 0.182761 12.1788 0.294007C13.3697 1.41839 14.5545 2.55071 15.7455 3.67509C15.9242 3.84395 16.0001 4.02671 15.9981 4.26708C15.9919 6.08277 15.994 7.89847 15.994 9.71416C15.994 11.804 15.994 13.8958 15.994 15.9857C15.994 16.8955 15.4252 17.6524 14.5607 17.9086C14.4457 17.9424 14.3287 17.9682 14.2137 17.998L14.2157 18ZM11.1028 1.05485H10.8728C7.96727 1.05485 5.05967 1.05485 2.15413 1.05485C1.47446 1.05485 1.09458 1.41839 1.09458 2.07394C1.09458 6.68867 1.09458 11.3054 1.09458 15.9201C1.09458 16.5776 1.47241 16.9432 2.14797 16.9432C6.04735 16.9432 9.94674 16.9432 13.8461 16.9432C14.5237 16.9432 14.9036 16.5776 14.9036 15.9221C14.9036 12.2371 14.9036 8.55402 14.9036 4.869C14.9036 4.80742 14.9036 4.74385 14.9036 4.66637H14.686C13.9591 4.66637 13.2322 4.66637 12.5053 4.66637C11.6141 4.66637 11.1007 4.16577 11.0987 3.29964C11.0987 2.62024 11.0987 1.94085 11.0987 1.26145C11.0987 1.19788 11.0987 1.13431 11.0987 1.05286L11.1028 1.05485ZM12.2547 1.80576C12.2342 1.81569 12.2157 1.82563 12.1952 1.83556C12.1952 2.37192 12.1911 2.90829 12.1973 3.44465C12.1973 3.57775 12.302 3.61549 12.4272 3.61549C12.7907 3.61549 13.1541 3.61549 13.5176 3.61549C13.7024 3.61549 13.8851 3.61549 14.0248 3.61549C13.4416 3.01755 12.8482 2.41165 12.2547 1.80576Z' fill='${color}'/%3e %3cpath d='M7.94676 9.42215C6.68187 9.42215 5.41493 9.42215 4.15005 9.42215C3.81124 9.42215 3.5751 9.21754 3.56072 8.92552C3.54635 8.63151 3.76606 8.39313 4.06997 8.37128C4.09461 8.37128 4.11925 8.37128 4.14183 8.37128C6.67366 8.37128 9.20344 8.37128 11.7353 8.37128C11.9447 8.37128 12.1172 8.43683 12.2342 8.60768C12.3513 8.77653 12.3636 8.95929 12.265 9.14007C12.1603 9.33475 11.9858 9.42613 11.7599 9.42613C11.1788 9.42613 10.5977 9.42613 10.0166 9.42613C9.32664 9.42613 8.6367 9.42613 7.94471 9.42613L7.94676 9.42215Z' fill='${color}'/%3e %3cpath d='M7.6141 13.6395C6.45804 13.6395 5.29993 13.6395 4.14387 13.6395C3.74757 13.6395 3.48063 13.3276 3.57303 12.98C3.63668 12.7376 3.85434 12.5867 4.14798 12.5867C4.918 12.5867 5.68597 12.5867 6.45599 12.5867C7.99397 12.5867 9.53196 12.5867 11.0699 12.5867C11.5012 12.5867 11.7743 12.9423 11.6285 13.3038C11.5422 13.5203 11.3431 13.6395 11.0658 13.6395C9.91595 13.6395 8.764 13.6395 7.6141 13.6395Z' fill='${color}'/%3e %3cpath d='M7.22361 11.5299C6.19487 11.5299 5.16612 11.5299 4.13532 11.5299C3.80267 11.5299 3.56653 11.3153 3.55831 11.0213C3.5501 10.7134 3.78419 10.481 4.11684 10.479C4.49877 10.475 4.87864 10.479 5.26057 10.479C6.94435 10.479 8.62608 10.479 10.3099 10.479C10.7575 10.479 11.0347 10.8604 10.854 11.2259C10.7452 11.4445 10.5542 11.5339 10.3078 11.5339C9.27905 11.5339 8.25031 11.5339 7.21951 11.5339L7.22361 11.5299Z' fill='${color}'/%3e %3c/g%3e %3cdefs%3e %3cclipPath id='clip0_109_133'%3e %3crect width='16' height='18' fill='white'/%3e %3c/clipPath%3e %3c/defs%3e %3c/svg%3e`;
}

export function dataUriSettings(color: string) {
  return `data:image/svg+xml,%3csvg width='16' height='16' viewBox='0 0 16 16' fill='none' xmlns='http://www.w3.org/2000/svg'%3e %3cg clip-path='url(%23clip0_109_141)'%3e %3cpath d='M7.28356 0C7.76229 0 8.24273 0 8.72147 0C8.73857 0.00853515 8.75567 0.0221914 8.77447 0.0273125C9.4088 0.162168 9.84992 0.60941 9.95592 1.24443C9.97986 1.39123 9.97644 1.54486 9.97302 1.69508C9.97131 1.78214 10.0004 1.8214 10.0842 1.85042C10.2756 1.917 10.4637 1.99381 10.6501 2.07063C10.7595 2.11501 10.8758 2.21914 10.9732 2.20207C11.0707 2.18671 11.1493 2.05527 11.2365 1.97333C11.8247 1.42196 12.6813 1.41171 13.2695 1.95967C13.543 2.21402 13.8097 2.48032 14.0628 2.75685C14.3893 3.11192 14.4988 3.53868 14.4167 4.01494C14.3534 4.38024 14.1534 4.66702 13.885 4.90942C13.7995 4.98624 13.7755 5.04769 13.8371 5.15865C13.9277 5.32764 13.9978 5.50688 14.0696 5.68612C14.203 6.0207 14.2013 6.0207 14.5586 6.02923C15.1878 6.0446 15.7281 6.44063 15.9264 7.03297C15.9538 7.1149 15.9777 7.19855 16.0034 7.28219V8.71951C15.9914 8.75195 15.9777 8.78438 15.9692 8.81852C15.8597 9.26235 15.6067 9.59522 15.2032 9.81201C14.9279 9.96052 14.6287 9.98784 14.3244 9.97247C14.2252 9.96735 14.179 9.99808 14.1466 10.0954C14.0867 10.2832 14.0064 10.4641 13.9328 10.6468C13.8884 10.756 13.7858 10.8721 13.8012 10.9711C13.8166 11.0684 13.9482 11.1486 14.0286 11.234C14.5791 11.8229 14.5894 12.6781 14.0423 13.267C13.7909 13.5385 13.5293 13.7996 13.2592 14.0506C12.8813 14.4005 12.43 14.5098 11.9273 14.4022C11.611 14.3339 11.3494 14.1666 11.1408 13.9243C11.0314 13.7996 10.9425 13.7723 10.7903 13.8594C10.6108 13.9618 10.4107 14.0284 10.2175 14.1018C9.97986 14.1923 9.97473 14.1888 9.97815 14.4449C9.98841 15.0099 9.76956 15.4606 9.29253 15.7644C9.12156 15.872 8.91467 15.9232 8.72318 16H7.28698C7.23397 15.9829 7.18097 15.9624 7.12797 15.9471C6.58255 15.79 6.22692 15.4367 6.0833 14.8904C6.03372 14.7027 6.04227 14.4995 6.03714 14.3015C6.03543 14.2144 6.00978 14.1752 5.926 14.1462C5.73451 14.0813 5.53275 14.0267 5.36349 13.9208C5.11899 13.7689 4.96853 13.8167 4.76678 14.0181C4.19743 14.5883 3.32887 14.5832 2.74071 14.0335C2.46372 13.774 2.19187 13.506 1.93711 13.2244C1.61739 12.871 1.51309 12.446 1.59687 11.9765C1.66184 11.6095 1.86359 11.3244 2.13374 11.0855C2.22436 11.0052 2.22949 10.9404 2.17477 10.8345C2.08757 10.6689 2.02089 10.4931 1.94908 10.3207C1.90292 10.2115 1.89266 10.0544 1.81059 9.99979C1.72339 9.94004 1.57293 9.97247 1.44983 9.96906C0.740278 9.95028 0.129891 9.44842 0.0461126 8.74341C-0.0103097 8.27057 0.00165867 7.78577 0.0307247 7.30951C0.058081 6.87763 0.292319 6.53793 0.644531 6.28529C0.950579 6.06679 1.29937 6.00021 1.66697 6.02582C1.78837 6.03435 1.83966 5.98997 1.87556 5.87731C1.93028 5.7049 1.98157 5.52224 2.07732 5.37203C2.24145 5.11426 2.18845 4.95039 1.97302 4.7353C1.43615 4.19588 1.42589 3.33554 1.92686 2.77905C2.20213 2.47349 2.4945 2.18159 2.80055 1.90846C3.14592 1.59778 3.56481 1.50219 4.02303 1.58071C4.39576 1.64387 4.683 1.85042 4.9275 2.12355C5.00273 2.2089 5.06257 2.21402 5.16515 2.16281C5.35494 2.06551 5.55327 1.98698 5.7516 1.90846C6.03201 1.7958 6.03201 1.79921 6.03714 1.49024C6.0491 0.836445 6.36028 0.375547 6.95357 0.107543C7.05445 0.0631601 7.17242 0.0358476 7.28356 0ZM8.01021 0.93716C7.84436 0.93716 7.6768 0.935453 7.51096 0.93716C7.19465 0.942281 6.97409 1.16249 6.96896 1.48C6.96554 1.69337 6.96896 1.90675 6.96896 2.12013C6.96554 2.38814 6.84415 2.55201 6.58768 2.622C6.10382 2.75515 5.6456 2.94634 5.20961 3.19385C4.97195 3.32871 4.78217 3.3014 4.58725 3.11021C4.43508 2.9617 4.28804 2.80636 4.13246 2.65955C3.89309 2.43081 3.59046 2.43252 3.3528 2.66467C3.1254 2.88659 2.90142 3.11192 2.67915 3.33895C2.43637 3.58647 2.43808 3.89032 2.68257 4.14126C2.82448 4.28635 2.97152 4.42804 3.11173 4.57314C3.31006 4.77798 3.33912 4.96234 3.19892 5.20815C2.95272 5.64003 2.76464 6.0941 2.63299 6.57378C2.55947 6.84178 2.39875 6.95956 2.12177 6.96298C1.90805 6.96469 1.69433 6.96127 1.48061 6.96298C1.17285 6.9681 0.94887 7.18831 0.94545 7.49557C0.940321 7.82844 0.940321 8.16302 0.94545 8.49589C0.94887 8.80316 1.17114 9.02507 1.48061 9.03019C1.69433 9.03531 1.90805 9.03019 2.12177 9.0319C2.40046 9.03531 2.56118 9.1531 2.6347 9.4194C2.76635 9.89736 2.95443 10.3531 3.20063 10.785C3.34083 11.0325 3.31348 11.2169 3.11514 11.42C2.96981 11.5685 2.81935 11.7136 2.67402 11.8639C2.43808 12.108 2.43979 12.4118 2.67915 12.6542C2.90142 12.8813 3.1254 13.1066 3.3528 13.3285C3.59046 13.5607 3.89309 13.5624 4.13246 13.3353C4.28633 13.1885 4.43337 13.0332 4.58725 12.8847C4.78388 12.6935 4.97195 12.6645 5.20961 12.7993C5.6456 13.0468 6.10553 13.238 6.58768 13.3712C6.84415 13.4429 6.96554 13.605 6.96896 13.873C6.97238 14.0864 6.96725 14.2998 6.96896 14.5132C6.97409 14.8307 7.19465 15.0543 7.51096 15.0577C7.83923 15.0611 8.16751 15.0611 8.49407 15.0577C8.81038 15.0543 9.03094 14.8324 9.03607 14.5149C9.03949 14.3015 9.03607 14.0881 9.03607 13.8747C9.03949 13.605 9.15917 13.4429 9.41564 13.3729C9.8995 13.2397 10.3577 13.0485 10.7954 12.801C11.0348 12.6645 11.2211 12.6935 11.4178 12.8847C11.5717 13.0332 11.717 13.1885 11.8726 13.337C12.1102 13.5658 12.4146 13.5641 12.6522 13.3319C12.8796 13.11 13.1036 12.8847 13.3259 12.6576C13.5652 12.4135 13.567 12.1114 13.3327 11.8656C13.1857 11.7119 13.0301 11.5651 12.8813 11.4115C12.6967 11.2203 12.6676 11.0308 12.7976 10.8004C13.0489 10.36 13.2421 9.89566 13.3755 9.40745C13.4421 9.15993 13.6097 9.03873 13.8679 9.03361C14.0867 9.03019 14.3056 9.03531 14.5244 9.0319C14.8322 9.02507 15.0562 8.80486 15.0596 8.4976C15.0647 8.16473 15.0647 7.83015 15.0596 7.49728C15.0544 7.18831 14.8322 6.96981 14.5244 6.96298C14.3056 6.95956 14.0867 6.96298 13.8679 6.96127C13.6097 6.95786 13.4421 6.83495 13.3755 6.58743C13.2421 6.09751 13.0489 5.63491 12.7976 5.19449C12.6659 4.96405 12.695 4.77457 12.8796 4.58338C13.0318 4.42633 13.1908 4.27611 13.3413 4.11736C13.5618 3.8835 13.5601 3.57964 13.3361 3.34919C13.1104 3.11704 12.883 2.89 12.6522 2.66467C12.4111 2.4291 12.1068 2.43081 11.8606 2.6698C11.7119 2.81489 11.5665 2.96511 11.4178 3.11021C11.2211 3.3014 11.0331 3.32871 10.7954 3.19385C10.3594 2.94463 9.90121 2.75515 9.41735 2.622C9.16088 2.55201 9.03949 2.38814 9.03607 2.12013C9.03265 1.90163 9.03949 1.68313 9.03436 1.46463C9.02752 1.1642 8.80867 0.945695 8.50946 0.93716C8.34361 0.932039 8.17605 0.93716 8.01021 0.93716Z' fill='${color}'/%3e %3cpath d='M4.52564 7.99743C4.52906 6.07531 6.08153 4.52362 8.00159 4.52191C9.9285 4.52191 11.4878 6.08555 11.4793 8.01108C11.4707 9.93491 9.91311 11.4849 7.99475 11.4798C6.07298 11.4729 4.52222 9.91784 4.52393 7.99743H4.52564ZM8.0033 5.45907C6.59787 5.45907 5.46259 6.59425 5.46259 8.00084C5.46259 9.40573 6.59787 10.5426 8.0033 10.5426C9.40873 10.5426 10.544 9.40743 10.544 8.00084C10.544 6.59425 9.40873 5.45907 8.0033 5.45907Z' fill='${color}'/%3e %3c/g%3e %3cdefs%3e %3cclipPath id='clip0_109_141'%3e %3crect width='16' height='16' fill='white'/%3e %3c/clipPath%3e %3c/defs%3e %3c/svg%3e`;
}
