/** Strings created from cli with command: `npx mini-svg-data-uri <svg-file>` **/

export function dataUriAddImage(color: string) {
  return `data:image/svg+xml,%3csvg width='121' height='120' viewBox='0 0 121 120' fill='none' xmlns='http://www.w3.org/2000/svg'%3e %3cg clip-path='url(%23clip0_132_599)'%3e %3crect x='1.01562' y='1' width='118' height='118' rx='9' stroke='%23C8C8C8' stroke-width='2' stroke-linecap='round' stroke-dasharray='10 10'/%3e %3cpath d='M60.0156 32.4167V61.5834' stroke='%23C8C8C8' stroke-width='4' stroke-linecap='round' stroke-linejoin='round'/%3e %3cpath d='M45.4321 47H74.5988' stroke='%23C8C8C8' stroke-width='4' stroke-linecap='round' stroke-linejoin='round'/%3e %3cpath d='M23.3376 93L26.9216 83.2H28.9376L32.5216 93H30.6176L29.8336 90.732H26.0116L25.2136 93H23.3376ZM26.5016 89.332H29.3436L27.9156 85.258L26.5016 89.332ZM36.6059 93.168C35.9526 93.168 35.3692 93.0093 34.8559 92.692C34.3426 92.3747 33.9366 91.9407 33.6379 91.39C33.3392 90.8393 33.1899 90.214 33.1899 89.514C33.1899 88.814 33.3392 88.1933 33.6379 87.652C33.9366 87.1013 34.3426 86.672 34.8559 86.364C35.3692 86.0467 35.9526 85.888 36.6059 85.888C37.1286 85.888 37.5859 85.986 37.9779 86.182C38.3699 86.378 38.6872 86.6533 38.9299 87.008V82.92H40.7219V93H39.1259L38.9299 92.006C38.7059 92.314 38.4072 92.5847 38.0339 92.818C37.6699 93.0513 37.1939 93.168 36.6059 93.168ZM36.9839 91.6C37.5626 91.6 38.0339 91.4087 38.3979 91.026C38.7712 90.634 38.9579 90.1347 38.9579 89.528C38.9579 88.9213 38.7712 88.4267 38.3979 88.044C38.0339 87.652 37.5626 87.456 36.9839 87.456C36.4146 87.456 35.9432 87.6473 35.5699 88.03C35.1966 88.4127 35.0099 88.9073 35.0099 89.514C35.0099 90.1207 35.1966 90.62 35.5699 91.012C35.9432 91.404 36.4146 91.6 36.9839 91.6ZM45.7387 93.168C45.0854 93.168 44.5021 93.0093 43.9887 92.692C43.4754 92.3747 43.0694 91.9407 42.7707 91.39C42.4721 90.8393 42.3227 90.214 42.3227 89.514C42.3227 88.814 42.4721 88.1933 42.7707 87.652C43.0694 87.1013 43.4754 86.672 43.9887 86.364C44.5021 86.0467 45.0854 85.888 45.7387 85.888C46.2614 85.888 46.7187 85.986 47.1107 86.182C47.5027 86.378 47.8201 86.6533 48.0627 87.008V82.92H49.8547V93H48.2587L48.0627 92.006C47.8387 92.314 47.5401 92.5847 47.1667 92.818C46.8027 93.0513 46.3267 93.168 45.7387 93.168ZM46.1167 91.6C46.6954 91.6 47.1667 91.4087 47.5307 91.026C47.9041 90.634 48.0907 90.1347 48.0907 89.528C48.0907 88.9213 47.9041 88.4267 47.5307 88.044C47.1667 87.652 46.6954 87.456 46.1167 87.456C45.5474 87.456 45.0761 87.6473 44.7027 88.03C44.3294 88.4127 44.1427 88.9073 44.1427 89.514C44.1427 90.1207 44.3294 90.62 44.7027 91.012C45.0761 91.404 45.5474 91.6 46.1167 91.6ZM55.0575 93V83.2H56.8495V93H55.0575ZM58.7069 93V86.056H60.2889L60.4429 86.994C60.6669 86.658 60.9609 86.392 61.3249 86.196C61.6982 85.9907 62.1275 85.888 62.6129 85.888C63.6862 85.888 64.4469 86.3033 64.8949 87.134C65.1469 86.7513 65.4829 86.448 65.9029 86.224C66.3322 86 66.7989 85.888 67.3029 85.888C68.2082 85.888 68.9035 86.1587 69.3889 86.7C69.8742 87.2413 70.1169 88.0347 70.1169 89.08V93H68.3249V89.248C68.3249 88.6507 68.2082 88.1933 67.9749 87.876C67.7509 87.5587 67.4009 87.4 66.9249 87.4C66.4395 87.4 66.0475 87.5773 65.7489 87.932C65.4595 88.2867 65.3149 88.7813 65.3149 89.416V93H63.5229V89.248C63.5229 88.6507 63.4062 88.1933 63.1729 87.876C62.9395 87.5587 62.5802 87.4 62.0949 87.4C61.6189 87.4 61.2315 87.5773 60.9329 87.932C60.6435 88.2867 60.4989 88.7813 60.4989 89.416V93H58.7069ZM74.2122 93.168C73.6149 93.168 73.1249 93.0747 72.7422 92.888C72.3595 92.692 72.0749 92.4353 71.8882 92.118C71.7015 91.8007 71.6082 91.4507 71.6082 91.068C71.6082 90.424 71.8602 89.9013 72.3642 89.5C72.8682 89.0987 73.6242 88.898 74.6322 88.898H76.3962V88.73C76.3962 88.254 76.2609 87.904 75.9902 87.68C75.7195 87.456 75.3835 87.344 74.9822 87.344C74.6182 87.344 74.3009 87.4327 74.0302 87.61C73.7595 87.778 73.5915 88.03 73.5262 88.366H71.7762C71.8229 87.862 71.9909 87.4233 72.2802 87.05C72.5789 86.6767 72.9615 86.392 73.4282 86.196C73.8949 85.9907 74.4175 85.888 74.9962 85.888C75.9855 85.888 76.7649 86.1353 77.3342 86.63C77.9035 87.1247 78.1882 87.8247 78.1882 88.73V93H76.6622L76.4942 91.88C76.2889 92.2533 75.9995 92.5613 75.6262 92.804C75.2622 93.0467 74.7909 93.168 74.2122 93.168ZM74.6182 91.768C75.1315 91.768 75.5282 91.6 75.8082 91.264C76.0975 90.928 76.2795 90.5127 76.3542 90.018H74.8282C74.3522 90.018 74.0115 90.1067 73.8062 90.284C73.6009 90.452 73.4982 90.662 73.4982 90.914C73.4982 91.1847 73.6009 91.3947 73.8062 91.544C74.0115 91.6933 74.2822 91.768 74.6182 91.768ZM82.8383 90.928C82.5023 90.928 82.1896 90.8907 81.9003 90.816L81.3823 91.334C81.5409 91.418 81.7556 91.488 82.0263 91.544C82.2969 91.6 82.7356 91.656 83.3423 91.712C84.2663 91.796 84.9383 92.0153 85.3583 92.37C85.7783 92.7247 85.9883 93.2147 85.9883 93.84C85.9883 94.2507 85.8763 94.638 85.6523 95.002C85.4283 95.3753 85.0829 95.674 84.6163 95.898C84.1496 96.1313 83.5523 96.248 82.8243 96.248C81.8349 96.248 81.0369 96.0613 80.4303 95.688C79.8236 95.324 79.5203 94.7733 79.5203 94.036C79.5203 93.4107 79.8236 92.8693 80.4303 92.412C80.2436 92.328 80.0803 92.2393 79.9403 92.146C79.8096 92.0527 79.6929 91.9547 79.5903 91.852V91.53L80.8083 90.242C80.2669 89.766 79.9963 89.1547 79.9963 88.408C79.9963 87.9413 80.1083 87.5167 80.3323 87.134C80.5656 86.7513 80.8923 86.448 81.3123 86.224C81.7323 86 82.2409 85.888 82.8383 85.888C83.2303 85.888 83.5943 85.944 83.9303 86.056H86.5623V87.148L85.3723 87.232C85.5589 87.5867 85.6523 87.9787 85.6523 88.408C85.6523 88.8747 85.5403 89.2993 85.3163 89.682C85.0923 90.0647 84.7656 90.368 84.3363 90.592C83.9163 90.816 83.4169 90.928 82.8383 90.928ZM82.8383 89.556C83.2023 89.556 83.5009 89.458 83.7343 89.262C83.9769 89.066 84.0983 88.786 84.0983 88.422C84.0983 88.058 83.9769 87.778 83.7343 87.582C83.5009 87.386 83.2023 87.288 82.8383 87.288C82.4556 87.288 82.1476 87.386 81.9143 87.582C81.6809 87.778 81.5643 88.058 81.5643 88.422C81.5643 88.786 81.6809 89.066 81.9143 89.262C82.1476 89.458 82.4556 89.556 82.8383 89.556ZM81.1583 93.854C81.1583 94.1993 81.3169 94.456 81.6343 94.624C81.9609 94.8013 82.3576 94.89 82.8243 94.89C83.2723 94.89 83.6363 94.7967 83.9163 94.61C84.1963 94.4327 84.3363 94.19 84.3363 93.882C84.3363 93.63 84.2429 93.42 84.0563 93.252C83.8789 93.084 83.5196 92.9813 82.9783 92.944C82.5956 92.916 82.2409 92.874 81.9143 92.818C81.6436 92.9673 81.4476 93.1307 81.3263 93.308C81.2143 93.4853 81.1583 93.6673 81.1583 93.854ZM90.9695 93.168C90.2695 93.168 89.6489 93.0187 89.1075 92.72C88.5662 92.4213 88.1415 92.0013 87.8335 91.46C87.5255 90.9187 87.3715 90.2933 87.3715 89.584C87.3715 88.8653 87.5209 88.226 87.8195 87.666C88.1275 87.106 88.5475 86.672 89.0795 86.364C89.6209 86.0467 90.2555 85.888 90.9835 85.888C91.6649 85.888 92.2669 86.0373 92.7895 86.336C93.3122 86.6347 93.7182 87.0453 94.0075 87.568C94.3062 88.0813 94.4555 88.6553 94.4555 89.29C94.4555 89.3927 94.4509 89.5 94.4415 89.612C94.4415 89.724 94.4369 89.8407 94.4275 89.962H89.1495C89.1869 90.5033 89.3735 90.928 89.7095 91.236C90.0549 91.544 90.4702 91.698 90.9555 91.698C91.3195 91.698 91.6229 91.6187 91.8655 91.46C92.1175 91.292 92.3042 91.0773 92.4255 90.816H94.2455C94.1149 91.2547 93.8955 91.656 93.5875 92.02C93.2889 92.3747 92.9155 92.6547 92.4675 92.86C92.0289 93.0653 91.5295 93.168 90.9695 93.168ZM90.9835 87.344C90.5449 87.344 90.1575 87.47 89.8215 87.722C89.4855 87.9647 89.2709 88.338 89.1775 88.842H92.6355C92.6075 88.3847 92.4395 88.0207 92.1315 87.75C91.8235 87.4793 91.4409 87.344 90.9835 87.344Z' fill='%23C8C8C8'/%3e %3c/g%3e %3cdefs%3e %3cclipPath id='clip0_132_599'%3e %3crect width='120' height='120' fill='${color}' transform='translate(0.015625)'/%3e %3c/clipPath%3e %3c/defs%3e %3c/svg%3e`;
}

export function dataUriAddImageSmall(color: string) {
  return `data:image/svg+xml,%3csvg width='42' height='41' viewBox='0 0 42 41' fill='none' xmlns='http://www.w3.org/2000/svg'%3e %3cg clip-path='url(%23clip0_204_148)'%3e %3crect x='1.00342' y='1' width='39' height='39' rx='9' stroke='%23C8C8C8' stroke-width='2' stroke-linecap='round' stroke-dasharray='10 10'/%3e %3cpath d='M20.5034 13.2084V27.7917' stroke='%23C8C8C8' stroke-width='2' stroke-linecap='round' stroke-linejoin='round'/%3e %3cpath d='M13.2119 20.5H27.7952' stroke='%23C8C8C8' stroke-width='2' stroke-linecap='round' stroke-linejoin='round'/%3e %3c/g%3e %3cdefs%3e %3cclipPath id='clip0_204_148'%3e %3crect width='41' height='41' fill='${color}' transform='translate(0.00341797)'/%3e %3c/clipPath%3e %3c/defs%3e %3c/svg%3e`;
}

export function dataUriBill(color: string) {
  return `data:image/svg+xml,%3csvg width='18' height='17' viewBox='0 0 18 17' fill='none' xmlns='http://www.w3.org/2000/svg'%3e %3cg clip-path='url(%23clip0_110_608)'%3e %3cpath d='M17.9999 8.10293C17.897 8.33063 17.7182 8.40838 17.4799 8.40838C16.7107 8.39728 15.9469 8.40838 15.1778 8.40838C15.1073 8.40838 15.0369 8.40838 14.9448 8.40838C14.9448 8.49724 14.9448 8.56389 14.9448 8.63609C14.9448 10.5688 14.9448 12.5015 14.9448 14.4397C14.9448 15.7004 14.1323 16.7223 12.946 16.95C12.7239 16.9945 12.491 16.9945 12.2635 16.9945C9.04053 16.9945 5.82295 16.9778 2.59996 17.0056C1.42452 17.0167 0.444076 16.3058 0.140736 15.295C0.0594841 15.0284 0.0215665 14.7452 0.0161497 14.4675C-0.00551743 13.9121 0.0107329 13.3512 0.0107329 12.7903C0.0107329 12.3849 0.140736 12.246 0.530745 12.246C1.18618 12.246 1.84161 12.246 2.52954 12.246C2.52954 12.1627 2.52954 12.085 2.52954 12.0128C2.55121 8.66941 2.57829 5.3205 2.59454 1.97715C2.59454 1.31626 2.83288 0.788651 3.34206 0.388782C3.68873 0.105541 4.10041 2.0192e-05 4.53917 0.00557393C7.23673 0.00557393 9.93971 0.00557393 12.6373 0.00557393C13.7423 0.00557393 14.8527 -0.0110873 15.9578 0.00557393C16.9761 0.0277889 17.8266 0.672023 17.9728 1.74389C17.9728 1.76056 17.9891 1.77722 17.9945 1.78832V8.09182L17.9999 8.10293ZM3.30956 12.2405H3.53706C5.77962 12.2405 8.02217 12.2405 10.2647 12.2405C10.6926 12.2405 10.8118 12.3682 10.8172 12.8125C10.8172 13.4234 10.7956 14.0399 10.8389 14.6508C10.8822 15.295 11.2343 15.7615 11.8031 16.0281C12.4044 16.3058 12.984 16.2281 13.504 15.8171C13.9752 15.445 14.1594 14.934 14.1594 14.3342C14.1594 10.2744 14.1594 6.21466 14.1594 2.15487C14.1594 1.70502 14.2406 1.28293 14.4898 0.910834C14.5061 0.888619 14.5061 0.86085 14.5115 0.833081C14.4736 0.833081 14.4519 0.827528 14.4302 0.827528C11.1043 0.827528 7.77841 0.827528 4.4525 0.827528C3.81332 0.827528 3.38539 1.28293 3.37998 1.94938C3.35831 5.3094 3.33123 8.67496 3.30956 12.035C3.30956 12.0961 3.30956 12.1572 3.30956 12.246V12.2405ZM10.021 13.0569H0.812418C0.812418 13.6067 0.790751 14.151 0.812418 14.6841C0.850336 15.4894 1.5816 16.1725 2.36704 16.1725C5.07002 16.1725 7.77841 16.1725 10.4814 16.1725C10.5301 16.1725 10.5789 16.1725 10.6439 16.1725C10.6276 16.1336 10.6222 16.117 10.6114 16.1059C10.1781 15.5783 10.0047 14.9729 10.0155 14.2898C10.0264 13.8844 10.0155 13.4734 10.0155 13.0513L10.021 13.0569ZM17.1928 7.58643C17.1982 7.55866 17.209 7.53645 17.209 7.51978C17.209 5.68705 17.2199 3.85987 17.209 2.02714C17.2036 1.2996 16.6403 0.794205 15.974 0.86085C15.3728 0.921941 14.9502 1.42178 14.9502 2.08823C14.9502 3.85987 14.9502 5.63151 14.9502 7.40316C14.9502 7.46425 14.9502 7.51978 14.9502 7.58643H17.2036H17.1928Z' fill='${color}'/%3e %3cpath d='M8.56419 10.1744C7.45916 10.1744 6.35413 10.1744 5.24369 10.1744C5.16786 10.1744 5.09202 10.1744 5.01619 10.1633C4.82118 10.1356 4.68576 9.98005 4.68035 9.78567C4.67493 9.59684 4.79951 9.43023 4.9891 9.3858C5.04327 9.37469 5.10286 9.36914 5.16244 9.36914C7.42124 9.36914 9.68005 9.36914 11.9388 9.36914C12.2747 9.36914 12.4589 9.55241 12.4155 9.84121C12.3884 10.0134 12.2909 10.1244 12.123 10.1578C12.0363 10.1744 11.9497 10.18 11.863 10.18C10.7634 10.18 9.66379 10.18 8.56419 10.18V10.1744Z' fill='${color}'/%3e %3cpath d='M8.56402 6.47565C9.69613 6.47565 10.8228 6.47565 11.9549 6.47565C12.2637 6.47565 12.4424 6.64226 12.4262 6.90329C12.4154 7.09211 12.2854 7.24206 12.1012 7.26983C12.0308 7.28094 11.9603 7.28094 11.8899 7.28094C9.66362 7.28094 7.44274 7.28094 5.21644 7.28094C5.14602 7.28094 5.0756 7.28094 5.00518 7.26983C4.8156 7.23651 4.68018 7.0699 4.68018 6.88107C4.68018 6.69224 4.8156 6.52008 5.00518 6.48675C5.0756 6.47565 5.14602 6.47565 5.21644 6.47565C6.3323 6.47565 7.45357 6.47565 8.56943 6.47565H8.56402Z' fill='${color}'/%3e %3cpath d='M6.94961 4.38745C6.35918 4.38745 5.76875 4.38745 5.17832 4.38745C5.09707 4.38745 5.01582 4.37634 4.93457 4.35412C4.77206 4.30414 4.66915 4.13197 4.67998 3.96536C4.69081 3.78764 4.8154 3.63214 4.98874 3.59881C5.05915 3.58771 5.12957 3.58215 5.19999 3.58215C6.35918 3.58215 7.51838 3.58215 8.67215 3.58215C8.78591 3.58215 8.90508 3.60437 9.008 3.65435C9.15425 3.72655 9.203 3.86539 9.18675 4.03201C9.1705 4.19862 9.07841 4.30969 8.92674 4.35968C8.85091 4.38189 8.76424 4.38745 8.68299 4.38745C8.10339 4.38745 7.52379 4.38745 6.9442 4.38745H6.94961Z' fill='${color}'/%3e %3c/g%3e %3cdefs%3e %3cclipPath id='clip0_110_608'%3e %3crect width='18' height='17' fill='${color}'/%3e %3c/clipPath%3e %3c/defs%3e %3c/svg%3e`;
}

export function dataUriCard(color: string) {
  return `data:image/svg+xml,%3csvg width='27' height='23' viewBox='0 0 27 23' fill='none' xmlns='http://www.w3.org/2000/svg'%3e %3cg clip-path='url(%23clip0_110_633)'%3e %3cpath d='M23.4785 4.61407H1.17153C1.17153 4.71899 1.17153 4.81456 1.17153 4.91013C1.17153 7.68606 1.17153 10.4627 1.17153 13.2386C1.17153 14.3402 1.80089 14.9553 2.92653 14.9553C5.59617 14.9553 8.26507 14.9553 10.9347 14.9553C11.0266 14.9553 11.1192 14.9503 11.2097 14.9611C11.5214 14.997 11.7479 15.2536 11.7368 15.5503C11.7258 15.8406 11.5008 16.0677 11.195 16.095C11.131 16.1008 11.067 16.1001 11.0023 16.1001C8.27757 16.1001 5.55352 16.1037 2.82875 16.0986C1.38695 16.0965 0.298807 15.2234 0.0444161 13.8674C0.00324295 13.6489 0.00324295 13.4204 0.00324295 13.1962C0.00103724 10.2852 0.00103724 7.37419 0.00177248 4.46317C0.00177248 3.8344 -0.00999127 3.20563 0.0113305 2.57758C0.0591207 1.1713 1.20756 0.0610695 2.64788 0.0122052C2.73023 0.00933084 2.81331 0.00861224 2.89565 0.00861224C9.18852 0.00861224 15.4814 0.0208283 21.7743 -1.08705e-05C23.2668 -0.00504102 24.3763 0.956436 24.5858 2.16727C24.6909 2.77232 24.6637 3.40181 24.6667 4.02052C24.674 5.5116 24.6645 7.0034 24.6601 8.49448C24.6586 8.89042 24.4895 9.1333 24.1873 9.1872C23.7844 9.25906 23.4837 8.9903 23.48 8.53831C23.4741 7.79241 23.4785 7.04723 23.4785 6.30133C23.4785 5.74586 23.4785 5.1911 23.4785 4.61407ZM1.17815 3.44061H23.4785C23.4785 3.23509 23.4785 3.04754 23.4785 2.85999C23.4749 1.76701 22.8514 1.15405 21.7434 1.15405C17.2945 1.15405 12.8456 1.15405 8.39594 1.15405C6.51521 1.15405 4.63522 1.15117 2.75449 1.15549C1.92 1.15764 1.25314 1.74976 1.18256 2.55459C1.15756 2.83915 1.17888 3.12802 1.17888 3.43989L1.17815 3.44061Z' fill='${color}'/%3e %3cpath d='M20.5697 10.3599C24.1481 10.3765 27.0155 13.2034 27.0001 16.7008C26.9847 20.2032 24.0937 23.0165 20.5264 23C16.9487 22.9827 14.0806 20.1551 14.0953 16.6584C14.11 13.156 17.0017 10.3434 20.5697 10.3599ZM20.5506 11.5047C17.634 11.5039 15.265 13.8214 15.2643 16.6771C15.2628 19.5328 17.631 21.8538 20.5455 21.8553C23.4614 21.856 25.8311 19.5371 25.8318 16.6821C25.8325 13.8257 23.4666 11.5054 20.5506 11.5047Z' fill='${color}'/%3e %3cpath d='M5.27849 12.086C6.05784 12.086 6.83718 12.0774 7.6158 12.0889C8.1062 12.0961 8.39441 12.5912 8.10988 12.9548C8.00327 13.0913 7.78049 13.2149 7.60918 13.2171C6.06004 13.2372 4.5109 13.2314 2.96177 13.2264C2.60518 13.225 2.35446 12.9835 2.34638 12.6645C2.33829 12.3411 2.59783 12.0896 2.96838 12.086C3.73817 12.0795 4.5087 12.0838 5.27849 12.0846V12.086Z' fill='${color}'/%3e %3cpath d='M4.09837 9.20087C4.46525 9.20087 4.83213 9.19584 5.19901 9.20231C5.60633 9.20949 5.85631 9.42866 5.86072 9.77071C5.86513 10.125 5.61221 10.3549 5.19092 10.3578C4.46598 10.3636 3.74178 10.3636 3.01684 10.3578C2.61687 10.3542 2.35439 10.1228 2.34778 9.7894C2.34116 9.44663 2.61025 9.20877 3.02493 9.20231C3.38225 9.19656 3.74031 9.20087 4.09837 9.20087Z' fill='${color}'/%3e %3cpath d='M20.541 17.6005C21.1579 16.9961 21.7394 16.4241 22.3225 15.8536C22.6879 15.4957 23.0305 15.4397 23.3003 15.6919C23.5775 15.9513 23.5246 16.3049 23.1525 16.6699C22.4658 17.3432 21.7784 18.0173 21.0902 18.6892C20.6939 19.0765 20.405 19.0772 20.0131 18.6942C19.4676 18.161 18.9183 17.6321 18.3816 17.091C18.1316 16.8388 18.1434 16.4967 18.3794 16.2711C18.6088 16.0526 18.9367 16.0526 19.1985 16.274C19.2676 16.3329 19.3308 16.3983 19.3948 16.4622C19.7675 16.8323 20.1403 17.2024 20.541 17.6005Z' fill='${color}'/%3e %3c/g%3e %3cdefs%3e %3cclipPath id='clip0_110_633'%3e %3crect width='27' height='23' fill='${color}'/%3e %3c/clipPath%3e %3c/defs%3e %3c/svg%3e`;
}

export function dataUriChevronLeft(color: string) {
  return `data:image/svg+xml,%3csvg width='24' height='24' viewBox='0 0 24 24' fill='none' xmlns='http://www.w3.org/2000/svg'%3e %3cpath d='M15 18L9 12L15 6' stroke='${color}' stroke-width='2' stroke-linecap='round' stroke-linejoin='round'/%3e %3c/svg%3e`;
}

export function dataUriChevronUp(color: string) {
  return `data:image/svg+xml,%3csvg width='13' height='8' viewBox='0 0 13 8' fill='none' xmlns='http://www.w3.org/2000/svg'%3e %3cpath d='M12.5957 6.7981L6.79761 0.999999L0.99951 6.7981' stroke='${color}'/%3e %3c/svg%3e`;
}

export function dataUriEnvelope(color: string) {
  return `data:image/svg+xml,%3csvg width='16' height='11' viewBox='0 0 16 11' fill='none' xmlns='http://www.w3.org/2000/svg'%3e %3cg clip-path='url(%23clip0_110_572)'%3e %3cpath d='M16 9.77491C15.9077 9.99414 15.8483 10.2327 15.7164 10.4261C15.4394 10.8324 15.0173 11 14.5227 11C13.1707 11 11.8186 11 10.46 11C7.47238 11 4.48475 11 1.49711 11C0.883759 11 0.415499 10.7614 0.15169 10.2134C0.059357 10.0199 0.0131904 9.79426 0.00659522 9.58148C0 6.86049 0 4.13951 0 1.42497C0 0.599648 0.60676 0 1.45095 0C5.81698 0 10.183 0 14.5556 0C15.2943 0 15.8483 0.457796 15.9802 1.16706C15.9802 1.1864 15.9934 1.20574 16 1.22509V9.78136V9.77491ZM1.61583 0.92204C1.6554 0.967175 1.67519 0.986518 1.69497 1.00586C3.4493 2.71454 5.20363 4.42321 6.96455 6.13189C7.57791 6.72509 8.42209 6.71864 9.03545 6.11899C10.7832 4.42321 12.5309 2.72098 14.2721 1.02521C14.305 0.999414 14.3248 0.960727 14.3644 0.915592H1.61583V0.92204ZM1.70816 10.0715H14.2918C12.9992 8.78195 11.6801 7.46659 10.3479 6.13189C10.1171 6.35756 9.91261 6.57034 9.70157 6.77667C9.27288 7.20223 8.75185 7.44725 8.1385 7.47948C7.41962 7.51817 6.81286 7.27315 6.31162 6.77667C6.10058 6.57034 5.88953 6.35756 5.66529 6.13189C4.32646 7.46659 3.01401 8.78195 1.72135 10.0651L1.70816 10.0715ZM0.949711 1.56682V9.43963C2.29514 8.09848 3.62077 6.78312 4.90684 5.49355C3.61418 4.21043 2.29514 2.89508 0.949711 1.56038V1.56682ZM15.0569 1.57327C13.7115 2.90797 12.3858 4.22333 11.1129 5.4871C12.399 6.77022 13.7181 8.08558 15.0569 9.41383V1.57327Z' fill='${color}'/%3e %3c/g%3e %3cdefs%3e %3cclipPath id='clip0_110_572'%3e %3crect width='16' height='11' fill='${color}'/%3e %3c/clipPath%3e %3c/defs%3e %3c/svg%3e`;
}

export function dataUriFilter(color: string) {
  return `data:image/svg+xml,%3csvg width='17' height='12' viewBox='0 0 17 12' fill='none' xmlns='http://www.w3.org/2000/svg'%3e %3cg clip-path='url(%23clip0_109_198)'%3e %3cpath d='M8.50224 1.70801C5.99791 1.70801 3.4941 1.70801 0.989761 1.70694C0.857702 1.70694 0.721382 1.70694 0.594648 1.67586C0.174507 1.57193 -0.043285 1.206 0.00783484 0.714707C0.0483047 0.31985 0.345971 0.033753 0.74854 0.00535762C0.834804 0 0.921069 0 1.00733 0C6.00217 0 10.9975 0 15.9924 0.000535762C16.118 0.000535762 16.2469 -0.00321457 16.3694 0.020359C16.7874 0.101259 17.0249 0.452183 16.9988 0.932762C16.9759 1.35709 16.6857 1.66568 16.2735 1.70051C16.1745 1.70908 16.0744 1.70801 15.9748 1.70801C13.4838 1.70801 10.9933 1.70801 8.50224 1.70801Z' fill='${color}'/%3e %3cpath d='M8.49918 6.85349C6.81915 6.85349 5.13858 6.85456 3.45855 6.85295C2.98995 6.85295 2.71039 6.66919 2.59271 6.29469C2.40048 5.68178 2.76684 5.14869 3.40104 5.14816C6.80157 5.14387 10.2016 5.14441 13.6021 5.14816C14.1309 5.14869 14.4493 5.48087 14.4488 6.00109C14.4488 6.51971 14.1287 6.85028 13.5994 6.85188C11.8992 6.8567 10.1989 6.85349 8.49918 6.85403V6.85349Z' fill='${color}'/%3e %3cpath d='M8.48659 11.9984C7.64364 11.9984 6.80017 12.0037 5.95722 11.9968C5.3145 11.9914 4.94335 11.4514 5.14836 10.8347C5.25113 10.525 5.47265 10.3552 5.78629 10.3022C5.85125 10.2909 5.91888 10.2914 5.98491 10.2914C7.66441 10.2914 9.34444 10.2882 11.0239 10.2925C11.639 10.2941 11.9915 10.7297 11.885 11.3389C11.8152 11.7385 11.5037 11.9936 11.0554 11.9968C10.1991 12.0027 9.34231 11.9984 8.48605 11.9984H8.48659Z' fill='${color}'/%3e %3c/g%3e %3cdefs%3e %3cclipPath id='clip0_109_198'%3e %3crect width='17' height='12' fill='${color}'/%3e %3c/clipPath%3e %3c/defs%3e %3c/svg%3e`;
}

export function dataUriImageOutline(_: string) {
  return `data:image/svg+xml,%3csvg width='121' height='120' viewBox='0 0 121 120' fill='none' xmlns='http://www.w3.org/2000/svg'%3e %3crect x='1.01562' y='1' width='118' height='118' rx='9' stroke='%23C8C8C8' stroke-width='2' stroke-linecap='round' stroke-dasharray='10 10'/%3e %3c/svg%3e`;
}

export function dataUriPerson(color: string) {
  return `data:image/svg+xml,%3Csvg width='16' height='16' viewBox='0 0 16 16' fill='none' xmlns='http://www.w3.org/2000/svg'%3E%3Cg clip-path='url(%23clip0_111_436)'%3E%3Cpath d='M8.47138 16.0002H7.53481C7.48946 15.9908 7.44412 15.9798 7.39878 15.9736C6.96254 15.9063 6.51849 15.8688 6.09163 15.7671C1.98414 14.7832 -0.659857 10.6569 0.143817 6.50246C0.478421 4.7756 1.28366 3.30371 2.58142 2.12119C4.43425 0.43344 6.62325 -0.239157 9.10307 0.075243C10.6823 0.275458 12.0754 0.924593 13.2684 1.97885C14.6741 3.22081 15.5528 4.76622 15.8764 6.61977C15.9296 6.9201 15.9593 7.22511 16 7.52856V8.46707C15.9906 8.51712 15.9781 8.56718 15.9718 8.61723C15.9327 8.9113 15.9108 9.20849 15.8561 9.49786C15.5528 11.0918 14.8289 12.4682 13.689 13.6195C12.4944 14.827 11.0575 15.5872 9.37982 15.8766C9.07805 15.9282 8.77315 15.9595 8.46982 16.0002H8.47138ZM13.6046 12.2758C15.706 9.56982 15.6169 5.4263 12.7728 2.79222C10.0162 0.242611 5.73201 0.316127 3.03798 2.98462C0.311119 5.68439 0.40337 9.73562 2.40161 12.2743C3.14743 10.6366 4.36858 9.51507 6.06662 8.90348C4.36545 7.60208 4.35451 5.29491 5.65852 3.95128C6.90312 2.66709 8.9686 2.63581 10.2961 3.90279C11.5985 5.14632 11.7314 7.55046 9.94427 8.90504C11.636 9.51507 12.8541 10.6335 13.6046 12.2758ZM8.06486 15.0663C8.23685 15.0554 8.47138 15.0444 8.70436 15.0272C8.81381 15.0194 8.92169 15.0038 9.02958 14.9881C10.4806 14.766 11.7424 14.1497 12.8197 13.1549C12.8775 13.1017 12.8963 13.0579 12.8666 12.9829C12.1426 11.1027 10.7933 9.95461 8.81537 9.60266C7.45506 9.36022 6.18857 9.67618 5.0503 10.4661C4.14186 11.0965 3.50862 11.9427 3.13962 12.986C3.12398 13.0298 3.14274 13.1111 3.17558 13.1424C4.53588 14.4047 6.14792 15.0398 8.06329 15.0679L8.06486 15.0663ZM10.3445 6.25063C10.3477 4.96018 9.29226 3.90279 8.00231 3.90279C6.71862 3.90279 5.66634 4.95079 5.65852 6.23498C5.65071 7.52387 6.70299 8.58595 7.99293 8.59064C9.28131 8.59533 10.3414 7.54108 10.3445 6.25063Z' fill='${color}'/%3E%3C/g%3E%3Cdefs%3E%3CclipPath id='clip0_111_436'%3E%3Crect width='16' height='16' fill='${color}'/%3E%3C/clipPath%3E%3C/defs%3E%3C/svg%3E%0A`;
}

export function dataUriPhone(color: string) {
  return `data:image/svg+xml,%3csvg width='16' height='16' viewBox='0 0 16 16' fill='none' xmlns='http://www.w3.org/2000/svg'%3e %3cg clip-path='url(%23clip0_110_582)'%3e %3cpath d='M3.41977 0C3.93097 0.0995243 4.30115 0.421515 4.6537 0.778632C5.27067 1.4109 5.91702 2.02561 6.52223 2.67545C7.09219 3.2843 7.08631 4.10391 6.52223 4.72448C6.13442 5.15185 5.71136 5.54995 5.30005 5.95975C5.21779 6.04171 5.20016 6.10026 5.25304 6.21149C5.66435 7.07208 6.26369 7.79802 6.91004 8.48884C7.57401 9.19722 8.29674 9.82949 9.11936 10.3505C9.34265 10.491 9.58356 10.6081 9.81272 10.7428C9.8891 10.7896 9.93611 10.772 10.0007 10.7135C10.3474 10.3622 10.6941 9.99927 11.0584 9.66557C11.2582 9.48408 11.4756 9.30845 11.7165 9.20307C12.3393 8.93377 12.9093 9.08013 13.3852 9.54263C14.0786 10.21 14.7426 10.9008 15.4301 11.5682C16.141 12.2649 16.1998 13.184 15.5417 13.8924C15.054 14.4135 14.5604 14.9345 14.0316 15.4087C13.4675 15.918 12.7565 16.0468 12.0103 15.9883C10.841 15.8946 9.76571 15.4848 8.73156 14.9638C7.19208 14.1969 5.79362 13.2309 4.56556 12.0307C2.71466 10.2276 1.22807 8.18441 0.376067 5.72558C0.123405 5.02305 -0.0234919 4.30882 1.16176e-05 3.56531C0.0235151 2.89206 0.246798 2.30077 0.716868 1.81486C1.13993 1.37578 1.57475 0.948408 2.00956 0.521039C2.28573 0.251738 2.62065 0.0761068 3.00846 0H3.41389L3.41977 0ZM12.2806 15.1921C12.7683 15.2038 13.2207 15.0809 13.5792 14.7355C14.0492 14.2847 14.5017 13.8163 14.9482 13.3363C15.2773 12.985 15.2714 12.5869 14.9424 12.2473C14.2372 11.5214 13.5145 10.813 12.7918 10.1046C12.5156 9.83535 12.1631 9.82949 11.8458 10.052C11.7635 10.1105 11.6871 10.1866 11.6107 10.2569C11.2229 10.6432 10.8351 11.0296 10.4473 11.416C10.1888 11.6736 9.91261 11.7146 9.58943 11.5507C9.3544 11.4336 9.12524 11.3165 8.90196 11.1819C7.92656 10.5964 7.07456 9.86462 6.30482 9.03915C5.57621 8.25466 4.90636 7.42334 4.4598 6.43396C4.27177 6.01244 4.3129 5.77827 4.6537 5.45627C5.03563 5.0933 5.41169 4.72448 5.78187 4.3498C6.23431 3.89316 6.23431 3.52433 5.78187 3.06769C5.13552 2.412 4.4833 1.76802 3.83108 1.12404C3.73119 1.02452 3.61367 0.9367 3.49028 0.878156C3.1201 0.708379 2.82043 0.878156 2.56189 1.12989C2.16821 1.51043 1.77452 1.89096 1.40435 2.29491C1.22219 2.48811 1.06354 2.72228 0.957779 2.96231C0.740371 3.48335 0.79913 4.02781 0.904896 4.56056C1.11055 5.57922 1.50423 6.53348 2.01544 7.4292C3.84283 10.6432 6.40471 13.067 9.80684 14.5715C10.5942 14.9169 11.411 15.157 12.2806 15.1862V15.1921Z' fill='${color}'/%3e %3c/g%3e %3cdefs%3e %3cclipPath id='clip0_110_582'%3e %3crect width='16' height='16' fill='${color}'/%3e %3c/clipPath%3e %3c/defs%3e %3c/svg%3e`;
}

export function dataUriPin(color: string) {
  return `data:image/svg+xml,%3csvg width='14' height='19' viewBox='0 0 14 19' fill='none' xmlns='http://www.w3.org/2000/svg'%3e %3cg clip-path='url(%23clip0_110_587)'%3e %3cpath d='M7.37115 0C7.56054 0.0227818 7.74994 0.0417666 7.93554 0.0721423C10.6666 0.520184 12.553 2.03517 13.5605 4.61331C14.1249 6.06375 14.1287 7.54077 13.6552 9.02538C13.3939 9.84552 13.0151 10.6011 12.5454 11.3187C10.9924 13.688 9.43175 16.0536 7.86736 18.4191C7.74994 18.5937 7.59842 18.7646 7.42039 18.8785C7.06812 19.1025 6.61736 19.0076 6.33327 18.6886C6.25751 18.6013 6.18554 18.5064 6.12115 18.4077C4.56433 16.046 3.0113 13.6843 1.45448 11.3225C0.780238 10.3012 0.302965 9.19624 0.0908442 7.98881C-0.0947619 6.93705 0.0150866 5.90428 0.333268 4.89808C0.715844 3.69065 1.3863 2.65787 2.32948 1.81115C3.39009 0.854316 4.62115 0.277178 6.02645 0.0759392C6.22721 0.0455635 6.42797 0.0265787 6.62872 0C6.87493 0 7.12115 0 7.36736 0H7.37115ZM6.99993 18.214C7.07569 18.1115 7.13251 18.0432 7.18175 17.9672C8.02645 16.6839 8.87872 15.4005 9.71584 14.1133C10.5605 12.8223 11.4128 11.5352 12.2272 10.2214C12.7461 9.38229 13.0492 8.45204 13.1439 7.46483C13.2765 6.03717 12.928 4.71203 12.106 3.55396C10.6477 1.496 8.64009 0.603717 6.13251 0.896083C5.1363 1.01379 4.231 1.39728 3.4166 1.98581C2.32191 2.77558 1.55675 3.81595 1.1363 5.09932C0.863571 5.92326 0.757511 6.77378 0.878723 7.63949C1.0416 8.82794 1.5113 9.89109 2.16281 10.8821C3.71206 13.2476 5.27266 15.6093 6.82948 17.971C6.87494 18.0432 6.93175 18.1077 7.00751 18.2102L6.99993 18.214Z' fill='${color}'/%3e %3cpath d='M6.99256 10.7302C4.94331 10.7227 3.28801 9.05579 3.29937 7.00543C3.30695 4.95886 4.98498 3.2882 7.01907 3.30339C9.05695 3.31857 10.7085 4.98544 10.7047 7.02061C10.7009 9.07097 9.03422 10.7378 6.99256 10.7264V10.7302ZM6.95847 4.12733C5.33725 4.18048 4.06831 5.50562 4.12134 7.08516C4.17437 8.70646 5.50013 9.95566 7.11377 9.90251C8.6668 9.85315 9.93195 8.50902 9.8865 6.95986C9.84104 5.36514 8.5115 4.07797 6.95847 4.12733Z' fill='${color}'/%3e %3c/g%3e %3cdefs%3e %3cclipPath id='clip0_110_587'%3e %3crect width='14' height='19' fill='${color}'/%3e %3c/clipPath%3e %3c/defs%3e %3c/svg%3e`;
}

export function dataUriPlus(_: string) {
  return `data:image/svg+xml,%3csvg width='51' height='50' viewBox='0 0 51 50' fill='none' xmlns='http://www.w3.org/2000/svg'%3e %3cpath d='M25.0156 10.4167V39.5834' stroke='%23C8C8C8' stroke-width='4' stroke-linecap='round' stroke-linejoin='round'/%3e %3cpath d='M10.4321 25H39.5988' stroke='%23C8C8C8' stroke-width='4' stroke-linecap='round' stroke-linejoin='round'/%3e %3c/svg%3e`;
}

export function dataUriProduct(color: string) {
  return `data:image/svg+xml,%3csvg width='22' height='22' viewBox='0 0 22 22' fill='none' xmlns='http://www.w3.org/2000/svg'%3e %3cg clip-path='url(%23clip0_111_199)'%3e %3cpath d='M21.9941 11.0195C21.9941 12.7107 21.9882 14.4019 21.997 16.093C21.997 16.433 21.87 16.64 21.5657 16.7908C18.1684 18.4879 14.771 20.1909 11.3796 21.8998C11.1078 22.0358 10.8774 22.0299 10.6086 21.8939C7.20827 20.182 3.80502 18.476 0.398818 16.773C0.121123 16.6341 0 16.439 0 16.1285C0.00590842 12.7077 0.00590842 9.28696 0 5.86322C0 5.56165 0.118168 5.36947 0.389956 5.23347C3.80798 3.52752 7.226 1.81269 10.6411 0.0949131C10.8981 -0.0351769 11.1167 -0.0263071 11.3708 0.100826C14.771 1.81269 18.1713 3.51865 21.5775 5.21869C21.8759 5.36652 22 5.56756 22 5.8987C21.9911 7.60466 21.997 9.31357 21.997 11.0195H21.9941ZM1.02511 6.56689C1.0192 6.65855 1.01034 6.71768 1.01034 6.77977C1.01034 9.77184 1.01034 12.761 1.00443 15.753C1.00443 15.9304 1.08124 15.9955 1.21713 16.0635C4.22452 17.5684 7.22895 19.0762 10.2334 20.5811C10.3072 20.6196 10.384 20.6491 10.4934 20.6994C10.4934 20.5811 10.4934 20.4984 10.4934 20.4156C10.4934 17.4649 10.4934 14.5113 10.4993 11.5606C10.4993 11.3654 10.4313 11.2738 10.2659 11.191C7.2644 9.69201 4.26588 8.18711 1.26736 6.6822C1.1935 6.64376 1.11669 6.6142 1.02216 6.56985L1.02511 6.56689ZM13.7518 10.1946C13.6425 10.2419 13.5746 10.2715 13.5037 10.307C12.9099 10.6026 12.322 10.9072 11.7223 11.194C11.548 11.2767 11.4948 11.3802 11.4978 11.5694C11.5037 14.5201 11.5007 17.4738 11.5007 20.4244C11.5007 20.5072 11.5007 20.59 11.5007 20.7053C11.6071 20.658 11.678 20.6284 11.743 20.5959C14.7563 19.0851 17.7696 17.5743 20.7829 16.0694C20.9394 15.9925 20.9897 15.9009 20.9897 15.7294C20.9838 12.761 20.9867 9.79549 20.9867 6.82707C20.9867 6.75316 20.9808 6.67629 20.9749 6.57576C20.8833 6.61715 20.8124 6.64672 20.7445 6.67924C20.1448 6.97786 19.548 7.28534 18.9424 7.57509C18.7858 7.64901 18.7326 7.74066 18.7326 7.91214C18.7386 9.47914 18.7356 11.0432 18.7356 12.6102C18.7356 12.8851 18.771 13.1719 18.4638 13.3286C18.1595 13.4824 17.9468 13.2931 17.7253 13.1305C17.3619 12.8674 16.9926 12.6072 16.6174 12.3382C16.5465 12.4357 16.4904 12.5096 16.4372 12.5865C15.8612 13.4232 15.2851 14.2599 14.7061 15.0967C14.5258 15.3568 14.3309 15.4396 14.0916 15.3657C13.8641 15.2977 13.7459 15.1085 13.7459 14.7921C13.7459 13.7514 13.7459 12.7107 13.7459 11.667C13.7459 11.191 13.7459 10.712 13.7459 10.1976L13.7518 10.1946ZM5.0192 4.04492C5.0842 4.08336 5.10783 4.10405 5.13442 4.11588C8.17134 5.64148 11.2112 7.16412 14.2511 8.68381C14.325 8.71929 14.449 8.70747 14.5258 8.66903C15.1846 8.34676 15.8375 8.01562 16.4934 7.68744C16.7356 7.56622 16.9749 7.445 17.2378 7.31491C17.1817 7.27943 17.1521 7.25578 17.1167 7.241C14.0857 5.72131 11.0547 4.19866 8.02068 2.68489C7.93796 2.6435 7.79321 2.65532 7.70458 2.69967C6.93944 3.0722 6.18316 3.45656 5.42393 3.83796C5.29985 3.90005 5.17873 3.96509 5.0192 4.04492ZM13.2437 9.31652C13.1699 9.27217 13.1433 9.25443 13.1167 9.23965C10.0827 7.71701 7.0517 6.19436 4.01477 4.68059C3.94092 4.64511 3.81684 4.65102 3.74003 4.6865C3.32939 4.87868 2.92762 5.08564 2.5229 5.28964C2.23929 5.43156 1.95864 5.57643 1.64254 5.73609C1.74889 5.79522 1.81979 5.83957 1.89365 5.87505C4.75923 7.31195 7.62777 8.74295 10.4845 10.1976C10.8656 10.3898 11.1699 10.4371 11.5244 10.1858C11.7016 10.0616 11.9114 9.98471 12.1064 9.88715C12.4727 9.70384 12.839 9.52053 13.2437 9.31652ZM20.3634 5.74496C20.2688 5.69174 20.2097 5.65626 20.1507 5.6267C17.1521 4.12179 14.1566 2.61689 11.1551 1.12085C11.0694 1.07946 10.9276 1.08537 10.839 1.12676C10.2895 1.38694 9.74889 1.66486 9.20532 1.93687C9.14623 1.96644 9.0901 2.00487 9.01329 2.04922C9.11374 2.10244 9.19055 2.14087 9.26736 2.17931C12.0325 3.56595 14.8006 4.95555 17.5657 6.34219C17.8287 6.47524 18.1004 6.7029 18.3634 6.69994C18.6381 6.69698 18.9129 6.46933 19.1846 6.33628C19.5657 6.14706 19.9439 5.95488 20.3575 5.74496H20.3634ZM14.7504 13.1956L14.7947 13.2163C15.1581 12.69 15.5185 12.1667 15.8818 11.6404C16.3191 11.0077 16.452 10.984 17.0724 11.4246C17.2851 11.5754 17.5007 11.7261 17.7341 11.8917V8.19006C16.7504 8.68381 15.7903 9.16278 14.8331 9.64766C14.7888 9.67132 14.7533 9.76001 14.7533 9.81914C14.7474 10.9456 14.7504 12.0721 14.7504 13.1985V13.1956Z' fill='${color}'/%3e %3c/g%3e %3cdefs%3e %3cclipPath id='clip0_111_199'%3e %3crect width='22' height='22' fill='${color}'/%3e %3c/clipPath%3e %3c/defs%3e %3c/svg%3e`;
}

export function dataUriSettings(color: string) {
  return `data:image/svg+xml,%3csvg width='22' height='22' viewBox='0 0 22 22' fill='none' xmlns='http://www.w3.org/2000/svg'%3e %3cg clip-path='url(%23clip0_1405_197)'%3e %3cpath d='M10.0149 0C10.6732 0 11.3338 0 11.9921 0C12.0156 0.0117358 12.0391 0.0305132 12.065 0.0375547C12.9372 0.222981 13.5437 0.837939 13.6895 1.71108C13.7224 1.91294 13.7177 2.12419 13.713 2.33074C13.7106 2.45044 13.7506 2.50443 13.8658 2.54433C14.1291 2.63587 14.3877 2.74149 14.6439 2.84711C14.7944 2.90814 14.9543 3.05132 15.0883 3.02785C15.2223 3.00672 15.3304 2.82599 15.4503 2.71333C16.259 1.95519 17.4368 1.94111 18.2456 2.69455C18.6217 3.04428 18.9884 3.41043 19.3364 3.79068C19.7854 4.27889 19.9359 4.86568 19.823 5.52054C19.736 6.02283 19.461 6.41716 19.0919 6.75045C18.9743 6.85608 18.9414 6.94057 19.0261 7.09314C19.1507 7.32551 19.2471 7.57196 19.3458 7.81841C19.5292 8.27846 19.5268 8.27846 20.0182 8.29019C20.8833 8.31132 21.6262 8.85586 21.8989 9.67033C21.9365 9.78299 21.9694 9.898 22.0047 10.013V11.9893C21.9882 12.0339 21.9694 12.0785 21.9577 12.1255C21.8072 12.7357 21.4593 13.1934 20.9045 13.4915C20.526 13.6957 20.1145 13.7333 19.6961 13.7122C19.5597 13.7051 19.4963 13.7474 19.4516 13.8811C19.3693 14.1393 19.2588 14.3881 19.1577 14.6393C19.0966 14.7895 18.9555 14.9491 18.9767 15.0852C18.9979 15.219 19.1789 15.3293 19.2894 15.4467C20.0464 16.2565 20.0605 17.4324 19.3082 18.2422C18.9626 18.6154 18.6029 18.9745 18.2315 19.3195C17.7119 19.8007 17.0912 19.9509 16.4001 19.8031C15.9652 19.7092 15.6055 19.4791 15.3186 19.1458C15.1682 18.9745 15.0459 18.9369 14.8367 19.0567C14.5899 19.1975 14.3148 19.289 14.0491 19.3899C13.7224 19.5143 13.7153 19.5097 13.72 19.8617C13.7341 20.6386 13.4332 21.2583 12.7773 21.6761C12.5422 21.824 12.2577 21.8944 11.9944 22H10.0197C9.94677 21.9765 9.87389 21.9484 9.80101 21.9272C9.05107 21.7113 8.56208 21.2254 8.3646 20.4743C8.29642 20.2162 8.30818 19.9368 8.30112 19.6646C8.29877 19.5449 8.26351 19.4909 8.14831 19.451C7.88501 19.3618 7.6076 19.2867 7.37486 19.1411C7.03867 18.9323 6.83179 18.998 6.55438 19.2749C5.77152 20.0589 4.57725 20.0518 3.76853 19.2961C3.38768 18.9393 3.01388 18.5708 2.66359 18.1835C2.22397 17.6976 2.08056 17.1132 2.19576 16.4677C2.28509 15.9631 2.5625 15.5711 2.93395 15.2425C3.05855 15.1322 3.0656 15.043 2.99037 14.8975C2.87048 14.6698 2.77879 14.428 2.68005 14.191C2.61658 14.0408 2.60247 13.8248 2.48963 13.7497C2.36973 13.6676 2.16285 13.7122 1.99358 13.7075C1.01794 13.6816 0.178661 12.9916 0.0634659 12.0222C-0.0141148 11.372 0.00234171 10.7054 0.0423075 10.0506C0.0799224 9.45674 0.402 8.98965 0.886291 8.64227C1.30711 8.34183 1.7867 8.25029 2.29215 8.2855C2.45906 8.29724 2.52959 8.23621 2.57896 8.0813C2.65419 7.84423 2.72472 7.59309 2.85637 7.38654C3.08206 7.03211 3.00918 6.80679 2.71296 6.51104C1.97477 5.76934 1.96067 4.58637 2.64949 3.82119C3.02799 3.40105 3.43 2.99968 3.85081 2.62413C4.3257 2.19695 4.90168 2.06551 5.53173 2.17348C6.04423 2.26032 6.43919 2.54433 6.77537 2.91988C6.87881 3.03723 6.96109 3.04428 7.10215 2.97386C7.3631 2.84007 7.63581 2.7321 7.90852 2.62413C8.29407 2.46922 8.29407 2.47391 8.30112 2.04908C8.31758 1.15011 8.74545 0.516377 9.56122 0.147872C9.69993 0.0868452 9.86214 0.0492905 10.0149 0ZM11.0141 1.28859C10.7861 1.28859 10.5557 1.28625 10.3276 1.28859C9.8927 1.29564 9.58943 1.59842 9.58238 2.03499C9.57768 2.32839 9.58238 2.62179 9.58238 2.91518C9.57768 3.28369 9.41076 3.50902 9.05812 3.60525C8.39281 3.78833 7.76276 4.05121 7.16327 4.39155C6.83649 4.57698 6.57554 4.53942 6.30753 4.27654C6.0983 4.07234 5.89612 3.85874 5.68219 3.65689C5.35306 3.34237 4.93694 3.34471 4.61016 3.66393C4.29749 3.96906 3.98952 4.27889 3.6839 4.59106C3.35007 4.9314 3.35242 5.34919 3.6886 5.69423C3.88373 5.89374 4.08591 6.08855 4.27868 6.28806C4.55139 6.56972 4.59136 6.82322 4.39858 7.16121C4.06005 7.75504 3.80144 8.37939 3.62042 9.03894C3.51933 9.40745 3.29834 9.5694 2.91749 9.5741C2.62363 9.57644 2.32976 9.57175 2.0359 9.5741C1.61273 9.58114 1.30476 9.88392 1.30005 10.3064C1.293 10.7641 1.293 11.2242 1.30005 11.6819C1.30476 12.1043 1.61038 12.4095 2.0359 12.4165C2.32976 12.4236 2.62363 12.4165 2.91749 12.4189C3.3007 12.4236 3.52168 12.5855 3.62277 12.9517C3.80379 13.6089 4.0624 14.2356 4.40093 14.8294C4.59371 15.1697 4.55609 15.4232 4.28338 15.7025C4.08356 15.9068 3.87667 16.1063 3.67684 16.3128C3.35242 16.6485 3.35477 17.0663 3.6839 17.3995C3.98952 17.7117 4.29749 18.0216 4.61016 18.3267C4.93694 18.6459 5.35306 18.6482 5.68219 18.3361C5.89377 18.1342 6.09595 17.9206 6.30753 17.7164C6.57789 17.4535 6.83649 17.4136 7.16327 17.5991C7.76276 17.9394 8.39516 18.2023 9.05812 18.3854C9.41076 18.4839 9.57768 18.7069 9.58238 19.0754C9.58708 19.3688 9.58003 19.6622 9.58238 19.9556C9.58943 20.3922 9.8927 20.6997 10.3276 20.7044C10.779 20.7091 11.2304 20.7091 11.6794 20.7044C12.1143 20.6997 12.4176 20.3945 12.4247 19.958C12.4294 19.6646 12.4247 19.3712 12.4247 19.0778C12.4294 18.7069 12.5939 18.4839 12.9466 18.3877C13.6119 18.2046 14.2419 17.9417 14.8438 17.6014C15.1729 17.4136 15.4291 17.4535 15.6995 17.7164C15.9111 17.9206 16.1109 18.1342 16.3248 18.3384C16.6516 18.6529 17.0701 18.6506 17.3969 18.3314C17.7095 18.0262 18.0175 17.7164 18.3231 17.4042C18.6523 17.0686 18.6546 16.6532 18.3325 16.3152C18.1304 16.1039 17.9164 15.9021 17.7119 15.6908C17.458 15.4279 17.418 15.1674 17.5967 14.8505C17.9423 14.245 18.2079 13.6065 18.3913 12.9352C18.483 12.5949 18.7134 12.4283 19.0684 12.4212C19.3693 12.4165 19.6702 12.4236 19.9711 12.4189C20.3943 12.4095 20.7023 12.1067 20.707 11.6842C20.714 11.2265 20.714 10.7665 20.707 10.3088C20.6999 9.88392 20.3943 9.58348 19.9711 9.5741C19.6702 9.5694 19.3693 9.57409 19.0684 9.57175C18.7134 9.56705 18.483 9.39806 18.3913 9.05772C18.2079 8.38408 17.9423 7.748 17.5967 7.14243C17.4157 6.82556 17.4556 6.56503 17.7095 6.30214C17.9188 6.08621 18.1374 5.87965 18.3443 5.66137C18.6476 5.33981 18.6452 4.92201 18.3372 4.60514C18.0269 4.28593 17.7142 3.97375 17.3969 3.66393C17.0654 3.34002 16.6469 3.34237 16.3084 3.67097C16.1039 3.87048 15.904 4.07703 15.6995 4.27654C15.4291 4.53942 15.1705 4.57698 14.8438 4.39155C14.2443 4.04886 13.6142 3.78833 12.9489 3.60525C12.5963 3.50902 12.4294 3.28369 12.4247 2.91518C12.42 2.61474 12.4294 2.31431 12.4223 2.01387C12.4129 1.60077 12.112 1.30033 11.7006 1.28859C11.4725 1.28155 11.2421 1.28859 11.0141 1.28859Z' fill='${color}'/%3e %3cpath d='M6.22306 10.9965C6.22776 8.35357 8.3624 6.22 11.0025 6.21765C13.652 6.21765 15.796 8.36766 15.7843 11.0153C15.7725 13.6605 13.6308 15.7917 10.9931 15.7847C8.35065 15.7753 6.21835 13.637 6.22071 10.9965H6.22306ZM11.0048 7.50625C9.07238 7.50625 7.51137 9.06711 7.51137 11.0012C7.51137 12.9329 9.07238 14.4961 11.0048 14.4961C12.9373 14.4961 14.4983 12.9352 14.4983 11.0012C14.4983 9.06711 12.9373 7.50625 11.0048 7.50625Z' fill='${color}'/%3e %3c/g%3e %3cdefs%3e %3cclipPath id='clip0_1405_197'%3e %3crect width='22' height='22' fill='${color}'/%3e %3c/clipPath%3e %3c/defs%3e %3c/svg%3e`;
}
