// Copyright (c) morrisjdev. All rights reserved.
// Original copyright (c) .NET Foundation. All rights reserved.
// Modified version by morrisjdev
// Licensed under the Apache License, Version 2.0. See License.txt in the project root for license information.

using System;
using FileContextCore.Storage;
using Microsoft.EntityFrameworkCore;
using Microsoft.EntityFrameworkCore.Diagnostics;
using Microsoft.EntityFrameworkCore.Infrastructure;
using Microsoft.EntityFrameworkCore.Storage;
using Microsoft.Extensions.DependencyInjection;

namespace FileContextCore.Infrastructure.Internal
{
    /// <summary>
    ///     <para>
    ///         This is an internal API that supports the Entity Framework Core infrastructure and not subject to
    ///         the same compatibility standards as public APIs. It may be changed or removed without notice in
    ///         any release. You should only use it directly in your code with extreme caution and knowing that
    ///         doing so can result in application failures when updating to a new Entity Framework Core release.
    ///     </para>
    ///     <para>
    ///         The service lifetime is <see cref="ServiceLifetime.Singleton"/> and multiple registrations
    ///         are allowed. This means a single instance of each service is used by many <see cref="DbContext"/>
    ///         instances. The implementation must be thread-safe.
    ///         This service cannot depend on services registered as <see cref="ServiceLifetime.Scoped"/>.
    ///     </para>
    /// </summary>
    public class FileContextSingletonOptions : IFileContextSingletonOptions
    {
    
        public virtual void Initialize(IDbContextOptions options)
        {
            var inMemoryOptions = options.FindExtension<FileContextOptionsExtension>();

            if (inMemoryOptions != null)
            {
                DatabaseRoot = inMemoryOptions.DatabaseRoot;
            }
        }

    
        public virtual void Validate(IDbContextOptions options)
        {
            var inMemoryOptions = options.FindExtension<FileContextOptionsExtension>();

            if (inMemoryOptions != null
                && DatabaseRoot != inMemoryOptions.DatabaseRoot)
            {
                throw new InvalidOperationException(
                    CoreStrings.SingletonOptionChanged(
                        nameof(FileContextDbContextOptionsExtensions.UseFileContextDatabase),
                        nameof(DbContextOptionsBuilder.UseInternalServiceProvider)));
            }
        }

    
        public virtual FileContextDatabaseRoot DatabaseRoot { get; private set; }
    }
}
