# Monocle Entities
The entity type defines the type of GenAI component that Monocle understand. The monocle instrumentation can extract the relevenat information for this entity. There are a fixed set of [entity types](./entity_types.py) that are defined by Monocle out of the box, eg workflow, model etc. As the GenAI landscape evolves, the Monocle community will introduce a new entity type if the current entities won't represent a new technology component.

## Entities
Following attributes are supported for all entities
| Name | Description | Required |
| - | - | - |
| name | Entity name generated by Monocle | Required |
| type | entity.category.type | True |

### MonocleEntity.Workflow
Workflow ie the core application code. 
#### Workflow types
- generic
- langchain
- llamaindex
- haystack

### MonocleEntity.Model
GenAI models. It has following sub categories
- generic
- llm
- embedding
#### Model types
- gpt3
- gpt-3.5
- gpt-3.5-turbo
- gpt4
- gpt4o
- gpt4o-mini
- ollama

Following attributes are supported for all model type entities
| Name | Description | Required |
| - | - | - |
| parameters | model parameters | false |
| algorithm | model algorithm | false |

### MonocleEntity.AppHosting
Application host services where the workflow code is run.
#### AppHosting types
- generic
- aws_lambda
- aws_sagemaker
- azure_func
- github_codespace
- azure_mlw

### MonocleEntity.Inference
The model hosting infrastructure services.
Following attributes are supported for inference type entities
| Name | Description | Required |
| - | - | - |
| inference_endpoint | connection endpoint for inference service | false |
#### Inference types
- generic
- nvidia_triton
- openai
- azure_oai
- aws_sagemaker
- aws_bedrock
- hugging_face

Following attributes are supported for inference type entities
| Name | Description | Inference type | Required |
| - | - | - | - |
| deployment | model deployment name | azure_oai | false |


### MonocleEntity.VectorStore
Vector search data stores.
#### VectorStore types
- generic
- chroma
- aws_es
- milvus
- pinecone
