# Contributing to Monocle
Contributions to Monocle are welcome from everyone. The following are a set of guidelines for contributing to Monocle. Following these guidelines makes contributing to this project easy and transparent. These are mostly guidelines, not rules. Use your best judgment, and feel free to propose changes to this document in a pull request. Please refer to our code of conduct when making contributions. 

## How can you contribute?
### Contributing code
If you encounter a bug, you can
- (Recommended) File an issue about the bug.
- Provide clear and concrete ways/scripts to reproduce the bug.
- Provide possible solutions for the bug.
- Pull a request to fix the bug.

If you're interested in existing issues, you can
- (Recommended) Provide answers for issue labeled question.
- Provide help for issues labeled bug, improvement, and enhancement by
-- (Recommended) Ask questions, reproduce the issue, or provide solutions.
-- Pull a request to fix the issue.

If you require a new feature or major enhancement, you can
- (Recommended) File an issue about the feature/enhancement with reasons.
- Pull a request to implement the feature.

If you are a reviewer/approver of Monocle, you can
- Participate in PR review process.
- Instruct newcomers in the community to complete the PR process.

If you want to become a contributor of Monocle, submit your pull requests. All contributions to this project must be accompanied by acknowledgment of, and agreement to, the [Developer Certificate of Origin](https://github.com/apps/dco). All submissions will be reviewed as quickly as possible.

 
