# Under The Hood Of Executables 🔍

[![License: MIT](https://img.shields.io/badge/License-MIT-yellow.svg)](https://opensource.org/licenses/MIT)
[![PRs Welcome](https://img.shields.io/badge/PRs-welcome-brightgreen.svg)](CONTRIBUTING.md)
[![Made with Love](https://img.shields.io/badge/Made%20with-❤-red.svg)](https://github.com/mohitmishra786/underTheHoodOfExecutables)

An in-depth exploration of how C programs transform from source code to executable binaries. This repository contains a comprehensive guide to understanding linking, loading, and executable formats.

## 📚 Book Website

Visit this book website: [Under The Hood Of Executables](https://mohitmishra786.github.io/underTheHoodOfExecutables/)

## 🌟 Features

- Detailed explanations of ELF format
- Deep dive into linking and loading processes
- Practical examples and case studies
- Interactive diagrams and illustrations
- Step-by-step tutorials
- Real-world applications
- Performance optimization insights

## 📖 Content Structure

The book is organized into five parts, each focusing on different aspects of the compilation and linking process. [View detailed content structure](INDEX.md)

## 🚀 Getting Started

1. Clone the repository:
   ```bash
   git clone https://github.com/mohitmishra786/underTheHoodOfExecutables.git
   ```

2. Navigate to the chapter you're interested in:
   ```bash
   cd underTheHoodOfExecutables
   ```

3. Read the chapters in markdown format or visit our [website](https://mohitmishra786.github.io/underTheHoodOfExecutables/) for an enhanced reading experience.

## Star History

<a href="https://star-history.com/#mohitmishra786/underTheHoodOfExecutables&Date">
 <picture>
   <source media="(prefers-color-scheme: dark)" srcset="https://api.star-history.com/svg?repos=mohitmishra786/underTheHoodOfExecutables&type=Date&theme=dark" />
   <source media="(prefers-color-scheme: light)" srcset="https://api.star-history.com/svg?repos=mohitmishra786/underTheHoodOfExecutables&type=Date" />
   <img alt="Star History Chart" src="https://api.star-history.com/svg?repos=mohitmishra786/underTheHoodOfExecutables&type=Date" />
 </picture>
</a>

## 🤝 Contributing

Contributions are welcome! Please read our [Contributing Guidelines](CONTRIBUTING.md) and [Code of Conduct](CODE_OF_CONDUCT.md) before getting started.

## 📄 License

This project is licensed under the MIT License - see the [LICENSE](LICENSE) file for details.

## 🙏 Acknowledgments

- All contributors who have helped improve this guide
- The C programming community
- Open source tools and documentation that made this possible
