# From Source to Binary: A C Programmer's Guide to Linking and Loading

**Part 1: Building Blocks**

* [**Chapter 1: The Mystery of Executable Size**](https://github.com/mohitmishra786/underTheHoodOfExecutables/tree/main/src/Ch-1-The-Mystery-Of-Executable-Size)
  * [Why is my "Hello World" so Big?](https://github.com/mohitmishra786/underTheHoodOfExecutables/blob/main/src/Ch-1-The-Mystery-Of-Executable-Size/Why-is-my-Hello-World-so-Big.md)

* [**Chapter 2: ELF: Unpacking the Executable and Link Format**](https://github.com/mohitmishra786/underTheHoodOfExecutables/tree/main/src/Ch-2-The-Executable-And-Linkable-Format)
  * [Demystifying the Executable Format](https://github.com/mohitmishra786/underTheHoodOfExecutables/blob/main/src/Ch-2-The-Executable-And-Linkable-Format/Demystifying-the-Executable-Format.md)

* [**Chapter 3: Sections: Organizing Code and Data**](https://github.com/mohitmishra786/underTheHoodOfExecutables/tree/main/src/Ch-3-Sections-Organizing-Code-And-Data)
  * [Understanding ELF Sections](https://github.com/mohitmishra786/underTheHoodOfExecutables/blob/main/src/Ch-3-Sections-Organizing-Code-And-Data/Understanding-ELF-Sections.md)

* [**Chapter 4: Global Variables and Initialization**](https://github.com/mohitmishra786/underTheHoodOfExecutables/tree/main/src/Ch-4-Global-Variables-And-Initialization)
  * [The Secret Life of Global Variables in C](https://github.com/mohitmishra786/underTheHoodOfExecutables/blob/main/src/Ch-4-Global-Variables-And-Initialization/The-Secret-Life-of-Global-Variables-in-C.md)

**Part 2: The Linker's Dance**

* [**Chapter 5: The Linker's Role: Piecing Together the Puzzle**](https://github.com/mohitmishra786/underTheHoodOfExecutables/tree/main/src/Ch-5-The-Linker's-Role)
  * [Bringing The C Code Together](https://github.com/mohitmishra786/underTheHoodOfExecutables/blob/main/src/Ch-5-The-Linker's-Role/Bringing-The-C-Code-Together.md)

* [**Chapter 6: Relocations: Patching the Code**](https://github.com/mohitmishra786/underTheHoodOfExecutables/tree/main/src/Ch-6-Relocations-Patching-The-Code)
  * [The Linker's Patchwork](https://github.com/mohitmishra786/underTheHoodOfExecutables/blob/main/src/Ch-6-Relocations-Patching-The-Code/The%20Linker's%20Patchwork.md)

* [**Chapter 7: Symbols: Identifying and Resolving References**](https://github.com/mohitmishra786/underTheHoodOfExecutables/tree/main/src/Ch-7-Symbols)
  * [Symbols](https://github.com/mohitmishra786/underTheHoodOfExecutables/blob/main/src/Ch-7-Symbols/Symbols.md)

* [**Chapter 8: Linker Scripts: Controlling the Layout**](https://github.com/mohitmishra786/underTheHoodOfExecutables/tree/main/src/Ch-8-Customizing-The-Layout)
  * [Introduction To Linker Scripts](https://github.com/mohitmishra786/underTheHoodOfExecutables/blob/main/src/Ch-8-Customizing-The-Layout/Introduction-To-Linker-Scripts.md)

**Part 3: Dynamic Linking: Sharing and Flexibility**

* [**Chapter 9: Dynamic Linking: Sharing Code and Resources**](https://github.com/mohitmishra786/underTheHoodOfExecutables/tree/main/src/Ch-9-Dynamic-Linking)
  * [Shrinking Executables and Sharing Code](https://github.com/mohitmishra786/underTheHoodOfExecutables/blob/main/src/Ch-9-Dynamic-Linking/Shrinking%20Executables%20and%20Sharing%20Code.md)

* [**Chapter 10: The Dynamic Linking Process**](https://github.com/mohitmishra786/underTheHoodOfExecutables/tree/main/src/Ch-10-Dynamic-Linking-Process)
  * [Lazy Loading: Dynamic Linking on Demand](https://github.com/mohitmishra786/underTheHoodOfExecutables/blob/main/src/Ch-10-Dynamic-Linking-Process/Lazy%20Loading:%20Dynamic%20Linking%20on%20Demand.md)

* [**Chapter 11: Controlling Dynamic Linking Behavior**](https://github.com/mohitmishra786/underTheHoodOfExecutables/tree/main/src/Ch-11-Controlling-Dynamic-Linking-Behavior)
  * [Taking Control: Environment Variables For Dynamic Linking](https://github.com/mohitmishra786/underTheHoodOfExecutables/blob/main/src/Ch-11-Controlling-Dynamic-Linking-Behavior/Taking-Control-Environment-Variables-For-Dynamic-Linking.md)

* [**Chapter 12: Linux Executable Loading**](https://github.com/mohitmishra786/underTheHoodOfExecutables/tree/main/src/Ch-12-Linux-Executable-Loading)
  * [Linux Executable Loading](https://github.com/mohitmishra786/underTheHoodOfExecutables/blob/main/src/Ch-12-Linux-Executable-Loading/Linux-Executable-Loading.md)

**Part 4: Advanced Linking and Optimization**

* [**Chapter 13: Weak Symbols and Link-Time Optimization**](https://github.com/mohitmishra786/underTheHoodOfExecutables/tree/main/src/Ch-13-Weak-Symbols)
  * [Weak Symbols: A Linker's Flexibility](https://github.com/mohitmishra786/underTheHoodOfExecutables/blob/main/src/Ch-13-Weak-Symbols/Weak%20Symbols:%20A%20Linker's%20Flexibility.md)

**Part 5: Looking Ahead**

* [**Chapter 14: Conclusion: A Deeper Understanding**](https://github.com/mohitmishra786/underTheHoodOfExecutables/tree/main/src/Ch-14-Final-Chapter)
  * [Level Up Your C](https://github.com/mohitmishra786/underTheHoodOfExecutables/blob/main/src/Ch-14-Final-Chapter/Level-Up-Your-C.md)