# Contributing to Under The Hood Of Executables

We love your input! We want to make contributing to this guide as easy and transparent as possible, whether it's:

- Reporting a typo
- Discussing the current state of the content
- Submitting a fix
- Proposing new sections
- Becoming a maintainer

## We Develop with Github
We use GitHub to host code, to track issues and feature requests, as well as accept pull requests.

## Pull Requests
1. Fork the repo and create your branch from `main`.
2. If you've added content, make sure it follows our style guide.
3. If you've changed APIs or functionality, update the documentation.
4. Make sure your code follows our formatting guidelines.
5. Issue that pull request!

## Any contributions you make will be under the MIT Software License
When you submit code changes, your submissions are understood to be under the same [MIT License](LICENSE) that covers the project.

## Report issues using Github's [issue tracker](https://github.com/mohitmishra786/underTheHoodOfExecutables/issues)
We use GitHub issues to track public bugs and requests.

## Write bug reports with detail, background, and sample code

**Great Bug Reports** tend to have:

- A quick summary and/or background
- Steps to reproduce
  - Be specific!
  - Give sample code if you can.
- What you expected would happen
- What actually happens
- Notes (possibly including why you think this might be happening)

## License
By contributing, you agree that your contributions will be licensed under its MIT License.

## References
This document was adapted from the open-source contribution guidelines for [Facebook's Draft](https://github.com/facebook/draft-js/blob/a9316a723f9e918afde44dea68b5f9f39b7d9b00/CONTRIBUTING.md).