# 预训练及微调

由于预训练和微调比较相似，在本文中共同介绍。

预训练和微调的数据格式需求请参考[自定义数据集](../Customization/自定义数据集.md)部分。

从数据需求上，继续预训练的训练需求量可能在几十万行~几百万行不等，如果从头预训练需要的卡数和数据量非常庞大，不在本文的讨论范围内。
微调的数据需求从几千行~百万行不等，更低的数据量请考虑使用RAG方式。

## 预训练

预训练的example请参考[这里](https://github.com/modelscope/swift/blob/main/examples/train/pt/train.sh)。

如果使用多机多卡预训练，请参考[这里](https://github.com/modelscope/swift/blob/main/examples/train/multi-node)。

Megatron的example还没有正式支持，预计本迭代内会支持好。

## 微调

微调支持很多轻量训练方式（注意这些方式预训练也可以使用，但实际上建议预训练使用全参数训练+DeepSpeed）

样例可以参考[这里](https://github.com/modelscope/swift/blob/main/examples/train/tuners)。

此外SWIFT支持的其他技术和样例有：

- ddp+device_map：这种比较适合单卡跑不下，deepspeed不支持的情况，参考[这里](https://github.com/modelscope/ms-swift/blob/main/examples/train/multi-gpu/ddp_device_map/train.sh)
- fsdp+qlora： 可以在双卡3090运行70B模型的训练，参考[这里](https://github.com/modelscope/ms-swift/tree/main/examples/train/multi-gpu/fsdp_qlora/train.sh)
- 多模态训练：参考[这里](https://github.com/modelscope/swift/blob/main/examples/train/multimodal)
- 序列并行：参考[这里](https://github.com/modelscope/swift/blob/main/examples/train/sequence_parallel)
- packing：将多个sequence拼成一个，可以让每个样例训练时尽量接近设置的max_length，提高显卡利用率，参考[这里](https://github.com/modelscope/swift/blob/main/examples/train/packing/train.sh)
- 流式训练：不断读入数据，在数据量比较大的情况下减少内存使用。参考[这里](https://github.com/modelscope/swift/blob/main/examples/train/streaming/train.sh)
- lazy tokenize：适合一次读入固定数据，训练时解析图片的场景。参考[这里](https://github.com/modelscope/swift/blob/main/examples/train/lazy_tokenize/train.sh)
- agent训练：参考[这里](https://github.com/modelscope/swift/blob/main/examples/train/agent)
- all-to-all模型训练：参考[这里](https://github.com/modelscope/swift/blob/main/examples/train/all_to_all)


**提示**:

- 我们默认在训练时设置`--gradient_checkpointing true`来**节约显存**，这会略微降低训练速度.
- 如果你想要使用deepspeed，你需要`pip install deepspeed==0.14.*`. 使用deepspeed可以**节约显存**，但可能会略微降低训练速度.
- 如果你的机器是A100等高性能显卡，且模型支持flash-attn，推荐你安装[**flash-attn**](https://github.com/Dao-AILab/flash-attention)，这将会加快训练和推理的速度以及显存占用
- 如果你需要**断网**进行训练，请使用`--model <model_dir>`和设置`--check_model false`. 具体参数含义请查看[命令行参数](命令行参数.md).
- 如果你想在训练时，将权重push到ModelScope Hub中，你需要设置`--push_to_hub true`
- 如果你想要在推理时，合并LoRA权重并保存，你需要设置`--merge_lora true`. **现无法对qlora训练的模型进行merge**，因此**不建议使用qlora进行微调**，部署生态不好
