
# 推送模型

使用SWIFT时，用户可以选择将训练好的模型推送到社区上。

```shell
swift sft/export/pt/rlhf \
    --use_hf 0/1 \
    ...
```

上述参数可以控制推送模型的社区（该参数对下载同样有影响），为0时推送魔搭，为1时推送Hugging Face，默认值为0. 同样可以使用环境变量来控制：
```shell
USE_HF=0/1 \
swift sft/export/pt/rlhf \
    ...
```

## 推送魔搭
要使用推送模型能力，首先要确认你已经注册了魔搭官方账号，并且在[页面](https://www.modelscope.cn/my/myaccesstoken)上取得了对应的sdk token。

### 训练时推送模型

在训练时推送模型，需要在命令行上添加以下参数：
```shell
--push_to_hub true \
--hub_model_id my-group/my-model \
--hub_token <token-from-modelscope-page>
```

上述参数添加好后，训练后的checkpoint和训练参数就会被推送到魔搭社区上，方便以后使用。值得注意的是，魔搭社区允许您上传私有模型，需要模型是私有时，添加以下参数:

```shell
--hub_private_repo true
```

这样该模型就只有有该组织权限的人才能看到。

### 导出时推送模型

导出时推送模型的参数和训练时的参数是相同的：
```shell
# 如果是全参数训练，则是--model
CUDA_VISIBLE_DEVICES=0 swift export \
    --adapters output/vx-xxx/checkpoint-xxx \
    --push_to_hub true \
    --hub_model_id '<your-model-id>' \
    --hub_token '<your-sdk-token>'
```

这样可以将LoRA合并或量化后的模型直接推送到魔搭上。

## 推送Hugging Face

Hugging Face的token可以通过[页面](https://huggingface.co/settings/tokens)进行注册，注册完成后，在本地执行：
```shell
huggingface-cli login
# 在弹出的input中输入token
```

本地登录完成后，命令行中仅需要指定：
```shell
--push_to_hub true \
--hub_model_id my-group/my-model
```
即可推送模型。
