# 推理和部署

SWIFT支持以命令行、Python代码和界面方式进行推理和部署：
- 使用`engine.infer`或者`engine.infer_async`进行python的方式推理. 参考[这里](https://github.com/modelscope/ms-swift/blob/main/examples/infer/demo.py).
- 使用`swift infer`使用命令行的方式进行推理. 参考[这里](https://github.com/modelscope/ms-swift/blob/main/examples/infer/cli_demo.sh).
- 使用`swift deploy`进行服务部署，并使用openai API或者`client.infer`的方式推理. 服务端参考[这里](https://github.com/modelscope/ms-swift/tree/main/examples/deploy/server), 客户端参考[这里](https://github.com/modelscope/ms-swift/tree/main/examples/deploy/client).
- 使用`swift app`部署模型进行界面推理, 可以查看[这里](../GetStarted/界面使用.md)


## 命令行推理指令

命令行推理可以参考上述第二点给出的链接。脚本运行后仅需在terminal中输入query即可。注意命令行的几个使用方式：
- `reset-system`命令 重置system
- `multi-line`命令 切换到多行模式，在输入中支持换行输入，以`#`代表输入结束
- `single-line`命令 切换到单行模式
- `clear`命令 清除history
- `exit`命令 退出
- 如果query中带有多模态数据，添加<image>/<video>/<audio>等标签，例如输入`<image>What is in the image?`，即可在接下来输入图片地址

## 推理加速后端

可以使用`swift infer/deploy`执行推理和部署。目前SWIFT支持pt（原生torch）、vLLM、LMDeploy三种推理框架，分别可以用`--infer_backend pt/vllm/lmdeploy`进行切换。
除pt外，vllm和lmdeploy分别有自己的模型支持范围，请查看各自官方文档来确定是否可用，以防出现运行错误。
