# 常见问题整理

下面是swift使用过程中遇到的一些常见问题。

## 训练

### Q1: Swift微调支持的模型和数据集有哪些？
详见文档[支持的模型和数据集](https://swift.readthedocs.io/zh-cn/latest/Instruction/%E6%94%AF%E6%8C%81%E7%9A%84%E6%A8%A1%E5%9E%8B%E5%92%8C%E6%95%B0%E6%8D%AE%E9%9B%86.html)。

### Q2: 使用自定义数据集训练时支持的数据格式有哪些？
自定义数据集格式见文档[自定义数据集](https://swift.readthedocs.io/zh-cn/latest/Customization/%E8%87%AA%E5%AE%9A%E4%B9%89%E6%95%B0%E6%8D%AE%E9%9B%86.html)。

### Q3: 自定义数据集dataset_info.json格式，如何通过这种方式使用自定义数据集？
dataset_info.json格式见文档[自定义数据集](https://swift.readthedocs.io/zh-cn/latest/Customization/%E8%87%AA%E5%AE%9A%E4%B9%89%E6%95%B0%E6%8D%AE%E9%9B%86.html)。命令行，`--custom_dataset_info xxx.json`，`--dataset <dataset_id_or_path>`。

### Q4: 如何在界面训练使用自定义数据集？
界面训练使用自定义数据集与命令行一致，参考文档[自定义数据集](https://swift.readthedocs.io/zh-cn/latest/Customization/%E8%87%AA%E5%AE%9A%E4%B9%89%E6%95%B0%E6%8D%AE%E9%9B%86.html)。

### Q5: 数据集jsonl文件里的一行能不能写成这样？{"index": "00000", "query": "11111", "response": "22222", 'source':'qqq'}
可以有额外字段的，这些字段不会被使用。

### Q6: 命令行参数在哪个文档中查看？
详见文档[命令行参数](https://swift.readthedocs.io/zh-cn/latest/Instruction/%E5%91%BD%E4%BB%A4%E8%A1%8C%E5%8F%82%E6%95%B0.html)。

### Q7: 离线环境训练需要配置的参数有哪些？
`--model 本地路径`，`--check_model false`，详见[命令行参数](https://swift.readthedocs.io/zh-cn/latest/Instruction/%E5%91%BD%E4%BB%A4%E8%A1%8C%E5%8F%82%E6%95%B0.html)。

### Q8: model_type在哪儿查看？
查看文档[支持的模型和数据集](https://swift.readthedocs.io/zh-cn/latest/Instruction/%E6%94%AF%E6%8C%81%E7%9A%84%E6%A8%A1%E5%9E%8B%E5%92%8C%E6%95%B0%E6%8D%AE%E9%9B%86.html)。

### Q9: 模型训练完能直接转gguf格式吗？
目前只支持导出ModelFile，详见文档[命令行参数](https://swift.readthedocs.io/zh-cn/latest/Instruction/%E5%91%BD%E4%BB%A4%E8%A1%8C%E5%8F%82%E6%95%B0.html)。

### Q10: swift支持预训练吗，我看只有sft？
支持，命令行`swift pt`，[预训练例子](https://github.com/modelscope/ms-swift/tree/main/examples/train/pt)，数据集格式见[自定义数据集](https://swift.readthedocs.io/zh-cn/latest/Customization/%E8%87%AA%E5%AE%9A%E4%B9%89%E6%95%B0%E6%8D%AE%E9%9B%86.html)。

### Q11: 想问一下用lora微调的模型，如果想断点续训的话，是应该先把它合成一整个模型吗，还是可以不合起来，直接通过路径来指定原模型和lora块
不合并，`--resume_from_checkpoint output/xxx/vx-xxx/checkpoint-xxx`，详见[命令行参数](https://swift.readthedocs.io/zh-cn/latest/Instruction/%E5%91%BD%E4%BB%A4%E8%A1%8C%E5%8F%82%E6%95%B0.html)。

### Q12: 我想控制一下从网上下载下来的原始模型权重的位置，怎么才能做到把原始的模型放在指定的文件夹里呢？
可以配置环境变量`MODELSCOPE_CACHE=your_path`将原始的模型存到指定路径；如果用sdk下载，通过`cache_dir="本地地址"`；也可以使用`modelscope download`命令行工具或`git`下载，详见modelscope文档[模型下载](https://modelscope.cn/docs/models/download)。训练时`--model`配置本地路径即可。如果需要在离线环境训练，配置`--check_model false`，详见[命令行参数](https://swift.readthedocs.io/zh-cn/latest/Instruction/%E5%91%BD%E4%BB%A4%E8%A1%8C%E5%8F%82%E6%95%B0.html)。

### Q13: 有人在用ms-swift遇到过这个问题？
```text
[rank6]: pydantic_core._pydantic_core.ValidationError: 1 validation error for DeepSpeedZeroConfig
[rank6]: stage3_prefetch_bucket_size
[rank6]: Input should be a valid integer, got a number with a fractional part [type=int_from_float,input_value=11560550.4，in put_type=float]
[rank6]: For further information visit https://errors.pydantic.dev/2.8/v/int_fro_float
```
`deepspeed`版本降到`0.14.*`。

### Q14: 有微调qwen-2-vl的完整的教程和命令行吗？
[Qwen2-VL 最佳实践](https://swift2x.readthedocs.io/zh-cn/latest/Multi-Modal/qwen2-vl%E6%9C%80%E4%BD%B3%E5%AE%9E%E8%B7%B5.html)。

### Q15: 多模态大模型微调有什么支持的trick吗，类似llm的neftune?
`piassa/olora/dora`这些`lora`的变种或者`fourierft`都可以尝试。参考`sft`参数里面的各种trick，有一些不一定在多模态上适用。

### Q16: 训练过程中eval得到的acc和对应保存的ckpt去重新推理一遍计算得到的acc不是一致的
训练时候的eval_acc和推理时候的acc 计算方式不一样的。`acc_strategy`: 默认为`'token'`, 可选择的值包括: `'token'`, `'sentence'`.

### Q17: 魔搭官方镜像与swift环境
`docker run`命令启动容器即可，如：`docker run --gpus all -p 8000:8000 -it -d --name ms registry.cn-beijing.aliyuncs.com/modelscope-repo/modelscope:ubuntu22.04-cuda12.1.0-py310-torch2.3.0-tf2.16.1-1.16.0 /bin/bash`，启动容器后拉最新代码安装swift。

### Q18: 多机多卡训练命令行
详见[多机多卡例子](https://github.com/modelscope/ms-swift/tree/main/examples/train/multi-node)

### Q19: 如何选择template?
见[issue](https://github.com/modelscope/ms-swift/issues/1813)。

### Q20: 多卡训练torchrun和swift sft如何使用？
`swift sft`走的就是`torchrun`。

### Q21: 有个问题，因为我的sft数据集太大了，然后每次tokenize都需要很久，有解决方案吗？
使用`lazy_tokenize`，详见[命令行参数](https://swift.readthedocs.io/zh-cn/latest/Instruction/%E5%91%BD%E4%BB%A4%E8%A1%8C%E5%8F%82%E6%95%B0.html)。

### Q22: 训练时，如果两个数据集直接追加一起放在训练集中，模型在训练的时候内部会有shuffle的流程吗？还是按顺序取数据去训练？
trainer中会随机。

### Q23: 如果模型两张卡，数据不开并行，deepspeed就会出现报错，怎么处理呢？
`deepspeed` 和 `device_map`是不兼容的，两个只能选1个。

### Q24: 在线训练时已经下载的数据集，离线重新训练为什么还要下载？
数据文件中有url，不支持离线训练。

### Q25: vlm模型训练如何减少显存使用？
配置`--freeze_vit true`。

### Q26: 为什么WEB-UI界面上支持的模型比文档中少？
升级一下ms-swift。

### Q27: 没有适配model_type的模型，sft时可以自定义special_tokens和chat_template吗？
可以。参考接入模型的PR以及自定义模型数据集文档。

### Q28: 可以在python脚本里面用DPO去训练qwen2-vl吗？
可以。从`swift.llm`中导入`rlhf_main` 和`RLHFArguments`。

### Q29: 请问训练MLLM时，可否先进行纯文本的预训练，然后接入VQA数据集进行微调呢？
可以。也可以混着训练。

### Q30: 基于qwen2的sft模型进行dpo训练，v100的机器，训练时都是Nan呢？
V100机器要用fp32训练qwen2。

### Q31: 想问一下，swift，能支持蒸馏吗？
不支持。建议量化，效果比较好。

### Q32: cannot import name 'ftp_head' from 'datasets.utils.file_utils' ，有没有遇到这个问题的?
`pip install datasets==2.*`。

### Q33: 当前训练完默认最多保存两个checkpoint，如果想多保存几个应该怎么修改呢？
`--save_total_limit`，详见[命令行参数](https://swift.readthedocs.io/zh-cn/latest/Instruction/%E5%91%BD%E4%BB%A4%E8%A1%8C%E5%8F%82%E6%95%B0.html)。

### Q34: Grounding任务中通用数据格式支持一个类别有多个实例吗？
目前均支持了一个物体对应多个bbox，参考文档[自定义数据集](https://swift.readthedocs.io/zh-cn/latest/Customization/%E8%87%AA%E5%AE%9A%E4%B9%89%E6%95%B0%E6%8D%AE%E9%9B%86.html)。

### Q35: 这个错误为什么会出现在这，numpy.object找不到在哪？
`numpy==1.26.3`，尝试一下。

### Q36: swift框架能支持序列并行了吗？
支持。现在是引入`xtuner`来实现。

### Q37: 用v100微调qwen2-1.5B时，loss': 0.0, 'acc': 0.0, 'grad_norm': nan，是什么问题呢?
尝试用fp32。

### Q38: gptq量化模型，能全参数微调吗？
不能。gptq模型的int型参数无法参与求导，只能附着lora等额外结构参与更新。

### Q39: 请问如果想用qlora的方式微调的话应该如何设置参数呢?glm4-chat
参考qlora[例子](https://github.com/modelscope/ms-swift/tree/main/examples/train/fsdp_qlora)。

### Q40: 用qwen2-vl-7b训练自己的数据集，总是出现"AdamW' object has no attribute 'train这个问题。
`accelerate 0.34.0`试试。

### Q41: 请教一个问题，我应该如何在swift框架下扩充我的词表呢？
swift目前还不支持词表扩充。

### Q42: 同名的模型是可以直接使用huggingface上的吗？
设置环境变量`USE_HF=1`。

### Q43: 请问Qwen2-VL-2B能进行增量预训练吗？有指导文件吗?有图文,也有纯文本的。
支持了，如果继续预训练将所有的内容放在response中就可以了。

### Q44: 请问下用视频做训练的时候，如何在参数中控制抽帧率，设了frame_rate设不起, minicpmv
设置环境变量`MAX_NUM_FRAMES`。

### Q45: swift在训练的时候，可以把验证集的推理结果保存下来吗？
训练结束后，运行swift infer，会保存。

### Q46: 我全量full参数dpo，为何保存的checkpoint 比原本模型文件要大呢?整整大了1倍
用V100微调，存的是fp32类型。

### Q47: 多机训练速度缓慢，在使用swift框架进行LLM训练时，发现采用deepspeed zero3训练会出现严重的速度下降问题
详见[issue](https://github.com/modelscope/ms-swift/issues/1825)。

### Q48: swift现在是支持qwen2-vl多阶段预训练的吗？我看官方的最佳实践里的sft好像都是vit+llm一起训的，不知道支不支持单独finetune
详见[issue](https://github.com/modelscope/ms-swift/issues/2222)。

### Q49: qwen2-vl是不是不支持混合纯文本数据?
支持图文和纯文本。

### Q50: 微调的时候可以绘制不同数据集的loss曲线吗？
不支持的，数据集是混合训练的。

### Q51: 模型训练后，回复重复了很多内容
参考[预训练及微调](https://swift.readthedocs.io/zh-cn/latest/Instruction/%E9%A2%84%E8%AE%AD%E7%BB%83%E5%8F%8A%E5%BE%AE%E8%B0%83.html)。如果训练过程中出现重复的情况，请多训练几个epoch, 清洗数据, 全参数训练, 采用RLHF的方式缓解。

### Q52: 想问一下swift目前支持prompt tuning或者prefix tuning吗？
不支持，这两个方法知识遗忘比较严重，目前不推荐使用。

### Q53: 两张A10训练报错如下：
```text
[rank0]: torch.distributed.DistBackendError: NCCL error in:../torch/csrc/distributed/c10d/ProcessGroupNCCL.cpp:1970， unhandled system error (run with NCCL_DEBUG=INFO for details),NCCL version 2.20.5
[rank0]:ncclSystemError: System call (e.g. socket,malloc) or external library call failed or device error.
```
请检查共享内存是否太小，nccl需要共享内存。

### Q54: 请问在采用DDP微调训练的过程中，冻结某些层时导致的某些参数未参与梯度回传问题怎么解决？
配置参数`--ddp_find_unused_parameters true`。

### Q55: swift有没有数据集质检工具？
[data-juicer](https://github.com/modelscope/data-juicer)。

### Q55: web端在哪启动模型并行?只找到了数据并行的勾选项，没找到模型并行在哪。
指定可见显卡就可以。

### Q56: 如何不自动shuffle呢?想把它关掉。
目前只能改transformers[代码](https://github.com/huggingface/transformers/blob/main/src/transformers/trainer.py)。

### Q57: 'num_items_in_batch'是个什么参数？没找到在哪。
升级`ms-swift==2.5.2`或者降低`transformers<4.46`。

## 推理

### Q1:swift推理有文档吗？
swift支持python脚本、命令行、ui界面推理，详见[推理和部署](https://swift.readthedocs.io/zh-cn/latest/Instruction/%E6%8E%A8%E7%90%86%E5%92%8C%E9%83%A8%E7%BD%B2.html)。

### Q2: 训练后的模型如何使用数据集推理？
参数`--load_dataset_config true`或`--val_dataset <your-val-dataset>`，见文档[命令行参数](https://swift.readthedocs.io/zh-cn/latest/Instruction/%E5%91%BD%E4%BB%A4%E8%A1%8C%E5%8F%82%E6%95%B0.html)。

### Q3: swift推理的时候可以指定下载好的模型吗？
`--model`配置本地路径即可，详见[命令行参数](https://swift.readthedocs.io/zh-cn/latest/Instruction/%E5%91%BD%E4%BB%A4%E8%A1%8C%E5%8F%82%E6%95%B0.html)。

### Q4: 我想在一个没有label的数据集上推理，怎么做呢？我看文档里面的数据集格式都是训练集
配置参数`--val_dataset <your-val-dataset>`。

### Q5: 遇到报错ValueError: Input length of input_ids is 35, but `max_length` is set to 20.如何解决？
```text
raise ValueError(
ValueError: Input length of input_ids is 35, but `max_length` is set to 20. This can lead to unexpected behavior. You should consider increasing `max_length` or, better yet, setting `max_new_tokens`.
```
设置model.generation_config.max_new_tokens。

### Q6: qwen2-vl推理爆显存
设置环境变量，SIZE_FACTOR=8 MAX_PIXELS=602112，见文档[Qwen2-VL 最佳实践](https://swift2x.readthedocs.io/zh-cn/latest/Multi-Modal/qwen2-vl%E6%9C%80%E4%BD%B3%E5%AE%9E%E8%B7%B5.html)。

### Q7: v100显卡，在python虚拟环境中，参考https://swift2x.readthedocs.io/zh-cn/latest/Multi-Modal/qwen2-vl%E6%9C%80%E4%BD%B3%E5%AE%9E%E8%B7%B5.html 完成环境准备，在测试推理命令：CUDA_VISIBLE_DEVICES=0,1,2,3 swift infer --model_type qwen2-vl-7b-instruct 时报错：RuntimeError: probability tensor contains either `inf`, `nan` or element < 0
尝试用A10或者3090机器推理。

### Q8: 运行下面命令，预测之后的结果在哪里？CUDA_VISIBLE_DEVICES=0 swift infer --ckpt_dir output/glm4v-9b-chat/vx-xxx/checkpoint-xxx-merged --load_dataset_config true
日志中会打印路径。

### Q9: 推理的时候，调用inference，怎样能获取到输出logits呢？
参考[test_logprobs.py](https://github.com/modelscope/ms-swift/blob/main/tests/infer/test_logprobs.py)。

### Q10: 最新版本swift，我在加载qwen2-32b-instruct-awq 量化模型及其lora的时候，使用vllm 提示我加上merge lore ture,我加上就报错了，我去掉vllm 加速就能正常推理了，但是速度很慢
qlora训练的模型不支持merge-lora的, 建议lora微调后 merge-lora再量化。

### Q11: vllm会报错，assert factor in rope_scaling
`pip install git+https://github.com/huggingface/transformers@21fac7abba2a37fae86106f87fcf9974fd1e3830`，详见qwen2-vl[issue#96](https://github.com/QwenLM/Qwen2-VL/issues/96)。

### Q12: vllm作为推理后端的话，模型必须合并以后才能调用吗？
可以不合并，详见文档[命令行参数](https://swift.readthedocs.io/zh-cn/latest/Instruction/%E5%91%BD%E4%BB%A4%E8%A1%8C%E5%8F%82%E6%95%B0.html)。

### Q13: 推理返回prob只能用inference_client函数吗，单样本推理demo下的inference函数，能取出结果吗？
`generation_config.output_logits`修改一下。`model.generation_config.output_logits = True`
`model.generation_config.return_dict_in_generate = True`

### Q14: 有人遇到过这个问题吗?RuntimeError: "triu_tril_cuda_template" not implemented for'BFloat16'
升级torch,这个版本的torch没实现这个算子。

### Q15: qwen2-audio支持流式推理吗？
支持，详见[issue](https://github.com/modelscope/ms-swift/issues/1653)

### Q16: inference client推理多模态，do_sample在哪里设置？
设置temperature=0。

### Q17: ms-swift支持大模型批处理不？
支持的。详见[demo](https://github.com/modelscope/ms-swift/blob/main/examples/infer/demo.py)。

### Q18: ms-swift量化模型的时候，显示内存不足，可以在量化的时候少占用一些资源吗，慢一点没关系。
尝试设置`--device_map cpu`。

### Q19: swift支持对多模态模型量化吗？
支持。

### Q20: 使用GPTQ报错如下，请问是啥原因？
```text
if llm_config['architectures'][0] == 'LlamaForCausalLM':
KeyError: 'architectures'
```
尝试transformers==4.44.*版本。

### Q21: swift infer如何将评估的结果保存到指定文件呢 每次都不知道保存到哪里了
设置`--result_path your_path`，详见[InferArguments](https://github.com/modelscope/ms-swift/blob/main/swift/llm/argument/infer_args.py)。

### Q22: AWQ量化yi-vl-6b出错如下：
```text
TypeError: swift.llm.utils.model.get_model_tokenizer_with_flash_attn() got multiple values for keyword argument 'automodel_class'.
```
请使用gptq量化。

### Q23: 想问一下用swift export对qwen2.5 72B模型进行gptq int4量化，max model length=32768用的是默认值，给的校准数据集有128个样本，但是量化的时候报错了，报错日志是：factorization could not be completed because the input is not positive-definite(the leading minor of order 18145 is not pisitive-definite)。是什么原因？
海森矩阵不正定的问题，试试其他的数据集。

## 部署

### Q1: 如何部署训练后的模型？
`swift deploy --ckpt_dir xxx`，见文档[推理和部署](https://swift.readthedocs.io/zh-cn/latest/Instruction/%E6%8E%A8%E7%90%86%E5%92%8C%E9%83%A8%E7%BD%B2.html)。

### Q2: 如何使用vllm部署进行多卡部署？
详见[例子](https://github.com/modelscope/ms-swift/tree/main/examples/deploy)。

### Q3: 请问用vllm部署的时候，客户端怎么传入图片？
详见[客户端例子](https://github.com/modelscope/ms-swift/tree/main/examples/deploy/client/mllm)。

### Q4: 有个问题想问一下，qwen2-7b部署后使用客户端时，调用openai的api要使用client.completions.create，不能使用client.chat.completions.create，但是使用qwen2-7b-instruct-q5_k_m.gguf的时候可以使用client.chat.completions.create，这是为什么呀？
base模型可以用client.chat.completions.create的，不过这个是兼容行为。

### Q5: 使用两张卡用swift deploy启动服务端后，用Ctrl+C退出后，会一直有一个python进程，一直占用一张卡的显存，这是正常现象吗？
需要kill 一下, 这是vllm的问题。

### Q6: 在哪查看模型是否支持lmdeploy或vllm加速？
vllm和lmdeploy分别有自己的模型支持范围，请查看各自官方文档来确定是否可用。

### Q7: 通义千问2.5-数学-7B-Instruct，会偶尔这样一直返回乱码，是什么问题呢？用vllm部署，fp16。
尝试bf16。

### Q8: swift推理服务启动后，交互进行设置的温度之类的配置，如何设置呢？
推理只能启动前设置。部署可以在启动时设置默认，之后在客户端继续设置，覆盖默认。

### Q9: 在本地部署qwen2vl模型，推理后端使用vllm，本地视频怎么传入呢？可以使用 base64 传进去吗？curl调用如何加载视频呢？
base64，详见[mllm客户端例子](https://github.com/modelscope/ms-swift/tree/main/examples/deploy/client/mllm)

### Q10: qwen2-vl部署时报错如下，是vllm的版本不对么？
```text
Unrecognized keys in `rope_scaling`for 'rope_type'='default': {'mrope_section'} Unrecognized keys in `rope_scaling`for 'rope_type'='default': {'mrope_section'}
```
详见[issue](https://github.com/QwenLM/Qwen2-VL/issues/209)。

### Q11: swift推理可以输出预测概率吗？在部署的时候，怎么设置？
参考[test_logprobs.py](https://github.com/modelscope/ms-swift/blob/main/tests/infer/test_logprobs.py)。

## 评测

### Q1: swift支持的评测集有哪些？
纯文本评测：
```text
'obqa', 'cmb', 'AX_b', 'siqa', 'nq', 'mbpp', 'winogrande', 'mmlu', 'BoolQ', 'cluewsc', 'ocnli', 'lambada',
'CMRC', 'ceval', 'csl', 'cmnli', 'bbh', 'ReCoRD', 'math', 'humaneval', 'eprstmt', 'WSC', 'storycloze',
'MultiRC', 'RTE', 'chid', 'gsm8k', 'AX_g', 'bustm', 'afqmc', 'piqa', 'lcsts', 'strategyqa', 'Xsum', 'agieval',
'ocnli_fc', 'C3', 'tnews', 'race', 'triviaqa', 'CB', 'WiC', 'hellaswag', 'summedits', 'GaokaoBench',
'ARC_e', 'COPA', 'ARC_c', 'DRCD'
```

多模态评测：
```text
'COCO_VAL', 'MME', 'HallusionBench', 'POPE', 'MMBench_DEV_EN', 'MMBench_TEST_EN', 'MMBench_DEV_CN', 'MMBench_TEST_CN',
'MMBench', 'MMBench_CN', 'MMBench_DEV_EN_V11', 'MMBench_TEST_EN_V11', 'MMBench_DEV_CN_V11',
'MMBench_TEST_CN_V11', 'MMBench_V11', 'MMBench_CN_V11', 'SEEDBench_IMG', 'SEEDBench2',
'SEEDBench2_Plus', 'ScienceQA_VAL', 'ScienceQA_TEST', 'MMT-Bench_ALL_MI', 'MMT-Bench_ALL',
'MMT-Bench_VAL_MI', 'MMT-Bench_VAL', 'AesBench_VAL', 'AesBench_TEST', 'CCBench', 'AI2D_TEST', 'MMStar',
'RealWorldQA', 'MLLMGuard_DS', 'BLINK', 'OCRVQA_TEST', 'OCRVQA_TESTCORE', 'TextVQA_VAL', 'DocVQA_VAL',
'DocVQA_TEST', 'InfoVQA_VAL', 'InfoVQA_TEST', 'ChartQA_TEST', 'MathVision', 'MathVision_MINI',
'MMMU_DEV_VAL', 'MMMU_TEST', 'OCRBench', 'MathVista_MINI', 'LLaVABench', 'MMVet', 'MTVQA_TEST',
'MMLongBench_DOC', 'VCR_EN_EASY_500', 'VCR_EN_EASY_100', 'VCR_EN_EASY_ALL', 'VCR_EN_HARD_500',
'VCR_EN_HARD_100', 'VCR_EN_HARD_ALL', 'VCR_ZH_EASY_500', 'VCR_ZH_EASY_100', 'VCR_ZH_EASY_ALL',
'VCR_ZH_HARD_500', 'VCR_ZH_HARD_100', 'VCR_ZH_HARD_ALL', 'MMDU', 'MMBench-Video', 'Video-MME',
'MMBench_DEV_EN', 'MMBench_TEST_EN', 'MMBench_DEV_CN', 'MMBench_TEST_CN', 'MMBench', 'MMBench_CN',
'MMBench_DEV_EN_V11', 'MMBench_TEST_EN_V11', 'MMBench_DEV_CN_V11', 'MMBench_TEST_CN_V11', 'MMBench_V11',
'MMBench_CN_V11', 'SEEDBench_IMG', 'SEEDBench2', 'SEEDBench2_Plus', 'ScienceQA_VAL', 'ScienceQA_TEST',
'MMT-Bench_ALL_MI', 'MMT-Bench_ALL', 'MMT-Bench_VAL_MI', 'MMT-Bench_VAL', 'AesBench_VAL',
'AesBench_TEST', 'CCBench', 'AI2D_TEST', 'MMStar', 'RealWorldQA', 'MLLMGuard_DS', 'BLINK'
```

详见文档[评测](https://swift.readthedocs.io/zh-cn/latest/Instruction/%E8%AF%84%E6%B5%8B.html)。

### Q2: 如何使用自定义评测集？
纯文本、多模态自定义评测集必须和某个官方评测集数据格式（pattern）保持一致，见文档[评测](https://swift.readthedocs.io/zh-cn/latest/Instruction/%E8%AF%84%E6%B5%8B.html)。

### Q3: python3.11环境，评测时mmengine报错
尝试python3.10环境。或先安装全量依赖： `pip3 install evalscope[all]`，再打patch： `pip3 install https://modelscope-open.oss-cn-hangzhou.aliyuncs.com/package/evalscope-0.5.3.post1-py3-none-any.whl`。

### Q4: 官方支持的评测数据集手动下载后，swift eval能配置本地路径评测吗？
先下载评测数据集[eval.zip](https://modelscope.cn/datasets/swift/evalscope_resource/files)，解压后将里面的内容放到 `~/.cache/modelscope/media_resources/evalscope/data`文件夹下；再执行swift eval命令就可以使用本地数据。

### Q5: 自定义评测是不是有bug，把标准例子改成英文，一直都跑不通？
```shell
swift eval --model_type 'qwen2_5-1_5b-instruct' --eval_dataset no --custom_eval_config '/mnt/workspace/test_data/config_eval.json'
```
这是依赖了nltk的包，然后nltk的tokenizer需要下载一个punkt_tab的zip文件，国内有些环境下载不太稳定或者直接失败。已尝试改了代码做兜底，规避这个问题；参考[issue](https://github.com/nltk/nltk/issues/3293)。

### Q6: eval微调后的模型，总是会在固定的百分比停掉，但是vllm服务看着一直是有在正常运行的。模型越大，断开的越早。
`TIMEOUT`环境变量设置为-1。

### Q7: evalscope 支持多模型对比吗？
详见[文档](https://evalscope.readthedocs.io/zh-cn/latest/user_guides/arena.html)。

### Q8: 多模态数据集有没有自定义评估？
多模态自定义评估可以参考[文档](https://evalscope.readthedocs.io/zh-cn/latest/advanced_guides/custom_dataset/index.html)。

### Q9: ms-swift有方法测试qps，延迟，tokens/s吗？
可以尝试使用evalscope的[模型推理性能压测](https://evalscope.readthedocs.io/zh-cn/latest/user_guides/stress_test/index.html)。

### Q10: 评估的时候可不可以控制数据集条数？评估一个mmlu需要一个多小时，也太慢了。
配置参数`--eval_limit`，这里的`--eval_limit`是控制了每个subset的条数，比如mmlu有50多个subset，每个limit10条，那就是500多条。
