# 命令行参数

命令行参数的介绍会分为基本参数，原子参数、集成参数和特定模型参数。命令行最终使用的参数列表为集成参数。集成参数继承自基本参数和一些原子参数。特定模型参数是针对于具体模型的参数，可以通过`--model_kwargs'`或者环境变量进行设置。

## 基本参数

- 🔥tuner_backend: 可选为'peft', 'unsloth', 默认为'peft'
- 🔥train_type: 默认为'lora'. 可选为: 'lora', 'full', 'longlora', 'adalora', 'llamapro', 'adapter', 'vera', 'boft', 'fourierft', 'reft'
- 🔥adapters: 用于指定adapter的id/path的list，默认为`[]`.
- seed: 默认为42
- model_kwargs: 特定模型可传入的额外参数. 该参数列表会在训练推理时打印日志进行提示，例如`--model_kwargs '{"fps_max_frames": 12}'`
- load_args: 当指定`--resume_from_checkpoint`, `--model`, `--adapters`会读取保存文件中的`args.json`，将默认为None的`基本参数`（除去数据参数和生成参数）进行赋值（可通过手动传入进行覆盖）。默认为True
- load_data_args: 如果将该参数设置为True, 则会额外读取数据参数. 默认为False
- use_hf: 默认为False. 控制模型下载、数据集下载、模型push的hub
- hub_token: hub token. modelscope的hub token可以查看[这里](https://modelscope.cn/my/myaccesstoken)
- custom_register_path: 自定义模型、对话模板和数据集注册的`.py`文件路径

### 模型参数
- 🔥model: 模型id或模型本地路径。如果是自定义模型请配合`model_type`和`template`使用，具体可以参考[自定义模型](../Customization/自定义模型.md)
- model_type: 模型类型。相同的模型架构、template、模型加载过程被定义为一个model_type
- model_revision: 模型版本
- task_type: 默认为'causal_lm'. 可选为'causal_lm', 'seq_cls'. seq_cls的例子可以查看[这里](https://github.com/modelscope/ms-swift/tree/main/examples/train/seq_cls).
- 🔥torch_dtype: 模型权重的数据类型，支持`float16`,`bfloat16`,`float32`，默认从config文件中读取
- attn_impl: attention类型，支持`flash_attn`, `sdpa`, `eager`，默认使用sdpa
- num_labels: 分类模型需要指定。代表标签数量，默认为None
- rope_scaling: rope类型，支持`linear`和`dynamic`，请配合`max_length`共同使用
- device_map: 模型使用的device_map配置，例如：'auto'、'cpu'、json字符串、json文件路径
- local_repo_path: 部分模型在加载时依赖于github repo. 为了避免`git clone`时遇到网络问题, 可以直接使用本地repo. 该参数需要传入本地repo的路径, 默认为`None`

### 数据参数
- 🔥dataset: 数据集id或路径。传入格式为：`数据集id or 数据集路径:子数据集#取样数量`，其中子数据集和取样数据可选。空格分割传递多个数据集。本地数据集支持jsonl、csv、json、文件夹等。自定义数据集可以参考[自定义数据集](../Customization/自定义数据集.md)
- 🔥val_dataset: 验证集id或路径
- 🔥split_dataset_ratio: 不指定val_dataset时如何拆分训练集和验证集，默认为0.01
- data_seed: 数据集随机种子，默认为42
- 🔥dataset_num_proc: 数据集预处理的进程数，默认为1
- 🔥streaming: 流式读取并处理数据集，默认False
- enable_cache: 数据集预处理使用cache，默认False
  - 注意: 如果改为True，在数据集有更改时可能无法生效，如果修改本参数发现训练不正常请考虑设置为False
- download_mode: 数据集下载模式，包含`reuse_dataset_if_exists`和`force_redownload`，默认为reuse_dataset_if_exists
- strict: 如果为True，则数据集只要某行有问题直接抛错，否则会丢弃出错行。默认False
- 🔥model_name: 仅用于自我认知任务，传入模型中文名和英文名，以空格分隔
- 🔥model_author: 仅用于自我认知任务，传入模型作者的中文名和英文名，以空格分隔
- custom_dataset_info: 自定义简单数据集注册，参考[自定义数据集](../Customization/自定义数据集.md)

### 模板参数
- 🔥template: 对话模板类型，默认使用model对应的template类型。`swift pt`会将对话模版转为生成模板使用
- 🔥system: 自定义system字段，默认为None，使用template的默认system
- 🔥max_length: 单样本的tokens最大长度。默认为None，设置为模型支持的tokens最大长度(max_model_len)
- truncation_strategy: 如果超长如何处理，支持`delete`, `left`和`right`，代表删除、左侧裁剪和右侧裁剪，默认为'delete'
- 🔥max_pixels: 多模态模型图片前处理的最大像素数（H\*W），默认不缩放。
- tools_prompt: 智能体训练时的工具列表转为system的格式，请参考[智能体训练](./智能体的支持.md)，默认为'react_en'
- padding_side: 当训练`batch_size>=2`时的padding_side，可选值为'left', 'right'，默认为'right'。（`generate`的batch_size>=2时，只进行左padding）
- loss_scale: 如何针对训练添加token的loss权重。默认为`'default'`，代表所有response（含history）以1计算交叉熵损失。具体可以查看[插件化](../Customization/插件化.md)和[智能体训练](./智能体的支持.md)
- sequence_parallel_size: 序列并行数量。参考[example](https://github.com/modelscope/ms-swift/tree/main/examples/train/sequence_parallel/train.sh)
- use_chat_template: 使用chat模板或generation模板，默认为`True`。`swift pt`会自动设置为generation模板
- template_backend: 使用swift或jinja进行推理。如果使用jinja，则使用transformers的`apply_chat_template`。默认为swift

### 生成参数
参考[generation_config](https://huggingface.co/docs/transformers/main_classes/text_generation#transformers.GenerationConfig)文档

- 🔥max_new_tokens: 推理支持的最大新token数量，默认为None，无限制
- temperature: 温度参数，默认为None，读取generation_config.json
  - 注意：do_sample参数在本版本中移除了，请将temperature配置为0来达到相同效果
- top_k: top_k参数，默认为None，读取generation_config.json
- top_p: top_p参数，默认为None，读取generation_config.json
- repetition_penalty: 重复惩罚项，默认为None，读取generation_config.json
- num_beams: beam search的并行保留数量，默认为1
- 🔥stream: 流式输出，默认为`False`
- stop_words: 额外的停止词，默认为`[]`

### 量化参数
以下为拉起模型时量化的参数，具体含义可以查看[量化](https://huggingface.co/docs/transformers/main/en/main_classes/quantization)文档。这里不包含`swift export`中涉及的`gptq`、`awq`量化参数

- 🔥quant_method: 加载模型时采用的量化方法，可选项为`bnb`, `hqq`, `eetq`
- 🔥quant_bits: 量化bits数，默认为None
- hqq_axis: hqq量化axis，默认为None
- bnb_4bit_compute_dtype: bnb量化计算类型，可选为`float16`、`bfloat16`、`float32`，默认设置为`torch_dtype`
- bnb_4bit_quant_type: bnb量化类型，支持`fp4`和`nf4`，默认为`nf4`
- bnb_4bit_use_double_quant: 是否使用双重量化，默认为`True`
- bnb_4bit_quant_storage: bnb量化存储类型，默认为None


## 原子参数

### Seq2SeqTrainer参数

该参数列表继承自transformers `Seq2SeqTrainingArguments`，ms-swift对其默认值进行了覆盖。未列出的请参考[HF官方文档](https://huggingface.co/docs/transformers/main/en/main_classes/trainer#transformers.Seq2SeqTrainingArguments)

- 🔥output_dir: 默认为`output/<model_name>`
- 🔥gradient_checkpointing: 是否使用gradient_checkpointing，默认为True
- 🔥deepspeed: 默认为None. 可以设置为'zero0', 'zero1', 'zero2', 'zero3', 'zero2_offload', 'zero3_offload'来使用ms-swift内置的deepspeed配置文件
- 🔥per_device_train_batch_size: 默认值1
- 🔥per_device_eval_batch_size: 默认值1
- weight_decay: weight衰减系数，默认值0.1
- 🔥learning_rate: 学习率，全参数默认为1e-5，tuner为1e-4
- lr_scheduler_type: lr_scheduler类型，默认为cosine
- lr_scheduler_kwargs: lr_scheduler其他参数
- 🔥gradient_checkpointing_kwargs: 传入`torch.utils.checkpoint`中的参数. 例如设置为`--gradient_checkpointing_kwargs '{"use_reentrant": false}'`
- report_to: 默认值为`tensorboard`。你也可以指定`--report_to tensorboard wandb`, `--report_to all`
- remove_unused_columns: 默认值False
- logging_first_step: 是否记录第一个step的打印，默认值True
- logging_steps: 日志打印间隔，默认值5
- metric_for_best_model: 默认为None. 即当`predict_with_generate`设置为False, 则为'loss', 否则设置为'rouge-l'
- greater_is_better: 默认为None. 即当`metric_for_best_model`含'loss'时, 设置为False, 否则设置为True.


其他重要参数：
- 🔥num_train_epochs: 训练的epoch数，默认为3
- 🔥gradient_accumulation_steps: 梯度累加，默认为1
- 🔥save_strategy: 保存模型的策略, 可选为'no', 'steps', 'epoch', 默认为'steps'
- 🔥save_steps: 默认为500
- 🔥eval_strategy: 默认为None, 评估策略, 跟随`save_strategy`的策略
- 🔥eval_steps: 默认为None, 如果存在评估数据集, 则跟随`save_steps`的策略
- 🔥save_total_limit: 默认为None, 保存所有的checkpoint
- max_steps: 默认为-1，最大训练的steps数，在数据集为流式时需要设置
- 🔥warmup_ratio: 默认为0.
- save_on_each_node: 默认为False. 在多机训练时需要被考虑
- save_only_model: 默认为False. 是否只保存模型权重
- 🔥resume_from_checkpoint: 断点续训参数, 默认为None
- 🔥ddp_backend: 默认为None，可选为"nccl", "gloo", "mpi", "ccl", "hccl", "cncl", "mccl"
- 🔥ddp_find_unused_parameters: 默认为None
- 🔥dataloader_num_workers: 默认为0
- 🔥neftune_noise_alpha: neftune添加的噪声系数, 默认为0，通常可以设置为5, 10, 15
- average_tokens_across_devices: 是否在设备之间的token数进行平均。如果设置为True，将使用all_reduce同步`num_tokens_in_batch`以进行精确的损失计算。默认为False
- max_grad_norm: 梯度裁剪. 默认为1.
- push_to_hub: 推送训练权重到hub. 默认为False
- hub_model_id: 默认为None
- hub_private_repo: 默认为False

### Tuner参数
- 🔥freeze_llm: 冻结LLM. 默认为False. 可用于全参和LoRA
- 🔥freeze_vit: 冻结ViT. 默认为True. 可用于全参和LoRA
- 🔥freeze_aligner: 冻结aligner. 默认为True, 可用于全参和LoRA
- 🔥target_modules: 指定lora模块, 默认为`all-linear`. 在LLM和多模态LLM中，其行为有所不同. 若是LLM则自动寻找除lm_head外的linear并附加tuner，若是多模态LLM，则默认只在LLM上附加tuner，该行为可以被`freeze_llm`, `freeze_vit`, `freeze_aligner`控制. 该参数不限于LoRA
- 🔥target_regex: 指定lora模块的regex表达式. 默认为`None`, 如果该值传入, 则target_modules不生效. 该参数不限于LoRA
- 🔥init_weights: 初始化weights的方法, LoRA可以指定为`true`, `false`, `guassian`, `pissa`, `pissa_niter_[number of iters]`, Bone可以指定为`true`, `false`, `bat`, 默认值`true`
- modules_to_save: 在已附加tuner后，原模型参与训练和存储的模块，默认为`[]`. 该参数不限于LoRA

#### 全参
- freeze_parameters: 被冻结参数的前缀, 默认为`[]`
- freeze_parameters_ratio: 从下往上冻结的参数比例, 默认为0. 可设置为1将所有参数冻结, 结合`trainable_parameters`设置可训练参数.
- trainable_parameters: 可训练参数的前缀, 默认为`[]`. `trainable_parameters`的优先级高于`freeze_parameters`和`freeze_parameters_ratio`

#### LoRA
- 🔥lora_rank: 默认为`8`
- 🔥lora_alpha: 默认为`32`
- lora_dropout: 默认为`0.05`
- lora_bias: 默认为`'none'`, 可以选择的值: 'none', 'all'. 如果你要将bias全都设置为可训练, 你可以设置为`'all'`
- lora_dtype: 指定lora模块的dtype类型. 支持'float16', 'bfloat16', 'float32'，不设置默认跟随原模型类型
- 🔥use_dora: 默认为`False`, 是否使用`DoRA`
- use_rslora: 默认为`False`, 是否使用`RS-LoRA`
- 🔥lorap_lr_ratio: LoRA+参数, 默认值`None`, 建议值`10~16`, 使用lora时指定该参数即可使用lora+.
- init_weights: 权重初始化方法，适用于支持的 Tuner。默认值为 `true`。

##### LoRA-GA
- lora_ga_batch_size: 默认值为 `2`。在 LoRA-GA 中估计梯度以进行初始化时使用的批处理大小。
- lora_ga_iters: 默认值为 `2`。在 LoRA-GA 中估计梯度以进行初始化时的迭代次数。
- lora_ga_max_length: 默认值为 `1024`。在 LoRA-GA 中估计梯度以进行初始化时的最大输入长度。
- lora_ga_direction: 默认值为 `ArB2r`。在 LoRA-GA 中使用估计梯度进行初始化时的初始方向。允许的值有：`ArBr`、`A2rBr`、`ArB2r` 和 `random`。
- lora_ga_scale: 默认值为 `stable`。LoRA-GA 的初始化缩放方式。允许的值有：`gd`、`unit`、`stable` 和 `weightS`。
- lora_ga_stable_gamma: 默认值为 `16`。当初始化时选择 `stable` 缩放时的 gamma 值。

#### FourierFt

FourierFt使用`target_modules`, `target_regex`, `modules_to_save`三个参数.

- fourier_n_frequency: 傅里叶变换的频率数量, `int`类型, 类似于LoRA中的`r`. 默认值`2000`.
- fourier_scaling: W矩阵的缩放值, `float`类型, 类似LoRA中的`lora_alpha`. 默认值`300.0`.

#### BOFT

BOFT使用`target_modules`, `target_regex`, `modules_to_save`三个参数.

- boft_block_size: BOFT块尺寸, 默认值4.
- boft_block_num: BOFT块数量, 不能和`boft_block_size`同时使用.
- boft_dropout: boft的dropout值, 默认0.0.

#### Vera

Vera使用`target_modules`, `target_regex`, `modules_to_save`三个参数.

- vera_rank: Vera Attention的尺寸, 默认值256.
- vera_projection_prng_key: 是否存储Vera映射矩阵, 默认为True.
- vera_dropout: Vera的dropout值, 默认`0.0`.
- vera_d_initial: Vera的d矩阵的初始值, 默认`0.1`.

#### GaLore

- 🔥use_galore: 默认值False, 是否使用GaLore.
- galore_target_modules: 默认值None, 不传的情况下对attention和mlp应用GaLore.
- galore_rank: 默认值128, GaLore的rank值.
- galore_update_proj_gap: 默认值50, 分解矩阵的更新间隔.
- galore_scale: 默认值1.0, 矩阵权重系数.
- galore_proj_type: 默认值`std`, GaLore矩阵分解类型.
- galore_optim_per_parameter: 默认值False, 是否给每个Galore目标Parameter设定一个单独的optimizer.
- galore_with_embedding: 默认值False, 是否对embedding应用GaLore.
- galore_quantization: 是否使用q-galore. 默认值`False`.
- galore_proj_quant: 是否对SVD分解矩阵做量化, 默认`False`.
- galore_proj_bits: SVD量化bit数.
- galore_proj_group_size: SVD量化分组数.
- galore_cos_threshold: 投影矩阵更新的cos相似度阈值. 默认值0.4.
- galore_gamma_proj: 在投影矩阵逐渐相似后会拉长更新间隔, 本参数为每次拉长间隔的系数, 默认值2.
- galore_queue_size: 计算投影矩阵相似度的队列长度, 默认值5.

#### LISA

注意:LISA仅支持全参数，即train_type full`.

- 🔥lisa_activated_layers: 默认值`0`, 代表不使用LISA，改为非0代表需要激活的layers个数，建议设置为2或8.
- lisa_step_interval: 默认值`20`, 多少iter切换可反向传播的layers.

#### UNSLOTH

🔥unsloth无新增参数，对已有参数进行调节即可支持:

```
--tuner_backend unsloth
--train_type full/lora
--quant_bits 4
```

#### LLAMAPRO

- 🔥llamapro_num_new_blocks: 默认值`4`, 插入的新layers总数.
- llamapro_num_groups: 默认值`None`, 分为多少组插入new_blocks, 如果为`None`则等于`llamapro_num_new_blocks`, 即每个新的layer单独插入原模型.

#### AdaLoRA

以下参数`train_type`设置为`adalora`时生效. adalora的`target_modules`等参数继承于lora的对应参数, 但`lora_dtype`参数不生效.

- adalora_target_r: 默认值`8`, adalora的平均rank.
- adalora_init_r: 默认值`12`, adalora的初始rank.
- adalora_tinit: 默认值`0`, adalora的初始warmup.
- adalora_tfinal: 默认值`0`, adalora的final warmup.
- adalora_deltaT: 默认值`1`, adalora的step间隔.
- adalora_beta1: 默认值`0.85`, adalora的EMA参数.
- adalora_beta2: 默认值`0.85`, adalora的EMA参数.
- adalora_orth_reg_weight: 默认值`0.5`, adalora的正则化参数.

#### ReFT

以下参数`train_type`设置为`reft`时生效.

> 1. ReFT无法合并tuner
> 2. ReFT和gradient_checkpointing不兼容
> 3. 如果使用DeepSpeed遇到问题请暂时卸载DeepSpeed

- 🔥reft_layers: ReFT应用于哪些层上, 默认为`None`, 代表所有层, 可以输入层号的list, 例如reft_layers 1 2 3 4`
- 🔥reft_rank: ReFT矩阵的rank, 默认为`4`.
- reft_intervention_type: ReFT的类型, 支持'NoreftIntervention', 'LoreftIntervention', 'ConsreftIntervention', 'LobireftIntervention', 'DireftIntervention', 'NodireftIntervention', 默认为`LoreftIntervention`.
- reft_args: ReFT Intervention中的其他支持参数, 以json-string格式输入.

#### Liger

- use_liger: 使用liger-kernel进行训练.

### LMDeploy参数
参数含义可以查看[lmdeploy文档](https://lmdeploy.readthedocs.io/en/latest/api/pipeline.html#turbomindengineconfig)

- 🔥tp: tensor并行度. 默认值`1`
- session_len: 默认值`None`
- cache_max_entry_count: 默认值`0.8`
- quant_policy: 默认值`0`
- vision_batch_size: 默认值`1`

### vLLM参数
参数含义可以查看[vllm文档](https://docs.vllm.ai/en/latest/models/engine_args.html)

- 🔥gpu_memory_utilization: 默认值`0.9`
- 🔥tensor_parallel_size: 默认为`1`
- pipeline_parallel_size: 默认为`1`
- max_num_seqs: 默认为`256`
- 🔥max_model_len: 默认为`None`
- disable_custom_all_reduce: 默认为`False`
- enforce_eager: vllm使用pytorch eager模式还是建立cuda graph. 默认为`False`. 设置为True可以节约显存, 但会影响效率.
- 🔥limit_mm_per_prompt: 控制vllm使用多图, 默认为`None`. 例如传入`--limit_mm_per_prompt '{"image": 10, "video": 5}'`
- vllm_max_lora_rank: 默认为`16`. vllm对于lora支持的参数


### 合并参数

- 🔥merge_lora: 是否合并lora，本参数支持lora、llamapro、longlora，默认为False
- safe_serialization: 是否存储safetensors，默认为True
- max_shard_size: 单存储文件最大大小，默认'5GB'


## 集成参数

### 训练参数
训练参数除包含[基本参数](#基本参数)、[Seq2SeqTrainer参数](#Seq2SeqTrainer参数)、[tuner参数](#tuner参数)外，还包含下面的部分:

- add_version: 在output_dir上额外增加目录`'<版本号>-<时间戳>'`防止权重覆盖，默认为True
- resume_only_model: 如果resume_from_checkpoint，仅resume模型权重，默认为False
- check_model: 检查本地模型文件有损坏或修改并给出提示，默认为True。如果是断网环境，请设置为False
- loss_type: loss类型，默认使用模型自带损失函数

- packing: 是否使用packing，默认为False
- 🔥lazy_tokenize: 是否使用lazy_tokenize，在LLM训练中默认False，MLLM训练中默认True

- acc_strategy: 训练acc的策略，可以为`seq`和`token`级别的acc，默认为`token`
- max_new_tokens: predict_with_generate=True时的最大生成token数量，默认64
- temperature: predict_with_generate=True时的temperature，默认0
- optimizer: plugin的自定义optimizer名称
- metric: plugin的自定义metric名称

### RLHF参数
RLHF参数继承于[训练参数](#训练参数)

- 🔥rlhf_type: 对齐算法类型，支持`dpo`, `orpo`, `simpo`, `kto`, `cpo`, `rm`
- ref_model: DPO等算法中的原始对比模型
- ref_model_type: 同model_type
- ref_model_revision: 同model_revision

- 🔥beta: KL正则项系数, 默认为`None`, 即`simpo`算法默认为`2.`, 其他算法默认为`0.1`. 具体参考[文档](./人类对齐.md)
- label_smoothing: 是否使用DPO smoothing, 默认值为`0`，一般设置在0~0.5之间

- 🔥rpo_alpha: 控制DPO中加入sft_loss的权重, 默认为`1`. 最后的loss为`KL_loss + rpo_alpha * sft_loss`

- cpo_alpha: CPO/SimPO loss 中 nll loss的系数, 默认为`1.`

- simpo_gamma: SimPO算法中的reward margin项，论文中建议设置为0.5-1.5, 默认为`1.`

- desirable_weight: KTO算法中对desirable response的loss权重 $\lambda_D$ ，默认为`1.`
- undesirable_weight: KTO论文中对undesirable response的loss权重 $\lambda_U$ , 默认为`1.`


### 推理参数

推理参数除包含[基本参数](#基本参数)、[合并参数](#合并参数)、[vLLM参数](#vllm参数)、[LMDeploy参数](#LMDeploy参数)外，还包含下面的部分：

- 🔥infer_backend: 推理backend，支持'pt'、'vllm'、'lmdeploy'三个推理框架，默认为'pt'
- 🔥max_batch_size: pt backend的batch_size，默认为1
- ddp_backend: pt backend使用多卡推理时的分布式后端，默认为None. 多卡推理例子可以查看[这里](https://github.com/modelscope/ms-swift/tree/main/examples/infer/pt)
- result_path: 推理结果存储路径（jsonl），默认为None，保存在checkpoint目录或者'./result'目录
- val_dataset_sample: 推理数据集采样数，默认为None


### 部署参数

部署参数继承于[推理参数](#推理参数)

- host: 服务host，默认为'0.0.0.0'
- port: 端口号，默认为8000
- api_key: 访问需要使用的Key

- owned_by: 默认为`swift`
- 🔥served_model_name: 提供服务的模型名称，默认使用model的后缀
- verbose: 打印访问日志，默认为True
- log_interval: tokens/s统计值打印间隔，默认20秒。设置为-1则不打印
- max_logprobs: 最多返回的logprobs数量，默认为20


### Web-UI参数
- server_name: web-ui的host，默认为'0.0.0.0'
- server_port: web-ui的port，默认为7860
- share: 默认为False
- lang: web-ui的语言，可选为'zh', 'en'。默认为'zh'


### App参数

App参数继承于[部署参数](#部署参数), [Web-UI参数](#Web-UI参数)
- base_url: 模型部署的base_url，例如`http://localhost:8000/v1`。默认为`None`
- studio_title: studio的标题。默认为None，设置为模型名
- is_multimodal: 是否启动多模态版本的app。默认为None，自动根据model判断，若无法判断，设置为False
- lang: 覆盖Web-UI参数，默认为'en'

### 评测参数

评测参数继承于[部署参数](#部署参数)

- 🔥eval_dataset: 评测数据集，请查看[评测文档](./评测.md)
- eval_limit: 每个评测集的采样数，默认为None
- eval_output_dir: 评测存储结果的文件夹，默认为'eval_output'
- temperature: 默认为0.
- verbose: 该参数在本地评估时传入DeployArguments中，默认`False`
- max_batch_size: 最大batch_size，文本评测默认256，多模态默认16
- 🔥eval_url: 评测url，例如`http://localhost:8000/v1`。默认为None，采用本地部署评估。例子可以查看[这里](https://github.com/modelscope/ms-swift/tree/main/examples/eval/eval_url)

### 导出参数

导出参数除包含[基本参数](#基本参数)和[合并参数](#合并参数)外，还包含下面的部分:

- 🔥output_dir: 导出结果存储路径，默认为None

- 🔥quant_method: 可选为'gptq', 'awq'，默认为None
- quant_n_samples: gptq/awq的校验集抽样数，默认为128
- max_length: 校准集的max_length, 默认值2048
- quant_batch_size: 量化batch_size，默认为1
- group_size: 量化group大小，默认为128

- 🔥push_to_hub: 是否推送hub，默认为False
- hub_model_id: 推送的model_id，默认为None
- hub_private_repo: 是否是private repo，默认为False
- commit_message: 提交信息，默认为'update files'


## 特定模型参数
特定模型参数可以通过`--model_kwargs`或者环境变量进行设置，例如: `--model_kwargs '{"fps_max_frames": 12}'`或者`FPS_MAX_FRAMES=12`

### qwen2_vl, qvq
参数含义可以查看[这里](https://github.com/QwenLM/Qwen2-VL/blob/main/qwen-vl-utils/src/qwen_vl_utils/vision_process.py#L24)

- IMAGE_FACTOR: 默认为28
- MIN_PIXELS: 默认为`4 * 28 * 28`
- 🔥MAX_PIXELS: 默认为`16384 * 28 * 28`，参考[这里](https://github.com/modelscope/ms-swift/blob/main/examples/train/multimodal/ocr.sh#L3)
- MAX_RATIO: 默认为200
- VIDEO_MIN_PIXELS: 默认为`128 * 28 * 28`
- 🔥VIDEO_MAX_PIXELS: 默认为`768 * 28 * 28`，参考[这里](https://github.com/modelscope/ms-swift/blob/main/examples/train/multimodal/video.sh#L7)
- VIDEO_TOTAL_PIXELS: 默认为`24576 * 28 * 28`
- FRAME_FACTOR: 默认为2
- FPS: 默认为2.0
- FPS_MIN_FRAMES: 默认为4
- 🔥FPS_MAX_FRAMES: 默认为768，参考[这里](https://github.com/modelscope/ms-swift/blob/main/examples/train/multimodal/video.sh#L8)

### internvl, internvl_phi3
参数含义可以查看[这里](https://modelscope.cn/models/OpenGVLab/Mini-InternVL-Chat-2B-V1-5)
- MAX_NUM: 默认为12
- INPUT_SIZE: 默认为448

### internvl2, internvl2_phi3, internvl2_5
参数含义可以查看[这里](https://modelscope.cn/models/OpenGVLab/InternVL2_5-2B)
- MAX_NUM: 默认为12
- INPUT_SIZE: 默认为448
- VIDEO_MAX_NUM: 默认为1。视频的MAX_NUM
- VIDEO_SEGMENTS: 默认为8


### minicpmv2_6
- MAX_SLICE_NUMS: 默认为9，参考[这里](https://modelscope.cn/models/OpenBMB/MiniCPM-V-2_6/file/view/master?fileName=config.json&status=1)
- VIDEO_MAX_SLICE_NUMS: 默认为1，视频的MAX_SLICE_NUMS，参考[这里](https://modelscope.cn/models/OpenBMB/MiniCPM-V-2_6)
- MAX_NUM_FRAMES: 默认为64，参考[这里](https://modelscope.cn/models/OpenBMB/MiniCPM-V-2_6)

### ovis1_6
- MAX_PARTITION: 参考[这里](https://github.com/AIDC-AI/Ovis/blob/d248e34d755a95d24315c40e2489750a869c5dbc/ovis/model/modeling_ovis.py#L312)

### mplug_owl3, mplug_owl3_241101
- MAX_NUM_FRAMES: 默认为16，参考[这里](https://modelscope.cn/models/iic/mPLUG-Owl3-7B-240728)

### xcomposer2_4khd
- HD_NUM: 默认为55，参考[这里](https://modelscope.cn/models/Shanghai_AI_Laboratory/internlm-xcomposer2-4khd-7b)

### xcomposer2_5
- HD_NUM: 图片数量为1时，默认值为24。大于1，默认为6。参考[这里](https://modelscope.cn/models/AI-ModelScope/internlm-xcomposer2d5-7b/file/view/master?fileName=modeling_internlm_xcomposer2.py&status=1#L254)

### video_cogvlm2
- NUM_FRAMES: 默认为24，参考[这里](https://github.com/THUDM/CogVLM2/blob/main/video_demo/inference.py#L22)

### phi3_vision
- NUM_CROPS: 默认为4，参考[这里](https://modelscope.cn/models/LLM-Research/Phi-3.5-vision-instruct)

### llama3_1_omni
- N_MELS: 默认为128，参考[这里](https://github.com/ictnlp/LLaMA-Omni/blob/544d0ff3de8817fdcbc5192941a11cf4a72cbf2b/omni_speech/infer/infer.py#L57)

### video_llava
- NUM_FRAMES: 默认为16
