---
id: resources
title: Talks & Blogs
---

<div id="codefund"></div>

## Official resources

-   Introduction blog post [The curious case of MobX state tree](https://medium.com/@mweststrate/the-curious-case-of-mobx-state-tree-7b4e22d461f)
-   Free [egghead.io](https://egghead.io/courses/manage-application-state-with-mobx-state-tree) MST course
-   [Introduction tutorial](../intro/getting-started)

## Talks

-   Talk React Europe 2017: [Next generation state management](https://www.youtube.com/watch?v=rwqwwn_46kA)
-   Talk ReactNext 2017: [React, but for Data](https://www.youtube.com/watch?v=xfC_xEA8Z1M&index=6&list=PLMYVq3z1QxSqq6D7jxVdqttOX7H_Brq8Z) ([slides](http://react-next-2017-slides.surge.sh/#1), [demo](https://codesandbox.io/s/8y4p23j32j))
-   Talk ReactJSDay Verona 2017: [Immutable or immutable? Both!](https://www.youtube.com/watch?v=zdtwaa5Rmb8&index=9&list=PLWK9j6ps_unl293VhhN4RYMCISxye3xH9) ([slides](https://mweststrate.github.io/reactjsday2017-presentation/index.html#1), [demo](https://github.com/mweststrate/reatjsday2017-demo))
-   Talk React Alicante 2017: [Mutable or Immutable? Let's do both!](https://www.youtube.com/watch?v=DgnL3uij9ec&list=PLd7nkr8mN0sWvBH_s0foCE6eZTX8BmLUM&index=9) ([slides](https://mattiamanzati.github.io/slides-react-alicante-2017/#2))
-   Talk ReactiveConf 2016: [Immer-mutable state management](https://www.youtube.com/watch?v=Ql8KUUUOHNc&list=PLa2ZZ09WYepMCRRGCRPhTYuTCat4TiDlX&index=30)
-   Talk FrontendLove 2018: [MobX State Tree + React: pure reactivity served](https://www.youtube.com/watch?v=HS9revHrNRI) by [Luca Mezzalira](https://lucamezzalira.com/) ([slides](https://docs.google.com/presentation/d/1f18RhN9hz1GPAdY4binWVNZDKm3k7EfNvV48lWnzdjQ/edit#slide=id.g35f391192_00)).
-   Talk React Native EU 2019: [Resolving the Great State Debate with Hooks, Context, and MobX-State-Tree](https://www.youtube.com/watch?v=Wx9slbOTD6Q) by [Jamon Holmgren](https://jamonholmgren.com/) ([slides](https://infinite-red.slides.com/infinitered/resolving-the-great-state-debate))
-   International JavaScript Conference 2019, Londen [You don’t know MobX State Tree](https://www.youtube.com/watch?v=LKyCJB27oNM), by [Max Gallo](https://twitter.com/_maxgallo)
-   React Europe 2019: [Combining GraphQL + mobx-state-tree](https://www.youtube.com/watch?v=Sq2M00vghqY)

## Blogs / Vlogs

-   [Introduction to MobX State Tree](https://www.youtube.com/watch?v=pPgOrecfcg4) by [Leigh Halliday](https://twitter.com/leighchalliday)
-   [Creating a Trivia App with Ignite Bowser](https://shift.infinite.red/creating-a-trivia-app-with-ignite-bowser-part-1-1987cc6e93a1) by [Robin Heinze](https://twitter.com/robin_heinze)
-   <img src="https://raw.githubusercontent.com/mobxjs/mobx/master/docs/assets/book.jpg" height="80px"/> [The MobX book](https://books.google.nl/books?id=ALFmDwAAQBAJ&pg=PP1&lpg=PP1&dq=michel+weststrate+mobx+quick+start+guide:+supercharge+the+client+state+in+your+react+apps+with+mobx&source=bl&ots=D460fxti0F&sig=ivDGTxsPNwlOjLHrpKF1nweZFl8&hl=nl&sa=X&ved=2ahUKEwiwl8XO--ncAhWPmbQKHWOYBqIQ6AEwAnoECAkQAQ#v=onepage&q=michel%20weststrate%20mobx%20quick%20start%20guide%3A%20supercharge%20the%20client%20state%20in%20your%20react%20apps%20with%20mobx&f=false) by Pavan Podila and Michel Weststrate, discusses MobX-State-Tree as well.
-   [How to: mobx-state-tree + react + typescript](https://dev.to/margaretkrutikova/how-to-mobx-state-tree-react-typescript-3d5j) by [Margarita Krutikova](https://twitter.com/rita_krutikova)
-   [MobX-state-tree: A step by step guide for React Apps](https://medium.com/mr-frontend-community/mobx-state-tree-a-step-by-step-guide-for-react-apps-e65716a219d2) by [Faris Tangastani](https://medium.com/@ftangastani)

## Supported devtools:

-   [Reactotron](https://github.com/infinitered/reactotron)
-   [MobX DevTools](https://chrome.google.com/webstore/detail/mobx-developer-tools/pfgnfdagidkfgccljigdamigbcnndkod)
-   The Redux can be connected as well as demonstrated [here](https://github.com/coolsoftwaretyler/mst-example-redux-todomvc/blob/main/src/index.js#L6)

## Addons, libraries and tools

-   [mst-query](https://github.com/ConrabOpto/mst-query/) - Query library for MST with support for auto normalization, garbage collection, infinite scroll & pagination, and more
