---
id: api
title: API overview
---

<div id="codefund"></div>

See the [TypeDocs](/API/) for full details and typings.

| signature                                                                                                             |                                                                                                                                                                                                                                                       |
| --------------------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| [`addDisposer(node, () => void)`](/API/#adddisposer)                                                     | Add a function to be invoked whenever the target node is about to be destroyed                                                                                                                                                                        |
| [`addMiddleware(node, middleware: (actionDescription, next) => any, includeHooks)`](/API/#addmiddleware) | Attaches middleware to a node. See [middleware](../concepts/middleware). Returns disposer.                                                                                                                                                                |
| [`applyAction(node, actionDescription)`](/API/#applyaction)                                              | Replays an action on the targeted node                                                                                                                                                                                                                |
| [`applyPatch(node, jsonPatch)`](/API/#applypatch)                                                        | Applies a JSON patch, or array of patches, to a node in the tree                                                                                                                                                                                      |
| [`applySnapshot(node, snapshot)`](/API/#applysnapshot)                                                   | Updates a node with the given snapshot                                                                                                                                                                                                                |
| [`cast(nodeOrSnapshot)`](/API/#cast)                                                                     | Cast a node instance or snapshot to a node instance so it can be used in assignment operations                                                                                                                                                        |
| [`castToSnapshot(nodeOrSnapshot)`](/API/#casttosnapshot)                                                 | Cast a node instance to a snapshot so it can be used inside create operations                                                                                                                                                                         |
| [`castToReferenceSnapshot(node)`](/API/#casttoreferencesnapshot)                                         | Cast a node instance to a reference snapshot so it can be used inside create operations                                                                                                                                                               |
| [`createActionTrackingMiddleware`](/API/#createactiontrackingmiddleware)                                 | Utility to make writing middleware that tracks async actions less cumbersome. Consider migrating to `createActionTrackingMiddleware2`                                                                                                                 |
| [`createActionTrackingMiddleware2`](/API/#createactiontrackingmiddleware)                                | Utility to make writing middleware that tracks async actions less cumbersome                                                                                                                                                                          |
| [`clone(node, keepEnvironment?: boolean / newEnvironment)`](/API/#clone)                          | Creates a full clone of the given node. By default preserves the same environment                                                                                                                                                                     |
| [`decorate(handler, function)`](/API/#decorate)                                                          | Attaches middleware to a specific action (or flow)                                                                                                                                                                                                    |
| [`destroy(node)`](/API/#destroy)                                                                         | Kills `node`, making it unusable. Removes it from any parent in the process                                                                                                                                                                           |
| [`detach(node)`](/API/#detach)                                                                           | Removes `node` from its current parent, and lets it live on as standalone tree                                                                                                                                                                        |
| [`flow(generator)`](/API/#flow)                                                                          | Creates an asynchronous flow based on a generator function                                                                                                                                                                                            |
| [`castFlowReturn(value)`](/API/#castflowreturn)                                                          | Casts a flow return value so it can be correctly inferred as return type. Only needed when using TypeScript and when returning a Promise.                                                                                                             |
| [`getChildType(node, property?)`](/API/#getchildtype)                                                    | Returns the declared type of the given `property` of `node`. For arrays and maps `property` can be omitted as they all have the same type                                                                                                             |
| [`getEnv(node)`](/API/#getenv)                                                                           | Returns the environment of `node`, see [dependency injection](../concepts/dependency-injection)                                                                                                                                                                                  |
| [`getParent(node, depth=1)`](/API/#getparent)                                                            | Returns the intermediate parent of the `node`, or a higher one if `depth > 1`                                                                                                                                                                         |
| [`getParentOfType(node, type)`](/API/#getparentoftype)                                                   | Return the first parent that satisfies the provided type                                                                                                                                                                                              |
| [`getPath(node)`](/API/#getpath)                                                                         | Returns the path of `node` in the tree                                                                                                                                                                                                                |
| [`getPathParts(node)`](/API/#getpathparts)                                                               | Returns the path of `node` in the tree, unescaped as separate parts                                                                                                                                                                                   |
| [`getRelativePath(base, target)`](/API/#getrelativepath)                                                 | Returns the short path, which one could use to walk from node `base` to node `target`, assuming they are in the same tree. Up is represented as `../`                                                                                                 |
| [`getRoot(node)`](/API/#getroot)                                                                         | Returns the root element of the tree containing `node`                                                                                                                                                                                                |
| [`getIdentifier(node)`](/API/#getidentifier)                                                             | Returns the identifier of the given element                                                                                                                                                                                                           |
| [`getNodeId(node)`](/API/#getnodeid)                                                                     | Returns the unique node id (not to be confused with the instance identifier) for a given instance                                                                                                                                                     |
| [`getSnapshot(node, applyPostProcess)`](/API/#getsnapshot)                                               | Returns the snapshot of the `node`. See [snapshots](../concepts/snapshots)                                                                                                                                                                                       |
| [`getType(node)`](/API/#gettype)                                                                         | Returns the type of `node`                                                                                                                                                                                                                            |
| [`hasParent(node, depth=1)`](/API/#hasparent)                                                            | Returns `true` if `node` has a parent at `depth`                                                                                                                                                                                                      |
| [`hasParentOfType(node, type)`](/API/#hasparentoftype)                                                   | Returns `true` if the `node` has a parent that satisfies the provided type                                                                                                                                                                            |
| [`isAlive(node)`](/API/#isalive)                                                                         | Returns `true` if `node` is alive                                                                                                                                                                                                                     |
| [`isStateTreeNode(value)`](/API/#isstatetreenode)                                                        | Returns `true` if `value` is a node of a mobx-state-tree                                                                                                                                                                                              |
| [`isProtected(value)`](/API/#isprotected)                                                                | Returns `true` if the given node is protected, see [actions](../concepts/actions)                                                                                                                                                                                |
| [`isValidReference(() => node / null / undefined, checkIfAlive = true)`](/API/#isvalidreference)       | Tests if a reference is valid (pointing to an existing node and optionally if alive) and returns if the check passes or not.                                                                                                                          |
| [`isRoot(node)`](/API/#isroot)                                                                           | Returns true if `node` has no parents                                                                                                                                                                                                                 |
| [`joinJsonPath(parts)`](/API/#joinjsonpath)                                                              | Joins and escapes the given path `parts` into a JSON path                                                                                                                                                                                             |
| [`onAction(node, (actionDescription) => void)`](/API/#onaction)                                          | A built-in middleware that calls the provided callback with an action description upon each invocation. Returns disposer                                                                                                                              |
| [`onPatch(node, (patch) => void)`](/API/#onpatch)                                                        | Attach a JSONPatch listener, that is invoked for each change in the tree. Returns disposer                                                                                                                                                            |
| [`onSnapshot(node, (snapshot) => void)`](/API/#onsnapshot)                                               | Attach a snapshot listener, that is invoked for each change in the tree. Returns disposer                                                                                                                                                             |
| [`process(generator)`](/API/#process)                                                                    | `DEPRECATED` – replaced with [flow](/API/#flow)                                                                                                                                                                                          |
| [`protect(node)`](/API/#protect)                                                                         | Protects an unprotected tree against modifications from outside actions                                                                                                                                                                               |
| [`recordActions(node)`](/API/#recordactions)                                                             | Creates a recorder that listens to all actions in `node`. Call `.stop()` on the recorder to stop this, and `.replay(target)` to replay the recorded actions on another tree                                                                           |
| [`recordPatches(node)`](/API/#recordpatches)                                                             | Creates a recorder that listens to all patches emitted by the node. Call `.stop()` on the recorder to stop this, and `.replay(target)` to replay the recorded patches on another tree                                                                 |
| [`getMembers(node)`](/API/#getMembers)                                                                   | Returns the model name, properties, actions, views, volatiles of a model node instance                                                                                                                                                                |
| [`getPropertyMembers(typeOrNode)`](/API/#getPropertyMembers)                                             | Returns the model name and properties of a model type for either a model type or a model node                                                                                                                                                         |
| [`resolve(node, path)`](/API/#resolve)                                                                   | Resolves a `path` (json path) relatively to the given `node`                                                                                                                                                                                          |
| [`resolveIdentifier(type, target, identifier)`](/API/#resolveidentifier)                                 | resolves an identifier of a given type in a model tree                                                                                                                                                                                                |
| [`resolvePath(target, path)`](/API/#resolvepath)                                                         | resolves a JSON path, starting at the specified target                                                                                                                                                                                                |
| [`setLivelinessChecking("warn" / "ignore" / "error")`](/API/#setlivelinesschecking)                    | Defines what MST should do when running into reads / writes to objects that have died. By default it will print a warning. Use te `"error"` option to easy debugging to see where the error was thrown and when the offending read / write took place |
| [`getLivelinessChecking()`](/API/#getlivelinesschecking)                                                 | Returns the current liveliness checking mode.                                                                                                                                                                                                         |
| [`splitJsonPath(path)`](/API/#splitjsonpath)                                                             | Splits and unescapes the given JSON `path` into path parts                                                                                                                                                                                            |
| [`typecheck(type, value)`](/API/#typecheck)                                                              | Typechecks a value against a type. Throws on errors. Use this if you need typechecks even in a production build. NOTE: set process.env.ENABLE_TYPE_CHECK = "true" if you want to enable type checking in any environment                                                                                                                                      |
| [`tryResolve(node, path)`](/API/#tryresolve)                                                             | Like `resolve`, but just returns `null` if resolving fails at any point in the path                                                                                                                                                                   |
| [`tryReference(() => node / null / undefined, checkIfAlive = true)`](/API/#tryreference)                 | Tests if a reference is valid (pointing to an existing node and optionally if alive) and returns such reference if it the check passes, else it returns undefined.                                                                                    |
| [`unprotect(node)`](/API/#unprotect)                                                                     | Unprotects `node`, making it possible to directly modify any value in the subtree, without actions                                                                                                                                                    |
| [`walk(startNode, (node) => void)`](/API/#walk)                                                          | Performs a depth-first walk through a tree                                                                                                                                                                                                            |
| [`escapeJsonPath(path)`](/API/#escapejsonpath)                                                           | escape special characters in an identifier, according to http://tools.ietf.org/html/rfc6901                                                                                                                                                           |
| [`unescapeJsonPath(path)`](/API/#unescapejsonpath)                                                       | escape special characters in an identifier, according to http://tools.ietf.org/html/rfc6901                                                                                                                                                           |
| [`isType(value)`](/API/#isType)                                                                          | Returns if a given value represents a type.                                                                                                                                                                                                           |
| [`isArrayType(value)`](/API/#isArrayType)                                                                | Returns if a given value represents an array type.                                                                                                                                                                                                    |
| [`isFrozenType(value)`](/API/#isFrozenType)                                                              | Returns if a given value represents a frozen type.                                                                                                                                                                                                    |
| [`isIdentifierType(value)`](/API/#isIdentifierType)                                                      | Returns if a given value represents an identifier type.                                                                                                                                                                                               |
| [`isLateType(value)`](/API/#isLateType)                                                                  | Returns if a given value represents a late type.                                                                                                                                                                                                      |
| [`isLiteralType(value)`](/API/#isLiteralType)                                                            | Returns if a given value represents a literal type.                                                                                                                                                                                                   |
| [`isMapType(value)`](/API/#isMapType)                                                                    | Returns if a given value represents a map type.                                                                                                                                                                                                       |
| [`isModelType(value)`](/API/#isModelType)                                                                | Returns if a given value represents a model type.                                                                                                                                                                                                     |
| [`isOptionalType(value)`](/API/#isOptionalType)                                                          | Returns if a given value represents an optional type.                                                                                                                                                                                                 |
| [`isPrimitiveType(value)`](/API/#isPrimitiveType)                                                        | Returns if a given value represents a primitive type.                                                                                                                                                                                                 |
| [`isReferenceType(value)`](/API/#isReferenceType)                                                        | Returns if a given value represents a reference type.                                                                                                                                                                                                 |
| [`isRefinementType(value)`](/API/#isRefinementType)                                                      | Returns if a given value represents a refinement type.                                                                                                                                                                                                |
| [`isUnionType(value)`](/API/#isUnionType)                                                                | Returns if a given value represents a union type.                                                                                                                                                                                                     |
| [`getRunningActionContext()`](/API/#getrunningactioncontext)                                             | Returns the currently executing MST action context, or undefined if none.                                                                                                                                                                             |
| [`isActionContextChildOf(actionContext, parent)`](/API/#isActionContextChildOf)                          | Returns if the given action context is a parent of this action context.                                                                                                                                                                               |
| [`isActionContextThisOrChildOf(actionContext, parentOrSame)`](/API/#isActionContextThisOrChildOf)        | Returns if the given action context is this or a parent of this action context.                                                                                                                                                                       |

A _disposer_ is a function that cancels the effect for which it was created.

