% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/terminal.R
\name{terminal}
\alias{terminal}
\title{Terminal points of a randomised clinical trial design that assumes a
Bernoulli distributed primary outcome variable}
\usage{
terminal(des = ph2rand::des_one_stage(), k = 1:des$J, summary = FALSE)
}
\arguments{
\item{des}{An object of class \code{ph2rand_des}, as returned by
\code{\link{des_one_stage}} or \code{\link{des_two_stage}}. Defaults to
\code{ph2rand::des_one_stage()}.}

\item{k}{A \code{\link{numeric}} \code{\link{vector}} indicating which stages
to consider when determining the terminal points. Defaults to \code{1:des$J}
(i.e., to all stages of the given design).}

\item{summary}{A \code{\link{logical}} variable indicating whether a summary
of the function's progress should be printed to the console. Defaults to
\code{FALSE}.}
}
\value{
A \code{\link{list}} with additional class \code{"ph2rand_terminal"},
containing each of the input parameters along with a tibble in the slot
\code{$terminal}, which gives the determined terminal points.
}
\description{
\code{terminal} determines the 'terminal' points of a design returned by
\code{\link{des_one_stage}} or \code{\link{des_two_stage}}.
}
\examples{
# The default two-stage design
des     <- des_two_stage()
# Its terminal points across stages 1 and 2
term_12 <- terminal(des)
# Its terminal points from stage 2 only
term_2  <- terminal(des, 2)
# A plot of these points
plot(term_2)
}
\seealso{
\code{\link{des_one_stage}}, \code{\link{des_two_stage}},
\code{\link{plot.ph2rand_terminal}}.
}
