% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.ph2rand_pmf.R
\name{plot.ph2rand_pmf}
\alias{plot.ph2rand_pmf}
\title{Plot probability mass functions of a randomised clinical trial design that
assumes a Bernoulli distributed primary outcome variable}
\usage{
\method{plot}{ph2rand_pmf}(x, output = FALSE, ...)
}
\arguments{
\item{x}{An object of class \code{ph2rand_pmf}, as returned by
\code{\link{pmf}}.}

\item{output}{A \code{\link{logical}} variable indicating whether outputs
should be returned by the function.}

\item{...}{Not currently used.}
}
\value{
If \code{output = TRUE}, a \code{\link{list}} containing each of the
input parameters along with a plot in the slot \code{$plot}, which gives the
produced plot of the terminal points.
}
\description{
\code{plot.ph2rand_pmf} plots the terminal points of a design returned by
\code{\link{pmf}}.
}
\examples{
# The default two-stage design
des <- des_two_stage()
# Its probability mass function under the uninteresting and interesting
# scenarios
pmf <- pmf(des)
# The plot of them
plot(pmf)
# The same probability mass functions, conditioning on the trial ending in
# stage 2
pmf <- pmf(des, k = 2)
# The plot of them
plot(pmf)
}
\seealso{
\code{\link{des_one_stage}}, \code{\link{des_two_stage}},
\code{\link{pmf}}, \code{\link{plot.ph2rand_des}}.
}
