# Small N Stats Data Tracker (Qt)

Data Tracker is a Qt-based application that assists researchers and clinicians in reliably measuring behavior of interest. This program can be used by multiple observers to record, and compare, behavior in real-time. Additionally, this tool provides multiples methods for assessing the reliability of measurements, session-by-session viewing and interpretation, and the automation of clinical responsibilities.

Features include:
  - Multi-rater observations with options for saving data in multiple locations and formats (JSON, xlsx)
  - Calculation of reliability indices
  - Customizable methods for designing measurement systems
  - Automation of clinical responsibilities (compiling results, calculation of reliability metrics, charting, etc.)
  - Cross-platform support for Windows, Mac, and Linux (only Ubuntu tested)
  - Saving figures in a range of common formats

TODO
  - Reli Checks
  - Charting
  - Session Viewer

### Version
------
0.1.0 (beta)

### Changelog
------
 * 0.1.0 - Auto update/notification
 * 0.0.9 - Session viewer
 * 0.0.8 - Automated file migrations (after every change, optional)
 * 0.0.7 - Automated reliability calculations (after every session, optional)
 * 0.0.6 - Theming (light and dark modes)
 * 0.0.5 - JSON and xlsx file outputs (optional)
 * 0.0.4 - Saveable options for file output
 * 0.0.3 - Post-session cumulative recording plots (optional)
 * 0.0.2 - Calculation of reliability
 * 0.0.1 - Barebones framework

### Usage
------

...

### Referenced Works (F/OSS software)
------
 * Qt Framework (5.8) - LGPL 3.0 (GPL 3.0 Licensed). Copyright (C). Qt Team [Site](https://www.qt.io/)
 * Tango icon set - Public Domain Licensed. Copyright (C) 2009, "Tango Desktop Project" [Site](http://tango.freedesktop.org/Tango_Desktop_Project)
 * QtXlsx - MIT Licensed. Copyright (C) 2013, Debao Zhang <hello@debao.me> [Github](https://github.com/dbzhang800/QtXlsxWriter)
 * QDarkStyleSheet - MIT Licensed. Copyright (C) 2013-2017, Colin Duquesnoy <colin.duquesnoy@gmail.com> [Github](https://github.com/ColinDuquesnoy/QDarkStyleSheet)
 * BDataPro - GPL-3+. Copyright (C) 2017, Chris Bullock. [Site](https://www.kennedykrieger.org/patient-care/patient-care-programs/inpatient-programs/neurobehavioral-unit-nbu/bdatapro-software-for-real-time-behavior-data-collection).

### Referenced Works (academic works)
------
The Small N Stats Data Tracker is based on the following academic works:

 * Bullock, C. E., Fisher, W. W., & Hagopian, L. P. (2017). Description and Validation of a Computerized Behavioral Data Program: "BDataPro". The Behavior Analyst, 1-11. [doi:https://dx.doi.org/10.1007/s40614-016-0079-0](https://dx.doi.org/10.1007/s40614-016-0079-0)

### Acknowledgements and Credits
------
 * Donald A. Hantula, Decision Making Laboratory, Temple University [Site](http://astro.temple.edu/~hantula/)
 * Chris Bullock, Kennedy Krieger Institute (Site)[https://www.kennedykrieger.org/patient-care/patient-care-programs/inpatient-programs/neurobehavioral-unit-nbu/bdatapro-software-for-real-time-behavior-data-collection].

### Installation
------
No other packages are required. Simply build and run or install and run.

### Download
------
All downloadable binaries, if/when posted, will be hosted at [Small N Stats](http://www.smallnstats.com).

### Development
------
Want to contribute? Great! Emails or PM's are welcome.

### Todos
------
 - Post-session key editing (for fixing errors)
 - Statistical analyses (lag sequential analyses)
 - Treatment summaries and reports

### License
----
Data Tracker (Qt) - Copyright 2017, Shawn P. Gilroy. GPL-Version 3
