"use strict";
var appShared = angular.module("MixShared", [
  "ngRoute",
  "ngFileUpload",
  "LocalStorageModule",
  "SharedComponents",
]);
var sharedComponents = angular.module("SharedComponents", []);
window.executeFunctionByName = async function (
  functionName,
  args,
  context = window
) {
  if (functionName !== null) {
    var namespaces = functionName.split(".");
    var func = namespaces.pop();
    for (var i = 0; i < namespaces.length; i++) {
      context = context[namespaces[i]];
    }
    functionName = null;
    return context[func].apply(this, args);
  }
};

appShared.constant("AppSettings", {
  serviceBase: "",
  apiVersion: "v1",
});
appShared.constant("ngAppSettings", {
  serviceBase: "",
  encryptKey: "MbQeThWmZq4t7w!z$C&F)J@NcRfUjXn2",
  encryptIV: "3s6v9y$B&E)H@McQ",
  clientId: "ngAuthApp",
  facebookAppId: "",
  request: {
    pageSize: "20",
    pageIndex: 0,
    status: "Published",
    orderBy: "CreatedDateTime",
    direction: "Desc",
    fromDate: null,
    toDate: null,
    keyword: "",
    key: "",
    query: {},
  },
  restRequest: {
    pageSize: "20",
    pageIndex: 0,
    status: "Published",
    orderBy: "CreatedDateTime",
    direction: "Desc",
    fromDate: null,
    toDate: null,
    keyword: "",
    query: {},
  },
  privacies: ["VND", "USD"],
  pageSizes: ["", "5", "10", "15", "20"],
  directions: [
    {
      value: "Asc",
      title: "Asc",
    },
    {
      value: "Desc",
      title: "Desc",
    },
  ],
  orders: [
    {
      value: "CreatedDateTime",
      title: "Created Date",
    },
    {
      value: "Priority",
      title: "Priority",
    },

    {
      value: "Title",
      title: "Title",
    },
  ],
  contentStatuses: ["Deleted", "Preview", "Published", "Draft", "Schedule"],
  dataTypes: [
    {
      title: "Custom",
      value: "Custom",
    },
    {
      title: "DateTime",
      value: "DateTime",
    },
    {
      title: "Date",
      value: "Date",
    },
    {
      title: "Time",
      value: "Time",
    },
    {
      title: "Duration",
      value: "Duration",
    },
    {
      title: "Phone Number",
      value: "PhoneNumber",
    },
    {
      title: "Currency",
      value: "Currency",
    },
    {
      title: "Text",
      value: "Text",
    },
    {
      title: "Html",
      value: "Html",
    },
    {
      title: "Multiline Text",
      value: "MultilineText",
    },
    {
      title: "Email Address",
      value: "EmailAddress",
    },
    {
      title: "Password",
      value: "Password",
    },
    {
      title: "Url",
      value: "Url",
    },
    {
      title: "Image Url",
      value: "ImageUrl",
    },
    {
      title: "Credit Card",
      value: "CreditCard",
    },
    {
      title: "PostalCode",
      value: "PostalCode",
    },
    {
      title: "Upload",
      value: "Upload",
    },
    {
      title: "Color",
      value: "Color",
    },
    {
      title: "Boolean",
      value: "Boolean",
    },
    {
      title: "Icon",
      value: "Icon",
    },
    {
      title: "Video Youtube",
      value: "VideoYoutube",
    },
    {
      title: "Tui Editor",
      value: "TuiEditor",
    },
    {
      title: "Integer",
      value: "Integer",
    },
    {
      title: "QR Code",
      value: "QRCode",
    },
    {
      title: "Reference",
      value: "Reference",
    },
  ],
  icons: [],
});
appShared.run([
  "$http",
  "$rootScope",
  "ngAppSettings",
  "$location",
  "BaseRestService",
  "ApiService",
  "CommonService",
  "AuthService",
  "TranslatorService",
  function (
    $http,
    $rootScope,
    ngAppSettings,
    $location,
    baseRestService,
    apiService,
    commonService,
    authService,
    translatorService
  ) {
    $rootScope.currentContext = $rootScope;
    $rootScope.isBusy = false;
    $rootScope.translator = translatorService;
    $rootScope.errors = [];
    $rootScope.breadCrumbs = [];
    $rootScope.message = {
      title: "",
      content: "",
      errors: [],
      okFuncName: null,
      okArgs: [],
      cancelFuncName: null,
      cancelArgs: [],
      lblOK: "OK",
      lblCancel: "Cancel",
      context: $rootScope,
    };

    $rootScope.isBusy = false;
    $rootScope.translator = translatorService;
    $rootScope.message = {
      title: "test",
      content: "",
      errors: [],
      okFuncName: null,
      okArgs: [],
      cancelFuncName: null,
      cancelArgs: [],
      lblOK: "OK",
      lblCancel: "Cancel",
      context: $rootScope,
    };
    $rootScope.range = function (max) {
      var input = [];
      for (var i = 1; i <= max; i += 1) input.push(i);
      return input;
    };

    $rootScope.generateKeyword = function (
      src,
      character,
      isCamelCase = false,
      isLowerFirst = false
    ) {
      if (src) {
        src = $rootScope.parseUnsignString(src);

        if (isCamelCase) {
          src = src
            .replace(/\w\S*/g, function (txt) {
              return txt.charAt(0).toUpperCase() + txt.substr(1).toLowerCase();
            })
            .replace(/[^a-zA-Z0-9]+/g, "");

          if (isLowerFirst) {
            src = src.replace(/^./, (str) => str.toLowerCase()); // first to lowercase
          }
        } else {
          src = src
            .replace(/[^a-zA-Z0-9]+/g, character)
            .replace(/([A-Z]+)([A-Z][a-z])/g, "$1-$2")
            .replace(/([a-z])([A-Z])/g, "$1-$2")
            // .replace(/([0-9])([^0-9])/g, "$1-$2")
            // .replace(/([^0-9])([0-9])/g, "$1-$2")
            .replace(/-+/g, character)
            .toLowerCase();
        }

        return src;
      }
    };

    $rootScope.generatePhone = function (src) {
      return src.replace(/^([0-9]{3})([0-9]{3})([0-9]{4})$/, "($1) $2-$3");
    };
    $rootScope.parseUnsignString = function (str) {
      str = str.replace(/à|á|ạ|ả|ã|â|ầ|ấ|ậ|ẩ|ẫ|ă|ằ|ắ|ặ|ẳ|ẵ/g, "a");
      str = str.replace(/è|é|ẹ|ẻ|ẽ|ê|ề|ế|ệ|ể|ễ/g, "e");
      str = str.replace(/ì|í|ị|ỉ|ĩ/g, "i");
      str = str.replace(/ò|ó|ọ|ỏ|õ|ô|ồ|ố|ộ|ổ|ỗ|ơ|ờ|ớ|ợ|ở|ỡ/g, "o");
      str = str.replace(/ù|ú|ụ|ủ|ũ|ư|ừ|ứ|ự|ử|ữ/g, "u");
      str = str.replace(/ỳ|ý|ỵ|ỷ|ỹ/g, "y");
      str = str.replace(/đ/g, "d");
      str = str.replace(/À|Á|Ạ|Ả|Ã|Â|Ầ|Ấ|Ậ|Ẩ|Ẫ|Ă|Ằ|Ắ|Ặ|Ẳ|Ẵ/g, "A");
      str = str.replace(/È|É|Ẹ|Ẻ|Ẽ|Ê|Ề|Ế|Ệ|Ể|Ễ/g, "E");
      str = str.replace(/Ì|Í|Ị|Ỉ|Ĩ/g, "I");
      str = str.replace(/Ò|Ó|Ọ|Ỏ|Õ|Ô|Ồ|Ố|Ộ|Ổ|Ỗ|Ơ|Ờ|Ớ|Ợ|Ở|Ỡ/g, "O");
      str = str.replace(/Ù|Ú|Ụ|Ủ|Ũ|Ư|Ừ|Ứ|Ự|Ử|Ữ/g, "U");
      str = str.replace(/Ỳ|Ý|Ỵ|Ỷ|Ỹ/g, "Y");
      str = str.replace(/Đ/g, "D");
      return str;
    };
    $rootScope.logOut = function () {
      authService.logOut();
    };

    $rootScope.updateSettings = function () {
      commonService.removeSettings();
      commonService
        .fillSettings($rootScope.globalSettings.lang)
        .then(function (response) {
          $rootScope.globalSettings = response;
        });
      $rootScope.isBusy = false;
    };
    $rootScope.executeFunctionByName = async function (
      functionName,
      args,
      context = window
    ) {
      if (functionName !== null) {
        var namespaces = functionName.split(".");
        var func = namespaces.pop();
        for (var i = 0; i < namespaces.length; i++) {
          context = context[namespaces[i]];
        }
        functionName = null;
        return context[func].apply(this, args);
      }
    };

    $rootScope.showConfirm = function (
      context,
      okFuncName,
      okArgs,
      cancelFuncName,
      title,
      msg,
      cancelArgs,
      lblOK,
      lblCancel
    ) {
      $rootScope.confirmMessage = {
        title: title,
        content: msg,
        context: context,
        okFuncName: okFuncName,
        okArgs: okArgs,
        cancelFuncName: cancelFuncName,
        cancelArgs: cancelArgs,
        lblOK: lblOK ? lblOK : "OK",
        lblCancel: lblCancel ? lblCancel : "Cancel",
      };

      $("#dlg-confirm-msg").modal("show");
    };

    $rootScope.preview = function (type, data, title, size, objClass) {
      $rootScope.previewObject = {
        title: title || "Preview",
        size: size || "modal-md",
        objClass: objClass,
        type: type,
        data: data,
      };
      $("#dlg-preview-popup").modal("show");
    };

    $rootScope.initEditors = function () {
      setTimeout(function () {
        $.each($(".code-editor"), function (i, e) {
          var container = $(this);
          var editor = ace.edit(e);
          if (container.hasClass("json")) {
            editor.session.setMode("ace/mode/json");
          } else {
            editor.session.setMode("ace/mode/razor");
          }
          editor.setTheme("ace/theme/chrome");
          //editor.setReadOnly(true);
          editor.$blockScrolling = Infinity;
          editor.session.setUseWrapMode(true);
          editor.setOptions({
            maxLines: Infinity,
          });
          editor.getSession().on("change", function (e) {
            // e.type, etc
            $(container).parent().find(".code-content").val(editor.getValue());
          });
        });
      }, 200);
    };

    $rootScope.showErrors = function (errors) {
      if (errors.length) {
        $.each(errors, function (i, e) {
          $rootScope.showMessage(e, "danger");
        });
      } else {
        $rootScope.showMessage("Server Errors", "danger");
      }
    };
    $rootScope.shortString = function (msg, max) {
      var data = decodeURIComponent(msg);
      if (data) {
        if (max < data.length) {
          return data.replace(/[+]/g, " ").substr(0, max) + " ...";
        } else {
          return data.replace(/[+]/g, " ");
        }
      }
    };
    $rootScope.showMessage = function (content, type) {
      // $rootScope.toast = new  bootstrap.Toast(document.getElementById('toast-msg'));
      // $rootScope.toastMsg= content;
      // $rootScope.toast.show();
      var from = "bottom";
      var align = "right";
      if ($ && $.notify) {
        $.notify(
          {
            icon: "fas fa-bell",
            message: $rootScope.translate(content),
          },
          {
            type: type,
            timer: 2000,
            placement: {
              from: from,
              align: align,
            },
          }
        );
      } else {
        console.log(content);
      }
    };
    $rootScope.encrypt = function (message) {
      var keySize = 256;
      var ivSize = 128;
      var iterations = 100;
      var salt = CryptoJS.lib.WordArray.random(128 / 8);
      var pass = "secret-key";
      var key = CryptoJS.PBKDF2(pass, salt, {
        keySize: keySize / 32,
        iterations: iterations,
      });

      var iv = CryptoJS.lib.WordArray.random(ivSize / 8);

      var options = {
        mode: CryptoJS.mode.CBC,
        padding: CryptoJS.pad.Pkcs7,
        iv: iv,
      };
      var encrypted = CryptoJS.AES.encrypt(message, key, options);
      return {
        key: key.toString(CryptoJS.enc.Base64),
        iv: iv.toString(CryptoJS.enc.Base64),
        data: encrypted.ciphertext.toString(CryptoJS.enc.Base64),
      };
    };
    $rootScope.decrypt = function (encryptedData) {
      var ivSize = 128;
      var cipherParams = CryptoJS.lib.CipherParams.create({
        ciphertext: CryptoJS.enc.Base64.parse(encryptedData.data),
      });
      var key = CryptoJS.enc.Base64.parse(encryptedData.key);
      var iv = CryptoJS.lib.WordArray.random(ivSize / 8);
      var options = {
        mode: CryptoJS.mode.CBC,
        padding: CryptoJS.pad.Pkcs7,
        iv: iv,
      };

      var decrypted = CryptoJS.AES.decrypt(cipherParams, key, options);
      return decrypted.toString(CryptoJS.enc.Utf8);
    };

    $rootScope.ajaxSubmitForm = async function (form, url) {
      var req = {
        serviceBase: this.serviceBase,
        method: "POST",
        url: url,
        headers: {
          "Content-Type": undefined,
        },
        contentType: false, // Not to set any content header
        processData: false, // Not to process data
        data: form,
      };
      return await apiService.getApiResult(req);
    };

    $rootScope.translate = function (keyword, isWrap, defaultText) {
      if ($rootScope.globalSettings && $rootScope.translator) {
        return (
          $rootScope.translator.get(keyword, isWrap, defaultText) || keyword
        );
      } else {
        return keyword || defaultText;
      }
    };

    $rootScope.getConfiguration = function (keyword, isWrap, defaultText) {
      if (
        $rootScope.globalSettings &&
        ($rootScope.globalSettingsService || $rootScope.isBusy)
      ) {
        return $rootScope.globalSettingsService.get(
          keyword,
          isWrap,
          defaultText
        );
      } else {
        return keyword || defaultText;
      }
    };

    $rootScope.waitForInit = async function (functionName, args, scope) {
      if (!$rootScope.isInit) {
        () => {
          setTimeout(() => {
            $rootScope.waitForInit(functionName, args, scope);
          }, 200);
        };
      } else {
        $rootScope.executeFunctionByName(functionName, args, scope);
      }
    };

    $rootScope.$watch("isBusy", function (newValue, oldValue) {
      if (newValue) {
        $rootScope.message.content = "";
        $rootScope.errors = [];
      }
    });
    $rootScope.generateUUID = function () {
      // Public Domain/MIT
      var d = new Date().getTime();
      if (
        typeof performance !== "undefined" &&
        typeof performance.now === "function"
      ) {
        d += performance.now(); //use high-precision timer if available
      }
      return "xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(
        /[xy]/g,
        function (c) {
          var r = (d + Math.random() * 16) % 16 | 0;
          d = Math.floor(d / 16);
          return (c === "x" ? r : (r & 0x3) | 0x8).toString(16);
        }
      );
    };
    $rootScope.filterArray = function (array, keys, values) {
      var result = [];
      if (array) {
        for (var i = 0; i < array.length; i++) {
          var matched = true;
          for (var j = 0; j < keys.length; j++) {
            if (array[i][keys[j]] !== values[j]) {
              matched = false;
              break;
            }
          }
          if (matched) {
            result.push(array[i]);
          }
        }
      }
      return result;
    };
    $rootScope.findObjectByKey = function (array, key, value) {
      if (array) {
        if (Array.isArray(key)) {
          for (var i = 0; i < array.length; i++) {
            var isMatch = true;
            angular.forEach(key, function (e, j) {
              isMatch = array[i][key[j]] == value[j];
            });
            if (isMatch) {
              return array[i];
            }
          }
        } else {
          for (var i = 0; i < array.length; i++) {
            if (array[i][key] == value) {
              return array[i];
            }
          }
        }
      }
      return null;
    };
    $rootScope.removeObjectByKey = function (array, key, value) {
      if (Array.isArray(key)) {
        for (var i = 0; i < array.length; i++) {
          var isMatch = true;
          angular.forEach(key, function (e, j) {
            isMatch = array[i][key[j]] == value[j];
          });
          if (isMatch) {
            array.splice(i, 1);
            break;
          }
        }
      } else {
        for (var i = 0; i < array.length; i++) {
          if (array[i][key] == value) {
            array.splice(i, 1);
            break;
          }
        }
      }
      for (var i = 0; i < array.length; i++) {
        if (array[i][key] == value) {
          array.splice(i, 1);
          break;
        }
      }
    };

    $rootScope.changeLang = async function (lang) {
      var url = await translatorService.translateUrl(lang);
      translatorService.translateUrl(lang);
      window.top.location = url;
    };
    // upload on file select or drop
    $rootScope.upload = function (file, url) {
      Upload.upload({
        url: "upload/url",
        data: {
          file: file,
          username: $scope.username,
        },
      }).then(
        function (resp) {
          console.log(
            "Success " +
              resp.config.data.file.name +
              "uploaded. Response: " +
              resp.data
          );
        },
        function (resp) {
          console.log("Error status: " + resp.status);
        },
        function (evt) {
          var progressPercentage = parseInt((100.0 * evt.loaded) / evt.total);
          console.log(
            "progress: " + progressPercentage + "% " + evt.config.data.file.name
          );
        }
      );
    };
    $rootScope.goToSiteUrl = function (url) {
      window.top.location = url;
    };
    $rootScope.goToPath = function (url) {
      $location.url(url.trim());
    };
    $rootScope.encryptMixDatabase = function (attributes, data) {
      angular.forEach(attributes, function (attr) {
        if (attr.isEncrypt) {
          angular.forEach(data, function (item) {
            var columnData = $rootScope.findObjectByKey(
              item.data,
              "attributeName",
              attr.name
            );
            if (columnData) {
              var encryptedData = $rootScope.encrypt(columnData.stringValue);
              columnData.encryptValue = encryptedData.data;
              columnData.encryptKey = encryptedData.key;
              columnData.stringValue = "";
            }
          });
        }
      });
    };
    $rootScope.decryptMixDatabase = function (attributes, data) {
      angular.forEach(attributes, function (attr) {
        if (attr.isEncrypt) {
          angular.forEach(data, function (item) {
            var columnData = $rootScope.findObjectByKey(
              item.data,
              "attributeName",
              attr.name
            );
            if (columnData) {
              var encryptedData = {
                key: columnData.encryptKey,
                data: columnData.encryptValue,
              };
              columnData.stringValue = $rootScope.decrypt(encryptedData);
            }
          });
        }
      });
    };
    $rootScope.testJSON = function (obj) {
      if (typeof obj === "object" && obj !== null) {
        return obj;
      }
      if (typeof obj !== "string") {
        return false;
      }
      try {
        return JSON.parse(obj);
      } catch (error) {
        return false;
      }
    };
    $rootScope.getRestService = function (modelName, isGlobal, lang) {
      var serviceFactory = angular.copy(baseRestService);
      serviceFactory.init(modelName, isGlobal, lang);
      return serviceFactory;
    };
    $rootScope.showLogin = function (req, type = null) {
      $rootScope.isBusy = false;
      $rootScope.loginCallbackRequest = req;
      $rootScope.loginCallbackType = type;

      // window.top.location.href = "/security/login";
      $("#login-popup").modal("show");
    };
    $rootScope.isInRoles = function (roleNames) {
      for (let index = 0; index < roleNames.length; index++) {
        const roleName = roleNames[index];
        if (authService.isInRole(roleName)) {
          return true;
        }
      }
      return false;
    };

    $rootScope.isInRole = function (roleName) {
      return authService.isInRole(roleName);
    };
    $rootScope.showContentFilter = function (callback) {
      $rootScope.contentFilterCallback = callback;
      $("#modal-content-filter").modal("show");
    };

    $rootScope.updateOrders = function (index, minIndex, items) {
      items.splice(index, 1);
      for (var i = 0; i < items.length; i++) {
        items[i].priority = minIndex + i;
      }
    };

    $rootScope.showHelper = function (url) {
      $rootScope.helperUrl = url;
      $("#dev-helper-modal").modal("show");
    };

    $rootScope.openModal = function (
      templateUrl,
      controllerName,
      resolve,
      size = "lg",
      successCallback = null,
      failCallback = null
    ) {
      var modalInstance = $uibModal.open({
        animation: true,
        windowClass: "show",
        templateUrl: templateUrl,
        controller: controllerName,
        controllerAs: "$ctrl",
        size: size,
        resolve: resolve,
      });

      modalInstance.result.then(
        function (result) {
          successCallback(result);
        },
        function (error) {
          failCallback(error);
        }
      );
    };

    $rootScope.isImage = function (file) {
      let ext = file.name.substring(file.name.lastIndexOf("."));
      return ext
        .toLowerCase()
        .match(/([/|.|\w|\s|-])*\.(?:jpg|jpeg|gif|png|svg)/g);
    };
  },
]);

"use strict";
appShared
  .directive("ngEnter", function () {
    return function (scope, element, attrs) {
      element.bind("keydown keypress", function (event) {
        if (event.which === 13) {
          scope.$apply(function () {
            scope.$eval(attrs.ngEnter);
          });

          event.preventDefault();
        }
      });
    };
  })
  .directive("ngScroll", function () {
    return function (scope, element, attrs) {
      element.bind("scroll", function (event) {
        scope.$apply(function () {
          scope.$eval(attrs.ngScroll);
        });
        event.preventDefault();
      });
    };
  })
  .directive("file", function () {
    return {
      scope: {
        file: "=",
        files: "=",
      },
      link: function (scope, el, attrs) {
        el.bind("change", function (event) {
          var files = event.target.files;
          var file = files[0];
          scope.file = file;
          scope.files = files;
          scope.$apply();
        });
      },
    };
  })
  .directive("imageonload", function () {
    return {
      restrict: "A",
      link: function (scope, element, attrs) {
        element.bind("load", function () {});
        element.bind("error", function () {});
      },
    };
  });

"use strict";
appShared
  .filter("trim", trimString)
  .filter("utcToLocal", FilterUtcDate)
  .filter("utcToLocalTime", FilterUtcDateTime)
  .filter("phoneNumber", FilterPhoneNumber)
  .filter("money", FilterMoney)
  .filter("markdown", MarkdownToHtml)
  .filter("trustUrl", trustUrl)
  .filter("trustHtml", trustHtml)
  .constant("ngAppSettings", {
    serviceBase: "",
    clientId: "ngAuthApp",
    facebookAppId: "",
    request: {
      pageSize: "20",
      pageIndex: 0,
      status: "Published",
      orderBy: "CreatedDateTime",
      direction: "Desc",
      fromDate: null,
      toDate: null,
      keyword: "",
      key: "",
      query: "{}",
    },
    privacies: ["VND", "USD"],
    pageSizes: ["5", "10", "15", "20"],
    directions: [
      {
        value: "0",
        title: "Asc",
      },
      {
        value: "1",
        title: "Desc",
      },
    ],
    orders: [
      {
        value: "CreatedDateTime",
        title: "Created Date",
      },
      {
        value: "Priority",
        title: "Priority",
      },

      {
        value: "Title",
        title: "Title",
      },
    ],
    contentStatuses: ["Deleted", "Preview", "Published", "Draft", "Schedule"],
    dataTypes: [
      { title: "Custom", value: 0 },
      { title: "DateTime", value: 1 },
      { title: "Date", value: 2 },
      { title: "Time", value: 3 },
      { title: "Duration", value: 4 },
      { title: "PhoneNumber", value: 5 },
      { title: "Currency", value: 6 },
      { title: "Text", value: 7 },
      { title: "Html", value: 8 },
      { title: "MultilineText", value: 9 },
      { title: "EmailAddress", value: 10 },
      { title: "Password", value: 11 },
      { title: "Url", value: 12 },
      { title: "ImageUrl", value: 13 },
      { title: "CreditCard", value: 14 },
      { title: "PostalCode", value: 15 },
      { title: "Upload", value: 16 },
    ],
  });

function trustUrl($sce) {
  return (url) => $sce.trustAsResourceUrl(url);
}

function trustHtml($sce) {
  return (html) => $sce.trustAsHtml(html);
}

function MarkdownToHtml($filter) {
  return function (mdContent) {
    var converter = new showdown.Converter();
    return converter.makeHtml(mdContent);
  };
}

function trimString() {
  return function (content, length = 150) {
    return content.length > length
      ? `${content.substring(0, length)}...`
      : content;
  };
}

function FilterUtcDate($filter) {
  return function (utcDateString, format) {
    format = format || "MM.dd.yyyy - hh:mm:ss a";
    // return if input date is null or undefined
    if (!utcDateString) {
      return;
    }

    // append 'Z' to the date string to indicate UTC time if the timezone isn't already specified
    if (
      typeof utcDateString == "string" &&
      utcDateString.indexOf("Z") === -1 &&
      utcDateString.indexOf("+") === -1
    ) {
      utcDateString += "Z";
    }

    // convert and format date using the built in angularjs date filter
    return $filter("date")(utcDateString, format);
  };
}
function FilterUtcDateTime($filter) {
  return function (utcDateString, format) {
    format = format || "yyyy-MM-ddThh:mm";
    // return if input date is null or undefined
    if (!utcDateString) {
      return;
    }

    // append 'Z' to the date string to indicate UTC time if the timezone isn't already specified
    if (
      typeof utcDateString == "string" &&
      utcDateString.indexOf("Z") === -1 &&
      utcDateString.indexOf("+") === -1
    ) {
      utcDateString += "Z";
    }

    // convert and format date using the built in angularjs date filter
    return $filter("date")(utcDateString, format);
  };
}
function buildDropdown(trumbowyg) {
  var dropdown = [];

  $.each(trumbowyg.o.plugins.fontfamily.fontList, function (index, font) {
    trumbowyg.addBtnDef("fontfamily_" + index, {
      title:
        '<span style="font-family: ' +
        font.family +
        ';">' +
        font.name +
        "</span>",
      hasIcon: false,
      fn: function () {
        trumbowyg.execCmd("fontName", font.family, true);
      },
    });
    dropdown.push("fontfamily_" + index);
  });

  return dropdown;
}
function FilterPhoneNumber() {
  return function (phone) {
    return phone.replace(/^([0-9]{3})([0-9]{3})([0-9]{4,})$/, "($1) $2-$3");
  };
}

function FilterMoney() {
  return function (money) {
    if (money) {
      return money.toString().replace(/(\d)(?=(\d{3})+(?!\d))/g, "$1,");
    }
  };
}

"use strict";
appShared.factory("ApiService", [
  "$location",
  "$http",
  "$q",
  "$rootScope",
  "localStorageService",
  "CryptoService",
  "AppSettings",
  function (
    $location,
    $http,
    $q,
    $rootScope,
    localStorageService,
    cryptoService,
    appSettings
  ) {
    var factory = {};

    var _refreshToken = async function () {
      let _authentication = await _fillAuthData();
      let data = {
        refreshToken: _authentication.refresh_token,
        accessToken: _authentication.access_token,
      };
      if (_authentication) {
        var apiUrl = `/account/refresh-token`;
        var req = {
          method: "POST",
          url: apiUrl,
          data: JSON.stringify(data),
        };
        var resp = await _getApiResult(req);
        if (resp.isSucceed) {
          let encryptedData = resp.data;
          return _updateAuthData(encryptedData);
        } else {
          _logOut();
        }
      } else {
        _logOut();
      }
    };

    var _fillAuthData = async function () {
      var encryptedAuthData = localStorageService.get("authorizationData");

      if (encryptedAuthData) {
        return JSON.parse(
          cryptoService.decryptAES(encryptedAuthData.data, encryptedAuthData.k)
        );
      }
      return {};
    };

    var _updateAuthData = async function (encryptedData) {
      localStorageService.set("authorizationData", encryptedData);
    };

    var _getAllSettings = async function (culture) {
      var settings = localStorageService.get("localizeSettings");
      var globalSettings = localStorageService.get("globalSettings");
      var translator = localStorageService.get("translator");
      if (
        settings &&
        globalSettings &&
        translator &&
        settings.lang === culture
      ) {
        $rootScope.localizeSettings = settings;
        $rootScope.globalSettings = globalSettings;
        $rootScope.translator.translator = translator;
      } else {
        var url = "/rest/shared";
        if (culture) {
          url += "/" + culture;
        }
        url += "/get-shared-settings";
        var req = {
          method: "GET",
          url: url,
        };
        return _getRestApiResult(req).then(function (response) {
          response.data.globalSettings.lastUpdateConfiguration = new Date();
          localStorageService.set(
            "localizeSettings",
            response.data.localizeSettings
          );
          localStorageService.set(
            "globalSettings",
            response.data.globalSettings
          );
          localStorageService.set("translator", response.data.translator);
          $rootScope.localizeSettings = response.data.localizeSettings;
          $rootScope.globalSettings = response.data.globalSettings;
          $rootScope.translator.translator = response.data.translator;
        });
      }
    };

    var _initAllSettings = async function (culture) {
      localStorageService.remove("localizeSettings");
      localStorageService.remove("translator");
      localStorageService.remove("globalSettings");

      var response = await _getAllSettings();
      if (response) {
        localStorageService.set("localizeSettings", response.localizeSettings);
        localStorageService.set("translator", response.translator);
        localStorageService.set("globalSettings", response.globalSettings);
      }
      return response;
    };

    var _sendRestRequest = async function (
      req,
      retry = true,
      skipAuthorize = false
    ) {
      var defer = $q.defer();
      req.uploadEventHandlers = {
        progress: function (e) {
          defer.notify((e.loaded * 100) / e.total);
        },
      };
      if (!req.headers) {
        req.headers = {
          "Content-Type": "application/json",
        };
      }

      if (!skipAuthorize) {
        let _authentication = await _fillAuthData();
        req.headers.Authorization = `Bearer ${_authentication.access_token}`;
      }

      return $http(req).then(
        function (resp) {
          if (
            req.url.indexOf("settings") == -1 &&
            (!$rootScope.localizeSettings ||
              $rootScope.localizeSettings.lastUpdateConfiguration <
                resp.data.lastUpdateConfiguration)
          ) {
            _initAllSettings();
          }

          return { isSucceed: true, data: resp.data };
        },
        async function (error) {
          if (error.status === 401 && retry) {
            return _refreshToken().then(() =>
              _sendRestRequest(req, false, skipAuthorize)
            );
          } else if (
            error.status === 200 ||
            error.status === 204 ||
            error.status === 205
          ) {
            return {
              isSucceed: true,
              status: err.status,
              errors: [error.statusText || error.status],
            };
          } else {
            if (error.data) {
              return { isSucceed: false, errors: [error.data] };
            } else {
              return {
                isSucceed: false,
                errors: [error.statusText || error.status],
              };
            }
          }
        },
        function (progress) {
          console.log("uploading: " + Math.floor(progress) + "%");
        }
      );
    };

    var _sendRequest = async function (
      req,
      retry = true,
      skipAuthorize = false,
      onUploadFileProgress = null
    ) {
      if (!req.headers) {
        req.headers = {
          "Content-Type": "application/json",
        };
      }

      if (!skipAuthorize) {
        var _authentication = await _fillAuthData();
        req.headers.Authorization = `Bearer ${_authentication.access_token}`;
      }
      if (onUploadFileProgress) {
        req.uploadEventHandlers = {
          progress: (e) => _progressHandler(e),
        };
      }
      return $http(req).then(
        function (resp) {
          if (
            req.url.indexOf("localizeSettings") == -1 &&
            (!$rootScope.localizeSettings ||
              $rootScope.localizeSettings.lastUpdateConfiguration <
                resp.data.lastUpdateConfiguration)
          ) {
            _initAllSettings();
          }

          return resp.data;
        },
        async function (error) {
          if (error.status === 401) {
            //Try again with new token from previous Request (optional)
            if (retry) {
              return _refreshToken().then(() =>
                _sendRequest(req, false, skipAuthorize, onUploadFileProgress)
              );
            } else {
              return {
                isSucceed: false,
                errors: [error.statusText || error.status],
              };
            }
          } else if (error.status === 403) {
            var t = { isSucceed: false, errors: ["Forbidden"] };
            $rootScope.showLogin(req, "rest");
            // window.top.location.href = '/security/login';
            return t;
          } else {
            if (error.data) {
              return error.data;
            } else {
              return {
                isSucceed: false,
                errors: [error.statusText || error.status],
              };
            }
          }
        },
        function (progress) {
          console.log("uploading: " + Math.floor(progress) + "%");
        }
      );
    };

    var _progressHandler = function (e) {
      if (e.lengthComputable) {
        progress = Math.round((e.loaded * 100) / e.total);
        onUploadFileProgress(progress);
        console.log("progress: " + progress + "%");
        if (e.loaded == e.total) {
          console.log("File upload finished!");
          console.log("Server will perform extra work now...");
        }
      }
    };

    var _getApiResult = async function (
      req,
      retry = true,
      skipAuthorize = false,
      serviceBase,
      onUploadFileProgress = null
    ) {
      var serviceUrl =
        appSettings.serviceBase + "/api/" + appSettings.apiVersion;
      if (serviceBase || req.serviceBase) {
        serviceUrl =
          (serviceBase || req.serviceBase) + "/api/" + appSettings.apiVersion;
      }

      req.url = serviceUrl + req.url;
      if (!req.headers) {
        req.headers = {
          "Content-Type": "application/json",
        };
      }
      req.headers.Authorization = "Bearer " + req.Authorization || "";
      return _sendRequest(req, retry, skipAuthorize, onUploadFileProgress).then(
        function (resp) {
          return resp;
        }
      );
    };

    var _getRestApiResult = async function (
      req,
      retry = true,
      skipAuthorize = false,
      serviceBase
    ) {
      var serviceUrl =
        appSettings.serviceBase + "/api/" + appSettings.apiVersion;
      if (serviceBase || req.serviceBase) {
        serviceUrl =
          (serviceBase || req.serviceBase) + "/api/" + appSettings.apiVersion;
      }
      req.url = serviceUrl + req.url;
      return _sendRestRequest(req, retry, skipAuthorize);
    };
    var _logOut = async function () {
      localStorageService.remove("authorizationData");
      window.top.location.href = "/security/login";
      //   var apiUrl = "/account/logout";
      //   var req = {
      //     method: "GET",
      //     url: apiUrl,
      //   };
      //   localStorageService.remove("authorizationData");
      //   var resp = await _getRestApiResult(req, false);
      //   if (resp.isSucceed) {
      //     window.top.location.href = "/security/login";
      //   }
    };
    var _getAnonymousApiResult = async function (req) {
      $rootScope.isBusy = true;
      var serviceUrl =
        appSettings.serviceBase + "/api/" + appSettings.apiVersion;
      req.url = serviceUrl + req.url;
      req.headers = {
        "Content-Type": "application/json",
      };
      return $http(req).then(
        function (resp) {
          return resp.data;
        },
        function (error) {
          return {
            isSucceed: false,
            errors: [error.statusText || error.status],
          };
        }
      );
    };
    factory.initAllSettings = _initAllSettings;
    factory.getAllSettings = _getAllSettings;
    factory.refreshToken = _refreshToken;
    factory.fillAuthData = _fillAuthData;
    factory.updateAuthData = _updateAuthData;
    factory.sendRestRequest = _sendRestRequest;
    factory.sendRequest = _sendRequest;
    factory.getApiResult = _getApiResult;
    factory.getRestApiResult = _getRestApiResult;
    factory.getAnonymousApiResult = _getAnonymousApiResult;
    return factory;
  },
]);

"use strict";
appShared.factory("AuthService", [
  "$http",
  "$rootScope",
  "$routeParams",
  "$q",
  "localStorageService",
  "CryptoService",
  "ApiService",
  function (
    $http,
    $rootScope,
    $routeParams,
    $q,
    localStorageService,
    cryptoService,
    apiService
  ) {
    var authServiceFactory = {};
    var _authentication = null;

    var _saveRegistration = function (registration) {
      _logOut();

      return $http
        .post("/account/register", registration)
        .then(function (response) {
          return response;
        });
    };

    var _forgotPassword = async function (data) {
      var apiUrl = "/account/forgot-password";
      var req = {
        method: "POST",
        url: apiUrl,
        data: JSON.stringify(data),
      };
      var resp = await apiService.getRestApiResult(req);
      return resp;
    };

    var _resetPassword = async function (data) {
      var apiUrl = "/account/reset-password";
      var req = {
        method: "POST",
        url: apiUrl,
        data: JSON.stringify(data),
      };
      var resp = await apiService.getRestApiResult(req);
      return resp;
    };

    var _login = async function (loginData) {
      var data = {
        UserName: loginData.username,
        Password: loginData.password,
        RememberMe: loginData.rememberMe,
        Email: "",
        ReturnUrl: "",
      };
      var message = cryptoService.encryptAES(JSON.stringify(data));
      var apiUrl = "/account/login";
      var req = {
        method: "POST",
        url: apiUrl,
        data: JSON.stringify({ message: message }),
      };
      var resp = await apiService.getRestApiResult(req, true);
      if (resp.isSucceed) {
        let encryptedData = resp.data;
        apiService.updateAuthData(encryptedData);
        apiService.initAllSettings().then(function () {
          if ($routeParams.ReturnUrl) {
            setTimeout(() => {
              window.top.location = $routeParams.ReturnUrl;
            }, 200);
          } else if (
            document.referrer &&
            document.referrer.indexOf("init") === -1
          ) {
            setTimeout(() => {
              window.top.location = document.referrer;
            }, 200);
          } else {
            setTimeout(() => {
              window.top.location = "/";
            }, 200);
          }
        });
      } else {
        $rootScope.isBusy = false;
        $rootScope.showErrors(resp.errors);
      }
      return resp;
    };

    var _loginPopup = async function (loginData) {
      return await this.login(loginData);
    };

    var _externalLogin = async function (loginData, provider) {
      var data = {
        provider: provider,
        username: loginData.username,
        email: loginData.email,
        externalAccessToken: loginData.accessToken,
      };
      var message = cryptoService.encryptAES(JSON.stringify(data));
      var apiUrl = "/account/external-login";
      var req = {
        method: "POST",
        url: apiUrl,
        data: JSON.stringify({ message: message }),
      };
      var resp = await apiService.getRestApiResult(req, true);

      if (resp.isSucceed) {
        let encryptedData = resp.data;
        apiService.updateAuthData(encryptedData);
        apiService.initAllSettings().then(function () {
          return resp;
        });
      } else {
        $rootScope.isBusy = false;
        $rootScope.showErrors(resp.errors);
      }
      return resp;
    };

    var _logOut = async function () {
      localStorageService.remove("authorizationData");
      window.top.location.href = "/security/login";

      //     var apiUrl = "/account/logout";
      //   var req = {
      //     method: "GET",
      //     url: apiUrl,
      //   };

      //   _authentication = null;
      //   var resp = await apiService.getRestApiResult(req);
      //   if (resp.isSucceed) {
      //     window.top.location.href = "/security/login";
      //   }
    };

    var _fillAuthData = async function () {
      this.authentication = await apiService.fillAuthData();
    };

    var _refreshToken = async function (id, accessToken) {
      let data = {
        refreshToken: id,
        accessToken: accessToken,
      };
      if (id) {
        var apiUrl = `/account/refresh-token`;
        var req = {
          method: "POST",
          url: apiUrl,
          data: JSON.stringify(data),
        };
        var resp = await apiService.getApiResult(req);
        if (resp.isSucceed) {
          let encryptedData = resp.data;
          return apiService.updateAuthData(encryptedData);
        } else {
          _logOut();
        }
      } else {
        _logOut();
      }
    };

    var _isInRole = function (roleName) {
      if (!this.authentication || !this.authentication.info) {
        return false;
      }
      var role = this.authentication.info.userRoles.filter(
        (m) => m.description == roleName && m.isActived
      );
      return role.length > 0;
    };

    authServiceFactory.saveRegistration = _saveRegistration;
    authServiceFactory.isInRole = _isInRole;
    authServiceFactory.forgotPassword = _forgotPassword;
    authServiceFactory.resetPassword = _resetPassword;
    authServiceFactory.login = _login;
    authServiceFactory.externalLogin = _externalLogin;
    authServiceFactory.loginPopup = _loginPopup;
    authServiceFactory.logOut = _logOut;
    authServiceFactory.fillAuthData = _fillAuthData;
    authServiceFactory.refreshToken = _refreshToken;
    return authServiceFactory;
  },
]);

"use strict";
appShared.factory("BaseRestService", [
  "$rootScope",
  "$routeParams",
  "AppSettings",
  "AuthService",
  "ApiService",
  "CommonService",
  "localStorageService",
  function ($rootScope, $routeParams, appSettings, authService, commonService) {
    var serviceFactory = {};
    var _init = function (modelName, isGlobal, lang, serviceBase) {
      this.modelName = modelName;
      if (serviceBase) {
        this.serviceBase = serviceBase;
      }
      if (!isGlobal && isGlobal != "true") {
        if ($rootScope.localizeSettings || lang) {
          this.lang = lang || $rootScope.localizeSettings.lang;
          this.prefixUrl = `/rest/${this.lang}/${modelName}`;
        } else {
          this.prefixUrl = `/rest/${modelName}`;
        }
      } else {
        this.prefixUrl = `/rest/${modelName}`;
      }
    };

    var _duplicate = async function (params = [], queries) {
      var url = this.prefixUrl + "/duplicate";
      for (let i = 0; i < params.length; i++) {
        if (params[i] != undefined && params[i] != null) {
          url += "/" + params[i];
        }
      }
      var querystring = _parseQuery(queries);
      var req = {
        serviceBase: this.serviceBase,
        method: "GET",
        url: `${url}?${querystring}`,
      };
      return await this.getRestApiResult(req);
    };

    var _getSingle = async function (params = [], queries) {
      var url = this.prefixUrl;
      for (let i = 0; i < params.length; i++) {
        if (params[i] != undefined && params[i] != null) {
          url += "/" + params[i];
        }
      }
      var querystring = _parseQuery(queries);
      var req = {
        method: "GET",
        url: `${url}?${querystring}`,
      };
      return await this.getRestApiResult(req);
    };

    var _clearCache = async function (params = [], queries) {
      var url = this.prefixUrl;
      for (let i = 0; i < params.length; i++) {
        if (params[i] != undefined && params[i] != null) {
          url += "/remove-cache/" + params[i];
        }
      }
      var querystring = _parseQuery(queries);
      var req = {
        method: "GET",
        url: `${url}?${querystring}`,
      };
      return await this.getRestApiResult(req);
    };

    var _getDefault = async function (queriesObj) {
      var url = `${this.prefixUrl}/default`;
      var querystring = _parseQuery(queriesObj);
      var req = {
        method: "GET",
        url: `${url}?${querystring}`,
      };
      return await this.getRestApiResult(req);
    };
    var _count = async function (params = []) {
      var url = this.prefixUrl + "/count";
      for (let i = 0; i < params.length; i++) {
        if (params[i] != null) {
          url += "/" + params[i];
        }
      }
      var req = {
        method: "GET",
        url: url,
      };
      return await this.getRestApiResult(req);
    };
    var _getList = async function (objData) {
      var data = serviceFactory.parseQuery(objData);
      var url = this.prefixUrl;

      if (data) {
        url += "?";
        url = url.concat(data);
      }
      var req = {
        serviceBase: this.serviceBase,
        method: "GET",
        url: url,
      };
      return await this.getRestApiResult(req);
    };

    var _export = async function (objData) {
      var data = serviceFactory.parseQuery(objData);
      var url = this.prefixUrl + "/export";

      if (data) {
        url += "?";
        url = url.concat(data);
      }
      var req = {
        serviceBase: this.serviceBase,
        method: "GET",
        url: url,
      };
      return await this.getRestApiResult(req);
    };

    var _delete = async function (params = []) {
      var url = this.prefixUrl;
      for (let i = 0; i < params.length; i++) {
        if (params[i] != null) {
          url += "/" + params[i];
        }
      }
      var req = {
        serviceBase: this.serviceBase,
        method: "DELETE",
        url: url,
      };
      return await this.getRestApiResult(req);
    };
    var _save = async function (objData) {
      if (objData.id == 0 || objData.id == null) {
        return await this.create(objData);
      } else {
        return await this.update(objData.id, objData);
      }
    };
    var _create = async function (objData) {
      var url = this.prefixUrl;
      var req = {
        serviceBase: this.serviceBase,
        method: "POST",
        url: url,
        data: JSON.stringify(objData),
      };
      return await this.getRestApiResult(req);
    };

    var _update = async function (id, objData) {
      var url = this.prefixUrl + "/" + id;
      var req = {
        serviceBase: this.serviceBase,
        method: "PUT",
        url: url,
        data: objData,
      };
      return await this.getRestApiResult(req);
    };

    var _saveFields = async function (id, objData) {
      var url = this.prefixUrl + "/" + id;
      var req = {
        serviceBase: this.serviceBase,
        method: "PATCH",
        url: url,
        data: JSON.stringify(objData),
      };
      return await this.getRestApiResult(req);
    };

    var _saveMany = async function (models) {
      var req = {
        method: "POST",
        url: this.prefixUrl + "/save-many",
        data: JSON.stringify(models),
      };
      return await this.getRestApiResult(req);
    };

    var _applyList = async function (objData) {
      var url = this.prefixUrl + "/list-action";
      var req = {
        serviceBase: this.serviceBase,
        method: "POST",
        url: url,
        data: JSON.stringify(objData),
      };
      return await this.getRestApiResult(req);
    };

    var _ajaxSubmitForm = async function (form, url, onUploadFileProgress) {
      var req = {
        serviceBase: this.serviceBase,
        method: "POST",
        url: url,
        headers: { "Content-Type": undefined },
        contentType: false, // Not to set any content header
        processData: false, // Not to process data
        data: form,
      };
      return await this.getRestApiResult(
        req,
        this.serviceBase,
        onUploadFileProgress || _onUploadFileProgress
      );
    };

    var _parseQuery = function (req) {
      var result = "";
      if (req) {
        if (angular.isObject(req.query)) {
          req.query = JSON.stringify(req.query);
        }
        for (var key in req) {
          if (req.hasOwnProperty(key)) {
            if (result != "") {
              result += "&";
            }
            result += `${key}=${req[key]}`;
          }
        }
        return result;
      } else {
        return result;
      }
    };

    var _onUploadFileProgress = function (progress) {
      console.log(`loaded ${progress}%`);
    };

    var _getRestApiResult = async function (req, serviceBase) {
      if (!authService.authentication) {
        await authService.fillAuthData();
      }
      if (authService.authentication) {
        req.Authorization = authService.authentication.access_token;
      }

      var serviceUrl =
        appSettings.serviceBase + "/api/" + appSettings.apiVersion;
      if (serviceBase || req.serviceBase) {
        serviceUrl =
          (serviceBase || req.serviceBase) + "/api/" + appSettings.apiVersion;
      }

      req.url = serviceUrl + req.url;
      if (!req.headers) {
        req.headers = {
          "Content-Type": "application/json",
        };
      }
      req.headers.Authorization = "Bearer " + req.Authorization || "";

      return commonService.sendRestRequest(req).then(function (resp) {
        return resp;
      });
    };

    serviceFactory.lang = "";
    serviceFactory.prefixUrl = "";
    serviceFactory.init = _init;
    serviceFactory.count = _count;
    serviceFactory.duplicate = _duplicate;
    serviceFactory.applyList = _applyList;
    serviceFactory.clearCache = _clearCache;
    serviceFactory.getDefault = _getDefault;
    serviceFactory.getSingle = _getSingle;
    serviceFactory.getList = _getList;
    serviceFactory.export = _export;
    serviceFactory.create = _create;
    serviceFactory.update = _update;
    serviceFactory.save = _save;
    serviceFactory.saveFields = _saveFields;
    serviceFactory.saveMany = _saveMany;
    serviceFactory.delete = _delete;
    serviceFactory.ajaxSubmitForm = _ajaxSubmitForm;
    serviceFactory.parseQuery = _parseQuery;
    serviceFactory.getRestApiResult = _getRestApiResult;
    return serviceFactory;
  },
]);

"use strict";
appShared.factory("BaseService", [
  "$rootScope",
  "$routeParams",
  "ApiService",
  "CommonService",
  function ($rootScope, $routeParams, apiService, commonService) {
    var serviceFactory = {};

    var _init = function (modelName, isGlobal, serviceBase) {
      this.modelName = modelName;
      this.serviceBase = serviceBase;
      if (!isGlobal) {
        this.lang = $rootScope.localizeSettings.lang;
        this.prefixUrl = "/" + this.lang + "/" + modelName;
      } else {
        this.prefixUrl = "/" + modelName;
      }
    };
    var _getSingle = async function (params = []) {
      var url =
        (this.prefixUrl || "/" + this.lang + "/" + this.modelName) + "/details";
      for (let i = 0; i < params.length; i++) {
        if (params[i]) {
          url += "/" + params[i];
        }
      }
      var req = {
        method: "GET",
        serviceBase: this.serviceBase,
        url: url,
      };
      return await apiService.getApiResult(req);
    };
    var _getList = async function (objData, params = []) {
      var url = this.prefixUrl + "/list";
      for (let i = 0; i < params.length; i++) {
        url += "/" + params[i];
      }
      var req = {
        serviceBase: this.serviceBase,
        method: "POST",
        url: url,
        data: JSON.stringify(objData),
      };

      return await apiService.getApiResult(req);
    };
    var _export = async function (objData, params = []) {
      var url = this.prefixUrl + "/export";
      for (let i = 0; i < params.length; i++) {
        url += "/" + params[i];
      }
      var req = {
        serviceBase: this.serviceBase,
        method: "POST",
        url: url,
        data: JSON.stringify(objData),
      };

      return await apiService.getApiResult(req);
    };

    var _delete = async function (id) {
      var url = this.prefixUrl + "/delete/" + id;
      var req = {
        serviceBase: this.serviceBase,
        method: "GET",
        url: url,
      };
      return await apiService.getApiResult(req);
    };

    var _save = async function (objData) {
      var url = this.prefixUrl + "/save";
      var req = {
        serviceBase: this.serviceBase,
        method: "POST",
        url: url,
        data: JSON.stringify(objData),
      };
      return await apiService.getApiResult(req);
    };
    var _saveProperties = async function (objData) {
      var url = this.prefixUrl + "/save-properties";
      var req = {
        serviceBase: this.serviceBase,
        method: "POST",
        url: url,
        data: JSON.stringify(objData),
      };
      return await apiService.getApiResult(req);
    };
    var _saveList = async function (objData) {
      var url = this.prefixUrl + "/save-list";
      var req = {
        serviceBase: this.serviceBase,
        method: "POST",
        url: url,
        data: JSON.stringify(objData),
      };
      return await apiService.getApiResult(req);
    };

    var _updateInfos = async function (objData) {
      var url = this.prefixUrl + "/update-infos";
      var req = {
        serviceBase: this.serviceBase,
        method: "POST",
        url: url,
        data: JSON.stringify(objData),
      };
      return await apiService.getApiResult(req);
    };
    var _ajaxSubmitForm = async function (form, url, onUploadFileProgress) {
      var req = {
        serviceBase: this.serviceBase,
        method: "POST",
        url: url,
        headers: { "Content-Type": undefined },
        data: form,
      };
      return await apiService.getApiResult(
        req,
        this.serviceBase,
        onUploadFileProgress || _onUploadFileProgress
      );
    };

    var _applyList = async function (objData) {
      var url = this.prefixUrl + "/apply-list";
      var req = {
        serviceBase: this.serviceBase,
        method: "POST",
        url: url,
        data: JSON.stringify(objData),
      };
      return await apiService.getApiResult(req);
    };

    var _onUploadFileProgress = function (progress) {
      console.log(`loaded ${progress}%`);
    };

    serviceFactory.lang = "";
    serviceFactory.prefixUrl = "";
    serviceFactory.init = _init;
    serviceFactory.getSingle = _getSingle;
    serviceFactory.getList = _getList;
    serviceFactory.export = _export;
    serviceFactory.save = _save;
    serviceFactory.saveProperties = _saveProperties;
    serviceFactory.saveList = _saveList;
    serviceFactory.applyList = _applyList;
    serviceFactory.delete = _delete;
    serviceFactory.updateInfos = _updateInfos;
    serviceFactory.ajaxSubmitForm = _ajaxSubmitForm;
    return serviceFactory;
  },
]);

"use strict";
appShared.factory("CommonService", [
  "$rootScope",
  "ApiService",
  "localStorageService",
  function ($rootScope, apiService, localStorageService) {
    var factory = {};

    var _loadJArrayData = async function (name) {
      var req = {
        method: "GET",
        url: "/portal/jarray-data/" + name,
      };
      return await apiService.getAnonymousApiResult(req);
    };

    var _stopApplication = async function () {
      var req = {
        method: "GET",
        url: "/rest/shared/stop-application",
      };
      return await apiService.getRestApiResult(req, false, true);
    };

    var _clearCache = async function () {
      var req = {
        method: "GET",
        url: "/rest/shared/clear-cache",
      };
      return await apiService.getRestApiResult(req, false, true);
    };

    var _loadJsonData = async function (name) {
      var req = {
        method: "GET",
        url: "/portal/json-data/" + name,
      };
      return await apiService.getAnonymousApiResult(req);
    };

    var _showAlertMsg = function (title, message) {
      $rootScope.message = {
        title: title,
        value: message,
      };
      $("#modal-msg").modal("show");
    };

    var _checkfile = function (sender, validExts) {
      var fileExt = sender.value;
      fileExt = fileExt.substring(fileExt.lastIndexOf("."));
      if (validExts.indexOf(fileExt) < 0) {
        _showAlertMsg(
          "",
          "Invalid file selected, valid files are of " +
            validExts.toString() +
            " types."
        );
        sender.value = "";
        return false;
      } else return true;
    };

    var _sendMail = async function (subject, body) {
      var url = "/portal/sendmail";
      var req = {
        method: "POST",
        url: url,
        data: { subject: subject, body: body },
      };
      return apiService.getApiResult(req).then(function (response) {
        return response.data;
      });
    };

    var _getAllSettings = async function (culture) {
      var settings = localStorageService.get("localizeSettings");
      var globalSettings = localStorageService.get("globalSettings");
      var translator = localStorageService.get("translator");
      if (
        settings &&
        globalSettings &&
        translator &&
        settings.lang === culture
      ) {
        $rootScope.localizeSettings = settings;
        $rootScope.globalSettings = globalSettings;
        $rootScope.translator.translator = translator;
      } else {
        var url = "/rest/shared";
        if (culture) {
          url += "/" + culture;
        }
        url += "/get-shared-settings";
        var req = {
          method: "GET",
          url: url,
        };
        return apiService
          .getRestApiResult(req, false, true)
          .then(function (response) {
            response.data.globalSettings.lastUpdateConfiguration = new Date();
            localStorageService.set(
              "localizeSettings",
              response.data.localizeSettings
            );
            localStorageService.set(
              "globalSettings",
              response.data.globalSettings
            );
            localStorageService.set("translator", response.data.translator);
            $rootScope.localizeSettings = response.data.localizeSettings;
            $rootScope.globalSettings = response.data.globalSettings;
            $rootScope.translator.translator = response.data.translator;
          });
      }
    };

    var _checkConfig = async function (lastSync) {
      if (!lastSync) {
        _renewSettings();
      } else {
        var d = new Date(lastSync);
        d.setMinutes(d.getMinutes() + 20);
        let now = new Date();
        if (now > d) {
          _renewSettings();
        } else {
          var url = "/rest/shared/check-config/" + lastSync;
          var req = {
            method: "GET",
            url: url,
          };
          return apiService
            .getApiResult(req, true, true)
            .then(function (response) {
              if (response.data) {
                _renewSettings();
              } else {
                $rootScope.localizeSettings =
                  localStorageService.get("localizeSettings");
                $rootScope.globalSettings =
                  localStorageService.get("globalSettings");
                $rootScope.translator.translator =
                  localStorageService.get("translator");
              }
            });
        }
      }
    };

    var _renewSettings = function () {
      _removeSettings().then(() => {
        _removeTranslator().then(() => {
          _getAllSettings();
        });
      });
    };

    var _genrateSitemap = async function () {
      var url = "/portal";
      url += "/sitemap";
      var req = {
        method: "GET",
        url: url,
      };
      return apiService.getApiResult(req).then(function (response) {
        return response.data;
      });
    };

    var _getPermissions = async function () {
      var req = {
        method: "GET",
        url: "/rest/shared/permissions",
      };
      return await apiService.getRestApiResult(req);
    };

    var _initAllSettings = async function (culture) {
      localStorageService.remove("localizeSettings");
      localStorageService.remove("translator");
      localStorageService.remove("globalSettings");

      var response = await _getAllSettings();
      if (response) {
        localStorageService.set("localizeSettings", response.localizeSettings);
        localStorageService.set("translator", response.translator);
        localStorageService.set("globalSettings", response.globalSettings);
      }
      return response;
    };

    var _removeSettings = async function (settings) {
      localStorageService.remove("localizeSettings");
    };

    var _removeTranslator = async function () {
      localStorageService.remove("translator");
    };

    var _fillAllSettings = async function (culture) {
      var settings = localStorageService.get("localizeSettings");
      var globalSettings = localStorageService.get("globalSettings");
      var translator = localStorageService.get("translator");
      if (
        settings &&
        globalSettings &&
        translator &&
        (!culture || settings.lang === culture)
      ) {
        $rootScope.localizeSettings = settings;
        $rootScope.globalSettings = globalSettings;
        $rootScope.translator.translator = translator;
        await _checkConfig(globalSettings.lastUpdateConfiguration);
      } else {
        if (culture && settings && settings.lang !== culture) {
          await _removeSettings();
          await _removeTranslator();
        }
        await _getAllSettings(culture);
      }
    };

    factory.sendMail = _sendMail;
    factory.initAllSettings = _initAllSettings;
    factory.fillAllSettings = _fillAllSettings;
    factory.removeSettings = _removeSettings;
    factory.removeTranslator = _removeTranslator;
    factory.showAlertMsg = _showAlertMsg;
    factory.checkfile = _checkfile;
    factory.genrateSitemap = _genrateSitemap;
    factory.loadJArrayData = _loadJArrayData;
    factory.stopApplication = _stopApplication;
    factory.loadJsonData = _loadJsonData;
    factory.clearCache = _clearCache;
    factory.getPermissions = _getPermissions;
    return factory;
  },
]);

"use strict";
appShared.factory("CryptoService", [
  "$rootScope",
  "ngAppSettings",
  function ($rootScope, ngAppSettings) {
    var factory = {};
    //size: 128 / 192 / 256
    var size = 256;

    var _encryptAES = function (message, iCompleteEncodedKey = null) {
      var key, iv;
      ngAppSettings;
      iCompleteEncodedKey =
        iCompleteEncodedKey || $rootScope.globalSettings.apiEncryptKey;
      var keys = _parseKeys(iCompleteEncodedKey);
      key = keys.key;
      iv = keys.iv;
      return _encryptMessage(message, key, iv);
    };

    var _decryptAES = function (ciphertext, iCompleteEncodedKey = null) {
      var key, iv;
      iCompleteEncodedKey =
        iCompleteEncodedKey || $rootScope.globalSettings.apiEncryptKey;
      var keys = _parseKeys(iCompleteEncodedKey);
      key = keys.key;
      iv = keys.iv;
      return _decryptMessage(ciphertext, key, iv);
    };

    var _decryptMessage = function (ciphertext, key, iv) {
      var cipherParams = CryptoJS.lib.CipherParams.create({
        ciphertext: CryptoJS.enc.Base64.parse(ciphertext),
      });
      var options = {
        iv: iv,
        keySize: size / 8,
        mode: CryptoJS.mode.CBC,
        padding: CryptoJS.pad.Pkcs7,
      };
      var decrypted = CryptoJS.AES.decrypt(cipherParams, key, options);
      return decrypted.toString(CryptoJS.enc.Utf8);
    };

    var _encryptMessage = function (message, key, iv) {
      var options = {
        iv: iv,
        keySize: size / 8,
        mode: CryptoJS.mode.CBC,
        padding: CryptoJS.pad.Pkcs7,
      };
      if (angular.isObject(message)) {
        message = JSON.stringify(message);
      }
      var encrypted = CryptoJS.AES.encrypt(message, key, options);
      return encrypted.ciphertext.toString(CryptoJS.enc.Base64);
    };

    var _parseKeys = function (iCompleteEncodedKey) {
      var keyStrings = CryptoJS.enc.Utf8.stringify(
        CryptoJS.enc.Base64.parse(iCompleteEncodedKey)
      ).split(",");
      return {
        iv: CryptoJS.enc.Base64.parse(keyStrings[0]),
        key: CryptoJS.enc.Base64.parse(keyStrings[1]),
      };
    };

    factory.encryptAES = _encryptAES;
    factory.decryptAES = _decryptAES;
    return factory;
  },
]);

"use strict";
appShared.factory("FileService", [
  "BaseService",
  function (baseService) {
    var serviceFactory = Object.create(baseService);
    serviceFactory.init("file", true);
    return serviceFactory;
  },
]);

"use strict";
appShared.factory("GlobalSettingsService", [
  "$rootScope",
  "ApiService",
  "CommonService",
  "localStorageService",
  "AppSettings",
  function (
    $rootScope,
    apiService,
    commonService,
    localStorageService,
    appSettings
  ) {
    var factory = {};
    var _globalSettings = {
      lang: "",
      data: null,
    };
    var _fillGlobalSettings = async function (culture) {
      this.globalSettings = localStorageService.get("globalSettings");
      if (
        this.globalSettings &&
        this.globalSettings.data &&
        this.globalSettings.lang === culture
      ) {
        //_globalSettings = globalSettings;
        //this.globalSettings = globalSettings;

        return this.globalSettings;
      } else {
        this.globalSettings = await _getglobalSettings(culture);
        return this.globalSettings;
      }
    };
    var _getglobalSettings = async function (culture) {
      var globalSettings = localStorageService.get("globalSettings");
      if (globalSettings && (!culture || globalSettings.lang === culture)) {
        globalSettings = globalSettings;
        return globalSettings;
      } else {
        globalSettings = { lang: culture, data: null };
        var url = "/portal";
        if (culture) {
          url += "/" + culture;
        }
        url += "/global-settings";
        var req = {
          method: "GET",
          url: url,
        };
        var getData = await apiService.getApiResult(req);
        if (getData.isSucceed) {
          globalSettings = getData.data;
          localStorageService.set("globalSettings", globalSettings);
        }
        return globalSettings;
      }
    };
    var _reset = async function (lang) {
      localStorageService.remove("globalSettings");
      await _getglobalSettings(lang);
    };
    var _get = function (keyword, isWrap, defaultText) {
      if ($rootScope.waitForInit()) {
        if (!this.globalSettings && $rootScope.globalSettings) {
          $rootScope.isBusy = true;
          this.fillGlobalSettings($rootScope.globalSettings.lang).then(
            function (response) {
              $rootScope.isBusy = false;
              return (
                response[keyword] ||
                defaultText ||
                getLinkCreateLanguage(keyword, isWrap)
              );
            }
          );
        } else {
          return (
            this.globalSettings[keyword] ||
            defaultText ||
            getLinkCreateLanguage(keyword, isWrap)
          );
        }
      }
    };

    var _getAsync = async function (keyword, defaultText) {
      if (!this.globalSettings && $rootScope.globalSettings) {
        $rootScope.isBusy = true;
        this.globalSettings = await _fillGlobalSettings(lang);
        return (
          this.globalSettings[keyword] ||
          defaultText ||
          getLinkCreateLanguage(keyword, isWrap)
        );
      } else {
        return (
          this.globalSettings[keyword] ||
          defaultText ||
          getLinkCreateLanguage(keyword, isWrap)
        );
      }
    };

    var getLinkCreateLanguage = function (keyword, isWrap) {
      //return '<span data-key="/portal/language/details?k=' + keyword + '">[' + keyword + ']</span>';
      return isWrap ? "[" + keyword + "]" : keyword;
    };

    factory.getAsync = _getAsync;
    factory.get = _get;
    factory.reset = _reset;
    factory.globalSettings = _globalSettings;
    factory.fillGlobalSettings = _fillGlobalSettings;
    return factory;
  },
]);

"use strict";
appShared.factory("gpayService", [
  "$rootScope",
  "ngAppSettings",
  function ($rootScope, ngAppSettings) {
    var factory = {};
    /**
     * Define the version of the Google Pay API referenced when creating your
     * configuration
     *
     * @see {@link https://developers.google.com/pay/api/web/reference/request-objects#PaymentDataRequest|apiVersion in PaymentDataRequest}
     */
    const baseRequest = {
      apiVersion: 2,
      apiVersionMinor: 0,
    };

    /**
     * Card networks supported by your site and your gateway
     *
     * @see {@link https://developers.google.com/pay/api/web/reference/request-objects#CardParameters|CardParameters}
     * @todo confirm card networks supported by your site and gateway
     */
    const allowedCardNetworks = [
      "AMEX",
      "DISCOVER",
      "JCB",
      "MASTERCARD",
      "VISA",
    ];

    /**
     * Card authentication methods supported by your site and your gateway
     *
     * @see {@link https://developers.google.com/pay/api/web/reference/request-objects#CardParameters|CardParameters}
     * @todo confirm your processor supports Android device tokens for your
     * supported card networks
     */
    const allowedCardAuthMethods = ["PAN_ONLY", "CRYPTOGRAM_3DS"];

    /**
     * Identify your gateway and your site's gateway merchant identifier
     *
     * The Google Pay API response will return an encrypted payment method capable
     * of being charged by a supported gateway after payer authorization
     *
     * @todo check with your gateway on the parameters to pass
     * @see {@link https://developers.google.com/pay/api/web/reference/request-objects#gateway|PaymentMethodTokenizationSpecification}
     */
    const tokenizationSpecification = {
      type: "PAYMENT_GATEWAY",
      parameters: {
        gateway: "example",
        gatewayMerchantId: "exampleGatewayMerchantId",
      },
    };

    /**
     * Describe your site's support for the CARD payment method and its required
     * fields
     *
     * @see {@link https://developers.google.com/pay/api/web/reference/request-objects#CardParameters|CardParameters}
     */
    const baseCardPaymentMethod = {
      type: "CARD",
      parameters: {
        allowedAuthMethods: allowedCardAuthMethods,
        allowedCardNetworks: allowedCardNetworks,
      },
    };

    /**
     * Describe your site's support for the CARD payment method including optional
     * fields
     *
     * @see {@link https://developers.google.com/pay/api/web/reference/request-objects#CardParameters|CardParameters}
     */
    const cardPaymentMethod = Object.assign({}, baseCardPaymentMethod, {
      tokenizationSpecification: tokenizationSpecification,
    });

    /**
     * An initialized google.payments.api.PaymentsClient object or null if not yet set
     *
     * @see {@link getGooglePaymentsClient}
     */
    let paymentsClient = null;

    /**
     * Configure your site's support for payment methods supported by the Google Pay
     * API.
     *
     * Each member of allowedPaymentMethods should contain only the required fields,
     * allowing reuse of this base request when determining a viewer's ability
     * to pay and later requesting a supported payment method
     *
     * @returns {object} Google Pay API version, payment methods supported by the site
     */
    var _getGoogleIsReadyToPayRequest = function () {
      return Object.assign({}, baseRequest, {
        allowedPaymentMethods: [baseCardPaymentMethod],
      });
    };

    /**
     * Configure support for the Google Pay API
     *
     * @see {@link https://developers.google.com/pay/api/web/reference/request-objects#PaymentDataRequest|PaymentDataRequest}
     * @returns {object} PaymentDataRequest fields
     */
    var _getGooglePaymentDataRequest = function (
      merchantInfo,
      transactionInfo
    ) {
      const paymentDataRequest = Object.assign({}, baseRequest);
      paymentDataRequest.allowedPaymentMethods = [cardPaymentMethod];
      paymentDataRequest.transactionInfo = transactionInfo;
      paymentDataRequest.merchantInfo = merchantInfo;
      paymentDataRequest.callbackIntents = ["PAYMENT_AUTHORIZATION"];
      paymentDataRequest.emailRequired = true;
      paymentDataRequest.shippingOptionRequired = false;
      paymentDataRequest.shippingAddressRequired = false;

      return paymentDataRequest;
    };

    /**
     * Return an active PaymentsClient or initialize
     *
     * @see {@link https://developers.google.com/pay/api/web/reference/client#PaymentsClient|PaymentsClient constructor}
     * @returns {google.payments.api.PaymentsClient} Google Pay API client
     */
    var _getGooglePaymentsClient = function (
      merchantInfo,
      onPaymentAuthorized
    ) {
      if (paymentsClient === null) {
        paymentsClient = new google.payments.api.PaymentsClient({
          environment: this.environment,
          merchantInfo: merchantInfo,
          paymentDataCallbacks: {
            onPaymentAuthorized: onPaymentAuthorized,
          },
        });
      }
      return paymentsClient;
    };

    /**
     * Prefetch payment data to improve performance
     *
     * @see {@link https://developers.google.com/pay/api/web/reference/client#prefetchPaymentData|prefetchPaymentData()}
     */
    var _prefetchGooglePaymentData = function () {
      const paymentDataRequest = getGooglePaymentDataRequest();
      // transactionInfo must be set but does not affect cache
      paymentDataRequest.transactionInfo = {
        totalPriceStatus: "NOT_CURRENTLY_KNOWN",
        currencyCode: "USD",
      };
      const paymentsClient = this.getGooglePaymentsClient();
      paymentsClient.prefetchPaymentData(paymentDataRequest);
    };

    factory.prefetchGooglePaymentData = _prefetchGooglePaymentData;
    factory.getGooglePaymentsClient = _getGooglePaymentsClient;
    factory.getGooglePaymentDataRequest = _getGooglePaymentDataRequest;
    factory.getGoogleIsReadyToPayRequest = _getGoogleIsReadyToPayRequest;
    return factory;
  },
]);

"use strict";
appShared.factory("StoreService", [
  "BaseRestService",
  function (baseService) {
    var serviceFactory = Object.create(baseService);
    serviceFactory.init("", null, "en-us", "https://store.mixcore.org");
    // Define more service methods here
    var _getThemes = async function (objData) {
      var data = serviceFactory.parseQuery(objData);
      var url = "/rest/en-us/post/client";

      if (data) {
        url += "?";
        url = url.concat(data);
      }
      var req = {
        serviceBase: this.serviceBase,
        method: "GET",
        url: url,
      };
      return await this.getRestApiResult(req);
    };

    var _getCategories = async function (objData) {
      var data = serviceFactory.parseQuery(objData);
      var url = "/rest/en-us/mix-database-data/client";

      if (data) {
        url += "?";
        url = url.concat(data);
      }
      var req = {
        serviceBase: this.serviceBase,
        method: "GET",
        url: url,
      };
      return await this.getRestApiResult(req);
    };

    serviceFactory.getThemes = _getThemes;
    serviceFactory.getCategories = _getCategories;

    return serviceFactory;
  },
]);

"use strict";
appShared.factory("ThemeService", [
  "ApiService",
  "CommonService",
  "BaseRestService",
  function (apiService, commonService, baseService) {
    var serviceFactory = Object.create(baseService);
    serviceFactory.init("theme/portal");

    var _syncTemplates = async function (id) {
      var url = this.prefixUrl + "/sync/" + id;
      var req = {
        method: "GET",
        url: url,
      };
      return await apiService.getRestApiResult(req);
    };
    var _install = async function (objData) {
      var url = this.prefixUrl + "/install";
      var req = {
        method: "POST",
        url: url,
        data: JSON.stringify(objData),
      };
      return await apiService.getRestApiResult(req);
    };
    var _export = async function (id, objData) {
      var url = this.prefixUrl + "/export/" + id;
      var req = {
        method: "POST",
        url: url,
        data: JSON.stringify(objData),
      };
      return await apiService.getRestApiResult(req);
    };
    var _getExportData = async function (id) {
      var url =
        (this.prefixUrl || "/" + this.lang + "/" + this.modelName) +
        "/export/" +
        id;
      var req = {
        method: "GET",
        url: url,
      };
      return await apiService.getRestApiResult(req);
    };
    serviceFactory.install = _install;
    serviceFactory.export = _export;
    serviceFactory.syncTemplates = _syncTemplates;
    serviceFactory.getExportData = _getExportData;
    return serviceFactory;
  },
]);

"use strict";
appShared.factory("TranslatorService", [
  "$rootScope",
  "ApiService",
  "CommonService",
  "localStorageService",
  function ($rootScope, apiService, commonService, localStorageService) {
    var factory = {};
    var _translator = {
      lang: "",
      data: null,
    };
    var _init = function (translator) {
      this._translator = translator;
    };

    var _fillTranslator = async function (culture) {
      this.translator = localStorageService.get("translator");
      if (
        this.translator &&
        this.translator.data &&
        this.translator.lang === culture
      ) {
        return this.translator;
      } else {
        this.translator = await _getTranslator(culture);
        return this.translator;
      }
    };
    var _getTranslator = async function (culture) {
      var translator = localStorageService.get("translator");
      if (translator && translator.lang === culture) {
        translator = translator;
        return translator;
      } else {
        translator = { lang: culture, data: null };
        var url = "/portal";
        if (culture) {
          url += "/" + culture;
        }
        url += "/translator";
        var req = {
          method: "GET",
          url: url,
        };
        translator.lang = culture;
        var getData = await apiService.getApiResult(req);
        if (getData.isSucceed) {
          translator.data = getData.data;
          localStorageService.set("translator", translator);
        }
        return translator;
      }
    };
    var _reset = async function (lang) {
      localStorageService.remove("translator");
      await _getTranslator(lang);
    };
    var _get = function (keyword, isWrap, defaultText) {
      if (!this.translator.data && $rootScope.globalSettings) {
        $rootScope.isBusy = true;
        this.fillTranslator($rootScope.globalSettings.lang).then(function (
          response
        ) {
          $rootScope.isBusy = false;
          return (
            response.data[keyword] ||
            defaultText ||
            getLinkCreateLanguage(keyword, isWrap)
          );
        });
      } else {
        return (
          this.translator.data[keyword] ||
          defaultText ||
          getLinkCreateLanguage(keyword, isWrap)
        );
      }
    };

    var _getAsync = async function (keyword, defaultText) {
      if (!this.translator.data && $rootScope.globalSettings) {
        $rootScope.isBusy = true;
        this.translator = await _fillTranslator(lang);
        return (
          this.translator.data[keyword] ||
          defaultText ||
          getLinkCreateLanguage(keyword, isWrap)
        );
      } else {
        return (
          this.translator.data[keyword] ||
          defaultText ||
          getLinkCreateLanguage(keyword, isWrap)
        );
      }
    };

    var getLinkCreateLanguage = function (keyword, isWrap) {
      //return '<span data-key="/portal/language/details?k=' + keyword + '">[' + keyword + ']</span>';
      return isWrap ? "[" + keyword + "]" : keyword;
    };
    var _translateUrl = async function (culture) {
      var viewType = document.getElementById("view-type").value;
      var viewId = document.getElementById("view-id").value;
      var url =
        "/portal/translate-url/" + culture + "/" + viewType + "/" + viewId;
      var req = {
        method: "GET",
        url: url,
      };
      var getData = await apiService.getApiResult(req);
      return getData.data;
    };
    factory.getAsync = _getAsync;
    factory.get = _get;
    factory.init = _init;
    factory.reset = _reset;
    factory.translator = _translator;
    factory.fillTranslator = _fillTranslator;
    factory.translateUrl = _translateUrl;
    return factory;
  },
]);

"use strict";
appShared.factory("RestMixDatabasePortalService", [
  "BaseRestService",
  function (baseService) {
    var serviceFactory = Object.create(baseService);
    serviceFactory.init("mix-database/portal");
    var _migrate = async function (data) {
      var url = `${this.prefixUrl}/migrate/${data.id}`;
      var req = {
        method: "POST",
        url: url,
        data: JSON.stringify(data),
      };
      return await this.getRestApiResult(req);
    };
    serviceFactory.migrate = _migrate;
    return serviceFactory;
  },
]);

"use strict";
appShared.factory("RestMixDatabaseColumnPortalService", [
  "BaseRestService",
  "ApiService",
  "CommonService",
  function (baseService, apiService, commonService) {
    var serviceFactory = Object.create(baseService);
    serviceFactory.init("mix-database-column/portal", true);
    var _initData = async function (mixDatabaseName) {
      var url = this.prefixUrl + "/init/" + mixDatabaseName;
      var req = {
        method: "GET",
        url: url,
      };
      return await apiService.getRestApiResult(req);
    };
    serviceFactory.initData = _initData;
    return serviceFactory;
  },
]);

"use strict";
appShared.factory("RestMixDatabaseDataValuePortalService", [
  "BaseRestService",
  function (baseService) {
    var serviceFactory = Object.create(baseService);
    serviceFactory.init("mix-database-data-value/portal");
    return serviceFactory;
  },
]);

"use strict";
appShared.factory("RestMixDatabaseDataClientService", [
  "BaseRestService",
  "ApiService",
  "CommonService",
  function (baseService, apiService, commonService) {
    var serviceFactory = Object.create(baseService);
    serviceFactory.init("mix-database-data/form", false);
    var _initData = async function (mixDatabaseName) {
      var url = this.prefixUrl + "/init/" + mixDatabaseName;
      var req = {
        method: "GET",
        url: url,
      };
      return await apiService.getRestApiResult(req);
    };
    var _saveData = async function (
      mixDatabaseName,
      objData,
      sendMail = false
    ) {
      var url = `${this.prefixUrl}/save-data/${mixDatabaseName}/${sendMail}`;
      var req = {
        method: "POST",
        url: url,
        data: JSON.stringify(objData),
      };
      return await apiService.getRestApiResult(req);
    };

    var _saveValues = async function (dataId, objData) {
      var url = `${this.prefixUrl}/save-values/${dataId}`;
      var req = {
        method: "POST",
        url: url,
        data: JSON.stringify(objData),
      };
      return await apiService.getRestApiResult(req);
    };
    serviceFactory.initData = _initData;
    serviceFactory.saveData = _saveData;
    serviceFactory.saveValues = _saveValues;
    return serviceFactory;
  },
]);

"use strict";
appShared.factory("RestMixDatabaseDataPortalService", [
  "BaseRestService",
  "ApiService",
  "CommonService",
  function (baseService, apiService, commonService) {
    var serviceFactory = angular.copy(baseService);
    serviceFactory.init("mix-database-data/portal");

    var _saveAdditionalData = async function (objData) {
      var url = this.prefixUrl + "/save-additional-data";
      var req = {
        method: "POST",
        url: url,
        data: JSON.stringify(objData),
      };
      return await apiService.getRestApiResult(req);
    };

    var _getAdditionalData = async function (data) {
      var url = this.prefixUrl + "/additional-data";
      var queries = serviceFactory.parseQuery(data);
      if (queries) {
        url += "?";
        url = url.concat(queries);
      }
      var req = {
        method: "GET",
        url: url,
      };
      return await apiService.getRestApiResult(req);
    };

    var _initData = async function (mixDatabaseName) {
      var url = this.prefixUrl + "/init/" + mixDatabaseName;
      var req = {
        method: "GET",
        url: url,
      };
      return await apiService.getRestApiResult(req);
    };

    var _export = async function (objData) {
      var data = serviceFactory.parseQuery(objData);
      var url = this.prefixUrl;

      if (data) {
        url += "/export?";
        url = url.concat(data);
      }
      var req = {
        method: "GET",
        url: url,
      };
      return await apiService.getRestApiResult(req);
    };

    var _import = async function (mixDatabaseName, file) {
      var url =
        (this.prefixUrl || "/" + this.lang + "/" + this.modelName) +
        "/import-data/" +
        mixDatabaseName;
      var frm = new FormData();
      frm.append("file", file);
      return serviceFactory.ajaxSubmitForm(frm, url);
    };

    var _migrate = async function (mixDatabaseId) {
      var url = this.prefixUrl + "/migrate-data/" + mixDatabaseId;
      var req = {
        method: "GET",
        url: url,
      };
      return await apiService.getRestApiResult(req);
    };

    serviceFactory.migrate = _migrate;
    serviceFactory.initData = _initData;
    serviceFactory.getAdditionalData = _getAdditionalData;
    serviceFactory.saveAdditionalData = _saveAdditionalData;
    serviceFactory.export = _export;
    serviceFactory.import = _import;
    return serviceFactory;
  },
]);

"use strict";
appShared.factory("RestMvcModuleDataService", [
  "BaseRestService",
  function (baseService) {
    var serviceFactory = Object.create(baseService);
    serviceFactory.init("module-data/mvc");
    var _initForm = async function (moduleId) {
      var url = `${this.prefixUrl}/init-form/${moduleId}`;
      var req = {
        method: "GET",
        url: url,
      };
      return await apiService.getRestApiResult(req);
    };
    serviceFactory.initForm = _initForm;
    return serviceFactory;
  },
]);

"use strict";
appShared.factory("RestMvcPostService", [
  "BaseRestService",
  function (baseService) {
    var serviceFactory = Object.create(baseService);
    serviceFactory.init("mix-post/mvc");
    // Define more service methods here
    return serviceFactory;
  },
]);

"use strict";
appShared.factory("RestRelatedAttributeDataFormService", [
  "BaseRestService",
  function (baseService) {
    var serviceFactory = angular.copy(baseService);
    serviceFactory.init("mix-database-data-association/form");
    return serviceFactory;
  },
]);

"use strict";
appShared.factory("RestRelatedAttributeDataPortalService", [
  "BaseRestService",
  "ApiService",
  "CommonService",
  function (baseService, apiService, commonService) {
    var serviceFactory = angular.copy(baseService);
    serviceFactory.init("mix-database-data-association/portal");
    return serviceFactory;
  },
]);

"use strict";
appShared.factory("RestRelatedMixDatabasePortalService", [
  "BaseRestService",
  "ApiService",
  "CommonService",
  function (baseService, apiService, commonService) {
    var serviceFactory = Object.create(baseService);
    serviceFactory.init("related-mix-database/portal");
    return serviceFactory;
  },
]);

"use strict";

function BaseCtrl($scope, $rootScope, $routeParams, ngAppSettings, service) {
  $scope.request = angular.copy(ngAppSettings.request);
  $scope.request.query = "";
  $scope.contentStatuses = angular.copy(ngAppSettings.contentStatuses);
  $scope.viewmodel = null;
  $scope.data = null;
  $scope.isInit = false;
  $scope.isValid = true;
  $scope.errors = [];
  $scope.saveSuccessCallbackArgs = [];
  $scope.validateArgs = [];
  $scope.removeCallbackArgs = [];
  $scope.range = $rootScope.range;
  $scope.validate = null;
  $scope.getSingleSuccessCallback = null;
  $scope.getSingleFailCallback = null;
  $scope.getListSuccessCallback = null;
  $scope.getListFailCallback = null;
  $scope.saveFailCallback = null;
  $scope.selectedList = {
    action: "",
    data: [],
  };
  $scope.actions = ["Delete", "Publish", "Export"];
  $scope.translate = $rootScope.translate;
  if ($rootScope.referrerUrl) {
    $scope.referrerUrl = $rootScope.referrerUrl;
  } else {
    $scope.referrerUrl = `/portal/${service.modelName}/list`;
  }
  $scope.getSingle = async function () {
    $rootScope.isBusy = true;
    var id = $routeParams.id;
    var resp = await service.getSingle([id, "portal"]);
    if (resp && resp.isSucceed) {
      $scope.viewmodel = resp.data;
      if ($scope.getSingleSuccessCallback) {
        $scope.getSingleSuccessCallback();
      }
      $rootScope.isBusy = false;
      $scope.$apply();
    } else {
      if (resp) {
        $rootScope.showErrors(resp.errors);
      }
      if ($scope.getSingleFailCallback) {
        $scope.getSingleFailCallback();
      }
      $rootScope.isBusy = false;
      $scope.$apply();
    }
  };
  $scope.getList = async function (pageIndex) {
    if (pageIndex !== undefined) {
      $scope.request.pageIndex = pageIndex;
    }
    if ($scope.request.fromDate !== null) {
      var d = new Date($scope.request.fromDate);
      $scope.request.fromDate = d.toISOString();
    }
    if ($scope.request.toDate !== null) {
      var d = new Date($scope.request.toDate);
      $scope.request.toDate = d.toISOString();
    }
    $rootScope.isBusy = true;
    var resp = await service.getList($scope.request);
    if (resp && resp.isSucceed) {
      $scope.data = resp.data;
      $.each($scope.data.items, function (i, data) {
        $.each($scope.viewmodels, function (i, e) {
          if (e.dataId === data.id) {
            data.isHidden = true;
          }
        });
      });
      if ($scope.getListSuccessCallback) {
        $scope.getListSuccessCallback();
      }
      $("html, body").animate({ scrollTop: "0px" }, 500);
      $rootScope.isBusy = false;
      $scope.$apply();
    } else {
      if (resp) {
        $rootScope.showErrors(resp.errors);
      }
      if ($scope.getListFailCallback) {
        $scope.getListFailCallback();
      }
      $rootScope.isBusy = false;
      $scope.$apply();
    }
  };

  $scope.remove = function (id) {
    $rootScope.showConfirm(
      $scope,
      "removeConfirmed",
      [id],
      null,
      "Remove",
      "Deleted data will not able to recover, are you sure you want to delete this item?"
    );
  };

  $scope.removeConfirmed = async function (id) {
    $rootScope.isBusy = true;
    var result = await service.delete(id);
    if (result.isSucceed) {
      if ($scope.removeCallback) {
        $rootScope.executeFunctionByName(
          "removeCallback",
          $scope.removeCallbackArgs,
          $scope
        );
      }
      $scope.getList();
    } else {
      $rootScope.showMessage("failed");
      $rootScope.isBusy = false;
      $scope.$apply();
    }
  };
  $scope.applyList = async function () {
    $rootScope.showConfirm(
      $scope,
      "applyListConfirmed",
      [],
      null,
      "Remove",
      "Are you sure to " + $scope.selectedList.action + " these items"
    );
  };

  $scope.applyListConfirmed = async function () {
    $rootScope.isBusy = true;
    var resp = await service.applyList($scope.selectedList);
    if (resp && resp.isSucceed) {
      $scope.viewmodel = resp.data;
      $rootScope.showMessage("success", "success");
      switch ($scope.selectedList.action) {
        case "Delete":
          $scope.selectedList.isSelectAll = false;
          $scope.selectedList.data = [];
          $scope.getList();
          break;
        case "Export":
          window.open(resp.data.webPath, "_blank");
          $rootScope.isBusy = false;
          $scope.$apply();
          break;
      }
    } else {
      if (resp) {
        $rootScope.showErrors("Failed");
      }
      $rootScope.isBusy = false;
      $scope.$apply();
    }
  };

  $scope.save = async function (data) {
    if ($scope.validate) {
      $scope.isValid = await $rootScope.executeFunctionByName(
        "validate",
        $scope.validateArgs,
        $scope
      );
    }
    $rootScope.isBusy = true;
    $scope.viewmodel = data || $scope.viewmodel;
    if ($scope.isValid) {
      var resp = await service.save($scope.viewmodel);
      if (resp && resp.isSucceed) {
        $scope.viewmodel = resp.data;
        $rootScope.showMessage("success", "success");

        if ($scope.saveSuccessCallback) {
          $rootScope.executeFunctionByName(
            "saveSuccessCallback",
            $scope.saveSuccessCallbackArgs,
            $scope
          );
        } else {
          $rootScope.isBusy = false;
          $scope.$apply();
        }
      } else {
        if ($scope.saveFailCallback) {
          $rootScope.executeFunctionByName(
            "saveFailCallback",
            $scope.saveSuccessCallbackArgs,
            $scope
          );
        }
        if (resp) {
          $rootScope.showErrors(resp.errors);
        }
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    } else {
      $rootScope.showErrors(["invalid model"]);
      $rootScope.isBusy = false;
      $scope.$apply();
    }
  };
  $scope.select = function (id, isSelected) {
    if (isSelected) {
      $scope.selectedList.data.push(id);
    } else {
      $scope.removeObject($scope.selectedList.data, id);
    }
  };
  $scope.selectAll = function (isSelected) {
    $scope.selectedList.data = [];
    angular.forEach($scope.data.items, function (e) {
      e.isSelected = isSelected;
      if (isSelected) {
        $scope.selectedList.data.push(e.id);
      }
    });
  };
  $scope.applyList = async function () {
    $rootScope.showConfirm(
      $scope,
      "applyListConfirmed",
      [],
      null,
      "Remove",
      "Are you sure to" + $scope.selectedList.action + " these items"
    );
  };

  $scope.applyListConfirmed = async function () {
    $rootScope.isBusy = true;
    var resp = await service.applyList($scope.selectedList);
    if (resp && resp.isSucceed) {
      $scope.viewmodel = resp.data;
      $rootScope.showMessage("success", "success");
      switch ($scope.selectedList.action) {
        case "Delete":
          $scope.selectedList.isSelectAll = false;
          $scope.selectedList.data = [];
          $scope.getList();
          break;
        case "Export":
          window.open(resp.data.webPath, "_blank");
          $rootScope.isBusy = false;
          $scope.$apply();
          break;
      }
    } else {
      if (resp) {
        $rootScope.showErrors(resp.errors);
      }
      $rootScope.isBusy = false;
      $scope.$apply();
    }
  };

  $scope.shortString = function (msg, max) {
    if (msg) {
      var data = decodeURIComponent(msg);

      if (max < data.length) {
        return data.replace(/[+]/g, " ").substr(0, max) + " ...";
      } else {
        return data.replace(/[+]/g, " ");
      }
    } else {
      return "";
    }
  };

  $scope.handleResult = function (result) {
    if (result.isSucceed) {
      $rootScope.showMessage("Success");
    } else {
      $rootScope.showErrors(result.errors);
    }
  };
}

"use strict";
function BaseODataCtrl(
  $scope,
  $rootScope,
  $routeParams,
  ngAppSettings,
  service
) {
  $scope.request = angular.copy(ngAppSettings.request);
  $scope.contentStatuses = angular.copy(ngAppSettings.contentStatuses);
  $scope.viewmodel = null;
  $scope.defaultId = 0;
  $scope.data = null;
  $scope.isInit = false;
  $scope.isValid = true;
  $scope.errors = [];
  $scope.saveSuccessCallbackArgs = [];
  $scope.validateArgs = [];
  $scope.removeCallbackArgs = [];
  $scope.range = $rootScope.range;
  $scope.validate = null;
  $scope.getSingleSuccessCallback = null;
  $scope.getSingleFailCallback = null;
  $scope.getListSuccessCallback = null;
  $scope.getListFailCallback = null;
  $scope.saveFailCallback = null;
  $scope.selectedList = {
    action: "",
    data: [],
  };
  $scope.actions = ["Delete", "Publish", "Export"];
  $scope.translate = $rootScope.translate;
  if ($rootScope.referrerUrl) {
    $scope.referrerUrl = $rootScope.referrerUrl;
  } else {
    $scope.referrerUrl = "/portal"; // document.referrer.substr(document.referrer.indexOf('/portal'));
  }

  $scope.getSingle = async function (params = []) {
    $rootScope.isBusy = true;
    var id = $routeParams.id || $scope.defaultId;
    params.splice(0, 0, id);
    var resp = await service.getSingle("portal", [id]);
    if (resp) {
      $scope.viewmodel = resp;
      if ($scope.getSingleSuccessCallback) {
        $scope.getSingleSuccessCallback();
      }
      $rootScope.isBusy = false;
      $scope.$apply();
    } else {
      if (resp) {
        $rootScope.showErrors("Failed");
      }
      if ($scope.getSingleFailCallback) {
        $scope.getSingleFailCallback();
      }
      $rootScope.isBusy = false;
      $scope.$apply();
    }
  };

  $scope.count = async function (params = []) {
    $rootScope.isBusy = true;
    var resp = await service.count("read", params);
    if (resp) {
      $scope.request.totalItems = resp;
      $rootScope.isBusy = false;
      $scope.$apply();
    } else {
      if (resp) {
        $rootScope.showErrors("Failed");
      }
      $rootScope.isBusy = false;
      $scope.$apply();
    }
  };

  $scope.getList = async function (pageIndex, params = []) {
    $rootScope.isBusy = true;
    if (pageIndex !== undefined) {
      $scope.request.pageIndex = pageIndex;
    }
    if ($scope.request.fromDate !== null) {
      var d = new Date($scope.request.fromDate);
      $scope.request.fromDate = d.toISOString();
    }
    if ($scope.request.toDate !== null) {
      var d = new Date($scope.request.toDate);
      $scope.request.toDate = d.toISOString();
    }
    var resp = await service.getList("read", $scope.request, params);
    if (resp) {
      $scope.data = resp;
      $scope.count(params);
      $.each($scope.data, function (i, data) {
        $.each($scope.viewmodels, function (i, e) {
          if (e.dataId === data.id) {
            data.isHidden = true;
          }
        });
      });
      if ($scope.getListSuccessCallback) {
        $scope.getListSuccessCallback();
      }
      $("html, body").animate({ scrollTop: "0px" }, 500);
      $rootScope.isBusy = false;
      $scope.$apply();
    } else {
      if (resp) {
        $rootScope.showErrors("Failed");
      }
      if ($scope.getListFailCallback) {
        $scope.getListFailCallback();
      }
      $rootScope.isBusy = false;
      $scope.$apply();
    }
  };

  $scope.remove = function (id) {
    $rootScope.showConfirm(
      $scope,
      "removeConfirmed",
      [id],
      null,
      "Remove",
      "Deleted data will not able to recover, are you sure you want to delete this item?"
    );
  };

  $scope.removeConfirmed = async function (id) {
    $rootScope.isBusy = true;
    var result = await service.delete([id]);
    if (result.isSucceed) {
      if ($scope.removeCallback) {
        $rootScope.executeFunctionByName(
          "removeCallback",
          $scope.removeCallbackArgs,
          $scope
        );
      }
      $scope.getList();
    } else {
      $rootScope.showMessage("failed");
      $rootScope.isBusy = false;
      $scope.$apply();
    }
  };

  $scope.save = async function (data) {
    $rootScope.isBusy = true;
    if ($scope.validate) {
      $scope.isValid = await $rootScope.executeFunctionByName(
        "validate",
        $scope.validateArgs,
        $scope
      );
    }
    if ($scope.isValid) {
      var resp = await service.save("portal", data);
      if (resp.isSucceed) {
        $scope.viewmodel = resp.data;
        $rootScope.showMessage("success", "success");

        if ($scope.saveSuccessCallback) {
          $rootScope.executeFunctionByName(
            "saveSuccessCallback",
            $scope.saveSuccessCallbackArgs,
            $scope
          );
        } else {
          $rootScope.isBusy = false;
          $scope.$apply();
        }
      } else {
        if ($scope.saveFailCallback) {
          $rootScope.executeFunctionByName(
            "saveFailCallback",
            $scope.saveSuccessCallbackArgs,
            $scope
          );
        }
        if (resp) {
          $rootScope.showErrors(resp.errors);
        }
        $rootScope.isBusy = false;
        $scope.$apply();
      }
      return resp;
    } else {
      $rootScope.showErrors(["invalid model"]);
      $rootScope.isBusy = false;
      $scope.$apply();
    }
  };
  $scope.select = function (id, isSelected) {
    if (isSelected) {
      $scope.selectedList.data.push(id);
    } else {
      $scope.removeObject($scope.selectedList.data, id);
    }
  };
  $scope.selectAll = function (isSelected) {
    $scope.selectedList.data = [];
    angular.forEach($scope.data, function (e) {
      e.isSelected = isSelected;
      if (isSelected) {
        $scope.selectedList.data.push(e.id);
      }
    });
  };
  $scope.applyList = async function () {
    $rootScope.showConfirm(
      $scope,
      "applyListConfirmed",
      [],
      null,
      "Remove",
      "Are you sure to " + $scope.selectedList.action + " these items"
    );
  };

  $scope.applyListConfirmed = async function () {
    $rootScope.isBusy = true;
    var resp = await service.applyList("read", $scope.selectedList);
    if (resp && resp.isSucceed) {
      $scope.viewmodel = resp.data;
      $rootScope.showMessage("success", "success");
      switch ($scope.selectedList.action) {
        case "Delete":
          $scope.selectedList.isSelectAll = false;
          $scope.selectedList.data = [];
          $scope.getList();
          break;
        case "Export":
          window.open(resp.data.webPath, "_blank");
          $rootScope.isBusy = false;
          $scope.$apply();
          break;
      }
    } else {
      if (resp) {
        $rootScope.showErrors(resp.errors);
      }
      $rootScope.isBusy = false;
      $scope.$apply();
    }
  };

  $scope.shortString = function (msg, max) {
    if (msg) {
      var data = decodeURIComponent(msg);

      if (max < data.length) {
        return data.replace(/[+]/g, " ").substr(0, max) + " ...";
      } else {
        return data.replace(/[+]/g, " ");
      }
    } else {
      return "";
    }
  };
}

"use strict";
function BaseRestCtrl(
  $scope,
  $rootScope,
  $location,
  $routeParams,
  ngAppSettings,
  service
) {
  $scope.request = $rootScope.getRequest();
  $scope.contentStatuses = angular.copy(ngAppSettings.contentStatuses);
  $scope.viewmodel = null;

  $scope.isScrollTop = true;
  $scope.defaultId = 0;
  $scope.data = null;
  $scope.isInit = false;
  $scope.isValid = true;
  $scope.errors = [];
  $scope.saveSuccessCallbackArgs = [];
  $scope.validateArgs = [];
  $scope.removeCallbackArgs = [];
  $scope.range = $rootScope.range;
  $scope.validate = null;
  $scope.getSingleSuccessCallback = null;
  $scope.getSingleFailCallback = null;
  $scope.getListSuccessCallback = null;
  $scope.getListFailCallback = null;
  $scope.saveFailCallback = null;
  $scope.selectedList = {
    action: "",
    data: [],
  };
  $scope.actions = ["Delete", "Publish", "Export"];
  $scope.translate = $rootScope.translate;
  if ($rootScope.referrerUrl) {
    $scope.referrerUrl = $rootScope.referrerUrl;
  } else {
    $scope.referrerUrl = `/portal/${service.modelName.substr(
      0,
      service.modelName.indexOf("/")
    )}/list`; // document.referrer);
  }

  $scope.duplicate = async function (id) {
    $rootScope.isBusy = true;
    if (!id) {
      return await this.getDefault();
    } else {
      var resp = await service.duplicate([id]);
      if (resp.isSucceed) {
        $scope.goToDetail(resp.data.id, $scope.viewmodelType);
      } else {
        if (resp) {
          $rootScope.showErrors(resp.errors);
        }
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    }
  };

  $scope.goToDetail = function (id, type) {
    const url = `/portal/${type}/details/${id}`;
    window.location.href = url;
  };
  $scope.getSingle = async function (params = []) {
    $rootScope.isBusy = true;
    var id = $routeParams.id;
    if (!id) {
      return await this.getDefault();
    } else {
      params.splice(0, 0, id);
      var resp = await service.getSingle([id]);
      if (resp.isSucceed) {
        $scope.viewmodel = resp.data;
        if ($scope.getSingleSuccessCallback) {
          $scope.getSingleSuccessCallback();
        }
        $rootScope.isBusy = false;
        $scope.$apply();
      } else {
        if (resp) {
          $rootScope.showErrors(resp.errors);
        }
        if ($scope.getSingleFailCallback) {
          $scope.getSingleFailCallback();
        }
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    }
  };

  $scope.getDefault = async function () {
    $rootScope.isBusy = true;
    var resp = await service.getDefault();
    if (resp.isSucceed) {
      $scope.viewmodel = resp.data;
      if ($scope.getSingleSuccessCallback) {
        $scope.getSingleSuccessCallback();
      }
      $rootScope.isBusy = false;
      $scope.$apply();
    } else {
      if (resp) {
        $rootScope.showErrors(resp.errors);
      }
      if ($scope.getSingleFailCallback) {
        $scope.getSingleFailCallback();
      }
      $rootScope.isBusy = false;
      $scope.$apply();
    }
  };

  $scope.getList = async function (pageIndex, params = []) {
    $rootScope.isBusy = true;
    if (pageIndex !== undefined) {
      $scope.request.pageIndex = pageIndex;
    }
    if ($scope.request.fromDate !== null) {
      var d = new Date($scope.request.fromDate);
      $scope.request.fromDate = d.toISOString();
    }
    if ($scope.request.toDate !== null) {
      var dt = new Date($scope.request.toDate);
      $scope.request.toDate = dt.toISOString();
    }
    var resp = await service.getList($scope.request, params);
    if (resp && resp.isSucceed) {
      $scope.data = resp.data;
      $.each($scope.data, function (i, data) {
        $.each($scope.viewmodels, function (i, e) {
          if (e.dataId === data.id) {
            data.isHidden = true;
          }
        });
      });
      if ($scope.getListSuccessCallback) {
        $scope.getListSuccessCallback();
      }
      if ($scope.isScrollTop) {
        $("html, body").animate({ scrollTop: "0px" }, 500);
      }
      $rootScope.isBusy = false;
      $scope.$apply();
    } else {
      if (resp) {
        $rootScope.showErrors(resp.errors || ["Failed"]);
      }
      if ($scope.getListFailCallback) {
        $scope.getListFailCallback();
      }
      $rootScope.isBusy = false;
      $scope.$apply();
    }
  };

  $scope.remove = function (id) {
    $rootScope.showConfirm(
      $scope,
      "removeConfirmed",
      [id],
      null,
      "Remove",
      "Deleted data will not able to recover, are you sure you want to delete this item?"
    );
  };

  $scope.removeConfirmed = async function (id) {
    $rootScope.isBusy = true;
    var result = await service.delete([id]);
    if (result.isSucceed) {
      if ($scope.removeCallback) {
        $rootScope.executeFunctionByName(
          "removeCallback",
          $scope.removeCallbackArgs,
          $scope
        );
      }
      $scope.getList();
    } else {
      $rootScope.showMessage("failed");
      $rootScope.isBusy = false;
      $scope.$apply();
    }
  };

  $scope.save = async function () {
    $rootScope.isBusy = true;
    if ($scope.validate) {
      $scope.isValid = await $rootScope.executeFunctionByName(
        "validate",
        $scope.validateArgs,
        $scope
      );
    }
    if ($scope.isValid) {
      var resp = null;
      if ($scope.viewmodel.id == 0 || $scope.viewmodel.id == null) {
        resp = await service.create($scope.viewmodel);
      } else {
        resp = await service.update($scope.viewmodel.id, $scope.viewmodel);
      }

      if (resp.isSucceed) {
        $scope.viewmodel = resp.data;
        $rootScope.showMessage("success", "success");

        if ($scope.saveSuccessCallback) {
          $rootScope.executeFunctionByName(
            "saveSuccessCallback",
            $scope.saveSuccessCallbackArgs,
            $scope
          );
        }
      } else {
        if ($scope.saveFailCallback) {
          $rootScope.executeFunctionByName(
            "saveFailCallback",
            $scope.saveSuccessCallbackArgs,
            $scope
          );
        }
        if (resp) {
          $rootScope.showErrors(resp.errors);
        }
      }
      $rootScope.isBusy = false;
      $scope.$apply();
      return resp;
    } else {
      $rootScope.showErrors($scope.errors);
      $rootScope.isBusy = false;
      $scope.$apply();
    }
  };
  $scope.select = function (id, isSelected) {
    if (isSelected) {
      $scope.selectedList.data.push(id);
    } else {
      $scope.removeObject($scope.selectedList.data, id);
    }
  };

  $scope.selectAll = function (isSelected) {
    $scope.selectedList.data = [];
    angular.forEach($scope.data.items, function (e) {
      e.isSelected = isSelected;
      if (isSelected) {
        $scope.selectedList.data.push(e.id);
      }
    });
  };

  $scope.applyList = async function () {
    $rootScope.showConfirm(
      $scope,
      "applyListConfirmed",
      [],
      null,
      "Remove",
      "Are you sure to " + $scope.selectedList.action + " these items"
    );
  };

  $scope.applyListConfirmed = async function () {
    $rootScope.isBusy = true;
    var resp = await service.applyList($scope.selectedList);
    if (resp && resp.isSucceed) {
      $rootScope.showMessage("success", "success");
      switch ($scope.selectedList.action) {
        case "Export":
          window.top.location = resp.data.data.webPath;
          $rootScope.isBusy = false;
          $scope.$apply();
          break;
        case "Delete":
        default:
          $scope.selectedList.isSelectAll = false;
          $scope.selectedList.data = [];
          $scope.getList();
          break;
      }
    } else {
      if (resp) {
        $rootScope.showErrors(resp.errors);
      }
      $rootScope.isBusy = false;
      $scope.$apply();
    }
  };
  $scope.clearCache = async function () {
    if ($scope.viewmodel) {
      $rootScope.isBusy = true;
      var resp = await service.clearCache([$scope.viewmodel.id]);
      if (resp.isSucceed) {
        $rootScope.showMessage("success", "success");
      } else {
        $rootScope.showErrors(resp.errors);
      }
      $rootScope.isBusy = false;
      $scope.$apply();
    }
  };

  $scope.handleResult = function (result) {
    if (result.isSucceed) {
      $rootScope.showMessage("Success");
    } else {
      $rootScope.showErrors(result.errors);
    }
  };

  $scope.shortString = function (msg, max) {
    if (msg) {
      var data = decodeURIComponent(msg);

      if (max < data.length) {
        return data.replace(/[+]/g, " ").substr(0, max) + " ...";
      } else {
        return data.replace(/[+]/g, " ");
      }
    } else {
      return "";
    }
  };
}

function BaseHub(scope) {
  scope.isLog = true;
  scope.connection = null;
  scope.host = "/";
  scope.responses = [];
  scope.requests = [];
  scope.rooms = [];
  scope.others = [];
  scope.totalReconnect = 10;
  scope.timeDelay = 1000;

  scope.joinRoom = function (room) {
    scope.connection.invoke("JoinRoom", room);
  };

  scope.connect = function () {
    scope.connection.invoke("join", scope.player);
  };
  scope.sendMessage = function () {
    scope.connection.invoke("SendMessage", scope.request);
  };
  scope.receiveMessage = function (msg) {
    scope.responses.splice(0, 0, msg);
    scope.$applyAsync();
  };
  scope.prettyJsonObj = function (obj) {
    return JSON.stringify(obj, null, "\t");
  };
  // Starts a connection with transport fallback - if the connection cannot be started using
  // the webSockets transport the function will fallback to the serverSentEvents transport and
  // if this does not work it will try longPolling. If the connection cannot be started using
  // any of the available transports the function will return a rejected Promise.
  scope.startConnection = async function (hubName, callback) {
    scope.connection = new signalR.HubConnectionBuilder()
      .withUrl(scope.host + hubName)
      .withAutomaticReconnect()
      .configureLogging(signalR.LogLevel.Information)
      .build();
    // Create a function that the hub can call to broadcast messages.

    // https://docs.microsoft.com/en-us/aspnet/core/signalr/configuration?view=aspnetcore-3.1&tabs=dotnet
    //It's not possible to configure JSON serialization in the JavaScript client at this time.
    scope.connection.on("receive_message", (msg) => {
      //   let msg = JSON.parse(resp);
      scope.receiveMessage(msg);
    });
    scope.connection
      .start()
      .then(function () {
        console.log("connection started", scope.connection);
        if (callback) {
          callback();
        }
        //scope.$apply();
      })
      .catch(function (error) {
        console.log(`Cannot start the connection use transport.`, error);
        return Promise.reject(error);
      });
    scope.connection.onclose((error) => {
      console.assert(
        scope.connection.state === signalR.HubConnectionState.Disconnected
      );

      let textContent = `Connection closed due to error "${error}". Try refreshing this page to restart the connection.`;
      console.error(textContent);
    });

    scope.reconnect = function () {
      scope.connection
        .start()
        .then(function () {
          console.log("connection started", scope.connection);
          return true;
          //scope.$apply();
        })
        .catch(function (error) {
          console.log(`Cannot start the connection use transport.`, error);
          return false;
        });
    };
  };
  if (scope.$on) {
    scope.$on("$destroy", function () {
      if (scope.onLeave) {
        scope.onLeave();
      }
      if (scope.connection) {
        scope.connection.stop();
      }
    });
  }
}

"use strict";
appShared.controller("ModuleFormController", [
  "$scope",
  "SharedModuleDataService",
  function ($scope, moduleDataService) {
    $scope.initModuleForm = async function (name) {
      var resp = null;
      if (!$rootScope.isInit) {
        setTimeout(function () {
          $scope.initModuleForm(name);
        }, 500);
      } else {
        resp = await moduleDataService.initModuleForm(name);
        if (resp && resp.isSucceed) {
          $scope.data = resp.data;
          $scope.data.postId = $scope.postId;
          $scope.data.productId = $scope.productId;
          $scope.data.categoryId = $scope.categoryId;
          $rootScope.isBusy = false;
          $scope.$apply();
          //$scope.initEditor();
        } else {
          if (resp) {
            $rootScope.showErrors(resp.errors);
          }
          $scope.$apply();
        }
      }
    };

    $scope.loadModuleData = async function (id) {
      $rootScope.isBusy = true;
      var response = await moduleDataService.getModuleData(
        $scope.moduleId,
        $scope.d,
        "portal"
      );
      if (response.isSucceed) {
        $scope.data = response.data;
        $rootScope.isBusy = false;
        $scope.$apply();
      } else {
        $rootScope.showErrors(response.errors);
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };

    $scope.saveModuleData = async function () {
      var form = $("#module-" + $scope.data.moduleId);
      $.each($scope.data.dataProperties, function (i, e) {
        switch (e.dataType) {
          case 5:
            e.value = $(form)
              .find("." + e.name)
              .val();
            break;
          default:
            e.value = e.value ? e.value.toString() : null;
            break;
        }
      });
      var resp = await moduleDataService.saveModuleData($scope.data);
      if (resp && resp.isSucceed) {
        $scope.data = resp.data;
        $scope.initModuleForm();
        $rootScope.showMessage("success", "success");
        if ($scope.saveSuccessCallback) {
          $scope.saveSuccessCallback({ data: $scope.data });
        } else {
          $rootScope.isBusy = false;
          $scope.$apply();
        }
      } else {
        if (resp) {
          $rootScope.showErrors(resp.errors);
        }
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };
  },
]);

appShared.controller("MixDataController", [
  "$rootScope",
  "$scope",
  "ngAppSettings",
  "RestRelatedAttributeDataFormService",
  "RestMixDatabaseDataClientService",
  function ($rootScope, $scope, ngAppSettings, navService, dataService) {
    $scope.defaultData = null;
    $scope.formData = null;
    $scope.formRecords = null;
    $scope.formName = null;
    $scope.navRequest = angular.copy(ngAppSettings.request);
    $scope.successMsg = "Thành công";
    $scope.init = async function (
      formName,
      parentId,
      parentType,
      validateHandler,
      loadingHandler,
      successHandler,
      failHandler
    ) {
      $scope.successMsg = "Success";
      $scope.validateHandler = validateHandler;
      $scope.loadingHandler = loadingHandler;
      $scope.successHandler = successHandler;
      $scope.failHandler = failHandler;
      $scope.formName = formName;
      $scope.navRequest.mixDatabaseName = formName;
      $scope.navRequest.parentType = parentType;
      $scope.navRequest.parentId = parentId;
      var getDefault = await dataService.initData($scope.formName);
      $scope.defaultData = getDefault.data;
      if ($scope.defaultData) {
        $scope.defaultData.mixDatabaseName = $scope.formName;
        $scope.defaultData.parentType = parentType || "Set";
        $scope.defaultData.parentId = parentId;
        $scope.formData = angular.copy($scope.defaultData);
      }
      $scope.$apply();
    };
    $scope.loadData = function () {
      navService.getList($scope.navRequest).then((resp) => {
        if (resp) {
          $scope.formRecords = resp.data;
          $scope.$apply();
        } else {
          if (resp) {
            $rootScope.showErrors("Failed");
          }
          $scope.$apply();
        }
      });
    };
    $scope.submit = async (data) => {
      $scope.form.$$element.addClass("was-validated");
      if ($scope.form.$valid) {
        $rootScope.isBusy = true;
        if ($scope.loadingHandler) {
          $rootScope.executeFunctionByName($scope.loadingHandler, [true]);
        }
        if (
          !$scope.validateHandler ||
          $rootScope.executeFunctionByName($scope.validateHandler, [data])
        ) {
          var saveResult = await dataService.save(data);
          if (saveResult.isSucceed) {
            $scope.loadData();
            if ($scope.successHandler) {
              $rootScope.executeFunctionByName($scope.successHandler, [
                saveResult,
              ]);
            } else {
              $scope.form.$$element.removeClass("was-validated");
              $scope.form.$setPristine();
              $scope.form.$setUntouched();
              console.log($scope.successMsg);
            }
            $scope.formData = angular.copy($scope.defaultData);
            $rootScope.isBusy = false;
            // $scope.loadData();
            if ($scope.loadingHandler) {
              $rootScope.executeFunctionByName($scope.loadingHandler, [false]);
            }
            $scope.$apply();
          } else {
            if (saveResult.errors && saveResult.errors.length) {
              if ($scope.failHandler) {
                $rootScope.executeFunctionByName($scope.failHandler, [
                  data,
                  saveResult,
                ]);
              } else {
                console.error(saveResult.errors);
              }
            }
            if ($scope.loadingHandler) {
              $rootScope.executeFunctionByName($scope.loadingHandler, [false]);
            }
            $rootScope.isBusy = false;
            $scope.$apply();
          }
        }
      }
    };

    $scope.saveValue = async (id, name, value) => {
      if ($scope.form.$valid) {
        $rootScope.isBusy = true;
        var obj = new {}();
        obj[name] = value;
        await dataService.saveValues(id, obj);
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };
  },
]);

"use strict";
appShared.controller("MvcModuleDataController", [
  "$scope",
  "$rootScope",
  "ngAppSettings",
  "$routeParams",
  "$location",
  "RestMvcModuleDataService",
  function (
    $scope,
    $rootScope,
    ngAppSettings,
    $routeParams,
    $location,
    service
  ) {
    BaseRestCtrl.call(
      this,
      $scope,
      $rootScope,
      $location,
      $routeParams,
      ngAppSettings,
      service
    );
    $scope.request.orderBy = "Priority";
    $scope.request.direction = "Asc";
    $scope.localizeSettings = $rootScope.globalSettings;
    $scope.moduleId = null;
    $scope.module = null;
    $scope.allData = [];
    $scope.editDataUrl = null;
    $scope.canLoadMore = false;
    $scope.init = async function (moduleId, pageSize) {
      $scope.moduleId = moduleId;
      $scope.request.module_id = $scope.moduleId;
      $scope.request.pageSize = pageSize || $scope.request.pageSize;
      $scope.loadMore(0);
    };

    $scope.getSingle = async function () {
      $rootScope.isBusy = true;
      var resp = await service.getSingle($scope.id, "mvc");
      if (resp && resp.isSucceed) {
        $scope.activedModuleData = resp.data;
        $rootScope.initEditor();
        $rootScope.isBusy = false;
        $scope.$apply();
      } else {
        if (resp) {
          $rootScope.showErrors(resp.errors);
        }
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };
    $scope.activeItem = function (arr, item) {
      angular.forEach(arr, function (e) {
        if (e.id != item.id) {
          e.expanded = false;
        } else {
          e.expanded = !e.expanded;
        }
      });
    };
    $scope.loadMore = async function (pageIndex) {
      $scope.request.pageIndex = pageIndex || $scope.request.pageIndex + 1;
      $rootScope.isBusy = true;
      var response = await service.getList($scope.request);
      if (response.isSucceed) {
        $scope.allData = $scope.allData.concat(response.data.items);
        $rootScope.isBusy = false;
        $scope.canLoadMore = response.data.totalItems > $scope.allData.length;
        $scope.$apply();
      } else {
        $rootScope.showErrors(response.errors);
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };
  },
]);

"use strict";
appShared.controller("MvcPostController", [
  "$scope",
  "$rootScope",
  "ngAppSettings",
  "$routeParams",
  "$location",
  "BaseService",
  function (
    $scope,
    $rootScope,
    ngAppSettings,
    $routeParams,
    $location,
    baseService
  ) {
    BaseRestCtrl.call(
      this,
      $scope,
      $rootScope,
      $location,
      $routeParams,
      ngAppSettings,
      service
    );
    $scope.service = null;
    $scope.request.orderBy = "Priority";
    $scope.request.direction = "Asc";
    $scope.localizeSettings = $rootScope.globalSettings;
    $scope.moduleId = null;
    $scope.module = null;
    $scope.allData = [];
    $scope.editDataUrl = null;
    $scope.canLoadMore = false;
    $scope.init = async function (type, parentId, pageSize) {
      $scope.parentId = parentId; // page / post
      $scope.service = Object.create(baseService);
      if (type.toLowerCase() === "page") {
        $scope.service.init("page-post/mvc");
      } else if (type.toLowerCase() === "page") {
        $scope.service.init("module-post/mvc");
      }

      $scope.request.module_id = $scope.moduleId;
      $scope.request.pageSize = pageSize || $scope.request.pageSize;
      $scope.loadMore(0);
    };

    $scope.loadMore = async function (pageIndex) {
      $scope.request.pageIndex = pageIndex || $scope.request.pageIndex + 1;
      $rootScope.isBusy = true;
      var response = await service.getList($scope.request);
      if (response.isSucceed) {
        $scope.allData = $scope.allData.concat(response.data.items);
        $rootScope.isBusy = false;
        $scope.canLoadMore =
          response.data.totalItems >
          response.data.page * response.data.pageSize;
        $scope.$apply();
      } else {
        $rootScope.showErrors(response.errors);
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };
  },
]);

sharedComponents.component("addressEditor", {
  templateUrl: "/mix-app/views/app-shared/components/address-editor/view.html",
  bindings: {
    province: "=",
    provinceClass: "=?",
    district: "=",
    districtClass: "=?",
    ward: "=",
    wardClass: "=?",
  },
  controller: "AddressEditorController",
});

sharedComponents.controller("AddressEditorController", [
  "$rootScope",
  "$scope",
  "ApiService",
  function PortalTemplateController($rootScope, $scope, apiService) {
    var ctrl = this;
    ctrl.provinceEndpoint = "/rest/shared/json-data/provinces.json/true";
    ctrl.districtEndpoint = "/rest/shared/json-data/districts.json/true";
    ctrl.wardEndpoint = "/rest/shared/json-data/wards.json/true";
    ctrl.$onInit = async function () {
      ctrl.provinceClass =
        ctrl.provinceClass || "form-select form-control mb-3";
      ctrl.districtClass =
        ctrl.districtClass || "form-select form-control mb-3";
      ctrl.wardClass = ctrl.wardClass || "form-select form-control mb-3";

      ctrl.provinceOptions = await apiService.getApiResult({
        url: ctrl.provinceEndpoint,
      });
      $scope.$apply();
      $rootScope.$watch(
        () => {
          return ctrl.province;
        },
        async function (newVal, oldVal) {
          if (newVal != oldVal || !ctrl.district) {
            if (!ctrl.allDistrictOptions) {
              ctrl.allDistrictOptions = await apiService.getApiResult({
                url: ctrl.districtEndpoint,
              });
              ctrl.districtOptions = ctrl.allDistrictOptions.filter(
                (m) => m["province"] == ctrl.province
              );
              $scope.$apply();
            } else {
              ctrl.districtOptions = ctrl.allDistrictOptions.filter(
                (m) => m["province"] == ctrl.province
              );
            }
          }
        }
      );
      $rootScope.$watch(
        () => {
          return ctrl.district;
        },
        async function (newVal, oldVal) {
          if (newVal != oldVal) {
            if (!ctrl.allWardOptions) {
              ctrl.allWardOptions = await apiService.getApiResult({
                url: ctrl.wardEndpoint,
              });
              ctrl.wardOptions = ctrl.allWardOptions.filter(
                (m) => m["district"] == ctrl.district
              );
              $scope.$apply();
            } else {
              ctrl.wardOptions = ctrl.allWardOptions.filter(
                (m) => m["district"] == ctrl.district
              );
            }
          }
        }
      );
    };
  },
]);

sharedComponents.component("apiFile", {
  templateUrl: "/mix-app/views/app-shared/components/api-file/api-file.html",
  controller: [
    "$rootScope",
    "$scope",
    "Upload",
    function PortalTemplateController($rootScope, $scope, uploader) {
      var ctrl = this;
      ctrl.accept = ctrl.accept || "application/zip";
      ctrl.selectFile = function (files) {
        if (files !== undefined && files !== null && files.length > 0) {
          const file = files[0];
          ctrl.postedFile = file;
        }
      };

      ctrl.uploadFile = function (file) {
        // Create FormData object
        var files = new FormData();
        var folder = ctrl.folder;
        var title = ctrl.title;
        var description = ctrl.description;
        // Looping over all files and add it to FormData object
        files.append(file.name, file);

        // Adding one more key to FormData object
        files.append("fileFolder", folder);
        files.append("title", title);
        files.append("description", description);
        $.ajax({
          url: "/" + $rootScope.localizeSettings.lang + "/media/upload", //'/tts/UploadImage',
          type: "POST",
          contentType: false, // Not to set any content header
          processData: false, // Not to process data
          data: files,
          success: function (result) {
            ctrl.src = result.data.fullPath;
            $scope.$apply();
          },
          error: function (err) {
            return "";
          },
        });
      };
      ctrl.getBase64 = function (file) {
        if (file !== null) {
          $rootScope.isBusy = true;
          var reader = new FileReader();
          reader.readAsDataURL(file);
          reader.onload = function () {
            var index = reader.result.indexOf(",") + 1;
            var base64 = reader.result.substring(index);
            ctrl.postedFile.fileName = file.name.substring(
              0,
              file.name.lastIndexOf(".")
            );
            ctrl.postedFile.extension = file.name.substring(
              file.name.lastIndexOf(".")
            );
            ctrl.postedFile.fileStream = reader.result;
            $rootScope.isBusy = false;
            $scope.$apply();
          };
          reader.onerror = function (error) {};
        } else {
          return null;
        }
      };
    },
  ],
  bindings: {
    header: "=",
    accept: "=",
    title: "=",
    postedFile: "=",
    formName: "=",
    isBase64: "=",
  },
});

sharedComponents.component("azureStorage", {
  templateUrl: "/mix-app/views/app-shared/components/azure-storage/view.html",
  bindings: {
    data: "=",
    width: "=",
  },
  controller: [
    "$rootScope",
    function ($rootScope) {
      var ctrl = this;
      ctrl.blobSasUrl = "<placeholder>";
      ctrl.blobServiceClient = new BlobServiceClient(blobSasUrl);
      ctrl.containerName = "container" + new Date().getTime();
      ctrl.containerClient = blobServiceClient.getContainerClient(
        containerName
      );

      const fileInput = document.getElementById("azure-file-input");
      const status = document.getElementById("status");
      const fileList = document.getElementById("file-list");

      const reportStatus = (message) => {
        status.innerHTML += `${message}<br/>`;
        status.scrollTop = status.scrollHeight;
      };

      ctrl.$onInit = function () {};

      ctrl.createContainer = async () => {
        try {
          reportStatus(`Creating container "${containerName}"...`);
          await containerClient.create();
          reportStatus(`Done.`);
        } catch (error) {
          reportStatus(error.message);
        }
      };

      ctrl.deleteContainer = async () => {
        try {
          reportStatus(`Deleting container "${containerName}"...`);
          await containerClient.delete();
          reportStatus(`Done.`);
        } catch (error) {
          reportStatus(error.message);
        }
      };

      ctrl.listFiles = async () => {
        fileList.size = 0;
        fileList.innerHTML = "";
        try {
          reportStatus("Retrieving file list...");
          let iter = containerClient.listBlobsFlat();
          let blobItem = await iter.next();
          while (!blobItem.done) {
            fileList.size += 1;
            fileList.innerHTML += `<option>${blobItem.value.name}</option>`;
            blobItem = await iter.next();
          }
          if (fileList.size > 0) {
            reportStatus("Done.");
          } else {
            reportStatus("The container does not contain any files.");
          }
        } catch (error) {
          reportStatus(error.message);
        }
      };

      ctrl.uploadFiles = async () => {
        try {
          reportStatus("Uploading files...");
          const promises = [];
          for (const file of fileInput.files) {
            const blockBlobClient = containerClient.getBlockBlobClient(
              file.name
            );
            promises.push(blockBlobClient.uploadBrowserData(file));
          }
          await Promise.all(promises);
          reportStatus("Done.");
          listFiles();
        } catch (error) {
          reportStatus(error.message);
        }
      };

      ctrl.deleteFiles = async () => {
        try {
          if (fileList.selectedOptions.length > 0) {
            reportStatus("Deleting files...");
            for (const option of fileList.selectedOptions) {
              await containerClient.deleteBlob(option.text);
            }
            reportStatus("Done.");
            listFiles();
          } else {
            reportStatus("No files selected.");
          }
        } catch (error) {
          reportStatus(error.message);
        }
      };
    },
  ],
});

sharedComponents.component("breadcrumbs", {
  templateUrl:
    "/mix-app/views/app-shared/components/breadcrumbs/breadcrumbs.html",
  controller: [
    "$rootScope",
    function ($rootScope) {
      var ctrl = this;
    },
  ],
  bindings: {
    breadCrumbs: "=",
  },
});

sharedComponents.component("cultures", {
  templateUrl: "/mix-app/views/app-shared/components/cultures/cultures.html",
  bindings: {
    isClone: "=",
    data: "=",
  },
});

sharedComponents.component("checkboxSwitch", {
  templateUrl: "/mix-app/views/app-shared/components/checkbox-switch/view.html",
  controller: [
    "$rootScope",
    "$location",
    function ($rootScope, $location) {
      var ctrl = this;
      ctrl.guid = $rootScope.generateUUID();
      ctrl.$onInit = function () {
        ctrl.isSelected = ctrl.isSelected || false;
      };
      ctrl.limString = function (str, max) {
        if (str) {
          return str.length > max ? str.substring(0, max) + " ..." : str;
        }
      };
    },
  ],

  bindings: {
    value: "=",
    isSelected: "=?",
    detailsUrl: "=?",
    callback: "&",
    description: "=",
  },
});

sharedComponents.component("swDataPreview", {
  templateUrl:
    "/mix-app/views/app-shared/components/data-preview/data-preview.html",
  controller: [
    "$rootScope",
    function ($rootScope) {
      var ctrl = this;
    },
  ],
  bindings: {
    type: "=",
    value: "=",
  },
});

//sharedComponents.controller('ImageController', );
sharedComponents.component("customFile", {
  templateUrl:
    "/mix-app/views/app-shared/components/custom-file/custom-file.html",
  bindings: {
    header: "=",
    title: "=",
    description: "=",
    src: "=",
    srcUrl: "=?",
    data: "=?",
    type: "=?",
    folder: "=",
    auto: "=",
    onInsert: "&?",
    onDelete: "&",
    save: "&",
  },
  controller: [
    "$rootScope",
    "$scope",
    "MediaService",
    function PortalTemplateController($rootScope, $scope, mediaService) {
      var ctrl = this;
      ctrl.media = null;
      ctrl.$onInit = function () {
        ctrl.id = Math.random();
        ctrl.mediaFile = {
          file: null,
          fullPath: "",
          fileFolder: "content/site",
          title: "",
          description: "",
        };
      };
      ctrl.selectFile = function (files) {
        if (files !== undefined && files !== null && files.length > 0) {
          ctrl.file = files[0];
          if ($rootScope.isImage(ctrl.file)) {
            ctrl.canUpload = false;
            mediaService.openCroppie(ctrl.file, ctrl, true);
          } else {
            ctrl.canUpload = true;
            ctrl.uploadFile(ctrl.file);
          }
        }
      };

      ctrl.croppieCallback = function (result) {
        if (result) {
          ctrl.srcUrl = result.filePath;
          if (ctrl.onInsert) {
            ctrl.onInsert({ data: ctrl.srcUrl });
          }
        } else if (ctrl.file) {
          ctrl.uploadFile(ctrl.file);
        }
      };

      ctrl.uploadFile = async function (file) {
        if (file !== null) {
          $rootScope.isBusy = true;
          var reader = new FileReader();
          reader.readAsDataURL(file);
          reader.onload = async function () {
            var getMedia = await mediaService.getSingle(["portal"]);
            if (getMedia.isSucceed) {
              ctrl.mediaFile.fileName = file.name.substring(
                0,
                file.name.lastIndexOf(".")
              );
              ctrl.mediaFile.extension = file.name.substring(
                file.name.lastIndexOf(".")
              );
              ctrl.mediaFile.fileStream = reader.result;
              var media = getMedia.data;
              media.mediaFile = ctrl.mediaFile;
              var resp = await mediaService.save(media);
              if (resp && resp.isSucceed) {
                ctrl.src = resp.data.fullPath;
                ctrl.srcUrl = resp.data.fullPath;
                $rootScope.isBusy = false;
                $scope.$apply();
              } else {
                if (resp) {
                  $rootScope.showErrors(resp.errors);
                }
                $rootScope.isBusy = false;
                $scope.$apply();
              }
            }
          };
          reader.onerror = function (error) {};
        } else {
          return null;
        }
      };
      ctrl.getBase64 = function (file) {
        if (file !== null && ctrl.mediaFile) {
          $rootScope.isBusy = true;
          var reader = new FileReader();
          reader.readAsDataURL(file);
          reader.onload = function () {
            var index = reader.result.indexOf(",") + 1;
            var base64 = reader.result.substring(index);
            ctrl.mediaFile.fileName = file.name.substring(
              0,
              file.name.lastIndexOf(".")
            );
            ctrl.mediaFile.extension = file.name.substring(
              file.name.lastIndexOf(".")
            );
            ctrl.mediaFile.fileStream = reader.result;
            ctrl.srcUrl = reader.result;
            $rootScope.isBusy = false;

            $scope.$apply();
          };
          reader.onerror = function (error) {
            $rootScope.isBusy = false;
            $rootScope.showErrors([error]);
          };
        } else {
          return null;
        }
      };
    },
  ],
});

sharedComponents.component("fbLogin", {
  templateUrl: "/mix-app/views/app-shared/components/fb-login/view.html",
  bindings: {
    fbPageId: "=",
    themeColor: "=",
    inGreeting: "=",
    outGreeting: "=",
    loginCallback: "&?",
    logoutCallback: "&?",
  },
  controller: [
    "$rootScope",
    "$scope",
    "$location",
    function ($rootScope, $scope, $location) {
      var ctrl = this;
      ctrl.loginStatus = null;
      ctrl.showLogin = false;
      ctrl.init = function () {
        // ctrl.checkLoginState();
        ctrl.showLogin =
          $rootScope.globalSettings.externalLoginProviders.Facebook != "";
      };
      ctrl.translate = $rootScope.translate;
      ctrl.login = function () {
        FB.login(
          function (response) {
            ctrl.statusChangeCallback(response);
          },
          { scope: "public_profile,email" }
        );
      };
      ctrl.logout = function () {
        FB.getLoginStatus(function (response) {
          if (response.status === "connected") {
            FB.logout(function (response) {
              ctrl.loggedIn = false;
              ctrl.profile = null;
              if (ctrl.logoutCallback) {
                ctrl.logoutCallback();
              }
              $scope.$apply();
            });
          }
        });
      };
      ctrl.getProfile = function (authResponse) {
        FB.api("/me", "GET", { fields: "id,name,email" }, function (response) {
          ctrl.profile = response;
          ctrl.loggedIn = true;
          if (ctrl.loginCallback) {
            let loginData = {
              userID: authResponse.userID,
              email: response.email,
              accessToken: authResponse.accessToken,
            };
            ctrl.loginCallback({ resp: loginData });
          }
          $scope.$apply();
        });
      };
      ctrl.checkLoginState = function () {
        FB.getLoginStatus(function (response) {
          ctrl.statusChangeCallback(response);
          ctrl.loginStatus = response;
        });
      };
      ctrl.statusChangeCallback = function (response) {
        // Called with the results from FB.getLoginStatus().
        if (response.status === "connected") {
          // Logged into your webpage and Facebook.
          ctrl.getProfile(response.authResponse);
        }
      };
    },
  ],
});

"use trick";
sharedComponents.directive("pane", function () {
  return {
    require: "^tabs",
    restrict: "E",
    transclude: true,
    scope: { title: "@" },
    link: function (scope, element, attrs, tabsController) {
      tabsController.addPane(scope);
    },
    template:
      '<div class="tab-pane" ng-class="{active: selected}" ng-transclude>' +
      "</div>",
    replace: true,
  };
});

sharedComponents.directive("tabs", function () {
  return {
    restrict: "E",
    transclude: true,
    scope: {},
    controller: function ($scope, $element) {
      var panes = ($scope.panes = []);

      $scope.select = function (pane) {
        angular.forEach(panes, function (pane) {
          pane.selected = false;
        });
        pane.selected = true;
      };

      this.addPane = function (pane) {
        if (panes.length === 0) $scope.select(pane);
        panes.push(pane);
      };
    },
    templateUrl: "/mix-app/views/app-shared/components/templates/tabs.html",
    replace: true,
  };
});

sharedComponents.component("goToTop", {
  templateUrl: "/mix-app/views/app-shared/components/go-to-top/view.html",
  controller: [
    "$rootScope",
    "$scope",
    function ($rootScope, $scope) {
      var ctrl = this;
      ctrl.$onInit = function () {
        $(window).scroll(function () {
          if ($(window).scrollTop() >= 50) {
            // If page is scrolled more than 50px
            $("#return-to-top").fadeIn(200); // Fade in the arrow
          } else {
            $("#return-to-top").fadeOut(200); // Else fade out the arrow
          }
        });
      };
      ctrl.goToTop = function () {
        // ===== Scroll to Top ====
        $("body,html").animate(
          {
            scrollTop: 0, // Scroll to top of body
          },
          500
        );
      };
    },
  ],
  bindings: {},
});

sharedComponents.component("googlePay", {
  templateUrl: "/mix-app/views/app-shared/components/google-pay/view.html",
  bindings: {
    items: "=",
    currencyCode: "=",
    totalPriceStatus: "=",
    totalPrice: "=",
    processPaymentData: "&",
  },
  controller: [
    "$rootScope",
    "$element",
    "gpayService",
    function ($rootScope, $element, service) {
      var ctrl = this;
      ctrl.merchantInfo = {
        merchantId: "BCR2DN6TV7RIL73C",
        merchantName: "Mixcore",
      };
      ctrl.payPalPaymentMethod = {
        type: "PAYPAL",
        parameters: {
          purchase_context: {
            purchase_units: [
              {
                payee: {
                  merchant_id: "08975416670814987822",
                },
              },
            ],
          },
        },
      };
      ctrl.environment = "TEST";

      ctrl.init = function () {
        ctrl.onGooglePayLoaded($element[0]);
      };

      ctrl.onGooglePayLoaded = function (element) {
        const paymentsClient = service.getGooglePaymentsClient(
          ctrl.merchantInfo,
          ctrl.onPaymentAuthorized
        );
        paymentsClient
          .isReadyToPay(service.getGoogleIsReadyToPayRequest())
          .then(function (response) {
            if (response.result) {
              ctrl.addGooglePayButton(element);
              // @todo prefetch payment data to improve performance after confirming site functionality
              // prefetchGooglePaymentData();
            }
          })
          .catch(function (err) {
            // show error in developer console for debugging
            console.error(err);
          });
      };

      /**
       * Provide Google Pay API with a payment amount, currency, and amount status
       *
       * @see {@link https://developers.google.com/pay/api/web/reference/request-objects#TransactionInfo|TransactionInfo}
       * @returns {object} transaction info, suitable for use as transactionInfo property of PaymentDataRequest
       */
      ctrl.getGoogleTransactionInfo = function () {
        return {
          displayItems: ctrl.items,
          countryCode: "VN",
          currencyCode: "VND",
          totalPriceStatus: "FINAL",
          totalPrice: `${ctrl.totalPrice}`,
          totalPriceLabel: "Total",
        };
      };

      /**
       * Add a Google Pay purchase button alongside an existing checkout button
       *
       * @see {@link https://developers.google.com/pay/api/web/reference/request-objects#ButtonOptions|Button options}
       * @see {@link https://developers.google.com/pay/api/web/guides/brand-guidelines|Google Pay brand guidelines}
       */
      ctrl.addGooglePayButton = function (element) {
        const paymentsClient = service.getGooglePaymentsClient(
          ctrl.merchantInfo,
          ctrl.onPaymentAuthorized
        );
        const button = paymentsClient.createButton({
          buttonColor: "default",
          buttonType: "plain",
          buttonSizeMode: "fill",
          onClick: ctrl.onGooglePaymentButtonClicked,
        });
        element.appendChild(button);
        // @todo prefetch payment data to improve performance after confirming site functionality
        // prefetchGooglePaymentData();
      };

      /**
       * Show Google Pay payment sheet when Google Pay payment button is clicked
       */
      ctrl.onGooglePaymentButtonClicked = function () {
        let transactionInfo = ctrl.getGoogleTransactionInfo();
        const paymentDataRequest = service.getGooglePaymentDataRequest(
          ctrl.merchantInfo,
          transactionInfo
        );
        paymentDataRequest.transactionInfo = transactionInfo;

        const paymentsClient = service.getGooglePaymentsClient(
          ctrl.merchantInfo,
          ctrl.onPaymentAuthorized
        );
        paymentsClient.loadPaymentData(paymentDataRequest);
      };

      ctrl.onPaymentAuthorized = function (paymentData) {
        return new Promise(function (resolve, reject) {
          // handle the response
          ctrl
            .processPayment(paymentData)
            .then(function (resp) {
              console.log(resp);
              resolve({ transactionState: "SUCCESS" });
            })
            .catch(function () {
              resolve({
                transactionState: "ERROR",
                error: {
                  intent: "PAYMENT_AUTHORIZATION",
                  message: "Insufficient funds",
                  reason: "PAYMENT_DATA_INVALID",
                },
              });
            });
        });
      };

      /**
       * Process payment data returned by the Google Pay API
       *
       * @param {object} paymentData response from Google Pay API after user approves payment
       * @see {@link https://developers.google.com/pay/api/web/reference/response-objects#PaymentData|PaymentData object reference}
       */
      ctrl.processPayment = async function (paymentData) {
        return await ctrl.processPaymentData({ paymentData: paymentData });
      };
    },
  ],
});

(function (angular) {
  appShared.component("languageSwitcher", {
    templateUrl:
      "/mix-app/views/app-shared/components/language-switcher/language-switcher.html",
    controller: [
      "$rootScope",
      "$scope",
      "$location",
      "ApiService",
      "CommonService",
      "TranslatorService",
      "GlobalSettingsService",
      function (
        $rootScope,
        $scope,
        $location,
        apiService,
        commonService,
        translatorService,
        globalSettingsService
      ) {
        var ctrl = this;
        ctrl.localizeSettings = {};
        this.$onInit = function () {
          ctrl.localizeSettings = $rootScope.localizeSettings;
          if ($rootScope.globalSettings) {
            ctrl.localizeSettings.cultures = $rootScope.globalSettings.cultures;
          }
        };

        ctrl.changeLang = async function (lang, langIcon) {
          ctrl.localizeSettings.lang = lang;
          ctrl.localizeSettings.langIcon = langIcon;
          // await commonService.removeSettings();
          // await commonService.removeTranslator();
          // commonService.fillSettings(lang).then(function () {
          //     translatorService.reset(lang).then(function () {
          commonService.fillAllSettings(lang).then(function (response) {
            translatorService.translateUrl(lang).then(function (url) {
              window.top.location = url;
            });
          });
          //     });
          // });
        };
        ctrl.logOut = function () {
          $rootScope.logOut();
        };
      },
    ],
    bindings: {
      //settings: '=',
      ulStyle: "=",
      liStyle: "=",
      aStyle: "=",
      activeClass: "=",
    },
  });
})(window.angular);

sharedComponents.component("limitString", {
  templateUrl:
    "/mix-app/views/app-shared/components/limit-string/limit-string.html",
  controller: [
    "$rootScope",
    "$scope",
    "ngAppSettings",
    function ($rootScope, $scope, ngAppSettings) {
      var ctrl = this;
      ctrl.shortenString = "";
      ctrl.previousContentId = undefined;

      this.$onInit = () => {
        ctrl.previousContentId = angular.copy(ctrl.contentId);
      };

      this.$doCheck = () => {
        if (ctrl.contentId !== ctrl.previousContentId) {
          ctrl.loadModuleData();
          ctrl.previousContentId = ctrl.contentId;
        }
      };
      ctrl.shortString = function () {
        var data = decodeURIComponent(ctrl.content);
        if (data) {
          if (ctrl.max < data.length) {
            ctrl.shortenString =
              data.replace(/[+]/g, " ").substr(0, ctrl.max) + " ...";
          } else {
            ctrl.shortenString = data.replace(/[+]/g, " ");
          }
        }
      };
      ctrl.view = function () {
        var obj = {
          moduleId: ctrl.moduleId,
          id: ctrl.contentId,
        };
        $rootScope.preview("module-data", obj, null, "modal-lg");
      };
      ctrl.translate = $rootScope.translate;
    },
  ],
  bindings: {
    content: "=",
    showData: "=",
    max: "=",
    moduleId: "=",
    contentId: "=",
  },
});

appShared.component("loginPopup", {
  templateUrl: "/mix-app/views/app-shared/components/login-popup/view.html",
  controller: "LoginPopupController",
});

appShared.controller("LoginPopupController", [
  "$scope",
  "$rootScope",
  "AuthService",
  "ApiService",
  "CommonService",
  function LoginPopupController(
    $scope,
    $rootScope,
    authService,
    commonService
  ) {
    $scope.loginData = {
      username: "",
      password: "",
      rememberMe: false,
    };
    $scope.login = async function () {
      var result = await authService.loginPopup($scope.loginData);
      if (result && result.isSucceed) {
        $rootScope.isBusy = false;
        $scope.message = result.errors[0];
        $("#login-popup").modal("hide");
        $scope.$apply();

        if ($rootScope.loginCallbackRequest) {
          if ($rootScope.loginCallbackType == "rest") {
            apiService.getRestApiResult($rootScope.loginCallbackRequest);
          } else {
            apiService.getRestResult($rootScope.loginCallbackRequest);
          }
          $rootScope.loginCallbackRequest = null;
          $rootScope.loginCallbackType = null;
        }
      } else {
        $rootScope.goToSiteUrl("/security/login");
      }
    };
    $scope.closeDialog = function () {
      $("#login-popup").modal("hide");
    };
  },
]);

appShared.component("mediaNavs", {
  templateUrl:
    "/mix-app/views/app-shared/components/media-navs/media-navs.html",
  controller: [
    "$rootScope",
    "$scope",
    "ngAppSettings",
    "MediaService",
    function ($rootScope, $scope, ngAppSettings, mediaService) {
      var ctrl = this;
      mediaService.init("media");
      ctrl.request = {
        pageSize: "10",
        pageIndex: 0,
        status: "Published",
        orderBy: "CreatedDateTime",
        direction: "Desc",
        fromDate: null,
        toDate: null,
        keyword: "",
      };
      ctrl.medias = [];
      ctrl.activeMedia = function (media) {
        var currentItem = null;
        if (ctrl.data === null || ctrl.isSingle) {
          ctrl.data = [];
        }
        $.each(ctrl.data, function (i, e) {
          if (e.mediaId === media.id) {
            e.isActived = media.isActived;
            currentItem = e;
            return false;
          }
        });
        if (currentItem === null) {
          currentItem = {
            description:
              media.description !== "undefined" ? media.description : "",
            image: media.filePath,
            mediaId: media.id,
            product: ctrl.id,
            specificulture: media.specificulture,
            position: 0,
            priority: ctrl.data.length + 1,
            isActived: true,
          };
          ctrl.data.push(currentItem);
        }
        if (ctrl.isSingle) {
          if (!media.isActived) {
            ctrl.output = "";
            ctrl.data = [];
          } else {
            ctrl.output = ctrl.data[0].image;
            //ctrl.loadMedias(ctrl.request.pageIndex);
          }
        }
      };
      ctrl.loadMedias = async function (pageIndex) {
        if (!ctrl.prefix) {
          ctrl.prefix = "media_navs";
        }
        if (pageIndex !== undefined) {
          ctrl.request.pageIndex = pageIndex;
        }
        if (ctrl.request.fromDate !== null) {
          var d = new Date(ctrl.request.fromDate);
          ctrl.request.fromDate = d.toISOString();
        }
        if (ctrl.request.toDate !== null) {
          ctrl.request.toDate = ctrl.request.toDate.toISOString();
        }
        if ($rootScope.globalSettings) {
          ctrl.isBusy = true;
          var resp = await mediaService.getList(ctrl.request);
          if (resp && resp.isSucceed) {
            ctrl.medias = resp.data;
            if (ctrl.data) {
              angular.forEach(ctrl.medias.items, function (value, key) {
                var temp = ctrl.data.filter(function (item) {
                  return item.mediaId === value.id;
                })[0];
                value.isActived = temp !== undefined;
              });
            }
            ctrl.isBusy = false;
            $scope.$apply();
          } else {
            if (resp) {
              $rootScope.showErrors(resp.errors);
            }
            ctrl.isBusy = false;
            $scope.$apply();
          }
        }
      };
    },
  ],
  bindings: {
    data: "=",
    prefix: "=",
    sourceFieldName: "=",
    isSingle: "=",
    output: "=",
    loadMedia: "&",
    onDelete: "&",
    onUpdate: "&",
  },
});

sharedComponents.component("message", {
  templateUrl: "/mix-app/views/app-shared/components/message/message.html",
  bindings: {
    message: "=",
  },
});

"use strict";
appShared.controller("MediaController", [
  "$scope",
  "$rootScope",
  "ngAppSettings",
  "$routeParams",
  "MediaService",
  "ApiService",
  "CommonService",
  function (
    $scope,
    $rootScope,
    ngAppSettings,
    $routeParams,
    service,
    apiService,
    commonService
  ) {
    BaseCtrl.call(
      this,
      $scope,
      $rootScope,
      $routeParams,
      ngAppSettings,
      service
    );

    $scope.viewmodel = {
      title: "",
      description: "",
      status: "Published",
      mediaFile: {
        file: null,
        fullPath: "",
        folderName: "Media",
        fileFolder: "",
        fileName: "",
        extension: "",
        content: "",
        fileStream: "",
      },
    };
    // multipart form
    $scope.formFile = null;
    $scope.relatedMedias = [];

    $scope.init = function () {
      $("#modal-files").on("shown.bs.modal", function () {
        $scope.getList();
      });
    };
    $scope.getListSuccessCallback = function () {
      angular.forEach($scope.data.items, function (e) {
        e.isImage = $scope.isImage(e.fullPath);
      });
    };
    $scope.isImage = function (url) {
      return url
        .toLowerCase()
        .match(/([/|.|\w|\s|-])*\.(?:jpg|jpeg|gif|png|svg|webp|jfif)/g);
    };
    $scope.save = async function () {
      var data = $scope.viewmodel;
      $rootScope.isBusy = true;
      if ($scope.validate) {
        $scope.isValid = await $rootScope.executeFunctionByName(
          "validate",
          $scope.validateArgs,
          $scope
        );
      }
      if ($scope.isValid) {
        var resp = await service.save(
          data,
          $scope.formFile,
          $scope.onUploadFileProgress
        );
        if (resp && resp.isSucceed) {
          $scope.viewmodel = resp.data;
          $rootScope.showMessage("success", "success");

          if ($scope.saveSuccessCallback) {
            $rootScope.executeFunctionByName(
              "saveSuccessCallback",
              $scope.saveSuccessCallbackArgs,
              $scope
            );
          } else {
            $rootScope.goToPath("/portal/media/list");
          }
          $rootScope.isBusy = false;
          $scope.$apply();
        } else {
          if ($scope.saveFailCallback) {
            $rootScope.executeFunctionByName(
              "saveFailCallback",
              $scope.saveSuccessCallbackArgs,
              $scope
            );
          }
          if (resp) {
            $rootScope.showErrors(resp.errors);
          }
          $rootScope.isBusy = false;
          $scope.$apply();
        }
      } else {
        $rootScope.showErrors(["invalid model"]);
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };
    $scope.uploadMedia = async function () {
      $rootScope.isBusy = true;
      var resp = await service.uploadMedia($scope.mediaFile);
      if (resp && resp.isSucceed) {
        //$scope.activedMedia = resp.data;
        $scope.getList();
        $scope.$apply();
      } else {
        if (resp) {
          $rootScope.showErrors(resp.errors);
        }
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };
    $scope.selectFile = function (file, errFiles) {
      if (file !== undefined && file !== null) {
        $scope.mediaFile.folder = "Media";
        $scope.mediaFile.file = file;
        $scope.getBase64(file);
      }
    };
    $scope.getBase64 = function (file) {
      if (file !== null && $scope.postedFile) {
        $rootScope.isBusy = true;
        var reader = new FileReader();
        reader.readAsDataURL(file);
        reader.onload = function () {
          var index = reader.result.indexOf(",") + 1;
          var base64 = reader.result.substring(index);
          $scope.activedMedia.mediaFile.fileName = $rootScope.generateKeyword(
            file.name.substring(0, file.name.lastIndexOf(".")),
            "-"
          );
          $scope.activedMedia.mediaFile.extension = file.name.substring(
            file.name.lastIndexOf(".")
          );
          $scope.activedMedia.mediaFile.fileStream = reader.result;
          $rootScope.isBusy = false;
          $scope.$apply();
        };
        reader.onerror = function (error) {
          $rootScope.showErrors([error]);
          $rootScope.isBusy = false;
        };
      } else {
        return null;
      }
    };
    $scope.togglePreview = function (item) {
      item.isPreview = item.isPreview === undefined ? true : !item.isPreview;
    };
    $scope.clone = async function (id) {
      $rootScope.isBusy = true;
      var resp = await service.cloneMedia(id);
      if (resp && resp.isSucceed) {
        $scope.activedMedia = resp.data;
        $rootScope.showMessage("Update successfully!", "success");
        $rootScope.isBusy = false;
        $scope.$apply();
        //$location.path('/portal/media/details/' + resp.data.id);
      } else {
        if (resp) {
          $rootScope.showErrors(resp.errors);
        }
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };

    $scope.removeCallback = function () {
      $scope.getList();
    };
    $scope.onUploadFileProgress = function (progress) {
      $scope.progress = progress;
    };
  },
]);

"use strict";
appShared.factory("MediaService", [
  "$rootScope",
  "$uibModal",
  "ApiService",
  "CommonService",
  "BaseService",
  function ($rootScope, $uibModal, apiService, commonService, baseService) {
    var serviceFactory = Object.create(baseService);
    serviceFactory.init("media");
    var _cloneMedia = async function (id) {
      var req = {
        method: "GET",
        url: serviceFactory.prefixUrl + "/clone/" + id,
      };
      return await apiService.getApiResult(req);
    };
    var _save = async function (objData, file, onUploadFileProgress) {
      var url = this.prefixUrl + "/save";
      var fd = new FormData();
      var file = objData.mediaFile.file;
      objData.mediaFile.file = null;
      fd.append("model", angular.toJson(objData));
      fd.append("file", file);
      return await serviceFactory.ajaxSubmitForm(fd, url, onUploadFileProgress);
    };
    var _uploadMedia = async function (file, onUploadFileProgress) {
      //var container = $(this).parents('.model-media').first().find('.custom-file').first();
      if (file !== null) {
        // Create FormData object
        var url = this.prefixUrl + "/upload-media";
        var fd = new FormData();

        fd.append("file", file);
        return await serviceFactory.ajaxSubmitForm(
          fd,
          url,
          onUploadFileProgress
        );
      }
    };
    var _openCroppie = function (file, scope, autoSave = true) {
      const w = parseInt(scope.w);
      const h = parseInt(scope.h);
      const rto = w && h ? scope.w / scope.h : null;

      var modalInstance = $uibModal.open({
        animation: true,
        windowClass: "show",
        templateUrl:
          "/mix-app/views/app-shared/components/modal-croppie/croppie.html",
        controller: "ModalCroppieController",
        controllerAs: "$ctrl",
        size: "lg",
        resolve: {
          mediaService: this,
          file: function () {
            return file;
          },
          w,
          h,
          rto,
          autoSave,
        },
      });
      modalInstance.result.then(
        function (result) {
          scope.croppieCallback(result);
        },
        function () {}
      );
    };
    serviceFactory.openCroppie = _openCroppie;
    serviceFactory.cloneMedia = _cloneMedia;
    serviceFactory.uploadMedia = _uploadMedia;
    serviceFactory.save = _save;
    return serviceFactory;
  },
]);

sharedComponents.component("medias", {
  templateUrl: "/mix-app/views/app-shared/components/medias/medias.html",
  controller: "MediaController",
  bindings: {},
});

"use strict";
appShared.controller("MessengerController", [
  "$scope",
  function ($scope) {
    BaseHub.call(this, $scope);
    $scope.user = {
      loggedIn: false,
      info: {},
    };
    $scope.isHide = true;
    $scope.hideContact = true;
    $scope.members = [];
    $scope.messages = [];
    $scope.message = { connection: {}, content: "" };
    $scope.request = {
      uid: "",
      objectType: null,
      action: "",
      data: {},
      room: "",
      isMyself: false,
    };
    $scope.loadMsgButton = function () {};
    $scope.init = function () {
      $scope.startConnection("MixChatHub", $scope.checkLoginStatus);

      $("button").on("click", function () {
        var text = $("#message").val();
        var hnow = new Date().getHours();
        var mnow = new Date().getMinutes();
        mnow = mnow < 10 ? "0" + mnow : mnow;
        var d = hnow + ":" + mnow;

        if (text.length > 0) {
          $("#message").css("border", "1px solid #f4f5f9");
          $("#conversation").append(
            "<li class='message-right'><div class='message-avatar'><div class='avatar ion-ios-person'></div><div class='name'>You</div></div><div class='message-text'>" +
              text +
              "</div><div class='message-hour'>" +
              d +
              " <span class='ion-android-done-all'></span></div></li>"
          );
          $("#message").val("");
          $(".widget-conversation").scrollTop(
            $("ul li").last().position().top + $("ul li").last().height()
          );
        } else {
          $("#message").css("border", "1px solid #eb9f9f");
          $("#message").animate({ opacity: "0.1" }, "slow");
          $("#message").animate({ opacity: "1" }, "slow");
          $("#message").animate({ opacity: "0.1" }, "slow");
          $("#message").animate({ opacity: "1" }, "slow");
        }
      });

      // var _createClass = function () {function defineProperties(target, props) {for (var i = 0; i < props.length; i++) {var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);}}return function (Constructor, protoProps, staticProps) {if (protoProps) defineProperties(Constructor.prototype, protoProps);if (staticProps) defineProperties(Constructor, staticProps);return Constructor;};}();function _classCallCheck(instance, Constructor) {if (!(instance instanceof Constructor)) {throw new TypeError("Cannot call a class as a function");}}var HoverButton = function () {
      //   function HoverButton(el) {_classCallCheck(this, HoverButton);
      //     this.el = el;
      //     this.hover = false;
      //     this.calculatePosition();
      //     this.attachEventsListener();
      //   }_createClass(HoverButton, [{ key: 'attachEventsListener', value: function attachEventsListener()

      //     {var _this = this;
      //       window.addEventListener('mousemove', function (e) {return _this.onMouseMove(e);});
      //       window.addEventListener('resize', function (e) {return _this.calculatePosition(e);});
      //     } }, { key: 'calculatePosition', value: function calculatePosition()

      //     {

      //       var box = this.el.getBoundingClientRect();
      //       this.x = box.left + box.width * 0.5;
      //       this.y = box.top + box.height * 0.5;
      //       this.width = box.width;
      //       this.height = box.height;
      //     } }, { key: 'onMouseMove', value: function onMouseMove(

      //     e) {
      //       var hover = false;
      //       var hoverArea = this.hover ? 0.7 : 0.5;
      //       var x = e.clientX - this.x;
      //       var y = e.clientY - this.y;
      //       var distance = Math.sqrt(x * x + y * y);
      //       if (distance < this.width * hoverArea) {
      //         hover = true;
      //         if (!this.hover) {
      //           this.hover = true;
      //         }
      //         this.onHover(e.clientX, e.clientY);
      //       }

      //       if (!hover && this.hover) {
      //         this.onLeave();
      //         this.hover = false;
      //       }
      //     } }, { key: 'onHover', value: function onHover(

      //     x, y) {
      //       TweenMax.to(this.el, 0.4, {
      //         x: (x - this.x) * 0.4,
      //         y: (y - this.y) * 0.4,
      //         scale: 1.15,
      //         ease: Power2.easeOut });

      //       this.el.style.zIndex = 10;
      //     } }, { key: 'onLeave', value: function onLeave()
      //     {
      //       TweenMax.to(this.el, 0.7, {
      //         x: 0,
      //         y: 0,
      //         scale: 1,
      //         ease: Elastic.easeOut.config(1.2, 0.4) });

      //       this.el.style.zIndex = 1;
      //     } }]);return HoverButton;}();

      // var btn1 = document.querySelector('#quest');
      // new HoverButton(btn1);
    };
    $scope.logout = function () {
      FB.logout(function (response) {
        // user is now logged out
        $scope.user.loggedIn = false;
      });
    };
    $scope.login = function () {
      FB.login(function (response) {
        if (response.authResponse) {
          FB.api("/me", function (response) {
            $scope.user.info.name = response.name;
            $scope.user.info.id = response.id;
            $scope.user.info.avatar =
              "//graph.facebook.com/" +
              response.id +
              "/picture?width=32&height=32";
            $scope.join();
            $scope.$apply();
          });
        } else {
          console.log("User cancelled login or did not fully authorize.");
        }
      });
    };
    $scope.join = function () {
      $scope.request.uid = $scope.user.info.id;
      $scope.request.data = $scope.user.info;
      $scope.message.connection = $scope.user.info;
      $scope.connection.invoke("join", $scope.request);
    };
    $scope.toggle = function () {
      $scope.isHide = !$scope.isHide;
    };
    $scope.toggleContact = function () {
      $scope.hideContact = !$scope.hideContact;
    };
    $scope.sendMessage = function () {
      if ($scope.user.loggedIn) {
        $scope.request.data = $scope.message;
        $scope.connection.invoke("sendMessage", $scope.request);
        $scope.message.content = "";
      }
    };
    $scope.receiveMessage = function (msg) {
      //$scope.responses.splice(0, 0, msg);
      switch (msg.responseKey) {
        case "NewMember":
          $scope.newMember(msg.data);
          $(".widget-conversation").scrollTop = $(
            ".widget-conversation"
          )[0].scrollHeight;
          break;

        case "NewMessage":
          $scope.newMessage(msg.data);
          break;
        case "ConnectSuccess":
          $scope.user.loggedIn = true;
          $scope.initList(msg.data);
          $scope.$apply();
          break;

        case "MemberOffline":
          $scope.removeMember(msg.data);
          break;
      }
    };
    $scope.checkLoginStatus = function () {
      FB.getLoginStatus(function (response) {
        if (response.status === "connected") {
          // The user is logged in and has authenticated your
          // app, and response.authResponse supplies
          // the user's ID, a valid access token, a signed
          // request, and the time the access token
          // and signed request each expire.
          FB.api("/me", function (response) {
            $scope.user.info.name = response.name;
            $scope.user.info.id = response.id;
            $scope.user.info.avatar =
              "//graph.facebook.com/" +
              response.id +
              "/picture?width=32&height=32";
            $scope.join();
            $scope.$apply();
          });
        } else if (response.status === "authorization_expired") {
          // The user has signed into your application with
          // Facebook Login but must go through the login flow
          // again to renew data authorization. You might remind
          // the user they've used Facebook, or hide other options
          // to avoid duplicate account creation, but you should
          // collect a user gesture (e.g. click/touch) to launch the
          // login dialog so popup blocking is not triggered.
        } else if (response.status === "not_authorized") {
          // The user hasn't authorized your application.  They
          // must click the Login button, or you must call FB.login
          // in response to a user gesture, to launch a login dialog.
        } else {
          // The user isn't logged in to Facebook. You can launch a
          // login dialog with a user gesture, but the user may have
          // to log in to Facebook before authorizing your application.
        }
      });
    };
    $scope.newMember = function (member) {
      var index = $scope.members.findIndex((x) => x.id === member.id);
      if (index < 0) {
        $scope.members.splice(0, 0, member);
      }
      $scope.$apply();
    };

    $scope.initList = function (data) {
      data.forEach((member) => {
        var index = $scope.members.findIndex((x) => x.id === member.id);
        if (index < 0) {
          $scope.members.splice(0, 0, member);
        }
      });

      $scope.$apply();
    };

    $scope.removeMember = function (memberId) {
      var index = $scope.members.findIndex((x) => x.id === memberId);
      if (index >= 0) {
        $scope.members.splice(index, 1);
      }
      $scope.$apply();
    };

    $scope.newMessage = function (msg) {
      $scope.messages.push(msg);
      $scope.$apply();
      var objDiv = document.getElementsByClassName("widget-conversation")[0];
      objDiv.scrollTop = objDiv.scrollHeight + 20;
    };
  },
]);

sharedComponents.component("messenger", {
  templateUrl: "/mix-app/views/app-shared/components/messenger/index.html",
  controller: "MessengerController",
  bindings: {
    message: "=",
  },
});

sharedComponents.component("messengerPrivate", {
  templateUrl:
    "/mix-app/views/app-shared/components/messenger-private/index.html",
  controller: "MessengerController",
  bindings: {
    message: "=",
    connectionId: "=",
  },
});

sharedComponents.component("mixColumnEditor", {
  templateUrl:
    "/mix-app/views/app-shared/components/mix-column-editor/view.html",
  bindings: {
    model: "=",
    column: "=",
    parentId: "=?",
    isShowTitle: "=?",
    inputClass: "=?",
    createUrl: "=?",
    updateUrl: "=?",
    backUrl: "=?",
    level: "=?",
  },
  controller: [
    "$rootScope",
    "$scope",
    "$routeParams",
    "ngAppSettings",
    "$filter",
    "ApiService",
    function (
      $rootScope,
      $scope,
      $routeParams,
      ngAppSettings,
      $filter,
      apiService
    ) {
      var ctrl = this;
      ctrl.mediaFile = {};
      ctrl.icons = ngAppSettings.icons;
      ctrl.previousValue = null;
      ctrl.translate = (keyword, isWrap, defaultText) => {
        return $rootScope.translate(keyword, isWrap, defaultText);
      };
      ctrl.$doCheck = function () {
        // Generate seo string if create new or not exist
        if (
          ctrl.column &&
          ctrl.model &&
          (!ctrl.model.id || !ctrl.model.obj["seo_url"]) &&
          ctrl.column.name == "title"
        ) {
          if (
            ctrl.model.obj[ctrl.column.name] &&
            ctrl.previousValue !== ctrl.model.obj[ctrl.column.name]
          ) {
            ctrl.previousValue = ctrl.model.obj[ctrl.column.name];
            ctrl.model.obj["seo_url"] = $rootScope.generateKeyword(
              ctrl.model.obj[ctrl.column.name],
              "-"
            );
          }
        }
        if (ctrl.model && ctrl.column) {
          // check encrypt data
          if (
            ctrl.column.isEncrypt &&
            ctrl.model.obj[ctrl.column.name] &&
            $rootScope.testJSON(ctrl.model.obj[ctrl.column.name])
          ) {
            ctrl.model.obj[ctrl.column.name] = ctrl.parseEncryptedData(
              ctrl.model.obj[ctrl.column.name]
            );
          }
        }
      }.bind(ctrl);
      ctrl.refData = null;
      ctrl.defaultDataModel = null;

      ctrl.refDataModel = {
        id: null,
        data: null,
      };

      ctrl.dataTypes = $rootScope.globalSettings.dataTypes;
      ctrl.previousId = null;
      ctrl.options = [];
      ctrl.$onInit = async function () {
        if (!ctrl.createUrl && ctrl.model && ctrl.column.referenceId) {
          ctrl.buildCreateUrl();
        }
        if (!ctrl.updateUrl) {
          ctrl.updateUrl = "/portal/mix-database-data/details";
        }
        if (ctrl.model && ctrl.column.isSelect) {
          // Load options from system configutation by name if exist else load options from column configurations
          if (ctrl.column.columnConfigurations.optionsConfigurationName) {
            // load options if not belong to other column value
            let belongTo = ctrl.column.columnConfigurations.belongTo;
            let endpoint =
              ctrl.column.columnConfigurations.optionsConfigurationName;
            if (!belongTo) {
              let options = await apiService.getApiResult({
                url: endpoint,
              });
              ctrl.options = options;
            } else {
              //   ctrl.options = options.filter(
              //     (m) => m[belongTo] == ctrl.model.obj[belongTo]
              //   );
              $rootScope.$watch(
                () => {
                  return ctrl.model.obj[belongTo];
                },
                async function (newVal, oldVal) {
                  if (newVal != oldVal) {
                    if (!ctrl.allOptions) {
                      ctrl.allOptions = await apiService.getApiResult({
                        url: endpoint,
                      });
                    }
                    ctrl.options = ctrl.allOptions.filter(
                      (m) => m[belongTo] == ctrl.model.obj[belongTo]
                    );
                  }
                }
              );
            }
          } else {
            ctrl.options = ctrl.column.options;
          }
        }

        ctrl.watchId();
      };
      ctrl.watchId = function () {
        $rootScope.$watch(
          () => {
            if (ctrl.model) {
              return ctrl.model.id;
            }
          },
          async function (newVal, oldVal) {
            if (newVal != oldVal) {
              ctrl.buildCreateUrl();
            }
          }
        );
      };
      ctrl.buildCreateUrl = function () {
        ctrl.createUrl = `/portal/mix-database-data/create?mixDatabaseId=${ctrl.column.referenceId}&dataId=default&parentId=${ctrl.model.id}&parentType=Set`;
      };
      ctrl.initData = async function () {
        setTimeout(() => {
          switch (ctrl.column.dataType.toLowerCase()) {
            case "datetime":
            case "date":
            case "time":
              if (ctrl.model.obj[ctrl.column.name]) {
                ctrl.obj = new Date(ctrl.model.obj[ctrl.column.name]);
              }
              break;
            case "reference": // reference
              // if(ctrl.column.referenceId && ctrl.model.id){
              //     ctrl.model[ctrl.column.name] = ctrl.column.referenceId;
              //     navService.getSingle(['default']).then(resp=>{
              //         resp.mixDatabaseId = ctrl.column.referenceId;
              //         resp.parentId = ctrl.parentId;
              //         resp.parentType = ctrl.parentType;
              //         ctrl.defaultDataModel = resp;
              //         ctrl.refDataModel = angular.copy(ctrl.defaultDataModel);
              //     });
              //     ctrl.loadRefData();
              // }
              break;
            default:
              if (ctrl.column && !ctrl.model[ctrl.column.name]) {
                ctrl.model[ctrl.column.name] = ctrl.column.defaultValue;
                $scope.$apply();
              }
              break;
          }
        }, 200);
      };
      ctrl.parseEncryptedData = function (data) {
        var encryptedData = $rootScope.testJSON(data);
        return $rootScope.decrypt(encryptedData);
      };
      ctrl.initDefaultValue = async function () {
        switch (ctrl.column.dataType) {
          case "datetime":
          case "date":
          case "time":
            if (ctrl.column.defaultValue) {
              ctrl.obj = new Date(
                ctrl.mixDatabaseDataValue.column.defaultValue
              );
            }
            break;
          case "double":
            if (ctrl.column.defaultValue) {
              ctrl.model[ctrl.column.name] = parseFloat(
                ctrl.mixDatabaseDataValue.column.defaultValue
              );
            }
            break;
          case "boolean":
            if (ctrl.column.defaultValue) {
              ctrl.model[ctrl.column.name] =
                ctrl.mixDatabaseDataValue.column.defaultValue == "true";
            }
            break;

          default:
            if (ctrl.column.defaultValue) {
              ctrl.model[ctrl.column.name] = ctrl.column.defaultValue;
            }
            break;
        }
      };
      ctrl.updateJsonContent = function (content) {
        ctrl.model.obj[ctrl.column.name] = JSON.parse(content);
        $scope.$apply();
      };
      ctrl.updateValue = function () {
        switch (ctrl.column.dataType.toLowerCase()) {
          case "datetime":
            if (ctrl.obj) {
              ctrl.model.obj[ctrl.column.name] = ctrl.obj.toLocaleString();
            }
            break;
          case "date":
            if (ctrl.obj) {
              ctrl.model.obj[ctrl.column.name] = ctrl.obj.toLocaleDateString();
            }
            break;
          case "time":
            if (ctrl.obj) {
              ctrl.model.obj[ctrl.column.name] =
                ctrl.obj.toLocaleTimeString("en-GB");
            }
            break;
          default:
            if (ctrl.column.defaultValue) {
              ctrl.model[ctrl.column.name] = ctrl.column.defaultValue;
            }
            break;
        }
      };
    },
  ],
});

sharedComponents.component("mixColumnPreview", {
  templateUrl:
    "/mix-app/views/app-shared/components/mix-column-preview/view.html",
  bindings: {
    model: "=",
    column: "=",
    maxLength: "=?",
    isShowTitle: "=?",
    inputClass: "=?",
  },
  controller: [
    "$rootScope",
    "$sce",
    "$filter",
    function ($rootScope, $sce, $filter) {
      var ctrl = this;
      ctrl.previousId = null;

      ctrl.$onInit = function () {
        ctrl.parseView();
      };
      ctrl.parseView = function () {
        ctrl.uuid = $rootScope.generateUUID();
        var obj = $rootScope.testJSON(ctrl.model);
        ctrl.view = ctrl.model;
        if (ctrl.column.isEncrypt) {
          if (obj) {
            ctrl.encryptedData = obj;
            ctrl.model = ctrl.encryptedData.data;
            ctrl.decrypted = $rootScope.decrypt(ctrl.encryptedData);
          }
        } else {
          if (obj && ctrl.maxLength) {
            ctrl.view = JSON.stringify(ctrl.model);
          }
        }
        if (ctrl.maxLength && ctrl.view) {
          ctrl.view = $filter("trim")(ctrl.view, ctrl.maxLength);
        }
        if (ctrl.column.dataType == 20 && ctrl.model) {
          // youtube video
          ctrl.model = $sce.trustAsResourceUrl(
            "https://www.youtube.com/embed/" +
              ctrl.model +
              "?rel=0&showinfo=0&autoplay=0"
          );
        }
        // if(ctrl.column.dataType == 24 && ctrl.model) // youtube video
        // {
        //     ctrl.generateQRCode();
        // }
      };
      ctrl.generateQRCode = function () {
        setTimeout(() => {
          $("#" + ctrl.uuid).empty();
          $("#" + ctrl.uuid).qrcode(ctrl.model);
        }, 200);
      };
    },
  ],
});

sharedComponents.component("mixDataTable", {
  templateUrl:
    "/mix-app/views/app-shared/components/mix-data-table/mix-data-table.html",
  controller: [
    "$rootScope",
    "$scope",
    "$location",
    "ngAppSettings",
    function ($rootScope, $scope, $location, ngAppSettings) {
      var ctrl = this;
      ctrl.colWidth = 3;
      ctrl.init = function () {
        if (ctrl.data.items.length) {
          ctrl.min = ctrl.data.items[0].priority;
        }
        ctrl.colWidth = parseInt(9 / ctrl.columns.length);
        ctrl.lastColWidth = 9 % ctrl.columns.length > 0 ? 2 : 1;
      };
      ctrl.translate = $rootScope.translate;
      ctrl.selected = null;
      ctrl.updateOrders = function (index, items) {
        items.splice(index, 1);
        for (var i = 0; i < items.length; i++) {
          items[i].priority = ctrl.min + i;
        }
        ctrl.onUpdateInfos({ items: items });
      };

      ctrl.updateChildOrders = function (index, items) {
        items.splice(index, 1);
        for (var i = 0; i < items.length; i++) {
          items[i].priority = ctrl.min + i;
        }
        ctrl.onUpdateChildInfos({ items: items });
      };
      ctrl.dragoverCallback = function (index, item, external, type) {
        //console.log('drop ', index, item, external, type);
      };
      ctrl.insertCallback = function (index, item, external, type) {
        //console.log('insert ', index, item, external, type);
      };
      ctrl.delete = function (id) {
        ctrl.onDelete({ id: id });
      };
      ctrl.goTo = function (id) {
        $location.path(ctrl.editUrl + "/" + id);
      };
      ctrl.toggleChildNavs = function (nav) {
        nav.showChildNavs = nav.childNavs.length > 0 && !nav.showChildNavs;
      };
    },
  ],
  bindings: {
    data: "=",
    childName: "=",
    canDrag: "=",
    editUrl: "=",
    columns: "=",
    onDelete: "&",
    onUpdateInfos: "&",
    onUpdateChildInfos: "&",
  },
});

sharedComponents.component("mixDataPreview", {
  templateUrl:
    "/mix-app/views/app-shared/components/mix-data-preview/mix-data-preview.html",
  controller: [
    "$rootScope",
    function ($rootScope) {
      var ctrl = this;
    },
  ],
  bindings: {
    type: "=",
    value: "=",
    width: "=",
  },
});

"use strict";
appShared.controller("MixDatabaseDataClientController", [
  "$scope",
  "$rootScope",
  "ngAppSettings",
  "$routeParams",
  "$location",
  "RestMixDatabaseDataPortalService",
  "RestRelatedMixDatabasePortalService",
  "ApiService",
  "CommonService",
  function (
    $scope,
    $rootScope,
    ngAppSettings,
    $routeParams,
    $location,
    service,
    navService,
    commonService
  ) {
    BaseODataCtrl.call(
      this,
      $scope,
      $rootScope,
      $routeParams,
      ngAppSettings,
      service
    );
    $scope.defaultId = "default";
    $scope.parentId = null;
    $scope.parentType = null;
    $scope.cates = ["Site", "System"];
    $scope.others = [];
    $scope.importFile = {
      file: null,
      fullPath: "",
      folder: "import",
      title: "",
      description: "",
    };
    $scope.localizeSettings = $rootScope.globalSettings;
    $scope.canDrag =
      $scope.request.orderBy !== "Priority" || $scope.request.direction !== "0";
    $scope.init = async function () {
      $scope.mixDatabaseId = $routeParams.mixDatabaseId;
      $scope.mixDatabaseName = $routeParams.mixDatabaseName;
      $scope.dataId = $routeParams.dataId;
      $scope.refParentId = $routeParams.refParentId;
      $scope.refParentType = $routeParams.refParentType;
      if ($scope.refParentId && $scope.refParentType) {
        $scope.refDataModel = {
          parentId: $scope.refParentId,
          parentType: $scope.refParentType,
        };
      }
    };
    $scope.saveSuccessCallback = function () {
      if ($scope.refDataModel) {
        $scope.refDataModel.id = $scope.viewmodel.id;
        $scope.refDataModel.mixDatabaseId = $scope.viewmodel.mixDatabaseId;
        $scope.refDataModel.mixDatabaseName = $scope.viewmodel.mixDatabaseName;
        $scope.refDataModel.specificulture = $scope.viewmodel.specificulture;
        $scope.refDataModel.data = $scope.viewmodel;
        $rootScope.isBusy = true;
        navService.save("portal", $scope.refDataModel).then((resp) => {
          if (resp.isSucceed) {
            $rootScope.isBusy = false;
            $scope.$apply();
          } else {
            $rootScope.showMessage("failed");
            $rootScope.isBusy = false;
            $scope.$apply();
          }
        });
      }
    };
    $scope.export = async function (page = 0) {
      $rootScope.isBusy = true;
      $scope.mixDatabaseId = $routeParams.mixDatabaseId;
      $scope.mixDatabaseName = $routeParams.mixDatabaseName;
      if (page != undefined) {
        $scope.request.pageIndex = page;
      }
      var type = $routeParams.type;
      var parentId = $routeParams.parentId;
      var resp = await service.export(
        "portal",
        $scope.request,
        $scope.mixDatabaseId,
        $scope.mixDatabaseName,
        type,
        parentId
      );
      $scope.canDrag =
        $scope.request.orderBy !== "Priority" ||
        $scope.request.direction !== "0";
      if (resp && resp.isSucceed) {
        window.top.location = resp.data;
        $rootScope.isBusy = false;
        $scope.$apply();
      } else {
        if (resp) {
          $rootScope.showErrors(resp.errors);
        }
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };
    $scope.openImportDialog = function () {
      $("#inp-import-data").click();
    };

    $scope.getList = async function (page = 0) {
      $rootScope.isBusy = true;
      $scope.mixDatabaseId = $routeParams.mixDatabaseId;
      $scope.mixDatabaseName = $routeParams.mixDatabaseName;
      if (page != undefined) {
        $scope.request.pageIndex = page;
      }
      var type = $routeParams.type;
      var parentId = $routeParams.parentId;
      var response = await service.getList(
        "read",
        $scope.request,
        $scope.mixDatabaseId,
        $scope.mixDatabaseName,
        type,
        parentId
      );
      $scope.canDrag =
        $scope.request.orderBy !== "Priority" ||
        $scope.request.direction !== "0";
      if (response) {
        $scope.data = response;
        $scope.count([$routeParams.mixDatabaseName]);
        $rootScope.isBusy = false;
        $scope.$apply();
      } else {
        $rootScope.showErrors("Failed");
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };
    $scope.getSingle = async function () {
      $rootScope.isBusy = true;
      var id = $routeParams.id || $scope.defaultId;
      $scope.mixDatabaseId = $routeParams.mixDatabaseId;
      $scope.mixDatabaseName = $routeParams.mixDatabaseName;
      var resp = await service.getSingle("portal", [
        id,
        $scope.mixDatabaseId,
        $scope.mixDatabaseName,
      ]);
      if (resp) {
        $scope.viewmodel = resp;
        $scope.viewmodel.parentType = $scope.parentType;
        $scope.viewmodel.parentId = $scope.parentId;
        $rootScope.isBusy = false;
        $scope.$apply();
      } else {
        if (resp) {
          $rootScope.showErrors("Failed");
        }
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };
    $scope.preview = function (item) {
      item.editUrl = "/portal/post/details/" + item.id;
      $rootScope.preview("post", item, item.title, "modal-lg");
    };
    $scope.edit = function (data) {
      $scope.goToPath(
        "/portal/mix-database-data/details?dataId=" +
          data.id +
          "&mixDatabaseId=" +
          $scope.mixDatabaseId
      );
    };
    $scope.remove = function (data) {
      $rootScope.showConfirm(
        $scope,
        "removeConfirmed",
        [data.id],
        null,
        "Remove",
        "Deleted data will not able to recover, are you sure you want to delete this item?"
      );
    };

    $scope.removeConfirmed = async function (dataId) {
      $rootScope.isBusy = true;
      var result = await service.delete([dataId]);
      if (result.isSucceed) {
        if ($scope.removeCallback) {
          $rootScope.executeFunctionByName(
            "removeCallback",
            $scope.removeCallbackArgs,
            $scope
          );
        }
        $scope.getList();
      } else {
        $rootScope.showMessage("failed");
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };

    $scope.saveOthers = async function () {
      var response = await service.saveList($scope.others);
      if (response.isSucceed) {
        $scope.getList();
        $scope.$apply();
      } else {
        $rootScope.showErrors(response.errors);
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };
  },
]);

sharedComponents.component("mixDatabaseDataValuePreview", {
  templateUrl:
    "/mix-app/views/app-shared/components/mix-database-data-value-preview/view.html",
  controller: [
    "$rootScope",
    function ($rootScope) {
      var ctrl = this;
      ctrl.$onInit = function () {
        if (ctrl.data.column && ctrl.data.column.isEncrypt) {
          var encryptedData = {
            key: ctrl.data.encryptKey,
            data: ctrl.data.encryptValue,
          };
          ctrl.data.stringValue = $rootScope.decrypt(encryptedData);
        }
      };
    },
  ],
  bindings: {
    data: "=",
    width: "=",
  },
});

sharedComponents.component("mixDatabaseFormWeb", {
  templateUrl:
    "/mix-app/views/app-shared/components/mix-database-form-web/view.html",
  bindings: {
    mixDatabaseId: "=",
    mixDatabaseName: "=",
    mixDatabaseDataId: "=?",
    mixDatabaseData: "=?",
    parentType: "=?",
    parentId: "=?",
    defaultId: "=",
    saveData: "&?",
  },
  controller: [
    "$rootScope",
    "$scope",
    "RestMixDatabasePortalService",
    function ($rootScope, $scope, service) {
      var ctrl = this;
      ctrl.isBusy = false;
      ctrl.attributes = [];
      ctrl.defaultData = null;
      ctrl.selectedProp = null;
      ctrl.localizeSettings = $rootScope.globalSettings;
      ctrl.$onInit = async function () {
        ctrl.defaultData = await service.getSingle("web", [
          ctrl.defaultId,
          ctrl.mixDatabaseId,
          ctrl.mixDatabaseName,
        ]);
        ctrl.loadData();
      };
      ctrl.loadData = async function () {
        /*
                    If input is data id => load ctrl.mixDatabaseData from service and handle it independently
                    Else modify input ctrl.mixDatabaseData
                */
        $rootScope.isBusy = true;
        if (ctrl.mixDatabaseDataId) {
          ctrl.mixDatabaseData = await service.getSingle("portal", [
            ctrl.mixDatabaseDataId,
            ctrl.mixDatabaseId,
            ctrl.mixDatabaseName,
          ]);
          if (ctrl.mixDatabaseData) {
            ctrl.defaultData.mixDatabaseId = ctrl.mixDatabaseData.mixDatabaseId;
            ctrl.defaultData.mixDatabaseName =
              ctrl.mixDatabaseData.mixDatabaseName;
            $rootScope.isBusy = false;
            $scope.$apply();
          } else {
            if (ctrl.mixDatabaseData) {
              $rootScope.showErrors("Failed");
            }
            $rootScope.isBusy = false;
            $scope.$apply();
          }
        } else {
          if (!ctrl.mixDatabaseData) {
            ctrl.mixDatabaseData = angular.copy(ctrl.defaultData);
          }
          $rootScope.isBusy = false;
          $scope.$apply();
        }
      };
      ctrl.reload = async function () {
        ctrl.mixDatabaseData = angular.copy(ctrl.defaultData);
      };
      ctrl.submit = async function () {
        angular.forEach(ctrl.mixDatabaseData.values, function (e) {
          //Encrypt column before send
          if (e.column.isEncrypt) {
            var encryptData = $rootScope.encrypt(e.stringValue);
            e.encryptKey = encryptData.key;
            e.encryptValue = encryptData.data;
            e.stringValue = null;
          }
        });
        if (ctrl.saveData) {
          ctrl.isBusy = true;
          var result = await ctrl.saveData({ data: ctrl.mixDatabaseData });
          if (result && result.isSucceed) {
            ctrl.isBusy = false;
            ctrl.mixDatabaseData = result.data;
            $scope.$apply();
          } else {
            ctrl.isBusy = false;
            // ctrl.mixDatabaseData = await service.getSingle('portal', [ctrl.defaultId, ctrl.mixDatabaseId, ctrl.mixDatabaseName]);
            $scope.$apply();
          }
        } else {
          ctrl.isBusy = true;
          var saveResult = await service.save(ctrl.mixDatabaseData);
          if (saveResult.isSucceed) {
            ctrl.isBusy = false;
          } else {
            ctrl.isBusy = false;
            if (saveResult) {
              $rootScope.showErrors(saveResult.errors);
            }
            $scope.$apply();
          }
        }
      };

      ctrl.filterData = function (attributeName) {
        if (ctrl.mixDatabaseData) {
          var attr = $rootScope.findObjectByKey(
            ctrl.mixDatabaseData.data,
            "mixDatabaseColumnName",
            attributeName
          );
          if (!attr) {
            attr = angular.copy(
              $rootScope.findObjectByKey(
                ctrl.defaultData.data,
                "mixDatabaseColumnName",
                attributeName
              )
            );
            ctrl.mixDatabaseData.data.push(attr);
          }
          return attr;
        }
      };
    },
  ],
});

sharedComponents.component("mixDateEditor", {
  templateUrl: "/mix-app/views/app-shared/components/mix-date-editor/view.html",
  bindings: {
    utcDate: "=",
    isReadonly: "=?",
  },
  controller: [
    "$filter",
    function ($filter) {
      var ctrl = this;
      ctrl.$onInit = async function () {
        ctrl.readonly = ctrl.isReadonly === "true";
        if (ctrl.utcDate) {
          let local = $filter("utcToLocal")(ctrl.utcDate, "yyyy-MM-ddTHH:mm");
          ctrl.local = new Date(local);
        }
      };
      ctrl.update = function () {
        ctrl.utcDate = ctrl.local.toISOString();
      };
    },
  ],
});

sharedComponents.component("mixLoader", {
  templateUrl: "/mix-app/views/app-shared/components/mix-loader/view.html",
  controller: [
    "$rootScope",
    "$location",
    function ($rootScope, $location) {
      var ctrl = this;
      ctrl.imageDataArray = [];
      ctrl.canvasCount = 10;
      ctrl.duration = 500;
      ctrl.bgDuration = 2500;
      ctrl.canvas = null;
      ctrl.init = function () {
        html2canvas($(".mix-loader-container .content")[0]).then((canvas) => {
          ctrl.canvas = canvas;
        });
      };
      ctrl.swap = function () {
        var temp = document.createElement("canvas");
        var buffer = temp.getContext("2d");
        var scale = 0.5;
        //capture all div data as image
        // ctx = ctrl.canvas.getContext("2d");
        temp.width = ctrl.canvas.width * scale;
        temp.height = ctrl.canvas.height * scale;
        buffer.drawImage(
          ctrl.canvas,
          0,
          0,
          ctrl.canvas.width * scale,
          ctrl.canvas.height * scale
        );
        var imageData = buffer.getImageData(0, 0, temp.width, temp.height);
        var pixelArr = imageData.data;
        ctrl.createBlankImageData(imageData);
        //put pixel info to ctrl.imageDataArray (Weighted Distributed)
        for (let i = 0; i < pixelArr.length; i += 4) {
          //find the highest probability canvas the pixel should be in
          let p = Math.floor((i / pixelArr.length) * ctrl.canvasCount);
          let a = ctrl.imageDataArray[ctrl.weightedRandomDistrib(p)];
          a[i] = pixelArr[i];
          a[i + 1] = pixelArr[i + 1];
          a[i + 2] = pixelArr[i + 2];
          a[i + 3] = pixelArr[i + 3];
        }
        //create canvas for each imageData and append to target element
        for (let i = 0; i < ctrl.canvasCount; i++) {
          let c = ctrl.newCanvasFromImageData(
            ctrl.imageDataArray[i],
            temp.width,
            temp.height
          );
          c.classList.add("dust");
          $(".mix-loader-container").append(c);
        }
        //clear all children except the canvas
        $(".mix-loader-container .content")
          .children()
          .not(".dust")
          .fadeOut(ctrl.bgDuration);
        //apply animation
        $(".dust").each(function (index) {
          ctrl.animateBlur($(this), 0.8, ctrl.duration);
          setTimeout(() => {
            ctrl.animateTransform(
              $(this),
              100,
              -100,
              chance.integer({ min: -15, max: 15 }),
              ctrl.duration + 110 * index
            );
          }, 70 * index);
          //remove the canvas from DOM tree when faded
          $(this)
            .delay(70 * index)
            .fadeOut(110 * index + ctrl.duration, "swing", () => {
              $(this).remove();
            });
        });
      };
      ctrl.weightedRandomDistrib = function (peak) {
        var prob = [],
          seq = [];
        for (let i = 0; i < ctrl.canvasCount; i++) {
          prob.push(Math.pow(ctrl.canvasCount - Math.abs(peak - i), 3));
          seq.push(i);
        }
        return chance.weighted(seq, prob);
      };
      ctrl.animateBlur = function (elem, radius, duration) {
        var r = 0;
        $({ rad: 0 }).animate(
          { rad: radius },
          {
            duration: duration,
            easing: "swing",
            step: function (now) {
              elem.css({
                filter: "blur(" + now + "px)",
              });
            },
          }
        );
      };
      ctrl.animateTransform = function (elem, sx, sy, angle, duration) {
        var td = (tx = ty = 0);
        $({ x: 0, y: 0, deg: 0 }).animate(
          { x: sx, y: sy, deg: angle },
          {
            duration: duration,
            easing: "swing",
            step: function (now, fx) {
              if (fx.prop == "x") tx = now;
              else if (fx.prop == "y") ty = now;
              else if (fx.prop == "deg") td = now;
              elem.css({
                transform:
                  "rotate(" +
                  td +
                  "deg)" +
                  "translate(" +
                  tx +
                  "px," +
                  ty +
                  "px)",
              });
            },
          }
        );
      };
      ctrl.createBlankImageData = function (imageData) {
        for (let i = 0; i < ctrl.canvasCount; i++) {
          let arr = new Uint8ClampedArray(imageData.data);
          for (let j = 0; j < arr.length; j++) {
            arr[j] = 0;
          }
          ctrl.imageDataArray.push(arr);
        }
      };
      ctrl.newCanvasFromImageData = function (imageDataArray, w, h) {
        var canvas = document.createElement("canvas");
        canvas.width = w;
        canvas.height = h;
        tempCtx = canvas.getContext("2d");
        tempCtx.putImageData(new ImageData(imageDataArray, w, h), 0, 0);

        return canvas;
      };
    },
  ],

  bindings: {
    isShow: "=",
  },
});

sharedComponents.component("mixModuleDataTable", {
  templateUrl:
    "/mix-app/views/app-shared/components/mix-module-data-table/mix-module-data-table.html",
  controller: [
    "$rootScope",
    "$scope",
    "$location",
    "ngAppSettings",
    "SharedModuleDataService",
    function ($rootScope, $scope, $location, ngAppSettings, dataService) {
      var ctrl = this;
      ctrl.colWidth = 3;
      ctrl.init = function () {
        ctrl.editUrl = "/portal/module-data/details/" + ctrl.moduleId;
        ctrl.visible = $rootScope.visible;
        if (ctrl.data.items.length) {
          ctrl.min = ctrl.data.items[0].priority;
          if (!ctrl.min) {
            ctrl.min = 0;
          }
        }
        ctrl.colWidth = parseInt(9 / ctrl.columns.length);
        ctrl.lastColWidth = 9 % ctrl.columns.length > 0 ? 2 : 1;
      };
      ctrl.translate = $rootScope.translate;
      ctrl.selected = null;
      ctrl.updateOrders = function (index, items) {
        items.splice(index, 1);
        for (var i = 0; i < items.length; i++) {
          items[i].priority = ctrl.min + i;
        }
        ctrl.updateDataInfos(items);
      };
      ctrl.updateDataInfos = async function (items) {
        $rootScope.isBusy = true;
        var resp = await dataService.updateInfos(items);
        if (resp && resp.isSucceed) {
          $scope.activedPage = resp.data;
          $rootScope.showMessage("success", "success");
          $rootScope.isBusy = false;
          $scope.$apply();
        } else {
          if (resp) {
            $rootScope.showErrors(resp.errors);
          }
          $rootScope.isBusy = false;
          $scope.$apply();
        }
      };
      ctrl.dragoverCallback = function (index, item, external, type) {
        //console.log('drop ', index, item, external, type);
      };
      ctrl.insertCallback = function (index, item, external, type) {
        //console.log('insert ', index, item, external, type);
      };
      ctrl.delete = function (id) {
        ctrl.onDelete({ id: id });
      };
      ctrl.goTo = function (id) {
        $location.path(ctrl.editUrl + "/" + id);
      };
      ctrl.toggleChildNavs = function (nav) {
        nav.showChildNavs = nav.childNavs.length > 0 && !nav.showChildNavs;
      };
      ctrl.view = function (moduleId, contentId) {
        var obj = {
          moduleId: moduleId,
          id: contentId,
        };
        $rootScope.preview("module-data", obj, null, "modal-lg");
      };
    },
  ],
  bindings: {
    moduleId: "=",
    data: "=",
    childName: "=",
    canDrag: "=",
    editUrl: "=",
    columns: "=",
    onDelete: "&",
    // onUpdateInfos: '&',
    onUpdateChildInfos: "&",
  },
});

"use strict";
appShared.controller("ModalPostController", [
  "$scope",
  "$rootScope",
  "$location",
  "ngAppSettings",
  "$routeParams",
  "PostRestService",
  function (
    $scope,
    $rootScope,
    $location,
    ngAppSettings,
    $routeParams,
    service
  ) {
    BaseCtrl.call(
      this,
      $scope,
      $rootScope,
      $routeParams,
      ngAppSettings,
      service
    );
    $scope.columns = [
      {
        title: "Title",
        name: "title",
        filter: true,
        type: "string",
      },
      {
        title: "Url",
        name: "imageUrl",
        filter: true,
        type: "upload",
      },
    ];
  },
]);

"use strict";
appShared.factory("ModalPostRestService", [
  "$rootScope",
  "ApiService",
  "CommonService",
  "BaseService",
  function ($rootScope, apiService, commonService, baseService) {
    var serviceFactory = Object.create(baseService);
    serviceFactory.init("page-post");
    return serviceFactory;
  },
]);

sharedComponents.component("modalPosts", {
  templateUrl:
    "/mix-app/views/app-shared/components/modal-posts/modal-posts.html",
  controller: "ModalPostController",
  bindings: {
    data: "=",
    childName: "=",
    canDrag: "=",
    editUrl: "=",
    columns: "=",
    onDelete: "&",
    onUpdateInfos: "&",
    onUpdateChildInfos: "&",
  },
});

sharedComponents.component("mixSelect", {
  templateUrl: "/mix-app/views/app-shared/components/mix-select/view.html",
  bindings: {
    options: "=",
    model: "=",
    allowNull: "=?",
    callback: "&?",
  },
  controller: [
    "$rootScope",
    "$scope",
    function PortalTemplateController($rootScope, $scope) {
      var ctrl = this;
      ctrl.onSelect = function () {
        ctrl.callback({ type: ctrl.model });
      };
    },
  ],
});

sharedComponents.controller(
  "ModalCroppieController",
  function (
    $rootScope,
    $scope,
    $http,
    $uibModalInstance,
    mediaService,
    file,
    w,
    h,
    rto,
    autoSave
  ) {
    var ctrl = this;
    ctrl.autoSave = autoSave;
    ctrl.maxW = 400;
    ctrl.file = file;
    ctrl.w = w;
    ctrl.h = h;
    ctrl.rto = rto;
    ctrl.isAdmin = $rootScope.isAdmin;
    ctrl.postedFile = {};
    ctrl.isImage = false;
    ctrl.mediaNavs = [];
    ctrl.media = {
      title: "",
      mediaFile: {
        file: null,
      },
    };
    ctrl.image_placeholder = "/mix-app/assets/img/image_placeholder.jpg";
    ctrl.options = null;
    ctrl.init = function () {
      ctrl.srcUrl = ctrl.srcUrl || ctrl.image_placeholder;
      ctrl.maxHeight = ctrl.maxHeight || "2000px";
      ctrl.id = Math.floor(Math.random() * 100);
      ctrl.canvas = document.getElementById(`canvas-${ctrl.id}`);
      ctrl.cropped = {
        source: null,
      };
      if (ctrl.frameUrl) {
        ctrl.frame = ctrl.loadImage(frameUrl);
      }

      if (ctrl.srcUrl) {
        ctrl.loadBase64(ctrl.srcUrl);
      }

      if (ctrl.file) {
        setTimeout(() => {
          ctrl.selectFile([ctrl.file]);
        }, 500);
      }

      // Assign blob to component when selecting a image
    };

    ctrl.loadFromUrl = function () {
      if (ctrl.src !== ctrl.srcUrl && ctrl.srcUrl != ctrl.image_placeholder) {
        ctrl.src = ctrl.srcUrl;
        ctrl.isImage = ctrl.srcUrl
          .toLowerCase()
          .match(/([/|.|\w|\s|-])*\.(?:jpg|jpeg|gif|png|svg)/g);
        if (ctrl.isImage) {
          ctrl.loadBase64(ctrl.srcUrl);
        }
      }
    };

    ctrl.origin = function () {
      $uibModalInstance.close();
    };

    ctrl.ok = async function () {
      if (!ctrl.autoSave) {
        $uibModalInstance.close(ctrl.cropped.image);
      } else {
        ctrl.media.fileFolder = ctrl.folder || "Media";
        ctrl.media.fileName = ctrl.media.mediaFile.fileName;
        ctrl.media.extension = ctrl.media.mediaFile.extension;
        ctrl.media.mediaFile.fileStream = ctrl.cropped.image;
        var result = await mediaService.save(ctrl.media);
        if (result.isSucceed) {
          $uibModalInstance.close(result.data);
        }
      }
    };

    ctrl.cancel = function () {
      $uibModalInstance.dismiss("cancel");
    };
    ctrl.combineImage = function () {
      ctrl.canvas = document.getElementById(`canvas-${ctrl.id}`);
      if (ctrl.canvas) {
        var img = document.getElementById("croppie-src");
        var w = ctrl.options.boundary.width;
        var h = ctrl.options.boundary.height;
        // var rto = w / h;
        var newW = ctrl.options.output.width;
        var newH = ctrl.options.output.height;
        var ctx = ctrl.canvas.getContext("2d");
        ctx.imageSmoothingEnabled = true;
        ctx.drawImage(img, 0, 0, newW, newH);
        if (ctrl.frame) {
          // combine with frame
          ctx.drawImage(ctrl.frame, 0, 0, w, h);
        }

        $scope.$apply(function () {
          ctrl.postedFile.fileStream = ctrl.canvas.toDataURL(); //ctx.getImageData(0, 0, 300, 350);
          ctrl.imgUrl = ctrl.postedFile.fileStream.replace(
            "image/png",
            "image/octet-stream"
          );
        });
      }
    };
    ctrl.saveCanvas = function () {
      var link = document.createElement("a");
      link.download = ctrl.postedFile.fileName + ctrl.postedFile.extension;
      $rootScope.isBusy = true;
      ctrl.canvas.toBlob(function (blob) {
        link.href = URL.createObjectURL(blob);
        link.click();
        $rootScope.isBusy = false;
        $scope.$apply();
      }, "image/png");
    };
    ctrl._arrayBufferToBase64 = function (buffer) {
      var binary = "";
      var bytes = new Uint8Array(buffer);
      var len = bytes.byteLength;
      for (var i = 0; i < len; i++) {
        binary += String.fromCharCode(bytes[i]);
      }
      return window.btoa(binary);
    };

    ctrl.selectFile = function (files) {
      if (files !== undefined && files !== null && files.length > 0) {
        const file = files[0];
        ctrl.media.folder = ctrl.folder ? ctrl.folder : "Media";
        ctrl.media.title = ctrl.title ? ctrl.title : file.name;
        ctrl.media.description = ctrl.description ? ctrl.description : "";
        ctrl.media.mediaFile.fileName = file.name.substring(
          0,
          file.name.lastIndexOf(".")
        );
        ctrl.media.mediaFile.extension = file.name.substring(
          file.name.lastIndexOf(".")
        );
        ctrl.getBase64(file);
        // if (file.size < 100000) {
        //   var msg = "Please choose a better photo (larger than 100kb)!";
        //   $rootScope.showConfirm(ctrl, null, [], null, null, msg);
        // } else {
        // }
      }
    };
    ctrl.loadBase64 = function (url) {
      var ext = url.substring(url.lastIndexOf(".") + 1);
      $http({
        method: "GET",
        url: url,
        responseType: "arraybuffer",
      }).then(function (resp) {
        var base64 = `data:image/${ext};base64,${ctrl._arrayBufferToBase64(
          resp.data
        )}`;
        var image = new Image();
        image.src = base64;
        image.onload = function () {
          // access image size here
          ctrl.originW = this.width;
          ctrl.originH = this.height;

          ctrl.loadImageSize(this.width, this.height);
          ctrl.cropped.source = base64;
          $scope.$apply();
        };
        return base64;
      });
    };
    ctrl.getBase64 = function (file) {
      if (file !== null) {
        $rootScope.isBusy = true;
        var reader = new FileReader();
        reader.readAsDataURL(file);
        // ctrl.cropped.source = null;
        reader.onload = function () {
          if (ctrl.media.mediaFile) {
            ctrl.media.mediaFile.fileName = file.name.substring(
              0,
              file.name.lastIndexOf(".")
            );
            ctrl.media.mediaFile.extension = file.name.substring(
              file.name.lastIndexOf(".")
            );
            // ctrl.postedFile.fileStream = reader.result;
          }
          var image = new Image();
          image.src = reader.result;

          image.onload = function () {
            // access image size here
            ctrl.originW = this.width;
            ctrl.originH = this.height;
            ctrl.loadImageSize(this.width, this.height);
            ctrl.cropped.source = reader.result;
            $rootScope.isBusy = false;
            $scope.$apply();
          };
        };
        reader.onerror = function (error) {
          $rootScope.isBusy = false;
          $rootScope.showErrors([error]);
        };
      } else {
        return null;
      }
    };
    ctrl.loadImageSize = function (w, h) {
      // const maxW = ctrl.w + 100;
      w = w || ctrl.originW;
      h = h || ctrl.originH;
      var rto = w / h;
      ctrl.rto = ctrl.rto || rto;
      ctrl.w = ctrl.w || w;
      ctrl.h = ctrl.w / ctrl.rto;
      ctrl.options = {
        boundary: { height: ctrl.maxW / rto, width: ctrl.maxW },
        render: { height: ctrl.maxW / rto, width: ctrl.maxW },
        output: { height: ctrl.h, width: ctrl.h * ctrl.rto },
      };
      ctrl.loadViewport();
    };
    ctrl.loadViewport = function () {
      if (ctrl.w && ctrl.h) {
        ctrl.rto = ctrl.w / ctrl.h;
        let w = ctrl.w > ctrl.maxW ? ctrl.maxW * 0.6 : ctrl.w * 0.6;
        let h = w / ctrl.rto;
        if (w > ctrl.options.boundary.width) {
          w = ctrl.options.boundary.width;
          h = w / ctrl.rto;
        }
        ctrl.options.viewport = {
          height: h,
          width: w,
        };
      }
    };
  }
);

// sharedComponents.component('modalConfirm', {
//     templateUrl: '/mix-app/views/app-shared/components/modal-confirm/modal-confirm.html',
//     controller: ModalConfirmController,
//     bindings: {
//         message: '='
//     }
// });
function ModalConfirmController($rootScope, $scope, $mdDialog, message) {
  $scope.message = message;
  $scope.executeFunctionByName = async function (functionName, args, context) {
    var result = await $rootScope.executeFunctionByName(
      functionName,
      args,
      context
    );
    if (result) {
      $scope.$apply();
    }
    $mdDialog.hide();
  };
  $scope.closeDialog = function () {
    $mdDialog.hide();
  };
}

"use strict";
appShared.controller("SharedModuleDataController", [
  "$scope",
  "$rootScope",
  "ngAppSettings",
  "$routeParams",
  "$timeout",
  "$location",
  "AuthService",
  "SharedModuleDataService",
  function (
    $scope,
    $rootScope,
    ngAppSettings,
    $routeParams,
    $timeout,
    $location,
    authService,
    moduleDataService
  ) {
    $scope.request = {
      pageSize: "10",
      pageIndex: 0,
      status: "Published",
      orderBy: "CreatedDateTime",
      direction: "Desc",
      fromDate: null,
      toDate: null,
      keyword: "",
    };
    $scope.moduleDataFile = {
      file: null,
      fullPath: "",
      folder: "ModuleData",
      title: "",
      description: "",
    };
    $scope.activedModuleData = null;
    $scope.relatedModuleDatas = [];
    $rootScope.isBusy = false;
    $scope.data = {
      pageIndex: 0,
      pageSize: 1,
      totalItems: 0,
    };
    $scope.errors = [];

    $scope.range = function (max) {
      var input = [];
      for (var i = 1; i <= max; i += 1) input.push(i);
      return input;
    };

    $scope.getModuleData = async function (id) {
      $rootScope.isBusy = true;
      var resp = await moduleDataService.getModuleData(id, "portal");
      if (resp && resp.isSucceed) {
        $scope.activedModuleData = resp.data;
        $rootScope.initEditor();
        $rootScope.isBusy = false;
        $scope.$apply();
      } else {
        if (resp) {
          $rootScope.showErrors(resp.errors);
        }
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };

    $scope.initModuleForm = async function (name) {
      var resp = null;
      $scope.name = name;
      if ($scope.id) {
        resp = await moduleDataService.getModuleData(
          $scope.id,
          $scope.dataId,
          "portal"
        );
      } else {
        resp = await moduleDataService.initModuleForm($scope.name);
      }

      if (resp && resp.isSucceed) {
        $scope.activedModuleData = resp.data;
        $rootScope.isBusy = false;
        $scope.$apply();
      } else {
        if (resp) {
          $rootScope.showErrors(resp.errors);
        }
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };

    $scope.loadParams = async function () {
      $scope.dataId = $routeParams.id;
      $scope.backUrl = "/portal/module-data/list/" + $routeParams.moduleId;
      $scope.moduleId = $routeParams.moduleId;
    };

    $scope.loadModuleData = async function () {
      $rootScope.isBusy = true;
      var moduleId = $routeParams.moduleId;
      var id = $routeParams.id;
      var response = await moduleDataService.getModuleData(
        moduleId,
        id,
        "portal"
      );
      if (response.isSucceed) {
        $scope.activedModuleData = response.data;
        $rootScope.initEditor();
        $rootScope.isBusy = false;
        $scope.$apply();
      } else {
        $rootScope.showErrors(response.errors);
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };
    $scope.loadModuleDatas = async function (moduleId, pageIndex) {
      $scope.request.key = moduleId;
      if (pageIndex !== undefined) {
        $scope.request.pageIndex = pageIndex;
      }
      if ($scope.request.fromDate !== null) {
        var d = new Date($scope.request.fromDate);
        $scope.request.fromDate = d.toISOString();
      }
      if ($scope.request.toDate !== null) {
        var d = new Date($scope.request.toDate);
        $scope.request.toDate = d.toISOString();
      }
      var resp = await moduleDataService.getModuleDatas($scope.request);
      if (resp && resp.isSucceed) {
        $scope.data = resp.data;
        $rootScope.isBusy = false;
        $scope.$apply();
      } else {
        if (resp) {
          $rootScope.showErrors(resp.errors);
        }
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };

    $scope.removeModuleData = async function (id) {
      if (confirm("Are you sure!")) {
        var resp = await moduleDataService.removeModuleData(id);
        if (resp && resp.isSucceed) {
          $scope.loadModuleDatas();
        } else {
          if (resp) {
            $rootScope.showErrors(resp.errors);
          }
        }
      }
    };

    $scope.saveModuleData = async function () {
      var resp = await moduleDataService.saveModuleData(
        $scope.activedModuleData
      );
      if (resp && resp.isSucceed) {
        $scope.activedModuleData = resp.data;
        $rootScope.showMessage("Update successfully!", "success");
        $rootScope.isBusy = false;
        $scope.initModuleForm($scope.name);
        $rootScope.isBusy = false;
        $scope.$apply();
        //$location.path('/portal/moduleData/details/' + resp.data.id);
      } else {
        if (resp) {
          $rootScope.showErrors(resp.errors);
        }
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };
  },
]);

"use strict";
appShared.factory("SharedModuleDataService", [
  "$http",
  "$rootScope",
  "ApiService",
  "CommonService",
  function ($http, $rootScope, apiService, commonService) {
    var moduleDatasServiceFactory = {};

    var _updateInfos = async function (pages) {
      var apiUrl = "/" + $rootScope.localizeSettings.lang + "/module-data";
      var req = {
        method: "POST",
        url: apiUrl + "/update-infos",
        data: JSON.stringify(pages),
      };
      return await apiService.getApiResult(req);
    };

    var _getModuleData = async function (moduleId, id, type) {
      var apiUrl = "/" + $rootScope.localizeSettings.lang + "/module-data/";
      var url = apiUrl + "details/" + type;
      if (id) {
        url += "/" + moduleId + "/" + id;
      } else {
        url += "/" + moduleId;
      }
      var req = {
        method: "GET",
        url: url,
      };
      return await apiService.getApiResult(req);
    };

    var _getModuleDatas = async function (request) {
      var apiUrl = "/" + $rootScope.localizeSettings.lang + "/module-data/";
      var req = {
        method: "POST",
        url: apiUrl + "list",
        data: JSON.stringify(request),
      };

      return await apiService.getApiResult(req);
    };

    var _exportModuleData = async function (request) {
      var apiUrl = "/" + $rootScope.localizeSettings.lang + "/module-data/";
      var req = {
        method: "POST",
        url: apiUrl + "export",
        data: JSON.stringify(request),
      };

      return await apiService.getApiResult(req);
    };

    var _initModuleForm = async function (name) {
      var apiUrl = "/" + $rootScope.localizeSettings.lang + "/module-data/";
      var req = {
        method: "GET",
        url: apiUrl + "init-by-name/" + name,
      };

      return await apiService.getApiResult(req);
    };

    var _removeModuleData = async function (id) {
      var apiUrl = "/" + $rootScope.localizeSettings.lang + "/module-data/";
      var req = {
        method: "GET",
        url: apiUrl + "delete/" + id,
      };
      return await apiService.getApiResult(req);
    };

    var _saveModuleData = async function (moduleData) {
      var apiUrl = "/" + $rootScope.localizeSettings.lang + "/module-data/";
      var req = {
        method: "POST",
        url: apiUrl + "save",
        data: JSON.stringify(moduleData),
      };
      return await apiService.getApiResult(req);
    };
    var _saveFields = async function (id, propertyName, propertyValue) {
      var apiUrl = "/" + $rootScope.localizeSettings.lang + "/module-data/";
      var column = [
        {
          propertyName: propertyName,
          propertyValue: propertyValue,
        },
      ];
      var req = {
        method: "POST",
        url: apiUrl + "save/" + id,
        data: JSON.stringify(column),
      };
      return await apiService.getApiResult(req);
    };
    moduleDatasServiceFactory.getModuleData = _getModuleData;
    moduleDatasServiceFactory.getModuleDatas = _getModuleDatas;
    moduleDatasServiceFactory.exportModuleData = _exportModuleData;
    moduleDatasServiceFactory.removeModuleData = _removeModuleData;
    moduleDatasServiceFactory.saveModuleData = _saveModuleData;
    moduleDatasServiceFactory.initModuleForm = _initModuleForm;
    moduleDatasServiceFactory.saveFields = _saveFields;
    moduleDatasServiceFactory.updateInfos = _updateInfos;
    return moduleDatasServiceFactory;
  },
]);

sharedComponents.component("moduleDataPreview", {
  templateUrl:
    "/mix-app/views/app-shared/components/module-data-preview/module-data-preview.html",
  controller: [
    "$rootScope",
    function ($rootScope) {
      var ctrl = this;

      ctrl.translate = $rootScope.translate;
      ctrl.$onInit = () => {
        if (!ctrl.datatype) {
          ctrl.datatype = ctrl.data.dataType;
        }
      };
    },
  ],
  bindings: {
    data: "=",
    datatype: "=?",
    width: "=",
    header: "=",
  },
});

sharedComponents.component("moduleForm", {
  templateUrl: "/mix-app/views/app-shared/components/module-form/view.html",
  bindings: {
    moduleId: "=",
    categoryId: "=",
    productId: "=",
    postId: "=",
    d: "=",
    title: "=",
    name: "=",
    submitText: "=",
    isShowTitle: "=",
    backUrl: "=?",
    saveCallback: "&?",
    failedCallback: "&?",
  },
  controller: [
    "$scope",
    "$rootScope",
    "ngAppSettings",
    "$routeParams",
    "$timeout",
    "$location",
    "AuthService",
    "ModuleDataRestService",
    function (
      $scope,
      $rootScope,
      ngAppSettings,
      $routeParams,
      $timeout,
      $location,
      authService,
      moduleDataService
    ) {
      var ctrl = this;
      $rootScope.isBusy = false;

      ctrl.initModuleForm = async function () {
        var resp = null;
        if (!$rootScope.isInit) {
          setTimeout(function () {
            ctrl.initModuleForm();
          }, 500);
        } else {
          if (!ctrl.moduleId) {
            resp = await moduleDataService.initModuleForm(ctrl.name);
          } else {
            if (ctrl.d) {
              resp = await moduleDataService.getSingle([ctrl.d]);
            } else {
              resp = await moduleDataService.initForm(ctrl.moduleId);
            }
          }
          if (resp && resp.isSucceed) {
            ctrl.data = resp.data;
            ctrl.data.postId = ctrl.postId;
            ctrl.data.productId = ctrl.productId;
            ctrl.data.categoryId = ctrl.categoryId;
            angular.forEach(ctrl.data.dataProperties, function (e) {
              if (!ctrl.data.jItem[e.name]) {
                ctrl.data.jItem[e.name] = {
                  dataType: e.dataType,
                  value: null,
                };
              }
            });

            $rootScope.isBusy = false;
            $scope.$apply();
          } else {
            if (resp) {
              $rootScope.showErrors(resp.errors);
            }
            $rootScope.isBusy = false;
            $scope.$apply();
          }
        }
      };

      ctrl.loadModuleData = async function () {
        $rootScope.isBusy = true;
        var id = $routeParams.id;
        var response = await moduleDataService.getModuleData(
          ctrl.moduleId,
          ctrl.d,
          "portal"
        );
        if (response.isSucceed) {
          ctrl.data = response.data;
          //$rootScope.initEditor();
          $rootScope.isBusy = false;
          $scope.$apply();
        } else {
          $rootScope.showErrors(response.errors);
          $rootScope.isBusy = false;
          $scope.$apply();
        }
      };
      ctrl.submitFormData = async function () {
        if ($(".g-recaptcha").length > 0) {
        } else {
          ctrl.saveModuleData();
        }
      };
      ctrl.saveModuleData = async function () {
        $rootScope.isBusy = true;
        var form = $("#module-" + ctrl.data.moduleId);
        console.log(ctrl.data);
        $.each(ctrl.data.dataProperties, function (i, e) {
          switch (e.dataType) {
            case 5:
              e.value = $(form)
                .find("." + e.name)
                .val();
              break;
            default:
              e.value = e.value ? e.value.toString() : null;
              break;
          }
        });
        var resp = await moduleDataService.save(ctrl.data);
        if (resp && resp.isSucceed) {
          ctrl.data = resp.data;
          if (ctrl.saveSuccessCallback) {
            ctrl.saveSuccessCallback({
              data: ctrl.data,
            });
            $rootScope.isBusy = false;
            $scope.$apply();
          } else {
            var msg = $rootScope.translate("success");
            $rootScope.showMessage(msg, "success");
            // ctrl.initModuleForm();
            $rootScope.isBusy = false;
            $scope.$apply();
          }
        } else {
          if (resp) {
            // if(ctrl.failedCallback){
            //     ctrl.failedCallback({ response: resp });
            // }
            // else{
            //     $rootScope.showErrors(resp.errors);
            // }
            $rootScope.showErrors(resp.errors);
          }

          $rootScope.isBusy = false;
          $scope.$apply();
        }
      };
    },
  ],
});

sharedComponents.component("moduleFormEditor", {
  templateUrl:
    "/mix-app/views/app-shared/components/module-form-editor/view.html",
  bindings: {
    data: "=",
    datatype: "=?",
    column: "=?",
    inputClass: "=",
    isShowTitle: "=",
    columnTitle: "=",
  },
  controller: [
    "$rootScope",
    "$scope",
    "$filter",
    "ngAppSettings",
    function ($rootScope, $scope, $filter, ngAppSettings) {
      var ctrl = this;
      ctrl.icons = ngAppSettings.icons;
      this.dataTypes = ngAppSettings.dataTypes;
      ctrl.$onInit = function () {
        ctrl.dataType = ctrl.datatype
          ? ctrl.datatype.toLowerCase()
          : ctrl.data.dataType.toLowerCase();
        ctrl.obj = null;
        switch (ctrl.dataType) {
          case "datetime":
          case "date":
          case "time":
            if (ctrl.data.value) {
              ctrl.obj = new Date(ctrl.data.value);
            }
            break;
          case "boolean":
            ctrl.obj = String(ctrl.data.value) == "true";
            break;
          default:
            if (ctrl.column && !ctrl.data.value) {
              ctrl.data.value = ctrl.column.defaultValue;
              ctrl.obj = ctrl.column.defaultValue;
            }
            break;
        }
      };
      ctrl.updateValue = function () {
        switch (ctrl.dataType) {
          case "datetime":
            if (ctrl.obj) {
              ctrl.data.value = ctrl.obj.toLocaleString();
            }
            break;
          case "date":
            if (ctrl.obj) {
              ctrl.data.value = ctrl.obj.toLocaleDateString();
            }
            break;
          case "time":
            if (ctrl.obj) {
              ctrl.data.value = ctrl.obj.toLocaleTimeString("en-GB");
            }
            break;

          case "boolean":
            ctrl.data.value = ctrl.obj.toString().toLowerCase();
            break;
          default:
            ctrl.data.value = ctrl.obj;
            break;
        }
        console.log(ctrl.data.value);
      };
    },
  ],
});

sharedComponents.component("onePay", {
  templateUrl: "/mix-app/views/app-shared/components/one-pay/view.html",
  bindings: {
    cartData: "=?",
    successCallback: "&?",
  },
  controller: "OnePayShoppingCartController",
});

sharedComponents.controller("OnePayShoppingCartController", [
  "$rootScope",
  "$scope",
  "$controller",
  "localStorageService",
  "RestMixDatabaseDataClientService",
  function ($rootScope, $scope, $controller, localStorageService, dataService) {
    angular.extend(
      this,
      $controller("ShoppingCartController", { $scope: $scope })
    );
    $scope.url = " https://mtf.onepay.vn/onecomm-pay/vpc.op";

    $scope.init = async function (
      validateCallback,
      successCallback,
      failCallback
    ) {
      $scope.validateCallback = validateCallback;
      $scope.successCallback = successCallback;
      $scope.failCallback = failCallback;

      $scope.cartData =
        $scope.cartData || localStorageService.get("shoppingCart");
      $scope.initRequest();
      $scope.initResponse();
    };

    $scope.initRequest = async function () {
      var getRequest = await dataService.initData("onepayRequest");
      $scope.request = getRequest.data;
      $scope.request.obj.vpc_Amount = $scope.cartData.total;
      $scope.request.obj.vpc_ReturnURL = window.top.location.href;
      $scope.request.obj.AgainLink = window.top.location.href;
    };
    $scope.initResponse = async function () {
      var getResponse = await dataService.initData("onepayResponse");
      $scope.response = getResponse.data.obj;
    };
    $scope.onSuccess = async function (resp) {
      $scope.cartData = resp;
      localStorageService.set("shoppingCart", $scope.cartData);

      $scope.request.obj.vpc_MerchTxnRef = resp.id;
      $scope.request.obj.vpc_OrderInfo = resp.id;
      $scope.request.obj.Title = `Order ${$scope.cartData.name}`;
      dataService.save($scope.request);

      $scope.url = `${$scope.url}?${dataService.parseQuery(
        $scope.request.obj
      )}`;
      window.top.location = $scope.url;
    };
    $scope.paymentSuccess = async function (resp) {
      await dataService.saveValues($scope.cartData.id, { status: "Paid" });

      if ($scope.successCallback) {
        $rootScope.executeFunctionByName(
          $scope.successCallback,
          [resp],
          window
        );
      } else {
        window.location.href = "/";
      }
    };
  },
]);

sharedComponents.component("modulePreview", {
  templateUrl: "/mix-app/views/app-shared/components/module-preview/view.html",
  controller: [
    "$scope",
    "$rootScope",
    "SharedModuleDataService",
    function ($scope, $rootScope, moduleDataService) {
      var ctrl = this;
      $rootScope.isBusy = false;
      ctrl.previousContentId = undefined;

      this.$onInit = () => {
        ctrl.previousContentId = angular.copy(ctrl.contentId);
      };

      this.$doCheck = () => {
        if (ctrl.contentId !== ctrl.previousContentId) {
          ctrl.loadModuleData();
          ctrl.previousContentId = ctrl.contentId;
        }
      };

      ctrl.loadModuleData = async function () {
        $rootScope.isBusy = true;
        var response = await moduleDataService.getModuleData(
          ctrl.moduleId,
          ctrl.contentId,
          "portal"
        );
        if (response.isSucceed) {
          ctrl.data = response.data;
          $rootScope.isBusy = false;
          $scope.$apply();
        } else {
          $rootScope.showErrors(response.errors);
          $rootScope.isBusy = false;
          $scope.$apply();
        }
      };
    },
  ],
  bindings: {
    moduleId: "=",
    contentId: "=",
  },
});

sharedComponents.component("mixPaging", {
  templateUrl: "/mix-app/views/app-shared/components/paging/paging.html",
  controller: [
    "$rootScope",
    function ($rootScope) {
      var ctrl = this;
      ctrl.loadData = function (index) {
        ctrl.pagingAction({ pageIndex: index });
      };
      ctrl.range = $rootScope.range;
    },
  ],
  bindings: {
    data: "=",
    activeClass: "=",
    ulClass: "=",
    page: "=",
    pageSize: "=",
    total: "=",
    totalPage: "=",
    pagingAction: "&",
  },
});

"use trick";
sharedComponents.directive("pill", function () {
  return {
    require: "^pills",
    restrict: "E",
    transclude: true,
    scope: { header: "@", id: "@", icon: "@" },
    link: function (scope, element, attrs, tabsController) {
      tabsController.addPane(scope);
    },
    template:
      '<div class="tab-pane" ng-class="{active: selected}" ng-transclude>' +
      "</div>",
    replace: true,
  };
});

sharedComponents.directive("pills", function () {
  return {
    restrict: "E",
    transclude: true,
    scope: {
      selectCallback: "&",
    },
    controller: function ($scope, $element) {
      var panes = ($scope.panes = []);

      $scope.select = function (pane) {
        angular.forEach(panes, function (pane) {
          pane.selected = false;
        });
        pane.selected = true;
        this.selectCallback({ pane: pane });
      };

      this.addPane = function (pane) {
        if (panes.length === 0) $scope.select(pane);
        panes.push(pane);
      };
    },
    templateUrl: "/mix-app/views/app-shared/components/pills/pills.html",
    replace: true,
  };
});

sharedComponents.component("payPal", {
  templateUrl: "/mix-app/views/app-shared/components/pay-pal/view.html",
  bindings: {
    cartData: "=?",
    isBusy: "=?",
    onSuccess: "=?", // name of function ex: window.onSuccess => 'onSuccess'
    onFail: "=?", // name of function ex: window.onFail => 'onFail'
  },
  controller: [
    "$rootScope",
    "$scope",
    "localStorageService",
    "RestMixDatabaseDataClientService",
    function ($rootScope, $scope, localStorageService, dataService) {
      var ctrl = this;

      ctrl.init = function () {
        ctrl.cartData =
          ctrl.cartData || localStorageService.get("shoppingCart");
        let total = Math.round(ctrl.cartData.total / 23000);
        paypal
          .Buttons({
            createOrder: function (data, actions) {
              // This function sets up the details of the transaction, including the amount and line item details.
              return actions.order.create({
                purchase_units: [
                  {
                    amount: {
                      value: total,
                      currency_code: "USD",
                    },
                  },
                ],
              });
            },
            onApprove: function (data, actions) {
              // This function captures the funds from the transaction.
              var obj = {
                data: data,
              };
              return actions.order.capture().then(async function (details) {
                // This function shows a transaction success message to your buyer.
                obj.details = details;
                ctrl.cartData.status = details.status;
                ctrl.cartData.paypalLogs = [obj];
                ctrl.isBusy = true;
                var saveCart = await dataService.saveData(
                  "shoppingCart",
                  ctrl.cartData,
                  true
                );
                ctrl.isBusy = false;
                $scope.$apply();
                if (saveCart.isSucceed) {
                  localStorageService.set("shoppingCart", null);
                  if (ctrl.onSuccess && ctrl.cartData.status === "COMPLETED") {
                    $rootScope.executeFunctionByName(
                      ctrl.onSuccess,
                      [ctrl.cartData],
                      window
                    );
                  }
                } else {
                  if (ctrl.onFail && ctrl.cartData.status === "COMPLETED") {
                    $rootScope.executeFunctionByName(
                      ctrl.onFail,
                      [ctrl.cartData],
                      window
                    );
                  }
                }

                // dataService.saveData("paypal", obj);
              });
            },
          })
          .render("#paypal-button-container");
        //This function displays Smart Payment Buttons on your web page.
      };
    },
  ],
});

sharedComponents.component("portalSearch", {
  templateUrl: "portal-search.html",
  bindings: {
    previewUrl: "=",
    backUrl: "=",
  },
});

sharedComponents.component("previewImage", {
  templateUrl:
    "/mix-app/views/app-shared/components/preview-image/preview-image.html",
  controller: [
    "$rootScope",
    "$scope",
    "ngAppSettings",
    function ($rootScope, $scope) {
      var ctrl = this;
      ctrl.isImage = false;
      ctrl.init = function () {
        if (ctrl.imgSrc) {
          ctrl.imgClass = ctrl.imgClass || "rounded";
          ctrl.isImage = ctrl.imgSrc
            .toLowerCase()
            .match(/([/|.|\w|\s|-])*\.(?:jpg|jpeg|gif|png|svg|webp|jfif|ico)/g);
          // check if facebook avatar Url
          ctrl.isImage =
            ctrl.isImage ||
            ctrl.imgSrc
              .toLowerCase()
              .match(
                /(?:(?:http|https):\/\/)?(?:www.)?(graph.facebook.com)\/([A-Za-z0-9.]{0,})\/(picture)(\?)?([A-Za-z0-9.=&]{0,})?/g
              );
        }
      };
      ctrl.showImage = async function (functionName, args, context) {
        $rootScope.preview("img", ctrl.imgSrc);
      };
    },
  ],
  bindings: {
    imgWidth: "=",
    imgHeight: "=",
    imgSrc: "=",
    imgClass: "=?",
  },
});

sharedComponents.component("previewPopup", {
  templateUrl:
    "/mix-app/views/app-shared/components/preview-popup/preview-popup.html",
  controller: [
    "$location",
    function ($location) {
      var ctrl = this;
      ctrl.goToLink = async function (link) {
        $("#dlg-preview-popup").modal("hide");
        $location.path(link);
      };
    },
  ],
  bindings: {
    previewObject: "=",
  },
});

sharedComponents.component("quillEditor", {
  templateUrl: "/mix-app/views/app-shared/components/quill-editor/view.html",
  controller: [
    "$rootScope",
    "$scope",
    "$element",
    "ngAppSettings",
    function ($rootScope, $scope, $element, ngAppSettings) {
      var ctrl = this;
      ctrl.previousId = null;
      ctrl.editor = null;
      ctrl.init = function () {
        if (ctrl.content == undefined) {
          ctrl.content = "";
        }
        ctrl.guid = $rootScope.generateUUID();
        setTimeout(() => {
          var toolbarOptions = {
            container: [
              ["bold", "italic", "underline", "strike"], // toggled buttons
              ["blockquote", "image", "link", "code-block"],

              [{ header: 1 }, { header: 2 }], // custom button values
              [{ list: "ordered" }, { list: "bullet" }],
              [{ script: "sub" }, { script: "super" }], // superscript/subscript
              [{ indent: "-1" }, { indent: "+1" }], // outdent/indent
              [{ direction: "rtl" }], // text direction

              [{ size: ["small", false, "large", "huge"] }], // custom dropdown
              [{ header: [1, 2, 3, 4, 5, 6, false] }],

              [{ color: [] }, { background: [] }], // dropdown with defaults from theme
              [{ font: [] }],
              [{ align: [] }],

              ["clean"], // remove formatting button
            ],
            handlers: {
              // handlers object will be merged with default handlers object
              link: function (value) {
                if (value) {
                  var href = prompt("Enter the URL");
                  this.quill.format("link", href);
                } else {
                  this.quill.format("link", false);
                }
              },
              image: function () {
                var range = this.quill.getSelection();
                var value = prompt("Enter the image URL");
                this.quill.insertEmbed(
                  range.index,
                  "image",
                  value,
                  Quill.sources.USER
                );
              },
            },
          };

          ctrl.editor = new Quill("#quill-editor-" + ctrl.guid, {
            modules: {
              toolbar: toolbarOptions,
              imageResize: {},
            },
            placeholder: "Compose an epic...",
            theme: "snow",
          });

          // Init content
          ctrl.editor.clipboard.dangerouslyPasteHTML(0, ctrl.content);

          ctrl.editor.on("text-change", function (delta, oldDelta, source) {
            if (source == "api") {
              console.log("An API call triggered this change.");
            } else if (source == "user") {
              console.log("A user action triggered this change.");
            }
            ctrl.updateContent();
          });
        });
      };
      window.fsClick = function () {
        $(".quill-editor-defaultUI").toggleClass("fs");
      };
      ctrl.updateContent = function () {
        // ctrl.content = JSON.stringify(ctrl.editor.getContents());
        ctrl.content = ctrl.editor.root.innerHTML;
        $scope.$apply();
        // console.log(ctrl.content);
      };
    },
  ],
  bindings: {
    content: "=",
  },
});

sharedComponents.component("qrCode", {
  templateUrl: "/mix-app/views/app-shared/components/qr-code/view.html",
  controller: [
    "$location",
    function ($location) {
      var ctrl = this;
      ctrl.$onInit = function () {
        if (ctrl.model) {
          ctrl.generate();
        }
      };
      ctrl.generate = function () {
        $("#qr-output").empty();
        $("#qr-output").qrcode(ctrl.model);
      };
    },
  ],
  bindings: {
    model: "=",
  },
});

sharedComponents.component("serviceHub", {
  templateUrl: "/mix-app/views/app-shared/components/service-hub/view.html",
  bindings: {
    hubName: "=",
  },
  controller: [
    "$rootScope",
    "$scope",
    function ($rootScope, $scope) {
      var ctrl = this;
      BaseHub.call(this, ctrl);

      ctrl.user = {
        loggedIn: false,
        connection: {},
      };
      ctrl.isHide = true;
      ctrl.hideContact = true;
      ctrl.members = [];
      ctrl.messages = [];
      ctrl.message = { connection: {}, content: "" };
      ctrl.request = {
        uid: "",
        action: "",
        objectType: null,
        data: {},
        room: "",
        isMyself: false,
      };
      ctrl.loadMsgButton = function () {};
      ctrl.init = function () {
        ctrl.user.connection.name = Math.random() * 100;
        ctrl.user.connection.id = "abc";
        ctrl.user.connection.avatar = "";
        ctrl.startConnection("serviceHub", ctrl.join);
      };
      ctrl.logout = function () {
        FB.logout(function (response) {
          // user is now logged out
          ctrl.user.loggedIn = false;
        });
      };
      ctrl.login = function () {
        FB.login(function (response) {
          if (response.authResponse) {
            FB.api("/me", function (response) {
              ctrl.user.info.name = response.name;
              ctrl.user.info.id = response.id;
              ctrl.user.info.avatar =
                "//graph.facebook.com/" +
                response.id +
                "/picture?width=32&height=32";
              ctrl.join();
              $scope.$apply();
            });
          } else {
            console.log("User cancelled login or did not fully authorize.");
          }
        });
      };
      ctrl.join = function () {
        // var obj = {name: 'tinku', message: 'test'};
        // ctrl.connection.invoke("SendMessage", JSON.stringify(obj) ).catch(err => console.error(err.toString()));
        ctrl.request.action = "join_group";
        ctrl.request.uid = ctrl.user.connection.id;
        ctrl.request.data = ctrl.user.connection;
        ctrl.message.connection = ctrl.user.connection;
        ctrl.connection.invoke("HandleRequest", JSON.stringify(ctrl.request));
      };
      ctrl.toggle = function () {
        ctrl.isHide = !ctrl.isHide;
      };
      ctrl.toggleContact = function () {
        ctrl.hideContact = !ctrl.hideContact;
      };
      ctrl.sendMessage = function () {
        // if (ctrl.user.loggedIn) {
        ctrl.request.data = ctrl.message;
        ctrl.request.action = "send_message";
        ctrl.connection.invoke("sendMessage", JSON.stringify(ctrl.request));
        ctrl.message.content = "";
        // }
      };
      ctrl.receiveMessage = function (msg) {
        switch (msg.responseKey) {
          case "NewMember":
            ctrl.newMember(msg.data);
            $(".widget-conversation").scrollTop = $(
              ".widget-conversation"
            )[0].scrollHeight;
            break;

          case "NewMessage":
            ctrl.newMessage(msg.data);
            break;
          case "ConnectSuccess":
            ctrl.user.loggedIn = true;
            ctrl.initList(msg.data);
            $scope.$apply();
            break;

          case "MemberOffline":
            ctrl.removeMember(msg.data);
            break;
          case "Error":
            console.error(msg.data);
            break;
        }
      };
      ctrl.checkLoginStatus = function () {
        FB.getLoginStatus(function (response) {
          if (response.status === "connected") {
            // The user is logged in and has authenticated your
            // app, and response.authResponse supplies
            // the user's ID, a valid access token, a signed
            // request, and the time the access token
            // and signed request each expire.
            FB.api("/me", function (response) {
              ctrl.user.info.name = response.name;
              ctrl.user.info.id = response.id;
              ctrl.user.info.avatar =
                "//graph.facebook.com/" +
                response.id +
                "/picture?width=32&height=32";
              ctrl.join();
              $scope.$apply();
            });
          } else if (response.status === "authorization_expired") {
            // The user has signed into your application with
            // Facebook Login but must go through the login flow
            // again to renew data authorization. You might remind
            // the user they've used Facebook, or hide other options
            // to avoid duplicate account creation, but you should
            // collect a user gesture (e.g. click/touch) to launch the
            // login dialog so popup blocking is not triggered.
          } else if (response.status === "not_authorized") {
            // The user hasn't authorized your application.  They
            // must click the Login button, or you must call FB.login
            // in response to a user gesture, to launch a login dialog.
          } else {
            // The user isn't logged in to Facebook. You can launch a
            // login dialog with a user gesture, but the user may have
            // to log in to Facebook before authorizing your application.
          }
        });
      };
      ctrl.newMember = function (member) {
        var m = $rootScope.findObjectByKey(ctrl.members, "id", member.id);
        if (!m) {
          ctrl.members.push(member);
        }
        $scope.$apply();
      };

      ctrl.initList = function (data) {
        data.forEach((member) => {
          var index = ctrl.members.findIndex((x) => x.id === member.id);
          if (index < 0) {
            ctrl.members.splice(0, 0, member);
          }
        });

        $scope.$apply();
      };

      ctrl.removeMember = function (memberId) {
        var index = ctrl.members.findIndex((x) => x.id === memberId);
        if (index >= 0) {
          ctrl.members.splice(index, 1);
        }
        $scope.$apply();
      };

      ctrl.newMessage = function (msg) {
        ctrl.messages.push(msg);
        $scope.$apply();
        // var objDiv = document.getElementsByClassName("widget-conversation")[0];
        // objDiv.scrollTop = objDiv.scrollHeight + 20;
      };
    },
  ],
});

sharedComponents.component("recaptcha", {
  templateUrl: "/mix-app/views/app-shared/components/recaptcha/recaptcha.html",
  controller: [
    "$rootScope",
    "ApiService",
    "CommonService",
    function ($rootScope, apiService, commonService) {
      var ctrl = this;
      ctrl.shortenString = "";
      ctrl.previousContentId = undefined;
      ctrl.recaptcha_key = null;
      ctrl.token = null;
      this.$onInit = () => {
        ctrl.recaptcha_key = $rootScope.globalSettings.data.Recaptcha_Key;
        ctrl.recaptcha_secret = $rootScope.globalSettings.data.Recaptcha_Secret;
        grecaptcha.ready(function () {
          grecaptcha
            .execute(ctrl.recaptcha_key, { action: ctrl.action })
            .then(function (token) {
              ctrl.token = token;
            });
        });
      };
      ctrl.verify = function () {
        var url = "https://www.google.com/recaptcha/api/siteverify";
        var data = {
          secret: ctrl.recaptcha_secret,
          response: ctrl.token,
        };
        var req = {
          method: "POST",
          url: url,
          data: data,
        };
        return apiService.getApiResult(req).then(function (response) {
          if (response.success) {
            ctrl.callback();
          } else {
            angular.forEach(response.error - codes, function (err) {
              commonService.showAlertMsg("Recaptcha Error", err);
            });
          }
        });
      };
    },
  ],
  bindings: {
    action: "=",
    callback: "&",
  },
});

sharedComponents.component("codeEditor", {
  templateUrl: "codeEditor.html",
  bindings: {
    product: "=",
    onDelete: "&",
    onUpdate: "&",
  },
});

sharedComponents.component("shoppingCart", {
  templateUrl: "/mix-app/views/app-shared/components/shopping-cart/view.html",
  bindings: {
    cartData: "=?",
    successCallback: "&?",
  },
  controller: "ShoppingCartController",
});
sharedComponents.controller("ShoppingCartController", [
  "$rootScope",
  "$scope",
  "localStorageService",
  "RestMixDatabaseDataClientService",
  function ($rootScope, $scope, localStorageService, dataService) {
    $scope.submitted = false;
    $scope.isShow = false;
    $scope.init = function (validateCallback, successCallback, failCallback) {
      $scope.validateCallback = validateCallback;
      $scope.successCallback = successCallback;
      $scope.failCallback = failCallback;
    };
    $scope.translate = $rootScope.translate;

    $scope.showShoppingCart = function () {
      $scope.cartModal.show();
    };
    $scope.calculate = function () {
      $scope.cartData.total = 0;
      $scope.cartData.totalItem = $scope.cartData.items.length;
      angular.forEach($scope.cartData.items, function (e) {
        $scope.cartData.total += parseInt(e.price) * e.quantity;
      });
      localStorageService.set("shoppingCart", $scope.cartData);
    };
    $scope.removeItem = function (index) {
      $scope.cartData.items.splice(index, 1);
      $scope.calculate();
    };

    $scope.submit = async function () {
      $scope.onValidate();
      if ($scope.frmCheckOut.$valid) {
        $scope.isBusy = true;
        $rootScope.submitting = true;
        var result = await dataService.saveData(
          "shoppingCart",
          $scope.cartData
        );
        if (result.isSucceed) {
          $scope.isBusy = false;
          $scope.cartData = result.data.obj;
          $scope.$apply();
          $scope.onSuccess(result.data);
        } else {
          $scope.isBusy = false;
          $scope.$apply();
          $scope.onFail(result.errors);
        }
      }
    };

    $scope.onValidate = async function () {
      $scope.frmCheckOut.$$element.addClass("was-validated");
      if ($scope.validateCallback) {
        let isValid = await $rootScope.executeFunctionByName(
          $scope.validateCallback,
          [$scope.frmCheckOut, $scope.cartData],
          window
        );
        $scope.frmCheckOut.$valid = $scope.frmCheckOut.$valid && isValid;
      }
    };
    $scope.onSuccess = function (resp) {
      localStorageService.set("shoppingCart", resp.obj);

      if ($scope.successCallback) {
        $rootScope.executeFunctionByName(
          $scope.successCallback,
          [resp],
          window
        );
      } else {
        setTimeout(() => {
          $scope.submitting = false;
        }, 1000);
        $scope.cartData = {
          items: [],
          totalItem: 0,
          total: 0,
        };
        localStorageService.set("shoppingCart", $scope.cartData);
        window.location.href = "/";
      }
    };
    $scope.onFail = function (errors) {
      $scope.errors = errors;
      if ($scope.failCallback) {
        $rootScope.executeFunctionByName($scope.failCallback, [errors], window);
      }
    };
    $scope.sendmail = async function () {
      let edm =
        'Url: <a href="[url]">View Tour</a> <br/>Name: [name] <br/>' +
        "Phone: [phone]<br/>" +
        "Email: [email]<br/>" +
        "Quantity: [quantity]<br/>" +
        "Message: [message] <br/>" +
        "property: [property] <br/>Price: [price] <br/>";

      edm = edm.replace(/\[url\]/g, window.top.location.href);
      edm = edm.replace(/\[name\]/g, $scope.order.name);
      edm = edm.replace(/\[phone\]/g, $scope.order.phone);
      edm = edm.replace(/\[email\]/g, $scope.order.email);
      edm = edm.replace(/\[message\]/g, $scope.order.message);
      edm = edm.replace(/\[property\]/g, $scope.order.propertyId);
      edm = edm.replace(/\[price\]/g, $scope.order.price);
      edm = edm.replace(/\[quantity\]/g, $scope.order.quantity);

      //   TODO Handle cart submit
      await commonService.sendMail("Booking - " + $scope.propertyName, edm);
      $scope.submitted = true;
    };
  },
]);

sharedComponents.component("snowy", {
  templateUrl: "/mix-app/views/app-shared/components/snowy/index.html",
  controller: [
    "$scope",
    function ($scope) {
      var ctrl = this;
      this.init = function () {
        var Snowflake = (function () {
          var flakes;
          var flakesTotal = 250;
          var wind = 0;
          var mouseX;
          var mouseY;

          function Snowflake(size, x, y, vx, vy) {
            this.size = size;
            this.x = x;
            this.y = y;
            this.vx = vx;
            this.vy = vy;
            this.hit = false;
            this.melt = false;
            this.div = document.createElement("div");
            this.div.classList.add("snowflake");
            this.div.style.width = this.size + "px";
            this.div.style.height = this.size + "px";
          }

          Snowflake.prototype.move = function () {
            if (this.hit) {
              if (Math.random() > 0.995) this.melt = true;
            } else {
              this.x += this.vx + Math.min(Math.max(wind, -10), 10);
              this.y += this.vy;
            }

            // Wrap the snowflake to within the bounds of the page
            if (this.x > window.innerWidth + this.size) {
              this.x -= window.innerWidth + this.size;
            }

            if (this.x < -this.size) {
              this.x += window.innerWidth + this.size;
            }

            if (this.y > window.innerHeight + this.size) {
              this.x = Math.random() * window.innerWidth;
              this.y -= window.innerHeight + this.size * 2;
              this.melt = false;
            }

            var dx = mouseX - this.x;
            var dy = mouseY - this.y;
            this.hit =
              !this.melt && this.y < mouseY && dx * dx + dy * dy < 2400;
          };

          Snowflake.prototype.draw = function () {
            this.div.style.transform = this.div.style.MozTransform = this.div.style.webkitTransform =
              "translate3d(" + this.x + "px" + "," + this.y + "px,0)";
          };

          function update() {
            for (var i = flakes.length; i--; ) {
              var flake = flakes[i];
              flake.move();
              flake.draw();
            }
            requestAnimationFrame(update);
          }

          Snowflake.init = function (container) {
            flakes = [];

            for (var i = flakesTotal; i--; ) {
              var size = (Math.random() + 0.2) * 2 + 1;
              var flake = new Snowflake(
                size,
                Math.random() * window.innerWidth,
                Math.random() * window.innerHeight,
                Math.random() - 0.5,
                size * 0.3
              );
              container.appendChild(flake.div);
              flakes.push(flake);
            }

            container.onmousemove = function (event) {
              mouseX = event.clientX;
              mouseY = event.clientY;
              wind = ((mouseX - window.innerWidth / 2) / window.innerWidth) * 6;
            };

            container.ontouchstart = function (event) {
              mouseX = event.targetTouches[0].clientX;
              mouseY = event.targetTouches[0].clientY;
              event.preventDefault();
            };

            window.ondeviceorientation = function (event) {
              if (event) {
                wind = event.gamma / 10;
              }
            };

            update();
          };

          return Snowflake;
        })();

        window.onload = function () {
          setTimeout(function () {
            Snowflake.init(document.getElementById("snow"));
          }, 500);
        };
      };
    },
  ],
  bindings: {},
});

sharedComponents.component("starRating", {
  templateUrl:
    "/mix-app/views/app-shared/components/star-rating/star-rating.html",
  bindings: {
    ratingValue: "=",
    max: "=?", // optional (default is 5)
    onRatingSelect: "&?",
    isReadonly: "=?",
  },
  controller: "StarRatingController",
});

appShared.controller("StarRatingController", [
  "$rootScope",
  function ($rootScope) {
    var ctrl = this;
    ctrl.translate = function (keyword) {
      return $rootScope.translate(keyword);
    };
    ctrl.readonly = false;
    ctrl.rateFunction = function (rating) {
      console.log("Rating selected: " + rating);
    };
    ctrl.init = function () {
      ctrl.readonly = ctrl.isReadonly === "true";
      ctrl.stars = [];
      ctrl.max = ctrl.max || 5;
      for (var i = 0; i < ctrl.max; i++) {
        ctrl.stars.push({
          filled: i < ctrl.ratingValue,
        });
      }
    };
    ctrl.toggle = function (index) {
      if (ctrl.readonly === undefined || ctrl.readonly === false) {
        ctrl.ratingValue = index + 1;
      }
    };
    ctrl.filled = function (index) {
      return index < ctrl.ratingValue;
    };
  },
]);

sharedComponents.component("statuses", {
  templateUrl: "/mix-app/views/app-shared/components/statuses/statuses.html",
  controller: [
    "$rootScope",
    "ngAppSettings",
    function ($rootScope, ngAppSettings) {
      this.contentStatuses = ngAppSettings.contentStatuses;
    },
  ],
  bindings: {
    status: "=",
  },
});

sharedComponents.component("mixStore", {
  templateUrl: "/mix-app/views/app-shared/components/store/view.html",
  bindings: {
    installCallback: "&?",
  },
  controller: [
    "$scope",
    "$rootScope",
    "ngAppSettings",
    "CryptoService",
    "ThemeService",
    "StoreService",
    function (
      $scope,
      $rootScope,
      ngAppSettings,
      cryptoService,
      themeService,
      service
    ) {
      var ctrl = this;
      ctrl.categories = [];
      BaseHub.call(this, ctrl);
      ctrl.current = null;
      ctrl.viewMode = "list";
      ctrl.init = async function () {
        ctrl.startConnection("portalhub", () => {
          ctrl.joinRoom("Theme");
        });
        ctrl.themeRequest = angular.copy(ngAppSettings.request);
        ctrl.themeRequest.orderBy = "createdDatetime";
        ctrl.themeRequest.postType = "theme";
        ctrl.themeRequest.query.mixcore_versions = "1.0.5";
        ctrl.cateRequest = angular.copy(ngAppSettings.request);
        ctrl.cateRequest.mixDatabaseName = "sys_category";
        ctrl.cateRequest.pageSize = null;

        ctrl.localizeSettings = $rootScope.globalSettings;
        let getCategories = await service.getCategories(ctrl.cateRequest);
        ctrl.categories = getCategories.data.items;
        await ctrl.getThemes(ctrl.themeRequest);
        $scope.$apply();
      };
      ctrl.receiveMessage = function (resp) {
        let msg = JSON.parse(resp);
        switch (msg.action) {
          case "Downloading":
            var index = ctrl.data.items.findIndex(
              (m) => m.id == ctrl.current.id
            );
            var progress = Math.round(msg.message);
            if (index >= 0) {
              ctrl.data.items[index].progress = progress;
              if (progress == 100) {
                ctrl.data.items[index].additionalData.installStatus =
                  "Installing";
              }
              $scope.$apply();
            }
            break;

          default:
            console.log(msg);
            break;
        }
      };
      ctrl.getThemes = async function () {
        $rootScope.isBusy = true;
        if (ctrl.themeRequest.fromDate !== null) {
          var d = new Date(ctrl.themeRequest.fromDate);
          ctrl.themeRequest.fromDate = d.toISOString();
        }
        if (ctrl.themeRequest.toDate !== null) {
          var dt = new Date(ctrl.themeRequest.toDate);
          ctrl.themeRequest.toDate = dt.toISOString();
        }
        var resp = await service.getThemes(ctrl.themeRequest);
        if (resp && resp.isSucceed) {
          ctrl.data = resp.data;
          $.each(ctrl.data, function (i, data) {
            $.each(ctrl.viewmodels, function (i, e) {
              if (e.dataId === data.id) {
                data.isHidden = true;
              }
            });
          });
          $rootScope.isBusy = false;
          $scope.$apply();
        } else {
          if (resp) {
            $rootScope.showErrors(resp.errors || ["Failed"]);
          }
          if (ctrl.getListFailCallback) {
            ctrl.getListFailCallback();
          }
          $rootScope.isBusy = false;
          $scope.$apply();
        }
      };
      ctrl.preview = function (theme) {
        ctrl.current = theme;
        // TODO: verify user - theme to enable install
        ctrl.current.canInstall = true;
        ctrl.viewMode = "detail";
      };
      ctrl.back = function () {
        ctrl.viewMode = "list";
      };
      ctrl.processPaymentData = async function (paymentData) {
        var encrypted = cryptoService.encryptAES(paymentData);
        ctrl.current.canInstall = true;
        $scope.$apply();
        return encrypted;
      };
      ctrl.installTheme = async function (theme, id) {
        $rootScope.isBusy = false;
        theme.installStatus = "downloading";
        ctrl.id = id;
        var result = await themeService.install(theme);

        if (result.isSucceed) {
          $rootScope.isBusy = false;
          theme.installStatus = "finished";
          $rootScope.showMessage("success");
        } else {
          $rootScope.isBusy = false;
          theme.installStatus = "failed";
          $rootScope.showErrors(result.errors);
        }

        if (ctrl.installCallback) {
          ctrl.installCallback({ data: result });
        }
        $scope.$apply();
      };
    },
  ],
});

"use trick";
sharedComponents.directive("pane", function () {
  return {
    require: "^tabs",
    restrict: "E",
    transclude: true,
    scope: { header: "@", id: "@", icon: "@" },
    link: function (scope, element, attrs, tabsController) {
      tabsController.addPane(scope);
    },
    template:
      '<div class="tab-pane" ng-class="{active: selected}" ng-transclude>' +
      "</div>",
    replace: true,
  };
});

sharedComponents.directive("tabs", function () {
  return {
    restrict: "E",
    transclude: true,
    scope: {
      selectCallback: "&",
    },
    controller: function ($scope, $element) {
      var panes = ($scope.panes = []);

      $scope.select = function (pane) {
        angular.forEach(panes, function (pane) {
          pane.selected = false;
        });
        pane.selected = true;
        this.selectCallback({ pane: pane });
      };

      this.addPane = function (pane) {
        if (panes.length === 0) $scope.select(pane);
        panes.push(pane);
      };
    },
    templateUrl: "/mix-app/views/app-shared/components/tabs/tabs.html",
    replace: true,
  };
});

"use trick";
sharedComponents.directive("paneV", function () {
  return {
    require: "^tabs-v",
    restrict: "E",
    transclude: true,
    scope: { header: "@", id: "@", icon: "@", class: "@" },
    link: function (scope, element, attrs, tabsController) {
      tabsController.addPane(scope);
    },
    template:
      '<div class="tab-pane" ng-class="{active: selected}" ng-transclude>' +
      "</div>",
    replace: true,
  };
});

sharedComponents.directive("tabsV", function () {
  return {
    restrict: "E",
    transclude: true,
    scope: {
      selectCallback: "&",
    },
    controller: function ($scope, $element) {
      var panes = ($scope.panes = []);

      $scope.select = function (pane) {
        angular.forEach(panes, function (pane) {
          pane.selected = false;
        });
        pane.selected = true;
        this.selectCallback({ pane: pane });
      };

      this.addPane = function (pane) {
        if (panes.length === 0) $scope.select(pane);
        panes.push(pane);
      };
    },
    templateUrl: "/mix-app/views/app-shared/components/tabs-verticle/tabs.html",
    replace: true,
  };
});

"use trick";
sharedComponents.directive("paneH", function () {
  return {
    require: "^tabs-h",
    restrict: "E",
    transclude: true,
    scope: { header: "@", id: "@", icon: "@" },
    link: function (scope, element, attrs, tabsController) {
      tabsController.addPane(scope);
    },
    template:
      '<div class="tab-pane" ng-class="{active: selected}" ng-transclude>' +
      "</div>",
    replace: true,
  };
});

sharedComponents.directive("tabsH", function () {
  return {
    restrict: "E",
    transclude: true,
    scope: {
      selectCallback: "&",
    },
    controller: function ($scope, $element) {
      var panes = ($scope.panes = []);

      $scope.select = function (pane) {
        angular.forEach(panes, function (pane) {
          pane.selected = false;
        });
        pane.selected = true;
        this.selectCallback({ pane: pane });
      };

      this.addPane = function (pane) {
        if (panes.length === 0) $scope.select(pane);
        panes.push(pane);
      };
    },
    templateUrl:
      "/mix-app/views/app-shared/components/tabs-horizontal/tabs.html",
    replace: true,
  };
});

sharedComponents.component("tags", {
  templateUrl: "/mix-app/views/app-shared/components/tags/tags.html",
  controller: [
    "$scope",
    function ($scope) {
      var ctrl = this;
    },
  ],
  bindings: {
    input: "=",
  },
});

sharedComponents.component("tagsView", {
  templateUrl: "/mix-app/views/app-shared/components/tags-view/view.html",
  controller: [
    "$rootScope",
    "$scope",
    function ($rootScope, $scope) {
      var ctrl = this;
      ctrl.$onInit = function () {
        if (ctrl.tags) {
          ctrl.data = angular.fromJson(ctrl.tags);
        } else {
          ctrl.data = [];
        }
        angular.forEach(ctrl.data, function (e, i) {
          e.url =
            $rootScope.globalSettings.domain +
            "/" +
            $rootScope.localizeSettings.lang +
            "/tag/" +
            e.text;
        });
        $scope.$apply();
      };
    },
  ],
  bindings: {
    tags: "=",
  },
});

sharedComponents.component("trumbowyg", {
  templateUrl: "/mix-app/views/app-shared/components/trumbowyg/trumbowyg.html",
  bindings: {
    options: "<?",
    ngDisabled: "<?",
    placeholder: "@?",
    onFocus: "&?",
    onBlur: "&?",
    onInit: "&?",
    onChange: "&?",
    onResize: "&?",
    onPaste: "&?",
    onOpenfullscreen: "&?",
    onClosefullscreen: "&?",
    onClose: "&?",
    removeformatPasted: "=",
  },
  require: {
    ngModel: "ngModel",
  },
  controller: [
    "$element",
    "$scope",
    "$attrs",
    "ngAppSettings",
    function ($element, $scope, $attrs) {
      var ctrl = this;
      const TBW_EVENTS = [
          "focus",
          "blur",
          "init",
          "change",
          "resize",
          "paste",
          "openfullscreen",
          "closefullscreen",
          "close",
        ],
        EVENTS_PREFIX = "tbw";
      ctrl.options = {
        svgPath: "/mix-app/assets/icons.svg",
        removeformatPasted: false,
        imageWidthModalEdit: true,
        resetCss: true,
        tagClasses: {
          iframe: "w-100", // Tailwind CSS example
        },
        btnsDef: {
          // Customizables dropdowns
          image: {
            dropdown: ["insertImage", "upload", "noembed"],
            ico: "insertImage",
          },
        },
        btns: [
          ["table"],
          ["emoji"],
          ["formatting"],
          ["strong", "em", "del", "underline"],
          ["fontsize"],
          ["foreColor", "backColor"],
          ["highlight"],
          ["link"],
          ["image"],
          ["justifyLeft", "justifyCenter", "justifyRight", "justifyFull"],
          ["unorderedList", "orderedList"],
          ["indent", "outdent"],
          ["preformatted"],
          ["horizontalRule"],
          ["fullscreen"],
          ["viewHTML"],
        ],
        plugins: {
          // Add imagur parameters to upload plugin
          upload: {
            serverPath: "/api/v1/vi-vn/media/upload-media",
            fileFieldName: "file",
            headers: {
              Authorization: "Client-ID 9e57cb1c4791cea",
            },
            urlPropertyName: "data.fullPath",
            statusPropertyName: "isSucceed",
          },
          table: {},
          fontfamily: {
            init: function (trumbowyg) {
              trumbowyg.o.plugins.fontfamily =
                trumbowyg.o.plugins.fontfamily || defaultOptions;
              trumbowyg.addBtnDef("fontfamily", {
                dropdown: buildDropdown(trumbowyg),
                hasIcon: false,
                text: trumbowyg.lang.fontFamily,
              });
            },
          },
        },
      };
      ctrl.getElementReference = function () {
        return $($element.find("div"));
      };

      ctrl.getEditorReference = function () {
        return ctrl.getElementReference().find(".trumbowyg-editor");
      };
      ctrl.updateModelValue = () => {
        $scope.$applyAsync(() => {
          const value = ctrl.getEditorReference().trumbowyg("html");
          ctrl.ngModel.$setViewValue(value);
        });
      };

      ctrl.emitEvent = (event) => {
        const attr = $attrs.$normalize(`on-${event}`);
        if (angular.isFunction(this[attr])) {
          $scope.$applyAsync(() => this[attr]());
        }
      };

      ctrl.initializeEditor = (element) => {
        if (ctrl.removeformatPasted) {
          ctrl.options.plugins.removeformatPasted =
            ctrl.removeformatPasted == "true";
        }
        element
          .trumbowyg(ctrl.options)
          .on("tbwchange", () => ctrl.updateModelValue())
          .on("tbwpaste", () => ctrl.updateModelValue());
        angular.forEach(TBW_EVENTS, (event) => {
          element.on(`${EVENTS_PREFIX}${event}`, () => ctrl.emitEvent(event));
        });
        ctrl.ngModel.$render();
      };

      ctrl.$onDestroy = () => {
        ctrl.getElementReference().trumbowyg("destroy");
      };

      ctrl.$onChanges = (changes) => {
        const element = ctrl.getElementReference();

        if (changes.options && !changes.options.isFirstChange()) {
          element.trumbowyg("destroy");
        }
        ctrl.options = ctrl.options || {};
        ctrl.initializeEditor(element);

        if (changes.ngDisabled) {
          element.trumbowyg(ctrl.ngDisabled ? "disable" : "enable");
        }

        if (changes.placeholder) {
          ctrl.getEditorReference().attr("placeholder", ctrl.placeholder);
        }
      };

      ctrl.$onInit = () => {
        ctrl.ngModel.$render = () => {
          const element = ctrl.getEditorReference();
          element.trumbowyg("html", ctrl.ngModel.$modelValue);
        };
      };
    },
  ],
});

sharedComponents.component("tuiEditor", {
  templateUrl: "/mix-app/views/app-shared/components/tui-editor/view.html",
  controller: [
    "$rootScope",
    "$scope",
    "$element",
    "ngAppSettings",
    function ($rootScope, $scope, $element, ngAppSettings) {
      var ctrl = this;
      ctrl.previousId = null;
      ctrl.editor = null;
      ctrl.init = function () {
        ctrl.guid = $rootScope.generateUUID();
        setTimeout(() => {
          ctrl.editor = new tui.Editor({
            el: document.querySelector("#tui-" + ctrl.guid),
            initialEditType: "markdown",
            previewStyle: "vertical",
            height: "300px",
            initialValue: ctrl.content,
            events: {
              // change: ctrl.updateContent,
              // focus: () => onFocus(),
              blur: () => ctrl.updateContent(),
            },
          });
          ctrl.toolbar = ctrl.editor.getUI().getToolbar();
          ctrl.toolbar.addButton(
            {
              name: "fullscreen",
              tooltip: "fullscreen",
              $el: $(
                '<button onclick="fsClick()" class="mi mi-FullScreen mi-lg mi-fw text-secondary" type="button"></button>'
              ),
            },
            1
          );
        }, 100);
      };
      window.fsClick = function () {
        $(".tui-editor-defaultUI").toggleClass("fs");
      };
      ctrl.updateContent = function () {
        ctrl.content = ctrl.editor.getMarkdown();
      };
    },
  ],
  bindings: {
    content: "=",
  },
});

sharedComponents.component("uploadCroppie", {
  templateUrl:
    "/mix-app/views/app-shared/components/upload-croppie/view.html?v=1",
  bindings: {
    header: "=",
    description: "=",
    src: "=",
    srcUrl: "=",
    h: "=?",
    w: "=?",
    isCrop: "=?",
    frameUrl: "=?",
    type: "=",
    folder: "=",
    auto: "=",
    onDelete: "&",
    onUpdate: "&",
  },
  controller: [
    "$rootScope",
    "$scope",
    "$modal",
    "$http",
    "ngAppSettings",
    function ($rootScope, $scope, $modal, $http, ngAppSettings) {
      var ctrl = this;
      ctrl.options = {
        boundary: { height: 250 },
        render: { width: 1000, height: 1000 },
        output: { width: 1000, height: 1000 },
      };
      ctrl.rto = 1;
      ctrl.isAdmin = $rootScope.isAdmin;
      ctrl.postedFile = {};
      ctrl.isImage = false;
      ctrl.mediaNavs = [];
      ctrl.image_placeholder = "/mix-app/assets/img/image_placeholder.jpg";
      // `https://via.placeholder.com/${ctrl.options.render.width}x${ctrl.options.render.height}.png`;
      ctrl.$onInit = function () {
        ctrl.loadViewport();
        ctrl.srcUrl = ctrl.srcUrl || ctrl.image_placeholder;
        ctrl.isImage = ctrl.srcUrl
          .toLowerCase()
          .match(/([/|.|\w|\s|-])*\.(?:jpg|jpeg|gif|png|svg)/g);
        ctrl.maxHeight = ctrl.maxHeight || "2000px";
        ctrl.id = Math.floor(Math.random() * 100);
        ctrl.canvas = document.getElementById(`canvas-${ctrl.id}`);
        ctrl.cropped = {
          source: ctrl.image_placeholder,
        };
        // var frameUrl = '/content/templates/tsets/uploads/2019-10/730149275529721421464195891692074859757568n0037047f8f6f4adab55211aee3538155.png';//$rootScope.localizeSettings.data['frame_url']
        if (ctrl.frameUrl) {
          ctrl.frame = ctrl.loadImage(frameUrl);
        }
        if (ctrl.isImage) {
          ctrl.loadBase64(ctrl.srcUrl);
        }
        // Assign blob to component when selecting a image
      };
      ctrl.$doCheck = function () {
        if (ctrl.src !== ctrl.srcUrl && ctrl.srcUrl != ctrl.image_placeholder) {
          ctrl.src = ctrl.srcUrl;
          ctrl.isImage = ctrl.srcUrl
            .toLowerCase()
            .match(/([/|.|\w|\s|-])*\.(?:jpg|jpeg|gif|png|svg)/g);
          if (ctrl.isImage) {
            ctrl.loadBase64(ctrl.srcUrl);
          }
        }
      }.bind(ctrl);
      ctrl.combineImage = function () {
        ctrl.canvas = document.getElementById(`canvas-${ctrl.id}`);
        if (ctrl.canvas) {
          var img = document.getElementById("croppie-src");
          var w = ctrl.options.boundary.width;
          var h = ctrl.options.boundary.height;
          // var rto = w / h;
          var newW = ctrl.options.output.width;
          var newH = ctrl.options.output.height;
          var ctx = ctrl.canvas.getContext("2d");
          ctx.imageSmoothingEnabled = true;
          ctx.drawImage(img, 0, 0, newW, newH);
          if (ctrl.frame) {
            // combine with frame
            ctx.drawImage(ctrl.frame, 0, 0, w, h);
          }

          $scope.$apply(function () {
            ctrl.postedFile.fileStream = ctrl.canvas.toDataURL(); //ctx.getImageData(0, 0, 300, 350);
            ctrl.imgUrl = ctrl.postedFile.fileStream.replace(
              "image/png",
              "image/octet-stream"
            );
          });
        }
      };
      ctrl.saveCanvas = function () {
        var link = document.createElement("a");
        link.download = ctrl.postedFile.fileName + ctrl.postedFile.extension;
        $rootScope.isBusy = true;
        ctrl.canvas.toBlob(function (blob) {
          link.href = URL.createObjectURL(blob);
          link.click();
          $rootScope.isBusy = false;
          $scope.$apply();
        }, "image/png");
      };
      ctrl.loadBase64 = function (url) {
        var ext = url.substring(url.lastIndexOf(".") + 1);
        $http({
          method: "GET",
          url: url,
          responseType: "arraybuffer",
        }).then(function (resp) {
          var base64 = `data:image/${ext};base64,${ctrl._arrayBufferToBase64(
            resp.data
          )}`;
          var image = new Image();
          image.src = base64;
          image.onload = function () {
            // access image size here
            ctrl.loadImageSize(this.width, this.height);
          };
          ctrl.cropped.source = base64;
          return base64;
        });
      };
      ctrl.loadImage = function (src) {
        // http://www.thefutureoftheweb.com/blog/image-onload-isnt-being-called
        var img = new Image();
        // img.onload = onload;
        img.src = src;
        return img;
      };
      ctrl._arrayBufferToBase64 = function (buffer) {
        var binary = "";
        var bytes = new Uint8Array(buffer);
        var len = bytes.byteLength;
        for (var i = 0; i < len; i++) {
          binary += String.fromCharCode(bytes[i]);
        }
        return window.btoa(binary);
      };
      ctrl.mediaFile = {
        file: null,
        fullPath: "",
        folder: ctrl.folder,
        title: ctrl.title,
        description: ctrl.description,
      };
      ctrl.media = null;

      ctrl.selectFile = function (files) {
        if (files !== undefined && files !== null && files.length > 0) {
          const file = files[0];
          ctrl.mediaFile.folder = ctrl.folder ? ctrl.folder : "Media";
          ctrl.mediaFile.title = ctrl.title ? ctrl.title : "";
          ctrl.mediaFile.description = ctrl.description ? ctrl.description : "";
          ctrl.mediaFile.file = file;
          ctrl.getBase64(file);
          // if (file.size < 100000) {
          //   var msg = "Please choose a better photo (larger than 100kb)!";
          //   $rootScope.showConfirm(ctrl, null, [], null, null, msg);
          // } else {
          // }
        }
      };

      ctrl.getBase64 = function (file) {
        if (file !== null) {
          $rootScope.isBusy = true;
          var reader = new FileReader();
          reader.readAsDataURL(file);
          reader.onload = function () {
            ctrl.cropped.source = null;
            var index = reader.result.indexOf(",") + 1;
            var base64 = reader.result.substring(index);
            if (ctrl.postedFile) {
              ctrl.postedFile.fileName = file.name.substring(
                0,
                file.name.lastIndexOf(".")
              );
              ctrl.postedFile.extension = file.name.substring(
                file.name.lastIndexOf(".")
              );
              // ctrl.postedFile.fileStream = reader.result;
            }
            var image = new Image();
            image.src = reader.result;

            image.onload = function () {
              // access image size here
              ctrl.loadImageSize(this.width, this.height);
            };

            ctrl.cropped.source = reader.result;
            $rootScope.isBusy = false;
            $scope.$apply();
          };
          reader.onerror = function (error) {
            $rootScope.isBusy = false;
            $rootScope.showErrors([error]);
          };
        } else {
          return null;
        }
      };
      ctrl.loadImageSize = function (w, h) {
        var rto = w / h;
        // ctrl.options.boundary.width = ctrl.options.boundary.height * rto;
        ctrl.options.render.width = ctrl.options.render.height * rto;
        if (!ctrl.rto) {
          ctrl.rto = rto;
          ctrl.w = w;
          ctrl.h = h;
          ctrl.loadViewport();
        }
        $scope.$apply();
        ctrl.image_placeholder = `https://via.placeholder.com/${ctrl.options.render.width}x${ctrl.options.render.height}.png`;
      };
      ctrl.loadViewport = function () {
        if (ctrl.w && ctrl.h) {
          ctrl.rto = ctrl.w / ctrl.h;
          ctrl.options.viewport.height = ctrl.h;
          ctrl.options.viewport.width = ctrl.options.viewport.height * ctrl.rto;
        }
        // ctrl.image_placeholder = "/mix-app/assets/img/image_placeholder.jpg"; // `https://via.placeholder.com/${ctrl.options.render.width}x${ctrl.options.render.height}.png`;
      };
    },
  ],
});

"use strict";
appShared.controller("VideoCallController", [
  "$scope",
  function ($scope) {
    BaseHub.call(this, $scope);
    $scope.user = {
      loggedIn: false,
      info: {},
    };
    $scope.isHide = true;
    $scope.hideContact = true;
    $scope.members = [];
    $scope.messages = [];
    $scope.message = { connection: {}, content: "" };
    $scope.request = {
      uid: "",
      objectType: null,
      action: "",
      data: {},
      room: "",
      isMyself: false,
    };
    $scope.loadMsgButton = function () {};
    $scope.init = function () {
      $scope.startConnection("MixChatHub", $scope.checkLoginStatus);

      $("button").on("click", function () {
        var text = $("#message").val();
        var hnow = new Date().getHours();
        var mnow = new Date().getMinutes();
        mnow = mnow < 10 ? "0" + mnow : mnow;
        var d = hnow + ":" + mnow;

        if (text.length > 0) {
          $("#message").css("border", "1px solid #f4f5f9");
          $("#conversation").append(
            "<li class='message-right'><div class='message-avatar'><div class='avatar ion-ios-person'></div><div class='name'>You</div></div><div class='message-text'>" +
              text +
              "</div><div class='message-hour'>" +
              d +
              " <span class='ion-android-done-all'></span></div></li>"
          );
          $("#message").val("");
          $(".widget-conversation").scrollTop(
            $("ul li").last().position().top + $("ul li").last().height()
          );
        } else {
          $("#message").css("border", "1px solid #eb9f9f");
          $("#message").animate({ opacity: "0.1" }, "slow");
          $("#message").animate({ opacity: "1" }, "slow");
          $("#message").animate({ opacity: "0.1" }, "slow");
          $("#message").animate({ opacity: "1" }, "slow");
        }
      });

      // var _createClass = function () {function defineProperties(target, props) {for (var i = 0; i < props.length; i++) {var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);}}return function (Constructor, protoProps, staticProps) {if (protoProps) defineProperties(Constructor.prototype, protoProps);if (staticProps) defineProperties(Constructor, staticProps);return Constructor;};}();function _classCallCheck(instance, Constructor) {if (!(instance instanceof Constructor)) {throw new TypeError("Cannot call a class as a function");}}var HoverButton = function () {
      //   function HoverButton(el) {_classCallCheck(this, HoverButton);
      //     this.el = el;
      //     this.hover = false;
      //     this.calculatePosition();
      //     this.attachEventsListener();
      //   }_createClass(HoverButton, [{ key: 'attachEventsListener', value: function attachEventsListener()

      //     {var _this = this;
      //       window.addEventListener('mousemove', function (e) {return _this.onMouseMove(e);});
      //       window.addEventListener('resize', function (e) {return _this.calculatePosition(e);});
      //     } }, { key: 'calculatePosition', value: function calculatePosition()

      //     {

      //       var box = this.el.getBoundingClientRect();
      //       this.x = box.left + box.width * 0.5;
      //       this.y = box.top + box.height * 0.5;
      //       this.width = box.width;
      //       this.height = box.height;
      //     } }, { key: 'onMouseMove', value: function onMouseMove(

      //     e) {
      //       var hover = false;
      //       var hoverArea = this.hover ? 0.7 : 0.5;
      //       var x = e.clientX - this.x;
      //       var y = e.clientY - this.y;
      //       var distance = Math.sqrt(x * x + y * y);
      //       if (distance < this.width * hoverArea) {
      //         hover = true;
      //         if (!this.hover) {
      //           this.hover = true;
      //         }
      //         this.onHover(e.clientX, e.clientY);
      //       }

      //       if (!hover && this.hover) {
      //         this.onLeave();
      //         this.hover = false;
      //       }
      //     } }, { key: 'onHover', value: function onHover(

      //     x, y) {
      //       TweenMax.to(this.el, 0.4, {
      //         x: (x - this.x) * 0.4,
      //         y: (y - this.y) * 0.4,
      //         scale: 1.15,
      //         ease: Power2.easeOut });

      //       this.el.style.zIndex = 10;
      //     } }, { key: 'onLeave', value: function onLeave()
      //     {
      //       TweenMax.to(this.el, 0.7, {
      //         x: 0,
      //         y: 0,
      //         scale: 1,
      //         ease: Elastic.easeOut.config(1.2, 0.4) });

      //       this.el.style.zIndex = 1;
      //     } }]);return HoverButton;}();

      // var btn1 = document.querySelector('#quest');
      // new HoverButton(btn1);
    };
    $scope.logout = function () {
      FB.logout(function (response) {
        // user is now logged out
        $scope.user.loggedIn = false;
      });
    };
    $scope.login = function () {
      FB.login(function (response) {
        if (response.authResponse) {
          FB.api("/me", function (response) {
            $scope.user.info.name = response.name;
            $scope.user.info.id = response.id;
            $scope.user.info.avatar =
              "//graph.facebook.com/" +
              response.id +
              "/picture?width=32&height=32";
            $scope.join();
            $scope.$apply();
          });
        } else {
          console.log("User cancelled login or did not fully authorize.");
        }
      });
    };
    $scope.join = function () {
      $scope.request.uid = $scope.user.info.id;
      $scope.request.data = $scope.user.info;
      $scope.message.connection = $scope.user.info;
      $scope.connection.invoke("join", $scope.request);
    };
    $scope.toggle = function () {
      $scope.isHide = !$scope.isHide;
    };
    $scope.toggleContact = function () {
      $scope.hideContact = !$scope.hideContact;
    };
    $scope.sendMessage = function () {
      if ($scope.user.loggedIn) {
        $scope.request.data = $scope.message;
        $scope.connection.invoke("sendMessage", $scope.request);
        $scope.message.content = "";
      }
    };
    $scope.receiveMessage = function (msg) {
      //$scope.responses.splice(0, 0, msg);
      switch (msg.responseKey) {
        case "NewMember":
          $scope.newMember(msg.data);
          $(".widget-conversation").scrollTop = $(
            ".widget-conversation"
          )[0].scrollHeight;
          break;

        case "NewMessage":
          $scope.newMessage(msg.data);
          break;
        case "ConnectSuccess":
          $scope.user.loggedIn = true;
          $scope.initList(msg.data);
          $scope.$apply();
          break;

        case "MemberOffline":
          $scope.removeMember(msg.data);
          break;
      }
    };
    $scope.checkLoginStatus = function () {
      FB.getLoginStatus(function (response) {
        if (response.status === "connected") {
          // The user is logged in and has authenticated your
          // app, and response.authResponse supplies
          // the user's ID, a valid access token, a signed
          // request, and the time the access token
          // and signed request each expire.
          FB.api("/me", function (response) {
            $scope.user.info.name = response.name;
            $scope.user.info.id = response.id;
            $scope.user.info.avatar =
              "//graph.facebook.com/" +
              response.id +
              "/picture?width=32&height=32";
            $scope.join();
            $scope.$apply();
          });
        } else if (response.status === "authorization_expired") {
          // The user has signed into your application with
          // Facebook Login but must go through the login flow
          // again to renew data authorization. You might remind
          // the user they've used Facebook, or hide other options
          // to avoid duplicate account creation, but you should
          // collect a user gesture (e.g. click/touch) to launch the
          // login dialog so popup blocking is not triggered.
        } else if (response.status === "not_authorized") {
          // The user hasn't authorized your application.  They
          // must click the Login button, or you must call FB.login
          // in response to a user gesture, to launch a login dialog.
        } else {
          // The user isn't logged in to Facebook. You can launch a
          // login dialog with a user gesture, but the user may have
          // to log in to Facebook before authorizing your application.
        }
      });
    };
    $scope.newMember = function (member) {
      var index = $scope.members.findIndex((x) => x.id === member.id);
      if (index < 0) {
        $scope.members.splice(0, 0, member);
      }
      $scope.$apply();
    };

    $scope.initList = function (data) {
      data.forEach((member) => {
        var index = $scope.members.findIndex((x) => x.id === member.id);
        if (index < 0) {
          $scope.members.splice(0, 0, member);
        }
      });

      $scope.$apply();
    };

    $scope.removeMember = function (memberId) {
      var index = $scope.members.findIndex((x) => x.id === memberId);
      if (index >= 0) {
        $scope.members.splice(index, 1);
      }
      $scope.$apply();
    };

    $scope.newMessage = function (msg) {
      $scope.messages.push(msg);
      $scope.$apply();
      var objDiv = document.getElementsByClassName("widget-conversation")[0];
      objDiv.scrollTop = objDiv.scrollHeight + 20;
    };
  },
]);

sharedComponents.component("videoCall", {
  templateUrl: "/mix-app/views/app-shared/components/video-call/index.html",
  controller: [
    function () {
      var ctrl = this;
      ctrl.constraints = {
        audio: {},
        video: {},
      };
      ctrl.isPlayed = false;
      ctrl.videoElement = document.querySelector("video");
      ctrl.audioSelect = document.querySelector("select#audioSource");
      ctrl.videoSelect = document.querySelector("select#videoSource");
      ctrl.init = function () {
        navigator.mediaDevices
          .enumerateDevices()
          .then(ctrl.gotDevices)
          .then(ctrl.getStream)
          .catch(ctrl.handleError);
      };
      ctrl.gotDevices = function (deviceInfos) {
        for (let i = 0; i !== deviceInfos.length; ++i) {
          const deviceInfo = deviceInfos[i];
          const option = document.createElement("option");
          option.value = deviceInfo.deviceId;
          if (deviceInfo.kind === "audioinput") {
            option.text =
              deviceInfo.label || "microphone " + (ctrl.audioSelect.length + 1);
            ctrl.audioSelect.appendChild(option);
          } else if (deviceInfo.kind === "videoinput") {
            option.text =
              deviceInfo.label || "camera " + (ctrl.videoSelect.length + 1);
            ctrl.videoSelect.appendChild(option);
          } else {
            console.log("Found another kind of device: ", deviceInfo);
          }
        }
      };
      ctrl.getStream = function () {
        if (window.stream) {
          window.stream.getTracks().forEach(function (track) {
            track.stop();
          });
        }
        ctrl.constraints.audio.deviceId = { exact: ctrl.audioSelect.value };
        ctrl.constraints.video.deviceId = { exact: ctrl.videoSelect.value };
        navigator.mediaDevices
          .getUserMedia(ctrl.constraints)
          .then(ctrl.gotStream)
          .catch(ctrl.handleError);
      };
      ctrl.gotStream = function (stream) {
        window.stream = stream; // make stream available to console
        ctrl.videoElement.srcObject = stream;
      };

      ctrl.handleError = function (error) {
        console.error("Error: ", error);
      };
      ctrl.play = function () {
        ctrl.video.play();
        ctrl.isPlayed = true;
      };
      ctrl.stop = function () {
        ctrl.video.stop();
        ctrl.isPlayed = false;
      };
    },
  ],
  bindings: {
    message: "=",
  },
});

sharedComponents.component("youtubeEditor", {
  templateUrl:
    "/mix-app/views/app-shared/components/youtube-editor/youtube-editor.html",
  controller: [
    "$rootScope",
    "$scope",
    "$sce",
    function ($rootScope, $scope, $sce) {
      var ctrl = this;
      ctrl.isPlay = false;
      ctrl.loadVideo = function () {
        ctrl.isPlay = false;
        ctrl.src = "";
        if (ctrl.code) {
          ctrl.img =
            "https://img.youtube.com/vi/" + ctrl.code + "/sddefault.jpg";
        }
      };
      ctrl.playVideo = function () {
        ctrl.isPlay = true;
        ctrl.src = $sce.trustAsResourceUrl(
          "https://www.youtube.com/embed/" +
            ctrl.code +
            "?rel=0&showinfo=0&autoplay=1"
        );
      };
      ctrl.searchVideo = function () {
        // search
        $rootScope.preview(
          "message",
          "ToDo: Integrate youtube search (https://developers.google.com/youtube/v3/docs/search/list) \r\n PATH: portal-app/app/app-shared/components/youtube-editor/youtube-editor.js"
        );
      };
    },
  ],
  bindings: {
    code: "=",
    hideInput: "=?",
  },
});

/*!
 * angular-loading-bar v0.9.0
 * https://chieffancypants.github.io/angular-loading-bar
 * Copyright (c) 2016 Wes Cruver
 * License: MIT
 */
!(function () {
  "use strict";
  angular.module("angular-loading-bar", ["cfp.loadingBarInterceptor"]),
    angular.module("chieffancypants.loadingBar", ["cfp.loadingBarInterceptor"]),
    angular.module("cfp.loadingBarInterceptor", ["cfp.loadingBar"]).config([
      "$httpProvider",
      function (a) {
        var b = [
          "$q",
          "$cacheFactory",
          "$timeout",
          "$rootScope",
          "$log",
          "cfpLoadingBar",
          function (b, c, d, e, f, g) {
            function h() {
              d.cancel(j), g.complete(), (l = 0), (k = 0);
            }
            function i(b) {
              var d,
                e = c.get("$http"),
                f = a.defaults;
              (!b.cache && !f.cache) ||
                b.cache === !1 ||
                ("GET" !== b.method && "JSONP" !== b.method) ||
                (d = angular.isObject(b.cache)
                  ? b.cache
                  : angular.isObject(f.cache)
                  ? f.cache
                  : e);
              var g = void 0 !== d ? void 0 !== d.get(b.url) : !1;
              return void 0 !== b.cached && g !== b.cached
                ? b.cached
                : ((b.cached = g), g);
            }
            var j,
              k = 0,
              l = 0,
              m = g.latencyThreshold;
            return {
              request: function (a) {
                return (
                  a.ignoreLoadingBar ||
                    i(a) ||
                    (e.$broadcast("cfpLoadingBar:loading", { url: a.url }),
                    0 === k &&
                      (j = d(function () {
                        g.start();
                      }, m)),
                    k++,
                    g.set(l / k)),
                  a
                );
              },
              response: function (a) {
                return a && a.config
                  ? (a.config.ignoreLoadingBar ||
                      i(a.config) ||
                      (l++,
                      l >= k
                        ? (e.$broadcast("cfpLoadingBar:loaded", {
                            url: a.config.url,
                            result: a,
                          }),
                          h())
                        : g.set(l / k)),
                    a)
                  : (f.error(
                      "Broken interceptor detected: Config object not supplied in response:\n https://github.com/chieffancypants/angular-loading-bar/pull/50"
                    ),
                    a);
              },
              responseError: function (a) {
                return a && a.config
                  ? (a.config.ignoreLoadingBar ||
                      i(a.config) ||
                      (l++,
                      l >= k
                        ? (e.$broadcast("cfpLoadingBar:loaded", {
                            url: a.config.url,
                            result: a,
                          }),
                          h())
                        : g.set(l / k)),
                    b.reject(a))
                  : (f.error(
                      "Broken interceptor detected: Config object not supplied in rejection:\n https://github.com/chieffancypants/angular-loading-bar/pull/50"
                    ),
                    b.reject(a));
              },
            };
          },
        ];
        a.interceptors.push(b);
      },
    ]),
    angular.module("cfp.loadingBar", []).provider("cfpLoadingBar", function () {
      (this.autoIncrement = !0),
        (this.includeSpinner = !0),
        (this.includeBar = !0),
        (this.latencyThreshold = 100),
        (this.startSize = 0.02),
        (this.parentSelector = "body"),
        (this.spinnerTemplate =
          '<div id="loading-bar-spinner"><div class="spinner-icon"></div></div>'),
        (this.loadingBarTemplate =
          '<div id="loading-bar"><div class="bar"><div class="peg"></div></div></div>'),
        (this.$get = [
          "$injector",
          "$document",
          "$timeout",
          "$rootScope",
          function (a, b, c, d) {
            function e() {
              if ((k || (k = a.get("$animate")), c.cancel(m), !r)) {
                var e = b[0],
                  g = e.querySelector ? e.querySelector(n) : b.find(n)[0];
                g || (g = e.getElementsByTagName("body")[0]);
                var h = angular.element(g),
                  i = g.lastChild && angular.element(g.lastChild);
                d.$broadcast("cfpLoadingBar:started"),
                  (r = !0),
                  v && k.enter(o, h, i),
                  u && k.enter(q, h, o),
                  f(w);
              }
            }
            function f(a) {
              if (r) {
                var b = 100 * a + "%";
                p.css("width", b),
                  (s = a),
                  t &&
                    (c.cancel(l),
                    (l = c(function () {
                      g();
                    }, 250)));
              }
            }
            function g() {
              if (!(h() >= 1)) {
                var a = 0,
                  b = h();
                a =
                  b >= 0 && 0.25 > b
                    ? (3 * Math.random() + 3) / 100
                    : b >= 0.25 && 0.65 > b
                    ? (3 * Math.random()) / 100
                    : b >= 0.65 && 0.9 > b
                    ? (2 * Math.random()) / 100
                    : b >= 0.9 && 0.99 > b
                    ? 0.005
                    : 0;
                var c = h() + a;
                f(c);
              }
            }
            function h() {
              return s;
            }
            function i() {
              (s = 0), (r = !1);
            }
            function j() {
              k || (k = a.get("$animate")),
                f(1),
                c.cancel(m),
                (m = c(function () {
                  var a = k.leave(o, i);
                  a && a.then && a.then(i),
                    k.leave(q),
                    d.$broadcast("cfpLoadingBar:completed");
                }, 500));
            }
            var k,
              l,
              m,
              n = this.parentSelector,
              o = angular.element(this.loadingBarTemplate),
              p = o.find("div").eq(0),
              q = angular.element(this.spinnerTemplate),
              r = !1,
              s = 0,
              t = this.autoIncrement,
              u = this.includeSpinner,
              v = this.includeBar,
              w = this.startSize;
            return {
              start: e,
              set: f,
              status: h,
              inc: g,
              complete: j,
              autoIncrement: this.autoIncrement,
              includeSpinner: this.includeSpinner,
              latencyThreshold: this.latencyThreshold,
              parentSelector: this.parentSelector,
              startSize: this.startSize,
            };
          },
        ]);
    });
})();

/**
 * @ngDoc directive
 * @name ng.directive:paging
 *
 * @description
 * A directive to aid in paging large datasets
 * while requiring a small amount of page
 * information.
 *
 * @element EA
 *
 */
angular.module("bw.paging", []).directive("paging", function () {
  /**
   * The regex expression to use for any replace methods
   * Feel free to tweak / fork values for your application
   */
  var regex = /\{page\}/g;

  /**
   * The angular return value required for the directive
   * Feel free to tweak / fork values for your application
   */
  return {
    // Restrict to elements and attributes
    restrict: "EA",

    // Assign the angular link function
    link: columnLink,

    // Assign the angular directive template HTML
    template: columnTemplate,

    // Assign the angular scope attribute formatting
    scope: {
      page: "=",
      pageSize: "=",
      total: "=",
      scrollTop: "=",
      disabled: "@",
      dots: "@",
      ulClass: "@",
      aClass: "@",
      activeClass: "@",
      disabledClass: "@",
      adjacent: "@",
      pagingAction: "&",
      pgHref: "@",
      textFirst: "@",
      textLast: "@",
      textNext: "@",
      textPrev: "@",
      textFirstClass: "@",
      textLastClass: "@",
      textNextClass: "@",
      textPrevClass: "@",
      textTitlePage: "@",
      textTitleFirst: "@",
      textTitleLast: "@",
      textTitleNext: "@",
      textTitlePrev: "@",
    },
  };

  /**
   * Link the directive to enable our scope watch values
   *
   * @param {object} scope - Angular link scope
   * @param {object} el - Angular link element
   * @param {object} attrs - Angular link attribute
   */
  function columnLink(scope, el, attrs) {
    // Hook in our watched items
    scope.$watchCollection("[page,pageSize,total,disabled]", function () {
      build(scope, attrs);
    });
  }

  /**
   * Create our template html
   * We use a function to figure out how to handle href correctly
   *
   * @param {object} el - Angular link element
   * @param {object} attrs - Angular link attribute
   */
  function columnTemplate(el, attrs) {
    return (
      '<ul data-ng-hide="Hide" data-ng-class="ulClass"> ' +
      '<li class="page-item"' +
      'title="{{item.title}}" ' +
      'data-ng-class="Item.liClass" ' +
      'data-ng-repeat="Item in List"> ' +
      "<a " +
      (attrs.pgHref ? 'data-ng-href="{{Item.pgHref}}" ' : "href ") +
      'data-ng-class="aClass" ' +
      'data-ng-click="Item.action()" ' +
      'data-ng-bind="Item.value">' +
      "</a> " +
      "</li>" +
      "</ul>"
    );
  }

  /**
   * Assign default scope values from settings
   * Feel free to tweak / fork these for your application
   *
   * @param {Object} scope - The local directive scope object
   * @param {Object} attrs - The local directive attribute object
   */
  function setScopeValues(scope, attrs) {
    scope.List = [];
    scope.Hide = false;

    scope.page = parseInt(scope.page) || 1;
    scope.total = parseInt(scope.total) || 0;
    scope.adjacent = parseInt(scope.adjacent) || 2;

    scope.pgHref = scope.pgHref || "";
    scope.dots = scope.dots || "...";

    scope.ulClass = scope.ulClass || "pagination";
    scope.activeClass = scope.activeClass || "active";
    scope.disabledClass = scope.disabledClass || "disabled";

    scope.textFirst = scope.textFirst || "<<";
    scope.textLast = scope.textLast || ">>";
    scope.textNext = scope.textNext || ">";
    scope.textPrev = scope.textPrev || "<";

    scope.textFirstClass = scope.textFirstClass || "";
    scope.textLastClass = scope.textLastClass || "";
    scope.textNextClass = scope.textNextClass || "";
    scope.textPrevClass = scope.textPrevClass || "";

    scope.textTitlePage = scope.textTitlePage || "Page {page}";
    scope.textTitleFirst = scope.textTitleFirst || "First Page";
    scope.textTitleLast = scope.textTitleLast || "Last Page";
    scope.textTitleNext = scope.textTitleNext || "Next Page";
    scope.textTitlePrev = scope.textTitlePrev || "Previous Page";

    scope.hideIfEmpty = evalBoolAttribute(scope, attrs.hideIfEmpty);
    scope.showPrevNext = evalBoolAttribute(scope, attrs.showPrevNext);
    scope.showFirstLast = evalBoolAttribute(scope, attrs.showFirstLast);
    scope.scrollTop = String(scope.scrollTop) == "true"; //evalBoolAttribute(scope, attrs.scrollTop);
    scope.isDisabled = evalBoolAttribute(scope, attrs.disabled);
  }

  /**
   * A helper to perform our boolean eval on attributes
   * This allows flexibility in the attribute for strings and variables in scope
   *
   * @param {Object} scope - The local directive scope object
   * @param {Object} value - The attribute value of interest
   */
  function evalBoolAttribute(scope, value) {
    return angular.isDefined(value) ? !!scope.$parent.$eval(value) : false;
  }

  /**
   * Validate and clean up any scope values
   * This happens after we have set the scope values
   *
   * @param {Object} scope - The local directive scope object
   * @param {int} pageCount - The last page number or total page count
   */
  function validateScopeValues(scope, pageCount) {
    // Block where the page is larger than the pageCount
    // if (scope.page > pageCount) {
    //     scope.page = pageCount;
    // }

    // Block where the page is less than 0
    if (scope.page <= 0) {
      scope.page = 1;
    }

    // Block where adjacent value is 0 or below
    if (scope.adjacent <= 0) {
      scope.adjacent = 2;
    }

    // Hide from page if we have 1 or less pages
    // if directed to hide empty
    if (pageCount <= 1) {
      scope.Hide = scope.hideIfEmpty;
    }
  }

  /**
   * Assign the method action to take when a page is clicked
   *
   * @param {Object} scope - The local directive scope object
   * @param {int} page - The current page of interest
   */
  function internalAction(scope, page) {
    // Block clicks we try to load the active page
    if (scope.page === page) {
      return;
    }

    // Block if we are forcing disabled
    if (scope.isDisabled) {
      return;
    }

    // Update the page in scope
    scope.page = page;

    // Pass our parameters to the paging action
    scope.pagingAction({
      page: scope.page,
      pageSize: scope.pageSize,
      total: scope.total,
    });

    // If allowed scroll up to the top of the page
    if (scope.scrollTop) {
      //scrollTo(0, 0);
      $("html, body").animate({ scrollTop: "0px" }, 500);
    }
  }

  /**
   * Add the first, previous, next, and last buttons if desired
   * The logic is defined by the mode of interest
   * This method will simply return if the scope.showPrevNext is false
   * This method will simply return if there are no pages to display
   *
   * @param {Object} scope - The local directive scope object
   * @param {int} pageCount - The last page number or total page count
   * @param {string} mode - The mode of interest either prev or last
   */
  function addPrevNext(scope, pageCount, mode) {
    // Ignore if we are not showing
    // or there are no pages to display
    if ((!scope.showPrevNext && !scope.showFirstLast) || pageCount < 1) {
      return;
    }

    // Local variables to help determine logic
    var disabled, alpha, beta;

    // Determine logic based on the mode of interest
    // Calculate the previous / next page and if the click actions are allowed
    if (mode === "prev") {
      disabled = scope.page - 1 <= 0;
      var prevPage = scope.page - 1 <= 0 ? 1 : scope.page - 1;

      if (scope.showFirstLast) {
        alpha = {
          value: scope.textFirst,
          title: scope.textTitleFirst,
          aClass: scope.textFirstClass,
          page: 1,
        };
      }

      if (scope.showPrevNext) {
        beta = {
          value: scope.textPrev,
          title: scope.textTitlePrev,
          aClass: scope.textPrevClass,
          page: prevPage,
        };
      }
    } else {
      disabled = scope.page + 1 > pageCount;
      var nextPage = scope.page + 1 >= pageCount ? pageCount : scope.page + 1;

      if (scope.showPrevNext) {
        alpha = {
          value: scope.textNext,
          title: scope.textTitleNext,
          aClass: scope.textNextClass,
          page: nextPage,
        };
      }

      if (scope.showFirstLast) {
        beta = {
          value: scope.textLast,
          title: scope.textTitleLast,
          aClass: scope.textLastClass,
          page: pageCount,
        };
      }
    }

    // Create the Add Item Function
    var buildItem = function (item, disabled) {
      return {
        title: item.title,
        aClass: item.aClass,
        value: item.aClass ? "" : item.value,
        liClass: disabled ? scope.disabledClass : "",
        pgHref: disabled ? "" : scope.pgHref.replace(regex, item.page),
        action: function () {
          if (!disabled) {
            internalAction(scope, item.page);
          }
        },
      };
    };

    // Force disabled if specified
    if (scope.isDisabled) {
      disabled = true;
    }

    // Add alpha items
    if (alpha) {
      var alphaItem = buildItem(alpha, disabled);
      scope.List.push(alphaItem);
    }

    // Add beta items
    if (beta) {
      var betaItem = buildItem(beta, disabled);
      scope.List.push(betaItem);
    }
  }

  /**
   * Adds a range of numbers to our list
   * The range is dependent on the start and finish parameters
   *
   * @param {int} start - The start of the range to add to the paging list
   * @param {int} finish - The end of the range to add to the paging list
   * @param {Object} scope - The local directive scope object
   */
  function addRange(start, finish, scope) {
    // Add our items where i is the page number
    var i = 0;
    for (i = start; i <= finish; i++) {
      var pgHref = scope.pgHref.replace(regex, i);
      var liClass = scope.page === i ? scope.activeClass : "";

      // Handle items that are affected by disabled
      if (scope.isDisabled) {
        pgHref = "";
        liClass = scope.disabledClass;
      }

      scope.List.push({
        value: i,
        title: scope.textTitlePage.replace(regex, i),
        liClass: liClass,
        pgHref: pgHref,
        action: function () {
          internalAction(scope, this.value);
        },
      });
    }
  }

  /**
   * Add Dots ie: 1 2 [...] 10 11 12 [...] 56 57
   * This is my favorite function not going to lie
   *
   * @param {Object} scope - The local directive scope object
   */
  function addDots(scope) {
    scope.List.push({
      value: scope.dots,
      liClass: scope.disabledClass,
    });
  }

  /**
   * Add the first or beginning items in our paging list
   * We leverage the 'next' parameter to determine if the dots are required
   *
   * @param {Object} scope - The local directive scope object
   * @param {int} next - the next page number in the paging sequence
   */
  function addFirst(scope, next) {
    addRange(1, 2, scope);

    // We ignore dots if the next value is 3
    // ie: 1 2 [...] 3 4 5 becomes just 1 2 3 4 5
    if (next !== 3) {
      addDots(scope);
    }
  }

  /**
   * Add the last or end items in our paging list
   * We leverage the 'prev' parameter to determine if the dots are required
   *
   * @param {int} pageCount - The last page number or total page count
   * @param {Object} scope - The local directive scope object
   * @param {int} prev - the previous page number in the paging sequence
   */
  // Add Last Pages
  function addLast(pageCount, scope, prev) {
    // We ignore dots if the previous value is one less that our start range
    // ie: 1 2 3 4 [...] 5 6  becomes just 1 2 3 4 5 6
    if (prev !== pageCount - 2) {
      addDots(scope);
    }

    addRange(pageCount - 1, pageCount, scope);
  }

  /**
   * The main build function used to determine the paging logic
   * Feel free to tweak / fork values for your application
   *
   * @param {Object} scope - The local directive scope object
   * @param {Object} attrs - The local directive attribute object
   */
  function build(scope, attrs) {
    // Block divide by 0 and empty page size
    if (!scope.pageSize || scope.pageSize <= 0) {
      scope.pageSize = 1;
    }

    // Determine the last page or total page count
    var pageCount = Math.ceil(scope.total / scope.pageSize);

    // Set the default scope values where needed
    setScopeValues(scope, attrs);

    // Validate the scope values to protect against strange states
    validateScopeValues(scope, pageCount);

    // Create the beginning and end page values
    var start, finish;

    // Calculate the full adjacency value
    var fullAdjacentSize = scope.adjacent * 2 + 2;

    // Add the Next and Previous buttons to our list
    addPrevNext(scope, pageCount, "prev");

    // If the page count is less than the full adjacnet size
    // Then we simply display all the pages, Otherwise we calculate the proper paging display
    if (pageCount <= fullAdjacentSize + 2) {
      start = 1;
      addRange(start, pageCount, scope);
    } else {
      // Determine if we are showing the beginning of the paging list
      // We know it is the beginning if the page - adjacent is <= 2
      if (scope.page - scope.adjacent <= 2) {
        start = 1;
        finish = 1 + fullAdjacentSize;

        addRange(start, finish, scope);
        addLast(pageCount, scope, finish);
      }

      // Determine if we are showing the middle of the paging list
      // We know we are either in the middle or at the end since the beginning is ruled out above
      // So we simply check if we are not at the end
      // Again 2 is hard coded as we always display two pages after the dots
      else if (scope.page < pageCount - (scope.adjacent + 2)) {
        start = scope.page - scope.adjacent;
        finish = scope.page + scope.adjacent;

        addFirst(scope, start);
        addRange(start, finish, scope);
        addLast(pageCount, scope, finish);
      }

      // If nothing else we conclude we are at the end of the paging list
      // We know this since we have already ruled out the beginning and middle above
      else {
        start = pageCount - fullAdjacentSize;
        finish = pageCount;

        addFirst(scope, start);
        addRange(start, finish, scope);
      }
    }

    // Add the next and last buttons to our paging list
    addPrevNext(scope, pageCount, "next");
  }
});

(function webpackUniversalModuleDefinition(root, factory) {
  if (typeof exports === "object" && typeof module === "object")
    module.exports = factory();
  else if (typeof define === "function" && define.amd) define([], factory);
  else if (typeof exports === "object") exports["signalR"] = factory();
  else root["signalR"] = factory();
})(window, function () {
  return (function (modules) {
    var installedModules = {};
    function __webpack_require__(moduleId) {
      if (installedModules[moduleId]) {
        return installedModules[moduleId].exports;
      }
      var module = (installedModules[moduleId] = {
        i: moduleId,
        l: false,
        exports: {},
      });
      modules[moduleId].call(
        module.exports,
        module,
        module.exports,
        __webpack_require__
      );
      module.l = true;
      return module.exports;
    }
    __webpack_require__.m = modules;
    __webpack_require__.c = installedModules;
    __webpack_require__.d = function (exports, name, getter) {
      if (!__webpack_require__.o(exports, name)) {
        Object.defineProperty(exports, name, { enumerable: true, get: getter });
      }
    };
    __webpack_require__.r = function (exports) {
      if (typeof Symbol !== "undefined" && Symbol.toStringTag) {
        Object.defineProperty(exports, Symbol.toStringTag, { value: "Module" });
      }
      Object.defineProperty(exports, "__esModule", { value: true });
    };
    __webpack_require__.t = function (value, mode) {
      if (mode & 1) value = __webpack_require__(value);
      if (mode & 8) return value;
      if (mode & 4 && typeof value === "object" && value && value.__esModule)
        return value;
      var ns = Object.create(null);
      __webpack_require__.r(ns);
      Object.defineProperty(ns, "default", { enumerable: true, value: value });
      if (mode & 2 && typeof value != "string")
        for (var key in value)
          __webpack_require__.d(
            ns,
            key,
            function (key) {
              return value[key];
            }.bind(null, key)
          );
      return ns;
    };
    __webpack_require__.n = function (module) {
      var getter =
        module && module.__esModule
          ? function getDefault() {
              return module["default"];
            }
          : function getModuleExports() {
              return module;
            };
      __webpack_require__.d(getter, "a", getter);
      return getter;
    };
    __webpack_require__.o = function (object, property) {
      return Object.prototype.hasOwnProperty.call(object, property);
    };
    __webpack_require__.p = "";
    return __webpack_require__((__webpack_require__.s = 0));
  })([
    function (module, __webpack_exports__, __webpack_require__) {
      "use strict";
      __webpack_require__.r(__webpack_exports__);
      var es6_promise_dist_es6_promise_auto_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(
        1
      );
      var es6_promise_dist_es6_promise_auto_js__WEBPACK_IMPORTED_MODULE_0___default = __webpack_require__.n(
        es6_promise_dist_es6_promise_auto_js__WEBPACK_IMPORTED_MODULE_0__
      );
      var _index__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(3);
      __webpack_require__.d(__webpack_exports__, "VERSION", function () {
        return _index__WEBPACK_IMPORTED_MODULE_1__["VERSION"];
      });
      __webpack_require__.d(__webpack_exports__, "AbortError", function () {
        return _index__WEBPACK_IMPORTED_MODULE_1__["AbortError"];
      });
      __webpack_require__.d(__webpack_exports__, "HttpError", function () {
        return _index__WEBPACK_IMPORTED_MODULE_1__["HttpError"];
      });
      __webpack_require__.d(__webpack_exports__, "TimeoutError", function () {
        return _index__WEBPACK_IMPORTED_MODULE_1__["TimeoutError"];
      });
      __webpack_require__.d(__webpack_exports__, "HttpClient", function () {
        return _index__WEBPACK_IMPORTED_MODULE_1__["HttpClient"];
      });
      __webpack_require__.d(__webpack_exports__, "HttpResponse", function () {
        return _index__WEBPACK_IMPORTED_MODULE_1__["HttpResponse"];
      });
      __webpack_require__.d(
        __webpack_exports__,
        "DefaultHttpClient",
        function () {
          return _index__WEBPACK_IMPORTED_MODULE_1__["DefaultHttpClient"];
        }
      );
      __webpack_require__.d(__webpack_exports__, "HubConnection", function () {
        return _index__WEBPACK_IMPORTED_MODULE_1__["HubConnection"];
      });
      __webpack_require__.d(
        __webpack_exports__,
        "HubConnectionState",
        function () {
          return _index__WEBPACK_IMPORTED_MODULE_1__["HubConnectionState"];
        }
      );
      __webpack_require__.d(
        __webpack_exports__,
        "HubConnectionBuilder",
        function () {
          return _index__WEBPACK_IMPORTED_MODULE_1__["HubConnectionBuilder"];
        }
      );
      __webpack_require__.d(__webpack_exports__, "MessageType", function () {
        return _index__WEBPACK_IMPORTED_MODULE_1__["MessageType"];
      });
      __webpack_require__.d(__webpack_exports__, "LogLevel", function () {
        return _index__WEBPACK_IMPORTED_MODULE_1__["LogLevel"];
      });
      __webpack_require__.d(
        __webpack_exports__,
        "HttpTransportType",
        function () {
          return _index__WEBPACK_IMPORTED_MODULE_1__["HttpTransportType"];
        }
      );
      __webpack_require__.d(__webpack_exports__, "TransferFormat", function () {
        return _index__WEBPACK_IMPORTED_MODULE_1__["TransferFormat"];
      });
      __webpack_require__.d(__webpack_exports__, "NullLogger", function () {
        return _index__WEBPACK_IMPORTED_MODULE_1__["NullLogger"];
      });
      __webpack_require__.d(
        __webpack_exports__,
        "JsonHubProtocol",
        function () {
          return _index__WEBPACK_IMPORTED_MODULE_1__["JsonHubProtocol"];
        }
      );
      __webpack_require__.d(__webpack_exports__, "Subject", function () {
        return _index__WEBPACK_IMPORTED_MODULE_1__["Subject"];
      });
      if (!Uint8Array.prototype.indexOf) {
        Object.defineProperty(Uint8Array.prototype, "indexOf", {
          value: Array.prototype.indexOf,
          writable: true,
        });
      }
      if (!Uint8Array.prototype.slice) {
        Object.defineProperty(Uint8Array.prototype, "slice", {
          value: function (start, end) {
            return new Uint8Array(Array.prototype.slice.call(this, start, end));
          },
          writable: true,
        });
      }
      if (!Uint8Array.prototype.forEach) {
        Object.defineProperty(Uint8Array.prototype, "forEach", {
          value: Array.prototype.forEach,
          writable: true,
        });
      }
    },
    function (module, exports, __webpack_require__) {
      (function (global) {
        var require;
        /*!
         * @overview es6-promise - a tiny implementation of Promises/A+.
         * @copyright Copyright (c) 2014 Yehuda Katz, Tom Dale, Stefan Penner and contributors (Conversion to ES6 API by Jake Archibald)
         * @license   Licensed under MIT license
         *            See https://raw.githubusercontent.com/stefanpenner/es6-promise/master/LICENSE
         * @version   v4.2.2+97478eb6
         */
        /*!
         * @overview es6-promise - a tiny implementation of Promises/A+.
         * @copyright Copyright (c) 2014 Yehuda Katz, Tom Dale, Stefan Penner and contributors (Conversion to ES6 API by Jake Archibald)
         * @license   Licensed under MIT license
         *            See https://raw.githubusercontent.com/stefanpenner/es6-promise/master/LICENSE
         * @version   v4.2.2+97478eb6
         */
        (function (global, factory) {
          true ? (module.exports = factory()) : undefined;
        })(this, function () {
          "use strict";
          function objectOrFunction(x) {
            var type = typeof x;
            return x !== null && (type === "object" || type === "function");
          }
          function isFunction(x) {
            return typeof x === "function";
          }
          var _isArray = void 0;
          if (Array.isArray) {
            _isArray = Array.isArray;
          } else {
            _isArray = function (x) {
              return Object.prototype.toString.call(x) === "[object Array]";
            };
          }
          var isArray = _isArray;
          var len = 0;
          var vertxNext = void 0;
          var customSchedulerFn = void 0;
          var asap = function asap(callback, arg) {
            queue[len] = callback;
            queue[len + 1] = arg;
            len += 2;
            if (len === 2) {
              if (customSchedulerFn) {
                customSchedulerFn(flush);
              } else {
                scheduleFlush();
              }
            }
          };
          function setScheduler(scheduleFn) {
            customSchedulerFn = scheduleFn;
          }
          function setAsap(asapFn) {
            asap = asapFn;
          }
          var browserWindow =
            typeof window !== "undefined" ? window : undefined;
          var browserGlobal = browserWindow || {};
          var BrowserMutationObserver =
            browserGlobal.MutationObserver ||
            browserGlobal.WebKitMutationObserver;
          var isNode =
            typeof self === "undefined" &&
            typeof process !== "undefined" &&
            {}.toString.call(process) === "[object process]";
          var isWorker =
            typeof Uint8ClampedArray !== "undefined" &&
            typeof importScripts !== "undefined" &&
            typeof MessageChannel !== "undefined";
          function useNextTick() {
            return function () {
              return process.nextTick(flush);
            };
          }
          function useVertxTimer() {
            if (typeof vertxNext !== "undefined") {
              return function () {
                vertxNext(flush);
              };
            }
            return useSetTimeout();
          }
          function useMutationObserver() {
            var iterations = 0;
            var observer = new BrowserMutationObserver(flush);
            var node = document.createTextNode("");
            observer.observe(node, { characterData: true });
            return function () {
              node.data = iterations = ++iterations % 2;
            };
          }
          function useMessageChannel() {
            var channel = new MessageChannel();
            channel.port1.onmessage = flush;
            return function () {
              return channel.port2.postMessage(0);
            };
          }
          function useSetTimeout() {
            var globalSetTimeout = setTimeout;
            return function () {
              return globalSetTimeout(flush, 1);
            };
          }
          var queue = new Array(1e3);
          function flush() {
            for (var i = 0; i < len; i += 2) {
              var callback = queue[i];
              var arg = queue[i + 1];
              callback(arg);
              queue[i] = undefined;
              queue[i + 1] = undefined;
            }
            len = 0;
          }
          function attemptVertx() {
            try {
              var r = require;
              var vertx = __webpack_require__(
                !(function webpackMissingModule() {
                  var e = new Error("Cannot find module 'vertx'");
                  e.code = "MODULE_NOT_FOUND";
                  throw e;
                })()
              );
              vertxNext = vertx.runOnLoop || vertx.runOnContext;
              return useVertxTimer();
            } catch (e) {
              return useSetTimeout();
            }
          }
          var scheduleFlush = void 0;
          if (isNode) {
            scheduleFlush = useNextTick();
          } else if (BrowserMutationObserver) {
            scheduleFlush = useMutationObserver();
          } else if (isWorker) {
            scheduleFlush = useMessageChannel();
          } else if (browserWindow === undefined && "function" === "function") {
            scheduleFlush = attemptVertx();
          } else {
            scheduleFlush = useSetTimeout();
          }
          function then(onFulfillment, onRejection) {
            var parent = this;
            var child = new this.constructor(noop);
            if (child[PROMISE_ID] === undefined) {
              makePromise(child);
            }
            var _state = parent._state;
            if (_state) {
              var callback = arguments[_state - 1];
              asap(function () {
                return invokeCallback(_state, child, callback, parent._result);
              });
            } else {
              subscribe(parent, child, onFulfillment, onRejection);
            }
            return child;
          }
          function resolve$1(object) {
            var Constructor = this;
            if (
              object &&
              typeof object === "object" &&
              object.constructor === Constructor
            ) {
              return object;
            }
            var promise = new Constructor(noop);
            resolve(promise, object);
            return promise;
          }
          var PROMISE_ID = Math.random().toString(36).substring(16);
          function noop() {}
          var PENDING = void 0;
          var FULFILLED = 1;
          var REJECTED = 2;
          var GET_THEN_ERROR = new ErrorObject();
          function selfFulfillment() {
            return new TypeError("You cannot resolve a promise with itself");
          }
          function cannotReturnOwn() {
            return new TypeError(
              "A promises callback cannot return that same promise."
            );
          }
          function getThen(promise) {
            try {
              return promise.then;
            } catch (error) {
              GET_THEN_ERROR.error = error;
              return GET_THEN_ERROR;
            }
          }
          function tryThen(
            then$$1,
            value,
            fulfillmentHandler,
            rejectionHandler
          ) {
            try {
              then$$1.call(value, fulfillmentHandler, rejectionHandler);
            } catch (e) {
              return e;
            }
          }
          function handleForeignThenable(promise, thenable, then$$1) {
            asap(function (promise) {
              var sealed = false;
              var error = tryThen(
                then$$1,
                thenable,
                function (value) {
                  if (sealed) {
                    return;
                  }
                  sealed = true;
                  if (thenable !== value) {
                    resolve(promise, value);
                  } else {
                    fulfill(promise, value);
                  }
                },
                function (reason) {
                  if (sealed) {
                    return;
                  }
                  sealed = true;
                  reject(promise, reason);
                },
                "Settle: " + (promise._label || " unknown promise")
              );
              if (!sealed && error) {
                sealed = true;
                reject(promise, error);
              }
            }, promise);
          }
          function handleOwnThenable(promise, thenable) {
            if (thenable._state === FULFILLED) {
              fulfill(promise, thenable._result);
            } else if (thenable._state === REJECTED) {
              reject(promise, thenable._result);
            } else {
              subscribe(
                thenable,
                undefined,
                function (value) {
                  return resolve(promise, value);
                },
                function (reason) {
                  return reject(promise, reason);
                }
              );
            }
          }
          function handleMaybeThenable(promise, maybeThenable, then$$1) {
            if (
              maybeThenable.constructor === promise.constructor &&
              then$$1 === then &&
              maybeThenable.constructor.resolve === resolve$1
            ) {
              handleOwnThenable(promise, maybeThenable);
            } else {
              if (then$$1 === GET_THEN_ERROR) {
                reject(promise, GET_THEN_ERROR.error);
                GET_THEN_ERROR.error = null;
              } else if (then$$1 === undefined) {
                fulfill(promise, maybeThenable);
              } else if (isFunction(then$$1)) {
                handleForeignThenable(promise, maybeThenable, then$$1);
              } else {
                fulfill(promise, maybeThenable);
              }
            }
          }
          function resolve(promise, value) {
            if (promise === value) {
              reject(promise, selfFulfillment());
            } else if (objectOrFunction(value)) {
              handleMaybeThenable(promise, value, getThen(value));
            } else {
              fulfill(promise, value);
            }
          }
          function publishRejection(promise) {
            if (promise._onerror) {
              promise._onerror(promise._result);
            }
            publish(promise);
          }
          function fulfill(promise, value) {
            if (promise._state !== PENDING) {
              return;
            }
            promise._result = value;
            promise._state = FULFILLED;
            if (promise._subscribers.length !== 0) {
              asap(publish, promise);
            }
          }
          function reject(promise, reason) {
            if (promise._state !== PENDING) {
              return;
            }
            promise._state = REJECTED;
            promise._result = reason;
            asap(publishRejection, promise);
          }
          function subscribe(parent, child, onFulfillment, onRejection) {
            var _subscribers = parent._subscribers;
            var length = _subscribers.length;
            parent._onerror = null;
            _subscribers[length] = child;
            _subscribers[length + FULFILLED] = onFulfillment;
            _subscribers[length + REJECTED] = onRejection;
            if (length === 0 && parent._state) {
              asap(publish, parent);
            }
          }
          function publish(promise) {
            var subscribers = promise._subscribers;
            var settled = promise._state;
            if (subscribers.length === 0) {
              return;
            }
            var child = void 0,
              callback = void 0,
              detail = promise._result;
            for (var i = 0; i < subscribers.length; i += 3) {
              child = subscribers[i];
              callback = subscribers[i + settled];
              if (child) {
                invokeCallback(settled, child, callback, detail);
              } else {
                callback(detail);
              }
            }
            promise._subscribers.length = 0;
          }
          function ErrorObject() {
            this.error = null;
          }
          var TRY_CATCH_ERROR = new ErrorObject();
          function tryCatch(callback, detail) {
            try {
              return callback(detail);
            } catch (e) {
              TRY_CATCH_ERROR.error = e;
              return TRY_CATCH_ERROR;
            }
          }
          function invokeCallback(settled, promise, callback, detail) {
            var hasCallback = isFunction(callback),
              value = void 0,
              error = void 0,
              succeeded = void 0,
              failed = void 0;
            if (hasCallback) {
              value = tryCatch(callback, detail);
              if (value === TRY_CATCH_ERROR) {
                failed = true;
                error = value.error;
                value.error = null;
              } else {
                succeeded = true;
              }
              if (promise === value) {
                reject(promise, cannotReturnOwn());
                return;
              }
            } else {
              value = detail;
              succeeded = true;
            }
            if (promise._state !== PENDING) {
            } else if (hasCallback && succeeded) {
              resolve(promise, value);
            } else if (failed) {
              reject(promise, error);
            } else if (settled === FULFILLED) {
              fulfill(promise, value);
            } else if (settled === REJECTED) {
              reject(promise, value);
            }
          }
          function initializePromise(promise, resolver) {
            try {
              resolver(
                function resolvePromise(value) {
                  resolve(promise, value);
                },
                function rejectPromise(reason) {
                  reject(promise, reason);
                }
              );
            } catch (e) {
              reject(promise, e);
            }
          }
          var id = 0;
          function nextId() {
            return id++;
          }
          function makePromise(promise) {
            promise[PROMISE_ID] = id++;
            promise._state = undefined;
            promise._result = undefined;
            promise._subscribers = [];
          }
          function validationError() {
            return new Error("Array Methods must be provided an Array");
          }
          function validationError() {
            return new Error("Array Methods must be provided an Array");
          }
          var Enumerator = (function () {
            function Enumerator(Constructor, input) {
              this._instanceConstructor = Constructor;
              this.promise = new Constructor(noop);
              if (!this.promise[PROMISE_ID]) {
                makePromise(this.promise);
              }
              if (isArray(input)) {
                this.length = input.length;
                this._remaining = input.length;
                this._result = new Array(this.length);
                if (this.length === 0) {
                  fulfill(this.promise, this._result);
                } else {
                  this.length = this.length || 0;
                  this._enumerate(input);
                  if (this._remaining === 0) {
                    fulfill(this.promise, this._result);
                  }
                }
              } else {
                reject(this.promise, validationError());
              }
            }
            Enumerator.prototype._enumerate = function _enumerate(input) {
              for (
                var i = 0;
                this._state === PENDING && i < input.length;
                i++
              ) {
                this._eachEntry(input[i], i);
              }
            };
            Enumerator.prototype._eachEntry = function _eachEntry(entry, i) {
              var c = this._instanceConstructor;
              var resolve$$1 = c.resolve;
              if (resolve$$1 === resolve$1) {
                var _then = getThen(entry);
                if (_then === then && entry._state !== PENDING) {
                  this._settledAt(entry._state, i, entry._result);
                } else if (typeof _then !== "function") {
                  this._remaining--;
                  this._result[i] = entry;
                } else if (c === Promise$2) {
                  var promise = new c(noop);
                  handleMaybeThenable(promise, entry, _then);
                  this._willSettleAt(promise, i);
                } else {
                  this._willSettleAt(
                    new c(function (resolve$$1) {
                      return resolve$$1(entry);
                    }),
                    i
                  );
                }
              } else {
                this._willSettleAt(resolve$$1(entry), i);
              }
            };
            Enumerator.prototype._settledAt = function _settledAt(
              state,
              i,
              value
            ) {
              var promise = this.promise;
              if (promise._state === PENDING) {
                this._remaining--;
                if (state === REJECTED) {
                  reject(promise, value);
                } else {
                  this._result[i] = value;
                }
              }
              if (this._remaining === 0) {
                fulfill(promise, this._result);
              }
            };
            Enumerator.prototype._willSettleAt = function _willSettleAt(
              promise,
              i
            ) {
              var enumerator = this;
              subscribe(
                promise,
                undefined,
                function (value) {
                  return enumerator._settledAt(FULFILLED, i, value);
                },
                function (reason) {
                  return enumerator._settledAt(REJECTED, i, reason);
                }
              );
            };
            return Enumerator;
          })();
          function all(entries) {
            return new Enumerator(this, entries).promise;
          }
          function race(entries) {
            var Constructor = this;
            if (!isArray(entries)) {
              return new Constructor(function (_, reject) {
                return reject(new TypeError("You must pass an array to race."));
              });
            } else {
              return new Constructor(function (resolve, reject) {
                var length = entries.length;
                for (var i = 0; i < length; i++) {
                  Constructor.resolve(entries[i]).then(resolve, reject);
                }
              });
            }
          }
          function reject$1(reason) {
            var Constructor = this;
            var promise = new Constructor(noop);
            reject(promise, reason);
            return promise;
          }
          function needsResolver() {
            throw new TypeError(
              "You must pass a resolver function as the first argument to the promise constructor"
            );
          }
          function needsNew() {
            throw new TypeError(
              "Failed to construct 'Promise': Please use the 'new' operator, this object constructor cannot be called as a function."
            );
          }
          var Promise$2 = (function () {
            function Promise(resolver) {
              this[PROMISE_ID] = nextId();
              this._result = this._state = undefined;
              this._subscribers = [];
              if (noop !== resolver) {
                typeof resolver !== "function" && needsResolver();
                this instanceof Promise
                  ? initializePromise(this, resolver)
                  : needsNew();
              }
            }
            Promise.prototype.catch = function _catch(onRejection) {
              return this.then(null, onRejection);
            };
            Promise.prototype.finally = function _finally(callback) {
              var promise = this;
              var constructor = promise.constructor;
              return promise.then(
                function (value) {
                  return constructor.resolve(callback()).then(function () {
                    return value;
                  });
                },
                function (reason) {
                  return constructor.resolve(callback()).then(function () {
                    throw reason;
                  });
                }
              );
            };
            return Promise;
          })();
          Promise$2.prototype.then = then;
          Promise$2.all = all;
          Promise$2.race = race;
          Promise$2.resolve = resolve$1;
          Promise$2.reject = reject$1;
          Promise$2._setScheduler = setScheduler;
          Promise$2._setAsap = setAsap;
          Promise$2._asap = asap;
          function polyfill() {
            var local = void 0;
            if (typeof global !== "undefined") {
              local = global;
            } else if (typeof self !== "undefined") {
              local = self;
            } else {
              try {
                local = Function("return this")();
              } catch (e) {
                throw new Error(
                  "polyfill failed because global object is unavailable in this environment"
                );
              }
            }
            var P = local.Promise;
            if (P) {
              var promiseToString = null;
              try {
                promiseToString = Object.prototype.toString.call(P.resolve());
              } catch (e) {}
              if (promiseToString === "[object Promise]" && !P.cast) {
                return;
              }
            }
            local.Promise = Promise$2;
          }
          Promise$2.polyfill = polyfill;
          Promise$2.Promise = Promise$2;
          Promise$2.polyfill();
          return Promise$2;
        });
      }.call(this, __webpack_require__(2)));
    },
    function (module, exports) {
      var g;
      g = (function () {
        return this;
      })();
      try {
        g = g || new Function("return this")();
      } catch (e) {
        if (typeof window === "object") g = window;
      }
      module.exports = g;
    },
    function (module, __webpack_exports__, __webpack_require__) {
      "use strict";
      __webpack_require__.r(__webpack_exports__);
      __webpack_require__.d(__webpack_exports__, "VERSION", function () {
        return VERSION;
      });
      var _Errors__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(4);
      __webpack_require__.d(__webpack_exports__, "AbortError", function () {
        return _Errors__WEBPACK_IMPORTED_MODULE_0__["AbortError"];
      });
      __webpack_require__.d(__webpack_exports__, "HttpError", function () {
        return _Errors__WEBPACK_IMPORTED_MODULE_0__["HttpError"];
      });
      __webpack_require__.d(__webpack_exports__, "TimeoutError", function () {
        return _Errors__WEBPACK_IMPORTED_MODULE_0__["TimeoutError"];
      });
      var _HttpClient__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(5);
      __webpack_require__.d(__webpack_exports__, "HttpClient", function () {
        return _HttpClient__WEBPACK_IMPORTED_MODULE_1__["HttpClient"];
      });
      __webpack_require__.d(__webpack_exports__, "HttpResponse", function () {
        return _HttpClient__WEBPACK_IMPORTED_MODULE_1__["HttpResponse"];
      });
      var _DefaultHttpClient__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(
        6
      );
      __webpack_require__.d(
        __webpack_exports__,
        "DefaultHttpClient",
        function () {
          return _DefaultHttpClient__WEBPACK_IMPORTED_MODULE_2__[
            "DefaultHttpClient"
          ];
        }
      );
      var _HubConnection__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(10);
      __webpack_require__.d(__webpack_exports__, "HubConnection", function () {
        return _HubConnection__WEBPACK_IMPORTED_MODULE_3__["HubConnection"];
      });
      __webpack_require__.d(
        __webpack_exports__,
        "HubConnectionState",
        function () {
          return _HubConnection__WEBPACK_IMPORTED_MODULE_3__[
            "HubConnectionState"
          ];
        }
      );
      var _HubConnectionBuilder__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(
        17
      );
      __webpack_require__.d(
        __webpack_exports__,
        "HubConnectionBuilder",
        function () {
          return _HubConnectionBuilder__WEBPACK_IMPORTED_MODULE_4__[
            "HubConnectionBuilder"
          ];
        }
      );
      var _IHubProtocol__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(15);
      __webpack_require__.d(__webpack_exports__, "MessageType", function () {
        return _IHubProtocol__WEBPACK_IMPORTED_MODULE_5__["MessageType"];
      });
      var _ILogger__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(9);
      __webpack_require__.d(__webpack_exports__, "LogLevel", function () {
        return _ILogger__WEBPACK_IMPORTED_MODULE_6__["LogLevel"];
      });
      var _ITransport__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(20);
      __webpack_require__.d(
        __webpack_exports__,
        "HttpTransportType",
        function () {
          return _ITransport__WEBPACK_IMPORTED_MODULE_7__["HttpTransportType"];
        }
      );
      __webpack_require__.d(__webpack_exports__, "TransferFormat", function () {
        return _ITransport__WEBPACK_IMPORTED_MODULE_7__["TransferFormat"];
      });
      var _Loggers__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(14);
      __webpack_require__.d(__webpack_exports__, "NullLogger", function () {
        return _Loggers__WEBPACK_IMPORTED_MODULE_8__["NullLogger"];
      });
      var _JsonHubProtocol__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(
        25
      );
      __webpack_require__.d(
        __webpack_exports__,
        "JsonHubProtocol",
        function () {
          return _JsonHubProtocol__WEBPACK_IMPORTED_MODULE_9__[
            "JsonHubProtocol"
          ];
        }
      );
      var _Subject__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(16);
      __webpack_require__.d(__webpack_exports__, "Subject", function () {
        return _Subject__WEBPACK_IMPORTED_MODULE_10__["Subject"];
      });
      var VERSION = "3.1.2";
    },
    function (module, __webpack_exports__, __webpack_require__) {
      "use strict";
      __webpack_require__.r(__webpack_exports__);
      __webpack_require__.d(__webpack_exports__, "HttpError", function () {
        return HttpError;
      });
      __webpack_require__.d(__webpack_exports__, "TimeoutError", function () {
        return TimeoutError;
      });
      __webpack_require__.d(__webpack_exports__, "AbortError", function () {
        return AbortError;
      });
      var __extends =
        (undefined && undefined.__extends) ||
        (function () {
          var extendStatics =
            Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array &&
              function (d, b) {
                d.__proto__ = b;
              }) ||
            function (d, b) {
              for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
            };
          return function (d, b) {
            extendStatics(d, b);
            function __() {
              this.constructor = d;
            }
            d.prototype =
              b === null
                ? Object.create(b)
                : ((__.prototype = b.prototype), new __());
          };
        })();
      var HttpError = (function (_super) {
        __extends(HttpError, _super);
        function HttpError(errorMessage, statusCode) {
          var _newTarget = this.constructor;
          var _this = this;
          var trueProto = _newTarget.prototype;
          _this = _super.call(this, errorMessage) || this;
          _this.statusCode = statusCode;
          _this.__proto__ = trueProto;
          return _this;
        }
        return HttpError;
      })(Error);
      var TimeoutError = (function (_super) {
        __extends(TimeoutError, _super);
        function TimeoutError(errorMessage) {
          var _newTarget = this.constructor;
          if (errorMessage === void 0) {
            errorMessage = "A timeout occurred.";
          }
          var _this = this;
          var trueProto = _newTarget.prototype;
          _this = _super.call(this, errorMessage) || this;
          _this.__proto__ = trueProto;
          return _this;
        }
        return TimeoutError;
      })(Error);
      var AbortError = (function (_super) {
        __extends(AbortError, _super);
        function AbortError(errorMessage) {
          var _newTarget = this.constructor;
          if (errorMessage === void 0) {
            errorMessage = "An abort occurred.";
          }
          var _this = this;
          var trueProto = _newTarget.prototype;
          _this = _super.call(this, errorMessage) || this;
          _this.__proto__ = trueProto;
          return _this;
        }
        return AbortError;
      })(Error);
    },
    function (module, __webpack_exports__, __webpack_require__) {
      "use strict";
      __webpack_require__.r(__webpack_exports__);
      __webpack_require__.d(__webpack_exports__, "HttpResponse", function () {
        return HttpResponse;
      });
      __webpack_require__.d(__webpack_exports__, "HttpClient", function () {
        return HttpClient;
      });
      var __assign =
        (undefined && undefined.__assign) ||
        Object.assign ||
        function (t) {
          for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s)
              if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];
          }
          return t;
        };
      var HttpResponse = (function () {
        function HttpResponse(statusCode, statusText, content) {
          this.statusCode = statusCode;
          this.statusText = statusText;
          this.content = content;
        }
        return HttpResponse;
      })();
      var HttpClient = (function () {
        function HttpClient() {}
        HttpClient.prototype.get = function (url, options) {
          return this.send(__assign({}, options, { method: "GET", url: url }));
        };
        HttpClient.prototype.post = function (url, options) {
          return this.send(__assign({}, options, { method: "POST", url: url }));
        };
        HttpClient.prototype.delete = function (url, options) {
          return this.send(
            __assign({}, options, { method: "DELETE", url: url })
          );
        };
        HttpClient.prototype.getCookieString = function (url) {
          return "";
        };
        return HttpClient;
      })();
    },
    function (module, __webpack_exports__, __webpack_require__) {
      "use strict";
      __webpack_require__.r(__webpack_exports__);
      __webpack_require__.d(
        __webpack_exports__,
        "DefaultHttpClient",
        function () {
          return DefaultHttpClient;
        }
      );
      var _Errors__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(4);
      var _HttpClient__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(5);
      var _NodeHttpClient__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(7);
      var _XhrHttpClient__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(8);
      var __extends =
        (undefined && undefined.__extends) ||
        (function () {
          var extendStatics =
            Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array &&
              function (d, b) {
                d.__proto__ = b;
              }) ||
            function (d, b) {
              for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
            };
          return function (d, b) {
            extendStatics(d, b);
            function __() {
              this.constructor = d;
            }
            d.prototype =
              b === null
                ? Object.create(b)
                : ((__.prototype = b.prototype), new __());
          };
        })();
      var DefaultHttpClient = (function (_super) {
        __extends(DefaultHttpClient, _super);
        function DefaultHttpClient(logger) {
          var _this = _super.call(this) || this;
          if (typeof XMLHttpRequest !== "undefined") {
            _this.httpClient = new _XhrHttpClient__WEBPACK_IMPORTED_MODULE_3__[
              "XhrHttpClient"
            ](logger);
          } else {
            _this.httpClient = new _NodeHttpClient__WEBPACK_IMPORTED_MODULE_2__[
              "NodeHttpClient"
            ](logger);
          }
          return _this;
        }
        DefaultHttpClient.prototype.send = function (request) {
          if (request.abortSignal && request.abortSignal.aborted) {
            return Promise.reject(
              new _Errors__WEBPACK_IMPORTED_MODULE_0__["AbortError"]()
            );
          }
          if (!request.method) {
            return Promise.reject(new Error("No method defined."));
          }
          if (!request.url) {
            return Promise.reject(new Error("No url defined."));
          }
          return this.httpClient.send(request);
        };
        DefaultHttpClient.prototype.getCookieString = function (url) {
          return this.httpClient.getCookieString(url);
        };
        return DefaultHttpClient;
      })(_HttpClient__WEBPACK_IMPORTED_MODULE_1__["HttpClient"]);
    },
    function (module, __webpack_exports__, __webpack_require__) {
      "use strict";
      __webpack_require__.r(__webpack_exports__);
      __webpack_require__.d(__webpack_exports__, "NodeHttpClient", function () {
        return NodeHttpClient;
      });
      var _HttpClient__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5);
      var __extends =
        (undefined && undefined.__extends) ||
        (function () {
          var extendStatics =
            Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array &&
              function (d, b) {
                d.__proto__ = b;
              }) ||
            function (d, b) {
              for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
            };
          return function (d, b) {
            extendStatics(d, b);
            function __() {
              this.constructor = d;
            }
            d.prototype =
              b === null
                ? Object.create(b)
                : ((__.prototype = b.prototype), new __());
          };
        })();
      var NodeHttpClient = (function (_super) {
        __extends(NodeHttpClient, _super);
        function NodeHttpClient(logger) {
          return _super.call(this) || this;
        }
        NodeHttpClient.prototype.send = function () {
          return Promise.reject(
            new Error(
              "If using Node either provide an XmlHttpRequest polyfill or consume the cjs or esm script instead of the browser/signalr.js one."
            )
          );
        };
        return NodeHttpClient;
      })(_HttpClient__WEBPACK_IMPORTED_MODULE_0__["HttpClient"]);
    },
    function (module, __webpack_exports__, __webpack_require__) {
      "use strict";
      __webpack_require__.r(__webpack_exports__);
      __webpack_require__.d(__webpack_exports__, "XhrHttpClient", function () {
        return XhrHttpClient;
      });
      var _Errors__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(4);
      var _HttpClient__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(5);
      var _ILogger__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(9);
      var __extends =
        (undefined && undefined.__extends) ||
        (function () {
          var extendStatics =
            Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array &&
              function (d, b) {
                d.__proto__ = b;
              }) ||
            function (d, b) {
              for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
            };
          return function (d, b) {
            extendStatics(d, b);
            function __() {
              this.constructor = d;
            }
            d.prototype =
              b === null
                ? Object.create(b)
                : ((__.prototype = b.prototype), new __());
          };
        })();
      var XhrHttpClient = (function (_super) {
        __extends(XhrHttpClient, _super);
        function XhrHttpClient(logger) {
          var _this = _super.call(this) || this;
          _this.logger = logger;
          return _this;
        }
        XhrHttpClient.prototype.send = function (request) {
          var _this = this;
          if (request.abortSignal && request.abortSignal.aborted) {
            return Promise.reject(
              new _Errors__WEBPACK_IMPORTED_MODULE_0__["AbortError"]()
            );
          }
          if (!request.method) {
            return Promise.reject(new Error("No method defined."));
          }
          if (!request.url) {
            return Promise.reject(new Error("No url defined."));
          }
          return new Promise(function (resolve, reject) {
            var xhr = new XMLHttpRequest();
            xhr.open(request.method, request.url, true);
            xhr.withCredentials = true;
            xhr.setRequestHeader("X-Requested-With", "XMLHttpRequest");
            xhr.setRequestHeader("Content-Type", "text/plain;charset=UTF-8");
            var headers = request.headers;
            if (headers) {
              Object.keys(headers).forEach(function (header) {
                xhr.setRequestHeader(header, headers[header]);
              });
            }
            if (request.responseType) {
              xhr.responseType = request.responseType;
            }
            if (request.abortSignal) {
              request.abortSignal.onabort = function () {
                xhr.abort();
                reject(
                  new _Errors__WEBPACK_IMPORTED_MODULE_0__["AbortError"]()
                );
              };
            }
            if (request.timeout) {
              xhr.timeout = request.timeout;
            }
            xhr.onload = function () {
              if (request.abortSignal) {
                request.abortSignal.onabort = null;
              }
              if (xhr.status >= 200 && xhr.status < 300) {
                resolve(
                  new _HttpClient__WEBPACK_IMPORTED_MODULE_1__["HttpResponse"](
                    xhr.status,
                    xhr.statusText,
                    xhr.response || xhr.responseText
                  )
                );
              } else {
                reject(
                  new _Errors__WEBPACK_IMPORTED_MODULE_0__["HttpError"](
                    xhr.statusText,
                    xhr.status
                  )
                );
              }
            };
            xhr.onerror = function () {
              _this.logger.log(
                _ILogger__WEBPACK_IMPORTED_MODULE_2__["LogLevel"].Warning,
                "Error from HTTP request. " +
                  xhr.status +
                  ": " +
                  xhr.statusText +
                  "."
              );
              reject(
                new _Errors__WEBPACK_IMPORTED_MODULE_0__["HttpError"](
                  xhr.statusText,
                  xhr.status
                )
              );
            };
            xhr.ontimeout = function () {
              _this.logger.log(
                _ILogger__WEBPACK_IMPORTED_MODULE_2__["LogLevel"].Warning,
                "Timeout from HTTP request."
              );
              reject(
                new _Errors__WEBPACK_IMPORTED_MODULE_0__["TimeoutError"]()
              );
            };
            xhr.send(request.content || "");
          });
        };
        return XhrHttpClient;
      })(_HttpClient__WEBPACK_IMPORTED_MODULE_1__["HttpClient"]);
    },
    function (module, __webpack_exports__, __webpack_require__) {
      "use strict";
      __webpack_require__.r(__webpack_exports__);
      __webpack_require__.d(__webpack_exports__, "LogLevel", function () {
        return LogLevel;
      });
      var LogLevel;
      (function (LogLevel) {
        LogLevel[(LogLevel["Trace"] = 0)] = "Trace";
        LogLevel[(LogLevel["Debug"] = 1)] = "Debug";
        LogLevel[(LogLevel["Information"] = 2)] = "Information";
        LogLevel[(LogLevel["Warning"] = 3)] = "Warning";
        LogLevel[(LogLevel["Error"] = 4)] = "Error";
        LogLevel[(LogLevel["Critical"] = 5)] = "Critical";
        LogLevel[(LogLevel["None"] = 6)] = "None";
      })(LogLevel || (LogLevel = {}));
    },
    function (module, __webpack_exports__, __webpack_require__) {
      "use strict";
      __webpack_require__.r(__webpack_exports__);
      __webpack_require__.d(
        __webpack_exports__,
        "HubConnectionState",
        function () {
          return HubConnectionState;
        }
      );
      __webpack_require__.d(__webpack_exports__, "HubConnection", function () {
        return HubConnection;
      });
      var _HandshakeProtocol__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(
        11
      );
      var _IHubProtocol__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(15);
      var _ILogger__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(9);
      var _Subject__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(16);
      var _Utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(13);
      var __awaiter =
        (undefined && undefined.__awaiter) ||
        function (thisArg, _arguments, P, generator) {
          return new (P || (P = Promise))(function (resolve, reject) {
            function fulfilled(value) {
              try {
                step(generator.next(value));
              } catch (e) {
                reject(e);
              }
            }
            function rejected(value) {
              try {
                step(generator["throw"](value));
              } catch (e) {
                reject(e);
              }
            }
            function step(result) {
              result.done
                ? resolve(result.value)
                : new P(function (resolve) {
                    resolve(result.value);
                  }).then(fulfilled, rejected);
            }
            step(
              (generator = generator.apply(thisArg, _arguments || [])).next()
            );
          });
        };
      var __generator =
        (undefined && undefined.__generator) ||
        function (thisArg, body) {
          var _ = {
              label: 0,
              sent: function () {
                if (t[0] & 1) throw t[1];
                return t[1];
              },
              trys: [],
              ops: [],
            },
            f,
            y,
            t,
            g;
          return (
            (g = { next: verb(0), throw: verb(1), return: verb(2) }),
            typeof Symbol === "function" &&
              (g[Symbol.iterator] = function () {
                return this;
              }),
            g
          );
          function verb(n) {
            return function (v) {
              return step([n, v]);
            };
          }
          function step(op) {
            if (f) throw new TypeError("Generator is already executing.");
            while (_)
              try {
                if (
                  ((f = 1),
                  y &&
                    (t =
                      op[0] & 2
                        ? y["return"]
                        : op[0]
                        ? y["throw"] || ((t = y["return"]) && t.call(y), 0)
                        : y.next) &&
                    !(t = t.call(y, op[1])).done)
                )
                  return t;
                if (((y = 0), t)) op = [op[0] & 2, t.value];
                switch (op[0]) {
                  case 0:
                  case 1:
                    t = op;
                    break;
                  case 4:
                    _.label++;
                    return { value: op[1], done: false };
                  case 5:
                    _.label++;
                    y = op[1];
                    op = [0];
                    continue;
                  case 7:
                    op = _.ops.pop();
                    _.trys.pop();
                    continue;
                  default:
                    if (
                      !((t = _.trys), (t = t.length > 0 && t[t.length - 1])) &&
                      (op[0] === 6 || op[0] === 2)
                    ) {
                      _ = 0;
                      continue;
                    }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) {
                      _.label = op[1];
                      break;
                    }
                    if (op[0] === 6 && _.label < t[1]) {
                      _.label = t[1];
                      t = op;
                      break;
                    }
                    if (t && _.label < t[2]) {
                      _.label = t[2];
                      _.ops.push(op);
                      break;
                    }
                    if (t[2]) _.ops.pop();
                    _.trys.pop();
                    continue;
                }
                op = body.call(thisArg, _);
              } catch (e) {
                op = [6, e];
                y = 0;
              } finally {
                f = t = 0;
              }
            if (op[0] & 5) throw op[1];
            return { value: op[0] ? op[1] : void 0, done: true };
          }
        };
      var DEFAULT_TIMEOUT_IN_MS = 30 * 1e3;
      var DEFAULT_PING_INTERVAL_IN_MS = 15 * 1e3;
      var HubConnectionState;
      (function (HubConnectionState) {
        HubConnectionState["Disconnected"] = "Disconnected";
        HubConnectionState["Connecting"] = "Connecting";
        HubConnectionState["Connected"] = "Connected";
        HubConnectionState["Disconnecting"] = "Disconnecting";
        HubConnectionState["Reconnecting"] = "Reconnecting";
      })(HubConnectionState || (HubConnectionState = {}));
      var HubConnection = (function () {
        function HubConnection(connection, logger, protocol, reconnectPolicy) {
          var _this = this;
          _Utils__WEBPACK_IMPORTED_MODULE_4__["Arg"].isRequired(
            connection,
            "connection"
          );
          _Utils__WEBPACK_IMPORTED_MODULE_4__["Arg"].isRequired(
            logger,
            "logger"
          );
          _Utils__WEBPACK_IMPORTED_MODULE_4__["Arg"].isRequired(
            protocol,
            "protocol"
          );
          this.serverTimeoutInMilliseconds = DEFAULT_TIMEOUT_IN_MS;
          this.keepAliveIntervalInMilliseconds = DEFAULT_PING_INTERVAL_IN_MS;
          this.logger = logger;
          this.protocol = protocol;
          this.connection = connection;
          this.reconnectPolicy = reconnectPolicy;
          this.handshakeProtocol = new _HandshakeProtocol__WEBPACK_IMPORTED_MODULE_0__[
            "HandshakeProtocol"
          ]();
          this.connection.onreceive = function (data) {
            return _this.processIncomingData(data);
          };
          this.connection.onclose = function (error) {
            return _this.connectionClosed(error);
          };
          this.callbacks = {};
          this.methods = {};
          this.closedCallbacks = [];
          this.reconnectingCallbacks = [];
          this.reconnectedCallbacks = [];
          this.invocationId = 0;
          this.receivedHandshakeResponse = false;
          this.connectionState = HubConnectionState.Disconnected;
          this.connectionStarted = false;
          this.cachedPingMessage = this.protocol.writeMessage({
            type:
              _IHubProtocol__WEBPACK_IMPORTED_MODULE_1__["MessageType"].Ping,
          });
        }
        HubConnection.create = function (
          connection,
          logger,
          protocol,
          reconnectPolicy
        ) {
          return new HubConnection(
            connection,
            logger,
            protocol,
            reconnectPolicy
          );
        };
        Object.defineProperty(HubConnection.prototype, "state", {
          get: function () {
            return this.connectionState;
          },
          enumerable: true,
          configurable: true,
        });
        Object.defineProperty(HubConnection.prototype, "connectionId", {
          get: function () {
            return this.connection
              ? this.connection.connectionId || null
              : null;
          },
          enumerable: true,
          configurable: true,
        });
        Object.defineProperty(HubConnection.prototype, "baseUrl", {
          get: function () {
            return this.connection.baseUrl || "";
          },
          set: function (url) {
            if (
              this.connectionState !== HubConnectionState.Disconnected &&
              this.connectionState !== HubConnectionState.Reconnecting
            ) {
              throw new Error(
                "The HubConnection must be in the Disconnected or Reconnecting state to change the url."
              );
            }
            if (!url) {
              throw new Error("The HubConnection url must be a valid url.");
            }
            this.connection.baseUrl = url;
          },
          enumerable: true,
          configurable: true,
        });
        HubConnection.prototype.start = function () {
          this.startPromise = this.startWithStateTransitions();
          return this.startPromise;
        };
        HubConnection.prototype.startWithStateTransitions = function () {
          return __awaiter(this, void 0, void 0, function () {
            var e_1;
            return __generator(this, function (_a) {
              switch (_a.label) {
                case 0:
                  if (
                    this.connectionState !== HubConnectionState.Disconnected
                  ) {
                    return [
                      2,
                      Promise.reject(
                        new Error(
                          "Cannot start a HubConnection that is not in the 'Disconnected' state."
                        )
                      ),
                    ];
                  }
                  this.connectionState = HubConnectionState.Connecting;
                  this.logger.log(
                    _ILogger__WEBPACK_IMPORTED_MODULE_2__["LogLevel"].Debug,
                    "Starting HubConnection."
                  );
                  _a.label = 1;
                case 1:
                  _a.trys.push([1, 3, , 4]);
                  return [4, this.startInternal()];
                case 2:
                  _a.sent();
                  this.connectionState = HubConnectionState.Connected;
                  this.connectionStarted = true;
                  this.logger.log(
                    _ILogger__WEBPACK_IMPORTED_MODULE_2__["LogLevel"].Debug,
                    "HubConnection connected successfully."
                  );
                  return [3, 4];
                case 3:
                  e_1 = _a.sent();
                  this.connectionState = HubConnectionState.Disconnected;
                  this.logger.log(
                    _ILogger__WEBPACK_IMPORTED_MODULE_2__["LogLevel"].Debug,
                    "HubConnection failed to start successfully because of error '" +
                      e_1 +
                      "'."
                  );
                  return [2, Promise.reject(e_1)];
                case 4:
                  return [2];
              }
            });
          });
        };
        HubConnection.prototype.startInternal = function () {
          return __awaiter(this, void 0, void 0, function () {
            var handshakePromise, handshakeRequest, e_2;
            var _this = this;
            return __generator(this, function (_a) {
              switch (_a.label) {
                case 0:
                  this.stopDuringStartError = undefined;
                  this.receivedHandshakeResponse = false;
                  handshakePromise = new Promise(function (resolve, reject) {
                    _this.handshakeResolver = resolve;
                    _this.handshakeRejecter = reject;
                  });
                  return [
                    4,
                    this.connection.start(this.protocol.transferFormat),
                  ];
                case 1:
                  _a.sent();
                  _a.label = 2;
                case 2:
                  _a.trys.push([2, 5, , 7]);
                  handshakeRequest = {
                    protocol: this.protocol.name,
                    version: this.protocol.version,
                  };
                  this.logger.log(
                    _ILogger__WEBPACK_IMPORTED_MODULE_2__["LogLevel"].Debug,
                    "Sending handshake request."
                  );
                  return [
                    4,
                    this.sendMessage(
                      this.handshakeProtocol.writeHandshakeRequest(
                        handshakeRequest
                      )
                    ),
                  ];
                case 3:
                  _a.sent();
                  this.logger.log(
                    _ILogger__WEBPACK_IMPORTED_MODULE_2__["LogLevel"]
                      .Information,
                    "Using HubProtocol '" + this.protocol.name + "'."
                  );
                  this.cleanupTimeout();
                  this.resetTimeoutPeriod();
                  this.resetKeepAliveInterval();
                  return [4, handshakePromise];
                case 4:
                  _a.sent();
                  if (this.stopDuringStartError) {
                    throw this.stopDuringStartError;
                  }
                  return [3, 7];
                case 5:
                  e_2 = _a.sent();
                  this.logger.log(
                    _ILogger__WEBPACK_IMPORTED_MODULE_2__["LogLevel"].Debug,
                    "Hub handshake failed with error '" +
                      e_2 +
                      "' during start(). Stopping HubConnection."
                  );
                  this.cleanupTimeout();
                  this.cleanupPingTimer();
                  return [4, this.connection.stop(e_2)];
                case 6:
                  _a.sent();
                  throw e_2;
                case 7:
                  return [2];
              }
            });
          });
        };
        HubConnection.prototype.stop = function () {
          return __awaiter(this, void 0, void 0, function () {
            var startPromise, e_3;
            return __generator(this, function (_a) {
              switch (_a.label) {
                case 0:
                  startPromise = this.startPromise;
                  this.stopPromise = this.stopInternal();
                  return [4, this.stopPromise];
                case 1:
                  _a.sent();
                  _a.label = 2;
                case 2:
                  _a.trys.push([2, 4, , 5]);
                  return [4, startPromise];
                case 3:
                  _a.sent();
                  return [3, 5];
                case 4:
                  e_3 = _a.sent();
                  return [3, 5];
                case 5:
                  return [2];
              }
            });
          });
        };
        HubConnection.prototype.stopInternal = function (error) {
          if (this.connectionState === HubConnectionState.Disconnected) {
            this.logger.log(
              _ILogger__WEBPACK_IMPORTED_MODULE_2__["LogLevel"].Debug,
              "Call to HubConnection.stop(" +
                error +
                ") ignored because it is already in the disconnected state."
            );
            return Promise.resolve();
          }
          if (this.connectionState === HubConnectionState.Disconnecting) {
            this.logger.log(
              _ILogger__WEBPACK_IMPORTED_MODULE_2__["LogLevel"].Debug,
              "Call to HttpConnection.stop(" +
                error +
                ") ignored because the connection is already in the disconnecting state."
            );
            return this.stopPromise;
          }
          this.connectionState = HubConnectionState.Disconnecting;
          this.logger.log(
            _ILogger__WEBPACK_IMPORTED_MODULE_2__["LogLevel"].Debug,
            "Stopping HubConnection."
          );
          if (this.reconnectDelayHandle) {
            this.logger.log(
              _ILogger__WEBPACK_IMPORTED_MODULE_2__["LogLevel"].Debug,
              "Connection stopped during reconnect delay. Done reconnecting."
            );
            clearTimeout(this.reconnectDelayHandle);
            this.reconnectDelayHandle = undefined;
            this.completeClose();
            return Promise.resolve();
          }
          this.cleanupTimeout();
          this.cleanupPingTimer();
          this.stopDuringStartError =
            error ||
            new Error(
              "The connection was stopped before the hub handshake could complete."
            );
          return this.connection.stop(error);
        };
        HubConnection.prototype.stream = function (methodName) {
          var _this = this;
          var args = [];
          for (var _i = 1; _i < arguments.length; _i++) {
            args[_i - 1] = arguments[_i];
          }
          var _a = this.replaceStreamingParams(args),
            streams = _a[0],
            streamIds = _a[1];
          var invocationDescriptor = this.createStreamInvocation(
            methodName,
            args,
            streamIds
          );
          var promiseQueue;
          var subject = new _Subject__WEBPACK_IMPORTED_MODULE_3__["Subject"]();
          subject.cancelCallback = function () {
            var cancelInvocation = _this.createCancelInvocation(
              invocationDescriptor.invocationId
            );
            delete _this.callbacks[invocationDescriptor.invocationId];
            return promiseQueue.then(function () {
              return _this.sendWithProtocol(cancelInvocation);
            });
          };
          this.callbacks[invocationDescriptor.invocationId] = function (
            invocationEvent,
            error
          ) {
            if (error) {
              subject.error(error);
              return;
            } else if (invocationEvent) {
              if (
                invocationEvent.type ===
                _IHubProtocol__WEBPACK_IMPORTED_MODULE_1__["MessageType"]
                  .Completion
              ) {
                if (invocationEvent.error) {
                  subject.error(new Error(invocationEvent.error));
                } else {
                  subject.complete();
                }
              } else {
                subject.next(invocationEvent.item);
              }
            }
          };
          promiseQueue = this.sendWithProtocol(invocationDescriptor).catch(
            function (e) {
              subject.error(e);
              delete _this.callbacks[invocationDescriptor.invocationId];
            }
          );
          this.launchStreams(streams, promiseQueue);
          return subject;
        };
        HubConnection.prototype.sendMessage = function (message) {
          this.resetKeepAliveInterval();
          return this.connection.send(message);
        };
        HubConnection.prototype.sendWithProtocol = function (message) {
          return this.sendMessage(this.protocol.writeMessage(message));
        };
        HubConnection.prototype.send = function (methodName) {
          var args = [];
          for (var _i = 1; _i < arguments.length; _i++) {
            args[_i - 1] = arguments[_i];
          }
          var _a = this.replaceStreamingParams(args),
            streams = _a[0],
            streamIds = _a[1];
          var sendPromise = this.sendWithProtocol(
            this.createInvocation(methodName, args, true, streamIds)
          );
          this.launchStreams(streams, sendPromise);
          return sendPromise;
        };
        HubConnection.prototype.invoke = function (methodName) {
          var _this = this;
          var args = [];
          for (var _i = 1; _i < arguments.length; _i++) {
            args[_i - 1] = arguments[_i];
          }
          var _a = this.replaceStreamingParams(args),
            streams = _a[0],
            streamIds = _a[1];
          var invocationDescriptor = this.createInvocation(
            methodName,
            args,
            false,
            streamIds
          );
          var p = new Promise(function (resolve, reject) {
            _this.callbacks[invocationDescriptor.invocationId] = function (
              invocationEvent,
              error
            ) {
              if (error) {
                reject(error);
                return;
              } else if (invocationEvent) {
                if (
                  invocationEvent.type ===
                  _IHubProtocol__WEBPACK_IMPORTED_MODULE_1__["MessageType"]
                    .Completion
                ) {
                  if (invocationEvent.error) {
                    reject(new Error(invocationEvent.error));
                  } else {
                    resolve(invocationEvent.result);
                  }
                } else {
                  reject(
                    new Error(
                      "Unexpected message type: " + invocationEvent.type
                    )
                  );
                }
              }
            };
            var promiseQueue = _this
              .sendWithProtocol(invocationDescriptor)
              .catch(function (e) {
                reject(e);
                delete _this.callbacks[invocationDescriptor.invocationId];
              });
            _this.launchStreams(streams, promiseQueue);
          });
          return p;
        };
        HubConnection.prototype.on = function (methodName, newMethod) {
          if (!methodName || !newMethod) {
            return;
          }
          methodName = methodName.toLowerCase();
          if (!this.methods[methodName]) {
            this.methods[methodName] = [];
          }
          if (this.methods[methodName].indexOf(newMethod) !== -1) {
            return;
          }
          this.methods[methodName].push(newMethod);
        };
        HubConnection.prototype.off = function (methodName, method) {
          if (!methodName) {
            return;
          }
          methodName = methodName.toLowerCase();
          var handlers = this.methods[methodName];
          if (!handlers) {
            return;
          }
          if (method) {
            var removeIdx = handlers.indexOf(method);
            if (removeIdx !== -1) {
              handlers.splice(removeIdx, 1);
              if (handlers.length === 0) {
                delete this.methods[methodName];
              }
            }
          } else {
            delete this.methods[methodName];
          }
        };
        HubConnection.prototype.onclose = function (callback) {
          if (callback) {
            this.closedCallbacks.push(callback);
          }
        };
        HubConnection.prototype.onreconnecting = function (callback) {
          if (callback) {
            this.reconnectingCallbacks.push(callback);
          }
        };
        HubConnection.prototype.onreconnected = function (callback) {
          if (callback) {
            this.reconnectedCallbacks.push(callback);
          }
        };
        HubConnection.prototype.processIncomingData = function (data) {
          this.cleanupTimeout();
          if (!this.receivedHandshakeResponse) {
            data = this.processHandshakeResponse(data);
            this.receivedHandshakeResponse = true;
          }
          if (data) {
            var messages = this.protocol.parseMessages(data, this.logger);
            for (
              var _i = 0, messages_1 = messages;
              _i < messages_1.length;
              _i++
            ) {
              var message = messages_1[_i];
              switch (message.type) {
                case _IHubProtocol__WEBPACK_IMPORTED_MODULE_1__["MessageType"]
                  .Invocation:
                  this.invokeClientMethod(message);
                  break;
                case _IHubProtocol__WEBPACK_IMPORTED_MODULE_1__["MessageType"]
                  .StreamItem:
                case _IHubProtocol__WEBPACK_IMPORTED_MODULE_1__["MessageType"]
                  .Completion:
                  var callback = this.callbacks[message.invocationId];
                  if (callback) {
                    if (
                      message.type ===
                      _IHubProtocol__WEBPACK_IMPORTED_MODULE_1__["MessageType"]
                        .Completion
                    ) {
                      delete this.callbacks[message.invocationId];
                    }
                    callback(message);
                  }
                  break;
                case _IHubProtocol__WEBPACK_IMPORTED_MODULE_1__["MessageType"]
                  .Ping:
                  break;
                case _IHubProtocol__WEBPACK_IMPORTED_MODULE_1__["MessageType"]
                  .Close:
                  this.logger.log(
                    _ILogger__WEBPACK_IMPORTED_MODULE_2__["LogLevel"]
                      .Information,
                    "Close message received from server."
                  );
                  var error = message.error
                    ? new Error(
                        "Server returned an error on close: " + message.error
                      )
                    : undefined;
                  if (message.allowReconnect === true) {
                    this.connection.stop(error);
                  } else {
                    this.stopPromise = this.stopInternal(error);
                  }
                  break;
                default:
                  this.logger.log(
                    _ILogger__WEBPACK_IMPORTED_MODULE_2__["LogLevel"].Warning,
                    "Invalid message type: " + message.type + "."
                  );
                  break;
              }
            }
          }
          this.resetTimeoutPeriod();
        };
        HubConnection.prototype.processHandshakeResponse = function (data) {
          var _a;
          var responseMessage;
          var remainingData;
          try {
            (_a = this.handshakeProtocol.parseHandshakeResponse(data)),
              (remainingData = _a[0]),
              (responseMessage = _a[1]);
          } catch (e) {
            var message = "Error parsing handshake response: " + e;
            this.logger.log(
              _ILogger__WEBPACK_IMPORTED_MODULE_2__["LogLevel"].Error,
              message
            );
            var error = new Error(message);
            this.handshakeRejecter(error);
            throw error;
          }
          if (responseMessage.error) {
            var message =
              "Server returned handshake error: " + responseMessage.error;
            this.logger.log(
              _ILogger__WEBPACK_IMPORTED_MODULE_2__["LogLevel"].Error,
              message
            );
            var error = new Error(message);
            this.handshakeRejecter(error);
            throw error;
          } else {
            this.logger.log(
              _ILogger__WEBPACK_IMPORTED_MODULE_2__["LogLevel"].Debug,
              "Server handshake complete."
            );
          }
          this.handshakeResolver();
          return remainingData;
        };
        HubConnection.prototype.resetKeepAliveInterval = function () {
          var _this = this;
          this.cleanupPingTimer();
          this.pingServerHandle = setTimeout(function () {
            return __awaiter(_this, void 0, void 0, function () {
              var _a;
              return __generator(this, function (_b) {
                switch (_b.label) {
                  case 0:
                    if (
                      !(this.connectionState === HubConnectionState.Connected)
                    )
                      return [3, 4];
                    _b.label = 1;
                  case 1:
                    _b.trys.push([1, 3, , 4]);
                    return [4, this.sendMessage(this.cachedPingMessage)];
                  case 2:
                    _b.sent();
                    return [3, 4];
                  case 3:
                    _a = _b.sent();
                    this.cleanupPingTimer();
                    return [3, 4];
                  case 4:
                    return [2];
                }
              });
            });
          }, this.keepAliveIntervalInMilliseconds);
        };
        HubConnection.prototype.resetTimeoutPeriod = function () {
          var _this = this;
          if (
            !this.connection.features ||
            !this.connection.features.inherentKeepAlive
          ) {
            this.timeoutHandle = setTimeout(function () {
              return _this.serverTimeout();
            }, this.serverTimeoutInMilliseconds);
          }
        };
        HubConnection.prototype.serverTimeout = function () {
          this.connection.stop(
            new Error(
              "Server timeout elapsed without receiving a message from the server."
            )
          );
        };
        HubConnection.prototype.invokeClientMethod = function (
          invocationMessage
        ) {
          var _this = this;
          var methods = this.methods[invocationMessage.target.toLowerCase()];
          if (methods) {
            try {
              methods.forEach(function (m) {
                return m.apply(_this, invocationMessage.arguments);
              });
            } catch (e) {
              this.logger.log(
                _ILogger__WEBPACK_IMPORTED_MODULE_2__["LogLevel"].Error,
                "A callback for the method " +
                  invocationMessage.target.toLowerCase() +
                  " threw error '" +
                  e +
                  "'."
              );
            }
            if (invocationMessage.invocationId) {
              var message =
                "Server requested a response, which is not supported in this version of the client.";
              this.logger.log(
                _ILogger__WEBPACK_IMPORTED_MODULE_2__["LogLevel"].Error,
                message
              );
              this.stopPromise = this.stopInternal(new Error(message));
            }
          } else {
            this.logger.log(
              _ILogger__WEBPACK_IMPORTED_MODULE_2__["LogLevel"].Warning,
              "No client method with the name '" +
                invocationMessage.target +
                "' found."
            );
          }
        };
        HubConnection.prototype.connectionClosed = function (error) {
          this.logger.log(
            _ILogger__WEBPACK_IMPORTED_MODULE_2__["LogLevel"].Debug,
            "HubConnection.connectionClosed(" +
              error +
              ") called while in state " +
              this.connectionState +
              "."
          );
          this.stopDuringStartError =
            this.stopDuringStartError ||
            error ||
            new Error(
              "The underlying connection was closed before the hub handshake could complete."
            );
          if (this.handshakeResolver) {
            this.handshakeResolver();
          }
          this.cancelCallbacksWithError(
            error ||
              new Error(
                "Invocation canceled due to the underlying connection being closed."
              )
          );
          this.cleanupTimeout();
          this.cleanupPingTimer();
          if (this.connectionState === HubConnectionState.Disconnecting) {
            this.completeClose(error);
          } else if (
            this.connectionState === HubConnectionState.Connected &&
            this.reconnectPolicy
          ) {
            this.reconnect(error);
          } else if (this.connectionState === HubConnectionState.Connected) {
            this.completeClose(error);
          }
        };
        HubConnection.prototype.completeClose = function (error) {
          var _this = this;
          if (this.connectionStarted) {
            this.connectionState = HubConnectionState.Disconnected;
            this.connectionStarted = false;
            try {
              this.closedCallbacks.forEach(function (c) {
                return c.apply(_this, [error]);
              });
            } catch (e) {
              this.logger.log(
                _ILogger__WEBPACK_IMPORTED_MODULE_2__["LogLevel"].Error,
                "An onclose callback called with error '" +
                  error +
                  "' threw error '" +
                  e +
                  "'."
              );
            }
          }
        };
        HubConnection.prototype.reconnect = function (error) {
          return __awaiter(this, void 0, void 0, function () {
            var reconnectStartTime,
              previousReconnectAttempts,
              retryError,
              nextRetryDelay,
              e_4;
            var _this = this;
            return __generator(this, function (_a) {
              switch (_a.label) {
                case 0:
                  reconnectStartTime = Date.now();
                  previousReconnectAttempts = 0;
                  retryError =
                    error !== undefined
                      ? error
                      : new Error(
                          "Attempting to reconnect due to a unknown error."
                        );
                  nextRetryDelay = this.getNextRetryDelay(
                    previousReconnectAttempts++,
                    0,
                    retryError
                  );
                  if (nextRetryDelay === null) {
                    this.logger.log(
                      _ILogger__WEBPACK_IMPORTED_MODULE_2__["LogLevel"].Debug,
                      "Connection not reconnecting because the IRetryPolicy returned null on the first reconnect attempt."
                    );
                    this.completeClose(error);
                    return [2];
                  }
                  this.connectionState = HubConnectionState.Reconnecting;
                  if (error) {
                    this.logger.log(
                      _ILogger__WEBPACK_IMPORTED_MODULE_2__["LogLevel"]
                        .Information,
                      "Connection reconnecting because of error '" +
                        error +
                        "'."
                    );
                  } else {
                    this.logger.log(
                      _ILogger__WEBPACK_IMPORTED_MODULE_2__["LogLevel"]
                        .Information,
                      "Connection reconnecting."
                    );
                  }
                  if (this.onreconnecting) {
                    try {
                      this.reconnectingCallbacks.forEach(function (c) {
                        return c.apply(_this, [error]);
                      });
                    } catch (e) {
                      this.logger.log(
                        _ILogger__WEBPACK_IMPORTED_MODULE_2__["LogLevel"].Error,
                        "An onreconnecting callback called with error '" +
                          error +
                          "' threw error '" +
                          e +
                          "'."
                      );
                    }
                    if (
                      this.connectionState !== HubConnectionState.Reconnecting
                    ) {
                      this.logger.log(
                        _ILogger__WEBPACK_IMPORTED_MODULE_2__["LogLevel"].Debug,
                        "Connection left the reconnecting state in onreconnecting callback. Done reconnecting."
                      );
                      return [2];
                    }
                  }
                  _a.label = 1;
                case 1:
                  if (!(nextRetryDelay !== null)) return [3, 7];
                  this.logger.log(
                    _ILogger__WEBPACK_IMPORTED_MODULE_2__["LogLevel"]
                      .Information,
                    "Reconnect attempt number " +
                      previousReconnectAttempts +
                      " will start in " +
                      nextRetryDelay +
                      " ms."
                  );
                  return [
                    4,
                    new Promise(function (resolve) {
                      _this.reconnectDelayHandle = setTimeout(
                        resolve,
                        nextRetryDelay
                      );
                    }),
                  ];
                case 2:
                  _a.sent();
                  this.reconnectDelayHandle = undefined;
                  if (
                    this.connectionState !== HubConnectionState.Reconnecting
                  ) {
                    this.logger.log(
                      _ILogger__WEBPACK_IMPORTED_MODULE_2__["LogLevel"].Debug,
                      "Connection left the reconnecting state during reconnect delay. Done reconnecting."
                    );
                    return [2];
                  }
                  _a.label = 3;
                case 3:
                  _a.trys.push([3, 5, , 6]);
                  return [4, this.startInternal()];
                case 4:
                  _a.sent();
                  this.connectionState = HubConnectionState.Connected;
                  this.logger.log(
                    _ILogger__WEBPACK_IMPORTED_MODULE_2__["LogLevel"]
                      .Information,
                    "HubConnection reconnected successfully."
                  );
                  if (this.onreconnected) {
                    try {
                      this.reconnectedCallbacks.forEach(function (c) {
                        return c.apply(_this, [_this.connection.connectionId]);
                      });
                    } catch (e) {
                      this.logger.log(
                        _ILogger__WEBPACK_IMPORTED_MODULE_2__["LogLevel"].Error,
                        "An onreconnected callback called with connectionId '" +
                          this.connection.connectionId +
                          "; threw error '" +
                          e +
                          "'."
                      );
                    }
                  }
                  return [2];
                case 5:
                  e_4 = _a.sent();
                  this.logger.log(
                    _ILogger__WEBPACK_IMPORTED_MODULE_2__["LogLevel"]
                      .Information,
                    "Reconnect attempt failed because of error '" + e_4 + "'."
                  );
                  if (
                    this.connectionState !== HubConnectionState.Reconnecting
                  ) {
                    this.logger.log(
                      _ILogger__WEBPACK_IMPORTED_MODULE_2__["LogLevel"].Debug,
                      "Connection left the reconnecting state during reconnect attempt. Done reconnecting."
                    );
                    return [2];
                  }
                  retryError =
                    e_4 instanceof Error ? e_4 : new Error(e_4.toString());
                  nextRetryDelay = this.getNextRetryDelay(
                    previousReconnectAttempts++,
                    Date.now() - reconnectStartTime,
                    retryError
                  );
                  return [3, 6];
                case 6:
                  return [3, 1];
                case 7:
                  this.logger.log(
                    _ILogger__WEBPACK_IMPORTED_MODULE_2__["LogLevel"]
                      .Information,
                    "Reconnect retries have been exhausted after " +
                      (Date.now() - reconnectStartTime) +
                      " ms and " +
                      previousReconnectAttempts +
                      " failed attempts. Connection disconnecting."
                  );
                  this.completeClose();
                  return [2];
              }
            });
          });
        };
        HubConnection.prototype.getNextRetryDelay = function (
          previousRetryCount,
          elapsedMilliseconds,
          retryReason
        ) {
          try {
            return this.reconnectPolicy.nextRetryDelayInMilliseconds({
              elapsedMilliseconds: elapsedMilliseconds,
              previousRetryCount: previousRetryCount,
              retryReason: retryReason,
            });
          } catch (e) {
            this.logger.log(
              _ILogger__WEBPACK_IMPORTED_MODULE_2__["LogLevel"].Error,
              "IRetryPolicy.nextRetryDelayInMilliseconds(" +
                previousRetryCount +
                ", " +
                elapsedMilliseconds +
                ") threw error '" +
                e +
                "'."
            );
            return null;
          }
        };
        HubConnection.prototype.cancelCallbacksWithError = function (error) {
          var callbacks = this.callbacks;
          this.callbacks = {};
          Object.keys(callbacks).forEach(function (key) {
            var callback = callbacks[key];
            callback(null, error);
          });
        };
        HubConnection.prototype.cleanupPingTimer = function () {
          if (this.pingServerHandle) {
            clearTimeout(this.pingServerHandle);
          }
        };
        HubConnection.prototype.cleanupTimeout = function () {
          if (this.timeoutHandle) {
            clearTimeout(this.timeoutHandle);
          }
        };
        HubConnection.prototype.createInvocation = function (
          methodName,
          args,
          nonblocking,
          streamIds
        ) {
          if (nonblocking) {
            return {
              arguments: args,
              streamIds: streamIds,
              target: methodName,
              type:
                _IHubProtocol__WEBPACK_IMPORTED_MODULE_1__["MessageType"]
                  .Invocation,
            };
          } else {
            var invocationId = this.invocationId;
            this.invocationId++;
            return {
              arguments: args,
              invocationId: invocationId.toString(),
              streamIds: streamIds,
              target: methodName,
              type:
                _IHubProtocol__WEBPACK_IMPORTED_MODULE_1__["MessageType"]
                  .Invocation,
            };
          }
        };
        HubConnection.prototype.launchStreams = function (
          streams,
          promiseQueue
        ) {
          var _this = this;
          if (streams.length === 0) {
            return;
          }
          if (!promiseQueue) {
            promiseQueue = Promise.resolve();
          }
          var _loop_1 = function (streamId) {
            streams[streamId].subscribe({
              complete: function () {
                promiseQueue = promiseQueue.then(function () {
                  return _this.sendWithProtocol(
                    _this.createCompletionMessage(streamId)
                  );
                });
              },
              error: function (err) {
                var message;
                if (err instanceof Error) {
                  message = err.message;
                } else if (err && err.toString) {
                  message = err.toString();
                } else {
                  message = "Unknown error";
                }
                promiseQueue = promiseQueue.then(function () {
                  return _this.sendWithProtocol(
                    _this.createCompletionMessage(streamId, message)
                  );
                });
              },
              next: function (item) {
                promiseQueue = promiseQueue.then(function () {
                  return _this.sendWithProtocol(
                    _this.createStreamItemMessage(streamId, item)
                  );
                });
              },
            });
          };
          for (var streamId in streams) {
            _loop_1(streamId);
          }
        };
        HubConnection.prototype.replaceStreamingParams = function (args) {
          var streams = [];
          var streamIds = [];
          for (var i = 0; i < args.length; i++) {
            var argument = args[i];
            if (this.isObservable(argument)) {
              var streamId = this.invocationId;
              this.invocationId++;
              streams[streamId] = argument;
              streamIds.push(streamId.toString());
              args.splice(i, 1);
            }
          }
          return [streams, streamIds];
        };
        HubConnection.prototype.isObservable = function (arg) {
          return arg && arg.subscribe && typeof arg.subscribe === "function";
        };
        HubConnection.prototype.createStreamInvocation = function (
          methodName,
          args,
          streamIds
        ) {
          var invocationId = this.invocationId;
          this.invocationId++;
          return {
            arguments: args,
            invocationId: invocationId.toString(),
            streamIds: streamIds,
            target: methodName,
            type:
              _IHubProtocol__WEBPACK_IMPORTED_MODULE_1__["MessageType"]
                .StreamInvocation,
          };
        };
        HubConnection.prototype.createCancelInvocation = function (id) {
          return {
            invocationId: id,
            type:
              _IHubProtocol__WEBPACK_IMPORTED_MODULE_1__["MessageType"]
                .CancelInvocation,
          };
        };
        HubConnection.prototype.createStreamItemMessage = function (id, item) {
          return {
            invocationId: id,
            item: item,
            type:
              _IHubProtocol__WEBPACK_IMPORTED_MODULE_1__["MessageType"]
                .StreamItem,
          };
        };
        HubConnection.prototype.createCompletionMessage = function (
          id,
          error,
          result
        ) {
          if (error) {
            return {
              error: error,
              invocationId: id,
              type:
                _IHubProtocol__WEBPACK_IMPORTED_MODULE_1__["MessageType"]
                  .Completion,
            };
          }
          return {
            invocationId: id,
            result: result,
            type:
              _IHubProtocol__WEBPACK_IMPORTED_MODULE_1__["MessageType"]
                .Completion,
          };
        };
        return HubConnection;
      })();
    },
    function (module, __webpack_exports__, __webpack_require__) {
      "use strict";
      __webpack_require__.r(__webpack_exports__);
      __webpack_require__.d(
        __webpack_exports__,
        "HandshakeProtocol",
        function () {
          return HandshakeProtocol;
        }
      );
      var _TextMessageFormat__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(
        12
      );
      var _Utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(13);
      var HandshakeProtocol = (function () {
        function HandshakeProtocol() {}
        HandshakeProtocol.prototype.writeHandshakeRequest = function (
          handshakeRequest
        ) {
          return _TextMessageFormat__WEBPACK_IMPORTED_MODULE_0__[
            "TextMessageFormat"
          ].write(JSON.stringify(handshakeRequest));
        };
        HandshakeProtocol.prototype.parseHandshakeResponse = function (data) {
          var responseMessage;
          var messageData;
          var remainingData;
          if (
            Object(_Utils__WEBPACK_IMPORTED_MODULE_1__["isArrayBuffer"])(
              data
            ) ||
            (typeof Buffer !== "undefined" && data instanceof Buffer)
          ) {
            var binaryData = new Uint8Array(data);
            var separatorIndex = binaryData.indexOf(
              _TextMessageFormat__WEBPACK_IMPORTED_MODULE_0__[
                "TextMessageFormat"
              ].RecordSeparatorCode
            );
            if (separatorIndex === -1) {
              throw new Error("Message is incomplete.");
            }
            var responseLength = separatorIndex + 1;
            messageData = String.fromCharCode.apply(
              null,
              binaryData.slice(0, responseLength)
            );
            remainingData =
              binaryData.byteLength > responseLength
                ? binaryData.slice(responseLength).buffer
                : null;
          } else {
            var textData = data;
            var separatorIndex = textData.indexOf(
              _TextMessageFormat__WEBPACK_IMPORTED_MODULE_0__[
                "TextMessageFormat"
              ].RecordSeparator
            );
            if (separatorIndex === -1) {
              throw new Error("Message is incomplete.");
            }
            var responseLength = separatorIndex + 1;
            messageData = textData.substring(0, responseLength);
            remainingData =
              textData.length > responseLength
                ? textData.substring(responseLength)
                : null;
          }
          var messages = _TextMessageFormat__WEBPACK_IMPORTED_MODULE_0__[
            "TextMessageFormat"
          ].parse(messageData);
          var response = JSON.parse(messages[0]);
          if (response.type) {
            throw new Error("Expected a handshake response from the server.");
          }
          responseMessage = response;
          return [remainingData, responseMessage];
        };
        return HandshakeProtocol;
      })();
    },
    function (module, __webpack_exports__, __webpack_require__) {
      "use strict";
      __webpack_require__.r(__webpack_exports__);
      __webpack_require__.d(
        __webpack_exports__,
        "TextMessageFormat",
        function () {
          return TextMessageFormat;
        }
      );
      var TextMessageFormat = (function () {
        function TextMessageFormat() {}
        TextMessageFormat.write = function (output) {
          return "" + output + TextMessageFormat.RecordSeparator;
        };
        TextMessageFormat.parse = function (input) {
          if (input[input.length - 1] !== TextMessageFormat.RecordSeparator) {
            throw new Error("Message is incomplete.");
          }
          var messages = input.split(TextMessageFormat.RecordSeparator);
          messages.pop();
          return messages;
        };
        TextMessageFormat.RecordSeparatorCode = 30;
        TextMessageFormat.RecordSeparator = String.fromCharCode(
          TextMessageFormat.RecordSeparatorCode
        );
        return TextMessageFormat;
      })();
    },
    function (module, __webpack_exports__, __webpack_require__) {
      "use strict";
      __webpack_require__.r(__webpack_exports__);
      __webpack_require__.d(__webpack_exports__, "Arg", function () {
        return Arg;
      });
      __webpack_require__.d(__webpack_exports__, "Platform", function () {
        return Platform;
      });
      __webpack_require__.d(__webpack_exports__, "getDataDetail", function () {
        return getDataDetail;
      });
      __webpack_require__.d(
        __webpack_exports__,
        "formatArrayBuffer",
        function () {
          return formatArrayBuffer;
        }
      );
      __webpack_require__.d(__webpack_exports__, "isArrayBuffer", function () {
        return isArrayBuffer;
      });
      __webpack_require__.d(__webpack_exports__, "sendMessage", function () {
        return sendMessage;
      });
      __webpack_require__.d(__webpack_exports__, "createLogger", function () {
        return createLogger;
      });
      __webpack_require__.d(
        __webpack_exports__,
        "SubjectSubscription",
        function () {
          return SubjectSubscription;
        }
      );
      __webpack_require__.d(__webpack_exports__, "ConsoleLogger", function () {
        return ConsoleLogger;
      });
      var _ILogger__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(9);
      var _Loggers__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(14);
      var __awaiter =
        (undefined && undefined.__awaiter) ||
        function (thisArg, _arguments, P, generator) {
          return new (P || (P = Promise))(function (resolve, reject) {
            function fulfilled(value) {
              try {
                step(generator.next(value));
              } catch (e) {
                reject(e);
              }
            }
            function rejected(value) {
              try {
                step(generator["throw"](value));
              } catch (e) {
                reject(e);
              }
            }
            function step(result) {
              result.done
                ? resolve(result.value)
                : new P(function (resolve) {
                    resolve(result.value);
                  }).then(fulfilled, rejected);
            }
            step(
              (generator = generator.apply(thisArg, _arguments || [])).next()
            );
          });
        };
      var __generator =
        (undefined && undefined.__generator) ||
        function (thisArg, body) {
          var _ = {
              label: 0,
              sent: function () {
                if (t[0] & 1) throw t[1];
                return t[1];
              },
              trys: [],
              ops: [],
            },
            f,
            y,
            t,
            g;
          return (
            (g = { next: verb(0), throw: verb(1), return: verb(2) }),
            typeof Symbol === "function" &&
              (g[Symbol.iterator] = function () {
                return this;
              }),
            g
          );
          function verb(n) {
            return function (v) {
              return step([n, v]);
            };
          }
          function step(op) {
            if (f) throw new TypeError("Generator is already executing.");
            while (_)
              try {
                if (
                  ((f = 1),
                  y &&
                    (t =
                      op[0] & 2
                        ? y["return"]
                        : op[0]
                        ? y["throw"] || ((t = y["return"]) && t.call(y), 0)
                        : y.next) &&
                    !(t = t.call(y, op[1])).done)
                )
                  return t;
                if (((y = 0), t)) op = [op[0] & 2, t.value];
                switch (op[0]) {
                  case 0:
                  case 1:
                    t = op;
                    break;
                  case 4:
                    _.label++;
                    return { value: op[1], done: false };
                  case 5:
                    _.label++;
                    y = op[1];
                    op = [0];
                    continue;
                  case 7:
                    op = _.ops.pop();
                    _.trys.pop();
                    continue;
                  default:
                    if (
                      !((t = _.trys), (t = t.length > 0 && t[t.length - 1])) &&
                      (op[0] === 6 || op[0] === 2)
                    ) {
                      _ = 0;
                      continue;
                    }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) {
                      _.label = op[1];
                      break;
                    }
                    if (op[0] === 6 && _.label < t[1]) {
                      _.label = t[1];
                      t = op;
                      break;
                    }
                    if (t && _.label < t[2]) {
                      _.label = t[2];
                      _.ops.push(op);
                      break;
                    }
                    if (t[2]) _.ops.pop();
                    _.trys.pop();
                    continue;
                }
                op = body.call(thisArg, _);
              } catch (e) {
                op = [6, e];
                y = 0;
              } finally {
                f = t = 0;
              }
            if (op[0] & 5) throw op[1];
            return { value: op[0] ? op[1] : void 0, done: true };
          }
        };
      var Arg = (function () {
        function Arg() {}
        Arg.isRequired = function (val, name) {
          if (val === null || val === undefined) {
            throw new Error("The '" + name + "' argument is required.");
          }
        };
        Arg.isIn = function (val, values, name) {
          if (!(val in values)) {
            throw new Error("Unknown " + name + " value: " + val + ".");
          }
        };
        return Arg;
      })();
      var Platform = (function () {
        function Platform() {}
        Object.defineProperty(Platform, "isBrowser", {
          get: function () {
            return typeof window === "object";
          },
          enumerable: true,
          configurable: true,
        });
        Object.defineProperty(Platform, "isWebWorker", {
          get: function () {
            return typeof self === "object" && "importScripts" in self;
          },
          enumerable: true,
          configurable: true,
        });
        Object.defineProperty(Platform, "isNode", {
          get: function () {
            return !this.isBrowser && !this.isWebWorker;
          },
          enumerable: true,
          configurable: true,
        });
        return Platform;
      })();
      function getDataDetail(data, includeContent) {
        var detail = "";
        if (isArrayBuffer(data)) {
          detail = "Binary data of length " + data.byteLength;
          if (includeContent) {
            detail += ". Content: '" + formatArrayBuffer(data) + "'";
          }
        } else if (typeof data === "string") {
          detail = "String data of length " + data.length;
          if (includeContent) {
            detail += ". Content: '" + data + "'";
          }
        }
        return detail;
      }
      function formatArrayBuffer(data) {
        var view = new Uint8Array(data);
        var str = "";
        view.forEach(function (num) {
          var pad = num < 16 ? "0" : "";
          str += "0x" + pad + num.toString(16) + " ";
        });
        return str.substr(0, str.length - 1);
      }
      function isArrayBuffer(val) {
        return (
          val &&
          typeof ArrayBuffer !== "undefined" &&
          (val instanceof ArrayBuffer ||
            (val.constructor && val.constructor.name === "ArrayBuffer"))
        );
      }
      function sendMessage(
        logger,
        transportName,
        httpClient,
        url,
        accessTokenFactory,
        content,
        logMessageContent
      ) {
        return __awaiter(this, void 0, void 0, function () {
          var _a, headers, token, responseType, response;
          return __generator(this, function (_b) {
            switch (_b.label) {
              case 0:
                if (!accessTokenFactory) return [3, 2];
                return [4, accessTokenFactory()];
              case 1:
                token = _b.sent();
                if (token) {
                  headers =
                    ((_a = {}), (_a["Authorization"] = "Bearer " + token), _a);
                }
                _b.label = 2;
              case 2:
                logger.log(
                  _ILogger__WEBPACK_IMPORTED_MODULE_0__["LogLevel"].Trace,
                  "(" +
                    transportName +
                    " transport) sending data. " +
                    getDataDetail(content, logMessageContent) +
                    "."
                );
                responseType = isArrayBuffer(content) ? "arraybuffer" : "text";
                return [
                  4,
                  httpClient.post(url, {
                    content: content,
                    headers: headers,
                    responseType: responseType,
                  }),
                ];
              case 3:
                response = _b.sent();
                logger.log(
                  _ILogger__WEBPACK_IMPORTED_MODULE_0__["LogLevel"].Trace,
                  "(" +
                    transportName +
                    " transport) request complete. Response status: " +
                    response.statusCode +
                    "."
                );
                return [2];
            }
          });
        });
      }
      function createLogger(logger) {
        if (logger === undefined) {
          return new ConsoleLogger(
            _ILogger__WEBPACK_IMPORTED_MODULE_0__["LogLevel"].Information
          );
        }
        if (logger === null) {
          return _Loggers__WEBPACK_IMPORTED_MODULE_1__["NullLogger"].instance;
        }
        if (logger.log) {
          return logger;
        }
        return new ConsoleLogger(logger);
      }
      var SubjectSubscription = (function () {
        function SubjectSubscription(subject, observer) {
          this.subject = subject;
          this.observer = observer;
        }
        SubjectSubscription.prototype.dispose = function () {
          var index = this.subject.observers.indexOf(this.observer);
          if (index > -1) {
            this.subject.observers.splice(index, 1);
          }
          if (
            this.subject.observers.length === 0 &&
            this.subject.cancelCallback
          ) {
            this.subject.cancelCallback().catch(function (_) {});
          }
        };
        return SubjectSubscription;
      })();
      var ConsoleLogger = (function () {
        function ConsoleLogger(minimumLogLevel) {
          this.minimumLogLevel = minimumLogLevel;
          this.outputConsole = console;
        }
        ConsoleLogger.prototype.log = function (logLevel, message) {
          if (logLevel >= this.minimumLogLevel) {
            switch (logLevel) {
              case _ILogger__WEBPACK_IMPORTED_MODULE_0__["LogLevel"].Critical:
              case _ILogger__WEBPACK_IMPORTED_MODULE_0__["LogLevel"].Error:
                this.outputConsole.error(
                  "[" +
                    new Date().toISOString() +
                    "] " +
                    _ILogger__WEBPACK_IMPORTED_MODULE_0__["LogLevel"][
                      logLevel
                    ] +
                    ": " +
                    message
                );
                break;
              case _ILogger__WEBPACK_IMPORTED_MODULE_0__["LogLevel"].Warning:
                this.outputConsole.warn(
                  "[" +
                    new Date().toISOString() +
                    "] " +
                    _ILogger__WEBPACK_IMPORTED_MODULE_0__["LogLevel"][
                      logLevel
                    ] +
                    ": " +
                    message
                );
                break;
              case _ILogger__WEBPACK_IMPORTED_MODULE_0__["LogLevel"]
                .Information:
                this.outputConsole.info(
                  "[" +
                    new Date().toISOString() +
                    "] " +
                    _ILogger__WEBPACK_IMPORTED_MODULE_0__["LogLevel"][
                      logLevel
                    ] +
                    ": " +
                    message
                );
                break;
              default:
                this.outputConsole.log(
                  "[" +
                    new Date().toISOString() +
                    "] " +
                    _ILogger__WEBPACK_IMPORTED_MODULE_0__["LogLevel"][
                      logLevel
                    ] +
                    ": " +
                    message
                );
                break;
            }
          }
        };
        return ConsoleLogger;
      })();
    },
    function (module, __webpack_exports__, __webpack_require__) {
      "use strict";
      __webpack_require__.r(__webpack_exports__);
      __webpack_require__.d(__webpack_exports__, "NullLogger", function () {
        return NullLogger;
      });
      var NullLogger = (function () {
        function NullLogger() {}
        NullLogger.prototype.log = function (_logLevel, _message) {};
        NullLogger.instance = new NullLogger();
        return NullLogger;
      })();
    },
    function (module, __webpack_exports__, __webpack_require__) {
      "use strict";
      __webpack_require__.r(__webpack_exports__);
      __webpack_require__.d(__webpack_exports__, "MessageType", function () {
        return MessageType;
      });
      var MessageType;
      (function (MessageType) {
        MessageType[(MessageType["Invocation"] = 1)] = "Invocation";
        MessageType[(MessageType["StreamItem"] = 2)] = "StreamItem";
        MessageType[(MessageType["Completion"] = 3)] = "Completion";
        MessageType[(MessageType["StreamInvocation"] = 4)] = "StreamInvocation";
        MessageType[(MessageType["CancelInvocation"] = 5)] = "CancelInvocation";
        MessageType[(MessageType["Ping"] = 6)] = "Ping";
        MessageType[(MessageType["Close"] = 7)] = "Close";
      })(MessageType || (MessageType = {}));
    },
    function (module, __webpack_exports__, __webpack_require__) {
      "use strict";
      __webpack_require__.r(__webpack_exports__);
      __webpack_require__.d(__webpack_exports__, "Subject", function () {
        return Subject;
      });
      var _Utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(13);
      var Subject = (function () {
        function Subject() {
          this.observers = [];
        }
        Subject.prototype.next = function (item) {
          for (var _i = 0, _a = this.observers; _i < _a.length; _i++) {
            var observer = _a[_i];
            observer.next(item);
          }
        };
        Subject.prototype.error = function (err) {
          for (var _i = 0, _a = this.observers; _i < _a.length; _i++) {
            var observer = _a[_i];
            if (observer.error) {
              observer.error(err);
            }
          }
        };
        Subject.prototype.complete = function () {
          for (var _i = 0, _a = this.observers; _i < _a.length; _i++) {
            var observer = _a[_i];
            if (observer.complete) {
              observer.complete();
            }
          }
        };
        Subject.prototype.subscribe = function (observer) {
          this.observers.push(observer);
          return new _Utils__WEBPACK_IMPORTED_MODULE_0__["SubjectSubscription"](
            this,
            observer
          );
        };
        return Subject;
      })();
    },
    function (module, __webpack_exports__, __webpack_require__) {
      "use strict";
      __webpack_require__.r(__webpack_exports__);
      __webpack_require__.d(
        __webpack_exports__,
        "HubConnectionBuilder",
        function () {
          return HubConnectionBuilder;
        }
      );
      var _DefaultReconnectPolicy__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(
        18
      );
      var _HttpConnection__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(
        19
      );
      var _HubConnection__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(10);
      var _ILogger__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(9);
      var _JsonHubProtocol__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(
        25
      );
      var _Loggers__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(14);
      var _Utils__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(13);
      var __assign =
        (undefined && undefined.__assign) ||
        Object.assign ||
        function (t) {
          for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s)
              if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];
          }
          return t;
        };
      var LogLevelNameMapping = {
        trace: _ILogger__WEBPACK_IMPORTED_MODULE_3__["LogLevel"].Trace,
        debug: _ILogger__WEBPACK_IMPORTED_MODULE_3__["LogLevel"].Debug,
        info: _ILogger__WEBPACK_IMPORTED_MODULE_3__["LogLevel"].Information,
        information:
          _ILogger__WEBPACK_IMPORTED_MODULE_3__["LogLevel"].Information,
        warn: _ILogger__WEBPACK_IMPORTED_MODULE_3__["LogLevel"].Warning,
        warning: _ILogger__WEBPACK_IMPORTED_MODULE_3__["LogLevel"].Warning,
        error: _ILogger__WEBPACK_IMPORTED_MODULE_3__["LogLevel"].Error,
        critical: _ILogger__WEBPACK_IMPORTED_MODULE_3__["LogLevel"].Critical,
        none: _ILogger__WEBPACK_IMPORTED_MODULE_3__["LogLevel"].None,
      };
      function parseLogLevel(name) {
        var mapping = LogLevelNameMapping[name.toLowerCase()];
        if (typeof mapping !== "undefined") {
          return mapping;
        } else {
          throw new Error("Unknown log level: " + name);
        }
      }
      var HubConnectionBuilder = (function () {
        function HubConnectionBuilder() {}
        HubConnectionBuilder.prototype.configureLogging = function (logging) {
          _Utils__WEBPACK_IMPORTED_MODULE_6__["Arg"].isRequired(
            logging,
            "logging"
          );
          if (isLogger(logging)) {
            this.logger = logging;
          } else if (typeof logging === "string") {
            var logLevel = parseLogLevel(logging);
            this.logger = new _Utils__WEBPACK_IMPORTED_MODULE_6__[
              "ConsoleLogger"
            ](logLevel);
          } else {
            this.logger = new _Utils__WEBPACK_IMPORTED_MODULE_6__[
              "ConsoleLogger"
            ](logging);
          }
          return this;
        };
        HubConnectionBuilder.prototype.withUrl = function (
          url,
          transportTypeOrOptions
        ) {
          _Utils__WEBPACK_IMPORTED_MODULE_6__["Arg"].isRequired(url, "url");
          this.url = url;
          if (typeof transportTypeOrOptions === "object") {
            this.httpConnectionOptions = __assign(
              {},
              this.httpConnectionOptions,
              transportTypeOrOptions
            );
          } else {
            this.httpConnectionOptions = __assign(
              {},
              this.httpConnectionOptions,
              { transport: transportTypeOrOptions }
            );
          }
          return this;
        };
        HubConnectionBuilder.prototype.withHubProtocol = function (protocol) {
          _Utils__WEBPACK_IMPORTED_MODULE_6__["Arg"].isRequired(
            protocol,
            "protocol"
          );
          this.protocol = protocol;
          return this;
        };
        HubConnectionBuilder.prototype.withAutomaticReconnect = function (
          retryDelaysOrReconnectPolicy
        ) {
          if (this.reconnectPolicy) {
            throw new Error("A reconnectPolicy has already been set.");
          }
          if (!retryDelaysOrReconnectPolicy) {
            this.reconnectPolicy = new _DefaultReconnectPolicy__WEBPACK_IMPORTED_MODULE_0__[
              "DefaultReconnectPolicy"
            ]();
          } else if (Array.isArray(retryDelaysOrReconnectPolicy)) {
            this.reconnectPolicy = new _DefaultReconnectPolicy__WEBPACK_IMPORTED_MODULE_0__[
              "DefaultReconnectPolicy"
            ](retryDelaysOrReconnectPolicy);
          } else {
            this.reconnectPolicy = retryDelaysOrReconnectPolicy;
          }
          return this;
        };
        HubConnectionBuilder.prototype.build = function () {
          var httpConnectionOptions = this.httpConnectionOptions || {};
          if (httpConnectionOptions.logger === undefined) {
            httpConnectionOptions.logger = this.logger;
          }
          if (!this.url) {
            throw new Error(
              "The 'HubConnectionBuilder.withUrl' method must be called before building the connection."
            );
          }
          var connection = new _HttpConnection__WEBPACK_IMPORTED_MODULE_1__[
            "HttpConnection"
          ](this.url, httpConnectionOptions);
          return _HubConnection__WEBPACK_IMPORTED_MODULE_2__[
            "HubConnection"
          ].create(
            connection,
            this.logger ||
              _Loggers__WEBPACK_IMPORTED_MODULE_5__["NullLogger"].instance,
            this.protocol ||
              new _JsonHubProtocol__WEBPACK_IMPORTED_MODULE_4__[
                "JsonHubProtocol"
              ](),
            this.reconnectPolicy
          );
        };
        return HubConnectionBuilder;
      })();
      function isLogger(logger) {
        return logger.log !== undefined;
      }
    },
    function (module, __webpack_exports__, __webpack_require__) {
      "use strict";
      __webpack_require__.r(__webpack_exports__);
      __webpack_require__.d(
        __webpack_exports__,
        "DefaultReconnectPolicy",
        function () {
          return DefaultReconnectPolicy;
        }
      );
      var DEFAULT_RETRY_DELAYS_IN_MILLISECONDS = [0, 2e3, 1e4, 3e4, null];
      var DefaultReconnectPolicy = (function () {
        function DefaultReconnectPolicy(retryDelays) {
          this.retryDelays =
            retryDelays !== undefined
              ? retryDelays.concat([null])
              : DEFAULT_RETRY_DELAYS_IN_MILLISECONDS;
        }
        DefaultReconnectPolicy.prototype.nextRetryDelayInMilliseconds = function (
          retryContext
        ) {
          return this.retryDelays[retryContext.previousRetryCount];
        };
        return DefaultReconnectPolicy;
      })();
    },
    function (module, __webpack_exports__, __webpack_require__) {
      "use strict";
      __webpack_require__.r(__webpack_exports__);
      __webpack_require__.d(__webpack_exports__, "HttpConnection", function () {
        return HttpConnection;
      });
      __webpack_require__.d(
        __webpack_exports__,
        "TransportSendQueue",
        function () {
          return TransportSendQueue;
        }
      );
      var _DefaultHttpClient__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(
        6
      );
      var _ILogger__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(9);
      var _ITransport__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(20);
      var _LongPollingTransport__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(
        21
      );
      var _ServerSentEventsTransport__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(
        23
      );
      var _Utils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(13);
      var _WebSocketTransport__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(
        24
      );
      var __awaiter =
        (undefined && undefined.__awaiter) ||
        function (thisArg, _arguments, P, generator) {
          return new (P || (P = Promise))(function (resolve, reject) {
            function fulfilled(value) {
              try {
                step(generator.next(value));
              } catch (e) {
                reject(e);
              }
            }
            function rejected(value) {
              try {
                step(generator["throw"](value));
              } catch (e) {
                reject(e);
              }
            }
            function step(result) {
              result.done
                ? resolve(result.value)
                : new P(function (resolve) {
                    resolve(result.value);
                  }).then(fulfilled, rejected);
            }
            step(
              (generator = generator.apply(thisArg, _arguments || [])).next()
            );
          });
        };
      var __generator =
        (undefined && undefined.__generator) ||
        function (thisArg, body) {
          var _ = {
              label: 0,
              sent: function () {
                if (t[0] & 1) throw t[1];
                return t[1];
              },
              trys: [],
              ops: [],
            },
            f,
            y,
            t,
            g;
          return (
            (g = { next: verb(0), throw: verb(1), return: verb(2) }),
            typeof Symbol === "function" &&
              (g[Symbol.iterator] = function () {
                return this;
              }),
            g
          );
          function verb(n) {
            return function (v) {
              return step([n, v]);
            };
          }
          function step(op) {
            if (f) throw new TypeError("Generator is already executing.");
            while (_)
              try {
                if (
                  ((f = 1),
                  y &&
                    (t =
                      op[0] & 2
                        ? y["return"]
                        : op[0]
                        ? y["throw"] || ((t = y["return"]) && t.call(y), 0)
                        : y.next) &&
                    !(t = t.call(y, op[1])).done)
                )
                  return t;
                if (((y = 0), t)) op = [op[0] & 2, t.value];
                switch (op[0]) {
                  case 0:
                  case 1:
                    t = op;
                    break;
                  case 4:
                    _.label++;
                    return { value: op[1], done: false };
                  case 5:
                    _.label++;
                    y = op[1];
                    op = [0];
                    continue;
                  case 7:
                    op = _.ops.pop();
                    _.trys.pop();
                    continue;
                  default:
                    if (
                      !((t = _.trys), (t = t.length > 0 && t[t.length - 1])) &&
                      (op[0] === 6 || op[0] === 2)
                    ) {
                      _ = 0;
                      continue;
                    }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) {
                      _.label = op[1];
                      break;
                    }
                    if (op[0] === 6 && _.label < t[1]) {
                      _.label = t[1];
                      t = op;
                      break;
                    }
                    if (t && _.label < t[2]) {
                      _.label = t[2];
                      _.ops.push(op);
                      break;
                    }
                    if (t[2]) _.ops.pop();
                    _.trys.pop();
                    continue;
                }
                op = body.call(thisArg, _);
              } catch (e) {
                op = [6, e];
                y = 0;
              } finally {
                f = t = 0;
              }
            if (op[0] & 5) throw op[1];
            return { value: op[0] ? op[1] : void 0, done: true };
          }
        };
      var MAX_REDIRECTS = 100;
      var WebSocketModule = null;
      var EventSourceModule = null;
      if (
        _Utils__WEBPACK_IMPORTED_MODULE_5__["Platform"].isNode &&
        "function" !== "undefined"
      ) {
        var requireFunc = true ? require : undefined;
        WebSocketModule = requireFunc("ws");
        EventSourceModule = requireFunc("eventsource");
      }
      var HttpConnection = (function () {
        function HttpConnection(url, options) {
          if (options === void 0) {
            options = {};
          }
          this.features = {};
          this.negotiateVersion = 1;
          _Utils__WEBPACK_IMPORTED_MODULE_5__["Arg"].isRequired(url, "url");
          this.logger = Object(
            _Utils__WEBPACK_IMPORTED_MODULE_5__["createLogger"]
          )(options.logger);
          this.baseUrl = this.resolveUrl(url);
          options = options || {};
          options.logMessageContent = options.logMessageContent || false;
          if (
            !_Utils__WEBPACK_IMPORTED_MODULE_5__["Platform"].isNode &&
            typeof WebSocket !== "undefined" &&
            !options.WebSocket
          ) {
            options.WebSocket = WebSocket;
          } else if (
            _Utils__WEBPACK_IMPORTED_MODULE_5__["Platform"].isNode &&
            !options.WebSocket
          ) {
            if (WebSocketModule) {
              options.WebSocket = WebSocketModule;
            }
          }
          if (
            !_Utils__WEBPACK_IMPORTED_MODULE_5__["Platform"].isNode &&
            typeof EventSource !== "undefined" &&
            !options.EventSource
          ) {
            options.EventSource = EventSource;
          } else if (
            _Utils__WEBPACK_IMPORTED_MODULE_5__["Platform"].isNode &&
            !options.EventSource
          ) {
            if (typeof EventSourceModule !== "undefined") {
              options.EventSource = EventSourceModule;
            }
          }
          this.httpClient =
            options.httpClient ||
            new _DefaultHttpClient__WEBPACK_IMPORTED_MODULE_0__[
              "DefaultHttpClient"
            ](this.logger);
          this.connectionState = "Disconnected";
          this.connectionStarted = false;
          this.options = options;
          this.onreceive = null;
          this.onclose = null;
        }
        HttpConnection.prototype.start = function (transferFormat) {
          return __awaiter(this, void 0, void 0, function () {
            var message, message;
            return __generator(this, function (_a) {
              switch (_a.label) {
                case 0:
                  transferFormat =
                    transferFormat ||
                    _ITransport__WEBPACK_IMPORTED_MODULE_2__["TransferFormat"]
                      .Binary;
                  _Utils__WEBPACK_IMPORTED_MODULE_5__["Arg"].isIn(
                    transferFormat,
                    _ITransport__WEBPACK_IMPORTED_MODULE_2__["TransferFormat"],
                    "transferFormat"
                  );
                  this.logger.log(
                    _ILogger__WEBPACK_IMPORTED_MODULE_1__["LogLevel"].Debug,
                    "Starting connection with transfer format '" +
                      _ITransport__WEBPACK_IMPORTED_MODULE_2__[
                        "TransferFormat"
                      ][transferFormat] +
                      "'."
                  );
                  if (this.connectionState !== "Disconnected") {
                    return [
                      2,
                      Promise.reject(
                        new Error(
                          "Cannot start an HttpConnection that is not in the 'Disconnected' state."
                        )
                      ),
                    ];
                  }
                  this.connectionState = "Connecting ";
                  this.startInternalPromise = this.startInternal(
                    transferFormat
                  );
                  return [4, this.startInternalPromise];
                case 1:
                  _a.sent();
                  if (!(this.connectionState === "Disconnecting"))
                    return [3, 3];
                  message =
                    "Failed to start the HttpConnection before stop() was called.";
                  this.logger.log(
                    _ILogger__WEBPACK_IMPORTED_MODULE_1__["LogLevel"].Error,
                    message
                  );
                  return [4, this.stopPromise];
                case 2:
                  _a.sent();
                  return [2, Promise.reject(new Error(message))];
                case 3:
                  if (this.connectionState !== "Connected") {
                    message =
                      "HttpConnection.startInternal completed gracefully but didn't enter the connection into the connected state!";
                    this.logger.log(
                      _ILogger__WEBPACK_IMPORTED_MODULE_1__["LogLevel"].Error,
                      message
                    );
                    return [2, Promise.reject(new Error(message))];
                  }
                  _a.label = 4;
                case 4:
                  this.connectionStarted = true;
                  return [2];
              }
            });
          });
        };
        HttpConnection.prototype.send = function (data) {
          if (this.connectionState !== "Connected") {
            return Promise.reject(
              new Error(
                "Cannot send data if the connection is not in the 'Connected' State."
              )
            );
          }
          if (!this.sendQueue) {
            this.sendQueue = new TransportSendQueue(this.transport);
          }
          return this.sendQueue.send(data);
        };
        HttpConnection.prototype.stop = function (error) {
          return __awaiter(this, void 0, void 0, function () {
            var _this = this;
            return __generator(this, function (_a) {
              switch (_a.label) {
                case 0:
                  if (this.connectionState === "Disconnected") {
                    this.logger.log(
                      _ILogger__WEBPACK_IMPORTED_MODULE_1__["LogLevel"].Debug,
                      "Call to HttpConnection.stop(" +
                        error +
                        ") ignored because the connection is already in the disconnected state."
                    );
                    return [2, Promise.resolve()];
                  }
                  if (this.connectionState === "Disconnecting") {
                    this.logger.log(
                      _ILogger__WEBPACK_IMPORTED_MODULE_1__["LogLevel"].Debug,
                      "Call to HttpConnection.stop(" +
                        error +
                        ") ignored because the connection is already in the disconnecting state."
                    );
                    return [2, this.stopPromise];
                  }
                  this.connectionState = "Disconnecting";
                  this.stopPromise = new Promise(function (resolve) {
                    _this.stopPromiseResolver = resolve;
                  });
                  return [4, this.stopInternal(error)];
                case 1:
                  _a.sent();
                  return [4, this.stopPromise];
                case 2:
                  _a.sent();
                  return [2];
              }
            });
          });
        };
        HttpConnection.prototype.stopInternal = function (error) {
          return __awaiter(this, void 0, void 0, function () {
            var e_1, e_2, e_3;
            return __generator(this, function (_a) {
              switch (_a.label) {
                case 0:
                  this.stopError = error;
                  _a.label = 1;
                case 1:
                  _a.trys.push([1, 3, , 4]);
                  return [4, this.startInternalPromise];
                case 2:
                  _a.sent();
                  return [3, 4];
                case 3:
                  e_1 = _a.sent();
                  return [3, 4];
                case 4:
                  if (!this.sendQueue) return [3, 9];
                  _a.label = 5;
                case 5:
                  _a.trys.push([5, 7, , 8]);
                  return [4, this.sendQueue.stop()];
                case 6:
                  _a.sent();
                  return [3, 8];
                case 7:
                  e_2 = _a.sent();
                  this.logger.log(
                    _ILogger__WEBPACK_IMPORTED_MODULE_1__["LogLevel"].Error,
                    "TransportSendQueue.stop() threw error '" + e_2 + "'."
                  );
                  return [3, 8];
                case 8:
                  this.sendQueue = undefined;
                  _a.label = 9;
                case 9:
                  if (!this.transport) return [3, 14];
                  _a.label = 10;
                case 10:
                  _a.trys.push([10, 12, , 13]);
                  return [4, this.transport.stop()];
                case 11:
                  _a.sent();
                  return [3, 13];
                case 12:
                  e_3 = _a.sent();
                  this.logger.log(
                    _ILogger__WEBPACK_IMPORTED_MODULE_1__["LogLevel"].Error,
                    "HttpConnection.transport.stop() threw error '" + e_3 + "'."
                  );
                  this.stopConnection();
                  return [3, 13];
                case 13:
                  this.transport = undefined;
                  return [3, 15];
                case 14:
                  this.logger.log(
                    _ILogger__WEBPACK_IMPORTED_MODULE_1__["LogLevel"].Debug,
                    "HttpConnection.transport is undefined in HttpConnection.stop() because start() failed."
                  );
                  this.stopConnection();
                  _a.label = 15;
                case 15:
                  return [2];
              }
            });
          });
        };
        HttpConnection.prototype.startInternal = function (transferFormat) {
          return __awaiter(this, void 0, void 0, function () {
            var url, negotiateResponse, redirects, _loop_1, this_1, e_4;
            return __generator(this, function (_a) {
              switch (_a.label) {
                case 0:
                  url = this.baseUrl;
                  this.accessTokenFactory = this.options.accessTokenFactory;
                  _a.label = 1;
                case 1:
                  _a.trys.push([1, 12, , 13]);
                  if (!this.options.skipNegotiation) return [3, 5];
                  if (
                    !(
                      this.options.transport ===
                      _ITransport__WEBPACK_IMPORTED_MODULE_2__[
                        "HttpTransportType"
                      ].WebSockets
                    )
                  )
                    return [3, 3];
                  this.transport = this.constructTransport(
                    _ITransport__WEBPACK_IMPORTED_MODULE_2__[
                      "HttpTransportType"
                    ].WebSockets
                  );
                  return [4, this.startTransport(url, transferFormat)];
                case 2:
                  _a.sent();
                  return [3, 4];
                case 3:
                  throw new Error(
                    "Negotiation can only be skipped when using the WebSocket transport directly."
                  );
                case 4:
                  return [3, 11];
                case 5:
                  negotiateResponse = null;
                  redirects = 0;
                  _loop_1 = function () {
                    var accessToken_1;
                    return __generator(this, function (_a) {
                      switch (_a.label) {
                        case 0:
                          return [4, this_1.getNegotiationResponse(url)];
                        case 1:
                          negotiateResponse = _a.sent();
                          if (
                            this_1.connectionState === "Disconnecting" ||
                            this_1.connectionState === "Disconnected"
                          ) {
                            throw new Error(
                              "The connection was stopped during negotiation."
                            );
                          }
                          if (negotiateResponse.error) {
                            throw new Error(negotiateResponse.error);
                          }
                          if (negotiateResponse.ProtocolVersion) {
                            throw new Error(
                              "Detected a connection attempt to an ASP.NET SignalR Server. This client only supports connecting to an ASP.NET Core SignalR Server. See https://aka.ms/signalr-core-differences for details."
                            );
                          }
                          if (negotiateResponse.url) {
                            url = negotiateResponse.url;
                          }
                          if (negotiateResponse.accessToken) {
                            accessToken_1 = negotiateResponse.accessToken;
                            this_1.accessTokenFactory = function () {
                              return accessToken_1;
                            };
                          }
                          redirects++;
                          return [2];
                      }
                    });
                  };
                  this_1 = this;
                  _a.label = 6;
                case 6:
                  return [5, _loop_1()];
                case 7:
                  _a.sent();
                  _a.label = 8;
                case 8:
                  if (negotiateResponse.url && redirects < MAX_REDIRECTS)
                    return [3, 6];
                  _a.label = 9;
                case 9:
                  if (redirects === MAX_REDIRECTS && negotiateResponse.url) {
                    throw new Error("Negotiate redirection limit exceeded.");
                  }
                  return [
                    4,
                    this.createTransport(
                      url,
                      this.options.transport,
                      negotiateResponse,
                      transferFormat
                    ),
                  ];
                case 10:
                  _a.sent();
                  _a.label = 11;
                case 11:
                  if (
                    this.transport instanceof
                    _LongPollingTransport__WEBPACK_IMPORTED_MODULE_3__[
                      "LongPollingTransport"
                    ]
                  ) {
                    this.features.inherentKeepAlive = true;
                  }
                  if (this.connectionState === "Connecting ") {
                    this.logger.log(
                      _ILogger__WEBPACK_IMPORTED_MODULE_1__["LogLevel"].Debug,
                      "The HttpConnection connected successfully."
                    );
                    this.connectionState = "Connected";
                  }
                  return [3, 13];
                case 12:
                  e_4 = _a.sent();
                  this.logger.log(
                    _ILogger__WEBPACK_IMPORTED_MODULE_1__["LogLevel"].Error,
                    "Failed to start the connection: " + e_4
                  );
                  this.connectionState = "Disconnected";
                  this.transport = undefined;
                  return [2, Promise.reject(e_4)];
                case 13:
                  return [2];
              }
            });
          });
        };
        HttpConnection.prototype.getNegotiationResponse = function (url) {
          return __awaiter(this, void 0, void 0, function () {
            var _a,
              headers,
              token,
              negotiateUrl,
              response,
              negotiateResponse,
              e_5;
            return __generator(this, function (_b) {
              switch (_b.label) {
                case 0:
                  if (!this.accessTokenFactory) return [3, 2];
                  return [4, this.accessTokenFactory()];
                case 1:
                  token = _b.sent();
                  if (token) {
                    headers =
                      ((_a = {}),
                      (_a["Authorization"] = "Bearer " + token),
                      _a);
                  }
                  _b.label = 2;
                case 2:
                  negotiateUrl = this.resolveNegotiateUrl(url);
                  this.logger.log(
                    _ILogger__WEBPACK_IMPORTED_MODULE_1__["LogLevel"].Debug,
                    "Sending negotiation request: " + negotiateUrl + "."
                  );
                  _b.label = 3;
                case 3:
                  _b.trys.push([3, 5, , 6]);
                  return [
                    4,
                    this.httpClient.post(negotiateUrl, {
                      content: "",
                      headers: headers,
                    }),
                  ];
                case 4:
                  response = _b.sent();
                  if (response.statusCode !== 200) {
                    return [
                      2,
                      Promise.reject(
                        new Error(
                          "Unexpected status code returned from negotiate " +
                            response.statusCode
                        )
                      ),
                    ];
                  }
                  negotiateResponse = JSON.parse(response.content);
                  if (
                    !negotiateResponse.negotiateVersion ||
                    negotiateResponse.negotiateVersion < 1
                  ) {
                    negotiateResponse.connectionToken =
                      negotiateResponse.connectionId;
                  }
                  return [2, negotiateResponse];
                case 5:
                  e_5 = _b.sent();
                  this.logger.log(
                    _ILogger__WEBPACK_IMPORTED_MODULE_1__["LogLevel"].Error,
                    "Failed to complete negotiation with the server: " + e_5
                  );
                  return [2, Promise.reject(e_5)];
                case 6:
                  return [2];
              }
            });
          });
        };
        HttpConnection.prototype.createConnectUrl = function (
          url,
          connectionToken
        ) {
          if (!connectionToken) {
            return url;
          }
          return (
            url +
            (url.indexOf("?") === -1 ? "?" : "&") +
            ("id=" + connectionToken)
          );
        };
        HttpConnection.prototype.createTransport = function (
          url,
          requestedTransport,
          negotiateResponse,
          requestedTransferFormat
        ) {
          return __awaiter(this, void 0, void 0, function () {
            var connectUrl,
              transportExceptions,
              transports,
              negotiate,
              _i,
              transports_1,
              endpoint,
              transportOrError,
              ex_1,
              ex_2,
              message;
            return __generator(this, function (_a) {
              switch (_a.label) {
                case 0:
                  connectUrl = this.createConnectUrl(
                    url,
                    negotiateResponse.connectionToken
                  );
                  if (!this.isITransport(requestedTransport)) return [3, 2];
                  this.logger.log(
                    _ILogger__WEBPACK_IMPORTED_MODULE_1__["LogLevel"].Debug,
                    "Connection was provided an instance of ITransport, using that directly."
                  );
                  this.transport = requestedTransport;
                  return [
                    4,
                    this.startTransport(connectUrl, requestedTransferFormat),
                  ];
                case 1:
                  _a.sent();
                  this.connectionId = negotiateResponse.connectionId;
                  return [2];
                case 2:
                  transportExceptions = [];
                  transports = negotiateResponse.availableTransports || [];
                  negotiate = negotiateResponse;
                  (_i = 0), (transports_1 = transports);
                  _a.label = 3;
                case 3:
                  if (!(_i < transports_1.length)) return [3, 13];
                  endpoint = transports_1[_i];
                  transportOrError = this.resolveTransportOrError(
                    endpoint,
                    requestedTransport,
                    requestedTransferFormat
                  );
                  if (!(transportOrError instanceof Error)) return [3, 4];
                  transportExceptions.push(
                    endpoint.transport + " failed: " + transportOrError
                  );
                  return [3, 12];
                case 4:
                  if (!this.isITransport(transportOrError)) return [3, 12];
                  this.transport = transportOrError;
                  if (!!negotiate) return [3, 9];
                  _a.label = 5;
                case 5:
                  _a.trys.push([5, 7, , 8]);
                  return [4, this.getNegotiationResponse(url)];
                case 6:
                  negotiate = _a.sent();
                  return [3, 8];
                case 7:
                  ex_1 = _a.sent();
                  return [2, Promise.reject(ex_1)];
                case 8:
                  connectUrl = this.createConnectUrl(
                    url,
                    negotiate.connectionToken
                  );
                  _a.label = 9;
                case 9:
                  _a.trys.push([9, 11, , 12]);
                  return [
                    4,
                    this.startTransport(connectUrl, requestedTransferFormat),
                  ];
                case 10:
                  _a.sent();
                  this.connectionId = negotiate.connectionId;
                  return [2];
                case 11:
                  ex_2 = _a.sent();
                  this.logger.log(
                    _ILogger__WEBPACK_IMPORTED_MODULE_1__["LogLevel"].Error,
                    "Failed to start the transport '" +
                      endpoint.transport +
                      "': " +
                      ex_2
                  );
                  negotiate = undefined;
                  transportExceptions.push(
                    endpoint.transport + " failed: " + ex_2
                  );
                  if (this.connectionState !== "Connecting ") {
                    message =
                      "Failed to select transport before stop() was called.";
                    this.logger.log(
                      _ILogger__WEBPACK_IMPORTED_MODULE_1__["LogLevel"].Debug,
                      message
                    );
                    return [2, Promise.reject(new Error(message))];
                  }
                  return [3, 12];
                case 12:
                  _i++;
                  return [3, 3];
                case 13:
                  if (transportExceptions.length > 0) {
                    return [
                      2,
                      Promise.reject(
                        new Error(
                          "Unable to connect to the server with any of the available transports. " +
                            transportExceptions.join(" ")
                        )
                      ),
                    ];
                  }
                  return [
                    2,
                    Promise.reject(
                      new Error(
                        "None of the transports supported by the client are supported by the server."
                      )
                    ),
                  ];
              }
            });
          });
        };
        HttpConnection.prototype.constructTransport = function (transport) {
          switch (transport) {
            case _ITransport__WEBPACK_IMPORTED_MODULE_2__["HttpTransportType"]
              .WebSockets:
              if (!this.options.WebSocket) {
                throw new Error(
                  "'WebSocket' is not supported in your environment."
                );
              }
              return new _WebSocketTransport__WEBPACK_IMPORTED_MODULE_6__[
                "WebSocketTransport"
              ](
                this.httpClient,
                this.accessTokenFactory,
                this.logger,
                this.options.logMessageContent || false,
                this.options.WebSocket
              );
            case _ITransport__WEBPACK_IMPORTED_MODULE_2__["HttpTransportType"]
              .ServerSentEvents:
              if (!this.options.EventSource) {
                throw new Error(
                  "'EventSource' is not supported in your environment."
                );
              }
              return new _ServerSentEventsTransport__WEBPACK_IMPORTED_MODULE_4__[
                "ServerSentEventsTransport"
              ](
                this.httpClient,
                this.accessTokenFactory,
                this.logger,
                this.options.logMessageContent || false,
                this.options.EventSource
              );
            case _ITransport__WEBPACK_IMPORTED_MODULE_2__["HttpTransportType"]
              .LongPolling:
              return new _LongPollingTransport__WEBPACK_IMPORTED_MODULE_3__[
                "LongPollingTransport"
              ](
                this.httpClient,
                this.accessTokenFactory,
                this.logger,
                this.options.logMessageContent || false
              );
            default:
              throw new Error("Unknown transport: " + transport + ".");
          }
        };
        HttpConnection.prototype.startTransport = function (
          url,
          transferFormat
        ) {
          var _this = this;
          this.transport.onreceive = this.onreceive;
          this.transport.onclose = function (e) {
            return _this.stopConnection(e);
          };
          return this.transport.connect(url, transferFormat);
        };
        HttpConnection.prototype.resolveTransportOrError = function (
          endpoint,
          requestedTransport,
          requestedTransferFormat
        ) {
          var transport =
            _ITransport__WEBPACK_IMPORTED_MODULE_2__["HttpTransportType"][
              endpoint.transport
            ];
          if (transport === null || transport === undefined) {
            this.logger.log(
              _ILogger__WEBPACK_IMPORTED_MODULE_1__["LogLevel"].Debug,
              "Skipping transport '" +
                endpoint.transport +
                "' because it is not supported by this client."
            );
            return new Error(
              "Skipping transport '" +
                endpoint.transport +
                "' because it is not supported by this client."
            );
          } else {
            if (transportMatches(requestedTransport, transport)) {
              var transferFormats = endpoint.transferFormats.map(function (s) {
                return _ITransport__WEBPACK_IMPORTED_MODULE_2__[
                  "TransferFormat"
                ][s];
              });
              if (transferFormats.indexOf(requestedTransferFormat) >= 0) {
                if (
                  (transport ===
                    _ITransport__WEBPACK_IMPORTED_MODULE_2__[
                      "HttpTransportType"
                    ].WebSockets &&
                    !this.options.WebSocket) ||
                  (transport ===
                    _ITransport__WEBPACK_IMPORTED_MODULE_2__[
                      "HttpTransportType"
                    ].ServerSentEvents &&
                    !this.options.EventSource)
                ) {
                  this.logger.log(
                    _ILogger__WEBPACK_IMPORTED_MODULE_1__["LogLevel"].Debug,
                    "Skipping transport '" +
                      _ITransport__WEBPACK_IMPORTED_MODULE_2__[
                        "HttpTransportType"
                      ][transport] +
                      "' because it is not supported in your environment.'"
                  );
                  return new Error(
                    "'" +
                      _ITransport__WEBPACK_IMPORTED_MODULE_2__[
                        "HttpTransportType"
                      ][transport] +
                      "' is not supported in your environment."
                  );
                } else {
                  this.logger.log(
                    _ILogger__WEBPACK_IMPORTED_MODULE_1__["LogLevel"].Debug,
                    "Selecting transport '" +
                      _ITransport__WEBPACK_IMPORTED_MODULE_2__[
                        "HttpTransportType"
                      ][transport] +
                      "'."
                  );
                  try {
                    return this.constructTransport(transport);
                  } catch (ex) {
                    return ex;
                  }
                }
              } else {
                this.logger.log(
                  _ILogger__WEBPACK_IMPORTED_MODULE_1__["LogLevel"].Debug,
                  "Skipping transport '" +
                    _ITransport__WEBPACK_IMPORTED_MODULE_2__[
                      "HttpTransportType"
                    ][transport] +
                    "' because it does not support the requested transfer format '" +
                    _ITransport__WEBPACK_IMPORTED_MODULE_2__["TransferFormat"][
                      requestedTransferFormat
                    ] +
                    "'."
                );
                return new Error(
                  "'" +
                    _ITransport__WEBPACK_IMPORTED_MODULE_2__[
                      "HttpTransportType"
                    ][transport] +
                    "' does not support " +
                    _ITransport__WEBPACK_IMPORTED_MODULE_2__["TransferFormat"][
                      requestedTransferFormat
                    ] +
                    "."
                );
              }
            } else {
              this.logger.log(
                _ILogger__WEBPACK_IMPORTED_MODULE_1__["LogLevel"].Debug,
                "Skipping transport '" +
                  _ITransport__WEBPACK_IMPORTED_MODULE_2__["HttpTransportType"][
                    transport
                  ] +
                  "' because it was disabled by the client."
              );
              return new Error(
                "'" +
                  _ITransport__WEBPACK_IMPORTED_MODULE_2__["HttpTransportType"][
                    transport
                  ] +
                  "' is disabled by the client."
              );
            }
          }
        };
        HttpConnection.prototype.isITransport = function (transport) {
          return (
            transport && typeof transport === "object" && "connect" in transport
          );
        };
        HttpConnection.prototype.stopConnection = function (error) {
          this.logger.log(
            _ILogger__WEBPACK_IMPORTED_MODULE_1__["LogLevel"].Debug,
            "HttpConnection.stopConnection(" +
              error +
              ") called while in state " +
              this.connectionState +
              "."
          );
          this.transport = undefined;
          error = this.stopError || error;
          this.stopError = undefined;
          if (this.connectionState === "Disconnected") {
            this.logger.log(
              _ILogger__WEBPACK_IMPORTED_MODULE_1__["LogLevel"].Debug,
              "Call to HttpConnection.stopConnection(" +
                error +
                ") was ignored because the connection is already in the disconnected state."
            );
            return;
          }
          if (this.connectionState === "Connecting ") {
            this.logger.log(
              _ILogger__WEBPACK_IMPORTED_MODULE_1__["LogLevel"].Warning,
              "Call to HttpConnection.stopConnection(" +
                error +
                ") was ignored because the connection hasn't yet left the in the connecting state."
            );
            return;
          }
          if (this.connectionState === "Disconnecting") {
            this.stopPromiseResolver();
          }
          if (error) {
            this.logger.log(
              _ILogger__WEBPACK_IMPORTED_MODULE_1__["LogLevel"].Error,
              "Connection disconnected with error '" + error + "'."
            );
          } else {
            this.logger.log(
              _ILogger__WEBPACK_IMPORTED_MODULE_1__["LogLevel"].Information,
              "Connection disconnected."
            );
          }
          this.connectionId = undefined;
          this.connectionState = "Disconnected";
          if (this.onclose && this.connectionStarted) {
            this.connectionStarted = false;
            try {
              this.onclose(error);
            } catch (e) {
              this.logger.log(
                _ILogger__WEBPACK_IMPORTED_MODULE_1__["LogLevel"].Error,
                "HttpConnection.onclose(" + error + ") threw error '" + e + "'."
              );
            }
          }
        };
        HttpConnection.prototype.resolveUrl = function (url) {
          if (
            url.lastIndexOf("https://", 0) === 0 ||
            url.lastIndexOf("http://", 0) === 0
          ) {
            return url;
          }
          if (
            !_Utils__WEBPACK_IMPORTED_MODULE_5__["Platform"].isBrowser ||
            !window.document
          ) {
            throw new Error("Cannot resolve '" + url + "'.");
          }
          var aTag = window.document.createElement("a");
          aTag.href = url;
          this.logger.log(
            _ILogger__WEBPACK_IMPORTED_MODULE_1__["LogLevel"].Information,
            "Normalizing '" + url + "' to '" + aTag.href + "'."
          );
          return aTag.href;
        };
        HttpConnection.prototype.resolveNegotiateUrl = function (url) {
          var index = url.indexOf("?");
          var negotiateUrl = url.substring(
            0,
            index === -1 ? url.length : index
          );
          if (negotiateUrl[negotiateUrl.length - 1] !== "/") {
            negotiateUrl += "/";
          }
          negotiateUrl += "negotiate";
          negotiateUrl += index === -1 ? "" : url.substring(index);
          if (negotiateUrl.indexOf("negotiateVersion") === -1) {
            negotiateUrl += index === -1 ? "?" : "&";
            negotiateUrl += "negotiateVersion=" + this.negotiateVersion;
          }
          return negotiateUrl;
        };
        return HttpConnection;
      })();
      function transportMatches(requestedTransport, actualTransport) {
        return (
          !requestedTransport || (actualTransport & requestedTransport) !== 0
        );
      }
      var TransportSendQueue = (function () {
        function TransportSendQueue(transport) {
          this.transport = transport;
          this.buffer = [];
          this.executing = true;
          this.sendBufferedData = new PromiseSource();
          this.transportResult = new PromiseSource();
          this.sendLoopPromise = this.sendLoop();
        }
        TransportSendQueue.prototype.send = function (data) {
          this.bufferData(data);
          if (!this.transportResult) {
            this.transportResult = new PromiseSource();
          }
          return this.transportResult.promise;
        };
        TransportSendQueue.prototype.stop = function () {
          this.executing = false;
          this.sendBufferedData.resolve();
          return this.sendLoopPromise;
        };
        TransportSendQueue.prototype.bufferData = function (data) {
          if (this.buffer.length && typeof this.buffer[0] !== typeof data) {
            throw new Error(
              "Expected data to be of type " +
                typeof this.buffer +
                " but was of type " +
                typeof data
            );
          }
          this.buffer.push(data);
          this.sendBufferedData.resolve();
        };
        TransportSendQueue.prototype.sendLoop = function () {
          return __awaiter(this, void 0, void 0, function () {
            var transportResult, data, error_1;
            return __generator(this, function (_a) {
              switch (_a.label) {
                case 0:
                  if (false) {
                  }
                  return [4, this.sendBufferedData.promise];
                case 1:
                  _a.sent();
                  if (!this.executing) {
                    if (this.transportResult) {
                      this.transportResult.reject("Connection stopped.");
                    }
                    return [3, 6];
                  }
                  this.sendBufferedData = new PromiseSource();
                  transportResult = this.transportResult;
                  this.transportResult = undefined;
                  data =
                    typeof this.buffer[0] === "string"
                      ? this.buffer.join("")
                      : TransportSendQueue.concatBuffers(this.buffer);
                  this.buffer.length = 0;
                  _a.label = 2;
                case 2:
                  _a.trys.push([2, 4, , 5]);
                  return [4, this.transport.send(data)];
                case 3:
                  _a.sent();
                  transportResult.resolve();
                  return [3, 5];
                case 4:
                  error_1 = _a.sent();
                  transportResult.reject(error_1);
                  return [3, 5];
                case 5:
                  return [3, 0];
                case 6:
                  return [2];
              }
            });
          });
        };
        TransportSendQueue.concatBuffers = function (arrayBuffers) {
          var totalLength = arrayBuffers
            .map(function (b) {
              return b.byteLength;
            })
            .reduce(function (a, b) {
              return a + b;
            });
          var result = new Uint8Array(totalLength);
          var offset = 0;
          for (
            var _i = 0, arrayBuffers_1 = arrayBuffers;
            _i < arrayBuffers_1.length;
            _i++
          ) {
            var item = arrayBuffers_1[_i];
            result.set(new Uint8Array(item), offset);
            offset += item.byteLength;
          }
          return result;
        };
        return TransportSendQueue;
      })();
      var PromiseSource = (function () {
        function PromiseSource() {
          var _this = this;
          this.promise = new Promise(function (resolve, reject) {
            var _a;
            return (
              (_a = [resolve, reject]),
              (_this.resolver = _a[0]),
              (_this.rejecter = _a[1]),
              _a
            );
          });
        }
        PromiseSource.prototype.resolve = function () {
          this.resolver();
        };
        PromiseSource.prototype.reject = function (reason) {
          this.rejecter(reason);
        };
        return PromiseSource;
      })();
    },
    function (module, __webpack_exports__, __webpack_require__) {
      "use strict";
      __webpack_require__.r(__webpack_exports__);
      __webpack_require__.d(
        __webpack_exports__,
        "HttpTransportType",
        function () {
          return HttpTransportType;
        }
      );
      __webpack_require__.d(__webpack_exports__, "TransferFormat", function () {
        return TransferFormat;
      });
      var HttpTransportType;
      (function (HttpTransportType) {
        HttpTransportType[(HttpTransportType["None"] = 0)] = "None";
        HttpTransportType[(HttpTransportType["WebSockets"] = 1)] = "WebSockets";
        HttpTransportType[(HttpTransportType["ServerSentEvents"] = 2)] =
          "ServerSentEvents";
        HttpTransportType[(HttpTransportType["LongPolling"] = 4)] =
          "LongPolling";
      })(HttpTransportType || (HttpTransportType = {}));
      var TransferFormat;
      (function (TransferFormat) {
        TransferFormat[(TransferFormat["Text"] = 1)] = "Text";
        TransferFormat[(TransferFormat["Binary"] = 2)] = "Binary";
      })(TransferFormat || (TransferFormat = {}));
    },
    function (module, __webpack_exports__, __webpack_require__) {
      "use strict";
      __webpack_require__.r(__webpack_exports__);
      __webpack_require__.d(
        __webpack_exports__,
        "LongPollingTransport",
        function () {
          return LongPollingTransport;
        }
      );
      var _AbortController__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(
        22
      );
      var _Errors__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(4);
      var _ILogger__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(9);
      var _ITransport__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(20);
      var _Utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(13);
      var __awaiter =
        (undefined && undefined.__awaiter) ||
        function (thisArg, _arguments, P, generator) {
          return new (P || (P = Promise))(function (resolve, reject) {
            function fulfilled(value) {
              try {
                step(generator.next(value));
              } catch (e) {
                reject(e);
              }
            }
            function rejected(value) {
              try {
                step(generator["throw"](value));
              } catch (e) {
                reject(e);
              }
            }
            function step(result) {
              result.done
                ? resolve(result.value)
                : new P(function (resolve) {
                    resolve(result.value);
                  }).then(fulfilled, rejected);
            }
            step(
              (generator = generator.apply(thisArg, _arguments || [])).next()
            );
          });
        };
      var __generator =
        (undefined && undefined.__generator) ||
        function (thisArg, body) {
          var _ = {
              label: 0,
              sent: function () {
                if (t[0] & 1) throw t[1];
                return t[1];
              },
              trys: [],
              ops: [],
            },
            f,
            y,
            t,
            g;
          return (
            (g = { next: verb(0), throw: verb(1), return: verb(2) }),
            typeof Symbol === "function" &&
              (g[Symbol.iterator] = function () {
                return this;
              }),
            g
          );
          function verb(n) {
            return function (v) {
              return step([n, v]);
            };
          }
          function step(op) {
            if (f) throw new TypeError("Generator is already executing.");
            while (_)
              try {
                if (
                  ((f = 1),
                  y &&
                    (t =
                      op[0] & 2
                        ? y["return"]
                        : op[0]
                        ? y["throw"] || ((t = y["return"]) && t.call(y), 0)
                        : y.next) &&
                    !(t = t.call(y, op[1])).done)
                )
                  return t;
                if (((y = 0), t)) op = [op[0] & 2, t.value];
                switch (op[0]) {
                  case 0:
                  case 1:
                    t = op;
                    break;
                  case 4:
                    _.label++;
                    return { value: op[1], done: false };
                  case 5:
                    _.label++;
                    y = op[1];
                    op = [0];
                    continue;
                  case 7:
                    op = _.ops.pop();
                    _.trys.pop();
                    continue;
                  default:
                    if (
                      !((t = _.trys), (t = t.length > 0 && t[t.length - 1])) &&
                      (op[0] === 6 || op[0] === 2)
                    ) {
                      _ = 0;
                      continue;
                    }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) {
                      _.label = op[1];
                      break;
                    }
                    if (op[0] === 6 && _.label < t[1]) {
                      _.label = t[1];
                      t = op;
                      break;
                    }
                    if (t && _.label < t[2]) {
                      _.label = t[2];
                      _.ops.push(op);
                      break;
                    }
                    if (t[2]) _.ops.pop();
                    _.trys.pop();
                    continue;
                }
                op = body.call(thisArg, _);
              } catch (e) {
                op = [6, e];
                y = 0;
              } finally {
                f = t = 0;
              }
            if (op[0] & 5) throw op[1];
            return { value: op[0] ? op[1] : void 0, done: true };
          }
        };
      var LongPollingTransport = (function () {
        function LongPollingTransport(
          httpClient,
          accessTokenFactory,
          logger,
          logMessageContent
        ) {
          this.httpClient = httpClient;
          this.accessTokenFactory = accessTokenFactory;
          this.logger = logger;
          this.pollAbort = new _AbortController__WEBPACK_IMPORTED_MODULE_0__[
            "AbortController"
          ]();
          this.logMessageContent = logMessageContent;
          this.running = false;
          this.onreceive = null;
          this.onclose = null;
        }
        Object.defineProperty(LongPollingTransport.prototype, "pollAborted", {
          get: function () {
            return this.pollAbort.aborted;
          },
          enumerable: true,
          configurable: true,
        });
        LongPollingTransport.prototype.connect = function (
          url,
          transferFormat
        ) {
          return __awaiter(this, void 0, void 0, function () {
            var pollOptions, token, pollUrl, response;
            return __generator(this, function (_a) {
              switch (_a.label) {
                case 0:
                  _Utils__WEBPACK_IMPORTED_MODULE_4__["Arg"].isRequired(
                    url,
                    "url"
                  );
                  _Utils__WEBPACK_IMPORTED_MODULE_4__["Arg"].isRequired(
                    transferFormat,
                    "transferFormat"
                  );
                  _Utils__WEBPACK_IMPORTED_MODULE_4__["Arg"].isIn(
                    transferFormat,
                    _ITransport__WEBPACK_IMPORTED_MODULE_3__["TransferFormat"],
                    "transferFormat"
                  );
                  this.url = url;
                  this.logger.log(
                    _ILogger__WEBPACK_IMPORTED_MODULE_2__["LogLevel"].Trace,
                    "(LongPolling transport) Connecting."
                  );
                  if (
                    transferFormat ===
                      _ITransport__WEBPACK_IMPORTED_MODULE_3__["TransferFormat"]
                        .Binary &&
                    typeof XMLHttpRequest !== "undefined" &&
                    typeof new XMLHttpRequest().responseType !== "string"
                  ) {
                    throw new Error(
                      "Binary protocols over XmlHttpRequest not implementing advanced features are not supported."
                    );
                  }
                  pollOptions = {
                    abortSignal: this.pollAbort.signal,
                    headers: {},
                    timeout: 1e5,
                  };
                  if (
                    transferFormat ===
                    _ITransport__WEBPACK_IMPORTED_MODULE_3__["TransferFormat"]
                      .Binary
                  ) {
                    pollOptions.responseType = "arraybuffer";
                  }
                  return [4, this.getAccessToken()];
                case 1:
                  token = _a.sent();
                  this.updateHeaderToken(pollOptions, token);
                  pollUrl = url + "&_=" + Date.now();
                  this.logger.log(
                    _ILogger__WEBPACK_IMPORTED_MODULE_2__["LogLevel"].Trace,
                    "(LongPolling transport) polling: " + pollUrl + "."
                  );
                  return [4, this.httpClient.get(pollUrl, pollOptions)];
                case 2:
                  response = _a.sent();
                  if (response.statusCode !== 200) {
                    this.logger.log(
                      _ILogger__WEBPACK_IMPORTED_MODULE_2__["LogLevel"].Error,
                      "(LongPolling transport) Unexpected response code: " +
                        response.statusCode +
                        "."
                    );
                    this.closeError = new _Errors__WEBPACK_IMPORTED_MODULE_1__[
                      "HttpError"
                    ](response.statusText || "", response.statusCode);
                    this.running = false;
                  } else {
                    this.running = true;
                  }
                  this.receiving = this.poll(this.url, pollOptions);
                  return [2];
              }
            });
          });
        };
        LongPollingTransport.prototype.getAccessToken = function () {
          return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
              switch (_a.label) {
                case 0:
                  if (!this.accessTokenFactory) return [3, 2];
                  return [4, this.accessTokenFactory()];
                case 1:
                  return [2, _a.sent()];
                case 2:
                  return [2, null];
              }
            });
          });
        };
        LongPollingTransport.prototype.updateHeaderToken = function (
          request,
          token
        ) {
          if (!request.headers) {
            request.headers = {};
          }
          if (token) {
            request.headers["Authorization"] = "Bearer " + token;
            return;
          }
          if (request.headers["Authorization"]) {
            delete request.headers["Authorization"];
          }
        };
        LongPollingTransport.prototype.poll = function (url, pollOptions) {
          return __awaiter(this, void 0, void 0, function () {
            var token, pollUrl, response, e_1;
            return __generator(this, function (_a) {
              switch (_a.label) {
                case 0:
                  _a.trys.push([0, , 8, 9]);
                  _a.label = 1;
                case 1:
                  if (!this.running) return [3, 7];
                  return [4, this.getAccessToken()];
                case 2:
                  token = _a.sent();
                  this.updateHeaderToken(pollOptions, token);
                  _a.label = 3;
                case 3:
                  _a.trys.push([3, 5, , 6]);
                  pollUrl = url + "&_=" + Date.now();
                  this.logger.log(
                    _ILogger__WEBPACK_IMPORTED_MODULE_2__["LogLevel"].Trace,
                    "(LongPolling transport) polling: " + pollUrl + "."
                  );
                  return [4, this.httpClient.get(pollUrl, pollOptions)];
                case 4:
                  response = _a.sent();
                  if (response.statusCode === 204) {
                    this.logger.log(
                      _ILogger__WEBPACK_IMPORTED_MODULE_2__["LogLevel"]
                        .Information,
                      "(LongPolling transport) Poll terminated by server."
                    );
                    this.running = false;
                  } else if (response.statusCode !== 200) {
                    this.logger.log(
                      _ILogger__WEBPACK_IMPORTED_MODULE_2__["LogLevel"].Error,
                      "(LongPolling transport) Unexpected response code: " +
                        response.statusCode +
                        "."
                    );
                    this.closeError = new _Errors__WEBPACK_IMPORTED_MODULE_1__[
                      "HttpError"
                    ](response.statusText || "", response.statusCode);
                    this.running = false;
                  } else {
                    if (response.content) {
                      this.logger.log(
                        _ILogger__WEBPACK_IMPORTED_MODULE_2__["LogLevel"].Trace,
                        "(LongPolling transport) data received. " +
                          Object(
                            _Utils__WEBPACK_IMPORTED_MODULE_4__["getDataDetail"]
                          )(response.content, this.logMessageContent) +
                          "."
                      );
                      if (this.onreceive) {
                        this.onreceive(response.content);
                      }
                    } else {
                      this.logger.log(
                        _ILogger__WEBPACK_IMPORTED_MODULE_2__["LogLevel"].Trace,
                        "(LongPolling transport) Poll timed out, reissuing."
                      );
                    }
                  }
                  return [3, 6];
                case 5:
                  e_1 = _a.sent();
                  if (!this.running) {
                    this.logger.log(
                      _ILogger__WEBPACK_IMPORTED_MODULE_2__["LogLevel"].Trace,
                      "(LongPolling transport) Poll errored after shutdown: " +
                        e_1.message
                    );
                  } else {
                    if (
                      e_1 instanceof
                      _Errors__WEBPACK_IMPORTED_MODULE_1__["TimeoutError"]
                    ) {
                      this.logger.log(
                        _ILogger__WEBPACK_IMPORTED_MODULE_2__["LogLevel"].Trace,
                        "(LongPolling transport) Poll timed out, reissuing."
                      );
                    } else {
                      this.closeError = e_1;
                      this.running = false;
                    }
                  }
                  return [3, 6];
                case 6:
                  return [3, 1];
                case 7:
                  return [3, 9];
                case 8:
                  this.logger.log(
                    _ILogger__WEBPACK_IMPORTED_MODULE_2__["LogLevel"].Trace,
                    "(LongPolling transport) Polling complete."
                  );
                  if (!this.pollAborted) {
                    this.raiseOnClose();
                  }
                  return [7];
                case 9:
                  return [2];
              }
            });
          });
        };
        LongPollingTransport.prototype.send = function (data) {
          return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
              if (!this.running) {
                return [
                  2,
                  Promise.reject(
                    new Error("Cannot send until the transport is connected")
                  ),
                ];
              }
              return [
                2,
                Object(_Utils__WEBPACK_IMPORTED_MODULE_4__["sendMessage"])(
                  this.logger,
                  "LongPolling",
                  this.httpClient,
                  this.url,
                  this.accessTokenFactory,
                  data,
                  this.logMessageContent
                ),
              ];
            });
          });
        };
        LongPollingTransport.prototype.stop = function () {
          return __awaiter(this, void 0, void 0, function () {
            var deleteOptions, token;
            return __generator(this, function (_a) {
              switch (_a.label) {
                case 0:
                  this.logger.log(
                    _ILogger__WEBPACK_IMPORTED_MODULE_2__["LogLevel"].Trace,
                    "(LongPolling transport) Stopping polling."
                  );
                  this.running = false;
                  this.pollAbort.abort();
                  _a.label = 1;
                case 1:
                  _a.trys.push([1, , 5, 6]);
                  return [4, this.receiving];
                case 2:
                  _a.sent();
                  this.logger.log(
                    _ILogger__WEBPACK_IMPORTED_MODULE_2__["LogLevel"].Trace,
                    "(LongPolling transport) sending DELETE request to " +
                      this.url +
                      "."
                  );
                  deleteOptions = { headers: {} };
                  return [4, this.getAccessToken()];
                case 3:
                  token = _a.sent();
                  this.updateHeaderToken(deleteOptions, token);
                  return [4, this.httpClient.delete(this.url, deleteOptions)];
                case 4:
                  _a.sent();
                  this.logger.log(
                    _ILogger__WEBPACK_IMPORTED_MODULE_2__["LogLevel"].Trace,
                    "(LongPolling transport) DELETE request sent."
                  );
                  return [3, 6];
                case 5:
                  this.logger.log(
                    _ILogger__WEBPACK_IMPORTED_MODULE_2__["LogLevel"].Trace,
                    "(LongPolling transport) Stop finished."
                  );
                  this.raiseOnClose();
                  return [7];
                case 6:
                  return [2];
              }
            });
          });
        };
        LongPollingTransport.prototype.raiseOnClose = function () {
          if (this.onclose) {
            var logMessage = "(LongPolling transport) Firing onclose event.";
            if (this.closeError) {
              logMessage += " Error: " + this.closeError;
            }
            this.logger.log(
              _ILogger__WEBPACK_IMPORTED_MODULE_2__["LogLevel"].Trace,
              logMessage
            );
            this.onclose(this.closeError);
          }
        };
        return LongPollingTransport;
      })();
    },
    function (module, __webpack_exports__, __webpack_require__) {
      "use strict";
      __webpack_require__.r(__webpack_exports__);
      __webpack_require__.d(
        __webpack_exports__,
        "AbortController",
        function () {
          return AbortController;
        }
      );
      var AbortController = (function () {
        function AbortController() {
          this.isAborted = false;
          this.onabort = null;
        }
        AbortController.prototype.abort = function () {
          if (!this.isAborted) {
            this.isAborted = true;
            if (this.onabort) {
              this.onabort();
            }
          }
        };
        Object.defineProperty(AbortController.prototype, "signal", {
          get: function () {
            return this;
          },
          enumerable: true,
          configurable: true,
        });
        Object.defineProperty(AbortController.prototype, "aborted", {
          get: function () {
            return this.isAborted;
          },
          enumerable: true,
          configurable: true,
        });
        return AbortController;
      })();
    },
    function (module, __webpack_exports__, __webpack_require__) {
      "use strict";
      __webpack_require__.r(__webpack_exports__);
      __webpack_require__.d(
        __webpack_exports__,
        "ServerSentEventsTransport",
        function () {
          return ServerSentEventsTransport;
        }
      );
      var _ILogger__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(9);
      var _ITransport__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(20);
      var _Utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(13);
      var __awaiter =
        (undefined && undefined.__awaiter) ||
        function (thisArg, _arguments, P, generator) {
          return new (P || (P = Promise))(function (resolve, reject) {
            function fulfilled(value) {
              try {
                step(generator.next(value));
              } catch (e) {
                reject(e);
              }
            }
            function rejected(value) {
              try {
                step(generator["throw"](value));
              } catch (e) {
                reject(e);
              }
            }
            function step(result) {
              result.done
                ? resolve(result.value)
                : new P(function (resolve) {
                    resolve(result.value);
                  }).then(fulfilled, rejected);
            }
            step(
              (generator = generator.apply(thisArg, _arguments || [])).next()
            );
          });
        };
      var __generator =
        (undefined && undefined.__generator) ||
        function (thisArg, body) {
          var _ = {
              label: 0,
              sent: function () {
                if (t[0] & 1) throw t[1];
                return t[1];
              },
              trys: [],
              ops: [],
            },
            f,
            y,
            t,
            g;
          return (
            (g = { next: verb(0), throw: verb(1), return: verb(2) }),
            typeof Symbol === "function" &&
              (g[Symbol.iterator] = function () {
                return this;
              }),
            g
          );
          function verb(n) {
            return function (v) {
              return step([n, v]);
            };
          }
          function step(op) {
            if (f) throw new TypeError("Generator is already executing.");
            while (_)
              try {
                if (
                  ((f = 1),
                  y &&
                    (t =
                      op[0] & 2
                        ? y["return"]
                        : op[0]
                        ? y["throw"] || ((t = y["return"]) && t.call(y), 0)
                        : y.next) &&
                    !(t = t.call(y, op[1])).done)
                )
                  return t;
                if (((y = 0), t)) op = [op[0] & 2, t.value];
                switch (op[0]) {
                  case 0:
                  case 1:
                    t = op;
                    break;
                  case 4:
                    _.label++;
                    return { value: op[1], done: false };
                  case 5:
                    _.label++;
                    y = op[1];
                    op = [0];
                    continue;
                  case 7:
                    op = _.ops.pop();
                    _.trys.pop();
                    continue;
                  default:
                    if (
                      !((t = _.trys), (t = t.length > 0 && t[t.length - 1])) &&
                      (op[0] === 6 || op[0] === 2)
                    ) {
                      _ = 0;
                      continue;
                    }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) {
                      _.label = op[1];
                      break;
                    }
                    if (op[0] === 6 && _.label < t[1]) {
                      _.label = t[1];
                      t = op;
                      break;
                    }
                    if (t && _.label < t[2]) {
                      _.label = t[2];
                      _.ops.push(op);
                      break;
                    }
                    if (t[2]) _.ops.pop();
                    _.trys.pop();
                    continue;
                }
                op = body.call(thisArg, _);
              } catch (e) {
                op = [6, e];
                y = 0;
              } finally {
                f = t = 0;
              }
            if (op[0] & 5) throw op[1];
            return { value: op[0] ? op[1] : void 0, done: true };
          }
        };
      var ServerSentEventsTransport = (function () {
        function ServerSentEventsTransport(
          httpClient,
          accessTokenFactory,
          logger,
          logMessageContent,
          eventSourceConstructor
        ) {
          this.httpClient = httpClient;
          this.accessTokenFactory = accessTokenFactory;
          this.logger = logger;
          this.logMessageContent = logMessageContent;
          this.eventSourceConstructor = eventSourceConstructor;
          this.onreceive = null;
          this.onclose = null;
        }
        ServerSentEventsTransport.prototype.connect = function (
          url,
          transferFormat
        ) {
          return __awaiter(this, void 0, void 0, function () {
            var token;
            var _this = this;
            return __generator(this, function (_a) {
              switch (_a.label) {
                case 0:
                  _Utils__WEBPACK_IMPORTED_MODULE_2__["Arg"].isRequired(
                    url,
                    "url"
                  );
                  _Utils__WEBPACK_IMPORTED_MODULE_2__["Arg"].isRequired(
                    transferFormat,
                    "transferFormat"
                  );
                  _Utils__WEBPACK_IMPORTED_MODULE_2__["Arg"].isIn(
                    transferFormat,
                    _ITransport__WEBPACK_IMPORTED_MODULE_1__["TransferFormat"],
                    "transferFormat"
                  );
                  this.logger.log(
                    _ILogger__WEBPACK_IMPORTED_MODULE_0__["LogLevel"].Trace,
                    "(SSE transport) Connecting."
                  );
                  this.url = url;
                  if (!this.accessTokenFactory) return [3, 2];
                  return [4, this.accessTokenFactory()];
                case 1:
                  token = _a.sent();
                  if (token) {
                    url +=
                      (url.indexOf("?") < 0 ? "?" : "&") +
                      ("access_token=" + encodeURIComponent(token));
                  }
                  _a.label = 2;
                case 2:
                  return [
                    2,
                    new Promise(function (resolve, reject) {
                      var opened = false;
                      if (
                        transferFormat !==
                        _ITransport__WEBPACK_IMPORTED_MODULE_1__[
                          "TransferFormat"
                        ].Text
                      ) {
                        reject(
                          new Error(
                            "The Server-Sent Events transport only supports the 'Text' transfer format"
                          )
                        );
                        return;
                      }
                      var eventSource;
                      if (
                        _Utils__WEBPACK_IMPORTED_MODULE_2__["Platform"]
                          .isBrowser ||
                        _Utils__WEBPACK_IMPORTED_MODULE_2__["Platform"]
                          .isWebWorker
                      ) {
                        eventSource = new _this.eventSourceConstructor(url, {
                          withCredentials: true,
                        });
                      } else {
                        var cookies = _this.httpClient.getCookieString(url);
                        eventSource = new _this.eventSourceConstructor(url, {
                          withCredentials: true,
                          headers: { Cookie: cookies },
                        });
                      }
                      try {
                        eventSource.onmessage = function (e) {
                          if (_this.onreceive) {
                            try {
                              _this.logger.log(
                                _ILogger__WEBPACK_IMPORTED_MODULE_0__[
                                  "LogLevel"
                                ].Trace,
                                "(SSE transport) data received. " +
                                  Object(
                                    _Utils__WEBPACK_IMPORTED_MODULE_2__[
                                      "getDataDetail"
                                    ]
                                  )(e.data, _this.logMessageContent) +
                                  "."
                              );
                              _this.onreceive(e.data);
                            } catch (error) {
                              _this.close(error);
                              return;
                            }
                          }
                        };
                        eventSource.onerror = function (e) {
                          var error = new Error(e.data || "Error occurred");
                          if (opened) {
                            _this.close(error);
                          } else {
                            reject(error);
                          }
                        };
                        eventSource.onopen = function () {
                          _this.logger.log(
                            _ILogger__WEBPACK_IMPORTED_MODULE_0__["LogLevel"]
                              .Information,
                            "SSE connected to " + _this.url
                          );
                          _this.eventSource = eventSource;
                          opened = true;
                          resolve();
                        };
                      } catch (e) {
                        reject(e);
                        return;
                      }
                    }),
                  ];
              }
            });
          });
        };
        ServerSentEventsTransport.prototype.send = function (data) {
          return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
              if (!this.eventSource) {
                return [
                  2,
                  Promise.reject(
                    new Error("Cannot send until the transport is connected")
                  ),
                ];
              }
              return [
                2,
                Object(_Utils__WEBPACK_IMPORTED_MODULE_2__["sendMessage"])(
                  this.logger,
                  "SSE",
                  this.httpClient,
                  this.url,
                  this.accessTokenFactory,
                  data,
                  this.logMessageContent
                ),
              ];
            });
          });
        };
        ServerSentEventsTransport.prototype.stop = function () {
          this.close();
          return Promise.resolve();
        };
        ServerSentEventsTransport.prototype.close = function (e) {
          if (this.eventSource) {
            this.eventSource.close();
            this.eventSource = undefined;
            if (this.onclose) {
              this.onclose(e);
            }
          }
        };
        return ServerSentEventsTransport;
      })();
    },
    function (module, __webpack_exports__, __webpack_require__) {
      "use strict";
      __webpack_require__.r(__webpack_exports__);
      __webpack_require__.d(
        __webpack_exports__,
        "WebSocketTransport",
        function () {
          return WebSocketTransport;
        }
      );
      var _ILogger__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(9);
      var _ITransport__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(20);
      var _Utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(13);
      var __awaiter =
        (undefined && undefined.__awaiter) ||
        function (thisArg, _arguments, P, generator) {
          return new (P || (P = Promise))(function (resolve, reject) {
            function fulfilled(value) {
              try {
                step(generator.next(value));
              } catch (e) {
                reject(e);
              }
            }
            function rejected(value) {
              try {
                step(generator["throw"](value));
              } catch (e) {
                reject(e);
              }
            }
            function step(result) {
              result.done
                ? resolve(result.value)
                : new P(function (resolve) {
                    resolve(result.value);
                  }).then(fulfilled, rejected);
            }
            step(
              (generator = generator.apply(thisArg, _arguments || [])).next()
            );
          });
        };
      var __generator =
        (undefined && undefined.__generator) ||
        function (thisArg, body) {
          var _ = {
              label: 0,
              sent: function () {
                if (t[0] & 1) throw t[1];
                return t[1];
              },
              trys: [],
              ops: [],
            },
            f,
            y,
            t,
            g;
          return (
            (g = { next: verb(0), throw: verb(1), return: verb(2) }),
            typeof Symbol === "function" &&
              (g[Symbol.iterator] = function () {
                return this;
              }),
            g
          );
          function verb(n) {
            return function (v) {
              return step([n, v]);
            };
          }
          function step(op) {
            if (f) throw new TypeError("Generator is already executing.");
            while (_)
              try {
                if (
                  ((f = 1),
                  y &&
                    (t =
                      op[0] & 2
                        ? y["return"]
                        : op[0]
                        ? y["throw"] || ((t = y["return"]) && t.call(y), 0)
                        : y.next) &&
                    !(t = t.call(y, op[1])).done)
                )
                  return t;
                if (((y = 0), t)) op = [op[0] & 2, t.value];
                switch (op[0]) {
                  case 0:
                  case 1:
                    t = op;
                    break;
                  case 4:
                    _.label++;
                    return { value: op[1], done: false };
                  case 5:
                    _.label++;
                    y = op[1];
                    op = [0];
                    continue;
                  case 7:
                    op = _.ops.pop();
                    _.trys.pop();
                    continue;
                  default:
                    if (
                      !((t = _.trys), (t = t.length > 0 && t[t.length - 1])) &&
                      (op[0] === 6 || op[0] === 2)
                    ) {
                      _ = 0;
                      continue;
                    }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) {
                      _.label = op[1];
                      break;
                    }
                    if (op[0] === 6 && _.label < t[1]) {
                      _.label = t[1];
                      t = op;
                      break;
                    }
                    if (t && _.label < t[2]) {
                      _.label = t[2];
                      _.ops.push(op);
                      break;
                    }
                    if (t[2]) _.ops.pop();
                    _.trys.pop();
                    continue;
                }
                op = body.call(thisArg, _);
              } catch (e) {
                op = [6, e];
                y = 0;
              } finally {
                f = t = 0;
              }
            if (op[0] & 5) throw op[1];
            return { value: op[0] ? op[1] : void 0, done: true };
          }
        };
      var WebSocketTransport = (function () {
        function WebSocketTransport(
          httpClient,
          accessTokenFactory,
          logger,
          logMessageContent,
          webSocketConstructor
        ) {
          this.logger = logger;
          this.accessTokenFactory = accessTokenFactory;
          this.logMessageContent = logMessageContent;
          this.webSocketConstructor = webSocketConstructor;
          this.httpClient = httpClient;
          this.onreceive = null;
          this.onclose = null;
        }
        WebSocketTransport.prototype.connect = function (url, transferFormat) {
          return __awaiter(this, void 0, void 0, function () {
            var token;
            var _this = this;
            return __generator(this, function (_a) {
              switch (_a.label) {
                case 0:
                  _Utils__WEBPACK_IMPORTED_MODULE_2__["Arg"].isRequired(
                    url,
                    "url"
                  );
                  _Utils__WEBPACK_IMPORTED_MODULE_2__["Arg"].isRequired(
                    transferFormat,
                    "transferFormat"
                  );
                  _Utils__WEBPACK_IMPORTED_MODULE_2__["Arg"].isIn(
                    transferFormat,
                    _ITransport__WEBPACK_IMPORTED_MODULE_1__["TransferFormat"],
                    "transferFormat"
                  );
                  this.logger.log(
                    _ILogger__WEBPACK_IMPORTED_MODULE_0__["LogLevel"].Trace,
                    "(WebSockets transport) Connecting."
                  );
                  if (!this.accessTokenFactory) return [3, 2];
                  return [4, this.accessTokenFactory()];
                case 1:
                  token = _a.sent();
                  if (token) {
                    url +=
                      (url.indexOf("?") < 0 ? "?" : "&") +
                      ("access_token=" + encodeURIComponent(token));
                  }
                  _a.label = 2;
                case 2:
                  return [
                    2,
                    new Promise(function (resolve, reject) {
                      url = url.replace(/^http/, "ws");
                      var webSocket;
                      var cookies = _this.httpClient.getCookieString(url);
                      var opened = false;
                      if (
                        _Utils__WEBPACK_IMPORTED_MODULE_2__["Platform"]
                          .isNode &&
                        cookies
                      ) {
                        webSocket = new _this.webSocketConstructor(
                          url,
                          undefined,
                          { headers: { Cookie: "" + cookies } }
                        );
                      }
                      if (!webSocket) {
                        webSocket = new _this.webSocketConstructor(url);
                      }
                      if (
                        transferFormat ===
                        _ITransport__WEBPACK_IMPORTED_MODULE_1__[
                          "TransferFormat"
                        ].Binary
                      ) {
                        webSocket.binaryType = "arraybuffer";
                      }
                      webSocket.onopen = function (_event) {
                        _this.logger.log(
                          _ILogger__WEBPACK_IMPORTED_MODULE_0__["LogLevel"]
                            .Information,
                          "WebSocket connected to " + url + "."
                        );
                        _this.webSocket = webSocket;
                        opened = true;
                        resolve();
                      };
                      webSocket.onerror = function (event) {
                        var error = null;
                        if (
                          typeof ErrorEvent !== "undefined" &&
                          event instanceof ErrorEvent
                        ) {
                          error = event.error;
                        } else {
                          error = new Error(
                            "There was an error with the transport."
                          );
                        }
                        reject(error);
                      };
                      webSocket.onmessage = function (message) {
                        _this.logger.log(
                          _ILogger__WEBPACK_IMPORTED_MODULE_0__["LogLevel"]
                            .Trace,
                          "(WebSockets transport) data received. " +
                            Object(
                              _Utils__WEBPACK_IMPORTED_MODULE_2__[
                                "getDataDetail"
                              ]
                            )(message.data, _this.logMessageContent) +
                            "."
                        );
                        if (_this.onreceive) {
                          _this.onreceive(message.data);
                        }
                      };
                      webSocket.onclose = function (event) {
                        if (opened) {
                          _this.close(event);
                        } else {
                          var error = null;
                          if (
                            typeof ErrorEvent !== "undefined" &&
                            event instanceof ErrorEvent
                          ) {
                            error = event.error;
                          } else {
                            error = new Error(
                              "There was an error with the transport."
                            );
                          }
                          reject(error);
                        }
                      };
                    }),
                  ];
              }
            });
          });
        };
        WebSocketTransport.prototype.send = function (data) {
          if (
            this.webSocket &&
            this.webSocket.readyState === this.webSocketConstructor.OPEN
          ) {
            this.logger.log(
              _ILogger__WEBPACK_IMPORTED_MODULE_0__["LogLevel"].Trace,
              "(WebSockets transport) sending data. " +
                Object(_Utils__WEBPACK_IMPORTED_MODULE_2__["getDataDetail"])(
                  data,
                  this.logMessageContent
                ) +
                "."
            );
            this.webSocket.send(data);
            return Promise.resolve();
          }
          return Promise.reject("WebSocket is not in the OPEN state");
        };
        WebSocketTransport.prototype.stop = function () {
          if (this.webSocket) {
            this.webSocket.onclose = function () {};
            this.webSocket.onmessage = function () {};
            this.webSocket.onerror = function () {};
            this.webSocket.close();
            this.webSocket = undefined;
            this.close(undefined);
          }
          return Promise.resolve();
        };
        WebSocketTransport.prototype.close = function (event) {
          this.logger.log(
            _ILogger__WEBPACK_IMPORTED_MODULE_0__["LogLevel"].Trace,
            "(WebSockets transport) socket closed."
          );
          if (this.onclose) {
            if (event && (event.wasClean === false || event.code !== 1e3)) {
              this.onclose(
                new Error(
                  "WebSocket closed with status code: " +
                    event.code +
                    " (" +
                    event.reason +
                    ")."
                )
              );
            } else {
              this.onclose();
            }
          }
        };
        return WebSocketTransport;
      })();
    },
    function (module, __webpack_exports__, __webpack_require__) {
      "use strict";
      __webpack_require__.r(__webpack_exports__);
      __webpack_require__.d(
        __webpack_exports__,
        "JsonHubProtocol",
        function () {
          return JsonHubProtocol;
        }
      );
      var _IHubProtocol__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(15);
      var _ILogger__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(9);
      var _ITransport__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(20);
      var _Loggers__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(14);
      var _TextMessageFormat__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(
        12
      );
      var JSON_HUB_PROTOCOL_NAME = "json";
      var JsonHubProtocol = (function () {
        function JsonHubProtocol() {
          this.name = JSON_HUB_PROTOCOL_NAME;
          this.version = 1;
          this.transferFormat =
            _ITransport__WEBPACK_IMPORTED_MODULE_2__["TransferFormat"].Text;
        }
        JsonHubProtocol.prototype.parseMessages = function (input, logger) {
          if (typeof input !== "string") {
            throw new Error(
              "Invalid input for JSON hub protocol. Expected a string."
            );
          }
          if (!input) {
            return [];
          }
          if (logger === null) {
            logger =
              _Loggers__WEBPACK_IMPORTED_MODULE_3__["NullLogger"].instance;
          }
          var messages = _TextMessageFormat__WEBPACK_IMPORTED_MODULE_4__[
            "TextMessageFormat"
          ].parse(input);
          var hubMessages = [];
          for (
            var _i = 0, messages_1 = messages;
            _i < messages_1.length;
            _i++
          ) {
            var message = messages_1[_i];
            var parsedMessage = JSON.parse(message);
            if (typeof parsedMessage.type !== "number") {
              throw new Error("Invalid payload.");
            }
            switch (parsedMessage.type) {
              case _IHubProtocol__WEBPACK_IMPORTED_MODULE_0__["MessageType"]
                .Invocation:
                this.isInvocationMessage(parsedMessage);
                break;
              case _IHubProtocol__WEBPACK_IMPORTED_MODULE_0__["MessageType"]
                .StreamItem:
                this.isStreamItemMessage(parsedMessage);
                break;
              case _IHubProtocol__WEBPACK_IMPORTED_MODULE_0__["MessageType"]
                .Completion:
                this.isCompletionMessage(parsedMessage);
                break;
              case _IHubProtocol__WEBPACK_IMPORTED_MODULE_0__["MessageType"]
                .Ping:
                break;
              case _IHubProtocol__WEBPACK_IMPORTED_MODULE_0__["MessageType"]
                .Close:
                break;
              default:
                logger.log(
                  _ILogger__WEBPACK_IMPORTED_MODULE_1__["LogLevel"].Information,
                  "Unknown message type '" + parsedMessage.type + "' ignored."
                );
                continue;
            }
            hubMessages.push(parsedMessage);
          }
          return hubMessages;
        };
        JsonHubProtocol.prototype.writeMessage = function (message) {
          return _TextMessageFormat__WEBPACK_IMPORTED_MODULE_4__[
            "TextMessageFormat"
          ].write(JSON.stringify(message));
        };
        JsonHubProtocol.prototype.isInvocationMessage = function (message) {
          this.assertNotEmptyString(
            message.target,
            "Invalid payload for Invocation message."
          );
          if (message.invocationId !== undefined) {
            this.assertNotEmptyString(
              message.invocationId,
              "Invalid payload for Invocation message."
            );
          }
        };
        JsonHubProtocol.prototype.isStreamItemMessage = function (message) {
          this.assertNotEmptyString(
            message.invocationId,
            "Invalid payload for StreamItem message."
          );
          if (message.item === undefined) {
            throw new Error("Invalid payload for StreamItem message.");
          }
        };
        JsonHubProtocol.prototype.isCompletionMessage = function (message) {
          if (message.result && message.error) {
            throw new Error("Invalid payload for Completion message.");
          }
          if (!message.result && message.error) {
            this.assertNotEmptyString(
              message.error,
              "Invalid payload for Completion message."
            );
          }
          this.assertNotEmptyString(
            message.invocationId,
            "Invalid payload for Completion message."
          );
        };
        JsonHubProtocol.prototype.assertNotEmptyString = function (
          value,
          errorMessage
        ) {
          if (typeof value !== "string" || value === "") {
            throw new Error(errorMessage);
          }
        };
        return JsonHubProtocol;
      })();
    },
  ]);
});
//# sourceMappingURL=signalr.min.js.map

!(function (t, e) {
  "object" == typeof exports
    ? (module.exports = exports = e())
    : "function" == typeof define && define.amd
    ? define([], e)
    : (t.CryptoJS = e());
})(this, function () {
  var h,
    t,
    e,
    r,
    i,
    n,
    f,
    o,
    s,
    c,
    a,
    l,
    d,
    m,
    x,
    b,
    H,
    z,
    A,
    u,
    p,
    _,
    v,
    y,
    g,
    B,
    w,
    k,
    S,
    C,
    D,
    E,
    R,
    M,
    F,
    P,
    W,
    O,
    I,
    U,
    K,
    X,
    L,
    j,
    N,
    T,
    q,
    Z,
    V,
    G,
    J,
    $,
    Q,
    Y,
    tt,
    et,
    rt,
    it,
    nt,
    ot,
    st,
    ct,
    at,
    ht,
    lt,
    ft,
    dt,
    ut,
    pt,
    _t,
    vt,
    yt,
    gt,
    Bt,
    wt,
    kt,
    St,
    bt =
      bt ||
      (function (l) {
        var t;
        if (
          ("undefined" != typeof window && window.crypto && (t = window.crypto),
          !t &&
            "undefined" != typeof window &&
            window.msCrypto &&
            (t = window.msCrypto),
          !t &&
            "undefined" != typeof global &&
            global.crypto &&
            (t = global.crypto),
          !t && "function" == typeof require)
        )
          try {
            t = require("crypto");
          } catch (t) {}
        function i() {
          if (t) {
            if ("function" == typeof t.getRandomValues)
              try {
                return t.getRandomValues(new Uint32Array(1))[0];
              } catch (t) {}
            if ("function" == typeof t.randomBytes)
              try {
                return t.randomBytes(4).readInt32LE();
              } catch (t) {}
          }
          throw new Error(
            "Native crypto module could not be used to get secure random number."
          );
        }
        var r =
          Object.create ||
          function (t) {
            var e;
            return (n.prototype = t), (e = new n()), (n.prototype = null), e;
          };
        function n() {}
        var e = {},
          o = (e.lib = {}),
          s = (o.Base = {
            extend: function (t) {
              var e = r(this);
              return (
                t && e.mixIn(t),
                (e.hasOwnProperty("init") && this.init !== e.init) ||
                  (e.init = function () {
                    e.$super.init.apply(this, arguments);
                  }),
                ((e.init.prototype = e).$super = this),
                e
              );
            },
            create: function () {
              var t = this.extend();
              return t.init.apply(t, arguments), t;
            },
            init: function () {},
            mixIn: function (t) {
              for (var e in t) t.hasOwnProperty(e) && (this[e] = t[e]);
              t.hasOwnProperty("toString") && (this.toString = t.toString);
            },
            clone: function () {
              return this.init.prototype.extend(this);
            },
          }),
          f = (o.WordArray = s.extend({
            init: function (t, e) {
              (t = this.words = t || []),
                (this.sigBytes = null != e ? e : 4 * t.length);
            },
            toString: function (t) {
              return (t || a).stringify(this);
            },
            concat: function (t) {
              var e = this.words,
                r = t.words,
                i = this.sigBytes,
                n = t.sigBytes;
              if ((this.clamp(), i % 4))
                for (var o = 0; o < n; o++) {
                  var s = (r[o >>> 2] >>> (24 - (o % 4) * 8)) & 255;
                  e[(i + o) >>> 2] |= s << (24 - ((i + o) % 4) * 8);
                }
              else for (o = 0; o < n; o += 4) e[(i + o) >>> 2] = r[o >>> 2];
              return (this.sigBytes += n), this;
            },
            clamp: function () {
              var t = this.words,
                e = this.sigBytes;
              (t[e >>> 2] &= 4294967295 << (32 - (e % 4) * 8)),
                (t.length = l.ceil(e / 4));
            },
            clone: function () {
              var t = s.clone.call(this);
              return (t.words = this.words.slice(0)), t;
            },
            random: function (t) {
              for (var e = [], r = 0; r < t; r += 4) e.push(i());
              return new f.init(e, t);
            },
          })),
          c = (e.enc = {}),
          a = (c.Hex = {
            stringify: function (t) {
              for (var e = t.words, r = t.sigBytes, i = [], n = 0; n < r; n++) {
                var o = (e[n >>> 2] >>> (24 - (n % 4) * 8)) & 255;
                i.push((o >>> 4).toString(16)), i.push((15 & o).toString(16));
              }
              return i.join("");
            },
            parse: function (t) {
              for (var e = t.length, r = [], i = 0; i < e; i += 2)
                r[i >>> 3] |=
                  parseInt(t.substr(i, 2), 16) << (24 - (i % 8) * 4);
              return new f.init(r, e / 2);
            },
          }),
          h = (c.Latin1 = {
            stringify: function (t) {
              for (var e = t.words, r = t.sigBytes, i = [], n = 0; n < r; n++) {
                var o = (e[n >>> 2] >>> (24 - (n % 4) * 8)) & 255;
                i.push(String.fromCharCode(o));
              }
              return i.join("");
            },
            parse: function (t) {
              for (var e = t.length, r = [], i = 0; i < e; i++)
                r[i >>> 2] |= (255 & t.charCodeAt(i)) << (24 - (i % 4) * 8);
              return new f.init(r, e);
            },
          }),
          d = (c.Utf8 = {
            stringify: function (t) {
              try {
                return decodeURIComponent(escape(h.stringify(t)));
              } catch (t) {
                throw new Error("Malformed UTF-8 data");
              }
            },
            parse: function (t) {
              return h.parse(unescape(encodeURIComponent(t)));
            },
          }),
          u = (o.BufferedBlockAlgorithm = s.extend({
            reset: function () {
              (this._data = new f.init()), (this._nDataBytes = 0);
            },
            _append: function (t) {
              "string" == typeof t && (t = d.parse(t)),
                this._data.concat(t),
                (this._nDataBytes += t.sigBytes);
            },
            _process: function (t) {
              var e,
                r = this._data,
                i = r.words,
                n = r.sigBytes,
                o = this.blockSize,
                s = n / (4 * o),
                c =
                  (s = t
                    ? l.ceil(s)
                    : l.max((0 | s) - this._minBufferSize, 0)) * o,
                a = l.min(4 * c, n);
              if (c) {
                for (var h = 0; h < c; h += o) this._doProcessBlock(i, h);
                (e = i.splice(0, c)), (r.sigBytes -= a);
              }
              return new f.init(e, a);
            },
            clone: function () {
              var t = s.clone.call(this);
              return (t._data = this._data.clone()), t;
            },
            _minBufferSize: 0,
          })),
          p =
            ((o.Hasher = u.extend({
              cfg: s.extend(),
              init: function (t) {
                (this.cfg = this.cfg.extend(t)), this.reset();
              },
              reset: function () {
                u.reset.call(this), this._doReset();
              },
              update: function (t) {
                return this._append(t), this._process(), this;
              },
              finalize: function (t) {
                return t && this._append(t), this._doFinalize();
              },
              blockSize: 16,
              _createHelper: function (r) {
                return function (t, e) {
                  return new r.init(e).finalize(t);
                };
              },
              _createHmacHelper: function (r) {
                return function (t, e) {
                  return new p.HMAC.init(r, e).finalize(t);
                };
              },
            })),
            (e.algo = {}));
        return e;
      })(Math);
  function mt(t, e, r) {
    return t ^ e ^ r;
  }
  function xt(t, e, r) {
    return (t & e) | (~t & r);
  }
  function Ht(t, e, r) {
    return (t | ~e) ^ r;
  }
  function zt(t, e, r) {
    return (t & r) | (e & ~r);
  }
  function At(t, e, r) {
    return t ^ (e | ~r);
  }
  function Ct(t, e) {
    return (t << e) | (t >>> (32 - e));
  }
  function Dt(t, e, r, i) {
    var n,
      o = this._iv;
    o ? ((n = o.slice(0)), (this._iv = void 0)) : (n = this._prevBlock),
      i.encryptBlock(n, 0);
    for (var s = 0; s < r; s++) t[e + s] ^= n[s];
  }
  function Et(t) {
    if (255 == ((t >> 24) & 255)) {
      var e = (t >> 16) & 255,
        r = (t >> 8) & 255,
        i = 255 & t;
      255 === e
        ? ((e = 0), 255 === r ? ((r = 0), 255 === i ? (i = 0) : ++i) : ++r)
        : ++e,
        (t = 0),
        (t += e << 16),
        (t += r << 8),
        (t += i);
    } else t += 1 << 24;
    return t;
  }
  function Rt() {
    for (var t = this._X, e = this._C, r = 0; r < 8; r++) ft[r] = e[r];
    (e[0] = (e[0] + 1295307597 + this._b) | 0),
      (e[1] = (e[1] + 3545052371 + (e[0] >>> 0 < ft[0] >>> 0 ? 1 : 0)) | 0),
      (e[2] = (e[2] + 886263092 + (e[1] >>> 0 < ft[1] >>> 0 ? 1 : 0)) | 0),
      (e[3] = (e[3] + 1295307597 + (e[2] >>> 0 < ft[2] >>> 0 ? 1 : 0)) | 0),
      (e[4] = (e[4] + 3545052371 + (e[3] >>> 0 < ft[3] >>> 0 ? 1 : 0)) | 0),
      (e[5] = (e[5] + 886263092 + (e[4] >>> 0 < ft[4] >>> 0 ? 1 : 0)) | 0),
      (e[6] = (e[6] + 1295307597 + (e[5] >>> 0 < ft[5] >>> 0 ? 1 : 0)) | 0),
      (e[7] = (e[7] + 3545052371 + (e[6] >>> 0 < ft[6] >>> 0 ? 1 : 0)) | 0),
      (this._b = e[7] >>> 0 < ft[7] >>> 0 ? 1 : 0);
    for (r = 0; r < 8; r++) {
      var i = t[r] + e[r],
        n = 65535 & i,
        o = i >>> 16,
        s = ((((n * n) >>> 17) + n * o) >>> 15) + o * o,
        c = (((4294901760 & i) * i) | 0) + (((65535 & i) * i) | 0);
      dt[r] = s ^ c;
    }
    (t[0] =
      (dt[0] +
        ((dt[7] << 16) | (dt[7] >>> 16)) +
        ((dt[6] << 16) | (dt[6] >>> 16))) |
      0),
      (t[1] = (dt[1] + ((dt[0] << 8) | (dt[0] >>> 24)) + dt[7]) | 0),
      (t[2] =
        (dt[2] +
          ((dt[1] << 16) | (dt[1] >>> 16)) +
          ((dt[0] << 16) | (dt[0] >>> 16))) |
        0),
      (t[3] = (dt[3] + ((dt[2] << 8) | (dt[2] >>> 24)) + dt[1]) | 0),
      (t[4] =
        (dt[4] +
          ((dt[3] << 16) | (dt[3] >>> 16)) +
          ((dt[2] << 16) | (dt[2] >>> 16))) |
        0),
      (t[5] = (dt[5] + ((dt[4] << 8) | (dt[4] >>> 24)) + dt[3]) | 0),
      (t[6] =
        (dt[6] +
          ((dt[5] << 16) | (dt[5] >>> 16)) +
          ((dt[4] << 16) | (dt[4] >>> 16))) |
        0),
      (t[7] = (dt[7] + ((dt[6] << 8) | (dt[6] >>> 24)) + dt[5]) | 0);
  }
  function Mt() {
    for (var t = this._X, e = this._C, r = 0; r < 8; r++) wt[r] = e[r];
    (e[0] = (e[0] + 1295307597 + this._b) | 0),
      (e[1] = (e[1] + 3545052371 + (e[0] >>> 0 < wt[0] >>> 0 ? 1 : 0)) | 0),
      (e[2] = (e[2] + 886263092 + (e[1] >>> 0 < wt[1] >>> 0 ? 1 : 0)) | 0),
      (e[3] = (e[3] + 1295307597 + (e[2] >>> 0 < wt[2] >>> 0 ? 1 : 0)) | 0),
      (e[4] = (e[4] + 3545052371 + (e[3] >>> 0 < wt[3] >>> 0 ? 1 : 0)) | 0),
      (e[5] = (e[5] + 886263092 + (e[4] >>> 0 < wt[4] >>> 0 ? 1 : 0)) | 0),
      (e[6] = (e[6] + 1295307597 + (e[5] >>> 0 < wt[5] >>> 0 ? 1 : 0)) | 0),
      (e[7] = (e[7] + 3545052371 + (e[6] >>> 0 < wt[6] >>> 0 ? 1 : 0)) | 0),
      (this._b = e[7] >>> 0 < wt[7] >>> 0 ? 1 : 0);
    for (r = 0; r < 8; r++) {
      var i = t[r] + e[r],
        n = 65535 & i,
        o = i >>> 16,
        s = ((((n * n) >>> 17) + n * o) >>> 15) + o * o,
        c = (((4294901760 & i) * i) | 0) + (((65535 & i) * i) | 0);
      kt[r] = s ^ c;
    }
    (t[0] =
      (kt[0] +
        ((kt[7] << 16) | (kt[7] >>> 16)) +
        ((kt[6] << 16) | (kt[6] >>> 16))) |
      0),
      (t[1] = (kt[1] + ((kt[0] << 8) | (kt[0] >>> 24)) + kt[7]) | 0),
      (t[2] =
        (kt[2] +
          ((kt[1] << 16) | (kt[1] >>> 16)) +
          ((kt[0] << 16) | (kt[0] >>> 16))) |
        0),
      (t[3] = (kt[3] + ((kt[2] << 8) | (kt[2] >>> 24)) + kt[1]) | 0),
      (t[4] =
        (kt[4] +
          ((kt[3] << 16) | (kt[3] >>> 16)) +
          ((kt[2] << 16) | (kt[2] >>> 16))) |
        0),
      (t[5] = (kt[5] + ((kt[4] << 8) | (kt[4] >>> 24)) + kt[3]) | 0),
      (t[6] =
        (kt[6] +
          ((kt[5] << 16) | (kt[5] >>> 16)) +
          ((kt[4] << 16) | (kt[4] >>> 16))) |
        0),
      (t[7] = (kt[7] + ((kt[6] << 8) | (kt[6] >>> 24)) + kt[5]) | 0);
  }
  return (
    (h = bt.lib.WordArray),
    (bt.enc.Base64 = {
      stringify: function (t) {
        var e = t.words,
          r = t.sigBytes,
          i = this._map;
        t.clamp();
        for (var n = [], o = 0; o < r; o += 3)
          for (
            var s =
                (((e[o >>> 2] >>> (24 - (o % 4) * 8)) & 255) << 16) |
                (((e[(o + 1) >>> 2] >>> (24 - ((o + 1) % 4) * 8)) & 255) << 8) |
                ((e[(o + 2) >>> 2] >>> (24 - ((o + 2) % 4) * 8)) & 255),
              c = 0;
            c < 4 && o + 0.75 * c < r;
            c++
          )
            n.push(i.charAt((s >>> (6 * (3 - c))) & 63));
        var a = i.charAt(64);
        if (a) for (; n.length % 4; ) n.push(a);
        return n.join("");
      },
      parse: function (t) {
        var e = t.length,
          r = this._map,
          i = this._reverseMap;
        if (!i) {
          i = this._reverseMap = [];
          for (var n = 0; n < r.length; n++) i[r.charCodeAt(n)] = n;
        }
        var o = r.charAt(64);
        if (o) {
          var s = t.indexOf(o);
          -1 !== s && (e = s);
        }
        return (function (t, e, r) {
          for (var i = [], n = 0, o = 0; o < e; o++)
            if (o % 4) {
              var s = r[t.charCodeAt(o - 1)] << ((o % 4) * 2),
                c = r[t.charCodeAt(o)] >>> (6 - (o % 4) * 2),
                a = s | c;
              (i[n >>> 2] |= a << (24 - (n % 4) * 8)), n++;
            }
          return h.create(i, n);
        })(t, e, i);
      },
      _map: "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=",
    }),
    (function (l) {
      var t = bt,
        e = t.lib,
        r = e.WordArray,
        i = e.Hasher,
        n = t.algo,
        H = [];
      !(function () {
        for (var t = 0; t < 64; t++)
          H[t] = (4294967296 * l.abs(l.sin(t + 1))) | 0;
      })();
      var o = (n.MD5 = i.extend({
        _doReset: function () {
          this._hash = new r.init([
            1732584193,
            4023233417,
            2562383102,
            271733878,
          ]);
        },
        _doProcessBlock: function (t, e) {
          for (var r = 0; r < 16; r++) {
            var i = e + r,
              n = t[i];
            t[i] =
              (16711935 & ((n << 8) | (n >>> 24))) |
              (4278255360 & ((n << 24) | (n >>> 8)));
          }
          var o = this._hash.words,
            s = t[e + 0],
            c = t[e + 1],
            a = t[e + 2],
            h = t[e + 3],
            l = t[e + 4],
            f = t[e + 5],
            d = t[e + 6],
            u = t[e + 7],
            p = t[e + 8],
            _ = t[e + 9],
            v = t[e + 10],
            y = t[e + 11],
            g = t[e + 12],
            B = t[e + 13],
            w = t[e + 14],
            k = t[e + 15],
            S = o[0],
            m = o[1],
            x = o[2],
            b = o[3];
          (S = z(S, m, x, b, s, 7, H[0])),
            (b = z(b, S, m, x, c, 12, H[1])),
            (x = z(x, b, S, m, a, 17, H[2])),
            (m = z(m, x, b, S, h, 22, H[3])),
            (S = z(S, m, x, b, l, 7, H[4])),
            (b = z(b, S, m, x, f, 12, H[5])),
            (x = z(x, b, S, m, d, 17, H[6])),
            (m = z(m, x, b, S, u, 22, H[7])),
            (S = z(S, m, x, b, p, 7, H[8])),
            (b = z(b, S, m, x, _, 12, H[9])),
            (x = z(x, b, S, m, v, 17, H[10])),
            (m = z(m, x, b, S, y, 22, H[11])),
            (S = z(S, m, x, b, g, 7, H[12])),
            (b = z(b, S, m, x, B, 12, H[13])),
            (x = z(x, b, S, m, w, 17, H[14])),
            (S = A(S, (m = z(m, x, b, S, k, 22, H[15])), x, b, c, 5, H[16])),
            (b = A(b, S, m, x, d, 9, H[17])),
            (x = A(x, b, S, m, y, 14, H[18])),
            (m = A(m, x, b, S, s, 20, H[19])),
            (S = A(S, m, x, b, f, 5, H[20])),
            (b = A(b, S, m, x, v, 9, H[21])),
            (x = A(x, b, S, m, k, 14, H[22])),
            (m = A(m, x, b, S, l, 20, H[23])),
            (S = A(S, m, x, b, _, 5, H[24])),
            (b = A(b, S, m, x, w, 9, H[25])),
            (x = A(x, b, S, m, h, 14, H[26])),
            (m = A(m, x, b, S, p, 20, H[27])),
            (S = A(S, m, x, b, B, 5, H[28])),
            (b = A(b, S, m, x, a, 9, H[29])),
            (x = A(x, b, S, m, u, 14, H[30])),
            (S = C(S, (m = A(m, x, b, S, g, 20, H[31])), x, b, f, 4, H[32])),
            (b = C(b, S, m, x, p, 11, H[33])),
            (x = C(x, b, S, m, y, 16, H[34])),
            (m = C(m, x, b, S, w, 23, H[35])),
            (S = C(S, m, x, b, c, 4, H[36])),
            (b = C(b, S, m, x, l, 11, H[37])),
            (x = C(x, b, S, m, u, 16, H[38])),
            (m = C(m, x, b, S, v, 23, H[39])),
            (S = C(S, m, x, b, B, 4, H[40])),
            (b = C(b, S, m, x, s, 11, H[41])),
            (x = C(x, b, S, m, h, 16, H[42])),
            (m = C(m, x, b, S, d, 23, H[43])),
            (S = C(S, m, x, b, _, 4, H[44])),
            (b = C(b, S, m, x, g, 11, H[45])),
            (x = C(x, b, S, m, k, 16, H[46])),
            (S = D(S, (m = C(m, x, b, S, a, 23, H[47])), x, b, s, 6, H[48])),
            (b = D(b, S, m, x, u, 10, H[49])),
            (x = D(x, b, S, m, w, 15, H[50])),
            (m = D(m, x, b, S, f, 21, H[51])),
            (S = D(S, m, x, b, g, 6, H[52])),
            (b = D(b, S, m, x, h, 10, H[53])),
            (x = D(x, b, S, m, v, 15, H[54])),
            (m = D(m, x, b, S, c, 21, H[55])),
            (S = D(S, m, x, b, p, 6, H[56])),
            (b = D(b, S, m, x, k, 10, H[57])),
            (x = D(x, b, S, m, d, 15, H[58])),
            (m = D(m, x, b, S, B, 21, H[59])),
            (S = D(S, m, x, b, l, 6, H[60])),
            (b = D(b, S, m, x, y, 10, H[61])),
            (x = D(x, b, S, m, a, 15, H[62])),
            (m = D(m, x, b, S, _, 21, H[63])),
            (o[0] = (o[0] + S) | 0),
            (o[1] = (o[1] + m) | 0),
            (o[2] = (o[2] + x) | 0),
            (o[3] = (o[3] + b) | 0);
        },
        _doFinalize: function () {
          var t = this._data,
            e = t.words,
            r = 8 * this._nDataBytes,
            i = 8 * t.sigBytes;
          e[i >>> 5] |= 128 << (24 - (i % 32));
          var n = l.floor(r / 4294967296),
            o = r;
          (e[15 + (((64 + i) >>> 9) << 4)] =
            (16711935 & ((n << 8) | (n >>> 24))) |
            (4278255360 & ((n << 24) | (n >>> 8)))),
            (e[14 + (((64 + i) >>> 9) << 4)] =
              (16711935 & ((o << 8) | (o >>> 24))) |
              (4278255360 & ((o << 24) | (o >>> 8)))),
            (t.sigBytes = 4 * (e.length + 1)),
            this._process();
          for (var s = this._hash, c = s.words, a = 0; a < 4; a++) {
            var h = c[a];
            c[a] =
              (16711935 & ((h << 8) | (h >>> 24))) |
              (4278255360 & ((h << 24) | (h >>> 8)));
          }
          return s;
        },
        clone: function () {
          var t = i.clone.call(this);
          return (t._hash = this._hash.clone()), t;
        },
      }));
      function z(t, e, r, i, n, o, s) {
        var c = t + ((e & r) | (~e & i)) + n + s;
        return ((c << o) | (c >>> (32 - o))) + e;
      }
      function A(t, e, r, i, n, o, s) {
        var c = t + ((e & i) | (r & ~i)) + n + s;
        return ((c << o) | (c >>> (32 - o))) + e;
      }
      function C(t, e, r, i, n, o, s) {
        var c = t + (e ^ r ^ i) + n + s;
        return ((c << o) | (c >>> (32 - o))) + e;
      }
      function D(t, e, r, i, n, o, s) {
        var c = t + (r ^ (e | ~i)) + n + s;
        return ((c << o) | (c >>> (32 - o))) + e;
      }
      (t.MD5 = i._createHelper(o)), (t.HmacMD5 = i._createHmacHelper(o));
    })(Math),
    (e = (t = bt).lib),
    (r = e.WordArray),
    (i = e.Hasher),
    (n = t.algo),
    (f = []),
    (o = n.SHA1 = i.extend({
      _doReset: function () {
        this._hash = new r.init([
          1732584193,
          4023233417,
          2562383102,
          271733878,
          3285377520,
        ]);
      },
      _doProcessBlock: function (t, e) {
        for (
          var r = this._hash.words,
            i = r[0],
            n = r[1],
            o = r[2],
            s = r[3],
            c = r[4],
            a = 0;
          a < 80;
          a++
        ) {
          if (a < 16) f[a] = 0 | t[e + a];
          else {
            var h = f[a - 3] ^ f[a - 8] ^ f[a - 14] ^ f[a - 16];
            f[a] = (h << 1) | (h >>> 31);
          }
          var l = ((i << 5) | (i >>> 27)) + c + f[a];
          (l +=
            a < 20
              ? 1518500249 + ((n & o) | (~n & s))
              : a < 40
              ? 1859775393 + (n ^ o ^ s)
              : a < 60
              ? ((n & o) | (n & s) | (o & s)) - 1894007588
              : (n ^ o ^ s) - 899497514),
            (c = s),
            (s = o),
            (o = (n << 30) | (n >>> 2)),
            (n = i),
            (i = l);
        }
        (r[0] = (r[0] + i) | 0),
          (r[1] = (r[1] + n) | 0),
          (r[2] = (r[2] + o) | 0),
          (r[3] = (r[3] + s) | 0),
          (r[4] = (r[4] + c) | 0);
      },
      _doFinalize: function () {
        var t = this._data,
          e = t.words,
          r = 8 * this._nDataBytes,
          i = 8 * t.sigBytes;
        return (
          (e[i >>> 5] |= 128 << (24 - (i % 32))),
          (e[14 + (((64 + i) >>> 9) << 4)] = Math.floor(r / 4294967296)),
          (e[15 + (((64 + i) >>> 9) << 4)] = r),
          (t.sigBytes = 4 * e.length),
          this._process(),
          this._hash
        );
      },
      clone: function () {
        var t = i.clone.call(this);
        return (t._hash = this._hash.clone()), t;
      },
    })),
    (t.SHA1 = i._createHelper(o)),
    (t.HmacSHA1 = i._createHmacHelper(o)),
    (function (n) {
      var t = bt,
        e = t.lib,
        r = e.WordArray,
        i = e.Hasher,
        o = t.algo,
        s = [],
        B = [];
      !(function () {
        function t(t) {
          for (var e = n.sqrt(t), r = 2; r <= e; r++) if (!(t % r)) return;
          return 1;
        }
        function e(t) {
          return (4294967296 * (t - (0 | t))) | 0;
        }
        for (var r = 2, i = 0; i < 64; )
          t(r) &&
            (i < 8 && (s[i] = e(n.pow(r, 0.5))),
            (B[i] = e(n.pow(r, 1 / 3))),
            i++),
            r++;
      })();
      var w = [],
        c = (o.SHA256 = i.extend({
          _doReset: function () {
            this._hash = new r.init(s.slice(0));
          },
          _doProcessBlock: function (t, e) {
            for (
              var r = this._hash.words,
                i = r[0],
                n = r[1],
                o = r[2],
                s = r[3],
                c = r[4],
                a = r[5],
                h = r[6],
                l = r[7],
                f = 0;
              f < 64;
              f++
            ) {
              if (f < 16) w[f] = 0 | t[e + f];
              else {
                var d = w[f - 15],
                  u =
                    ((d << 25) | (d >>> 7)) ^
                    ((d << 14) | (d >>> 18)) ^
                    (d >>> 3),
                  p = w[f - 2],
                  _ =
                    ((p << 15) | (p >>> 17)) ^
                    ((p << 13) | (p >>> 19)) ^
                    (p >>> 10);
                w[f] = u + w[f - 7] + _ + w[f - 16];
              }
              var v = (i & n) ^ (i & o) ^ (n & o),
                y =
                  ((i << 30) | (i >>> 2)) ^
                  ((i << 19) | (i >>> 13)) ^
                  ((i << 10) | (i >>> 22)),
                g =
                  l +
                  (((c << 26) | (c >>> 6)) ^
                    ((c << 21) | (c >>> 11)) ^
                    ((c << 7) | (c >>> 25))) +
                  ((c & a) ^ (~c & h)) +
                  B[f] +
                  w[f];
              (l = h),
                (h = a),
                (a = c),
                (c = (s + g) | 0),
                (s = o),
                (o = n),
                (n = i),
                (i = (g + (y + v)) | 0);
            }
            (r[0] = (r[0] + i) | 0),
              (r[1] = (r[1] + n) | 0),
              (r[2] = (r[2] + o) | 0),
              (r[3] = (r[3] + s) | 0),
              (r[4] = (r[4] + c) | 0),
              (r[5] = (r[5] + a) | 0),
              (r[6] = (r[6] + h) | 0),
              (r[7] = (r[7] + l) | 0);
          },
          _doFinalize: function () {
            var t = this._data,
              e = t.words,
              r = 8 * this._nDataBytes,
              i = 8 * t.sigBytes;
            return (
              (e[i >>> 5] |= 128 << (24 - (i % 32))),
              (e[14 + (((64 + i) >>> 9) << 4)] = n.floor(r / 4294967296)),
              (e[15 + (((64 + i) >>> 9) << 4)] = r),
              (t.sigBytes = 4 * e.length),
              this._process(),
              this._hash
            );
          },
          clone: function () {
            var t = i.clone.call(this);
            return (t._hash = this._hash.clone()), t;
          },
        }));
      (t.SHA256 = i._createHelper(c)), (t.HmacSHA256 = i._createHmacHelper(c));
    })(Math),
    (function () {
      var n = bt.lib.WordArray,
        t = bt.enc;
      t.Utf16 = t.Utf16BE = {
        stringify: function (t) {
          for (var e = t.words, r = t.sigBytes, i = [], n = 0; n < r; n += 2) {
            var o = (e[n >>> 2] >>> (16 - (n % 4) * 8)) & 65535;
            i.push(String.fromCharCode(o));
          }
          return i.join("");
        },
        parse: function (t) {
          for (var e = t.length, r = [], i = 0; i < e; i++)
            r[i >>> 1] |= t.charCodeAt(i) << (16 - (i % 2) * 16);
          return n.create(r, 2 * e);
        },
      };
      function s(t) {
        return ((t << 8) & 4278255360) | ((t >>> 8) & 16711935);
      }
      t.Utf16LE = {
        stringify: function (t) {
          for (var e = t.words, r = t.sigBytes, i = [], n = 0; n < r; n += 2) {
            var o = s((e[n >>> 2] >>> (16 - (n % 4) * 8)) & 65535);
            i.push(String.fromCharCode(o));
          }
          return i.join("");
        },
        parse: function (t) {
          for (var e = t.length, r = [], i = 0; i < e; i++)
            r[i >>> 1] |= s(t.charCodeAt(i) << (16 - (i % 2) * 16));
          return n.create(r, 2 * e);
        },
      };
    })(),
    (function () {
      if ("function" == typeof ArrayBuffer) {
        var t = bt.lib.WordArray,
          n = t.init;
        (t.init = function (t) {
          if (
            (t instanceof ArrayBuffer && (t = new Uint8Array(t)),
            (t instanceof Int8Array ||
              ("undefined" != typeof Uint8ClampedArray &&
                t instanceof Uint8ClampedArray) ||
              t instanceof Int16Array ||
              t instanceof Uint16Array ||
              t instanceof Int32Array ||
              t instanceof Uint32Array ||
              t instanceof Float32Array ||
              t instanceof Float64Array) &&
              (t = new Uint8Array(t.buffer, t.byteOffset, t.byteLength)),
            t instanceof Uint8Array)
          ) {
            for (var e = t.byteLength, r = [], i = 0; i < e; i++)
              r[i >>> 2] |= t[i] << (24 - (i % 4) * 8);
            n.call(this, r, e);
          } else n.apply(this, arguments);
        }).prototype = t;
      }
    })(),
    Math,
    (c = (s = bt).lib),
    (a = c.WordArray),
    (l = c.Hasher),
    (d = s.algo),
    (m = a.create([
      0,
      1,
      2,
      3,
      4,
      5,
      6,
      7,
      8,
      9,
      10,
      11,
      12,
      13,
      14,
      15,
      7,
      4,
      13,
      1,
      10,
      6,
      15,
      3,
      12,
      0,
      9,
      5,
      2,
      14,
      11,
      8,
      3,
      10,
      14,
      4,
      9,
      15,
      8,
      1,
      2,
      7,
      0,
      6,
      13,
      11,
      5,
      12,
      1,
      9,
      11,
      10,
      0,
      8,
      12,
      4,
      13,
      3,
      7,
      15,
      14,
      5,
      6,
      2,
      4,
      0,
      5,
      9,
      7,
      12,
      2,
      10,
      14,
      1,
      3,
      8,
      11,
      6,
      15,
      13,
    ])),
    (x = a.create([
      5,
      14,
      7,
      0,
      9,
      2,
      11,
      4,
      13,
      6,
      15,
      8,
      1,
      10,
      3,
      12,
      6,
      11,
      3,
      7,
      0,
      13,
      5,
      10,
      14,
      15,
      8,
      12,
      4,
      9,
      1,
      2,
      15,
      5,
      1,
      3,
      7,
      14,
      6,
      9,
      11,
      8,
      12,
      2,
      10,
      0,
      4,
      13,
      8,
      6,
      4,
      1,
      3,
      11,
      15,
      0,
      5,
      12,
      2,
      13,
      9,
      7,
      10,
      14,
      12,
      15,
      10,
      4,
      1,
      5,
      8,
      7,
      6,
      2,
      13,
      14,
      0,
      3,
      9,
      11,
    ])),
    (b = a.create([
      11,
      14,
      15,
      12,
      5,
      8,
      7,
      9,
      11,
      13,
      14,
      15,
      6,
      7,
      9,
      8,
      7,
      6,
      8,
      13,
      11,
      9,
      7,
      15,
      7,
      12,
      15,
      9,
      11,
      7,
      13,
      12,
      11,
      13,
      6,
      7,
      14,
      9,
      13,
      15,
      14,
      8,
      13,
      6,
      5,
      12,
      7,
      5,
      11,
      12,
      14,
      15,
      14,
      15,
      9,
      8,
      9,
      14,
      5,
      6,
      8,
      6,
      5,
      12,
      9,
      15,
      5,
      11,
      6,
      8,
      13,
      12,
      5,
      12,
      13,
      14,
      11,
      8,
      5,
      6,
    ])),
    (H = a.create([
      8,
      9,
      9,
      11,
      13,
      15,
      15,
      5,
      7,
      7,
      8,
      11,
      14,
      14,
      12,
      6,
      9,
      13,
      15,
      7,
      12,
      8,
      9,
      11,
      7,
      7,
      12,
      7,
      6,
      15,
      13,
      11,
      9,
      7,
      15,
      11,
      8,
      6,
      6,
      14,
      12,
      13,
      5,
      14,
      13,
      13,
      7,
      5,
      15,
      5,
      8,
      11,
      14,
      14,
      6,
      14,
      6,
      9,
      12,
      9,
      12,
      5,
      15,
      8,
      8,
      5,
      12,
      9,
      12,
      5,
      14,
      6,
      8,
      13,
      6,
      5,
      15,
      13,
      11,
      11,
    ])),
    (z = a.create([0, 1518500249, 1859775393, 2400959708, 2840853838])),
    (A = a.create([1352829926, 1548603684, 1836072691, 2053994217, 0])),
    (u = d.RIPEMD160 = l.extend({
      _doReset: function () {
        this._hash = a.create([
          1732584193,
          4023233417,
          2562383102,
          271733878,
          3285377520,
        ]);
      },
      _doProcessBlock: function (t, e) {
        for (var r = 0; r < 16; r++) {
          var i = e + r,
            n = t[i];
          t[i] =
            (16711935 & ((n << 8) | (n >>> 24))) |
            (4278255360 & ((n << 24) | (n >>> 8)));
        }
        var o,
          s,
          c,
          a,
          h,
          l,
          f,
          d,
          u,
          p,
          _,
          v = this._hash.words,
          y = z.words,
          g = A.words,
          B = m.words,
          w = x.words,
          k = b.words,
          S = H.words;
        (l = o = v[0]),
          (f = s = v[1]),
          (d = c = v[2]),
          (u = a = v[3]),
          (p = h = v[4]);
        for (r = 0; r < 80; r += 1)
          (_ = (o + t[e + B[r]]) | 0),
            (_ +=
              r < 16
                ? mt(s, c, a) + y[0]
                : r < 32
                ? xt(s, c, a) + y[1]
                : r < 48
                ? Ht(s, c, a) + y[2]
                : r < 64
                ? zt(s, c, a) + y[3]
                : At(s, c, a) + y[4]),
            (_ = ((_ = Ct((_ |= 0), k[r])) + h) | 0),
            (o = h),
            (h = a),
            (a = Ct(c, 10)),
            (c = s),
            (s = _),
            (_ = (l + t[e + w[r]]) | 0),
            (_ +=
              r < 16
                ? At(f, d, u) + g[0]
                : r < 32
                ? zt(f, d, u) + g[1]
                : r < 48
                ? Ht(f, d, u) + g[2]
                : r < 64
                ? xt(f, d, u) + g[3]
                : mt(f, d, u) + g[4]),
            (_ = ((_ = Ct((_ |= 0), S[r])) + p) | 0),
            (l = p),
            (p = u),
            (u = Ct(d, 10)),
            (d = f),
            (f = _);
        (_ = (v[1] + c + u) | 0),
          (v[1] = (v[2] + a + p) | 0),
          (v[2] = (v[3] + h + l) | 0),
          (v[3] = (v[4] + o + f) | 0),
          (v[4] = (v[0] + s + d) | 0),
          (v[0] = _);
      },
      _doFinalize: function () {
        var t = this._data,
          e = t.words,
          r = 8 * this._nDataBytes,
          i = 8 * t.sigBytes;
        (e[i >>> 5] |= 128 << (24 - (i % 32))),
          (e[14 + (((64 + i) >>> 9) << 4)] =
            (16711935 & ((r << 8) | (r >>> 24))) |
            (4278255360 & ((r << 24) | (r >>> 8)))),
          (t.sigBytes = 4 * (e.length + 1)),
          this._process();
        for (var n = this._hash, o = n.words, s = 0; s < 5; s++) {
          var c = o[s];
          o[s] =
            (16711935 & ((c << 8) | (c >>> 24))) |
            (4278255360 & ((c << 24) | (c >>> 8)));
        }
        return n;
      },
      clone: function () {
        var t = l.clone.call(this);
        return (t._hash = this._hash.clone()), t;
      },
    })),
    (s.RIPEMD160 = l._createHelper(u)),
    (s.HmacRIPEMD160 = l._createHmacHelper(u)),
    (p = bt.lib.Base),
    (_ = bt.enc.Utf8),
    (bt.algo.HMAC = p.extend({
      init: function (t, e) {
        (t = this._hasher = new t.init()),
          "string" == typeof e && (e = _.parse(e));
        var r = t.blockSize,
          i = 4 * r;
        e.sigBytes > i && (e = t.finalize(e)), e.clamp();
        for (
          var n = (this._oKey = e.clone()),
            o = (this._iKey = e.clone()),
            s = n.words,
            c = o.words,
            a = 0;
          a < r;
          a++
        )
          (s[a] ^= 1549556828), (c[a] ^= 909522486);
        (n.sigBytes = o.sigBytes = i), this.reset();
      },
      reset: function () {
        var t = this._hasher;
        t.reset(), t.update(this._iKey);
      },
      update: function (t) {
        return this._hasher.update(t), this;
      },
      finalize: function (t) {
        var e = this._hasher,
          r = e.finalize(t);
        return e.reset(), e.finalize(this._oKey.clone().concat(r));
      },
    })),
    (y = (v = bt).lib),
    (g = y.Base),
    (B = y.WordArray),
    (w = v.algo),
    (k = w.SHA1),
    (S = w.HMAC),
    (C = w.PBKDF2 = g.extend({
      cfg: g.extend({ keySize: 4, hasher: k, iterations: 1 }),
      init: function (t) {
        this.cfg = this.cfg.extend(t);
      },
      compute: function (t, e) {
        for (
          var r = this.cfg,
            i = S.create(r.hasher, t),
            n = B.create(),
            o = B.create([1]),
            s = n.words,
            c = o.words,
            a = r.keySize,
            h = r.iterations;
          s.length < a;

        ) {
          var l = i.update(e).finalize(o);
          i.reset();
          for (var f = l.words, d = f.length, u = l, p = 1; p < h; p++) {
            (u = i.finalize(u)), i.reset();
            for (var _ = u.words, v = 0; v < d; v++) f[v] ^= _[v];
          }
          n.concat(l), c[0]++;
        }
        return (n.sigBytes = 4 * a), n;
      },
    })),
    (v.PBKDF2 = function (t, e, r) {
      return C.create(r).compute(t, e);
    }),
    (E = (D = bt).lib),
    (R = E.Base),
    (M = E.WordArray),
    (F = D.algo),
    (P = F.MD5),
    (W = F.EvpKDF = R.extend({
      cfg: R.extend({ keySize: 4, hasher: P, iterations: 1 }),
      init: function (t) {
        this.cfg = this.cfg.extend(t);
      },
      compute: function (t, e) {
        for (
          var r,
            i = this.cfg,
            n = i.hasher.create(),
            o = M.create(),
            s = o.words,
            c = i.keySize,
            a = i.iterations;
          s.length < c;

        ) {
          r && n.update(r), (r = n.update(t).finalize(e)), n.reset();
          for (var h = 1; h < a; h++) (r = n.finalize(r)), n.reset();
          o.concat(r);
        }
        return (o.sigBytes = 4 * c), o;
      },
    })),
    (D.EvpKDF = function (t, e, r) {
      return W.create(r).compute(t, e);
    }),
    (I = (O = bt).lib.WordArray),
    (U = O.algo),
    (K = U.SHA256),
    (X = U.SHA224 = K.extend({
      _doReset: function () {
        this._hash = new I.init([
          3238371032,
          914150663,
          812702999,
          4144912697,
          4290775857,
          1750603025,
          1694076839,
          3204075428,
        ]);
      },
      _doFinalize: function () {
        var t = K._doFinalize.call(this);
        return (t.sigBytes -= 4), t;
      },
    })),
    (O.SHA224 = K._createHelper(X)),
    (O.HmacSHA224 = K._createHmacHelper(X)),
    (L = bt.lib),
    (j = L.Base),
    (N = L.WordArray),
    ((T = bt.x64 = {}).Word = j.extend({
      init: function (t, e) {
        (this.high = t), (this.low = e);
      },
    })),
    (T.WordArray = j.extend({
      init: function (t, e) {
        (t = this.words = t || []),
          (this.sigBytes = null != e ? e : 8 * t.length);
      },
      toX32: function () {
        for (var t = this.words, e = t.length, r = [], i = 0; i < e; i++) {
          var n = t[i];
          r.push(n.high), r.push(n.low);
        }
        return N.create(r, this.sigBytes);
      },
      clone: function () {
        for (
          var t = j.clone.call(this),
            e = (t.words = this.words.slice(0)),
            r = e.length,
            i = 0;
          i < r;
          i++
        )
          e[i] = e[i].clone();
        return t;
      },
    })),
    (function (d) {
      var t = bt,
        e = t.lib,
        u = e.WordArray,
        i = e.Hasher,
        l = t.x64.Word,
        r = t.algo,
        C = [],
        D = [],
        E = [];
      !(function () {
        for (var t = 1, e = 0, r = 0; r < 24; r++) {
          C[t + 5 * e] = (((r + 1) * (r + 2)) / 2) % 64;
          var i = (2 * t + 3 * e) % 5;
          (t = e % 5), (e = i);
        }
        for (t = 0; t < 5; t++)
          for (e = 0; e < 5; e++) D[t + 5 * e] = e + ((2 * t + 3 * e) % 5) * 5;
        for (var n = 1, o = 0; o < 24; o++) {
          for (var s = 0, c = 0, a = 0; a < 7; a++) {
            if (1 & n) {
              var h = (1 << a) - 1;
              h < 32 ? (c ^= 1 << h) : (s ^= 1 << (h - 32));
            }
            128 & n ? (n = (n << 1) ^ 113) : (n <<= 1);
          }
          E[o] = l.create(s, c);
        }
      })();
      var R = [];
      !(function () {
        for (var t = 0; t < 25; t++) R[t] = l.create();
      })();
      var n = (r.SHA3 = i.extend({
        cfg: i.cfg.extend({ outputLength: 512 }),
        _doReset: function () {
          for (var t = (this._state = []), e = 0; e < 25; e++)
            t[e] = new l.init();
          this.blockSize = (1600 - 2 * this.cfg.outputLength) / 32;
        },
        _doProcessBlock: function (t, e) {
          for (var r = this._state, i = this.blockSize / 2, n = 0; n < i; n++) {
            var o = t[e + 2 * n],
              s = t[e + 2 * n + 1];
            (o =
              (16711935 & ((o << 8) | (o >>> 24))) |
              (4278255360 & ((o << 24) | (o >>> 8)))),
              (s =
                (16711935 & ((s << 8) | (s >>> 24))) |
                (4278255360 & ((s << 24) | (s >>> 8)))),
              ((x = r[n]).high ^= s),
              (x.low ^= o);
          }
          for (var c = 0; c < 24; c++) {
            for (var a = 0; a < 5; a++) {
              for (var h = 0, l = 0, f = 0; f < 5; f++) {
                (h ^= (x = r[a + 5 * f]).high), (l ^= x.low);
              }
              var d = R[a];
              (d.high = h), (d.low = l);
            }
            for (a = 0; a < 5; a++) {
              var u = R[(a + 4) % 5],
                p = R[(a + 1) % 5],
                _ = p.high,
                v = p.low;
              for (
                h = u.high ^ ((_ << 1) | (v >>> 31)),
                  l = u.low ^ ((v << 1) | (_ >>> 31)),
                  f = 0;
                f < 5;
                f++
              ) {
                ((x = r[a + 5 * f]).high ^= h), (x.low ^= l);
              }
            }
            for (var y = 1; y < 25; y++) {
              var g = (x = r[y]).high,
                B = x.low,
                w = C[y];
              l =
                w < 32
                  ? ((h = (g << w) | (B >>> (32 - w))),
                    (B << w) | (g >>> (32 - w)))
                  : ((h = (B << (w - 32)) | (g >>> (64 - w))),
                    (g << (w - 32)) | (B >>> (64 - w)));
              var k = R[D[y]];
              (k.high = h), (k.low = l);
            }
            var S = R[0],
              m = r[0];
            (S.high = m.high), (S.low = m.low);
            for (a = 0; a < 5; a++)
              for (f = 0; f < 5; f++) {
                var x = r[(y = a + 5 * f)],
                  b = R[y],
                  H = R[((a + 1) % 5) + 5 * f],
                  z = R[((a + 2) % 5) + 5 * f];
                (x.high = b.high ^ (~H.high & z.high)),
                  (x.low = b.low ^ (~H.low & z.low));
              }
            x = r[0];
            var A = E[c];
            (x.high ^= A.high), (x.low ^= A.low);
          }
        },
        _doFinalize: function () {
          var t = this._data,
            e = t.words,
            r = (this._nDataBytes, 8 * t.sigBytes),
            i = 32 * this.blockSize;
          (e[r >>> 5] |= 1 << (24 - (r % 32))),
            (e[((d.ceil((1 + r) / i) * i) >>> 5) - 1] |= 128),
            (t.sigBytes = 4 * e.length),
            this._process();
          for (
            var n = this._state,
              o = this.cfg.outputLength / 8,
              s = o / 8,
              c = [],
              a = 0;
            a < s;
            a++
          ) {
            var h = n[a],
              l = h.high,
              f = h.low;
            (l =
              (16711935 & ((l << 8) | (l >>> 24))) |
              (4278255360 & ((l << 24) | (l >>> 8)))),
              (f =
                (16711935 & ((f << 8) | (f >>> 24))) |
                (4278255360 & ((f << 24) | (f >>> 8)))),
              c.push(f),
              c.push(l);
          }
          return new u.init(c, o);
        },
        clone: function () {
          for (
            var t = i.clone.call(this),
              e = (t._state = this._state.slice(0)),
              r = 0;
            r < 25;
            r++
          )
            e[r] = e[r].clone();
          return t;
        },
      }));
      (t.SHA3 = i._createHelper(n)), (t.HmacSHA3 = i._createHmacHelper(n));
    })(Math),
    (function () {
      var t = bt,
        e = t.lib.Hasher,
        r = t.x64,
        i = r.Word,
        n = r.WordArray,
        o = t.algo;
      function s() {
        return i.create.apply(i, arguments);
      }
      var mt = [
          s(1116352408, 3609767458),
          s(1899447441, 602891725),
          s(3049323471, 3964484399),
          s(3921009573, 2173295548),
          s(961987163, 4081628472),
          s(1508970993, 3053834265),
          s(2453635748, 2937671579),
          s(2870763221, 3664609560),
          s(3624381080, 2734883394),
          s(310598401, 1164996542),
          s(607225278, 1323610764),
          s(1426881987, 3590304994),
          s(1925078388, 4068182383),
          s(2162078206, 991336113),
          s(2614888103, 633803317),
          s(3248222580, 3479774868),
          s(3835390401, 2666613458),
          s(4022224774, 944711139),
          s(264347078, 2341262773),
          s(604807628, 2007800933),
          s(770255983, 1495990901),
          s(1249150122, 1856431235),
          s(1555081692, 3175218132),
          s(1996064986, 2198950837),
          s(2554220882, 3999719339),
          s(2821834349, 766784016),
          s(2952996808, 2566594879),
          s(3210313671, 3203337956),
          s(3336571891, 1034457026),
          s(3584528711, 2466948901),
          s(113926993, 3758326383),
          s(338241895, 168717936),
          s(666307205, 1188179964),
          s(773529912, 1546045734),
          s(1294757372, 1522805485),
          s(1396182291, 2643833823),
          s(1695183700, 2343527390),
          s(1986661051, 1014477480),
          s(2177026350, 1206759142),
          s(2456956037, 344077627),
          s(2730485921, 1290863460),
          s(2820302411, 3158454273),
          s(3259730800, 3505952657),
          s(3345764771, 106217008),
          s(3516065817, 3606008344),
          s(3600352804, 1432725776),
          s(4094571909, 1467031594),
          s(275423344, 851169720),
          s(430227734, 3100823752),
          s(506948616, 1363258195),
          s(659060556, 3750685593),
          s(883997877, 3785050280),
          s(958139571, 3318307427),
          s(1322822218, 3812723403),
          s(1537002063, 2003034995),
          s(1747873779, 3602036899),
          s(1955562222, 1575990012),
          s(2024104815, 1125592928),
          s(2227730452, 2716904306),
          s(2361852424, 442776044),
          s(2428436474, 593698344),
          s(2756734187, 3733110249),
          s(3204031479, 2999351573),
          s(3329325298, 3815920427),
          s(3391569614, 3928383900),
          s(3515267271, 566280711),
          s(3940187606, 3454069534),
          s(4118630271, 4000239992),
          s(116418474, 1914138554),
          s(174292421, 2731055270),
          s(289380356, 3203993006),
          s(460393269, 320620315),
          s(685471733, 587496836),
          s(852142971, 1086792851),
          s(1017036298, 365543100),
          s(1126000580, 2618297676),
          s(1288033470, 3409855158),
          s(1501505948, 4234509866),
          s(1607167915, 987167468),
          s(1816402316, 1246189591),
        ],
        xt = [];
      !(function () {
        for (var t = 0; t < 80; t++) xt[t] = s();
      })();
      var c = (o.SHA512 = e.extend({
        _doReset: function () {
          this._hash = new n.init([
            new i.init(1779033703, 4089235720),
            new i.init(3144134277, 2227873595),
            new i.init(1013904242, 4271175723),
            new i.init(2773480762, 1595750129),
            new i.init(1359893119, 2917565137),
            new i.init(2600822924, 725511199),
            new i.init(528734635, 4215389547),
            new i.init(1541459225, 327033209),
          ]);
        },
        _doProcessBlock: function (t, e) {
          for (
            var r = this._hash.words,
              i = r[0],
              n = r[1],
              o = r[2],
              s = r[3],
              c = r[4],
              a = r[5],
              h = r[6],
              l = r[7],
              f = i.high,
              d = i.low,
              u = n.high,
              p = n.low,
              _ = o.high,
              v = o.low,
              y = s.high,
              g = s.low,
              B = c.high,
              w = c.low,
              k = a.high,
              S = a.low,
              m = h.high,
              x = h.low,
              b = l.high,
              H = l.low,
              z = f,
              A = d,
              C = u,
              D = p,
              E = _,
              R = v,
              M = y,
              F = g,
              P = B,
              W = w,
              O = k,
              I = S,
              U = m,
              K = x,
              X = b,
              L = H,
              j = 0;
            j < 80;
            j++
          ) {
            var N,
              T,
              q = xt[j];
            if (j < 16)
              (T = q.high = 0 | t[e + 2 * j]),
                (N = q.low = 0 | t[e + 2 * j + 1]);
            else {
              var Z = xt[j - 15],
                V = Z.high,
                G = Z.low,
                J =
                  ((V >>> 1) | (G << 31)) ^ ((V >>> 8) | (G << 24)) ^ (V >>> 7),
                $ =
                  ((G >>> 1) | (V << 31)) ^
                  ((G >>> 8) | (V << 24)) ^
                  ((G >>> 7) | (V << 25)),
                Q = xt[j - 2],
                Y = Q.high,
                tt = Q.low,
                et =
                  ((Y >>> 19) | (tt << 13)) ^
                  ((Y << 3) | (tt >>> 29)) ^
                  (Y >>> 6),
                rt =
                  ((tt >>> 19) | (Y << 13)) ^
                  ((tt << 3) | (Y >>> 29)) ^
                  ((tt >>> 6) | (Y << 26)),
                it = xt[j - 7],
                nt = it.high,
                ot = it.low,
                st = xt[j - 16],
                ct = st.high,
                at = st.low;
              (T =
                (T =
                  (T = J + nt + ((N = $ + ot) >>> 0 < $ >>> 0 ? 1 : 0)) +
                  et +
                  ((N += rt) >>> 0 < rt >>> 0 ? 1 : 0)) +
                ct +
                ((N += at) >>> 0 < at >>> 0 ? 1 : 0)),
                (q.high = T),
                (q.low = N);
            }
            var ht,
              lt = (P & O) ^ (~P & U),
              ft = (W & I) ^ (~W & K),
              dt = (z & C) ^ (z & E) ^ (C & E),
              ut = (A & D) ^ (A & R) ^ (D & R),
              pt =
                ((z >>> 28) | (A << 4)) ^
                ((z << 30) | (A >>> 2)) ^
                ((z << 25) | (A >>> 7)),
              _t =
                ((A >>> 28) | (z << 4)) ^
                ((A << 30) | (z >>> 2)) ^
                ((A << 25) | (z >>> 7)),
              vt =
                ((P >>> 14) | (W << 18)) ^
                ((P >>> 18) | (W << 14)) ^
                ((P << 23) | (W >>> 9)),
              yt =
                ((W >>> 14) | (P << 18)) ^
                ((W >>> 18) | (P << 14)) ^
                ((W << 23) | (P >>> 9)),
              gt = mt[j],
              Bt = gt.high,
              wt = gt.low,
              kt = X + vt + ((ht = L + yt) >>> 0 < L >>> 0 ? 1 : 0),
              St = _t + ut;
            (X = U),
              (L = K),
              (U = O),
              (K = I),
              (O = P),
              (I = W),
              (P =
                (M +
                  (kt =
                    (kt =
                      (kt =
                        kt + lt + ((ht = ht + ft) >>> 0 < ft >>> 0 ? 1 : 0)) +
                      Bt +
                      ((ht = ht + wt) >>> 0 < wt >>> 0 ? 1 : 0)) +
                    T +
                    ((ht = ht + N) >>> 0 < N >>> 0 ? 1 : 0)) +
                  ((W = (F + ht) | 0) >>> 0 < F >>> 0 ? 1 : 0)) |
                0),
              (M = E),
              (F = R),
              (E = C),
              (R = D),
              (C = z),
              (D = A),
              (z =
                (kt +
                  (pt + dt + (St >>> 0 < _t >>> 0 ? 1 : 0)) +
                  ((A = (ht + St) | 0) >>> 0 < ht >>> 0 ? 1 : 0)) |
                0);
          }
          (d = i.low = d + A),
            (i.high = f + z + (d >>> 0 < A >>> 0 ? 1 : 0)),
            (p = n.low = p + D),
            (n.high = u + C + (p >>> 0 < D >>> 0 ? 1 : 0)),
            (v = o.low = v + R),
            (o.high = _ + E + (v >>> 0 < R >>> 0 ? 1 : 0)),
            (g = s.low = g + F),
            (s.high = y + M + (g >>> 0 < F >>> 0 ? 1 : 0)),
            (w = c.low = w + W),
            (c.high = B + P + (w >>> 0 < W >>> 0 ? 1 : 0)),
            (S = a.low = S + I),
            (a.high = k + O + (S >>> 0 < I >>> 0 ? 1 : 0)),
            (x = h.low = x + K),
            (h.high = m + U + (x >>> 0 < K >>> 0 ? 1 : 0)),
            (H = l.low = H + L),
            (l.high = b + X + (H >>> 0 < L >>> 0 ? 1 : 0));
        },
        _doFinalize: function () {
          var t = this._data,
            e = t.words,
            r = 8 * this._nDataBytes,
            i = 8 * t.sigBytes;
          return (
            (e[i >>> 5] |= 128 << (24 - (i % 32))),
            (e[30 + (((128 + i) >>> 10) << 5)] = Math.floor(r / 4294967296)),
            (e[31 + (((128 + i) >>> 10) << 5)] = r),
            (t.sigBytes = 4 * e.length),
            this._process(),
            this._hash.toX32()
          );
        },
        clone: function () {
          var t = e.clone.call(this);
          return (t._hash = this._hash.clone()), t;
        },
        blockSize: 32,
      }));
      (t.SHA512 = e._createHelper(c)), (t.HmacSHA512 = e._createHmacHelper(c));
    })(),
    (Z = (q = bt).x64),
    (V = Z.Word),
    (G = Z.WordArray),
    (J = q.algo),
    ($ = J.SHA512),
    (Q = J.SHA384 = $.extend({
      _doReset: function () {
        this._hash = new G.init([
          new V.init(3418070365, 3238371032),
          new V.init(1654270250, 914150663),
          new V.init(2438529370, 812702999),
          new V.init(355462360, 4144912697),
          new V.init(1731405415, 4290775857),
          new V.init(2394180231, 1750603025),
          new V.init(3675008525, 1694076839),
          new V.init(1203062813, 3204075428),
        ]);
      },
      _doFinalize: function () {
        var t = $._doFinalize.call(this);
        return (t.sigBytes -= 16), t;
      },
    })),
    (q.SHA384 = $._createHelper(Q)),
    (q.HmacSHA384 = $._createHmacHelper(Q)),
    bt.lib.Cipher ||
      (function () {
        var t = bt,
          e = t.lib,
          r = e.Base,
          a = e.WordArray,
          i = e.BufferedBlockAlgorithm,
          n = t.enc,
          o = (n.Utf8, n.Base64),
          s = t.algo.EvpKDF,
          c = (e.Cipher = i.extend({
            cfg: r.extend(),
            createEncryptor: function (t, e) {
              return this.create(this._ENC_XFORM_MODE, t, e);
            },
            createDecryptor: function (t, e) {
              return this.create(this._DEC_XFORM_MODE, t, e);
            },
            init: function (t, e, r) {
              (this.cfg = this.cfg.extend(r)),
                (this._xformMode = t),
                (this._key = e),
                this.reset();
            },
            reset: function () {
              i.reset.call(this), this._doReset();
            },
            process: function (t) {
              return this._append(t), this._process();
            },
            finalize: function (t) {
              return t && this._append(t), this._doFinalize();
            },
            keySize: 4,
            ivSize: 4,
            _ENC_XFORM_MODE: 1,
            _DEC_XFORM_MODE: 2,
            _createHelper: function (i) {
              return {
                encrypt: function (t, e, r) {
                  return h(e).encrypt(i, t, e, r);
                },
                decrypt: function (t, e, r) {
                  return h(e).decrypt(i, t, e, r);
                },
              };
            },
          }));
        function h(t) {
          return "string" == typeof t ? w : g;
        }
        e.StreamCipher = c.extend({
          _doFinalize: function () {
            return this._process(!0);
          },
          blockSize: 1,
        });
        var l,
          f = (t.mode = {}),
          d = (e.BlockCipherMode = r.extend({
            createEncryptor: function (t, e) {
              return this.Encryptor.create(t, e);
            },
            createDecryptor: function (t, e) {
              return this.Decryptor.create(t, e);
            },
            init: function (t, e) {
              (this._cipher = t), (this._iv = e);
            },
          })),
          u = (f.CBC =
            (((l = d.extend()).Encryptor = l.extend({
              processBlock: function (t, e) {
                var r = this._cipher,
                  i = r.blockSize;
                p.call(this, t, e, i),
                  r.encryptBlock(t, e),
                  (this._prevBlock = t.slice(e, e + i));
              },
            })),
            (l.Decryptor = l.extend({
              processBlock: function (t, e) {
                var r = this._cipher,
                  i = r.blockSize,
                  n = t.slice(e, e + i);
                r.decryptBlock(t, e),
                  p.call(this, t, e, i),
                  (this._prevBlock = n);
              },
            })),
            l));
        function p(t, e, r) {
          var i,
            n = this._iv;
          n ? ((i = n), (this._iv = void 0)) : (i = this._prevBlock);
          for (var o = 0; o < r; o++) t[e + o] ^= i[o];
        }
        var _ = ((t.pad = {}).Pkcs7 = {
            pad: function (t, e) {
              for (
                var r = 4 * e,
                  i = r - (t.sigBytes % r),
                  n = (i << 24) | (i << 16) | (i << 8) | i,
                  o = [],
                  s = 0;
                s < i;
                s += 4
              )
                o.push(n);
              var c = a.create(o, i);
              t.concat(c);
            },
            unpad: function (t) {
              var e = 255 & t.words[(t.sigBytes - 1) >>> 2];
              t.sigBytes -= e;
            },
          }),
          v =
            ((e.BlockCipher = c.extend({
              cfg: c.cfg.extend({ mode: u, padding: _ }),
              reset: function () {
                var t;
                c.reset.call(this);
                var e = this.cfg,
                  r = e.iv,
                  i = e.mode;
                this._xformMode == this._ENC_XFORM_MODE
                  ? (t = i.createEncryptor)
                  : ((t = i.createDecryptor), (this._minBufferSize = 1)),
                  this._mode && this._mode.__creator == t
                    ? this._mode.init(this, r && r.words)
                    : ((this._mode = t.call(i, this, r && r.words)),
                      (this._mode.__creator = t));
              },
              _doProcessBlock: function (t, e) {
                this._mode.processBlock(t, e);
              },
              _doFinalize: function () {
                var t,
                  e = this.cfg.padding;
                return (
                  this._xformMode == this._ENC_XFORM_MODE
                    ? (e.pad(this._data, this.blockSize),
                      (t = this._process(!0)))
                    : ((t = this._process(!0)), e.unpad(t)),
                  t
                );
              },
              blockSize: 4,
            })),
            (e.CipherParams = r.extend({
              init: function (t) {
                this.mixIn(t);
              },
              toString: function (t) {
                return (t || this.formatter).stringify(this);
              },
            }))),
          y = ((t.format = {}).OpenSSL = {
            stringify: function (t) {
              var e = t.ciphertext,
                r = t.salt;
              return (r
                ? a.create([1398893684, 1701076831]).concat(r).concat(e)
                : e
              ).toString(o);
            },
            parse: function (t) {
              var e,
                r = o.parse(t),
                i = r.words;
              return (
                1398893684 == i[0] &&
                  1701076831 == i[1] &&
                  ((e = a.create(i.slice(2, 4))),
                  i.splice(0, 4),
                  (r.sigBytes -= 16)),
                v.create({ ciphertext: r, salt: e })
              );
            },
          }),
          g = (e.SerializableCipher = r.extend({
            cfg: r.extend({ format: y }),
            encrypt: function (t, e, r, i) {
              i = this.cfg.extend(i);
              var n = t.createEncryptor(r, i),
                o = n.finalize(e),
                s = n.cfg;
              return v.create({
                ciphertext: o,
                key: r,
                iv: s.iv,
                algorithm: t,
                mode: s.mode,
                padding: s.padding,
                blockSize: t.blockSize,
                formatter: i.format,
              });
            },
            decrypt: function (t, e, r, i) {
              return (
                (i = this.cfg.extend(i)),
                (e = this._parse(e, i.format)),
                t.createDecryptor(r, i).finalize(e.ciphertext)
              );
            },
            _parse: function (t, e) {
              return "string" == typeof t ? e.parse(t, this) : t;
            },
          })),
          B = ((t.kdf = {}).OpenSSL = {
            execute: function (t, e, r, i) {
              i = i || a.random(8);
              var n = s.create({ keySize: e + r }).compute(t, i),
                o = a.create(n.words.slice(e), 4 * r);
              return (n.sigBytes = 4 * e), v.create({ key: n, iv: o, salt: i });
            },
          }),
          w = (e.PasswordBasedCipher = g.extend({
            cfg: g.cfg.extend({ kdf: B }),
            encrypt: function (t, e, r, i) {
              var n = (i = this.cfg.extend(i)).kdf.execute(
                r,
                t.keySize,
                t.ivSize
              );
              i.iv = n.iv;
              var o = g.encrypt.call(this, t, e, n.key, i);
              return o.mixIn(n), o;
            },
            decrypt: function (t, e, r, i) {
              (i = this.cfg.extend(i)), (e = this._parse(e, i.format));
              var n = i.kdf.execute(r, t.keySize, t.ivSize, e.salt);
              return (i.iv = n.iv), g.decrypt.call(this, t, e, n.key, i);
            },
          }));
      })(),
    (bt.mode.CFB =
      (((Y = bt.lib.BlockCipherMode.extend()).Encryptor = Y.extend({
        processBlock: function (t, e) {
          var r = this._cipher,
            i = r.blockSize;
          Dt.call(this, t, e, i, r), (this._prevBlock = t.slice(e, e + i));
        },
      })),
      (Y.Decryptor = Y.extend({
        processBlock: function (t, e) {
          var r = this._cipher,
            i = r.blockSize,
            n = t.slice(e, e + i);
          Dt.call(this, t, e, i, r), (this._prevBlock = n);
        },
      })),
      Y)),
    (bt.mode.ECB =
      (((tt = bt.lib.BlockCipherMode.extend()).Encryptor = tt.extend({
        processBlock: function (t, e) {
          this._cipher.encryptBlock(t, e);
        },
      })),
      (tt.Decryptor = tt.extend({
        processBlock: function (t, e) {
          this._cipher.decryptBlock(t, e);
        },
      })),
      tt)),
    (bt.pad.AnsiX923 = {
      pad: function (t, e) {
        var r = t.sigBytes,
          i = 4 * e,
          n = i - (r % i),
          o = r + n - 1;
        t.clamp(),
          (t.words[o >>> 2] |= n << (24 - (o % 4) * 8)),
          (t.sigBytes += n);
      },
      unpad: function (t) {
        var e = 255 & t.words[(t.sigBytes - 1) >>> 2];
        t.sigBytes -= e;
      },
    }),
    (bt.pad.Iso10126 = {
      pad: function (t, e) {
        var r = 4 * e,
          i = r - (t.sigBytes % r);
        t.concat(bt.lib.WordArray.random(i - 1)).concat(
          bt.lib.WordArray.create([i << 24], 1)
        );
      },
      unpad: function (t) {
        var e = 255 & t.words[(t.sigBytes - 1) >>> 2];
        t.sigBytes -= e;
      },
    }),
    (bt.pad.Iso97971 = {
      pad: function (t, e) {
        t.concat(bt.lib.WordArray.create([2147483648], 1)),
          bt.pad.ZeroPadding.pad(t, e);
      },
      unpad: function (t) {
        bt.pad.ZeroPadding.unpad(t), t.sigBytes--;
      },
    }),
    (bt.mode.OFB =
      ((et = bt.lib.BlockCipherMode.extend()),
      (rt = et.Encryptor = et.extend({
        processBlock: function (t, e) {
          var r = this._cipher,
            i = r.blockSize,
            n = this._iv,
            o = this._keystream;
          n && ((o = this._keystream = n.slice(0)), (this._iv = void 0)),
            r.encryptBlock(o, 0);
          for (var s = 0; s < i; s++) t[e + s] ^= o[s];
        },
      })),
      (et.Decryptor = rt),
      et)),
    (bt.pad.NoPadding = { pad: function () {}, unpad: function () {} }),
    (it = bt.lib.CipherParams),
    (nt = bt.enc.Hex),
    (bt.format.Hex = {
      stringify: function (t) {
        return t.ciphertext.toString(nt);
      },
      parse: function (t) {
        var e = nt.parse(t);
        return it.create({ ciphertext: e });
      },
    }),
    (function () {
      var t = bt,
        e = t.lib.BlockCipher,
        r = t.algo,
        h = [],
        l = [],
        f = [],
        d = [],
        u = [],
        p = [],
        _ = [],
        v = [],
        y = [],
        g = [];
      !(function () {
        for (var t = [], e = 0; e < 256; e++)
          t[e] = e < 128 ? e << 1 : (e << 1) ^ 283;
        var r = 0,
          i = 0;
        for (e = 0; e < 256; e++) {
          var n = i ^ (i << 1) ^ (i << 2) ^ (i << 3) ^ (i << 4);
          (n = (n >>> 8) ^ (255 & n) ^ 99), (h[r] = n);
          var o = t[(l[n] = r)],
            s = t[o],
            c = t[s],
            a = (257 * t[n]) ^ (16843008 * n);
          (f[r] = (a << 24) | (a >>> 8)),
            (d[r] = (a << 16) | (a >>> 16)),
            (u[r] = (a << 8) | (a >>> 24)),
            (p[r] = a);
          a = (16843009 * c) ^ (65537 * s) ^ (257 * o) ^ (16843008 * r);
          (_[n] = (a << 24) | (a >>> 8)),
            (v[n] = (a << 16) | (a >>> 16)),
            (y[n] = (a << 8) | (a >>> 24)),
            (g[n] = a),
            r ? ((r = o ^ t[t[t[c ^ o]]]), (i ^= t[t[i]])) : (r = i = 1);
        }
      })();
      var B = [0, 1, 2, 4, 8, 16, 32, 64, 128, 27, 54],
        i = (r.AES = e.extend({
          _doReset: function () {
            if (!this._nRounds || this._keyPriorReset !== this._key) {
              for (
                var t = (this._keyPriorReset = this._key),
                  e = t.words,
                  r = t.sigBytes / 4,
                  i = 4 * (1 + (this._nRounds = 6 + r)),
                  n = (this._keySchedule = []),
                  o = 0;
                o < i;
                o++
              )
                o < r
                  ? (n[o] = e[o])
                  : ((a = n[o - 1]),
                    o % r
                      ? 6 < r &&
                        o % r == 4 &&
                        (a =
                          (h[a >>> 24] << 24) |
                          (h[(a >>> 16) & 255] << 16) |
                          (h[(a >>> 8) & 255] << 8) |
                          h[255 & a])
                      : ((a =
                          (h[(a = (a << 8) | (a >>> 24)) >>> 24] << 24) |
                          (h[(a >>> 16) & 255] << 16) |
                          (h[(a >>> 8) & 255] << 8) |
                          h[255 & a]),
                        (a ^= B[(o / r) | 0] << 24)),
                    (n[o] = n[o - r] ^ a));
              for (var s = (this._invKeySchedule = []), c = 0; c < i; c++) {
                o = i - c;
                if (c % 4) var a = n[o];
                else a = n[o - 4];
                s[c] =
                  c < 4 || o <= 4
                    ? a
                    : _[h[a >>> 24]] ^
                      v[h[(a >>> 16) & 255]] ^
                      y[h[(a >>> 8) & 255]] ^
                      g[h[255 & a]];
              }
            }
          },
          encryptBlock: function (t, e) {
            this._doCryptBlock(t, e, this._keySchedule, f, d, u, p, h);
          },
          decryptBlock: function (t, e) {
            var r = t[e + 1];
            (t[e + 1] = t[e + 3]),
              (t[e + 3] = r),
              this._doCryptBlock(t, e, this._invKeySchedule, _, v, y, g, l);
            r = t[e + 1];
            (t[e + 1] = t[e + 3]), (t[e + 3] = r);
          },
          _doCryptBlock: function (t, e, r, i, n, o, s, c) {
            for (
              var a = this._nRounds,
                h = t[e] ^ r[0],
                l = t[e + 1] ^ r[1],
                f = t[e + 2] ^ r[2],
                d = t[e + 3] ^ r[3],
                u = 4,
                p = 1;
              p < a;
              p++
            ) {
              var _ =
                  i[h >>> 24] ^
                  n[(l >>> 16) & 255] ^
                  o[(f >>> 8) & 255] ^
                  s[255 & d] ^
                  r[u++],
                v =
                  i[l >>> 24] ^
                  n[(f >>> 16) & 255] ^
                  o[(d >>> 8) & 255] ^
                  s[255 & h] ^
                  r[u++],
                y =
                  i[f >>> 24] ^
                  n[(d >>> 16) & 255] ^
                  o[(h >>> 8) & 255] ^
                  s[255 & l] ^
                  r[u++],
                g =
                  i[d >>> 24] ^
                  n[(h >>> 16) & 255] ^
                  o[(l >>> 8) & 255] ^
                  s[255 & f] ^
                  r[u++];
              (h = _), (l = v), (f = y), (d = g);
            }
            (_ =
              ((c[h >>> 24] << 24) |
                (c[(l >>> 16) & 255] << 16) |
                (c[(f >>> 8) & 255] << 8) |
                c[255 & d]) ^
              r[u++]),
              (v =
                ((c[l >>> 24] << 24) |
                  (c[(f >>> 16) & 255] << 16) |
                  (c[(d >>> 8) & 255] << 8) |
                  c[255 & h]) ^
                r[u++]),
              (y =
                ((c[f >>> 24] << 24) |
                  (c[(d >>> 16) & 255] << 16) |
                  (c[(h >>> 8) & 255] << 8) |
                  c[255 & l]) ^
                r[u++]),
              (g =
                ((c[d >>> 24] << 24) |
                  (c[(h >>> 16) & 255] << 16) |
                  (c[(l >>> 8) & 255] << 8) |
                  c[255 & f]) ^
                r[u++]);
            (t[e] = _), (t[e + 1] = v), (t[e + 2] = y), (t[e + 3] = g);
          },
          keySize: 8,
        }));
      t.AES = e._createHelper(i);
    })(),
    (function () {
      var t = bt,
        e = t.lib,
        n = e.WordArray,
        r = e.BlockCipher,
        i = t.algo,
        h = [
          57,
          49,
          41,
          33,
          25,
          17,
          9,
          1,
          58,
          50,
          42,
          34,
          26,
          18,
          10,
          2,
          59,
          51,
          43,
          35,
          27,
          19,
          11,
          3,
          60,
          52,
          44,
          36,
          63,
          55,
          47,
          39,
          31,
          23,
          15,
          7,
          62,
          54,
          46,
          38,
          30,
          22,
          14,
          6,
          61,
          53,
          45,
          37,
          29,
          21,
          13,
          5,
          28,
          20,
          12,
          4,
        ],
        l = [
          14,
          17,
          11,
          24,
          1,
          5,
          3,
          28,
          15,
          6,
          21,
          10,
          23,
          19,
          12,
          4,
          26,
          8,
          16,
          7,
          27,
          20,
          13,
          2,
          41,
          52,
          31,
          37,
          47,
          55,
          30,
          40,
          51,
          45,
          33,
          48,
          44,
          49,
          39,
          56,
          34,
          53,
          46,
          42,
          50,
          36,
          29,
          32,
        ],
        f = [1, 2, 4, 6, 8, 10, 12, 14, 15, 17, 19, 21, 23, 25, 27, 28],
        d = [
          {
            0: 8421888,
            268435456: 32768,
            536870912: 8421378,
            805306368: 2,
            1073741824: 512,
            1342177280: 8421890,
            1610612736: 8389122,
            1879048192: 8388608,
            2147483648: 514,
            2415919104: 8389120,
            2684354560: 33280,
            2952790016: 8421376,
            3221225472: 32770,
            3489660928: 8388610,
            3758096384: 0,
            4026531840: 33282,
            134217728: 0,
            402653184: 8421890,
            671088640: 33282,
            939524096: 32768,
            1207959552: 8421888,
            1476395008: 512,
            1744830464: 8421378,
            2013265920: 2,
            2281701376: 8389120,
            2550136832: 33280,
            2818572288: 8421376,
            3087007744: 8389122,
            3355443200: 8388610,
            3623878656: 32770,
            3892314112: 514,
            4160749568: 8388608,
            1: 32768,
            268435457: 2,
            536870913: 8421888,
            805306369: 8388608,
            1073741825: 8421378,
            1342177281: 33280,
            1610612737: 512,
            1879048193: 8389122,
            2147483649: 8421890,
            2415919105: 8421376,
            2684354561: 8388610,
            2952790017: 33282,
            3221225473: 514,
            3489660929: 8389120,
            3758096385: 32770,
            4026531841: 0,
            134217729: 8421890,
            402653185: 8421376,
            671088641: 8388608,
            939524097: 512,
            1207959553: 32768,
            1476395009: 8388610,
            1744830465: 2,
            2013265921: 33282,
            2281701377: 32770,
            2550136833: 8389122,
            2818572289: 514,
            3087007745: 8421888,
            3355443201: 8389120,
            3623878657: 0,
            3892314113: 33280,
            4160749569: 8421378,
          },
          {
            0: 1074282512,
            16777216: 16384,
            33554432: 524288,
            50331648: 1074266128,
            67108864: 1073741840,
            83886080: 1074282496,
            100663296: 1073758208,
            117440512: 16,
            134217728: 540672,
            150994944: 1073758224,
            167772160: 1073741824,
            184549376: 540688,
            201326592: 524304,
            218103808: 0,
            234881024: 16400,
            251658240: 1074266112,
            8388608: 1073758208,
            25165824: 540688,
            41943040: 16,
            58720256: 1073758224,
            75497472: 1074282512,
            92274688: 1073741824,
            109051904: 524288,
            125829120: 1074266128,
            142606336: 524304,
            159383552: 0,
            176160768: 16384,
            192937984: 1074266112,
            209715200: 1073741840,
            226492416: 540672,
            243269632: 1074282496,
            260046848: 16400,
            268435456: 0,
            285212672: 1074266128,
            301989888: 1073758224,
            318767104: 1074282496,
            335544320: 1074266112,
            352321536: 16,
            369098752: 540688,
            385875968: 16384,
            402653184: 16400,
            419430400: 524288,
            436207616: 524304,
            452984832: 1073741840,
            469762048: 540672,
            486539264: 1073758208,
            503316480: 1073741824,
            520093696: 1074282512,
            276824064: 540688,
            293601280: 524288,
            310378496: 1074266112,
            327155712: 16384,
            343932928: 1073758208,
            360710144: 1074282512,
            377487360: 16,
            394264576: 1073741824,
            411041792: 1074282496,
            427819008: 1073741840,
            444596224: 1073758224,
            461373440: 524304,
            478150656: 0,
            494927872: 16400,
            511705088: 1074266128,
            528482304: 540672,
          },
          {
            0: 260,
            1048576: 0,
            2097152: 67109120,
            3145728: 65796,
            4194304: 65540,
            5242880: 67108868,
            6291456: 67174660,
            7340032: 67174400,
            8388608: 67108864,
            9437184: 67174656,
            10485760: 65792,
            11534336: 67174404,
            12582912: 67109124,
            13631488: 65536,
            14680064: 4,
            15728640: 256,
            524288: 67174656,
            1572864: 67174404,
            2621440: 0,
            3670016: 67109120,
            4718592: 67108868,
            5767168: 65536,
            6815744: 65540,
            7864320: 260,
            8912896: 4,
            9961472: 256,
            11010048: 67174400,
            12058624: 65796,
            13107200: 65792,
            14155776: 67109124,
            15204352: 67174660,
            16252928: 67108864,
            16777216: 67174656,
            17825792: 65540,
            18874368: 65536,
            19922944: 67109120,
            20971520: 256,
            22020096: 67174660,
            23068672: 67108868,
            24117248: 0,
            25165824: 67109124,
            26214400: 67108864,
            27262976: 4,
            28311552: 65792,
            29360128: 67174400,
            30408704: 260,
            31457280: 65796,
            32505856: 67174404,
            17301504: 67108864,
            18350080: 260,
            19398656: 67174656,
            20447232: 0,
            21495808: 65540,
            22544384: 67109120,
            23592960: 256,
            24641536: 67174404,
            25690112: 65536,
            26738688: 67174660,
            27787264: 65796,
            28835840: 67108868,
            29884416: 67109124,
            30932992: 67174400,
            31981568: 4,
            33030144: 65792,
          },
          {
            0: 2151682048,
            65536: 2147487808,
            131072: 4198464,
            196608: 2151677952,
            262144: 0,
            327680: 4198400,
            393216: 2147483712,
            458752: 4194368,
            524288: 2147483648,
            589824: 4194304,
            655360: 64,
            720896: 2147487744,
            786432: 2151678016,
            851968: 4160,
            917504: 4096,
            983040: 2151682112,
            32768: 2147487808,
            98304: 64,
            163840: 2151678016,
            229376: 2147487744,
            294912: 4198400,
            360448: 2151682112,
            425984: 0,
            491520: 2151677952,
            557056: 4096,
            622592: 2151682048,
            688128: 4194304,
            753664: 4160,
            819200: 2147483648,
            884736: 4194368,
            950272: 4198464,
            1015808: 2147483712,
            1048576: 4194368,
            1114112: 4198400,
            1179648: 2147483712,
            1245184: 0,
            1310720: 4160,
            1376256: 2151678016,
            1441792: 2151682048,
            1507328: 2147487808,
            1572864: 2151682112,
            1638400: 2147483648,
            1703936: 2151677952,
            1769472: 4198464,
            1835008: 2147487744,
            1900544: 4194304,
            1966080: 64,
            2031616: 4096,
            1081344: 2151677952,
            1146880: 2151682112,
            1212416: 0,
            1277952: 4198400,
            1343488: 4194368,
            1409024: 2147483648,
            1474560: 2147487808,
            1540096: 64,
            1605632: 2147483712,
            1671168: 4096,
            1736704: 2147487744,
            1802240: 2151678016,
            1867776: 4160,
            1933312: 2151682048,
            1998848: 4194304,
            2064384: 4198464,
          },
          {
            0: 128,
            4096: 17039360,
            8192: 262144,
            12288: 536870912,
            16384: 537133184,
            20480: 16777344,
            24576: 553648256,
            28672: 262272,
            32768: 16777216,
            36864: 537133056,
            40960: 536871040,
            45056: 553910400,
            49152: 553910272,
            53248: 0,
            57344: 17039488,
            61440: 553648128,
            2048: 17039488,
            6144: 553648256,
            10240: 128,
            14336: 17039360,
            18432: 262144,
            22528: 537133184,
            26624: 553910272,
            30720: 536870912,
            34816: 537133056,
            38912: 0,
            43008: 553910400,
            47104: 16777344,
            51200: 536871040,
            55296: 553648128,
            59392: 16777216,
            63488: 262272,
            65536: 262144,
            69632: 128,
            73728: 536870912,
            77824: 553648256,
            81920: 16777344,
            86016: 553910272,
            90112: 537133184,
            94208: 16777216,
            98304: 553910400,
            102400: 553648128,
            106496: 17039360,
            110592: 537133056,
            114688: 262272,
            118784: 536871040,
            122880: 0,
            126976: 17039488,
            67584: 553648256,
            71680: 16777216,
            75776: 17039360,
            79872: 537133184,
            83968: 536870912,
            88064: 17039488,
            92160: 128,
            96256: 553910272,
            100352: 262272,
            104448: 553910400,
            108544: 0,
            112640: 553648128,
            116736: 16777344,
            120832: 262144,
            124928: 537133056,
            129024: 536871040,
          },
          {
            0: 268435464,
            256: 8192,
            512: 270532608,
            768: 270540808,
            1024: 268443648,
            1280: 2097152,
            1536: 2097160,
            1792: 268435456,
            2048: 0,
            2304: 268443656,
            2560: 2105344,
            2816: 8,
            3072: 270532616,
            3328: 2105352,
            3584: 8200,
            3840: 270540800,
            128: 270532608,
            384: 270540808,
            640: 8,
            896: 2097152,
            1152: 2105352,
            1408: 268435464,
            1664: 268443648,
            1920: 8200,
            2176: 2097160,
            2432: 8192,
            2688: 268443656,
            2944: 270532616,
            3200: 0,
            3456: 270540800,
            3712: 2105344,
            3968: 268435456,
            4096: 268443648,
            4352: 270532616,
            4608: 270540808,
            4864: 8200,
            5120: 2097152,
            5376: 268435456,
            5632: 268435464,
            5888: 2105344,
            6144: 2105352,
            6400: 0,
            6656: 8,
            6912: 270532608,
            7168: 8192,
            7424: 268443656,
            7680: 270540800,
            7936: 2097160,
            4224: 8,
            4480: 2105344,
            4736: 2097152,
            4992: 268435464,
            5248: 268443648,
            5504: 8200,
            5760: 270540808,
            6016: 270532608,
            6272: 270540800,
            6528: 270532616,
            6784: 8192,
            7040: 2105352,
            7296: 2097160,
            7552: 0,
            7808: 268435456,
            8064: 268443656,
          },
          {
            0: 1048576,
            16: 33555457,
            32: 1024,
            48: 1049601,
            64: 34604033,
            80: 0,
            96: 1,
            112: 34603009,
            128: 33555456,
            144: 1048577,
            160: 33554433,
            176: 34604032,
            192: 34603008,
            208: 1025,
            224: 1049600,
            240: 33554432,
            8: 34603009,
            24: 0,
            40: 33555457,
            56: 34604032,
            72: 1048576,
            88: 33554433,
            104: 33554432,
            120: 1025,
            136: 1049601,
            152: 33555456,
            168: 34603008,
            184: 1048577,
            200: 1024,
            216: 34604033,
            232: 1,
            248: 1049600,
            256: 33554432,
            272: 1048576,
            288: 33555457,
            304: 34603009,
            320: 1048577,
            336: 33555456,
            352: 34604032,
            368: 1049601,
            384: 1025,
            400: 34604033,
            416: 1049600,
            432: 1,
            448: 0,
            464: 34603008,
            480: 33554433,
            496: 1024,
            264: 1049600,
            280: 33555457,
            296: 34603009,
            312: 1,
            328: 33554432,
            344: 1048576,
            360: 1025,
            376: 34604032,
            392: 33554433,
            408: 34603008,
            424: 0,
            440: 34604033,
            456: 1049601,
            472: 1024,
            488: 33555456,
            504: 1048577,
          },
          {
            0: 134219808,
            1: 131072,
            2: 134217728,
            3: 32,
            4: 131104,
            5: 134350880,
            6: 134350848,
            7: 2048,
            8: 134348800,
            9: 134219776,
            10: 133120,
            11: 134348832,
            12: 2080,
            13: 0,
            14: 134217760,
            15: 133152,
            2147483648: 2048,
            2147483649: 134350880,
            2147483650: 134219808,
            2147483651: 134217728,
            2147483652: 134348800,
            2147483653: 133120,
            2147483654: 133152,
            2147483655: 32,
            2147483656: 134217760,
            2147483657: 2080,
            2147483658: 131104,
            2147483659: 134350848,
            2147483660: 0,
            2147483661: 134348832,
            2147483662: 134219776,
            2147483663: 131072,
            16: 133152,
            17: 134350848,
            18: 32,
            19: 2048,
            20: 134219776,
            21: 134217760,
            22: 134348832,
            23: 131072,
            24: 0,
            25: 131104,
            26: 134348800,
            27: 134219808,
            28: 134350880,
            29: 133120,
            30: 2080,
            31: 134217728,
            2147483664: 131072,
            2147483665: 2048,
            2147483666: 134348832,
            2147483667: 133152,
            2147483668: 32,
            2147483669: 134348800,
            2147483670: 134217728,
            2147483671: 134219808,
            2147483672: 134350880,
            2147483673: 134217760,
            2147483674: 134219776,
            2147483675: 0,
            2147483676: 133120,
            2147483677: 2080,
            2147483678: 131104,
            2147483679: 134350848,
          },
        ],
        u = [
          4160749569,
          528482304,
          33030144,
          2064384,
          129024,
          8064,
          504,
          2147483679,
        ],
        o = (i.DES = r.extend({
          _doReset: function () {
            for (var t = this._key.words, e = [], r = 0; r < 56; r++) {
              var i = h[r] - 1;
              e[r] = (t[i >>> 5] >>> (31 - (i % 32))) & 1;
            }
            for (var n = (this._subKeys = []), o = 0; o < 16; o++) {
              var s = (n[o] = []),
                c = f[o];
              for (r = 0; r < 24; r++)
                (s[(r / 6) | 0] |= e[(l[r] - 1 + c) % 28] << (31 - (r % 6))),
                  (s[4 + ((r / 6) | 0)] |=
                    e[28 + ((l[r + 24] - 1 + c) % 28)] << (31 - (r % 6)));
              s[0] = (s[0] << 1) | (s[0] >>> 31);
              for (r = 1; r < 7; r++) s[r] = s[r] >>> (4 * (r - 1) + 3);
              s[7] = (s[7] << 5) | (s[7] >>> 27);
            }
            var a = (this._invSubKeys = []);
            for (r = 0; r < 16; r++) a[r] = n[15 - r];
          },
          encryptBlock: function (t, e) {
            this._doCryptBlock(t, e, this._subKeys);
          },
          decryptBlock: function (t, e) {
            this._doCryptBlock(t, e, this._invSubKeys);
          },
          _doCryptBlock: function (t, e, r) {
            (this._lBlock = t[e]),
              (this._rBlock = t[e + 1]),
              p.call(this, 4, 252645135),
              p.call(this, 16, 65535),
              _.call(this, 2, 858993459),
              _.call(this, 8, 16711935),
              p.call(this, 1, 1431655765);
            for (var i = 0; i < 16; i++) {
              for (
                var n = r[i], o = this._lBlock, s = this._rBlock, c = 0, a = 0;
                a < 8;
                a++
              )
                c |= d[a][((s ^ n[a]) & u[a]) >>> 0];
              (this._lBlock = s), (this._rBlock = o ^ c);
            }
            var h = this._lBlock;
            (this._lBlock = this._rBlock),
              (this._rBlock = h),
              p.call(this, 1, 1431655765),
              _.call(this, 8, 16711935),
              _.call(this, 2, 858993459),
              p.call(this, 16, 65535),
              p.call(this, 4, 252645135),
              (t[e] = this._lBlock),
              (t[e + 1] = this._rBlock);
          },
          keySize: 2,
          ivSize: 2,
          blockSize: 2,
        }));
      function p(t, e) {
        var r = ((this._lBlock >>> t) ^ this._rBlock) & e;
        (this._rBlock ^= r), (this._lBlock ^= r << t);
      }
      function _(t, e) {
        var r = ((this._rBlock >>> t) ^ this._lBlock) & e;
        (this._lBlock ^= r), (this._rBlock ^= r << t);
      }
      t.DES = r._createHelper(o);
      var s = (i.TripleDES = r.extend({
        _doReset: function () {
          var t = this._key.words;
          if (2 !== t.length && 4 !== t.length && t.length < 6)
            throw new Error(
              "Invalid key length - 3DES requires the key length to be 64, 128, 192 or >192."
            );
          var e = t.slice(0, 2),
            r = t.length < 4 ? t.slice(0, 2) : t.slice(2, 4),
            i = t.length < 6 ? t.slice(0, 2) : t.slice(4, 6);
          (this._des1 = o.createEncryptor(n.create(e))),
            (this._des2 = o.createEncryptor(n.create(r))),
            (this._des3 = o.createEncryptor(n.create(i)));
        },
        encryptBlock: function (t, e) {
          this._des1.encryptBlock(t, e),
            this._des2.decryptBlock(t, e),
            this._des3.encryptBlock(t, e);
        },
        decryptBlock: function (t, e) {
          this._des3.decryptBlock(t, e),
            this._des2.encryptBlock(t, e),
            this._des1.decryptBlock(t, e);
        },
        keySize: 6,
        ivSize: 2,
        blockSize: 2,
      }));
      t.TripleDES = r._createHelper(s);
    })(),
    (function () {
      var t = bt,
        e = t.lib.StreamCipher,
        r = t.algo,
        i = (r.RC4 = e.extend({
          _doReset: function () {
            for (
              var t = this._key,
                e = t.words,
                r = t.sigBytes,
                i = (this._S = []),
                n = 0;
              n < 256;
              n++
            )
              i[n] = n;
            n = 0;
            for (var o = 0; n < 256; n++) {
              var s = n % r,
                c = (e[s >>> 2] >>> (24 - (s % 4) * 8)) & 255;
              o = (o + i[n] + c) % 256;
              var a = i[n];
              (i[n] = i[o]), (i[o] = a);
            }
            this._i = this._j = 0;
          },
          _doProcessBlock: function (t, e) {
            t[e] ^= n.call(this);
          },
          keySize: 8,
          ivSize: 0,
        }));
      function n() {
        for (
          var t = this._S, e = this._i, r = this._j, i = 0, n = 0;
          n < 4;
          n++
        ) {
          r = (r + t[(e = (e + 1) % 256)]) % 256;
          var o = t[e];
          (t[e] = t[r]),
            (t[r] = o),
            (i |= t[(t[e] + t[r]) % 256] << (24 - 8 * n));
        }
        return (this._i = e), (this._j = r), i;
      }
      t.RC4 = e._createHelper(i);
      var o = (r.RC4Drop = i.extend({
        cfg: i.cfg.extend({ drop: 192 }),
        _doReset: function () {
          i._doReset.call(this);
          for (var t = this.cfg.drop; 0 < t; t--) n.call(this);
        },
      }));
      t.RC4Drop = e._createHelper(o);
    })(),
    (bt.mode.CTRGladman =
      ((ot = bt.lib.BlockCipherMode.extend()),
      (st = ot.Encryptor = ot.extend({
        processBlock: function (t, e) {
          var r,
            i = this._cipher,
            n = i.blockSize,
            o = this._iv,
            s = this._counter;
          o && ((s = this._counter = o.slice(0)), (this._iv = void 0)),
            0 === ((r = s)[0] = Et(r[0])) && (r[1] = Et(r[1]));
          var c = s.slice(0);
          i.encryptBlock(c, 0);
          for (var a = 0; a < n; a++) t[e + a] ^= c[a];
        },
      })),
      (ot.Decryptor = st),
      ot)),
    (at = (ct = bt).lib.StreamCipher),
    (ht = ct.algo),
    (lt = []),
    (ft = []),
    (dt = []),
    (ut = ht.Rabbit = at.extend({
      _doReset: function () {
        for (var t = this._key.words, e = this.cfg.iv, r = 0; r < 4; r++)
          t[r] =
            (16711935 & ((t[r] << 8) | (t[r] >>> 24))) |
            (4278255360 & ((t[r] << 24) | (t[r] >>> 8)));
        var i = (this._X = [
            t[0],
            (t[3] << 16) | (t[2] >>> 16),
            t[1],
            (t[0] << 16) | (t[3] >>> 16),
            t[2],
            (t[1] << 16) | (t[0] >>> 16),
            t[3],
            (t[2] << 16) | (t[1] >>> 16),
          ]),
          n = (this._C = [
            (t[2] << 16) | (t[2] >>> 16),
            (4294901760 & t[0]) | (65535 & t[1]),
            (t[3] << 16) | (t[3] >>> 16),
            (4294901760 & t[1]) | (65535 & t[2]),
            (t[0] << 16) | (t[0] >>> 16),
            (4294901760 & t[2]) | (65535 & t[3]),
            (t[1] << 16) | (t[1] >>> 16),
            (4294901760 & t[3]) | (65535 & t[0]),
          ]);
        for (r = this._b = 0; r < 4; r++) Rt.call(this);
        for (r = 0; r < 8; r++) n[r] ^= i[(r + 4) & 7];
        if (e) {
          var o = e.words,
            s = o[0],
            c = o[1],
            a =
              (16711935 & ((s << 8) | (s >>> 24))) |
              (4278255360 & ((s << 24) | (s >>> 8))),
            h =
              (16711935 & ((c << 8) | (c >>> 24))) |
              (4278255360 & ((c << 24) | (c >>> 8))),
            l = (a >>> 16) | (4294901760 & h),
            f = (h << 16) | (65535 & a);
          (n[0] ^= a),
            (n[1] ^= l),
            (n[2] ^= h),
            (n[3] ^= f),
            (n[4] ^= a),
            (n[5] ^= l),
            (n[6] ^= h),
            (n[7] ^= f);
          for (r = 0; r < 4; r++) Rt.call(this);
        }
      },
      _doProcessBlock: function (t, e) {
        var r = this._X;
        Rt.call(this),
          (lt[0] = r[0] ^ (r[5] >>> 16) ^ (r[3] << 16)),
          (lt[1] = r[2] ^ (r[7] >>> 16) ^ (r[5] << 16)),
          (lt[2] = r[4] ^ (r[1] >>> 16) ^ (r[7] << 16)),
          (lt[3] = r[6] ^ (r[3] >>> 16) ^ (r[1] << 16));
        for (var i = 0; i < 4; i++)
          (lt[i] =
            (16711935 & ((lt[i] << 8) | (lt[i] >>> 24))) |
            (4278255360 & ((lt[i] << 24) | (lt[i] >>> 8)))),
            (t[e + i] ^= lt[i]);
      },
      blockSize: 4,
      ivSize: 2,
    })),
    (ct.Rabbit = at._createHelper(ut)),
    (bt.mode.CTR =
      ((pt = bt.lib.BlockCipherMode.extend()),
      (_t = pt.Encryptor = pt.extend({
        processBlock: function (t, e) {
          var r = this._cipher,
            i = r.blockSize,
            n = this._iv,
            o = this._counter;
          n && ((o = this._counter = n.slice(0)), (this._iv = void 0));
          var s = o.slice(0);
          r.encryptBlock(s, 0), (o[i - 1] = (o[i - 1] + 1) | 0);
          for (var c = 0; c < i; c++) t[e + c] ^= s[c];
        },
      })),
      (pt.Decryptor = _t),
      pt)),
    (yt = (vt = bt).lib.StreamCipher),
    (gt = vt.algo),
    (Bt = []),
    (wt = []),
    (kt = []),
    (St = gt.RabbitLegacy = yt.extend({
      _doReset: function () {
        for (
          var t = this._key.words,
            e = this.cfg.iv,
            r = (this._X = [
              t[0],
              (t[3] << 16) | (t[2] >>> 16),
              t[1],
              (t[0] << 16) | (t[3] >>> 16),
              t[2],
              (t[1] << 16) | (t[0] >>> 16),
              t[3],
              (t[2] << 16) | (t[1] >>> 16),
            ]),
            i = (this._C = [
              (t[2] << 16) | (t[2] >>> 16),
              (4294901760 & t[0]) | (65535 & t[1]),
              (t[3] << 16) | (t[3] >>> 16),
              (4294901760 & t[1]) | (65535 & t[2]),
              (t[0] << 16) | (t[0] >>> 16),
              (4294901760 & t[2]) | (65535 & t[3]),
              (t[1] << 16) | (t[1] >>> 16),
              (4294901760 & t[3]) | (65535 & t[0]),
            ]),
            n = (this._b = 0);
          n < 4;
          n++
        )
          Mt.call(this);
        for (n = 0; n < 8; n++) i[n] ^= r[(n + 4) & 7];
        if (e) {
          var o = e.words,
            s = o[0],
            c = o[1],
            a =
              (16711935 & ((s << 8) | (s >>> 24))) |
              (4278255360 & ((s << 24) | (s >>> 8))),
            h =
              (16711935 & ((c << 8) | (c >>> 24))) |
              (4278255360 & ((c << 24) | (c >>> 8))),
            l = (a >>> 16) | (4294901760 & h),
            f = (h << 16) | (65535 & a);
          (i[0] ^= a),
            (i[1] ^= l),
            (i[2] ^= h),
            (i[3] ^= f),
            (i[4] ^= a),
            (i[5] ^= l),
            (i[6] ^= h),
            (i[7] ^= f);
          for (n = 0; n < 4; n++) Mt.call(this);
        }
      },
      _doProcessBlock: function (t, e) {
        var r = this._X;
        Mt.call(this),
          (Bt[0] = r[0] ^ (r[5] >>> 16) ^ (r[3] << 16)),
          (Bt[1] = r[2] ^ (r[7] >>> 16) ^ (r[5] << 16)),
          (Bt[2] = r[4] ^ (r[1] >>> 16) ^ (r[7] << 16)),
          (Bt[3] = r[6] ^ (r[3] >>> 16) ^ (r[1] << 16));
        for (var i = 0; i < 4; i++)
          (Bt[i] =
            (16711935 & ((Bt[i] << 8) | (Bt[i] >>> 24))) |
            (4278255360 & ((Bt[i] << 24) | (Bt[i] >>> 8)))),
            (t[e + i] ^= Bt[i]);
      },
      blockSize: 4,
      ivSize: 2,
    })),
    (vt.RabbitLegacy = yt._createHelper(St)),
    (bt.pad.ZeroPadding = {
      pad: function (t, e) {
        var r = 4 * e;
        t.clamp(), (t.sigBytes += r - (t.sigBytes % r || r));
      },
      unpad: function (t) {
        var e = t.words,
          r = t.sigBytes - 1;
        for (r = t.sigBytes - 1; 0 <= r; r--)
          if ((e[r >>> 2] >>> (24 - (r % 4) * 8)) & 255) {
            t.sigBytes = r + 1;
            break;
          }
      },
    }),
    bt
  );
});

/*! ngTagsInput v3.2.0 License: MIT */ !(function () {
  "use strict";
  var a = {
      backspace: 8,
      tab: 9,
      enter: 13,
      escape: 27,
      space: 32,
      up: 38,
      down: 40,
      left: 37,
      right: 39,
      delete: 46,
      comma: 188,
    },
    b = 9007199254740991,
    c = ["text", "email", "url"],
    d = angular.module("ngTagsInput", []);
  d.directive("tagsInput", [
    "$timeout",
    "$document",
    "$window",
    "$q",
    "tagsInputConfig",
    "tiUtil",
    function (d, e, f, g, h, i) {
      function j(a, b, c, d) {
        var e,
          f,
          h,
          j,
          k = {};
        return (
          (e = function (b) {
            return i.safeToString(b[a.displayProperty]);
          }),
          (f = function (b, c) {
            b[a.displayProperty] = c;
          }),
          (h = function (b) {
            var d = e(b),
              f =
                d &&
                d.length >= a.minLength &&
                d.length <= a.maxLength &&
                a.allowedTagsPattern.test(d) &&
                !i.findInObjectArray(
                  k.items,
                  b,
                  a.keyProperty || a.displayProperty
                );
            return g.when(f && c({ $tag: b })).then(i.promisifyValue);
          }),
          (j = function (a) {
            return g.when(d({ $tag: a })).then(i.promisifyValue);
          }),
          (k.items = []),
          (k.addText = function (a) {
            var b = {};
            return f(b, a), k.add(b);
          }),
          (k.add = function (c) {
            var d = e(c);
            return (
              a.replaceSpacesWithDashes && (d = i.replaceSpacesWithDashes(d)),
              f(c, d),
              h(c)
                .then(function () {
                  k.items.push(c), b.trigger("tag-added", { $tag: c });
                })
                ["catch"](function () {
                  d && b.trigger("invalid-tag", { $tag: c });
                })
            );
          }),
          (k.remove = function (a) {
            var c = k.items[a];
            return j(c).then(function () {
              return (
                k.items.splice(a, 1),
                k.clearSelection(),
                b.trigger("tag-removed", { $tag: c }),
                c
              );
            });
          }),
          (k.select = function (a) {
            0 > a ? (a = k.items.length - 1) : a >= k.items.length && (a = 0),
              (k.index = a),
              (k.selected = k.items[a]);
          }),
          (k.selectPrior = function () {
            k.select(--k.index);
          }),
          (k.selectNext = function () {
            k.select(++k.index);
          }),
          (k.removeSelected = function () {
            return k.remove(k.index);
          }),
          (k.clearSelection = function () {
            (k.selected = null), (k.index = -1);
          }),
          (k.getItems = function () {
            return a.useStrings ? k.items.map(e) : k.items;
          }),
          k.clearSelection(),
          k
        );
      }
      function k(a) {
        return -1 !== c.indexOf(a);
      }
      return {
        restrict: "E",
        require: "ngModel",
        scope: {
          tags: "=ngModel",
          text: "=?",
          templateScope: "=?",
          tagClass: "&",
          onTagAdding: "&",
          onTagAdded: "&",
          onInvalidTag: "&",
          onTagRemoving: "&",
          onTagRemoved: "&",
          onTagClicked: "&",
        },
        replace: !1,
        transclude: !0,
        templateUrl: "ngTagsInput/tags-input.html",
        controller: [
          "$scope",
          "$attrs",
          "$element",
          function (a, c, d) {
            (a.events = i.simplePubSub()),
              h.load("tagsInput", a, c, {
                template: [String, "ngTagsInput/tag-item.html"],
                type: [String, "text", k],
                placeholder: [String, "Add a tag"],
                tabindex: [Number, null],
                removeTagSymbol: [String, String.fromCharCode(215)],
                replaceSpacesWithDashes: [Boolean, !0],
                minLength: [Number, 3],
                maxLength: [Number, b],
                addOnEnter: [Boolean, !0],
                addOnSpace: [Boolean, !1],
                addOnComma: [Boolean, !0],
                addOnBlur: [Boolean, !0],
                addOnPaste: [Boolean, !1],
                pasteSplitPattern: [RegExp, /,/],
                allowedTagsPattern: [RegExp, /.+/],
                enableEditingLastTag: [Boolean, !1],
                minTags: [Number, 0],
                maxTags: [Number, b],
                displayProperty: [String, "text"],
                keyProperty: [String, ""],
                allowLeftoverText: [Boolean, !1],
                addFromAutocompleteOnly: [Boolean, !1],
                spellcheck: [Boolean, !0],
                useStrings: [Boolean, !1],
              }),
              (a.tagList = new j(
                a.options,
                a.events,
                i.handleUndefinedResult(a.onTagAdding, !0),
                i.handleUndefinedResult(a.onTagRemoving, !0)
              )),
              (this.registerAutocomplete = function () {
                d.find("input");
                return {
                  addTag: function (b) {
                    return a.tagList.add(b);
                  },
                  getTags: function () {
                    return a.tagList.items;
                  },
                  getCurrentTagText: function () {
                    return a.newTag.text();
                  },
                  getOptions: function () {
                    return a.options;
                  },
                  getTemplateScope: function () {
                    return a.templateScope;
                  },
                  on: function (b, c) {
                    return a.events.on(b, c, !0), this;
                  },
                };
              }),
              (this.registerTagItem = function () {
                return {
                  getOptions: function () {
                    return a.options;
                  },
                  removeTag: function (b) {
                    a.disabled || a.tagList.remove(b);
                  },
                };
              });
          },
        ],
        link: function (b, c, g, h) {
          var j,
            k,
            l = [
              a.enter,
              a.comma,
              a.space,
              a.backspace,
              a["delete"],
              a.left,
              a.right,
            ],
            m = b.tagList,
            n = b.events,
            o = b.options,
            p = c.find("input"),
            q = ["minTags", "maxTags", "allowLeftoverText"];
          (j = function () {
            h.$setValidity("maxTags", m.items.length <= o.maxTags),
              h.$setValidity("minTags", m.items.length >= o.minTags),
              h.$setValidity(
                "leftoverText",
                b.hasFocus || o.allowLeftoverText ? !0 : !b.newTag.text()
              );
          }),
            (k = function () {
              d(function () {
                p[0].focus();
              });
            }),
            (h.$isEmpty = function (a) {
              return !a || !a.length;
            }),
            (b.newTag = {
              text: function (a) {
                return angular.isDefined(a)
                  ? ((b.text = a), void n.trigger("input-change", a))
                  : b.text || "";
              },
              invalid: null,
            }),
            (b.track = function (a) {
              return a[o.keyProperty || o.displayProperty];
            }),
            (b.getTagClass = function (a, c) {
              var d = a === m.selected;
              return [
                b.tagClass({ $tag: a, $index: c, $selected: d }),
                { selected: d },
              ];
            }),
            b.$watch("tags", function (a) {
              if (a) {
                if (
                  ((m.items = i.makeObjectArray(a, o.displayProperty)),
                  o.useStrings)
                )
                  return;
                b.tags = m.items;
              } else m.items = [];
            }),
            b.$watch("tags.length", function () {
              j(), h.$validate();
            }),
            g.$observe("disabled", function (a) {
              b.disabled = a;
            }),
            (b.eventHandlers = {
              input: {
                keydown: function (a) {
                  n.trigger("input-keydown", a);
                },
                focus: function () {
                  b.hasFocus || ((b.hasFocus = !0), n.trigger("input-focus"));
                },
                blur: function () {
                  d(function () {
                    var a = e.prop("activeElement"),
                      d = a === p[0],
                      f = c[0].contains(a);
                    (d || !f) && ((b.hasFocus = !1), n.trigger("input-blur"));
                  });
                },
                paste: function (a) {
                  (a.getTextData = function () {
                    var b =
                      a.clipboardData ||
                      (a.originalEvent && a.originalEvent.clipboardData);
                    return b
                      ? b.getData("text/plain")
                      : f.clipboardData.getData("Text");
                  }),
                    n.trigger("input-paste", a);
                },
              },
              host: {
                click: function () {
                  b.disabled || k();
                },
              },
              tag: {
                click: function (a) {
                  n.trigger("tag-clicked", { $tag: a });
                },
              },
            }),
            n
              .on("tag-added", b.onTagAdded)
              .on("invalid-tag", b.onInvalidTag)
              .on("tag-removed", b.onTagRemoved)
              .on("tag-clicked", b.onTagClicked)
              .on("tag-added", function () {
                b.newTag.text("");
              })
              .on("tag-added tag-removed", function () {
                (b.tags = m.getItems()), h.$setDirty(), k();
              })
              .on("invalid-tag", function () {
                b.newTag.invalid = !0;
              })
              .on("option-change", function (a) {
                -1 !== q.indexOf(a.name) && j();
              })
              .on("input-change", function () {
                m.clearSelection(), (b.newTag.invalid = null);
              })
              .on("input-focus", function () {
                c.triggerHandler("focus"), h.$setValidity("leftoverText", !0);
              })
              .on("input-blur", function () {
                o.addOnBlur &&
                  !o.addFromAutocompleteOnly &&
                  m.addText(b.newTag.text()),
                  c.triggerHandler("blur"),
                  j();
              })
              .on("input-keydown", function (c) {
                var d,
                  e,
                  f,
                  g,
                  h = c.keyCode,
                  j = {};
                i.isModifierOn(c) ||
                  -1 === l.indexOf(h) ||
                  ((j[a.enter] = o.addOnEnter),
                  (j[a.comma] = o.addOnComma),
                  (j[a.space] = o.addOnSpace),
                  (d = !o.addFromAutocompleteOnly && j[h]),
                  (e = (h === a.backspace || h === a["delete"]) && m.selected),
                  (g =
                    h === a.backspace &&
                    0 === b.newTag.text().length &&
                    o.enableEditingLastTag),
                  (f =
                    (h === a.backspace || h === a.left || h === a.right) &&
                    0 === b.newTag.text().length &&
                    !o.enableEditingLastTag),
                  d
                    ? m.addText(b.newTag.text())
                    : g
                    ? (m.selectPrior(),
                      m.removeSelected().then(function (a) {
                        a && b.newTag.text(a[o.displayProperty]);
                      }))
                    : e
                    ? m.removeSelected()
                    : f &&
                      (h === a.left || h === a.backspace
                        ? m.selectPrior()
                        : h === a.right && m.selectNext()),
                  (d || f || e || g) && c.preventDefault());
              })
              .on("input-paste", function (a) {
                if (o.addOnPaste) {
                  var b = a.getTextData(),
                    c = b.split(o.pasteSplitPattern);
                  c.length > 1 &&
                    (c.forEach(function (a) {
                      m.addText(a);
                    }),
                    a.preventDefault());
                }
              });
        },
      };
    },
  ]),
    d.directive("tiTagItem", [
      "tiUtil",
      function (a) {
        return {
          restrict: "E",
          require: "^tagsInput",
          template: '<ng-include src="$$template"></ng-include>',
          scope: { $scope: "=scope", data: "=" },
          link: function (b, c, d, e) {
            var f = e.registerTagItem(),
              g = f.getOptions();
            (b.$$template = g.template),
              (b.$$removeTagSymbol = g.removeTagSymbol),
              (b.$getDisplayText = function () {
                return a.safeToString(b.data[g.displayProperty]);
              }),
              (b.$removeTag = function () {
                f.removeTag(b.$index);
              }),
              b.$watch("$parent.$index", function (a) {
                b.$index = a;
              });
          },
        };
      },
    ]),
    d.directive("autoComplete", [
      "$document",
      "$timeout",
      "$sce",
      "$q",
      "tagsInputConfig",
      "tiUtil",
      function (b, c, d, e, f, g) {
        function h(a, b, c) {
          var d,
            f,
            h,
            i = {};
          return (
            (h = function () {
              return b.tagsInput.keyProperty || b.tagsInput.displayProperty;
            }),
            (d = function (a, c) {
              return a.filter(function (a) {
                return !g.findInObjectArray(c, a, h(), function (a, c) {
                  return (
                    b.tagsInput.replaceSpacesWithDashes &&
                      ((a = g.replaceSpacesWithDashes(a)),
                      (c = g.replaceSpacesWithDashes(c))),
                    g.defaultComparer(a, c)
                  );
                });
              });
            }),
            (i.reset = function () {
              (f = null),
                (i.items = []),
                (i.visible = !1),
                (i.index = -1),
                (i.selected = null),
                (i.query = null);
            }),
            (i.show = function () {
              b.selectFirstMatch ? i.select(0) : (i.selected = null),
                (i.visible = !0);
            }),
            (i.load = g.debounce(function (c, j) {
              i.query = c;
              var k = e.when(a({ $query: c }));
              (f = k),
                k.then(function (a) {
                  k === f &&
                    ((a = g.makeObjectArray(a.data || a, h())),
                    (a = d(a, j)),
                    (i.items = a.slice(0, b.maxResultsToShow)),
                    i.items.length > 0 ? i.show() : i.reset());
                });
            }, b.debounceDelay)),
            (i.selectNext = function () {
              i.select(++i.index);
            }),
            (i.selectPrior = function () {
              i.select(--i.index);
            }),
            (i.select = function (a) {
              0 > a ? (a = i.items.length - 1) : a >= i.items.length && (a = 0),
                (i.index = a),
                (i.selected = i.items[a]),
                c.trigger("suggestion-selected", a);
            }),
            i.reset(),
            i
          );
        }
        function i(a, b) {
          var c = a.find("li").eq(b),
            d = c.parent(),
            e = c.prop("offsetTop"),
            f = c.prop("offsetHeight"),
            g = d.prop("clientHeight"),
            h = d.prop("scrollTop");
          h > e
            ? d.prop("scrollTop", e)
            : e + f > g + h && d.prop("scrollTop", e + f - g);
        }
        return {
          restrict: "E",
          require: "^tagsInput",
          scope: { source: "&", matchClass: "&" },
          templateUrl: "ngTagsInput/auto-complete.html",
          controller: [
            "$scope",
            "$element",
            "$attrs",
            function (a, b, c) {
              (a.events = g.simplePubSub()),
                f.load("autoComplete", a, c, {
                  template: [String, "ngTagsInput/auto-complete-match.html"],
                  debounceDelay: [Number, 100],
                  minLength: [Number, 3],
                  highlightMatchedText: [Boolean, !0],
                  maxResultsToShow: [Number, 10],
                  loadOnDownArrow: [Boolean, !1],
                  loadOnEmpty: [Boolean, !1],
                  loadOnFocus: [Boolean, !1],
                  selectFirstMatch: [Boolean, !0],
                  displayProperty: [String, ""],
                }),
                (a.suggestionList = new h(a.source, a.options, a.events)),
                (this.registerAutocompleteMatch = function () {
                  return {
                    getOptions: function () {
                      return a.options;
                    },
                    getQuery: function () {
                      return a.suggestionList.query;
                    },
                  };
                });
            },
          ],
          link: function (b, c, d, e) {
            var f,
              h = [a.enter, a.tab, a.escape, a.up, a.down],
              j = b.suggestionList,
              k = e.registerAutocomplete(),
              l = b.options,
              m = b.events;
            (l.tagsInput = k.getOptions()),
              (f = function (a) {
                return (a && a.length >= l.minLength) || (!a && l.loadOnEmpty);
              }),
              (b.templateScope = k.getTemplateScope()),
              (b.addSuggestionByIndex = function (a) {
                j.select(a), b.addSuggestion();
              }),
              (b.addSuggestion = function () {
                var a = !1;
                return (
                  j.selected &&
                    (k.addTag(angular.copy(j.selected)), j.reset(), (a = !0)),
                  a
                );
              }),
              (b.track = function (a) {
                return a[
                  l.tagsInput.keyProperty || l.tagsInput.displayProperty
                ];
              }),
              (b.getSuggestionClass = function (a, c) {
                var d = a === j.selected;
                return [
                  b.matchClass({ $match: a, $index: c, $selected: d }),
                  { selected: d },
                ];
              }),
              k
                .on(
                  "tag-added tag-removed invalid-tag input-blur",
                  function () {
                    j.reset();
                  }
                )
                .on("input-change", function (a) {
                  f(a) ? j.load(a, k.getTags()) : j.reset();
                })
                .on("input-focus", function () {
                  var a = k.getCurrentTagText();
                  l.loadOnFocus && f(a) && j.load(a, k.getTags());
                })
                .on("input-keydown", function (c) {
                  var d = c.keyCode,
                    e = !1;
                  if (!g.isModifierOn(c) && -1 !== h.indexOf(d))
                    return (
                      j.visible
                        ? d === a.down
                          ? (j.selectNext(), (e = !0))
                          : d === a.up
                          ? (j.selectPrior(), (e = !0))
                          : d === a.escape
                          ? (j.reset(), (e = !0))
                          : (d === a.enter || d === a.tab) &&
                            (e = b.addSuggestion())
                        : d === a.down &&
                          b.options.loadOnDownArrow &&
                          (j.load(k.getCurrentTagText(), k.getTags()),
                          (e = !0)),
                      e
                        ? (c.preventDefault(), c.stopImmediatePropagation(), !1)
                        : void 0
                    );
                }),
              m.on("suggestion-selected", function (a) {
                i(c, a);
              });
          },
        };
      },
    ]),
    d.directive("tiAutocompleteMatch", [
      "$sce",
      "tiUtil",
      function (a, b) {
        return {
          restrict: "E",
          require: "^autoComplete",
          template: '<ng-include src="$$template"></ng-include>',
          scope: { $scope: "=scope", data: "=" },
          link: function (c, d, e, f) {
            var g = f.registerAutocompleteMatch(),
              h = g.getOptions();
            (c.$$template = h.template),
              (c.$index = c.$parent.$index),
              (c.$highlight = function (c) {
                return (
                  h.highlightMatchedText &&
                    (c = b.safeHighlight(c, g.getQuery())),
                  a.trustAsHtml(c)
                );
              }),
              (c.$getDisplayText = function () {
                return b.safeToString(
                  c.data[h.displayProperty || h.tagsInput.displayProperty]
                );
              });
          },
        };
      },
    ]),
    d.directive("tiTranscludeAppend", function () {
      return function (a, b, c, d, e) {
        e(function (a) {
          b.append(a);
        });
      };
    }),
    d.directive("tiAutosize", [
      "tagsInputConfig",
      function (a) {
        return {
          restrict: "A",
          require: "ngModel",
          link: function (b, c, d, e) {
            var f,
              g,
              h = a.getTextAutosizeThreshold();
            (f = angular.element('<span class="input"></span>')),
              f
                .css("display", "none")
                .css("visibility", "hidden")
                .css("width", "auto")
                .css("white-space", "pre"),
              c.parent().append(f),
              (g = function (a) {
                var b,
                  e = a;
                return (
                  angular.isString(e) && 0 === e.length && (e = d.placeholder),
                  e &&
                    (f.text(e),
                    f.css("display", ""),
                    (b = f.prop("offsetWidth")),
                    f.css("display", "none")),
                  c.css("width", b ? b + h + "px" : ""),
                  a
                );
              }),
              e.$parsers.unshift(g),
              e.$formatters.unshift(g),
              d.$observe("placeholder", function (a) {
                e.$modelValue || g(a);
              });
          },
        };
      },
    ]),
    d.directive("tiBindAttrs", function () {
      return function (a, b, c) {
        a.$watch(
          c.tiBindAttrs,
          function (a) {
            angular.forEach(a, function (a, b) {
              c.$set(b, a);
            });
          },
          !0
        );
      };
    }),
    d.provider("tagsInputConfig", function () {
      var a = {},
        b = {},
        c = 3;
      (this.setDefaults = function (b, c) {
        return (a[b] = c), this;
      }),
        (this.setActiveInterpolation = function (a, c) {
          return (b[a] = c), this;
        }),
        (this.setTextAutosizeThreshold = function (a) {
          return (c = a), this;
        }),
        (this.$get = [
          "$interpolate",
          function (d) {
            var e = {};
            return (
              (e[String] = function (a) {
                return a;
              }),
              (e[Number] = function (a) {
                return parseInt(a, 10);
              }),
              (e[Boolean] = function (a) {
                return "true" === a.toLowerCase();
              }),
              (e[RegExp] = function (a) {
                return new RegExp(a);
              }),
              {
                load: function (c, f, g, h) {
                  var i = function () {
                    return !0;
                  };
                  (f.options = {}),
                    angular.forEach(h, function (h, j) {
                      var k, l, m, n, o, p;
                      (k = h[0]),
                        (l = h[1]),
                        (m = h[2] || i),
                        (n = e[k]),
                        (o = function () {
                          var b = a[c] && a[c][j];
                          return angular.isDefined(b) ? b : l;
                        }),
                        (p = function (a) {
                          f.options[j] = a && m(a) ? n(a) : o();
                        }),
                        b[c] && b[c][j]
                          ? g.$observe(j, function (a) {
                              p(a),
                                f.events.trigger("option-change", {
                                  name: j,
                                  newValue: a,
                                });
                            })
                          : p(g[j] && d(g[j])(f.$parent));
                    });
                },
                getTextAutosizeThreshold: function () {
                  return c;
                },
              }
            );
          },
        ]);
    }),
    d.factory("tiUtil", [
      "$timeout",
      "$q",
      function (a, b) {
        var c = {};
        return (
          (c.debounce = function (b, c) {
            var d;
            return function () {
              var e = arguments;
              a.cancel(d),
                (d = a(function () {
                  b.apply(null, e);
                }, c));
            };
          }),
          (c.makeObjectArray = function (a, b) {
            if (!angular.isArray(a) || 0 === a.length || angular.isObject(a[0]))
              return a;
            var c = [];
            return (
              a.forEach(function (a) {
                var d = {};
                (d[b] = a), c.push(d);
              }),
              c
            );
          }),
          (c.findInObjectArray = function (a, b, d, e) {
            var f = null;
            return (
              (e = e || c.defaultComparer),
              a.some(function (a) {
                return e(a[d], b[d]) ? ((f = a), !0) : void 0;
              }),
              f
            );
          }),
          (c.defaultComparer = function (a, b) {
            return (
              c.safeToString(a).toLowerCase() ===
              c.safeToString(b).toLowerCase()
            );
          }),
          (c.safeHighlight = function (a, b) {
            function d(a) {
              return a.replace(/([.?*+^$[\]\\(){}|-])/g, "\\$1");
            }
            if (((a = c.encodeHTML(a)), (b = c.encodeHTML(b)), !b)) return a;
            var e = new RegExp("&[^;]+;|" + d(b), "gi");
            return a.replace(e, function (a) {
              return a.toLowerCase() === b.toLowerCase()
                ? "<em>" + a + "</em>"
                : a;
            });
          }),
          (c.safeToString = function (a) {
            return angular.isUndefined(a) || null == a
              ? ""
              : a.toString().trim();
          }),
          (c.encodeHTML = function (a) {
            return c
              .safeToString(a)
              .replace(/&/g, "&amp;")
              .replace(/</g, "&lt;")
              .replace(/>/g, "&gt;");
          }),
          (c.handleUndefinedResult = function (a, b) {
            return function () {
              var c = a.apply(null, arguments);
              return angular.isUndefined(c) ? b : c;
            };
          }),
          (c.replaceSpacesWithDashes = function (a) {
            return c.safeToString(a).replace(/\s/g, "-");
          }),
          (c.isModifierOn = function (a) {
            return a.shiftKey || a.ctrlKey || a.altKey || a.metaKey;
          }),
          (c.promisifyValue = function (a) {
            return (
              (a = angular.isUndefined(a) ? !0 : a), b[a ? "when" : "reject"]()
            );
          }),
          (c.simplePubSub = function () {
            var a = {};
            return {
              on: function (b, c, d) {
                return (
                  b.split(" ").forEach(function (b) {
                    a[b] || (a[b] = []);
                    var e = d ? [].unshift : [].push;
                    e.call(a[b], c);
                  }),
                  this
                );
              },
              trigger: function (b, d) {
                var e = a[b] || [];
                return (
                  e.every(function (a) {
                    return c.handleUndefinedResult(a, !0)(d);
                  }),
                  this
                );
              },
            };
          }),
          c
        );
      },
    ]),
    d.run([
      "$templateCache",
      function (a) {
        a.put(
          "ngTagsInput/tags-input.html",
          '<div class="host" tabindex="-1" ng-click="eventHandlers.host.click()" ti-transclude-append><div class="tags" ng-class="{focused: hasFocus}"><ul class="tag-list"><li class="tag-item" ng-repeat="tag in tagList.items track by track(tag)" ng-class="getTagClass(tag, $index)" ng-click="eventHandlers.tag.click(tag)"><ti-tag-item scope="templateScope" data="::tag"></ti-tag-item></li></ul><input class="input" autocomplete="off" ng-model="newTag.text" ng-model-options="{getterSetter: true}" ng-keydown="eventHandlers.input.keydown($event)" ng-focus="eventHandlers.input.focus($event)" ng-blur="eventHandlers.input.blur($event)" ng-paste="eventHandlers.input.paste($event)" ng-trim="false" ng-class="{\'invalid-tag\': newTag.invalid}" ng-disabled="disabled" ti-bind-attrs="{type: options.type, placeholder: options.placeholder, tabindex: options.tabindex, spellcheck: options.spellcheck}" ti-autosize></div></div>'
        ),
          a.put(
            "ngTagsInput/tag-item.html",
            '<span ng-bind="$getDisplayText()"></span> <a class="remove-button" ng-click="$removeTag()" ng-bind="::$$removeTagSymbol"></a>'
          ),
          a.put(
            "ngTagsInput/auto-complete.html",
            '<div class="autocomplete" ng-if="suggestionList.visible"><ul class="suggestion-list"><li class="suggestion-item" ng-repeat="item in suggestionList.items track by track(item)" ng-class="getSuggestionClass(item, $index)" ng-click="addSuggestionByIndex($index)" ng-mouseenter="suggestionList.select($index)"><ti-autocomplete-match scope="templateScope" data="::item"></ti-autocomplete-match></li></ul></div>'
          ),
          a.put(
            "ngTagsInput/auto-complete-match.html",
            '<span ng-bind-html="$highlight($getDisplayText())"></span>'
          );
      },
    ]);
})();

/*!
 * html2canvas 1.0.0 <https://html2canvas.hertzen.com>
 * Copyright (c) 2021 Niklas von Hertzen <https://hertzen.com>
 * Released under MIT License
 */
!function(A,e){"object"==typeof exports&&"undefined"!=typeof module?module.exports=e():"function"==typeof define&&define.amd?define(e):(A=A||self).html2canvas=e()}(this,function(){"use strict";
/*! *****************************************************************************
    Copyright (c) Microsoft Corporation. All rights reserved.
    Licensed under the Apache License, Version 2.0 (the "License"); you may not use
    this file except in compliance with the License. You may obtain a copy of the
    License at http://www.apache.org/licenses/LICENSE-2.0

    THIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
    KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED
    WARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,
    MERCHANTABLITY OR NON-INFRINGEMENT.

    See the Apache Version 2.0 License for specific language governing permissions
    and limitations under the License.
    ***************************************************************************** */var r=function(A,e){return(r=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(A,e){A.__proto__=e}||function(A,e){for(var t in e)e.hasOwnProperty(t)&&(A[t]=e[t])})(A,e)};function A(A,e){function t(){this.constructor=A}r(A,e),A.prototype=null===e?Object.create(e):(t.prototype=e.prototype,new t)}var K=function(){return(K=Object.assign||function(A){for(var e,t=1,r=arguments.length;t<r;t++)for(var n in e=arguments[t])Object.prototype.hasOwnProperty.call(e,n)&&(A[n]=e[n]);return A}).apply(this,arguments)};function a(B,s,o,i){return new(o||(o=Promise))(function(A,e){function t(A){try{n(i.next(A))}catch(A){e(A)}}function r(A){try{n(i.throw(A))}catch(A){e(A)}}function n(e){e.done?A(e.value):new o(function(A){A(e.value)}).then(t,r)}n((i=i.apply(B,s||[])).next())})}function S(t,r){var n,B,s,A,o={label:0,sent:function(){if(1&s[0])throw s[1];return s[1]},trys:[],ops:[]};return A={next:e(0),throw:e(1),return:e(2)},"function"==typeof Symbol&&(A[Symbol.iterator]=function(){return this}),A;function e(e){return function(A){return function(e){if(n)throw new TypeError("Generator is already executing.");for(;o;)try{if(n=1,B&&(s=2&e[0]?B.return:e[0]?B.throw||((s=B.return)&&s.call(B),0):B.next)&&!(s=s.call(B,e[1])).done)return s;switch(B=0,s&&(e=[2&e[0],s.value]),e[0]){case 0:case 1:s=e;break;case 4:return o.label++,{value:e[1],done:!1};case 5:o.label++,B=e[1],e=[0];continue;case 7:e=o.ops.pop(),o.trys.pop();continue;default:if(!(s=0<(s=o.trys).length&&s[s.length-1])&&(6===e[0]||2===e[0])){o=0;continue}if(3===e[0]&&(!s||e[1]>s[0]&&e[1]<s[3])){o.label=e[1];break}if(6===e[0]&&o.label<s[1]){o.label=s[1],s=e;break}if(s&&o.label<s[2]){o.label=s[2],o.ops.push(e);break}s[2]&&o.ops.pop(),o.trys.pop();continue}e=r.call(t,o)}catch(A){e=[6,A],B=0}finally{n=s=0}if(5&e[0])throw e[1];return{value:e[0]?e[1]:void 0,done:!0}}([e,A])}}}var I=(n.prototype.add=function(A,e,t,r){return new n(this.left+A,this.top+e,this.width+t,this.height+r)},n.fromClientRect=function(A){return new n(A.left,A.top,A.width,A.height)},n);function n(A,e,t,r){this.left=A,this.top=e,this.width=t,this.height=r}for(var T=function(A){return I.fromClientRect(A.getBoundingClientRect())},c=function(A){for(var e=[],t=0,r=A.length;t<r;){var n=A.charCodeAt(t++);if(55296<=n&&n<=56319&&t<r){var B=A.charCodeAt(t++);56320==(64512&B)?e.push(((1023&n)<<10)+(1023&B)+65536):(e.push(n),t--)}else e.push(n)}return e},l=function(){for(var A=[],e=0;e<arguments.length;e++)A[e]=arguments[e];if(String.fromCodePoint)return String.fromCodePoint.apply(String,A);var t=A.length;if(!t)return"";for(var r=[],n=-1,B="";++n<t;){var s=A[n];s<=65535?r.push(s):(s-=65536,r.push(55296+(s>>10),s%1024+56320)),(n+1===t||16384<r.length)&&(B+=String.fromCharCode.apply(String,r),r.length=0)}return B},e="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/",Q="undefined"==typeof Uint8Array?[]:new Uint8Array(256),t=0;t<e.length;t++)Q[e.charCodeAt(t)]=t;function B(A,e,t){return A.slice?A.slice(e,t):new Uint16Array(Array.prototype.slice.call(A,e,t))}var s=(o.prototype.get=function(A){var e;if(0<=A){if(A<55296||56319<A&&A<=65535)return e=((e=this.index[A>>5])<<2)+(31&A),this.data[e];if(A<=65535)return e=((e=this.index[2048+(A-55296>>5)])<<2)+(31&A),this.data[e];if(A<this.highStart)return e=2080+(A>>11),e=this.index[e],e+=A>>5&63,e=((e=this.index[e])<<2)+(31&A),this.data[e];if(A<=1114111)return this.data[this.highValueIndex]}return this.errorValue},o);function o(A,e,t,r,n,B){this.initialValue=A,this.errorValue=e,this.highStart=t,this.highValueIndex=r,this.index=n,this.data=B}function C(A,e,t,r){var n=r[t];if(Array.isArray(A)?-1!==A.indexOf(n):A===n)for(var B=t;B<=r.length;){if((i=r[++B])===e)return!0;if(i!==d)break}if(n===d)for(B=t;0<B;){var s=r[--B];if(Array.isArray(A)?-1!==A.indexOf(s):A===s)for(var o=t;o<=r.length;){var i;if((i=r[++o])===e)return!0;if(i!==d)break}if(s!==d)break}return!1}function g(A,e){for(var t=A;0<=t;){var r=e[t];if(r!==d)return r;t--}return 0}function u(A,e,t,r,n){if(0===t[r])return Y;var B=r-1;if(Array.isArray(n)&&!0===n[B])return Y;var s=B-1,o=1+B,i=e[B],a=0<=s?e[s]:0,c=e[o];if(2===i&&3===c)return Y;if(-1!==j.indexOf(i))return"!";if(-1!==j.indexOf(c))return Y;if(-1!==$.indexOf(c))return Y;if(8===g(B,e))return"÷";if(11===q.get(A[B])&&(c===X||c===x||c===P))return Y;if(7===i||7===c)return Y;if(9===i)return Y;if(-1===[d,H,f].indexOf(i)&&9===c)return Y;if(-1!==[p,N,m,D,y].indexOf(c))return Y;if(g(B,e)===O)return Y;if(C(23,O,B,e))return Y;if(C([p,N],L,B,e))return Y;if(C(12,12,B,e))return Y;if(i===d)return"÷";if(23===i||23===c)return Y;if(16===c||16===i)return"÷";if(-1!==[H,f,L].indexOf(c)||14===i)return Y;if(36===a&&-1!==rA.indexOf(i))return Y;if(i===y&&36===c)return Y;if(c===R&&-1!==Z.concat(R,m,b,X,x,P).indexOf(i))return Y;if(-1!==Z.indexOf(c)&&i===b||-1!==Z.indexOf(i)&&c===b)return Y;if(i===M&&-1!==[X,x,P].indexOf(c)||-1!==[X,x,P].indexOf(i)&&c===v)return Y;if(-1!==Z.indexOf(i)&&-1!==AA.indexOf(c)||-1!==AA.indexOf(i)&&-1!==Z.indexOf(c))return Y;if(-1!==[M,v].indexOf(i)&&(c===b||-1!==[O,f].indexOf(c)&&e[1+o]===b)||-1!==[O,f].indexOf(i)&&c===b||i===b&&-1!==[b,y,D].indexOf(c))return Y;if(-1!==[b,y,D,p,N].indexOf(c))for(var Q=B;0<=Q;){if((u=e[Q])===b)return Y;if(-1===[y,D].indexOf(u))break;Q--}if(-1!==[M,v].indexOf(c))for(Q=-1!==[p,N].indexOf(i)?s:B;0<=Q;){var u;if((u=e[Q])===b)return Y;if(-1===[y,D].indexOf(u))break;Q--}if(G===i&&-1!==[G,J,V,z].indexOf(c)||-1!==[J,V].indexOf(i)&&-1!==[J,k].indexOf(c)||-1!==[k,z].indexOf(i)&&c===k)return Y;if(-1!==tA.indexOf(i)&&-1!==[R,v].indexOf(c)||-1!==tA.indexOf(c)&&i===M)return Y;if(-1!==Z.indexOf(i)&&-1!==Z.indexOf(c))return Y;if(i===D&&-1!==Z.indexOf(c))return Y;if(-1!==Z.concat(b).indexOf(i)&&c===O||-1!==Z.concat(b).indexOf(c)&&i===N)return Y;if(41===i&&41===c){for(var w=t[B],U=1;0<w&&41===e[--w];)U++;if(U%2!=0)return Y}return i===x&&c===P?Y:"÷"}function w(t,A){A||(A={lineBreak:"normal",wordBreak:"normal"});var e=function(A,n){void 0===n&&(n="strict");var B=[],s=[],o=[];return A.forEach(function(A,e){var t=q.get(A);if(50<t?(o.push(!0),t-=50):o.push(!1),-1!==["normal","auto","loose"].indexOf(n)&&-1!==[8208,8211,12316,12448].indexOf(A))return s.push(e),B.push(16);if(4!==t&&11!==t)return s.push(e),31===t?B.push("strict"===n?L:X):t===W?B.push(_):29===t?B.push(_):43===t?131072<=A&&A<=196605||196608<=A&&A<=262141?B.push(X):B.push(_):void B.push(t);if(0===e)return s.push(e),B.push(_);var r=B[e-1];return-1===eA.indexOf(r)?(s.push(s[e-1]),B.push(r)):(s.push(e),B.push(_))}),[s,B,o]}(t,A.lineBreak),r=e[0],n=e[1],B=e[2];return"break-all"!==A.wordBreak&&"break-word"!==A.wordBreak||(n=n.map(function(A){return-1!==[b,_,W].indexOf(A)?X:A})),[r,n,"keep-all"===A.wordBreak?B.map(function(A,e){return A&&19968<=t[e]&&t[e]<=40959}):void 0]}var i,U,E,h,F,d=10,H=13,f=15,p=17,N=18,m=19,R=20,L=21,O=22,D=24,b=25,v=26,M=27,y=28,_=30,x=32,P=33,V=34,z=35,X=37,G=38,J=39,k=40,W=42,Y="×",q=(i=function(A){var e,t,r,n,B,s=.75*A.length,o=A.length,i=0;"="===A[A.length-1]&&(s--,"="===A[A.length-2]&&s--);var a="undefined"!=typeof ArrayBuffer&&"undefined"!=typeof Uint8Array&&void 0!==Uint8Array.prototype.slice?new ArrayBuffer(s):new Array(s),c=Array.isArray(a)?a:new Uint8Array(a);for(e=0;e<o;e+=4)t=Q[A.charCodeAt(e)],r=Q[A.charCodeAt(e+1)],n=Q[A.charCodeAt(e+2)],B=Q[A.charCodeAt(e+3)],c[i++]=t<<2|r>>4,c[i++]=(15&r)<<4|n>>2,c[i++]=(3&n)<<6|63&B;return a}("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"),U=Array.isArray(i)?function(A){for(var e=A.length,t=[],r=0;r<e;r+=4)t.push(A[r+3]<<24|A[r+2]<<16|A[r+1]<<8|A[r]);return t}(i):new Uint32Array(i),E=Array.isArray(i)?function(A){for(var e=A.length,t=[],r=0;r<e;r+=2)t.push(A[r+1]<<8|A[r]);return t}(i):new Uint16Array(i),h=B(E,12,U[4]/2),F=2===U[5]?B(E,(24+U[4])/2):function(A,e,t){return A.slice?A.slice(e,t):new Uint32Array(Array.prototype.slice.call(A,e,t))}(U,Math.ceil((24+U[4])/4)),new s(U[0],U[1],U[2],U[3],h,F)),Z=[_,36],j=[1,2,3,5],$=[d,8],AA=[M,v],eA=j.concat($),tA=[G,J,k,V,z],rA=[f,H],nA=(BA.prototype.slice=function(){return l.apply(void 0,this.codePoints.slice(this.start,this.end))},BA);function BA(A,e,t,r){this.codePoints=A,this.required="!"===e,this.start=t,this.end=r}var sA,oA;(oA=sA||(sA={}))[oA.STRING_TOKEN=0]="STRING_TOKEN",oA[oA.BAD_STRING_TOKEN=1]="BAD_STRING_TOKEN",oA[oA.LEFT_PARENTHESIS_TOKEN=2]="LEFT_PARENTHESIS_TOKEN",oA[oA.RIGHT_PARENTHESIS_TOKEN=3]="RIGHT_PARENTHESIS_TOKEN",oA[oA.COMMA_TOKEN=4]="COMMA_TOKEN",oA[oA.HASH_TOKEN=5]="HASH_TOKEN",oA[oA.DELIM_TOKEN=6]="DELIM_TOKEN",oA[oA.AT_KEYWORD_TOKEN=7]="AT_KEYWORD_TOKEN",oA[oA.PREFIX_MATCH_TOKEN=8]="PREFIX_MATCH_TOKEN",oA[oA.DASH_MATCH_TOKEN=9]="DASH_MATCH_TOKEN",oA[oA.INCLUDE_MATCH_TOKEN=10]="INCLUDE_MATCH_TOKEN",oA[oA.LEFT_CURLY_BRACKET_TOKEN=11]="LEFT_CURLY_BRACKET_TOKEN",oA[oA.RIGHT_CURLY_BRACKET_TOKEN=12]="RIGHT_CURLY_BRACKET_TOKEN",oA[oA.SUFFIX_MATCH_TOKEN=13]="SUFFIX_MATCH_TOKEN",oA[oA.SUBSTRING_MATCH_TOKEN=14]="SUBSTRING_MATCH_TOKEN",oA[oA.DIMENSION_TOKEN=15]="DIMENSION_TOKEN",oA[oA.PERCENTAGE_TOKEN=16]="PERCENTAGE_TOKEN",oA[oA.NUMBER_TOKEN=17]="NUMBER_TOKEN",oA[oA.FUNCTION=18]="FUNCTION",oA[oA.FUNCTION_TOKEN=19]="FUNCTION_TOKEN",oA[oA.IDENT_TOKEN=20]="IDENT_TOKEN",oA[oA.COLUMN_TOKEN=21]="COLUMN_TOKEN",oA[oA.URL_TOKEN=22]="URL_TOKEN",oA[oA.BAD_URL_TOKEN=23]="BAD_URL_TOKEN",oA[oA.CDC_TOKEN=24]="CDC_TOKEN",oA[oA.CDO_TOKEN=25]="CDO_TOKEN",oA[oA.COLON_TOKEN=26]="COLON_TOKEN",oA[oA.SEMICOLON_TOKEN=27]="SEMICOLON_TOKEN",oA[oA.LEFT_SQUARE_BRACKET_TOKEN=28]="LEFT_SQUARE_BRACKET_TOKEN",oA[oA.RIGHT_SQUARE_BRACKET_TOKEN=29]="RIGHT_SQUARE_BRACKET_TOKEN",oA[oA.UNICODE_RANGE_TOKEN=30]="UNICODE_RANGE_TOKEN",oA[oA.WHITESPACE_TOKEN=31]="WHITESPACE_TOKEN",oA[oA.EOF_TOKEN=32]="EOF_TOKEN";function iA(A){return 48<=A&&A<=57}function aA(A){return iA(A)||65<=A&&A<=70||97<=A&&A<=102}function cA(A){return 10===A||9===A||32===A}function QA(A){return function(A){return function(A){return 97<=A&&A<=122}(A)||function(A){return 65<=A&&A<=90}(A)}(A)||function(A){return 128<=A}(A)||95===A}function uA(A){return QA(A)||iA(A)||45===A}function wA(A,e){return 92===A&&10!==e}function UA(A,e,t){return 45===A?QA(e)||wA(e,t):!!QA(A)||!(92!==A||!wA(A,e))}function lA(A,e,t){return 43===A||45===A?!!iA(e)||46===e&&iA(t):iA(46===A?e:A)}var CA={type:sA.LEFT_PARENTHESIS_TOKEN},gA={type:sA.RIGHT_PARENTHESIS_TOKEN},EA={type:sA.COMMA_TOKEN},hA={type:sA.SUFFIX_MATCH_TOKEN},FA={type:sA.PREFIX_MATCH_TOKEN},dA={type:sA.COLUMN_TOKEN},HA={type:sA.DASH_MATCH_TOKEN},fA={type:sA.INCLUDE_MATCH_TOKEN},pA={type:sA.LEFT_CURLY_BRACKET_TOKEN},NA={type:sA.RIGHT_CURLY_BRACKET_TOKEN},KA={type:sA.SUBSTRING_MATCH_TOKEN},IA={type:sA.BAD_URL_TOKEN},TA={type:sA.BAD_STRING_TOKEN},mA={type:sA.CDO_TOKEN},RA={type:sA.CDC_TOKEN},LA={type:sA.COLON_TOKEN},OA={type:sA.SEMICOLON_TOKEN},DA={type:sA.LEFT_SQUARE_BRACKET_TOKEN},bA={type:sA.RIGHT_SQUARE_BRACKET_TOKEN},vA={type:sA.WHITESPACE_TOKEN},SA={type:sA.EOF_TOKEN},MA=(yA.prototype.write=function(A){this._value=this._value.concat(c(A))},yA.prototype.read=function(){for(var A=[],e=this.consumeToken();e!==SA;)A.push(e),e=this.consumeToken();return A},yA.prototype.consumeToken=function(){var A=this.consumeCodePoint();switch(A){case 34:return this.consumeStringToken(34);case 35:var e=this.peekCodePoint(0),t=this.peekCodePoint(1),r=this.peekCodePoint(2);if(uA(e)||wA(t,r)){var n=UA(e,t,r)?2:1,B=this.consumeName();return{type:sA.HASH_TOKEN,value:B,flags:n}}break;case 36:if(61===this.peekCodePoint(0))return this.consumeCodePoint(),hA;break;case 39:return this.consumeStringToken(39);case 40:return CA;case 41:return gA;case 42:if(61===this.peekCodePoint(0))return this.consumeCodePoint(),KA;break;case 43:if(lA(A,this.peekCodePoint(0),this.peekCodePoint(1)))return this.reconsumeCodePoint(A),this.consumeNumericToken();break;case 44:return EA;case 45:var s=A,o=this.peekCodePoint(0),i=this.peekCodePoint(1);if(lA(s,o,i))return this.reconsumeCodePoint(A),this.consumeNumericToken();if(UA(s,o,i))return this.reconsumeCodePoint(A),this.consumeIdentLikeToken();if(45===o&&62===i)return this.consumeCodePoint(),this.consumeCodePoint(),RA;break;case 46:if(lA(A,this.peekCodePoint(0),this.peekCodePoint(1)))return this.reconsumeCodePoint(A),this.consumeNumericToken();break;case 47:if(42===this.peekCodePoint(0))for(this.consumeCodePoint();;){var a=this.consumeCodePoint();if(42===a&&47===(a=this.consumeCodePoint()))return this.consumeToken();if(-1===a)return this.consumeToken()}break;case 58:return LA;case 59:return OA;case 60:if(33===this.peekCodePoint(0)&&45===this.peekCodePoint(1)&&45===this.peekCodePoint(2))return this.consumeCodePoint(),this.consumeCodePoint(),mA;break;case 64:var c=this.peekCodePoint(0),Q=this.peekCodePoint(1),u=this.peekCodePoint(2);if(UA(c,Q,u))return B=this.consumeName(),{type:sA.AT_KEYWORD_TOKEN,value:B};break;case 91:return DA;case 92:if(wA(A,this.peekCodePoint(0)))return this.reconsumeCodePoint(A),this.consumeIdentLikeToken();break;case 93:return bA;case 61:if(61===this.peekCodePoint(0))return this.consumeCodePoint(),FA;break;case 123:return pA;case 125:return NA;case 117:case 85:var w=this.peekCodePoint(0),U=this.peekCodePoint(1);return 43!==w||!aA(U)&&63!==U||(this.consumeCodePoint(),this.consumeUnicodeRangeToken()),this.reconsumeCodePoint(A),this.consumeIdentLikeToken();case 124:if(61===this.peekCodePoint(0))return this.consumeCodePoint(),HA;if(124===this.peekCodePoint(0))return this.consumeCodePoint(),dA;break;case 126:if(61===this.peekCodePoint(0))return this.consumeCodePoint(),fA;break;case-1:return SA}return cA(A)?(this.consumeWhiteSpace(),vA):iA(A)?(this.reconsumeCodePoint(A),this.consumeNumericToken()):QA(A)?(this.reconsumeCodePoint(A),this.consumeIdentLikeToken()):{type:sA.DELIM_TOKEN,value:l(A)}},yA.prototype.consumeCodePoint=function(){var A=this._value.shift();return void 0===A?-1:A},yA.prototype.reconsumeCodePoint=function(A){this._value.unshift(A)},yA.prototype.peekCodePoint=function(A){return A>=this._value.length?-1:this._value[A]},yA.prototype.consumeUnicodeRangeToken=function(){for(var A=[],e=this.consumeCodePoint();aA(e)&&A.length<6;)A.push(e),e=this.consumeCodePoint();for(var t=!1;63===e&&A.length<6;)A.push(e),e=this.consumeCodePoint(),t=!0;if(t){var r=parseInt(l.apply(void 0,A.map(function(A){return 63===A?48:A})),16),n=parseInt(l.apply(void 0,A.map(function(A){return 63===A?70:A})),16);return{type:sA.UNICODE_RANGE_TOKEN,start:r,end:n}}var B=parseInt(l.apply(void 0,A),16);if(45===this.peekCodePoint(0)&&aA(this.peekCodePoint(1))){this.consumeCodePoint(),e=this.consumeCodePoint();for(var s=[];aA(e)&&s.length<6;)s.push(e),e=this.consumeCodePoint();return n=parseInt(l.apply(void 0,s),16),{type:sA.UNICODE_RANGE_TOKEN,start:B,end:n}}return{type:sA.UNICODE_RANGE_TOKEN,start:B,end:B}},yA.prototype.consumeIdentLikeToken=function(){var A=this.consumeName();return"url"===A.toLowerCase()&&40===this.peekCodePoint(0)?(this.consumeCodePoint(),this.consumeUrlToken()):40===this.peekCodePoint(0)?(this.consumeCodePoint(),{type:sA.FUNCTION_TOKEN,value:A}):{type:sA.IDENT_TOKEN,value:A}},yA.prototype.consumeUrlToken=function(){var A=[];if(this.consumeWhiteSpace(),-1===this.peekCodePoint(0))return{type:sA.URL_TOKEN,value:""};var e,t=this.peekCodePoint(0);if(39===t||34===t){var r=this.consumeStringToken(this.consumeCodePoint());return r.type===sA.STRING_TOKEN&&(this.consumeWhiteSpace(),-1===this.peekCodePoint(0)||41===this.peekCodePoint(0))?(this.consumeCodePoint(),{type:sA.URL_TOKEN,value:r.value}):(this.consumeBadUrlRemnants(),IA)}for(;;){var n=this.consumeCodePoint();if(-1===n||41===n)return{type:sA.URL_TOKEN,value:l.apply(void 0,A)};if(cA(n))return this.consumeWhiteSpace(),-1===this.peekCodePoint(0)||41===this.peekCodePoint(0)?(this.consumeCodePoint(),{type:sA.URL_TOKEN,value:l.apply(void 0,A)}):(this.consumeBadUrlRemnants(),IA);if(34===n||39===n||40===n||0<=(e=n)&&e<=8||11===e||14<=e&&e<=31||127===e)return this.consumeBadUrlRemnants(),IA;if(92===n){if(!wA(n,this.peekCodePoint(0)))return this.consumeBadUrlRemnants(),IA;A.push(this.consumeEscapedCodePoint())}else A.push(n)}},yA.prototype.consumeWhiteSpace=function(){for(;cA(this.peekCodePoint(0));)this.consumeCodePoint()},yA.prototype.consumeBadUrlRemnants=function(){for(;;){var A=this.consumeCodePoint();if(41===A||-1===A)return;wA(A,this.peekCodePoint(0))&&this.consumeEscapedCodePoint()}},yA.prototype.consumeStringSlice=function(A){for(var e="";0<A;){var t=Math.min(6e4,A);e+=l.apply(void 0,this._value.splice(0,t)),A-=t}return this._value.shift(),e},yA.prototype.consumeStringToken=function(A){for(var e="",t=0;;){var r=this._value[t];if(-1===r||void 0===r||r===A)return e+=this.consumeStringSlice(t),{type:sA.STRING_TOKEN,value:e};if(10===r)return this._value.splice(0,t),TA;if(92===r){var n=this._value[t+1];-1!==n&&void 0!==n&&(10===n?(e+=this.consumeStringSlice(t),t=-1,this._value.shift()):wA(r,n)&&(e+=this.consumeStringSlice(t),e+=l(this.consumeEscapedCodePoint()),t=-1))}t++}},yA.prototype.consumeNumber=function(){var A=[],e=4,t=this.peekCodePoint(0);for(43!==t&&45!==t||A.push(this.consumeCodePoint());iA(this.peekCodePoint(0));)A.push(this.consumeCodePoint());t=this.peekCodePoint(0);var r=this.peekCodePoint(1);if(46===t&&iA(r))for(A.push(this.consumeCodePoint(),this.consumeCodePoint()),e=8;iA(this.peekCodePoint(0));)A.push(this.consumeCodePoint());t=this.peekCodePoint(0),r=this.peekCodePoint(1);var n=this.peekCodePoint(2);if((69===t||101===t)&&((43===r||45===r)&&iA(n)||iA(r)))for(A.push(this.consumeCodePoint(),this.consumeCodePoint()),e=8;iA(this.peekCodePoint(0));)A.push(this.consumeCodePoint());return[function(A){var e=0,t=1;43!==A[e]&&45!==A[e]||(45===A[e]&&(t=-1),e++);for(var r=[];iA(A[e]);)r.push(A[e++]);var n=r.length?parseInt(l.apply(void 0,r),10):0;46===A[e]&&e++;for(var B=[];iA(A[e]);)B.push(A[e++]);var s=B.length,o=s?parseInt(l.apply(void 0,B),10):0;69!==A[e]&&101!==A[e]||e++;var i=1;43!==A[e]&&45!==A[e]||(45===A[e]&&(i=-1),e++);for(var a=[];iA(A[e]);)a.push(A[e++]);var c=a.length?parseInt(l.apply(void 0,a),10):0;return t*(n+o*Math.pow(10,-s))*Math.pow(10,i*c)}(A),e]},yA.prototype.consumeNumericToken=function(){var A=this.consumeNumber(),e=A[0],t=A[1],r=this.peekCodePoint(0),n=this.peekCodePoint(1),B=this.peekCodePoint(2);if(UA(r,n,B)){var s=this.consumeName();return{type:sA.DIMENSION_TOKEN,number:e,flags:t,unit:s}}return 37===r?(this.consumeCodePoint(),{type:sA.PERCENTAGE_TOKEN,number:e,flags:t}):{type:sA.NUMBER_TOKEN,number:e,flags:t}},yA.prototype.consumeEscapedCodePoint=function(){var A=this.consumeCodePoint();if(aA(A)){for(var e=l(A);aA(this.peekCodePoint(0))&&e.length<6;)e+=l(this.consumeCodePoint());cA(this.peekCodePoint(0))&&this.consumeCodePoint();var t=parseInt(e,16);return 0===t||function(A){return 55296<=A&&A<=57343}(t)||1114111<t?65533:t}return-1===A?65533:A},yA.prototype.consumeName=function(){for(var A="";;){var e=this.consumeCodePoint();if(uA(e))A+=l(e);else{if(!wA(e,this.peekCodePoint(0)))return this.reconsumeCodePoint(e),A;A+=l(this.consumeEscapedCodePoint())}}},yA);function yA(){this._value=[]}var _A=(xA.create=function(A){var e=new MA;return e.write(A),new xA(e.read())},xA.parseValue=function(A){return xA.create(A).parseComponentValue()},xA.parseValues=function(A){return xA.create(A).parseComponentValues()},xA.prototype.parseComponentValue=function(){for(var A=this.consumeToken();A.type===sA.WHITESPACE_TOKEN;)A=this.consumeToken();if(A.type===sA.EOF_TOKEN)throw new SyntaxError("Error parsing CSS component value, unexpected EOF");this.reconsumeToken(A);for(var e=this.consumeComponentValue();(A=this.consumeToken()).type===sA.WHITESPACE_TOKEN;);if(A.type===sA.EOF_TOKEN)return e;throw new SyntaxError("Error parsing CSS component value, multiple values found when expecting only one")},xA.prototype.parseComponentValues=function(){for(var A=[];;){var e=this.consumeComponentValue();if(e.type===sA.EOF_TOKEN)return A;A.push(e),A.push()}},xA.prototype.consumeComponentValue=function(){var A=this.consumeToken();switch(A.type){case sA.LEFT_CURLY_BRACKET_TOKEN:case sA.LEFT_SQUARE_BRACKET_TOKEN:case sA.LEFT_PARENTHESIS_TOKEN:return this.consumeSimpleBlock(A.type);case sA.FUNCTION_TOKEN:return this.consumeFunction(A)}return A},xA.prototype.consumeSimpleBlock=function(A){for(var e={type:A,values:[]},t=this.consumeToken();;){if(t.type===sA.EOF_TOKEN||Be(t,A))return e;this.reconsumeToken(t),e.values.push(this.consumeComponentValue()),t=this.consumeToken()}},xA.prototype.consumeFunction=function(A){for(var e={name:A.value,values:[],type:sA.FUNCTION};;){var t=this.consumeToken();if(t.type===sA.EOF_TOKEN||t.type===sA.RIGHT_PARENTHESIS_TOKEN)return e;this.reconsumeToken(t),e.values.push(this.consumeComponentValue())}},xA.prototype.consumeToken=function(){var A=this._tokens.shift();return void 0===A?SA:A},xA.prototype.reconsumeToken=function(A){this._tokens.unshift(A)},xA);function xA(A){this._tokens=A}function PA(A){return A.type===sA.DIMENSION_TOKEN}function VA(A){return A.type===sA.NUMBER_TOKEN}function zA(A){return A.type===sA.IDENT_TOKEN}function XA(A){return A.type===sA.STRING_TOKEN}function GA(A,e){return zA(A)&&A.value===e}function JA(A){return A.type!==sA.WHITESPACE_TOKEN}function kA(A){return A.type!==sA.WHITESPACE_TOKEN&&A.type!==sA.COMMA_TOKEN}function WA(A){var e=[],t=[];return A.forEach(function(A){if(A.type===sA.COMMA_TOKEN){if(0===t.length)throw new Error("Error parsing function args, zero tokens for arg");return e.push(t),void(t=[])}A.type!==sA.WHITESPACE_TOKEN&&t.push(A)}),t.length&&e.push(t),e}function YA(A){return A.type===sA.NUMBER_TOKEN||A.type===sA.DIMENSION_TOKEN}function qA(A){return A.type===sA.PERCENTAGE_TOKEN||YA(A)}function ZA(A){return 1<A.length?[A[0],A[1]]:[A[0]]}function jA(A,e,t){var r=A[0],n=A[1];return[ae(r,e),ae(void 0!==n?n:r,t)]}function $A(A){return A.type===sA.DIMENSION_TOKEN&&("deg"===A.unit||"grad"===A.unit||"rad"===A.unit||"turn"===A.unit)}function Ae(A){switch(A.filter(zA).map(function(A){return A.value}).join(" ")){case"to bottom right":case"to right bottom":case"left top":case"top left":return[se,se];case"to top":case"bottom":return Qe(0);case"to bottom left":case"to left bottom":case"right top":case"top right":return[se,ie];case"to right":case"left":return Qe(90);case"to top left":case"to left top":case"right bottom":case"bottom right":return[ie,ie];case"to bottom":case"top":return Qe(180);case"to top right":case"to right top":case"left bottom":case"bottom left":return[ie,se];case"to left":case"right":return Qe(270)}return 0}function ee(A){return 0==(255&A)}function te(A){var e=255&A,t=255&A>>8,r=255&A>>16,n=255&A>>24;return e<255?"rgba("+n+","+r+","+t+","+e/255+")":"rgb("+n+","+r+","+t+")"}function re(A,e){if(A.type===sA.NUMBER_TOKEN)return A.number;if(A.type!==sA.PERCENTAGE_TOKEN)return 0;var t=3===e?1:255;return 3===e?A.number/100*t:Math.round(A.number/100*t)}function ne(A){var e=A.filter(kA);if(3===e.length){var t=e.map(re),r=t[0],n=t[1],B=t[2];return we(r,n,B,1)}if(4!==e.length)return 0;var s=e.map(re),o=(r=s[0],n=s[1],B=s[2],s[3]);return we(r,n,B,o)}var Be=function(A,e){return e===sA.LEFT_CURLY_BRACKET_TOKEN&&A.type===sA.RIGHT_CURLY_BRACKET_TOKEN||(e===sA.LEFT_SQUARE_BRACKET_TOKEN&&A.type===sA.RIGHT_SQUARE_BRACKET_TOKEN||e===sA.LEFT_PARENTHESIS_TOKEN&&A.type===sA.RIGHT_PARENTHESIS_TOKEN)},se={type:sA.NUMBER_TOKEN,number:0,flags:4},oe={type:sA.PERCENTAGE_TOKEN,number:50,flags:4},ie={type:sA.PERCENTAGE_TOKEN,number:100,flags:4},ae=function(A,e){if(A.type===sA.PERCENTAGE_TOKEN)return A.number/100*e;if(PA(A))switch(A.unit){case"rem":case"em":return 16*A.number;case"px":default:return A.number}return A.number},ce=function(A){if(A.type===sA.DIMENSION_TOKEN)switch(A.unit){case"deg":return Math.PI*A.number/180;case"grad":return Math.PI/200*A.number;case"rad":return A.number;case"turn":return 2*Math.PI*A.number}throw new Error("Unsupported angle type")},Qe=function(A){return Math.PI*A/180},ue=function(A){if(A.type===sA.FUNCTION){var e=Fe[A.name];if(void 0===e)throw new Error('Attempting to parse an unsupported color function "'+A.name+'"');return e(A.values)}if(A.type===sA.HASH_TOKEN){if(3===A.value.length){var t=A.value.substring(0,1),r=A.value.substring(1,2),n=A.value.substring(2,3);return we(parseInt(t+t,16),parseInt(r+r,16),parseInt(n+n,16),1)}if(4===A.value.length){t=A.value.substring(0,1),r=A.value.substring(1,2),n=A.value.substring(2,3);var B=A.value.substring(3,4);return we(parseInt(t+t,16),parseInt(r+r,16),parseInt(n+n,16),parseInt(B+B,16)/255)}if(6===A.value.length){t=A.value.substring(0,2),r=A.value.substring(2,4),n=A.value.substring(4,6);return we(parseInt(t,16),parseInt(r,16),parseInt(n,16),1)}if(8===A.value.length){t=A.value.substring(0,2),r=A.value.substring(2,4),n=A.value.substring(4,6),B=A.value.substring(6,8);return we(parseInt(t,16),parseInt(r,16),parseInt(n,16),parseInt(B,16)/255)}}if(A.type===sA.IDENT_TOKEN){var s=de[A.value.toUpperCase()];if(void 0!==s)return s}return de.TRANSPARENT},we=function(A,e,t,r){return(A<<24|e<<16|t<<8|Math.round(255*r)<<0)>>>0};function Ue(A,e,t){return t<0&&(t+=1),1<=t&&(t-=1),t<1/6?(e-A)*t*6+A:t<.5?e:t<2/3?6*(e-A)*(2/3-t)+A:A}function le(A){var e=A.filter(kA),t=e[0],r=e[1],n=e[2],B=e[3],s=(t.type===sA.NUMBER_TOKEN?Qe(t.number):ce(t))/(2*Math.PI),o=qA(r)?r.number/100:0,i=qA(n)?n.number/100:0,a=void 0!==B&&qA(B)?ae(B,1):1;if(0==o)return we(255*i,255*i,255*i,1);var c=i<=.5?i*(1+o):i+o-i*o,Q=2*i-c,u=Ue(Q,c,s+1/3),w=Ue(Q,c,s),U=Ue(Q,c,s-1/3);return we(255*u,255*w,255*U,a)}var Ce,ge,Ee,he,Fe={hsl:le,hsla:le,rgb:ne,rgba:ne},de={ALICEBLUE:4042850303,ANTIQUEWHITE:4209760255,AQUA:16777215,AQUAMARINE:2147472639,AZURE:4043309055,BEIGE:4126530815,BISQUE:4293182719,BLACK:255,BLANCHEDALMOND:4293643775,BLUE:65535,BLUEVIOLET:2318131967,BROWN:2771004159,BURLYWOOD:3736635391,CADETBLUE:1604231423,CHARTREUSE:2147418367,CHOCOLATE:3530104575,CORAL:4286533887,CORNFLOWERBLUE:1687547391,CORNSILK:4294499583,CRIMSON:3692313855,CYAN:16777215,DARKBLUE:35839,DARKCYAN:9145343,DARKGOLDENROD:3095837695,DARKGRAY:2846468607,DARKGREEN:6553855,DARKGREY:2846468607,DARKKHAKI:3182914559,DARKMAGENTA:2332068863,DARKOLIVEGREEN:1433087999,DARKORANGE:4287365375,DARKORCHID:2570243327,DARKRED:2332033279,DARKSALMON:3918953215,DARKSEAGREEN:2411499519,DARKSLATEBLUE:1211993087,DARKSLATEGRAY:793726975,DARKSLATEGREY:793726975,DARKTURQUOISE:13554175,DARKVIOLET:2483082239,DEEPPINK:4279538687,DEEPSKYBLUE:12582911,DIMGRAY:1768516095,DIMGREY:1768516095,DODGERBLUE:512819199,FIREBRICK:2988581631,FLORALWHITE:4294635775,FORESTGREEN:579543807,FUCHSIA:4278255615,GAINSBORO:3705462015,GHOSTWHITE:4177068031,GOLD:4292280575,GOLDENROD:3668254975,GRAY:2155905279,GREEN:8388863,GREENYELLOW:2919182335,GREY:2155905279,HONEYDEW:4043305215,HOTPINK:4285117695,INDIANRED:3445382399,INDIGO:1258324735,IVORY:4294963455,KHAKI:4041641215,LAVENDER:3873897215,LAVENDERBLUSH:4293981695,LAWNGREEN:2096890111,LEMONCHIFFON:4294626815,LIGHTBLUE:2916673279,LIGHTCORAL:4034953471,LIGHTCYAN:3774873599,LIGHTGOLDENRODYELLOW:4210742015,LIGHTGRAY:3553874943,LIGHTGREEN:2431553791,LIGHTGREY:3553874943,LIGHTPINK:4290167295,LIGHTSALMON:4288707327,LIGHTSEAGREEN:548580095,LIGHTSKYBLUE:2278488831,LIGHTSLATEGRAY:2005441023,LIGHTSLATEGREY:2005441023,LIGHTSTEELBLUE:2965692159,LIGHTYELLOW:4294959359,LIME:16711935,LIMEGREEN:852308735,LINEN:4210091775,MAGENTA:4278255615,MAROON:2147483903,MEDIUMAQUAMARINE:1724754687,MEDIUMBLUE:52735,MEDIUMORCHID:3126187007,MEDIUMPURPLE:2473647103,MEDIUMSEAGREEN:1018393087,MEDIUMSLATEBLUE:2070474495,MEDIUMSPRINGGREEN:16423679,MEDIUMTURQUOISE:1221709055,MEDIUMVIOLETRED:3340076543,MIDNIGHTBLUE:421097727,MINTCREAM:4127193855,MISTYROSE:4293190143,MOCCASIN:4293178879,NAVAJOWHITE:4292783615,NAVY:33023,OLDLACE:4260751103,OLIVE:2155872511,OLIVEDRAB:1804477439,ORANGE:4289003775,ORANGERED:4282712319,ORCHID:3664828159,PALEGOLDENROD:4008225535,PALEGREEN:2566625535,PALETURQUOISE:2951671551,PALEVIOLETRED:3681588223,PAPAYAWHIP:4293907967,PEACHPUFF:4292524543,PERU:3448061951,PINK:4290825215,PLUM:3718307327,POWDERBLUE:2967529215,PURPLE:2147516671,REBECCAPURPLE:1714657791,RED:4278190335,ROSYBROWN:3163525119,ROYALBLUE:1097458175,SADDLEBROWN:2336560127,SALMON:4202722047,SANDYBROWN:4104413439,SEAGREEN:780883967,SEASHELL:4294307583,SIENNA:2689740287,SILVER:3233857791,SKYBLUE:2278484991,SLATEBLUE:1784335871,SLATEGRAY:1887473919,SLATEGREY:1887473919,SNOW:4294638335,SPRINGGREEN:16744447,STEELBLUE:1182971135,TAN:3535047935,TEAL:8421631,THISTLE:3636451583,TOMATO:4284696575,TRANSPARENT:0,TURQUOISE:1088475391,VIOLET:4001558271,WHEAT:4125012991,WHITE:4294967295,WHITESMOKE:4126537215,YELLOW:4294902015,YELLOWGREEN:2597139199};(ge=Ce||(Ce={}))[ge.VALUE=0]="VALUE",ge[ge.LIST=1]="LIST",ge[ge.IDENT_VALUE=2]="IDENT_VALUE",ge[ge.TYPE_VALUE=3]="TYPE_VALUE",ge[ge.TOKEN_VALUE=4]="TOKEN_VALUE",(he=Ee||(Ee={}))[he.BORDER_BOX=0]="BORDER_BOX",he[he.PADDING_BOX=1]="PADDING_BOX";function He(A){var e=ue(A[0]),t=A[1];return t&&qA(t)?{color:e,stop:t}:{color:e,stop:null}}function fe(A,t){var e=A[0],r=A[A.length-1];null===e.stop&&(e.stop=se),null===r.stop&&(r.stop=ie);for(var n=[],B=0,s=0;s<A.length;s++){var o=A[s].stop;if(null!==o){var i=ae(o,t);B<i?n.push(i):n.push(B),B=i}else n.push(null)}var a=null;for(s=0;s<n.length;s++){var c=n[s];if(null===c)null===a&&(a=s);else if(null!==a){for(var Q=s-a,u=(c-n[a-1])/(1+Q),w=1;w<=Q;w++)n[a+w-1]=u*w;a=null}}return A.map(function(A,e){return{color:A.color,stop:Math.max(Math.min(1,n[e]/t),0)}})}function pe(A,e,t){var r="number"==typeof A?A:function(A,e,t){var r=e/2,n=t/2,B=ae(A[0],e)-r,s=n-ae(A[1],t);return(Math.atan2(s,B)+2*Math.PI)%(2*Math.PI)}(A,e,t),n=Math.abs(e*Math.sin(r))+Math.abs(t*Math.cos(r)),B=e/2,s=t/2,o=n/2,i=Math.sin(r-Math.PI/2)*o,a=Math.cos(r-Math.PI/2)*o;return[n,B-a,B+a,s-i,s+i]}function Ne(A,e){return Math.sqrt(A*A+e*e)}function Ke(A,e,B,s,o){return[[0,0],[0,e],[A,0],[A,e]].reduce(function(A,e){var t=e[0],r=e[1],n=Ne(B-t,s-r);return(o?n<A.optimumDistance:n>A.optimumDistance)?{optimumCorner:e,optimumDistance:n}:A},{optimumDistance:o?1/0:-1/0,optimumCorner:null}).optimumCorner}function Ie(A){var n=Qe(180),B=[];return WA(A).forEach(function(A,e){if(0===e){var t=A[0];if(t.type===sA.IDENT_TOKEN&&-1!==["top","left","right","bottom"].indexOf(t.value))return void(n=Ae(A));if($A(t))return void(n=(ce(t)+Qe(270))%Qe(360))}var r=He(A);B.push(r)}),{angle:n,stops:B,type:Pe.LINEAR_GRADIENT}}function Te(A){return 0===A[0]&&255===A[1]&&0===A[2]&&255===A[3]}var me={name:"background-clip",initialValue:"border-box",prefix:!(he[he.CONTENT_BOX=2]="CONTENT_BOX"),type:Ce.LIST,parse:function(A){return A.map(function(A){if(zA(A))switch(A.value){case"padding-box":return Ee.PADDING_BOX;case"content-box":return Ee.CONTENT_BOX}return Ee.BORDER_BOX})}},Re={name:"background-color",initialValue:"transparent",prefix:!1,type:Ce.TYPE_VALUE,format:"color"},Le=function(A,e,t,r,n){var B="http://www.w3.org/2000/svg",s=document.createElementNS(B,"svg"),o=document.createElementNS(B,"foreignObject");return s.setAttributeNS(null,"width",A.toString()),s.setAttributeNS(null,"height",e.toString()),o.setAttributeNS(null,"width","100%"),o.setAttributeNS(null,"height","100%"),o.setAttributeNS(null,"x",t.toString()),o.setAttributeNS(null,"y",r.toString()),o.setAttributeNS(null,"externalResourcesRequired","true"),s.appendChild(o),o.appendChild(n),s},Oe=function(r){return new Promise(function(A,e){var t=new Image;t.onload=function(){return A(t)},t.onerror=e,t.src="data:image/svg+xml;charset=utf-8,"+encodeURIComponent((new XMLSerializer).serializeToString(r))})},De={get SUPPORT_RANGE_BOUNDS(){var A=function(A){if(A.createRange){var e=A.createRange();if(e.getBoundingClientRect){var t=A.createElement("boundtest");t.style.height="123px",t.style.display="block",A.body.appendChild(t),e.selectNode(t);var r=e.getBoundingClientRect(),n=Math.round(r.height);if(A.body.removeChild(t),123===n)return!0}}return!1}(document);return Object.defineProperty(De,"SUPPORT_RANGE_BOUNDS",{value:A}),A},get SUPPORT_SVG_DRAWING(){var A=function(A){var e=new Image,t=A.createElement("canvas"),r=t.getContext("2d");if(!r)return!1;e.src="data:image/svg+xml,<svg xmlns='http://www.w3.org/2000/svg'></svg>";try{r.drawImage(e,0,0),t.toDataURL()}catch(A){return!1}return!0}(document);return Object.defineProperty(De,"SUPPORT_SVG_DRAWING",{value:A}),A},get SUPPORT_FOREIGNOBJECT_DRAWING(){var A="function"==typeof Array.from&&"function"==typeof window.fetch?function(r){var A=r.createElement("canvas"),n=100;A.width=n,A.height=n;var B=A.getContext("2d");if(!B)return Promise.reject(!1);B.fillStyle="rgb(0, 255, 0)",B.fillRect(0,0,n,n);var e=new Image,s=A.toDataURL();e.src=s;var t=Le(n,n,0,0,e);return B.fillStyle="red",B.fillRect(0,0,n,n),Oe(t).then(function(A){B.drawImage(A,0,0);var e=B.getImageData(0,0,n,n).data;B.fillStyle="red",B.fillRect(0,0,n,n);var t=r.createElement("div");return t.style.backgroundImage="url("+s+")",t.style.height="100px",Te(e)?Oe(Le(n,n,0,0,t)):Promise.reject(!1)}).then(function(A){return B.drawImage(A,0,0),Te(B.getImageData(0,0,n,n).data)}).catch(function(){return!1})}(document):Promise.resolve(!1);return Object.defineProperty(De,"SUPPORT_FOREIGNOBJECT_DRAWING",{value:A}),A},get SUPPORT_CORS_IMAGES(){var A=void 0!==(new Image).crossOrigin;return Object.defineProperty(De,"SUPPORT_CORS_IMAGES",{value:A}),A},get SUPPORT_RESPONSE_TYPE(){var A="string"==typeof(new XMLHttpRequest).responseType;return Object.defineProperty(De,"SUPPORT_RESPONSE_TYPE",{value:A}),A},get SUPPORT_CORS_XHR(){var A="withCredentials"in new XMLHttpRequest;return Object.defineProperty(De,"SUPPORT_CORS_XHR",{value:A}),A}},be=(ve.prototype.debug=function(){for(var A=[],e=0;e<arguments.length;e++)A[e]=arguments[e];this.enabled&&("undefined"!=typeof window&&window.console&&"function"==typeof console.debug?console.debug.apply(console,[this.id,this.getTime()+"ms"].concat(A)):this.info.apply(this,A))},ve.prototype.getTime=function(){return Date.now()-this.start},ve.create=function(A){ve.instances[A.id]=new ve(A)},ve.destroy=function(A){delete ve.instances[A]},ve.getInstance=function(A){var e=ve.instances[A];if(void 0===e)throw new Error("No logger instance found with id "+A);return e},ve.prototype.info=function(){for(var A=[],e=0;e<arguments.length;e++)A[e]=arguments[e];this.enabled&&"undefined"!=typeof window&&window.console&&"function"==typeof console.info&&console.info.apply(console,[this.id,this.getTime()+"ms"].concat(A))},ve.prototype.error=function(){for(var A=[],e=0;e<arguments.length;e++)A[e]=arguments[e];this.enabled&&("undefined"!=typeof window&&window.console&&"function"==typeof console.error?console.error.apply(console,[this.id,this.getTime()+"ms"].concat(A)):this.info.apply(this,A))},ve.instances={},ve);function ve(A){var e=A.id,t=A.enabled;this.id=e,this.enabled=t,this.start=Date.now()}var Se=(Me.create=function(A,e){return Me._caches[A]=new ye(A,e)},Me.destroy=function(A){delete Me._caches[A]},Me.open=function(A){var e=Me._caches[A];if(void 0!==e)return e;throw new Error('Cache with key "'+A+'" not found')},Me.getOrigin=function(A){var e=Me._link;return e?(e.href=A,e.href=e.href,e.protocol+e.hostname+e.port):"about:blank"},Me.isSameOrigin=function(A){return Me.getOrigin(A)===Me._origin},Me.setContext=function(A){Me._link=A.document.createElement("a"),Me._origin=Me.getOrigin(A.location.href)},Me.getInstance=function(){var A=Me._current;if(null===A)throw new Error("No cache instance attached");return A},Me.attachInstance=function(A){Me._current=A},Me.detachInstance=function(){Me._current=null},Me._caches={},Me._origin="about:blank",Me._current=null,Me);function Me(){}var ye=(_e.prototype.addImage=function(A){var e=Promise.resolve();return this.has(A)||(Ye(A)||Je(A))&&(this._cache[A]=this.loadImage(A)),e},_e.prototype.match=function(A){return this._cache[A]},_e.prototype.loadImage=function(s){return a(this,void 0,void 0,function(){var e,r,t,n,B=this;return S(this,function(A){switch(A.label){case 0:return e=Se.isSameOrigin(s),r=!ke(s)&&!0===this._options.useCORS&&De.SUPPORT_CORS_IMAGES&&!e,t=!ke(s)&&!e&&"string"==typeof this._options.proxy&&De.SUPPORT_CORS_XHR&&!r,e||!1!==this._options.allowTaint||ke(s)||t||r?(n=s,t?[4,this.proxy(n)]:[3,2]):[2];case 1:n=A.sent(),A.label=2;case 2:return be.getInstance(this.id).debug("Added image "+s.substring(0,256)),[4,new Promise(function(A,e){var t=new Image;t.onload=function(){return A(t)},t.onerror=e,(We(n)||r)&&(t.crossOrigin="anonymous"),t.src=n,!0===t.complete&&setTimeout(function(){return A(t)},500),0<B._options.imageTimeout&&setTimeout(function(){return e("Timed out ("+B._options.imageTimeout+"ms) loading image")},B._options.imageTimeout)})];case 3:return[2,A.sent()]}})})},_e.prototype.has=function(A){return void 0!==this._cache[A]},_e.prototype.keys=function(){return Promise.resolve(Object.keys(this._cache))},_e.prototype.proxy=function(B){var s=this,o=this._options.proxy;if(!o)throw new Error("No proxy defined");var i=B.substring(0,256);return new Promise(function(e,t){var r=De.SUPPORT_RESPONSE_TYPE?"blob":"text",n=new XMLHttpRequest;if(n.onload=function(){if(200===n.status)if("text"==r)e(n.response);else{var A=new FileReader;A.addEventListener("load",function(){return e(A.result)},!1),A.addEventListener("error",function(A){return t(A)},!1),A.readAsDataURL(n.response)}else t("Failed to proxy resource "+i+" with status code "+n.status)},n.onerror=t,n.open("GET",o+"?url="+encodeURIComponent(B)+"&responseType="+r),"text"!=r&&n instanceof XMLHttpRequest&&(n.responseType=r),s._options.imageTimeout){var A=s._options.imageTimeout;n.timeout=A,n.ontimeout=function(){return t("Timed out ("+A+"ms) proxying "+i)}}n.send()})},_e);function _e(A,e){this.id=A,this._options=e,this._cache={}}function xe(A){var n=rt.CIRCLE,B=Bt.FARTHEST_CORNER,s=[],o=[];return WA(A).forEach(function(A,e){var t=!0;if(0===e?t=A.reduce(function(A,e){if(zA(e))switch(e.value){case"center":return o.push(oe),!1;case"top":case"left":return o.push(se),!1;case"right":case"bottom":return o.push(ie),!1}else if(qA(e)||YA(e))return o.push(e),!1;return A},t):1===e&&(t=A.reduce(function(A,e){if(zA(e))switch(e.value){case"circle":return n=rt.CIRCLE,!1;case et:return n=rt.ELLIPSE,!1;case tt:case Ze:return B=Bt.CLOSEST_SIDE,!1;case je:return B=Bt.FARTHEST_SIDE,!1;case $e:return B=Bt.CLOSEST_CORNER,!1;case"cover":case At:return B=Bt.FARTHEST_CORNER,!1}else if(YA(e)||qA(e))return Array.isArray(B)||(B=[]),B.push(e),!1;return A},t)),t){var r=He(A);s.push(r)}}),{size:B,shape:n,stops:s,position:o,type:Pe.RADIAL_GRADIENT}}var Pe,Ve,ze=/^data:image\/svg\+xml/i,Xe=/^data:image\/.*;base64,/i,Ge=/^data:image\/.*/i,Je=function(A){return De.SUPPORT_SVG_DRAWING||!qe(A)},ke=function(A){return Ge.test(A)},We=function(A){return Xe.test(A)},Ye=function(A){return"blob"===A.substr(0,4)},qe=function(A){return"svg"===A.substr(-3).toLowerCase()||ze.test(A)},Ze="closest-side",je="farthest-side",$e="closest-corner",At="farthest-corner",et="ellipse",tt="contain";(Ve=Pe||(Pe={}))[Ve.URL=0]="URL",Ve[Ve.LINEAR_GRADIENT=1]="LINEAR_GRADIENT",Ve[Ve.RADIAL_GRADIENT=2]="RADIAL_GRADIENT";var rt,nt,Bt,st;(nt=rt||(rt={}))[nt.CIRCLE=0]="CIRCLE",nt[nt.ELLIPSE=1]="ELLIPSE",(st=Bt||(Bt={}))[st.CLOSEST_SIDE=0]="CLOSEST_SIDE",st[st.FARTHEST_SIDE=1]="FARTHEST_SIDE",st[st.CLOSEST_CORNER=2]="CLOSEST_CORNER",st[st.FARTHEST_CORNER=3]="FARTHEST_CORNER";var ot=function(A){if(A.type===sA.URL_TOKEN){var e={url:A.value,type:Pe.URL};return Se.getInstance().addImage(A.value),e}if(A.type!==sA.FUNCTION)throw new Error("Unsupported image type");var t=ct[A.name];if(void 0===t)throw new Error('Attempting to parse an unsupported image function "'+A.name+'"');return t(A.values)};var it,at,ct={"linear-gradient":function(A){var n=Qe(180),B=[];return WA(A).forEach(function(A,e){if(0===e){var t=A[0];if(t.type===sA.IDENT_TOKEN&&"to"===t.value)return void(n=Ae(A));if($A(t))return void(n=ce(t))}var r=He(A);B.push(r)}),{angle:n,stops:B,type:Pe.LINEAR_GRADIENT}},"-moz-linear-gradient":Ie,"-ms-linear-gradient":Ie,"-o-linear-gradient":Ie,"-webkit-linear-gradient":Ie,"radial-gradient":function(A){var B=rt.CIRCLE,s=Bt.FARTHEST_CORNER,o=[],i=[];return WA(A).forEach(function(A,e){var t=!0;if(0===e){var r=!1;t=A.reduce(function(A,e){if(r)if(zA(e))switch(e.value){case"center":return i.push(oe),A;case"top":case"left":return i.push(se),A;case"right":case"bottom":return i.push(ie),A}else(qA(e)||YA(e))&&i.push(e);else if(zA(e))switch(e.value){case"circle":return B=rt.CIRCLE,!1;case et:return B=rt.ELLIPSE,!1;case"at":return!(r=!0);case Ze:return s=Bt.CLOSEST_SIDE,!1;case"cover":case je:return s=Bt.FARTHEST_SIDE,!1;case tt:case $e:return s=Bt.CLOSEST_CORNER,!1;case At:return s=Bt.FARTHEST_CORNER,!1}else if(YA(e)||qA(e))return Array.isArray(s)||(s=[]),s.push(e),!1;return A},t)}if(t){var n=He(A);o.push(n)}}),{size:s,shape:B,stops:o,position:i,type:Pe.RADIAL_GRADIENT}},"-moz-radial-gradient":xe,"-ms-radial-gradient":xe,"-o-radial-gradient":xe,"-webkit-radial-gradient":xe,"-webkit-gradient":function(A){var e=Qe(180),s=[],o=Pe.LINEAR_GRADIENT,t=rt.CIRCLE,r=Bt.FARTHEST_CORNER;return WA(A).forEach(function(A,e){var t=A[0];if(0===e){if(zA(t)&&"linear"===t.value)return void(o=Pe.LINEAR_GRADIENT);if(zA(t)&&"radial"===t.value)return void(o=Pe.RADIAL_GRADIENT)}if(t.type===sA.FUNCTION)if("from"===t.name){var r=ue(t.values[0]);s.push({stop:se,color:r})}else if("to"===t.name)r=ue(t.values[0]),s.push({stop:ie,color:r});else if("color-stop"===t.name){var n=t.values.filter(kA);if(2===n.length){r=ue(n[1]);var B=n[0];VA(B)&&s.push({stop:{type:sA.PERCENTAGE_TOKEN,number:100*B.number,flags:B.flags},color:r})}}}),o===Pe.LINEAR_GRADIENT?{angle:(e+Qe(180))%Qe(360),stops:s,type:o}:{size:r,shape:t,stops:s,position:[],type:o}}},Qt={name:"background-image",initialValue:"none",type:Ce.LIST,prefix:!1,parse:function(A){if(0===A.length)return[];var e=A[0];return e.type===sA.IDENT_TOKEN&&"none"===e.value?[]:A.filter(function(A){return kA(A)&&function(A){return A.type!==sA.FUNCTION||ct[A.name]}(A)}).map(ot)}},ut={name:"background-origin",initialValue:"border-box",prefix:!1,type:Ce.LIST,parse:function(A){return A.map(function(A){if(zA(A))switch(A.value){case"padding-box":return 1;case"content-box":return 2}return 0})}},wt={name:"background-position",initialValue:"0% 0%",type:Ce.LIST,prefix:!1,parse:function(A){return WA(A).map(function(A){return A.filter(qA)}).map(ZA)}};(at=it||(it={}))[at.REPEAT=0]="REPEAT",at[at.NO_REPEAT=1]="NO_REPEAT",at[at.REPEAT_X=2]="REPEAT_X";var Ut,lt,Ct={name:"background-repeat",initialValue:"repeat",prefix:!(at[at.REPEAT_Y=3]="REPEAT_Y"),type:Ce.LIST,parse:function(A){return WA(A).map(function(A){return A.filter(zA).map(function(A){return A.value}).join(" ")}).map(gt)}},gt=function(A){switch(A){case"no-repeat":return it.NO_REPEAT;case"repeat-x":case"repeat no-repeat":return it.REPEAT_X;case"repeat-y":case"no-repeat repeat":return it.REPEAT_Y;case"repeat":default:return it.REPEAT}};(lt=Ut||(Ut={})).AUTO="auto",lt.CONTAIN="contain";function Et(A){return{name:"border-"+A+"-color",initialValue:"transparent",prefix:!1,type:Ce.TYPE_VALUE,format:"color"}}function ht(A){return{name:"border-radius-"+A,initialValue:"0 0",prefix:!1,type:Ce.LIST,parse:function(A){return ZA(A.filter(qA))}}}var Ft,dt,Ht={name:"background-size",initialValue:"0",prefix:!(lt.COVER="cover"),type:Ce.LIST,parse:function(A){return WA(A).map(function(A){return A.filter(ft)})}},ft=function(A){return zA(A)||qA(A)},pt=Et("top"),Nt=Et("right"),Kt=Et("bottom"),It=Et("left"),Tt=ht("top-left"),mt=ht("top-right"),Rt=ht("bottom-right"),Lt=ht("bottom-left");(dt=Ft||(Ft={}))[dt.NONE=0]="NONE",dt[dt.SOLID=1]="SOLID",dt[dt.DASHED=2]="DASHED",dt[dt.DOTTED=3]="DOTTED",dt[dt.DOUBLE=4]="DOUBLE";function Ot(A){return{name:"border-"+A+"-style",initialValue:"solid",prefix:!1,type:Ce.IDENT_VALUE,parse:function(A){switch(A){case"none":return Ft.NONE;case"dashed":return Ft.DASHED;case"dotted":return Ft.DOTTED;case"double":return Ft.DOUBLE}return Ft.SOLID}}}function Dt(A){return{name:"border-"+A+"-width",initialValue:"0",type:Ce.VALUE,prefix:!1,parse:function(A){return PA(A)?A.number:0}}}var bt,vt,St=Ot("top"),Mt=Ot("right"),yt=Ot("bottom"),_t=Ot("left"),xt=Dt("top"),Pt=Dt("right"),Vt=Dt("bottom"),zt=Dt("left"),Xt={name:"color",initialValue:"transparent",prefix:!1,type:Ce.TYPE_VALUE,format:"color"},Gt={name:"display",initialValue:"inline-block",prefix:!1,type:Ce.LIST,parse:function(A){return A.filter(zA).reduce(function(A,e){return A|Jt(e.value)},0)}},Jt=function(A){switch(A){case"block":case"-webkit-box":return 2;case"inline":return 4;case"run-in":return 8;case"flow":return 16;case"flow-root":return 32;case"table":return 64;case"flex":case"-webkit-flex":return 128;case"grid":case"-ms-grid":return 256;case"ruby":return 512;case"subgrid":return 1024;case"list-item":return 2048;case"table-row-group":return 4096;case"table-header-group":return 8192;case"table-footer-group":return 16384;case"table-row":return 32768;case"table-cell":return 65536;case"table-column-group":return 131072;case"table-column":return 262144;case"table-caption":return 524288;case"ruby-base":return 1048576;case"ruby-text":return 2097152;case"ruby-base-container":return 4194304;case"ruby-text-container":return 8388608;case"contents":return 16777216;case"inline-block":return 33554432;case"inline-list-item":return 67108864;case"inline-table":return 134217728;case"inline-flex":return 268435456;case"inline-grid":return 536870912}return 0};(vt=bt||(bt={}))[vt.NONE=0]="NONE",vt[vt.LEFT=1]="LEFT",vt[vt.RIGHT=2]="RIGHT",vt[vt.INLINE_START=3]="INLINE_START";var kt,Wt,Yt,qt,Zt={name:"float",initialValue:"none",prefix:!(vt[vt.INLINE_END=4]="INLINE_END"),type:Ce.IDENT_VALUE,parse:function(A){switch(A){case"left":return bt.LEFT;case"right":return bt.RIGHT;case"inline-start":return bt.INLINE_START;case"inline-end":return bt.INLINE_END}return bt.NONE}},jt={name:"letter-spacing",initialValue:"0",prefix:!1,type:Ce.VALUE,parse:function(A){return A.type===sA.IDENT_TOKEN&&"normal"===A.value?0:A.type===sA.NUMBER_TOKEN?A.number:A.type===sA.DIMENSION_TOKEN?A.number:0}},$t={name:"line-break",initialValue:(Wt=kt||(kt={})).NORMAL="normal",prefix:!(Wt.STRICT="strict"),type:Ce.IDENT_VALUE,parse:function(A){switch(A){case"strict":return kt.STRICT;case"normal":default:return kt.NORMAL}}},Ar={name:"line-height",initialValue:"normal",prefix:!1,type:Ce.TOKEN_VALUE},er={name:"list-style-image",initialValue:"none",type:Ce.VALUE,prefix:!1,parse:function(A){return A.type===sA.IDENT_TOKEN&&"none"===A.value?null:ot(A)}};(qt=Yt||(Yt={}))[qt.INSIDE=0]="INSIDE";var tr,rr,nr={name:"list-style-position",initialValue:"outside",prefix:!(qt[qt.OUTSIDE=1]="OUTSIDE"),type:Ce.IDENT_VALUE,parse:function(A){switch(A){case"inside":return Yt.INSIDE;case"outside":default:return Yt.OUTSIDE}}};(rr=tr||(tr={}))[rr.NONE=-1]="NONE",rr[rr.DISC=0]="DISC",rr[rr.CIRCLE=1]="CIRCLE",rr[rr.SQUARE=2]="SQUARE",rr[rr.DECIMAL=3]="DECIMAL",rr[rr.CJK_DECIMAL=4]="CJK_DECIMAL",rr[rr.DECIMAL_LEADING_ZERO=5]="DECIMAL_LEADING_ZERO",rr[rr.LOWER_ROMAN=6]="LOWER_ROMAN",rr[rr.UPPER_ROMAN=7]="UPPER_ROMAN",rr[rr.LOWER_GREEK=8]="LOWER_GREEK",rr[rr.LOWER_ALPHA=9]="LOWER_ALPHA",rr[rr.UPPER_ALPHA=10]="UPPER_ALPHA",rr[rr.ARABIC_INDIC=11]="ARABIC_INDIC",rr[rr.ARMENIAN=12]="ARMENIAN",rr[rr.BENGALI=13]="BENGALI",rr[rr.CAMBODIAN=14]="CAMBODIAN",rr[rr.CJK_EARTHLY_BRANCH=15]="CJK_EARTHLY_BRANCH",rr[rr.CJK_HEAVENLY_STEM=16]="CJK_HEAVENLY_STEM",rr[rr.CJK_IDEOGRAPHIC=17]="CJK_IDEOGRAPHIC",rr[rr.DEVANAGARI=18]="DEVANAGARI",rr[rr.ETHIOPIC_NUMERIC=19]="ETHIOPIC_NUMERIC",rr[rr.GEORGIAN=20]="GEORGIAN",rr[rr.GUJARATI=21]="GUJARATI",rr[rr.GURMUKHI=22]="GURMUKHI",rr[rr.HEBREW=22]="HEBREW",rr[rr.HIRAGANA=23]="HIRAGANA",rr[rr.HIRAGANA_IROHA=24]="HIRAGANA_IROHA",rr[rr.JAPANESE_FORMAL=25]="JAPANESE_FORMAL",rr[rr.JAPANESE_INFORMAL=26]="JAPANESE_INFORMAL",rr[rr.KANNADA=27]="KANNADA",rr[rr.KATAKANA=28]="KATAKANA",rr[rr.KATAKANA_IROHA=29]="KATAKANA_IROHA",rr[rr.KHMER=30]="KHMER",rr[rr.KOREAN_HANGUL_FORMAL=31]="KOREAN_HANGUL_FORMAL",rr[rr.KOREAN_HANJA_FORMAL=32]="KOREAN_HANJA_FORMAL",rr[rr.KOREAN_HANJA_INFORMAL=33]="KOREAN_HANJA_INFORMAL",rr[rr.LAO=34]="LAO",rr[rr.LOWER_ARMENIAN=35]="LOWER_ARMENIAN",rr[rr.MALAYALAM=36]="MALAYALAM",rr[rr.MONGOLIAN=37]="MONGOLIAN",rr[rr.MYANMAR=38]="MYANMAR",rr[rr.ORIYA=39]="ORIYA",rr[rr.PERSIAN=40]="PERSIAN",rr[rr.SIMP_CHINESE_FORMAL=41]="SIMP_CHINESE_FORMAL",rr[rr.SIMP_CHINESE_INFORMAL=42]="SIMP_CHINESE_INFORMAL",rr[rr.TAMIL=43]="TAMIL",rr[rr.TELUGU=44]="TELUGU",rr[rr.THAI=45]="THAI",rr[rr.TIBETAN=46]="TIBETAN",rr[rr.TRAD_CHINESE_FORMAL=47]="TRAD_CHINESE_FORMAL",rr[rr.TRAD_CHINESE_INFORMAL=48]="TRAD_CHINESE_INFORMAL",rr[rr.UPPER_ARMENIAN=49]="UPPER_ARMENIAN",rr[rr.DISCLOSURE_OPEN=50]="DISCLOSURE_OPEN";function Br(A){return{name:"margin-"+A,initialValue:"0",prefix:!1,type:Ce.TOKEN_VALUE}}var sr,or,ir={name:"list-style-type",initialValue:"none",prefix:!(rr[rr.DISCLOSURE_CLOSED=51]="DISCLOSURE_CLOSED"),type:Ce.IDENT_VALUE,parse:function(A){switch(A){case"disc":return tr.DISC;case"circle":return tr.CIRCLE;case"square":return tr.SQUARE;case"decimal":return tr.DECIMAL;case"cjk-decimal":return tr.CJK_DECIMAL;case"decimal-leading-zero":return tr.DECIMAL_LEADING_ZERO;case"lower-roman":return tr.LOWER_ROMAN;case"upper-roman":return tr.UPPER_ROMAN;case"lower-greek":return tr.LOWER_GREEK;case"lower-alpha":return tr.LOWER_ALPHA;case"upper-alpha":return tr.UPPER_ALPHA;case"arabic-indic":return tr.ARABIC_INDIC;case"armenian":return tr.ARMENIAN;case"bengali":return tr.BENGALI;case"cambodian":return tr.CAMBODIAN;case"cjk-earthly-branch":return tr.CJK_EARTHLY_BRANCH;case"cjk-heavenly-stem":return tr.CJK_HEAVENLY_STEM;case"cjk-ideographic":return tr.CJK_IDEOGRAPHIC;case"devanagari":return tr.DEVANAGARI;case"ethiopic-numeric":return tr.ETHIOPIC_NUMERIC;case"georgian":return tr.GEORGIAN;case"gujarati":return tr.GUJARATI;case"gurmukhi":return tr.GURMUKHI;case"hebrew":return tr.HEBREW;case"hiragana":return tr.HIRAGANA;case"hiragana-iroha":return tr.HIRAGANA_IROHA;case"japanese-formal":return tr.JAPANESE_FORMAL;case"japanese-informal":return tr.JAPANESE_INFORMAL;case"kannada":return tr.KANNADA;case"katakana":return tr.KATAKANA;case"katakana-iroha":return tr.KATAKANA_IROHA;case"khmer":return tr.KHMER;case"korean-hangul-formal":return tr.KOREAN_HANGUL_FORMAL;case"korean-hanja-formal":return tr.KOREAN_HANJA_FORMAL;case"korean-hanja-informal":return tr.KOREAN_HANJA_INFORMAL;case"lao":return tr.LAO;case"lower-armenian":return tr.LOWER_ARMENIAN;case"malayalam":return tr.MALAYALAM;case"mongolian":return tr.MONGOLIAN;case"myanmar":return tr.MYANMAR;case"oriya":return tr.ORIYA;case"persian":return tr.PERSIAN;case"simp-chinese-formal":return tr.SIMP_CHINESE_FORMAL;case"simp-chinese-informal":return tr.SIMP_CHINESE_INFORMAL;case"tamil":return tr.TAMIL;case"telugu":return tr.TELUGU;case"thai":return tr.THAI;case"tibetan":return tr.TIBETAN;case"trad-chinese-formal":return tr.TRAD_CHINESE_FORMAL;case"trad-chinese-informal":return tr.TRAD_CHINESE_INFORMAL;case"upper-armenian":return tr.UPPER_ARMENIAN;case"disclosure-open":return tr.DISCLOSURE_OPEN;case"disclosure-closed":return tr.DISCLOSURE_CLOSED;case"none":default:return tr.NONE}}},ar=Br("top"),cr=Br("right"),Qr=Br("bottom"),ur=Br("left");(or=sr||(sr={}))[or.VISIBLE=0]="VISIBLE",or[or.HIDDEN=1]="HIDDEN",or[or.SCROLL=2]="SCROLL";function wr(A){return{name:"padding-"+A,initialValue:"0",prefix:!1,type:Ce.TYPE_VALUE,format:"length-percentage"}}var Ur,lr,Cr,gr,Er={name:"overflow",initialValue:"visible",prefix:!(or[or.AUTO=3]="AUTO"),type:Ce.LIST,parse:function(A){return A.filter(zA).map(function(A){switch(A.value){case"hidden":return sr.HIDDEN;case"scroll":return sr.SCROLL;case"auto":return sr.AUTO;case"visible":default:return sr.VISIBLE}})}},hr={name:"overflow-wrap",initialValue:(lr=Ur||(Ur={})).NORMAL="normal",prefix:!(lr.BREAK_WORD="break-word"),type:Ce.IDENT_VALUE,parse:function(A){switch(A){case"break-word":return Ur.BREAK_WORD;case"normal":default:return Ur.NORMAL}}},Fr=wr("top"),dr=wr("right"),Hr=wr("bottom"),fr=wr("left");(gr=Cr||(Cr={}))[gr.LEFT=0]="LEFT",gr[gr.CENTER=1]="CENTER";var pr,Nr,Kr={name:"text-align",initialValue:"left",prefix:!(gr[gr.RIGHT=2]="RIGHT"),type:Ce.IDENT_VALUE,parse:function(A){switch(A){case"right":return Cr.RIGHT;case"center":case"justify":return Cr.CENTER;case"left":default:return Cr.LEFT}}};(Nr=pr||(pr={}))[Nr.STATIC=0]="STATIC",Nr[Nr.RELATIVE=1]="RELATIVE",Nr[Nr.ABSOLUTE=2]="ABSOLUTE",Nr[Nr.FIXED=3]="FIXED";var Ir,Tr,mr={name:"position",initialValue:"static",prefix:!(Nr[Nr.STICKY=4]="STICKY"),type:Ce.IDENT_VALUE,parse:function(A){switch(A){case"relative":return pr.RELATIVE;case"absolute":return pr.ABSOLUTE;case"fixed":return pr.FIXED;case"sticky":return pr.STICKY}return pr.STATIC}},Rr={name:"text-shadow",initialValue:"none",type:Ce.LIST,prefix:!1,parse:function(A){return 1===A.length&&GA(A[0],"none")?[]:WA(A).map(function(A){for(var e={color:de.TRANSPARENT,offsetX:se,offsetY:se,blur:se},t=0,r=0;r<A.length;r++){var n=A[r];YA(n)?(0===t?e.offsetX=n:1===t?e.offsetY=n:e.blur=n,t++):e.color=ue(n)}return e})}};(Tr=Ir||(Ir={}))[Tr.NONE=0]="NONE",Tr[Tr.LOWERCASE=1]="LOWERCASE",Tr[Tr.UPPERCASE=2]="UPPERCASE";var Lr,Or,Dr={name:"text-transform",initialValue:"none",prefix:!(Tr[Tr.CAPITALIZE=3]="CAPITALIZE"),type:Ce.IDENT_VALUE,parse:function(A){switch(A){case"uppercase":return Ir.UPPERCASE;case"lowercase":return Ir.LOWERCASE;case"capitalize":return Ir.CAPITALIZE}return Ir.NONE}},br={name:"transform",initialValue:"none",prefix:!0,type:Ce.VALUE,parse:function(A){if(A.type===sA.IDENT_TOKEN&&"none"===A.value)return null;if(A.type!==sA.FUNCTION)return null;var e=vr[A.name];if(void 0===e)throw new Error('Attempting to parse an unsupported transform function "'+A.name+'"');return e(A.values)}},vr={matrix:function(A){var e=A.filter(function(A){return A.type===sA.NUMBER_TOKEN}).map(function(A){return A.number});return 6===e.length?e:null},matrix3d:function(A){var e=A.filter(function(A){return A.type===sA.NUMBER_TOKEN}).map(function(A){return A.number}),t=e[0],r=e[1],n=(e[2],e[3],e[4]),B=e[5],s=(e[6],e[7],e[8],e[9],e[10],e[11],e[12]),o=e[13];e[14],e[15];return 16===e.length?[t,r,n,B,s,o]:null}},Sr={type:sA.PERCENTAGE_TOKEN,number:50,flags:4},Mr=[Sr,Sr],yr={name:"transform-origin",initialValue:"50% 50%",prefix:!0,type:Ce.LIST,parse:function(A){var e=A.filter(qA);return 2!==e.length?Mr:[e[0],e[1]]}};(Or=Lr||(Lr={}))[Or.VISIBLE=0]="VISIBLE",Or[Or.HIDDEN=1]="HIDDEN";var _r,xr,Pr={name:"visible",initialValue:"none",prefix:!(Or[Or.COLLAPSE=2]="COLLAPSE"),type:Ce.IDENT_VALUE,parse:function(A){switch(A){case"hidden":return Lr.HIDDEN;case"collapse":return Lr.COLLAPSE;case"visible":default:return Lr.VISIBLE}}};(xr=_r||(_r={})).NORMAL="normal",xr.BREAK_ALL="break-all";var Vr,zr,Xr={name:"word-break",initialValue:"normal",prefix:!(xr.KEEP_ALL="keep-all"),type:Ce.IDENT_VALUE,parse:function(A){switch(A){case"break-all":return _r.BREAK_ALL;case"keep-all":return _r.KEEP_ALL;case"normal":default:return _r.NORMAL}}},Gr={name:"z-index",initialValue:"auto",prefix:!1,type:Ce.VALUE,parse:function(A){if(A.type===sA.IDENT_TOKEN)return{auto:!0,order:0};if(VA(A))return{auto:!1,order:A.number};throw new Error("Invalid z-index number parsed")}},Jr={name:"opacity",initialValue:"1",type:Ce.VALUE,prefix:!1,parse:function(A){return VA(A)?A.number:1}},kr={name:"text-decoration-color",initialValue:"transparent",prefix:!1,type:Ce.TYPE_VALUE,format:"color"},Wr={name:"text-decoration-line",initialValue:"none",prefix:!1,type:Ce.LIST,parse:function(A){return A.filter(zA).map(function(A){switch(A.value){case"underline":return 1;case"overline":return 2;case"line-through":return 3;case"none":return 4}return 0}).filter(function(A){return 0!==A})}},Yr={name:"font-family",initialValue:"",prefix:!1,type:Ce.LIST,parse:function(A){var e=[],t=[];return A.forEach(function(A){switch(A.type){case sA.IDENT_TOKEN:case sA.STRING_TOKEN:e.push(A.value);break;case sA.NUMBER_TOKEN:e.push(A.number.toString());break;case sA.COMMA_TOKEN:t.push(e.join(" ")),e.length=0}}),e.length&&t.push(e.join(" ")),t.map(function(A){return-1===A.indexOf(" ")?A:"'"+A+"'"})}},qr={name:"font-size",initialValue:"0",prefix:!1,type:Ce.TYPE_VALUE,format:"length"},Zr={name:"font-weight",initialValue:"normal",type:Ce.VALUE,prefix:!1,parse:function(A){if(VA(A))return A.number;if(zA(A))switch(A.value){case"bold":return 700;case"normal":default:return 400}return 400}},jr={name:"font-variant",initialValue:"none",type:Ce.LIST,prefix:!1,parse:function(A){return A.filter(zA).map(function(A){return A.value})}};(zr=Vr||(Vr={})).NORMAL="normal",zr.ITALIC="italic";function $r(A,e){return 0!=(A&e)}function An(A,e,t){if(!A)return"";var r=A[Math.min(e,A.length-1)];return r?t?r.open:r.close:""}var en={name:"font-style",initialValue:"normal",prefix:!(zr.OBLIQUE="oblique"),type:Ce.IDENT_VALUE,parse:function(A){switch(A){case"oblique":return Vr.OBLIQUE;case"italic":return Vr.ITALIC;case"normal":default:return Vr.NORMAL}}},tn={name:"content",initialValue:"none",type:Ce.LIST,prefix:!1,parse:function(A){if(0===A.length)return[];var e=A[0];return e.type===sA.IDENT_TOKEN&&"none"===e.value?[]:A}},rn={name:"counter-increment",initialValue:"none",prefix:!0,type:Ce.LIST,parse:function(A){if(0===A.length)return null;var e=A[0];if(e.type===sA.IDENT_TOKEN&&"none"===e.value)return null;for(var t=[],r=A.filter(JA),n=0;n<r.length;n++){var B=r[n],s=r[n+1];if(B.type===sA.IDENT_TOKEN){var o=s&&VA(s)?s.number:1;t.push({counter:B.value,increment:o})}}return t}},nn={name:"counter-reset",initialValue:"none",prefix:!0,type:Ce.LIST,parse:function(A){if(0===A.length)return[];for(var e=[],t=A.filter(JA),r=0;r<t.length;r++){var n=t[r],B=t[r+1];if(zA(n)&&"none"!==n.value){var s=B&&VA(B)?B.number:0;e.push({counter:n.value,reset:s})}}return e}},Bn={name:"quotes",initialValue:"none",prefix:!0,type:Ce.LIST,parse:function(A){if(0===A.length)return null;var e=A[0];if(e.type===sA.IDENT_TOKEN&&"none"===e.value)return null;var t=[],r=A.filter(XA);if(r.length%2!=0)return null;for(var n=0;n<r.length;n+=2){var B=r[n].value,s=r[n+1].value;t.push({open:B,close:s})}return t}},sn={name:"box-shadow",initialValue:"none",type:Ce.LIST,prefix:!1,parse:function(A){return 1===A.length&&GA(A[0],"none")?[]:WA(A).map(function(A){for(var e={color:255,offsetX:se,offsetY:se,blur:se,spread:se,inset:!1},t=0,r=0;r<A.length;r++){var n=A[r];GA(n,"inset")?e.inset=!0:YA(n)?(0===t?e.offsetX=n:1===t?e.offsetY=n:2===t?e.blur=n:e.spread=n,t++):e.color=ue(n)}return e})}},on=(an.prototype.isVisible=function(){return 0<this.display&&0<this.opacity&&this.visibility===Lr.VISIBLE},an.prototype.isTransparent=function(){return ee(this.backgroundColor)},an.prototype.isTransformed=function(){return null!==this.transform},an.prototype.isPositioned=function(){return this.position!==pr.STATIC},an.prototype.isPositionedWithZIndex=function(){return this.isPositioned()&&!this.zIndex.auto},an.prototype.isFloating=function(){return this.float!==bt.NONE},an.prototype.isInlineLevel=function(){return $r(this.display,4)||$r(this.display,33554432)||$r(this.display,268435456)||$r(this.display,536870912)||$r(this.display,67108864)||$r(this.display,134217728)},an);function an(A){this.backgroundClip=wn(me,A.backgroundClip),this.backgroundColor=wn(Re,A.backgroundColor),this.backgroundImage=wn(Qt,A.backgroundImage),this.backgroundOrigin=wn(ut,A.backgroundOrigin),this.backgroundPosition=wn(wt,A.backgroundPosition),this.backgroundRepeat=wn(Ct,A.backgroundRepeat),this.backgroundSize=wn(Ht,A.backgroundSize),this.borderTopColor=wn(pt,A.borderTopColor),this.borderRightColor=wn(Nt,A.borderRightColor),this.borderBottomColor=wn(Kt,A.borderBottomColor),this.borderLeftColor=wn(It,A.borderLeftColor),this.borderTopLeftRadius=wn(Tt,A.borderTopLeftRadius),this.borderTopRightRadius=wn(mt,A.borderTopRightRadius),this.borderBottomRightRadius=wn(Rt,A.borderBottomRightRadius),this.borderBottomLeftRadius=wn(Lt,A.borderBottomLeftRadius),this.borderTopStyle=wn(St,A.borderTopStyle),this.borderRightStyle=wn(Mt,A.borderRightStyle),this.borderBottomStyle=wn(yt,A.borderBottomStyle),this.borderLeftStyle=wn(_t,A.borderLeftStyle),this.borderTopWidth=wn(xt,A.borderTopWidth),this.borderRightWidth=wn(Pt,A.borderRightWidth),this.borderBottomWidth=wn(Vt,A.borderBottomWidth),this.borderLeftWidth=wn(zt,A.borderLeftWidth),this.boxShadow=wn(sn,A.boxShadow),this.color=wn(Xt,A.color),this.display=wn(Gt,A.display),this.float=wn(Zt,A.cssFloat),this.fontFamily=wn(Yr,A.fontFamily),this.fontSize=wn(qr,A.fontSize),this.fontStyle=wn(en,A.fontStyle),this.fontVariant=wn(jr,A.fontVariant),this.fontWeight=wn(Zr,A.fontWeight),this.letterSpacing=wn(jt,A.letterSpacing),this.lineBreak=wn($t,A.lineBreak),this.lineHeight=wn(Ar,A.lineHeight),this.listStyleImage=wn(er,A.listStyleImage),this.listStylePosition=wn(nr,A.listStylePosition),this.listStyleType=wn(ir,A.listStyleType),this.marginTop=wn(ar,A.marginTop),this.marginRight=wn(cr,A.marginRight),this.marginBottom=wn(Qr,A.marginBottom),this.marginLeft=wn(ur,A.marginLeft),this.opacity=wn(Jr,A.opacity);var e=wn(Er,A.overflow);this.overflowX=e[0],this.overflowY=e[1<e.length?1:0],this.overflowWrap=wn(hr,A.overflowWrap),this.paddingTop=wn(Fr,A.paddingTop),this.paddingRight=wn(dr,A.paddingRight),this.paddingBottom=wn(Hr,A.paddingBottom),this.paddingLeft=wn(fr,A.paddingLeft),this.position=wn(mr,A.position),this.textAlign=wn(Kr,A.textAlign),this.textDecorationColor=wn(kr,A.textDecorationColor||A.color),this.textDecorationLine=wn(Wr,A.textDecorationLine),this.textShadow=wn(Rr,A.textShadow),this.textTransform=wn(Dr,A.textTransform),this.transform=wn(br,A.transform),this.transformOrigin=wn(yr,A.transformOrigin),this.visibility=wn(Pr,A.visibility),this.wordBreak=wn(Xr,A.wordBreak),this.zIndex=wn(Gr,A.zIndex)}var cn,Qn=function(A){this.content=wn(tn,A.content),this.quotes=wn(Bn,A.quotes)},un=function(A){this.counterIncrement=wn(rn,A.counterIncrement),this.counterReset=wn(nn,A.counterReset)},wn=function(A,e){var t=new MA,r=null!=e?e.toString():A.initialValue;t.write(r);var n=new _A(t.read());switch(A.type){case Ce.IDENT_VALUE:var B=n.parseComponentValue();return A.parse(zA(B)?B.value:A.initialValue);case Ce.VALUE:return A.parse(n.parseComponentValue());case Ce.LIST:return A.parse(n.parseComponentValues());case Ce.TOKEN_VALUE:return n.parseComponentValue();case Ce.TYPE_VALUE:switch(A.format){case"angle":return ce(n.parseComponentValue());case"color":return ue(n.parseComponentValue());case"image":return ot(n.parseComponentValue());case"length":var s=n.parseComponentValue();return YA(s)?s:se;case"length-percentage":var o=n.parseComponentValue();return qA(o)?o:se}}throw new Error("Attempting to parse unsupported css format type "+A.format)},Un=function(A){this.styles=new on(window.getComputedStyle(A,null)),this.textNodes=[],this.elements=[],null!==this.styles.transform&&uB(A)&&(A.style.transform="none"),this.bounds=T(A),this.flags=0},ln=function(A,e){this.text=A,this.bounds=e},Cn=function(A){var e=A.ownerDocument;if(e){var t=e.createElement("html2canvaswrapper");t.appendChild(A.cloneNode(!0));var r=A.parentNode;if(r){r.replaceChild(t,A);var n=T(t);return t.firstChild&&r.replaceChild(t.firstChild,t),n}}return new I(0,0,0,0)},gn=function(A,e,t){var r=A.ownerDocument;if(!r)throw new Error("Node has no owner document");var n=r.createRange();return n.setStart(A,e),n.setEnd(A,e+t),I.fromClientRect(n.getBoundingClientRect())},En=function(A,e){return 0!==e.letterSpacing?c(A).map(function(A){return l(A)}):hn(A,e)},hn=function(A,e){for(var t,r=function(A,e){var t=c(A),r=w(t,e),n=r[0],B=r[1],s=r[2],o=t.length,i=0,a=0;return{next:function(){if(o<=a)return{done:!0,value:null};for(var A=Y;a<o&&(A=u(t,B,n,++a,s))===Y;);if(A===Y&&a!==o)return{done:!0,value:null};var e=new nA(t,A,i,a);return i=a,{value:e,done:!1}}}}(A,{lineBreak:e.lineBreak,wordBreak:e.overflowWrap===Ur.BREAK_WORD?"break-word":e.wordBreak}),n=[];!(t=r.next()).done;)t.value&&n.push(t.value.slice());return n},Fn=function(A,e){this.text=dn(A.data,e.textTransform),this.textBounds=function(A,t,r){var e=En(A,t),n=[],B=0;return e.forEach(function(A){if(t.textDecorationLine.length||0<A.trim().length)if(De.SUPPORT_RANGE_BOUNDS)n.push(new ln(A,gn(r,B,A.length)));else{var e=r.splitText(A.length);n.push(new ln(A,Cn(r))),r=e}else De.SUPPORT_RANGE_BOUNDS||(r=r.splitText(A.length));B+=A.length}),n}(this.text,e,A)},dn=function(A,e){switch(e){case Ir.LOWERCASE:return A.toLowerCase();case Ir.CAPITALIZE:return A.replace(Hn,fn);case Ir.UPPERCASE:return A.toUpperCase();default:return A}},Hn=/(^|\s|:|-|\(|\))([a-z])/g,fn=function(A,e,t){return 0<A.length?e+t.toUpperCase():A},pn=(A(Nn,cn=Un),Nn);function Nn(A){var e=cn.call(this,A)||this;return e.src=A.currentSrc||A.src,e.intrinsicWidth=A.naturalWidth,e.intrinsicHeight=A.naturalHeight,Se.getInstance().addImage(e.src),e}var Kn,In=(A(Tn,Kn=Un),Tn);function Tn(A){var e=Kn.call(this,A)||this;return e.canvas=A,e.intrinsicWidth=A.width,e.intrinsicHeight=A.height,e}var mn,Rn=(A(Ln,mn=Un),Ln);function Ln(A){var e=mn.call(this,A)||this,t=new XMLSerializer;return e.svg="data:image/svg+xml,"+encodeURIComponent(t.serializeToString(A)),e.intrinsicWidth=A.width.baseVal.value,e.intrinsicHeight=A.height.baseVal.value,Se.getInstance().addImage(e.svg),e}var On,Dn=(A(bn,On=Un),bn);function bn(A){var e=On.call(this,A)||this;return e.value=A.value,e}var vn,Sn=(A(Mn,vn=Un),Mn);function Mn(A){var e=vn.call(this,A)||this;return e.start=A.start,e.reversed="boolean"==typeof A.reversed&&!0===A.reversed,e}var yn,_n=[{type:sA.DIMENSION_TOKEN,flags:0,unit:"px",number:3}],xn=[{type:sA.PERCENTAGE_TOKEN,flags:0,number:50}],Pn="checkbox",Vn="radio",zn="password",Xn=707406591,Gn=(A(Jn,yn=Un),Jn);function Jn(A){var e=yn.call(this,A)||this;switch(e.type=A.type.toLowerCase(),e.checked=A.checked,e.value=function(A){var e=A.type===zn?new Array(A.value.length+1).join("•"):A.value;return 0===e.length?A.placeholder||"":e}(A),e.type!==Pn&&e.type!==Vn||(e.styles.backgroundColor=3739148031,e.styles.borderTopColor=e.styles.borderRightColor=e.styles.borderBottomColor=e.styles.borderLeftColor=2779096575,e.styles.borderTopWidth=e.styles.borderRightWidth=e.styles.borderBottomWidth=e.styles.borderLeftWidth=1,e.styles.borderTopStyle=e.styles.borderRightStyle=e.styles.borderBottomStyle=e.styles.borderLeftStyle=Ft.SOLID,e.styles.backgroundClip=[Ee.BORDER_BOX],e.styles.backgroundOrigin=[0],e.bounds=function(A){return A.width>A.height?new I(A.left+(A.width-A.height)/2,A.top,A.height,A.height):A.width<A.height?new I(A.left,A.top+(A.height-A.width)/2,A.width,A.width):A}(e.bounds)),e.type){case Pn:e.styles.borderTopRightRadius=e.styles.borderTopLeftRadius=e.styles.borderBottomRightRadius=e.styles.borderBottomLeftRadius=_n;break;case Vn:e.styles.borderTopRightRadius=e.styles.borderTopLeftRadius=e.styles.borderBottomRightRadius=e.styles.borderBottomLeftRadius=xn}return e}var kn,Wn=(A(Yn,kn=Un),Yn);function Yn(A){var e=kn.call(this,A)||this,t=A.options[A.selectedIndex||0];return e.value=t&&t.text||"",e}var qn,Zn=(A(jn,qn=Un),jn);function jn(A){var e=qn.call(this,A)||this;return e.value=A.value,e}function $n(A){return ue(_A.create(A).parseComponentValue())}var AB,eB=(A(tB,AB=Un),tB);function tB(A){var e=AB.call(this,A)||this;e.src=A.src,e.width=parseInt(A.width,10)||0,e.height=parseInt(A.height,10)||0,e.backgroundColor=e.styles.backgroundColor;try{if(A.contentWindow&&A.contentWindow.document&&A.contentWindow.document.documentElement){e.tree=oB(A.contentWindow.document.documentElement);var t=A.contentWindow.document.documentElement?$n(getComputedStyle(A.contentWindow.document.documentElement).backgroundColor):de.TRANSPARENT,r=A.contentWindow.document.body?$n(getComputedStyle(A.contentWindow.document.body).backgroundColor):de.TRANSPARENT;e.backgroundColor=ee(t)?ee(r)?e.styles.backgroundColor:r:t}}catch(A){}return e}function rB(A){return"STYLE"===A.tagName}var nB=["OL","UL","MENU"],BB=function(A,e,t){for(var r=A.firstChild,n=void 0;r;r=n)if(n=r.nextSibling,cB(r)&&0<r.data.trim().length)e.textNodes.push(new Fn(r,e.styles));else if(QB(r)){var B=sB(r);B.styles.isVisible()&&(iB(r,B,t)?B.flags|=4:aB(B.styles)&&(B.flags|=2),-1!==nB.indexOf(r.tagName)&&(B.flags|=8),e.elements.push(B),HB(r)||gB(r)||fB(r)||BB(r,B,t))}},sB=function(A){return FB(A)?new pn(A):hB(A)?new In(A):gB(A)?new Rn(A):UB(A)?new Dn(A):lB(A)?new Sn(A):CB(A)?new Gn(A):fB(A)?new Wn(A):HB(A)?new Zn(A):dB(A)?new eB(A):new Un(A)},oB=function(A){var e=sB(A);return e.flags|=4,BB(A,e,e),e},iB=function(A,e,t){return e.styles.isPositionedWithZIndex()||e.styles.opacity<1||e.styles.isTransformed()||EB(A)&&t.styles.isTransparent()},aB=function(A){return A.isPositioned()||A.isFloating()},cB=function(A){return A.nodeType===Node.TEXT_NODE},QB=function(A){return A.nodeType===Node.ELEMENT_NODE},uB=function(A){return QB(A)&&void 0!==A.style&&!wB(A)},wB=function(A){return"object"==typeof A.className},UB=function(A){return"LI"===A.tagName},lB=function(A){return"OL"===A.tagName},CB=function(A){return"INPUT"===A.tagName},gB=function(A){return"svg"===A.tagName},EB=function(A){return"BODY"===A.tagName},hB=function(A){return"CANVAS"===A.tagName},FB=function(A){return"IMG"===A.tagName},dB=function(A){return"IFRAME"===A.tagName},HB=function(A){return"TEXTAREA"===A.tagName},fB=function(A){return"SELECT"===A.tagName},pB=(NB.prototype.getCounterValue=function(A){var e=this.counters[A];return e&&e.length?e[e.length-1]:1},NB.prototype.getCounterValues=function(A){var e=this.counters[A];return e||[]},NB.prototype.pop=function(A){var e=this;A.forEach(function(A){return e.counters[A].pop()})},NB.prototype.parse=function(A){var t=this,e=A.counterIncrement,r=A.counterReset,n=!0;null!==e&&e.forEach(function(A){var e=t.counters[A.counter];e&&0!==A.increment&&(n=!1,e[Math.max(0,e.length-1)]+=A.increment)});var B=[];return n&&r.forEach(function(A){var e=t.counters[A.counter];B.push(A.counter),e||(e=t.counters[A.counter]=[]),e.push(A.reset)}),B},NB);function NB(){this.counters={}}function KB(r,A,e,n,t,B){return r<A||e<r?yB(r,t,0<B.length):n.integers.reduce(function(A,e,t){for(;e<=r;)r-=e,A+=n.values[t];return A},"")+B}function IB(A,e,t,r){for(var n="";t||A--,n=r(A)+n,e<=(A/=e)*e;);return n}function TB(A,e,t,r,n){var B=t-e+1;return(A<0?"-":"")+(IB(Math.abs(A),B,r,function(A){return l(Math.floor(A%B)+e)})+n)}function mB(A,e,t){void 0===t&&(t=". ");var r=e.length;return IB(Math.abs(A),r,!1,function(A){return e[Math.floor(A%r)]})+t}function RB(A,e,t,r,n,B){if(A<-9999||9999<A)return yB(A,tr.CJK_DECIMAL,0<n.length);var s=Math.abs(A),o=n;if(0===s)return e[0]+o;for(var i=0;0<s&&i<=4;i++){var a=s%10;0==a&&$r(B,1)&&""!==o?o=e[a]+o:1<a||1==a&&0===i||1==a&&1===i&&$r(B,2)||1==a&&1===i&&$r(B,4)&&100<A||1==a&&1<i&&$r(B,8)?o=e[a]+(0<i?t[i-1]:"")+o:1==a&&0<i&&(o=t[i-1]+o),s=Math.floor(s/10)}return(A<0?r:"")+o}var LB,OB,DB={integers:[1e3,900,500,400,100,90,50,40,10,9,5,4,1],values:["M","CM","D","CD","C","XC","L","XL","X","IX","V","IV","I"]},bB={integers:[9e3,8e3,7e3,6e3,5e3,4e3,3e3,2e3,1e3,900,800,700,600,500,400,300,200,100,90,80,70,60,50,40,30,20,10,9,8,7,6,5,4,3,2,1],values:["Ք","Փ","Ւ","Ց","Ր","Տ","Վ","Ս","Ռ","Ջ","Պ","Չ","Ո","Շ","Ն","Յ","Մ","Ճ","Ղ","Ձ","Հ","Կ","Ծ","Խ","Լ","Ի","Ժ","Թ","Ը","Է","Զ","Ե","Դ","Գ","Բ","Ա"]},vB={integers:[1e4,9e3,8e3,7e3,6e3,5e3,4e3,3e3,2e3,1e3,400,300,200,100,90,80,70,60,50,40,30,20,19,18,17,16,15,10,9,8,7,6,5,4,3,2,1],values:["י׳","ט׳","ח׳","ז׳","ו׳","ה׳","ד׳","ג׳","ב׳","א׳","ת","ש","ר","ק","צ","פ","ע","ס","נ","מ","ל","כ","יט","יח","יז","טז","טו","י","ט","ח","ז","ו","ה","ד","ג","ב","א"]},SB={integers:[1e4,9e3,8e3,7e3,6e3,5e3,4e3,3e3,2e3,1e3,900,800,700,600,500,400,300,200,100,90,80,70,60,50,40,30,20,10,9,8,7,6,5,4,3,2,1],values:["ჵ","ჰ","ჯ","ჴ","ხ","ჭ","წ","ძ","ც","ჩ","შ","ყ","ღ","ქ","ფ","ჳ","ტ","ს","რ","ჟ","პ","ო","ჲ","ნ","მ","ლ","კ","ი","თ","ჱ","ზ","ვ","ე","დ","გ","ბ","ა"]},MB="마이너스",yB=function(A,e,t){var r=t?". ":"",n=t?"、":"",B=t?", ":"",s=t?" ":"";switch(e){case tr.DISC:return"•"+s;case tr.CIRCLE:return"◦"+s;case tr.SQUARE:return"◾"+s;case tr.DECIMAL_LEADING_ZERO:var o=TB(A,48,57,!0,r);return o.length<4?"0"+o:o;case tr.CJK_DECIMAL:return mB(A,"〇一二三四五六七八九",n);case tr.LOWER_ROMAN:return KB(A,1,3999,DB,tr.DECIMAL,r).toLowerCase();case tr.UPPER_ROMAN:return KB(A,1,3999,DB,tr.DECIMAL,r);case tr.LOWER_GREEK:return TB(A,945,969,!1,r);case tr.LOWER_ALPHA:return TB(A,97,122,!1,r);case tr.UPPER_ALPHA:return TB(A,65,90,!1,r);case tr.ARABIC_INDIC:return TB(A,1632,1641,!0,r);case tr.ARMENIAN:case tr.UPPER_ARMENIAN:return KB(A,1,9999,bB,tr.DECIMAL,r);case tr.LOWER_ARMENIAN:return KB(A,1,9999,bB,tr.DECIMAL,r).toLowerCase();case tr.BENGALI:return TB(A,2534,2543,!0,r);case tr.CAMBODIAN:case tr.KHMER:return TB(A,6112,6121,!0,r);case tr.CJK_EARTHLY_BRANCH:return mB(A,"子丑寅卯辰巳午未申酉戌亥",n);case tr.CJK_HEAVENLY_STEM:return mB(A,"甲乙丙丁戊己庚辛壬癸",n);case tr.CJK_IDEOGRAPHIC:case tr.TRAD_CHINESE_INFORMAL:return RB(A,"零一二三四五六七八九","十百千萬","負",n,14);case tr.TRAD_CHINESE_FORMAL:return RB(A,"零壹貳參肆伍陸柒捌玖","拾佰仟萬","負",n,15);case tr.SIMP_CHINESE_INFORMAL:return RB(A,"零一二三四五六七八九","十百千萬","负",n,14);case tr.SIMP_CHINESE_FORMAL:return RB(A,"零壹贰叁肆伍陆柒捌玖","拾佰仟萬","负",n,15);case tr.JAPANESE_INFORMAL:return RB(A,"〇一二三四五六七八九","十百千万","マイナス",n,0);case tr.JAPANESE_FORMAL:return RB(A,"零壱弐参四伍六七八九","拾百千万","マイナス",n,7);case tr.KOREAN_HANGUL_FORMAL:return RB(A,"영일이삼사오육칠팔구","십백천만",MB,B,7);case tr.KOREAN_HANJA_INFORMAL:return RB(A,"零一二三四五六七八九","十百千萬",MB,B,0);case tr.KOREAN_HANJA_FORMAL:return RB(A,"零壹貳參四五六七八九","拾百千",MB,B,7);case tr.DEVANAGARI:return TB(A,2406,2415,!0,r);case tr.GEORGIAN:return KB(A,1,19999,SB,tr.DECIMAL,r);case tr.GUJARATI:return TB(A,2790,2799,!0,r);case tr.GURMUKHI:return TB(A,2662,2671,!0,r);case tr.HEBREW:return KB(A,1,10999,vB,tr.DECIMAL,r);case tr.HIRAGANA:return mB(A,"あいうえおかきくけこさしすせそたちつてとなにぬねのはひふへほまみむめもやゆよらりるれろわゐゑをん");case tr.HIRAGANA_IROHA:return mB(A,"いろはにほへとちりぬるをわかよたれそつねならむうゐのおくやまけふこえてあさきゆめみしゑひもせす");case tr.KANNADA:return TB(A,3302,3311,!0,r);case tr.KATAKANA:return mB(A,"アイウエオカキクケコサシスセソタチツテトナニヌネノハヒフヘホマミムメモヤユヨラリルレロワヰヱヲン",n);case tr.KATAKANA_IROHA:return mB(A,"イロハニホヘトチリヌルヲワカヨタレソツネナラムウヰノオクヤマケフコエテアサキユメミシヱヒモセス",n);case tr.LAO:return TB(A,3792,3801,!0,r);case tr.MONGOLIAN:return TB(A,6160,6169,!0,r);case tr.MYANMAR:return TB(A,4160,4169,!0,r);case tr.ORIYA:return TB(A,2918,2927,!0,r);case tr.PERSIAN:return TB(A,1776,1785,!0,r);case tr.TAMIL:return TB(A,3046,3055,!0,r);case tr.TELUGU:return TB(A,3174,3183,!0,r);case tr.THAI:return TB(A,3664,3673,!0,r);case tr.TIBETAN:return TB(A,3872,3881,!0,r);case tr.DECIMAL:default:return TB(A,48,57,!0,r)}},_B="data-html2canvas-ignore",xB=(PB.prototype.toIFrame=function(A,t){var e=this,r=XB(A,t);if(!r.contentWindow)return Promise.reject("Unable to find iframe window");var n=A.defaultView.pageXOffset,B=A.defaultView.pageYOffset,s=r.contentWindow,o=s.document,i=GB(r).then(function(){return a(e,void 0,void 0,function(){var e;return S(this,function(A){switch(A.label){case 0:return this.scrolledElements.forEach(YB),s&&(s.scrollTo(t.left,t.top),!/(iPad|iPhone|iPod)/g.test(navigator.userAgent)||s.scrollY===t.top&&s.scrollX===t.left||(o.documentElement.style.top=-t.top+"px",o.documentElement.style.left=-t.left+"px",o.documentElement.style.position="absolute")),e=this.options.onclone,void 0===this.clonedReferenceElement?[2,Promise.reject("Error finding the "+this.referenceElement.nodeName+" in the cloned document")]:o.fonts&&o.fonts.ready?[4,o.fonts.ready]:[3,2];case 1:A.sent(),A.label=2;case 2:return"function"==typeof e?[2,Promise.resolve().then(function(){return e(o)}).then(function(){return r})]:[2,r]}})})});return o.open(),o.write(kB(document.doctype)+"<html></html>"),WB(this.referenceElement.ownerDocument,n,B),o.replaceChild(o.adoptNode(this.documentElement),o.documentElement),o.close(),i},PB.prototype.createElementClone=function(A){if(hB(A))return this.createCanvasClone(A);if(rB(A))return this.createStyleClone(A);var e=A.cloneNode(!1);return FB(e)&&"lazy"===e.loading&&(e.loading="eager"),e},PB.prototype.createStyleClone=function(A){try{var e=A.sheet;if(e&&e.cssRules){var t=[].slice.call(e.cssRules,0).reduce(function(A,e){return e&&"string"==typeof e.cssText?A+e.cssText:A},""),r=A.cloneNode(!1);return r.textContent=t,r}}catch(A){if(be.getInstance(this.options.id).error("Unable to access cssRules property",A),"SecurityError"!==A.name)throw A}return A.cloneNode(!1)},PB.prototype.createCanvasClone=function(A){if(this.options.inlineImages&&A.ownerDocument){var e=A.ownerDocument.createElement("img");try{return e.src=A.toDataURL(),e}catch(A){be.getInstance(this.options.id).info("Unable to clone canvas contents, canvas is tainted")}}var t=A.cloneNode(!1);try{t.width=A.width,t.height=A.height;var r=A.getContext("2d"),n=t.getContext("2d");return n&&(r?n.putImageData(r.getImageData(0,0,A.width,A.height),0,0):n.drawImage(A,0,0)),t}catch(A){}return t},PB.prototype.cloneNode=function(A){if(cB(A))return document.createTextNode(A.data);if(!A.ownerDocument)return A.cloneNode(!1);var e=A.ownerDocument.defaultView;if(e&&QB(A)&&(uB(A)||wB(A))){var t=this.createElementClone(A),r=e.getComputedStyle(A),n=e.getComputedStyle(A,":before"),B=e.getComputedStyle(A,":after");this.referenceElement===A&&uB(t)&&(this.clonedReferenceElement=t),EB(t)&&$B(t);for(var s=this.counters.parse(new un(r)),o=this.resolvePseudoContent(A,t,n,LB.BEFORE),i=A.firstChild;i;i=i.nextSibling)QB(i)&&("SCRIPT"===i.tagName||i.hasAttribute(_B)||"function"==typeof this.options.ignoreElements&&this.options.ignoreElements(i))||this.options.copyStyles&&QB(i)&&rB(i)||t.appendChild(this.cloneNode(i));o&&t.insertBefore(o,t.firstChild);var a=this.resolvePseudoContent(A,t,B,LB.AFTER);return a&&t.appendChild(a),this.counters.pop(s),r&&(this.options.copyStyles||wB(A))&&!dB(A)&&JB(r,t),0===A.scrollTop&&0===A.scrollLeft||this.scrolledElements.push([t,A.scrollLeft,A.scrollTop]),(HB(A)||fB(A))&&(HB(t)||fB(t))&&(t.value=A.value),t}return A.cloneNode(!1)},PB.prototype.resolvePseudoContent=function(U,A,e,t){var l=this;if(e){var r=e.content,C=A.ownerDocument;if(C&&r&&"none"!==r&&"-moz-alt-content"!==r&&"none"!==e.display){this.counters.parse(new un(e));var g=new Qn(e),E=C.createElement("html2canvaspseudoelement");JB(e,E),g.content.forEach(function(A){if(A.type===sA.STRING_TOKEN)E.appendChild(C.createTextNode(A.value));else if(A.type===sA.URL_TOKEN){var e=C.createElement("img");e.src=A.value,e.style.opacity="1",E.appendChild(e)}else if(A.type===sA.FUNCTION){if("attr"===A.name){var t=A.values.filter(zA);t.length&&E.appendChild(C.createTextNode(U.getAttribute(t[0].value)||""))}else if("counter"===A.name){var r=A.values.filter(kA),n=r[0],B=r[1];if(n&&zA(n)){var s=l.counters.getCounterValue(n.value),o=B&&zA(B)?ir.parse(B.value):tr.DECIMAL;E.appendChild(C.createTextNode(yB(s,o,!1)))}}else if("counters"===A.name){var i=A.values.filter(kA),a=(n=i[0],i[1]);if(B=i[2],n&&zA(n)){var c=l.counters.getCounterValues(n.value),Q=B&&zA(B)?ir.parse(B.value):tr.DECIMAL,u=a&&a.type===sA.STRING_TOKEN?a.value:"",w=c.map(function(A){return yB(A,Q,!1)}).join(u);E.appendChild(C.createTextNode(w))}}}else if(A.type===sA.IDENT_TOKEN)switch(A.value){case"open-quote":E.appendChild(C.createTextNode(An(g.quotes,l.quoteDepth++,!0)));break;case"close-quote":E.appendChild(C.createTextNode(An(g.quotes,--l.quoteDepth,!1)));break;default:E.appendChild(C.createTextNode(A.value))}}),E.className=qB+" "+ZB;var n=t===LB.BEFORE?" "+qB:" "+ZB;return wB(A)?A.className.baseValue+=n:A.className+=n,E}}},PB.destroy=function(A){return!!A.parentNode&&(A.parentNode.removeChild(A),!0)},PB);function PB(A,e){if(this.options=e,this.scrolledElements=[],this.referenceElement=A,this.counters=new pB,this.quoteDepth=0,!A.ownerDocument)throw new Error("Cloned element does not have an owner document");this.documentElement=this.cloneNode(A.ownerDocument.documentElement)}(OB=LB||(LB={}))[OB.BEFORE=0]="BEFORE",OB[OB.AFTER=1]="AFTER";var VB,zB,XB=function(A,e){var t=A.createElement("iframe");return t.className="html2canvas-container",t.style.visibility="hidden",t.style.position="fixed",t.style.left="-10000px",t.style.top="0px",t.style.border="0",t.width=e.width.toString(),t.height=e.height.toString(),t.scrolling="no",t.setAttribute(_B,"true"),A.body.appendChild(t),t},GB=function(n){return new Promise(function(e,A){var t=n.contentWindow;if(!t)return A("No window assigned for iframe");var r=t.document;t.onload=n.onload=r.onreadystatechange=function(){t.onload=n.onload=r.onreadystatechange=null;var A=setInterval(function(){0<r.body.childNodes.length&&"complete"===r.readyState&&(clearInterval(A),e(n))},50)}})},JB=function(A,e){for(var t=A.length-1;0<=t;t--){var r=A.item(t);"content"!==r&&e.style.setProperty(r,A.getPropertyValue(r))}return e},kB=function(A){var e="";return A&&(e+="<!DOCTYPE ",A.name&&(e+=A.name),A.internalSubset&&(e+=A.internalSubset),A.publicId&&(e+='"'+A.publicId+'"'),A.systemId&&(e+='"'+A.systemId+'"'),e+=">"),e},WB=function(A,e,t){A&&A.defaultView&&(e!==A.defaultView.pageXOffset||t!==A.defaultView.pageYOffset)&&A.defaultView.scrollTo(e,t)},YB=function(A){var e=A[0],t=A[1],r=A[2];e.scrollLeft=t,e.scrollTop=r},qB="___html2canvas___pseudoelement_before",ZB="___html2canvas___pseudoelement_after",jB='{\n    content: "" !important;\n    display: none !important;\n}',$B=function(A){As(A,"."+qB+":before"+jB+"\n         ."+ZB+":after"+jB)},As=function(A,e){var t=A.ownerDocument;if(t){var r=t.createElement("style");r.textContent=e,A.appendChild(r)}};(zB=VB||(VB={}))[zB.VECTOR=0]="VECTOR",zB[zB.BEZIER_CURVE=1]="BEZIER_CURVE";function es(A,t){return A.length===t.length&&A.some(function(A,e){return A===t[e]})}var ts=(rs.prototype.add=function(A,e){return new rs(this.x+A,this.y+e)},rs);function rs(A,e){this.type=VB.VECTOR,this.x=A,this.y=e}function ns(A,e,t){return new ts(A.x+(e.x-A.x)*t,A.y+(e.y-A.y)*t)}var Bs=(ss.prototype.subdivide=function(A,e){var t=ns(this.start,this.startControl,A),r=ns(this.startControl,this.endControl,A),n=ns(this.endControl,this.end,A),B=ns(t,r,A),s=ns(r,n,A),o=ns(B,s,A);return e?new ss(this.start,t,B,o):new ss(o,s,n,this.end)},ss.prototype.add=function(A,e){return new ss(this.start.add(A,e),this.startControl.add(A,e),this.endControl.add(A,e),this.end.add(A,e))},ss.prototype.reverse=function(){return new ss(this.end,this.endControl,this.startControl,this.start)},ss);function ss(A,e,t,r){this.type=VB.BEZIER_CURVE,this.start=A,this.startControl=e,this.endControl=t,this.end=r}function os(A){return A.type===VB.BEZIER_CURVE}var is,as,cs=function(A){var e=A.styles,t=A.bounds,r=jA(e.borderTopLeftRadius,t.width,t.height),n=r[0],B=r[1],s=jA(e.borderTopRightRadius,t.width,t.height),o=s[0],i=s[1],a=jA(e.borderBottomRightRadius,t.width,t.height),c=a[0],Q=a[1],u=jA(e.borderBottomLeftRadius,t.width,t.height),w=u[0],U=u[1],l=[];l.push((n+o)/t.width),l.push((w+c)/t.width),l.push((B+U)/t.height),l.push((i+Q)/t.height);var C=Math.max.apply(Math,l);1<C&&(n/=C,B/=C,o/=C,i/=C,c/=C,Q/=C,w/=C,U/=C);var g=t.width-o,E=t.height-Q,h=t.width-c,F=t.height-U,d=e.borderTopWidth,H=e.borderRightWidth,f=e.borderBottomWidth,p=e.borderLeftWidth,N=ae(e.paddingTop,A.bounds.width),K=ae(e.paddingRight,A.bounds.width),I=ae(e.paddingBottom,A.bounds.width),T=ae(e.paddingLeft,A.bounds.width);this.topLeftBorderDoubleOuterBox=0<n||0<B?ws(t.left+p/3,t.top+d/3,n-p/3,B-d/3,is.TOP_LEFT):new ts(t.left+p/3,t.top+d/3),this.topRightBorderDoubleOuterBox=0<n||0<B?ws(t.left+g,t.top+d/3,o-H/3,i-d/3,is.TOP_RIGHT):new ts(t.left+t.width-H/3,t.top+d/3),this.bottomRightBorderDoubleOuterBox=0<c||0<Q?ws(t.left+h,t.top+E,c-H/3,Q-f/3,is.BOTTOM_RIGHT):new ts(t.left+t.width-H/3,t.top+t.height-f/3),this.bottomLeftBorderDoubleOuterBox=0<w||0<U?ws(t.left+p/3,t.top+F,w-p/3,U-f/3,is.BOTTOM_LEFT):new ts(t.left+p/3,t.top+t.height-f/3),this.topLeftBorderDoubleInnerBox=0<n||0<B?ws(t.left+2*p/3,t.top+2*d/3,n-2*p/3,B-2*d/3,is.TOP_LEFT):new ts(t.left+2*p/3,t.top+2*d/3),this.topRightBorderDoubleInnerBox=0<n||0<B?ws(t.left+g,t.top+2*d/3,o-2*H/3,i-2*d/3,is.TOP_RIGHT):new ts(t.left+t.width-2*H/3,t.top+2*d/3),this.bottomRightBorderDoubleInnerBox=0<c||0<Q?ws(t.left+h,t.top+E,c-2*H/3,Q-2*f/3,is.BOTTOM_RIGHT):new ts(t.left+t.width-2*H/3,t.top+t.height-2*f/3),this.bottomLeftBorderDoubleInnerBox=0<w||0<U?ws(t.left+2*p/3,t.top+F,w-2*p/3,U-2*f/3,is.BOTTOM_LEFT):new ts(t.left+2*p/3,t.top+t.height-2*f/3),this.topLeftBorderStroke=0<n||0<B?ws(t.left+p/2,t.top+d/2,n-p/2,B-d/2,is.TOP_LEFT):new ts(t.left+p/2,t.top+d/2),this.topRightBorderStroke=0<n||0<B?ws(t.left+g,t.top+d/2,o-H/2,i-d/2,is.TOP_RIGHT):new ts(t.left+t.width-H/2,t.top+d/2),this.bottomRightBorderStroke=0<c||0<Q?ws(t.left+h,t.top+E,c-H/2,Q-f/2,is.BOTTOM_RIGHT):new ts(t.left+t.width-H/2,t.top+t.height-f/2),this.bottomLeftBorderStroke=0<w||0<U?ws(t.left+p/2,t.top+F,w-p/2,U-f/2,is.BOTTOM_LEFT):new ts(t.left+p/2,t.top+t.height-f/2),this.topLeftBorderBox=0<n||0<B?ws(t.left,t.top,n,B,is.TOP_LEFT):new ts(t.left,t.top),this.topRightBorderBox=0<o||0<i?ws(t.left+g,t.top,o,i,is.TOP_RIGHT):new ts(t.left+t.width,t.top),this.bottomRightBorderBox=0<c||0<Q?ws(t.left+h,t.top+E,c,Q,is.BOTTOM_RIGHT):new ts(t.left+t.width,t.top+t.height),this.bottomLeftBorderBox=0<w||0<U?ws(t.left,t.top+F,w,U,is.BOTTOM_LEFT):new ts(t.left,t.top+t.height),this.topLeftPaddingBox=0<n||0<B?ws(t.left+p,t.top+d,Math.max(0,n-p),Math.max(0,B-d),is.TOP_LEFT):new ts(t.left+p,t.top+d),this.topRightPaddingBox=0<o||0<i?ws(t.left+Math.min(g,t.width-H),t.top+d,g>t.width+H?0:Math.max(0,o-H),Math.max(0,i-d),is.TOP_RIGHT):new ts(t.left+t.width-H,t.top+d),this.bottomRightPaddingBox=0<c||0<Q?ws(t.left+Math.min(h,t.width-p),t.top+Math.min(E,t.height-f),Math.max(0,c-H),Math.max(0,Q-f),is.BOTTOM_RIGHT):new ts(t.left+t.width-H,t.top+t.height-f),this.bottomLeftPaddingBox=0<w||0<U?ws(t.left+p,t.top+Math.min(F,t.height-f),Math.max(0,w-p),Math.max(0,U-f),is.BOTTOM_LEFT):new ts(t.left+p,t.top+t.height-f),this.topLeftContentBox=0<n||0<B?ws(t.left+p+T,t.top+d+N,Math.max(0,n-(p+T)),Math.max(0,B-(d+N)),is.TOP_LEFT):new ts(t.left+p+T,t.top+d+N),this.topRightContentBox=0<o||0<i?ws(t.left+Math.min(g,t.width+p+T),t.top+d+N,g>t.width+p+T?0:o-p+T,i-(d+N),is.TOP_RIGHT):new ts(t.left+t.width-(H+K),t.top+d+N),this.bottomRightContentBox=0<c||0<Q?ws(t.left+Math.min(h,t.width-(p+T)),t.top+Math.min(E,t.height+d+N),Math.max(0,c-(H+K)),Q-(f+I),is.BOTTOM_RIGHT):new ts(t.left+t.width-(H+K),t.top+t.height-(f+I)),this.bottomLeftContentBox=0<w||0<U?ws(t.left+p+T,t.top+F,Math.max(0,w-(p+T)),U-(f+I),is.BOTTOM_LEFT):new ts(t.left+p+T,t.top+t.height-(f+I))};(as=is||(is={}))[as.TOP_LEFT=0]="TOP_LEFT",as[as.TOP_RIGHT=1]="TOP_RIGHT",as[as.BOTTOM_RIGHT=2]="BOTTOM_RIGHT",as[as.BOTTOM_LEFT=3]="BOTTOM_LEFT";function Qs(A){return[A.topLeftBorderBox,A.topRightBorderBox,A.bottomRightBorderBox,A.bottomLeftBorderBox]}function us(A){return[A.topLeftPaddingBox,A.topRightPaddingBox,A.bottomRightPaddingBox,A.bottomLeftPaddingBox]}var ws=function(A,e,t,r,n){var B=(Math.sqrt(2)-1)/3*4,s=t*B,o=r*B,i=A+t,a=e+r;switch(n){case is.TOP_LEFT:return new Bs(new ts(A,a),new ts(A,a-o),new ts(i-s,e),new ts(i,e));case is.TOP_RIGHT:return new Bs(new ts(A,e),new ts(A+s,e),new ts(i,a-o),new ts(i,a));case is.BOTTOM_RIGHT:return new Bs(new ts(i,e),new ts(i,e+o),new ts(A+s,a),new ts(A,a));case is.BOTTOM_LEFT:default:return new Bs(new ts(i,a),new ts(i-s,a),new ts(A,e+o),new ts(A,e))}},Us=function(A,e,t){this.type=0,this.target=6,this.offsetX=A,this.offsetY=e,this.matrix=t},ls=function(A,e){this.type=1,this.target=e,this.path=A},Cs=function(A){this.type=2,this.target=6,this.opacity=A},gs=function(A){this.element=A,this.inlineLevel=[],this.nonInlineLevel=[],this.negativeZIndex=[],this.zeroOrAutoZIndexOrTransformedOrOpacity=[],this.positiveZIndex=[],this.nonPositionedFloats=[],this.nonPositionedInlineLevel=[]},Es=(hs.prototype.getParentEffects=function(){var A=this.effects.slice(0);if(this.container.styles.overflowX!==sr.VISIBLE){var e=Qs(this.curves),t=us(this.curves);es(e,t)||A.push(new ls(t,6))}return A},hs);function hs(A,e){if(this.container=A,this.effects=e.slice(0),this.curves=new cs(A),A.styles.opacity<1&&this.effects.push(new Cs(A.styles.opacity)),null!==A.styles.transform){var t=A.bounds.left+A.styles.transformOrigin[0].number,r=A.bounds.top+A.styles.transformOrigin[1].number,n=A.styles.transform;this.effects.push(new Us(t,r,n))}if(A.styles.overflowX!==sr.VISIBLE){var B=Qs(this.curves),s=us(this.curves);es(B,s)?this.effects.push(new ls(B,6)):(this.effects.push(new ls(B,2)),this.effects.push(new ls(s,4)))}}function Fs(A,e){switch(e){case 0:return ms(A.topLeftBorderBox,A.topLeftPaddingBox,A.topRightBorderBox,A.topRightPaddingBox);case 1:return ms(A.topRightBorderBox,A.topRightPaddingBox,A.bottomRightBorderBox,A.bottomRightPaddingBox);case 2:return ms(A.bottomRightBorderBox,A.bottomRightPaddingBox,A.bottomLeftBorderBox,A.bottomLeftPaddingBox);case 3:default:return ms(A.bottomLeftBorderBox,A.bottomLeftPaddingBox,A.topLeftBorderBox,A.topLeftPaddingBox)}}function ds(A){var e=A.bounds,t=A.styles;return e.add(t.borderLeftWidth,t.borderTopWidth,-(t.borderRightWidth+t.borderLeftWidth),-(t.borderTopWidth+t.borderBottomWidth))}function Hs(A){var e=A.styles,t=A.bounds,r=ae(e.paddingLeft,t.width),n=ae(e.paddingRight,t.width),B=ae(e.paddingTop,t.width),s=ae(e.paddingBottom,t.width);return t.add(r+e.borderLeftWidth,B+e.borderTopWidth,-(e.borderRightWidth+e.borderLeftWidth+r+n),-(e.borderTopWidth+e.borderBottomWidth+B+s))}function fs(A,e,t){var r=function(A,e){return 0===A?e.bounds:2===A?Hs(e):ds(e)}(Ls(A.styles.backgroundOrigin,e),A),n=function(A,e){return A===Ee.BORDER_BOX?e.bounds:A===Ee.CONTENT_BOX?Hs(e):ds(e)}(Ls(A.styles.backgroundClip,e),A),B=Rs(Ls(A.styles.backgroundSize,e),t,r),s=B[0],o=B[1],i=jA(Ls(A.styles.backgroundPosition,e),r.width-s,r.height-o);return[Os(Ls(A.styles.backgroundRepeat,e),i,B,r,n),Math.round(r.left+i[0]),Math.round(r.top+i[1]),s,o]}function ps(A){return zA(A)&&A.value===Ut.AUTO}function Ns(A){return"number"==typeof A}var Ks=function(c,Q,u,w){c.container.elements.forEach(function(A){var e=$r(A.flags,4),t=$r(A.flags,2),r=new Es(A,c.getParentEffects());$r(A.styles.display,2048)&&w.push(r);var n=$r(A.flags,8)?[]:w;if(e||t){var B=e||A.styles.isPositioned()?u:Q,s=new gs(r);if(A.styles.isPositioned()||A.styles.opacity<1||A.styles.isTransformed()){var o=A.styles.zIndex.order;if(o<0){var i=0;B.negativeZIndex.some(function(A,e){return o>A.element.container.styles.zIndex.order?(i=e,!1):0<i}),B.negativeZIndex.splice(i,0,s)}else if(0<o){var a=0;B.positiveZIndex.some(function(A,e){return o>=A.element.container.styles.zIndex.order?(a=e+1,!1):0<a}),B.positiveZIndex.splice(a,0,s)}else B.zeroOrAutoZIndexOrTransformedOrOpacity.push(s)}else A.styles.isFloating()?B.nonPositionedFloats.push(s):B.nonPositionedInlineLevel.push(s);Ks(r,s,e?s:u,n)}else A.styles.isInlineLevel()?Q.inlineLevel.push(r):Q.nonInlineLevel.push(r),Ks(r,Q,u,n);$r(A.flags,8)&&Is(A,n)})},Is=function(A,e){for(var t=A instanceof Sn?A.start:1,r=A instanceof Sn&&A.reversed,n=0;n<e.length;n++){var B=e[n];B.container instanceof Dn&&"number"==typeof B.container.value&&0!==B.container.value&&(t=B.container.value),B.listValue=yB(t,B.container.styles.listStyleType,!0),t+=r?-1:1}},Ts=function(A,e){var t=[];return os(A)?t.push(A.subdivide(.5,!1)):t.push(A),os(e)?t.push(e.subdivide(.5,!0)):t.push(e),t},ms=function(A,e,t,r){var n=[];return os(A)?n.push(A.subdivide(.5,!1)):n.push(A),os(t)?n.push(t.subdivide(.5,!0)):n.push(t),os(r)?n.push(r.subdivide(.5,!0).reverse()):n.push(r),os(e)?n.push(e.subdivide(.5,!1).reverse()):n.push(e),n},Rs=function(A,e,t){var r=e[0],n=e[1],B=e[2],s=A[0],o=A[1];if(qA(s)&&o&&qA(o))return[ae(s,t.width),ae(o,t.height)];var i=Ns(B);if(zA(s)&&(s.value===Ut.CONTAIN||s.value===Ut.COVER))return Ns(B)?t.width/t.height<B!=(s.value===Ut.COVER)?[t.width,t.width/B]:[t.height*B,t.height]:[t.width,t.height];var a=Ns(r),c=Ns(n),Q=a||c;if(ps(s)&&(!o||ps(o)))return a&&c?[r,n]:i||Q?Q&&i?[a?r:n*B,c?n:r/B]:[a?r:t.width,c?n:t.height]:[t.width,t.height];if(i){var u=0,w=0;return qA(s)?u=ae(s,t.width):qA(o)&&(w=ae(o,t.height)),ps(s)?u=w*B:o&&!ps(o)||(w=u/B),[u,w]}var U=null,l=null;if(qA(s)?U=ae(s,t.width):o&&qA(o)&&(l=ae(o,t.height)),null===U||o&&!ps(o)||(l=a&&c?U/r*n:t.height),null!==l&&ps(s)&&(U=a&&c?l/n*r:t.width),null!==U&&null!==l)return[U,l];throw new Error("Unable to calculate background-size for element")},Ls=function(A,e){var t=A[e];return void 0===t?A[0]:t},Os=function(A,e,t,r,n){var B=e[0],s=e[1],o=t[0],i=t[1];switch(A){case it.REPEAT_X:return[new ts(Math.round(r.left),Math.round(r.top+s)),new ts(Math.round(r.left+r.width),Math.round(r.top+s)),new ts(Math.round(r.left+r.width),Math.round(i+r.top+s)),new ts(Math.round(r.left),Math.round(i+r.top+s))];case it.REPEAT_Y:return[new ts(Math.round(r.left+B),Math.round(r.top)),new ts(Math.round(r.left+B+o),Math.round(r.top)),new ts(Math.round(r.left+B+o),Math.round(r.height+r.top)),new ts(Math.round(r.left+B),Math.round(r.height+r.top))];case it.NO_REPEAT:return[new ts(Math.round(r.left+B),Math.round(r.top+s)),new ts(Math.round(r.left+B+o),Math.round(r.top+s)),new ts(Math.round(r.left+B+o),Math.round(r.top+s+i)),new ts(Math.round(r.left+B),Math.round(r.top+s+i))];default:return[new ts(Math.round(n.left),Math.round(n.top)),new ts(Math.round(n.left+n.width),Math.round(n.top)),new ts(Math.round(n.left+n.width),Math.round(n.height+n.top)),new ts(Math.round(n.left),Math.round(n.height+n.top))]}},Ds="Hidden Text",bs=(vs.prototype.parseMetrics=function(A,e){var t=this._document.createElement("div"),r=this._document.createElement("img"),n=this._document.createElement("span"),B=this._document.body;t.style.visibility="hidden",t.style.fontFamily=A,t.style.fontSize=e,t.style.margin="0",t.style.padding="0",B.appendChild(t),r.src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7",r.width=1,r.height=1,r.style.margin="0",r.style.padding="0",r.style.verticalAlign="baseline",n.style.fontFamily=A,n.style.fontSize=e,n.style.margin="0",n.style.padding="0",n.appendChild(this._document.createTextNode(Ds)),t.appendChild(n),t.appendChild(r);var s=r.offsetTop-n.offsetTop+2;t.removeChild(n),t.appendChild(this._document.createTextNode(Ds)),t.style.lineHeight="normal",r.style.verticalAlign="super";var o=r.offsetTop-t.offsetTop+2;return B.removeChild(t),{baseline:s,middle:o}},vs.prototype.getMetrics=function(A,e){var t=A+" "+e;return void 0===this._data[t]&&(this._data[t]=this.parseMetrics(A,e)),this._data[t]},vs);function vs(A){this._data={},this._document=A}var Ss=(Ms.prototype.applyEffects=function(A,e){for(var t=this;this._activeEffects.length;)this.popEffect();A.filter(function(A){return $r(A.target,e)}).forEach(function(A){return t.applyEffect(A)})},Ms.prototype.applyEffect=function(A){this.ctx.save(),function(A){return 2===A.type}(A)&&(this.ctx.globalAlpha=A.opacity),function(A){return 0===A.type}(A)&&(this.ctx.translate(A.offsetX,A.offsetY),this.ctx.transform(A.matrix[0],A.matrix[1],A.matrix[2],A.matrix[3],A.matrix[4],A.matrix[5]),this.ctx.translate(-A.offsetX,-A.offsetY)),function(A){return 1===A.type}(A)&&(this.path(A.path),this.ctx.clip()),this._activeEffects.push(A)},Ms.prototype.popEffect=function(){this._activeEffects.pop(),this.ctx.restore()},Ms.prototype.renderStack=function(e){return a(this,void 0,void 0,function(){return S(this,function(A){switch(A.label){case 0:return e.element.container.styles.isVisible()?[4,this.renderStackContent(e)]:[3,2];case 1:A.sent(),A.label=2;case 2:return[2]}})})},Ms.prototype.renderNode=function(e){return a(this,void 0,void 0,function(){return S(this,function(A){switch(A.label){case 0:return e.container.styles.isVisible()?[4,this.renderNodeBackgroundAndBorders(e)]:[3,3];case 1:return A.sent(),[4,this.renderNodeContent(e)];case 2:A.sent(),A.label=3;case 3:return[2]}})})},Ms.prototype.renderTextWithLetterSpacing=function(t,A){var r=this;0===A?this.ctx.fillText(t.text,t.bounds.left,t.bounds.top+t.bounds.height):c(t.text).map(function(A){return l(A)}).reduce(function(A,e){return r.ctx.fillText(e,A,t.bounds.top+t.bounds.height),A+r.ctx.measureText(e).width},t.bounds.left)},Ms.prototype.createFontStyle=function(A){var e=A.fontVariant.filter(function(A){return"normal"===A||"small-caps"===A}).join(""),t=A.fontFamily.join(", "),r=PA(A.fontSize)?""+A.fontSize.number+A.fontSize.unit:A.fontSize.number+"px";return[[A.fontStyle,e,A.fontWeight,r,t].join(" "),t,r]},Ms.prototype.renderTextNode=function(r,o){return a(this,void 0,void 0,function(){var e,t,n,B,s=this;return S(this,function(A){return e=this.createFontStyle(o),t=e[0],n=e[1],B=e[2],this.ctx.font=t,r.textBounds.forEach(function(r){s.ctx.fillStyle=te(o.color),s.renderTextWithLetterSpacing(r,o.letterSpacing);var A=o.textShadow;A.length&&r.text.trim().length&&(A.slice(0).reverse().forEach(function(A){s.ctx.shadowColor=te(A.color),s.ctx.shadowOffsetX=A.offsetX.number*s.options.scale,s.ctx.shadowOffsetY=A.offsetY.number*s.options.scale,s.ctx.shadowBlur=A.blur.number,s.ctx.fillText(r.text,r.bounds.left,r.bounds.top+r.bounds.height)}),s.ctx.shadowColor="",s.ctx.shadowOffsetX=0,s.ctx.shadowOffsetY=0,s.ctx.shadowBlur=0),o.textDecorationLine.length&&(s.ctx.fillStyle=te(o.textDecorationColor||o.color),o.textDecorationLine.forEach(function(A){switch(A){case 1:var e=s.fontMetrics.getMetrics(n,B).baseline;s.ctx.fillRect(r.bounds.left,Math.round(r.bounds.top+e),r.bounds.width,1);break;case 2:s.ctx.fillRect(r.bounds.left,Math.round(r.bounds.top),r.bounds.width,1);break;case 3:var t=s.fontMetrics.getMetrics(n,B).middle;s.ctx.fillRect(r.bounds.left,Math.ceil(r.bounds.top+t),r.bounds.width,1)}}))}),[2]})})},Ms.prototype.renderReplacedElement=function(A,e,t){if(t&&0<A.intrinsicWidth&&0<A.intrinsicHeight){var r=Hs(A),n=us(e);this.path(n),this.ctx.save(),this.ctx.clip(),this.ctx.drawImage(t,0,0,A.intrinsicWidth,A.intrinsicHeight,r.left,r.top,r.width,r.height),this.ctx.restore()}},Ms.prototype.renderNodeContent=function(l){return a(this,void 0,void 0,function(){var e,t,r,n,B,s,o,i,a,c,Q,u,w,U;return S(this,function(A){switch(A.label){case 0:this.applyEffects(l.effects,4),e=l.container,t=l.curves,r=e.styles,n=0,B=e.textNodes,A.label=1;case 1:return n<B.length?(s=B[n],[4,this.renderTextNode(s,r)]):[3,4];case 2:A.sent(),A.label=3;case 3:return n++,[3,1];case 4:if(!(e instanceof pn))return[3,8];A.label=5;case 5:return A.trys.push([5,7,,8]),[4,this.options.cache.match(e.src)];case 6:return u=A.sent(),this.renderReplacedElement(e,t,u),[3,8];case 7:return A.sent(),be.getInstance(this.options.id).error("Error loading image "+e.src),[3,8];case 8:if(e instanceof In&&this.renderReplacedElement(e,t,e.canvas),!(e instanceof Rn))return[3,12];A.label=9;case 9:return A.trys.push([9,11,,12]),[4,this.options.cache.match(e.svg)];case 10:return u=A.sent(),this.renderReplacedElement(e,t,u),[3,12];case 11:return A.sent(),be.getInstance(this.options.id).error("Error loading svg "+e.svg.substring(0,255)),[3,12];case 12:return e instanceof eB&&e.tree?[4,new Ms({id:this.options.id,scale:this.options.scale,backgroundColor:e.backgroundColor,x:0,y:0,scrollX:0,scrollY:0,width:e.width,height:e.height,cache:this.options.cache,windowWidth:e.width,windowHeight:e.height}).render(e.tree)]:[3,14];case 13:o=A.sent(),e.width&&e.height&&this.ctx.drawImage(o,0,0,e.width,e.height,e.bounds.left,e.bounds.top,e.bounds.width,e.bounds.height),A.label=14;case 14:if(e instanceof Gn&&(i=Math.min(e.bounds.width,e.bounds.height),e.type===Pn?e.checked&&(this.ctx.save(),this.path([new ts(e.bounds.left+.39363*i,e.bounds.top+.79*i),new ts(e.bounds.left+.16*i,e.bounds.top+.5549*i),new ts(e.bounds.left+.27347*i,e.bounds.top+.44071*i),new ts(e.bounds.left+.39694*i,e.bounds.top+.5649*i),new ts(e.bounds.left+.72983*i,e.bounds.top+.23*i),new ts(e.bounds.left+.84*i,e.bounds.top+.34085*i),new ts(e.bounds.left+.39363*i,e.bounds.top+.79*i)]),this.ctx.fillStyle=te(Xn),this.ctx.fill(),this.ctx.restore()):e.type===Vn&&e.checked&&(this.ctx.save(),this.ctx.beginPath(),this.ctx.arc(e.bounds.left+i/2,e.bounds.top+i/2,i/4,0,2*Math.PI,!0),this.ctx.fillStyle=te(Xn),this.ctx.fill(),this.ctx.restore())),ys(e)&&e.value.length){switch(this.ctx.font=this.createFontStyle(r)[0],this.ctx.fillStyle=te(r.color),this.ctx.textBaseline="middle",this.ctx.textAlign=xs(e.styles.textAlign),U=Hs(e),a=0,e.styles.textAlign){case Cr.CENTER:a+=U.width/2;break;case Cr.RIGHT:a+=U.width}c=U.add(a,0,0,-U.height/2+1),this.ctx.save(),this.path([new ts(U.left,U.top),new ts(U.left+U.width,U.top),new ts(U.left+U.width,U.top+U.height),new ts(U.left,U.top+U.height)]),this.ctx.clip(),this.renderTextWithLetterSpacing(new ln(e.value,c),r.letterSpacing),this.ctx.restore(),this.ctx.textBaseline="bottom",this.ctx.textAlign="left"}if(!$r(e.styles.display,2048))return[3,20];if(null===e.styles.listStyleImage)return[3,19];if((Q=e.styles.listStyleImage).type!==Pe.URL)return[3,18];u=void 0,w=Q.url,A.label=15;case 15:return A.trys.push([15,17,,18]),[4,this.options.cache.match(w)];case 16:return u=A.sent(),this.ctx.drawImage(u,e.bounds.left-(u.width+10),e.bounds.top),[3,18];case 17:return A.sent(),be.getInstance(this.options.id).error("Error loading list-style-image "+w),[3,18];case 18:return[3,20];case 19:l.listValue&&e.styles.listStyleType!==tr.NONE&&(this.ctx.font=this.createFontStyle(r)[0],this.ctx.fillStyle=te(r.color),this.ctx.textBaseline="middle",this.ctx.textAlign="right",U=new I(e.bounds.left,e.bounds.top+ae(e.styles.paddingTop,e.bounds.width),e.bounds.width,function(A,e){return zA(A)&&"normal"===A.value?1.2*e:A.type===sA.NUMBER_TOKEN?e*A.number:qA(A)?ae(A,e):e}(r.lineHeight,r.fontSize.number)/2+1),this.renderTextWithLetterSpacing(new ln(l.listValue,U),r.letterSpacing),this.ctx.textBaseline="bottom",this.ctx.textAlign="left"),A.label=20;case 20:return[2]}})})},Ms.prototype.renderStackContent=function(C){return a(this,void 0,void 0,function(){var e,t,r,n,B,s,o,i,a,c,Q,u,w,U,l;return S(this,function(A){switch(A.label){case 0:return[4,this.renderNodeBackgroundAndBorders(C.element)];case 1:A.sent(),e=0,t=C.negativeZIndex,A.label=2;case 2:return e<t.length?(l=t[e],[4,this.renderStack(l)]):[3,5];case 3:A.sent(),A.label=4;case 4:return e++,[3,2];case 5:return[4,this.renderNodeContent(C.element)];case 6:A.sent(),r=0,n=C.nonInlineLevel,A.label=7;case 7:return r<n.length?(l=n[r],[4,this.renderNode(l)]):[3,10];case 8:A.sent(),A.label=9;case 9:return r++,[3,7];case 10:B=0,s=C.nonPositionedFloats,A.label=11;case 11:return B<s.length?(l=s[B],[4,this.renderStack(l)]):[3,14];case 12:A.sent(),A.label=13;case 13:return B++,[3,11];case 14:o=0,i=C.nonPositionedInlineLevel,A.label=15;case 15:return o<i.length?(l=i[o],[4,this.renderStack(l)]):[3,18];case 16:A.sent(),A.label=17;case 17:return o++,[3,15];case 18:a=0,c=C.inlineLevel,A.label=19;case 19:return a<c.length?(l=c[a],[4,this.renderNode(l)]):[3,22];case 20:A.sent(),A.label=21;case 21:return a++,[3,19];case 22:Q=0,u=C.zeroOrAutoZIndexOrTransformedOrOpacity,A.label=23;case 23:return Q<u.length?(l=u[Q],[4,this.renderStack(l)]):[3,26];case 24:A.sent(),A.label=25;case 25:return Q++,[3,23];case 26:w=0,U=C.positiveZIndex,A.label=27;case 27:return w<U.length?(l=U[w],[4,this.renderStack(l)]):[3,30];case 28:A.sent(),A.label=29;case 29:return w++,[3,27];case 30:return[2]}})})},Ms.prototype.mask=function(A){this.ctx.beginPath(),this.ctx.moveTo(0,0),this.ctx.lineTo(this.canvas.width,0),this.ctx.lineTo(this.canvas.width,this.canvas.height),this.ctx.lineTo(0,this.canvas.height),this.ctx.lineTo(0,0),this.formatPath(A.slice(0).reverse()),this.ctx.closePath()},Ms.prototype.path=function(A){this.ctx.beginPath(),this.formatPath(A),this.ctx.closePath()},Ms.prototype.formatPath=function(A){var r=this;A.forEach(function(A,e){var t=os(A)?A.start:A;0===e?r.ctx.moveTo(t.x,t.y):r.ctx.lineTo(t.x,t.y),os(A)&&r.ctx.bezierCurveTo(A.startControl.x,A.startControl.y,A.endControl.x,A.endControl.y,A.end.x,A.end.y)})},Ms.prototype.renderRepeat=function(A,e,t,r){this.path(A),this.ctx.fillStyle=e,this.ctx.translate(t,r),this.ctx.fill(),this.ctx.translate(-t,-r)},Ms.prototype.resizeImage=function(A,e,t){if(A.width===e&&A.height===t)return A;var r=this.canvas.ownerDocument.createElement("canvas");return r.width=e,r.height=t,r.getContext("2d").drawImage(A,0,0,A.width,A.height,0,0,e,t),r},Ms.prototype.renderBackgroundImage=function(v){return a(this,void 0,void 0,function(){var D,e,b,t,r,n;return S(this,function(A){switch(A.label){case 0:D=v.styles.backgroundImage.length-1,e=function(e){var t,r,n,B,s,o,i,a,c,Q,u,w,U,l,C,g,E,h,F,d,H,f,p,N,K,I,T,m,R,L,O;return S(this,function(A){switch(A.label){case 0:if(e.type!==Pe.URL)return[3,5];t=void 0,r=e.url,A.label=1;case 1:return A.trys.push([1,3,,4]),[4,b.options.cache.match(r)];case 2:return t=A.sent(),[3,4];case 3:return A.sent(),be.getInstance(b.options.id).error("Error loading background-image "+r),[3,4];case 4:return t&&(n=fs(v,D,[t.width,t.height,t.width/t.height]),g=n[0],f=n[1],p=n[2],F=n[3],d=n[4],l=b.ctx.createPattern(b.resizeImage(t,F,d),"repeat"),b.renderRepeat(g,l,f,p)),[3,6];case 5:!function(A){return A.type===Pe.LINEAR_GRADIENT}(e)?function(A){return A.type===Pe.RADIAL_GRADIENT}(e)&&(C=fs(v,D,[null,null,null]),g=C[0],E=C[1],h=C[2],F=C[3],d=C[4],H=0===e.position.length?[oe]:e.position,f=ae(H[0],F),p=ae(H[H.length-1],d),N=function(A,e,t,r,n){var B=0,s=0;switch(A.size){case Bt.CLOSEST_SIDE:A.shape===rt.CIRCLE?B=s=Math.min(Math.abs(e),Math.abs(e-r),Math.abs(t),Math.abs(t-n)):A.shape===rt.ELLIPSE&&(B=Math.min(Math.abs(e),Math.abs(e-r)),s=Math.min(Math.abs(t),Math.abs(t-n)));break;case Bt.CLOSEST_CORNER:if(A.shape===rt.CIRCLE)B=s=Math.min(Ne(e,t),Ne(e,t-n),Ne(e-r,t),Ne(e-r,t-n));else if(A.shape===rt.ELLIPSE){var o=Math.min(Math.abs(t),Math.abs(t-n))/Math.min(Math.abs(e),Math.abs(e-r)),i=Ke(r,n,e,t,!0),a=i[0],c=i[1];s=o*(B=Ne(a-e,(c-t)/o))}break;case Bt.FARTHEST_SIDE:A.shape===rt.CIRCLE?B=s=Math.max(Math.abs(e),Math.abs(e-r),Math.abs(t),Math.abs(t-n)):A.shape===rt.ELLIPSE&&(B=Math.max(Math.abs(e),Math.abs(e-r)),s=Math.max(Math.abs(t),Math.abs(t-n)));break;case Bt.FARTHEST_CORNER:if(A.shape===rt.CIRCLE)B=s=Math.max(Ne(e,t),Ne(e,t-n),Ne(e-r,t),Ne(e-r,t-n));else if(A.shape===rt.ELLIPSE){o=Math.max(Math.abs(t),Math.abs(t-n))/Math.max(Math.abs(e),Math.abs(e-r));var Q=Ke(r,n,e,t,!1);a=Q[0],c=Q[1],s=o*(B=Ne(a-e,(c-t)/o))}}return Array.isArray(A.size)&&(B=ae(A.size[0],r),s=2===A.size.length?ae(A.size[1],n):B),[B,s]}(e,f,p,F,d),K=N[0],I=N[1],0<K&&0<K&&(T=b.ctx.createRadialGradient(E+f,h+p,0,E+f,h+p,K),fe(e.stops,2*K).forEach(function(A){return T.addColorStop(A.stop,te(A.color))}),b.path(g),b.ctx.fillStyle=T,K!==I?(m=v.bounds.left+.5*v.bounds.width,R=v.bounds.top+.5*v.bounds.height,O=1/(L=I/K),b.ctx.save(),b.ctx.translate(m,R),b.ctx.transform(1,0,0,L,0,0),b.ctx.translate(-m,-R),b.ctx.fillRect(E,O*(h-R)+R,F,d*O),b.ctx.restore()):b.ctx.fill())):(B=fs(v,D,[null,null,null]),g=B[0],f=B[1],p=B[2],F=B[3],d=B[4],s=pe(e.angle,F,d),o=s[0],i=s[1],a=s[2],c=s[3],Q=s[4],(u=document.createElement("canvas")).width=F,u.height=d,w=u.getContext("2d"),U=w.createLinearGradient(i,c,a,Q),fe(e.stops,o).forEach(function(A){return U.addColorStop(A.stop,te(A.color))}),w.fillStyle=U,w.fillRect(0,0,F,d),0<F&&0<d&&(l=b.ctx.createPattern(u,"repeat"),b.renderRepeat(g,l,f,p))),A.label=6;case 6:return D--,[2]}})},b=this,t=0,r=v.styles.backgroundImage.slice(0).reverse(),A.label=1;case 1:return t<r.length?(n=r[t],[5,e(n)]):[3,4];case 2:A.sent(),A.label=3;case 3:return t++,[3,1];case 4:return[2]}})})},Ms.prototype.renderSolidBorder=function(e,t,r){return a(this,void 0,void 0,function(){return S(this,function(A){return this.path(Fs(r,t)),this.ctx.fillStyle=te(e),this.ctx.fill(),[2]})})},Ms.prototype.renderDoubleBorder=function(r,n,B,s){return a(this,void 0,void 0,function(){var e,t;return S(this,function(A){switch(A.label){case 0:return n<3?[4,this.renderSolidBorder(r,B,s)]:[3,2];case 1:return A.sent(),[2];case 2:return e=function(A,e){switch(e){case 0:return ms(A.topLeftBorderBox,A.topLeftBorderDoubleOuterBox,A.topRightBorderBox,A.topRightBorderDoubleOuterBox);case 1:return ms(A.topRightBorderBox,A.topRightBorderDoubleOuterBox,A.bottomRightBorderBox,A.bottomRightBorderDoubleOuterBox);case 2:return ms(A.bottomRightBorderBox,A.bottomRightBorderDoubleOuterBox,A.bottomLeftBorderBox,A.bottomLeftBorderDoubleOuterBox);case 3:default:return ms(A.bottomLeftBorderBox,A.bottomLeftBorderDoubleOuterBox,A.topLeftBorderBox,A.topLeftBorderDoubleOuterBox)}}(s,B),this.path(e),this.ctx.fillStyle=te(r),this.ctx.fill(),t=function(A,e){switch(e){case 0:return ms(A.topLeftBorderDoubleInnerBox,A.topLeftPaddingBox,A.topRightBorderDoubleInnerBox,A.topRightPaddingBox);case 1:return ms(A.topRightBorderDoubleInnerBox,A.topRightPaddingBox,A.bottomRightBorderDoubleInnerBox,A.bottomRightPaddingBox);case 2:return ms(A.bottomRightBorderDoubleInnerBox,A.bottomRightPaddingBox,A.bottomLeftBorderDoubleInnerBox,A.bottomLeftPaddingBox);case 3:default:return ms(A.bottomLeftBorderDoubleInnerBox,A.bottomLeftPaddingBox,A.topLeftBorderDoubleInnerBox,A.topLeftPaddingBox)}}(s,B),this.path(t),this.ctx.fill(),[2]}})})},Ms.prototype.renderNodeBackgroundAndBorders=function(c){return a(this,void 0,void 0,function(){var e,t,r,n,B,s,o,i,a=this;return S(this,function(A){switch(A.label){case 0:return this.applyEffects(c.effects,2),e=c.container.styles,t=!ee(e.backgroundColor)||e.backgroundImage.length,r=[{style:e.borderTopStyle,color:e.borderTopColor,width:e.borderTopWidth},{style:e.borderRightStyle,color:e.borderRightColor,width:e.borderRightWidth},{style:e.borderBottomStyle,color:e.borderBottomColor,width:e.borderBottomWidth},{style:e.borderLeftStyle,color:e.borderLeftColor,width:e.borderLeftWidth}],n=_s(Ls(e.backgroundClip,0),c.curves),t||e.boxShadow.length?(this.ctx.save(),this.path(n),this.ctx.clip(),ee(e.backgroundColor)||(this.ctx.fillStyle=te(e.backgroundColor),this.ctx.fill()),[4,this.renderBackgroundImage(c.container)]):[3,2];case 1:A.sent(),this.ctx.restore(),e.boxShadow.slice(0).reverse().forEach(function(A){a.ctx.save();var e=Qs(c.curves),t=A.inset?0:1e4,r=function(A,t,r,n,B){return A.map(function(A,e){switch(e){case 0:return A.add(t,r);case 1:return A.add(t+n,r);case 2:return A.add(t+n,r+B);case 3:return A.add(t,r+B)}return A})}(e,-t+(A.inset?1:-1)*A.spread.number,(A.inset?1:-1)*A.spread.number,A.spread.number*(A.inset?-2:2),A.spread.number*(A.inset?-2:2));A.inset?(a.path(e),a.ctx.clip(),a.mask(r)):(a.mask(e),a.ctx.clip(),a.path(r)),a.ctx.shadowOffsetX=A.offsetX.number+t,a.ctx.shadowOffsetY=A.offsetY.number,a.ctx.shadowColor=te(A.color),a.ctx.shadowBlur=A.blur.number,a.ctx.fillStyle=A.inset?te(A.color):"rgba(0,0,0,1)",a.ctx.fill(),a.ctx.restore()}),A.label=2;case 2:s=B=0,o=r,A.label=3;case 3:return s<o.length?(i=o[s]).style!==Ft.NONE&&!ee(i.color)&&0<i.width?i.style!==Ft.DASHED?[3,5]:[4,this.renderDashedDottedBorder(i.color,i.width,B,c.curves,Ft.DASHED)]:[3,11]:[3,13];case 4:return A.sent(),[3,11];case 5:return i.style!==Ft.DOTTED?[3,7]:[4,this.renderDashedDottedBorder(i.color,i.width,B,c.curves,Ft.DOTTED)];case 6:return A.sent(),[3,11];case 7:return i.style!==Ft.DOUBLE?[3,9]:[4,this.renderDoubleBorder(i.color,i.width,B,c.curves)];case 8:return A.sent(),[3,11];case 9:return[4,this.renderSolidBorder(i.color,B,c.curves)];case 10:A.sent(),A.label=11;case 11:B++,A.label=12;case 12:return s++,[3,3];case 13:return[2]}})})},Ms.prototype.renderDashedDottedBorder=function(g,E,h,F,d){return a(this,void 0,void 0,function(){var e,t,r,n,B,s,o,i,a,c,Q,u,w,U,l,C;return S(this,function(A){return this.ctx.save(),e=function(A,e){switch(e){case 0:return Ts(A.topLeftBorderStroke,A.topRightBorderStroke);case 1:return Ts(A.topRightBorderStroke,A.bottomRightBorderStroke);case 2:return Ts(A.bottomRightBorderStroke,A.bottomLeftBorderStroke);case 3:default:return Ts(A.bottomLeftBorderStroke,A.topLeftBorderStroke)}}(F,h),t=Fs(F,h),d===Ft.DASHED&&(this.path(t),this.ctx.clip()),n=os(t[0])?(r=t[0].start.x,t[0].start.y):(r=t[0].x,t[0].y),s=os(t[1])?(B=t[1].end.x,t[1].end.y):(B=t[1].x,t[1].y),o=0===h||2===h?Math.abs(r-B):Math.abs(n-s),this.ctx.beginPath(),d===Ft.DOTTED?this.formatPath(e):this.formatPath(t.slice(0,2)),i=E<3?3*E:2*E,a=E<3?2*E:E,d===Ft.DOTTED&&(a=i=E),c=!0,o<=2*i?c=!1:o<=2*i+a?(i*=Q=o/(2*i+a),a*=Q):(u=Math.floor((o+a)/(i+a)),w=(o-u*i)/(u-1),a=(U=(o-(u+1)*i)/u)<=0||Math.abs(a-w)<Math.abs(a-U)?w:U),c&&(d===Ft.DOTTED?this.ctx.setLineDash([0,i+a]):this.ctx.setLineDash([i,a])),d===Ft.DOTTED?(this.ctx.lineCap="round",this.ctx.lineWidth=E):this.ctx.lineWidth=2*E+1.1,this.ctx.strokeStyle=te(g),this.ctx.stroke(),this.ctx.setLineDash([]),d===Ft.DASHED&&(os(t[0])&&(l=t[3],C=t[0],this.ctx.beginPath(),this.formatPath([new ts(l.end.x,l.end.y),new ts(C.start.x,C.start.y)]),this.ctx.stroke()),os(t[1])&&(l=t[1],C=t[2],this.ctx.beginPath(),this.formatPath([new ts(l.end.x,l.end.y),new ts(C.start.x,C.start.y)]),this.ctx.stroke())),this.ctx.restore(),[2]})})},Ms.prototype.render=function(t){return a(this,void 0,void 0,function(){var e;return S(this,function(A){switch(A.label){case 0:return this.options.backgroundColor&&(this.ctx.fillStyle=te(this.options.backgroundColor),this.ctx.fillRect(this.options.x-this.options.scrollX,this.options.y-this.options.scrollY,this.options.width,this.options.height)),e=function(A){var e=new Es(A,[]),t=new gs(e),r=[];return Ks(e,t,t,r),Is(e.container,r),t}(t),[4,this.renderStack(e)];case 1:return A.sent(),this.applyEffects([],2),[2,this.canvas]}})})},Ms);function Ms(A){this._activeEffects=[],this.canvas=A.canvas?A.canvas:document.createElement("canvas"),this.ctx=this.canvas.getContext("2d"),(this.options=A).canvas||(this.canvas.width=Math.floor(A.width*A.scale),this.canvas.height=Math.floor(A.height*A.scale),this.canvas.style.width=A.width+"px",this.canvas.style.height=A.height+"px"),this.fontMetrics=new bs(document),this.ctx.scale(this.options.scale,this.options.scale),this.ctx.translate(-A.x+A.scrollX,-A.y+A.scrollY),this.ctx.textBaseline="bottom",this._activeEffects=[],be.getInstance(A.id).debug("Canvas renderer initialized ("+A.width+"x"+A.height+" at "+A.x+","+A.y+") with scale "+A.scale)}var ys=function(A){return A instanceof Zn||(A instanceof Wn||A instanceof Gn&&A.type!==Vn&&A.type!==Pn)},_s=function(A,e){switch(A){case Ee.BORDER_BOX:return Qs(e);case Ee.CONTENT_BOX:return function(A){return[A.topLeftContentBox,A.topRightContentBox,A.bottomRightContentBox,A.bottomLeftContentBox]}(e);case Ee.PADDING_BOX:default:return us(e)}},xs=function(A){switch(A){case Cr.CENTER:return"center";case Cr.RIGHT:return"right";case Cr.LEFT:default:return"left"}},Ps=(Vs.prototype.render=function(r){return a(this,void 0,void 0,function(){var e,t;return S(this,function(A){switch(A.label){case 0:return e=Le(Math.max(this.options.windowWidth,this.options.width)*this.options.scale,Math.max(this.options.windowHeight,this.options.height)*this.options.scale,this.options.scrollX*this.options.scale,this.options.scrollY*this.options.scale,r),[4,Xs(e)];case 1:return t=A.sent(),this.options.backgroundColor&&(this.ctx.fillStyle=te(this.options.backgroundColor),this.ctx.fillRect(0,0,this.options.width*this.options.scale,this.options.height*this.options.scale)),this.ctx.drawImage(t,-this.options.x*this.options.scale,-this.options.y*this.options.scale),[2,this.canvas]}})})},Vs);function Vs(A){this.canvas=A.canvas?A.canvas:document.createElement("canvas"),this.ctx=this.canvas.getContext("2d"),this.options=A,this.canvas.width=Math.floor(A.width*A.scale),this.canvas.height=Math.floor(A.height*A.scale),this.canvas.style.width=A.width+"px",this.canvas.style.height=A.height+"px",this.ctx.scale(this.options.scale,this.options.scale),this.ctx.translate(-A.x+A.scrollX,-A.y+A.scrollY),be.getInstance(A.id).debug("EXPERIMENTAL ForeignObject renderer initialized ("+A.width+"x"+A.height+" at "+A.x+","+A.y+") with scale "+A.scale)}function zs(A){return ue(_A.create(A).parseComponentValue())}var Xs=function(r){return new Promise(function(A,e){var t=new Image;t.onload=function(){A(t)},t.onerror=e,t.src="data:image/svg+xml;charset=utf-8,"+encodeURIComponent((new XMLSerializer).serializeToString(r))})};"undefined"!=typeof window&&Se.setContext(window);var Gs=function(p,N){return a(void 0,void 0,void 0,function(){var e,t,r,n,B,s,o,i,a,c,Q,u,w,U,l,C,g,E,h,F,d,H,f;return S(this,function(A){switch(A.label){case 0:if(!(e=p.ownerDocument))throw new Error("Element is not attached to a Document");if(!(t=e.defaultView))throw new Error("Document is not attached to a Window");return r=(Math.round(1e3*Math.random())+Date.now()).toString(16),n=EB(p)||function(A){return"HTML"===A.tagName}(p)?function(A){var e=A.body,t=A.documentElement;if(!e||!t)throw new Error("Unable to get document size");var r=Math.max(Math.max(e.scrollWidth,t.scrollWidth),Math.max(e.offsetWidth,t.offsetWidth),Math.max(e.clientWidth,t.clientWidth)),n=Math.max(Math.max(e.scrollHeight,t.scrollHeight),Math.max(e.offsetHeight,t.offsetHeight),Math.max(e.clientHeight,t.clientHeight));return new I(0,0,r,n)}(e):T(p),B=n.width,s=n.height,o=n.left,i=n.top,a=K({},{allowTaint:!1,imageTimeout:15e3,proxy:void 0,useCORS:!1},N),c={backgroundColor:"#ffffff",cache:N.cache?N.cache:Se.create(r,a),logging:!0,removeContainer:!0,foreignObjectRendering:!1,scale:t.devicePixelRatio||1,windowWidth:t.innerWidth,windowHeight:t.innerHeight,scrollX:t.pageXOffset,scrollY:t.pageYOffset,x:o,y:i,width:Math.ceil(B),height:Math.ceil(s),id:r},Q=K({},c,a,N),u=new I(Q.scrollX,Q.scrollY,Q.windowWidth,Q.windowHeight),be.create({id:r,enabled:Q.logging}),be.getInstance(r).debug("Starting document clone"),w=new xB(p,{id:r,onclone:Q.onclone,ignoreElements:Q.ignoreElements,inlineImages:Q.foreignObjectRendering,copyStyles:Q.foreignObjectRendering}),(U=w.clonedReferenceElement)?[4,w.toIFrame(e,u)]:[2,Promise.reject("Unable to find element in cloned iframe")];case 1:return l=A.sent(),C=e.documentElement?zs(getComputedStyle(e.documentElement).backgroundColor):de.TRANSPARENT,g=e.body?zs(getComputedStyle(e.body).backgroundColor):de.TRANSPARENT,E=N.backgroundColor,h="string"==typeof E?zs(E):null===E?de.TRANSPARENT:4294967295,F=p===e.documentElement?ee(C)?ee(g)?h:g:C:h,d={id:r,cache:Q.cache,canvas:Q.canvas,backgroundColor:F,scale:Q.scale,x:Q.x,y:Q.y,scrollX:Q.scrollX,scrollY:Q.scrollY,width:Q.width,height:Q.height,windowWidth:Q.windowWidth,windowHeight:Q.windowHeight},Q.foreignObjectRendering?(be.getInstance(r).debug("Document cloned, using foreign object rendering"),[4,new Ps(d).render(U)]):[3,3];case 2:return H=A.sent(),[3,5];case 3:return be.getInstance(r).debug("Document cloned, using computed rendering"),Se.attachInstance(Q.cache),be.getInstance(r).debug("Starting DOM parsing"),f=oB(U),Se.detachInstance(),F===f.styles.backgroundColor&&(f.styles.backgroundColor=de.TRANSPARENT),be.getInstance(r).debug("Starting renderer"),[4,new Ss(d).render(f)];case 4:H=A.sent(),A.label=5;case 5:return!0===Q.removeContainer&&(xB.destroy(l)||be.getInstance(r).error("Cannot detach cloned iframe as it is not in the DOM anymore")),be.getInstance(r).debug("Finished rendering"),be.destroy(r),Se.destroy(r),[2,H]}})})};return function(A,e){return void 0===e&&(e={}),Gs(A,e)}});