"use strict";
var app = angular.module("MixSecurity", [
  "ngRoute",
  "ngFileUpload",
  "LocalStorageModule",
  "components",
  "MixShared",
]);
var modules = angular.module("components", []);

app.config(function ($routeProvider, $locationProvider, $sceProvider) {
  $locationProvider.html5Mode(true);

  $routeProvider.when("/security/login", {
    controller: "LoginController",
    templateUrl: "/mix-app/views/app-security/pages/login/view.html",
  });

  $routeProvider.when("/security/register", {
    controller: "RegisterController",
    templateUrl: "/mix-app/views/app-security/pages/register/view.html",
  });
  $routeProvider.when("/security/forgot-password", {
    controller: "ForgotPasswordController",
    templateUrl: "/mix-app/views/app-security/pages/forgot-password/view.html",
  });
  $routeProvider.when("/security/reset-password", {
    controller: "ResetPasswordController",
    templateUrl: "/mix-app/views/app-security/pages/reset-password/view.html",
  });

  $routeProvider.otherwise({ redirectTo: "/security/login" });
});

"use strict";
app.controller("LoginController", [
  "$rootScope",
  "$scope",
  "$location",
  "$routeParams",
  "ApiService",
  "CommonService",
  "AuthService",
  function (
    $rootScope,
    $scope,
    $location,
    $routeParams,
    apiService,
    commonService,
    authService
  ) {
    $scope.canLogin = true;
    if (authService.authentication && authService.isInRole("SuperAdmin")) {
      authService.referredUrl = $location.path();
      $location.path("/portal");
    }

    $scope.pageClass = "page-login";

    $scope.loginData = {
      username: "",
      password: "",
      rememberMe: true,
    };

    $scope.message = "";
    $scope.$on("$viewContentLoaded", async function () {
      $rootScope.isBusy = false;
      await commonService.fillAllSettings();
    });
    $scope.login = async function () {
      $rootScope.isBusy = true;
      var result = await authService.login($scope.loginData);
      if (result.isSucceed) {
        if ($routeParams.ReturnUrl) {
          window.top.location = $routeParams.ReturnUrl;
        } else if (
          document.referrer &&
          document.referrer.indexOf("init") === -1
        ) {
          window.top.location = document.referrer;
        } else {
          window.top.location = "/";
        }
      }
      $rootScope.isBusy = false;
      $scope.$apply();
    };
    $scope.externalLogin = async function (loginData, provider) {
      var result = await authService.externalLogin(loginData, provider);
      if (result) {
        $scope.canLogin = false;
        let returnUrl = $scope.getReturnUrl();
        let hasPermission = $scope.hasPermission(returnUrl);
        if (hasPermission) {
          window.top.location = returnUrl;
        } else {
          $rootScope.showErrors([
            "You don't have permission to access this url",
          ]);
          $rootScope.isBusy = false;
          $scope.$apply();
        }
      }
    };
    $scope.logOut = function () {
      $scope.canLogin = true;
      $scope.$apply();
    };

    $scope.getReturnUrl = function () {
      return $routeParams.ReturnUrl
        ? $routeParams.ReturnUrl
        : document.referrer && document.referrer.indexOf("init") === -1
        ? document.referrer
        : "/";
    };

    $scope.hasPermission = function (url) {
      return (
        url == "/" ||
        authService.isInRole("SuperAdmin") ||
        (authService.authentication.permissions &&
          authService.authentication.permissions.contains(url))
      );
    };

    $scope.authExternalProvider = function (provider) {
      var redirectUri =
        location.protocol + "//" + location.host + "/authcomplete.html";

      var externalProviderUrl =
        ngAuthSettings.apiServiceBaseUri +
        "api/Account/ExternalLogin?provider=" +
        provider +
        "&response_type=token&client_id=" +
        ngAuthSettings.clientId +
        "&redirect_uri=" +
        redirectUri;
      window.$windowScope = $scope;

      var oauthWindow = window.open(
        externalProviderUrl,
        "Authenticate Account",
        "location=0,status=0,width=600,height=750"
      );
    };

    $scope.authCompletedCB = function (fragment) {
      $scope.$apply(function () {
        if (fragment.haslocalaccount === "False") {
          authService.logOut();

          authService.externalAuthData = {
            provider: fragment.provider,
            username: fragment.external_user_name,
            externalAccessToken: fragment.external_access_token,
          };

          $location.path("/associate");
        } else {
          //Obtain access token and redirect to orders
          var externalData = {
            provider: fragment.provider,
            externalAccessToken: fragment.external_access_token,
          };
          authService.obtainAccessToken(externalData).then(
            function (response) {
              $location.path("/orders");
            },
            function (err) {
              $scope.message = err.error_description;
            }
          );
        }
      });
    };
  },
]);

"use strict";
app.controller("ForgotPasswordController", [
  "$rootScope",
  "$scope",
  "ngAppSettings",
  "$location",
  "AuthService",
  function ($rootScope, $scope, ngAppSettings, $location, authService) {
    if (
      authService.authentication &&
      authService.authentication.isAuth &&
      authService.authentication &&
      authService.authentication.isAdmin
    ) {
      authService.referredUrl = $location.path();
      $location.path("/portal");
    }
    $scope.pageClass = "page-forgot-password";
    $scope.isSucceed = false;
    $scope.viewmodel = {
      email: null,
    };

    $scope.message = "";
    $scope.$on("$viewContentLoaded", function () {
      $rootScope.isBusy = false;
      authService.referredUrl = "/security/login";
    });
    $scope.submit = async function () {
      var result = await authService.forgotPassword($scope.viewmodel);
      if (result.isSucceed) {
        $rootScope.isBusy = false;
        $scope.isSucceed = true;
        $scope.$apply();
      } else {
        $rootScope.isBusy = false;
        $rootScope.showErrors(result.errors);
      }
    };

    $scope.authExternalProvider = function (provider) {
      var redirectUri =
        location.protocol + "//" + location.host + "/authcomplete.html";

      var externalProviderUrl =
        ngAuthSettings.apiServiceBaseUri +
        "api/Account/ExternalLogin?provider=" +
        provider +
        "&response_type=token&client_id=" +
        ngAuthSettings.clientId +
        "&redirect_uri=" +
        redirectUri;
      window.$windowScope = $scope;

      var oauthWindow = window.open(
        externalProviderUrl,
        "Authenticate Account",
        "location=0,status=0,width=600,height=750"
      );
    };

    $scope.authCompletedCB = function (fragment) {
      $scope.$apply(function () {
        if (fragment.haslocalaccount === "False") {
          authService.logOut();

          authService.externalAuthData = {
            provider: fragment.provider,
            username: fragment.external_user_name,
            externalAccessToken: fragment.external_access_token,
          };

          $location.path("/associate");
        } else {
          //Obtain access token and redirect to orders
          var externalData = {
            provider: fragment.provider,
            externalAccessToken: fragment.external_access_token,
          };
          authService.obtainAccessToken(externalData).then(
            function (response) {
              $location.path("/orders");
            },
            function (err) {
              $scope.message = err.error_description;
            }
          );
        }
      });
    };
  },
]);

"use strict";
app.controller("RegisterController", [
  "$scope",
  "$rootScope",
  "RegisterServices",
  function ($scope, $rootScope, services) {
    $scope.user = {
      username: "",
      email: "",
      password: "",
      confirmPassword: "",
      isAgreed: false,
    };
    $scope.register = async function () {
      if (!$scope.user.isAgreed) {
        $rootScope.showMessage("Please agreed with our policy", "warning");
      } else {
        if ($scope.password !== $scope.confirmPassword) {
          $rootScope.showErrors(["Confirm Password is not matched"]);
        } else {
          $rootScope.isBusy = true;
          var result = await services.register($scope.user);
          if (result.isSucceed) {
            $rootScope.isBusy = false;
            window.location.href = "/security/login";
          } else {
            if (result) {
              $rootScope.showErrors(result.errors);
            }
            $rootScope.isBusy = false;
            $scope.$apply();
          }
        }
      }
    };
  },
]);

"use strict";
app.factory("RegisterServices", [
  "$http",
  "ApiService",
  "CommonService",
  function ($http, apiService, commonService) {
    //var serviceBase = 'http://ngauthenticationapi.azurewebsites.net/';

    var usersServiceFactory = {};
    var apiUrl = "/portal/";
    var _register = async function (user) {
      var apiUrl = "/account/register";
      var req = {
        method: "POST",
        url: apiUrl,
        data: JSON.stringify(user),
      };

      return await apiService.getApiResult(req);
    };

    usersServiceFactory.register = _register;
    return usersServiceFactory;
  },
]);

"use strict";
app.controller("ResetPasswordController", [
  "$scope",
  "$rootScope",
  "AuthService",
  "$routeParams",
  function ($scope, $rootScope, service, $routeParams) {
    $scope.user = {
      email: "",
      password: "",
      confirmPassword: "",
      code: "",
    };
    $scope.init = function () {
      $scope.user.code = $routeParams.token;
    };
    $scope.submit = async function () {
      if ($scope.password !== $scope.confirmPassword) {
        $rootScope.showErrors(["Confirm Password is not matched"]);
      } else {
        $rootScope.isBusy = true;
        var result = await service.resetPassword($scope.user);
        if (result.isSucceed) {
          $rootScope.isBusy = false;
          window.location.href = "/security/login";
        } else {
          if (result) {
            $rootScope.showErrors(result.errors);
          }
          $rootScope.isBusy = false;
          $scope.$apply();
        }
      }
    };
  },
]);

"use strict";
app.factory("RegisterServices", [
  "$http",
  "ApiService",
  "CommonService",
  function ($http, apiService, commonService) {
    //var serviceBase = 'http://ngauthenticationapi.azurewebsites.net/';

    var usersServiceFactory = {};
    var apiUrl = "/portal/";
    var _register = async function (user) {
      var apiUrl = "/account/register";
      var req = {
        method: "POST",
        url: apiUrl,
        data: JSON.stringify(user),
      };

      return await apiService.getApiResult(req);
    };

    usersServiceFactory.register = _register;
    return usersServiceFactory;
  },
]);
