/* Wed May 18 2022 15:38:26 GMT+0700 (Indochina Time) */"use strict";
var app = angular.module("MixPortal", [
  "angularCroppie",
  "ui.bootstrap",
  "ngRoute",
  "components",
  "ngFileUpload",
  "LocalStorageModule",
  "bw.paging",
  "dndLists",
  "ngTagsInput",
  "ngSanitize",
  "MixShared",
]);
var modules = angular.module("components", []);

"use strict";
app.controller("AppPortalController", [
  "$rootScope",
  "$scope",
  "ngAppSettings",
  "$location",
  "ApiService",
  "CommonService",
  "AuthService",
  "TranslatorService",
  "GlobalSettingsService",
  "localStorageService",
  function (
    $rootScope,
    $scope,
    ngAppSettings,
    $location,
    apiService,
    commonService,
    authService,
    translatorService,
    globalSettingsService,
    localStorageService
  ) {
    $scope.isInit = false;
    $scope.pageTagName = "";
    $scope.pageTagTypeName = "";
    $scope.pageTagType = 0;
    $scope.isAdmin = false;
    $scope.translator = translatorService;
    $rootScope.globalSettingsService = globalSettingsService;
    $scope.lang = null;
    $scope.localizeSettings = {};
    $scope.portalThemeSettings = {};
    $scope.init = function () {
      new ClipboardJS(".btn-clipboard");

      if (!$rootScope.isBusy) {
        $rootScope.isBusy = true;

        commonService.loadJArrayData("micon.json").then((resp) => {
          ngAppSettings.icons = resp.data;
        });
        commonService.loadJsonData("enums.json").then((resp) => {
          ngAppSettings.enums = resp.data;
        });
        commonService.fillAllSettings($scope.lang).then(function (response) {
          ngAppSettings.localizeSettings = $rootScope.localizeSettings.data;
          if ($rootScope.globalSettings) {
            $scope.portalThemeSettings =
              $rootScope.globalSettings.portalThemeSettings;
            authService.fillAuthData().then(function (response) {
              $rootScope.authentication = authService.authentication;
              $scope.isAuth = authService.authentication != null;
              $rootScope.isAuth = authService.authentication != null;
              if (authService.authentication) {
                $scope.isAdmin = authService.isInRole("SuperAdmin");
              } else {
                window.top.location.href = "/security/login";
              }
            });
            $rootScope.isInit = true;
            $scope.isInit = true;
            $rootScope.isBusy = false;
            $scope.$apply();
          } else {
            window.top.location.href = "/security/login";
          }
        });
      }
    };
    $scope.initFB = function () {
      window.fbAsyncInit = function () {
        FB.init({
          appId: "1958592154434745",
          cookie: true,
          xfbml: true,
          version: "v10.0",
        });

        FB.AppEvents.logPageView();
      };
    };
    $scope.$on("$routeChangeStart", function ($event, next, current) {
      // ... you could trigger something here ...
      if (current && current.$$route) {
        $rootScope.referrerUrl = current.$$route.originalPath;
        Object.keys(current.params).forEach(function (key, index) {
          // key: the name of the object key
          // index: the ordinal position of the key within the object
          if ($rootScope.referrerUrl.indexOf(":" + key) >= 0) {
            $rootScope.referrerUrl = $rootScope.referrerUrl.replace(
              ":" + key,
              current.params[key]
            );
          } else {
            if ($rootScope.referrerUrl.indexOf("?") < 0) {
              $rootScope.referrerUrl += "?";
            }
            $rootScope.referrerUrl += key + "=" + current.params[key] + "&";
          }
        });
      }
      $scope.pageTagName = $location.$$path.toString().split("/")[2];
      $scope.pageTagTypeName = $location.$$path.toString().split("/")[3];
      if ($scope.pageTagTypeName == "list") $scope.pageTagType = 1;
      if ($scope.pageTagTypeName == "create") $scope.pageTagType = 2;
    });
    $rootScope.limString = function (str, max) {
      return str.substring(0, max);
    };
    $rootScope.getRequest = function (key) {
      key =
        key || `request${$rootScope.generateKeyword($location.$$path, "_")}`;
      let lstRequest = localStorageService.get("requests") ?? {};
      let request = lstRequest[key];
      if (!request) {
        request = angular.copy(ngAppSettings.request);
        lstRequest[key] = request;
        localStorageService.set("requests", lstRequest);
      }
      return request;
    };
    $rootScope.setRequest = function (req, key) {
      key =
        key || `request${$rootScope.generateKeyword($location.$$path, "_")}`;
      let lstRequest = localStorageService.get("requests") ?? {};
      if (req) {
        lstRequest[key] = req;
        localStorageService.set("requests", lstRequest);
      }
    };
  },
]);

app.config(function (
  $routeProvider,
  $locationProvider,
  $sceProvider,
  ngAppSettings
) {
  $locationProvider.html5Mode(true);
  var data = $.parseJSON($("#portal-menus").val());
  ngAppSettings.routes = data.routes;
  angular.forEach(ngAppSettings.routes, function (cate, key) {
    if (cate.items.length) {
      angular.forEach(cate.items, function (item, key) {
        $routeProvider.when(item.path, {
          controller: item.controller,
          templateUrl: item.templatePath,
        });
      });
    }
  });
  $routeProvider.otherwise({ redirectTo: "/portal" });
});

"use strict";
app.factory("AttributeDataService", [
  "BaseService",
  function (baseService) {
    var serviceFactory = Object.create(baseService);
    serviceFactory.init("attribute-data");
    // Define more service methods here
    return serviceFactory;
  },
]);

"use strict";
app.factory("TemplateService", [
  "BaseRestService",
  "ApiService",
  "CommonService",
  function (baseService, apiService, commonService) {
    var serviceFactory = Object.create(baseService);
    serviceFactory.init("template/portal", true);
    var _copy = async function (id) {
      var url = this.prefixUrl + "/copy/" + id;
      var req = {
        method: "GET",
        url: url,
      };
      return await apiService.getRestApiResult(req);
    };
    serviceFactory.copy = _copy;
    return serviceFactory;
  },
]);

"use strict";
app.controller("AppSettingsController", [
  "$scope",
  "$rootScope",
  "ngAppSettings",
  "$routeParams",
  "$timeout",
  "$location",
  "AuthService",
  "ApiService",
  "CommonService",
  "AppSettingsServices",
  function (
    $scope,
    $rootScope,
    ngAppSettings,
    $routeParams,
    $timeout,
    $location,
    authService,
    apiService,
    commonService,
    appSettingsServices
  ) {
    $scope.appSettings = null;
    $scope.errors = [];
    $scope.statuses = ngAppSettings.contentStatuses;
    $scope.cultures = $rootScope.globalSettings.cultures;
    $scope.getAppSettings = async function (id) {
      $rootScope.isBusy = true;

      var resp = await appSettingsServices.getAppSettings();
      if (resp && resp.isSucceed) {
        $scope.appSettings = JSON.stringify(resp.data);
        $rootScope.initEditor();
        $rootScope.isBusy = false;
        $scope.$apply();
      } else {
        if (resp) {
          $rootScope.showErrors(resp.errors);
        }
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };
    $scope.loadAppSettings = async function () {
      $rootScope.isBusy = true;

      var response = await appSettingsServices.getAppSettings();
      if (response && response.isSucceed) {
        $scope.appSettings = response.data;
        $rootScope.isBusy = false;
        $scope.$apply();
      } else {
        $rootScope.showErrors(response?.errors || ["Failed"]);
        $rootScope.isBusy = false;
        $scope.$apply();
      }

      await apiService.initAllSettings();
      $scope.localizeSettings = $rootScope.localizeSettings;
      $rootScope.isBusy = false;
      $scope.$apply();

      // load portal menus
      commonService.loadJArrayData("portal-menus.json").then((resp) => {
        $scope.menus = resp.data;
        $rootScope.isBusy = false;
        $scope.$apply();
      });
    };

    $scope.saveAppSettings = async function (appSettings) {
      $rootScope.isBusy = true;
      var resp = await appSettingsServices.saveAppSettings(appSettings);
      if (resp && resp.isSucceed) {
        $scope.appSettings = resp.data;
        $rootScope.showMessage("success", "success");
        $rootScope.isBusy = false;
        $scope.$apply();
      } else {
        if (resp) {
          $rootScope.showErrors(resp.errors);
        }
        $scope.$apply();
      }
    };
  },
]);

"use strict";
app.factory("AppSettingsServices", [
  "$http",
  "$rootScope",
  "ApiService",
  "CommonService",
  function ($http, $rootScope, apiService, commonService) {
    //var serviceBase = 'http://ngauthenticationapi.azurewebsites.net/';

    var appSettingssServiceFactory = {};

    var settings = $rootScope.globalSettings;

    var _getAppSettings = async function () {
      var url = "/portal/app-settings/details";

      var req = {
        method: "GET",
        url: url,
      };
      return await apiService.getApiResult(req);
    };

    var _saveAppSettings = async function (appSettings) {
      var apiUrl = "/portal/app-settings/save";
      var req = {
        method: "POST",
        url: apiUrl,
        data: JSON.stringify(appSettings),
      };
      return await apiService.getApiResult(req);
    };
    var _saveGlobalSettings = async function (name, content) {
      var apiUrl = "/portal/app-settings/save-global/" + name;
      var req = {
        method: "POST",
        url: apiUrl,
        data: JSON.stringify(content),
      };
      return await apiService.getApiResult(req);
    };

    appSettingssServiceFactory.getAppSettings = _getAppSettings;
    appSettingssServiceFactory.saveAppSettings = _saveAppSettings;
    appSettingssServiceFactory.saveGlobalSettings = _saveGlobalSettings;
    return appSettingssServiceFactory;
  },
]);

"use strict";
app.controller("ConfigurationController", [
  "$scope",
  "$rootScope",
  "ngAppSettings",
  "$routeParams",
  "$location",
  "ConfigurationService",
  "ApiService",
  "CommonService",
  function (
    $scope,
    $rootScope,
    ngAppSettings,
    $routeParams,
    $location,
    service,
    commonService
  ) {
    BaseRestCtrl.call(
      this,
      $scope,
      $rootScope,
      $location,
      $routeParams,
      ngAppSettings,
      service
    );
    $scope.init = function () {
      $scope.request.category = $routeParams.category || "";
      $scope.getList();
    };
    $scope.getSingleSuccessCallback = function () {
      $scope.cates = ngAppSettings.enums.configuration_cates;
      $scope.globalSettings = $rootScope.globalSettings;
      $scope.request.category = $routeParams.category || "";
      if (!$scope.viewmodel.id) {
        $scope.viewmodel.property.dataType = "Text";
      }
      if (!$scope.viewmodel.category) {
        $scope.viewmodel.category = "Site";
      }
    };
    $scope.saveSuccessCallback = function () {
      commonService.initAllSettings().then(function () {
        // $location.url($scope.referrerUrl);
        $rootScope.isBusy = false;
        $scope.$apply();
      });
    };
    $scope.removeCallback = function () {
      commonService.initAllSettings().then(function () {
        $location.url($scope.referrerUrl);
      });
    };

    $scope.generateName = function () {
      $scope.viewmodel.keyword = $rootScope.generateKeyword(
        $scope.viewmodel.keyword,
        "_",
        true
      );
    };
  },
]);

"use strict";
app.factory("ConfigurationService", [
  "BaseRestService",
  "ApiService",
  "CommonService",
  function (baseService, apiService, commonService) {
    var serviceFactory = Object.create(baseService);
    serviceFactory.init("configuration");

    var _uploadConfiguration = async function (configurationFile) {
      //var container = $(this).parents('.model-configuration').first().find('.custom-file').first();
      if (
        configurationFile.file !== undefined &&
        configurationFile.file !== null
      ) {
        // Create FormData object
        var files = new FormData();

        // Looping over all files and add it to FormData object
        files.append(configurationFile.file.name, configurationFile.file);

        // Adding one more key to FormData object
        files.append("fileFolder", configurationFile.folder);
        files.append("title", configurationFile.title);
        files.append("description", configurationFile.description);

        var req = {
          url: this.prefixUrl + "/upload",
          type: "POST",
          headers: {},
          contentType: false, // Not to set any content header
          processData: false, // Not to process data
          data: files,
        };

        return await apiService.getApiResult(req);
      }
    };
    serviceFactory.uploadConfiguration = _uploadConfiguration;
    return serviceFactory;
  },
]);

"use strict";
app.controller("CultureController", [
  "$scope",
  "$rootScope",
  "ngAppSettings",
  "$routeParams",
  "CultureService",
  "ApiService",
  "CommonService",
  function (
    $scope,
    $rootScope,
    ngAppSettings,
    $routeParams,
    service,
    apiService,
    commonService
  ) {
    $scope.cultures = [
      {
        specificulture: "en-us",
        fullName: "United States - English",
        icon: "flag-icon-us",
      },
      {
        specificulture: "fr-dz",
        fullName: "Algeria - Français",
        icon: "flag-icon-dz",
      },
      {
        specificulture: "es-ar",
        fullName: "Argentina - Español",
        icon: "flag-icon-ar",
      },
      {
        specificulture: "en-au",
        fullName: "Australia - English",
        icon: "flag-icon-au",
      },
      {
        specificulture: "nl-be",
        fullName: "België - Nederlands",
        icon: "flag-icon-be",
      },
      {
        specificulture: "fr-be",
        fullName: "Belgique - Français",
        icon: "flag-icon-be",
      },
      {
        specificulture: "es-bo",
        fullName: "Bolivia - Español",
        icon: "flag-icon-bo",
      },
      {
        specificulture: "bs-ba",
        fullName: "Bosna i Hercegovina – Bosanski",
        icon: "flag-icon-ba",
      },
      {
        specificulture: "pt-br",
        fullName: "Brasil - Português",
        icon: "flag-icon-br",
      },
      {
        specificulture: "en-ca",
        fullName: "Canada - English",
        icon: "flag-icon-ca",
      },
      {
        specificulture: "fr-ca",
        fullName: "Canada - Français",
        icon: "flag-icon-ca",
      },
      {
        specificulture: "cs-cz",
        fullName: "Česká Republika - Čeština",
        icon: "flag-icon-cz",
      },
      {
        specificulture: "es-cl",
        fullName: "Chile - Español",
        icon: "flag-icon-cl",
      },
      {
        specificulture: "es-co",
        fullName: "Colombia - Español",
        icon: "flag-icon-co",
      },
      {
        specificulture: "es-cr",
        fullName: "Costa Rica - Español",
        icon: "flag-icon-cr",
      },
      {
        specificulture: "sr-latn-me",
        fullName: "Crna Gora - Srpski",
        icon: "flag-icon-me",
      },
      {
        specificulture: "en-cy",
        fullName: "Cyprus - English",
        icon: "flag-icon-cy",
      },
      {
        specificulture: "da-dk",
        fullName: "Danmark - Dansk",
        icon: "flag-icon-dk",
      },
      {
        specificulture: "de-de",
        fullName: "Deutschland - Deutsch",
        icon: "flag-icon-de",
      },
      {
        specificulture: "es-ec",
        fullName: "Ecuador - Español",
        icon: "flag-icon-ec",
      },
      {
        specificulture: "et-ee",
        fullName: "Eesti - Eesti",
        icon: "flag-icon-ee",
      },
      {
        specificulture: "en-eg",
        fullName: "Egypt - English",
        icon: "flag-icon-eg",
      },
      {
        specificulture: "es-sv",
        fullName: "El Salvador - Español",
        icon: "flag-icon-sv",
      },
      {
        specificulture: "es-es",
        fullName: "España - Español",
        icon: "flag-icon-es",
      },
      {
        specificulture: "fr-fr",
        fullName: "France - Français",
        icon: "flag-icon-fr",
      },
      {
        specificulture: "es-gt",
        fullName: "Guatemala - Español",
        icon: "flag-icon-gt",
      },
      {
        specificulture: "en-gulf",
        fullName: "Gulf - English",
        icon: "flag-icon-lf",
      },
      {
        specificulture: "es-hn",
        fullName: "Honduras - Español",
        icon: "flag-icon-hn",
      },
      {
        specificulture: "en-hk",
        fullName: "Hong Kong SAR - English",
        icon: "flag-icon-hk",
      },
      {
        specificulture: "hr-hr",
        fullName: "Hrvatska - Hrvatski",
        icon: "flag-icon-hr",
      },
      {
        specificulture: "en-in",
        fullName: "India - English",
        icon: "flag-icon-in",
      },
      {
        specificulture: "id-id",
        fullName: "Indonesia - Bahasa Indonesia",
        icon: "flag-icon-id",
      },
      {
        specificulture: "en-ie",
        fullName: "Ireland - English",
        icon: "flag-icon-ie",
      },
      {
        specificulture: "is-is",
        fullName: "Ísland - Íslenska",
        icon: "flag-icon-is",
      },
      {
        specificulture: "it-it",
        fullName: "Italia - Italiano",
        icon: "flag-icon-it",
      },
      {
        specificulture: "ja-jp",
        fullName: "Japanese - 日本語",
        icon: "flag-icon-jp",
      },
      {
        specificulture: "en-jo",
        fullName: "Jordan - English",
        icon: "flag-icon-jo",
      },
      {
        specificulture: "lv-lv",
        fullName: "Latvija - Latviešu",
        icon: "flag-icon-lv",
      },
      {
        specificulture: "en-lb",
        fullName: "Lebanon - English",
        icon: "flag-icon-lb",
      },
      {
        specificulture: "lt-lt",
        fullName: "Lietuva - Lietuvių",
        icon: "flag-icon-lt",
      },
      {
        specificulture: "hu-hu",
        fullName: "Magyarország - Magyar",
        icon: "flag-icon-hu",
      },
      {
        specificulture: "en-my",
        fullName: "Malaysia - English",
        icon: "flag-icon-my",
      },
      {
        specificulture: "en-mt",
        fullName: "Malta - English",
        icon: "flag-icon-mt",
      },
      {
        specificulture: "es-mx",
        fullName: "México - Español",
        icon: "flag-icon-mx",
      },
      {
        specificulture: "fr-ma",
        fullName: "Morocco - Français",
        icon: "flag-icon-ma",
      },
      {
        specificulture: "nl-nl",
        fullName: "Nederland - Nederlands",
        icon: "flag-icon-nl",
      },
      {
        specificulture: "en-nz",
        fullName: "New Zealand - English",
        icon: "flag-icon-nz",
      },
      {
        specificulture: "es-ni",
        fullName: "Nicaragua - Español",
        icon: "flag-icon-ni",
      },
      {
        specificulture: "en-ng",
        fullName: "Nigeria - English",
        icon: "flag-icon-ng",
      },
      {
        specificulture: "nb-no",
        fullName: "Norge - Bokmål",
        icon: "flag-icon-no",
      },
      {
        specificulture: "de-at",
        fullName: "Österreich - Deutsch",
        icon: "flag-icon-at",
      },
      {
        specificulture: "en-pk",
        fullName: "Pakistan - English",
        icon: "flag-icon-pk",
      },
      {
        specificulture: "es-pa",
        fullName: "Panamá - Español",
        icon: "flag-icon-pa",
      },
      {
        specificulture: "es-py",
        fullName: "Paraguay - Español",
        icon: "flag-icon-py",
      },
      {
        specificulture: "es-pe",
        fullName: "Perú - Español",
        icon: "flag-icon-pe",
      },
      {
        specificulture: "en-ph",
        fullName: "Philippines - English",
        icon: "flag-icon-ph",
      },
      {
        specificulture: "pl-pl",
        fullName: "Polska - Polski",
        icon: "flag-icon-pl",
      },
      {
        specificulture: "pt-pt",
        fullName: "Portugal - Português",
        icon: "flag-icon-pt",
      },
      {
        specificulture: "es-pr",
        fullName: "Puerto Rico - Español",
        icon: "flag-icon-pr",
      },
      {
        specificulture: "es-do",
        fullName: "República Dominicana - Español",
        icon: "flag-icon-do",
      },
      {
        specificulture: "ro-md",
        fullName: "Republica Moldova - Română",
        icon: "flag-icon-md",
      },
      {
        specificulture: "ro-ro",
        fullName: "România - Română",
        icon: "flag-icon-ro",
      },
      {
        specificulture: "en-sa",
        fullName: "Saudi Arabia - English",
        icon: "flag-icon-sa",
      },
      {
        specificulture: "de-ch",
        fullName: "Schweiz - Deutsch",
        icon: "flag-icon-ch",
      },
      {
        specificulture: "en-sg",
        fullName: "Singapore - English",
        icon: "flag-icon-sg",
      },
      {
        specificulture: "sl-si",
        fullName: "Slovenija - Slovenščina",
        icon: "flag-icon-si",
      },
      {
        specificulture: "sk-sk",
        fullName: "Slovensko - Slovenčina",
        icon: "flag-icon-sk",
      },
      {
        specificulture: "en-za",
        fullName: "South Africa - English",
        icon: "flag-icon-za",
      },
      {
        specificulture: "sr-latn-rs",
        fullName: "Srbija - Srpski",
        icon: "flag-icon-rs",
      },
      {
        specificulture: "en-lk",
        fullName: "Sri Lanka - English",
        icon: "flag-icon-lk",
      },
      {
        specificulture: "fr-ch",
        fullName: "Suisse - Français",
        icon: "flag-icon-ch",
      },
      {
        specificulture: "fi-fi",
        fullName: "Suomi - Suomi",
        icon: "flag-icon-fi",
      },
      {
        specificulture: "sv-se",
        fullName: "Sverige - Svenska",
        icon: "flag-icon-se",
      },
      {
        specificulture: "fr-tn",
        fullName: "Tunisia - Français",
        icon: "flag-icon-tn",
      },
      {
        specificulture: "tr-tr",
        fullName: "Türkiye - Türkçe",
        icon: "flag-icon-tr",
      },
      {
        specificulture: "en-gb",
        fullName: "United Kingdom - English",
        icon: "flag-icon-gb",
      },
      {
        specificulture: "en-us",
        fullName: "United States - English",
        icon: "flag-icon-us",
      },
      {
        specificulture: "es-uy",
        fullName: "Uruguay - Español",
        icon: "flag-icon-uy",
      },
      {
        specificulture: "es-ve",
        fullName: "Venezuela - Español",
        icon: "flag-icon-ve",
      },
      {
        specificulture: "vi-vn",
        fullName: "Việt Nam - Tiếng việt",
        icon: "flag-icon-vn",
      },
      {
        specificulture: "el-gr",
        fullName: "Ελλάδα - Ελληνικά",
        icon: "flag-icon-gr",
      },
      {
        specificulture: "ru-by",
        fullName: "Беларусь - Беларуская",
        icon: "flag-icon-by",
      },
      {
        specificulture: "bg-bg",
        fullName: "България - Български",
        icon: "flag-icon-bg",
      },
      {
        specificulture: "ru-kz",
        fullName: "Казахстан - Русский",
        icon: "flag-icon-kz",
      },
      {
        specificulture: "ru-ru",
        fullName: "Россия - Русский",
        icon: "flag-icon-ru",
      },
      {
        specificulture: "uk-ua",
        fullName: "Україна - Українська",
        icon: "flag-icon-ua",
      },
      {
        specificulture: "he-il",
        fullName: "ישראל - עברית",
        icon: "flag-icon-il",
      },
      {
        specificulture: "ar-iq",
        fullName: "العراق - العربية",
        icon: "flag-icon-iq",
      },
      {
        specificulture: "ar-sa",
        fullName: "المملكة العربية السعودية - العربية",
        icon: "flag-icon-sa",
      },
      {
        specificulture: "ar-ly",
        fullName: "ليبيا - العربية",
        icon: "flag-icon-ly",
      },
      {
        specificulture: "ar-eg",
        fullName: "مصر - العربية",
        icon: "flag-icon-eg",
      },
      {
        specificulture: "ar-gulf",
        fullName: "دول الخليج - العربية",
        icon: "flag-icon-lf",
      },
      { specificulture: "th-th", fullName: "ไทย - ไทย", icon: "flag-icon-th" },
      {
        specificulture: "ko-kr",
        fullName: "대한민국 - 한국어",
        icon: "flag-icon-kr",
      },
      {
        specificulture: "zh-cn",
        fullName: "中国 - 简体中文",
        icon: "flag-icon-cn",
      },
      {
        specificulture: "zh-tw",
        fullName: "台灣 - 繁體中文",
        icon: "flag-icon-tw",
      },
      {
        specificulture: "ja-jp",
        fullName: "日本 - 日本語",
        icon: "flag-icon-jp",
      },
      {
        specificulture: "zh-hk",
        fullName: "香港特別行政區 - 繁體中文",
        icon: "flag-icon-hk",
      },
    ];
    $scope.selected = null;
    BaseCtrl.call(
      this,
      $scope,
      $rootScope,
      $routeParams,
      ngAppSettings,
      service
    );
    $scope.saveSuccessCallback = function () {
      commonService
        .initAllSettings()
        .then(() =>
          commonService
            .fillAllSettings($scope.lang)
            .then(() => (window.location.href = "/portal/culture/list"))
        );
    };
    $scope.removeCallback = function () {
      commonService
        .initAllSettings()
        .then(() =>
          commonService
            .fillAllSettings($scope.lang)
            .then(() => (window.location.href = "/portal/culture/list"))
        );
    };
    $scope.changeData = function (selected) {
      if (selected) {
        $scope.viewmodel.specificulture = selected.specificulture;
        $scope.viewmodel.fullName = selected.fullName;
        $scope.viewmodel.icon = selected.icon;
      }
    };
  },
]);

"use strict";
app.factory("CultureService", [
  "BaseService",
  function (baseService) {
    var serviceFactory = Object.create(baseService);
    serviceFactory.init("culture");
    var _updateInfos = async function (pages) {
      var req = {
        method: "POST",
        url: this.prefixUrl + "/update-infos",
        data: JSON.stringify(pages),
      };
      return await apiService.getApiResult(req);
    };

    var _syncTemplates = async function (id) {
      var apiUrl = "/culture/";
      var url = apiUrl + "sync/" + id;
      var req = {
        method: "GET",
        url: url,
      };
      return await apiService.getApiResult(req);
    };

    serviceFactory.syncTemplates = _syncTemplates;
    serviceFactory.updateInfos = _updateInfos;
    return serviceFactory;
  },
]);

"use strict";
app.controller("DashboardController", [
  "$scope",
  "$rootScope",
  "ngAppSettings",
  "$timeout",
  "$location",
  "DashboardServices",
  function (
    $scope,
    $rootScope,
    ngAppSettings,
    $timeout,
    $location,
    dashboardServices
  ) {
    $scope.pageClass = "page-dashboard";
    $(".side-nav li").removeClass("active");
    $(".side-nav .page-dashboard").addClass("active");
    $scope.data = {
      totalPage: 0,
      totalPost: 0,
      totalProduct: 0,
      totalUser: 0,
    };
    $scope.users = [];
    $scope.$on("$viewContentLoaded", function () {
      $rootScope.isBusy = false;
    });
    $scope.getDashboardInfo = async function () {
      $rootScope.isBusy = true;
      var response = await dashboardServices.getDashboardInfo();
      if (response.isSucceed) {
        // $('#mainSection').removeClass('card');
        $scope.data = response.data;
        $rootScope.isBusy = false;
        $scope.$apply();
        // $scope.getChart();
      } else {
        $rootScope.showErrors(response.errors);
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };
    $scope.getChart = function () {
      var ctx = document.getElementById("myChart");
      var myChart = new Chart(ctx, {
        // type: 'pie',
        // data: {
        //   labels: ["Africa", "Asia", "Europe", "Latin America", "North America"],
        //   datasets: [{
        //     label: "Population (millions)",
        //     backgroundColor: ["#3e95cd", "#8e5ea2","#3cba9f","#e8c3b9","#c45850"],
        //     data: [2478,5267,734,784,433]
        //   }]
        // },
        // options: {
        //   title: {
        //     display: true,
        //     text: 'Predicted world population (millions) in 2050'
        //   }
        // }
      });
    };
  },
]);

"use strict";
app.factory("DashboardServices", [
  "$rootScope",
  "$http",
  "ApiService",
  "CommonService",
  function ($rootScope, $http, apiService, commonService) {
    //var serviceBase = 'http://ngauthenticationapi.azurewebsites.net/';

    var usersServiceFactory = {};
    var apiUrl = "/portal/" + $rootScope.localizeSettings.lang;
    var _getDashboardInfo = async function () {
      var req = {
        method: "GET",
        url: apiUrl + "/dashboard",
      };
      return await apiService.getApiResult(req);
    };

    usersServiceFactory.getDashboardInfo = _getDashboardInfo;
    return usersServiceFactory;
  },
]);

"use strict";
app.controller("CustomerController", [
  "$scope",
  "$rootScope",
  "ngAppSettings",
  "$routeParams",
  "$timeout",
  "$location",
  "CustomerServices",
  function (
    $scope,
    $rootScope,
    ngAppSettings,
    $routeParams,
    $timeout,
    $location,
    customerServices
  ) {
    $scope.request = angular.copy(ngAppSettings.request);
    $scope.request.contentStatuses = ["Active"];
    $scope.request.status = "0";
    $scope.activedCustomer = null;
    $scope.relatedCustomers = [];
    $rootScope.isBusy = false;
    $scope.data = {
      pageIndex: 0,
      pageSize: 1,
      totalItems: 0,
    };
    $scope.errors = [];

    $scope.range = function (max) {
      var input = [];
      for (var i = 1; i <= max; i += 1) input.push(i);
      return input;
    };

    $scope.loadCustomer = async function () {
      $rootScope.isBusy = true;
      var id = $routeParams.id;
      var response = await customerServices.getCustomer(id, "portal");
      if (response.isSucceed) {
        $scope.activedCustomer = response.data;
        $rootScope.initEditor();
        $rootScope.isBusy = false;
        $scope.$apply();
      } else {
        $rootScope.showErrors(response.errors);
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };
    $scope.loadCustomers = async function (pageIndex) {
      if (pageIndex !== undefined) {
        $scope.request.pageIndex = pageIndex;
      }
      if ($scope.request.fromDate !== null) {
        var d = new Date($scope.request.fromDate);
        $scope.request.fromDate = d.toISOString();
      }
      if ($scope.request.toDate !== null) {
        var d = new Date($scope.request.toDate);
        $scope.request.toDate = d.toISOString();
      }
      var resp = await customerServices.getCustomers($scope.request);
      if (resp && resp.isSucceed) {
        $scope.data = resp.data;
        //$("html, body").animate({ "scrollTop": "0px" }, 500);
        $.each($scope.data.items, function (i, customer) {
          $.each($scope.activedCustomers, function (i, e) {
            if (e.customerId === customer.id) {
              customer.isHidden = true;
            }
          });
        });
        $rootScope.isBusy = false;
        $scope.$apply();
      } else {
        if (resp) {
          $rootScope.showErrors(resp.errors);
        }
        $scope.$apply();
      }
    };

    $scope.removeCustomer = function (id) {
      $rootScope.showConfirm(
        $scope,
        "removeCustomerConfirmed",
        [id],
        null,
        "Remove Customer",
        "Deleted data will not able to recover, are you sure you want to delete this item?"
      );
    };

    $scope.removeCustomerConfirmed = async function (id) {
      var result = await customerServices.removeCustomer(id);
      if (result.isSucceed) {
        $rootScope.showMessage("success", "success");
        $scope.loadCustomers();
      } else {
        $rootScope.showMessage("failed");
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };

    $scope.saveCustomer = async function (customer) {
      customer.content = $(".editor-content").val();
      var resp = await customerServices.saveCustomer(customer);
      if (resp && resp.isSucceed) {
        $scope.activedCustomer = resp.data;
        $rootScope.showMessage("Update successfully!", "success");
        $rootScope.isBusy = false;
        $scope.$apply();
        //$location.path('/portal/customer/details/' + resp.data.id);
      } else {
        if (resp) {
          $rootScope.showErrors(resp.errors);
        }
        $scope.$apply();
      }
    };
  },
]);

"use strict";
app.factory("CustomerServices", [
  "$http",
  "$rootScope",
  "ApiService",
  "CommonService",
  function ($http, $rootScope, apiService, commonService) {
    //var serviceBase = 'http://ngauthenticationapi.azurewebsites.net/';

    var customersServiceFactory = {};

    var settings = $rootScope.globalSettings;

    var _getCustomer = async function (id, type) {
      var apiUrl = "/queen-beauty/customer/";
      var url = apiUrl + "details/" + type;
      if (id) {
        url += "/" + id;
      }
      var req = {
        method: "GET",
        url: url,
      };
      return await apiService.getApiResult(req);
    };

    var _initCustomer = async function (type) {
      var apiUrl = "/queen-beauty/customer/";
      var req = {
        method: "GET",
        url: apiUrl + "init/" + type,
      };
      return await apiService.getApiResult(req);
    };

    var _getCustomers = async function (request) {
      var apiUrl = "/queen-beauty/customer/";
      var req = {
        method: "POST",
        url: apiUrl + "list",
        data: JSON.stringify(request),
      };

      return await apiService.getApiResult(req);
    };

    var _removeCustomer = async function (id) {
      var apiUrl = "/queen-beauty/customer/";
      var req = {
        method: "GET",
        url: apiUrl + "delete/" + id,
      };
      return await apiService.getApiResult(req);
    };

    var _saveCustomer = async function (customer) {
      var apiUrl = "/queen-beauty/customer/";
      var req = {
        method: "POST",
        url: apiUrl + "save",
        data: JSON.stringify(customer),
      };
      return await apiService.getApiResult(req);
    };

    customersServiceFactory.getCustomer = _getCustomer;
    customersServiceFactory.initCustomer = _initCustomer;
    customersServiceFactory.getCustomers = _getCustomers;
    customersServiceFactory.removeCustomer = _removeCustomer;
    customersServiceFactory.saveCustomer = _saveCustomer;
    return customersServiceFactory;
  },
]);

"use strict";
app.controller("FileController", [
  "$scope",
  "$rootScope",
  "ngAppSettings",
  "$routeParams",
  "$timeout",
  "$location",
  "AuthService",
  "FileServices",
  function (
    $scope,
    $rootScope,
    ngAppSettings,
    $routeParams,
    $timeout,
    $location,
    authService,
    fileServices
  ) {
    $scope.request = {
      pageSize: "10",
      pageIndex: 0,
      status: "Published",
      orderBy: "CreatedDateTime",
      direction: "Desc",
      fromDate: null,
      toDate: null,
      keyword: "",
      key: "",
    };

    $scope.activedFile = null;
    $scope.relatedFiles = [];
    $rootScope.isBusy = false;
    $scope.data = {
      pageIndex: 0,
      pageSize: 1,
      totalItems: 0,
    };
    $scope.errors = [];

    $scope.range = function (max) {
      var input = [];
      for (var i = 1; i <= max; i += 1) input.push(i);
      return input;
    };
    $scope.loadPage = async function (folder) {
      if (folder) {
        $scope.request.key += $scope.request.key !== "" ? "/" : "";
        $scope.request.key += folder;
      }
      $location.url(
        "/portal/file/list?folder=" + encodeURIComponent($scope.request.key)
      );
    };
    $scope.loadFile = async function () {
      $rootScope.isBusy = true;
      $scope.listUrl = "/portal/file/list?folder/" + $routeParams.folder;
      $rootScope.isBusy = true;
      var response = await fileServices.getFile(
        $routeParams.folder,
        $routeParams.filename
      );
      if (response.isSucceed) {
        $scope.activedFile = response.data;
        $rootScope.isBusy = false;
        $scope.$apply();
      } else {
        $rootScope.showErrors(response.errors);
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };
    $scope.loadFiles = async function (folder) {
      if (folder) {
        $scope.request.key +=
          $scope.request.key !== "" ? "wwwroot/" : "wwwroot";
        $scope.request.key += folder;
      } else {
        $scope.request.key = $routeParams.folder
          ? $routeParams.folder
          : "wwwroot";
      }
      if ($routeParams.folder) {
        $scope.backUrl =
          "/portal/file/list?folder=" +
          $routeParams.folder.substring(
            0,
            $routeParams.folder.lastIndexOf("/")
          );
      }
      $rootScope.isBusy = true;
      var resp = await fileServices.getFiles($scope.request);
      if (resp && resp.isSucceed) {
        $scope.data = resp.data;
        $.each($scope.data.items, function (i, file) {
          $.each($scope.activedFiles, function (i, e) {
            if (e.fileId === file.id) {
              file.isHidden = true;
            }
          });
        });
        $rootScope.isBusy = false;
        $scope.$apply();
      } else {
        if (resp) {
          $rootScope.showErrors(resp.errors);
        }
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };

    $scope.removeFile = async function (id) {
      if (confirm("Are you sure!")) {
        $rootScope.isBusy = true;
        var resp = await fileServices.removeFile(id);
        if (resp && resp.isSucceed) {
          $scope.loadFiles();
        } else {
          if (resp) {
            $rootScope.showErrors(resp.errors);
          }
          $rootScope.isBusy = false;
          $scope.$apply();
        }
      }
    };

    $scope.saveFile = async function (file) {
      $rootScope.isBusy = true;
      var resp = await fileServices.saveFile(file);
      if (resp && resp.isSucceed) {
        $scope.activedFile = resp.data;
        $rootScope.showMessage("Update successfully!", "success");
        $rootScope.isBusy = false;
        $scope.$apply();
      } else {
        if (resp) {
          $rootScope.showErrors(resp.errors);
        }
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };
    $scope.updateTemplateContent = function (content) {
      $scope.activedFile.content = content;
    };
  },
]);

"use strict";
app.factory("FileServices", [
  "$http",
  "$rootScope",
  "ApiService",
  "CommonService",
  "BaseService",
  function ($http, $rootScope, apiService, commonService, baseService) {
    //var serviceBase = 'http://ngauthenticationapi.azurewebsites.net/';

    var filesServiceFactory = angular.copy(baseService);
    filesServiceFactory.init("file", true);
    var settings = $rootScope.globalSettings;

    var _getFile = async function (folder, filename) {
      var apiUrl = "/file/";
      var url = apiUrl + "details?folder=" + folder + "&filename=" + filename;
      var req = {
        method: "GET",
        url: url,
      };
      return await apiService.getApiResult(req);
    };

    var _initFile = async function (type) {
      var apiUrl = "/file/";
      var req = {
        method: "GET",
        url: apiUrl + "init/" + type,
      };
      return await apiService.getApiResult(req);
    };

    var _getFiles = async function (request) {
      var apiUrl = "/file/";
      var req = {
        method: "POST",
        url: apiUrl + "list",
        data: JSON.stringify(request),
      };

      return await apiService.getApiResult(req);
    };

    var _removeFile = async function (fullPath) {
      var apiUrl = "/file/";
      var req = {
        method: "GET",
        url: apiUrl + "delete/?fullPath=" + fullPath,
      };
      return await apiService.getApiResult(req);
    };

    var _saveFile = async function (file) {
      var apiUrl = "/file/";
      var req = {
        method: "POST",
        url: apiUrl + "save",
        data: JSON.stringify(file),
      };
      return await apiService.getApiResult(req);
    };
    var _uploadFile = async function (file, folder) {
      var apiUrl = "/file/upload-file";
      var fd = new FormData();
      fd.append("folder", folder);
      fd.append("file", file);
      return await filesServiceFactory.ajaxSubmitForm(fd, apiUrl);
    };

    filesServiceFactory.getFile = _getFile;
    filesServiceFactory.initFile = _initFile;
    filesServiceFactory.getFiles = _getFiles;
    filesServiceFactory.removeFile = _removeFile;
    filesServiceFactory.saveFile = _saveFile;
    filesServiceFactory.uploadFile = _uploadFile;
    return filesServiceFactory;
  },
]);

"use strict";
app.controller("JsonDataController", [
  "$scope",
  "$rootScope",
  "ngAppSettings",
  "$routeParams",
  "$timeout",
  "$location",
  "AuthService",
  "JsonDataService",
  function (
    $scope,
    $rootScope,
    ngAppSettings,
    $routeParams,
    $timeout,
    $location,
    authService,
    service
  ) {
    $scope.request = {
      pageSize: "10",
      pageIndex: 0,
      status: "Published",
      orderBy: "CreatedDateTime",
      direction: "Desc",
      fromDate: null,
      toDate: null,
      keyword: "",
      key: "",
    };

    $scope.activedFile = null;
    $scope.editorVisible = false;
    $scope.data = null;
    $scope.relatedFiles = [];
    $rootScope.isBusy = false;

    $scope.errors = [];

    $scope.loadPage = async function (folder) {
      if (folder) {
        $scope.request.key += $scope.request.key !== "" ? "/" : "";
        $scope.request.key += folder;
      }
      $location.url(
        "/portal/json-data/list?folder=" +
          encodeURIComponent($scope.request.key)
      );
    };
    $scope.init = async function () {
      $rootScope.isBusy = true;
      $scope.filename = $routeParams.filename;
      $scope.folder = $routeParams.folder;
      $scope.listUrl = "/portal/json-data/list?folder=" + $routeParams.folder;
      $rootScope.isBusy = true;
      var response = await service.getFile(
        $routeParams.folder,
        $routeParams.filename
      );
      if (response.isSucceed) {
        $scope.activedFile = response.data;
        $scope.data = $.parseJSON(response.data.content);
        $rootScope.isBusy = false;
        $scope.$apply();
      } else {
        $rootScope.showErrors(response.errors);
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };
    $scope.loadFiles = async function (folder) {
      if (folder) {
        $scope.request.key += $scope.request.key !== "" ? "/" : "";
        $scope.request.key += folder;
      } else {
        $scope.request.key = $routeParams.folder ? $routeParams.folder : "data";
      }

      $rootScope.isBusy = true;
      var resp = await service.getFiles($scope.request);
      if (resp && resp.isSucceed) {
        $scope.data = resp.data;
        $.each($scope.data.items, function (i, file) {
          $.each($scope.activedFiles, function (i, e) {
            if (e.fileId === file.id) {
              file.isHidden = true;
            }
          });
        });
        $rootScope.isBusy = false;
        $scope.$apply();
      } else {
        if (resp) {
          $rootScope.showErrors(resp.errors);
        }
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };

    $scope.removeFile = async function (id) {
      if (confirm("Are you sure!")) {
        $rootScope.isBusy = true;
        var resp = await service.removeFile(id);
        if (resp && resp.isSucceed) {
          $scope.loadFiles();
        } else {
          if (resp) {
            $rootScope.showErrors(resp.errors);
          }
          $rootScope.isBusy = false;
          $scope.$apply();
        }
      }
    };
    $scope.selectPane = function (pane) {
      $scope.editorVisible = pane.header == "Content";
    };
    $scope.save = async function (data) {
      $scope.activedFile.contennt = JSON.stringify(data);
      $scope.saveFile($scope.activedFile);
    };
    $scope.updateData = async function (data) {
      $scope.data = data;
    };
    $scope.saveFile = async function (file) {
      $rootScope.isBusy = true;
      file.content = JSON.stringify($scope.data);
      var resp = await service.saveFile(file);
      if (resp && resp.isSucceed) {
        $scope.activedFile = resp.data;
        $rootScope.showMessage("Update successfully!", "success");
        $rootScope.isBusy = false;
        $scope.$apply();
      } else {
        if (resp) {
          $rootScope.showErrors(resp.errors);
        }
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };
  },
]);

"use strict";
app.factory("JsonDataService", [
  "$http",
  "$rootScope",
  "ApiService",
  "CommonService",
  function ($http, $rootScope, apiService, commonService) {
    var filesServiceFactory = {};

    var settings = $rootScope.globalSettings;

    var _getFile = async function (folder, filename) {
      var apiUrl = "/file/";
      var url = apiUrl + "details?folder=" + folder + "&filename=" + filename;
      var req = {
        method: "GET",
        url: url,
      };
      return await apiService.getApiResult(req);
    };

    var _initFile = async function (type) {
      var apiUrl = "/file/";
      var req = {
        method: "GET",
        url: apiUrl + "init/" + type,
      };
      return await apiService.getApiResult(req);
    };

    var _getFiles = async function (request) {
      var apiUrl = "/file/";
      var req = {
        method: "POST",
        url: apiUrl + "list",
        data: JSON.stringify(request),
      };

      return await apiService.getApiResult(req);
    };

    var _removeFile = async function (id) {
      var apiUrl = "/file/";
      var req = {
        method: "GET",
        url: apiUrl + "delete/" + id,
      };
      return await apiService.getApiResult(req);
    };

    var _saveFile = async function (file) {
      var apiUrl = "/file/";
      var req = {
        method: "POST",
        url: apiUrl + "save",
        data: JSON.stringify(file),
      };
      return await apiService.getApiResult(req);
    };

    filesServiceFactory.getFile = _getFile;
    filesServiceFactory.initFile = _initFile;
    filesServiceFactory.getFiles = _getFiles;
    filesServiceFactory.removeFile = _removeFile;
    filesServiceFactory.saveFile = _saveFile;
    return filesServiceFactory;
  },
]);

"use strict";
app.controller("LocalizeController", [
  "$scope",
  "$rootScope",
  "ngAppSettings",
  "$routeParams",
  "$location",
  "LocalizeService",
  "ApiService",
  "CommonService",
  function (
    $scope,
    $rootScope,
    ngAppSettings,
    $routeParams,
    $location,
    service,
    commonService
  ) {
    BaseRestCtrl.call(
      this,
      $scope,
      $rootScope,
      $location,
      $routeParams,
      ngAppSettings,
      service
    );

    $scope.getSingleSuccessCallback = function () {
      $scope.cates = ngAppSettings.enums.configuration_cates;
      $scope.globalSettings = $rootScope.globalSettings;
      $scope.request.category = $routeParams.category || "";
      if (!$scope.viewmodel.id) {
        $scope.viewmodel.dataType = "Text";
      }
      if (!$scope.viewmodel.category) {
        $scope.viewmodel.category = "Site";
      }
    };
    $scope.saveSuccessCallback = function () {
      commonService.initAllSettings().then(function () {
        // $location.url($scope.referrerUrl);
        $rootScope.isBusy = false;
        $scope.$apply();
      });
    };
    $scope.removeCallback = function () {
      commonService.initAllSettings().then(function () {
        $location.url($scope.referrerUrl);
      });
    };

    $scope.generateName = function () {
      $scope.viewmodel.keyword = $rootScope.generateKeyword(
        $scope.viewmodel.keyword,
        "_",
        true
      );
    };
  },
]);

"use strict";
app.factory("LocalizeService", [
  "BaseRestService",
  "ApiService",
  "CommonService",
  function (baseService, apiService, commonService) {
    var serviceFactory = Object.create(baseService);
    serviceFactory.init("language");

    var _uploadLanguage = async function (languageFile) {
      //var container = $(this).parents('.model-language').first().find('.custom-file').first();
      if (languageFile.file !== undefined && languageFile.file !== null) {
        // Create FormData object
        var files = new FormData();

        // Looping over all files and add it to FormData object
        files.append(languageFile.file.name, languageFile.file);

        // Adding one more key to FormData object
        files.append("fileFolder", languageFile.folder);
        files.append("title", languageFile.title);
        files.append("description", languageFile.description);

        var req = {
          url: this.prefixUrl + "/upload",
          type: "POST",
          headers: {},
          contentType: false, // Not to set any content header
          processData: false, // Not to process data
          data: files,
        };

        return await apiService.getApiResult(req);
      }
    };
    serviceFactory.uploadLanguage = _uploadLanguage;
    return serviceFactory;
  },
]);

"use strict";
app.controller("ImportFileController", [
  "$scope",
  "$rootScope",
  "ImportFileServices",
  "TranslatorService",
  "GlobalSettingsService",
  function (
    $scope,
    $rootScope,
    service,
    translatorService,
    GlobalSettingsService
  ) {
    $scope.saveImportFile = async function () {
      $rootScope.isBusy = true;
      var form = document.getElementById("frm-import");
      var frm = new FormData();
      frm.append("assets", form["assets"].files[0]);
      var response = await service.saveImportFile(frm);
      if (response.isSucceed) {
        $scope.viewmodel = response.data;
        $rootScope.isBusy = false;
        $scope.$apply();
      } else {
        $rootScope.showErrors(response.errors);
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };
  },
]);

"use strict";
app.factory("ImportFileServices", [
  "$rootScope",
  "BaseService",
  function ($rootScope, baseService) {
    //var serviceBase = 'http://ngauthenticationapi.azurewebsites.net/';

    var serviceFactory = {};

    var settings = $rootScope.globalSettings;
    var serviceFactory = Object.create(baseService);
    serviceFactory.init("portal", true);
    var _saveImportFile = async function (frm) {
      var apiUrl = this.prefixUrl + "/" + settings.lang + "/import";
      return await this.ajaxSubmitForm(frm, apiUrl);
    };

    serviceFactory.saveImportFile = _saveImportFile;
    return serviceFactory;
  },
]);

"use strict";
app.controller("loginController", [
  "$rootScope",
  "$scope",
  "ngAppSettings",
  "$location",
  "AuthService",
  "ngAppSettings",
  function (
    $rootScope,
    $scope,
    ngAppSettings,
    $location,
    authService,
    ngAuthSettings
  ) {
    if (
      authService.authentication &&
      authService.authentication.isAuth &&
      authService.authentication.isAdmin
    ) {
      authService.referredUrl = $location.path();
      $location.path("/portal");
    }

    $scope.pageClass = "page-login";

    $scope.loginData = {
      username: "",
      password: "",
      rememberme: true,
    };

    $scope.message = "";
    $scope.$on("$viewContentLoaded", function () {
      $rootScope.isBusy = false;
    });
    $scope.login = async function () {
      if (authService.referredUrl === "/init/login") {
        authService.referredUrl = "/portal";
      }
      $rootScope.isBusy = true;
      var result = await authService.login($scope.loginData);
      if (result.isSucceed) {
        if ($routeParams.ReturnUrl) {
          window.top.location = $routeParams.ReturnUrl;
        } else if (
          document.referrer &&
          document.referrer.indexOf("init") === -1
        ) {
          window.top.location = document.referrer;
        } else {
          window.top.location = "/";
        }
      }
      $rootScope.isBusy = false;
      $scope.$apply();
    };

    $scope.authExternalProvider = function (provider) {
      var redirectUri =
        location.protocol + "//" + location.host + "/authcomplete.html";

      var externalProviderUrl =
        ngAuthSettings.apiServiceBaseUri +
        "api/Account/ExternalLogin?provider=" +
        provider +
        "&response_type=token&client_id=" +
        ngAuthSettings.clientId +
        "&redirect_uri=" +
        redirectUri;
      window.$windowScope = $scope;

      var oauthWindow = window.open(
        externalProviderUrl,
        "Authenticate Account",
        "location=0,status=0,width=600,height=750"
      );
    };

    $scope.authCompletedCB = function (fragment) {
      $scope.$apply(function () {
        if (fragment.haslocalaccount === "False") {
          authService.logOut();

          authService.externalAuthData = {
            provider: fragment.provider,
            username: fragment.external_user_name,
            externalAccessToken: fragment.external_access_token,
          };

          $location.path("/associate");
        } else {
          //Obtain access token and redirect to orders
          var externalData = {
            provider: fragment.provider,
            externalAccessToken: fragment.external_access_token,
          };
          authService.obtainAccessToken(externalData).then(
            function (response) {
              $location.path("/orders");
            },
            function (err) {
              $scope.message = err.error_description;
            }
          );
        }
      });
    };
  },
]);

"use strict";
app.controller("MixDatabaseDataController", [
  "$scope",
  "$rootScope",
  "ngAppSettings",
  "$routeParams",
  "$location",
  "RestMixDatabaseDataPortalService",
  "RestMixDatabaseColumnPortalService",
  function (
    $scope,
    $rootScope,
    ngAppSettings,
    $routeParams,
    $location,
    service,
    columnService
  ) {
    BaseRestCtrl.call(
      this,
      $scope,
      $rootScope,
      $location,
      $routeParams,
      ngAppSettings,
      service
    );
    $scope.queries = {};
    $scope.data = {};
    $scope.exportAll = true;
    $scope.localizeSettings = $rootScope.globalSettings;
    // $scope.request.orderBy = "Priority";
    // $scope.request.direction = "Asc";
    $scope.filterType = "contain";
    $scope.defaultId = "default";
    $scope.importFile = {
      file: null,
      fullPath: "",
      folder: "import",
      title: "",
      description: "",
    };
    $scope.initRouteParams = () => {
      $scope.requestKey = `request${$rootScope.generateKeyword(
        $location.$$path,
        "_"
      )}_${$routeParams.mixDatabaseId}`;
      $scope.request = $rootScope.getRequest($scope.requestKey);
      if ($routeParams.mixDatabaseId) {
        $scope.request.mixDatabaseId = $routeParams.mixDatabaseId;
      }
      $scope.request.mixDatabaseName = $routeParams.mixDatabaseName;
      $scope.request.filterType = $routeParams.filterType || "contain";
      $scope.request.compareType = $routeParams.compareType || "or";

      $scope.mixDatabaseId = $routeParams.mixDatabaseId;
      $scope.mixDatabaseName = $routeParams.mixDatabaseName;
      $scope.mixDatabaseTitle = $routeParams.mixDatabaseTitle;
      $scope.parentId = $routeParams.parentId;
      $scope.parentType = $routeParams.parentType;
      $scope.request.mixDatabaseName = $routeParams.mixDatabaseName;
      $scope.request.isGroup = $routeParams.isGroup || false;
      if ($routeParams.backUrl) {
        $scope.backUrl = decodeURIComponent($routeParams.backUrl);
      }
      if ($routeParams.dataId != $scope.defaultId) {
        $scope.dataId = $routeParams.dataId;
      }

      if ($scope.parentId && $scope.parentType) {
        $scope.refDataModel = {
          parentId: $scope.parentId,
          parentType: $scope.parentType,
        };
      }
    };
    $scope.init = async function () {
      $scope.initRouteParams();
      if ($scope.mixDatabaseName || $scope.mixDatabaseId) {
        var getFields = await columnService.initData(
          $scope.mixDatabaseName || $scope.mixDatabaseId
        );
        if (getFields.isSucceed) {
          $scope.columns = getFields.data;
          $scope.mixDatabaseTitle =
            $scope.mixDatabaseTitle || $scope.columns[0].mixDatabaseName;
          $scope.$apply();
        }
      }
    };
    $scope.saveSuccess = function (data) {
      if ($scope.backUrl) {
        $location.url($scope.backUrl);
      } else {
        window.location.href = window.location.href;
      }
    };
    $scope.selectData = function () {
      if ($scope.selectedList.data.length) {
        $scope.viewmodel = $scope.selectedList.data[0];
      }
    };
    // $scope.saveSuccessCallback = function () {
    //   if ($location.path() == "/portal/mix-database-data/create") {
    //     let backUrl =
    //       $scope.backUrl ||
    //       `/portal/mix-database-data/details?dataId=${$scope.viewmodel.id}`;
    //     $rootScope.goToSiteUrl(backUrl);
    //   } else {
    //     if ($scope.parentId && $scope.parentType == 'Set') {
    //       $rootScope.goToSiteUrl(`/portal/mix-database-data/details?dataId=${$scope.parentId}`);
    //     } else {
    //       let backUrl =
    //         $scope.backUrl ||
    //         `/portal/mix-database-data/list?mixDatabaseId=${$scope.viewmodel.mixDatabaseId}&mixDatabaseName=${$scope.viewmodel.mixDatabaseName}&mixDatabaseTitle=${$scope.viewmodel.mixDatabaseName}`;
    //       $rootScope.goToSiteUrl(backUrl);
    //     }
    //   }
    // };

    $scope.preview = function (item) {
      item.editUrl = "/portal/post/details/" + item.id;
      $rootScope.preview("post", item, item.title, "modal-lg");
    };
    $scope.edit = function (data) {
      $rootScope.goToPath(
        `/portal/mix-database-data/details?dataId=${data.id}&mixDatabaseTitle=${$scope.mixDatabaseTitle}`
      );
    };
    $scope.remove = function (data) {
      $rootScope.showConfirm(
        $scope,
        "removeConfirmed",
        [data.id],
        null,
        "Remove",
        "Deleted data will not able to recover, are you sure you want to delete this item?"
      );
    };

    $scope.removeConfirmed = async function (dataId) {
      $rootScope.isBusy = true;
      var result = await service.delete([dataId]);
      if (result.isSucceed) {
        if ($scope.removeCallback) {
          $rootScope.executeFunctionByName(
            "removeCallback",
            $scope.removeCallbackArgs,
            $scope
          );
        }
        $scope.getList();
      } else {
        $rootScope.showMessage("failed");
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };
    $scope.import = async function () {
      if ($scope.validateDataFile()) {
        $rootScope.isBusy = true;
        var form = document.getElementById("form-portal");
        var result = await service.import(
          $scope.mixDatabaseName,
          form["import-data-inp"].files[0]
        );
        if (result.isSucceed) {
          $rootScope.showMessage("success", "success");
          $rootScope.isBusy = false;
          $scope.getList(0);
        } else {
          $rootScope.showMessage("failed");
          $rootScope.isBusy = false;
          $scope.$apply();
        }
      }
    };
    $scope.validateDataFile = function () {
      if (!$scope.importFile.file) {
        $rootScope.showMessage("Please choose data file", "danger");
        return false;
      } else {
        return true;
      }
    };
    $scope.sendMail = function (data) {
      var email = "";
      angular.forEach(data.values, function (e) {
        if (e.mixDatabaseColumnName == "email") {
          email = e.stringValue;
        }
      });
      $rootScope.showConfirm(
        $scope,
        "sendMailConfirmed",
        [data],
        null,
        "Send mail",
        "Are you sure to send mail to " + email
      );
    };
    $scope.sendMailConfirmed = async function (data) {
      $rootScope.isBusy = true;
      $rootScope.isBusy = true;
      var result = await service.sendMail([data.id]);
      if (result.isSucceed) {
        $rootScope.showMessage("success", "success");
        $rootScope.isBusy = false;
        $scope.$apply();
      } else {
        $rootScope.showMessage("failed");
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };
    $scope.saveOthers = async function () {
      var response = await service.saveList($scope.others);
      if (response.isSucceed) {
        $scope.getList();
        $scope.$apply();
      } else {
        $rootScope.showErrors(response.errors);
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };
    $scope.selectImportFile = function (files) {
      if (files !== undefined && files !== null && files.length > 0) {
        const file = files[0];
        $scope.importFile.folder = "imports";
        $scope.importFile.title = $scope.mixDatabaseName;
        $scope.importFile.description = $scope.mixDatabaseName + "'s data";
        $scope.importFile.file = file;

        // if (ctrl.auto=='true') {
        //     ctrl.uploadFile(file);
        // }
        // else {
        //     ctrl.getBase64(file);
        // }
      }
    };
    $scope.getList = async function (pageIndex) {
      if (pageIndex !== undefined) {
        $scope.request.pageIndex = pageIndex;
      }
      if ($scope.request.fromDate !== null) {
        var df = new Date($scope.request.fromDate);
        $scope.request.fromDate = df.toISOString();
      }
      if ($scope.request.toDate !== null) {
        var dt = new Date($scope.request.toDate);
        $scope.request.toDate = dt.toISOString();
      }
      var query = {};

      Object.keys($scope.queries).forEach((e) => {
        if ($scope.queries[e]) {
          query[e] = $scope.queries[e];
        }
      });
      $scope.request.query = JSON.stringify(query);
      $rootScope.isBusy = true;
      var resp = await service.getList($scope.request);
      if (resp && resp.isSucceed) {
        $scope.data = resp.data;
        $.each($scope.data.items, function (i, data) {
          $.each($scope.activeddata, function (i, e) {
            if (e.dataId === data.id) {
              data.isHidden = true;
            }
          });
        });
        if ($scope.getListSuccessCallback) {
          $scope.getListSuccessCallback();
        }
        $("html, body").animate(
          {
            scrollTop: "0px",
          },
          500
        );
        if (!resp.data || !resp.data.items.length) {
          $scope.queries = {};
        }
        $rootScope.isBusy = false;
        $scope.$apply();
      } else {
        if (resp) {
          $rootScope.showErrors(resp.errors);
        }
        if ($scope.getListFailCallback) {
          $scope.getListFailCallback();
        }
        $scope.queries = {};
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };
    $scope.export = async function (pageIndex, exportAll) {
      if (pageIndex !== undefined) {
        $scope.request.pageIndex = pageIndex;
      }
      if ($scope.request.fromDate !== null) {
        var df = new Date($scope.request.fromDate);
        $scope.request.fromDate = df.toISOString();
      }
      if ($scope.request.toDate !== null) {
        var dt = new Date($scope.request.toDate);
        $scope.request.toDate = dt.toISOString();
      }
      var query = {};
      if ($routeParams.mixDatabaseId) {
        $scope.request.mixDatabaseId = $routeParams.mixDatabaseId;
      }
      $scope.request.mixDatabaseName = $routeParams.mixDatabaseName;
      $scope.request.filterType = $routeParams.filterType || "contain";
      Object.keys($scope.queries).forEach((e) => {
        if ($scope.queries[e]) {
          query[e] = $scope.queries[e];
        }
      });
      $scope.request.query = JSON.stringify(query);
      var request = angular.copy($scope.request);
      $scope.exportAll = $scope.exportAll;
      if (exportAll) {
        request.pageSize = 10000;
        request.pageIndex = 0;
      }
      $rootScope.isBusy = true;
      var resp = await service.export(request);
      if (resp && resp.isSucceed) {
        if (resp.data) {
          window.top.location = resp.data.webPath;
        } else {
          $rootScope.showMessage("Nothing to export");
        }
        $rootScope.isBusy = false;
        $scope.$apply();
      } else {
        if (resp) {
          $rootScope.showErrors(resp.errors);
        }
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };

    $scope.migrate = async function () {
      if ($routeParams.mixDatabaseId) {
        $rootScope.isBusy = true;
        var result = await service.migrate($routeParams.mixDatabaseId);
        $scope.handleResult(result);
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };
  },
]);

"use strict";
app.controller("MixDatabaseController", [
  "$scope",
  "$rootScope",
  "$location",
  "ngAppSettings",
  "$routeParams",
  "RestMixDatabaseDataPortalService",
  "RestMixDatabaseColumnPortalService",
  "RestMixDatabasePortalService",
  function (
    $scope,
    $rootScope,
    $location,
    ngAppSettings,
    $routeParams,
    databaseDataService,
    databaseColumnService,
    databaseService
  ) {
    BaseRestCtrl.call(
      this,
      $scope,
      $rootScope,
      $location,
      $routeParams,
      ngAppSettings,
      databaseService
    );
    $scope.defaultAttr = null;
    $scope.actions = ["Delete"];
    // $scope.request.selects = 'id,title,name,createdDateTime';
    $scope.orders = [
      { title: "Id", value: "id" },
      { title: "Name", value: "name" },
      { title: "Created Date", value: "createdDateTime" },
    ];
    $scope.request.orderBy = "createdDateTime";
    $scope.getSingleSuccessCallback = async function () {
      var getDefaultAttr = await databaseColumnService.getDefault();
      if (getDefaultAttr.isSucceed) {
        $scope.defaultAttr = getDefaultAttr.data;
        $scope.defaultAttr.options = [];
      }
      $scope.$apply();
    };
    $scope.migrate = async function () {
      if ($scope.viewmodel.id) {
        $rootScope.isBusy = true;
        var result = await databaseService.migrate($scope.viewmodel);
        if (result.isSucceed) {
          var migrateData = await databaseDataService.migrate(
            $scope.viewmodel.id
          );
          $scope.handleResult(migrateData);
          $rootScope.isBusy = false;
          $scope.$apply();
        } else {
          $rootScope.showErrors(["Cannot migrate database"]);
          $rootScope.isBusy = false;
          $scope.$apply();
        }
      }
    };
  },
]);

"use strict";
app.controller("ModuleController", [
    "$scope",
    "$rootScope",
    "ngAppSettings",
    "$location",
    "$routeParams",
    "ModuleRestService",
    "SharedModuleDataService",
    "RestRelatedMixDatabasePortalService",
    "RestMixDatabaseDataPortalService",
    "RestMixDatabaseColumnPortalService",
    function(
        $scope,
        $rootScope,
        ngAppSettings,
        $location,
        $routeParams,
        moduleServices,
        moduleDataService,
        RestRelatedMixDatabasePortalService,
        dataService,
        columnService
    ) {
        BaseRestCtrl.call(
            this,
            $scope,
            $rootScope,
            $location,
            $routeParams,
            ngAppSettings,
            moduleServices,
            "product"
        );
        $scope.viewmodelType = "module";
        $scope.contentUrl = "";
        $scope.getSingleSuccessCallback = function() {
            $scope.loadAdditionalData();

            if ($scope.viewmodel.id > 0) {
                // module => list post or list product
                if ($scope.viewmodel.type.localeCompare("ListPost") == 0) {
                    $scope.contentUrl = "/portal/module-post/list/" + $scope.viewmodel.id;
                } else if ($scope.viewmodel.type.localeCompare("Data") == 0) {
                    $scope.contentUrl = "/portal/module-data/list/" + $scope.viewmodel.id;
                }
            }
            if ($scope.viewmodel.sysCategories) {
                angular.forEach($scope.viewmodel.sysCategories, function(e) {
                    e.attributeData.obj.isActived = true;
                });
            }

            if ($scope.viewmodel.sysTags) {
                angular.forEach($scope.viewmodel.sysTags, function(e) {
                    e.attributeData.obj.isActived = true;
                });
            }

            if ($routeParams.template) {
                $scope.viewmodel.view = $rootScope.findObjectByKey(
                    $scope.viewmodel.templates,
                    "fileName",
                    $routeParams.template
                );
            }
        };
        $scope.getListByType = async function(pageIndex) {
            $scope.request.query = "?type=" + $scope.type;
            await $scope.getList(pageIndex);
        };
        $scope.defaultAttr = {
            name: "",
            options: [],
            priority: 0,
            dataType: 7,
            isGroupBy: false,
            isSelect: false,
            isDisplay: true,
            width: 3,
        };
        $scope.type = "-1";

        $scope.localizeSettings = $rootScope.globalSettings;
        $scope.viewmodel = null;
        $scope.editDataUrl = "";

        $scope.loadModuleDatas = async function() {
            $rootScope.isBusy = true;
            var id = $routeParams.id;
            $scope.dataColumns = [];
            var response = await moduleServices.getSingle([id]);
            if (response.isSucceed) {
                $scope.viewmodel = response.data;
                $scope.editDataUrl =
                    "/portal/module-data/details/" + $scope.viewmodel.id;
                $scope.loadMoreModuleDatas();
                angular.forEach($scope.viewmodel.columns, function(e, i) {
                    if (e.isDisplay) {
                        $scope.dataColumns.push({
                            title: e.title,
                            name: e.name,
                            filter: true,
                            type: 0, // string - ngAppSettings.dataTypes[0]
                        });
                    }
                });
                $rootScope.isBusy = false;
                $scope.$apply();
            } else {
                $rootScope.showErrors(response.errors);
                $rootScope.isBusy = false;
                $scope.$apply();
            }
        };

        $scope.loadMoreModuleDatas = async function(pageIndex) {
            $scope.request.query = "&module_id=" + $scope.viewmodel.id;
            if (pageIndex !== undefined) {
                $scope.request.pageIndex = pageIndex;
            }
            if ($scope.request.fromDate !== null) {
                var d = new Date($scope.request.fromDate);
                $scope.request.fromDate = d.toISOString();
            }
            if ($scope.request.toDate !== null) {
                var d = new Date($scope.request.toDate);
                $scope.request.toDate = d.toISOString();
            }
            $rootScope.isBusy = true;
            var resp = await moduleDataService.getModuleDatas($scope.request);
            if (resp && resp.isSucceed) {
                $scope.viewmodel.data = resp.data;
                $rootScope.isBusy = false;
                $scope.$apply();
            } else {
                if (resp) {
                    $rootScope.showErrors(resp.errors);
                }
                $rootScope.isBusy = false;
                $scope.$apply();
            }
        };
        $scope.exportModuleData = async function(pageIndex) {
            $scope.request.query = "&module_id=" + $scope.viewmodel.id;
            if (pageIndex !== undefined) {
                $scope.request.pageIndex = pageIndex;
            }
            if ($scope.request.fromDate !== null) {
                var d = new Date($scope.request.fromDate);
                $scope.request.fromDate = d.toISOString();
            }
            if ($scope.request.toDate !== null) {
                var d = new Date($scope.request.toDate);
                $scope.request.toDate = d.toISOString();
            }
            $rootScope.isBusy = true;
            var resp = await moduleDataService.exportModuleData($scope.request);
            if (resp && resp.isSucceed) {
                window.top.location = resp.data;
                $rootScope.isBusy = false;
                $scope.$apply();
            } else {
                if (resp) {
                    $rootScope.showErrors(resp.errors);
                }
                $rootScope.isBusy = false;
                $scope.$apply();
            }
        };

        $scope.removeData = function(id) {
            if ($scope.viewmodel) {
                $rootScope.showConfirm(
                    $scope,
                    "removeDataConfirmed", [id],
                    null,
                    "Remove Data",
                    "Deleted data will not able to recover, are you sure you want to delete this item?"
                );
            }
        };

        $scope.removeDataConfirmed = async function(id) {
            $rootScope.isBusy = true;
            var result = await moduleDataService.removeModuleData(id);
            if (result.isSucceed) {
                $scope.loadModuleDatas();
            } else {
                $rootScope.showMessage("failed");
                $rootScope.isBusy = false;
                $scope.$apply();
            }
        };
        $scope.updateModuleDataField = async function(item, propertyName) {
            var result = await moduleDataService.saveFields(
                item.id,
                propertyName,
                item[propertyName]
            );
            if (result.isSucceed) {
                $scope.loadModuleDatas();
            } else {
                $rootScope.showMessage("failed");
                $rootScope.isBusy = false;
                $scope.$apply();
            }
        };
        $scope.updateDataInfos = async function(items) {
            $rootScope.isBusy = true;
            var resp = await moduleDataService.updateInfos(items);
            if (resp && resp.isSucceed) {
                $scope.activedPage = resp.data;
                $rootScope.showMessage("success", "success");
                $rootScope.isBusy = false;
                $scope.$apply();
            } else {
                if (resp) {
                    $rootScope.showErrors(resp.errors);
                }
                $rootScope.isBusy = false;
                $scope.$apply();
            }
        };
        $scope.saveSuccessCallback = async function() {
            if ($scope.additionalData) {
                $scope.additionalData.isClone = $scope.viewmodel.isClone;
                $scope.additionalData.cultures = $scope.viewmodel.cultures;
                $scope.additionalData.parentId = $scope.viewmodel.id;
                $scope.additionalData.parentType = "Module";
                let result = await dataService.save($scope.additionalData);
                if (!result.isSucceed) {
                    $rootScope.showErrors(result.errors);
                } else {
                    $scope.additionalData = result.data;
                    $scope.saveColumns();
                }
            }
        };
        $scope.saveColumns = async function() {
            let result = await columnService.saveMany($scope.additionalData.columns);
            if (result.isSucceed) {
                $rootScope.showMessage("success", "success");
            }
        };
        $scope.loadPosts = async function() {
            $rootScope.isBusy = true;
            var id = $routeParams.id;
            $scope.postRequest.query += "&page_id=" + id;
            var response = await pagePostRestService.getList($scope.postRequest);
            if (response.isSucceed) {
                $scope.pageData.posts = response.data;
                $rootScope.isBusy = false;
                $scope.$apply();
            } else {
                $rootScope.showErrors(response.errors);
                $rootScope.isBusy = false;
                $scope.$apply();
            }
        };
        $scope.selectedCol = null;
        $scope.dragoverCallback = function(index, item, external, type) {
            //console.log('drop ', index, item, external, type);
        };
        $scope.insertColCallback = function(index, item, external, type) {};
        $scope.removeAttribute = function(attr, index) {
            $rootScope.showConfirm(
                $scope,
                "removeAttributeConfirmed", [attr, index],
                null,
                "Remove Field",
                "Deleted data will not able to recover, are you sure you want to delete this item?"
            );
        };
        $scope.removeAttributeConfirmed = function(attr, index) {
            RestRelatedMixDatabasePortalService.delete([]);
            $scope.viewmodel.attributeData.data.values.splice(index, 1);
        };
        $scope.loadAdditionalData = async function() {
            const obj = {
                parentType: "Module",
                parentId: $scope.viewmodel.id,
                databaseName: "sys_additional_column_module",
            };
            const getData = await dataService.getAdditionalData(obj);
            if (getData.isSucceed) {
                $scope.additionalData = getData.data;
                $rootScope.isBusy = false;
                $scope.$apply();
            }
        };
    },
]);
"use strict";
app.factory("ModuleRestService", [
  "BaseRestService",
  function (baseService) {
    var serviceFactory = Object.create(baseService);
    serviceFactory.init("module/portal");
    // Define more service methods here
    return serviceFactory;
  },
]);

"use strict";
app.controller("ModuleDataController", [
  "$scope",
  "$rootScope",
  "ngAppSettings",
  "$routeParams",
  "$location",
  "ModuleDataRestService",
  "ModuleRestService",
  "ApiService",
  "CommonService",
  function (
    $scope,
    $rootScope,
    ngAppSettings,
    $routeParams,
    $location,
    service,
    moduleService,
    commonService
  ) {
    BaseRestCtrl.call(
      this,
      $scope,
      $rootScope,
      $location,
      $routeParams,
      ngAppSettings,
      service
    );
    // $scope.request.orderBy = "Priority";
    // $scope.request.direction = "Asc";
    $scope.cates = ["Site", "System"];
    $scope.others = [];
    $scope.localizeSettings = $rootScope.globalSettings;
    $scope.moduleId = $routeParams.moduleId;
    $scope.backUrl = `/portal/module-data/list/${$scope.moduleId}`;
    $scope.module = null;
    $scope.dataColumns = [];
    $scope.editDataUrl = "/portal/module-data/details/" + $scope.moduleId;
    $scope.init = async function () {
      $scope.id = $routeParams.id;
      if (!$scope.module) {
        var getModule = await moduleService.getSingle([$scope.moduleId]);
        if (getModule.isSucceed) {
          $scope.module = getModule.data;
          angular.forEach($scope.module.columns, function (e, i) {
            if (e.isDisplay) {
              $scope.dataColumns.push({
                title: e.title,
                name: e.name,
                datatype: e.dataType,
                filter: true,
                type: 0, // string - ngAppSettings.dataTypes[0]
              });
            }
          });
          $scope.$apply();
        }
      }
    };
    $scope.getList = async function () {
      $rootScope.isBusy = true;
      $scope.request.module_id = $scope.moduleId;
      var response = await service.getList($scope.request);
      if (response.isSucceed) {
        $scope.data = response.data;
        $rootScope.isBusy = false;
        $scope.$apply();
      } else {
        $rootScope.showErrors(response.errors);
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };

    $scope.export = async function () {
      $rootScope.isBusy = true;
      $scope.request.module_id = $scope.moduleId;
      var response = await service.export($scope.request);
      if (response.isSucceed) {
        window.top.location = response.data.webPath;
        $rootScope.isBusy = false;
        $scope.$apply();
      } else {
        $rootScope.showErrors(response.errors);
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };

    $scope.getSingle = async function () {
      $rootScope.isBusy = true;
      var resp = await service.getSingle($routeParams.id, "portal");
      if (resp && resp.isSucceed) {
        $scope.activedModuleData = resp.data;
        $rootScope.initEditor();
        $rootScope.isBusy = false;
        $scope.$apply();
      } else {
        if (resp) {
          $rootScope.showErrors(resp.errors);
        }
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };
    $scope.remove = function (dataId) {
      $rootScope.showConfirm(
        $scope,
        "removeConfirmed",
        [dataId],
        null,
        "Remove",
        "Deleted data will not able to recover, are you sure you want to delete this item?"
      );
    };

    $scope.removeConfirmed = async function (dataId) {
      $rootScope.isBusy = true;
      var result = await service.delete([dataId]);
      if (result.isSucceed) {
        if ($scope.removeCallback) {
          $rootScope.executeFunctionByName(
            "removeCallback",
            $scope.removeCallbackArgs,
            $scope
          );
        }
        $scope.getList();
      } else {
        $rootScope.showMessage("failed");
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };

    $scope.removeCallback = function () {};

    $scope.saveOthers = async function () {
      var response = await service.saveList($scope.others);
      if (response.isSucceed) {
        $scope.getList();
        $scope.$apply();
      } else {
        $rootScope.showErrors(response.errors);
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };
  },
]);

"use strict";
app.factory("ModuleDataRestService", [
  "BaseRestService",
  "ApiService",
  "CommonService",
  function (baseService, apiService, commonService) {
    var serviceFactory = Object.create(baseService);
    serviceFactory.init("module-data/portal");
    // Define more service methods here

    var _initForm = async function (moduleId) {
      var url = `${this.prefixUrl}/init-form/${moduleId}`;
      var req = {
        method: "GET",
        url: url,
      };
      return await apiService.getRestApiResult(req);
    };
    serviceFactory.initForm = _initForm;
    return serviceFactory;
  },
]);

"use strict";
app.controller("ModuleGalleryController", [
  "$scope",
  "$rootScope",
  "ngAppSettings",
  "$routeParams",
  "$location",
  "ModuleGalleryService",
  "ApiService",
  "CommonService",
  function (
    $scope,
    $rootScope,
    ngAppSettings,
    $routeParams,
    $location,
    service,
    apiService,
    commonService
  ) {
    BaseCtrl.call(
      this,
      $scope,
      $rootScope,
      $routeParams,
      ngAppSettings,
      service
    );
    $scope.cates = ["Site", "System"];
    $scope.others = [];
    $scope.localizeSettings = $rootScope.globalSettings;
    $scope.moduleId = $routeParams.id;
    $scope.canDrag =
      $scope.request.orderBy !== "Priority" || $scope.request.direction !== "0";
    $scope.translate = $rootScope.translate;
    $scope.moduleId = $routeParams.id;
    $scope.getList = async function () {
      $rootScope.isBusy = true;
      var id = $routeParams.id;
      $scope.moduleId = $routeParams.id;
      $scope.request.query = "&module_id=" + id;
      $scope.canDrag =
        $scope.request.orderBy !== "Priority" ||
        $scope.request.direction !== "0";
      var response = await service.getList($scope.request);
      if (response.isSucceed) {
        $scope.data = response.data;
        $rootScope.isBusy = false;
        $scope.$apply();
      } else {
        $rootScope.showErrors(response.errors);
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };
    $scope.remove = function (moduleId, postId) {
      $rootScope.showConfirm(
        $scope,
        "removeConfirmed",
        [moduleId, postId],
        null,
        "Remove",
        "Deleted data will not able to recover, are you sure you want to delete this item?"
      );
    };

    $scope.removeConfirmed = async function (moduleId, postId) {
      $rootScope.isBusy = true;
      var result = await service.delete(moduleId, postId);
      if (result.isSucceed) {
        if ($scope.removeCallback) {
          $rootScope.executeFunctionByName(
            "removeCallback",
            $scope.removeCallbackArgs,
            $scope
          );
        }
        $scope.getList();
      } else {
        $rootScope.showMessage("failed");
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };

    $scope.removeCallback = function () {};

    $scope.saveOthers = async function () {
      var response = await service.saveList($scope.others);
      if (response.isSucceed) {
        $scope.getList();
        $scope.$apply();
      } else {
        $rootScope.showErrors(response.errors);
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };
    $scope.updateInfos = async function (index) {
      $scope.data.items.splice(index, 1);
      $rootScope.isBusy = true;
      var startIndex = $scope.data.items[0].priority - 1;
      for (var i = 0; i < $scope.data.items.length; i++) {
        $scope.data.items[i].priority = startIndex + i + 1;
      }
      var resp = await service.updateInfos($scope.data.items);
      if (resp && resp.isSucceed) {
        $scope.activedPage = resp.data;
        $rootScope.showMessage("success", "success");
        $rootScope.isBusy = false;
        $scope.$apply();
      } else {
        if (resp) {
          $rootScope.showErrors(resp.errors);
        }
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };
  },
]);

"use strict";
app.factory("ModuleGalleryService", [
  "$rootScope",
  "ApiService",
  "CommonService",
  "BaseService",
  function ($rootScope, apiService, commonService, baseService) {
    var serviceFactory = Object.create(baseService);
    serviceFactory.init("module-post");
    var _delete = async function (moduleId, postId) {
      var url = this.prefixUrl + "/delete/" + moduleId + "/" + postId;
      var req = {
        method: "GET",
        url: url,
      };
      return await apiService.getApiResult(req);
    };
    var _updateInfos = async function (modules) {
      var req = {
        method: "POST",
        url: this.prefixUrl + "/update-infos",
        data: JSON.stringify(modules),
      };
      return await apiService.getApiResult(req);
    };
    serviceFactory.delete = _delete;
    serviceFactory.updateInfos = _updateInfos;
    return serviceFactory;
  },
]);

"use strict";
app.controller("ModulePostController", [
  "$scope",
  "$rootScope",
  "ngAppSettings",
  "$routeParams",
  "$location",
  "ModulePostRestService",
  "ApiService",
  "CommonService",
  function (
    $scope,
    $rootScope,
    ngAppSettings,
    $routeParams,
    $location,
    service,
    commonService
  ) {
    BaseCtrl.call(
      this,
      $scope,
      $rootScope,
      $routeParams,
      ngAppSettings,
      service
    );
    $scope.cates = ["Site", "System"];
    $scope.others = [];
    $scope.localizeSettings = $rootScope.globalSettings;
    $scope.canDrag =
      $scope.request.orderBy !== "Priority" || $scope.request.direction !== "0";
    $scope.translate = $rootScope.translate;
    $scope.moduleIds = $routeParams.moduleIds || $routeParams.id;
    $scope.pageIds = $routeParams.page_ids || "";
    $scope.type = $routeParams.type || "";
    $scope.template = $routeParams.template || "";

    $scope.init = function () {
      $scope.createUrl = `/portal/post/create?page_ids=${$scope.pageIds}&module_ids=${$scope.moduleIds}&type=${$scope.type}&template=${$scope.template}`;
      $scope.getList();
    };
    $scope.getList = async function (pageIndex) {
      $rootScope.isBusy = true;
      if (pageIndex !== undefined) {
        $scope.request.pageIndex = pageIndex;
      }
      var id = $routeParams.id;
      $scope.moduleId = $routeParams.id;
      $scope.request.query = "&module_id=" + id;
      $scope.canDrag =
        $scope.request.orderBy !== "Priority" ||
        $scope.request.direction !== "0";
      var response = await service.getList($scope.request);
      if (response.isSucceed) {
        $scope.data = response.data;
        $rootScope.isBusy = false;
        $scope.$apply();
      } else {
        $rootScope.showErrors(response.errors);
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };
    $scope.preview = function (item) {
      item.editUrl = "/portal/post/details/" + item.id;
      $rootScope.preview("post", item, item.title, "modal-lg");
    };
    $scope.remove = function (moduleId, postId) {
      $rootScope.showConfirm(
        $scope,
        "removeConfirmed",
        [moduleId, postId],
        null,
        "Remove",
        "Deleted data will not able to recover, are you sure you want to delete this item?"
      );
    };

    $scope.removeConfirmed = async function (moduleId, postId) {
      $rootScope.isBusy = true;
      var result = await service.delete(moduleId, postId);
      if (result.isSucceed) {
        if ($scope.removeCallback) {
          $rootScope.executeFunctionByName(
            "removeCallback",
            $scope.removeCallbackArgs,
            $scope
          );
        }
        $scope.getList();
      } else {
        $rootScope.showMessage("failed");
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };

    $scope.removeCallback = function () {};

    $scope.saveOthers = async function () {
      var response = await service.saveList($scope.others);
      if (response.isSucceed) {
        $scope.getList();
        $scope.$apply();
      } else {
        $rootScope.showErrors(response.errors);
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };
    $scope.updateInfos = async function (index) {
      $scope.data.items.splice(index, 1);
      $rootScope.isBusy = true;
      var startIndex = $scope.data.items[0].priority - 1;
      for (var i = 0; i < $scope.data.items.length; i++) {
        $scope.data.items[i].priority = startIndex + i + 1;
      }
      var resp = await service.updateInfos($scope.data.items);
      if (resp && resp.isSucceed) {
        $scope.activedPage = resp.data;
        $rootScope.showMessage("success", "success");
        $rootScope.isBusy = false;
        $scope.$apply();
      } else {
        if (resp) {
          $rootScope.showErrors(resp.errors);
        }
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };
  },
]);

"use strict";
app.factory("ModulePostRestService", [
  "$rootScope",
  "ApiService",
  "CommonService",
  "BaseService",
  function ($rootScope, apiService, commonService, baseService) {
    var serviceFactory = Object.create(baseService);
    serviceFactory.init("module-post");
    var _delete = async function (moduleId, postId) {
      var url = this.prefixUrl + "/delete/" + moduleId + "/" + postId;
      var req = {
        method: "GET",
        url: url,
      };
      return await apiService.getApiResult(req);
    };
    var _updateInfos = async function (modules) {
      var req = {
        method: "POST",
        url: this.prefixUrl + "/update-infos",
        data: JSON.stringify(modules),
      };
      return await apiService.getApiResult(req);
    };
    serviceFactory.delete = _delete;
    serviceFactory.updateInfos = _updateInfos;
    return serviceFactory;
  },
]);

"use strict";
app.controller("PageController", [
  "$scope",
  "$rootScope",
  "ngAppSettings",
  "$location",
  "$routeParams",
  "PageRestService",
  "PagePostRestService",
  "PagePageRestService",
  "UrlAliasService",
  "RestMixDatabaseDataPortalService",
  "RestMixDatabaseColumnPortalService",
  function (
    $scope,
    $rootScope,
    ngAppSettings,
    $location,
    $routeParams,
    service,
    pagePostRestService,
    pagePageRestService,
    urlAliasService,
    dataService,
    columnService
  ) {
    BaseRestCtrl.call(
      this,
      $scope,
      $rootScope,
      $location,
      $routeParams,
      ngAppSettings,
      service
    );
    $scope.viewmodelType = "page";
    $scope.request.query = "level=0";
    $scope.pageType = "";
    $scope.pageTypes = $rootScope.globalSettings.pageTypes;
    $scope.selectedCategories = [];
    $scope.selectedTags = [];
    $scope.pageData = {
      posts: [],
      products: [],
      data: [],
    };
    $scope.postRequest = angular.copy(ngAppSettings.request);
    $scope.canDrag =
      $scope.request.orderBy !== "Priority" || $scope.request.direction !== "0";
    $scope.loadPosts = async function () {
      $rootScope.isBusy = true;
      var id = $routeParams.id;
      $scope.postRequest.query += "&page_id=" + id;
      var response = await pagePostRestService.getList($scope.postRequest);

      if (response.isSucceed) {
        $scope.pageData.posts = response.data;
        $rootScope.isBusy = false;
        $scope.$apply();
      } else {
        $rootScope.showErrors(response.errors);
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };
    $scope.getSingleSuccessCallback = function () {
      $scope.loadAdditionalData();
      if ($routeParams.template) {
        $scope.viewmodel.view = $rootScope.findObjectByKey(
          $scope.viewmodel.templates,
          "fileName",
          $routeParams.template
        );
      }
    };
    $scope.getListSuccessCallback = function () {
      $scope.canDrag =
        $scope.request.orderBy !== "Priority" ||
        $scope.request.direction !== "0";
    };
    $scope.loadAdditionalData = async function () {
      const obj = {
        parentType: "Page",
        parentId: $scope.viewmodel.id,
        databaseName: "sys_additional_column_page",
      };
      const getData = await dataService.getAdditionalData(obj);
      if (getData.isSucceed) {
        $scope.additionalData = getData.data;
        $scope.$apply();
      }
    };
    $scope.showChilds = function (id) {
      $("#childs-" + id).toggleClass("collapse");
    };
    $scope.updateInfos = async function (index) {
      $scope.data.items.splice(index, 1);
      $rootScope.isBusy = true;
      var startIndex = $scope.data.items[0].priority - 1;
      for (var i = 0; i < $scope.data.items.length; i++) {
        $scope.data.items[i].priority = startIndex + i + 1;
      }
      var resp = await service.updateInfos($scope.data.items);
      if (resp && resp.isSucceed) {
        $scope.activedPage = resp.data;
        $rootScope.showMessage("success", "success");
        $rootScope.isBusy = false;
        $scope.$apply();
      } else {
        if (resp) {
          $rootScope.showErrors(resp.errors);
        }
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };
    $scope.selPageType = function () {
      $scope.request.query = "level=0&pageType=" + $scope.pageType;
      $scope.getList();
    };
    $scope.goUp = async function (items, index) {
      items[index].priority -= 1;
      items[index - 1].priority += 1;
    };

    $scope.goDown = async function (items, index) {
      items[index].priority += 1;
      items[index - 1].priority -= 1;
    };

    $scope.updatePagePage = async function (items) {
      $rootScope.isBusy = true;
      var resp = await pagePageRestService.updateInfos(items);
      if (resp && resp.isSucceed) {
        $scope.activedPage = resp.data;
        $rootScope.showMessage("success", "success");
        $scope.getList();
      } else {
        if (resp) {
          $rootScope.showErrors(resp.errors);
        }
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };
    $scope.saveSuccessCallback = async function () {
      if ($scope.additionalData) {
        $scope.additionalData.isClone = $scope.viewmodel.isClone;
        $scope.additionalData.cultures = $scope.viewmodel.cultures;
        $scope.additionalData.parentId = $scope.viewmodel.id;
        $scope.additionalData.parentType = "Page";
        let result = await dataService.save($scope.additionalData);
        if (!result.isSucceed) {
          $rootScope.showErrors(result.errors);
        } else {
          $scope.additionalData = result.data;
          $scope.saveColumns();
        }
      }
      $rootScope.isBusy = false;
      $scope.$apply();
    };

    $scope.saveColumns = async function () {
      let result = await columnService.saveMany($scope.additionalData.columns);
      if (result.isSucceed) {
        $rootScope.showMessage("success", "success");
      }
    };

    $scope.validate = async function () {
      // Add default alias if create new page
      if (!$scope.viewmodel.id && !$scope.viewmodel.urlAliases.length) {
        // Ex: en-us/page-seo-name
        // await $scope.addAlias($scope.viewmodel.specificulture + '/' + $scope.viewmodel.seoName);
        return true;
      } else {
        return true;
      }
    };
    $scope.addAlias = async function (alias) {
      var getAlias = await urlAliasService.getSingle();
      if (getAlias.isSucceed) {
        if (alias) {
          getAlias.data.alias = alias;
        }
        $scope.viewmodel.urlAliases.push(getAlias.data);
        $rootScope.isBusy = false;
        $scope.$apply();
      } else {
        $rootScope.showErrors(getAlias.errors);
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };
    $scope.updateSysCategories = function (data) {
      // Loop selected categories
      angular.forEach($scope.selectedCategories, function (e) {
        // add if not exist in sysCategories
        var current = $rootScope.findObjectByKey(
          $scope.viewmodel.sysCategories,
          "id",
          e.id
        );
        if (!current) {
          $scope.viewmodel.sysCategories.push({
            id: e.id,
            parentId: $scope.viewmodel.id,
            mixDatabaseName: "sys_category",
          });
        }
      });
    };
    $scope.updateSysTags = function (data) {
      // Loop selected categories
      angular.forEach($scope.selectedTags, function (e) {
        // add if not exist in sysCategories
        var current = $rootScope.findObjectByKey(
          $scope.viewmodel.sysTags,
          "id",
          e.id
        );
        if (!current) {
          $scope.viewmodel.sysCategories.push({
            id: e.id,
            parentId: $scope.viewmodel.id,
            mixDatabaseName: "sys_tag",
          });
        }
      });
    };
    $scope.removeAliasCallback = async function (index) {
      $scope.viewmodel.urlAliases.splice(index, 1);
      $scope.$apply();
    };
  },
]);

"use strict";
app.factory("PageRestService", [
  "$rootScope",
  "ApiService",
  "CommonService",
  "BaseRestService",
  function ($rootScope, apiService, commonService, baseService) {
    var serviceFactory = Object.create(baseService);
    serviceFactory.init("page/portal");
    var _updateInfos = async function (pages) {
      var req = {
        method: "POST",
        url: this.prefixUrl + "/update-infos",
        data: JSON.stringify(pages),
      };
      return await apiService.getApiResult(req);
    };
    serviceFactory.updateInfos = _updateInfos;
    return serviceFactory;
  },
]);

"use strict";
app.controller("OrderController", [
  "$scope",
  "$rootScope",
  "ngAppSettings",
  "$routeParams",
  "$timeout",
  "$location",
  "AuthService",
  "OrderServices",
  "ngAppSettings",
  function (
    $scope,
    $rootScope,
    ngAppSettings,
    $routeParams,
    $timeout,
    $location,
    authService,
    orderServices
  ) {
    $scope.request = angular.copy(ngAppSettings.request);
    $scope.request.contentStatuses = [
      "Waiting",
      "Serving",
      "Rated",
      "Finished",
    ];
    $scope.request.status = "2";
    $scope.activedOrder = null;
    $scope.relatedOrders = [];
    $rootScope.isBusy = false;
    $scope.data = {
      pageIndex: 0,
      pageSize: 1,
      totalItems: 0,
      items: [],
    };
    $scope.errors = [];

    $scope.range = function (max) {
      var input = [];
      for (var i = 1; i <= max; i += 1) input.push(i);
      return input;
    };

    $scope.loadOrder = async function () {
      $rootScope.isBusy = true;
      var id = $routeParams.id;
      var response = await orderServices.getOrder(id, "portal");
      if (response.isSucceed) {
        $scope.activedOrder = response.data;
        $rootScope.initEditor();
        $rootScope.isBusy = false;
        $scope.$apply();
      } else {
        $rootScope.showErrors(response.errors);
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };
    $scope.loadOrders = async function (pageIndex) {
      if (pageIndex !== undefined) {
        $scope.request.pageIndex = pageIndex;
      }
      if ($scope.request.fromDate !== null) {
        var d = new Date($scope.request.fromDate);
        $scope.request.fromDate = d.toISOString();
      }
      if ($scope.request.toDate !== null) {
        var d = new Date($scope.request.toDate);
        $scope.request.toDate = d.toISOString();
      }
      $rootScope.isBusy = true;
      var resp = await orderServices.getOrders($scope.request);
      if (resp && resp.isSucceed) {
        $scope.data = resp.data;
        //$("html, body").animate({ "scrollTop": "0px" }, 500);
        $.each($scope.data.items, function (i, order) {
          $.each($scope.activedOrders, function (i, e) {
            if (e.orderId === order.id) {
              order.isHidden = true;
            }
          });
        });
        $rootScope.isBusy = false;
        $scope.$apply();
      } else {
        if (resp) {
          $rootScope.showErrors(resp.errors);
        }
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };

    $scope.removeOrder = function (id) {
      $rootScope.showConfirm(
        $scope,
        "removeOrderConfirmed",
        [id],
        null,
        "Remove Order",
        "Deleted data will not able to recover, are you sure you want to delete this item?"
      );
    };

    $scope.removeOrderConfirmed = async function (id) {
      $rootScope.isBusy = true;
      var result = await orderServices.removeOrder(id);
      if (result.isSucceed) {
        $scope.loadOrders();
      } else {
        $rootScope.showMessage("failed");
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };

    $scope.saveOrder = async function (order) {
      order.content = $(".editor-content.content").val();
      order.excerpt = $(".editor-content.excerpt").val();
      $rootScope.isBusy = true;
      var resp = await orderServices.saveOrder(order);
      if (resp && resp.isSucceed) {
        $scope.activedOrder = resp.data;
        $rootScope.showMessage("Update successfully!", "success");
        $rootScope.isBusy = false;
        $scope.$apply();
        //$location.path('/portal/order/details/' + resp.data.id);
      } else {
        if (resp) {
          $rootScope.showErrors(resp.errors);
        }
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };

    $scope.preview = function (item) {
      $rootScope.preview("order", item, item.title, "modal-lg");
    };
  },
]);

"use strict";
app.factory("OrderServices", [
  "$http",
  "$rootScope",
  "ApiService",
  "CommonService",
  function ($http, $rootScope, apiService, commonService) {
    //var serviceBase = 'http://ngauthenticationapi.azurewebsites.net/';

    var ordersServiceFactory = {};

    var settings = $rootScope.globalSettings;

    var _getOrder = async function (id, type) {
      var apiUrl = "/" + settings.lang + "/order/";
      var url = apiUrl + "details/" + type;
      if (id) {
        url += "/" + id;
      }
      var req = {
        method: "GET",
        url: url,
      };
      return await apiService.getApiResult(req);
    };

    var _initOrder = async function (type) {
      var apiUrl = "/" + settings.lang + "/order/";
      var req = {
        method: "GET",
        url: apiUrl + "init/" + type,
      };
      return await apiService.getApiResult(req);
    };

    var _getOrders = async function (request) {
      var apiUrl = "/" + settings.lang + "/order/";
      var req = {
        method: "POST",
        url: apiUrl + "list",
        data: JSON.stringify(request),
      };

      return await apiService.getApiResult(req);
    };

    var _removeOrder = async function (id) {
      var apiUrl = "/" + settings.lang + "/order/";
      var req = {
        method: "GET",
        url: apiUrl + "delete/" + id,
      };
      return await apiService.getApiResult(req);
    };

    var _saveOrder = async function (order) {
      var apiUrl = "/" + settings.lang + "/order/";
      var req = {
        method: "POST",
        url: apiUrl + "save",
        data: JSON.stringify(order),
      };
      return await apiService.getApiResult(req);
    };

    ordersServiceFactory.getOrder = _getOrder;
    ordersServiceFactory.initOrder = _initOrder;
    ordersServiceFactory.getOrders = _getOrders;
    ordersServiceFactory.removeOrder = _removeOrder;
    ordersServiceFactory.saveOrder = _saveOrder;
    return ordersServiceFactory;
  },
]);

"use strict";
app.controller("PageGalleryController", [
  "$scope",
  "$rootScope",
  "ngAppSettings",
  "$routeParams",
  "$location",
  "PageGalleryService",
  "PostRestService",
  "ApiService",
  "CommonService",
  function (
    $scope,
    $rootScope,
    ngAppSettings,
    $routeParams,
    $location,
    service,
    postService,
    apiService,
    commonService
  ) {
    BaseCtrl.call(
      this,
      $scope,
      $rootScope,
      $routeParams,
      ngAppSettings,
      service
    );
    $scope.cates = ["Site", "System"];
    $scope.others = [];
    $scope.localizeSettings = $rootScope.globalSettings;
    $scope.pageId = $routeParams.id;
    $scope.canDrag =
      $scope.request.orderBy !== "Priority" || $scope.request.direction !== "0";
    $scope.getList = async function () {
      $rootScope.isBusy = true;
      var id = $routeParams.id;
      $scope.request.query = "&page_id=" + id;
      var response = await service.getList($scope.request);
      $scope.canDrag =
        $scope.request.orderBy !== "Priority" ||
        $scope.request.direction !== "0";
      if (response.isSucceed) {
        $scope.data = response.data;
        $rootScope.isBusy = false;
        $scope.$apply();
      } else {
        $rootScope.showErrors(response.errors);
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };
    $scope.remove = function (pageId, postId) {
      $rootScope.showConfirm(
        $scope,
        "removeConfirmed",
        [pageId, postId],
        null,
        "Remove",
        "Deleted data will not able to recover, are you sure you want to delete this item?"
      );
    };

    $scope.removeConfirmed = async function (pageId, postId) {
      $rootScope.isBusy = true;
      var result = await service.delete(pageId, postId);
      if (result.isSucceed) {
        if ($scope.removeCallback) {
          $rootScope.executeFunctionByName(
            "removeCallback",
            $scope.removeCallbackArgs,
            $scope
          );
        }
        $scope.getList();
      } else {
        $rootScope.showMessage("failed");
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };

    $scope.saveOthers = async function () {
      var response = await service.saveList($scope.others);
      if (response.isSucceed) {
        $scope.getList();
        $scope.$apply();
      } else {
        $rootScope.showErrors(response.errors);
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };
    $scope.updateInfos = async function (index) {
      $scope.data.items.splice(index, 1);
      $rootScope.isBusy = true;
      var startIndex = $scope.data.items[0].priority - 1;
      for (var i = 0; i < $scope.data.items.length; i++) {
        $scope.data.items[i].priority = startIndex + i + 1;
      }
      var resp = await service.updateInfos($scope.data.items);
      if (resp && resp.isSucceed) {
        $scope.activedPage = resp.data;
        $rootScope.showMessage("success", "success");
        $rootScope.isBusy = false;
        $scope.$apply();
      } else {
        if (resp) {
          $rootScope.showErrors(resp.errors);
        }
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };
  },
]);

"use strict";
app.factory("PageGalleryService", [
  "$rootScope",
  "ApiService",
  "CommonService",
  "BaseService",
  function ($rootScope, apiService, commonService, baseService) {
    var serviceFactory = Object.create(baseService);
    serviceFactory.init("page-post");
    var _delete = async function (pageId, postId) {
      var url = this.prefixUrl + "/delete/" + pageId + "/" + postId;
      var req = {
        method: "GET",
        url: url,
      };
      return await apiService.getApiResult(req);
    };
    var _updateInfos = async function (pages) {
      var req = {
        method: "POST",
        url: this.prefixUrl + "/update-infos",
        data: JSON.stringify(pages),
      };
      return await apiService.getApiResult(req);
    };
    serviceFactory.delete = _delete;
    serviceFactory.updateInfos = _updateInfos;
    return serviceFactory;
  },
]);

"use strict";
app.controller("PagePageController", [
  "$scope",
  "$rootScope",
  "ngAppSettings",
  "$routeParams",
  "$location",
  "PagePostRestService",
  "PostRestService",
  "ApiService",
  "CommonService",
  function (
    $scope,
    $rootScope,
    ngAppSettings,
    $routeParams,
    $location,
    service,
    postService,
    apiService,
    commonService
  ) {
    BaseCtrl.call(
      this,
      $scope,
      $rootScope,
      $routeParams,
      ngAppSettings,
      service
    );
    $scope.cates = ["Site", "System"];
    $scope.others = [];
    $scope.localizeSettings = $rootScope.globalSettings;
    $scope.pageId = $routeParams.id;
    $scope.canDrag =
      $scope.request.orderBy !== "Priority" || $scope.request.direction !== "0";
    $scope.getList = async function () {
      $rootScope.isBusy = true;
      var id = $routeParams.id;
      $scope.request.query = "&page_id=" + id;
      var response = await service.getList($scope.request);
      $scope.canDrag =
        $scope.request.orderBy !== "Priority" ||
        $scope.request.direction !== "0";
      if (response.isSucceed) {
        $scope.data = response.data;
        $rootScope.isBusy = false;
        $scope.$apply();
      } else {
        $rootScope.showErrors(response.errors);
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };
    $scope.remove = function (pageId, postId) {
      $rootScope.showConfirm(
        $scope,
        "removeConfirmed",
        [pageId, postId],
        null,
        "Remove",
        "Deleted data will not able to recover, are you sure you want to delete this item?"
      );
    };

    $scope.removeConfirmed = async function (pageId, postId) {
      $rootScope.isBusy = true;
      var result = await service.delete(pageId, postId);
      if (result.isSucceed) {
        if ($scope.removeCallback) {
          $rootScope.executeFunctionByName(
            "removeCallback",
            $scope.removeCallbackArgs,
            $scope
          );
        }
        $scope.getList();
      } else {
        $rootScope.showMessage("failed");
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };

    $scope.saveOthers = async function () {
      var response = await service.saveList($scope.others);
      if (response.isSucceed) {
        $scope.getList();
        $scope.$apply();
      } else {
        $rootScope.showErrors(response.errors);
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };
    $scope.updateInfos = async function (index) {
      $scope.data.items.splice(index, 1);
      $rootScope.isBusy = true;
      var startIndex = $scope.data.items[0].priority - 1;
      for (var i = 0; i < $scope.data.items.length; i++) {
        $scope.data.items[i].priority = startIndex + i + 1;
      }
      var resp = await service.updateInfos($scope.data.items);
      if (resp && resp.isSucceed) {
        $scope.activedPage = resp.data;
        $rootScope.showMessage("success", "success");
        $rootScope.isBusy = false;
        $scope.$apply();
      } else {
        if (resp) {
          $rootScope.showErrors(resp.errors);
        }
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };
  },
]);

"use strict";
app.factory("PagePageRestService", [
  "$rootScope",
  "ApiService",
  "CommonService",
  "BaseService",
  function ($rootScope, apiService, commonService, baseService) {
    var serviceFactory = Object.create(baseService);
    serviceFactory.init("page-page");
    var _delete = async function (pageId, postId) {
      var url = this.prefixUrl + "/delete/" + pageId + "/" + postId;
      var req = {
        method: "GET",
        url: url,
      };
      return await apiService.getApiResult(req);
    };
    var _updateInfos = async function (pages) {
      var req = {
        method: "POST",
        url: this.prefixUrl + "/update-infos",
        data: JSON.stringify(pages),
      };
      return await apiService.getApiResult(req);
    };
    serviceFactory.delete = _delete;
    serviceFactory.updateInfos = _updateInfos;
    return serviceFactory;
  },
]);

"use strict";
app.controller("PagePositionController", [
  "$scope",
  "$rootScope",
  "ngAppSettings",
  "$routeParams",
  "$location",
  "PagePositionService",
  "PostRestService",
  "ApiService",
  "CommonService",
  function (
    $scope,
    $rootScope,
    ngAppSettings,
    $routeParams,
    $location,
    service,
    postService,
    apiService,
    commonService
  ) {
    BaseCtrl.call(
      this,
      $scope,
      $rootScope,
      $routeParams,
      ngAppSettings,
      service
    );
    $scope.cates = ["Site", "System"];
    $scope.others = [];
    $scope.localizeSettings = $rootScope.globalSettings;
    $scope.pageId = $routeParams.id;
    $scope.canDrag =
      $scope.request.orderBy !== "Priority" || $scope.request.direction !== "0";
    $scope.getList = async function () {
      $rootScope.isBusy = true;
      var id = $routeParams.id;
      $scope.request.query = "&page_id=" + id;
      var response = await service.getList($scope.request);
      $scope.canDrag =
        $scope.request.orderBy !== "Priority" ||
        $scope.request.direction !== "0";
      if (response.isSucceed) {
        $scope.data = response.data;
        $rootScope.isBusy = false;
        $scope.$apply();
      } else {
        $rootScope.showErrors(response.errors);
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };
    $scope.preview = function (item) {
      item.editUrl = "/portal/post/details/" + item.id;
      $rootScope.preview("post", item, item.title, "modal-lg");
    };
    $scope.remove = function (pageId, postId) {
      $rootScope.showConfirm(
        $scope,
        "removeConfirmed",
        [pageId, postId],
        null,
        "Remove",
        "Deleted data will not able to recover, are you sure you want to delete this item?"
      );
    };

    $scope.removeConfirmed = async function (pageId, postId) {
      $rootScope.isBusy = true;
      var result = await service.delete(pageId, postId);
      if (result.isSucceed) {
        if ($scope.removeCallback) {
          $rootScope.executeFunctionByName(
            "removeCallback",
            $scope.removeCallbackArgs,
            $scope
          );
        }
        $scope.getList();
      } else {
        $rootScope.showMessage("failed");
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };

    $scope.saveOthers = async function () {
      var response = await service.saveList($scope.others);
      if (response.isSucceed) {
        $scope.getList();
        $scope.$apply();
      } else {
        $rootScope.showErrors(response.errors);
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };
    $scope.updateInfos = async function (index) {
      $scope.data.items.splice(index, 1);
      $rootScope.isBusy = true;
      var startIndex = $scope.data.items[0].priority - 1;
      for (var i = 0; i < $scope.data.items.length; i++) {
        $scope.data.items[i].priority = startIndex + i + 1;
      }
      var resp = await service.updateInfos($scope.data.items);
      if (resp && resp.isSucceed) {
        $scope.activedPage = resp.data;
        $rootScope.showMessage("success", "success");
        $rootScope.isBusy = false;
        $scope.$apply();
      } else {
        if (resp) {
          $rootScope.showErrors(resp.errors);
        }
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };
  },
]);

"use strict";
app.factory("PagePositionService", [
  "$rootScope",
  "ApiService",
  "CommonService",
  "BaseService",
  function ($rootScope, apiService, commonService, baseService) {
    var serviceFactory = Object.create(baseService);
    serviceFactory.init("page-position");
    var _delete = async function (pageId, positionId) {
      var url = this.prefixUrl + "/delete/" + pageId + "/" + positionId;
      var req = {
        method: "GET",
        url: url,
      };
      return await apiService.getApiResult(req);
    };
    var _updateInfos = async function (pages) {
      var req = {
        method: "POST",
        url: this.prefixUrl + "/update-infos",
        data: JSON.stringify(pages),
      };
      return await apiService.getApiResult(req);
    };
    serviceFactory.delete = _delete;
    serviceFactory.updateInfos = _updateInfos;
    return serviceFactory;
  },
]);

"use strict";
app.controller("PagePostController", [
  "$scope",
  "$rootScope",
  "ngAppSettings",
  "$routeParams",
  "$location",
  "PagePostRestService",
  "PostRestService",
  "ApiService",
  "CommonService",
  function (
    $scope,
    $rootScope,
    ngAppSettings,
    $routeParams,
    $location,
    service,
    postService,
    commonService
  ) {
    BaseCtrl.call(
      this,
      $scope,
      $rootScope,
      $routeParams,
      ngAppSettings,
      service
    );
    $scope.cates = ["Site", "System"];
    $scope.others = [];
    $scope.localizeSettings = $rootScope.globalSettings;
    $scope.init = function () {
      $scope.pageId = $routeParams.id;
      $scope.type = $routeParams.type || "";
      $scope.template = $routeParams.template || "";
      $scope.pageIds = $routeParams.page_ids || $routeParams.id || "";
      $scope.moduleIds = $routeParams.module_ids || "";
      $scope.canDrag =
        $scope.request.orderBy === "Priority" &&
        $scope.request.direction === "Asc";
      $scope.createUrl =
        $routeParams.post_type === "gallery"
          ? "/portal/post/create-gallery"
          : `/portal/post/create?page_ids=${$scope.pageIds}&module_ids=${$scope.moduleIds}&type=${$scope.type}&template=${$scope.template}`;
      $scope.updateUrl =
        $routeParams.post_type === "gallery"
          ? "/portal/post/gallery-details"
          : "/portal/post/details";
    };
    $scope.getList = async function (pageIndex) {
      if (pageIndex !== undefined) {
        $scope.request.pageIndex = pageIndex;
      }
      $rootScope.isBusy = true;
      var id = $routeParams.id;
      $scope.request.query = "&page_id=" + id;
      var response = await service.getList($scope.request);
      $scope.canDrag =
        $scope.request.orderBy === "Priority" &&
        $scope.request.direction === "Asc";
      if (response.isSucceed) {
        $scope.data = response.data;
        $rootScope.isBusy = false;
        $scope.$apply();
      } else {
        $rootScope.showErrors(response.errors);
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };
    $scope.preview = function (item) {
      item.editUrl = "/portal/post/details/" + item.id;
      $rootScope.preview("post", item, item.title, "modal-lg");
    };
    $scope.remove = function (pageId, postId) {
      $rootScope.showConfirm(
        $scope,
        "removeConfirmed",
        [pageId, postId],
        null,
        "Remove",
        "Deleted data will not able to recover, are you sure you want to delete this item?"
      );
    };
    $scope.back = function () {
      window.history.back();
    };

    $scope.removeConfirmed = async function (id) {
      $rootScope.isBusy = true;
      var result = await service.delete(id);
      if (result.isSucceed) {
        if ($scope.removeCallback) {
          $rootScope.executeFunctionByName(
            "removeCallback",
            $scope.removeCallbackArgs,
            $scope
          );
        }
        $scope.getList();
      } else {
        $rootScope.showMessage("failed");
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };

    $scope.saveOthers = async function () {
      var response = await service.saveList($scope.others);
      if (response.isSucceed) {
        $scope.getList();
        $scope.$apply();
      } else {
        $rootScope.showErrors(response.errors);
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };
    $scope.updateInfos = async function (index) {
      $scope.data.items.splice(index, 1);
      $rootScope.isBusy = true;
      var startIndex = $scope.data.items[0].priority - 1;
      for (var i = 0; i < $scope.data.items.length; i++) {
        $scope.data.items[i].priority = startIndex + i + 1;
      }
      var resp = await service.updateInfos($scope.data.items);
      if (resp && resp.isSucceed) {
        $scope.activedPage = resp.data;
        $rootScope.showMessage("success", "success");
        $rootScope.isBusy = false;
        $scope.$apply();
      } else {
        if (resp) {
          $rootScope.showErrors(resp.errors);
        }
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };
  },
]);

"use strict";
app.factory("PagePostRestService", [
    "$rootScope",
    "ApiService",
    "CommonService",
    "BaseService",
    function($rootScope, apiService, commonService, baseService) {
        var serviceFactory = Object.create(baseService);
        serviceFactory.init("page-post");
        var _delete = async function(id) {
            var url = this.prefixUrl + "/delete/" + id;
            var req = {
                method: "GET",
                url: url,
            };
            return await apiService.getApiResult(req);
        };
        var _updateInfos = async function(pages) {
            var req = {
                method: "POST",
                url: this.prefixUrl + "/update-infos",
                data: JSON.stringify(pages),
            };
            return await apiService.getApiResult(req);
        };
        serviceFactory.delete = _delete;
        serviceFactory.updateInfos = _updateInfos;
        return serviceFactory;
    },
]);
"use strict";
app.controller("PermissionController", [
  "$scope",
  "$rootScope",
  "ngAppSettings",
  "$routeParams",
  "$location",
  "ApiService",
  "CommonService",
  "PermissionService",
  "RestPortalPageNavigationService",
  function (
    $scope,
    $rootScope,
    ngAppSettings,
    $routeParams,
    $location,
    apiService,
    commonService,
    service,
    navService
  ) {
    BaseRestCtrl.call(
      this,
      $scope,
      $rootScope,
      $location,
      $routeParams,
      ngAppSettings,
      service
    );
    $scope.request.level = 0;
    $scope.miOptions = ngAppSettings.miIcons;
    $scope.initDialog = function () {
      $("#dlg-permission").on("shown.bs.modal", function () {
        $scope.initCurrentPath();
      });
    };

    $scope.initCurrentPath = async function () {
      var resp = await service.getDefault();
      if (resp && resp.isSucceed) {
        $scope.viewmodel = resp.data;
        $scope.viewmodel.url = $location.url();
        $rootScope.isBusy = false;
        $scope.$applyAsync();
      } else {
        if (resp) {
          $rootScope.showErrors(resp.errors);
        }
        if ($scope.getSingleFailCallback) {
          $scope.getSingleFailCallback();
        }
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };
    $scope.saveSuccessCallback = function () {
      $scope.getSingle();
    };

    $scope.dragStart = function (index) {
      $scope.minPriority = $scope.data.items[0].priority;
      $scope.dragStartIndex = index;
    };
    $scope.updateOrders = function (index) {
      if (index > $scope.dragStartIndex) {
        $scope.data.items.splice($scope.dragStartIndex, 1);
      } else {
        $scope.data.items.splice($scope.dragStartIndex + 1, 1);
      }
      angular.forEach($scope.data.items, function (e, i) {
        e.priority = $scope.minPriority + i;
        service.saveFields(e.id, { priority: e.priority }).then((resp) => {
          $rootScope.isBusy = false;
          $scope.$apply();
        });
      });
    };

    $scope.updateChildInfos = async function (items) {
      $rootScope.isBusy = true;
      var resp = await service.updateChildInfos(items);
      if (resp && resp.isSucceed) {
        $scope.activedPage = resp.data;
        $rootScope.showMessage("success", "success");
        $rootScope.isBusy = false;
        $scope.$apply();
      } else {
        if (resp) {
          $rootScope.showErrors(resp.errors);
        }
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };
    $("#dlg-favorite").on("show.bs.modal", function (event) {
      $scope.initCurrentPath();
    });
  },
]);

"use strict";
app.factory("PermissionService", [
  "BaseRestService",
  "ApiService",
  "CommonService",
  function (baseService, apiService, commonService) {
    var serviceFactory = Object.create(baseService);
    serviceFactory.init("permission", true);
    var _updateInfos = async function (pages) {
      var req = {
        method: "POST",
        url: this.prefixUrl + "/update-infos",
        data: JSON.stringify(pages),
      };
      return await apiService.getApiResult(req);
    };

    var _updateChildInfos = async function (pages) {
      var req = {
        method: "POST",
        url: this.prefixUrl + "/update-child-infos",
        data: JSON.stringify(pages),
      };
      return await apiService.getApiResult(req);
    };

    serviceFactory.updateInfos = _updateInfos;
    serviceFactory.updateChildInfos = _updateChildInfos;
    return serviceFactory;
  },
]);

"use strict";
app.factory("RestPortalPageNavigationService", [
  "BaseRestService",
  "ApiService",
  "CommonService",
  function (baseService, apiService, commonService) {
    var serviceFactory = Object.create(baseService);
    serviceFactory.init("portal-page-navigation", true);

    return serviceFactory;
  },
]);

"use strict";
app.controller("PostController", [
  "$scope",
  "$rootScope",
  "$location",
  "$filter",
  "ngAppSettings",
  "$routeParams",
  "PostRestService",
  "UrlAliasService",
  "RestMixDatabaseDataPortalService",
  "RestMixDatabaseColumnPortalService",
  function (
    $scope,
    $rootScope,
    $location,
    $filter,
    ngAppSettings,
    $routeParams,
    service,
    urlAliasService,
    dataService,
    columnService
  ) {
    BaseRestCtrl.call(
      this,
      $scope,
      $rootScope,
      $location,
      $routeParams,
      ngAppSettings,
      service
    );
    $scope.viewmodelType = "post";
    $scope.additionalData = null;
    $scope.createUrl = "/portal/post/create?";
    $scope.selectedCategories = [];
    $scope.selectedTags = [];
    $scope.postType = {
      databaseName: "",
      title: "All",
    };
    $scope.cateRequest = angular.copy(ngAppSettings.request);
    $scope.postTypeRequest = angular.copy(ngAppSettings.request);
    $scope.postTypeRequest.mixDatabaseName = "post_type";
    $scope.postTypeRequest.orderBy = "Priority";
    $scope.postTypeRequest.direction = "Asc";

    $scope.initList = async function () {
      if ($routeParams.template) {
        $scope.createUrl = `${$scope.createUrl}&template=${$routeParams.template}`;
      }
      if ($routeParams.category) {
        $scope.request.category = $routeParams.category;
      }
      if ($routeParams.type) {
        $scope.createUrl = `${$scope.createUrl}&type=${$routeParams.type}`;
        $scope.request.postType = $routeParams.type;
      }
      if ($routeParams.page_ids) {
        $scope.createUrl = `${$scope.createUrl}&page_ids=${$routeParams.page_ids}`;
      }
      $scope.pageName = "postList";
      await $scope.loadPostTypes();
      await $scope.loadCategories();
      $scope.getList();
    };
    $scope.loadCategories = async function () {
      $scope.cateRequest.mixDatabaseName = "sys_category";
      var response = await dataService.getList($scope.cateRequest);
      if (response.isSucceed) {
        $scope.categories = response.data;
        $scope.isBusy = false;
        $scope.$apply();
      }
    };
    $scope.loadPostTypes = async function () {
      let getTypes = await dataService.getList($scope.postTypeRequest);
      if (getTypes.isSucceed) {
        $scope.postTypes = getTypes.data.items.map((m) => m.obj);
        $scope.postTypes.splice(
          0,
          0,
          {
            databaseName: "",
            title: "All",
            id: 0,
          },
          {
            databaseName: "sys_additional_column_post",
            title: "Default",
            id: 1,
          }
        );
        if ($scope.request.postType) {
          $scope.postType = $rootScope.findObjectByKey(
            $scope.postTypes,
            "databaseName",
            $scope.request.postType
          );
        }
        $scope.request.postType = $routeParams.type || "";
        $scope.$apply();
      }
    };
    $scope.getDefault = async function (type = null) {
      $rootScope.isBusy = true;
      type = type || $routeParams.type;
      var resp = await service.getDefault({
        type: type || "",
        template: $routeParams.template || "",
      });
      if (resp.isSucceed) {
        $scope.viewmodel = resp.data;
        if ($scope.getSingleSuccessCallback) {
          $scope.getSingleSuccessCallback();
        }

        // $scope.viewmodel.createdDateTime = Date.now();
        $scope.viewmodel.createdBy = $rootScope.authentication.username;

        $rootScope.isBusy = false;
        $scope.$apply();
      } else {
        if (resp) {
          $rootScope.showErrors(resp.errors);
        }
        if ($scope.getSingleFailCallback) {
          $scope.getSingleFailCallback();
        }
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };
    $scope.preview = function (item) {
      item.editUrl = "/portal/post/details/" + item.id;
      $rootScope.preview("post", item, item.title, "modal-lg");
    };
    $scope.onSelectType = function () {
      if ($scope.viewmodel) {
        $scope.viewmodel.type = $scope.postType.databaseName;
        $scope.loadAdditionalData();
      }
      $scope.request.postType = $scope.postType.databaseName;
      $scope.createUrl = `/portal/post/create?type=${$scope.request.postType}`;
      if ($routeParams.template) {
        $scope.createUrl += `&template=${$routeParams.template}`;
      }
      if (
        $scope.postType.databaseName &&
        (!$scope.viewmodel || !$scope.viewmodel.id)
      ) {
        $scope.getDefault($scope.request.postType);
      }
      if ($scope.pageName == "postList") {
        $scope.getList();
      }
    };
    $scope.getListRelated = async function (pageIndex) {
      if (pageIndex !== undefined) {
        $scope.request.pageIndex = pageIndex;
      }
      if ($scope.request.fromDate !== null) {
        var d = new Date($scope.request.fromDate);
        $scope.request.fromDate = d.toISOString();
      }
      if ($scope.request.toDate !== null) {
        var d = new Date($scope.request.toDate);
        $scope.request.toDate = d.toISOString();
      }
      var resp = await service.getList($scope.request);
      if (resp && resp.isSucceed) {
        let result = [];
        angular.forEach(resp.data.items, (element) => {
          let isActive =
            null !=
            $scope.viewmodel.postNavs.find(
              (p) => p.destinationId == element.id
            );
          if (!isActive) {
            var obj = {
              description: element.title,
              destinationId: element.id,
              image: element.image,
              isActived: isActive,
              sourceId: $scope.viewmodel.id,
              specificulture: $scope.viewmodel.specificulture,
              status: "Published",
            };
            result.push(obj);
          }
        });
        resp.data.items = result;
        $rootScope.isBusy = false;
        $scope.$apply();
        return resp.data;
      } else {
        $rootScope.showErrors(getData.errors);
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };
    $scope.saveFailCallback = function () {
      angular.forEach($scope.viewmodel.mixDatabaseNavs, function (nav) {
        if (nav.isActived) {
          $rootScope.decryptMixDatabase(
            nav.mixDatabase.attributes,
            nav.mixDatabase.postData.items
          );
        }
      });
    };
    $scope.saveSuccessCallback = async function () {
      if ($scope.additionalData) {
        $scope.additionalData.isClone = $scope.viewmodel.isClone;
        $scope.additionalData.cultures = $scope.viewmodel.cultures;
        $scope.additionalData.parentId = $scope.viewmodel.id;
        $scope.additionalData.parentType = "Post";
        let result = await dataService.save($scope.additionalData);
        if (!result.isSucceed) {
          $rootScope.showErrors(result.errors);
        } else {
          $scope.additionalData = result.data;
          $scope.saveColumns();
        }
      }
      $rootScope.isBusy = false;
      $scope.$apply();
    };

    $scope.saveColumns = async function () {
      let result = await columnService.saveMany($scope.additionalData.columns);
      if (result.isSucceed) {
        $rootScope.showMessage("success", "success");
      }
    };
    $scope.getSingleSuccessCallback = async function () {
      $scope.defaultThumbnailImgWidth =
        ngAppSettings.localizeSettings.DefaultThumbnailImgWidth;
      $scope.defaultThumbnailImgHeight =
        ngAppSettings.localizeSettings.DefaultThumbnailImgHeight;

      $scope.defaultFeatureImgWidth =
        ngAppSettings.localizeSettings.DefaultFeatureImgWidth;
      $scope.defaultFeatureImgHeight =
        ngAppSettings.localizeSettings.DefaultFeatureImgHeight;

      $scope.request.postType = $scope.viewmodel.type;
      var moduleIds = $routeParams.module_ids;
      var pageIds = $routeParams.page_ids;
      $scope.postType = $rootScope.findObjectByKey(
        $scope.postTypes,
        "databaseName",
        $scope.request.postType
      );
      await $scope.loadCategories();
      $scope.loadAdditionalData();
      if (moduleIds) {
        for (var moduleId of moduleIds.split(",")) {
          var moduleNav = $rootScope.findObjectByKey(
            $scope.viewmodel.modules,
            "moduleId",
            moduleId
          );
          if (moduleNav) {
            moduleNav.isActived = true;
          }
        }
      }
      if (pageIds) {
        for (var pageId of pageIds.split(",")) {
          var pageNav = $rootScope.findObjectByKey(
            $scope.viewmodel.pages,
            "pageId",
            pageId
          );
          if (pageNav) {
            pageNav.isActived = true;
          }
        }
      }
      if ($scope.viewmodel.sysCategories) {
        angular.forEach($scope.viewmodel.sysCategories, function (e) {
          e.attributeData.obj.isActived = true;
          $scope.selectedCategories.push(e.attributeData.obj);
        });
      }

      if ($scope.viewmodel.sysTags) {
        angular.forEach($scope.viewmodel.sysTags, function (e) {
          e.attributeData.obj.isActived = true;
          $scope.selectedCategories.push(e.attributeData.obj);
        });
      }
      if ($routeParams.template) {
        $scope.viewmodel.view = $rootScope.findObjectByKey(
          $scope.viewmodel.templates,
          "fileName",
          $routeParams.template
        );
      }
    };
    $scope.loadAdditionalData = async function () {
      const obj = {
        parentType: "Post",
        parentId: $scope.viewmodel.id,
        databaseName: $scope.viewmodel.type || "",
      };
      const getData = await dataService.getAdditionalData(obj);
      if (getData.isSucceed) {
        $scope.additionalData = getData.data;
        $scope.$apply();
      }
    };
    $scope.generateSeo = function () {
      if ($scope.viewmodel) {
        if (
          $scope.viewmodel.seoName === null ||
          $scope.viewmodel.seoName === ""
        ) {
          $scope.viewmodel.seoName = $rootScope.generateKeyword(
            $scope.viewmodel.title,
            "-"
          );
          if ($scope.viewmodel.seoName.length > 50) {
            $scope.viewmodel.seoName =
              $scope.viewmodel.seoName.substring(0, 80) + "...";
          }
        }
        if (
          $scope.viewmodel.seoTitle === null ||
          $scope.viewmodel.seoTitle === ""
        ) {
          $scope.viewmodel.seoTitle = $scope.viewmodel.title;
        }
        if (
          $scope.viewmodel.seoDescription === null ||
          $scope.viewmodel.seoDescription === ""
        ) {
          $scope.viewmodel.seoDescription = $scope.viewmodel.excerpt;
        }
        if (
          $scope.viewmodel.seoKeywords === null ||
          $scope.viewmodel.seoKeywords === ""
        ) {
          $scope.viewmodel.seoKeywords = $scope.viewmodel.title;
        }
      }
    };
    $scope.addAlias = async function () {
      var getAlias = await urlAliasService.getSingle();
      if (getAlias.isSucceed) {
        $scope.viewmodel.urlAliases.push(getAlias.data);
        $rootScope.isBusy = false;
        $scope.$apply();
      } else {
        $rootScope.showErrors(getAlias.errors);
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };
    $scope.removeAliasCallback = async function (index) {
      $scope.viewmodel.urlAliases.splice(index, 1);
      $scope.$apply();
    };
    $scope.updateSysCategories = function (data) {
      // Loop selected categories
      angular.forEach($scope.selectedCategories, function (e) {
        // add if not exist in sysCategories
        var current = $rootScope.findObjectByKey(
          $scope.viewmodel.sysCategories,
          "id",
          e.id
        );
        if (!current) {
          $scope.viewmodel.sysCategories.push({
            id: e.id,
            parentId: $scope.viewmodel.id,
            mixDatabaseName: "sys_category",
          });
        }
      });
    };
    $scope.updateSysTags = function (data) {
      // Loop selected categories
      angular.forEach($scope.selectedTags, function (e) {
        // add if not exist in sysCategories
        var current = $rootScope.findObjectByKey(
          $scope.viewmodel.sysTags,
          "id",
          e.id
        );
        if (!current) {
          $scope.viewmodel.sysCategories.push({
            id: e.id,
            parentId: $scope.viewmodel.id,
            mixDatabaseName: "sys_tag",
          });
        }
      });
    };
    $scope.validate = function () {
      angular.forEach($scope.viewmodel.mixDatabaseNavs, function (nav) {
        if (nav.isActived) {
          $rootScope.encryptMixDatabase(
            nav.mixDatabase.attributes,
            nav.mixDatabase.postData.items
          );
        }
      });
      return true;
    };
  },
]);

"use strict";
app.factory("PostRestService", [
  "BaseRestService",
  function (baseService) {
    var serviceFactory = Object.create(baseService);
    serviceFactory.init("post/portal");
    // Define more service methods here
    return serviceFactory;
  },
]);

"use strict";
app.controller("RoleController", [
  "$scope",
  "$rootScope",
  "$location",
  "$routeParams",
  "ngAppSettings",
  "RestMixDatabaseDataPortalService",
  "RestMixDatabaseColumnPortalService",
  "RoleService",
  function (
    $scope,
    $rootScope,
    $location,
    $routeParams,
    ngAppSettings,
    dataService,
    columnService,
    service
  ) {
    BaseRestCtrl.call(
      this,
      $scope,
      $rootScope,
      $location,
      $routeParams,
      ngAppSettings,
      service
    );
    $scope.role = { name: "" };
    $scope.initPermissions = async function () {
      let backUrl = "/portal/role/list";
      $scope.createUrl = `/portal/mix-database-data/create?mixDatabaseName=sys_permission&dataId=default&parentId=${$scope.viewmodel.id}&parentType=Role&backUrl=${backUrl}`;
      $scope.updateUrl = "/portal/mix-database-data/details";
    };

    $scope.createRole = async function () {
      $rootScope.isBusy = true;
      var result = await service.createRole($scope.role.name);
      if (result.isSucceed) {
        $scope.role.name = "";
        $scope.getList();
      } else {
        $rootScope.showErrors(result.errors);
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };
  },
]);

"use strict";
app.factory("RoleService", [
  "BaseRestService",
  "ApiService",
  "CommonService",
  function (baseService, apiService, commonService) {
    var serviceFactory = Object.create(baseService);
    serviceFactory.init("role", true);

    var _getPermissions = async function () {
      var req = {
        method: "GET",
        url: this.prefixUrl + "/permissions",
      };
      return await apiService.getApiResult(req);
    };

    var _updatePermission = async function (permission) {
      var req = {
        method: "POST",
        url: this.prefixUrl + "/update-permission",
        data: JSON.stringify(permission),
      };
      return await apiService.getApiResult(req);
    };
    var _createRole = function (name) {
      var req = {
        method: "POST",
        url: this.prefixUrl + "/create",
        data: JSON.stringify(name),
      };

      return apiService.getRestApiResult(req);
    };
    serviceFactory.createRole = _createRole;
    serviceFactory.getPermissions = _getPermissions;
    serviceFactory.updatePermission = _updatePermission;
    return serviceFactory;
  },
]);

"use strict";
app.controller("ServiceController", [
  "$scope",
  "$rootScope",
  "ngAppSettings",
  "$routeParams",
  "$location",
  "RestMixDatabasePortalService",
  "ApiService",
  "CommonService",
  function (
    $scope,
    $rootScope,
    ngAppSettings,
    $routeParams,
    $location,
    service,
    commonService
  ) {
    BaseODataCtrl.call(
      this,
      $scope,
      $rootScope,
      $routeParams,
      ngAppSettings,
      service
    );
    $scope.defaultId = "default";
    $scope.parentId = null;
    $scope.parentType = null;
    $scope.cates = ["Site", "System"];
    $scope.others = [];
    $scope.localizeSettings = $rootScope.globalSettings;
    $scope.canDrag =
      $scope.request.orderBy !== "Priority" || $scope.request.direction !== "0";
    $scope.init = async function () {
      $scope.mixDatabaseId = $routeParams.mixDatabaseId;
      $scope.mixDatabaseName = $routeParams.mixDatabaseName;
      $scope.dataId = $routeParams.dataId;
    };
    $scope.saveSuccessCallback = function () {
      $rootScope.isBusy = false;
      $scope.$apply();
      // if($scope.parentId){
      //     $location.url('/portal/mix-database-data/details?dataId='+ $scope.parentId);
      // }
      // else{
      //     $location.url('/portal/mix-database-data/list?mixDatabaseId='+ $scope.viewmodel.mixDatabaseId);
      // }
    };
    $scope.getList = async function () {
      $rootScope.isBusy = true;
      $scope.mixDatabaseId = $routeParams.mixDatabaseId;
      $scope.mixDatabaseName = $routeParams.mixDatabaseName;
      var type = $routeParams.type;
      var parentId = $routeParams.parentId;
      var response = await service.getList(
        "read",
        $scope.request,
        $scope.mixDatabaseId,
        $scope.mixDatabaseName,
        type,
        parentId
      );
      $scope.canDrag =
        $scope.request.orderBy !== "Priority" ||
        $scope.request.direction !== "0";
      if (response) {
        $scope.data = response;
        $rootScope.isBusy = false;
        $scope.$apply();
      } else {
        $rootScope.showErrors("Failed");
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };
    $scope.getSingle = async function () {
      $rootScope.isBusy = true;
      var id = $routeParams.id || $scope.defaultId;
      $scope.mixDatabaseId = $routeParams.mixDatabaseId;
      $scope.mixDatabaseName = $routeParams.mixDatabaseName;
      var resp = await service.getSingle("portal", [
        id,
        $scope.mixDatabaseId,
        $scope.mixDatabaseName,
      ]);
      if (resp) {
        $scope.viewmodel = resp;
        $scope.viewmodel.parentType = $scope.parentType;
        $scope.viewmodel.parentId = $scope.parentId;
        $rootScope.isBusy = false;
        $scope.$apply();
      } else {
        if (resp) {
          $rootScope.showErrors("Failed");
        }
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };
    $scope.preview = function (item) {
      item.editUrl = "/portal/post/details/" + item.id;
      $rootScope.preview("post", item, item.title, "modal-lg");
    };
    $scope.edit = function (data) {
      $scope.goToPath(
        "/portal/mix-database-data/details?dataId=" +
          data.id +
          "&mixDatabaseId=" +
          $scope.mixDatabaseId
      );
    };
    $scope.remove = function (data) {
      $rootScope.showConfirm(
        $scope,
        "removeConfirmed",
        [data.id],
        null,
        "Remove",
        "Deleted data will not able to recover, are you sure you want to delete this item?"
      );
    };

    $scope.removeConfirmed = async function (dataId) {
      $rootScope.isBusy = true;
      var result = await service.delete([dataId]);
      if (result.isSucceed) {
        if ($scope.removeCallback) {
          $rootScope.executeFunctionByName(
            "removeCallback",
            $scope.removeCallbackArgs,
            $scope
          );
        }
        $scope.getList();
      } else {
        $rootScope.showMessage("failed");
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };

    $scope.saveOthers = async function () {
      var response = await service.saveList($scope.others);
      if (response.isSucceed) {
        $scope.getList();
        $scope.$apply();
      } else {
        $rootScope.showErrors(response.errors);
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };
  },
]);

"use strict";
app.controller("SocialFeedController", [
  "$rootScope",
  "$scope",
  "$http",
  "PostRestService",
  function ($rootScope, $scope, $http, postService) {
    $scope.types = ["Facebook", "Instagram"];
    $scope.isInit = false;
    $scope.defaultPost = null;
    $scope.defaultProperty = {
      name: null,
      dataType: 7,
      value: "",
    };
    $scope.data = [];
    $scope.errors = [];
    $scope.socialSettings = {
      app_id: null,
      page_id: null,
      app_secret: null,
      access_token: "",
      page: [],
      data: [],
      posts: [],
      show_login: true,
      errors: [],
    };
    $scope.init = async function () {
      window.fbAsyncInit = function () {
        FB.init({
          appId: $rootScope.getConfiguration("FacebookAppId"),
          autoLogAppEvents: true,
          xfbml: true,
          version: "v3.2",
        });
      };
      $scope.socialSettings = {
        app_id: $rootScope.localizeSettings.data.FacebookAppId,
        page_id: $rootScope.localizeSettings.data.Facebook_Page_Id,
        app_secret: $rootScope.localizeSettings.data.FacebookAppSecret,
        access_token: $rootScope.localizeSettings.data.FacebookAccessToken,
        show_login: true,
        errors: [],
      };
      if ($scope.socialSettings.access_token) {
        $scope.socialSettings.show_login = false;
        $scope.loadPages();
      }
      postService.getSingle(["portal"]).then((resp) => {
        $scope.defaultPost = resp.data;
      });
    };

    // This function is called when someone finishes with the Login
    // Button.  See the onlogin handler attached to it in the sample
    // code below.
    $scope.login = function () {
      FB.login(
        function (response) {
          // handle the response
          $scope.statusChangeCallback(response);
        },
        {
          scope: "email, manage_pages",
          return_scopes: true,
        }
      );
    };

    $scope.statusChangeCallback = function (response) {
      // The response object is returned with a status column that lets the
      // app know the current login status of the person.
      // Full docs on the response object can be found in the documentation
      // for FB.getLoginStatus().
      if (response.status === "connected") {
        // Logged into your app and Facebook.
        $scope.exchangeToken(response);
        $scope.loadPages();
        //window.location = '/bo/feed?code=' + response.authResponse.accessToken;
      } else {
        $scope.socialSettings.show_login = true;
        $scope.$apply();
        // The person is not logged into your app or we are unable to tell.
      }
    };

    $scope.exchangeToken = function (response) {
      var url =
        "/oauth/access_token?grant_type=fb_exchange_token&client_id=" +
        $scope.socialSettings.app_id +
        "&client_secret=" +
        $scope.socialSettings.app_secret +
        "&fb_exchange_token=" +
        response.authResponse.accessToken;
      FB.api(url, function (response) {
        if (response.access_token) {
          $scope.socialSettings.access_token = response.access_token;
        } else {
          $scope.show_login = true;
          $scope.socialSettings.errors = response;
          $scope.$apply();
        }
      });
    };
    $scope.loadFeeds = function (url) {
      $scope.socialSettings.errors = "";
      $scope.socialSettings.posts = [];
      url =
        url ||
        "/" +
          $scope.socialSettings.page_id +
          "/posts?access_token=" +
          $scope.socialSettings.access_token +
          "&columns=type,name,story,full_picture,created_time,permalink_url,message,description,caption,attachments{media,type,target,subattachments},shares.summary(true).limit(0),likes.summary(true).limit(0),comments.summary(true).limit(0)&limit=10";
      $rootScope.isBusy = true;
      FB.api(url, function (response) {
        if (response.data) {
          $scope.socialSettings.data = response.data;
          angular.forEach(response.data, function (e, i) {
            var post = $scope.parsePost(e);
            $scope.socialSettings.posts.push(post);
          });
          if (response.paging) {
            $scope.socialSettings.nextUrl = response.paging.next;
            $scope.socialSettings.prevUrl = response.paging.previous;
          }
          $rootScope.isBusy = false;
          $scope.$apply();
        } else {
          $scope.socialSettings.show_login = true;
          $rootScope.isBusy = false;
          $scope.socialSettings.errors = response;
          $scope.$apply();
        }
      });
    };
    $scope.loadPages = function () {
      $scope.socialSettings.errors = "";
      var url =
        "/me/accounts?access_token=" +
        $scope.socialSettings.access_token +
        "&columns=id,name";
      FB.api(url, function (response) {
        if (response.data) {
          $scope.socialSettings.pages = response.data;
          $scope.$apply();
        } else {
          $scope.socialSettings.show_login = true;
          $scope.socialSettings.errors = response;
        }
      });
    };
    $scope.setAttr = function (e, attrName, attVal) {
      $(e).attr(attrName, attVal);
    };
    $scope.parsePost = function (post) {
      var post = angular.copy($scope.defaultPost);
      var prop = angular.copy($scope.defaultProperty);
      post.title = "Facebook Id";
      post.name = "facebook_id";
      post.value = post.id;
      post.properties.push(prop);

      post.title = post.name || post.id;
      post.excerpt = post.message;
      post.content = post.description;
      post.source = "Facebook";
      post.image = post.full_picture;
      post.detailsUrl = post.permalink_url;
      var attachments = post.attachments.data[0];

      if (attachments.media) {
        var media = $scope.parseMedia(attachments.media, attachments.type);
        if (media) {
          post.mediaNavs.push({
            media: media,
            specificulture: $rootScope.localizeSettings.lang,
            image: media.fullPath,
          });
        }
      }

      if (attachments.subattachments) {
        var medias = $scope.parseMedias(attachments.subattachments.data);
        angular.forEach(medias, function (e, i) {
          post.mediaNavs.push({
            media: e,
            specificulture: $rootScope.localizeSettings.lang,
            image: e.fullPath,
          });
        });
      }
      return post;
    };
    $scope.parseMedias = function (data) {
      var result = [];
      if (data) {
        angular.forEach(data, function (e, i) {
          var media = $scope.parseMedia(e.media, e.type);
          if (media) {
            result.push(media);
          }
        });
      }
      return result;
    };
    $scope.parseMedia = function (media, type) {
      if (media) {
        var src = "";
        switch (type) {
          case "video_autoplay":
            src = media.source;
            break;
          case "profile_media":
          case "photo":
          default:
            src = media.image.src;
            break;
        }
        try {
          if (src) {
            var index = src.lastIndexOf("/");
            var ext = src.match(/.(?:jpg|gif|png|gif|jpeg|mp4)/)[0];
            // if valid  file
            if (ext) {
              var eIndex = src.indexOf(ext);
              var filename = src.substring(index + 1, eIndex);
              var media = {
                fileName: filename,
                fileFolder: "Facebook",
                extension: ext,
                targetUrl: src,
                fullPath: src,
                fileType: type,
                source: "Facebook",
              };

              return media;
            } else {
              return null;
            }
          } else {
            return null;
          }
        } catch (err) {
          console.log("Cannot parse media", media);
          return null;
        }
      }
    };
    $scope.syncPosts = async function () {
      $rootScope.isBusy = true;
      var resp = await postService.saveList($scope.socialSettings.posts);
      if (resp && resp.isSucceed) {
        $rootScope.showMessage("success", "success");
        $rootScope.isBusy = false;
        $scope.$apply();
      } else {
        if (resp) {
          $rootScope.showErrors(resp.errors);
        }
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };
  },
]);

"use strict";
app.controller("StoreController", [
  "$scope",
  "$rootScope",
  "ngAppSettings",
  "CryptoService",
  "ThemeService",
  "StoreService",
  function (
    $scope,
    $rootScope,
    ngAppSettings,
    cryptoService,
    themeService,
    service
  ) {
  },
]);

"use strict";
app.controller("TemplateController", [
  "$scope",
  "$rootScope",
  "$routeParams",
  "$location",
  "ngAppSettings",
  "AuthService",
  "TemplateService",
  function (
    $scope,
    $rootScope,
    $routeParams,
    $location,
    ngAppSettings,
    authService,
    service
  ) {
    BaseRestCtrl.call(
      this,
      $scope,
      $rootScope,
      $location,
      $routeParams,
      ngAppSettings,
      service
    );
    BaseHub.call(this, $scope);
    $scope.folderTypes = [
      "Masters",
      "Layouts",
      "Pages",
      "Modules",
      "Forms",
      "Edms",
      "Products",
      "Posts",
      "Widgets",
    ];
    $scope.isInitHub = false;
    $scope.room = null;
    $scope.members = [];
    $scope.activedPane = null;
    $scope.canRename = true;
    $scope.user = null;
    $scope.selectPane = function (pane) {
      $scope.activedPane = pane;
    };
    $scope.init = async function () {
      authService.fillAuthData().then(function () {
        $scope.user = {
          username: authService.authentication.info.username,
          avatar: authService.authentication.info.userData.avatar,
        };
        $scope.startConnection("editFileHub", () => {
          let id = $routeParams.id || $rootScope.generateUUID();
          $scope.room = `Template-${id}`;
          $scope.joinRoom();
        });
      });
    };
    $scope.loadFolder = function (d) {
      $location.url(
        "/portal/template/list/" +
          $routeParams.themeId +
          "?folderType=" +
          encodeURIComponent(d)
      );
    };
    $scope.loadParams = async function () {
      $rootScope.isBusy = true;
      $scope.folderType = $routeParams.folderType; // ? $routeParams.folderType : 'Masters';
      $scope.themeId = $routeParams.themeId;
    };
    $scope.getSingle = async function () {
      $rootScope.isBusy = true;
      var id = $routeParams.id;
      $scope.folderType = $routeParams.folderType; // ? $routeParams.folderType : 'Masters';
      var themeId = $routeParams.themeId;
      $scope.listUrl =
        "/portal/template/list/" +
        themeId +
        "?folderType=" +
        encodeURIComponent($scope.folderType);
      if (id) {
        var resp = await service.getSingle([id], {
          folderType: $scope.folderType,
          themeId: themeId,
        });
        if (resp && resp.isSucceed) {
          $scope.viewmodel = resp.data;
          $scope.canRename =
            $scope.viewmodel.id === 0 ||
            $scope.viewmodel.fileName.indexOf("Copy") === 0;
          $rootScope.isBusy = false;
          $scope.$apply();
        } else {
          if (resp) {
            $rootScope.showErrors(resp.errors);
          }
          $rootScope.isBusy = false;
          $scope.$apply();
        }
      } else {
        var resp = await service.getDefault();
        if (resp && resp.isSucceed) {
          resp.data.themeId = themeId;
          resp.data.folderType = $scope.folderType;
          $scope.viewmodel = resp.data;
          $rootScope.isBusy = false;
          $scope.$apply();
        } else {
          if (resp) {
            $rootScope.showErrors(resp.errors);
          }
          $rootScope.isBusy = false;
          $scope.$apply();
        }
      }
    };
    $scope.copy = async function (id) {
      $rootScope.isBusy = true;
      $scope.folderType = $routeParams.folderType; // ? $routeParams.folderType : 'Masters';
      var themeId = $routeParams.themeId;
      $scope.listUrl =
        "/portal/template/list/" +
        themeId +
        "?folderType=" +
        encodeURIComponent($scope.folderType);
      var resp = await service.copy(id);
      if (resp && resp.isSucceed) {
        $location.url(
          `/portal/template/details/${themeId}/${$scope.folderType}/${resp.data.id}`
        );
        $scope.$apply();
      } else {
        if (resp) {
          $rootScope.showErrors(resp.errors);
        }
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };
    $scope.getList = async function (pageIndex, themeId) {
      $scope.request.themeId = themeId || $routeParams.themeId;
      $scope.request.folderType = $routeParams.folderType;
      $scope.request.status = null;
      $scope.folderType = $routeParams.folderType;
      if ($scope.folderType) {
        if (pageIndex !== undefined) {
          $scope.request.pageIndex = pageIndex;
        }
        if ($scope.request.fromDate !== null) {
          var df = new Date($scope.request.fromDate);
          $scope.request.fromDate = df.toISOString();
        }
        if ($scope.request.toDate !== null) {
          var dt = new Date($scope.request.toDate);
          $scope.request.toDate = dt.toISOString();
        }
        var resp = await service.getList($scope.request, [$scope.themeId]);
        if (resp && resp.isSucceed) {
          $scope.data = resp.data;
          $rootScope.isBusy = false;
          $scope.$apply();
        } else {
          if (resp) {
            $rootScope.showErrors(resp.errors);
          }
          $rootScope.isBusy = false;
          $scope.$apply();
        }
      } else {
        $rootScope.isBusy = false;
      }
    };
    $scope.updateTemplateContent = function (content) {
      $scope.viewmodel.content = content;
    };
    $scope.updateStyleContent = function (content) {
      $scope.viewmodel.scripts = content;
    };
    $scope.updateScriptContent = function (content) {
      $scope.viewmodel.styles = content;
    };
    $scope.joinRoom = function () {
      $scope.connection.invoke("JoinRoom", $scope.room, $scope.user);
    };
    $scope.receiveMessage = function (msg) {
      switch (msg.type) {
        case "MemberList":
          $scope.members = msg.data;
          $scope.initMembersData();
          $scope.canEdit = $scope.members.length == 1;
          if (!$scope.canEdit) {
            $scope.errors = [
              "Cannot modify if there is another user opening this template",
            ];
          } else {
            $scope.errors = [];
          }
          $scope.$apply();
          break;

        default:
          break;
      }
      console.log(msg);
    };
    $scope.initMembersData = function () {
      angular.forEach($scope.members, function (e) {
        if (!e.Avatar) {
          e.Avatar = "/mix-app/assets/img/user.png";
        }
      });
    };
  },
]);

"use strict";
app.controller("UrlAliasController", [
  "$scope",
  "$rootScope",
  "ngAppSettings",
  "$routeParams",
  "$location",
  "UrlAliasService",
  "ApiService",
  "CommonService",
  function (
    $scope,
    $rootScope,
    ngAppSettings,
    $routeParams,
    $location,
    service,
    apiService,
    commonService
  ) {
    BaseCtrl.call(
      this,
      $scope,
      $rootScope,
      $routeParams,
      ngAppSettings,
      service
    );
    $scope.cates = ["Site", "System"];
    $scope.others = [];
    $scope.localizeSettings = $rootScope.globalSettings;
    $scope.pageId = $routeParams.id;
    $scope.canDrag =
      $scope.request.orderBy !== "Priority" || $scope.request.direction !== "0";
    $scope.getList = async function () {
      $rootScope.isBusy = true;
      var id = $routeParams.id;
      $scope.request.query = "&page_id=" + id;
      var response = await service.getList($scope.request);
      $scope.canDrag =
        $scope.request.orderBy !== "Priority" ||
        $scope.request.direction !== "0";
      if (response.isSucceed) {
        $scope.data = response.data;
        $rootScope.isBusy = false;
        $scope.$apply();
      } else {
        $rootScope.showErrors(response.errors);
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };
    $scope.remove = function (id) {
      $rootScope.showConfirm(
        $scope,
        "removeConfirmed",
        [id],
        null,
        "Remove",
        "Deleted data will not able to recover, are you sure you want to delete this item?"
      );
    };

    $scope.removeConfirmed = async function (id) {
      $rootScope.isBusy = true;
      var result = await service.delete(id);
      if (result.isSucceed) {
        if ($scope.removeCallback) {
          $rootScope.executeFunctionByName(
            "removeCallback",
            $scope.removeCallbackArgs,
            $scope
          );
        }
        $scope.getList();
      } else {
        $rootScope.showMessage("failed");
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };

    $scope.updateInfos = async function (index) {
      $scope.data.items.splice(index, 1);
      $rootScope.isBusy = true;
      var startIndex = $scope.data.items[0].priority - 1;
      for (var i = 0; i < $scope.data.items.length; i++) {
        $scope.data.items[i].priority = startIndex + i + 1;
      }
      var resp = await service.updateInfos($scope.data.items);
      if (resp && resp.isSucceed) {
        $scope.activedPage = resp.data;
        $rootScope.showMessage("success", "success");
        $rootScope.isBusy = false;
        $scope.$apply();
      } else {
        if (resp) {
          $rootScope.showErrors(resp.errors);
        }
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };
  },
]);

"use strict";
app.factory("UrlAliasService", [
  "$rootScope",
  "ApiService",
  "CommonService",
  "BaseService",
  function ($rootScope, apiService, commonService, baseService) {
    var serviceFactory = Object.create(baseService);
    serviceFactory.init("url-alias");

    var _updateInfos = async function (pages) {
      var req = {
        method: "POST",
        url: this.prefixUrl + "/update-infos",
        data: JSON.stringify(pages),
      };
      return await apiService.getApiResult(req);
    };
    serviceFactory.updateInfos = _updateInfos;
    return serviceFactory;
  },
]);

"use strict";
app.controller("ThemeController", [
  "$scope",
  "$rootScope",
  "ngAppSettings",
  "$routeParams",
  "$location",
  "ThemeService",
  "ApiService",
  "CommonService",
  function (
    $scope,
    $rootScope,
    ngAppSettings,
    $routeParams,
    $location,
    service,
    commonService
  ) {
    BaseRestCtrl.call(
      this,
      $scope,
      $rootScope,
      $location,
      $routeParams,
      ngAppSettings,
      service
    );
    $scope.exportData = null;
    $scope.selectedExport = {
      isIncludeAssets: true,
      isIncludeTemplates: true,
      isIncludeConfigurations: true,
      isIncludePermissions: true,
      pages: [],
      modules: [],
      mixDatabases: [],
    };

    $scope.getSingleSuccessCallback = function () {
      $scope.assets = null;
      $scope.theme = null;
    };
    $scope.save = async function (viewmodel) {
      var form = document.getElementById("form-portal");
      var frm = new FormData();
      var url = service.prefixUrl + "/save";

      $rootScope.isBusy = true;
      // Looping over all files and add it to FormData object
      frm.append("assets", form["assets"].files[0]);
      frm.append("theme", form["theme"].files[0]);
      // Adding one more key to FormData object
      frm.append("model", angular.toJson(viewmodel || $scope.viewmodel));

      var response = await service.ajaxSubmitForm(frm, url);
      if (response.isSucceed) {
        $scope.viewmodel = response.data;
        $rootScope.isBusy = false;
        $location.url($scope.referrerUrl);
        $scope.$apply();
      } else {
        $rootScope.showErrors(response.errors);
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };
    $scope.syncTemplates = async function (id) {
      $rootScope.isBusy = true;
      var response = await service.syncTemplates(id);
      if (response.isSucceed) {
        $scope.viewmodel = response.data;
        $rootScope.isBusy = false;
        $scope.$apply();
      } else {
        $rootScope.showErrors(response.errors);
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };

    $scope.export = async function () {
      var id = $routeParams.id;
      $rootScope.isBusy = true;
      var response = await service.export(id, $scope.selectedExport);
      if (response.isSucceed) {
        $rootScope.isBusy = false;
        window.open(response.data, "_blank");
        $scope.$apply();
      } else {
        $rootScope.showErrors(response.errors);
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };
    $scope.saveSuccessCallback = function () {
      commonService.initAllSettings().then(function () {
        $location.path("/portal/theme/list");
        $rootScope.isBusy = false;
        $scope.$apply();
      });
    };
    $scope.removeCallback = function () {
      commonService.initAllSettings().then(function () {
        $location.path("/portal/theme/list");
      });
    };

    $scope.getExportData = async function () {
      var id = $routeParams.id;
      var resp = await service.getExportData(id);
      if (resp && resp.isSucceed) {
        $scope.exportData = resp.data;
        $rootScope.isBusy = false;
        $scope.$apply();
      } else {
        if (resp) {
          $rootScope.showErrors(resp.errors);
        }
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };

    $scope.generateSEO = function () {
      $scope.viewmodel.name = $rootScope.generateKeyword(
        $scope.viewmodel.title,
        "-"
      );
    };
  },
]);

"use strict";
app.controller("UserController", [
  "$scope",
  "$rootScope",
  "ngAppSettings",
  "$routeParams",
  "$timeout",
  "$location",
  "AuthService",
  "UserServices",
  "RestMixDatabaseDataPortalService",
  function (
    $scope,
    $rootScope,
    ngAppSettings,
    $routeParams,
    $timeout,
    $location,
    authService,
    userServices,
    dataService
  ) {
    $scope.request = {
      pageSize: "10",
      pageIndex: 0,
      status: "Published",
      orderBy: "CreatedDateTime",
      direction: "Desc",
      fromDate: null,
      toDate: null,
      keyword: "",
    };

    $scope.mediaFile = {
      file: null,
      fullPath: "",
      folder: "User",
      title: "",
      description: "",
    };
    $scope.activedUser = null;
    $scope.relatedUsers = [];
    $rootScope.isBusy = false;
    $scope.data = {
      pageIndex: 0,
      pageSize: 1,
      totalItems: 0,
    };
    $scope.errors = [];

    $scope.range = function (max) {
      var input = [];
      for (var i = 1; i <= max; i += 1) input.push(i);
      return input;
    };

    $scope.loadUser = async function () {
      $rootScope.isBusy = true;
      var id = $routeParams.id;
      var response = await userServices.getUser(id, "portal");
      if (response.isSucceed) {
        $scope.activedUser = response.data;
        $rootScope.isBusy = false;
        if (!$rootScope.isInRole("SuperAdmin")) {
          $scope.activedUser.userRoles = $scope.activedUser.userRoles.filter(
            (role) => role.description != "SuperAdmin"
          );
        }
        $scope.$apply();
      } else {
        $rootScope.showErrors(response.errors);
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };

    $scope.loadMyProfile = async function () {
      $rootScope.isBusy = true;
      var response = await userServices.getMyProfile();
      if (response.isSucceed) {
        $scope.activedUser = response.data;
        $rootScope.isBusy = false;
        $scope.$apply();
      } else {
        $rootScope.showErrors(response.errors);
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };

    $scope.loadUsers = async function (pageIndex) {
      authService.fillAuthData().then(() => {
        if ($rootScope.isInRoles(["SuperAdmin", "Admin"])) {
          $scope.createUrl = "/portal/user/create";
        }
      });

      if (pageIndex !== undefined) {
        $scope.request.pageIndex = pageIndex;
      }
      $rootScope.isBusy = true;
      var resp = await userServices.getUsers($scope.request);
      if (resp && resp.isSucceed) {
        $scope.data = resp.data;
        if (!$rootScope.isInRole("SuperAdmin")) {
          $scope.data.items = $scope.data.items.filter(
            (user) =>
              user.userRoles.length == 0 ||
              user.userRoles[0].role.name != "SuperAdmin"
          );
        }
        $.each($scope.data.items, function (i, user) {
          $.each($scope.data, function (i, e) {
            if (e.userId === user.id) {
              user.isHidden = true;
            }
          });
        });
        $rootScope.isBusy = false;
        $scope.$apply();
      } else {
        if (resp) {
          $rootScope.showErrors(resp.errors);
        }
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };

    $scope.removeUser = function (id) {
      $rootScope.showConfirm(
        $scope,
        "removeUserConfirmed",
        [id],
        null,
        "Remove User",
        "Deleted data will not able to recover, are you sure you want to delete this item?"
      );
    };

    $scope.removeUserConfirmed = async function (id) {
      $rootScope.isBusy = true;
      var result = await userServices.removeUser(id);
      if (result.isSucceed) {
        $scope.loadUsers();
      } else {
        $rootScope.showMessage("failed");
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };

    $scope.save = async function () {
      //if (user.avatar !== user.avatarUrl) {
      //    user.avatar = user.avatarUrl;
      //}
      $rootScope.isBusy = true;
      var resp = await userServices.saveUser($scope.activedUser);
      if (resp && resp.isSucceed) {
        $rootScope.showMessage("Update successfully!", "success");
        if ($scope.activedUser.user.id == authService.authentication.info.id) {
          authService
            .refreshToken(
              authService.authentication.refresh_token,
              authService.authentication.access_token
            )
            .then(() => {
              window.location = window.location;
            });
        }
        $rootScope.isBusy = false;
        $scope.$apply();
      } else {
        if (resp) {
          $rootScope.showErrors(resp.errors);
        }
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };

    $scope.saveUserData = async function () {
      if ($scope.activedUser.userData) {
        $scope.activedUser.userData.parentId = $scope.activedUser.id;
        $scope.activedUser.userData.parentType = "User";
        await dataService.save($scope.activedUser.userData);
      }
    };

    $scope.register = async function (user) {
      $rootScope.isBusy = true;
      var resp = await userServices.register(user);
      if (resp && resp.isSucceed) {
        $scope.activedUser = resp.data;
        $rootScope.showMessage("Update successfully!", "success");
        $rootScope.isBusy = false;
        $scope.$apply();
      } else {
        if (resp) {
          $rootScope.showErrors(resp.errors);
        }
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };

    $scope.updateRoleStatus = async function (nav) {
      var userRole = {
        userId: nav.userId,
        roleId: nav.roleId,
        roleName: nav.description,
        isUserInRole: nav.isActived,
      };
      $rootScope.isBusy = true;
      var resp = await userServices.updateRoleStatus(userRole);
      if (resp && resp.isSucceed) {
        $rootScope.showMessage("Update successfully!", "success");
        $rootScope.isBusy = false;
        $scope.$apply();
      } else {
        if (resp) {
          $rootScope.showErrors(resp.errors);
        }
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };
  },
]);

"use strict";
app.factory("UserServices", [
  "ApiService",
  "ngAppSettings",
  function (apiService, ngAuthSettings) {
    var usersServiceFactory = {};
    var apiUrl = "/account/";

    var serviceBase = ngAuthSettings.serviceBase;

    var _getUserDemographicInfo = function () {
      var url = "/GetUserDemographicInfo";
      var req = {
        method: "GET",
        url: serviceBase + url,
      };

      return apiService.getApiResult(req);
    };

    var _importUsers = function (strBase64) {
      var url = "import-users";
      var req = {
        method: "POST",
        url: apiUrl + url,
        data: JSON.stringify({ strBase64: strBase64 }),
      };

      return apiService.getApiResult(req);
    };

    var _getUsers = function (request) {
      var req = {
        method: "POST",
        url: apiUrl + "list",
        data: request,
      };

      return apiService.getApiResult(req);
    };

    var _getUser = async function (id, viewType) {
      var apiUrl = "/account/";
      var url = apiUrl + "details/" + viewType;
      if (id) {
        url += "/" + id;
      }
      var req = {
        method: "GET",
        url: url,
      };
      return await apiService.getApiResult(req);
    };

    var _getMyProfile = async function () {
      var apiUrl = "/account/";
      var url = apiUrl + "my-profile";
      var req = {
        method: "GET",
        url: url,
      };
      return await apiService.getApiResult(req);
    };

    var _updateRoleStatus = function (userInRole) {
      var req = {
        method: "POST",
        url: serviceBase + "/account/user-in-role",
        data: JSON.stringify(userInRole),
      };

      return apiService.getApiResult(req);
    };

    var _saveUser = async function (user) {
      var apiUrl = "/account/";
      var req = {
        method: "POST",
        url: apiUrl + "save",
        data: JSON.stringify(user),
      };
      return await apiService.getApiResult(req);
    };

    var _register = async function (user) {
      var apiUrl = "/account/";
      var req = {
        method: "POST",
        url: apiUrl + "register",
        data: JSON.stringify(user),
      };
      return await apiService.getApiResult(req);
    };

    var _removeUser = function (userId) {
      var req = {
        method: "GET",
        url: apiUrl + "remove-user/" + userId,
      };

      return apiService.getApiResult(req);
    };

    usersServiceFactory.importUsers = _importUsers;
    usersServiceFactory.getUsers = _getUsers;
    usersServiceFactory.getUser = _getUser;
    usersServiceFactory.getMyProfile = _getMyProfile;
    usersServiceFactory.saveUser = _saveUser;
    usersServiceFactory.register = _register;
    usersServiceFactory.removeUser = _removeUser;
    usersServiceFactory.updateRoleStatus = _updateRoleStatus;
    usersServiceFactory.getUserDemographicInfo = _getUserDemographicInfo;
    return usersServiceFactory;
  },
]);

"use strict";
function PageDetailsController($scope, $element, $attrs) {
  var ctrl = this;
  ctrl.activedPage = null;
  ctrl.relatedPages = [];
  ctrl.data = [];
  ctrl.errors = [];
  ctrl.range = function (max) {
    var input = [];
    for (var i = 1; i <= max; i += 1) input.push(i);
    return input;
  };
  ctrl.loadPage = function (pageId) {
    ctrl.isBusy = true;
    var url = "/" + ctrl.currentLanguage + "/page/details/be/" + pageId; //byPage/' + pageId;
    ctrl.localizeSettings.method = "GET";
    ctrl.localizeSettings.url = url; // + '/true';
    ctrl.localizeSettings.data = ctrl.request;
    $.ajax(ctrl.localizeSettings).done(function (response) {
      if (response.isSucceed) {
        ctrl.activedPage = response.data;
        ctrl.initEditor();
      }
      ctrl.isBusy = false;
      ctrl.$apply();
    });
  };
  ctrl.loadPages = function (pageIndex) {
    ctrl.isBusy = true;
    if (pageIndex !== undefined) {
      ctrl.request.pageIndex = pageIndex;
    }
    if (ctrl.request.fromDate !== null) {
      ctrl.request.fromDate = ctrl.request.fromDate.toISOString();
    }
    if (ctrl.request.toDate !== null) {
      ctrl.request.toDate = ctrl.request.toDate.toISOString();
    }
    var url = "/" + ctrl.currentLanguage + "/page/list"; //byPage/' + pageId;
    ctrl.localizeSettings.method = "POST";
    ctrl.localizeSettings.url = url; // + '/true';
    ctrl.localizeSettings.data = ctrl.request;
    $.ajax(ctrl.localizeSettings).done(function (response) {
      ctrl.data = response.data;

      $.each(ctrl.data.items, function (i, page) {
        $.each(ctrl.activedPages, function (i, e) {
          if (e.pageId === page.id) {
            page.isHidden = true;
          }
        });
      });
      ctrl.isBusy = false;
      setTimeout(function () {
        $('[data-bs-toggle="popover"]').popover({
          html: true,
          content: function () {
            var content = $(this).next(".popover-body");
            return $(content).html();
          },
          title: function () {
            var title = $(this).attr("data-popover-content");
            return $(title).children(".popover-heading").html();
          },
        });
      }, 200);
      ctrl.$apply();
    });
  };

  ctrl.removePage = function (pageId) {
    if (confirm("Are you sure!")) {
      var url = "/" + ctrl.currentLanguage + "/page/delete/" + pageId;
      $.ajax({
        method: "GET",
        url: url,
        success: function (data) {
          ctrl.loadPages();
          ctrl.$apply();
        },
        error: function (a, b, c) {},
      });
    }
  };
  ctrl.savePage = function (page) {
    var url = "/" + ctrl.currentLanguage + "/page/save";
    $.ajax({
      method: "POST",
      url: url,
      data: page,
      success: function (data) {
        //ctrl.loadPages();
        if (data.isSucceed) {
          alert("success");
        } else {
          alert("failed! " + data.errors);
        }
      },
      error: function (a, b, c) {},
    });
  };

  ctrl.changeMedia = function (media) {
    var currentItem = null;
    if (ctrl.activedPage.mediaNavs === undefined) {
      ctrl.activedPage.mediaNavs = [];
    }
    $.each(ctrl.activedPage.mediaNavs, function (i, e) {
      if (e.mediaId === media.id) {
        e.isActived = media.isActived;
        currentItem = e;
        return false;
      }
    });
    if (currentItem === null) {
      currentItem = {
        description: media.description !== "undefined" ? media.description : "",
        image: media.fullPath,
        mediaId: media.id,
        page: ctrl.activedPage.id,
        specificulture: media.specificulture,
        position: 0,
        priority: ctrl.activedMedias.length + 1,
        isActived: true,
      };
      media.isHidden = true;
      ctrl.activedPage.mediaNavs.push(currentItem);
    }
  };

  ctrl.changePage = function (page) {
    var currentItem = null;
    $.each(ctrl.activedPage.pageNavs, function (i, e) {
      if (e.relatedPageId === page.id) {
        e.isActived = page.isActived;
        currentItem = e;
        return false;
      }
    });
    if (currentItem === null) {
      currentItem = {
        relatedPageId: page.id,
        sourcePageId: $("#page-id").val(),
        specificulture: page.specificulture,
        priority: ctrl.activedPage.pageNavs.length + 1,
        page: page,
        isActived: true,
      };
      page.isHidden = true;
      ctrl.activedPage.pageNavs.push(currentItem);
    }
  };

  ctrl.addProperty = function (type) {
    var i = $(".property").length;
    $.ajax({
      method: "GET",
      url:
        "/" +
        ctrl.currentLanguage +
        "/Portal/" +
        type +
        "/AddEmptyProperty/" +
        i,
      success: function (data) {
        $("#tbl-properties > tbody").append(data);
        $(data).find(".prop-data-type").trigger("change");
      },
      error: function (a, b, c) {},
    });
    ctrl.updateHero = function (hero, prop, value) {
      hero[prop] = value;
    };

    ctrl.deleteHero = function (hero) {
      var idx = ctrl.list.indexOf(hero);
      if (idx >= 0) {
        ctrl.list.splice(idx, 1);
      }
    };
  };

  angular.module(appName).component("pageDetails", {
    templateUrl: "pageDetails.html",
    controller: PageDetailsController,
  });
}

app.component("appSettingsAuth", {
  templateUrl:
    "/mix-app/views/app-portal/pages/app-settings/components/auth/view.html",
  controller: [
    "ngAppSettings",
    function (ngAppSettings) {
      var ctrl = this;
    },
  ],
  bindings: {
    appSettings: "=",
    onDelete: "&",
    onUpdate: "&",
  },
});

app.component("appSettingsDefault", {
  templateUrl:
    "/mix-app/views/app-portal/pages/app-settings/components/default/view.html",
  controller: [
    "$rootScope",
    "ngAppSettings",
    function ($rootScope, ngAppSettings) {
      var ctrl = this;
      ctrl.$onInit = function () {
        ctrl.properties = $.parseJSON(
          ctrl.appSettings.GlobalSettings.DefaultPostAttr
        );
        ctrl.trackedProperties = $.parseJSON(
          ctrl.appSettings.GlobalSettings.DefaultPostAttr
        );
        ctrl.dataTypes = $rootScope.globalSettings.dataTypes;
      };
      ctrl.addPostProperty = function () {
        ctrl.properties.push({
          priority: 0,
          name: "",
          value: null,
          dataType: "7",
        });
      };
      ctrl.$doCheck = function () {
        if (ctrl.trackedProperties != ctrl.properties) {
          ctrl.trackedProperties = angular.copy(ctrl.properties);
          ctrl.appSettings.GlobalSettings.DefaultPostAttr = JSON.stringify(
            ctrl.properties
          );
        }
      }.bind(ctrl);
    },
  ],
  bindings: {
    appSettings: "=",
    cultures: "=",
    statuses: "=",
    onDelete: "&",
    onUpdate: "&",
  },
});

app.component("appSettingsGeneral", {
  templateUrl:
    "/mix-app/views/app-portal/pages/app-settings/components/general/view.html",
  controller: [
    "$rootScope",
    "$scope",
    "CommonService",
    function ($rootScope, $scope, commonService) {
      var ctrl = this;
      ctrl.stopApplication = async function () {
        $rootScope.isBusy = true;
        await commonService.stopApplication();
        $rootScope.showMessage("success", "success");
        $rootScope.isBusy = false;
        $scope.$apply();
      };
    },
  ],
  bindings: {
    appSettings: "=",
    onDelete: "&",
    onUpdate: "&",
  },
});

app.component("appSettingsHeart", {
  templateUrl:
    "/mix-app/views/app-portal/pages/app-settings/components/heart/view.html",
  bindings: {
    appSettings: "=",
  },
  controller: [
    "$rootScope",
    "$scope",
    "CommonService",
    "ngAppSettings",
    function ($rootScope, $scope, commonService, ngAppSettings) {
      var ctrl = this;
      ctrl.$onInit = function () {
        ctrl.databaseProviders = ngAppSettings.enums.database_providers;
        ctrl.cacheModes = ngAppSettings.enums.cache_modes;
      };
      ctrl.clearCache = async function () {
        $rootScope.isBusy = true;
        await commonService.clearCache();
        $rootScope.showMessage("success", "success");
        $rootScope.isBusy = false;
        $scope.$apply();
      };
    },
  ],
});

app.component("appSettingsSmtp", {
  templateUrl:
    "/mix-app/views/app-portal/pages/app-settings/components/smtp/view.html",
  controller: [
    "ngAppSettings",
    function (ngAppSettings) {
      var ctrl = this;
    },
  ],
  bindings: {
    appSettings: "=",
  },
});

modules.component("portalMenus", {
  templateUrl:
    "/mix-app/views/app-portal/pages/app-settings/components/portal-menus/view.html",
  bindings: {
    data: "=",
    allowedTypes: "=",
  },
  controller: [
    "$rootScope",
    "$scope",
    "$location",
    "ApiService",
    "CommonService",
    "ngAppSettings",
    function (
      $rootScope,
      $scope,
      $location,
      apiService,
      commonService,
      ngAppSettings
    ) {
      var ctrl = this;
      // ctrl.icons = [];
      ctrl.translate = $rootScope.translate;
      ctrl.init = function () {
        ctrl.icons = ngAppSettings.icons;
      };
    },
  ],
});

app.component("customerMain", {
  templateUrl:
    "/mix-app/views/app-portal/pages/customer/components/main/customer-main.html",
  bindings: {
    customer: "=",
    onDelete: "&",
    onUpdate: "&",
  },
});

app.component("customerOrders", {
  templateUrl:
    "/mix-app/views/app-portal/pages/customer/components/orders/customer-orders.html",
  controller: [
    "$rootScope",
    "OrderServices",
    function ($rootScope, orderServices) {
      var ctrl = this;
      ctrl.removeOrder = function (id) {
        $rootScope.showConfirm(
          ctrl,
          "removeOrderConfirmed",
          [id],
          null,
          "Remove Order",
          "Deleted data will not able to recover, are you sure you want to delete this item?"
        );
      };

      ctrl.removeOrderConfirmed = async function (id) {
        var result = await orderServices.removeOrder(id);
        if (result.isSucceed) {
          $rootScope.showMessage("success", "success");
          window.top.location = window.top.location.href;
        } else {
          $rootScope.showMessage("failed");
          $rootScope.isBusy = false;
          $scope.$apply();
        }
      };
    },
  ],
  bindings: {
    customer: "=",
    onDelete: "&",
    onUpdate: "&",
  },
});

app.component("mixDatabaseEdm", {
  templateUrl:
    "/mix-app/views/app-portal/pages/mix-database/components/edm/view.html",
  controller: [
    "$rootScope",
    function ($rootScope) {
      var ctrl = this;
      ctrl.localizeSettings = $rootScope.globalSettings;
    },
  ],
  bindings: {
    model: "=",
  },
});

app.component("mixDatabaseMain", {
  templateUrl:
    "/mix-app/views/app-portal/pages/mix-database/components/main/view.html",
  controller: [
    "$rootScope",
    function ($rootScope) {
      var ctrl = this;
      ctrl.localizeSettings = $rootScope.globalSettings;
      ctrl.isInRole = $rootScope.isInRole;
      ctrl.gennerateName = function () {
        if (
          !ctrl.model.id ||
          ctrl.model.name === null ||
          ctrl.model.name === ""
        ) {
          ctrl.model.name = $rootScope.generateKeyword(
            ctrl.model.title,
            "_",
            true,
            true
          );
        }
      };
    },
  ],
  bindings: {
    model: "=",
  },
});

app.component("moduleMain", {
  templateUrl:
    "/mix-app/views/app-portal/pages/module/components/main/main.html",
  controller: [
    "$rootScope",
    function ($rootScope) {
      var ctrl = this;
      ctrl.localizeSettings = $rootScope.globalSettings;
      ctrl.isInRole = $rootScope.isInRole;
      ctrl.gennerateName = function () {
        if (
          !ctrl.module.id ||
          ctrl.module.name === null ||
          ctrl.module.name === ""
        ) {
          ctrl.module.name = $rootScope.generateKeyword(ctrl.module.title, "_");
        }
      };
    },
  ],
  bindings: {
    module: "=",
  },
});

app.component("moduleAdvanced", {
  templateUrl:
    "/mix-app/views/app-portal/pages/module/components/module-advanced/view.html",
  bindings: {
    model: "=",
    additionalData: "=",
  },
  controller: [
    "$rootScope",
    function ($rootScope) {
      var ctrl = this;
      ctrl.localizeSettings = $rootScope.globalSettings;
      ctrl.$onInit = function () {
        ctrl.isAdmin = $rootScope.isAdmin;
      };
    },
  ],
});

app.component("moduleContent", {
  templateUrl:
    "/mix-app/views/app-portal/pages/module/components/module-content/view.html",
  bindings: {
    model: "=",
    additionalData: "=",
  },
  controller: [
    "$rootScope",
    function ($rootScope) {
      var ctrl = this;
      ctrl.$onInit = function () {
        ctrl.backUrl = `/portal/module/details`;
      };
      ctrl.localizeSettings = $rootScope.globalSettings;
    },
  ],
});

app.component("pageGeneral", {
  templateUrl:
    "/mix-app/views/app-portal/pages/page/components/general/general.html",
  controller: function ($rootScope) {
    var ctrl = this;
    ctrl.isInRole = $rootScope.isInRole;
    ctrl.dataTypes = [
      {
        title: "String",
        value: "text",
      },
      {
        title: "Int",
        value: "int",
      },
      {
        title: "Image",
        value: "image",
      },
      {
        title: "Boolean",
        value: "boolean",
      },
    ];
    ctrl.configurations = {
      core: {},
      plugins: {
        btnsDef: {
          // Customizables dropdowns
          image: {
            dropdown: ["insertImage", "upload", "base64", "noembed"],
            ico: "insertImage",
          },
        },
        btns: [
          ["viewHTML"],
          ["undo", "redo"],
          ["formatting"],
          ["strong", "em", "del", "underline"],
          ["link"],
          ["image"],
          ["justifyLeft", "justifyCenter", "justifyRight", "justifyFull"],
          ["unorderedList", "orderedList"],
          ["foreColor", "backColor"],
          ["preformatted"],
          ["horizontalRule"],
          ["fullscreen"],
        ],
        plugins: {
          // Add imagur parameters to upload plugin
          upload: {
            serverPath: "https://api.imgur.com/3/image",
            fileFieldName: "image",
            headers: {
              Authorization: "Client-ID 9e57cb1c4791cea",
            },
            urlPropertyName: "data.link",
          },
        },
      },
    };
    ctrl.addProperty = function (type) {
      var i = $(".property").length;
      ctrl.page.properties.push({
        priority: 0,
        name: "",
        value: null,
        dataType: 0,
      });
    };
    ctrl.initEditor = function () {
      setTimeout(function () {
        // Init Code editor
        $.each($(".code-editor"), function (i, e) {
          var container = $(this);
          var editor = ace.edit(e);
          if (container.hasClass("json")) {
            editor.session.setMode("ace/mode/json");
          } else {
            editor.session.setMode("ace/mode/razor");
          }
          editor.setTheme("ace/theme/chrome");
          //editor.setReadOnly(true);

          editor.session.setUseWrapMode(true);
          editor.setOptions({
            maxLines: Infinity,
          });
          editor.getSession().on("change", function (e) {
            // e.type, etc
            $(container).parent().find(".code-content").val(editor.getValue());
          });
        });
        $.each($(".editor-content"), function (i, e) {
          var $demoTextarea = $(e);
          $demoTextarea.quill(ctrl.configurations.plugins);
        });
      }, 200);
    };
  },
  bindings: {
    page: "=",
    onDelete: "&",
    onUpdate: "&",
  },
});

app.component("moduleType", {
  templateUrl:
    "/mix-app/views/app-portal/pages/module/components/module-type/view.html",
  controller: [
    "$rootScope",
    function ($rootScope) {
      var ctrl = this;
      ctrl.localizeSettings = $rootScope.globalSettings;
    },
  ],
  bindings: {
    model: "=",
  },
});

app.component("pageMain", {
  templateUrl: "/mix-app/views/app-portal/pages/page/components/main/main.html",
  controller: [
    "$rootScope",
    "$scope",
    "ngAppSettings",
    function ($rootScope, $scope) {
      var ctrl = this;
      ctrl.localizeSettings = $rootScope.globalSettings;
      // ctrl.setPageType = function (type) {
      //     ctrl.page.type = $index;
      // }
      ctrl.generateSeo = function () {
        if (ctrl.page) {
          if (ctrl.page.seoName === null || ctrl.page.seoName === "") {
            ctrl.page.seoName = $rootScope.generateKeyword(
              ctrl.page.title,
              "-"
            );
          }
          if (ctrl.page.seoTitle === null || ctrl.page.seoTitle === "") {
            ctrl.page.seoTitle = ctrl.page.title;
          }
          if (
            ctrl.page.seoDescription === null ||
            ctrl.page.seoDescription === ""
          ) {
            ctrl.page.seoDescription = ctrl.page.excerpt;
          }
          if (ctrl.page.seoKeywords === null || ctrl.page.seoKeywords === "") {
            ctrl.page.seoKeywords = ctrl.page.title;
          }
        }
      };
    },
  ],
  bindings: {
    page: "=",
    onDelete: "&",
    onUpdate: "&",
  },
});

app.component("pageModules", {
  templateUrl:
    "/mix-app/views/app-portal/pages/page/components/modules/modules.html",
  bindings: {
    page: "=",
    onDelete: "&",
    onUpdate: "&",
  },
});

app.component("pageAdvanced", {
  templateUrl:
    "/mix-app/views/app-portal/pages/page/components/page-advanced/view.html",
  bindings: {
    model: "=",
    additionalData: "=",
  },
  controller: [
    "$rootScope",
    "$scope",
    function ($rootScope, $scope) {
      var ctrl = this;

      ctrl.translate = $rootScope.translate;
      ctrl.$onInit = function () {
        ctrl.isAdmin = $rootScope.isAdmin;
      };
    },
  ],
});

app.component("pageParents", {
  templateUrl:
    "/mix-app/views/app-portal/pages/page/components/parents/parents.html",
  bindings: {
    page: "=",
    onDelete: "&",
    onUpdate: "&",
  },
});

app.component("pageContent", {
  templateUrl:
    "/mix-app/views/app-portal/pages/page/components/page-content/view.html",
  bindings: {
    model: "=",
    additionalData: "=",
  },
  controller: [
    "$rootScope",
    "$scope",
    function ($rootScope, $scope) {
      var ctrl = this;
      ctrl.translate = $rootScope.translate;
      ctrl.$onInit = function () {
        ctrl.backUrl = `/portal/page/details`;
      };
      ctrl.generateSeo = function () {
        if ($scope.viewmodel) {
          if (ctrl.model.seoName === null || ctrl.model.seoName === "") {
            ctrl.model.seoName = $rootScope.generateKeyword(
              ctrl.model.title,
              "-"
            );
          }
          if (ctrl.model.seoTitle === null || ctrl.model.seoTitle === "") {
            ctrl.model.seoTitle = ctrl.model.title;
          }
          if (
            ctrl.model.seoDescription === null ||
            ctrl.model.seoDescription === ""
          ) {
            ctrl.model.seoDescription = ctrl.model.excerpt;
          }
          if (
            ctrl.model.seoKeywords === null ||
            ctrl.model.seoKeywords === ""
          ) {
            ctrl.model.seoKeywords = ctrl.model.title;
          }
        }
      };
    },
  ],
});

app.component("productRelated", {
  templateUrl:
    "/mix-app/views/app-portal/pages/product/components/related/productRelated.html",
  controller: function () {
    var ctrl = this;
    ctrl.activeProduct = function (pr) {
      var currentItem = null;
      $.each(ctrl.product.productNavs, function (i, e) {
        if (e.relatedProductId === pr.id) {
          e.isActived = pr.isActived;
          currentItem = e;
          return false;
        }
      });
      if (currentItem === null) {
        currentItem = {
          relatedProductId: pr.id,
          sourceProductId: ctrl.product.id,
          specificulture: ctrl.product.specificulture,
          priority: ctrl.product.productNavs.length + 1,
          relatedProduct: pr,
          isActived: true,
        };
        pr.isHidden = true;
        ctrl.product.productNavs.push(currentItem);
      }
    };
  },
  bindings: {
    product: "=",
    list: "=",
    onDelete: "&",
    onUpdate: "&",
  },
});

app.component("pageType", {
  templateUrl:
    "/mix-app/views/app-portal/pages/page/components/page-type/view.html",
  bindings: {
    model: "=",
  },
  controller: [
    "$rootScope",
    function ($rootScope) {
      var ctrl = this;
      ctrl.localizeSettings = $rootScope.globalSettings;
    },
  ],
});

app.component("pagePlugPlay", {
  templateUrl:
    "/mix-app/views/app-portal/pages/page/components/plug-play/plug-play.html",
  bindings: {
    page: "=",
    onDelete: "&",
    onUpdate: "&",
  },
});

app.component("permissionMain", {
  templateUrl:
    "/mix-app/views/app-portal/pages/permission/components/main/main.html",
  controller: [
    "$rootScope",
    "$scope",
    "ngAppSettings",
    "$routeParams",
    function ($rootScope, $scope, ngAppSettings, $routeParams) {
      var ctrl = this;
      ctrl.localizeSettings = $rootScope.globalSettings;
      ctrl.icons = ngAppSettings.icons;
      ctrl.setPageType = function (type) {
        ctrl.page.type = $index;
      };
      ctrl.generateKeyword = function (text) {
        if (!$routeParams.id && text) {
          ctrl.page.textKeyword =
            "portal_" +
            text
              .replace(/[^a-zA-Z0-9]+/g, "_")
              .replace(/([A-Z]+)([A-Z][a-z])/g, "$1-$2")
              .replace(/([a-z])([A-Z])/g, "$1-$2")
              .replace(/([0-9])([^0-9])/g, "$1-$2")
              .replace(/([^0-9])([0-9])/g, "$1-$2")
              .replace(/-+/g, "_")
              .toLowerCase();
        }
      };
    },
  ],
  bindings: {
    page: "=",
    onDelete: "&",
    onUpdate: "&",
  },
});

app.component("pageSeo", {
  templateUrl: "/mix-app/views/app-portal/pages/page/components/seo/seo.html",
  controller: [
    "$rootScope",
    function ($rootScope) {
      var ctrl = this;
      ctrl.translate = function (keyword) {
        return $rootScope.translate(keyword);
      };
    },
  ],
  bindings: {
    page: "=",
    onDelete: "&",
    onUpdate: "&",
  },
});

app.component("permissionParents", {
  templateUrl:
    "/mix-app/views/app-portal/pages/permission/components/parents/parents.html",
  bindings: {
    page: "=",
    onDelete: "&",
    onUpdate: "&",
  },
});

modules.component("postFilterList", {
  templateUrl:
    "/mix-app/views/app-portal/pages/post/components/filter-list/filter-list.html",
  bindings: {
    request: "=",
    key: "=?",
    orders: "=?",
    createUrl: "=",
    createText: "=",
    categories: "=",
    postTypes: "=",
    callback: "&",
  },
  controller: [
    "$scope",
    "$rootScope",
    "ngAppSettings",
    "RestMixDatabaseDataPortalService",
    function ($scope, $rootScope, ngAppSettings, dataService) {
      var ctrl = this;
      ctrl.dateRange = {
        fromDate: null,
        toDate: null,
      };
      ctrl.request = angular.copy(ngAppSettings.request);

      ctrl.init = function () {
        if (!ctrl.orders) {
          ctrl.orders = ngAppSettings.orders;
        }
        ctrl.directions = ngAppSettings.directions;
        ctrl.pageSizes = ngAppSettings.pageSizes;
        ctrl.statuses = [];
        var statuses = ngAppSettings.contentStatuses;
        if (ctrl.request && ctrl.request.contentStatuses) {
          statuses = ctrl.request.contentStatuses;
        }
        angular.forEach(statuses, function (val, i) {
          ctrl.statuses.push({
            value: val,
            title: val,
          });
        });
      };

      ctrl.apply = function (pageIndex) {
        $rootScope.setRequest(ctrl.request, ctrl.key);
        ctrl.callback({ pageIndex: pageIndex });
      };
      ctrl.updateDate = function () {
        if (Date.parse(ctrl.dateRange.fromDate)) {
          ctrl.request.fromDate = new Date(
            ctrl.dateRange.fromDate
          ).toISOString();
        } else {
          $scope.request.fromDate = null;
        }
        if (Date.parse(ctrl.dateRange.toDate)) {
          ctrl.request.toDate = new Date(ctrl.dateRange.toDate).toISOString();
        } else {
          ctrl.request.toDate = null;
        }
        $rootScope.setRequest(ctrl.request, ctrl.key);
        ctrl.callback({ pageIndex: 0 });
      };
    },
  ],
});

app.component("permissionPlugPlay", {
  templateUrl:
    "/mix-app/views/app-portal/pages/permission/components/plug-play/plug-play.html",
  bindings: {
    page: "=",
    prefixParent: "=",
    prefixChild: "=",
    searchText: "=",
    onDelete: "&",
    onUpdate: "&",
  },
  controller: [
    "$rootScope",
    "$scope",
    "$location",
    "$element",
    "PermissionService",
    function ($rootScope, $scope, $location, $element, service) {
      var ctrl = this;
      ctrl.type = "Children";
      ctrl.goToPath = $rootScope.goToPath;
      ctrl.request = {
        pageSize: "5",
        pageIndex: 0,
        status: "Published",
        orderBy: "CreatedDateTime",
        direction: "Desc",
        fromDate: null,
        toDate: null,
      };
      ctrl.pages = [];
      ctrl.init = function () {
        if (ctrl.page) {
          ctrl.request.exceptIds = ctrl.page.parentNavs
            .map((p) => p.pageId)
            .concat(ctrl.page.childNavs.map((p) => p.pageId));
          if (ctrl.request.exceptIds.indexOf(ctrl.page.id) === -1) {
            ctrl.request.exceptIds.push(ctrl.page.id);
          }
          ctrl.getList();
        }
      };
      ctrl.selectPane = function (pane) {
        if (ctrl.page) {
          ctrl.type = pane.header;
          ctrl.request.keyword = "";
          ctrl.init();
        }
      };

      ctrl.selectItem = (nav) => {
        if (ctrl.type == "Parents") {
          if (
            !$rootScope.findObjectByKey(ctrl.page.parentNavs, "pageId", nav.id)
          ) {
            ctrl.page.parentNavs.push({
              isActived: true,
              pageId: ctrl.page.id,
              parentId: nav.id,
              description: nav.textDefault,
              status: "Published",
              parent: nav,
            });
          }
        } else {
          if (
            !$rootScope.findObjectByKey(ctrl.page.childNavs, "pageId", nav.id)
          ) {
            ctrl.page.childNavs.push({
              isActived: true,
              pageId: nav.id,
              parentId: ctrl.page.id,
              description: nav.textDefault,
              status: "Published",
              page: nav,
            });
          }
        }
      };

      ctrl.getList = async function () {
        $rootScope.isBusy = true;
        var resp = await service.getList(ctrl.request);
        if (resp && resp.isSucceed) {
          ctrl.pages = resp.data;
          $rootScope.isBusy = false;
          $scope.$apply();
        } else {
          if (resp) {
            $rootScope.showErrors(resp.errors || ["Failed"]);
          }
          $rootScope.isBusy = false;
          $scope.$apply();
        }
      };
    },
  ],
});

app.component("postMedias", {
  templateUrl:
    "/mix-app/views/app-portal/pages/post/components/medias/view.html",
  controller: function () {
    var ctrl = this;
    ctrl.activeMedia = function (media) {
      var currentItem = null;
      if (ctrl.post.mediaNavs === null) {
        ctrl.post.mediaNavs = [];
      }
      $.each(ctrl.post.mediaNavs, function (i, e) {
        if (e.mediaId === media.id) {
          e.isActived = media.isActived;
          currentItem = e;
          return false;
        }
      });
      if (currentItem === null) {
        currentItem = {
          description:
            media.description !== "undefined" ? media.description : "",
          image: media.filePath,
          mediaId: media.id,
          post: ctrl.post.id,
          specificulture: media.specificulture,
          position: 0,
          priority: ctrl.post.mediaNavs.length + 1,
          isActived: true,
        };
        media.isHidden = true;
        ctrl.post.mediaNavs.push(currentItem);
      }
    };
  },
  bindings: {
    post: "=",
    medias: "=",
    loadMedia: "&",
    onDelete: "&",
    onUpdate: "&",
  },
});

app.component("postGeneral", {
  templateUrl:
    "/mix-app/views/app-portal/pages/post/components/general/view.html",
  controller: [
    "$rootScope",
    "ngAppSettings",
    function ($rootScope, ngAppSettings) {
      var ctrl = this;
      ctrl.dataTypes = $rootScope.globalSettings.dataTypes;
      ctrl.$onInit = function () {};
      ctrl.addProperty = function (type) {
        var i = $(".property").length;
        ctrl.post.properties.push({
          title: "",
          name: "",
          value: null,
          dataType: "text",
        });
      };
    },
  ],
  bindings: {
    post: "=",
    isAdmin: "=",
    onDelete: "&",
    onUpdate: "&",
  },
});

app.component("postMain", {
  templateUrl: "/mix-app/views/app-portal/pages/post/components/main/view.html",
  bindings: {
    post: "=",
  },
  controller: [
    "$rootScope",
    "$scope",
    function ($rootScope, $scope) {
      var ctrl = this;
      ctrl.translate = $rootScope.translate;
      ctrl.generateSeo = function () {
        if (ctrl.post) {
          if (!ctrl.post.seoName) {
            ctrl.post.seoName = $rootScope.generateKeyword(
              ctrl.post.title,
              "-"
            );
          }
          if (!ctrl.post.seoTitle) {
            ctrl.post.seoTitle = ctrl.post.title;
          }
          if (!ctrl.post.seoDescription === null) {
            ctrl.post.seoDescription = ctrl.post.excerpt;
          }
          if (!ctrl.post.seoKeywords) {
            ctrl.post.seoKeywords = ctrl.post.title;
          }
        }
      };
    },
  ],
});

app.component("postModules", {
  templateUrl:
    "/mix-app/views/app-portal/pages/post/components/modules/view.html",
  controller: [
    "$rootScope",
    "$scope",
    "ngAppSettings",
    "SharedModuleDataService",
    function ($rootScope, $scope, ngAppSettings, moduleDataService) {
      var ctrl = this;
      ctrl.request = angular.copy(ngAppSettings.request);
      ctrl.translate = function (keyword, wrap, defaultValue) {
        return $rootScope.translate(keyword, wrap, defaultValue);
      };

      ctrl.removeData = function (id, moduleId) {
        $rootScope.showConfirm(
          ctrl,
          "removeDataConfirmed",
          [id, moduleId],
          null,
          "Remove Data",
          "Deleted data will not able to recover, are you sure you want to delete this item?"
        );
      };
      ctrl.removeDataConfirmed = async function (id, moduleId) {
        $rootScope.isBusy = true;
        var result = await moduleDataService.removeModuleData(id);
        if (result.isSucceed) {
          ctrl.loadModuleDatas(moduleId);
        } else {
          $rootScope.showMessage("failed");
          $rootScope.isBusy = false;
          $scope.$apply();
        }
      };
      ctrl.saveDataCallback = function (data) {
        if (data) {
          ctrl.loadModuleDatas(data.moduleId);
        }
      };
      ctrl.loadModuleDatas = async function (id, pageIndex) {
        $rootScope.isBusy = true;
        $scope.dataColumns = [];
        var request = angular.copy(ngAppSettings.request);
        request.query = "?module_id=" + id + "&post_id=" + ctrl.post.id;
        if (pageIndex) {
          request.pageIndex = pageIndex;
        }
        var response = await moduleDataService.getModuleDatas(request);
        if (response.isSucceed) {
          var nav = $rootScope.findObjectByKey(
            ctrl.post.moduleNavs,
            "moduleId",
            id
          );
          if (nav) {
            nav.module.data = response.data;
          }
          $rootScope.isBusy = false;
          $scope.$apply();
        } else {
          $rootScope.showErrors(response.errors);
          $rootScope.isBusy = false;
          $scope.$apply();
        }
      };

      ctrl.updateDataInfos = async function (items) {
        $rootScope.isBusy = true;
        var resp = await moduleDataService.updateInfos(items);
        if (resp && resp.isSucceed) {
          $scope.activedPage = resp.data;
          $rootScope.showMessage("success", "success");
          $rootScope.isBusy = false;
          $scope.$apply();
        } else {
          if (resp) {
            $rootScope.showErrors(resp.errors);
          }
          $rootScope.isBusy = false;
          $scope.$apply();
        }
      };
    },
  ],
  bindings: {
    post: "=",
    onDelete: "&",
    onUpdate: "&",
  },
});

app.component("postParents", {
  templateUrl:
    "/mix-app/views/app-portal/pages/post/components/parents/view.html",
  bindings: {
    post: "=",
    onDelete: "&",
    onUpdate: "&",
  },
});

app.component("postContent", {
  templateUrl:
    "/mix-app/views/app-portal/pages/post/components/post-content/view.html",
  bindings: {
    model: "=",
    additionalData: "=",
  },
  controller: [
    "$rootScope",
    "$scope",
    "ngAppSettings",
    "PostRestService",
    function ($rootScope, $scope, ngAppSettings, service) {
      var ctrl = this;
      ctrl.request = angular.copy(ngAppSettings.request);
      ctrl.translate = $rootScope.translate;
      ctrl.relatedData = {};
      ctrl.$onInit = function () {
        ctrl.backUrl = `/portal/post/details`;
      };
      ctrl.generateSeo = function () {
        if (ctrl.model) {
          if (ctrl.model.seoName === null || ctrl.model.seoName === "") {
            ctrl.model.seoName = $rootScope.generateKeyword(
              ctrl.model.title,
              "-"
            );
          }
          if (ctrl.model.seoTitle === null || ctrl.model.seoTitle === "") {
            ctrl.model.seoTitle = ctrl.model.title;
          }
          if (
            ctrl.model.seoDescription === null ||
            ctrl.model.seoDescription === ""
          ) {
            ctrl.model.seoDescription = ctrl.model.excerpt;
          }
          if (
            ctrl.model.seoKeywords === null ||
            ctrl.model.seoKeywords === ""
          ) {
            ctrl.model.seoKeywords = ctrl.model.title;
          }
        }
      };
      ctrl.getListRelated = async function (pageIndex) {
        if (pageIndex !== undefined) {
          ctrl.request.pageIndex = pageIndex;
        }
        if (ctrl.request.fromDate !== null) {
          var d = new Date(ctrl.request.fromDate);
          ctrl.request.fromDate = d.toISOString();
        }
        if (ctrl.request.toDate !== null) {
          var d = new Date(ctrl.request.toDate);
          ctrl.request.toDate = d.toISOString();
        }
        var resp = await service.getList(ctrl.request);
        if (resp && resp.isSucceed) {
          ctrl.relatedData = angular.copy(resp.data);
          ctrl.relatedData.items = [];
          angular.forEach(resp.data.items, (element) => {
            var existed = $rootScope.findObjectByKey(
              ctrl.model.postNavs,
              ["sourceId", "destinationId"],
              [ctrl.model.id, element.id]
            );

            var obj = {
              description: element.title,
              destinationId: element.id,
              image: element.image,
              isActived: existed !== null,
              sourceId: ctrl.model.id,
              specificulture: ctrl.model.specificulture,
              status: "Published",
            };

            ctrl.relatedData.items.push(obj);
          });
          console.log(ctrl.relatedData);
          $rootScope.isBusy = false;
          $scope.$apply();
        } else {
          $rootScope.showErrors(getData.errors);
          $rootScope.isBusy = false;
          $scope.$apply();
        }
      };
    },
  ],
});

app.component("postAdvanced", {
  templateUrl:
    "/mix-app/views/app-portal/pages/post/components/post-advanced/view.html",
  bindings: {
    model: "=",
    additionalData: "=",
  },
  controller: [
    "$rootScope",
    "$scope",
    function ($rootScope, $scope) {
      var ctrl = this;
      ctrl.translate = $rootScope.translate;
      ctrl.$onInit = function () {
        ctrl.isAdmin = $rootScope.isAdmin;
      };
    },
  ],
});

modules.component("relatedNavs", {
  templateUrl:
    "/mix-app/views/app-portal/pages/post/components/related-navigations/view.html",
  bindings: {
    request: "=",
    prefix: "=",
    sourceId: "=",
    culture: "=",
    navs: "=",
    data: "=",
    categories: "=",
    postTypes: "=",
    loadData: "&",
  },
  controller: [
    "$rootScope",
    "$scope",
    function ($rootScope, $scope) {
      var ctrl = this;
      ctrl.selected = null;
      ctrl.activeItem = function (item, index) {
        var currentItem = $rootScope.findObjectByKey(
          ctrl.navs,
          ["sourceId", "destinationId"],
          [ctrl.sourceId, item.id]
        );
        if (currentItem === null) {
          currentItem = item;
          currentItem.priority = ctrl.navs.length + 1;
          ctrl.navs.push(currentItem);
          ctrl.data.items.splice(index, 1);
        }
      };
      ctrl.updateOrders = function (index) {
        ctrl.navs.splice(index, 1);
        for (var i = 0; i < ctrl.data.length; i++) {
          ctrl.navs[i].priority = i + 1;
        }
      };
      ctrl.load = async function (pageIndex) {
        if (pageIndex !== undefined) {
          ctrl.request.pageIndex = pageIndex;
        }
        ctrl.data = await ctrl.loadData({ pageIndex: ctrl.request.pageIndex });
        $scope.$apply();
      };
      ctrl.checkActived = function (item) {
        if (ctrl.navs) {
          return ctrl.navs.find(function (nav) {
            return nav.destinationId === item.id;
          });
        }
      };
    },
  ],
});

modules.component("rolePageNav", {
  templateUrl:
    "/mix-app/views/app-portal/pages/role/components/role-page-navigation/role-page-navigations.html",
  controller: [
    "$rootScope",
    "$scope",
    "ngAppSettings",
    "RoleService",
    function ($rootScope, $scope, ngAppSettings, roleServices) {
      var ctrl = this;
      ctrl.selected = null;
      ctrl.updateOrders = function (index) {
        ctrl.data.splice(index, 1);
        for (var i = 0; i < ctrl.data.length; i++) {
          ctrl.data[i].priority = i + 1;
        }
      };
      //ctrl.change = async function () {
      //    //var permission = ctrl.page.navPermission;
      //    //$rootScope.isBusy = true;
      //    //var resp = await roleServices.updatePermission(permission);
      //    //if (resp && resp.isSucceed) {
      //    //    $rootScope.showMessage('Update successfully!', 'success');
      //    //    $rootScope.isBusy = false;
      //    //    $scope.$apply();
      //    //}
      //    //else {
      //    //    if (resp) { $rootScope.showErrors(resp.errors); }
      //    //    $rootScope.isBusy = false;
      //    //    $scope.$apply();
      //    //}
      //};
    },
  ],
  bindings: {
    prefix: "=",
    page: "=",
    callback: "&",
  },
});

app.component("themeExportMixDatabases", {
  templateUrl:
    "/mix-app/views/app-portal/pages/theme/components/theme-export-mix-databases/view.html",
  controller: [
    "$rootScope",
    "$scope",
    "ngAppSettings",
    function ($rootScope, $scope) {
      var ctrl = this;
      ctrl.updateMixDatabaseExport = function () {
        ctrl.selectedExport.mixDatabases = angular.copy(
          $rootScope.filterArray(
            ctrl.exportData.mixDatabases,
            ["isActived"],
            [true]
          )
        );
        // angular.forEach(ctrl.selectedExport.mixDatabases,function(e){
        //     e.data = angular.copy($rootScope.filterArray(e.data, ['isActived'], [true]));
        // });
      };
      ctrl.selectAll = function (arr) {
        ctrl.selectedList.data = [];
        angular.forEach(arr, function (e) {
          e.isActived = ctrl.selectedList.isSelectAll;
          e.isExportData = ctrl.selectedList.isExportData;
        });
        ctrl.updateMixDatabaseExport();
      };
    },
  ],
  bindings: {
    exportData: "=",
    selectedExport: "=",
  },
});

app.component("postSeo", {
  templateUrl: "/mix-app/views/app-portal/pages/post/components/seo/view.html",
  bindings: {
    post: "=",
    onDelete: "&",
    onUpdate: "&",
  },
});

app.component("themeExportModules", {
  templateUrl:
    "/mix-app/views/app-portal/pages/theme/components/theme-export-modules/view.html",
  controller: [
    "$rootScope",
    "$scope",
    "ngAppSettings",
    function ($rootScope, $scope) {
      var ctrl = this;
      ctrl.updateModuleExport = function () {
        ctrl.selectedExport.modules = angular.copy(
          $rootScope.filterArray(ctrl.exportData.modules, ["isActived"], [true])
        );
        // angular.forEach(ctrl.selectedExport.modules,function(e){
        //     e.data.items = angular.copy($rootScope.filterArray(e.data.items, ['isActived'], [true]));
        // });
      };
      ctrl.selectAll = function (arr) {
        ctrl.selectedList.data = [];
        angular.forEach(arr, function (e) {
          e.isActived = ctrl.selectedList.isSelectAll;
          e.isExportData = ctrl.selectedList.isExportData;
        });
        ctrl.updateModuleExport();
      };
    },
  ],
  bindings: {
    exportData: "=",
    selectedExport: "=",
  },
});

app.component("serviceMain", {
  templateUrl:
    "/mix-app/views/app-portal/pages/service/components/main/view.html",
  controller: [
    "$rootScope",
    function ($rootScope) {
      var ctrl = this;
      ctrl.localizeSettings = $rootScope.globalSettings;
      ctrl.gennerateName = function () {
        if (
          !ctrl.model.id ||
          ctrl.model.name === null ||
          ctrl.model.name === ""
        ) {
          ctrl.model.name = $rootScope.generateKeyword(ctrl.model.title, "_");
        }
      };
    },
  ],
  bindings: {
    model: "=",
  },
});

app.component("themeExportPages", {
  templateUrl:
    "/mix-app/views/app-portal/pages/theme/components/theme-export-pages/view.html",
  controller: [
    "$rootScope",
    "$scope",
    "ngAppSettings",
    function ($rootScope, $scope) {
      var ctrl = this;
      ctrl.updatePageExport = function (value, isSelected) {
        // Filter actived page
        var idx = (ctrl.selectedExport.pages = angular.copy(
          $rootScope.filterArray(ctrl.exportData.pages, ["isActived"], [true])
        ));

        // // Loop actived page
        // angular.forEach(ctrl.selectedExport.pages, function (e) {
        //     // filter list actived modules
        //     e.moduleNavs = angular.copy($rootScope.filterArray(e.moduleNavs, ['isActived'], [true]));

        //     // Loop actived modules
        //     angular.forEach(e.moduleNavs, function (n) {
        //         // filter list actived data
        //         n.module.data.items = angular.copy($rootScope.filterArray(n.module.data.items, ['isActived'], [true]));
        //         $rootScope.removeObjectByKey(ctrl.exportData.modules, 'id', n.moduleId);
        //         $rootScope.removeObjectByKey(ctrl.selectedExport.modules, 'id', n.moduleId);
        //     });
        // });
      };
      ctrl.isSelected = function (value) {
        return ctrl.selectedValues.indexOf(value) >= 0;
      };
      ctrl.selectAll = function (arr) {
        ctrl.selectedList.data = [];
        angular.forEach(arr, function (e) {
          e.isActived = ctrl.selectedList.isSelectAll;
          e.isExportData = ctrl.selectedList.isExportData;
        });
        ctrl.updatePageExport();
      };
    },
  ],
  bindings: {
    exportData: "=",
    selectedExport: "=",
  },
});

app.component("themeExportPosts", {
  templateUrl:
    "/mix-app/views/app-portal/pages/theme/components/theme-export-posts/view.html",
  controller: [
    "$rootScope",
    "$scope",
    "ngAppSettings",
    function ($rootScope, $scope) {
      var ctrl = this;
      ctrl.updatePostExport = function (value, isSelected) {
        // Filter actived post
        var idx = (ctrl.selectedExport.posts = angular.copy(
          $rootScope.filterArray(ctrl.exportData.posts, ["isActived"], [true])
        ));
      };
      ctrl.isSelected = function (value) {
        return ctrl.selectedValues.indexOf(value) >= 0;
      };
      ctrl.selectAll = function (arr) {
        ctrl.selectedList.data = [];
        angular.forEach(arr, function (e) {
          e.isActived = ctrl.selectedList.isSelectAll;
          e.isExportData = ctrl.selectedList.isExportData;
        });
        ctrl.updatePostExport();
      };
    },
  ],
  bindings: {
    exportData: "=",
    selectedExport: "=",
  },
});

var demo = {
  initDashboardPageCharts: function (incomes, services) {
    incomes = incomes || [
      50,
      150,
      100,
      190,
      130,
      90,
      150,
      160,
      120,
      140,
      190,
      95,
    ];
    chartColor = "#eeeeee";
    // General configuration for the charts with Line gradientStroke
    gradientChartOptionsConfiguration = {
      maintainAspectRatio: false,
      legend: {
        display: false,
      },
      tooltips: {
        bodySpacing: 4,
        mode: "nearest",
        intersect: 0,
        position: "nearest",
        xPadding: 10,
        yPadding: 10,
        caretPadding: 10,
      },
      responsive: 1,
      scales: {
        yAxes: [
          {
            display: 0,

            ticks: {
              display: false,
            },
            gridLines: {
              zeroLineColor: "transparent",
              drawTicks: false,
              display: false,
              drawBorder: false,
            },
          },
        ],
        xAxes: [
          {
            display: 0,

            ticks: {
              display: false,
            },
            gridLines: {
              zeroLineColor: "transparent",
              drawTicks: false,
              display: false,
              drawBorder: false,
            },
          },
        ],
      },
      layout: {
        padding: { left: 0, right: 0, top: 15, bottom: 15 },
      },
    };

    gradientChartOptionsConfigurationWithNumbersAndGrid = {
      maintainAspectRatio: false,
      legend: {
        display: false,
      },
      tooltips: {
        bodySpacing: 4,
        mode: "nearest",
        intersect: 0,
        position: "nearest",
        xPadding: 10,
        yPadding: 10,
        caretPadding: 10,
      },
      responsive: true,
      scales: {
        yAxes: [
          {
            gridLines: {
              zeroLineColor: "transparent",
              drawBorder: false,
            },
          },
        ],
        xAxes: [
          {
            display: 0,

            ticks: {
              display: false,
            },
            gridLines: {
              zeroLineColor: "transparent",
              drawTicks: false,
              display: false,
              drawBorder: false,
            },
          },
        ],
      },
      layout: {
        padding: { left: 0, right: 0, top: 15, bottom: 15 },
      },
    };

    var ctx = document.getElementById("bigDashboardChart").getContext("2d");

    var gradientStroke = ctx.createLinearGradient(500, 0, 100, 0);
    gradientStroke.addColorStop(0, "#80b6f4");
    gradientStroke.addColorStop(1, chartColor);

    var gradientFill = ctx.createLinearGradient(0, 200, 0, 50);
    gradientFill.addColorStop(0, "rgba(128, 182, 244, 0)");
    gradientFill.addColorStop(1, "rgba(255, 255, 255, 0.24)");

    var myChart = new Chart(ctx, {
      type: "bar",
      data: {
        labels: [
          "JAN",
          "FEB",
          "MAR",
          "APR",
          "MAY",
          "JUN",
          "JUL",
          "AUG",
          "SEP",
          "OCT",
          "NOV",
          "DEC",
        ],
        datasets: [
          {
            type: "line",
            label: "Incomes",
            borderColor: chartColor,
            pointBorderColor: chartColor,
            pointBackgroundColor: "red",
            pointHoverBackgroundColor: "#1e3d60",
            pointHoverBorderColor: chartColor,
            pointBorderWidth: 1,
            pointHoverRadius: 7,
            pointHoverBorderWidth: 2,
            pointRadius: 5,
            fill: true,
            backgroundColor: gradientFill,
            borderWidth: 2,
            data: incomes,
          },
          {
            label: "Services",
            //borderColor: chartColor,
            //pointBorderColor: chartColor,
            //pointBackgroundColor: "#1e3d60",
            //pointHoverBackgroundColor: "#1e3d60",
            //pointHoverBorderColor: chartColor,
            //pointBorderWidth: 1,
            //pointHoverRadius: 7,
            //pointHoverBorderWidth: 2,
            //pointRadius: 5,
            //fill: true,
            backgroundColor: "yellow",
            //borderWidth: 2,
            data: services,
          },
        ],
      },
      options: {
        layout: {
          padding: {
            left: 20,
            right: 20,
            top: 0,
            bottom: 0,
          },
        },
        maintainAspectRatio: false,
        tooltips: {
          backgroundColor: "#fff",
          titleFontColor: "#333",
          bodyFontColor: "#666",
          bodySpacing: 4,
          xPadding: 12,
          mode: "nearest",
          intersect: 0,
          position: "nearest",
        },
        legend: {
          position: "bottom",
          fillStyle: "#FFF",
          display: false,
        },
        scales: {
          yAxes: [
            {
              ticks: {
                fontColor: "rgba(255,255,255,0.4)",
                fontStyle: "bold",
                beginAtZero: true,
                maxTicksLimit: 5,
                padding: 10,
              },
              gridLines: {
                drawTicks: true,
                drawBorder: false,
                display: true,
                color: "rgba(255,255,255,0.1)",
                zeroLineColor: "transparent",
              },
            },
          ],
          xAxes: [
            {
              gridLines: {
                zeroLineColor: "transparent",
                display: false,
              },
              ticks: {
                padding: 10,
                fontColor: "rgba(255,255,255,0.4)",
                fontStyle: "bold",
              },
            },
          ],
        },
      },
    });
  },
};

modules.component("aceEditor", {
  templateUrl:
    "/mix-app/views/app-portal/components/ace-editor/ace-editor.html",
  controller: [
    "$rootScope",
    "$scope",
    "ngAppSettings",
    function ($rootScope, $scope, ngAppSettings) {
      var ctrl = this;
      ctrl.previousId = null;
      ctrl.editor = null;
      ctrl.id = Math.floor(Math.random() * 100) + 1;
      ctrl.$onChanges = (changes) => {
        if (changes.content) {
          ctrl.updateEditors();
        }
      };

      this.$doCheck = function () {
        if (ctrl.previousId != null && ctrl.previousId !== ctrl.contentId) {
          ctrl.previousId = ctrl.contentId;
          ctrl.updateEditors();
        }
      }.bind(this);
      ctrl.initAce = function () {
        setTimeout(() => {
          ctrl.previousId = ctrl.contentId;
          ctrl.updateEditors();
          $scope.$apply();
        }, 200);
      };
      ctrl.updateContent = function (content) {
        ctrl.editor.setValue(content);
      };
      ctrl.updateEditors = function () {
        $.each($("#code-editor-" + ctrl.id), function (i, e) {
          //var container = $(this);
          ace.require("ace/ext/language_tools");
          if (e) {
            var editor = ace.edit(e);
            switch (ctrl.ext) {
              case ".json":
                editor.session.setMode("ace/mode/json");
                break;
              case ".js":
                editor.session.setMode("ace/mode/javascript");
                break;
              case ".css":
                editor.session.setMode("ace/mode/css");
                break;
              case ".cshtml":
                editor.session.setMode("ace/mode/razor");
                break;
              case ".cs":
                editor.session.setMode("ace/mode/csharp");
                break;
              default:
                editor.session.setMode("ace/mode/razor");
                break;
            }
            editor.setTheme("ace/theme/chrome");
            //editor.setReadOnly(true);
            if (ctrl.content) {
              editor.setValue(ctrl.content);
            }
            editor.$blockScrolling = Infinity;
            editor.session.setUseWrapMode(true);
            editor.setOptions({
              enableBasicAutocompletion: true,
              enableSnippets: true,
              enableLiveAutocompletion: false,
              maxLines: 50,
              fontSize: 11,
            });
            editor.getSession().on("change", function (e) {
              // e.type, etc
              ctrl.content = editor.getValue();
            });
            editor.getSession().on("paste", function (e) {
              // e.type, etc
              ctrl.content = editor.getValue();
            });
            editor.commands.addCommand({
              name: "saveFile",
              bindKey: {
                win: "Ctrl-S",
                mac: "Command-S",
                sender: "editor|cli",
              },
              exec: function (env, args, request) {
                var btn = document.getElementById("btnToSubmit");
                btn.click();
              },
            });
            ctrl.editor = editor;
          }
        });
      };
    },
  ],
  bindings: {
    content: "=",
    contentId: "=",
    ext: "=",
  },
});

modules.component("actions", {
  templateUrl: "/mix-app/views/app-portal/components/actions/actions.html",
  bindings: {
    primaryUrl: "=",
    primaryTitle: "=",
    primaryIcon: "=",
    previewUrl: "=",
    backUrl: "=",
    contentUrl: "=",
    onClearCache: "&?",
    onSubmit: "&?",
  },
  controller: [
    "$rootScope",
    "$scope",
    "$location",
    function ($rootScope, $scope, $location) {
      var ctrl = this;
      ctrl.visible = $rootScope.visible;
      ctrl.back = function () {
        // ctrl.backUrl = ctrl.backUrl || "/admin";
        // $location.url(ctrl.backUrl);
        if (ctrl.backUrl) {
          $location.url(ctrl.backUrl);
        } else {
          window.history.back();
        }
      };
      ctrl.$onInit = function () {
        ctrl.isAdmin = $rootScope.isAdmin;
      };
      ctrl.submit = function ($event) {
        if (ctrl.onSubmit) {
          $event.preventDefault();
          ctrl.onSubmit();
          return;
        }
      };
      ctrl.clearCache = function () {
        ctrl.onClearCache();
      };
    },
  ],
});

modules.component("additionalValue", {
  templateUrl:
    "/mix-app/views/app-portal/components/additional-value/view.html",
  bindings: {
    additionalData: "=?",
    additionalDataId: "=?",
    parentType: "=?",
    parentId: "=?",
    backUrl: "=?",
    databaseName: "=?",
  },
  controller: [
    "$rootScope",
    "$scope",
    "RestMixDatabaseDataPortalService",
    function ($rootScope, $scope, dataService) {
      var ctrl = this;
      ctrl.value = {};
      ctrl.column = { dataType: "Text" };
      ctrl.selectedCol = null;
      ctrl.localizeSettings = $rootScope.globalSettings;
      ctrl.$onInit = async function () {
        if (!ctrl.additionalData) {
          if (!ctrl.additionalDataId) {
            const obj = {
              parentType: ctrl.parentType,
              parentId: ctrl.parentId,
              databaseName: ctrl.databaseName,
            };
            const getData = await dataService.getAdditionalData(obj);
            if (getData.isSucceed) {
              ctrl.additionalData = getData.data;
              ctrl.additionalData.mixDatabaseName = ctrl.databaseName;
              ctrl.additionalData.parentType = ctrl.parentType;
              ctrl.additionalData.parentId = ctrl.parentId;
              $scope.$apply();
            } else {
              $rootScope.showErrors(getData.errors);
            }
          } else {
            var getData = await dataService.getSingle([ctrl.additionalDataId]);
            ctrl.additionalData = getData.data;
            $scope.$apply();
          }
        }
      };
    },
  ],
});

modules.component("additionalColumn", {
  templateUrl:
    "/mix-app/views/app-portal/components/additional-column/view.html",
  bindings: {
    model: "=",
    additionalData: "=",
  },
  controller: [
    "$rootScope",
    "$scope",
    "RestMixDatabaseColumnPortalService",
    "RestMixDatabaseDataPortalService",
    function ($rootScope, $scope, columnService, dataService) {
      var ctrl = this;
      ctrl.value = {};
      ctrl.column = {
        dataType: "Text",
        mixDatabaseName: "sys_additional_column",
        mixDatabaseId: 6,
        status: "Published",
      };
      ctrl.selectedCol = null;
      ctrl.localizeSettings = $rootScope.globalSettings;
      ctrl.$onInit = async function () {};
      ctrl.addAttr = async function () {
        if (ctrl.column.name) {
          var current = $rootScope.findObjectByKey(
            ctrl.additionalData.columns,
            "name",
            ctrl.column.name
          );
          if (current) {
            $rootScope.showErrors(["Field " + ctrl.column.name + " existed!"]);
          } else {
            ctrl.column.priority = ctrl.additionalData.columns.length + 1;
            $rootScope.isBusy = true;
            var saveField = await columnService.create(ctrl.column);
            $rootScope.isBusy = false;
            if (saveField.isSucceed) {
              ctrl.additionalData.columns.push(saveField.data);
              if (ctrl.additionalData.parentId) {
                await dataService.save(ctrl.additionalData);
              }
              //reset column option
              ctrl.column.title = "";
              ctrl.column.name = "";
              ctrl.column.dataType = "Text";
            } else {
              $rootScope.showErrors(saveField.errors);
            }
            $scope.$apply();
          }
        } else {
          $rootScope.showErrors(["Please add column Name"]);
        }
      };

      ctrl.generateName = function (col) {
        col.name = $rootScope.generateKeyword(col.title, "_", true, true);
      };
      ctrl.showReferences = function (col) {
        ctrl.colRef = col;
        $("#modal-navs").modal("show");
      };
      ctrl.referenceCallback = async function (selected) {
        if (selected && selected.length) {
          ctrl.colRef.reference = selected;
          ctrl.colRef.referenceId = selected[0].id;
          await columnService.save(ctrl.colRef);
        }
        $("#modal-navs").modal("hide");
      };
      ctrl.updateOrders = function (index) {
        if (index > ctrl.dragStartIndex) {
          ctrl.additionalData.columns.splice(ctrl.dragStartIndex, 1);
        } else {
          ctrl.additionalData.columns.splice(ctrl.dragStartIndex + 1, 1);
        }
        angular.forEach(ctrl.additionalData.columns, function (e, i) {
          e.priority = i;
        });
      };

      ctrl.dragStart = function (index) {
        ctrl.dragStartIndex = index;
      };

      ctrl.removeAttribute = function (val, index) {
        $rootScope.showConfirm(
          ctrl,
          "removeAttributeConfirmed",
          [val, index],
          null,
          "Remove Field",
          "Deleted data will not able to recover, are you sure you want to delete this item?"
        );
      };
      ctrl.removeAttributeConfirmed = async function (val, index) {
        if (val.id) {
          $rootScope.isBusy = true;
          var result = await columnService.delete([val.id]);
          if (result.isSucceed) {
            ctrl.additionalData.columns.splice(index, 1);
            $rootScope.isBusy = false;
            $scope.$apply();
          } else {
            $rootScope.showErrors(result.errors);
            $rootScope.isBusy = false;
            $scope.$apply();
          }
        } else {
          ctrl.additionalData.columns.splice(index, 1);
        }
      };
    },
  ],
});

modules.component("confirm", {
  templateUrl: "/mix-app/views/app-portal/components/confirm/confirm.html",
  controller: [
    "$rootScope",
    "$scope",
    "ngAppSettings",
    function ($rootScope, $scope) {
      var ctrl = this;
      ctrl.executeFunctionByName = async function (
        functionName,
        args,
        context
      ) {
        var result = await $rootScope.executeFunctionByName(
          functionName,
          args,
          context
        );
        if (result) {
          $scope.$apply();
        }
      };
    },
  ],
  bindings: {
    message: "=",
  },
});

modules.component("customImage", {
  templateUrl:
    "/mix-app/views/app-portal/components/custom-image/custom-image.html",
  bindings: {
    header: "=?",
    description: "=?",
    src: "=",
    srcUrl: "=",
    w: "=?",
    h: "=?",
    rto: "=?",
    postedFile: "=?",
    type: "=?",
    folder: "=?",
    auto: "=",
    onDelete: "&?",
    onUpdate: "&?",
  },
  controller: [
    "$rootScope",
    "$scope",
    "$uibModal",
    "ngAppSettings",
    "MediaService",
    function ($rootScope, $scope, $uibModal, ngAppSettings, mediaService) {
      var ctrl = this;
      ctrl.isAdmin = $rootScope.isAdmin;
      var image_placeholder = "/mix-app/assets/img/image_placeholder.jpg";
      ctrl.isImage = false;
      ctrl.croppedStream = null;
      ctrl.mediaNavs = [];
      ctrl.options = {};
      ctrl.$onInit = function () {
        ctrl.srcUrl = ctrl.srcUrl || image_placeholder;
        ctrl.isImage = ctrl.srcUrl
          .toLowerCase()
          .match(/([/|.|\w|\s|-])*\.(?:jpg|jpeg|gif|png|svg|ico)/g);
        ctrl.id = Math.floor(Math.random() * 100);
      };
      ctrl.calImageSize = function () {
        if (ctrl.w) {
          ctrl.h = ctrl.h || ctrl.w / ctrl.rto;
          ctrl.rto = ctrl.rto || ctrl.w / ctrl.h;
        }
        if (ctrl.h) {
          ctrl.w = ctrl.w || ctrl.h * ctrl.rto;
          ctrl.rto = ctrl.rto || ctrl.w / ctrl.h;
        }

        ctrl.maxHeight = ctrl.maxHeight || "200px";
        ctrl.options = {
          boundary: { width: 150 * ctrl.rto, height: 150 },
          render: { width: 1000 * ctrl.rto, height: 1000 },
          output: { width: ctrl.w, height: ctrl.h },
        };
      };

      ctrl.mediaFile = {
        file: null,
        fullPath: "",
        folder: ctrl.folder,
        title: ctrl.title,
        description: ctrl.description,
      };

      ctrl.croppieCallback = function (result) {
        if (result) {
          ctrl.srcUrl = result.filePath;
        } else if (ctrl.file) {
          ctrl.uploadFile(ctrl.file);
        }
      };

      ctrl.media = {};
      ctrl.$doCheck = function () {
        if (ctrl.src !== ctrl.srcUrl && ctrl.srcUrl != image_placeholder) {
          ctrl.src = ctrl.srcUrl;
          ctrl.isImage = ctrl.srcUrl
            .toLowerCase()
            .match(/([/|.|\w|\s|-])*\.(?:jpg|jpeg|gif|png|svg)/g);
        }
      }.bind(ctrl);

      ctrl.selectFile = function (files) {
        if (files !== undefined && files !== null && files.length > 0) {
          ctrl.file = files[0];
          ctrl.mediaFile.fileFolder = ctrl.folder || "Media";
          ctrl.mediaFile.title = ctrl.title || "";
          ctrl.mediaFile.description = ctrl.description || "";
          ctrl.mediaFile.file = ctrl.file;
          mediaService.openCroppie(ctrl.file, ctrl, true);
        }
      };

      ctrl.uploadFile = async function (file) {
        if (file !== null) {
          $rootScope.isBusy = true;
          var getMedia = await mediaService.getSingle(["portal"]);
          if (getMedia.isSucceed) {
            ctrl.mediaFile.fileName = file.name.substring(
              0,
              file.name.lastIndexOf(".")
            );
            ctrl.mediaFile.extension = file.name.substring(
              file.name.lastIndexOf(".")
            );
            var media = getMedia.data;
            media.fileFolder = ctrl.folder || "Media";
            media.extension = ctrl.mediaFile.extension;
            media.title = ctrl.title || "";
            media.description = ctrl.description || "";
            media.mediaFile = ctrl.mediaFile;
            var resp = await mediaService.save(
              media,
              null,
              ctrl.onUploadFileProgress
            );
            if (resp && resp.isSucceed) {
              ctrl.src = resp.data.filePath;
              ctrl.srcUrl = resp.data.filePath;
              ctrl.isImage = ctrl.srcUrl
                .toLowerCase()
                .match(/([/|.|\w|\s|-])*\.(?:jpg|jpeg|gif|png|svg)/g);
              $rootScope.isBusy = false;
              $scope.$apply();
            } else {
              if (resp) {
                $rootScope.showErrors(resp.errors);
              }
              $rootScope.isBusy = false;
              $scope.$apply();
            }
          }
        } else {
          return null;
        }
      };

      ctrl.getBase64 = function (file) {
        if (file !== null) {
          $rootScope.isBusy = true;
          var reader = new FileReader();
          reader.readAsDataURL(file);
          reader.onload = function () {
            var index = reader.result.indexOf(",") + 1;
            var base64 = reader.result.substring(index);
            if (ctrl.postedFile) {
              ctrl.postedFile.fileName = file.name.substring(
                0,
                file.name.lastIndexOf(".")
              );
              ctrl.postedFile.extension = file.name.substring(
                file.name.lastIndexOf(".")
              );
              ctrl.postedFile.fileStream = reader.result;
            }
            ctrl.srcUrl = reader.result;
            ctrl.isImage =
              ctrl.srcUrl.indexOf("data:image/") >= 0 ||
              ctrl.srcUrl
                .toLowerCase()
                .match(/([/|.|\w|\s|-])*\.(?:jpg|jpeg|gif|png|svg)/g);
            ctrl.src = reader.result;
            $rootScope.isBusy = false;
            $scope.$apply();
          };
          reader.onerror = function (error) {
            $rootScope.isBusy = false;
            $rootScope.showErrors([error]);
          };
        } else {
          return null;
        }
      };

      ctrl.onUploadFileProgress = function (progress) {
        ctrl.progress = progress;
      };
    },
  ],
});

modules.component("filterList", {
  templateUrl:
    "/mix-app/views/app-portal/components/filter-list/filter-list.html",
  controller: [
    "$scope",
    "$rootScope",
    "ngAppSettings",
    function ($scope, $rootScope, ngAppSettings) {
      var ctrl = this;
      ctrl.dateRange = {
        fromDate: null,
        toDate: null,
      };
      ctrl.init = function () {
        if (!ctrl.orders) {
          ctrl.orders = ngAppSettings.orders;
        }
        ctrl.directions = ngAppSettings.directions;
        ctrl.pageSizes = ngAppSettings.pageSizes;
        ctrl.statuses = [];
        var statuses = ngAppSettings.contentStatuses;
        if (ctrl.request && ctrl.request.contentStatuses) {
          statuses = ctrl.request.contentStatuses;
        }
        angular.forEach(statuses, function (val, i) {
          ctrl.statuses.push({
            value: val,
            title: val,
          });
        });
      };
      ctrl.apply = function (pageIndex) {
        $rootScope.setRequest(ctrl.request, ctrl.key);
        ctrl.callback({ pageIndex: pageIndex });
      };
      ctrl.updateDate = function () {
        ctrl.request.pageIndex = 0;
        if (Date.parse(ctrl.dateRange.fromDate)) {
          ctrl.request.fromDate = new Date(
            ctrl.dateRange.fromDate
          ).toISOString();
        } else {
          $scope.request.fromDate = null;
        }
        if (Date.parse(ctrl.dateRange.toDate)) {
          ctrl.request.toDate = new Date(ctrl.dateRange.toDate).toISOString();
        } else {
          ctrl.request.toDate = null;
        }
        $rootScope.setRequest(ctrl.request, ctrl.key);
        ctrl.callback({ pageIndex: 0 });
      };
    },
  ],
  bindings: {
    request: "=",
    key: "=?",
    orders: "=?",
    createUrl: "=",
    createText: "=",
    callback: "&",
  },
});

modules.component("githubContributers", {
  templateUrl:
    "/mix-app/views/app-portal/components/github-contributers/view.html",
  controller: [
    "$rootScope",
    "$http",
    function ($rootScope, $http) {
      var ctrl = this;
      ctrl.items = [];
      ctrl.init = function () {
        var req = {
          method: "GET",
          url: "https://api.github.com/repos/mixcore/mix.core/contributors",
        };
        ctrl.getGithubApiResult(req);
      };

      ctrl.getGithubApiResult = async function (req) {
        return $http(req).then(
          function (resp) {
            if (resp.status == "200") {
              ctrl.items = resp.data;
            } else {
            }
          },
          function (error) {
            return {
              isSucceed: false,
              errors: [error.statusText || error.status],
            };
          }
        );
      };
    },
  ],
  bindings: {},
});

modules.component("funding", {
  templateUrl: "/mix-app/views/app-portal/components/funding/view.html",
  controller: [
    "$rootScope",
    "$http",
    function ($rootScope, $http) {
      var ctrl = this;
      ctrl.items = [
        {
          title: "opencollective.com/mixcore",
          href: "https://opencollective.com/mixcore",
          logo:
            "https://github.githubassets.com/images/modules/site/icons/funding_platforms/open_collective.svg",
        },
        {
          title: "funding.communitybridge.org/projects/mixcore",
          href: "https://crowdfunding.lfx.linuxfoundation.org/projects/mixcore",
          logo:
            "https://github.githubassets.com/images/modules/site/icons/funding_platforms/community_bridge.svg",
        },
        {
          title: "patreon.com/mixcore",
          href: "https://www.patreon.com/mixcore/creators",
          logo:
            "https://github.githubassets.com/images/modules/site/icons/funding_platforms/patreon.svg",
        },
        {
          title: "paypalme/mixcore",
          href: "https://www.paypal.me/mixcore",
          logo: "/mix-app/assets/img/svg/heart.svg",
        },
        {
          title: "buymeacoffee.com/mixcore",
          href: "https://www.buymeacoffee.com/mixcore",
          logo: "/mix-app/assets/img/svg/heart.svg",
        },
      ];
      ctrl.init = function () {};
    },
  ],
  bindings: {},
});

modules.component("githubReleases", {
  templateUrl: "/mix-app/views/app-portal/components/github-releases/view.html",
  controller: [
    "$rootScope",
    "$http",
    function ($rootScope, $http) {
      var ctrl = this;
      ctrl.items = [];
      ctrl.init = function () {
        var req = {
          method: "GET",
          url: "https://api.github.com/repos/mixcore/mix.core/releases",
        };
        ctrl.getGithubApiResult(req);
      };

      ctrl.getGithubApiResult = async function (req) {
        return $http(req).then(
          function (resp) {
            if (resp.status == "200") {
              ctrl.items = resp.data;
            } else {
            }
          },
          function (error) {
            return {
              isSucceed: false,
              errors: [error.statusText || error.status],
            };
          }
        );
      };
    },
  ],
  bindings: {},
});

modules.component("googleAnalytic", {
  templateUrl: "/mix-app/views/app-portal/components/google-analytic/view.html",
  bindings: {},
  controller: [
    "$rootScope",
    "ApiService",
    "CommonService",
    function ($rootScope, apiService, commonService) {
      var ctrl = this;
      ctrl.init = function () {
        if (gapi) {
          gapi.analytics.ready(function () {
            if ($rootScope.localizeSettings.data.Google_Client_Id) {
              /**
               * Authorize the user immediately if the user has already granted access.
               * If no access has been created, render an authorize button inside the
               * element with the ID "embed-api-auth-container".
               */
              gapi.analytics.auth.authorize({
                container: "embed-api-auth-container",
                //REPLACE WITH YOUR CLIENT ID
                clientid: $rootScope.localizeSettings.data.Google_Client_Id,
              });

              /**
               * Create a ViewSelector for the first view to be rendered inside of an
               * element with the id "view-selector-1-container".
               */
              var viewSelector1 = new gapi.analytics.ViewSelector({
                container: "view-selector-1-container",
              });

              /**
               * Create a ViewSelector for the second view to be rendered inside of an
               * element with the id "view-selector-2-container".
               */
              var viewSelector2 = new gapi.analytics.ViewSelector({
                container: "view-selector-2-container",
              });

              /**
               * Create a new ActiveUsers instance to be rendered inside of an
               * element with the id "active-users-container" and poll for changes every
               * five seconds.
               */
              var activeUsers = new gapi.analytics.ext.ActiveUsers({
                container: "active-users-container",
                pollingInterval: 5,
              });
              /**
               * Add CSS animation to visually show the when users come and go.
               */
              activeUsers.once("success", function () {
                var element = this.container.firstChild;
                var timeout;

                this.on("change", function (data) {
                  var element = this.container.firstChild;
                  var animationClass =
                    data.delta > 0 ? "is-increasing" : "is-decreasing";
                  element.className += " " + animationClass;

                  clearTimeout(timeout);
                  timeout = setTimeout(function () {
                    element.className = element.className.replace(
                      / is-(increasing|decreasing)/g,
                      ""
                    );
                  }, 3000);
                });
              });

              /**
               * Create a ViewSelector for the second view to be rendered inside of an
               * element with the id "view-selector-2-container".
               */
              var viewSelector2 = new gapi.analytics.ViewSelector({
                container: "view-selector-2-container",
              });

              // Render both view selectors to the page.
              // viewSelector1.execute();
              // viewSelector2.execute();

              /**
               * Create the first DataChart for top countries over the past 30 days.
               * It will be rendered inside an element with the id "chart-1-container".
               */
              var dataChart1 = new gapi.analytics.googleCharts.DataChart({
                query: {
                  // ids: $rootScope.localizeSettings.data.Google_Analytic_Ids,
                  metrics: "ga:sessions",
                  dimensions: "ga:date",
                  "start-date": "30daysAgo",
                  "end-date": "yesterday",
                },
                chart: {
                  container: "chart-1-container",
                  type: "LINE",
                  options: {
                    width: "95%",
                    legendTextStyle: { color: "#333" },
                    titleTextStyle: { color: "#333" },
                    backgroundColor: { fill: "transparent" },
                    hAxis: {
                      textStyle: { color: "#333" },
                    },
                    vAxis: {
                      textStyle: { color: "#333" },
                    },
                    series: {
                      0: {
                        color:
                          $rootScope.globalSettings.portalThemeSettings
                            .primaryColor,
                      },
                      1: { color: "#e7711b" },
                      2: { color: "#f1ca3a" },
                      3: { color: "#6f9654" },
                      4: { color: "#1c91c0" },
                      5: { color: "#43459d" },
                    },
                  },
                },
              });

              /**
               * Create the second DataChart for top countries over the past 30 days.
               * It will be rendered inside an element with the id "chart-2-container".
               */
              var dataChart2 = new gapi.analytics.googleCharts.DataChart({
                query: {
                  // ids: $rootScope.localizeSettings.data.Google_Analytic_Ids,
                  metrics: "ga:sessions",
                  dimensions: "ga:country",
                  "start-date": "90daysAgo",
                  "end-date": "yesterday",
                  "max-results": 6,
                  sort: "-ga:sessions",
                },
                chart: {
                  container: "chart-2-container",
                  type: "GEO",
                  options: {
                    width: "95%",
                    pieHole: 4 / 9,
                  },
                },
              });

              dataChart1
                .set({
                  query: {
                    ids: $rootScope.localizeSettings.data.Google_Analytic_Ids,
                  },
                })
                .execute();
              dataChart2
                .set({
                  query: {
                    ids: $rootScope.localizeSettings.data.Google_Analytic_Ids,
                  },
                })
                .execute();
              activeUsers
                .set({
                  ids: $rootScope.localizeSettings.data.Google_Analytic_Ids,
                })
                .execute();

              // /**
              //  * Update the first dataChart when the first view selecter is changed.
              //  */
              // viewSelector1.on('change', function (ids) {
              //   dataChart1.set({ query: { ids: ids } }).execute();
              //   // Start tracking active users for this view.
              //   activeUsers.set({ ids: ids }).execute();
              // });

              // /**
              //  * Update the first dataChart when the first view selecter is changed.
              //  */
              // viewSelector2.on('change', function (ids) {
              //   dataChart2.set({ query: { ids: ids } }).execute();
              //   // Start tracking active users for this view.
              //   activeUsers.set({ ids: ids }).execute();
              // });

              // /**
              //  * Update the second dataChart when the second view selecter is changed.
              //  */
              // viewSelector2.on('change', function (ids) {
              //   dataChart2.set({ query: { ids: ids } }).execute();
              // });
            }
          });
        }
      };
    },
  ],
});

modules.component("hubMessages", {
  templateUrl:
    "/mix-app/views/app-portal/components/hub-messages/hub-messages.html",
  controller: "HubMessagesController",
  bindings: {},
});
app.controller("HubMessagesController", [
  "$scope",
  function ($scope) {
    BaseHub.call(this, $scope);
    $scope.init = function () {
      $scope.startConnection("portalhub");
    };
  },
]);

modules.component("jsonBuilder", {
  templateUrl: "/mix-app/views/app-portal/components/json-builder/view.html",
  bindings: {
    data: "=?", // json obj (ex: { column1: 'some val' })
    folder: "=?", // filepath (ex: 'data/jsonfile.json')
    filename: "=?", // filepath (ex: 'data/jsonfile.json')
    allowedTypes: "=?", // string array ( ex: [ 'type1', 'type2' ] )
    backUrl: "=?", // string array ( ex: [ 'type1', 'type2' ] )
    save: "&",
    onUpdate: "&",
  },
  controller: [
    "$rootScope",
    "$scope",
    "$location",
    "FileServices",
    "ngAppSettings",
    function ($rootScope, $scope, $location, fileService, ngAppSettings) {
      var ctrl = this;
      ctrl.file = null;
      ctrl.translate = $rootScope.translate;
      ctrl.localizeSettings = $rootScope.globalSettings;
      ctrl.timestamp = Math.random();
      ctrl.templates = [
        { type: "item", name: "i1", dataType: 7, value: "" },
        {
          type: "object",
          name: "o1",
          columns: [{ allowedTypes: ["array", "object", "item"], items: [] }],
        },
        {
          type: "array",
          name: "a1",
          columns: [{ allowedTypes: ["object"], items: [] }],
        },
      ];
      ctrl.draft = [];
      ctrl.model = {};
      ctrl.dropzones = {
        root: [],
      };
      ctrl.selected = null;
      ctrl.selectedModel = {};
      ctrl.strModel = null;
      ctrl.init = async function () {
        var arr = [];
        if (!ctrl.data && ctrl.filename) {
          await ctrl.loadFile();
          ctrl.parseObjToList(ctrl.data, arr);
          ctrl.dropzones.root = arr;
        } else {
          ctrl.parseObjToList(ctrl.data, arr);
          ctrl.dropzones.root = arr;
        }
      };
      ctrl.loadFile = async function () {
        $rootScope.isBusy = true;
        $scope.listUrl = "/portal/json-data/list?folder=" + ctrl.folder;

        var response = await fileService.getFile(ctrl.folder, ctrl.filename);
        if (response.isSucceed) {
          ctrl.file = response.data;
          ctrl.data = $.parseJSON(response.data.content);
          $rootScope.isBusy = false;
          $scope.$apply();
        } else {
          $rootScope.showErrors(response.errors);
          $rootScope.isBusy = false;
          $scope.$apply();
        }
      };
      ctrl.saveFile = async function () {
        $rootScope.isBusy = true;
        ctrl.model = {};
        ctrl.update();
        if (ctrl.save) {
          ctrl.save({ data: ctrl.model });
        } else {
          // ctrl.parseObj(ctrl.dropzones.root, ctrl.model);
          ctrl.file.content = JSON.stringify(ctrl.model);
          var resp = await fileService.saveFile(ctrl.file);
          if (resp && resp.isSucceed) {
            $scope.activedFile = resp.data;
            $rootScope.showMessage("Update successfully!", "success");
            $rootScope.isBusy = false;
            $scope.$apply();
          } else {
            if (resp) {
              $rootScope.showErrors(resp.errors);
            }
            $rootScope.isBusy = false;
            $scope.$apply();
          }
        }
        ctrl.select(ctrl.selected);
      };
      ctrl.update = function () {
        ctrl.model = {};
        var obj = {
          type: "object",
          name: "data",
          columns: [
            {
              items: ctrl.dropzones.root,
            },
          ],
        };
        ctrl.parseObj(obj, ctrl.model);
        ctrl.onUpdate({ data: ctrl.model });
      };
      ctrl.parseObjToList = function (item, items) {
        // key: the name of the object key
        // index: the ordinal position of the key within the object
        Object.keys(item).forEach(function (key, index) {
          var obj = {};
          var objType = typeof item[key];
          switch (objType) {
            case "object":
              if (Array.isArray(item[key])) {
                obj = angular.copy(ctrl.templates[2]);
                obj.name = key;
                ctrl.parseObjToList(item[key], obj.columns[0].items);
                items.push(obj);
              } else {
                obj = angular.copy(ctrl.templates[1]);
                obj.name = key;
                ctrl.parseObjToList(item[key], obj.columns[0].items);
                items.push(obj);
              }
              break;
            default:
              obj = angular.copy(ctrl.templates[0]);
              obj.name = key;
              obj.value = item[key];
              items.push(obj);
              break;
          }
        });
      };
      ctrl.parseObj = function (item, obj, name) {
        switch (item.type) {
          case "array":
            obj[item.name] = [];
            angular.forEach(item.columns[0].items, (sub) => {
              var o = {};
              ctrl.parseObj(sub, o);
              obj[item.name].push(o);
            });
            break;
          case "object":
            angular.forEach(item.columns[0].items, (sub) => {
              if (sub.type == "object") {
                var o = {};
                ctrl.parseObj(sub, o);
                obj[item.name] = o;
              } else {
                ctrl.parseObj(sub, obj, item.name);
              }
            });
            break;
          case "item":
            obj[item.name] = item.value;
            break;
        }
      };
      ctrl.select = function (item) {
        if (ctrl.selected == item) {
          ctrl.parseObj(item, ctrl.selectedModel);
        } else {
          ctrl.selected = item;
          ctrl.selectedModel = {};
          ctrl.parseObj(item, ctrl.selectedModel);
        }
        ctrl.timestamp = Math.random();
      };
      ctrl.addField = function (item) {
        var column = angular.copy(ctrl.templates[0]);
        column.name = "f" + (item.columns[0].items.length + 1);
        item.columns[0].items.push(column);
        item.showMenu = false;
      };
      ctrl.addObj = function (item) {
        var obj = angular.copy(ctrl.templates[1]);
        obj.name = "o" + (item.columns[0].items.length + 1);
        item.columns[0].items.push(obj);
        item.showMenu = false;
        ctrl.update();
      };
      ctrl.addArray = function (item) {
        var obj = angular.copy(ctrl.templates[2]);
        obj.name = "a" + (item.columns[0].items.length + 1);
        item.columns[0].items.push(obj);
        item.showMenu = false;
        ctrl.update();
      };
      ctrl.clone = function (item, list) {
        var obj = angular.copy(item);
        obj.name = item.name + "_copy";
        item.showMenu = false;
        obj.showMenu = false;
        list.items.push(obj);
        ctrl.update();
      };

      ctrl.remove = function (index, list) {
        if (confirm("Remove this")) {
          list.items.splice(index, 1);
          ctrl.update();
        }
      };
    },
  ],
});

(function (angular) {
  app.component("headerNav", {
    templateUrl:
      "/mix-app/views/app-portal/components/header-nav/headerNav.html",
    controller: [
      "$rootScope",
      "CommonService",
      "AuthService",
      function ($rootScope, commonService, authService) {
        var ctrl = this;
        ctrl.globalSettings = $rootScope.globalSettings;
        ctrl.isInRole = $rootScope.isInRole;
        this.$onInit = function () {
          ctrl.isAdmin = $rootScope.isAdmin;
          ctrl.localizeSettings = $rootScope.localizeSettings;
          ctrl.localizeSettings.cultures = $rootScope.globalSettings.cultures;
          authService.fillAuthData().then(() => {
            if (authService.authentication && authService.authentication.info) {
              ctrl.avatar = authService.authentication.info.userData.avatar;
            }
          });
        };
        ctrl.translate = $rootScope.translate;
        ctrl.getConfiguration = function (keyword, isWrap, defaultText) {
          return $rootScope.getConfiguration(keyword, isWrap, defaultText);
        };
        ctrl.changeLang = function (lang, langIcon) {
          ctrl.localizeSettings.lang = lang;
          ctrl.localizeSettings.langIcon = langIcon;
          commonService.fillAllSettings(lang).then(function () {
            window.top.location = location.href;
          });
        };
        ctrl.logOut = function () {
          $rootScope.logOut();
        };
        ctrl.addPermission = function () {
          $("#dlg-permission").modal("show");
        };
        ctrl.addBookmark = function () {
          $("#dlg-bookmark").modal("show");
        };
        ctrl.toggleSidebar = function () {
          $(".main-sidebar").toggle();
          $(".sub-sidebar").toggle();
          // $('.navbar-brand').toggle();
        };
        ctrl.showHelper = function (url) {
          $rootScope.helperUrl = url;
          $("#dev-helper-modal").modal("show");
        };
        ctrl.generateSitemap = async function () {
          $rootScope.isBusy = true;
          var resp = await commonService.genrateSitemap();
          if (resp) {
            window.top.location.href =
              "/portal/file/details?folder=" +
              resp.fileFolder +
              "&filename=" +
              resp.fileName +
              resp.extension;
          } else {
            $rootScope.isBusy = false;
            $rootScope.showErrors(["Server error"]);
          }
        };
      },
    ],
    bindings: {
      breadCrumbs: "=",
      settings: "=",
    },
  });
})(window.angular);

modules.component("jumbotrons", {
  templateUrl:
    "/mix-app/views/app-portal/components/jumbotrons/jumbotrons.html",
  controller: [
    "$rootScope",
    "$scope",
    "$location",
    function ($rootScope, $scope, $location) {
      var ctrl = this;
      ctrl.translate = function (keyword) {
        return $rootScope.translate(keyword);
      };
      // ctrl.back = function () {
      //     ctrl.backUrl = ctrl.backUrl || '/admin';
      //     $location.path(ctrl.backUrl);
      // };
    },
  ],
  bindings: {
    tagName: "=",
    tagType: "=",
  },
});

modules.component("listMixColumn", {
  templateUrl: "/mix-app/views/app-portal/components/list-mix-column/view.html",
  controller: [
    "$rootScope",
    "$scope",
    "RestMixDatabaseColumnPortalService",
    function ($rootScope, $scope, service) {
      var ctrl = this;
      ctrl.selectedCol = null;
      ctrl.localizeSettings = $rootScope.globalSettings;
      ctrl.$onInit = async function () {
        var getDefaultAttr = await service.getDefault();
        if (getDefaultAttr.isSucceed) {
          ctrl.defaultAttr = getDefaultAttr.data;
          ctrl.defaultAttr.options = [];
        }
      };
      ctrl.addAttr = function () {
        if (ctrl.columns) {
          var t = angular.copy(ctrl.defaultAttr);
          t.priority = ctrl.columns.length + 1;
          ctrl.columns.push(t);
        }
      };
      ctrl.removeAttribute = async function (attr, index) {
        if (confirm("Remove this column ?")) {
          if (attr.id) {
            $rootScope.isBusy = true;
            var remove = await service.delete([attr.id]);
            if (remove.isSucceed) {
              ctrl.columns.splice(index, 1);
            }
            $rootScope.isBusy = false;
            $scope.$apply();
          } else {
            ctrl.columns.splice(index, 1);
          }
        }
      };
      ctrl.addOption = function (col, index) {
        var val = $("#option_" + index).val();
        col.options = col.options || [];
        var opt = {
          value: val,
          dataType: 7,
        };
        col.options.push(opt);
        $("#option_" + index).val("");
      };
      ctrl.generateForm = function () {
        var formHtml = document.createElement("module-form");
        formHtml.setAttribute("class", "row");
        angular.forEach(ctrl.viewmodel.attributes, function (e, i) {
          var el;
          var label = document.createElement("label");
          label.setAttribute("class", "form-label");
          label.setAttribute("ng-bind", "{{data.title}}");

          switch (e.dataType) {
            case "datetime":
              el = document.createElement("input");
              el.setAttribute("type", "datetime-local");
              break;

            case "date":
              el = document.createElement("input");
              el.setAttribute("type", "date");
              break;

            case "time":
              el = document.createElement("input");
              el.setAttribute("type", "time");
              break;

            case "phonenumber":
              el = document.createElement("input");
              el.setAttribute("type", "tel");
              break;

            case "number":
              el = document.createElement("input");
              el.setAttribute("type", "number");
              break;

            case "html":
              el = document.createElement("trumbowyg");
              el.setAttribute("options", "{}");
              el.setAttribute("type", "number");
              break;

            case "textarea":
              el = document.createElement("textarea");
              break;

            default:
              el = document.createElement("input");
              el.setAttribute("type", "text");
              formHtml.appendChild(el);
              break;
          }
          el.setAttribute("ng-model", "data.jItem[" + e.name + "].value");
          el.setAttribute("placeholder", "{{$ctrl.title}}");
          formHtml.appendChild(label);
          formHtml.appendChild(el);
        });
        ctrl.viewmodel.formView.content = formHtml.innerHTML;
      };

      ctrl.generateName = function (col, isForce = false) {
        if (isForce || !col.name) {
          col.name = $rootScope.generateKeyword(col.title, "_", true, true);
        }
      };
      ctrl.removeAttr = function (index) {
        if (ctrl.columns) {
          ctrl.columns.splice(index, 1);
        }
      };
      ctrl.updateOrders = function (index) {
        if (index > ctrl.dragStartIndex) {
          ctrl.columns.splice(ctrl.dragStartIndex, 1);
        } else {
          ctrl.columns.splice(ctrl.dragStartIndex + 1, 1);
        }
        angular.forEach(ctrl.columns, function (e, i) {
          e.priority = i;
        });
      };
      ctrl.dragStart = function (index) {
        ctrl.dragStartIndex = index;
      };
      ctrl.showReferences = function (col) {
        ctrl.colRef = col;
        $("#modal-navs").modal("show");
      };
      ctrl.referenceCallback = function (selected) {
        if (selected && selected.length) {
          ctrl.colRef.reference = selected;
          ctrl.colRef.referenceId = selected[0].id;
        }
        $("#modal-navs").modal("hide");
      };
    },
  ],
  bindings: {
    header: "=",
    columns: "=",
    removeAttributes: "=",
  },
});

modules.component("mainSideBar", {
  templateUrl:
    "/mix-app/views/app-portal/components/main-side-bar/main-side-bar.html",
  controller: [
    "$rootScope",
    "$scope",
    "ngAppSettings",
    "TranslatorService",
    "ApiService",
    "CommonService",
    function (
      $rootScope,
      $scope,
      ngAppSettings,
      translatorService,
      apiService,
      commonService
    ) {
      var ctrl = this;
      ctrl.items = [];
      ctrl.init = function () {
        var routes = JSON.parse($("#portal-menus").val());
        ctrl.items = routes.data;
      };
    },
  ],
  bindings: {},
});

modules.component("mainSideBarItem", {
  templateUrl:
    "/mix-app/views/app-portal/components/main-side-bar-item/main-side-bar-item.html",
  controller: [
    "$rootScope",
    function ($rootScope) {
      var ctrl = this;
      ctrl.translate = $rootScope.translate;
      ctrl.addClass = function (obj) {
        obj.currentTarget.classList.add("btn-group-lg");
        //alert(obj);
      };
      ctrl.removeClass = function (obj) {
        obj.currentTarget.classList.remove("btn-group-lg");
        //alert(obj);
      };
    },
  ],
  bindings: {
    item: "=",
  },
});

modules.component("mainSideBarDynamic", {
  templateUrl:
    "/mix-app/views/app-portal/components/main-side-bar-dynamic/main-side-bar-dynamic.html",
  controller: [
    "$rootScope",
    "$scope",
    "ngAppSettings",
    "CommonService",
    "TranslatorService",
    "AuthService",
    function (
      $rootScope,
      $scope,
      ngAppSettings,
      commonService,
      translatorService,
      authService
    ) {
      var ctrl = this;
      ctrl.init = function () {
        commonService.getPermissions().then(function (response) {
          if (response && response.isSucceed) {
            ctrl.isInit = true;
            ctrl.roles = response.data;
            if (ctrl.roles.data) {
              ctrl.role = ctrl.roles.data[0];
            }
            $rootScope.isBusy = false;
            $scope.$apply();
          }
        });
      };
    },
  ],
  bindings: {
    roles: "=",
    activedRole: "=",
    translate: "&",
  },
});

modules.component("mainSideBarItemDynamic", {
  templateUrl:
    "/mix-app/views/app-portal/components/main-side-bar-item-dynamic/main-side-bar-item-dynamic.html",
  controller: [
    "$rootScope",
    function ($rootScope) {
      var ctrl = this;
      ctrl.translate = $rootScope.translate;
    },
  ],
  bindings: {
    iconSize: "=",
    linkStyle: "=",
    itemStyle: "=",
    item: "=",
  },
});

modules.component("mediaFileUpload", {
  templateUrl:
    "/mix-app/views/app-portal/components/media-file-upload/view.html",
  bindings: {
    header: "=?",
    description: "=?",
    src: "=",
    srcUrl: "=",
    mediaFile: "=?",
    type: "=?",
    folder: "=?",
    auto: "=",
    uploadOptions: "=?",
    onDelete: "&?",
    onUpdate: "&?",
    onInsert: "&?",
  },
  controller: [
    "$rootScope",
    "$scope",
    "ngAppSettings",
    "MediaService",
    function ($rootScope, $scope, ngAppSettings, mediaService) {
      var ctrl = this;
      ctrl.isAdmin = $rootScope.isAdmin;
      var image_placeholder = "/mix-app/assets/img/image_placeholder.jpg";
      ctrl.isImage = false;
      ctrl.mediaNavs = [];
      ctrl.$onInit = function () {
        ctrl.autoSave = ctrl.auto === "true";
        ctrl.srcUrl = ctrl.srcUrl || image_placeholder;
        ctrl.mediaFile = ctrl.mediaFile || {};
        ctrl.isImage = ctrl.srcUrl
          .toLowerCase()
          .match(/([/|.|\w|\s|-])*\.(?:jpg|jpeg|gif|png|svg|ico)/g);
        ctrl.maxHeight = ctrl.maxHeight || "200px";
        ctrl.id = Math.floor(Math.random() * 100);
        if (ctrl.uploadOptions) {
          ctrl.w = ctrl.uploadOptions.width;
          ctrl.h = ctrl.uploadOptions.height;
        }
      };
      ctrl.$doCheck = function () {
        if (ctrl.src !== ctrl.srcUrl && ctrl.srcUrl != image_placeholder) {
          ctrl.src = ctrl.srcUrl;
          ctrl.isImage = ctrl.srcUrl
            .toLowerCase()
            .match(/([/|.|\w|\s|-])*\.(?:jpg|jpeg|gif|png|svg)/g);
        }
      }.bind(ctrl);

      ctrl.selectFile = function (files) {
        if (files !== undefined && files !== null && files.length > 0) {
          ctrl.formFile = files[0];
          ctrl.mediaFile.fileFolder = ctrl.folder ? ctrl.folder : "Media";
          ctrl.mediaFile.title = ctrl.title ? ctrl.title : "";
          ctrl.mediaFile.description = ctrl.description ? ctrl.description : "";
          ctrl.mediaFile.fileName = ctrl.formFile.name.substring(
            0,
            ctrl.formFile.name.lastIndexOf(".")
          );
          ctrl.mediaFile.extension = ctrl.formFile.name.substring(
            ctrl.formFile.name.lastIndexOf(".")
          );
          if ($rootScope.isImage(ctrl.formFile)) {
            ctrl.canUpload = false;
            mediaService.openCroppie(files[0], ctrl, ctrl.autoSave);
          } else {
            ctrl.mediaFile.file = ctrl.formFile;
            ctrl.canUpload = true;
            if (ctrl.autoSave) {
              ctrl.uploadFile(ctrl.formFile);
            }
            // ctrl.getBase64(ctrl.formFile);
          }
        }
      };

      ctrl.croppieCallback = function (result) {
        if (result) {
          ctrl.isImage = true;
          if (!ctrl.autoSave) {
            ctrl.src = result;
            ctrl.mediaFile.fileStream = result;
          } else {
            ctrl.src = result.filePath;
          }
          $scope.$apply();
        } else if (ctrl.formFile) {
          if (ctrl.autoSave) {
            ctrl.uploadFile(ctrl.formFile);
          } else {
            ctrl.mediaFile.file = ctrl.formFile;
            ctrl.getBase64(ctrl.formFile);
          }
          //   ctrl.uploadFile(ctrl.formFile);
        }
      };

      ctrl.uploadFile = async function (file) {
        if (file !== null) {
          $rootScope.isBusy = true;
          if (file) {
            var response = await mediaService.uploadMedia(
              file,
              ctrl.onUploadFileProgress
            );
            if (response.isSucceed) {
              ctrl.media = response.data;
              $rootScope.isBusy = false;
              ctrl.srcUrl = response.data.filePath;
              $scope.$apply();
            } else {
              $rootScope.showErrors(response.errors);
              $rootScope.isBusy = false;
              $scope.$apply();
            }
          }
        } else {
          return null;
        }
      };
      ctrl.getBase64 = function (file) {
        if (file !== null) {
          $rootScope.isBusy = true;
          var reader = new FileReader();
          reader.readAsDataURL(file);
          reader.onload = function () {
            if (ctrl.mediaFile) {
              ctrl.mediaFile.fileName = file.name.substring(
                0,
                file.name.lastIndexOf(".")
              );
              ctrl.mediaFile.extension = file.name.substring(
                file.name.lastIndexOf(".")
              );
              ctrl.mediaFile.fileStream = reader.result;
            }
            ctrl.srcUrl = reader.result;
            ctrl.isImage =
              ctrl.srcUrl.indexOf("data:image/") >= 0 ||
              ctrl.srcUrl
                .toLowerCase()
                .match(/([/|.|\w|\s|-])*\.(?:jpg|jpeg|gif|png|svg)/g);
            ctrl.src = reader.result;
            $rootScope.isBusy = false;
            $scope.$apply();
          };
          reader.onerror = function (error) {
            $rootScope.isBusy = false;
            $rootScope.showErrors([error]);
          };
        } else {
          return null;
        }
      };
      ctrl.onUploadFileProgress = function (progress) {
        ctrl.progress = progress;
      };
    },
  ],
});

modules.component("mediaUpload", {
  templateUrl:
    "/mix-app/views/app-portal/components/media-upload/media-upload.html",
  controller: [
    "$scope",
    "$rootScope",
    "MediaService",
    "ApiService",
    "CommonService",
    function ($scope, $rootScope, service, apiService, commonService) {
      var ctrl = this;
      ctrl.default = {
        title: "",
        description: "",
        status: "Published",
        fileFolder: "Medias",
        mediaFile: {
          file: null,
          fullPath: "",
          folderName: "Media",
          fileFolder: "",
          fileName: "",
          extension: "",
          content: "",
          fileStream: "",
        },
      };
      ctrl.viewmodel = angular.copy(ctrl.default);
      ctrl.onInsert = function (data) {
        if (ctrl.onUpdate) {
          ctrl.onUpdate();
        }
      };
      ctrl.save = async function (data) {
        $rootScope.isBusy = true;
        var resp = await service.save(data);
        if (resp && resp.isSucceed) {
          $scope.viewmodel = resp.data;
          $rootScope.showMessage("success", "success");
          $rootScope.isBusy = false;
          ctrl.viewmodel = angular.copy(ctrl.default);
          if (ctrl.onUpdate) {
            ctrl.onUpdate();
          }
          $("#modal-files .modal-body").animate({ scrollTop: "0px" }, 500);
          $scope.$apply();
        } else {
          if (resp) {
            $rootScope.showErrors(resp.errors);
          }
          $rootScope.isBusy = false;
          $scope.$apply();
        }
      };
    },
  ],
  bindings: {
    onUpdate: "&?",
  },
});

modules.component("mixDatabaseColumn", {
  templateUrl:
    "/mix-app/views/app-portal/components/mix-database-column/view.html",
  bindings: {
    column: "=",
  },
  controller: [
    "$rootScope",
    "$scope",
    "RestMixDatabaseColumnPortalService",
    function ($rootScope, $scope, columnService) {
      var ctrl = this;
      ctrl.value = {};
      ctrl.column = {
        dataType: "Text",
        mixDatabaseName: "sys_additional_column",
        mixDatabaseId: 6,
      };
      ctrl.selectedCol = null;
      ctrl.localizeSettings = $rootScope.globalSettings;
      ctrl.$onInit = async function () {};
      ctrl.addAttr = async function () {
        if (ctrl.column.name) {
          var current = $rootScope.findObjectByKey(
            ctrl.additionalData.columns,
            "name",
            ctrl.column.name
          );
          if (current) {
            $rootScope.showErrors(["Field " + ctrl.column.name + " existed!"]);
          } else {
            ctrl.column.priority = ctrl.additionalData.columns.length + 1;
            $rootScope.isBusy = true;
            var saveField = await columnService.create(ctrl.column);
            $rootScope.isBusy = false;
            if (saveField.isSucceed) {
              ctrl.additionalData.columns.push(saveField.data);

              //reset column option
              ctrl.column.title = "";
              ctrl.column.name = "";
              ctrl.column.dataType = "Text";
              $scope.$apply();
            }
          }
        } else {
          $rootScope.showErrors(["Please add column Name"]);
        }
      };

      ctrl.generateName = function (col) {
        col.name = $rootScope.generateKeyword(col.title, "_");
      };
      ctrl.showReferences = function (col) {
        ctrl.colRef = col;
        $("#modal-navs").modal("show");
      };
      ctrl.referenceCallback = function (selected) {
        if (selected && selected.length) {
          ctrl.colRef.reference = selected;
          ctrl.colRef.referenceId = selected[0].id;
        }
        $("#modal-navs").modal("hide");
      };
      ctrl.updateOrders = function (index) {
        if (index > ctrl.dragStartIndex) {
          ctrl.columns.splice(ctrl.dragStartIndex, 1);
        } else {
          ctrl.columns.splice(ctrl.dragStartIndex + 1, 1);
        }
        angular.forEach(ctrl.columns, function (e, i) {
          e.priority = i;
        });
      };

      ctrl.dragStart = function (index) {
        ctrl.dragStartIndex = index;
      };

      ctrl.removeAttribute = function (val, index) {
        $rootScope.showConfirm(
          ctrl,
          "removeAttributeConfirmed",
          [val, index],
          null,
          "Remove Field",
          "Deleted data will not able to recover, are you sure you want to delete this item?"
        );
      };
      ctrl.removeAttributeConfirmed = async function (val, index) {
        if (val.id) {
          $rootScope.isBusy = true;
          var result = await columnService.delete([val.id]);
          if (result.isSucceed) {
            ctrl.additionalData.columns.splice(index, 1);
            $rootScope.isBusy = false;
            $scope.$apply();
          } else {
            $rootScope.showErrors(result.errors);
            $rootScope.isBusy = false;
            $scope.$apply();
          }
        } else {
          ctrl.additionalData.columns.splice(index, 1);
        }
      };
    },
  ],
});

modules.component("mediumNews", {
  templateUrl: "/mix-app/views/app-portal/components/medium-news/view.html",
  controller: [
    "$rootScope",
    "$http",
    function ($rootScope, $http) {
      var ctrl = this;
      ctrl.items = [];
      ctrl.init = function () {
        var req = {
          method: "GET",
          url:
            "https://api.rss2json.com/v1/api.json?rss_url=https://medium.com/feed/mixcore&api_key=qww481wpgat3g4iqvqss7spzrilkbekpxpjgrbof&t=" +
            Math.floor(Date.now() / 1000),
        };
        ctrl.getMediumApiResult(req);
      };

      ctrl.getMediumApiResult = async function (req) {
        return $http(req).then(
          function (resp) {
            if (resp.status == "200") {
              ctrl.items = resp.data.items;
            }
          },
          function (error) {
            return {
              isSucceed: false,
              errors: [error.statusText || error.status],
            };
          }
        );
      };
    },
  ],
  bindings: {},
});

modules.component("mixDatabaseDataFilter", {
  templateUrl:
    "/mix-app/views/app-portal/components/mix-database-data-filter/view.html",
  bindings: {
    query: "=",
    mixDatabaseName: "=?",
    mixDatabaseId: "=?",
    selectedList: "=",
    initData: "=?",
    columns: "=?",
    selected: "=",
    callback: "&?",
    save: "&?",
  },
  controller: [
    "$rootScope",
    "$scope",
    "ngAppSettings",
    "RestMixDatabaseDataPortalService",
    function ($rootScope, $scope, ngAppSettings, dataService) {
      var ctrl = this;
      ctrl.request = angular.copy(ngAppSettings.request);
      ctrl.types = ["Page", "Post"];
      ctrl.type = "Page";
      ctrl.navs = [];
      ctrl.data = { items: [] };
      ctrl.goToPath = $rootScope.goToPath;
      ctrl.$onInit = function () {
        if (ctrl.initData) {
          ctrl.data = ctrl.initData;
        } else {
          ctrl.loadData();
        }
      };
      ctrl.loadData = async function (pageIndex) {
        ctrl.isBusy = true;

        // ctrl.request.query = ctrl.query + ctrl.srcId;
        ctrl.navs = [];
        if (pageIndex !== undefined) {
          ctrl.request.pageIndex = pageIndex;
        }
        if (ctrl.request.fromDate !== null) {
          var df = new Date(ctrl.request.fromDate);
          ctrl.request.fromDate = df.toISOString();
        }
        if (ctrl.request.toDate !== null) {
          var dt = new Date(ctrl.request.toDate);
          ctrl.request.toDate = dt.toISOString();
        }
        if (ctrl.mixDatabaseId) {
          ctrl.request.mixDatabaseId = ctrl.mixDatabaseId;
        }
        if (ctrl.mixDatabaseName) {
          ctrl.request.mixDatabaseName = ctrl.mixDatabaseName;
        }
        if (ctrl.filterType) {
          ctrl.request.filterType = ctrl.filterType;
        }

        var response = await dataService.getList(ctrl.request);
        if (response.isSucceed) {
          ctrl.data = response.data;
          ctrl.isBusy = false;
          $scope.$apply();
        } else {
          $rootScope.showErrors(response.errors);
          ctrl.isBusy = false;
          $scope.$apply();
        }
      };
      ctrl.edit = function (nav) {
        switch (ctrl.type) {
          case "Page":
            ctrl.goToPath(`/portal/page/details/${nav.id}`);
            break;
          case "Post":
            ctrl.goToPath(`/portal/post/details/${nav.id}`);
            break;
          case "Module":
            ctrl.goToPath(`/portal/module/details/${nav.id}`);
            break;
        }
      };
      ctrl.onClose = function () {
        ctrl.callback();
      };
      ctrl.select = function (nav) {
        var current = $rootScope.findObjectByKey(ctrl.data.items, "id", nav.id);
        if (!nav.isActive && ctrl.callback) {
          ctrl.callback({ nav: nav });
        }
        if (ctrl.isMultiple) {
          current.isActive = !current.isActive;
        } else {
          if (!nav.isActive) {
            angular.forEach(ctrl.data.items, (element) => {
              element.isActive = false;
            });
          }
          current.isActive = !nav.isActive;
        }
      };
      ctrl.saveSelected = function () {
        ctrl.selected = $rootScope.filterArray(
          ctrl.data,
          ["isActived"],
          [true]
        );
        setTimeout(() => {
          ctrl.save().then(() => {
            ctrl.loadPosts();
          });
        }, 500);
      };
      ctrl.limString = function (str, max) {
        if (str) {
          return str.length > max ? str.substring(0, max) + " ..." : str;
        }
      };
    },
  ],
});

modules.component("mixDatabaseDataValueEditor", {
  templateUrl:
    "/mix-app/views/app-portal/components/mix-database-data-value-editor/view.html",
  bindings: {
    mixDatabaseDataValue: "=?",
    parentType: "=?",
    parentId: "=?",
    isShowTitle: "=?",
  },
  controller: [
    "$rootScope",
    "$scope",
    "ngAppSettings",
    "$location",
    "RestRelatedMixDatabasePortalService",
    "RestMixDatabaseDataPortalService",
    function (
      $rootScope,
      $scope,
      ngAppSettings,
      $location,
      navService,
      dataService
    ) {
      var ctrl = this;
      ctrl.goToPath = $rootScope.goToPath;
      ctrl.icons = ngAppSettings.icons;
      ctrl.refData = null;
      ctrl.defaultDataModel = null;
      ctrl.refDataModel = {
        id: null,
        data: null,
      };
      ctrl.refRequest = angular.copy(ngAppSettings.request);
      ctrl.refRequest.pageSize = 100;
      ctrl.dataTypes = $rootScope.globalSettings.dataTypes;
      ctrl.previousId = null;
      ctrl.$doCheck = function () {
        if (
          ctrl.mixDatabaseDataValue &&
          ctrl.previousId !== ctrl.mixDatabaseDataValue.id
        ) {
          ctrl.previousId = ctrl.mixDatabaseDataValue.id;
          ctrl.initData();
        }
      }.bind(ctrl);
      ctrl.$onInit = function () {
        ctrl.initData();
      };
      ctrl.initData = async function () {
        setTimeout(() => {
          if (!ctrl.mixDatabaseDataValue.id) {
            ctrl.initDefaultValue();
          }
          switch (ctrl.mixDatabaseDataValue.dataType.toLowerCase()) {
            case "datetime":
            case "date":
            case "time":
              if (ctrl.mixDatabaseDataValue.dateTimeValue) {
                ctrl.mixDatabaseDataValue.dateObj = new Date(
                  ctrl.mixDatabaseDataValue.dateTimeValue
                );
                $scope.$apply();
              }
              break;
            case "reference": // reference
              if (
                ctrl.mixDatabaseDataValue.column.referenceId &&
                ctrl.parentId
              ) {
                ctrl.mixDatabaseDataValue.integerValue =
                  ctrl.mixDatabaseDataValue.column.referenceId;
                // navService.getSingle(["default"]).then((resp) => {
                //   ctrl.defaultDataModel = resp;
                //   ctrl.defaultDataModel.mixDatabaseId =
                //     ctrl.mixDatabaseDataValue.column.referenceId;
                //   ctrl.refDataModel = angular.copy(ctrl.defaultDataModel);
                // });
                // ctrl.loadRefData();
              }
              break;
            default:
              if (
                ctrl.mixDatabaseDataValue.column &&
                ctrl.mixDatabaseDataValue.column.isEncrypt &&
                ctrl.mixDatabaseDataValue.encryptValue
              ) {
                var encryptedData = {
                  key: ctrl.mixDatabaseDataValue.encryptKey,
                  data: ctrl.mixDatabaseDataValue.encryptValue,
                };
                ctrl.mixDatabaseDataValue.stringValue = $rootScope.decrypt(
                  encryptedData
                );
              }
              if (
                ctrl.mixDatabaseDataValue.column &&
                !ctrl.mixDatabaseDataValue.stringValue
              ) {
                ctrl.mixDatabaseDataValue.stringValue =
                  ctrl.mixDatabaseDataValue.column.defaultValue;
                $scope.$apply();
              }
              break;
          }
        }, 200);
      };
      ctrl.initDefaultValue = async function () {
        switch (ctrl.mixDatabaseDataValue.dataType) {
          case "datetime":
          case "date":
          case "time":
            if (ctrl.mixDatabaseDataValue.column.defaultValue) {
              ctrl.mixDatabaseDataValue.dateObj = new Date(
                ctrl.mixDatabaseDataValue.column.defaultValue
              );
              ctrl.mixDatabaseDataValue.stringValue =
                ctrl.mixDatabaseDataValue.column.defaultValue;
            }
            break;
          case "double":
            if (ctrl.mixDatabaseDataValue.column.defaultValue) {
              ctrl.mixDatabaseDataValue.doubleValue = parseFloat(
                ctrl.mixDatabaseDataValue.column.defaultValue
              );
              ctrl.mixDatabaseDataValue.stringValue =
                ctrl.mixDatabaseDataValue.column.defaultValue;
            }
            break;
          case "boolean":
            if (ctrl.mixDatabaseDataValue.column.defaultValue) {
              ctrl.mixDatabaseDataValue.booleanValue =
                ctrl.mixDatabaseDataValue.column.defaultValue == "true";
              ctrl.mixDatabaseDataValue.stringValue =
                ctrl.mixDatabaseDataValue.column.defaultValue;
            }
            break;

          default:
            if (ctrl.mixDatabaseDataValue.column.defaultValue) {
              ctrl.mixDatabaseDataValue.stringValue =
                ctrl.mixDatabaseDataValue.column.defaultValue;
            }
            break;
        }
      };
      ctrl.updateStringValue = async function (dataType) {
        switch (dataType.toLowerCase()) {
          case "datetime":
          case "date":
          case "time":
            if (ctrl.mixDatabaseDataValue.dateObj) {
              ctrl.mixDatabaseDataValue.dateTimeValue = ctrl.mixDatabaseDataValue.dateObj.toISOString();
              ctrl.mixDatabaseDataValue.stringValue =
                ctrl.mixDatabaseDataValue.dateTimeValue;
            }
            break;
          case "double":
            if (ctrl.mixDatabaseDataValue.doubleValue) {
              ctrl.mixDatabaseDataValue.stringValue = ctrl.mixDatabaseDataValue.doubleValue.toString();
            }
            break;
          case "boolean":
            if (ctrl.mixDatabaseDataValue.booleanValue != null) {
              ctrl.mixDatabaseDataValue.stringValue = ctrl.mixDatabaseDataValue.booleanValue.toString();
            }
            break;

          default:
            break;
        }
      };

      ctrl.updateRefData = function (nav) {
        ctrl.goToPath(`/portal/mix-database-data/details?dataId=${nav.data.id}
                &mixDatabaseId=${nav.data.mixDatabaseId}
                &parentId=${ctrl.parentId}
                &parentType=${ctrl.parentType}`);
        // ctrl.refDataModel = nav;
        // var e = $(".pane-form-" + ctrl.mixDatabaseDataValue.column.referenceId)[0];
        // angular.element(e).triggerHandler('click');
        // $location.url('/portal/mix-database-data/details?dataId='+ item.id +'&mixDatabaseId=' + item.mixDatabaseId+'&parentType=' + item.parentType+'&parentId=' + item.parentId);
      };

      ctrl.removeRefData = async function (nav) {
        $rootScope.showConfirm(
          ctrl,
          "removeRefDataConfirmed",
          [nav],
          null,
          "Remove",
          "Deleted data will not able to recover, are you sure you want to delete this item?"
        );
      };
      ctrl.removeRefDataConfirmed = async function (nav) {
        $rootScope.isBusy = true;
        var result = await navService.delete([
          nav.parentId,
          nav.parentType,
          nav.id,
        ]);
        if (result.isSucceed) {
          $rootScope.removeObjectByKey(ctrl.refData, "id", nav.id);
          $rootScope.isBusy = false;
          $scope.$apply();
        } else {
          $rootScope.showMessage("failed");
          $rootScope.isBusy = false;
          $scope.$apply();
        }
      };
    },
  ],
});

modules.component("mixDatabaseDataValues", {
  templateUrl:
    "/mix-app/views/app-portal/components/mix-database-data-values/view.html",
  bindings: {
    header: "=",
    data: "=",
    canDrag: "=",
    mixDatabaseName: "=?",
    mixDatabaseTitle: "=?",
    mixDatabaseId: "=?",
    queries: "=?",
    filterType: "=?",
    compareType: "=?",
    selectedList: "=",
    selectSingle: "=?",
    columns: "=?",
    onFilterList: "&?",
    onApplyList: "&?",
    onSendMail: "&?",
    onUpdate: "&?",
    onDuplicate: "&?",
    onDelete: "&?",
  },
  controller: [
    "$rootScope",
    "$scope",
    "RestMixDatabaseColumnPortalService",
    "RestMixDatabaseDataPortalService",
    function ($rootScope, $scope, columnService, dataService) {
      var ctrl = this;
      ctrl.actions = ["Delete", "SendMail"];
      ctrl.filterTypes = ["contain", "equal"];
      ctrl.compareTypes = ["or", "and"];
      ctrl.selectedProp = null;
      ctrl.localizeSettings = $rootScope.globalSettings;
      ctrl.$onInit = async function () {
        if (!ctrl.selectedList) {
          ctrl.selectedList = {
            action: "Delete",
            data: [],
          };
        }
        if (!ctrl.columns) {
          var getFields = await columnService.initData(
            ctrl.mixDatabaseName || ctrl.mixDatabaseId
          );
          if (getFields.isSucceed) {
            ctrl.columns = getFields.data;
            $scope.$apply();
          }
        }
      };
      ctrl.select = function (item) {
        if (item.isSelected) {
          if (ctrl.selectSingle == "true") {
            ctrl.selectedList.data = [];
            ctrl.selectedList.data.push(item);
          } else {
            var current = $rootScope.findObjectByKey(
              ctrl.selectedList,
              "id",
              item.id
            );
            if (!current) {
              ctrl.selectedList.data.push(item);
            }
          }
        } else {
          $rootScope.removeObject(ctrl.selectedList, item.id);
        }
      };
      ctrl.selectAll = function (isSelected) {
        ctrl.selectedList.data = [];
        angular.forEach(ctrl.data, function (e) {
          e.isSelected = isSelected;
          if (isSelected) {
            ctrl.selectedList.data.push(e.id);
          }
        });
      };
      ctrl.filter = function () {
        ctrl.data = [];
        ctrl.onFilterList();
      };
      ctrl.sendMail = async function (data) {
        ctrl.onSendMail({ data: data });
      };
      ctrl.apply = async function () {
        ctrl.onApplyList();
      };

      ctrl.duplicate = function (data) {
        ctrl.onDuplicate({ data: data });
      };

      ctrl.update = function (data) {
        ctrl.onUpdate({ data: data });
      };

      ctrl.delete = function (data) {
        ctrl.onDelete({ data: data });
      };

      ctrl.filterData = function (item, attributeName) {
        return $rootScope.findObjectByKey(
          item.data,
          "attributeName",
          attributeName
        );
      };

      ctrl.dragStart = function (index) {
        ctrl.dragStartIndex = index;
        ctrl.minPriority = ctrl.data[0].priority;
      };
      ctrl.updateOrders = function (index, items) {
        if (index > ctrl.dragStartIndex) {
          ctrl.data.splice(ctrl.dragStartIndex, 1);
        } else {
          ctrl.data.splice(ctrl.dragStartIndex + 1, 1);
        }
        ctrl.updateDataInfos();
      };
      ctrl.updateDataInfos = async function () {
        angular.forEach(ctrl.data, async function (e, i) {
          e.priority = ctrl.minPriority + i;
          var resp = await dataService.saveFields(e.id, {
            priority: e.priority,
          });
          if (resp && resp.isSucceed) {
            $scope.activedPage = resp.data;
          } else {
            if (resp) {
              $rootScope.showErrors(resp.errors);
            }
          }
        });
      };

      ctrl.view = function (item) {
        var obj = {
          columns: ctrl.columns,
          item: item,
        };
        $rootScope.preview("mix-database-data", obj, null, "modal-lg");
      };
    },
  ],
});

modules.component("mixDatabaseForm", {
  templateUrl:
    "/mix-app/views/app-portal/components/mix-database-form/view.html",
  bindings: {
    mixDatabaseId: "=",
    mixDatabaseName: "=?",
    mixDatabaseTitle: "=?",
    columns: "=?",
    mixDatabaseDataId: "=?",
    mixDatabaseData: "=",
    parentType: "=?", // attribute set = 1 | post = 2 | page = 3 | module = 4
    parentId: "=?",
    defaultId: "=",
    backUrl: "=?",
    level: "=?",
    hideAction: "=?",
    saveSuccess: "&?",
  },
  controller: [
    "$rootScope",
    "$scope",
    "$location",
    "$routeParams",
    "RestMixDatabasePortalService",
    "RestMixDatabaseDataPortalService",
    function (
      $rootScope,
      $scope,
      $location,
      $routeParams,
      databaseService,
      service
    ) {
      var ctrl = this;
      ctrl.isBusy = false;
      ctrl.attributes = [];
      ctrl.isInRole = $rootScope.isInRole;
      ctrl.defaultData = null;
      ctrl.selectedProp = null;
      ctrl.localizeSettings = $rootScope.globalSettings;
      ctrl.$onInit = async function () {
        ctrl.level = ctrl.level || 0;
        await ctrl.loadData();
      };
      ctrl.loadData = async function () {
        /*
            If input is data id => load ctrl.mixDatabaseData from service and handle it independently
        */
        ctrl.isBusy = true;
        var getDatabase = await databaseService.getSingle([ctrl.mixDatabaseId]);
        ctrl.mixDatabase = getDatabase.data;

        if (ctrl.mixDatabaseDataId) {
          var getData = await service.getSingle([ctrl.mixDatabaseDataId]);
          ctrl.mixDatabaseData = getData.data;
          if (ctrl.mixDatabaseData) {
            ctrl.mixDatabaseData.parentId = ctrl.parentId;
            ctrl.mixDatabaseData.parentType = ctrl.parentType;
            ctrl.mixDatabaseId = ctrl.mixDatabaseData.mixDatabaseId;
            ctrl.mixDatabaseName = ctrl.mixDatabaseData.mixDatabaseName;
            ctrl.mixDatabaseTitle =
              ctrl.mixDatabaseTitle ||
              $routeParams.mixDatabaseTitle ||
              ctrl.mixDatabaseName;
            await ctrl.loadDefaultModel();
            ctrl.isBusy = false;
            $scope.$apply();
          } else {
            if (getData) {
              $rootScope.showErrors(getData.errors);
            }
            ctrl.isBusy = false;
            $scope.$apply();
          }
        }
        if (ctrl.mixDatabaseName || ctrl.mixDatabaseId) {
          var getDatabase = await databaseService.getSingle([
            ctrl.mixDatabaseId,
          ]);
          ctrl.mixDatabase = getDatabase.data;
          await ctrl.loadDefaultModel();
          ctrl.childBackUrl = $location.url();
          ctrl.backUrl =
            ctrl.backUrl ??
            `/portal/mix-database-data/list?mixDatabaseId=${ctrl.mixDatabase.id}&mixDatabaseName=${ctrl.mixDatabase.name}&mixDatabaseTitle=${ctrl.mixDatabase.title}`;
          ctrl.isBusy = false;
          $scope.$apply();
        }
      };
      ctrl.loadDefaultModel = async function () {
        if ($routeParams.parentId) {
          ctrl.parentId = $routeParams.parentId;
        }
        if ($routeParams.parentType) {
          ctrl.parentType = $routeParams.parentType;
        }
        if (!ctrl.backUrl) {
          if (ctrl.parentType) {
            switch (ctrl.parentType) {
              case "Post":
              case "Page":
              case "Module":
                ctrl.backUrl =
                  ctrl.backUrl ??
                  `/portal/${ctrl.parentType.toLowerCase()}/details/${
                    ctrl.parentId
                  }`;
                break;

              default:
                ctrl.backUrl =
                  ctrl.backUrl ??
                  `/portal/mix-database-data/details?dataId=${ctrl.parentId}&mixDatabaseId=${ctrl.mixDatabaseId}&mixDatabaseName=${ctrl.mixDatabaseName}&mixDatabaseTitle=${$routeParams.mixDatabaseTitle}`;
                break;
            }
          }
        }
        var getDefault = await service.initData(
          ctrl.mixDatabaseName || ctrl.mixDatabaseId
        );
        ctrl.defaultData = getDefault.data;
        if (ctrl.defaultData) {
          ctrl.defaultData.mixDatabaseId = ctrl.mixDatabaseId || 0;
          ctrl.defaultData.mixDatabaseName = ctrl.mixDatabaseName;
          ctrl.defaultData.parentId = ctrl.parentId;
          ctrl.defaultData.parentType = ctrl.parentType;

          ctrl.columns = ctrl.columns || ctrl.defaultData.columns;
        }

        if (!ctrl.mixDatabaseData) {
          ctrl.mixDatabaseData = angular.copy(ctrl.defaultData);
        }
      };

      ctrl.reload = async function () {
        ctrl.mixDatabaseData = angular.copy(ctrl.defaultData);
      };
      ctrl.loadSelected = function () {
        if (ctrl.selectedList.data.length) {
          ctrl.mixDatabaseData = ctrl.selectedList.data[0];
          ctrl.mixDatabaseData.mixDatabaseId = ctrl.mixDatabaseId;
          ctrl.mixDatabaseData.mixDatabaseName = ctrl.mixDatabaseName;
          ctrl.mixDatabaseData.parentId = ctrl.parentId;
          ctrl.mixDatabaseData.parentType = ctrl.parentType;
        }
      };
      ctrl.submit = async function () {
        if (ctrl.validate()) {
          ctrl.isBusy = true;

          var saveResult = await service.save(ctrl.mixDatabaseData);
          if (saveResult.isSucceed) {
            ctrl.mixDatabaseData = saveResult.data;
            if (ctrl.saveSuccess) {
              ctrl.saveSuccess({ data: ctrl.mixDatabaseData });
            }
            ctrl.isBusy = false;
            $rootScope.showMessage("success");
            $scope.$apply();
          } else {
            ctrl.isBusy = false;
            if (saveResult) {
              $rootScope.showErrors(saveResult.errors);
            }
            $scope.$apply();
          }
        }
      };
      ctrl.validate = function () {
        var isValid = true;
        ctrl.errors = [];
        angular.forEach(ctrl.columns, function (column) {
          if (column.regex) {
            var regex = RegExp(column.regex, "g");
            isValid = regex.test(ctrl.mixDatabaseData.obj[column.name]);
            if (!isValid) {
              ctrl.errors.push(`${column.name} is not match Regex`);
            }
          }
          if (!isValid) {
            $rootScope.showErrors(ctrl.errors);
          }
          if (isValid && column.isEncrypt) {
            ctrl.mixDatabaseData.obj[column.name] = $rootScope.encrypt(
              ctrl.mixDatabaseData.obj[column.name]
            );
          }
        });
        return isValid;
      };
      ctrl.showContentFilter = function ($event) {
        $rootScope.showContentFilter(ctrl.loadSelectedLink);
      };
      ctrl.loadSelectedLink = function (data, type) {
        if (data) {
          ctrl.mixDatabaseData.obj.target_id = data.id;
          ctrl.mixDatabaseData.obj.title = data.title;
          ctrl.mixDatabaseData.obj.type = type;
          ctrl.mixDatabaseData.obj.uri = data.detailsUrl;
        }
      };
      ctrl.filterData = function (attributeName) {
        if (ctrl.mixDatabaseData) {
          var attr = $rootScope.findObjectByKey(
            ctrl.mixDatabaseData.obj,
            "mixDatabaseColumnName",
            attributeName
          );
          if (!attr) {
            attr = angular.copy(
              $rootScope.findObjectByKey(
                ctrl.defaultData.data,
                "mixDatabaseColumnName",
                attributeName
              )
            );
            mixDatabaseColumn;
            ctrl.mixDatabaseData.obj.push(attr);
          }
          return attr;
        }
      };
    },
  ],
});

modules.component("mixDatabaseNavData", {
  templateUrl:
    "/mix-app/views/app-portal/components/mix-database-nav-data/view.html",
  bindings: {
    nav: "=",
    parentId: "=",
    parentType: "=",
    onUpdate: "&?",
    onDelete: "&?",
  },
  controller: [
    "$rootScope",
    "$scope",
    "ngAppSettings",
    "RestRelatedAttributeDataPortalService",
    "RestMixDatabaseDataPortalService",
    function ($rootScope, $scope, ngAppSettings, navService, dataService) {
      var ctrl = this;
      ctrl.data = null;
      ctrl.selected = null;
      ctrl.navRequest = angular.copy(ngAppSettings.request);
      ctrl.setRequest = angular.copy(ngAppSettings.request);
      ctrl.localizeSettings = $rootScope.globalSettings;
      ctrl.$onInit = function () {
        navService
          .getDefault([ctrl.parentId, ctrl.parentType, "default"])
          .then((resp) => {
            ctrl.defaultData = resp.data;
            ctrl.defaultData.parentId = ctrl.parentId;
            ctrl.defaultData.parentType = ctrl.parentType;
            ctrl.selected = angular.copy(ctrl.defaultData);
            ctrl.loadData();
          });
        ctrl.navRequest.parentType = ctrl.parentType;
        ctrl.navRequest.parentId = ctrl.parentId;
      };
      ctrl.selectPane = function (pane) {};
      ctrl.loadData = function () {
        navService.getList(ctrl.navRequest).then((resp) => {
          if (resp) {
            ctrl.data = resp.data;
            $scope.$apply();
          } else {
            if (resp) {
              $rootScope.showErrors("Failed");
            }
            $scope.$apply();
          }
        });
      };
      ctrl.updateData = function (nav) {
        ctrl.selected = nav;
        var e = $(".pane-form-" + ctrl.nav.data.id)[0];
        angular.element(e).triggerHandler("click");
        // $location.url('/portal/mix-database-data/details?dataId='+ item.id +'&mixDatabaseId=' + item.mixDatabaseId+'&parentType=' + item.parentType+'&parentId=' + item.parentId);
      };
      ctrl.saveData = function (data) {
        $rootScope.isBusy = true;
        ctrl.selected.data = data;
        dataService.save(data).then((resp) => {
          if (resp.isSucceed) {
            ctrl.selected.dataId = resp.data.id;
            ctrl.selected.mixDatabaseId = resp.data.mixDatabaseId;
            ctrl.selected.mixDatabaseName = resp.data.mixDatabaseName;
            ctrl.selected.attributeData = resp.data;
            navService.save(ctrl.selected).then((resp) => {
              if (resp.isSucceed) {
                var tmp = $rootScope.findObjectByKey(
                  ctrl.data,
                  ["parentId", "parentType", "id"],
                  [resp.data.parentId, resp.data.parentType, resp.data.id]
                );
                if (!tmp) {
                  ctrl.data.items.push(resp.data);
                  var e = $(".pane-data-" + ctrl.nav.data.id)[0];
                  angular.element(e).triggerHandler("click");
                }
                ctrl.selected = angular.copy(ctrl.defautData);
                $rootScope.isBusy = false;
                $scope.$apply();
              } else {
                $rootScope.showMessage("failed");
                $rootScope.isBusy = false;
                $scope.$apply();
              }
            });
          } else {
            $rootScope.showMessage("failed");
            $rootScope.isBusy = false;
            $scope.$apply();
          }
        });
      };
      ctrl.removeData = async function (nav) {
        $rootScope.showConfirm(
          ctrl,
          "removeDataConfirmed",
          [nav],
          null,
          "Remove",
          "Deleted data will not able to recover, are you sure you want to delete this item?"
        );
      };
      ctrl.removeDataConfirmed = async function (nav) {
        $rootScope.isBusy = true;
        var result = await navService.delete([nav.id]);
        if (result.isSucceed) {
          $rootScope.removeObjectByKey(ctrl.data, "id", nav.id);
          $rootScope.isBusy = false;
          $scope.$apply();
        } else {
          $rootScope.showMessage("failed");
          $rootScope.isBusy = false;
          $scope.$apply();
        }
      };
      ctrl.dragStart = function (index) {
        ctrl.dragStartIndex = index;
        ctrl.minPriority = ctrl.data[0].priority;
      };
      ctrl.updateOrders = function (index) {
        if (index > ctrl.dragStartIndex) {
          ctrl.data.splice(ctrl.dragStartIndex, 1);
        } else {
          ctrl.data.splice(ctrl.dragStartIndex + 1, 1);
        }
        var arrNavs = [];
        angular.forEach(ctrl.data, function (e, i) {
          e.priority = ctrl.minPriority + i;
          var keys = {
            parentId: e.parentId,
            parentType: e.parentType,
            id: e.id,
          };
          var properties = {
            priority: e.priority,
          };
          arrNavs.push({
            keys: keys,
            properties: properties,
          });
        });
        navService.saveProperties("portal", arrNavs).then((resp) => {
          $rootScope.isBusy = false;
          $scope.$apply();
        });
      };
    },
  ],
});

modules.component("mixDatabaseNavValues", {
  templateUrl:
    "/mix-app/views/app-portal/components/mix-database-nav-values/view.html",
  bindings: {
    mixDatabaseId: "=?",
    mixDatabaseName: "=?",
    parentId: "=",
    parentType: "=",
    columns: "=?",
    header: "=",
    data: "=?",
    maxCol: "=?",
    createUrl: "=?",
    updateUrl: "=?",
    backUrl: "=?",
    onUpdate: "&?",
    onDelete: "&?",
  },
  controller: [
    "$rootScope",
    "$scope",
    "ngAppSettings",
    "RestRelatedAttributeDataPortalService",
    "RestMixDatabaseColumnPortalService",
    function ($rootScope, $scope, ngAppSettings, navService, columnService) {
      var ctrl = this;
      ctrl.selectedProp = null;
      ctrl.request = angular.copy(ngAppSettings.restRequest);
      ctrl.request.orderBy = "Priority";
      ctrl.request.query = "{}";

      ctrl.request.direction = 0;
      ctrl.localizeSettings = $rootScope.globalSettings;
      ctrl.$onInit = async function () {
        ctrl.maxCol = ctrl.maxCol || 3;
        if (!ctrl.columns) {
          var getFields = await columnService.initData(
            ctrl.mixDatabaseName || ctrl.mixDatabaseId
          );
          if (getFields.isSucceed) {
            ctrl.columns = getFields.data;
            ctrl.mixDatabaseTitle = ctrl.columns[0].mixDatabaseName;
            ctrl.mixDatabaseName = ctrl.columns[0].mixDatabaseName;
            ctrl.mixDatabaseId = ctrl.columns[0].mixDatabaseId;
            $scope.$apply();
          }
        }
        if (!ctrl.data) {
          ctrl.loadData();
        }
        ctrl.buildCreateUrl();
      };
      ctrl.buildCreateUrl = function () {
        var backUrl = encodeURI(
          `/portal/mix-database-data/details?dataId=${ctrl.parentId}`
        );
        ctrl.createUrl = `/portal/mix-database-data/create?mixDatabaseId=${ctrl.mixDatabaseId}&dataId=default&parentId=${ctrl.parentId}&parentType=Set&mixDatabaseTitle=${ctrl.mixDatabaseTitle}&backUrl=${backUrl}`;
      };
      ctrl.update = function (data) {
        ctrl.onUpdate({ data: data });
      };

      ctrl.delete = function (data) {
        ctrl.onDelete({ data: data });
      };

      ctrl.filterData = function (item, attributeName) {
        return $rootScope.findObjectByKey(
          item.data,
          "attributeName",
          attributeName
        );
      };

      ctrl.dragStart = function (index) {
        ctrl.dragStartIndex = index;
        ctrl.minPriority = ctrl.data.items[0].priority;
      };
      ctrl.updateOrders = function (index) {
        if (index > ctrl.dragStartIndex) {
          ctrl.data.items.splice(ctrl.dragStartIndex, 1);
        } else {
          ctrl.data.items.splice(ctrl.dragStartIndex + 1, 1);
        }
        angular.forEach(ctrl.data.items, function (e, i) {
          e.priority = ctrl.minPriority + i;
          navService.saveFields(e.id, { priority: e.priority }).then((resp) => {
            $rootScope.isBusy = false;
            $scope.$apply();
          });
        });
      };

      ctrl.loadData = function () {
        ctrl.request.mixDatabaseId = ctrl.mixDatabaseId || 0;
        ctrl.request.mixDatabaseName = ctrl.mixDatabaseName || null;
        ctrl.request.parentId = ctrl.parentId;
        ctrl.request.parentType = ctrl.parentType;
        navService.getList(ctrl.request).then((resp) => {
          if (resp) {
            ctrl.data = resp.data;
            $rootScope.isBusy = false;
            $scope.$apply();
          } else {
            if (resp) {
              $rootScope.showErrors("Failed");
            }
            ctrl.refData = [];
            $rootScope.isBusy = false;
            $scope.$apply();
          }
        });
      };
      ctrl.updateData = function (nav) {
        var backUrl = encodeURI(
          `/portal/mix-database-data/details?dataId=${ctrl.parentId}`
        );
        $rootScope.goToPath(
          `${ctrl.updateUrl}?dataId=${nav.dataId}&mixDatabaseId=${nav.mixDatabaseId}&parentId=${ctrl.parentId}&parentType=${ctrl.parentType}&backUrl=${backUrl}`
        );
        // ctrl.refDataModel = nav;
        // var e = $(".pane-form-" + ctrl.mixDatabaseDataValue.column.referenceId)[0];
        // angular.element(e).triggerHandler('click');
        // $location.url('/portal/mix-database-data/details?dataId='+ item.id +'&mixDatabaseId=' + item.mixDatabaseId+'&parentType=' + item.parentType+'&parentId=' + item.parentId);
      };
      ctrl.saveData = function (data) {
        $rootScope.isBusy = true;
        ctrl.refDataModel.data = data;
        dataService.save("portal", data).then((resp) => {
          if (resp.isSucceed) {
            ctrl.refDataModel.id = resp.data.id;
            ctrl.refDataModel.data = resp.data;
            navService.save("portal", ctrl.refDataModel).then((resp) => {
              if (resp.isSucceed) {
                var tmp = $rootScope.findObjectByKey(
                  ctrl.refData,
                  ["parentId", "parentType", "id"],
                  [resp.data.parentId, resp.data.parentType, resp.data.id]
                );
                if (!tmp) {
                  ctrl.refData.push(resp.data);
                }
                ctrl.refDataModel = angular.copy(ctrl.defaultDataModel);
                var e = $(
                  ".pane-data-" + ctrl.mixDatabaseDataValue.column.referenceId
                )[0];
                angular.element(e).triggerHandler("click");
                $rootScope.isBusy = false;
                $scope.$apply();
              } else {
                $rootScope.showMessage("failed");
                $rootScope.isBusy = false;
                $scope.$apply();
              }
            });
          } else {
            $rootScope.showMessage("failed");
            $rootScope.isBusy = false;
            $scope.$apply();
          }
        });
      };
      ctrl.removeData = async function (nav) {
        $rootScope.showConfirm(
          ctrl,
          "removeDataConfirmed",
          [nav],
          null,
          "Remove",
          "Deleted data will not able to recover, are you sure you want to delete this item?"
        );
      };
      ctrl.removeDataConfirmed = async function (nav) {
        $rootScope.isBusy = true;
        var result = await navService.delete([nav.id]);
        if (result.isSucceed) {
          $rootScope.removeObjectByKey(ctrl.data.items, "id", nav.id);
          $rootScope.isBusy = false;
          $scope.$apply();
        } else {
          $rootScope.showMessage("failed");
          $rootScope.isBusy = false;
          $scope.$apply();
        }
      };
      ctrl.view = function (item) {
        var obj = {
          columns: ctrl.columns,
          item: item,
        };
        $rootScope.preview("mix-database-data", obj, null, "modal-lg");
      };
    },
  ],
});

modules.component("mixDatabaseNavs", {
  templateUrl:
    "/mix-app/views/app-portal/components/mix-database-navs/view.html",
  bindings: {
    parentId: "=",
    parentType: "=",
    mixDatabaseNavs: "=?",
    onUpdate: "&?",
    onDelete: "&?",
  },
  controller: [
    "$rootScope",
    "$scope",
    "ngAppSettings",
    "RestRelatedMixDatabasePortalService",
    "RestMixDatabasePortalService",
    function ($rootScope, $scope, ngAppSettings, navService, setService) {
      var ctrl = this;
      ctrl.mixDatabaseNavs = ctrl.mixDatabaseNavs || [];
      ctrl.selected = {};
      ctrl.defaultData = null;
      ctrl.navRequest = angular.copy(ngAppSettings.request);
      ctrl.setRequest = angular.copy(ngAppSettings.request);

      ctrl.localizeSettings = $rootScope.globalSettings;
      ctrl.$onInit = function () {
        // ctrl.setRequest.type = ctrl.parentType;
        navService.getDefault().then((resp) => {
          resp.parentId = ctrl.parentId;
          resp.parentType = ctrl.parentType;
          ctrl.defaultData = resp;
          ctrl.loadData();
        });
      };
      ctrl.goToPath = $rootScope.goToPath;
      ctrl.selectPane = function (pane) {};
      ctrl.loadData = async function () {
        // Load attr set navs if not in input
        if (!ctrl.mixDatabaseNavs) {
          ctrl.navRequest.parentType = ctrl.parentType;
          ctrl.navRequest.parentId = ctrl.parentId;
          var resp = await navService.getList(ctrl.navRequest);
          if (resp) {
            angular.forEach(resp.data.items, (e) => {
              e.isActived = true;
              ctrl.mixDatabaseNavs.push(e);
            });
          } else {
            if (resp) {
              $rootScope.showErrors(resp.errors);
            }
          }
        } else {
          angular.forEach(ctrl.mixDatabaseNavs, (e) => {
            e.isActived = true;
          });
        }

        var setResult = await setService.getList(ctrl.setRequest);
        if (setResult) {
          angular.forEach(setResult.data.items, (element) => {
            var e = $rootScope.findObjectByKey(
              ctrl.mixDatabaseNavs,
              "mixDatabaseId",
              element.id
            );
            if (!e) {
              e = angular.copy(ctrl.defaultData);
              e.status = "Published";
              e.mixDatabaseId = element.id;
              e.specificulture = navService.lang;
              e.data = element;
              e.isActived = false;
              ctrl.mixDatabaseNavs.push(e);
            }
          });
        } else {
          if (setResult) {
            $rootScope.showErrors("Others Failed");
          }
        }
        $scope.$apply();
      };
      ctrl.change = async function (nav) {
        $rootScope.isBusy = true;
        var result;
        if (nav.isActived) {
          ctrl.active(nav);
        } else {
          ctrl.deactive(nav);
        }
      };

      ctrl.deactive = async function (nav) {
        let result = null;
        if (nav.id) {
          result = await navService.delete([nav.id]);
          $(".pane-container-" + nav.data.id)
            .parent()
            .remove();
        }
        if (result && result.isSucceed) {
          $rootScope.isBusy = false;
          $scope.$apply();
        } else {
          $rootScope.showMessage("failed");
          $rootScope.isBusy = false;
        }
      };

      ctrl.active = async function (nav) {
        $rootScope.isBusy = true;
        var result;
        result = await navService.save(nav);
        if (result && result.isSucceed) {
          $rootScope.isBusy = false;
          $scope.$apply();
        } else {
          $rootScope.showMessage("failed");
          $rootScope.isBusy = false;
          $scope.$apply();
        }
      };

      ctrl.update = function (data) {
        ctrl.onUpdate({
          data: data,
        });
      };

      ctrl.delete = function (data) {
        ctrl.onDelete({
          data: data,
        });
      };

      ctrl.dragStart = function (index) {
        ctrl.dragStartIndex = index;
        ctrl.minPriority = ctrl.mixDatabaseNavs[0].priority;
      };
      ctrl.updateOrders = function (index) {
        if (index > ctrl.dragStartIndex) {
          ctrl.mixDatabaseNavs.splice(ctrl.dragStartIndex, 1);
        } else {
          ctrl.mixDatabaseNavs.splice(ctrl.dragStartIndex + 1, 1);
        }
        var arrNavs = [];
        angular.forEach(ctrl.mixDatabaseNavs, function (e, i) {
          e.priority = ctrl.minPriority + i;
          var keys = {
            parentId: e.parentId,
            parentType: e.parentType,
            id: e.id,
          };
          var properties = {
            priority: e.priority,
          };
          arrNavs.push({
            keys: keys,
            properties: properties,
          });
        });
        navService.saveProperties("portal", arrNavs).then((resp) => {
          $rootScope.isBusy = false;
          $scope.$apply();
        });
      };
    },
  ],
});

modules.component("mixFileUpload", {
  templateUrl: "/mix-app/views/app-portal/components/mix-file-upload/view.html",
  bindings: {
    folder: "=?",
    accept: "=?",
    onFail: "&?",
    onSuccess: "&?",
  },
  controller: [
    "$rootScope",
    "$scope",
    "ngAppSettings",
    "FileServices",
    function ($rootScope, $scope, ngAppSettings, fileService) {
      var ctrl = this;
      ctrl.mediaFile = {};
      ctrl.isAdmin = $rootScope.isAdmin;
      ctrl.mediaNavs = [];
      ctrl.$onInit = function () {
        ctrl.id = Math.floor(Math.random() * 100);
      };
      ctrl.selectFile = function (files) {
        if (files !== undefined && files !== null && files.length > 0) {
          const file = files[0];
          ctrl.file = file;
          ctrl.mediaFile.folder = ctrl.folder ? ctrl.folder : "Media";
          ctrl.mediaFile.title = ctrl.title ? ctrl.title : "";
          ctrl.mediaFile.description = ctrl.description ? ctrl.description : "";
          ctrl.mediaFile.file = file;
          if (ctrl.auto == "true") {
            ctrl.uploadFile(file);
          } else {
            ctrl.getBase64(file);
          }
        }
      };

      ctrl.getBase64 = function (file) {
        if (file !== null) {
          $rootScope.isBusy = true;
          var reader = new FileReader();
          reader.readAsDataURL(file);
          reader.onload = function () {
            if (ctrl.mediaFile) {
              ctrl.mediaFile.fileName = file.name.substring(
                0,
                file.name.lastIndexOf(".")
              );
              ctrl.mediaFile.extension = file.name.substring(
                file.name.lastIndexOf(".")
              );
              ctrl.mediaFile.fileStream = reader.result;
            }
            $rootScope.isBusy = false;
            $scope.$apply();
          };
          reader.onerror = function (error) {
            $rootScope.isBusy = false;
            $rootScope.showErrors([error]);
          };
        } else {
          return null;
        }
      };

      ctrl.uploadFile = async function () {
        if (ctrl.file) {
          $rootScope.isBusy = true;
          var response = await fileService.uploadFile(ctrl.file, ctrl.folder);
          if (response) {
            if (ctrl.onSuccess) {
              ctrl.onSuccess();
            }
            $rootScope.showMessage("success", "success");
            $rootScope.isBusy = false;
            $scope.$apply();
          } else {
            $rootScope.showErrors(['Cannot upload file']);
            $rootScope.isBusy = false;
            $scope.$apply();
          }
        } else {
          $rootScope.showErrors(["Please choose file"]);
        }
      };
    },
  ],
});

"use strict";
app.controller("MixNavigationController", [
  "$scope",
  "$rootScope",
  "ngAppSettings",
  "$routeParams",
  "MediaService",
  "ApiService",
  "CommonService",
  function (
    $scope,
    $rootScope,
    ngAppSettings,
    $routeParams,
    service,
    apiService,
    commonService
  ) {
    BaseCtrl.call(
      this,
      $scope,
      $rootScope,
      $routeParams,
      ngAppSettings,
      service
    );

    $scope.viewmodel = {
      title: "",
      description: "",
      status: "Published",
      mediaFile: {
        file: null,
        fullPath: "",
        folderName: "Media",
        fileFolder: "",
        fileName: "",
        extension: "",
        content: "",
        fileStream: "",
      },
    };
    $scope.relatedMedias = [];
    $scope.uploadMedia = async function () {
      $rootScope.isBusy = true;
      var resp = await service.uploadMedia($scope.mediaFile);
      if (resp && resp.isSucceed) {
        $scope.activedMedia = resp.data;
        $scope.getList();
        $scope.$apply();
      } else {
        if (resp) {
          $rootScope.showErrors(resp.errors);
        }
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };
    $scope.selectFile = function (file, errFiles) {
      if (file !== undefined && file !== null) {
        $scope.mediaFile.folder = "Media";
        $scope.mediaFile.file = file;
        $scope.getBase64(file);
      }
    };
    $scope.getBase64 = function (file) {
      if (file !== null && $scope.postedFile) {
        $rootScope.isBusy = true;
        var reader = new FileReader();
        reader.readAsDataURL(file);
        reader.onload = function () {
          var index = reader.result.indexOf(",") + 1;
          var base64 = reader.result.substring(index);
          $scope.activedMedia.mediaFile.fileName = $rootScope.generateKeyword(
            file.name.substring(0, file.name.lastIndexOf(".")),
            "-"
          );
          $scope.activedMedia.mediaFile.extension = file.name.substring(
            file.name.lastIndexOf(".")
          );
          $scope.activedMedia.mediaFile.fileStream = reader.result;
          $rootScope.isBusy = false;
          $scope.$apply();
        };
        reader.onerror = function (error) {
          $rootScope.showErrors([error]);
          $rootScope.isBusy = false;
        };
      } else {
        return null;
      }
    };
    $scope.togglePreview = function (item) {
      item.isPreview = item.isPreview === undefined ? true : !item.isPreview;
    };
    $scope.clone = async function (id) {
      $rootScope.isBusy = true;
      var resp = await service.cloneMedia(id);
      if (resp && resp.isSucceed) {
        $scope.activedMedia = resp.data;
        $rootScope.showMessage("Update successfully!", "success");
        $rootScope.isBusy = false;
        $scope.$apply();
        //$location.path('/portal/media/details/' + resp.data.id);
      } else {
        if (resp) {
          $rootScope.showErrors(resp.errors);
        }
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };
    $scope.saveSuccessCallback = function () {
      $scope.getList();
    };
    $scope.removeCallback = function () {
      $scope.getList();
    };
  },
]);

modules.component("mixSelectIcons", {
  templateUrl:
    "/mix-app/views/app-portal/components/mix-select-icons/mix-select-icons.html",
  controller: [
    "$rootScope",
    "$scope",
    "$location",
    "$element",
    function ($rootScope, $scope, $location, $element) {
      var ctrl = this;
      ctrl.limitTo = 20;
      ctrl.container = $element[0].querySelector(".list-icon");
      ctrl.translate = function (keyword) {
        return $rootScope.translate(keyword);
      };
      ctrl.showMore = () => {
        if (
          ctrl.container.scrollTop >= ctrl.container.scrollHeight - 200 &&
          ctrl.limitTo < ctrl.options.length
        ) {
          ctrl.limitTo *= 2;
        }
      };
      ctrl.select = function (ico) {
        ctrl.data = ico.class;
      };
    },
  ],
  bindings: {
    data: "=",
    prefix: "=",
    options: "=",
  },
});

modules.component("mixValueEditor", {
  templateUrl:
    "/mix-app/views/app-portal/components/mix-value-editor/view.html",
  bindings: {
    title: "=?",
    isSelect: "=?",
    stringValue: "=",
    type: "=",
  },
  controller: [
    "$rootScope",
    "$scope",
    "ngAppSettings",
    "$location",
    "RestMixDatabaseDataPortalService",
    function ($rootScope, $scope, ngAppSettings, $location, dataService) {
      var ctrl = this;
      ctrl.icons = ngAppSettings.icons;
      ctrl.refData = [];
      ctrl.refRequest = angular.copy(ngAppSettings.request);
      ctrl.refRequest.pageSize = 100;
      ctrl.dataTypes = $rootScope.globalSettings.dataTypes;
      ctrl.previousId = null;
      ctrl.initData = async function () {
        setTimeout(() => {
          switch (ctrl.type) {
            case "datetime":
            case "date":
            case "time":
              if (ctrl.stringValue) {
                ctrl.dateObj = new Date(ctrl.stringValue);
                $scope.$apply();
              }
              break;
            case "boolean":
              if (ctrl.stringValue) {
                ctrl.booleanValue = ctrl.stringValue == "true";
              }
              break;

            case "reference": // reference
              if (ctrl.referenceId) {
                ctrl.refRequest.mixDatabaseId = ctrl.referenceId;
                ctrl.refRequest.parentType = ctrl.parentType;
                ctrl.refRequest.parentId = ctrl.parentId;

                dataService.getList(ctrl.refRequest).then((resp) => {
                  if (resp) {
                    ctrl.refData = resp;
                    $rootScope.isBusy = false;
                    $scope.$apply();
                  } else {
                    if (resp) {
                      $rootScope.showErrors("Failed");
                    }
                    $rootScope.isBusy = false;
                    $scope.$apply();
                  }
                });
              }
              break;
            default:
              if (ctrl.isEncrypt && ctrl.encryptValue) {
                var encryptedData = {
                  key: ctrl.encryptKey,
                  data: ctrl.encryptValue,
                };
                ctrl.stringValue = $rootScope.decrypt(encryptedData);
              }
              break;
          }
        }, 200);
      };
      ctrl.updateStringValue = async function (dataType) {
        switch (dataType) {
          case "datetime":
          case "date":
          case "time":
            if (ctrl.dateObj != null) {
              ctrl.stringValue = ctrl.dateObj.toISOString();
            } else {
              ctrl.stringValue = null;
            }
            break;
          case "double":
            // ctrl.stringValue = ctrl.doubleValue;
            break;
          case "boolean":
            // ctrl.stringValue = ctrl.booleanValue;
            break;

          default:
            ctrl.stringValue = ctrl.doubleValue;
            break;
        }
      };
      ctrl.updateRefData = function (item) {
        $location.url(
          "/portal/mix-database-data/details?dataId=" +
            item.id +
            "&mixDatabaseId=" +
            item.mixDatabaseId +
            "&parentType=" +
            item.parentType +
            "&parentId=" +
            item.parentId
        );
      };
      ctrl.removeRefData = async function (data) {
        $rootScope.showConfirm(
          ctrl,
          "removeRefDataConfirmed",
          [data.id],
          null,
          "Remove",
          "Deleted data will not able to recover, are you sure you want to delete this item?"
        );
      };
      ctrl.removeRefDataConfirmed = async function (dataId) {
        $rootScope.isBusy = true;
        var result = await dataService.delete(dataId);
        if (result.isSucceed) {
          $rootScope.removeObjectByKey(ctrl.refData, "id", dataId);
          $rootScope.isBusy = false;
          $scope.$apply();
        } else {
          $rootScope.showMessage("failed");
          $rootScope.isBusy = false;
          $scope.$apply();
        }
      };
    },
  ],
});

modules.component("mixTemplateEditor", {
  templateUrl:
    "/mix-app/views/app-portal/components/mix-template-editor/view.html",
  bindings: {
    template: "=",
    folderType: "=",
    isReadonly: "=?",
    lineCount: "=?",
    hideJs: "=?",
    hideCss: "=?",
  },
  controller: [
    "$scope",
    "$rootScope",
    "$routeParams",
    "ngAppSettings",
    "GlobalSettingsService",
    "TemplateService",
    function (
      $scope,
      $rootScope,
      $routeParams,
      ngAppSettings,
      globalSettingsService,
      service
    ) {
      BaseCtrl.call(
        this,
        $scope,
        $rootScope,
        $routeParams,
        ngAppSettings,
        service
      );
      var ctrl = this;
      ctrl.isNull = false;
      ctrl.request = angular.copy(ngAppSettings.request);
      ctrl.selectPane = function (pane) {
        ctrl.activedPane = pane;
      };
      ctrl.selectTemplate = function (template) {
        ctrl.template = template;
        $scope.$broadcast("updateContentCodeEditors", []);
      };
      ctrl.new = function () {
        ctrl.template.id = 0;
      };
      ctrl.init = async function () {
        if (ctrl.folderType) {
          var themeId = $rootScope.localizeSettings.data.ThemeId;
          ctrl.request.key = ctrl.folderType;
          var resp = await service.getList(ctrl.request, [themeId]);

          if (resp && resp.isSucceed) {
            ctrl.templates = resp.data.items;
            if (!ctrl.template) {
              ctrl.template = ctrl.templates[0];
            }
            $rootScope.isBusy = false;
            $scope.$apply();
          } else {
            if (resp) {
              $rootScope.showErrors(resp.errors);
              $rootScope.isBusy = false;
              $scope.$apply();
            }
          }
        }
      };
      ctrl.updateTemplateContent = function (content) {
        ctrl.template.content = content;
      };
      ctrl.updateStyleContent = function (content) {
        ctrl.template.scripts = content;
      };
      ctrl.updateScriptContent = function (content) {
        ctrl.template.styles = content;
      };
    },
  ],
});

modules.component("modalBookmark", {
  templateUrl:
    "/mix-app/views/app-portal/components/modal-bookmark/modal-bookmark.html",
  controller: [
    "$rootScope",
    "$scope",
    "localStorageService",
    "$routeParams",
    "$location",
    function (
      $rootScope,
      $scope,
      localStorageService,
      $routeParams,
      $location
    ) {
      var ctrl = this;
      ctrl.searchText = "";
      ctrl.defaultModel = {
        url: "",
        title: "",
      };
      ctrl.bookmarks = [];
      ctrl.model = null;
      ctrl.$onInit = function () {
        ctrl.model = angular.copy(ctrl.defaultModel);
        ctrl.getCurrentUrl();
        ctrl.bookmarks = localStorageService.get("bookmarks") || [];
      };
      ctrl.goToPath = function (url) {
        $rootScope.goToPath(url);
        $("#dlg-bookmark").modal("hide");
      };
      ctrl.getCurrentUrl = function (url) {
        url = url || $location.url();
        ctrl.model.url = url;
        ctrl.model.title = url;
      };
      ctrl.removeBookmark = function (url) {
        $rootScope.removeObjectByKey(ctrl.bookmarks, "url", url);
        localStorageService.set("bookmarks", ctrl.bookmarks);
      };
      ctrl.addBookmark = function () {
        var current = $rootScope.findObjectByKey(
          ctrl.bookmarks,
          "url",
          ctrl.model.url
        );
        if (current) {
          current.title = ctrl.model.title;
        } else {
          ctrl.bookmarks.push(ctrl.model);
        }
        localStorageService.set("bookmarks", ctrl.bookmarks);
        ctrl.model = angular.copy(ctrl.defaultModel);
      };
    },
  ],
});

modules.component("modalContentFilter", {
  templateUrl:
    "/mix-app/views/app-portal/components/modal-content-filter/modal-content-filter.html",
  bindings: {
    query: "=",
    initData: "=?",
    selected: "=",
    callback: "&?",
    save: "&?",
  },
  controller: [
    "$rootScope",
    "$scope",
    "ngAppSettings",
    "PostRestService",
    "PageRestService",
    "ModuleRestService",
    function (
      $rootScope,
      $scope,
      ngAppSettings,
      postService,
      pageService,
      moduleService
    ) {
      var ctrl = this;
      ctrl.request = angular.copy(ngAppSettings.request);
      ctrl.types = ["Page", "Post", "Module"];
      ctrl.moduleId = null;
      ctrl.type = "Page";
      ctrl.navs = [];
      ctrl.data = {
        items: [],
      };
      // ctrl.goToPath = $rootScope.goToPath;
      ctrl.$onInit = function () {
        $("#modal-content-filter").on("shown.bs.modal", function () {
          if (ctrl.initData) {
            ctrl.data = ctrl.initData;
          } else {
            if (!ctrl.data.items.length) {
              ctrl.loadData();
            }
          }
        });
      };
      ctrl.closeDialog = function () {
        $("#modal-content-filter").modal("hide");
      };
      ctrl.loadData = async function (pageIndex) {
        ctrl.request.query = ctrl.query + ctrl.srcId;
        ctrl.navs = [];
        if (pageIndex !== undefined) {
          ctrl.request.pageIndex = pageIndex;
        }
        if (ctrl.request.fromDate !== null) {
          var d = new Date(ctrl.request.fromDate);
          ctrl.request.fromDate = d.toISOString();
        }
        if (ctrl.request.toDate !== null) {
          var d = new Date(ctrl.request.toDate);
          ctrl.request.toDate = d.toISOString();
        }

        switch (ctrl.type) {
          case "Page":
            ctrl.loadPages();
            break;
          case "Post":
            ctrl.loadPosts();
            break;
          case "Module":
            ctrl.loadModules();
            break;
        }
      };
      ctrl.edit = function (nav) {
        switch (ctrl.type) {
          case "Page":
            ctrl.goToPath(`/portal/page/details/${nav.id}`);
            break;
          case "Post":
            ctrl.goToPath(`/portal/post/details/${nav.id}`);
            break;
          case "Module":
            ctrl.goToPath(`/portal/module/details/${nav.id}`);
            break;
        }
      };
      ctrl.loadModules = async function () {
        $rootScope.isBusy = true;
        var response = await moduleService.getList(ctrl.request);
        if (response.isSucceed) {
          ctrl.data = response.data;
          $rootScope.isBusy = false;
          $scope.$apply();
        } else {
          $rootScope.showErrors(response.errors);
          $rootScope.isBusy = false;
          $scope.$apply();
        }
      };
      ctrl.loadPosts = async function () {
        $rootScope.isBusy = true;
        var response = await postService.getList(ctrl.request);
        if (response.isSucceed) {
          ctrl.data = response.data;
          $rootScope.isBusy = false;
          $scope.$apply();
        } else {
          $rootScope.showErrors(response.errors);
          $rootScope.isBusy = false;
          $scope.$apply();
        }
      };
      ctrl.loadPages = async function () {
        $rootScope.isBusy = true;
        var response = await pageService.getList(ctrl.request);
        if (response.isSucceed) {
          ctrl.data = response.data;
          $rootScope.isBusy = false;
          $scope.$apply();
        } else {
          $rootScope.showErrors(response.errors);
          $rootScope.isBusy = false;
          $scope.$apply();
        }
      };
      ctrl.select = function (nav) {
        var current = $rootScope.findObjectByKey(ctrl.data.items, "id", nav.id);
        if (!nav.isActive && ctrl.callback) {
          ctrl.callback({
            nav: nav,
            type: ctrl.type,
          });
        }
        if (ctrl.isMultiple) {
          current.isActive = !current.isActive;
        } else {
          if (!nav.isActive) {
            angular.forEach(ctrl.data.items, (element) => {
              element.isActive = false;
            });
          }
          current.isActive = !nav.isActive;
        }
      };
      ctrl.saveSelected = function () {
        ctrl.selected = $rootScope.filterArray(
          ctrl.data,
          ["isActived"],
          [true]
        );
        setTimeout(() => {
          ctrl.save().then(() => {
            ctrl.loadPosts();
          });
        }, 500);
      };
      ctrl.limString = function (str, max) {
        if (str) {
          return str.length > max ? str.substring(0, max) + " ..." : str;
        }
      };
    },
  ],
});

modules.component("modalHelper", {
  templateUrl:
    "/mix-app/views/app-portal/components/modal-helper/modal-helper.html",
  bindings: {
    url: "=?",
    title: "=?",
  },
  controller: [
    "$rootScope",
    "$scope",
    "localStorageService",
    "$routeParams",
    "$location",
    "$sce",
    function (
      $rootScope,
      $scope,
      localStorageService,
      $routeParams,
      $location,
      $sce
    ) {
      var ctrl = this;
      ctrl.$onInit = function () {
        $("#dev-helper-modal").on("shown.bs.modal", function () {
          if ($rootScope.helperUrl) {
            ctrl.trustedUrl = $sce.trustAsResourceUrl($rootScope.helperUrl);
            ctrl.title = "Developer Document";
          } else {
            ctrl.loadHelperUrl();
            ctrl.title = "Developer Document";
          }
          $rootScope.helperUrl = null;
          $scope.$apply();
        });
      };
      ctrl.loadHelperUrl = function () {
        var portalUrl = $location.url();
        // var portalabsUrl = $location.absUrl();
        var defaultUrl = "//docs.mixcore.org";
        ctrl.trustedUrl = $sce.trustAsResourceUrl(defaultUrl);

        if (portalUrl.startsWith("/portal")) {
          ctrl.trustedUrl = $sce.trustAsResourceUrl(
            defaultUrl + "/basic-administration-screens"
          );
        }
        if (
          portalUrl.startsWith("/portal/mix-database-data/list?mixDatabaseId=2")
        ) {
          ctrl.trustedUrl = $sce.trustAsResourceUrl(
            defaultUrl + "/basic-usage-navigation"
          );
        }
        if (portalUrl.startsWith("/portal/post")) {
          ctrl.trustedUrl = $sce.trustAsResourceUrl(
            defaultUrl + "/basic-usage-writing-posts"
          );
        }
        if (portalUrl.startsWith("/portal/page")) {
          ctrl.trustedUrl = $sce.trustAsResourceUrl(
            defaultUrl + "/basic-usage-page"
          );
        }
        if (portalUrl.startsWith("/portal/module")) {
          ctrl.trustedUrl = $sce.trustAsResourceUrl(
            defaultUrl + "/basic-usage-module"
          );
        }
        if (portalUrl.startsWith("/portal/mix-database")) {
          ctrl.trustedUrl = $sce.trustAsResourceUrl(
            defaultUrl + "/basic-usage-database"
          );
        }
        if (
          portalUrl.startsWith("/portal/mix-database-data/list?mixDatabaseId=7")
        ) {
          ctrl.trustedUrl = $sce.trustAsResourceUrl(
            defaultUrl + "/basic-usage-category"
          );
        }
        if (
          portalUrl.startsWith("/portal/mix-database-data/list?mixDatabaseId=8")
        ) {
          ctrl.trustedUrl = $sce.trustAsResourceUrl(
            defaultUrl + "/basic-usage-tag"
          );
        }
        if (portalUrl.startsWith("/portal/media")) {
          ctrl.trustedUrl = $sce.trustAsResourceUrl(
            defaultUrl + "/basic-usage-media"
          );
        }
        if (portalUrl.startsWith("/portal/file")) {
          ctrl.trustedUrl = $sce.trustAsResourceUrl(
            defaultUrl + "/basic-usage-file"
          );
        }
        if (portalUrl.startsWith("/portal/user")) {
          ctrl.trustedUrl = $sce.trustAsResourceUrl(
            defaultUrl + "/basic-usage-user"
          );
        }
        if (portalUrl.startsWith("/portal/theme")) {
          ctrl.trustedUrl = $sce.trustAsResourceUrl(
            defaultUrl + "/basic-usage-theme"
          );
        }
        if (portalUrl.startsWith("/portal/app-settings")) {
          ctrl.trustedUrl = $sce.trustAsResourceUrl(
            defaultUrl + "/basic-usage-app-settings"
          );
        }
        if (portalUrl.startsWith("/portal/configuration")) {
          ctrl.trustedUrl = $sce.trustAsResourceUrl(
            defaultUrl + "/basic-usage-configuration"
          );
        }
        if (portalUrl.startsWith("/portal/my-profile")) {
          ctrl.trustedUrl = $sce.trustAsResourceUrl(
            defaultUrl + "/basic-usage-users-profile"
          );
        }

        // switch (portalUrl) {
        //   case '/portal':
        //   default:
        //     ctrl.trustedUrl = $sce.trustAsResourceUrl(defaultUrl);
        //     break;
        // }
      };
    },
  ],
});

app.component("modalCroppie", {
  templateUrl: "/mix-app/views/app-portal/components/modal-croppie/view.html",
  bidings: {
    resolve: "<",
    close: "&",
    dismiss: "&",
  },
  controller: function () {
    var $ctrl = this;
    $ctrl.fileUrl = "test";
    $ctrl.$onInit = function () {
      $ctrl.file = $ctrl.resolve.file;
    };

    $ctrl.ok = function () {
      $ctrl.close({ $value: $ctrl.fileUrl });
    };

    $ctrl.cancel = function () {
      $ctrl.dismiss({ $value: "cancel" });
    };
  },
});

modules.component("modalNavDatas", {
  templateUrl: "/mix-app/views/app-portal/components/modal-nav-datas/view.html",
  bindings: {
    mixDatabaseId: "=?",
    mixDatabaseName: "=?",
    parentId: "=?",
    parentType: "=?",
    type: "=?",
    columnDisplay: "=?",
    selectedList: "=?",
    selectCallback: "&",
    save: "&",
  },
  controller: [
    "$rootScope",
    "$scope",
    "ngAppSettings",
    "RestMixDatabaseDataPortalService",
    "RestRelatedMixDatabasePortalService",
    function ($rootScope, $scope, ngAppSettings, service, navService) {
      var ctrl = this;
      ctrl.request = angular.copy(ngAppSettings.request);
      ctrl.request.key = "readData";
      ctrl.navs = [];

      ctrl.queries = {};
      ctrl.data = { items: [] };
      ctrl.$onInit = function () {
        if (!ctrl.selectedList) {
          ctrl.selectedList = [];
        }
        if (ctrl.mixDatabaseId) {
          ctrl.request.query = "mixDatabaseId=" + ctrl.mixDatabaseId;
        }
        if (ctrl.mixDatabaseName) {
          ctrl.request.query += "&mixDatabaseName=" + ctrl.mixDatabaseName;
        }
      };
      ctrl.loadData = async function (pageIndex) {
        ctrl.request.query = "";
        if (pageIndex !== undefined) {
          ctrl.request.pageIndex = pageIndex;
        }
        if (ctrl.request.fromDate !== null) {
          var d = new Date(ctrl.request.fromDate);
          ctrl.request.fromDate = d.toISOString();
        }
        if (ctrl.request.toDate !== null) {
          var d = new Date(ctrl.request.toDate);
          ctrl.request.toDate = d.toISOString();
        }
        if (ctrl.mixDatabaseId) {
          ctrl.request.query = "mixDatabaseId=" + ctrl.mixDatabaseId;
        }
        if (ctrl.mixDatabaseName) {
          ctrl.request.query += "&mixDatabaseName=" + ctrl.mixDatabaseName;
        }
        Object.keys(ctrl.queries).forEach((e) => {
          if (ctrl.queries[e]) {
            ctrl.request.query += "&" + e + "=" + ctrl.queries[e];
          }
        });
        var response = await service.getList(ctrl.request);
        if (response.isSucceed) {
          ctrl.data = response.data;
          ctrl.navs = [];
          angular.forEach(response.data.items, function (e) {
            e.disabled =
              $rootScope.findObjectByKey(ctrl.selectedList, "id", e.id) != null;
            // var item = {
            //     priority: e.priority,
            //     description: e.data.title,
            //     postId: e.id,
            //     image: e.thumbnailUrl,
            //     specificulture: e.specificulture,
            //     status: 'Published',
            //     isActived: false
            // };
            // item[ctrl.srcField] = ctrl.srcId;
            // ctrl.navs.push(item);
          });
          $rootScope.isBusy = false;
          $scope.$apply();
        } else {
          $rootScope.showErrors(response.errors);
          $rootScope.isBusy = false;
          $scope.$apply();
        }
      };
      ctrl.select = function (value, isSelected) {
        if (isSelected) {
          if (ctrl.parentId) {
            var nav = {
              mixDatabaseName: ctrl.mixDatabaseName,
              parentId: ctrl.parentId,
              parentType: ctrl.parentType,
              id: value,
            };
            navService.save(nav).then((resp) => {
              if (resp.isSucceed) {
                var current = $rootScope.findObjectByKey(
                  ctrl.selectedList,
                  "id",
                  data.id
                );
                if (!current) {
                  data.disabled = true;
                  ctrl.selectedList.push(data);
                }
                $rootScope.showMessage("success", "success");
                $rootScope.isBusy = false;
                $scope.$apply();
              } else {
                $rootScope.showMessage("failed");
                $rootScope.isBusy = false;
                $scope.$apply();
              }
            });
          } else {
            var current = $rootScope.findObjectByKey(
              ctrl.selectedList,
              "id",
              data.id
            );
            if (!current) {
              data.disabled = true;
              ctrl.selectedList.push(data);
            }
          }
        } else {
          if (ctrl.parentId) {
            navService
              .delete([ctrl.parentId, ctrl.parentType, data.id])
              .then((resp) => {
                if (resp.isSucceed) {
                  data.disabled = false;
                  var tmp = $rootScope.findObjectByKey(
                    ctrl.data.items,
                    "id",
                    data.id
                  );
                  if (tmp) {
                    tmp.disabled = false;
                  }
                  $rootScope.removeObjectByKey(
                    ctrl.selectedList,
                    "id",
                    data.id
                  );
                  $rootScope.showMessage("success", "success");
                  $rootScope.isBusy = false;
                  $scope.$apply();
                } else {
                  $rootScope.showMessage("failed");
                  $rootScope.isBusy = false;
                  $scope.$apply();
                }
              });
          } else {
            data.disabled = false;
            var tmp = $rootScope.findObjectByKey(
              ctrl.data.items,
              "id",
              data.id
            );
            if (tmp) {
              tmp.disabled = false;
            }
            $rootScope.removeObjectByKey(ctrl.selectedList, "id", data.id);
          }
        }
        if (ctrl.selectCallback) {
          ctrl.selectCallback({ data: data });
        }
      };
      ctrl.createData = function () {
        var data = {
          title: ctrl.newTitle,
          slug: $rootScope.generateKeyword(ctrl.newTitle, "-"),
          type: ctrl.type,
        };
        service.saveByName(ctrl.mixDatabaseName, data).then((resp) => {
          if (resp.isSucceed) {
            ctrl.data.items.push(resp.data);
            $rootScope.showMessage("success", "success");
            $rootScope.isBusy = false;
            $scope.$apply();
          } else {
            $rootScope.showMessage("failed");
            $rootScope.isBusy = false;
            $scope.$apply();
          }
        });
      };
    },
  ],
});

modules.component("modalNavMetas", {
  templateUrl: "/mix-app/views/app-portal/components/modal-nav-metas/view.html",
  bindings: {
    header: "=",
    mixDatabaseId: "=?",
    mixDatabaseName: "=?",
    parentId: "=?",
    parentType: "=?",
    type: "=?",
    columnDisplay: "=?",
    isOpen: "=?",
    selectedList: "=?",
    selectCallback: "&?",
    save: "&",
  },
  controller: [
    "$rootScope",
    "$scope",
    "$routeParams",
    "ngAppSettings",
    "RestMixDatabaseDataPortalService",
    "RestRelatedAttributeDataPortalService",
    "RestMixDatabasePortalService",
    function (
      $rootScope,
      $scope,
      $routeParams,
      ngAppSettings,
      dataService,
      navService,
      databaseService
    ) {
      var ctrl = this;
      ctrl.request = angular.copy(ngAppSettings.request);
      ctrl.request.key = "readData";
      ctrl.navs = [];

      ctrl.queries = {};
      ctrl.data = { items: [] };
      ctrl.selectedValues = [];
      ctrl.$onInit = function () {
        ctrl.request.isGroup = true;
        if (!ctrl.selectedList) {
          ctrl.selectedList = [];
        }
        ctrl.selectedValues = ctrl.selectedList.map((m) => m.dataId);
        if (ctrl.mixDatabaseId) {
          ctrl.request.mixDatabaseId = ctrl.mixDatabaseId;
        }
        if (ctrl.mixDatabaseName) {
          ctrl.request.mixDatabaseName = ctrl.mixDatabaseName;
        }
        ctrl.loadDefaultModel();
        ctrl.loadData();
        ctrl.filterData();
      };
      ctrl.loadDefaultModel = async function () {
        ctrl.defaultNav = {
          id: null,
          specificulture: navService.lang,
          dataId: null,
          parentId: ctrl.parentId,
          parentType: ctrl.parentType,
          mixDatabaseId: ctrl.mixDatabaseId,
          mixDatabaseName: ctrl.mixDatabaseName,
          status: "Published",
          attributeData: null,
        };
        if ($routeParams.parentId) {
          ctrl.parentId = $routeParams.parentId;
        }
        if ($routeParams.parentType) {
          ctrl.parentType = $routeParams.parentType;
        }
        if (!ctrl.columns) {
          var getMixDatbase = await databaseService.getSingle([
            ctrl.mixDatabaseName || ctrl.mixDatabaseId,
          ]);
          if (getMixDatbase.isSucceed) {
            ctrl.columns = getMixDatbase.data.columns;
            ctrl.mixDatabaseId = getMixDatbase.data.id;
            ctrl.mixDatabaseName = getMixDatbase.data.name;
            ctrl.defaultNav.mixDatabaseId = getMixDatbase.data.id;
            ctrl.defaultNav.mixDatabaseName = getMixDatbase.data.name;
            $scope.$apply();
          }
        }
        var getDefault = await dataService.initData(
          ctrl.mixDatabaseName || ctrl.mixDatabaseId
        );
        ctrl.defaultData = getDefault.data;
        if (ctrl.defaultData) {
          ctrl.defaultData.mixDatabaseId = ctrl.mixDatabaseId || 0;
          ctrl.defaultData.mixDatabaseName = ctrl.mixDatabaseName;
        }

        if (!ctrl.mixDatabaseData) {
          ctrl.mixDatabaseData = angular.copy(ctrl.defaultData);
        }
      };
      ctrl.isSelected = function (value, level) {
        let item = $rootScope.findObjectByKey(
          ctrl.selectedList,
          "dataId",
          value
        );
        if (item) {
          item.level = level;
        }
        return ctrl.selectedValues.indexOf(value) >= 0;
      };
      ctrl.reload = async function () {
        ctrl.newTitle = "";
        ctrl.mixDatabaseData = angular.copy(ctrl.defaultData);
      };
      ctrl.loadData = async function (pageIndex) {
        ctrl.request.query = "{}";
        if (pageIndex !== undefined) {
          ctrl.request.pageIndex = pageIndex;
        }
        if (ctrl.request.fromDate !== null) {
          var d = new Date(ctrl.request.fromDate);
          ctrl.request.fromDate = d.toISOString();
        }
        if (ctrl.request.toDate !== null) {
          var d = new Date(ctrl.request.toDate);
          ctrl.request.toDate = d.toISOString();
        }
        if (ctrl.mixDatabaseId) {
          ctrl.request.mixDatabaseId = ctrl.mixDatabaseId;
        }
        if (ctrl.mixDatabaseName) {
          ctrl.request.mixDatabaseName = ctrl.mixDatabaseName;
        }
        if (ctrl.type) {
          ctrl.request.type = ctrl.type;
        }
        Object.keys(ctrl.queries).forEach((e) => {
          if (ctrl.queries[e]) {
            ctrl.request[e] = ctrl.queries[e];
          }
        });
        ctrl.request.key = "data";
        var response = await dataService.getList(ctrl.request);
        if (response.isSucceed) {
          ctrl.data = response.data;
          ctrl.filterData();
          ctrl.isBusy = false;
          $scope.$apply();
        } else {
          $rootScope.showErrors(response.errors);
          ctrl.isBusy = false;
          $scope.$apply();
        }
      };
      ctrl.filterData = function () {
        angular.forEach(ctrl.data.items, function (e) {
          // Not show data if there's in selected list
          e.disabled = ctrl.selectedValues.indexOf(e.id) >= 0;
        });
        angular.forEach(ctrl.selectedList, function (e) {
          var subIds = [];
          e.isActived = e.isActived === undefined ? true : e.isActived;
          if (e.attributeData && e.attributeData.obj.childItems) {
            angular.forEach(e.attributeData.obj.childItems, function (sub) {
              sub.isActived = ctrl.selectedValues.indexOf(e.id) >= 0;
            });
            subIds = e.attributeData.obj.childItems.map((m) => m.id);
          } else if (e.childItems) {
            subIds = e.childItems.map((m) => m.id);
          }
          var subData = ctrl.selectedList.filter(
            (m) => subIds.indexOf(m.dataId) >= 0
          );
          angular.forEach(subData, function (s) {
            s.disabled = true;
          });
        });
      };
      ctrl.select = async function (dataId, isSelected, level) {
        let idx = ctrl.selectedValues.indexOf(dataId);
        var nav = ctrl.selectedList[idx];
        if (!nav) {
          ctrl.selectedValues.push(dataId);
          nav = angular.copy(ctrl.defaultNav);
          nav.dataId = dataId;
          nav.attributeData = $rootScope.findObjectByKey(
            ctrl.data.items,
            "id",
            dataId
          );
          ctrl.selectedList.push(nav);
        }
        nav.level = level;
        if (isSelected) {
          nav.isActived = true;
          if (nav.parentId) {
            var saveResult = await navService.save(nav);
            nav.id = saveResult.data.id;
            $rootScope.showMessage("success", "success");
            ctrl.filterData();
            $scope.$apply();
          }
        }

        if (!isSelected) {
          await ctrl.removeNav(idx);
          if (ctrl.selectCallback) {
            ctrl.selectCallback({ data: nav });
          }
          return;
        }
      };
      ctrl.removeNav = async function (idx) {
        var nav = ctrl.selectedList[idx];
        ctrl.selectedValues.splice(idx, 1);
        ctrl.selectedList.splice(idx, 1);
        ctrl.filterData();
        if (nav && nav.id) {
          await navService.delete([nav.id]);
          $rootScope.showMessage("success", "success");
          $scope.$apply();
        }
      };
      ctrl.disableNavitem = function (nav, isDisable) {
        nav.disabled = isDisable;
      };
      ctrl.createData = function () {
        if (ctrl.newTitle) {
          var tmp = $rootScope.findObjectByKey(
            ctrl.data.items,
            "title",
            ctrl.newTitle
          );
          if (!tmp) {
            ctrl.isBusy = true;
            ctrl.mixDatabaseData.parentId = 0;
            ctrl.mixDatabaseData.parentType = "Set";
            ctrl.mixDatabaseData.obj.title = ctrl.newTitle;
            ctrl.mixDatabaseData.obj.slug = $rootScope.generateKeyword(
              ctrl.newTitle,
              "-"
            );
            ctrl.mixDatabaseData.obj.type = ctrl.type;
            dataService.save(ctrl.mixDatabaseData).then((resp) => {
              if (resp.isSucceed) {
                ctrl.data.items.push(resp.data);
                ctrl.reload();
                ctrl.select(resp.data.id, true);
                ctrl.filterData();
                ctrl.isBusy = false;
                $scope.$apply();
              } else {
                $rootScope.showErrors(resp.errors);
                ctrl.isBusy = false;
                $scope.$apply();
              }
            });
          } else {
            tmp.isActived = true;
            ctrl.select(tmp);
          }
        }
      };
    },
  ],
});

modules.component("modalNavPages", {
  templateUrl: "/mix-app/views/app-portal/components/modal-nav-pages/view.html",
  bindings: {
    srcField: "=",
    srcId: "=",
    query: "=",
    selected: "=",
    save: "&",
  },
  controller: [
    "$rootScope",
    "$scope",
    "ngAppSettings",
    "PageRestService",
    function ($rootScope, $scope, ngAppSettings, pageService) {
      var ctrl = this;
      ctrl.request = angular.copy(ngAppSettings.request);
      ctrl.navs = [];
      ctrl.data = { items: [] };
      ctrl.loadData = async function (pageIndex) {
        ctrl.request.query = ctrl.query + ctrl.srcId;
        if (pageIndex !== undefined) {
          ctrl.request.pageIndex = pageIndex;
        }
        if (ctrl.request.fromDate !== null) {
          var d = new Date(ctrl.request.fromDate);
          ctrl.request.fromDate = d.toISOString();
        }
        if (ctrl.request.toDate !== null) {
          var d = new Date(ctrl.request.toDate);
          ctrl.request.toDate = d.toISOString();
        }
        var response = await pageService.getList(ctrl.request);
        if (response.isSucceed) {
          ctrl.data = response.data;
          ctrl.navs = [];
          angular.forEach(response.data.items, function (e) {
            var item = {
              priority: e.priority,
              description: e.title,
              pageId: e.id,
              image: e.thumbnailUrl,
              specificulture: e.specificulture,
              status: "Published",
              isActived: false,
            };
            item[ctrl.srcField] = ctrl.srcId;
            ctrl.navs.push(item);
          });
          $rootScope.isBusy = false;
          $scope.$apply();
        } else {
          $rootScope.showErrors(response.errors);
          $rootScope.isBusy = false;
          $scope.$apply();
        }
      };
      ctrl.saveSelected = function () {
        ctrl.selected = $rootScope.filterArray(
          ctrl.navs,
          ["isActived"],
          [true]
        );
        setTimeout(() => {
          ctrl.save().then(() => {
            ctrl.loadPages();
          });
        }, 500);
      };
    },
  ],
});

modules.component("modalNavPosts", {
  templateUrl:
    "/mix-app/views/app-portal/components/modal-nav-posts/modal-nav-posts.html",
  bindings: {
    srcColumn: "=",
    srcId: "=",
    query: "=",
    selected: "=",
    save: "&",
  },
  controller: [
    "$rootScope",
    "$scope",
    "$routeParams",
    "ngAppSettings",
    "PostRestService",
    function ($rootScope, $scope, $routeParams, ngAppSettings, postService) {
      var ctrl = this;
      ctrl.request = angular.copy(ngAppSettings.request);
      ctrl.navs = [];
      ctrl.data = { items: [] };
      ctrl.loadPosts = async function (pageIndex) {
        // ctrl.request.query = ctrl.query + ctrl.srcId;
        if (pageIndex !== undefined) {
          ctrl.request.pageIndex = pageIndex;
        }
        if (ctrl.request.fromDate !== null) {
          var d = new Date(ctrl.request.fromDate);
          ctrl.request.fromDate = d.toISOString();
        }
        if (ctrl.request.toDate !== null) {
          var d = new Date(ctrl.request.toDate);
          ctrl.request.toDate = d.toISOString();
        }
        if ($routeParams.type) {
          ctrl.request.postType = $routeParams.type;
        } else {
          ctrl.request.postType = "";
        }
        var response = await postService.getList(ctrl.request);
        if (response.isSucceed) {
          ctrl.data = response.data;
          ctrl.navs = [];
          angular.forEach(response.data.items, function (e) {
            var item = {
              priority: e.priority,
              description: e.title,
              postId: e.id,
              image: e.thumbnailUrl,
              specificulture: e.specificulture,
              post: e,
              status: "Published",
              isActived: false,
            };
            item[ctrl.srcColumn] = ctrl.srcId;
            ctrl.navs.push(item);
          });
          $rootScope.isBusy = false;
          $scope.$apply();
        } else {
          $rootScope.showErrors(response.errors);
          $rootScope.isBusy = false;
          $scope.$apply();
        }
      };
      ctrl.saveSelected = function () {
        ctrl.selected = $rootScope.filterArray(
          ctrl.navs,
          ["isActived"],
          [true]
        );
        setTimeout(() => {
          ctrl.save().then(() => {
            ctrl.loadPosts();
          });
        }, 500);
      };
    },
  ],
});

modules.component("modalNavs", {
  templateUrl: "/mix-app/views/app-portal/components/modal-navs/view.html",
  bindings: {
    modelName: "=",
    viewType: "=",
    selects: "=",
    isSingle: "=?",
    isGlobal: "=?",
    save: "&",
  },
  controller: [
    "$rootScope",
    "$scope",
    "$routeParams",
    "ngAppSettings",
    function ($rootScope, $scope, $routeParams, ngAppSettings) {
      var ctrl = this;
      ctrl.request = angular.copy(ngAppSettings.request);
      ctrl.contentStatuses = angular.copy(ngAppSettings.contentStatuses);
      ctrl.viewmodel = null;
      ctrl.data = null;
      ctrl.isInit = false;
      ctrl.isValid = true;
      ctrl.errors = [];
      ctrl.selected = [];

      ctrl.init = function () {
        ctrl.service = $rootScope.getRestService(
          ctrl.modelName + "/portal",
          ctrl.isGlobal
        );
        ctrl.prefix = "modal_navs_" + ctrl.modelName;
        ctrl.cols = ctrl.selects.split(",");
        ctrl.getList();
      };

      ctrl.getList = async function (pageIndex) {
        if (pageIndex !== undefined) {
          ctrl.request.pageIndex = pageIndex;
        }
        if (ctrl.request.fromDate !== null) {
          var d = new Date(ctrl.request.fromDate);
          ctrl.request.fromDate = d.toISOString();
        }
        if (ctrl.request.toDate !== null) {
          var d = new Date(ctrl.request.toDate);
          ctrl.request.toDate = d.toISOString();
        }
        var resp = await ctrl.service.getList(ctrl.request);
        if (resp.isSucceed) {
          ctrl.data = resp.data;
          $.each(ctrl.data.items, function (i, data) {
            $.each(ctrl.viewmodels, function (i, e) {
              if (e.dataId === data.id) {
                data.isHidden = true;
              }
            });
          });
          $rootScope.isBusy = false;
          $scope.$apply();
        } else {
          if (resp) {
            $rootScope.showErrors(resp.errors);
          }
          $rootScope.isBusy = false;
          $scope.$apply();
        }
      };

      // ctrl.loadData = async function (pageIndex) {
      //     ctrl.request.query = ctrl.query + ctrl.srcId;
      //     if (pageIndex !== undefined) {
      //         ctrl.request.pageIndex = pageIndex;
      //     }
      //     if (ctrl.request.fromDate !== null) {
      //         var d = new Date(ctrl.request.fromDate);
      //         ctrl.request.fromDate = d.toISOString();
      //     }
      //     if (ctrl.request.toDate !== null) {
      //         var d = new Date(ctrl.request.toDate);
      //         ctrl.request.toDate = d.toISOString();
      //     }
      //     var response = await pageService.getList(ctrl.request);
      //     if (response.isSucceed) {
      //         ctrl.data = response.data;
      //         ctrl.navs = [];
      //         angular.forEach(response.data.items, function (e) {
      //             var item = {
      //                 priority: e.priority,
      //                 description: e.title,
      //                 pageId: e.id,
      //                 image: e.thumbnailUrl,
      //                 specificulture: e.specificulture,
      //                 status: 'Published',
      //                 isActived: false
      //             };
      //             item[ctrl.srcField] = ctrl.srcId;
      //             ctrl.navs.push(item);
      //         });
      //         $rootScope.isBusy = false;
      //         $scope.$apply();
      //     }
      //     else {
      //         $rootScope.showErrors(response.errors);
      //         $rootScope.isBusy = false;
      //         $scope.$apply();
      //     }
      // }
      ctrl.selectAll = function (isSelectAll) {
        angular.forEach(ctrl.data.items, (element) => {
          element.isActived = isSelectAll;
        });
      };
      ctrl.selectChange = function (item) {
        if (ctrl.isSingle == "true" && item.isActived) {
          angular.forEach(ctrl.data.items, (element) => {
            element.isActived = false;
          });
          item.isActived = true;
        }
      };
      ctrl.saveSelected = function () {
        ctrl.selected = $rootScope.filterArray(
          ctrl.data.items,
          ["isActived"],
          [true]
        );
        if (ctrl.save) {
          ctrl.save({ selected: ctrl.selected });
        }
      };
    },
  ],
});

modules.component("modalPermission", {
  templateUrl:
    "/mix-app/views/app-portal/components/modal-permission/modal-permission.html",
  controller: "PermissionController",
  bindings: {
    message: "=",
  },
});

modules.component("modalTemplate", {
  templateUrl: "/mix-app/views/app-portal/components/modal-template/view.html",
  controller: [
    "$rootScope",
    "$scope",
    "ngAppSettings",
    "TemplateService",
    function ($rootScope, $scope, ngAppSettings, service) {
      var ctrl = this;
      ctrl.request = angular.copy(ngAppSettings.request);
      ctrl.$onInit = function () {
        ctrl.modal = $("#modal-template");
        ctrl.request.status = null;
        ctrl.request.pageSize = 10;
        ctrl.modal.on("shown.bs.modal", function () {
          ctrl.search();
        });
      };
      ctrl.search = async function (pageIndex) {
        if (ctrl.request.keyword.indexOf("/") > 0) {
          let params = ctrl.request.keyword.split("/");
          ctrl.request.folderType = params[0];
          ctrl.request.keyword = params[1];
        }
        ctrl.request.pageIndex = pageIndex || ctrl.request.pageIndex;
        $rootScope.isBusy = true;
        var resp = await service.getList(ctrl.request);
        if (resp && resp.isSucceed) {
          ctrl.data = resp.data;
        }
        $rootScope.isBusy = false;
        $scope.$apply();
      };
      ctrl.edit = function (item) {
        let path = `/portal/template/details/${item.themeId}/${item.folderType}/${item.id}`;
        ctrl.modal.modal("hide");
        $rootScope.goToPath(path);
      };
    },
  ],
});

modules.component("monacoEditor", {
  templateUrl: "/mix-app/views/app-portal/components/monaco-editor/view.html",
  bindings: {
    editor: "=?",
    content: "=",
    defaultContent: "=?",
    contentId: "=",
    isVisible: "=",
    isReadonly: "=?",
    lineCount: "=?",
    ext: "=",
    updateContent: "&",
  },
  controller: [
    "$rootScope",
    "$scope",
    "$element",
    function ($rootScope, $scope, $element) {
      var ctrl = this;
      ctrl.previousId = null;
      ctrl.minHeight = 400;
      ctrl.isFull = false;
      ctrl.id = Math.floor(Math.random() * 100) + 1;
      ctrl.$onInit = function () {
        if (ctrl.content === null) {
          ctrl.content = "\r\n";
        }
      };
      ctrl.$onChanges = function (changes) {
        if (changes.content) {
          ctrl.updateContent(changes.content);
        }
        if (changes.isVisible || changes.isReadonly) {
          ctrl.updateEditors();
        }
      };

      ctrl.showHelper = function (url) {
        $rootScope.showHelper(url);
      };

      this.$doCheck = function () {
        if (ctrl.previousId != null && ctrl.previousId !== ctrl.contentId) {
          ctrl.previousId = ctrl.contentId;
          ctrl.updateContent(ctrl.content);
        }
        if (ctrl.isReadonly !== ctrl._readonly && ctrl.editor) {
          ctrl._readonly = ctrl.isReadonly;
          ctrl.editor.updateOptions({ readOnly: ctrl._readonly });
        }
        if (ctrl.isVisible && ctrl.editor) {
          setTimeout(() => {
            var h = ctrl.lineCount
              ? ctrl.lineCount
              : ctrl.editor.getModel().getLineCount() * 18;
            $($element).height(h);
            ctrl.editor.layout();
          }, 100);
        }
      }.bind(this);

      ctrl.initEditor = function () {
        // ctrl.lineCount = parseInt(ctrl.lineCount) || 100;
        ctrl.previousId = ctrl.contentId;
        ctrl.updateEditors();
      };

      ctrl.updateContent = function (content) {
        ctrl.editor.setValue(content);
        // lineCount = ctrl.editor.getModel().getLineCount();

        // var h = ctrl.editor.getModel().getLineCount() * 18;
        var h = ctrl.lineCount * 18;
        $($element).height(h);
        ctrl.editor.layout();
      };
      ctrl.updateEditors = function () {
        $.each($($element).find(".code-editor"), function (i, e) {
          if (e) {
            var model = {
              value: ctrl.content || ctrl.defaultContent,
              readOnly: ctrl.isReadonly === "true" || ctrl.isReadonly,

              lineNumbers: "on",
              roundedSelection: false,
              scrollBeyondLastLine: false,
              contextmenu: false,
              // theme: "vs-dark",
              formatOnType: true,
              formatOnPaste: true,
              // wordWrap: "on",
              automaticLayout: true, // the important part
            };
            switch (ctrl.ext) {
              case ".json":
              case ".webmanifest":
                model.language = "json";
                break;
              case ".js":
                model.language = "javascript";
                break;
              case ".css":
                model.language = "css";
                break;
              case ".cshtml":
                model.language = "razor";
                break;
              case ".cs":
                model.language = "csharp";
                break;
              default:
                model.language = "razor";
                break;
            }
            ctrl.editor = monaco.editor.create(e, model);

            ctrl.editor.getModel().onDidChangeContent(() => {
              ctrl.content = ctrl.editor.getModel().getValue();
              ctrl.updateContent({ content: ctrl.content });
            });
            ctrl.editor.addCommand(
              monaco.KeyMod.CtrlCmd | monaco.KeyCode.KEY_S,
              function () {
                var btn = document.getElementById("btnToSubmit");
                btn.click();
              }
            );

            if (ctrl.isFull) {
              $(e).height(window.innerHeight);
            } else {
              $(e).height(ctrl.minHeight);
            }

            // setTimeout(() => {
            //   // var h = ctrl.editor.getModel().getLineCount() * 18;
            //   // h = h < ctrl.minHeight ? ctrl.minHeight : h;
            //   var h = ctrl.lineCount * 20;
            // $(e).height(h);
            // ctrl.editor.layout();
            // }, 200);
          }
        });
      };

      ctrl.fullscreen = function (event) {
        // const element = $(event.target).parents(".monaco-editor");

        // event.target.addEventListener('click', () => {
        //   if (screenfull.isEnabled) {
        //     screenfull.request(element);
        //   }
        // });
        // $.each($($element).find('.code-editor'), function (i, e) {
        //     //var container = $(this);
        //     if (e) {}
        // });
        // console.log($(event.target));

        $(event.target)
          .parents(".monaco-editor")
          .toggleClass("monaco-editor-full");

        ctrl.isFull = !ctrl.isFull;

        ctrl.editor.dispose();

        // var h;

        // ctrl.editor.dispose();
        // if ($(".monaco-editor.container-code-editor.monaco-editor-full")[0]) {
        //   // Do something if class exists
        //   h = window.innerHeight;
        //   $(
        //     ".monaco-editor.container-code-editor.monaco-editor-full .code-editor"
        //   ).height(h);
        //   document.body.style.overflow = "hidden";
        // } else {
        //   // Do something if class does not exist
        //   h = ctrl.lineCount * 20;
        //   $(".monaco-editor .code-editor").height(h);
        //   document.body.style.overflow = "visible";
        // }
        // ctrl.editor.layout();

        ctrl.updateEditors();
      };
    },
  ],
});

modules.component("navs", {
  templateUrl:
    "/mix-app/views/app-portal/components/navigations/navigations.html",
  bindings: {
    prefix: "=",
    detailsUrl: "=",
    key: "=",
    data: "=",
    titleField: "=?",
    titleMaxLength: "=?",
    callback: "&",
  },
  controller: [
    "$scope",
    "$location",
    function ($scope, $location) {
      var ctrl = this;
      ctrl.selected = null;
      ctrl.activedIndex = null;
      ctrl.getTitle = (item) => {
        if (ctrl.titleField) {
          let t = item;
          angular.forEach(ctrl.titleField.split("."), (e) => {
            t = t[e];
          });
          return ctrl.limString(t, ctrl.titleMaxLength || 30);
        } else {
          return ctrl.limString(item.description, ctrl.titleMaxLength || 30);
        }
      };
      ctrl.updateOrders = function (index) {
        ctrl.data.splice(index, 1);
        for (var i = 0; i < ctrl.data.length; i++) {
          ctrl.data[i].priority = i + 1;
        }
      };
      ctrl.dropCallback = function (index, item, external, type) {
        ctrl.logListEvent("dropped at", index, external, type);
        for (var i = 0; i < ctrl.data.length; i++) {
          ctrl.data[i].priority = i + 1;
        }
        // Return false here to cancel drop. Return true if you insert the item yourself.
        return item;
      };
      ctrl.logListEvent = function (action, index, external, type) {
        var message = external ? "External " : "";
        message += type + " element was " + action + " position " + index;
      };
      ctrl.goToDetails = async function (nav) {
        $location.url(ctrl.detailsUrl + nav[ctrl.key]);
      };
      ctrl.limString = function (str, max) {
        if (str) {
          return str.length > max ? str.substring(0, max) + " ..." : str;
        }
      };
    },
  ],
});

modules.component("portalThemeSettings", {
  templateUrl:
    "/mix-app/views/app-portal/components/portal-theme-settings/view.html",
  bindings: {
    showLink: "=",
  },
  controller: [
    "$rootScope",
    "$scope",
    "AppSettingsServices",
    function ($rootScope, $scope, appSettingsServices) {
      var ctrl = this;
      this.$onInit = function () {
        ctrl.portalThemeSettings =
          $rootScope.globalSettings.portalThemeSettings;
      };
      ctrl.applyThemeSettings = function () {
        $rootScope.globalSettings.portalThemeSettings =
          ctrl.portalThemeSettings;
      };
      ctrl.saveThemeSettings = async function () {
        var resp = await appSettingsServices.saveGlobalSettings(
          "PortalThemeSettings",
          ctrl.portalThemeSettings
        );
        if (resp && resp.isSucceed) {
          $rootScope.showMessage("success", "success");
          $rootScope.isBusy = false;
          $scope.$apply();
        } else {
          if (resp) {
            $rootScope.showErrors(resp.errors);
          }
          $scope.$apply();
        }
      };
    },
  ],
});

modules.component("propertiesStructure", {
  templateUrl:
    "/mix-app/views/app-portal/components/properties-structure/view.html",
  controller: [
    "$rootScope",
    "$scope",
    function ($rootScope, $scope) {
      var ctrl = this;
      ctrl.selectedCol = null;
      ctrl.localizeSettings = $rootScope.globalSettings;
      ctrl.defaultAttr = {
        title: "",
        name: "",
        defaultValue: null,
        options: [],
        priority: 0,
        dataType: "Text",
        isGroupBy: false,
        isSelect: false,
        isDisplay: true,
        width: 3,
        columnConfigurations: {
          upload: {
            isCrop: false,
            width: null,
            height: null,
          },
        },
      };

      ctrl.addAttr = function () {
        if (ctrl.columns) {
          var t = angular.copy(ctrl.defaultAttr);
          ctrl.columns.push(t);
        }
      };

      ctrl.addOption = function (col, index) {
        var val = $("#option_" + index).val();
        col.options.push(val);
        $("#option_" + index).val("");
      };
      ctrl.generateForm = function () {
        var formHtml = document.createElement("module-form");
        formHtml.setAttribute("class", "row");
        angular.forEach(ctrl.viewmodel.columns, function (e, i) {
          var el;
          var label = document.createElement("label");
          label.setAttribute("class", "control-label");
          label.setAttribute("ng-bind", "{{data.title}}");

          switch (e.dataType) {
            case "datetime":
              el = document.createElement("input");
              el.setAttribute("type", "datetime-local");
              break;

            case "date":
              el = document.createElement("input");
              el.setAttribute("type", "date");
              break;

            case "time":
              el = document.createElement("input");
              el.setAttribute("type", "time");
              break;

            case "phonenumber":
              el = document.createElement("input");
              el.setAttribute("type", "tel");
              break;

            case "integer":
              el = document.createElement("input");
              el.setAttribute("type", "number");
              break;

            case "html":
              el = document.createElement("quill");
              el.setAttribute("options", "{}");
              el.setAttribute("type", "number");
              break;

            case "multilinetext":
              el = document.createElement("textarea");
              break;

            default:
              el = document.createElement("input");
              el.setAttribute("type", "text");
              formHtml.appendChild(el);
              break;
          }
          el.setAttribute("ng-model", "data.jItem[" + e.name + "].value");
          el.setAttribute("placeholder", "{{$ctrl.title}}");
          formHtml.appendChild(label);
          formHtml.appendChild(el);
        });
        ctrl.viewmodel.formView.content = formHtml.innerHTML;
      };

      ctrl.generateName = function (col) {
        col.name = $rootScope.generateKeyword(col.title, "_");
      };
      ctrl.removeAttr = function (index) {
        if (ctrl.columns) {
          ctrl.columns.splice(index, 1);
        }
      };
      ctrl.dragStart = function (index) {
        ctrl.dragStartIndex = index;
      };
      ctrl.updateOrders = function (index) {
        if (index > ctrl.dragStartIndex) {
          ctrl.columns.splice(ctrl.dragStartIndex, 1);
        } else {
          ctrl.columns.splice(ctrl.dragStartIndex + 1, 1);
        }
        angular.forEach(ctrl.columns, function (e, i) {
          e.priority = i;
        });
      };
    },
  ],
  bindings: {
    header: "=",
    columns: "=",
  },
});

modules.component("propertiesValue", {
  templateUrl:
    "/mix-app/views/app-portal/components/properties-value/view.html",
  bindings: {
    title: "=",
    columns: "=",
    properties: "=",
  },
  controller: [
    "$rootScope",
    "$scope",
    function ($rootScope, $scope) {
      var ctrl = this;
      ctrl.defaultAttr = {
        title: "",
        name: "",
        default: null,
        options: [],
        priority: 0,
        dataType: 7,
        isGroupBy: false,
        isSelect: false,
        isDisplay: true,
        width: 3,
      };
      ctrl.selectedProp = null;
      ctrl.localizeSettings = $rootScope.globalSettings;

      ctrl.$doCheck = function () {
        if (
          angular.toJson(ctrl.columns) != angular.toJson(ctrl.trackedColumns)
        ) {
          ctrl.trackedColumns = angular.copy(ctrl.columns);
          ctrl.trackedProperties = angular.copy(ctrl.properties);
          ctrl.loadEditors();
        }
      }.bind(ctrl);

      ctrl.loadEditors = function () {
        ctrl.properties = [];
        for (let i = 0; i < ctrl.columns.length; i++) {
          var col = ctrl.columns[i];
          var oldObj =
            $rootScope.findObjectByKey(
              ctrl.trackedProperties,
              "name",
              col.name
            ) || {};

          ctrl.properties.push({
            title: col.title,
            name: col.name,
            dataType: col.dataType,
            value: oldObj.value || col.defaultValue,
            options: col.options,
          });
        }
      };

      ctrl.addAttr = function () {
        if (ctrl.columns) {
          var t = angular.copy(ctrl.defaultAttr);
          ctrl.columns.push(t);
        }
      };
    },
  ],
});

modules.component("serviceHubPortal", {
  templateUrl:
    "/mix-app/views/app-portal/components/service-hub-portal/view.html",
  bindings: {
    mixDatabaseName: "=",
    isSave: "=?",
  },
  controller: [
    "$rootScope",
    "$scope",
    "RestMixDatabaseColumnPortalService",
    "RestMixDatabaseDataClientService",
    "UserServices",
    function ($rootScope, $scope, columnService, service, userServices) {
      var ctrl = this;
      BaseHub.call(this, ctrl);
      ctrl.localizeSettings = $rootScope.globalSettings;
      ctrl.user = {
        loggedIn: false,
        connection: {},
      };
      ctrl.mixDatabaseData = null;
      ctrl.isHide = true;
      ctrl.hideContact = true;
      ctrl.columns = [];
      ctrl.members = [];
      ctrl.errors = [];
      ctrl.messages = {
        items: [],
      };
      ctrl.message = { connection: {}, content: "" };
      ctrl.request = {
        uid: "",
        specificulture: "",
        action: "",
        objectType: null,
        data: {},
        room: "",
        isMyself: true,
        isSave: false,
      };
      ctrl.init = function () {
        ctrl.mixDatabaseId = ctrl.mixDatabaseId || 0;
        ctrl.request.specificulture = service.lang;
        ctrl.request.room = ctrl.mixDatabaseName;
        ctrl.request.isSave = ctrl.isSave == "true" || false;
        ctrl.startConnection("serviceHub", ctrl.checkLoginStatus);
      };
      ctrl.loadData = async function () {
        /*
                    If input is data id => load ctrl.mixDatabaseData from service and handle it independently
                    Else modify input ctrl.mixDatabaseData
                */
        $rootScope.isBusy = true;
        var getDefault = await service.initData(ctrl.mixDatabaseName);
        if (getDefault.isSucceed) {
          ctrl.defaultData = getDefault.data;
          ctrl.defaultData.data.user_name = ctrl.user.connection.name;
          ctrl.defaultData.data.user_id = ctrl.user.connection.id;
          ctrl.defaultData.data.user_avatar = ctrl.user.connection.avatar;
          ctrl.defaultData.data.data_type = 9;
          ctrl.mixDatabaseData = angular.copy(ctrl.defaultData);
          $rootScope.isBusy = false;
        }
        var getFields = await columnService.initData(ctrl.mixDatabaseName);
        if (getFields.isSucceed) {
          ctrl.columns = getFields.data;
        }
      };
      ctrl.submit = async function () {
        if (ctrl.validate()) {
          ctrl.request.action = "send_group_message";
          ctrl.request.uid = ctrl.user.connection.id;
          ctrl.request.data = ctrl.mixDatabaseData.data;
          ctrl.request.connection = ctrl.user.connection;
          ctrl.connection.invoke("HandleRequest", JSON.stringify(ctrl.request));
          ctrl.mixDatabaseData = angular.copy(ctrl.defaultData);
        }
      };
      ctrl.validate = function () {
        var isValid = true;
        ctrl.errors = [];
        angular.forEach(ctrl.columns, function (column) {
          if (column.regex) {
            var regex = RegExp(column.regex, "g");
            isValid = regex.test(ctrl.mixDatabaseData.data[column.name]);
            if (!isValid) {
              ctrl.errors.push(`${column.name} is not match Regex`);
            }
          }
          if (isValid && column.isEncrypt) {
            ctrl.mixDatabaseData.data[column.name] = $rootScope.encrypt(
              ctrl.mixDatabaseData.data[column.name]
            );
          }
        });
        return isValid;
      };
      ctrl.receiveMessage = function (msg) {
        switch (msg.responseKey) {
          case "NewMember":
            ctrl.newMember(msg.data);
            // $('.widget-conversation').scrollTop = $('.widget-conversation')[0].scrollHeight;
            break;
          case "NewMessage":
            ctrl.newMessage(msg.data);
            break;
          case "ConnectSuccess":
            ctrl.user.loggedIn = true;
            ctrl.initListMember(msg.data);
            $scope.$apply();
            break;
          case "PreviousMessages":
            ctrl.messages = msg.data;
            $scope.$apply();
            break;
          case "MemberOffline":
            ctrl.removeMember(msg.data);
            break;
          case "Error":
            console.error(msg.data);
            break;
        }
      };
      ctrl.newMessage = function (msg) {
        ctrl.messages.items.push(msg);
        $scope.$apply();
      };
      ctrl.newMember = function (member) {
        var m = $rootScope.findObjectByKey(ctrl.members, "id", member.id);
        if (!m) {
          ctrl.members.push(member);
        }
        $scope.$apply();
      };
      ctrl.join = async function () {
        ctrl.request.action = "join_group";
        ctrl.request.uid = ctrl.user.connection.id;
        ctrl.request.data = ctrl.user.connection;
        ctrl.message.connection = ctrl.user.connection;
        ctrl.connection.invoke("HandleRequest", JSON.stringify(ctrl.request));
        await ctrl.loadData();
        $scope.$apply();
      };
      ctrl.initListMember = function (data) {
        data.forEach((member) => {
          var index = ctrl.members.findIndex((x) => x.id === member.id);
          if (index < 0) {
            ctrl.members.splice(0, 0, member);
          }
        });

        $scope.$apply();
      };

      ctrl.checkLoginStatus = async function () {
        var response = await userServices.getMyProfile();
        ctrl.user.connection.name = response.data.username;
        ctrl.user.connection.id = response.data.id;
        ctrl.user.connection.connectionId = ctrl.connection.connectionId;
        ctrl.user.connection.avatar = response.data.avatar;
        ctrl.user.loggedIn = true;
        ctrl.join();
      };
    },
  ],
});

modules.component("templateEditor", {
  templateUrl:
    "/mix-app/views/app-portal/components/template-editor/templateEditor.html",
  bindings: {
    template: "=",
    templates: "=",
    folderType: "=",
    isReadonly: "=?",
    lineCount: "=?",
    hideJs: "=?",
    hideCss: "=?",
    enableRename: "=?",
  },
  controller: [
    "$scope",
    "$rootScope",
    "$routeParams",
    "ngAppSettings",
    "GlobalSettingsService",
    "TemplateService",
    function (
      $scope,
      $rootScope,
      $routeParams,
      ngAppSettings,
      globalSettingsService,
      service
    ) {
      BaseCtrl.call(
        this,
        $scope,
        $rootScope,
        $routeParams,
        ngAppSettings,
        service
      );
      var ctrl = this;
      BaseHub.call(this, ctrl);
      ctrl.isNull = false;
      ctrl.selectPane = function (pane) {
        ctrl.activedPane = pane;
      };
      ctrl.selectTemplate = function (template) {
        ctrl.template = template;
        $scope.$broadcast("updateContentCodeEditors", []);
      };
      ctrl.new = function () {
        ctrl.template.id = 0;
      };
      ctrl.init = async function () {
        if (!ctrl.template && ctrl.templates) {
          ctrl.template = ctrl.templates[0];
        }
        if (ctrl.folderType && !ctrl.folderType) {
          var themeId = globalSettingsService.get("themeId");
          var resp = await service.getSingle([
            "portal",
            themeId,
            ctrl.folderType,
          ]);
          if (resp && resp.isSucceed) {
            resp.data.fileName = "new";
            ctrl.templates.splice(0, 0, resp.data);
            $rootScope.isBusy = false;
            $scope.$apply();
          } else {
            if (resp) {
              $rootScope.showErrors(resp.errors);
              $rootScope.isBusy = false;
              $scope.$apply();
            }
          }
        }
      };
    },
  ],
});

modules.component("toastHelper", {
  templateUrl:
    "/mix-app/views/app-portal/components/toast-helper/toast-helper.html",
  bindings: {
    url: "=?",
    title: "=?",
  },
  controller: [
    "$rootScope",
    function ($rootScope) {
      var ctrl = this;
      ctrl.visible = $rootScope.visible;
    },
  ],
});

modules.component("urlAlias", {
  templateUrl: "/mix-app/views/app-portal/components/url-alias/url-alias.html",
  controller: [
    "$rootScope",
    "$scope",
    "UrlAliasService",
    function ($rootScope, $scope, service) {
      var ctrl = this;
      ctrl.$onInit = function () {
        ctrl.updateUrl();
      };
      ctrl.updateUrl = function () {
        ctrl.url =
          $rootScope.globalSettings.domain +
          "/" +
          $rootScope.localizeSettings.lang +
          "/" +
          ctrl.urlAlias.alias;
      };
      ctrl.remove = function () {
        if (ctrl.urlAlias.id > 0) {
          $rootScope.showConfirm(
            ctrl,
            "removeConfirmed",
            [ctrl.urlAlias.id],
            null,
            "Remove",
            "Deleted data will not able to recover, are you sure you want to delete this item?"
          );
        } else {
          if (ctrl.removeCallback) {
            ctrl.removeCallback({ index: ctrl.index });
          }
        }
      };

      ctrl.removeConfirmed = async function (id) {
        $rootScope.isBusy = true;
        var result = await service.delete(id);
        if (result.isSucceed) {
          if (ctrl.removeCallback) {
            ctrl.removeCallback({ index: ctrl.index });
          }
          $rootScope.isBusy = false;
          $scope.$apply();
        } else {
          $rootScope.showMessage("failed");
          $rootScope.isBusy = false;
          $scope.$apply();
        }
      };
    },
  ],
  bindings: {
    urlAlias: "=",
    index: "=",
    callback: "&",
    removeCallback: "&",
  },
});

!(function (t) {
  var e = {};
  function i(n) {
    if (e[n]) return e[n].exports;
    var s = (e[n] = { i: n, l: !1, exports: {} });
    return t[n].call(s.exports, s, s.exports, i), (s.l = !0), s.exports;
  }
  (i.m = t),
    (i.c = e),
    (i.d = function (t, e, n) {
      i.o(t, e) || Object.defineProperty(t, e, { enumerable: !0, get: n });
    }),
    (i.r = function (t) {
      "undefined" != typeof Symbol &&
        Symbol.toStringTag &&
        Object.defineProperty(t, Symbol.toStringTag, { value: "Module" }),
        Object.defineProperty(t, "__esModule", { value: !0 });
    }),
    (i.t = function (t, e) {
      if ((1 & e && (t = i(t)), 8 & e)) return t;
      if (4 & e && "object" == typeof t && t && t.__esModule) return t;
      var n = Object.create(null);
      if (
        (i.r(n),
        Object.defineProperty(n, "default", { enumerable: !0, value: t }),
        2 & e && "string" != typeof t)
      )
        for (var s in t)
          i.d(
            n,
            s,
            function (e) {
              return t[e];
            }.bind(null, s)
          );
      return n;
    }),
    (i.n = function (t) {
      var e =
        t && t.__esModule
          ? function () {
              return t.default;
            }
          : function () {
              return t;
            };
      return i.d(e, "a", e), e;
    }),
    (i.o = function (t, e) {
      return Object.prototype.hasOwnProperty.call(t, e);
    }),
    (i.p = ""),
    i((i.s = 40));
})({
  40: function (t, e) {
    gapi.analytics.ready(function () {
      gapi.analytics.createComponent("ActiveUsers", {
        initialize: function () {
          (this.activeUsers = 0),
            gapi.analytics.auth.once("signOut", this.handleSignOut_.bind(this));
        },
        execute: function () {
          this.polling_ && this.stop(),
            this.render_(),
            gapi.analytics.auth.isAuthorized()
              ? this.pollActiveUsers_()
              : gapi.analytics.auth.once(
                  "signIn",
                  this.pollActiveUsers_.bind(this)
                );
        },
        stop: function () {
          clearTimeout(this.timeout_),
            (this.polling_ = !1),
            this.emit("stop", { activeUsers: this.activeUsers });
        },
        render_: function () {
          var t = this.get();
          (this.container =
            "string" == typeof t.container
              ? document.getElementById(t.container)
              : t.container),
            (this.container.innerHTML = t.template || this.template),
            (this.container.querySelector("b").innerHTML = this.activeUsers);
        },
        pollActiveUsers_: function () {
          var t = this.get(),
            e = 1e3 * (t.pollingInterval || 5);
          if (isNaN(e) || e < 5e3)
            throw new Error("Frequency must be 5 seconds or more.");
          (this.polling_ = !0),
            gapi.client.analytics.data.realtime
              .get({ ids: t.ids, metrics: "rt:activeUsers" })
              .then(
                function (t) {
                  var i = t.result,
                    n = i.totalResults ? +i.rows[0][0] : 0,
                    s = this.activeUsers;
                  this.emit("success", { activeUsers: this.activeUsers }),
                    n != s && ((this.activeUsers = n), this.onChange_(n - s)),
                    1 == this.polling_ &&
                      (this.timeout_ = setTimeout(
                        this.pollActiveUsers_.bind(this),
                        e
                      ));
                }.bind(this)
              );
        },
        onChange_: function (t) {
          var e = this.container.querySelector("b");
          e && (e.innerHTML = this.activeUsers),
            this.emit("change", { activeUsers: this.activeUsers, delta: t }),
            t > 0
              ? this.emit("increase", {
                  activeUsers: this.activeUsers,
                  delta: t,
                })
              : this.emit("decrease", {
                  activeUsers: this.activeUsers,
                  delta: t,
                });
        },
        handleSignOut_: function () {
          this.stop(),
            gapi.analytics.auth.once("signIn", this.handleSignIn_.bind(this));
        },
        handleSignIn_: function () {
          this.pollActiveUsers_(),
            gapi.analytics.auth.once("signOut", this.handleSignOut_.bind(this));
        },
        template:
          '<div class="ActiveUsers">Active Users: <b class="ActiveUsers-value"></b></div>',
      });
    });
  },
});
//# sourceMappingURL=active-users.js.map
