"use strict";
var app = angular.module("MixInit", [
  "ngRoute",
  "ngFileUpload",
  "LocalStorageModule",
  "components",
  "MixShared",
]);
var modules = angular.module("components", []);

app.config(function ($routeProvider, $locationProvider, $sceProvider) {
  $locationProvider.html5Mode(true);

  $routeProvider.when("/init", {
    controller: "Step1Controller",
    templateUrl: "/mix-app/views/app-init/pages/step1/index.html",
  });

  $routeProvider.when("/init/step2", {
    controller: "Step2Controller",
    templateUrl: "/mix-app/views/app-init/pages/step2/view.html",
  });
  $routeProvider.when("/init/step3", {
    controller: "Step3Controller",
    templateUrl: "/mix-app/views/app-init/pages/step3/view.html",
  });
  $routeProvider.when("/init/step4", {
    controller: "Step4Controller",
    templateUrl: "/mix-app/views/app-init/pages/step4/view.html",
  });
  $routeProvider.when("/init/step5", {
    controller: "Step5Controller",
    templateUrl: "/mix-app/views/app-init/pages/step5/view.html",
  });
  $routeProvider.otherwise({
    redirectTo: "/init",
  });
});

"use strict";
app.controller("Step1Controller", [
  "$scope",
  "$rootScope",
  "ngAppSettings",
  "$timeout",
  "$location",
  "$http",
  "ApiService",
  "CommonService",
  "Step1Services",
  function (
    $scope,
    $rootScope,
    ngAppSettings,
    $timeout,
    $location,
    $http,
    apiService,
    commonService,
    step1Services
  ) {
    var rand = Math.floor(Math.random() * 10000) + 1;
    $scope.settings = {
      providers: [
        {
          text: "MySQL Database",
          value: "MySQL",
          port: "3306",
          img: "/mix-app/assets/img/mysql.jpg",
        },
        {
          text: "Microsoft SQL Server Database",
          value: "MSSQL",
          port: null,
          img: "/mix-app/assets/img/mssql.jpg",
        },
        {
          text: "PostgreSQL Database",
          value: "PostgreSQL",
          port: "5432",
          img: "/mix-app/assets/img/postgresql.jpg",
        },
        {
          text: "SQLite Database",
          value: "SQLITE",
          port: null,
          img: "/mix-app/assets/img/sqlite.jpg",
        },
      ],
      cultures: [],
    };
    $scope.loadSettings = async function () {
      step1Services.saveDefaultSettings();
      var getCultures = await commonService.loadJArrayData("cultures.json");
      if (getCultures.isSucceed) {
        $scope.settings.cultures = getCultures.data;
        $scope.initCmsModel.culture = $scope.settings.cultures[0];
        $scope.dbProvider = $scope.settings.providers[0];
        $scope.initCmsModel.databaseProvider = $scope.dbProvider.value;
        $scope.initCmsModel.databasePort = $scope.dbProvider.port;
        $rootScope.isBusy = false;
        $scope.$apply();
      } else {
        if (getCultures) {
          $rootScope.showErrors(getCultures.errors);
        }
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };
    $scope.changeTypeDB = async function (type) {
      $scope.initCmsModel.isUseLocal = type;
    };

    $scope.canConnect = function () {
      return (
        ($scope.initCmsModel.databaseServer &&
          $scope.initCmsModel.databaseName &&
          $scope.initCmsModel.databaseUser &&
          $scope.initCmsModel.culture) ||
        ($scope.initCmsModel.databaseProvider == "SQLITE" &&
          $scope.initCmsModel.sqliteDbConnectionString)
      );
    };
    $scope.initCmsModel = {
      isUseLocal: false,
      localDbConnectionString:
        "Server=(localdb)\\MSSQLLocalDB;Initial Catalog=" +
        rand +
        "-mix-cms.db;Integrated Security=True;Persist Security Info=False;Pooling=False;MultipleActiveResultSets=False;Encrypt=False;TrustServerCertificate=True",
      sqliteDbConnectionString: "Data Source=MixContent\\mix-cms.db",
      localDbName: rand + "-mix-cms",
      databaseServer: "",
      databasePort: "",
      databaseName: "",
      databaseUser: "",
      databasePassword: "",
      adminPassword: "",
      lang: "en-us",
      isMysql: false,
      databaseProvider: "",
      culture: $scope.settings.cultures[0],
    };

    $scope.updateLocalDbName = function () {
      $scope.initCmsModel.localDbName = $scope.initCmsModel.localDbName + ".db";
      $scope.initCmsModel.localDbConnectionString =
        "Server=(localdb)\\mssqllocaldb;Database=" +
        $scope.initCmsModel.localDbName +
        ";Trusted_Connection=True;MultipleActiveResultSets=true";
      $scope.initCmsModel.sqliteDbConnectionString =
        "Data Source=" + $scope.initCmsModel.localDbName;
    };
    $scope.updateDbProvider = function () {
      $scope.initCmsModel.databaseProvider = $scope.dbProvider.value;
      $scope.initCmsModel.databasePort = $scope.dbProvider.port;
    };
    $scope.initCms = async function () {
      if (!$scope.canConnect()) {
        $rootScope.showErrors(["Please check your connection info"]);
        return;
      }
      $rootScope.isBusy = true;
      if ($scope.initCmsModel.siteName && $scope.initCmsModel.siteName != "") {
        var result = await step1Services.initCms($scope.initCmsModel);
        if (result.isSucceed) {
          $rootScope.isBusy = false;
          $rootScope.goToPath("/init/step2");
          $scope.$apply();
        } else {
          if (result) {
            $rootScope.showErrors(result.errors);
          }
          $rootScope.isBusy = false;
          $scope.$apply();
        }
      } else {
        $rootScope.showErrors(["Site name is required"]);
        $rootScope.isBusy = false;
      }
    };
  },
]);

"use strict";
app.factory("Step1Services", [
  "$http",
  "$rootScope",
  "AppSettings",
  "ApiService",
  "CommonService",
  function ($http, $rootScope, appSettings, apiService, commonService) {
    var step1ServiceFactory = {};
    var _saveDefaultSettings = async function () {
      var req = {
        method: "GET",
        url: "/portal/app-settings/save-default",
      };
      return apiService.getAnonymousApiResult(req);
    };

    var _initCms = async function (data) {
      var req = {
        method: "POST",
        url: "/init/init-cms/step-1",
        data: JSON.stringify(data),
      };
      return await apiService.getAnonymousApiResult(req);
    };

    step1ServiceFactory.initCms = _initCms;
    step1ServiceFactory.saveDefaultSettings = _saveDefaultSettings;
    return step1ServiceFactory;
  },
]);

"use strict";
app.controller("Step3Controller", [
  "$scope",
  "$rootScope",
  "ApiService",
  "CommonService",
  "AuthService",
  "StoreService",
  "Step3Services",
  function (
    $scope,
    $rootScope,
    apiService,
    commonService,
    authService,
    storeService,
    service
  ) {
    var rand = Math.random();
    $scope.data = {
      isCreateDefault: true,
      theme: null,
    };
    $scope.request = {
      pageSize: "20",
      pageIndex: 0,
      status: "Published",
      orderBy: "CreatedDateTime",
      direction: "Desc",
      fromDate: null,
      toDate: null,
      postType: "theme",
    };
    $scope.themeType = "materialkit";
    $scope.init = async function () {
      $scope.form = document.getElementById("frm-theme");
      var getThemes = await storeService.getThemes($scope.request);
      if (getThemes.isSucceed) {
        $scope.themes = getThemes.data;
        $scope.$apply();
      }
      $(".preventUncheck").on("change", function (e) {
        if ($(".preventUncheck:checked").length == 0 && !this.checked)
          this.checked = true;
      });
      $(".option").click(function () {
        $(".option").removeClass("active");
        $(this).addClass("active");
      });
    };
    $scope.submit = async function () {
      let theme = $scope.form["theme"].files[0];
      if ($scope.mode === "Upload your theme" && !theme) {
        $rootScope.showErrors(["Please select theme file"]);
        return;
      }
      $rootScope.isBusy = true;
      var frm = new FormData();
      var url = "/init/init-cms/step-3";
      $scope.data.isCreateDefault = $scope.themeType === "materialkit";
      $rootScope.isBusy = true;
      // Looping over all files and add it to FormData object
      frm.append("theme", theme);
      // Adding one more key to FormData object
      frm.append("model", angular.toJson($scope.data));
      var response = await service.ajaxSubmitForm(frm, url);
      if (response.isSucceed) {
        $scope.viewmodel = response.data;
        commonService.initAllSettings().then(function () {
          $rootScope.isBusy = false;
          setTimeout(() => {
            $rootScope.goToSiteUrl("/portal");
          }, 500);
          $scope.$apply();
        });
      } else {
        $rootScope.showErrors(response.errors);
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };
    $scope.install = function (resp) {
      if (resp.isSucceed) {
        $scope.activeTheme(resp.data);
      } else {
        $rootScope.showErrors(["Cannot install theme"]);
      }
    };
    $scope.selectPane = function (pane) {
      $scope.canContinue = pane.header !== "Mixcore Store";
      $scope.mode = pane.header;
    };
    $scope.activeTheme = async function (data) {
      $rootScope.isBusy = true;
      var url = "/init/init-cms/step-3/active";
      $rootScope.isBusy = true;
      // Looping over all files and add it to FormData object
      var response = await service.activeTheme(data);
      if (response.isSucceed) {
        $scope.viewmodel = response.data;
        commonService.initAllSettings().then(function () {
          $rootScope.isBusy = false;
          setTimeout(() => {
            $rootScope.goToSiteUrl("/portal");
          }, 500);
          $scope.$apply();
        });
      } else {
        $rootScope.showErrors(response.errors);
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };
  },
]);

"use strict";
app.factory("Step3Services", [
  "ApiService",
  function (apiService) {
    var service = {};
    var _submit = async function (data) {
      var req = {
        method: "POST",
        url: "/init/init-cms/step-3",
        data: JSON.stringify(data),
      };
      return await apiService.getApiResult(req);
    };
    var _activeTheme = async function (data) {
      var req = {
        method: "POST",
        url: "/init/init-cms/step-3/active",
        data: JSON.stringify(data),
      };
      return await apiService.getApiResult(req);
    };
    var _ajaxSubmitForm = async function (form, url) {
      var req = {
        method: "POST",
        url: url,
        headers: { "Content-Type": undefined },
        contentType: false, // Not to set any content header
        processData: false, // Not to process data
        data: form,
      };
      return await apiService.getApiResult(req);
    };
    service.submit = _submit;
    service.activeTheme = _activeTheme;
    service.ajaxSubmitForm = _ajaxSubmitForm;
    return service;
  },
]);

"use strict";
app.controller("Step2Controller", [
  "$scope",
  "$rootScope",
  "$location",
  "ApiService",
  "CommonService",
  "Step2Services",
  "AuthService",
  function (
    $scope,
    $rootScope,
    $location,
    apiService,
    commonService,
    services,
    authService
  ) {
    $scope.user = {
      username: "",
      email: "",
      password: "",
      confirmPassword: "",
      isAgreed: false,
    };
    $scope.init = async function () {};
    $scope.register = async function () {
      if (!$scope.user.isAgreed) {
        var ele = document.getElementById("notTNCYetChecked");
        ele.style.display = "block";
        // $rootScope.showMessage('Please agreed with our policy', 'warning');
      } else {
        if ($scope.password !== $scope.confirmPassword) {
          $rootScope.showErrors(["Confirm Password is not matched"]);
        } else {
          $rootScope.isBusy = true;
          var result = await services.register($scope.user);
          if (result.isSucceed) {
            await commonService.fillAllSettings();
            var loginData = {
              username: $scope.user.username,
              password: $scope.user.password,
              rememberMe: true,
            };
            var result = await authService.login(loginData);
            if (result.isSucceed) {
              $rootScope.isBusy = false;
              $rootScope.goToPath("/init/step3");
              $scope.$apply();
            } else {
              if (result) {
                $rootScope.showErrors(result.errors);
              }
              $rootScope.isBusy = false;
              $scope.$apply();
            }
          } else {
            if (result) {
              $rootScope.showErrors(result.errors);
            }
            $rootScope.isBusy = false;
            $scope.$apply();
          }
        }
      }
    };
    $scope.advanceSetup = async function () {
      if (!$scope.user.isAgreed) {
        var ele = document.getElementById("notTNCYetChecked");
        ele.style.display = "block";
        // $rootScope.showMessage('Please agreed with our policy', 'warning');
      } else {
        if ($scope.password !== $scope.confirmPassword) {
          $rootScope.showErrors(["Confirm Password is not matched"]);
        } else {
          $rootScope.isBusy = true;
          var result = await services.register($scope.user);
          if (result.isSucceed) {
            var loginData = {
              username: $scope.user.username,
              password: $scope.user.password,
              rememberMe: true,
            };
            var result = await authService.login(loginData);
            if (result) {
              $rootScope.isBusy = false;
              // $location.url('/init/step3');
              $scope.$apply();
            } else {
              if (result) {
                $rootScope.showErrors(result.errors);
              }
              $rootScope.isBusy = false;
              $scope.$apply();
            }
          } else {
            if (result) {
              $rootScope.showErrors(result.errors);
            }
            $rootScope.isBusy = false;
            $scope.$apply();
          }
        }
      }
    };
  },
]);

"use strict";
app.factory("Step2Services", [
  "$http",
  "ApiService",
  "CommonService",
  function ($http, apiService, commonService) {
    //var serviceBase = 'http://ngauthenticationapi.azurewebsites.net/';

    var usersServiceFactory = {};
    var _register = async function (user) {
      var req = {
        method: "POST",
        url: "/init/init-cms/step-2",
        data: JSON.stringify(user),
      };

      return await apiService.getApiResult(req);
    };

    usersServiceFactory.register = _register;
    return usersServiceFactory;
  },
]);

"use strict";
app.controller("Step4Controller", [
  "$scope",
  "$rootScope",
  "ApiService",
  "CommonService",
  "AuthService",
  "Step4Services",
  function (
    $scope,
    $rootScope,
    apiService,
    commonService,
    authService,
    service
  ) {
    var rand = Math.random();
    $scope.data = [];
    $scope.init = async function () {
      var getData = await commonService.loadJArrayData("languages.json");
      if (getData.isSucceed) {
        $scope.data = getData.data;
        $rootScope.isBusy = false;
        $scope.$apply();
      } else {
        if (getData) {
          $rootScope.showErrors(getData.errors);
        }
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };
    $scope.submit = async function () {
      $rootScope.isBusy = true;
      var result = await service.submit($scope.data);
      if (result.isSucceed) {
        authService.initSettings().then(function () {
          $rootScope.isBusy = false;
          window.top.location = "/";
        });
      } else {
        if (result) {
          $rootScope.showErrors(result.errors);
        }
        $rootScope.isBusy = false;
      }
    };
  },
]);

"use strict";
app.factory("Step4Services", [
  "ApiService",
  "CommonService",
  function (apiService, commonService) {
    var service = {};
    var _submit = async function (data) {
      var req = {
        method: "POST",
        url: "/init/init-cms/step-4",
        data: JSON.stringify(data),
      };
      return await apiService.getApiResult(req);
    };
    service.submit = _submit;
    return service;
  },
]);

"use strict";
app.controller("Step5Controller", [
  "$scope",
  "$rootScope",
  "$location",
  "ApiService",
  "CommonService",
  "Step5Services",
  function ($scope, $rootScope, $location, apiService, commonService, service) {
    var rand = Math.random();
    $scope.data = [];
    $scope.init = async function () {
      var getData = await commonService.loadJArrayData("configurations.json");
      if (getData.isSucceed) {
        $scope.data = getData.data;
        $rootScope.isBusy = false;
        $scope.$apply();
      } else {
        if (getData) {
          $rootScope.showErrors(getData.errors);
        }
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };
    $scope.submit = async function () {
      $rootScope.isBusy = true;
      var result = await service.submit($scope.data);
      if (result.isSucceed) {
        $rootScope.isBusy = false;
        window.top.location = "/";
      } else {
        if (result) {
          $rootScope.showErrors(result.errors);
        }
        $rootScope.isBusy = false;
      }
    };
  },
]);

"use strict";
app.factory("Step5Services", [
  "ApiService",
  "CommonService",
  function (apiService, commonService) {
    //var serviceBase = 'http://ngauthenticationapi.azurewebsites.net/';

    var service = {};
    var _submit = async function (data) {
      var req = {
        method: "POST",
        url: "/init/init-cms/step-5",
        data: JSON.stringify(data),
      };
      return await apiService.getApiResult(req);
    };
    service.submit = _submit;
    return service;
  },
]);

modules.component("mssqlInfo", {
  templateUrl:
    "/mix-app/views/app-init/pages/step1/components/mssql-info/view.html",
  controller: [
    "$rootScope",
    function ($rootScope) {
      var ctrl = this;
    },
  ],
  bindings: {
    initCmsModel: "=",
  },
});

modules.component("mysqlInfo", {
  templateUrl:
    "/mix-app/views/app-init/pages/step1/components/mysql-info/view.html",
  controller: [
    "$rootScope",
    function ($rootScope) {
      var ctrl = this;
    },
  ],
  bindings: {
    initCmsModel: "=",
  },
});

modules.component("mssqlLocalInfo", {
  templateUrl:
    "/mix-app/views/app-init/pages/step1/components/mssql-local-info/view.html",
  controller: [
    "$rootScope",
    function ($rootScope) {
      var ctrl = this;
    },
  ],
  bindings: {
    initCmsModel: "=",
  },
});

modules.component("posgresqlInfo", {
  templateUrl:
    "/mix-app/views/app-init/pages/step1/components/posgresql-info/view.html",
  controller: [
    "$rootScope",
    function ($rootScope) {
      var ctrl = this;
    },
  ],
  bindings: {
    initCmsModel: "=",
  },
});

modules.component("sqliteInfo", {
  templateUrl:
    "/mix-app/views/app-init/pages/step1/components/sqlite-info/view.html",
  controller: [
    "$rootScope",
    function ($rootScope) {
      var ctrl = this;
    },
  ],
  bindings: {
    initCmsModel: "=",
  },
});

app.component("initCommonLanguages", {
  templateUrl:
    "/mix-app/views/app-init/pages/step4/components/common-languages/view.html",
  controller: [
    "$rootScope",
    function ($rootScope) {
      var ctrl = this;
      ctrl.data = [];
      ctrl.$onInit = function () {
        ctrl.data = $rootScope.filterArray(
          ctrl.languages,
          ["category"],
          ["Common"]
        );
      };
    },
  ],
  bindings: {
    languages: "=",
  },
});

app.component("initPortalLanguages", {
  templateUrl:
    "/mix-app/views/app-init/pages/step4/components/portal-languages/view.html",
  controller: [
    "$rootScope",
    function ($rootScope) {
      var ctrl = this;
      ctrl.data = [];
      ctrl.$onInit = function () {
        ctrl.data = $rootScope.filterArray(
          ctrl.languages,
          ["category"],
          ["Portal"]
        );
      };
    },
  ],
  bindings: {
    languages: "=",
  },
});

app.component("initFbConfigurations", {
  templateUrl:
    "/mix-app/views/app-init/pages/step3/components/fb-configurations/view.html",
  controller: [
    "$rootScope",
    function ($rootScope) {
      var ctrl = this;
      ctrl.data = [];
      ctrl.$onInit = function () {
        ctrl.data = $rootScope.filterArray(
          ctrl.configurations,
          ["category"],
          ["Social_Facebook"]
        );
      };
    },
  ],
  bindings: {
    configurations: "=",
  },
});

app.component("initGgConfigurations", {
  templateUrl:
    "/mix-app/views/app-init/pages/step3/components/gg-configurations/view.html",
  controller: [
    "$rootScope",
    function ($rootScope) {
      var ctrl = this;
      ctrl.data = [];
      ctrl.$onInit = function () {
        ctrl.data = $rootScope.filterArray(
          ctrl.configurations,
          ["category"],
          ["Social_Google"]
        );
      };
    },
  ],
  bindings: {
    configurations: "=",
  },
});

modules.component("initValueEditor", {
  templateUrl:
    "/mix-app/views/app-init/pages/step3/components/init-value-editor/view.html",
  controller: [
    "$rootScope",
    "$scope",
    "ngAppSettings",
    "FileService",
    function ($rootScope, $scope, ngAppSettings, fileService) {
      var ctrl = this;
      ctrl.icons = ngAppSettings.icons;
      ctrl.mediaFile = {
        file: null,
        fullPath: "",
        fileFolder: "content/site",
        title: "",
        description: "",
      };
      this.dataTypes = ngAppSettings.dataTypes;
      ctrl.initEditor = function () {
        ctrl.data.value = ctrl.data.default || null;
        setTimeout(function () {
          // Init Code editor
          $.each($(".code-editor"), function (i, e) {
            var container = $(this);
            var editor = ace.edit(e);
            if (container.hasClass("json")) {
              editor.session.setMode("ace/mode/json");
            } else {
              editor.session.setMode("ace/mode/razor");
            }
            editor.setTheme("ace/theme/chrome");
            //editor.setReadOnly(true);

            editor.session.setUseWrapMode(true);
            editor.setOptions({
              maxLines: Infinity,
            });
            editor.getSession().on("change", function (e) {
              // e.type, etc
              $(container)
                .parent()
                .find(".code-content")
                .val(editor.getValue());
            });
          });
          $.each($(".editor-content"), function (i, e) {
            var $demoTextarea = $(e);
            $demoTextarea
              .trumbowyg({
                semantic: false,
              })
              .on("tbwblur", function () {
                ctrl.data.value = $demoTextarea.val();
              });
          });
        }, 200);
      };
      ctrl.selectFile = function (file, errFiles) {
        if (file !== undefined && file !== null) {
          ctrl.mediaFile.folder = ctrl.folder ? ctrl.folder : "Media";
          ctrl.mediaFile.title = ctrl.title ? ctrl.title : "";
          ctrl.mediaFile.description = ctrl.description ? ctrl.description : "";
          ctrl.mediaFile.file = file;

          ctrl.uploadFile(file);
        }
      };
      ctrl.uploadFile = async function (file) {
        if (file !== null) {
          $rootScope.isBusy = true;
          var reader = new FileReader();
          reader.readAsDataURL(file);
          reader.onload = async function () {
            ctrl.mediaFile.fileName = file.name.substring(
              0,
              file.name.lastIndexOf(".")
            );
            ctrl.mediaFile.extension = file.name.substring(
              file.name.lastIndexOf(".")
            );
            ctrl.mediaFile.fileStream = reader.result;
            var resp = await fileService.save(ctrl.mediaFile);
            if (resp && resp.isSucceed) {
              ctrl.data.value = resp.data.webPath;
              ctrl.srcUrl = resp.data.webPath;
              $rootScope.isBusy = false;
              $scope.$apply();
            } else {
              if (resp) {
                $rootScope.showErrors(resp.errors);
              }
              $rootScope.isBusy = false;
              $scope.$apply();
            }
          };
          reader.onerror = function (error) {};
        } else {
          return null;
        }
      };
    },
  ],
  bindings: {
    data: "=",
    inputClass: "=",
    isShowTitle: "=",
    title: "=",
  },
});

app.component("initSiteConfigurations", {
  templateUrl:
    "/mix-app/views/app-init/pages/step3/components/site-configurations/view.html",
  controller: [
    "$rootScope",
    function ($rootScope) {
      var ctrl = this;
      ctrl.data = [];
      ctrl.$onInit = function () {
        ctrl.data = $rootScope.filterArray(
          ctrl.configurations,
          ["category"],
          ["Site_Common"]
        );
      };
    },
  ],
  bindings: {
    configurations: "=",
  },
});

app.component("initSysConfigurations", {
  templateUrl:
    "/mix-app/views/app-init/pages/step3/components/site-configurations/view.html",
  controller: [
    "$rootScope",
    function ($rootScope) {
      var ctrl = this;
      ctrl.data = [];
      ctrl.$onInit = function () {
        ctrl.data = $rootScope.filterArray(
          ctrl.configurations,
          ["category"],
          ["System"]
        );
      };
    },
  ],
  bindings: {
    configurations: "=",
  },
});
