"use strict";

var app = angular.module("MixClient", [
  "ngRoute",
  "LocalStorageModule",
  "components",
  "ngFileUpload",
  "angularCroppie",
  "ui.bootstrap",
  "cart",
  "ngSanitize",
  "MixShared",
]);

var serviceBase = "";
var modules = angular.module("components", []);
var cart = angular.module("cart", []);

// This is the "Offline page" service worker
// Add this below content to your HTML page, or add the js file to your page at the very top to register service worker
// Check compatibility for the browser we're running this in
// if ("serviceWorker" in navigator) {
//     if (navigator.serviceWorker.controller) {
//         console.log("[PWA Builder] active service worker found, no need to register");
//     } else {
//         // Register the service worker
//         navigator.serviceWorker
//             .register("service-worker.js", {
//                 scope: "./"
//             })
//             .then(function (reg) {
//                 console.log("[PWA Builder] Service worker has been registered for scope: " + reg.scope);
//             });
//     }
// }

(function (angular) {
  "use strict";
  app.controller("AppClientController", [
    "$rootScope",
    "$scope",
    "$location",
    "$anchorScroll",
    "GlobalSettingsService",
    "CommonService",
    "AuthService",
    "localStorageService",
    "TranslatorService",
    "SharedModuleDataService",
    "RestMixDatabaseDataClientService",
    function (
      $rootScope,
      $scope,
      $location,
      $anchorScroll,
      globalSettingsService,
      commonService,
      authService,
      localStorageService,
      translatorService,
      moduleDataService,
      mixDatabaseDataService
    ) {
      $scope.lang = "";
      $scope.isInit = false;
      $scope.isLoaded = false;
      $rootScope.user = null;
      $scope.mediaFile = {
        file: null,
        fullPath: "",
        folder: "module-data",
        title: "",
        description: "",
      };
      $scope.cartData = {
        items: [],
        totalItem: 0,
        total: 0,
      };
      $rootScope.globalSettingsService = globalSettingsService;
      $scope.changeLang = $rootScope.changeLang;
      $scope.init = function (lang) {
        angular.element(document).ready(function () {
          setTimeout(() => {
            if ($location.hash()) {
              $scope.gotoElement($location.hash());
            }
          }, 100);
        });

        mixDatabaseDataService.init(
          mixDatabaseDataService.modelName,
          false,
          lang
        );
        if (!$rootScope.isBusy) {
          $rootScope.isBusy = true;
          // globalSettingsService.fillGlobalSettings().then(function (response) {
          $scope.cartData = localStorageService.get("shoppingCart");
          if (!$scope.cartData) {
            $scope.cartData = {
              items: [],
              totalItem: 0,
              total: 0,
            };
            localStorageService.set("shoppingCart", $scope.cartData);
          }
          commonService.fillAllSettings(lang).then(function (response) {
            if ($rootScope.globalSettings) {
              authService.fillAuthData().then(function (response) {
                $rootScope.authentication = authService.authentication;
                $scope.isInit = true;
                $rootScope.isInit = true;
                $rootScope.isBusy = false;
                $scope.$apply();
              });

              // });
            } else {
              $scope.isInit = true;
              $rootScope.isInit = true;
              $rootScope.isBusy = false;
            }
          });

          // });
        }

        // $(document).on('click', 'a', function(e){
        //     var href = $(this).attr('href');
        //     var target = $(this).attr('target');
        //     if(!$(this).hasClass('each-portfolio') && href && href.indexOf('#') !== 0 && target!='_blank'){
        //         e.preventDefault();
        //         $scope.$apply($scope.isBusy = true);
        //         setTimeout(() => {
        //             // window.location.href = href;
        //             window.open(href, target || '_top');
        //         }, (200));
        //     }
        // });
      };

      $scope.translate = $rootScope.translate;
      $scope.gotoElement = function (eID) {
        // call $anchorScroll()
        if (!document.getElementById(eID)) {
          window.location = `/#${eID}`;
        }
        $scope.scrollTo(eID);
      };

      $scope.scrollTo = function (eID) {
        // This scrolling function
        // is from http://www.itnewb.com/tutorial/Creating-the-Smooth-Scroll-Effect-with-JavaScript

        var startY = currentYPosition();
        var stopY = elmYPosition(eID);
        var distance = stopY > startY ? stopY - startY : startY - stopY;
        if (distance < 100) {
          scrollTo(0, stopY);
          return;
        }
        var speed = Math.round(distance / 100);
        if (speed >= 20) speed = 20;
        var step = Math.round(distance / 25);
        var leapY = stopY > startY ? startY + step : startY - step;
        var timer = 0;
        if (stopY > startY) {
          for (var i = startY; i < stopY; i += step) {
            setTimeout("window.scrollTo(0, " + leapY + ")", timer * speed);
            leapY += step;
            if (leapY > stopY) leapY = stopY;
            timer++;
          }
          return;
        }
        for (var i = startY; i > stopY; i -= step) {
          setTimeout("window.scrollTo(0, " + leapY + ")", timer * speed);
          leapY -= step;
          if (leapY < stopY) leapY = stopY;
          timer++;
        }

        function currentYPosition() {
          // Firefox, Chrome, Opera, Safari
          if (self.pageYOffset) return self.pageYOffset;
          // Internet Explorer 6 - standards mode
          if (document.documentElement && document.documentElement.scrollTop)
            return document.documentElement.scrollTop;
          // Internet Explorer 6, 7 and 8
          if (document.body.scrollTop) return document.body.scrollTop;
          return 0;
        }

        function elmYPosition(eID) {
          var elm = document.getElementById(eID);
          var y = elm.offsetTop;
          var node = elm;
          while (node.offsetParent && node.offsetParent != document.body) {
            node = node.offsetParent;
            y += node.offsetTop;
          }
          return y;
        }
      };
      $scope.previewData = function (moduleId, id) {
        var obj = {
          moduleId: moduleId,
          id: id,
        };
        $rootScope.preview("module-data", obj, null, "modal-lg");
      };

      $scope.initModuleForm = async function (
        name,
        successCallback,
        failCallback
      ) {
        var resp = null;
        $scope.successCallback = successCallback;
        $scope.failCallback = failCallback;
        setTimeout(async () => {
          $scope.name = name;
          if ($scope.id) {
            resp = await moduleDataService.getModuleData(
              $scope.id,
              $scope.dataId,
              "portal"
            );
          } else {
            resp = await moduleDataService.initModuleForm($scope.name);
          }

          if (resp && resp.isSucceed) {
            $scope.activedModuleData = resp.data;
            $rootScope.isBusy = false;
            $scope.$apply();
          } else {
            if (resp) {
              if ($scope.errorCallback) {
                $rootScope.executeFunctionByName(
                  $scope.errorCallback,
                  [resp],
                  window
                );
              } else {
                $rootScope.showErrors(resp.errors);
              }
            }
            $rootScope.isBusy = false;
            $scope.$apply();
          }
        }, 500);
      };

      $scope.initMixDatabaseForm = async function (formName) {
        return await mixDatabaseDataService.initData(formName).data;
      };

      $scope.saveModuleData = async function () {
        var resp = await moduleDataService.saveModuleData(
          $scope.activedModuleData
        );
        if (resp && resp.isSucceed) {
          $scope.activedModuleData = resp.data;
          if ($scope.successCallback) {
            $rootScope.executeFunctionByName(
              $scope.successCallback,
              [resp],
              window
            );
          } else {
            var msg =
              $rootScope.localizeSettings.data["employee_success_msg"] ||
              "Thank you for submitting! Your lovely photo is well received 😊";
            $rootScope.showConfirm($scope, "", [], null, "", msg);
          }

          $rootScope.isBusy = false;
          $scope.initModuleForm($scope.name);
          $rootScope.isBusy = false;
          $scope.$apply();
        } else {
          if (resp) {
            if ($scope.failCallback) {
              $rootScope.executeFunctionByName(
                $scope.failCallback,
                [resp],
                window
              );
            } else {
              $rootScope.showErrors(resp.errors);
            }
          }
          $rootScope.isBusy = false;
          $scope.$apply();
        }
      };
      $scope.shareFB = function (url) {
        FB.ui(
          {
            method: "share",
            href: url,
          },
          function (response) {}
        );
      };
      $scope.shareTwitter = function (url, content) {
        var text = encodeURIComponent(content);
        var shareUrl =
          "https://twitter.com/intent/tweet?url=" + url + "&text=" + text;
        var win = window.open(shareUrl, "ShareOnTwitter", getWindowOptions());
        win.opener = null; // 2
      };
      $scope.saveShoppingCart = function () {
        localStorageService.set("shoppingCart", $scope.cartData);
      };

      var getWindowOptions = function () {
        var width = 500;
        var height = 350;
        var left = window.innerWidth / 2 - width / 2;
        var top = window.innerHeight / 2 - height / 2;

        return [
          "resizable,scrollbars,status",
          "height=" + height,
          "width=" + width,
          "left=" + left,
          "top=" + top,
        ].join();
      };
      window.load = function () {
        $scope.$apply(($scope.isLoaded = true));
      };
    },
  ]);
})(window.angular);

modules.component("addToCartButton", {
  templateUrl:
    "/mix-app/views/app-client/components/add-to-cart-button/view.html",
  bindings: {
    cartData: "=",
    propertyId: "=",
    title: "=",
    imageUrl: "=",
    price: "=",
    quantity: "=?",
  },
  controller: "AddToCartController",
});
modules.controller("AddToCartController", [
  "$rootScope",
  "$scope",
  "localStorageService",
  function ($rootScope, $scope, localStorageService) {
    $scope.init = function () {
      $scope.quantity = $scope.quantity || 1;
    };
    $scope.addToCart = function () {
      var current = $rootScope.findObjectByKey(
        $scope.cartData.items,
        "propertyId",
        $scope.propertyId
      );
      if (current) {
        current.quantity += parseInt($scope.quantity);
      } else {
        var item = {
          propertyId: $scope.propertyId,
          title: $scope.title,
          imageUrl: $scope.imageUrl,
          price: $scope.price,
          quantity: parseInt($scope.quantity) || 1,
        };
        $scope.cartData.items.push(item);
        $scope.cartData.totalItem += 1;
      }
      $scope.cartData.total += parseInt($scope.price);
      localStorageService.set("shoppingCart", $scope.cartData);
    };
  },
]);

modules.component("booking", {
  templateUrl: "/mix-app/views/app-client/components/booking/index.html",
  controller: [
    "$rootScope",
    "ApiService",
    "CommonService",
    function ($rootScope, apiService, commonService) {
      var ctrl = this;
      ctrl.submitted = false;
      ctrl.isShow = false;
      ctrl.order = {
        name: "",
        propertyId: "",
        price: "",
        quantity: 1,
      };
      ctrl.edm =
        'Url: <a href="[url]">View Tour</a> <br/>Name: [name] <br/>' +
        "Phone: [phone]<br/>" +
        "Email: [email]<br/>" +
        "Quantity: [quantity]<br/>" +
        "Message: [message] <br/>" +
        "property: [property] <br/>Price: [price] <br/>";
      ctrl.init = function () {
        if (!$rootScope.isInit) {
          setTimeout(function () {
            ctrl.init();
          }, 500);
        } else {
          ctrl.order.propertyId = ctrl.propertyId;
          ctrl.order.price = ctrl.price;
          ctrl.order.quantity = ctrl.quantity;
        }
      };
      ctrl.book = function () {
        ctrl.edm = ctrl.edm.replace(/\[url\]/g, window.top.location.href);
        ctrl.edm = ctrl.edm.replace(/\[name\]/g, ctrl.order.name);
        ctrl.edm = ctrl.edm.replace(/\[phone\]/g, ctrl.order.phone);
        ctrl.edm = ctrl.edm.replace(/\[email\]/g, ctrl.order.email);
        ctrl.edm = ctrl.edm.replace(/\[message\]/g, ctrl.order.message);
        ctrl.edm = ctrl.edm.replace(/\[property\]/g, ctrl.order.propertyId);
        ctrl.edm = ctrl.edm.replace(/\[price\]/g, ctrl.order.price);
        ctrl.edm = ctrl.edm.replace(/\[quantity\]/g, ctrl.order.quantity);

        commonService.sendMail("Booking - " + ctrl.propertyName, ctrl.edm);
        ctrl.submitted = true;
      };
    },
  ],
  bindings: {
    propertyId: "=",
    propertyName: "=",
    price: "=",
    quantity: "=",
  },
});

modules.component("fbCustomerChat", {
  templateUrl:
    "/mix-app/views/app-client/components/fb-customer-chat/view.html",
  controller: [
    "$location",
    function ($location) {
      var ctrl = this;
      this.$onInit = function () {
        setTimeout(() => {
          FB.XFBML.parse();
        }, 200);
      };
    },
  ],
  bindings: {
    fbPageId: "=",
    themeColor: "=",
    inGreeting: "=",
    outGreeting: "=",
  },
});

modules.component("fbSend", {
  templateUrl: "/mix-app/views/app-client/components/fb-send/fb-send.html",
  controller: [
    "$location",
    function ($location) {
      var ctrl = this;
      ctrl.href = ctrl.href || window.top.location.href;
      ctrl.send = function () {
        var link = ctrl.href || window.top.location.href;
        FB.ui(
          {
            method: "send",
            link: link,
          },
          function (response) {}
        );
      };
    },
  ],
  bindings: {
    href: "=",
    appId: "=",
  },
});

modules.component("fbLike", {
  templateUrl: "/mix-app/views/app-client/components/fb-like/fb-like.html",
  controller: [
    "$location",
    function ($location) {
      var ctrl = this;
      ctrl.href = ctrl.href || window.top.location.href;
      ctrl.layout = ctrl.layout || "standard";
      ctrl.size = ctrl.size || "small";
      ctrl.showFaces = ctrl.showFaces || true;
      this.$onInit = function () {
        setTimeout(() => {
          FB.XFBML.parse();
        }, 200);
      };
    },
  ],
  bindings: {
    href: "=",
    layout: "=",
    size: "=",
    showFaces: "=",
  },
});

modules.component("mixMessagesHubClient", {
  templateUrl:
    "/mix-app/views/app-client/components/mix-messages-hub-client/view.html",
  bindings: {
    mixDatabaseName: "=",
    isSave: "=?",
  },
  controller: [
    "$rootScope",
    "$scope",
    "RestMixDatabaseColumnPortalService",
    "RestMixDatabaseDataClientService",
    function ($rootScope, $scope, columnService, service) {
      var ctrl = this;
      BaseHub.call(this, ctrl);
      ctrl.localizeSettings = $rootScope.globalSettings;
      ctrl.user = {
        loggedIn: false,
        connection: {},
      };
      ctrl.mixDatabaseData = null;
      ctrl.isHide = true;
      ctrl.hideContact = true;
      ctrl.columns = [];
      ctrl.members = [];
      ctrl.errors = [];
      ctrl.messages = {
        items: [],
      };
      ctrl.message = { connection: {}, content: "" };
      ctrl.request = {
        uid: "",
        specificulture: "",
        action: "",
        objectType: null,
        data: {},
        room: "",
        isMyself: true,
        isSave: false,
      };
      ctrl.init = function () {
        ctrl.mixDatabaseId = ctrl.mixDatabaseId || 0;
        ctrl.request.specificulture = service.lang;
        ctrl.request.room = ctrl.mixDatabaseName;
        ctrl.request.isSave = ctrl.isSave || false;
        ctrl.startConnection("serviceHub", ctrl.checkLoginStatus);
      };
      ctrl.loadData = async function () {
        /*
                    If input is data id => load ctrl.mixDatabaseData from service and handle it independently
                    Else modify input ctrl.mixDatabaseData
                */
        $rootScope.isBusy = true;
        var getDefault = await service.initData(ctrl.mixDatabaseName);
        if (getDefault.isSucceed) {
          ctrl.defaultData = getDefault.data;
          ctrl.defaultData.data.user_name = ctrl.user.connection.name;
          ctrl.defaultData.data.user_id = ctrl.user.connection.id;
          ctrl.defaultData.data.user_avatar = ctrl.user.connection.avatar;
          ctrl.defaultData.data.data_type = 9;
          ctrl.defaultData.column = {
            dataType: "Text",
            title: "Message",
            name: "message",
          };
          ctrl.mixDatabaseData = angular.copy(ctrl.defaultData);
          $rootScope.isBusy = false;
        }
        var getFields = await columnService.initData(ctrl.mixDatabaseName);
        if (getFields.isSucceed) {
          ctrl.columns = getFields.data;
          ctrl.msgField = $rootScope.findObjectByKey(
            ctrl.columns,
            "name",
            "message"
          );
        }
      };
      ctrl.submit = async function () {
        if (ctrl.validate()) {
          ctrl.request.action = "send_group_message";
          ctrl.request.uid = ctrl.user.connection.id;
          ctrl.request.data = ctrl.mixDatabaseData.data;
          ctrl.request.connection = ctrl.user.connection;
          ctrl.connection.invoke("HandleRequest", JSON.stringify(ctrl.request));
          ctrl.mixDatabaseData = angular.copy(ctrl.defaultData);
        }
      };
      ctrl.validate = function () {
        var isValid = true;
        ctrl.errors = [];
        angular.forEach(ctrl.columns, function (column) {
          if (column.regex) {
            var regex = RegExp(column.regex, "g");
            isValid = regex.test(ctrl.mixDatabaseData.data[column.name]);
            if (!isValid) {
              if (column.name == "message") {
                ctrl.errors.push("Please don't use bad words in your message");
              } else {
                ctrl.errors.push(`${column.name} is not match Regex`);
              }
            }
          }
          if (isValid && column.isEncrypt) {
            ctrl.mixDatabaseData.data[column.name] = $rootScope.encrypt(
              ctrl.mixDatabaseData.data[column.name]
            );
          }
        });
        return isValid;
      };
      ctrl.receiveMessage = function (msg) {
        switch (msg.responseKey) {
          case "NewMember":
            ctrl.newMember(msg.data);
            // $('.widget-conversation').scrollTop = $('.widget-conversation')[0].scrollHeight;
            break;
          case "NewMessage":
            ctrl.newMessage(msg.data);
            break;
          case "ConnectSuccess":
            ctrl.user.loggedIn = true;
            ctrl.initListMember(msg.data);
            $scope.$apply();
            break;
          case "PreviousMessages":
            msg.data.items.forEach((element) => {
              element.msgField = angular.copy(ctrl.msgField);
              element.msgField.dataType = element.data.data_type;
            });
            ctrl.messages = msg.data;
            $scope.$apply();
            break;
          case "MemberOffline":
            ctrl.removeMember(msg.data);
            break;
          case "Error":
            console.error(msg.data);
            break;
        }
      };
      ctrl.newMessage = function (msg) {
        msg.msgField = angular.copy(ctrl.msgField);
        ctrl.messages.items.push(msg);
        $scope.$apply();
      };
      ctrl.newMember = function (member) {
        var m = $rootScope.findObjectByKey(ctrl.members, "id", member.id);
        if (!m) {
          ctrl.members.push(member);
        }
        $scope.$apply();
      };
      ctrl.join = async function () {
        ctrl.request.action = "join_group";
        ctrl.request.uid = ctrl.user.connection.id;
        ctrl.request.data = ctrl.user.connection;
        ctrl.message.connection = ctrl.user.connection;
        ctrl.connection.invoke("HandleRequest", JSON.stringify(ctrl.request));
        await ctrl.loadData();
        $scope.$apply();
      };
      ctrl.initListMember = function (data) {
        data.forEach((member) => {
          var index = ctrl.members.findIndex((x) => x.id === member.id);
          if (index < 0) {
            ctrl.members.splice(0, 0, member);
          }
        });

        $scope.$apply();
      };
      ctrl.updateDataType = function () {
        ctrl.mixDatabaseData.data.data_type = ctrl.msgField.dataType;
      };
      ctrl.checkLoginStatus = function () {
        FB.getLoginStatus(function (response) {
          if (response.status === "connected") {
            // The user is logged in and has authenticated your
            // app, and response.authResponse supplies
            // the user's ID, a valid access token, a signed
            // request, and the time the access token
            // and signed request each expire.
            FB.api("/me", function (response) {
              ctrl.user.connection.name = response.name;
              ctrl.user.connection.id = response.id;
              ctrl.user.connection.connectionId = ctrl.connection.connectionId;
              ctrl.user.connection.avatar =
                "//graph.facebook.com/" +
                response.id +
                "/picture?width=32&height=32";
              ctrl.user.loggedIn = true;
              ctrl.join();
            });
          } else if (response.status === "authorization_expired") {
            // The user has signed into your application with
            // Facebook Login but must go through the login flow
            // again to renew data authorization. You might remind
            // the user they've used Facebook, or hide other options
            // to avoid duplicate account creation, but you should
            // collect a user gesture (e.g. click/touch) to launch the
            // login dialog so popup blocking is not triggered.
          } else if (response.status === "not_authorized") {
            // The user hasn't authorized your application.  They
            // must click the Login button, or you must call FB.login
            // in response to a user gesture, to launch a login dialog.
          } else {
            // The user isn't logged in to Facebook. You can launch a
            // login dialog with a user gesture, but the user may have
            // to log in to Facebook before authorizing your application.
          }
        });
      };
      ctrl.logout = function () {
        FB.logout(function (response) {
          // user is now logged out
          ctrl.user.loggedIn = false;
        });
      };
      ctrl.login = function () {
        FB.login(function (response) {
          if (response.authResponse) {
            FB.api("/me", function (response) {
              ctrl.user.connection.name = response.name;
              ctrl.user.connection.id = response.id;
              ctrl.user.connection.connectionId = ctrl.connection.connectionId;
              ctrl.user.connection.avatar =
                "//graph.facebook.com/" +
                response.id +
                "/picture?width=32&height=32";
              ctrl.user.loggedIn = true;
              ctrl.join();
              $scope.$apply();
            });
          } else {
            console.log("User cancelled login or did not fully authorize.");
          }
        });
      };
    },
  ],
});

modules.component("fbShare", {
  templateUrl: "/mix-app/views/app-client/components/fb-share/fb-share.html",
  controller: [
    "$location",
    function ($location) {
      var ctrl = this;
      ctrl.href = ctrl.href || window.top.location.href;
      ctrl.share = function () {
        var href = window.top.location.href;
        FB.ui(
          {
            method: "share",
            href: href,
          },
          function (response) {}
        );
      };
    },
  ],
  bindings: {
    href: "=",
  },
});

modules.component("serviceHubClient", {
  templateUrl:
    "/mix-app/views/app-client/components/service-hub-client/view.html",
  bindings: {
    mixDatabaseName: "=",
    isSave: "=?",
  },
  controller: [
    "$rootScope",
    "$scope",
    "RestMixDatabaseColumnPortalService",
    "RestMixDatabaseDataClientService",
    function ($rootScope, $scope, columnService, service) {
      var ctrl = this;
      BaseHub.call(this, ctrl);
      ctrl.localizeSettings = $rootScope.globalSettings;
      ctrl.user = {
        loggedIn: false,
        connection: {},
      };
      ctrl.mixDatabaseData = null;
      ctrl.isHide = true;
      ctrl.hideContact = true;
      ctrl.columns = [];
      ctrl.members = [];
      ctrl.errors = [];
      ctrl.messages = {
        items: [],
      };
      ctrl.message = { connection: {}, content: "" };
      ctrl.request = {
        uid: "",
        specificulture: "",
        action: "",
        objectType: null,
        data: {},
        room: "",
        isMyself: true,
        isSave: false,
      };
      ctrl.init = function () {
        ctrl.mixDatabaseId = ctrl.mixDatabaseId || 0;
        ctrl.request.specificulture = service.lang;
        ctrl.request.room = ctrl.mixDatabaseName;
        ctrl.request.isSave = ctrl.isSave == "true" || false;
        ctrl.startConnection("serviceHub", ctrl.checkLoginStatus);
      };
      ctrl.loadData = async function () {
        /*
                    If input is data id => load ctrl.mixDatabaseData from service and handle it independently
                    Else modify input ctrl.mixDatabaseData
                */
        $rootScope.isBusy = true;
        var getDefault = await service.initData(ctrl.mixDatabaseName);
        if (getDefault.isSucceed) {
          ctrl.defaultData = getDefault.data;
          ctrl.defaultData.data.user_name = ctrl.user.connection.name;
          ctrl.defaultData.data.user_id = ctrl.user.connection.id;
          ctrl.defaultData.data.user_avatar = ctrl.user.connection.avatar;
          ctrl.defaultData.data.data_type = 9;
          ctrl.mixDatabaseData = angular.copy(ctrl.defaultData);
          $rootScope.isBusy = false;
        }
        var getFields = await columnService.initData(ctrl.mixDatabaseName);
        if (getFields.isSucceed) {
          ctrl.columns = getFields.data;
        }
      };
      ctrl.submit = async function () {
        if (ctrl.validate()) {
          ctrl.request.action = "send_group_message";
          ctrl.request.uid = ctrl.user.connection.id;
          ctrl.request.data = ctrl.mixDatabaseData.data;
          ctrl.request.connection = ctrl.user.connection;
          ctrl.connection.invoke("HandleRequest", JSON.stringify(ctrl.request));
          ctrl.mixDatabaseData = angular.copy(ctrl.defaultData);
        }
      };
      ctrl.validate = function () {
        var isValid = true;
        ctrl.errors = [];
        angular.forEach(ctrl.columns, function (column) {
          if (column.regex) {
            var regex = RegExp(column.regex, "g");
            isValid = regex.test(ctrl.mixDatabaseData.data[column.name]);
            if (!isValid) {
              ctrl.errors.push(`${column.name} is not match Regex`);
            }
          }
          if (isValid && column.isEncrypt) {
            ctrl.mixDatabaseData.data[column.name] = $rootScope.encrypt(
              ctrl.mixDatabaseData.data[column.name]
            );
          }
        });
        return isValid;
      };
      ctrl.receiveMessage = function (msg) {
        switch (msg.responseKey) {
          case "NewMember":
            ctrl.newMember(msg.data);
            // $('.widget-conversation').scrollTop = $('.widget-conversation')[0].scrollHeight;
            break;
          case "NewMessage":
            ctrl.newMessage(msg.data);
            break;
          case "ConnectSuccess":
            ctrl.user.loggedIn = true;
            ctrl.initListMember(msg.data);
            $scope.$apply();
            break;
          case "PreviousMessages":
            ctrl.messages = msg.data;
            $scope.$apply();
            break;
          case "MemberOffline":
            ctrl.removeMember(msg.data);
            break;
          case "Error":
            console.error(msg.data);
            break;
        }
      };
      ctrl.newMessage = function (msg) {
        ctrl.messages.items.push(msg);
        $scope.$apply();
      };
      ctrl.newMember = function (member) {
        var m = $rootScope.findObjectByKey(ctrl.members, "id", member.id);
        if (!m) {
          ctrl.members.push(member);
        }
        $scope.$apply();
      };
      ctrl.join = async function () {
        ctrl.request.action = "join_group";
        ctrl.request.uid = ctrl.user.connection.id;
        ctrl.request.data = ctrl.user.connection;
        ctrl.message.connection = ctrl.user.connection;
        ctrl.connection.invoke("HandleRequest", JSON.stringify(ctrl.request));
        await ctrl.loadData();
        $scope.$apply();
      };
      ctrl.initListMember = function (data) {
        data.forEach((member) => {
          var index = ctrl.members.findIndex((x) => x.id === member.id);
          if (index < 0) {
            ctrl.members.splice(0, 0, member);
          }
        });

        $scope.$apply();
      };

      ctrl.checkLoginStatus = function () {
        FB.getLoginStatus(function (response) {
          if (response.status === "connected") {
            // The user is logged in and has authenticated your
            // app, and response.authResponse supplies
            // the user's ID, a valid access token, a signed
            // request, and the time the access token
            // and signed request each expire.
            FB.api("/me", function (response) {
              ctrl.user.connection.name = response.name;
              ctrl.user.connection.id = response.id;
              ctrl.user.connection.connectionId = ctrl.connection.connectionId;
              ctrl.user.connection.avatar =
                "//graph.facebook.com/" +
                response.id +
                "/picture?width=32&height=32";
              ctrl.user.loggedIn = true;
              ctrl.join();
            });
          } else if (response.status === "authorization_expired") {
            // The user has signed into your application with
            // Facebook Login but must go through the login flow
            // again to renew data authorization. You might remind
            // the user they've used Facebook, or hide other options
            // to avoid duplicate account creation, but you should
            // collect a user gesture (e.g. click/touch) to launch the
            // login dialog so popup blocking is not triggered.
          } else if (response.status === "not_authorized") {
            // The user hasn't authorized your application.  They
            // must click the Login button, or you must call FB.login
            // in response to a user gesture, to launch a login dialog.
          } else {
            // The user isn't logged in to Facebook. You can launch a
            // login dialog with a user gesture, but the user may have
            // to log in to Facebook before authorizing your application.
          }
        });
      };
      ctrl.logout = function () {
        FB.logout(function (response) {
          // user is now logged out
          ctrl.user.loggedIn = false;
        });
      };
      ctrl.login = function () {
        FB.login(function (response) {
          if (response.authResponse) {
            FB.api("/me", function (response) {
              ctrl.user.connection.name = response.name;
              ctrl.user.connection.id = response.id;
              ctrl.user.connection.connectionId = ctrl.connection.connectionId;
              ctrl.user.connection.avatar =
                "//graph.facebook.com/" +
                response.id +
                "/picture?width=32&height=32";
              ctrl.user.loggedIn = true;
              ctrl.join();
              $scope.$apply();
            });
          } else {
            console.log("User cancelled login or did not fully authorize.");
          }
        });
      };
    },
  ],
});

app.factory("ConnectionManager", [
  function () {
    var serviceFactory = {};
    var _signaler,
      _connections = {},
      _iceServers = [
        { urls: "stun:ec2-54-176-1-181.us-west-1.compute.amazonaws.com:3478" },
        {
          urls: "turn:ec2-54-176-1-181.us-west-1.compute.amazonaws.com:3478",
          username: "tadhackuser",
          credential: "tadhackpw",
        },
      ], // stun.l.google.com - Firefox does not support DNS names.
      /* Callbacks */
      _onReadyForStreamCallback = function () {
        console.log("UNIMPLEMENTED: _onReadyForStreamCallback");
      },
      _onStreamAddedCallback = function () {
        console.log("UNIMPLEMENTED: _onStreamAddedCallback");
      },
      _onStreamRemovedCallback = function () {
        console.log("UNIMPLEMENTED: _onStreamRemovedCallback");
      },
      // Initialize the ConnectionManager with a signaler and callbacks to handle events
      _initialize = function (
        signaler,
        onReadyForStream,
        onStreamAdded,
        onStreamRemoved
      ) {
        _signaler = signaler;
        _onReadyForStreamCallback =
          onReadyForStream || _onReadyForStreamCallback;
        _onStreamAddedCallback = onStreamAdded || _onStreamAddedCallback;
        _onStreamRemovedCallback = onStreamRemoved || _onStreamRemovedCallback;
      },
      // Create a new WebRTC Peer Connection with the given partner
      _createConnection = function (partnerClientId) {
        console.log("WebRTC: creating connection...");

        // Create a new PeerConnection
        var connection = new RTCPeerConnection({
          iceServers: _iceServers,
          voiceActivityDetection: false,
        });

        // ICE Candidate Callback
        connection.onicecandidate = function (event) {
          if (event.candidate) {
            // Found a new candidate
            console.log("WebRTC: new ICE candidate");
            _signaler.invoke(
              "sendSignal",
              JSON.stringify({ candidate: event.candidate }),
              partnerClientId
            );
          } else {
            // Null candidate means we are done collecting candidates.
            console.log("WebRTC: ICE candidate gathering complete");
          }
        };

        // State changing
        connection.onstatechange = function () {
          // Not doing anything here, but interesting to see the state transitions
          var states = {
            iceConnectionState: connection.iceConnectionState,
            iceGatheringState: connection.iceGatheringState,
            readyState: connection.readyState,
            signalingState: connection.signalingState,
          };

          console.log(JSON.stringify(states));
        };

        // Stream handlers
        connection.onaddstream = function (event) {
          console.log("WebRTC: adding stream");
          // A stream was added, so surface it up to our UI via callback
          _onStreamAddedCallback(connection, event);
        };

        connection.onremovestream = function (event) {
          console.log("WebRTC: removing stream");
          // A stream was removed
          _onStreamRemovedCallback(connection, event.stream.id);
        };

        // Store away the connection
        _connections[partnerClientId] = connection;

        // And return it
        return connection;
      },
      // Process a newly received SDP signal
      _receivedSdpSignal = function (connection, partnerClientId, sdp) {
        console.log("WebRTC: processing sdp signal");
        connection.setRemoteDescription(
          new RTCSessionDescription(sdp),
          function () {
            if (connection.remoteDescription.type == "offer") {
              console.log("WebRTC: received offer, sending response...");
              _onReadyForStreamCallback(connection);
              connection.createAnswer(
                function (desc) {
                  connection.setLocalDescription(desc, function () {
                    _signaler.invoke(
                      "sendSignal",
                      JSON.stringify({ sdp: connection.localDescription }),
                      partnerClientId
                    );
                  });
                },
                function (error) {
                  console.log("Error creating session description: " + error);
                }
              );
            } else if (connection.remoteDescription.type == "answer") {
              console.log("WebRTC: received answer");
            }
          }
        );
      },
      // Hand off a new signal from the signaler to the connection
      _newSignal = function (partnerClientId, data) {
        var signal = JSON.parse(data),
          connection = _getConnection(partnerClientId);

        console.log("WebRTC: received signal");

        // Route signal based on type
        if (signal.sdp) {
          _receivedSdpSignal(connection, partnerClientId, signal.sdp);
        } else if (signal.candidate) {
          _receivedCandidateSignal(
            connection,
            partnerClientId,
            signal.candidate
          );
        }
      },
      // Process a newly received Candidate signal
      _receivedCandidateSignal = function (
        connection,
        partnerClientId,
        candidate
      ) {
        console.log("WebRTC: processing candidate signal");
        connection.addIceCandidate(new RTCIceCandidate(candidate));
      },
      // Retreive an existing or new connection for a given partner
      _getConnection = function (partnerClientId) {
        var connection =
          _connections[partnerClientId] || _createConnection(partnerClientId);
        return connection;
      },
      // Close all of our connections
      _closeAllConnections = function () {
        for (var connectionId in _connections) {
          _closeConnection(connectionId);
        }
      },
      // Close the connection between myself and the given partner
      _closeConnection = function (partnerClientId) {
        var connection = _connections[partnerClientId];

        if (connection) {
          // Let the user know which streams are leaving
          // todo: foreach connection.remoteStreams -> onStreamRemoved(stream.id)
          _onStreamRemovedCallback(null, null);

          // Close the connection
          connection.close();
          delete _connections[partnerClientId]; // Remove the property
        }
      },
      // Send an offer for audio/video
      _initiateOffer = function (partnerClientId, stream) {
        // Get a connection for the given partner
        var connection = _getConnection(partnerClientId);

        // Add our audio/video stream
        connection.addStream(stream);

        console.log("stream added on my end");

        // Send an offer for a connection
        connection.createOffer(
          function (desc) {
            connection.setLocalDescription(desc, function () {
              _signaler.invoke(
                "sendSignal",
                JSON.stringify({ sdp: connection.localDescription }),
                partnerClientId
              );
            });
          },
          function (error) {
            console.log("Error creating session description: " + error);
          }
        );
      };

    serviceFactory.initialize = _initialize;
    serviceFactory.newSignal = _newSignal;
    serviceFactory.closeConnection = _closeConnection;
    serviceFactory.closeAllConnections = _closeAllConnections;
    serviceFactory.initiateOffer = _initiateOffer;
    return serviceFactory;
  },
]);

modules.component("videoChatHub", {
  templateUrl: "/mix-app/views/app-client/components/video-chat-hub/view.html",
  bindings: {
    mixDatabaseName: "=",
    isSave: "=?",
  },
  controller: [
    "$rootScope",
    "$scope",
    "VideoChatService",
    "ViewModel",
    "ConnectionManager",
    function ($rootScope, $scope, service, viewmodel, connectionManager) {
      var ctrl = this;
      BaseHub.call(this, ctrl);
      ctrl.localizeSettings = $rootScope.globalSettings;
      ctrl.webrtcDetectedBrowser = null;
      ctrl.init = function () {
        ctrl.viewmodel = viewmodel;
        _start();
      };
      ctrl.toogleMute = function () {
        if (
          ctrl._mediaStream != null &&
          ctrl._mediaStream.getAudioTracks().length > 0
        ) {
          ctrl.viewmodel.muted = !ctrl.viewmodel.muted;
          ctrl._mediaStream.getAudioTracks()[0].enabled = ctrl.viewmodel.muted;
        }
      };
      ctrl.toogleVideo = function () {
        if (
          ctrl._mediaStream != null &&
          ctrl._mediaStream.getVideoTracks().length > 0
        ) {
          ctrl.viewmodel.video = !ctrl.viewmodel.video;
          ctrl._mediaStream.getVideoTracks()[0].enabled = ctrl.viewmodel.video;
        }
      };

      ctrl._mediaStream = null;

      var _hub,
        _connect = function (username, onSuccess, onFailure) {
          var hub = new signalR.HubConnectionBuilder()
            .withUrl("/videoChatHub")
            .withAutomaticReconnect()
            .configureLogging(signalR.LogLevel.Information)
            .build();
          // Setup client SignalR operations
          _setupHubCallbacks(hub);
          hub
            .start()
            .then(function () {
              console.log(
                "connected to SignalR hub... connection id: " + hub.connectionId
              );

              // Tell the hub what our username is
              hub.invoke("Join", username);

              if (onSuccess) {
                onSuccess(hub);
              }
              //scope.$apply();
            })
            .catch(function (error) {
              console.log(`Cannot start the connection use transport.`, error);
              if (onFailure) {
                onFailure(event);
              }
              return Promise.reject(error);
            });

          _hub = hub;
        },
        _start = function () {
          // Show warning if WebRTC support is not detected
          if (ctrl.webrtcDetectedBrowser == null) {
            console.log("Your browser doesnt appear to support WebRTC.");
            $(".browser-warning").show();
          }

          // Then proceed to the next step, gathering username
          _getUsername();
        },
        _getUsername = function () {
          alertify.prompt(
            "What is your name?",
            function (e, username) {
              if (e == false || username == "") {
                username = "User " + Math.floor(Math.random() * 10000 + 1);
                alertify.success(
                  "You really need a username, so we will call you... " +
                    username
                );
              }

              // proceed to next step, get media access and start up our connection
              _startSession(username);
            },
            ""
          );
        },
        _startSession = function (username) {
          ctrl.viewmodel.Username = username; // Set the selected username in the UI
          ctrl.viewmodel.Loading = true; // Turn on the loading indicator
          $scope.$apply();
          // Ask the user for permissions to access the webcam and mic
          getUserMedia(
            {
              // Permissions to request
              video: true,
              audio: true,
            },
            function (stream) {
              // succcess callback gives us a media stream
              $(".instructions").hide();

              // Now we have everything we need for interaction, so fire up SignalR
              _connect(
                username,
                function (hub) {
                  // tell the viewmodel our conn id, so we can be treated like the special person we are.
                  ctrl.viewmodel.MyConnectionId = hub.connectionId;

                  // Initialize our client signal manager, giving it a signaler (the SignalR hub) and some callbacks
                  console.log("initializing connection manager");
                  connectionManager.initialize(
                    hub,
                    _callbacks.onReadyForStream,
                    _callbacks.onStreamAdded,
                    _callbacks.onStreamRemoved
                  );

                  // Store off the stream reference so we can share it later
                  ctrl._mediaStream = stream;
                  ctrl._mediaStream.getAudioTracks()[0].enabled = true;
                  ctrl._mediaStream.getVideoTracks()[0].enabled = false;
                  // Load the stream into a video element so it starts playing in the UI
                  //console.log('playing my local video feed');
                  var videoElement = document.querySelector(".video.mine");
                  videoElement.volume = 0;
                  setTimeout(() => {
                    videoElement.volume = 0.5;
                  }, 2000);
                  attachMediaStream(videoElement, ctrl._mediaStream);

                  // Hook up the UI
                  ctrl.viewmodel.Loading = false;
                },
                function (event) {
                  alertify.alert(
                    "<h4>Failed SignalR Connection</h4> We were not able to connect you to the signaling server.<br/><br/>Error: " +
                      JSON.stringify(event)
                  );
                  ctrl.viewmodel.Loading = false;
                }
              );
            },
            function (error) {
              // error callback
              alertify.alert(
                "<h4>Failed to get hardware access!</h4> Do you have another browser type open and using your cam/mic?<br/><br/>You were not connected to the server, because I didn't code to make browsers without media access work well. <br/><br/>Actual Error: " +
                  JSON.stringify(error)
              );
              ctrl.viewmodel.Loading = false;
            }
          );
        },
        _setupHubCallbacks = function (hub) {
          // Hub Callback: Incoming Call
          hub.on("incomingCall", (callingUser) => {
            console.log("incoming call from: " + callingUser);
            callingUser = JSON.parse(callingUser);
            // Ask if we want to talk
            alertify.confirm(
              callingUser.Username + " is calling.  Do you want to chat?",
              function (e) {
                if (e) {
                  // I want to chat
                  hub.invoke("answerCall", true, callingUser.ConnectionId);

                  // So lets go into call mode on the UI
                  ctrl.viewmodel.Mode = "incall";
                } else {
                  // Go away, I don't want to chat with you
                  hub.invoke("answerCall", false, callingUser.ConnectionId);
                }
              }
            );
          });

          // Hub Callback: Call Accepted
          hub.on("callAccepted", (acceptingUser) => {
            console.log(
              "call accepted from: " +
                acceptingUser +
                ".  Initiating WebRTC call and offering my stream up..."
            );
            acceptingUser = JSON.parse(acceptingUser);
            // Callee accepted our call, let's send them an offer with our video stream
            connectionManager.initiateOffer(
              acceptingUser.ConnectionId,
              ctrl._mediaStream
            );

            // Set UI into call mode
            ctrl.viewmodel.Mode = "incall";
          });

          // Hub Callback: Call Declined
          hub.on("callDeclined", (decliningConnectionId, reason) => {
            console.log("call declined from: " + decliningConnectionId);

            // Let the user know that the callee declined to talk
            alertify.error(reason);

            // Back to an idle UI
            ctrl.viewmodel.Mode = "idle";
          });

          // Hub Callback: Call Ended
          hub.on("callEnded", (connectionId, reason) => {
            console.log("call with " + connectionId + " has ended: " + reason);

            // Let the user know why the server says the call is over
            alertify.error(reason);

            // Close the WebRTC connection
            connectionManager.closeConnection(connectionId);

            // Set the UI back into idle mode
            ctrl.viewmodel.Mode = "idle";
          });
          // Hub Callback: Update User List
          hub.on("updateUserList", (userList) => {
            ctrl.viewmodel.Users = JSON.parse(userList);
            $scope.$apply();
          });
          // Hub Callback: WebRTC Signal Received
          hub.on("receiveSignal", (callingUser, data) => {
            callingUser = JSON.parse(callingUser);
            connectionManager.newSignal(callingUser.ConnectionId, data);
          });
        },
        // Connection Manager Callbacks
        _callbacks = {
          onReadyForStream: function (connection) {
            // The connection manager needs our stream
            // todo: not sure I like this
            connection.addStream(ctrl._mediaStream);
          },
          onStreamAdded: function (connection, event) {
            console.log("binding remote stream to the partner window");

            // Bind the remote stream to the partner window
            var otherVideo = document.querySelector(".video.partner");
            attachMediaStream(otherVideo, event.stream); // from adapter.js
          },
          onStreamRemoved: function (connection, streamId) {
            // todo: proper stream removal.  right now we are only set up for one-on-one which is why this works.
            console.log("removing remote stream from partner window");

            // Clear out the partner window
            var otherVideo = document.querySelector(".video.partner");
            otherVideo.srcObject = null;
          },
        };
      ctrl.callUser = function (targetConnectionId) {
        // Make sure we are in a state where we can make a call
        if (ctrl.viewmodel.Mode !== "idle") {
          alertify.error(
            "Sorry, you are already in a call.  Conferencing is not yet implemented."
          );
          return;
        }
        // Then make sure we aren't calling ourselves.
        if (targetConnectionId != ctrl.viewmodel.MyConnectionId) {
          // Initiate a call
          _hub.invoke("callUser", targetConnectionId);

          // UI in calling mode
          ctrl.viewmodel.Mode = "calling";
        } else {
          alertify.error("Ah, nope.  Can't call yourself.");
        }
      };
      ctrl.hangup = function () {
        // Only allow hangup if we are not idle
        if (ctrl.viewmodel.Mode != "idle") {
          _hub.invoke("hangUp");
          connectionManager.closeAllConnections();
          ctrl.viewmodel.Mode = "idle";
        }
      };
    },
  ],
});

"use strict";
app.factory("VideoChatService", [
  "ViewModel",
  "ConnectionManager",
  function (viewmodel, connectionManager) {
    var serviceFactory = {};
    var _mediaStream,
      _hub,
      _connect = function (username, onSuccess, onFailure) {
        var hub = new signalR.HubConnectionBuilder()
          .withUrl("/videoChatHub")
          .withAutomaticReconnect()
          .configureLogging(signalR.LogLevel.Information)
          .build();
        hub
          .start()
          .then(function () {
            console.log(
              "connected to SignalR hub... connection id: " + hub.connectionId
            );

            // Tell the hub what our username is
            hub.invoke("Join", username);

            if (onSuccess) {
              onSuccess(hub);
            }
            //scope.$apply();
          })
          .catch(function (error) {
            console.log(`Cannot start the connection use transport.`, error);
            if (onFailure) {
              onFailure(event);
            }
            return Promise.reject(error);
          });
        // Setup client SignalR operations
        _setupHubCallbacks(hub);
        _hub = hub;
      },
      _start = function (vm) {
        // Show warning if WebRTC support is not detected
        viewmodel = vm;
        if (webrtcDetectedBrowser == null) {
          console.log("Your browser doesnt appear to support WebRTC.");
          $(".browser-warning").show();
        }

        // Then proceed to the next step, gathering username
        _getUsername();
      },
      _getUsername = function () {
        alertify.prompt(
          "What is your name?",
          function (e, username) {
            if (e == false || username == "") {
              username = "User " + Math.floor(Math.random() * 10000 + 1);
              alertify.success(
                "You really need a username, so we will call you... " + username
              );
            }

            // proceed to next step, get media access and start up our connection
            _startSession(username);
          },
          ""
        );
      },
      _startSession = function (username) {
        viewmodel.Username = username; // Set the selected username in the UI
        viewmodel.Loading = true; // Turn on the loading indicator

        // Ask the user for permissions to access the webcam and mic
        getUserMedia(
          {
            // Permissions to request
            video: true,
            audio: false,
          },
          function (stream) {
            // succcess callback gives us a media stream
            $(".instructions").hide();

            // Now we have everything we need for interaction, so fire up SignalR
            _connect(
              username,
              function (hub) {
                // tell the viewmodel our conn id, so we can be treated like the special person we are.
                viewmodel.MyConnectionId = hub.connectionId;

                // Initialize our client signal manager, giving it a signaler (the SignalR hub) and some callbacks
                console.log("initializing connection manager");
                connectionManager.initialize(
                  hub,
                  _callbacks.onReadyForStream,
                  _callbacks.onStreamAdded,
                  _callbacks.onStreamRemoved
                );

                // Store off the stream reference so we can share it later
                _mediaStream = stream;

                // Load the stream into a video element so it starts playing in the UI
                //console.log('playing my local video feed');
                var videoElement = document.querySelector(".video.mine");
                attachMediaStream(videoElement, _mediaStream);

                // Hook up the UI

                viewmodel.Loading = false;
              },
              function (event) {
                alertify.alert(
                  "<h4>Failed SignalR Connection</h4> We were not able to connect you to the signaling server.<br/><br/>Error: " +
                    JSON.stringify(event)
                );
                viewmodel.Loading = false;
              }
            );
          },
          function (error) {
            // error callback
            alertify.alert(
              "<h4>Failed to get hardware access!</h4> Do you have another browser type open and using your cam/mic?<br/><br/>You were not connected to the server, because I didn't code to make browsers without media access work well. <br/><br/>Actual Error: " +
                JSON.stringify(error)
            );
            viewmodel.Loading = false;
          }
        );
      },
      _callUser = function (targetConnectionId) {
        // Make sure we are in a state where we can make a call
        if (viewmodel.Mode !== "idle") {
          alertify.error(
            "Sorry, you are already in a call.  Conferencing is not yet implemented."
          );
          return;
        }
        // Then make sure we aren't calling ourselves.
        if (targetConnectionId != viewmodel.MyConnectionId) {
          // Initiate a call
          _hub.server.invoke("callUser", targetConnectionId);

          // UI in calling mode
          viewmodel.Mode = "calling";
        } else {
          alertify.error("Ah, nope.  Can't call yourself.");
        }
      },
      _hangup = function () {
        // Only allow hangup if we are not idle
        if (viewmodel.Mode != "idle") {
          _hub.server.invoke("hangUp");
          connectionManager.closeAllConnections();
          viewmodel.Mode = "idle";
        }
      },
      _setupHubCallbacks = function (hub) {
        // Hub Callback: Incoming Call

        hub.on("incomingCall", (callingUser) => {
          console.log("incoming call from: " + JSON.stringify(callingUser));

          // Ask if we want to talk
          alertify.confirm(
            callingUser.Username + " is calling.  Do you want to chat?",
            function (e) {
              if (e) {
                // I want to chat
                hub.server.answerCall(true, callingUser.ConnectionId);

                // So lets go into call mode on the UI
                viewmodel.Mode = "incall";
              } else {
                // Go away, I don't want to chat with you
                hub.server.answerCall(false, callingUser.ConnectionId);
              }
            }
          );
        });

        // Hub Callback: Call Accepted
        hub.on("callAccepted", (acceptingUser) => {
          console.log(
            "call accepted from: " +
              JSON.stringify(acceptingUser) +
              ".  Initiating WebRTC call and offering my stream up..."
          );

          // Callee accepted our call, let's send them an offer with our video stream
          connectionManager.initiateOffer(
            acceptingUser.ConnectionId,
            _mediaStream
          );

          // Set UI into call mode
          viewmodel.Mode = "incall";
        });

        // Hub Callback: Call Declined
        hub.on("callDeclined", (decliningConnectionId, reason) => {
          console.log("call declined from: " + decliningConnectionId);

          // Let the user know that the callee declined to talk
          alertify.error(reason);

          // Back to an idle UI
          viewmodel.Mode = "idle";
        });

        // Hub Callback: Call Ended
        hub.on("callEnded", (connectionId, reason) => {
          console.log("call with " + connectionId + " has ended: " + reason);

          // Let the user know why the server says the call is over
          alertify.error(reason);

          // Close the WebRTC connection
          connectionManager.closeConnection(connectionId);

          // Set the UI back into idle mode
          viewmodel.Mode = "idle";
        });
        // Hub Callback: Update User List
        hub.on("updateUserList", (userList) => {
          viewmodel.setUsers(userList);
        });
        // Hub Callback: WebRTC Signal Received
        hub.on("receiveSignal", (callingUser, data) => {
          connectionManager.newSignal(callingUser.ConnectionId, data);
        });
      },
      // Connection Manager Callbacks
      _callbacks = {
        onReadyForStream: function (connection) {
          // The connection manager needs our stream
          // todo: not sure I like this
          connection.addStream(_mediaStream);
        },
        onStreamAdded: function (connection, event) {
          console.log("binding remote stream to the partner window");

          // Bind the remote stream to the partner window
          var otherVideo = document.querySelector(".video.partner");
          attachMediaStream(otherVideo, event.stream); // from adapter.js
        },
        onStreamRemoved: function (connection, streamId) {
          // todo: proper stream removal.  right now we are only set up for one-on-one which is why this works.
          console.log("removing remote stream from partner window");

          // Clear out the partner window
          var otherVideo = document.querySelector(".video.partner");
          otherVideo.src = "";
        },
      };
    // serviceFactory._connect = _connect;
    // serviceFactory._start = _start;
    // serviceFactory._getUsername = _getUsername;
    // serviceFactory._startSession = _startSession;
    // serviceFactory._attachUiHandlers = _attachUiHandlers;
    // serviceFactory._setupHubCallbacks = _setupHubCallbacks;
    // serviceFactory._callbacks = _callbacks;
    // serviceFactory._mediaStream = _mediaStream;
    // serviceFactory._hub = _hub;
    // Define more service methods here
    serviceFactory.viewmodel = viewmodel;
    serviceFactory.callUser = _callUser; // Starts the UI process
    serviceFactory.hangup = _hangup; // Starts the UI process
    serviceFactory.start = _start; // Starts the UI process
    serviceFactory.getStream = function () {
      // Temp hack for the connection manager to reach back in here for a stream
      return _mediaStream;
    };
    return serviceFactory;
  },
]);

app.factory("ViewModel", [
  "$rootScope",
  function ($rootScope) {
    var viewmodel = {
      Users: [], // List of users that are logged in and ready for connections
      Username: "not logged in.", // My username, to be reflected in UI
      MyConnectionId: "", // My connection Id, so I can tell who I am
      Mode: "idle", // UI mode ['idle', 'calling', 'incall']
      Loading: false, // Loading indicator control
      muted: "muted", // Loading indicator control
    };

    // The user that represents me
    viewmodel.Me = function () {
      return $rootScope.findObjectByKey(
        this.Users,
        "MyConnectionId",
        viewmodel.MyConnectionId
      );
    };

    // The readable status of the UI
    viewmodel.CallStatus = function () {
      var callStatus;

      if (this.Mode == "idle") {
        callStatus = "Idle";
      } else if (this.Mode == "calling") {
        callStatus = "Calling...";
      } else {
        callStatus = "In Call";
      }

      return callStatus;
    };

    // Set a new array of users.  We could simply do viewmodel.Users([array]),
    // but the mapping plugin converts all the user props to observables for us.
    viewmodel.setUsers = function (userArray) {
      viewmodel.Users = userArray;
    };

    // Retreives the css class that should be used to represent the user status.
    // I can't get this to work as just a dynamic class property for some reason.
    viewmodel.getUserStatus = function (user) {
      var css;

      if (user == viewmodel.Me()) {
        css = "icon-user";
      } else if (user.InCall()) {
        css = "icon-phone-3";
      } else {
        css = "icon-phone-4";
      }

      return css;
    };

    // Return the viewmodel so that we can change props later
    return viewmodel;
  },
]);

modules.component("haiyenLoader", {
  templateUrl: "/mix-app/views/app-client/components/customs/loader/view.html",
  controller: [
    "$scope",
    "$location",
    function ($scope, $location) {
      var ctrl = this;
      ctrl.imageDataArray = [];
      ctrl.canvasCount = 10;
      ctrl.duration = 500;
      ctrl.bgDuration = 2500;
      ctrl.canvas = null;
      ctrl.isLoaded = false;
      ctrl.init = function () {
        setTimeout(() => {
          $scope.$apply((ctrl.isLoaded = true));
        }, 500);
      };
    },
  ],

  bindings: {},
});

modules.component("tclLogin", {
  binding: {
    user: "=",
  },
  templateUrl: "/mix-app/views/app-client/components/customs/login/view.html",
  controller: [
    "$scope",
    "$rootScope",
    "RestMixDatabaseDataClientService",
    function ($scope, $rootScope, service) {
      var ctrl = this;
      ctrl.loginData = {
        username: "",
        password: "",
        pageSize: 1,
        pageIndex: 0,
        mixDatabaseName: "tcl_user",
        filterType: "equal",
      };
      ctrl.$onInit = async function () {};
      ctrl.isBusy = false;
      ctrl.translate = $rootScope.translate;
      ctrl.submit = async function () {
        $rootScope.isBusy = true;
        var result = await service.getList(ctrl.loginData);
        if (result.isSucceed) {
          if (result.data.totalItems > 0) {
            if (
              result.data.items[0].obj.password == ctrl.loginData.password &&
              result.data.items[0].obj.username == ctrl.loginData.username
            ) {
              ctrl.onSuccess(result);
            } else {
              ctrl.onFail(result);
            }
          } else {
            ctrl.onFail(result);
          }
          $rootScope.isBusy = false;
          $scope.$apply();
        } else {
          ctrl.onFail(result);
          ctrl.isBusy = false;
          $scope.$apply();
        }
      };

      ctrl.onSuccess = function (result) {
        $rootScope.isLogin = true;
        ctrl.user = result.data.items[0];
        $rootScope.user = result.data.items[0];
        $scope.$apply();
      };

      ctrl.onFail = function (result) {
        ctrl.msg = {
          color: "red",
          text: "Sai tên đăng nhập hoặc mật khẩu!",
        };
      };
    },
  ],
});

modules.component("tclOrder", {
  binding: {
    user: "=",
  },
  templateUrl: "/mix-app/views/app-client/components/customs/order/view.html",
  controller: [
    "$scope",
    "$rootScope",
    "ngAppSettings",
    "RestMixDatabaseDataClientService",
    function ($scope, $rootScope, ngAppSettings, service) {
      var ctrl = this;
      ctrl.request = angular.copy(ngAppSettings.request);
      ctrl.request.mixDatabaseName = "tcl_package";
      ctrl.packages = [];
      ctrl.$onInit = async function () {
        ctrl.user = $rootScope.user;

        if (ctrl.user.obj.order_packages.length == 0) {
          await ctrl.loadDefaultPackages();
          ctrl.saveDefaultData().then(() => {
            service.clearCache([ctrl.user.obj.id]);
          });
        }
        ctrl.totalUnit = 0;
        angular.forEach(ctrl.user.obj.order_packages, function (pack) {
          ctrl.calculateItems(pack);
          if (pack.obj.quantity > 0) {
            ctrl.totalUnit += pack.obj.total * pack.obj.quantity;
          }
        });
      };

      ctrl.loadDefaultPackages = async function () {
        $rootScope.isBusy = true;
        ctrl.request.parentId = ctrl.user.id;
        ctrl.request.parentType = "Set";
        var getPackages = await service.getList(ctrl.request);
        if (getPackages.isSucceed) {
          ctrl.user.obj.order_packages = getPackages.data.items;
          angular.forEach(ctrl.user.obj.order_packages, function (pack) {
            pack.parentId = ctrl.user.id;
            pack.mixDatabaseId = 0;
            pack.parentType = "Set";
            pack.status = 2;
            pack.mixDatabaseName = "order_package";
            pack.id = null;
            pack.obj.quantity = 0;
            pack.obj.total = 0;
            pack.parentId = ctrl.user.id;
            pack.parentType = "Set";
            angular.forEach(pack.obj.package_slots, function (slot) {
              slot.id = null;
              slot.mixDatabaseName = "order_package_slot";
              slot.parentType = "Set";
              slot.status = 2;
              slot.mixDatabaseId = 0;
              angular.forEach(slot.obj.package_items, function (item) {
                item.id = null;
                item.mixDatabaseName = "order_package_item";
                item.parentType = "Set";
                item.mixDatabaseId = 0;
              });
            });
          });
          $rootScope.isBusy = false;
          $scope.$apply();
        }
      };

      ctrl.saveDefaultData = async function () {
        angular.forEach(ctrl.user.obj.order_packages, async function (pack) {
          var savePackage = await ctrl.saveData(pack);
          if (savePackage.isSucceed) {
            pack.id = savePackage.data.id;
            pack.mixDatabaseId = savePackage.data.mixDatabaseId;
            pack.obj.id = savePackage.data.id;
            angular.forEach(pack.obj.gifts, async function (gift) {
              gift.parentId = pack.id;
              gift.parentType = "Set";
              await ctrl.saveData(gift);
            });
            angular.forEach(pack.obj.package_slots, async function (slot) {
              slot.parentId = pack.id;

              var saveSlot = await ctrl.saveData(slot);
              if (saveSlot.isSucceed) {
                slot.mixDatabaseId = saveSlot.data.mixDatabaseId;
                slot.id = saveSlot.data.id;
                slot.mixDatabaseId = saveSlot.data.mixDatabaseId;
                slot.obj.id = saveSlot.data.id;
                slot.status = 2;
                angular.forEach(slot.obj.package_items, async function (item) {
                  item.parentId = slot.id;

                  var saveItem = await ctrl.saveData(item);
                  if (saveItem.isSucceed) {
                    item.id = saveItem.data.id;
                    item.obj.id = saveItem.data.id;
                    item.mixDatabaseId = saveItem.data.mixDatabaseId;
                    angular.forEach(
                      item.obj.products,
                      async function (product) {
                        product.parentId = item.id;
                        product.parentType = "Set";
                        await ctrl.saveData(product);
                      }
                    );
                  }
                });
              }
            });
          }
        });
      };
      ctrl.isBusy = false;
      ctrl.translate = $rootScope.translate;

      ctrl.updatePackageQuantity = async function (pack, value) {
        pack.obj.quantity += value;
        var result = await ctrl.saveData(pack);
        ctrl.handleResult(result);
        ctrl.totalUnit += value * pack.obj.total;
        service.clearCache([ctrl.user.obj.id]);
        // ctrl.calculateItems();
      };

      ctrl.updateItemQuantity = async function (pack, item, value) {
        const newVal = item.obj.quantity + value;
        if (newVal < 0) {
          return;
        }
        if (item.obj.max_quantity >= newVal) {
          item.obj.quantity = newVal;
          var result = await ctrl.saveData(item);
          ctrl.handleResult(result);
          ctrl.calculateItems(pack);
          if (!pack.isValid) {
            ctrl.totalUnit -= pack.obj.unit * pack.obj.quantity;
            pack.obj.quantity = 0;
          }
          service.clearCache([pack.id]);
        } else {
          alert(
            `Bạn không thể mua nhiều hơn ${item.obj.max_quantity} sản phẩm ${item.obj.product_title}`
          );
        }
      };

      ctrl.calculateItems = function (pack) {
        pack.obj.total = 0;
        angular.forEach(pack.obj.package_slots, function (slot) {
          slot.obj.total_unit = 0;
          angular.forEach(slot.obj.package_items, function (item) {
            slot.obj.total_unit += item.obj.quantity;
          });
          pack.obj.total += slot.obj.total_unit;
        });
        pack.isValid = pack.obj.total == pack.obj.unit;
      };

      ctrl.submit = async function () {
        if (ctrl.validate()) {
          $rootScope.isBusy = true;
          var result = await service.save(ctrl.user);
          ctrl.handleResult(result);
        }
      };

      ctrl.saveData = async function (data) {
        var result = await service.save(data);
        return result;
      };

      ctrl.handleResult = function (result) {
        if (result.isSucceed) {
          ctrl.onSuccess(result);
          $rootScope.isBusy = false;
          $scope.$apply();
        } else {
          ctrl.onFail(result);
          $rootScope.isBusy = false;
          $scope.$apply();
        }
      };

      ctrl.validate = function () {
        let result = true;
        angular.forEach(ctrl.user.obj.order_packages, function (pack) {
          if (!pack.isValid && pack.obj.quantity > 0) {
            result = false;
            alert(`${pack.obj.title} chỉ chấp nhận ${pack.obj.unit} sản phẩm`);
          }
        });
        return result;
      };
      ctrl.onSuccess = function (result) {
        $rootScope.isLogin = true;
        $rootScope.isBusy = false;
        $scope.$apply();
      };

      ctrl.onFail = function (result) {
        ctrl.msg = {
          color: "red",
          text: "Sai tên đăng nhập hoặc mật khẩu!",
        };
        $rootScope.isBusy = false;
        $scope.$apply();
      };

      ctrl.export = function () {
        if (ctrl.validate()) {
          $rootScope.isBusy = true;
          var canvasdiv = document.getElementById("receipt");
          html2canvas(canvasdiv, {
            backgroundColor: "#5b4298",
          }).then((canvas) => {
            var a = document.createElement("a");
            a.href = canvas.toDataURL("image/png");
            a.download = ctrl.user.obj.username + "_receipt_.png";
            a.click();
            $rootScope.isBusy = false;
            $scope.$apply();
          });
        }
      };
    },
  ],
});

modules.component("haiyenSubscriber", {
  binding: {},
  templateUrl:
    "/mix-app/views/app-client/components/customs/subscriber/view.html",
  controller: [
    "$scope",
    "$rootScope",
    "RestMixDatabaseDataClientService",
    function ($scope, $rootScope, service) {
      var ctrl = this;
      ctrl.subscriber = null;
      ctrl.formName = "subscribers";
      ctrl.$onInit = async function () {
        var initData = await service.initData(ctrl.formName);
        if (initData.isSucceed) {
          ctrl.default = initData.data;
          ctrl.subscriber = angular.copy(ctrl.default);
          $scope.$apply();
        }
      };
      ctrl.isBusy = false;
      ctrl.submit = async function () {
        ctrl.isBusy = true;
        var result = await service.save(ctrl.subscriber);
        if (result.isSucceed) {
          ctrl.onSuccess(result);
          ctrl.subscriber = angular.copy(ctrl.default);
          ctrl.isBusy = false;
        } else {
          ctrl.onFail(result);
          ctrl.isBusy = false;
        }
        $scope.$apply();
      };
      ctrl.onSuccess = function (result) {
        ctrl.msg = {
          color: "green",
          text: "Cám ơn bạn đã đăng ký thành công!",
        };
      };

      ctrl.onFail = function (result) {
        ctrl.msg = {
          color: "red",
          text: result.errors[0],
        };
      };
    },
  ],
});

app.controller("UserController", [
  "$rootScope",
  "$scope",
  "AuthService",
  "UserService",
  function ($rootScope, $scope, authService, userService) {
    $scope.loginData = {
      username: "",
      password: "",
      rememberme: true,
    };
    $scope.user = {
      firstName: "",
      lastName: "",
      username: "",
      email: "",
      password: "",
      userData: {},
    };
    $scope.init = function () {
      authService.fillAuthData().then((resp) => {
        if (authService.authentication.info) {
          $scope.user = authService.authentication.info;
          $scope.showLogin = false;
          $scope.userData = authService.authentication.info.userData;
        } else {
          $scope.showLogin = true;
        }
      });
    };
    $scope.logout = function () {
      authService.logOut();
      window.top.location = window.top.location;
    };
    $scope.login = async function () {
      var result = await authService.login($scope.loginData);
      if (result.isSucceed) {
        $rootScope.executeFunctionByName("loginSuccess", [result.data]);
      } else {
        $rootScope.executeFunctionByName("loginFail", [result.errors]);
      }
    };

    $scope.save = async function () {
      $rootScope.isBusy = true;
      var resp = null;
      if (!$scope.user.id) {
        resp = await userService.register($scope.user);
      } else {
        resp = await userService.saveUser($scope.user);
      }
      if (resp && resp.isSucceed) {
        $scope.user = resp.data;
        authService
          .refreshToken(
            authService.authentication.refresh_token,
            authService.authentication.access_token
          )
          .then(() => {
            $rootScope.executeFunctionByName("saveUserSuccess", [resp.Data]);
          });
        $rootScope.isBusy = false;
        $scope.$apply();
      } else {
        $rootScope.executeFunctionByName("saveUserFail", [resp.errors]);
        if (resp) {
          $rootScope.showErrors(resp.errors);
        }
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };

    $scope.getMyProfile = async function () {
      $rootScope.isBusy = true;
      var response = await userService.getMyProfile();
      if (response.isSucceed) {
        $scope.user = response.data;
        $rootScope.isBusy = false;
        $scope.$apply();
      } else {
        $rootScope.showErrors(response.errors);
        $rootScope.isBusy = false;
        $scope.$apply();
      }
    };
  },
]);

window.loginSuccess = function (data) {
  window.top.location = window.top.location;
};
window.loginFail = function (errors) {
  console.error(errors);
};
window.saveUserSuccess = function (data) {
  window.top.location = window.top.location;
};
window.saveUserFail = function (errors) {
  console.error(errors);
};

"use strict";
app.factory("RestNavigationService", [
  "BaseRestService",
  "ApiService",
  "CommonService",
  function (baseService, apiService, commonService) {
    var serviceFactory = angular.copy(baseService);
    serviceFactory.init("mix-database-data/navigation");
    var _initData = async function (mixDatabaseName) {
      var url = this.prefixUrl + "/init/" + mixDatabaseName;
      var req = {
        method: "GET",
        url: url,
      };
      return await apiService.getRestApiResult(req);
    };

    var _export = async function (objData) {
      var data = serviceFactory.parseQuery(objData);
      var url = this.prefixUrl;

      if (data) {
        url += "/export?";
        url = url.concat(data);
      }
      var req = {
        method: "GET",
        url: url,
      };
      return await apiService.getRestApiResult(req);
    };

    serviceFactory.initData = _initData;
    serviceFactory.export = _export;
    return serviceFactory;
  },
]);

"use strict";
app.factory("UserService", [
  "ApiService",
  function (apiService) {
    var usersServiceFactory = {};

    var _getMyProfile = async function () {
      var apiUrl = "/account/";
      var url = apiUrl + "my-profile";
      var req = {
        method: "GET",
        url: url,
      };
      return await apiService.getApiResult(req);
    };

    var _saveUser = async function (user) {
      var apiUrl = "/account/";
      var req = {
        method: "POST",
        url: apiUrl + "save-my-profile",
        data: JSON.stringify(user),
      };
      return await apiService.getApiResult(req);
    };

    var _register = async function (user) {
      var apiUrl = "/account/";
      var req = {
        method: "POST",
        url: apiUrl + "register",
        data: JSON.stringify(user),
      };
      return await apiService.getApiResult(req);
    };

    usersServiceFactory.getMyProfile = _getMyProfile;
    usersServiceFactory.saveUser = _saveUser;
    usersServiceFactory.register = _register;
    return usersServiceFactory;
  },
]);
