# Overview
________________________________________________________

In this `concepts` guide, we will explain the key concepts behind our confidential solutions.

Each section in our 'concepts' guide contains an introduction to the concept itself followed by a discussion of how we have implemented these technologies in BlindLLama & BlindChat.

The concepts we will cover are:

  1. [**Enclaves**](./enclaves.md): We introduce the highly isolated secure environments keeping user data private
  2. [**Attestation**](./attestation.md): We discuss how we provide cryptographic guarantees that our security measures are in place
  3. [**Attested TLS**](./TPMs.md): We describe how we verify the identity of our enclave before enabling secure communications to proceed

These concepts are also explained in our Enclaves & Attestation Explained video:
<iframe width="560" height="315" src="https://www.youtube.com/embed/bfFnNCI9Vq8?si=5thZFUKTMbxGKMXk" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen></iframe>



<div style="text-align: right;">
  <a href="../enclaves" class="btn">Next</a>
</div>