# 关于 Misskey

Misskey 是一个开源、分布式的微博客平台。它由日本的 syuilo 于 2014 年开始开发。它拥有丰富的功能，如 Drive 或 Reactions，以及非常高的 UI 可定制性。

## History
虽然 Misskey 最初是围绕公告板作为其主要功能而开始的，但由于添加了一个可以让用户发布短消息并按时间顺序查看它们的时间线，从而导致了人气的增长，使得开发的主要焦点逐渐转向这种功能。Misskey并不是一直都是一个分散的服务，而是通过在 2018 年采用 ActivityPub 而变得分散。从那时起，它已经成为一个被许多人认可和使用的服务。

::: tip
"Misskey" 这个名字来自一个叫做 "Brain Diver" 的歌，这首歌是 syuilo 当时经常听的一个叫做 May'n 的乐队演唱的。
:::

由于任何人都可以加入其开发，Misskey 仍在持续积极开发。

## "分布式"是什么意思？
<b>分布式</b>服务，也被称为<b>去中心化</b>服务，是指一个服务的特性，它将一个社区分割成许多服务器，这些服务器都相互<b>通信（federate）</b>，共享他们的内容，构建一个<b>网络（Fediverse）</b>。只存在一个服务器的服务，或者存在许多独立服务器的服务，被称为集中式服务。大多数服务都属于集中式的，例如 Twitter 或 Facebook。分布式服务的优点是能够自由选择适合自己的管理或服务器主题。你也可以自己创建服务器。由于联邦的特性，无论你选择哪个服务器，你都能够访问同一个社区。

## 永远开源
Misskey 一直是，也将永远是开源的。简单来说，开源意味着<b>公开软件（程序）的源代码</b>。这也包括在其定义中能够调整或重新分发源代码。Misskey 的全部源代码都在一个名为 [AGPL](https://github.com/misskey-dev/misskey/blob/develop/LICENSE) 的开源许可证下[被许可](https://github.com/misskey-dev)，这意味着任何人都可以自由地检查、使用、调整、更改或根据他们认为合适的方式重新分发。开源有许多优点，包括允许任何人根据他们的喜好进行更改，确保代码不包含任何有害的组件，并能够轻易参与其开发。为了实现 Misskey 的分布式特性，这种开源的概念是必不可少的。使用之前的例子，大多数以盈利为目标的服务，如 Twitter、Facebook 等，都不是开源的。

::: tip
从技术上讲，Misskey 的源代码是通过 Git 进行管理的，其仓库被托管在 [GitHub](https://github.com/misskey-dev) 上。
:::

## 加入开发和支持项目
如果你喜欢 Misskey，请支持该项目。支持项目可以通过许多方式，以下介绍了其中的一些。其中一些不需要编程技能，所以任何人都可以自由地以自己的方式支持 Misskey。我们一直在等你。

### 添加功能或修复错误
如果你具备软件工程技能，你可以通过编辑其源代码来为项目做出贡献。关于此的指南，请参阅 [这里](https://github.com/misskey-dev/misskey/blob/develop/CONTRIBUTING.md)。

### 参与讨论
你可以通过分享你对新的或现有功能的看法，以及报告错误来做出贡献。这样的讨论可以在 [GitHub](https://github.com/misskey-dev) 或 [论坛](https://forum.misskey.io/)等地进行。

### 翻译文本
Misskey 支持多种语言（也称为 i18n，这是 Internationalization 的缩写）。虽然原始语言通常是日语，但志愿者正在将 Misskey 翻译成其他语言。帮助这项翻译工作也是一种贡献的形式。Misskey 使用一个名为 [Crowdin 的服务来管理其翻译](https://crowdin.com/project/misskey)。

### 分享你的感受
除了报告错误，也请随时分享积极的印象，比如你个人喜欢 Misskey 的哪些部分，或者你觉得 Misskey 中有趣的事情。这些事情可以激励开发者，也算是对项目的间接支持。

### 增加 Misskist 的数量
"Misskist" 指的是使用 Misskey 的人。通过向你的熟人介绍 Misskey 来传播它，Misskist 的数量可能会增加，这也可以激励开发者。

### 捐款
[请在这里查看](./donate.md)

## 常见问题
### 这个项目的目标是什么？
坦率地说，虽然这有点模糊，但 Misskey 的目标是成为一个广泛使用的多用途平台。不像其他平台，Misskey 并没有基于特定的想法（例如，反中心化）或愿景并以此为导向进行开发，所以在这方面有点"无目标"。另一方面，这也带来了一种灵活性，因为它不受特定方向的束缚。
<!-- TODO: ここにロードマップへのリンク -->

### Misskey 是由一家公司开发的吗？
不是。Misskey 是由个人开发的，没有与任何特定公司建立商业化联系。开发成员通常是志愿者。此外，虽然有一些企业赞助商，但开发仍以社区为中心。

### 谁在管理 Misskey？
由于 Misskey 的分布式特性，每个单独的服务器都有自己的管理。因此，不是所有的 Misskey 都由一个人或公司管理。这意味着，由于开发团队不控制单独的服务器，对于管理相关的问题，你应该联系你的服务器的管理者。你可以在[这个页面](/about)上验证谁在管理你的单独服务器。如果你创建了一个服务器，那么你也会成为它的管理员。

### 我应该选择哪个服务器？
[你可以在这里找到一个（不完整的）服务器列表。](../instances.md) 根据服务器的不同，其社区或中心主题（例如，喜欢某个节目）可能会有所不同，所以如果有一个服务器适合你的兴趣，那么加入它可能是一个好选择。除此之外，服务器的大小、用户群、国家或使用的语言、对管理团队的依赖或信任以及许多其他事情也可以作为选择的标准。然而，没有一个单独的服务器是 Misskey 的官方服务器。你也可以选择创建自己的新服务器。

一般来说，无论你加入哪个服务器，你仍然可以与所有其他服务器的用户进行连接。

### 我如何创建自己的服务器？
感谢你对创建 Misskey 服务器的兴趣。在当前的 2022 年，没有专门的 Misskey 托管服务，所以创建一个新的服务器需要一定的知识。关于这方面的更多信息，请参见[这里](./install.md)。


### Misskey 使用什么类型的技术？
随着 Misskey 的开发进程，它使用的技术已经发生了巨大的变化。起初，它使用了 MySQL + PHP + jQuery 的组合，但现在使用以下内容。
- 服务器端：Node.js
- 数据库：PostgreSQL，Redis
- UI 框架：Vue.js
- 编程语言：TypeScript

除此之外，还使用了从 Misskey 衍生出的技术，如 MFM 或 AiScript。

### 这是 Mastodon 的分支吗？
不是。Misskey 是一个与 Mastodon 或其他类似项目完全不同的项目。它已经开发了很长时间。然而，只有在 Mastodon 出现后，它才成为一个分布式网络。除了两个项目都实现了 ActivityPub 协议，它们之间没有关系。

### 是否有 iOS / Android 的应用程序？
尽管没有官方的 Misskey 应用程序，但有几个第三方应用程序。详情请查看[这里](./apps)。

然而，第三方应用程序的功能必然会落后于官方的 Web 客户端，所以除非你真的想使用一个原生应用程序，我们推荐使用官方的 Web 客户端。由于 Misskey Web 客户端支持 PWA，也可以使其表现得像原生应用程序。关于此的详细信息，请查看[这里](todo)。

### 我在哪里可以下载 Misskey 的 logo 或图标？
请参考[资产集合](../appendix/assets.html)。

### 那个偶尔出现的可爱的猫耳女孩是谁？
那是 Misskey 的守护神，Ai。(他们称 Ai 很可爱，耶！)
<div class="info">ℹ️ 要了解更多关于 Ai 的信息，请查看 <a href="https://xn--931a.moe/" target="_blank">这里</a>（仅日语）。</div>

