# 管理自定义表情符号

自定义表情符号可以由管理员或版主管理，更改方法是进入实例中的“控制面板”，然后点击“自定义表情符号”子菜单。
默认情况下，您会看到一个当前本地安装的表情符号的列表。
一般地，新建实例的该列表是空的，但你可以通过不同的方式添加自定义表情符号。

## 从另一个实例复制表情符号

表情符号可以轻易复制。
在“自定义表情符号”菜单中，点击上方栏中的“远程”，输入另一个实例的名称或主机名即可搜索其表情符号。

当你找到一个您想要的表情符号时，点击它，会出现一个小菜单，选择相应的选项以导入表情符号。

请注意，表情符号可能受版权保护，请务必检查是否可以合法地使用表情符号，否则可能会收到版权纠纷。

## 导入单个表情符号

Misskey 允许您将图片导入成为一个表情符号，类似于表情包。
在“自定义表情符号”菜单中，点击右上角的“+”，选择想要上传的图片，即可将其导入为一个表情包。

::: danger
需要注意的是，如果您选择在 Misskey 云盘中导入图片，请务必保留该图片原图，不要删除，否则表情包可能会失效，Misskey 不会再复制一份图片作为表情包。
:::

导入成功后，您可以对其进行管理。

## 批量导入

您可以将想要导入的表情符号打包压缩为“.ZIP”文件，然后在“自定义表情符号”菜单中，点击右上角的“...”，选择“导入”，导入“.ZIP”文件。

::: warning
请务必压缩为“.ZIP”压缩文件。
批量导入表情符号可能会覆盖现有的表情符号或以其他方式弄乱实例。
请确保只从可信的来源导入表情符号，最好是只导入您自己导出的表情符号。
:::

### 打包的表情符号格式

`meta.json`文件包含了该打包文件中的表情符号的信息。
该文件的内容类似于如下，其中`Meta`是整个文件的结构。

```typescript
class Meta {
	metaVersion: number;
	host: string;
	/**
	 * Date and time representation returned by ECMAScript `Date.prototype.toString`.
	 */
	exportedAt: string;
	emojis: Emoji[];
}

class Emoji {
	downloaded: boolean;
	fileName: string;
	emoji: {
		id: string;
		updatedAt: string;
		name: string;
		host: null;
		category: string;
		originalUrl: string;
		publicUrl: string;
		uri: null;
		type: string;
		aliases: string[];
	};
}
```

在导入表情符号时，除了`Emojis`字段，`Meta`的字段目前不被使用或检查。

对于每个 `Emoji` 字段:
- `downloaded`: 该值应一直为 true，若不是或设置为 false，该表情符号可能不会被导入。
- `fileName`: 打包文件中的图像名称。
- `emoji`: 与表情符号相关的数据（存储在数据库中）。 目前该字段下的内容大部分不会被实例检查。 目前使用的是以下内容：
  - `name`: 表情符号的名称，用户可输入其名称来使用该表情符号, 例如，一个表情符号名称为“zhangsan”，用户输入“:zhangsan”即可使用。
    若之前有相同名称的表情符号， 先前的表情符号**会被移除**!
  - `category`: 表情符号的类别。
  - `aliases`: 应该被添加为别名（aliases）的字符串列表。在管理界面，这些显示为 "标签"。

## 编辑和删除表情符号

表情符号的属性可以通过在本地表情符号列表点击表情符号进行编辑。
当点击一个自定义的表情符号时，将打开一个编辑属性的对话框。该对话框也提供了删除该表情符号的选项。

::: danger
当删除一个自定义表情符号后，之前包含有该自定义表情符号的帖子会将该表情符号显示为自定义表情符号的名称。例如，一个帖子中名有“zhangsan”的表情符号，删除这个自定义表情符号后，该帖子会将“zhangsan”的表情符号替换为“:zhangsan”，不会再显示为原表情符号。
:::

请注意，您不能编辑或删除远程实例的表情符号。

每个表情符号可以有一个名称（name）和一个类别（category）以及几个标签（tags）。
类别用于结构化表情符号选择器（emoji picker）。
同时，标签（tags）可以作为替代名称（alternate names），在表情符号选择器中搜索时可以找到该表情符号。

当您完成编辑后，请点击对话框右上角的复选标记来保存您的更改。


### 批量编辑

通过勾选搜索栏下面的方框，可以批量编辑表情符号。
启用该功能后，点击一个表情符号不会打开编辑对话框。
编辑选项将显示为复选框下面的按钮。

要退出批量编辑，只需再次取消复选框。
