---
description: 'If you run into a problem, please check this page first.'
---

# Troubleshooting
::: tip
Please also use the [Frequently asked questions](./faq.md) page.
:::

If you run into a problem, please check this page first. In the case that you can't find your problem here, or the steps described here don't solve your issue, please contact your server's administrator or [Report it as a bug](./report-issue).

## The client does not start
In most of the cases, this is due your used browser's or operating system's version being outdated. Please try updating your browser or operating system to the latest version and then try again.

Although this does not happen frequently, if your client will still not start after this, it is possible for the cache to be at fault.In this case, please try clearing your cache and then try again.

## Pages cannot be loaded
If your client does boot, but you get an error when trying to load a page, please check your network connection for errors.In addition, check that the server you are trying to access is not down.

Although this does not happen frequently, cases where the cache is at fault can happen.In this case, please try clearing your cache and then try again.

Any remaining problems are likely related to the server you are trying to access, so please contact its administrator.

## The client is slow
Please try the following:

- Activate "Reduce UI animations" in the client settings
- Deactivate "Use blur effect for modals" in the client settings
- Activate hardware acceleration in your browser's settings
- Upgrade the specs of your used device

## Parts of the UI are weird (For example, the background is transparent)
Broken UI display may be caused by the theme cache system when the UI is changed as part of an update. Pressing "Clear cache" in the settings will fix this.

::: warning
Specifically clear the "Client's" cache. Don't clear the "Browser's" cache.
:::

## The blinking light of a notification or Antenna won't go away
A blinking light indicates unread content.In cases where this light won't go away, there is usually unread content that has been pushed away by new incoming content. If you believe to have read all content, but the light still won't go away (likely a bug), you can forcibly mark all content as read via the user settings.

## The renote button is blocked out
Followers-only notes cannot be renoted.

## Specific parts of the Misskey Web UI are not being displayed
Problems like these can arise if you are using an Adblocker. For an optimized experience on Misskey, please turn it off.

## Some parts of the Misskey Web UI are untranslated
In most cases, this is simply a matter of the translation not having been done yet instead of being a bug.Please wait until the translation of this area has been completed. You can alternatively also [participate in translation](./misskey) yourself.
