# Widgets

A widget is a small display element that can be added to the Misskey UI to display and interact with information.
By default they are displayed on the right side of the screen or accessed from the stack icon in the mobile web app navigation menu.

To edit widgets, switch to widget edit mode at the bottom of the widget view. In widget edit mode you can add, delete, and reorder widgets.

After you close out of the widget layout editor, you can also configure settings for each widget's behavior.

## List of Available Widgets

### Notifications

Shows a list of your notifications. You can change the types of notifications shown by opening the notification widget menu. If you disable "User global settings" you can choose to only show certain types of notifications.

### Timeline

Display a timeline. You can choose from one of the standard timelines (Home, Local, Social, and Global) or one of your custom user [Lists](./list.md) or [Antennas](./antenna.md).

### RSS Reader

Displays a list of items from an RSS feed. You can provide any valid RSS feed URL in the configuration.

### RSS-Ticker

Similar to the RSS Reader, but the ticker shows the feed as a scrolling ticker on a single line. There are also more options to customize how the the feed will be refreshed and displayed.

### Trending

Displays trending [Hashtags](./hashtag.md) as well as statistics of how many users have mentioned it and a graph of that hashtag's activity.

### Activity

Displays a visualization of activity over time.

### Online Users

Displays the number of users that are active on this instance.

### Photos

Displays a gallery of your recent photos.

### Slideshow

Displays a slideshow of photos one of your specified drive folders. To select the drive folder, left-click on the slideshow widget after you have exited the widget layout editor. Then select the checkbox of folders you want included in the slideshow and click the check mark to confirm.

### Calendar

Displays the current date as well as a graphic showing the date progression.

### Clock

Displays an analog clock. The analog clock has many options to customize its appearance.

### Digital Clock

Displays a digital clock.

### UNIX Clock

Displays the seconds elapsed since the UNIX Epoch (1970-01-01T00:00:00Z).

### Federation

List of federated instances and graphs of their recent activity.

### Instance Cloud

An interactive animation that shows federated instances.

### Sticky Notes

A text area where you can jot down short notes for yourself. You can save your sticky note and it will be available wherever you access Misskey Web.

### Posting Form

A widget form of the [Note](./note.md) composition menu.

### Server Metrics

A display of the server metrics. The type of metrics displayed can changed by clicking the arrows in the header of the widget.

### Job Queue

A display of the server job queue statistics.

### AiScript Console

A widget version that you can use to test and execute [AiScript](../advanced/aiscript.md) programs. This is a widget version of the Scratchpad page accessible through the help menu.

### Button

An interactive button that when clicked runs your own custom [AiScript](../advanced/aiscript.md) program.

### Ai

A digital version of the Misskey mascot, Ai, that will follow you around the site.
