---
description: '問題が発生したときは、まずこちらをご確認ください。'
---

# トラブルシューティング
::: tip
[よくある質問](./faq.md)も合わせてお役立てください。
:::

問題が発生したときは、まずこちらをご確認ください。
該当する項目が無い、もしくは手順を試しても解決しない場合は、サーバーの管理者に連絡するか[不具合を報告](./report-issue)してください。

## クライアントが起動しない
ほとんどの場合、お使いのブラウザまたはOSのバージョンが古いことが原因です。
ブラウザおよびOSのバージョンを最新のものに更新してから、再度試してみてください。

これは稀ですが、それでも起動しない場合は、キャッシュが原因の場合があります。ブラウザのキャッシュをクリアして、再度試してみてください。

## ページが読み込めない
クライアントが起動するもののページが読み込めないというエラーが出る場合は、ネットワークに問題がないか確認してください。また、サーバーがダウンしていないか確認してください。

これは稀ですが、キャッシュが原因の場合があります。ブラウザのキャッシュをクリアして、再度試してみてください。

まだ問題がある場合は、サーバーの問題と思われるのでサーバーの管理者に連絡してください。

## クライアントの動作が遅い
インターネットサービスプロバイダーの障害やメンテナンス予定の確認、ネットワークの通信速度の状態やネットワーク設定の確認、そしてサーバー側で何らかの障害やメンテナンスが発生しているかどうかを確認した上で、以下の設定を試すまたは確認してください:

1.Misskey Webの設定
メニューから設定を開き、クライアント設定の全般を開いて以下の設定を試してみてください。

- アピアランスの「UIのアニメーションを減らす」を有効にする
- アピアランスの「モーダルにぼかし効果を使用」を無効にする
- アピアランスの「システムデフォルトのフォントを使う」を有効にする
- アピアランスの「OSネイティブの絵文字を使用」を有効にする

以下の設定は、一部のMisskeyの機能が動かなくなることを了承した上で、試してみてください。

- 動作の「Pagesのスクリプトを無効にする」を無効にする
- アピアランスの「動きのあるMFMを無効にする」を有効にする

2.Webブラウザの設定
- お使いのWebブラウザの設定でハードウェアアクセラレーションを有効にする
- お使いのWebブラウザのアドオンや拡張機能の設定を確認するか、それらの機能をオフにする
- お使いのWebブラウザのその他の設定を確認する

3.その他
- お使いのPCやスマートフォンのシステム設定を確認する

## Misskey WebのUIの一部表示がおかしい(背景が透明になっている等)
アップデートによりUIの改修が行われたときに、テーマのキャッシュシステムの影響でそのような表示になることがあります。
クライアントの設定の「キャッシュをクリア」すると直ります。

::: warning
「クライアントの」キャッシュクリアです。「ブラウザの」キャッシュクリアは行わないでください。
:::

## 通知やアンテナ等の点滅が消えない
点滅は、未読のコンテンツがあることを示しています。通常点滅が消えない場合は、コンテンツを遡ると未読なコンテンツが残っています。
すべて既読にしたと思われるのに、それでもなお点滅が続く場合(おそらく不具合と思われます)は設定から強制的にすべて既読扱いにすることができます。

## Renoteができない
公開範囲がフォロワー限定のノートおよびDMはRenoteすることはできません。

## Misskey WebのUI上で特定の要素が表示されない
Webブラウザで広告ブロッカーなどのアドオンや拡張機能を使用していると、そのような不具合が発生することがあります。それらの設定を確認するか、オフにしてご利用ください。

## Misskey WebのUI上で未翻訳の部分がある
ほとんどの場合、Misskey WebのUIの翻訳が間に合っていないことが原因ですので、不具合ではありません。翻訳が終わるまで申し訳ありませんが、しばらくお待ちください。

もし、あなたがMisskeyの翻訳についてご興味があるなら[翻訳に参加](./misskey)していただくことは、もちろん可能です。
