---
description: 'Misskeyについてのドキュメントです。'
---

# Misskeyについて

Misskeyはオープンソースの分散型マイクロブログプラットフォームプロジェクトです。
開発は日本でsyuiloによって2014年から開始されました。
ドライブ、リアクションなどの豊富な機能や、高いカスタマイズ性を備えたUIを持つことが特徴です。

## 歴史
開発当初は掲示板がメインのサービスでしたが、ユーザーが短文を投稿し、それを時系列で流れるタイムライン機能を追加したところ人気が高まり、徐々にそれがメインとして開発が進むようになりました。
当初は分散型ではありませんでしたが、2018年にActivityPubを実装し分散型になったことで、より多くの方に認知され利用されるサービスになり、現在に至ります。

::: tip
Misskeyという名前は、syuiloが当時聴いていたMay'nというアーティストの楽曲、Brain Diverの歌詞に由来します。
:::

誰でも開発に参加することができ、現在でも活発に開発が続いています。

## 分散型とは何か？
<b>分散(distributed)型</b>とは、<b>非中央集権(decentralized)</b>とも呼ばれ、コミュニティが多数のサーバーに分散して存在し、それらが相互に<b>通信(連合、federation)</b>することでコンテンツ共有<b>ネットワーク(Fediverse)</b>を形成していることが特徴のサービスです。
単一のサーバーしか存在しない、もしくは複数存在しても互いに独立している場合は中央集権なサービスと言われ、例えばTwitterやFacebookなどほとんどのサービスがそれに該当します。
分散型のメリットは、自分に合った運営者やテーマのサーバーを選択できることです。自分でサーバーを作成することもできます。連合するおかげで、どのサーバーを選んでも、同じコミュニティにアクセスできます。

## 常にオープンソース
Misskeyはこれまでもこれからも、オープンソースであり続けます。オープンソースとは、簡単に言うと<b>ソフトウェアのソースコード(プログラム)が公開されている</b>ことです。ソースコードの修正や再配布が可能であることを定義に含めることもあります。
Misskeyのすべてのソースコードは[AGPL](https://github.com/misskey-dev/misskey/blob/develop/LICENSE)というオープンソースライセンスの下に[公開](https://github.com/misskey-dev)されていて、誰でも自由に閲覧、使用、修正、改変、再配布をすることができます。
オープンソースは、自分で好きなように変えたり、有害な処理が含まれていないことを確認することができたり、誰でも開発に参加できるなどの、様々なメリットがあります。
上述の分散型を実現するためにも、オープンソースであるということは必要不可欠な要素です。
再び引き合いに出しますが、TwitterやFacebookなどの利益を得ているほとんどのサービスはオープンソースではありません。

::: tip
技術的に言うと、MisskeyのソースコードはGitで管理されていて、リポジトリは[GitHub上でホスティングされています。](https://github.com/misskey-dev)
:::

## 開発に参加する、プロジェクトを支援する
Misskeyを気に入っていただけたら、ぜひプロジェクトを支援してください。プロジェクトに貢献するには、以下で紹介するようにいろいろな方法があります。方法によっては開発のスキルは不要なので、誰でも気軽に参加し貢献することができます。いつでもお待ちしています。

### 機能を追加したり、バグを修正する
ソフトウェアエンジニアのスキルをお持ちの方であれば、ソースコードを編集する形でプロジェクトに貢献することができます。
貢献についてのガイドは[こちら](https://github.com/misskey-dev/misskey/blob/develop/CONTRIBUTING.md)です。

### 議論に参加する
新しい機能、または既存の機能について意見を述べたり、不具合を報告したりすることでも貢献できます。
そのようなディスカッションは[GitHub](https://github.com/misskey-dev)上か、[フォーラム](https://forum.misskey.io/)等で行われます。

### テキストを翻訳する
Misskeyは様々な言語に対応しています(i18n -internationalizationの略- と呼ばれます)。元の言語は基本的に日本語ですが、有志によって他の言語へと翻訳されています。
その翻訳作業に加わっていただくことでもMisskeyに貢献できます。
Misskeyは[Crowdinというサービスを使用して翻訳の管理を行っています。](https://crowdin.com/project/misskey)

### 感想を投稿する
不具合報告等だけではなく、Misskeyの良い点、楽しい点といったポジティブな意見もぜひ共有してください。開発の励みになり、それは間接的ですがプロジェクトへの貢献です。

### ミスキストを増やす
ミスキストとは、Misskeyを使用する人のことです。
知り合いに紹介するなどしてMisskeyを広めていただければ、ミスキストが増え開発のモチベーションが上がります。

### 寄付をする
[こちらをご覧ください](./donate.md)

## よくある質問
### プロジェクトは何を目指していますか？
強いて言うと、漠然的になりますが広く使われる汎用的なプラットフォームになることを目指しています。
Misskeyは他のプロジェクトとは違い、何らかの思想(例えば、反中央集権)やビジョンに基づいて開発が行われているわけではなく、その点ではフラットです。
それが逆に、特定の方向性に縛られないフレキシブルさを生み出すことに繋がっていると感じています。
<!-- TODO: ここにロードマップへのリンク -->

### 企業によって開発されていますか？
いいえ。Misskeyの開発は個人で行われており、商業的でもないため、特定の企業の関りはありません。
開発メンバーも基本的にはボランティアです。
また、開発に対し企業のスポンサーがつくこともありますが、その場合でもやはり開発は個人のコミュニティが主体です。

### 誰が運営していますか？
Misskeyは分散型なため、各サーバーにそれぞれ異なった運営者がいます。従って、特定の個人や企業によって、Misskeyの全てが運営されているわけではありません。
また、開発チームが運営を行うわけでもないため、運営に関する連絡は、お使いのサーバーの運営者に行ってください。
サーバーの運営者は、サーバーの情報ページで確認することができます。
あなたがサーバーを作成すれば、あなたが運営者になります。

### どのサーバーを選べばいいですか？
[サーバー一覧が公開されています。](../instances.md)
サーバーによってコミュニティのテーマ(特定のこと、ものが好き 等)が決められている場合があるので、自分に合ったテーマのサーバーがあれば、そこを選ぶと良いかもしれません。
他にも、サーバーの規模、ユーザー層、国および言語、運営者が信頼できるかどうか、などの観点があります。
なお、Misskey公式のサーバーというものはありません。自身で新しくサーバーを作成するという選択肢もあります。

基本的にどのサーバーを選んだとしても、他の全てのサーバーのユーザーと繋がることができます。

### サーバーを建てるにはどうしたらいいですか？
Misskeyサーバーの作成に興味を持っていただきありがとうございます。
2022年現在、Misskeyのホスティングサービスは存在しないため、サーバーの作成にはある程度の知識が必要です。
サーバーの作成方法については[こちら](./install.md)をご覧ください。

### どのような技術を使用していますか？
Misskeyは開発が進むにつれ使用する技術も大きく変わってきました。開発当初はMySQL + PHP + jQueryといった構成でしたが、現在は以下のようになっています。
- サーバーサイド: Node.js
- データベース: PostgreSQL、Redis
- UIフレームワーク: Vue.js
- プログラミング言語: TypeScript

また、MFMやAiScriptなどの、Misskeyから派生して独自の技術も開発しています。

### Mastodonのフォークですか？
いいえ。MisskeyはMastodonやその他のプロジェクトとは全く別のプロジェクトです。
開発に関しても、Misskeyの方が昔から開発されています。ただし、分散型になったのはMastodonの登場より後です。
同じActivityPubという分散のためのプロトコルを実装しているという点以外、両者に特に関りがあるわけでもありません。

### iOS/Androidのアプリはありますか？
公式にはそういったOSのネイティブアプリを開発していませんが、サードパーティ製のアプリがいくつかあります。
詳しくは[こちら](./apps.md)をご覧ください。

ただ、サードパーティ製アプリはどうしても機能への対応が遅れてしまうため、とくに拘りがなければ公式のWebクライアントの利用をおすすめします。
なお、MisskeyのWebクライアントはPWAに対応しているので、ネイティブアプリのように動作させることも可能です。
詳しくは[こちら](todo)をご覧ください。

### Misskeyのロゴ、アイコンはどこで入手できますか？
[こちら](../appendix/assets.md)

### 時折目にする猫耳の可愛い女の子は？
Misskeyの守り神、藍ちゃんです。ｱｲﾁｬﾝｶﾜｲｲﾔｯﾀｰ!

::: tip
藍ちゃんについては[こちら](https://xn--931a.moe/)です。
:::
