# ノート
ノートは、Misskeyに投稿される、文章、ファイル、アンケートなどを含むコンテンツで、Misskeyの中心的概念です。また、そのノートを作成する行為自体もノートと呼ばれます。

::: tip
ノートという名称は、英語で「短い記録」を意味する Note が由来になっています。
:::

ノートが作成されると、[タイムライン](./timeline)に追加され、自分の[フォロワー](./follow)やサーバーのユーザーが見れるようになります。

ノートには、[リアクション](./reaction)を行うことができます。また、返信や引用もできます。

ノートを[お気に入り](./favorite)登録することで、後で簡単に見返すことができます。

## ノートを作成する
Misskey Webでノートを作成するには、画面上にある鉛筆マークのボタンを押して、作成フォームを開きます。作成フォームに内容を入力し、「ノート」ボタンを押すことでノートが作成されます。
ノートには、画像、動画など任意のファイルや、[アンケート](./poll)を添付することができます。また、本文中には[MFM](./mfm)が使用でき、[メンション](./mention)や[ハッシュタグ](./hashtag)を含めることもできます。
他にも、CWや公開範囲といった設定も行えます(詳細は後述)。

::: tip
Misskey Webでは、コンピューターのクリップボードに画像データがある状態で、フォーム内のテキストボックスにペーストするとその画像を添付することができます。
:::

::: tip
Misskey Webでは、テキストボックス内で<kbd class="key">Ctrl + Enter</kbd>を押すことでも投稿できます。
:::

## Renote
既にあるノートを引用、もしくはそのノートを新しいノートとして共有する行為、またそれによって作成されたノートをRenoteと呼びます。
自分がフォローしているユーザーの、気に入ったノートを自分のフォロワーに共有したい場合や、過去の自分のノートを再度共有したい場合に使います。
同じノートに対して無制限にRenoteを行うことができますが、あまり連続して使用すると迷惑になる場合もあるので、注意しましょう。

::: warning
公開範囲がフォロワーやダイレクトのノートはRenoteできません。
:::

Misskey WebでRenoteを削除するには、Renoteの時刻表示の隣にある「...」を押し、「Renote解除」を選択します。

## CW
Contents Warningの略で、ノートの内容を、閲覧者の操作なしには表示しないようにできる機能です。主に長大な内容を隠すためや、ネタバレ防止などに使うことができます。
Misskey WebでCWを設定するには、フォームの「内容を隠す」ボタン(目のアイコン)を押します。すると新しい入力エリアが表れるので、そこに内容の要約を記入します。

## 公開範囲
ノートごとに、そのノートが公開される範囲を設定することができます。
Misskey Webで公開範囲を設定するには、フォームの「ノート」ボタンの左にあるアイコンを押します。
公開範囲には、以下の種類があります。

### パブリック
全ての人に対してノートが公開されるほか、サーバーの全てのタイムライン(ホームタイムライン、ローカルタイムライン、ソーシャルタイムライン、グローバルタイムライン)にノートが流れます。

::: warning
アカウントが[サイレンス](./silence)状態の時は、この公開範囲は使用できません。
:::

### ホーム
全ての人に対してノートが公開されますが、フォロワー以外のローカルタイムライン、ソーシャルタイムライン、グローバルタイムラインにはノートは流れません。

### フォロワー
自分のフォロワーに対してのみノートを公開します。フォロワーの全てのタイムラインに流れます。

### ダイレクト
指定したユーザーに対してのみノートを公開します。指定したユーザーの全てのタイムラインに流れます。

### 「ローカルのみ」オプション
このオプションを有効にすると、リモートにノートを連合しなくなります。

### 公開範囲の比較
<table>
	<tr><th></th><th>パブリック</th><th>ホーム</th><th>フォロワー</th><th>ダイレクト</th></tr>
	<tr><th>フォロワーのLTL/STL/GTL</th><td>✔</td><td>✔</td><td>✔</td><td></td></tr>
	<tr><th>非フォロワーのLTL/STL/GTL</th><td>✔</td><td></td><td></td><td></td></tr>
</table>

## ピン留め
ノートをピン留めすると、ユーザーページに常にそのノートを表示しておくことができます。
Misskey Webでピン留めを行うには、ノートのメニューを開き、「ピン留め」を選択します。

::: tip
複数のノートを同時にピン留めすることも可能です。
:::

## ウォッチ
ノートをウォッチすると、自分以外のノートへのリアクションや返信などの通知を受け取ることができます。
Misskey Webでウォッチするには、ノートのメニューを開き、「ウォッチ」を選択します。
