---
description: 'ストリーミングAPIを使うと、リアルタイムで様々な情報(例えばタイムラインに新しい投稿が流れてきた、リアクションされた、フォローされた、など)を受け取ったり、様々な操作を行ったりすることができます。'
---

# ストリーミングAPI

::: tip
最初に[Misskey API](../index.md)のドキュメントを読むことをお勧めします。
:::

ストリーミングAPIを使うと、リアルタイムで様々な情報(例えばタイムラインに新しい投稿が流れてきた、リアクションされた、フォローされた、など)を受け取ったり、様々な操作を行ったりすることができます。

## ストリームに接続する

ストリーミングAPIを利用するには、まずMisskeyサーバーに**websocket**で接続する必要があります。

以下の形式のURLにwebsocket接続します:

```:no-line-numbers
wss://{host}/streaming?i={token}
```

ここで、
- `{host}`の部分は、接続したいサーバーのホストに置き換えます。
- `{token}`の部分は、ユーザーのアクセストークンに置き換えます。

::: tip
アクセストークンは省略することもできますが、その場合非ログインでの利用ということになり、受信できる情報や可能な操作は限られます。
:::

ストリームに接続すると、後述投稿の購読を行ったりすることができますが、まだこの段階では、例えばタイムラインへの新しい投稿を受信したりすることはできません。
そのようなイベントを受信するには、ストリーム上で後述する**チャンネル**に接続する必要があります。

**ストリーム上のやり取りはすべてJSONで行われます。**

## チャンネル
MisskeyのストリーミングAPIにはチャンネルという概念があります。これは、送受信する情報を分離するための仕組みです。
ストリーム上でチャンネルに接続することで、様々な情報を受け取ったり情報を送信したりすることができるようになります。

::: tip
ひとつのストリーム接続上で、同時に複数のチャンネルに接続することができます。
:::

以下では、チャンネルの使用方法を説明します。どのようなチャンネルがあるかは、[チャンネル一覧](./channel/index.md)を参照してください。

### チャンネルに接続する
チャンネルに接続するには、次のようなデータをJSONでストリームに送信します:

```js
{
	type: 'connect',
	body: {
		channel: 'xxxxxxxx',
		id: 'foobar',
		params: {
			...
		}
	}
}
```

ここで、
- `channel`には接続したいチャンネル名を設定します。[チャンネル一覧](./channel/index.md)を参照してください。
- `id`にはそのチャンネルとやり取りするための任意のIDを設定します。ストリームでは様々なメッセージが流れるので、そのメッセージがどのチャンネルからのものなのか識別する必要があるからです。このIDは、UUIDや、乱数のようなもので構いません。
- `params`はチャンネルに接続する際のパラメータです。チャンネルによって接続時に必要とされるパラメータは異なります。パラメータ不要のチャンネルに接続する際は、このプロパティは省略可能です。

::: tip
IDはチャンネルごとではなく「チャンネルの接続ごと」です。なぜなら、同じチャンネルに異なるパラメータで複数接続するケースもあるからです。
:::

### チャンネルからのメッセージを受け取る
例えばタイムラインのチャンネルなら、新しい投稿があった時にメッセージを発します。そのメッセージを受け取ることで、タイムラインに新しい投稿がされたことをリアルタイムで知ることができます。

チャンネルがメッセージを発すると、次のようなデータがJSONでストリームに流れてきます:
```js
{
	type: 'channel',
	body: {
		id: 'foobar',
		type: 'something',
		body: {
			some: 'thing'
		}
	}
}
```

ここで、
- `id`には前述したそのチャンネルに接続する際に設定したIDが設定されています。これで、このメッセージがどのチャンネルからのものなのか知ることができます。
- `type`にはメッセージの種類が設定されます。チャンネルによって、どのような種類のメッセージが流れてくるかは異なります。
- `body`にはメッセージの内容が設定されます。チャンネルによって、どのような内容のメッセージが流れてくるかは異なります。

### チャンネルに向けてメッセージを送信する
チャンネルによっては、メッセージを受け取るだけでなく、こちらから何かメッセージを送信し、何らかの操作を行える場合があります。

チャンネルにメッセージを送信するには、次のようなデータをJSONでストリームに送信します:
```js
{
	type: 'channel',
	body: {
		id: 'foobar',
		type: 'something',
		body: {
			some: 'thing'
		}
	}
}
```

ここで、
- `id`には前述したそのチャンネルに接続する際に設定したIDを設定します。これで、このメッセージがどのチャンネルに向けたものなのか識別させることができます。
- `type`にはメッセージの種類を設定します。チャンネルによって、どのような種類のメッセージを受け付けるかは異なります。
- `body`にはメッセージの内容を設定します。チャンネルによって、どのような内容のメッセージを受け付けるかは異なります。

### チャンネルから切断する
チャンネルから切断するには、次のようなデータをJSONでストリームに送信します:

```js
{
	type: 'disconnect',
	body: {
		id: 'foobar'
	}
}
```

ここで、
- `id`には前述したそのチャンネルに接続する際に設定したIDを設定します。

## 投稿のキャプチャ

Misskeyは投稿のキャプチャと呼ばれる仕組みを提供しています。これは、指定した投稿のイベントをストリームで受け取る機能です。

例えばタイムラインを取得してユーザーに表示したとします。ここで誰かがそのタイムラインに含まれるどれかの投稿に対してリアクションしたとします。
しかし、クライアントからするとある投稿にリアクションが付いたことなどは知る由がないため、リアルタイムでリアクションをタイムライン上の投稿に反映して表示するといったことができません。

この問題を解決するために、Misskeyは投稿のキャプチャ機構を用意しています。投稿をキャプチャすると、その投稿に関するイベントを受け取ることができるため、リアルタイムでリアクションを反映させたりすることが可能になります。

以下では、投稿のキャプチャ機能の使用方法を説明します。どのようなキャプチャイベントがあるかは、[キャプチャイベント一覧](./note-capture-events.md)を参照してください。

### 投稿をキャプチャする

投稿をキャプチャするには、ストリームに次のようなメッセージを送信します:

```js
{
	type: 'subNote',
	body: {
		id: 'xxxxxxxxxxxxxxxx'
	}
}
```

ここで、
- `id`にキャプチャしたい投稿の`id`を設定します。

このメッセージを送信すると、Misskeyにキャプチャを要請したことになり、以後、その投稿に関するイベントが流れてくるようになります。

例えば投稿にリアクションが付いたとすると、次のようなメッセージが流れてきます:

```js
{
	type: 'noteUpdated',
	body: {
		id: 'xxxxxxxxxxxxxxxx',
		type: 'reacted',
		body: {
			reaction: 'like',
			userId: 'yyyyyyyyyyyyyyyy'
		}
	}
}
```

ここで、
- `body`内の`id`に、イベントを発生させた投稿のIDが設定されます。
- `body`内の`type`に、イベントの種類が設定されます。
- `body`内の`body`に、イベントの詳細が設定されます。

### 投稿のキャプチャを解除する

その投稿がもう画面に表示されなくなったりして、その投稿に関するイベントをもう受け取る必要がなくなったときは、キャプチャの解除を申請してください。

次のメッセージを送信します:

```js
{
	type: 'unsubNote',
	body: {
		id: 'xxxxxxxxxxxxxxxx'
	}
}
```

ここで、
- `id`にキャプチャを解除したい投稿の`id`を設定します。

このメッセージを送信すると、以後、その投稿に関するイベントは流れてこないようになります。
