---
description: 'MisskeyはAPIを公開しています。APIを使ってMisskeyクライアント、Misskey連携Webサービス、Bot等(以下「アプリケーション」と呼びます)を開発することができます。'
---

# Misskey API
MisskeyはAPIを公開しています。APIを使ってMisskeyクライアント、Misskey連携Webサービス、Bot等(以下「アプリケーション」と呼びます)を開発することができます。
ストリーミングAPIもあるので、リアルタイム性のあるアプリケーションを作ることも可能です。

::: tip
Misskey公式SDKやサードパーティライブラリを使うことによって、このドキュメントで説明するいくつかの手順を簡略化できるなど、より便利にAPIを利用することができます。\
ライブラリについては[こちら](./libraries)を参照してください。
:::

APIを使い始めるには、APIを利用するアカウントに紐づいた**アクセストークン**を取得する必要があります。
このドキュメントでは、アクセストークンを取得する手順を説明した後、基本的なAPIの使い方を説明します。

## アクセストークンの取得
基本的に、APIはリクエストにはアクセストークンが必要となります。
アクセストークンは、ユーザーに紐づいた認証情報で、APIを利用するユーザーを識別するとともに、アクセストークンごとにどういった操作の権限を持っているかが管理されます。

::: tip
ユーザーとそのユーザーに紐づいたアクセストークンは一対多の関係であり、あるユーザーに対して複数のアクセストークンが発行され得ます。
:::

あなた自分自身のアクセストークンは簡単に取得できるほか、あなたのアプリケーションを使用することになる不特定のユーザーのアクセストークンを取得することもできます。

- 前者の場合: **「自分自身のアクセストークンを手動発行する」** に進む
- 後者の場合: **「アプリケーション利用者にアクセストークンの発行をリクエストする」** に進む

### 自分自身のアクセストークンを手動発行する
Misskey Webの「設定 > API」で、自分のアクセストークンを発行できます。

::: danger
アクセストークンは他人に知られないようにしてください。
:::

### アプリケーション利用者にアクセストークンの発行をリクエストする
アプリケーションを利用するユーザー(以下単に「ユーザー」と呼びます)のアクセストークンを取得するには、以下の手順で発行をリクエストします。

::: tip

以下に説明する方法は、アプリを作成せずインスタントにアクセストークンを発行する、MiAuthと呼ばれるものです。

[アプリ作成方式でのアクセストークン取得方法もあります（旧来型）。](./app)
:::

#### Step 1
UUIDを生成する。以後これを**セッションID**と呼びます。

::: danger
このセッションIDは毎回生成し、使いまわさないようにしてください。
:::

#### Step 2
アプリケーション認証フォームをユーザーのブラウザで表示させる。認証フォームは、以下の形式のURLで開くことができます:

```:no-line-numbers
https://{host}/miauth/{session}
```

ここで、
- `{host}`の部分は、ユーザーのサーバーのホストに置き換えます。通常ホストはユーザーが入力します。
- `{session}`の部分は、セッションIDに置き換えます。

また、URLにクエリパラメータとしていくつかのオプションを設定できます:

| 名前         | 説明                                                                                                                             |
| ------------ | -------------------------------------------------------------------------------------------------------------------------------- |
| `name`       | アプリケーション名。                                                                                                             |
| `icon`       | アプリケーションのアイコン画像URL。                                                                                              |
| `callback`   | 認証が終わった後にリダイレクトするURL。<br>リダイレクト時には、`session`というクエリパラメータでセッションIDが付きます。         |
| `permission` | アプリケーションが要求する権限。<br>要求する権限を`,`で区切って列挙します。権限の一覧は[こちら](./permission.md)で確認できます。 |

::: tip 例
```:no-line-numbers
https://misskey.io/miauth/c1f6d42b-468b-4fd2-8274-e58abdedef6f?name=MyApp&callback=https%3A%2F%2Fmyapp.example.com%2Fcallback&permission=write:notes,write:following,read:drive
```
:::

#### Step 3
ユーザーがアプリケーションアクセスを許可した後、次の形式のURLにPOSTリクエストすると、レスポンスとしてアクセストークンを含むJSONが返ります。

```:no-line-numbers
https://{host}/api/miauth/{session}/check
```

ここで、
- `{host}`の部分は、ユーザーのサーバーのホストに置き換えます。
- `{session}`の部分は、セッションIDに置き換えます。

レスポンスに含まれるプロパティは以下の通りです:

| 名前    | 説明                         |
| ------- | ---------------------------- |
| `token` | ユーザーのアクセストークン。 |
| `user`  | ユーザーの情報。             |

## APIの利用
アクセストークンが取得できたら、各種エンドポイントにリクエストすることでAPIの利用が行えます。

::: tip

- HTTP APIはすべてPOSTで、リクエスト/レスポンスともにJSON形式です（drive/files/createを除く）。
- 要求ヘッダーに`Content-Type: application/json`を指定します。
- アクセストークンは、`i`というパラメータ名でリクエストボディJSONに含めます。
- ベースURLは`https://{サーバーのドメイン}/api`です。

:::

アクセストークン付きのボディの例（metaの場合）:

```json
{
    "i": "HogEFugA1341",
    "detail": false
}
```

APIの詳細は、[APIリファレンス](./endpoints.html)を参照してください。

::: warning
MisskeyはRESTを採用していません。
:::

また、MisskeyはHTTP APIだけでなく、ストリーミングAPIも提供しています。ストリーミングAPIの詳細は[こちらのドキュメント](./streaming/index.md)を参照してください。
