---
description: '今年Misskeyで起こったこと・自分が取り組んだことや来年取り組む予定のことを紹介します'
---

# Misskey 2023 recap

:::tip
これは[Misskey Advent Calendar 2023](https://adventar.org/calendars/8742)一日目の記事です。
:::

こんにちは、しゅいろです。2023年も残すところあと1ヶ月となりました。

振り返ると、2023年はMisskeyが大きく成長した年でした。そして、来年2024年はMisskeyは10周年になります！！

個人的な趣味で始めたプロジェクトが10年続き、自分のライフワークになるとは夢にも思っていませんでした。

ここまで開発を続けられてきたのはひとえに皆様の応援・ご支援のおかげです。本当にありがとうございます。

この記事では今年Misskeyで起こったこと・自分が取り組んだことや来年取り組む予定のことを紹介します。

なお、gihyo.jpで行っているMisskey連載の方では2023年のMisskeyの開発に関するまとめを12月分の記事で公開予定です。興味がありましたらそちらも合わせてご覧ください。

では早速書いていきます！

## Misskey Play
まずはMisskey本体の話から。

Misskey Playは1月16日リリースのMisskey v13で登場した機能で、従来の動的なMisskey Pagesをより柔軟な形に昇華させたものになります。

この一年間で様々なPlayが作られていて、中には自分が想定もしていなかったようなハイクオリティな作品もあり驚かされています。

### モチベーション
従来のPagesはグラフィカルなUIで簡単に動的なコンテンツが作成できる反面、できることが限られていました。そこで、完全なプログラミングを行えるようにすることで最高の自由度を持つコンテンツ作成プラットフォームを提供したいと考えるようになり、Playが生まれました。

最高の自由度と言っても、例えばユーザーの書いたJavaScriptをそのまま走らせるような実装ではもちろんセキュリティ上の問題があるので、安全なサンドボックス環境でプログラムを実行する必要があります。

そのために、AiScriptというJavaScript上で動作するスクリプト言語を作成して、Playはそのホストとなるような実装にしてセキュリティを担保しました。

このAiScriptは汎用的な言語なので、Playだけでなく、プラグインの実装などにも用いられています。

### 今後
例えば画像を描画できるようにするなど、できることをもっと増やしたいと考えています。

また、v2023.11.0で任意のデータをサーバーサイドに保存可能なレジストリAPIが開放されたので、それを活用したPlayが出てくることも期待しています。

## アイコンデコレーション

サーバー側で用意されたデコレーション画像をアイコンに重ねて着飾ることができる機能で、個人的にお気に入りの機能です(みんなかわいいため)。

まだ機能がベータ版の段階からサーバーごとに創意工夫がされ、特色のあるデコレーションが作られており、デコレーションの一覧を眺めているだけでサーバーの雰囲気を掴むことができます。

さらに、デコレーションでユーザーの個性をより表現することができ、コミュニティの活性化にも繋がると感じています。

デコレーションはロールごとに使用可能なものを設定できるようになっており、運用方法によってはサーバー運営者のマネタイズにも役立つと期待しています。

![](/img/blog/2023-12-01-2023recap---decorations.png)

▲自分が用意したデコレーション13種

### 今後
デコレーションをひとつだけでなく、複数重ね掛けできるようにする予定です。これにより、サングラスを掛けながら頭にみかんを乗せたり、怒りながら愛情を振りまいたりなどの芸当が可能になります。

また、位置を微調整できるようにしたり、デコレーションの種類が多い場合の表示を改善するといった、細かなQoM(Quality of Misskeying)を向上させる改修も予定しています。

サーバー間の連合も予定しています。

## オンボーディングの強化
Misskeyのユーザー層が拡大してきているので、ドキュメントやチュートリアルを充実させてMisskeyに慣れてもらう、いわゆるオンボーディングを強化する必要性が高まってきています。

そのため、今年は以下のような改修を行いました。

### 実績
実績機能もv13から追加されたものです。実績を実装したかったモチベーションとしては、単に楽しいというのもありますが、実績をアンロックするために今までよりMisskeyの様々な機能を触る機会が増えることによる、オンボーディングの促進という面が大きいです。

実際、今まで開いたこともなかった「Misskeyについて」ページを実績のために開いて触ってみる、というのは多く観測しています。

また、獲得した実績は他のユーザーに公開されるので、その人がどれくらいMisskeyを使っているか、というのを知るためのひとつの指標にもなります。

なお、実績はお察しのようにCookie Clickerからインスピレーションを受けたものが多くあります。

### アカウント初期設定ウィザードおよびチュートリアル
これもオンボーディングの一環で、アカウント作成時にウィザードを表示し基本的な設定を行えるようになったのと(v13.12.0)、設定後にMisskeyの基本的な概念や操作を一通り学べるチュートリアルを表示できるようになりました(v2023.11.0)。

チュートリアルでは実際のコンポーネントが使われ、インタラクティブにMisskeyの操作を学ぶことができるようになっています。

![](/img/blog/2023-12-01-2023recap---tutorial.png)

### 今後
来年も引き続きオンボーディングの強化に取り組んでいく予定です。

例えば、ドキュメントやUI内の説明を充実させたり、タイムラインや投稿以外のチュートリアルを追加したり、実装を計画しているログインボーナス受け取りの際に「今日のヒント」等と称してMisskeyにおけるTipsを表示させたりを考えています。

またオンボーディングとは少し違いますが、一週間に一度、その週の活動実績(受け取ったリアクション数やノートが閲覧された回数、増えたフォロワーなど)をメールで受け取れるようにすることで、「あーこの前そんなサービス登録したな、なんかフォロワー増えてるし開いてみるか」といったユーザーストーリーが発生し、ユーザーの定着率向上を狙う機能も構想中です。

## モデレーション機能の強化
Misskeyのユーザー数が増えているため、モデレーションに関する機能も強化する必要性が高まってきていました。

そのため今年は以下のような改修を行い、サーバー運営の負担を軽減できるようにしました。

### ロール機能
ユーザーごとに、ロールという予め設定した属性を付与することのできる機能です。

ロール機能の実装の必要性は当初半信半疑(従来の「モデレーターか否か」という単純なフラグだけで十分ではないかと考えていました)でしたが、いざ実装してみると、Misskeyサーバーの運用の幅が大きく広がり、一部の運営者からは革命と評される機能になりました。

ロール機能を使用することで権限を細かくコントロールできるようになり、コンディショナルロールを作成すればアサインを自動化できるなど、柔軟な運用が可能になりました。

また、ロールはバッジとして表示することも可能で、サーバーの支援者特典としても活用が可能になっています。

### お知らせ刷新
お知らせの表示方法にバナーやダイアログを追加したほか、ユーザー個別のお知らせを作成できるようになりました。

### モデレーションログ
モデレーターの行った様々な操作をログとして記録・表示できる管理者用機能です。

操作の前後の差分表示機能もあり、以前の状態に差し戻すことも容易になっています。

操作の種類や操作者をフィルタリングして表示することも可能です。

### 今後
2024年もモデレーション機能の拡充に引き続き取り組んでいきます。

検討中の課題にGDPR対応があり、実現は簡単ではありませんが日本以外の国でも安心してサーバーの運営が行えるようにしたいと思っています。

## パフォーマンスの改善
今年は様々なMisskeyサーバーでユーザー数が急増したことに伴い、より少ないコストでサーバーを稼働させることができるようMisskeyのパフォーマンス向上に重点的に取り組みました。

自分の中で印象に残っていて、かつパフォーマンス改善へのインパクトも大きかったものとしてはFTT(Fanout Timeline Technology)の実装が挙げられます。

これはX(Twitter)でも昔から採用されているタイムラインの実装方法(アーキテクチャ)で、投稿作成時の負荷が高くなる代わりに、タイムライン読み込み時のパフォーマンスを大幅に向上させることができるものです。

![](/img/blog/2023-12-01-2023recap---ftt.png)

以前よりMisskeyでもこのアーキテクチャへの変更は検討されてきていましたが、投稿時の負荷が高まることへの懸念や実装の難しさなどがありなかなか実現には至っていませんでした。

しかし今年に入りアーキテクチャ変更の必要性が以前にも増して高まってきたのと、自分の技術力が向上(Redisの知見)してきたこともあり、ついに重い腰を上げ実装を行った次第です。

結果としては成功で、実際に以前は「フォローしているユーザーが少ないアカウントでホームタイムラインの読み込みを行う場合」や「メンバーの少ないユーザーリストのタイムラインを読み込む場合」といったシチュエーションでは負荷が高くタイムラインの表示までしばらく時間がかかることがありましたが、FTTが有効になっているサーバーではそのようなシチュエーションでも瞬時にタイムラインが表示されるようになりました。

FTTも含め、パフォーマンス改善の取り組みについての詳細は以下で解説しています。

- [「Misskeyのパフォーマンス改善の取り組み⁠⁠・2023年7月」](https://gihyo.jp/article/2023/07/misskey-05)
- [「Misskeyのパフォーマンス改善の取り組み⁠⁠⁠⁠・2023年11月」](https://gihyo.jp/article/2023/11/misskey-08)

### 今後
もちろん2024年も引き続きパフォーマンスの改善に取り組んでいきます！

例えば、クエリの最適化、No WebSocketモード、Node.jsからより速いプラットフォームに移行することなども検討しています。

さらに、おそらく2024年内に、Misskey Webで利用しているフレームワークであるVueの大きなアップデート(Vue Vapor)があると予想され、その暁にはMisskey Webをより軽量化できると考えています。

## 安定性向上

今年は規模の大きなサーバーが増え、Misskeyのソフトウェアとしての信頼性が以前より求めらるようになったことから、以下のような取り組みも行いました。

- リリースサイクルを見直し、大きな機能の追加や改修は短くとも1ヶ月間隔でしか行わないようにした
- ベータテストの期間を長めに設けて、不具合や改善点の洗い出しを行いやすくした
- リリース時に複数の開発者にレビューしてもらう機会を設けた

結果、今年は去年に比べて「アップデート直後に問題が発生する」といった事案がかなり減ったと感じています。

### 今後

来年もこうした取り組みは続けていきたいと思います。

リリースサイクルについて「大きな機能の追加や改修は短くとも1ヶ月間隔でしか行わない」と説明しましたが、この安定志向をさらに推し進め、「偶数月(もしくは奇数月)でしか機能追加をリリースしない=短くとも2ヶ月間隔」というサイクルにすることも検討しています。

また、テストが不足していることも課題になっているのでそちらについても進めていきたいです。

## リファクタリング
今年は大きなリファクタリング(Misskeyのソースコードの整理)も行ったので、今後の機能追加や改修が行いやすくなっています。

詳しくはgihyo.jpの連載をご覧ください。

## Misskey Hub Next

現在MisskeyプロジェクトのオフィシャルサイトであるMisskey Hubの刷新作業を行っており、VuePressからNuxt.jsに書き直され、よりモダンで使いやすいデザインに改修するとともに、コンテンツの拡充を行っています。

![](/img/blog/2023-12-01-2023recap---misskey-hub-next.png)

一例として、MFMプレイグラウンドや何かと必要になるAIDコンバーター、テーマ・プラグインストア(予定)、シェア中継機能(予定)などがあります。

また、ローカリゼーションをGitHubリポジトリに直接PRする方式から、Misskey本体と同じくCrowdinを利用する方式に改められました。これによって、より簡単にドキュメントの翻訳に貢献していただくことが可能になっています。

Misskey Hub Nextを主導してくださっているかっこかり氏に感謝申し上げます。

### 今後
早いうちにドキュメントを充実させ、現行のMisskey Hubのリプレースを行う予定です。

## Misskey開発についての連載がスタート
お伝えしているように、今年の2月に技術評論社様からお声がけいただき、Misskeyの技術についての連載をWebメディアgihyo.jpにて始めることとなりました。

仰々しくも「Misskey & Webテクノロジー最前線」と題し、Misskeyで使われている最新のWeb技術などについて解説をしていくものになっています。

https://gihyo.jp/list/group/Misskey-Web%E3%83%86%E3%82%AF%E3%83%8E%E3%83%AD%E3%82%B8%E3%83%BC%E6%9C%80%E5%89%8D%E7%B7%9A

ありがたいことに、解説が平易で分かりやすいとの評価をいただいていて、2024年も引き続き記事の公開を行っていく予定です！

## misskey.io法人化

以前もニュースでお伝えしましたが、Misskey最大手サーバー misskey.io が今年ついに株式会社MisskeyHQ(代表取締役: 村上さん)として法人化し、私も取締役に就任しました。

misskey.ioのアクティブユーザー数は1月時点で1日平均500人前後でしたが、記事執筆時点(12月)では平均約28,000人まで増加(56倍)していて、ものすごい成長スピードとなっています。

![](/img/blog/2023-12-01-2023recap---io-chart.png)

▲ioユーザー数のチャート

misskey.ioはもともとmisskey.xyzという名前で、自分で運営を行っていました。今は村上さんはじめとするmisskey.io運営チームにバトンタッチしていますが、それでも自分の始めたサービスがここまで大きくなったというのは感慨深いです。

モデレーションやインフラ整備、障害対応など、自分一人では到底そのような運営はできません。運営チームの方々に感謝申し上げます。

来年もさらなる成長は間違いありませんので、misskey.io運営に携われることを嬉しく思います。

## スポンサー

以前もニュースでお伝えしましたが、今年はMisskey開発への支援も大幅に増え、Xserver様、Skeb様からの支援もいただきました。

Misskeyは収入源を寄付にのみ頼っているため、こうした支援をいただけるのはとてもありがたいです。

ご期待に沿えるよう来年もより活発な開発を続けていきます！

## 財政状況の改善

上述したように企業からの支援や、利用者の皆様からの寄付が今年に入り大幅に増えたこともあり、プロジェクトとして財政状況に余裕が生まれました。

いただいた資金はMisskeyに貢献してくださった開発者の方々への報奨金としても活用されました。

### 今後

財政状況が改善したとはいえ、他の開発者への分配や、今後アプリ開発をしていくという点で見るとまだまだ資金は不足しています。

皆様からの寄付だけに頼るのも限界があると思うので、プロジェクトとしてマネタイズを行う方法を模索していきたいと思います。

## Misskeyの商標登録に成功
2023年7月12日、「Misskey」が日本において商標登録されました。

Misskey®®®®®®®®®®®

## メディアで取り上げられる
ありがたいことに、今年はMisskeyをメディアで取り上げていただく機会がとても多かったです。

- [「次のTwitterはMastdonかMisskeyか!?　Fediverse（フェディバース）な世界へ飛び込んでみる」](https://k-tai.watch.impress.co.jp/docs/column/minna/1458691.html)
- [「『次のTwitter』を探しているなら、より心の機微が絵文字で伝わる、高機能な短文型SNS『Misskey』へようこそ」](https://k-tai.watch.impress.co.jp/docs/column/minna/1474357.html)
- [「話題の分散SNS『Misskey』が居心地いい　行儀悪くて笑えるあのころのインターネットが帰ってきた　ユーザー爆増中」](https://www.itmedia.co.jp/news/articles/2303/03/news185.html)
- [日経Linux2023年5月号](https://info.nikkeibp.co.jp/media/LIN/atcl/mag/032900074/)
- [「'Post-Twitter' decentralized social media struggles for way forward」](https://asia.nikkei.com/Business/Technology/Post-Twitter-decentralized-social-media-struggles-for-way-forward)
- [「『楽しんでほしい』ピュアな思いがMisskeyを生んだ。異様な熱狂を放つSNSの今までとこれから」](https://levtech.jp/media/article/interview/detail_268/)
- [「Twitterにさよなら　SNSの自治求めミスキーに移民」](https://www.nikkei.com/article/DGXZQOCB034P20T00C23A7000000/)
- [「Twitter（X）に代わるSNS」人気ランキングTOP25！](https://nlab.itmedia.co.jp/research/articles/1771561/)
- [「目指すのは『オタク向けmixi』『平成のインターネット』……？　ユーザー爆増の純日本産SNS『Misskey』開発・運営インタビュー」](https://realsound.jp/tech/2023/09/post-1422348.html)

## ファンアート
今年は素敵なイラストをたくさん描いていただきました。

あまりの多さに更新が遅れ気味ですが、こちらにまとめてあります。

https://xn--931a.moe/

## misskey.io合同誌
れおねこ氏主導で、misskey.io合同誌が企画されました。

メロンブックスでは予約ランキングで二位になるなど、注目度もかなり高いようです。

高いバイタリティでプロジェクトを主導されたれおねこ氏、寄稿された方々、購入された方々に対し私からも感謝申し上げます。ありがとうございます！

## Misskey Developer Conference (MiDC)

第一回は神奈川県川崎市で、第二回は東京都渋谷区でMisskey Developer Conference (MiDC) 2023(開発者オフ会)が開催されました。

![](/img/blog/2023-12-01-2023recap---midc-shibuya.webp)

▲第二回の様子

## その他の今後の予定

以下のような予定があります。

- ログインボーナス実装
- チャットUI実装
- ギャラリー機能の改修
- 3D空間内で皆と遊べる機能(Misskey Roomの発展形)
- Misskey Gamesの復活
  - Misskey リバーシ
  - Misskey 麻雀
- ネイティブクライアント開発
- テスト拡充
- 等

大雑把なロードマップは[こちらにあります。](https://github.com/misskey-dev/misskey/blob/develop/ROADMAP.md)

## 自分の話

![](/img/blog/2023-12-01-2023recap---mugitya.webp)

- 家が物流倉庫になった
	- Amazonの欲しいものリストに麦茶を65535個希望とかで入れていたら大量に届いて大変なことになりました
		- 飲みきれないという意味での大変ではなく、置き場所に困る(床が抜けそう)という意味での大変
	- 配達員の方からは、おそらく自分は麦茶の人として認識されている
	- 本記事執筆時点では(他の開発者に配ったということもあり)ほぼすべて消費しました。送ってくださった皆様ありがとうございました
	- 皆さんはどうせそんなに贈られることはないだろうと高をくくって65535個希望とかに設定しないようにしましょう
- Cities: Skylines 2はいいぞ
	- でも激重だしバグが多い
	- 暖房としても活用できる
- Factorio: Space Age楽しみ
	- 多分動くと思うからリリースしようぜ
- レンズ沼にはまった
	- たすけて

## まとめのまとめ

紹介は以上になりますが、これらは2023年にMisskeyで起こったことのほんの一部で、紹介しきれなかったことはまだまだたくさんあります。

振り返ると、2023年はMisskeyが大きく発展した年であることに間違いないです。

ユーザーも去年とは比べ物にならないほど増え、多くの人にMisskeyを楽しんでいただけていることを嬉しく思います。

改めてになりますが、ここまでMisskeyが成長できたのは以下の皆様のおかげです。

- Misskeyの開発を経済的に支援してくださった方々
- Misskeyの開発に貢献してくださった方々
- ベータ版をテストし、リリースの安定性向上に貢献してくださった方々
- サードパーティアプリを開発し、快適なMisskey体験を提供してくださった方々
- ファンアートを制作して、Misskeyのコミュニティを盛り上げてくださった方々
- 応援の言葉やリアクションをしてくださった方々
- そのほかすべての利用者の方々

「方々」がゲシュタルト崩壊してきました。皆様本当にありがとうございました。
そして来年もMisskeyを発展させていきますので何卒よろしくお願いいたします！！

:::tip
Misskeyの今のコードネーム(v13~)は「nasubi」です。今年の初め、コードネームは今後野菜で統一していこうと思い、一番手は「一富士二鷹三茄子」とも言われ縁起の良い🍆を選びました。そして言葉通り縁起の良い年になりました。
:::

それでは(ちょっと早いですが)、Merry Christmas and Happy New Year!

![](/img/blog/2023-12-01-2023recap---2024.jpg)

---

Misskeyは皆様の支援のおかげで継続した開発が行えています。Misskeyを気に入っていただけたらぜひ[プロジェクトに支援](https://misskey-hub.net/docs/donate.html)をお願いします！
