---
description: 'MFMで使われている技術や考え方について紹介します。'
---

# インサイド MFM

こんにちは、まりはちです🚀

Misskey関係では主にMFM(Markup language For Misskey)やAiScript、MisskeyPagesの開発で関わっています。よろしくお願いします。

今回の記事では、MFMで使われている技術や考え方について紹介しようと思います。
少し専門的な内容を含むと思いますが、少々お付き合いください！

## MisskeyはどうやってMFMを認識する？

MFMで書かれた文字列をそのまま表示するだけだと、**太字にする**などの効果を与えることはできません。なぜなら、MFMはそのままでは普通の文字列なのでどの部分を**太字**にすればいいのかをMisskeyが認識できないためです。

MisskeyがMFMで書かれた文字列の効果や構造を認識できるようにするためには、構文解析(パース)というステップが必要になります。

構文解析の「構文」とは、例えば**太字**などの記法のことで、MFM構文を含む文字列を解釈してMisskeyが認識できる形のデータに変換することを構文解析(パース)といいます。構文解析はMFMの解析や表示をする上で重要な技術となっています。

また、パースをするプログラムのことをパーサー(構文解析器)と呼びます。

## MFMのパーサーはどのように動作するのか？

MFMのパーサーは、1つのMFMの文字列を受け取り、それを解析することでMisskeyが認識できる形のデータに変換するプログラムです。

```
[MFMの文字列] --(MFMパーサーのプログラム)--> [Misskeyが認識できる形のデータ]
```

ここでは、MFMのパーサーの動作について少し見てみることにします。

MFMパーサは、受け取った1つの文字列を、複数の部分として分割します。各部分は、**太字**などの効果が適用される部分と、効果が適用されない普通の文字列です。この各部分のことをノードと呼び、この全体のことをAST(抽象構文木)またはノードツリーと呼んでいます。

この部分に分けることこそがMFMのパーサーが行うもっとも重要な仕事です。先ほど説明した「Misskeyが認識できる形のデータに変換する」とは、この明確に部分分けされたASTを生成することを指していました🚀

## おわりに

いかがでしたか？
MFMで使われている技術について、基本的な考え方の部分についてお話しました。
実際のMFMのパーサーはもう少し複雑なこともやっていますが、ベースにある考え方はここに書いたとおりです。

構文解析はいいぞ。🚀
