import { SVGProps } from "react";

export function ACMIcon(
  props: JSX.IntrinsicAttributes & SVGProps<SVGSVGElement>
): JSX.Element {
  return (
    <svg viewBox="0 0 24 24" aria-hidden="true" {...props}>
      <path d="m7.435 12.25c-.08.025-.15.072-.202.135-.048.072-.073.158-.07.245 0 .15.038.252.12.308.077.056.194.082.352.082.087 0 .174-.02.264-.06.09-.038.174-.095.245-.165v-.66c-.168.015-.303.03-.405.045-.105.01-.207.034-.305.07zm4.565-12.25-12 12 12 12 12-12zm0 19.357c-4.062-.002-7.355-3.294-7.357-7.357.002-4.062 3.295-7.356 7.357-7.358 4.063.002 7.355 3.295 7.357 7.358-.002 4.063-3.294 7.355-7.357 7.357zm0-13.98v.002c-3.654 0-6.62 2.966-6.62 6.62s2.966 6.62 6.62 6.62 6.62-2.966 6.62-6.62c0-3.656-2.964-6.62-6.62-6.623zm-2.862 8.246h-.995v-.336l-.182.154c-.142.108-.304.188-.477.233-.082.02-.202.035-.352.035-.262.007-.515-.097-.698-.285-.187-.19-.277-.426-.277-.716 0-.238.046-.427.14-.574.1-.15.24-.27.405-.348.205-.09.423-.152.646-.18.25-.033.516-.06.803-.078v-.017c0-.176-.066-.297-.196-.363-.13-.07-.322-.102-.58-.102-.117 0-.254.02-.41.063-.158.044-.308.1-.458.164h-.087v-.77c.097-.03.256-.062.48-.1.217-.04.438-.06.663-.06.55 0 .95.092 1.2.276.25.183.375.462.375.837v2.168zm3.22-.167c-.07.028-.134.056-.2.086-.074.03-.15.058-.23.08-.094.024-.186.044-.27.06-.084.014-.196.022-.336.022-.263 0-.506-.033-.723-.1-.21-.062-.406-.165-.57-.307-.163-.142-.292-.32-.373-.52-.09-.21-.135-.457-.135-.738-.008-.27.042-.535.146-.78.09-.204.224-.384.392-.53.165-.134.355-.233.56-.29.22-.066.447-.096.675-.096.37 0 .732.087 1.06.255v.854h-.127c-.048-.043-.096-.085-.147-.124-.06-.048-.122-.09-.188-.126-.167-.095-.357-.144-.55-.14-.254 0-.45.086-.59.263-.138.177-.21.414-.21.714 0 .32.075.56.225.715.15.157.347.235.592.235.11 0 .222-.013.33-.042.153-.043.295-.12.415-.225.048-.04.088-.082.123-.11h.13v.843zm4.333.173v-1.597c0-.157 0-.29-.007-.397-.002-.09-.02-.18-.052-.263-.023-.066-.07-.12-.13-.15-.153-.064-.325-.063-.478.002-.086.04-.168.087-.244.14v2.263h-.993v-1.595c0-.156-.003-.286-.01-.396-.003-.09-.02-.18-.05-.264-.027-.066-.076-.12-.136-.15-.06-.033-.145-.048-.25-.048-.083 0-.165.02-.24.056-.078.04-.152.086-.228.136v2.262h-.995v-3.188h.993v.356c.144-.125.296-.233.46-.323.148-.08.314-.12.484-.12.182-.004.36.045.514.14.153.1.27.244.34.414.19-.177.37-.314.54-.41s.34-.145.515-.145c.136-.002.27.023.396.075.115.044.22.116.3.21.09.106.16.23.2.364.045.142.066.328.066.553v2.076h-.995z" />
    </svg>
  );
}

export function OrcidIcon(
  props: JSX.IntrinsicAttributes & SVGProps<SVGSVGElement>
): JSX.Element {
  return (
    <svg viewBox="0 0 32 32" aria-hidden="true" {...props}>
      <path d="m16 3c-7.1678612 0-13 5.832144-13 13s5.8321388 13 13 13c7.167861 0 13-5.832144 13-13s-5.832139-13-13-13zm0 2c6.086982 0 11 4.9130223 11 11 0 6.086978-4.913018 11-11 11-6.0869817 0-11-4.913022-11-11 0-6.0869777 4.9130183-11 11-11zm-5 3a1 1 0 0 0 0 2 1 1 0 0 0 0-2zm-1 3v11h2v-11zm4 0v1 10h4.5c3.025577 0 5.5-2.474423 5.5-5.5s-2.474423-5.5-5.5-5.5zm2 2h2.5c1.944423 0 3.5 1.555577 3.5 3.5s-1.555577 3.5-3.5 3.5h-2.5z" />
    </svg>
  );
}

export function TwitterXIcon(
  props: JSX.IntrinsicAttributes & SVGProps<SVGSVGElement>
): JSX.Element {
  return (
    <svg viewBox="0 0 1200 1227" aria-hidden="true" {...props}>
      <path d="M714.163 519.284L1160.89 0H1055.03L667.137 450.887L357.328 0H0L468.492 681.821L0 1226.37H105.866L515.491 750.218L842.672 1226.37H1200L714.137 519.284H714.163ZM569.165 687.828L521.697 619.934L144.011 79.6944H306.615L611.412 515.685L658.88 583.579L1055.08 1150.3H892.476L569.165 687.854V687.828Z"></path>
    </svg>
  );
}

export function ResearchGateIcon(
  props: JSX.IntrinsicAttributes & SVGProps<SVGSVGElement>
): JSX.Element {
  return (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      viewBox="0 0 24 24"
      aria-hidden="true"
      {...props}
    >
      <path d="m19.586 0c-.818 0-1.508.19-2.073.565-.563.377-.97.936-1.213 1.68a3.193 3.193 0 0 0 -.112.437 8.365 8.365 0 0 0 -.078.53 9 9 0 0 0 -.05.727c-.01.282-.013.621-.013 1.016a31.121 31.123 0 0 0 .014 1.017 9 9 0 0 0 .05.727 7.946 7.946 0 0 0 .077.53h-.005a3.334 3.334 0 0 0 .113.438c.245.743.65 1.303 1.214 1.68.565.376 1.256.564 2.075.564.8 0 1.536-.213 2.105-.603.57-.39.94-.916 1.175-1.65.076-.235.135-.558.177-.93a10.9 10.9 0 0 0 .043-1.207v-.82c0-.095-.047-.142-.14-.142h-3.064c-.094 0-.14.047-.14.141v.956c0 .094.046.14.14.14h1.666c.056 0 .084.03.084.086 0 .36 0 .62-.036.865-.038.244-.1.447-.147.606-.108.385-.348.664-.638.876s-.738.35-1.227.35c-.545 0-.901-.15-1.21-.353-.306-.203-.517-.454-.67-.915a3.136 3.136 0 0 1 -.147-.762 17.366 17.367 0 0 1 -.034-.656c-.01-.26-.014-.572-.014-.939a26.401 26.403 0 0 1 .014-.938 15.821 15.822 0 0 1 .035-.656 3.19 3.19 0 0 1 .148-.76 1.89 1.89 0 0 1 .742-1.01c.344-.244.593-.352 1.137-.352.508 0 .815.096 1.144.303.33.207.528.492.764.925.047.094.111.118.198.07l1.044-.43c.075-.048.09-.115.042-.199a3.549 3.549 0 0 0 -.466-.742 3 3 0 0 0 -.679-.607 3.313 3.313 0 0 0 -.903-.41 4.068 4.068 0 0 0 -1.142-.148zm-11.369 5.836c-1.69 0-3.036.086-4.297.086-1.146 0-2.291 0-3.007-.029v.831l1.088.2c.744.144 1.174.488 1.174 2.264v11.288c0 1.777-.43 2.12-1.174 2.263l-1.088.2v.832c.773-.029 2.12-.086 3.465-.086 1.29 0 2.951.057 3.667.086v-.831l-1.49-.2c-.773-.115-1.174-.487-1.174-2.264v-4.784c.688.057 1.29.057 2.206.057 1.748 3.123 3.41 5.472 4.355 6.56.86 1.032 2.177 1.691 3.839 1.691.487 0 1.003-.086 1.318-.23v-.744c-1.031 0-2.063-.716-2.808-1.518-1.26-1.376-2.95-3.582-4.355-6.074 2.32-.545 4.04-2.722 4.04-4.9 0-3.208-2.492-4.698-5.758-4.698zm-.515 1.29c2.406 0 3.839 1.26 3.839 3.552 0 2.263-1.547 3.782-4.097 3.782-.974 0-1.404-.03-2.063-.086v-7.19c.66-.059 1.547-.059 2.32-.059z" />
    </svg>
  );
}

export function TwitterIcon(
  props: JSX.IntrinsicAttributes & SVGProps<SVGSVGElement>
) {
  return (
    <svg viewBox="0 0 24 24" aria-hidden="true" {...props}>
      <path d="M20.055 7.983c.011.174.011.347.011.523 0 5.338-3.92 11.494-11.09 11.494v-.003A10.755 10.755 0 0 1 3 18.186c.308.038.618.057.928.058a7.655 7.655 0 0 0 4.841-1.733c-1.668-.032-3.13-1.16-3.642-2.805a3.753 3.753 0 0 0 1.76-.07C5.07 13.256 3.76 11.6 3.76 9.676v-.05a3.77 3.77 0 0 0 1.77.505C3.816 8.945 3.288 6.583 4.322 4.737c1.98 2.524 4.9 4.058 8.034 4.22a4.137 4.137 0 0 1 1.128-3.86A3.807 3.807 0 0 1 19 5.274a7.657 7.657 0 0 0 2.475-.98c-.29.934-.9 1.729-1.713 2.233A7.54 7.54 0 0 0 22 5.89a8.084 8.084 0 0 1-1.945 2.093Z" />
    </svg>
  );
}

export function InstagramIcon(
  props: JSX.IntrinsicAttributes & SVGProps<SVGSVGElement>
): JSX.Element {
  return (
    <svg viewBox="0 0 24 24" aria-hidden="true" {...props}>
      <path d="M12 3c-2.444 0-2.75.01-3.71.054-.959.044-1.613.196-2.185.418A4.412 4.412 0 0 0 4.51 4.511c-.5.5-.809 1.002-1.039 1.594-.222.572-.374 1.226-.418 2.184C3.01 9.25 3 9.556 3 12s.01 2.75.054 3.71c.044.959.196 1.613.418 2.185.23.592.538 1.094 1.039 1.595.5.5 1.002.808 1.594 1.038.572.222 1.226.374 2.184.418C9.25 20.99 9.556 21 12 21s2.75-.01 3.71-.054c.959-.044 1.613-.196 2.185-.419a4.412 4.412 0 0 0 1.595-1.038c.5-.5.808-1.002 1.038-1.594.222-.572.374-1.226.418-2.184.044-.96.054-1.267.054-3.711s-.01-2.75-.054-3.71c-.044-.959-.196-1.613-.419-2.185A4.412 4.412 0 0 0 19.49 4.51c-.5-.5-1.002-.809-1.594-1.039-.572-.222-1.226-.374-2.184-.418C14.75 3.01 14.444 3 12 3Zm0 1.622c2.403 0 2.688.009 3.637.052.877.04 1.354.187 1.67.31.421.163.72.358 1.036.673.315.315.51.615.673 1.035.123.317.27.794.31 1.671.043.95.052 1.234.052 3.637s-.009 2.688-.052 3.637c-.04.877-.187 1.354-.31 1.67-.163.421-.358.72-.673 1.036a2.79 2.79 0 0 1-1.035.673c-.317.123-.794.27-1.671.31-.95.043-1.234.052-3.637.052s-2.688-.009-3.637-.052c-.877-.04-1.354-.187-1.67-.31a2.789 2.789 0 0 1-1.036-.673 2.79 2.79 0 0 1-.673-1.035c-.123-.317-.27-.794-.31-1.671-.043-.95-.052-1.234-.052-3.637s.009-2.688.052-3.637c.04-.877.187-1.354.31-1.67.163-.421.358-.72.673-1.036.315-.315.615-.51 1.035-.673.317-.123.794-.27 1.671-.31.95-.043 1.234-.052 3.637-.052Z" />
      <path d="M12 15a3 3 0 1 1 0-6 3 3 0 0 1 0 6Zm0-7.622a4.622 4.622 0 1 0 0 9.244 4.622 4.622 0 0 0 0-9.244Zm5.884-.182a1.08 1.08 0 1 1-2.16 0 1.08 1.08 0 0 1 2.16 0Z" />
    </svg>
  );
}

export function GitHubIcon(
  props: JSX.IntrinsicAttributes & SVGProps<SVGSVGElement>
): JSX.Element {
  return (
    <svg viewBox="0 0 24 24" aria-hidden="true" {...props}>
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M12 2C6.475 2 2 6.588 2 12.253c0 4.537 2.862 8.369 6.838 9.727.5.09.687-.218.687-.487 0-.243-.013-1.05-.013-1.91C7 20.059 6.35 18.957 6.15 18.38c-.113-.295-.6-1.205-1.025-1.448-.35-.192-.85-.667-.013-.68.788-.012 1.35.744 1.538 1.051.9 1.551 2.338 1.116 2.912.846.088-.666.35-1.115.638-1.371-2.225-.256-4.55-1.14-4.55-5.062 0-1.115.387-2.038 1.025-2.756-.1-.256-.45-1.307.1-2.717 0 0 .837-.269 2.75 1.051.8-.23 1.65-.346 2.5-.346.85 0 1.7.115 2.5.346 1.912-1.333 2.75-1.05 2.75-1.05.55 1.409.2 2.46.1 2.716.637.718 1.025 1.628 1.025 2.756 0 3.934-2.337 4.806-4.562 5.062.362.32.675.936.675 1.897 0 1.371-.013 2.473-.013 2.82 0 .268.188.589.688.486a10.039 10.039 0 0 0 4.932-3.74A10.447 10.447 0 0 0 22 12.253C22 6.588 17.525 2 12 2Z"
      />
    </svg>
  );
}

export function LinkedInIcon(
  props: JSX.IntrinsicAttributes & SVGProps<SVGSVGElement>
): JSX.Element {
  return (
    <svg viewBox="0 0 24 24" {...props}>
      <path d="M18.335 18.339H15.67v-4.177c0-.996-.02-2.278-1.39-2.278-1.389 0-1.601 1.084-1.601 2.205v4.25h-2.666V9.75h2.56v1.17h.035c.358-.674 1.228-1.387 2.528-1.387 2.7 0 3.2 1.778 3.2 4.091v4.715zM7.003 8.575a1.546 1.546 0 01-1.548-1.549 1.548 1.548 0 111.547 1.549zm1.336 9.764H5.666V9.75H8.34v8.589zM19.67 3H4.329C3.593 3 3 3.58 3 4.297v15.406C3 20.42 3.594 21 4.328 21h15.338C20.4 21 21 20.42 21 19.703V4.297C21 3.58 20.4 3 19.666 3h.003z" />
    </svg>
  );
}

export function GoogleScholarIcon(
  props: JSX.IntrinsicAttributes & SVGProps<SVGSVGElement>
): JSX.Element {
  return (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      viewBox="0 0 30 30.000001"
      preserveAspectRatio="xMidYMid meet"
      {...props}
    >
      <defs>
        <clipPath id="id1">
          <path
            d="M 3.386719 3 L 27.339844 3 L 27.339844 28 L 3.386719 28 Z M 3.386719 3 "
            clipRule="nonzero"
          />
        </clipPath>
      </defs>
      <g clipPath="url(#id1)">
        <path
          d="M 14.660156 3.25 L 3.386719 10.308594 L 11.125 10.308594 C 11.097656 10.417969 11.050781 10.515625 11.027344 10.625 C 10.960938 10.964844 10.910156 11.34375 10.910156 11.734375 C 10.910156 16.773438 16.054688 16.207031 16.054688 16.207031 L 16.054688 17.492188 C 16.054688 18.011719 16.734375 17.832031 16.816406 18.890625 C 16.476562 18.890625 9.691406 18.695312 9.691406 23.277344 C 9.691406 27.882812 15.679688 27.65625 15.679688 27.65625 C 15.679688 27.65625 22.59375 27.964844 22.59375 22.273438 C 22.597656 18.871094 18.636719 17.765625 18.636719 16.398438 C 18.636719 15.015625 21.621094 14.609375 21.621094 11.375 C 21.621094 9.960938 21.523438 8.953125 20.890625 8.238281 C 20.84375 8.1875 20.808594 8.152344 20.761719 8.121094 C 20.75 8.109375 20.738281 8.101562 20.726562 8.09375 L 20.898438 8.09375 L 23.816406 5.902344 L 23.816406 8.898438 C 23.816406 8.953125 23.820312 9.007812 23.832031 9.0625 C 23.609375 9.1875 23.429688 9.363281 23.300781 9.585938 C 23.171875 9.808594 23.109375 10.050781 23.113281 10.308594 L 23.113281 11.722656 C 23.109375 11.910156 23.144531 12.09375 23.214844 12.269531 C 23.285156 12.445312 23.386719 12.597656 23.515625 12.734375 C 23.648438 12.867188 23.804688 12.972656 23.976562 13.042969 C 24.152344 13.117188 24.332031 13.152344 24.519531 13.152344 C 24.710938 13.152344 24.890625 13.117188 25.066406 13.042969 C 25.238281 12.972656 25.390625 12.867188 25.523438 12.734375 C 25.65625 12.597656 25.757812 12.445312 25.828125 12.269531 C 25.898438 12.09375 25.933594 11.910156 25.929688 11.722656 L 25.929688 10.308594 C 25.933594 10.050781 25.871094 9.808594 25.742188 9.585938 C 25.613281 9.363281 25.433594 9.1875 25.207031 9.0625 C 25.21875 9.007812 25.226562 8.953125 25.226562 8.898438 L 25.226562 4.839844 L 27.339844 3.25 Z M 15.632812 7.5625 C 16.039062 7.542969 16.445312 7.640625 16.835938 7.863281 C 17.125 8.007812 17.402344 8.21875 17.644531 8.480469 C 18.148438 8.984375 18.570312 9.714844 18.796875 10.578125 C 19.332031 12.625 18.636719 14.597656 17.191406 14.96875 C 15.765625 15.375 14.171875 14.039062 13.621094 12.007812 C 13.378906 11.015625 13.410156 10.054688 13.6875 9.292969 C 13.691406 9.28125 13.695312 9.273438 13.699219 9.265625 C 13.703125 9.261719 13.710938 9.257812 13.714844 9.253906 C 13.792969 8.953125 13.921875 8.679688 14.082031 8.457031 C 14.371094 8.035156 14.753906 7.746094 15.226562 7.617188 C 15.363281 7.585938 15.496094 7.566406 15.632812 7.5625 Z M 16.183594 19.75 C 18.566406 19.570312 20.597656 20.886719 20.746094 22.675781 C 20.84375 24.449219 19.007812 26.027344 16.605469 26.1875 C 14.222656 26.351562 12.160156 25.050781 12.046875 23.277344 C 11.933594 21.492188 13.78125 19.929688 16.183594 19.75 Z M 16.183594 19.75 "
          fillOpacity="1"
          fillRule="nonzero"
        />
      </g>
    </svg>
  );
}

export function SementicScholarIcon(
  props: React.SVGProps<SVGSVGElement>
): JSX.Element {
  return (
    <svg viewBox="0 0 512 512" {...props}>
      <path d="m 379.0868,75.20191 c 18.16812,40.68422 25.53302,83.89034 32.42143,127.20955 -1.26557,0.35902 -2.52865,0.72116 -3.79427,1.08267 -0.9109,-2.53364 -1.98432,-5.02156 -2.70735,-7.60959 -5.21805,-18.65384 -10.47938,-37.29655 -15.47376,-56.01156 -1.79641,-6.7327 -6.03443,-10.08392 -12.09539,-13.38137 -8.90177,-4.84112 -17.31343,-11.08316 -24.69005,-18.04576 -4.70771,-4.44068 -8.73494,-7.14859 -15.41325,-7.07815 -44.46061,0.47028 -88.92553,0.51538 -133.38426,0.92448 -2.96314,0.0295 -6.63075,1.12345 -8.72809,3.06448 -8.08853,7.48476 -15.67094,15.51457 -25.64177,25.55586 26.29927,64.04074 39.52245,133.8403 33.84523,208.04469 -12.62623,-8.0842 -22.40117,-14.47949 -22.98144,-31.41848 C 177.54002,222.87779 151.42365,146.31401 96.863089,80.431113 95.635828,78.948619 95.025884,76.955074 94.126122,75.20129 H 379.0868 Z M 48.729955,107.84705 c 12.662672,0 25.33214,-0.20085 37.983708,0.17178 2.510789,0.0723 6.022658,1.66788 7.277148,3.67935 37.836649,60.79088 67.333839,124.63574 71.155359,197.68268 0.0178,0.28921 -0.2826,0.59448 -1.36262,2.71657 -22.61129,-77.29358 -63.40364,-142.73587 -115.871175,-201.39106 0.273676,-0.95167 0.544426,-1.90519 0.818185,-2.85871 z m -40.7293523,53.1819 c 18.0890173,-0.65752 33.3891773,-1.3175 48.6911883,-1.60238 1.541204,-0.0295 3.360468,2.009 4.650795,3.4439 29.847587,33.20131 56.935394,68.2806 73.632114,110.23473 3.17758,7.97976 5.35158,16.35996 7.98907,24.55477 C 108.37943,243.23533 60.253096,202.53752 7.9999987,161.02833 Z M 202.47422,436.79811 c -31.48153,-50.06559 -61.80372,-98.28894 -92.12778,-146.5123 0.37077,-0.47706 0.74155,-0.95165 1.11169,-1.42811 2.54233,2.04731 56.62149,45.41225 80.9093,65.30201 6.76608,5.54129 11.87848,5.44178 18.91585,-0.27375 82.58396,-67.08545 174.73706,-117.86224 272.58287,-158.80848 5.22305,-2.18511 10.64009,-3.91664 15.98238,-5.81688 1.18651,-0.42022 2.44093,-0.65319 4.15147,-0.22122 C 390.37701,255.0261 281.97764,327.27773 202.47359,436.79871 Z" />
    </svg>
  );
}

export function DBLPIcon(props: React.SVGProps<SVGSVGElement>): JSX.Element {
  return (
    <svg viewBox="0 0 24 24" {...props}>
      <path d="M6.17,19.317c-0.161,0-0.318-0.034-0.465-0.102c-0.491-0.228-0.646-0.73-0.672-0.828l-2.232-8.59C2.594,9.007,3.053,8.382,3.566,8.136l1.146-0.549L3.056,1.23C2.888,0.604,3.213,0.282,3.36,0.172c0.341-0.251,0.81-0.227,1.29,0.072l6.338,4.006c0.843,0.523,1.067,1.293,1.09,1.379c0.011,0.039,0.018,0.079,0.021,0.12l2.221,8.508c0.007,0.024,0.021,0.104,0.024,0.129c0.128,0.727-0.325,1.308-0.802,1.534l-6.805,3.261C6.55,19.272,6.357,19.317,6.17,19.317z M4.264,9.465l2.136,8.216l6.497-3.114L10.628,6.05c-0.006-0.024-0.011-0.048-0.015-0.072c-0.039-0.083-0.156-0.292-0.421-0.456l-5.35-3.381L6.32,7.808c0.091,0.347-0.078,0.71-0.401,0.866L4.264,9.465z M4.214,9.489C4.214,9.489,4.214,9.489,4.214,9.489L4.214,9.489L4.214,9.489z"></path>
      <path d="M20.102,24c-0.235,0-0.493-0.081-0.753-0.24l-6.339-4.006c-0.459-0.286-0.806-0.688-1.026-1.193c-0.009-0.02-0.048-0.131-0.055-0.152l-0.114-0.429c-0.104-0.401,0.135-0.811,0.535-0.916c0.397-0.102,0.811,0.134,0.916,0.535l0.1,0.38c0.028,0.062,0.139,0.315,0.442,0.504l5.352,3.382l-1.475-5.656c-0.091-0.35,0.079-0.714,0.406-0.868l1.7-0.8l-2.189-8.196l-3.479,1.661c-0.377,0.18-0.822,0.02-1-0.354c-0.179-0.374-0.021-0.821,0.354-1l3.79-1.81c0.354-0.167,0.723-0.177,1.036-0.029c0.489,0.23,0.639,0.732,0.664,0.83l2.229,8.587c0.214,0.78-0.241,1.41-0.755,1.662l-1.147,0.54l1.652,6.337c0.163,0.626-0.161,0.948-0.308,1.057C20.482,23.942,20.3,24,20.102,24z M17.515,6.019c0,0.001,0,0.002,0.001,0.003L17.515,6.019z"></path>
    </svg>
  );
}

export function SpotifyIcon(props: React.SVGProps<SVGSVGElement>): JSX.Element {
  return (
    <svg viewBox="0 0 168 168" {...props}>
      <path
        fill="#1ED760"
        d="M83.996.277C37.747.277.253 37.77.253 84.019c0 46.251 37.494 83.741 83.743 83.741 46.254 0 83.744-37.49 83.744-83.741 0-46.246-37.49-83.738-83.745-83.738l.001-.004zm38.404 120.78a5.217 5.217 0 01-7.18 1.73c-19.662-12.01-44.414-14.73-73.564-8.07a5.222 5.222 0 01-6.249-3.93 5.213 5.213 0 013.926-6.25c31.9-7.291 59.263-4.15 81.337 9.34 2.46 1.51 3.24 4.72 1.73 7.18zm10.25-22.805c-1.89 3.075-5.91 4.045-8.98 2.155-22.51-13.839-56.823-17.846-83.448-9.764-3.453 1.043-7.1-.903-8.148-4.35a6.538 6.538 0 014.354-8.143c30.413-9.228 68.222-4.758 94.072 11.127 3.07 1.89 4.04 5.91 2.15 8.976v-.001zm.88-23.744c-26.99-16.031-71.52-17.505-97.289-9.684-4.138 1.255-8.514-1.081-9.768-5.219a7.835 7.835 0 015.221-9.771c29.581-8.98 78.756-7.245 109.83 11.202a7.823 7.823 0 012.74 10.733c-2.2 3.722-7.02 4.949-10.73 2.739z"
      />
    </svg>
  );
}
