# [Luanti Website](https://www.minetest.net)

[![Build status](https://github.com/minetest/minetest.github.io/workflows/build/badge.svg)](https://github.com/minetest/minetest.github.io/actions)\
The official Luanti website, living at [www.minetest.net](https://www.minetest.net).

## Features

- Uses the [Bulma](https://bulma.io/) CSS framework.
- Uses modern Web design techniques: `rem` units, `hsl` colors.
- Responsive site and favicon.

## Development workflow

This site uses the [Jekyll](https://jekyllrb.com) static site generator.

- Ensure you have [Ruby](https://www.ruby-lang.org/) 2.4 or later installed.
- Install [Bundler](https://bundler.io/) by running `gem install bundler`.
  - On Linux, use a Ruby version manager such as [rbenv](https://github.com/rbenv/rbenv)
    to easily switch to any version and avoid permission issues.
- Install dependencies by running `bundle install`.
- Use `bundle exec jekyll serve` to automatically build the site
  and serve it locally.

You can also use the provided [Dev Container](https://containers.dev/) configuration to make it easier.

### Browser support

When working on new features, keep in mind this website only supports
*evergreen browsers*:

- Chrome (two most recent versions)
- Edge (two most recent versions)
- Firefox (two most recent versions + latest ESR version)
- Opera (two most recent versions)
- Safari (two most recent versions)

Internet Explorer isn't supported.

## License

Copyright © 2015-2020 Hugo Locurcio and contributors

Unless otherwise specified, code is licensed under the MIT license.
Media (except gallery) and content are licensed under
[CC BY-SA 3.0 Unported](https://creativecommons.org/licenses/by-sa/3.0/).

Gallery screenshots are by various authors and depict various content

- 1: Backrooms Test (Sumianvoice)
- 2: Soothing32 (Zughy)
- 3: i3 (Jean-Patrick Guerrero)
- 4: Mineclone2 (Wuzzy)
- 5: Steampunk Blimp (APercy)
- 6: Animalia (ElCeejo)
- 7: RPG16 texture pack (Hugues Ross)
- 8: Minetest Game
