'use strict';

// <a name="components-dom-constructors"></a>
// ###dom events constructors


var _ = require('milo-core').proto;


// https://developer.mozilla.org/en-US/docs/Web/Reference/Events

var eventTypes = {
    ClipboardEvent: ['copy', 'cut', 'paste', 'beforecopy', 'beforecut', 'beforepaste'],
    Event: ['input', 'readystatechange'],
    FocusEvent: ['focus', 'blur', 'focusin', 'focusout'],
    KeyboardEvent: ['keydown', 'keypress',  'keyup'],
    MouseEvent: ['click', 'contextmenu', 'dblclick', 'mousedown', 'mouseup',
                 'mouseenter', 'mouseleave', 'mousemove', 'mouseout', 'mouseover',
                 'show' /* context menu */],
    TouchEvent: ['touchstart', 'touchend', 'touchmove', 'touchenter', 'touchleave', 'touchcancel'],
};


// mock window and event constructors for testing
if (typeof window != 'undefined')
    var global = window;
else {
    global = {};
    _.eachKey(eventTypes, function(eTypes, eventConstructorName) {
        var eventConstructor = _.makeFunction(eventConstructorName, 'type', 'properties',
            'this.type = type; _.extend(this, properties);');
        global[eventConstructorName] = eventConstructor;
    });
}


var domEventsConstructors = {};

_.eachKey(eventTypes, function(eTypes, eventConstructorName) {
    eTypes.forEach(function(type) {
        if (Object.hasOwnProperty(domEventsConstructors, type))
            throw new Error('duplicate event type ' + type);

        domEventsConstructors[type] = global[eventConstructorName];
    });
});


module.exports = domEventsConstructors;
