# Snapshot hash

Snapshots are prepended with a header specifying the **version hash**. This hash depends on all source code files that can potentially affect the snapshot format. Therefore, if the version hash has been verified to work with Darter, it'll probably parse without major problems. Currently, the only snapshot version supported is `c8562f0ee0ebc38ba217c7955956d1cb`.
The table below shows snapshot hash values for every Flutter release.

## How to get snapshot hash for a Dart SDK version

Version-related stuff in the Dart runtime is injected into the `runtime/vm/version_in.cc` template, you can see the fields there:

 - `SNAPSHOT_HASH`: the hash that appears as the 'version' field in the snapshot header
 - `VERSION_STR` and `COMMIT_TIME`
 - `ABI_VERSION` and `OLDEST_SUPPORTED_ABI_VERSION`

According to `runtime/BUILD.gn`, this file is generated by `tools/make_version.py`. The hash is generated by concatenating the contents of each file in `VM_SNAPSHOT_FILES`, and taking the MD5 of the result.
Quick way to generate it:

    echo '{{SNAPSHOT_HASH}}' > /tmp/mv-template && python2 tools/make_version.py --input /tmp/mv-template --output /tmp/v-result

## How is the snapshot hash calculated

It's calculated by the [`tools/make_version.py`](https://github.com/dart-lang/sdk/blob/34224674260486616e008a3dabd5f38ce4520cef/tools/make_version.py) script.

The script looks at a list of files (the `VM_SNAPSHOT_FILES` variable) located in
`runtime/vm` containing headers and source files whose changes could *potentially* introduce a
breaking change in the format. These files are read(*) and concatenated, in order, and
the MD5 of the result is the snapshot hash.

The snapshot hash was introduced in [`3dfb90f5`](https://github.com/dart-lang/sdk/commit/3dfb90f59f7a6846b00259770bc08104f7bcc594) (1.7.0-dev.2.0, late 2014). Before that, the
*version string* (see same script) was used. Darter will likely never work with such old
snapshots anyway, so we can forget about it.

In [`f58c5bb7`](https://github.com/dart-lang/sdk/commit/f58c5bb78a117d3090cebb83eb00d1b3372cffb1) (2.0.0-dev.8.0, late 2017),
the calculation was changed to include `clustered_snapshot.{h,cc}` and `image_snapshot.{h,cc}`.
 - `clustered_snapshot.{h,cc}` was added in [`524fbc1e`](https://github.com/dart-lang/sdk/commit/524fbc1e0f9d61ff5da69bbed2b35745528de945) (1.18.0-dev.4.0, mid 2016).
 - `image_snapshot.{h,cc}` was added in [`8ed836f`](https://github.com/dart-lang/sdk/commit/8ed836fd6d988f7a3466b2707cabd739f2d10aa3) (2.0.0-dev.6.0, late 2017, some days before `f58c5bb7`).

(*) read using python's default text mode, then encoded as UTF-8 before concatenating.
After [`0ce83987`](https://github.com/dart-lang/sdk/commit/0ce83987d65d008a5705edb248bddb9c845643ec),
(2.9.0-21.0.dev, mid 2020) they are read in binary mode and should be exactly equivalent to `cat [files] | md5sum`.

To date, there have been no more changes.

FIXME: ABI version, could it be useful? cc455ecc1d5a4f45297831472086d3bbe4b78d9b
FIXME: look at pkg/kernel/binary.md


# Flutter versions

Info about the various release channels: <https://github.com/flutter/flutter/wiki/Flutter-build-release-channels>

Listed in <https://docs.flutter.dev/development/tools/sdk/releases>, which loads:

<https://storage.googleapis.com/flutter_infra_release/releases/releases_windows.json>  
<https://storage.googleapis.com/flutter_infra_release/releases/releases_macos.json>  
<https://storage.googleapis.com/flutter_infra_release/releases/releases_linux.json>

Containing releases by channel, with: release date, commit, tag (and also filename and sha256 hash?)

## How to get Dart SDK version used by Flutter

 - For a certain Flutter version, look at the used `engine` version by looking at the **`bin/internal/engine.version`** file.

 - Then go to that commit of flutter/engine, and look at `DEPS` file. `dart_revision` indicates commit of dart/sdk.


# Flutter version table

| Release date | Channel | Version | Commit | Engine commit | Dart SDK commit | Snapshot version |
| ------------ | ------- | ------- | ------ | ------------- | --------------- | ---------------- |
| 2021-12-16 | stable | 2.8.1 | 77d935af4db863f6abd0b9c31c7e6df2a13de57b | 890a5fca2e34db413be624fc83aeea8e61d42ce6 | 1278bd5adb6a857580f137e47bc521976222f7b9 | adf563436d12ba0d50ea5beb7f3be1bb |
| 2021-12-15 | beta | 2.9.0-0.1.pre | 8f1f9c10f04b8f106d78275e93ceead8ea837d8b | 234aca678a2fb70ff2659870186f97c32f8894f4 | 88bcc99a5555d1b463b9601feb6973c97846e2e2 | 3318fe66091c0ffbb64faec39976cb7d |
| 2021-12-09 | stable | 2.8.0 | cf4400006550b70f28e4b4af815151d1e74846c6 | 40a99c595137e4b2f5b2efa8ff343ea23c1e16b8 | 3d2629cd0310df74bdf260d828ed3c75f25db889 | adf563436d12ba0d50ea5beb7f3be1bb |
| 2021-12-01 | beta | 2.8.0-3.3.pre | 262b70ece1aebf84f132c51ec4cf90be605ce61b | 06a7363b0cfd4092fe06eb80f829b5fbc94fd32a | 52519ea8eb4780c468c4c2ed00e7c8046ccfed41 | adf563436d12ba0d50ea5beb7f3be1bb |
| 2021-11-18 | beta | 2.8.0-3.2.pre | 2901cd720879ba3d7ba7cbd7d447ec9e80f937b6 | bcc2b7f12cada3d1359e353c416568b4c3f6df69 | 52519ea8eb4780c468c4c2ed00e7c8046ccfed41 | adf563436d12ba0d50ea5beb7f3be1bb |
| 2021-11-12 | beta | 2.8.0-3.1.pre | 3dab5550407a2c2fe70a762acfdfde93311148de | 09f1520e8b9585d133faf1eccced9357670c6d11 | c8b50bd835770529f30c6079376c824264a57e2c | adf563436d12ba0d50ea5beb7f3be1bb |
| 2021-10-28 | beta | 2.7.0-3.1.pre | fc7015e35aac7ab785e7ae15a47db5c9e669ec7f | a75e3b80f9c1ffb30bbe736c5a42e4a815a79197 | bfadad702e9f699f4ab024c335e7498152d26e34 | 24d9d411c2f90c8fbe8907f99e89d4b0 |
| 2021-10-20 | beta | 2.7.0-3.0.pre | c19845a8c347adebc2c672f5e51b74855e645be2 | bbba2b2437d739a455ecafb66a22a46d31b233ed | bfadad702e9f699f4ab024c335e7498152d26e34 | 24d9d411c2f90c8fbe8907f99e89d4b0 |
| 2021-10-15 | stable | 2.5.3 | 18116933e77adc82f80866c928266a5b4f1ed645 | d3ea636dc5d16b56819f3266241e1f708979c233 | 4ac35a7ec8c598ba1fdd8a1835a7fd84c61d9221 | 9cf77f4405212c45daf608e1cd646852 |
| 2021-09-30 | stable | 2.5.2 | 3595343e20a61ff16d14e8ecc25f364276bb1b8b | 6ac856380fa4f66469552ce986edf59f65f7cd68 | 020b3efd3f0023c5db2097787f7cf778db837a8f | 9cf77f4405212c45daf608e1cd646852 |
| 2021-09-17 | stable | 2.5.1 | ffb2ecea5223acdd139a5039be2f9c796962833d | b3af521a050e6ef076778bcaf16e27b2521df8f8 | 3300f32fdc5432f40bc00f4179529cbd7449c93a | 9cf77f4405212c45daf608e1cd646852 |
| 2021-09-16 | beta | 2.6.0-5.2.pre | 400608f101bcfb21db99ac4d5df763a80c279337 | 1d521d89d8d98f27be4e0ff84d5c6b72dbdc91ca | d41cdbc054ce74d56b361334320a170a1289955c | f10776149bf76be288def3c2ca73bdc1 |
| 2021-09-10 | beta | 2.5.0 | 4cc385b4b84ac2f816d939a49ea1f328c4e0b48e | f0826da7ef2d301eb8f4ead91aaf026aa2b52881 | 4c8a4f0d7ad055fa7dea5e80862cd2074f4454d3 | 9cf77f4405212c45daf608e1cd646852 |
| 2021-09-08 | stable | 2.5.0 | 4cc385b4b84ac2f816d939a49ea1f328c4e0b48e | f0826da7ef2d301eb8f4ead91aaf026aa2b52881 | 4c8a4f0d7ad055fa7dea5e80862cd2074f4454d3 | 9cf77f4405212c45daf608e1cd646852 |
| 2021-09-02 | beta | 2.5.0-5.3.pre | a7fb06d6faa2f0ad0da124c79a4eb26ae091baa5 | fcde2c8b2f0891c80e1f0f794bc7c26dd50f2949 | aa7d19d185583b221093ad7385cf91fca3e8779c | 9cf77f4405212c45daf608e1cd646852 |
| 2021-08-19 | beta | 2.5.0-5.2.pre | 19c61fed0da681ba2068c97e22add3bde38e51e4 | 7a4c4505f6a7a1aa758d62b58150dce43cfa473f | 9a1827339c8e4e55a9b214d033aeba7d30daa28f | 9cf77f4405212c45daf608e1cd646852 |
| 2021-08-12 | beta | 2.5.0-5.1.pre | 65cf7de5f45140010a5d2989f5abbbf530708a6b | fbeb7e22bd6d594a16c487cc138970fbd2a77d40 | efcdca04aac66e37d579d179866189385e63cd9a | 9cf77f4405212c45daf608e1cd646852 |
| 2021-07-22 | beta | 2.4.0-4.2.pre | f18b9281c2280c2646aa3d4348715ed5bb9446c8 | 844c29f42a614420b2205c178f22d30b43a8b0bb | 3cc4208a482a84bffcf09ceb8fdd85001cd43e19 | 659a72e41e3276e882709901c27de33d |
| 2021-07-22 | beta | 2.4.0-4.1.pre | 7636dea9ca4fe4377dd557c262a992d0cd894bc7 | ed25e8f01efe6e778cdc65a1858ba3c5ce629786 | fb3ebe02a0bb75725cdbaf4179ae5de7a6554e3a | 659a72e41e3276e882709901c27de33d |
| 2021-07-01 | stable | 2.2.3 | f4abaa0735eba4dfd8f33f73363911d63931fe03 | 241c87ad800beeab545ab867354d4683d5bfb6ce | 065872e802209ffa97aa3fad204758830b6100a0 | e4a09dbf2bb120fe4674e0576617a0dc |
| 2021-06-25 | beta | 2.3.0-24.1.pre | 615957513eb43b128a16048ab5aa2daaba1656cd | 9d517f475ba1282b619477bde8e708d6a34287cf | 0cc2dddef12a1d63d08f993b63667623e584b459 | 7a5b240780941844bae88eca5dbaa7b8 |
| 2021-06-11 | stable | 2.2.2 | d79295af24c3ed621c33713ecda14ad196fd9c31 | 91c9fc8fe011352879e3bb6660966eafc0847233 | 516eb3b05c252ef3d34255d06700c1f09f7f4502 | e4a09dbf2bb120fe4674e0576617a0dc |
| 2021-06-11 | beta | 2.2.2 | d79295af24c3ed621c33713ecda14ad196fd9c31 | 91c9fc8fe011352879e3bb6660966eafc0847233 | 516eb3b05c252ef3d34255d06700c1f09f7f4502 | e4a09dbf2bb120fe4674e0576617a0dc |
| 2021-05-27 | stable | 2.2.1 | 02c026b03cd31dd3f867e5faeb7e104cce174c5f | 0fdb562ac8068ce3dda6b69aca3f355f4d1d2718 | 375a2d7c66c8eb5d40872bdb57dd664b5f850d94 | e4a09dbf2bb120fe4674e0576617a0dc |
| 2021-05-19 | beta | 2.2.0 | b22742018b3edf16c6cadd7b76d9db5e7f9064b5 | a9d88a4d182bdae23e3a4989abfb7ea25954aad1 | 9094f738083c746a15b496ea5f882362a3dc4889 | e4a09dbf2bb120fe4674e0576617a0dc |
| 2021-05-18 | stable | 2.2.0 | b22742018b3edf16c6cadd7b76d9db5e7f9064b5 | a9d88a4d182bdae23e3a4989abfb7ea25954aad1 | 9094f738083c746a15b496ea5f882362a3dc4889 | e4a09dbf2bb120fe4674e0576617a0dc |
| 2021-05-10 | beta | 2.2.0-10.3.pre | 06e2fd63574bad2edafbe4653104ed76871ee0b1 | a123e75c6082da3a08f229b9c565e64b5b24a8a3 | 4511eb2a779a612d9d6b2012123575013e0aef12 | e4a09dbf2bb120fe4674e0576617a0dc |
| 2021-04-30 | stable | 2.0.6 | 1d9032c7e1d867f071f2277eb1673e8f9b0274e3 | 05e680e202af9a92461070cb2d9982acad46c83c | 7c8c6b3053d0ba91fcf15f81c45650184dc27e88 | 5b97292b25f0a715613b7a28e0734f77 |
| 2021-04-29 | beta | 2.2.0-10.2.pre | b5017bf8de877083978bfeb1874d236c3fc83029 | 91ed51e05c68efdbddf642735f164fc914358cff | 5cae07b3980f4684d3d477457c307a67235adf99 | e4a09dbf2bb120fe4674e0576617a0dc |
| 2021-04-16 | stable | 2.0.5 | adc687823a831bbebe28bdccfac1a628ca621513 | b09f014e9658da6647361e7e416d1a159d34192d | 7c8c6b3053d0ba91fcf15f81c45650184dc27e88 | 5b97292b25f0a715613b7a28e0734f77 |
| 2021-04-15 | beta | 2.2.0-10.1.pre | 0941968447ea8058e56e1479f7e53147149b739e | d2a2e93510ad6cfc3d62a90d903b7056e4da8264 | 94162a28126443d4c3f1a7c9267ec1d69d38b330 | 34f6eec64e9371856eaaa278ccf56538 |
| 2021-04-02 | stable | 2.0.4 | b1395592de68cc8ac4522094ae59956dd21a91db | 2dce47073a378673f6ca095e91b8065544c3a881 | 65376c07234d1df472662d21dff2498ab2d3cdda | 5b97292b25f0a715613b7a28e0734f77 |
| 2021-03-19 | stable | 2.0.3 | 4d7946a68d26794349189cf21b3f68cc6fe61dcb | 3459eb24361807fb186953a864cf890fa8e9d26a | 65376c07234d1df472662d21dff2498ab2d3cdda | 5b97292b25f0a715613b7a28e0734f77 |
| 2021-03-18 | beta | 2.1.0-12.2.pre | 5bedb7b1d5698ce2c1c67aaf9afae7b3948b172a | 711ab3fda05004ee5f6035f2a0bf099fca39a129 | 64a5583ffbc920080d1cc04c316d8a949f0ea317 | 39a9141bbcc3cae43e6f9f6b7fbaafe3 |
| 2021-03-15 | beta | 2.0.2 | 8962f6dc68ec8e2206ac2fa874da4a453856c7d3 | 5d8bf811b3072390933d69f3e289a4bb673636c4 | d6e7aacfe6d19c8d478dcf3e315b76720813a417 | 5b97292b25f0a715613b7a28e0734f77 |
| 2021-03-12 | stable | 2.0.2 | 8962f6dc68ec8e2206ac2fa874da4a453856c7d3 | 5d8bf811b3072390933d69f3e289a4bb673636c4 | d6e7aacfe6d19c8d478dcf3e315b76720813a417 | 5b97292b25f0a715613b7a28e0734f77 |
| 2021-03-04 | beta | 2.0.1 | c5a4b4029c0798f37c4a39b479d7cb75daa7b05c | 40441def692f444660a11e20fac37af9050245ab | 72c1995001d1214138a8186032f2199f237bc505 | 5b97292b25f0a715613b7a28e0734f77 |
| 2021-03-04 | stable | 2.0.1 | c5a4b4029c0798f37c4a39b479d7cb75daa7b05c | 40441def692f444660a11e20fac37af9050245ab | 72c1995001d1214138a8186032f2199f237bc505 | 5b97292b25f0a715613b7a28e0734f77 |
| 2021-03-03 | beta | 2.0.0 | 60bd88df915880d23877bfc1602e8ddcf4c4dd2a | 40441def692f444660a11e20fac37af9050245ab | 72c1995001d1214138a8186032f2199f237bc505 | 5b97292b25f0a715613b7a28e0734f77 |
| 2021-03-03 | stable | 2.0.0 | 60bd88df915880d23877bfc1602e8ddcf4c4dd2a | 40441def692f444660a11e20fac37af9050245ab | 72c1995001d1214138a8186032f2199f237bc505 | 5b97292b25f0a715613b7a28e0734f77 |
| 2021-02-25 | beta | 1.26.0-17.8.pre | 044f2cf5607a26f8818dab0f766400e85c52bdff | 042c82b02c83c20e57a67d86a8d3b7677d983556 | 33cba2d358cf0726adba4a994c9514422e0ab027 | 5b97292b25f0a715613b7a28e0734f77 |
| 2021-02-24 | beta | 1.26.0-17.7.pre | 68e7d2e301e1969275cd11947e900b6b80405052 | 4a466e17cb02da06e9e256a278cb9779f2abb245 | efa74fd7dbec036b70ed5537f79a0ba994cf0e75 | 5b97292b25f0a715613b7a28e0734f77 |
| 2021-02-16 | beta | 1.26.0-17.6.pre | a29104a69b102a7485cd00d358eaeab219d258ab | 21fa8bb99e9a20563d9a7d39afeba8e5c811a7eb | cc15e7439ae2c596b2ca0c5c032e294a20843e30 | 5b97292b25f0a715613b7a28e0734f77 |
| 2021-02-11 | beta | 1.26.0-17.5.pre | 1fe38dcb5fc58242c6e0904a318bcc3ed5a4d837 | d4453f601890ec682bbf8f5659b70f15cce1d67d | bc1fa173477efb6192bddd5f95c1ad0cccbc8d6f | 5b97292b25f0a715613b7a28e0734f77 |
| 2021-02-10 | beta | 1.26.0-17.4.pre | 48c9d3e0e19e8fec84f1d316ce0559f26ca7277d | 2c527d6c7e70e2f51bca1a46f1174b250f84c5da | e5dd92c3ca766810e0e5a02d8725b1cebc19f564 | 5b97292b25f0a715613b7a28e0734f77 |
| 2021-02-05 | beta | 1.26.0-17.3.pre | 4b50ca7f7fbf56be72e54cd200825b760416a356 | 2c527d6c7e70e2f51bca1a46f1174b250f84c5da | e5dd92c3ca766810e0e5a02d8725b1cebc19f564 | 5b97292b25f0a715613b7a28e0734f77 |
| 2021-02-04 | beta | 1.26.0-17.2.pre | 79b49b9e1057f90ebf797725233c6b311722de69 | 2c527d6c7e70e2f51bca1a46f1174b250f84c5da | e5dd92c3ca766810e0e5a02d8725b1cebc19f564 | 5b97292b25f0a715613b7a28e0734f77 |
| 2021-01-25 | stable | 1.22.6 | 9b2d32b605630f28625709ebd9d78ab3016b2bf6 | 2f0af3715217a0c2ada72c717d4ed9178d68f6ed | 2ea318b540948b55306bf82fd34b2c84ec634f48 | 8ee4ef7a67df9845fba331734198a953 |
| 2021-01-15 | beta | 1.25.0-8.3.pre | 5d36f2e7f5387b6c751449258ade8e4e6edf99be | 7a8f8ca02c276dce02f8dd42a44e776ac03fa9bc | 2b88e9de118097d12183aa30ec9f8c6bed9d64fc | 9e2165577cef0f0f70f9ff072107920c |
| 2021-01-06 | beta | 1.25.0-8.2.pre | b0a22998593fc605c723dee8ff4d9315c32cfe2c | 92ae191c17a53144bf4d62f3863c110be08e3fd3 | cbd08e5c567353709a0db3692caa984dbcd9aeb7 | 9e2165577cef0f0f70f9ff072107920c |
| 2020-12-16 | beta | 1.25.0-8.1.pre | 8f89f6505b941329a864fef1527243a72800bf4d | 92ae191c17a53144bf4d62f3863c110be08e3fd3 | cbd08e5c567353709a0db3692caa984dbcd9aeb7 | 9e2165577cef0f0f70f9ff072107920c |
| 2020-12-10 | stable | 1.22.5 | 78910062997c3a836feee883712c241a5fd22983 | ae90085a8437c0ae94d6b5ad2741739ebc742cb4 | 7c148d029de32590a8d0d332bf807d25929f080e | 8ee4ef7a67df9845fba331734198a953 |
| 2020-11-19 | beta | 1.24.0-10.2.pre | 022b333a089afb81c471ec43d1f1f4f26305d876 | 07c1eed46b9d9b58df78566e9b8b2e42e80d3380 | 09481aa6ca60a12a5885db108aa5152cecb73fb1 | a2bdb58c7edf9471da9180bf8185e7f7 |
| 2020-11-13 | stable | 1.22.4 | 1aafb3a8b9b0c36241c5f5b34ee914770f015818 | 2c956a31c0a3d350827aee6c56bb63337c5b4e6e | 7c148d029de32590a8d0d332bf807d25929f080e | 8ee4ef7a67df9845fba331734198a953 |
| 2020-10-30 | stable | 1.22.3 | 8874f21e79d7ec66d0457c7ab338348e31b17f1d | a1440ca392ca23e874a105c5f3248b495bd0e247 | ecf9ce8ef42de11033801b2870e8b310c3722902 | 8ee4ef7a67df9845fba331734198a953 |
| 2020-10-16 | stable | 1.22.2 | 84f3d28555368a70270e9ac8390a9441df95e752 | b8752bbfff0419c8bf616b602bc59fd28f6a3d1b | 1d923a386d7a9f384435a2b4c1287b2937504566 | 8ee4ef7a67df9845fba331734198a953 |
| 2020-10-15 | beta | 1.23.0-18.1.pre | 198df796aa80073ef22bdf249e614e2ff33c6895 | 1d12d82d9cb54876f58044aa52198d53ec841c3d | 7cdfa7be71c9530e2ce12a095df1775aa0b9ab63 | 953aa80d78c4d8886e3e4d784fd9d95f |
| 2020-10-08 | stable | 1.22.1 | f30b7f4db93ee747cd727df747941a28ead25ff5 | 75bef9f6c8ac2ed4e1e04cdfcd88b177d9f1850d | efd753621946a89008b76b76d85d54d1aa57fce8 | 8ee4ef7a67df9845fba331734198a953 |
| 2020-10-08 | beta | 1.22.0-12.4.pre | f30b7f4db93ee747cd727df747941a28ead25ff5 | 75bef9f6c8ac2ed4e1e04cdfcd88b177d9f1850d | efd753621946a89008b76b76d85d54d1aa57fce8 | 8ee4ef7a67df9845fba331734198a953 |
| 2020-10-01 | stable | 1.22.0 | d408d302e22179d598f467e11da5dd968dbdc9ec | 5babba6c4d25fa237bbf755ab85c9a0c50b3c6ec | 41eab9b49ccce8960f71c657861dc629f96295af | 8ee4ef7a67df9845fba331734198a953 |
| 2020-09-29 | beta | 1.22.0-12.3.pre | d408d302e22179d598f467e11da5dd968dbdc9ec | 5babba6c4d25fa237bbf755ab85c9a0c50b3c6ec | 41eab9b49ccce8960f71c657861dc629f96295af | 8ee4ef7a67df9845fba331734198a953 |
| 2020-09-28 | beta | 1.22.0-12.2.pre | 2bafdc822636426fa09afb43236400a60ea432b2 | f763b5b9b936872bc6c84b4395286ce684e3b431 | 4215dca724fb80de592f51a6cdba51e7638d1723 | 8ee4ef7a67df9845fba331734198a953 |
| 2020-09-16 | beta | 1.22.0-12.1.pre | 8b3760638a189741cd9ca881aa2dd237c1df1be5 | 4654fc6cf6416daae78eac2c211ad84c46e21625 | 52130c19ca593b185ea9cf72b26b1d02455551ef | 8ee4ef7a67df9845fba331734198a953 |
| 2020-09-15 | stable | 1.20.4 | fba99f6cf9a14512e461e3122c8ddfaa25394e89 | d1bc06f032f9d6c148ea6b96b48261d6f545004f | b07da893600eadc4efafc5a54b8f9533e43c0034 | 04645b6182fad3d68350d84669869ce5 |
| 2020-09-02 | stable | 1.20.3 | 216dee60c0cc9449f0b29bcf922974d612263e24 | d1bc06f032f9d6c148ea6b96b48261d6f545004f | b07da893600eadc4efafc5a54b8f9533e43c0034 | 04645b6182fad3d68350d84669869ce5 |
| 2020-08-28 | beta | 1.21.0-9.2.pre | 81a45ec2e5f80fa71d5135f1702ce540558b416d | 20a953183580250aac2e15d36007664118bda5ab | 2ea332979fbc9e8c42f9efe4a33dec83108c897b | 5f40b0a9f04b5018fa08a9b67fd316cd |
| 2020-08-19 | beta | 1.21.0-9.1.pre | be9bc8cb3942bda5d8ef4e44b44616c470625e18 | 267070c17a6956de1a03dbe09cda56f0c485f41b | 7cb472077b56a99aef7233bb616ba200b4de8682 | 5f40b0a9f04b5018fa08a9b67fd316cd |
| 2020-08-14 | beta | 1.20.2 | bbfbf1770cca2da7c82e887e4e4af910034800b6 | 9d5b21729ff53dbf8eadd8bc97e0e30d77abec95 | e940ff7819053ed8a4c04a4dfcda7df12e969331 | 04645b6182fad3d68350d84669869ce5 |
| 2020-08-13 | stable | 1.20.2 | bbfbf1770cca2da7c82e887e4e4af910034800b6 | 9d5b21729ff53dbf8eadd8bc97e0e30d77abec95 | e940ff7819053ed8a4c04a4dfcda7df12e969331 | 04645b6182fad3d68350d84669869ce5 |
| 2020-08-06 | stable | 1.20.1 | 2ae34518b87dd891355ed6c6ea8cb68c4d52bb9d | c8e3b9485386425213e2973126d6f57e7ed83c54 | 6eb17654b6501e2617c67854ed113ab550d2b3c7 | 04645b6182fad3d68350d84669869ce5 |
| 2020-08-05 | stable | 1.20.0 | 840c9205b344a59e48a5926ee2d791cc5640924c | c8e3b9485386425213e2973126d6f57e7ed83c54 | 6eb17654b6501e2617c67854ed113ab550d2b3c7 | 04645b6182fad3d68350d84669869ce5 |
| 2020-08-03 | beta | 1.20.0-7.4.pre | 916c3ac648aa0498a70f32b5fc4f6c51447628e3 | d6ee1499c27a156a797d9f1539ffb7892855c1d0 | e2ea2e82e8785e18df30b7a06ef7cbc73fd9a81a | 04645b6182fad3d68350d84669869ce5 |
| 2020-07-29 | beta | 1.20.0-7.3.pre | e606910f28be51c8151f6169072afe3b3a8b3c5e | ac95267aef5175b3f6c3387d502070c68f588ad5 | e2ea2e82e8785e18df30b7a06ef7cbc73fd9a81a | 04645b6182fad3d68350d84669869ce5 |
| 2020-07-21 | beta | 1.20.0-7.2.pre | a2bde82fbd52e09057a4146f46889f4e10342d32 | 60b269d898cbe0be27e9b9ba9d21eae97b887ab6 | 57f76512bee70f7e96abf9306797a5e256e02453 | 8b2ca977d1d2920b9839d1b60eade6a7 |
| 2020-07-01 | beta | 1.19.0-4.3.pre | 8fe7655ed20ffd1395f68e30539a847a01a30351 | 9a28c3bcf40ce64fee61e807ee3e1395fd6bd954 | 5815449a2935fd4a0a9505fa0f7ca562a53f2465 | 59da07d9da5a83be4ce75b7913b63dbd |
| 2020-07-01 | beta | 1.19.0-4.2.pre | 9b9b543d9265484132c798adaab6caca52055b08 | 9a28c3bcf40ce64fee61e807ee3e1395fd6bd954 | 5815449a2935fd4a0a9505fa0f7ca562a53f2465 | 59da07d9da5a83be4ce75b7913b63dbd |
| 2020-07-01 | stable | 1.17.5 | 8af6b2f038c1172e61d418869363a28dffec3cb4 | ee76268252c22f5c11e82a7b87423ca3982e51a7 | caebd6700d5ece73b5566b33ff1daecb91dac500 | be7d304ff826e2dfac63538e227c3cc5 |
| 2020-06-18 | stable | 1.17.4 | 1ad9baa8b99a2897c20f9e6e54d3b9b359ade314 | ee76268252c22f5c11e82a7b87423ca3982e51a7 | caebd6700d5ece73b5566b33ff1daecb91dac500 | be7d304ff826e2dfac63538e227c3cc5 |
| 2020-06-10 | beta | 1.19.0-4.1.pre | f994b769743368b36b9c03fb359f62230b60ab92 | 9a28c3bcf40ce64fee61e807ee3e1395fd6bd954 | 5815449a2935fd4a0a9505fa0f7ca562a53f2465 | 59da07d9da5a83be4ce75b7913b63dbd |
| 2020-06-04 | stable | 1.17.3 | b041144f833e05cf463b8887fa12efdec9493488 | ee76268252c22f5c11e82a7b87423ca3982e51a7 | caebd6700d5ece73b5566b33ff1daecb91dac500 | be7d304ff826e2dfac63538e227c3cc5 |
| 2020-05-28 | stable | 1.17.2 | 5f21edf8b66e31a39133177319414395cc5b5f48 | b851c718295a896918dc93cb1ff14f2f895a1b90 | 9a618e5661665b8d687a28e6b1ec25e9177ec2d7 | be7d304ff826e2dfac63538e227c3cc5 |
| 2020-05-14 | beta | 1.18.0-11.1.pre | 2738a1148ba6c9a6114df62358109407c3ef2553 | ef9215ceb2884ddf520d321bcd822d1461330876 | 14c6a93013bfcd311dfeac1c0ad0a5f9f4afb5ef | b58ead73b2c5dfec69565df469bba387 |
| 2020-05-13 | stable | 1.17.1 | f7a6a7906be96d2288f5d63a5a54c515a6e987fe | 6bc433c6b6b5b98dcf4cc11aff31cdee90849f32 | ae8b2249c8fb43ff894eb6f858c41520cf9ce5cc | 74edb834fac3fcea79d7ac2d1d6f1fb2 |
| 2020-05-06 | stable | 1.17.0 | e6b34c2b5c96bb95325269a29a84e83ed8909b5f | 540786dd51f112885a89792d678296b95e6622e5 | f12284ca12b9076dcc86f1524fefd57a7318ee52 | 74edb834fac3fcea79d7ac2d1d6f1fb2 |
| 2020-05-02 | beta | 1.17.0-3.4.pre | e6b34c2b5c96bb95325269a29a84e83ed8909b5f | 540786dd51f112885a89792d678296b95e6622e5 | f12284ca12b9076dcc86f1524fefd57a7318ee52 | 74edb834fac3fcea79d7ac2d1d6f1fb2 |
| 2020-04-29 | beta | 1.17.0-3.3.pre | 0da1ab09224f6c6d69fcff1195a3662fe7ad7534 | 376ad6a64b08aa26005e3f82aed26de2e290b572 | 7611c1abb42779a7ef1117527a7b86677b130c03 | 74edb834fac3fcea79d7ac2d1d6f1fb2 |
| 2020-04-22 | beta | 1.17.0-3.2.pre | 2a7bc389f28d83c581f7ddd4601588a22e12512e | 4c8c31f591882b3c668992d2e9da761118899f38 | 91f39d8eb15aad876332637eea090e196ad295ff | 74edb834fac3fcea79d7ac2d1d6f1fb2 |
| 2020-04-17 | stable | v1.12.13+hotfix.9 | f139b11009aeb8ed2a3a3aa8b0066e482709dde3 | af51afceb8886cc11e25047523c4e0c7e1f5d408 | 1c9356d8990a2a8c90c66097e20cb2f22e5cc267 | 20e5c4f7dc44368ac5a17643b93665f6 |
| 2020-04-06 | beta | 1.17.0-dev.3.1 | d3ed9ec945f8869f0e136c357d0c2a6be2b60c98 | c9506cb8e93e5e8879152ff5c948b175abb5b997 | eea97179386a9ced7d68452cea158345f4019baa | 9e7cb7c9394c24c2398410b902673e13 |
| 2020-03-17 | beta | v1.15.17 | 2294d75bfa8d067ba90230c0fc2268f3636d7584 | 5aff3119480996ca014ec0f8d26d74db617b5852 | 9983424a3c50c623730fd43b4ce263df660eb455 | ee91a9191a5286c31d91a89754ba36af |
| 2020-02-11 | stable | v1.12.13+hotfix.8 | 0b8abb4724aa590dd0f429683339b1e045a1594d | e1e6ced81d029258d449bdec2ba3cddca9c2ca0c | 4cc36055d6803b899667feaedc1216a96e9d1c72 | 20e5c4f7dc44368ac5a17643b93665f6 |
| 2020-02-05 | beta | v1.14.6 | fabeb2a16f1d008ab8230f450c49141d35669798 | c4229bfbbae455ad69c967be19aee3fadd6486e1 | fc3af737c75931908521e9c36358a151408d6084 | e739779cc1d28f0f697a92f2daf5f10f |
| 2020-01-27 | stable | v1.12.13+hotfix.7 | 9f5ff2306bb3e30b2b98eee79cd231b1336f41f4 | a67792536ca236a971d0efbcfd7af4efb8f6c119 | a4911c63f4f72ba571d6db94de56007b09f4af99 | 20e5c4f7dc44368ac5a17643b93665f6 |
| 2020-01-15 | beta | v1.13.6 | 659dc8129d4edb9166e9a0d600439d135740933f | bdc9708d235e582483d299642ad8682826ebb90d | c547f5d933e5a10e18b1b26b54a6249e88fa0f1c | 81662522448cdd4d02eb060669e5d48b |
| 2019-12-11 | beta | v1.12.13+hotfix.6 | 18cd7a3601bcffb36fdf2f679f763b5e827c2e8e | 2994f7e1e682039464cb25e31a78b86a3c59b695 | a4911c63f4f72ba571d6db94de56007b09f4af99 | 20e5c4f7dc44368ac5a17643b93665f6 |
| 2019-12-11 | stable | v1.12.13+hotfix.5 | 27321ebbad34b0a3fafe99fac037102196d655ff | 2994f7e1e682039464cb25e31a78b86a3c59b695 | a4911c63f4f72ba571d6db94de56007b09f4af99 | 20e5c4f7dc44368ac5a17643b93665f6 |
| 2019-12-11 | beta | v1.12.13+hotfix.5 | 27321ebbad34b0a3fafe99fac037102196d655ff | 2994f7e1e682039464cb25e31a78b86a3c59b695 | a4911c63f4f72ba571d6db94de56007b09f4af99 | 20e5c4f7dc44368ac5a17643b93665f6 |
| 2019-12-10 | beta | v1.12.13+hotfix.4 | fb60324e6fa791bedeade8be4773a42037e11f62 | ac9391978e7c0693b75a82c219e059b6ffee35c4 | a4911c63f4f72ba571d6db94de56007b09f4af99 | 20e5c4f7dc44368ac5a17643b93665f6 |
| 2019-12-06 | beta | v1.12.13+hotfix.3 | 57f2df76d75cff290cbe2765b07db1ad3e67b50d | ac9391978e7c0693b75a82c219e059b6ffee35c4 | a4911c63f4f72ba571d6db94de56007b09f4af99 | 20e5c4f7dc44368ac5a17643b93665f6 |
| 2019-12-04 | beta | v1.12.13+hotfix.2 | 4f54e46f56c2ffc92eb440dbdab1a7f8e722e593 | 6955b06cedb2425f4363f10642c9b0e63e496af0 | a4911c63f4f72ba571d6db94de56007b09f4af99 | 20e5c4f7dc44368ac5a17643b93665f6 |
| 2019-12-03 | beta | v1.12.13+hotfix.1 | 5b07015393539822da275ab9a348b9e9ce92a29e | c1e322b685a81c11c16bddd22282925b7d0272e8 | a4911c63f4f72ba571d6db94de56007b09f4af99 | 20e5c4f7dc44368ac5a17643b93665f6 |
| 2019-11-22 | beta | v1.11.0 | 856a90e67c9284124d44d2be6c785bacd3a1c772 | af04338413c3ed73316350f64248a152433073b6 | fa4379946109467c8a48f20f19d83d7c72968a3e | 2fb364d659ea53f7892be9ba5e036047 |
| 2019-10-23 | stable | v1.9.1+hotfix.6 | 68587a0916366e9512a78df22c44163d041dd5f3 | b863200c37df4ed378042de11c4e9ff34e4e58c9 | 1ef83b86ae637ffe7359173804cbc6d3fa25e6db | c8562f0ee0ebc38ba217c7955956d1cb |
| 2019-10-17 | stable | v1.9.1+hotfix.5 | 1aedbb1835bd6eb44550293d57d4d124f19901f0 | b863200c37df4ed378042de11c4e9ff34e4e58c9 | 1ef83b86ae637ffe7359173804cbc6d3fa25e6db | c8562f0ee0ebc38ba217c7955956d1cb |
| 2019-10-10 | beta | v1.10.7 | e70236e36ce1d32067dc68eb55519ec3e14b6b01 | 9e6314d348f9b5521e3c66856324d7a9c4a928c9 | 1103600280676ea169a30d7a503e836671cdc553 | c3bbfe8f226120ad0569d7b78ed2d9ef |
| 2019-10-01 | stable | v1.9.1+hotfix.4 | cc949a8e8b9cf394b9290a8e80f87af3e207dce5 | b863200c37df4ed378042de11c4e9ff34e4e58c9 | 1ef83b86ae637ffe7359173804cbc6d3fa25e6db | c8562f0ee0ebc38ba217c7955956d1cb |
| 2019-09-27 | beta | v1.9.1+hotfix.4 | cc949a8e8b9cf394b9290a8e80f87af3e207dce5 | b863200c37df4ed378042de11c4e9ff34e4e58c9 | 1ef83b86ae637ffe7359173804cbc6d3fa25e6db | c8562f0ee0ebc38ba217c7955956d1cb |
| 2019-09-26 | beta | v1.9.1+hotfix.3 | a72edc27064c2cbfbbae17ea1695333e1b3d9595 | b863200c37df4ed378042de11c4e9ff34e4e58c9 | 1ef83b86ae637ffe7359173804cbc6d3fa25e6db | c8562f0ee0ebc38ba217c7955956d1cb |
| 2019-09-10 | stable | v1.9.1+hotfix.2 | 2d2a1ffec95cc70a3218872a2cd3f8de4933c42f | b863200c37df4ed378042de11c4e9ff34e4e58c9 | 1ef83b86ae637ffe7359173804cbc6d3fa25e6db | c8562f0ee0ebc38ba217c7955956d1cb |
| 2019-09-08 | beta | v1.9.1+hotfix.2 | 2d2a1ffec95cc70a3218872a2cd3f8de4933c42f | b863200c37df4ed378042de11c4e9ff34e4e58c9 | 1ef83b86ae637ffe7359173804cbc6d3fa25e6db | c8562f0ee0ebc38ba217c7955956d1cb |
| 2019-09-04 | beta | v1.9.1+hotfix.1 | a1fb3fabec40144f57344635c37c28eed4fb122b | cc88fa45dbf4c55bc23cecea17fb90f43bccf588 | 74e4033d316abb6cc2290051ec85534caf4dca54 | c8562f0ee0ebc38ba217c7955956d1cb |
| 2019-08-08 | beta | v1.8.3 | e4ebcdf6f4facee5779c38a04d91d08dc58ea7a4 | 38ac5f30a7026e870619c2e8e8c99c070d74036f | 0ca1582afdb057e8a701908c1c527e0a56a7b5b2 | 34948253b59d5a56b2ec161e17975a4e |
| 2019-07-24 | stable | v1.7.8+hotfix.4 | 20e59316b8b8474554b38493b8ca888794b0234a | fee001c93f25a1e7258e762781a7361f122d29f5 | 7340a569caac6431d8698dc3788579b57ffcf0c6 | 1d7acad1540192ac459cf60344efb7c1 |
| 2019-07-19 | beta | v1.7.8+hotfix.4 | 20e59316b8b8474554b38493b8ca888794b0234a | fee001c93f25a1e7258e762781a7361f122d29f5 | 7340a569caac6431d8698dc3788579b57ffcf0c6 | 1d7acad1540192ac459cf60344efb7c1 |
| 2019-07-09 | stable | v1.7.8+hotfix.3 | b712a172f9694745f50505c93340883493b505e5 | 54ad777fd29b031b87c7a68a6637fb48c0932862 | 7340a569caac6431d8698dc3788579b57ffcf0c6 | 1d7acad1540192ac459cf60344efb7c1 |
| 2019-07-09 | beta | v1.7.8+hotfix.3 | b712a172f9694745f50505c93340883493b505e5 | 54ad777fd29b031b87c7a68a6637fb48c0932862 | 7340a569caac6431d8698dc3788579b57ffcf0c6 | 1d7acad1540192ac459cf60344efb7c1 |
| 2019-07-08 | stable | v1.7.8+hotfix.2 | 2e540931f73593e35627592ca4f9a4ca3035ed31 | b1cb0d9e9b44393efeb735f664672a74732cdc8b | 7340a569caac6431d8698dc3788579b57ffcf0c6 | 1d7acad1540192ac459cf60344efb7c1 |
| 2019-07-02 | beta | v1.7.8+hotfix.2 | 2e540931f73593e35627592ca4f9a4ca3035ed31 | b1cb0d9e9b44393efeb735f664672a74732cdc8b | 7340a569caac6431d8698dc3788579b57ffcf0c6 | 1d7acad1540192ac459cf60344efb7c1 |
| 2019-05-30 | beta | v1.6.3 | bc7bc940836f1f834699625426795fd6f07c18ec | 8dc3a4cde2075a4f5458fd0eb199627f5124508d | e3edfd36b2aa7ff4e98fe541ef5666ef2e70d17e | c89592e3e4956c33956c8ba0f691dbd0 |
| 2019-05-07 | stable | v1.5.4-hotfix.2 | 7a4c33425ddd78c54aba07d86f3f9a4a0051769b | 52c7a1e849a170be4b2b2fe34142ca2c0a6fea1f | a1668566e563aef64025d0af88a099cbbe847b7e | eed485c757fba5d731e4054412c99f2e |
| 2019-05-02 | beta | v1.5.4-hotfix.2 | 7a4c33425ddd78c54aba07d86f3f9a4a0051769b | 52c7a1e849a170be4b2b2fe34142ca2c0a6fea1f | a1668566e563aef64025d0af88a099cbbe847b7e | eed485c757fba5d731e4054412c99f2e |
| 2019-04-30 | beta | v1.5.4-hotfix.1 | 09cbc34a0b19cef287a82aa4b9966d525369eecc | 52c7a1e849a170be4b2b2fe34142ca2c0a6fea1f | a1668566e563aef64025d0af88a099cbbe847b7e | eed485c757fba5d731e4054412c99f2e |
| 2019-04-27 | beta | v1.5.4 | b593f5167bce84fb3cad5c258477bf3abc1b14eb | ca31a7c57bada458fa7f5c0d3f36bc1af4ccbc79 | cf4444b803a376bb1ad6442e1f09434a4d58167b | eed485c757fba5d731e4054412c99f2e |
| 2019-04-12 | beta | v1.4.9-hotfix.1 | 88fa7ea4031f5c86225573e58e5558dc4ea1c251 | 4737fc5cd89b8f0136e927b00f2e159444b95a73 | f6768b6fb3e58bb704aca1e22a7ffd11e7ff07cb | f630ecdf457e27dd24d3b9e0a6bc1c13 |
| 2019-03-15 | beta | v1.3.8 | e5b1ed7a7f7b85c1877e09a9495681f719be5578 | f4951df193a7966f9ed4da43d555eee0913d84d1 | 571ea80e1101e706980ea8aefa7fc18a0c8ba2ec | 9a66dcb2da955dffdbdb0eafa0288784 |
| 2019-02-26 | stable | v1.2.1 | 8661d8aecd626f7f57ccbcb735553edc05a2e713 | 3757390fa4b00d2d261bfdf5182d2e87c9113ff9 | 0a7dcf17eb5f2450480527d6ad1e201fb47f1e36 | 0c73eb70aa4d30f450273cb424be8c62 |
| 2019-02-26 | beta | v1.2.1 | 8661d8aecd626f7f57ccbcb735553edc05a2e713 | 3757390fa4b00d2d261bfdf5182d2e87c9113ff9 | 0a7dcf17eb5f2450480527d6ad1e201fb47f1e36 | 0c73eb70aa4d30f450273cb424be8c62 |
| 2019-01-29 | beta | v1.1.8 | 985ccb6d14c6ce5ce74823a4d366df2438eac44f | 7112b72cc229e05d36716c3d7739885d3ffa72e6 | ec86471ccc47a62df8b4009e1fb37c66ff9dc91b | 317d4c7e607b1fd7d682c0010aadf1d0 |
| 2018-12-04 | stable | v1.0.0 | 5391447fae6209bb21a89e6a5a6583cac1af9b4b | 7375a0f414bde4bc941e623482221db2fc8c4ab5 | f9ebf2129732fd2b606286fdf58e500384b8a0bc | 8343f188ada07642f47c56e518f1307c |
| 2018-12-04 | beta | v1.0.0 | 5391447fae6209bb21a89e6a5a6583cac1af9b4b | 7375a0f414bde4bc941e623482221db2fc8c4ab5 | f9ebf2129732fd2b606286fdf58e500384b8a0bc | 8343f188ada07642f47c56e518f1307c |
| 2018-11-30 | beta | v0.11.13 | 58c8489fcdb4e4ef6c010117584c9b23d15221aa | 7375a0f414bde4bc941e623482221db2fc8c4ab5 | f9ebf2129732fd2b606286fdf58e500384b8a0bc | 8343f188ada07642f47c56e518f1307c |
| 2018-11-29 | beta | v0.11.12 | 06ec8d3b41beb469d845626e36a246ee09300fa7 | 72c7a7567228cdaf8b7aa4a9e3d212ef9d4cc0ed | f9ebf2129732fd2b606286fdf58e500384b8a0bc | 8343f188ada07642f47c56e518f1307c |
| 2018-11-28 | beta | v0.11.11 | e7680128afbbde443d69f89bb264015276a8475a | be973ea196127383f356d39be466e2f3bd163083 | f9ebf2129732fd2b606286fdf58e500384b8a0bc | 8343f188ada07642f47c56e518f1307c |
| 2018-11-27 | beta | v0.11.10 | c27c4a265e9ad295e5d434cddabbc639b2e3542d | eebc6a58958587203f624528ff46b1d4b2b0f2fa | f9ebf2129732fd2b606286fdf58e500384b8a0bc | 8343f188ada07642f47c56e518f1307c |
| 2018-11-21 | beta | v0.11.9 | d48e6e433cc5ca67b24b19f70aaa197e84ba63c1 | 5c8147450db52b81232c138b9f9a65a8f9c61862 | f9ebf2129732fd2b606286fdf58e500384b8a0bc | 8343f188ada07642f47c56e518f1307c |
| 2018-11-20 | beta | v0.11.8 | f5b02e3c05ed1ab31e890add84fb56e35de2d392 | 1baf081343530dbaa8bec378fe1ce26b4897c23f | f9ebf2129732fd2b606286fdf58e500384b8a0bc | 8343f188ada07642f47c56e518f1307c |
| 2018-11-19 | beta | v0.11.7 | 7a005e1dcda665ace7241a24e79fae1a71f17b18 | 2e06da3df9cb370795f49747fdfd295b8168c133 | f9ebf2129732fd2b606286fdf58e500384b8a0bc | 8343f188ada07642f47c56e518f1307c |
| 2018-11-13 | beta | v0.11.3 | 72bf075e8d6961d2ca6df462b2228954f8d0e73a | 5646e86a6f442dc6f4158ae7010ab13d72a0b356 | 9c07fb64c48adb3d6fde50bab6b8b641c5b67683 | d124ce50a30741a188e41c52c424c127 |
| 2018-11-06 | beta | v0.10.2 | d8cbb80206db06d151206f8b599b7dde5a386a2d | 6c2ade9fa2b555899530a31cc8cbd1dff3bf5eea | bf26f760b1bb3d5fea6bda110f6a17b590364120 | 46b2bfb57b5647c5f7527ff9aa56c69b |
| 2018-10-09 | beta | v0.9.4 | f37c235c32fc15babe6dc7b7bc2ee4387e5ecf92 | 74625aed323d04f2add0410e84038d250f51b616 | a2eb050044eec93f0844667b8b6132e858467e4e | a135b1a4c6790a272609c9405379bc63 |
| 2018-09-18 | beta | v0.8.2 | 5ab9e70727d858def3a586db7fb98ee580352957 | 58a1894a1cd798de2f9a206f157a90d45944028b | 760a9690c22ec3f3d163173737f9949f97e6e02a | 1b444eb4796616ea2f955f3f1e440801 |
| 2018-09-05 | beta | v0.7.3 | 3b309bda072a6b326e8aa4591a5836af600923ce | af42b6dc95bd9f719e43c4e9f29a00640f0f0bba | ccb16f72824374163562364bf19dd18e8a882fab | d0cf500478165d79bdefccb0847ffb33 |
| 2018-08-28 | beta | v0.6.0 | 9299c02cf708497d6f72edda8efae0bb8340660e | e3687f70c7ece72000b32ee1b3c02755ba5361ac | be6309690fd60284a87f3258a740c7c30efb1092 | 35224090f45cbae1402bafd97a112a40 |
| 2018-06-19 | beta | v0.5.1 | c7ea3ca377e909469c68f2ab878a5bc53d3cf66b | 1ed25ca7b7e3e3e8047df050bba4174074c9b336 | f981f097602ca434ce0a36b1f704723cad105fb6 | 04cb98b58e7d69109004454c20b492f7 |
| 2018-05-22 | beta | v0.4.4 | f9bb4289e9fd861d70ae78bcc3a042ef1b35cc9d | 06afdfe54ebef9168a90ca00a6721c2d36e6aafa | 46ab040e589adc5200370dec7952ce5150850822 | 1b155eedbb3a2640a88d2e54d2f2d204 |
| 2018-05-07 | beta | v0.3.2 | 44b7e7d3f42f050a79712daab253af06e9daf530 | 09d05a38912a3c1a906e95099cac9a7e14fae85f | fe606f890b0a311da802c78b0af414a3c2087a79 | 39646f79e9336fb65ac68c8568544c92 |
| 2018-04-24 | beta | v0.3.1 | 12bbaba9ae044d0ea77da4dd5e4db15eed403f09 | 09d05a38912a3c1a906e95099cac9a7e14fae85f | fe606f890b0a311da802c78b0af414a3c2087a79 | 39646f79e9336fb65ac68c8568544c92 |
| 2018-04-09 | beta | v0.2.8 | b397406561f5e7a9c94e28f58d9e49fca0dd58b7 | c903c217a1a8206cdebdab1703b52ec6180edf37 | 52afcba357ad398e8c24f3e3363ac6ff5293df63 | d72bf5003e5924b61a7943f58e7b6814 |
| 2018-04-02 | beta | v0.2.3 | 5a58b36e36b8d7aace89d3950e6deb307956a6a0 | e61bb9ac3a3fd789754e2e54220bcfc27076a857 | 290c576264faa096a0b3206c71b2435309d9f904 | 0d015018f02a6de0c92ac1ac59191b55 |
| 2018-03-15 | beta | v0.1.5 | 3ea4d06340a97a1e9d7cae97567c64e0569dcaa2 | ead227f118077d1f2b57842a32abaf105b573b8a | 0b4f01f7593c8c42a77dc27d1fc234c95eacc88e | 9bc066b6e8ef5a9f7224c2926c6ad2f4 |

`dev` channel not included for brevity (also, it was [announced to shut down in late 2021](https://medium.com/flutter/whats-new-in-flutter-2-8-d085b763d181#34c4)).
See `list_versions.ipynb` for generation of this table.
