def make_type_data(is_precompiled, is_product):
    not_in_precompiled = lambda x: [] if is_precompiled else [x]
    not_in_product = lambda x: [] if is_product else [x]

    FIELDS = {
        # The root type (not raw object -- defined in separate header)
        'ObjectStore': [
            ['Class', 'object_class', None],
            ['Type', 'object_type', None],
            ['Class', 'null_class', None],
            ['Type', 'null_type', None],
            ['Type', 'function_type', None],
            ['Type', 'type_type', None],
            ['Class', 'closure_class', None],
            ['Type', 'number_type', None],
            ['Type', 'int_type', None],
            ['Class', 'integer_implementation_class', None],
            ['Type', 'int64_type', None],
            ['Class', 'smi_class', None],
            ['Type', 'smi_type', None],
            ['Class', 'mint_class', None],
            ['Type', 'mint_type', None],
            ['Class', 'double_class', None],
            ['Type', 'double_type', None],
            ['Type', 'float32x4_type', None],
            ['Type', 'int32x4_type', None],
            ['Type', 'float64x2_type', None],
            ['Type', 'string_type', None],
            ['TypeArguments', 'type_argument_int', None],
            ['TypeArguments', 'type_argument_double', None],
            ['TypeArguments', 'type_argument_string', None],
            ['TypeArguments', 'type_argument_string_dynamic', None],
            ['TypeArguments', 'type_argument_string_string', None],
            ['Class', 'compiletime_error_class', None],
            ['Class', 'pragma_class', None],
            ['Field', 'pragma_name', None],
            ['Field', 'pragma_options', None],
            ['Class', 'future_class', None],
            ['Class', 'completer_class', None],
            ['Class', 'symbol_class', None],
            ['Class', 'one_byte_string_class', None],
            ['Class', 'two_byte_string_class', None],
            ['Class', 'external_one_byte_string_class', None],
            ['Class', 'external_two_byte_string_class', None],
            ['Type', 'bool_type', None],
            ['Class', 'bool_class', None],
            ['Class', 'array_class', None],
            ['Type', 'array_type', None],
            ['Class', 'immutable_array_class', None],
            ['Class', 'growable_object_array_class', None],
            ['Class', 'linked_hash_map_class', None],
            ['Class', 'linked_hash_set_class', None],
            ['Class', 'float32x4_class', None],
            ['Class', 'int32x4_class', None],
            ['Class', 'float64x2_class', None],
            ['Class', 'error_class', None],
            ['Class', 'weak_property_class', None],
            ['Array', 'symbol_table', None],
            ['Array', 'canonical_types', None],
            ['Array', 'canonical_type_arguments', None],
            ['Library', 'async_library', None],
            ['Library', 'builtin_library', None],
            ['Library', 'core_library', None],
            ['Library', 'collection_library', None],
            ['Library', 'convert_library', None],
            ['Library', 'developer_library', None],
            ['Library', 'ffi_library', None],
            ['Library', '_internal_library', None],
            ['Library', 'isolate_library', None],
            ['Library', 'math_library', None],
            ['Library', 'mirrors_library', None],
            ['Library', 'native_wrappers_library', None],
            ['Library', 'profiler_library', None],
            ['Library', 'root_library', None],
            ['Library', 'typed_data_library', None],
            ['Library', '_vmservice_library', None],
            ['GrowableObjectArray', 'libraries', None],
            ['Array', 'libraries_map', None],
            ['GrowableObjectArray', 'closure_functions', None],
            ['GrowableObjectArray', 'pending_classes', None],
            ['GrowableObjectArray', 'pending_unevaluated_const_fields', None],
            ['GrowableObjectArray', 'pending_deferred_loads', None],
            ['GrowableObjectArray', 'resume_capabilities', None],
            ['GrowableObjectArray', 'exit_listeners', None],
            ['GrowableObjectArray', 'error_listeners', None],
            ['Instance', 'stack_overflow', None],
            ['Instance', 'out_of_memory', None],
            ['UnhandledException', 'preallocated_unhandled_exception', None],
            ['StackTrace', 'preallocated_stack_trace', None],
            ['Function', 'lookup_port_handler', None],
            ['Function', 'handle_message_function', None],
            ['Function', 'growable_list_factory', None],
            ['Function', 'simple_instance_of_function', None],
            ['Function', 'simple_instance_of_true_function', None],
            ['Function', 'simple_instance_of_false_function', None],
            ['Function', 'async_clear_thread_stack_trace', None],
            ['Function', 'async_set_thread_stack_trace', None],
            ['Function', 'async_star_move_next_helper', None],
            ['Function', 'complete_on_async_return', None],
            ['Class', 'async_star_stream_controller', None],
            ['ObjectPool', 'global_object_pool', None],
            ['Array', 'library_load_error_table', None],
            ['Array', 'unique_dynamic_targets', None],
            ['GrowableObjectArray', 'megamorphic_cache_table', None],
            ['Code', 'build_method_extractor_code', None],
            ['Code', 'null_error_stub_with_fpu_regs_stub', None],
            ['Code', 'null_error_stub_without_fpu_regs_stub', None],
            ['Code', 'stack_overflow_stub_with_fpu_regs_stub', None],
            ['Code', 'stack_overflow_stub_without_fpu_regs_stub', None],
            ['Code', 'write_barrier_wrappers_stub', None],
            ['Code', 'array_write_barrier_stub', None],
            ['Code', 'megamorphic_miss_code', None],
            ['Function', 'megamorphic_miss_function', None],
            ['Array', 'code_order_table', None],
            ['Array', 'obfuscation_map', None],
            ['GrowableObjectArray', 'changed_in_last_reload', None],
            ['Class', 'ffi_pointer_class', None],
            ['Class', 'ffi_native_type_class', None],
            ['Class', 'ffi_struct_class', None],
            ['Object', 'ffi_as_function_internal', None],
        ],
        
        # Manually parsed types:
        'Function': [
            ['String', 'name', None],
            ['Object', 'owner', 'Class or patch class or mixin class\n where this function is defined.'],
            ['AbstractType', 'result_type', None],
            ['Array', 'parameter_types', None],
            ['Array', 'parameter_names', None],
            ['TypeArguments', 'type_parameters', 'Array of TypeParameter.'],
            ['Object', 'data', 'Additional data specific to the function kind. See\n Function::set_data() for details.'],
        ],
        'Field': [
            ['String', 'name', None],
            ['Object', 'owner', 'Class or patch class or mixin class\n where this field is defined or original field.'],
            ['AbstractType', 'type', None],
            ['(RawInstance* static_value) Value for static fields | (RawSmi* offset) Offset in words for instance fields.', 'value', None],
            ['Function', 'initializer_function', 'Static initializer function.'],
            *not_in_precompiled(['Instance', 'saved_initial_value', 'Saved initial value - static fields.']),
            ['Smi', 'guarded_list_length', None],
            ['Array', 'dependent_code', None],
        ],
        'Code': [
            ['ObjectPool', 'object_pool', 'Accessed from generated code.'],
            # parsed differently: ['Instructions', 'instructions', 'Accessed from generated code.'],
            ['Object', 'owner', 'Function, Null, or a Class.'],
            ['ExceptionHandlers', 'exception_handlers', None],
            ['PcDescriptors', 'pc_descriptors', None],
            ['(RawTypedData* catch_entry_moves_maps) | (RawSmi* variables)', 'catch_entry', None],
            ['Array', 'stackmaps', None],
            ['Array', 'inlined_id_to_function', None],
            ['CodeSourceMap', 'code_source_map', None],
            # parsed differently: *not_in_precompiled(['Instructions', 'active_instructions', None]),
            *not_in_precompiled(['Array', 'deopt_info_array', None]),
            *not_in_precompiled(['Array', 'static_calls_target_table', '\n (code-offset, function, code) triples.']),
            *not_in_product(['Object', 'return_address_metadata', '\n If return_address_metadata_ is a Smi, it is the offset to the prologue.\n Else, return_address_metadata_ is null.']),
            # not in snapshot: *not_in_product(['LocalVarDescriptors', 'var_descriptors', None]),
            # not in snapshot: *not_in_product(['Array', 'comments', None]),
        ],
        'Bytecode': [
            ['ObjectPool', 'object_pool', None],
            ['Function', 'function', None],
            ['Array', 'closures', None],
            ['ExceptionHandlers', 'exception_handlers', None],
            ['PcDescriptors', 'pc_descriptors', None],
            *not_in_product(['LocalVarDescriptors', 'var_descriptors', None]),
        ],
        'ICData': [
            ['Array', 'entries', 'Contains class-ids, target and count.'],
            ['String', 'target_name', 'Name of target function.'],
            ['Array', 'args_descriptor', 'Arguments descriptor.'],
            *not_in_precompiled(['AbstractType', 'receivers_static_type', 'Static type of the receiver, if instance call and available.']),
            ['Object', 'owner', 'Parent/calling function or original IC of cloned IC.'],
        ],
        'TypedDataView': [
            ['Smi', 'length', None],
            ['TypedDataBase', 'typed_data', None],
            ['Smi', 'offset_in_bytes', None],
        ],
        'ExternalTypedData': [
            ['Smi', 'length', None],
        ],
        'RegExp': [
            ['Smi', 'num_bracket_expressions', None],
            ['Array', 'capture_name_map', None],
            ['String', 'pattern', 'Pattern to be used for matching.'],
            ['(RawFunction* function) | (RawTypedData* bytecode)', 'one_byte', None],
            ['(RawFunction* function) | (RawTypedData* bytecode)', 'two_byte', None],
            ['Function', 'external_one_byte_function', None],
            ['Function', 'external_two_byte_function', None],
            ['(RawFunction* function) | (RawTypedData* bytecode)', 'one_byte_sticky', None],
            ['(RawFunction* function) | (RawTypedData* bytecode)', 'two_byte_sticky', None],
            ['Function', 'external_one_byte_sticky_function', None],
            ['Function', 'external_two_byte_sticky_function', None],
        ],
        'Type': [
            ['Code', 'type_test_stub', None],
            ['Smi', 'type_class_id', None],
            ['TypeArguments', 'arguments', None],
            ['Smi', 'hash', None],
            ['Function', 'signature', 'If not null, this type is a function type.'],
        ],

        # Variable-length types that were not defined here:
        #  LocalVarDescriptors
        #  Context
        #  TypeArguments
        #  TypedData
        #  Array

        # Automatically parsed types:
        'Class': [
            ['String', 'name', None],
            ['String', 'user_name', None],
            ['Array', 'functions', None],
            ['Array', 'functions_hash_table', None],
            ['Array', 'fields', None],
            ['Array', 'offset_in_words_to_field', None],
            ['Array', 'interfaces', 'Array of AbstractType.'],
            ['Script', 'script', None],
            ['Library', 'library', None],
            ['TypeArguments', 'type_parameters', 'Array of TypeParameter.'],
            ['AbstractType', 'super_type', None],
            ['Function', 'signature_function', 'Associated function for typedef class.'],
            ['Array', 'constants', 'Canonicalized const instances of this class.'],
            ['Type', 'declaration_type', 'Declaration type for this class.'],
            ['Array', 'invocation_dispatcher_cache', 'Cache for dispatcher functions.'],
            ['Code', 'allocation_stub', 'Stub code for allocation of instances.'],
            ['GrowableObjectArray', 'direct_implementors', 'Array of Class.'],
            ['GrowableObjectArray', 'direct_subclasses', 'Array of Class.'],
            ['Array', 'dependent_code', 'CHA optimized codes.'],
        ],
        'PatchClass': [
            ['Class', 'patched_class', None],
            ['Class', 'origin_class', None],
            ['Script', 'script', None],
            ['ExternalTypedData', 'library_kernel_data', None],
        ],
        'ClosureData': [
            ['ContextScope', 'context_scope', None],
            ['Function', 'parent_function', 'Enclosing function of this local function.'],
            ['Type', 'signature_type', None],
            ['Instance', 'closure', 'Closure object for static implicit closures.'],
        ],
        'SignatureData': [
            ['Function', 'parent_function', 'Enclosing function of this sig. function.'],
            ['Type', 'signature_type', None],
        ],
        'RedirectionData': [
            ['Type', 'type', None],
            ['String', 'identifier', None],
            ['Function', 'target', None],
        ],
        'FfiTrampolineData': [
            ['Type', 'signature_type', None],
            ['Function', 'c_signature', None],
            ['Function', 'callback_target', None],
            ['Instance', 'callback_exceptional_return', None],
        ],
        'Script': [
            ['String', 'url', None],
            ['String', 'resolved_url', None],
            ['Array', 'compile_time_constants', None],
            ['TypedData', 'line_starts', None],
            ['Array', 'debug_positions', None],
            ['Array', 'yield_positions', None],
            ['KernelProgramInfo', 'kernel_program_info', None],
            ['String', 'source', None],
        ],
        'Library': [
            ['String', 'name', None],
            ['String', 'url', None],
            ['String', 'private_key', None],
            ['Array', 'dictionary', 'Top-level names in this library.'],
            ['GrowableObjectArray', 'metadata', 'Metadata on classes, methods etc.'],
            ['Class', 'toplevel_class', 'Class containing top-level elements.'],
            ['GrowableObjectArray', 'owned_scripts', None],
            ['Array', 'imports', 'List of Namespaces imported without prefix.'],
            ['Array', 'exports', 'List of re-exported Namespaces.'],
            ['Instance', 'load_error', 'Error iff load_state_ == kLoadError.'],
            ['ExternalTypedData', 'kernel_data', None],
            ['Array', 'resolved_names', 'Cache of resolved names in library scope.'],
            ['Array', 'exported_names', 'Cache of exported names by library.'],
            ['Array', 'loaded_scripts', 'Array of scripts loaded in this library.'],
        ],
        'Namespace': [
            ['Library', 'library', 'library with name dictionary.'],
            ['Array', 'show_names', 'list of names that are exported.'],
            ['Array', 'hide_names', 'blacklist of names that are not exported.'],
            ['Field', 'metadata_field', 'remembers the token pos of metadata if any,\n and the metadata values if computed.\n'],
        ],
        'KernelProgramInfo': [
            ['TypedData', 'string_offsets', None],
            ['ExternalTypedData', 'string_data', None],
            ['TypedData', 'canonical_names', None],
            ['ExternalTypedData', 'metadata_payloads', None],
            ['ExternalTypedData', 'metadata_mappings', None],
            ['Array', 'scripts', None],
            ['Array', 'constants', None],
            ['Array', 'bytecode_component', None],
            ['GrowableObjectArray', 'potential_natives', None],
            ['GrowableObjectArray', 'potential_pragma_functions', None],
            ['ExternalTypedData', 'constants_table', None],
        ],
        'ExceptionHandlers': [
            ['Array', 'handled_types_data', None],
        ],
        'ParameterTypeCheck': [
            ['AbstractType', 'param', None],
            ['AbstractType', 'type_or_bound', None],
            ['String', 'name', None],
            ['SubtypeTestCache', 'cache', None],
        ],
        'SingleTargetCache': [
            ['Code', 'target', None],
        ],
        'UnlinkedCall': [
            ['String', 'target_name', None],
            ['Array', 'args_descriptor', None],
        ],
        'MegamorphicCache': [
            ['Array', 'buckets', None],
            ['Smi', 'mask', None],
            ['String', 'target_name', 'Name of target function.'],
            ['Array', 'args_descriptor', 'Arguments descriptor.'],
        ],
        'SubtypeTestCache': [
            ['Array', 'cache', None],
        ],
        'ApiError': [
            ['String', 'message', None],
        ],
        'LanguageError': [
            ['Error', 'previous_error', 'May be null.'],
            ['Script', 'script', None],
            ['String', 'message', None],
            ['String', 'formatted_message', "Incl. previous error's formatted message."],
        ],
        'UnhandledException': [
            ['Instance', 'exception', None],
            ['Instance', 'stacktrace', None],
        ],
        'UnwindError': [
            ['String', 'message', None],
        ],
        'LibraryPrefix': [
            ['String', 'name', 'Library prefix name.'],
            ['Library', 'importer', 'Library which declares this prefix.'],
            ['Array', 'imports', 'Libraries imported with this prefix.'],
            ['Array', 'dependent_code', 'Code that refers to deferred, unloaded\n library prefix.\n'],
        ],
        'TypeRef': [
            ['Code', 'type_test_stub', None],
            ['AbstractType', 'type', 'The referenced type.'],
        ],
        'TypeParameter': [
            ['Code', 'type_test_stub', None],
            ['String', 'name', None],
            ['Smi', 'hash', None],
            ['AbstractType', 'bound', 'ObjectType if no explicit bound specified.'],
            ['Function', 'parameterized_function', None],
        ],
        'Closure': [
            ['TypeArguments', 'instantiator_type_arguments', None],
            ['TypeArguments', 'function_type_arguments', None],
            ['TypeArguments', 'delayed_type_arguments', None],
            ['Function', 'function', None],
            ['Context', 'context', None],
            ['Smi', 'hash', None],
        ],
        'GrowableObjectArray': [
            ['TypeArguments', 'type_arguments', None],
            ['Smi', 'length', None],
            ['Array', 'data', None],
        ],
        'LinkedHashMap': [
            ['TypeArguments', 'type_arguments', None],
            ['TypedData', 'index', None],
            ['Smi', 'hash_mask', None],
            ['Array', 'data', None],
            ['Smi', 'used_data', None],
            ['Smi', 'deleted_keys', None],
        ],
        'Pointer': [
            ['TypeArguments', 'type_arguments', None],
            ['Integer', 'c_memory_address', None],
        ],
        'ReceivePort': [
            ['SendPort', 'send_port', None],
            ['Instance', 'handler', None],
        ],
        'StackTrace': [
            ['StackTrace', 'async_link', 'Link to parent async stack trace.'],
            ['Array', 'code_array', 'Code object for each frame in the stack trace.'],
            ['Array', 'pc_offset_array', 'Offset of PC for each frame.'],
        ],
        'WeakProperty': [
            ['Object', 'key', None],
            ['Object', 'value', None],
        ],
        'MirrorReference': [
            ['Object', 'referent', None],
        ],
        'UserTag': [
            ['String', 'label', None],
        ],
    }

    # Meanings:
    #  <not present> -> to_snapshot() defined, always returns last field
    #  True: to_snapshot() defined, returns last field for the three valid values
    #  False: to_snapshot() not defined, at least on that class
    #  (a,b,c): fields returned by to_snapshot() for kFull, kFullJIT, kFullAOT
    MAPPINGS = {
        'ObjectStore': ('library_load_error_table', 'megamorphic_miss_function', 'megamorphic_miss_function'),
        
        'Function': True,
        'Field': ('guarded_list_length', 'dependent_code', 'initializer_function'),
        'Code': False,
        'ICData': ('owner', 'owner', 'args_descriptor'),
        'TypeArguments': False,
        'String': False,
        'RawExternalTypedData': False,

        # Automatically parsed types:
        'Class': ('direct_subclasses', 'dependent_code', 'allocation_stub'),
        'PatchClass': ('library_kernel_data', 'library_kernel_data', 'script'),
        'ClosureData': False,
        'Script': ('kernel_program_info', 'kernel_program_info', 'url'),
        'Library': ('kernel_data', 'kernel_data', 'load_error'),
        'ExceptionHandlers': False,
        'SingleTargetCache': False,
        'SubtypeTestCache': False,
        'ApiError': False,
        'UnwindError': False,
        'LibraryPrefix': ('imports', 'imports', 'importer'),
        'LinkedHashMap': False,
        'Pointer': False,
        'ReceivePort': False,
        'MirrorReference': False,
        'UserTag': False,
    }
    
    return FIELDS, MAPPINGS
