[![Build Status](https://goatly.visualstudio.com/LIFTI/_apis/build/status/mikegoatly.lifti?branchName=master)](https://goatly.visualstudio.com/LIFTI/_build/latest?definitionId=14&branchName=master)

<img src="docs/static/images/lifti.svg" width="40" style="float:right">

# LIFTI

A lightweight full text indexer for .NET

Key features:

* [📃 Indexing loose text](https://mikegoatly.github.io/lifti/docs/getting-started/)
* [💼 Indexing object properties](https://mikegoatly.github.io/lifti/docs/getting-started/indexing-objects/)
* [🔎 Powerful query language](https://mikegoatly.github.io/lifti/docs/searching/lifti-query-syntax/)
* [📚 Thesaurus](https://mikegoatly.github.io/lifti/docs/index-construction/withdefaultthesaurus/)
* [🗄️ Compact binary serialized format](https://mikegoatly.github.io/lifti/docs/serialization/)

## Getting started

[📖 Read the documentation](https://mikegoatly.github.io/lifti/docs) - there's lots of useful information and examples there, along with some [getting started guides](https://mikegoatly.github.io/lifti/docs/getting-started/).

[🧑‍💻 Check out some sample code](https://github.com/mikegoatly/lifti/tree/master/samples/TestConsole) - the repo contains examples that can be run as a console application.

[🤹‍♀️ Use LIFTI in a Blazor app](https://mikegoatly.github.io/lifti/blazor-sample) - try out various queries against Wikipedia content

## Support

If you find LIFTI useful, why not buy me a coffee to power the development work?

[![buymeacoffee](https://user-images.githubusercontent.com/4577868/176899270-00846262-8323-4f13-9c6a-d655a30cbca3.png)](https://www.buymeacoffee.com/mikegoatly)

## Contribute

It would be great to have more people contributing to LIFTI - how can you help?

* Create issues for bugs you find - **level 1**
* Create feature suggestions - **level 2**
* Create pull requests for documentation changes - **level 3**
* Create pull requests for bug fixes or features - **boss level**

### Documentation contributions

1. Install [hugo-extended](https://gohugo.io/installation/), e.g. by using `winget install Hugo.Hugo.Extended` on Windows.
1. Fork the LIFTI repo and clone your fork locally
1. Initialize the docsy theme git submodule using `git submodule update --recursive --init`
1. Edit the documentation
1. Test the site locally by running `hugo server` from the `docs` folder
1. Create a pull request for your changes
