# Living
[![DOTNET](https://img.shields.io/badge/dynamic/xml?url=https://raw.githubusercontent.com/migueloliveiradev/living/main/Living.WebAPI/Living.WebAPI.csproj&query=//Project/PropertyGroup/TargetFramework&style=for-the-badge&label=DOTNET%20VERSION&logo=dotnet&logoSize=auto&logoColor=blue)](#)
[![TOTAL DE TESTES](https://img.shields.io/badge/dynamic/json?url=https://raw.githubusercontent.com/migueloliveiradev/living/badges/badges.json&query=%24.testsTotal&label=TOTAL%20DE%20TESTES&style=for-the-badge)](#)
[![COBERTURA DE CODIGO](https://img.shields.io/badge/dynamic/json?url=https://raw.githubusercontent.com/migueloliveiradev/living/badges/badges.json&query=%24.coverageLines&label=COBERTURA%20DE%20CODIGO&style=for-the-badge)](#)

[![NUXT JS](https://img.shields.io/badge/dynamic/json?url=https%3A%2F%2Fraw.githubusercontent.com%2Fmigueloliveiradev%2Fliving%2Fmain%2FLiving.WebAPP%2Fpackage.json&query=%24.devDependencies.nuxt&label=NUXT%20JS&style=for-the-badge&logo=nuxtdotjs)](#)
[![Vue Js](https://img.shields.io/badge/dynamic/json?url=https%3A%2F%2Fraw.githubusercontent.com%2Fmigueloliveiradev%2Fliving%2Fmain%2FLiving.WebAPP%2Fpackage.json&query=%24.devDependencies.vue&label=VUE%20JS&style=for-the-badge&logo=vuedotjs)](#)

[![wakatime](https://wakatime.com/badge/user/4ea4d323-1f7a-46e1-a08e-2080b1b95450/project/2d30b516-80de-4f2a-9840-412dc68667ac.svg?style=for-the-badge)](https://wakatime.com/@eimigueloliveir)

Uma rede social para você compartilhar e salvar suas memórias, seus interesses, suas ideias e dividir com seus amigos

## Tecnologias Utilizadas 
- Back End
  - WebAPI
    - [ASP.NET Core 8](https://learn.microsoft.com/pt-br/aspnet/core/)
    - [ASP.NET Core Identity](https://learn.microsoft.com/pt-br/aspnet/core/security/authentication/identity)
    - [MediatR](https://github.com/jbogard/MediatR)
    - [.NET Core Native DI](https://learn.microsoft.com/en-us/dotnet/core/extensions/dependency-injection)
  - Persistência
    - [Entity Framework Core 8](https://learn.microsoft.com/pt-br/ef/core/)
    - [PostgreSQL](https://www.postgresql.org/)
  - Documentação
    - [Swagger UI](https://github.com/domaindrivendev/Swashbuckle.AspNetCore)
  - Testes
    - [xUnit](https://learn.microsoft.com/pt-br/dotnet/core/testing/unit-testing-with-dotnet-test)
    - [Testcontainers](https://testcontainers.com/)
    - [AutoFixture](https://github.com/AutoFixture/AutoFixture/)
    - [FluentAssertions](https://github.com/fluentassertions/fluentassertions/)
    - [TestServer](https://learn.microsoft.com/en-us/aspnet/core/test/integration-tests?view=aspnetcore-8.0)
    - [Coverlet](https://github.com/coverlet-coverage/coverlet)
- Front End
  - Linguagem
    - [Node.Js](https://nodejs.org/pt)
    - [TypeScript](https://www.typescriptlang.org/)
  - Frameworks
    - [Vue.Js 3](https://vuejs.org/)
    - [Nuxt 3](https://nuxt.com/)
  - UI
    - [PrimeVue](https://primevue.org/)
    - [PrimeFlex](https://primeflex.org/)
    - [PrimeIcons](https://primevue.org/icons)
  - Desenvolvimento
    - [ESLint](https://eslint.nuxt.com/)
    - [OpenAPI TypeScript](https://openapi-ts.dev/)

## Design Patterns
  - CQRS
  - Unit Of Work
  - Repository & Generic Repository
  - Dependency injection
  - ORM
  - Mediator

# Contribuidores 
<a href="https://github.com/eimigueloliveir/living/graphs/contributors">
  <img src="https://contrib.rocks/image?repo=eimigueloliveir/living" />
</a>
