//
//  Copyright (c) Microsoft Corporation. All rights reserved.
//  Licensed under the MIT License. See License.txt in the project root for license information.
//
namespace Microsoft.VisualStudio.Text.Formatting
{
    using System.Collections.Generic;

    /// <summary>
    /// Represents a list of <see cref="ISequenceElement"/> objects generated by the <see cref="ITextAndAdornmentSequencer"/>.
    /// </summary>
    public interface ITextAndAdornmentCollection : IList<ISequenceElement>
    {
        /// <summary>
        /// Gets the <see cref="ITextAndAdornmentSequencer"/> that generated the collection.
        /// </summary>
        ITextAndAdornmentSequencer Sequencer { get; }
    }
}