﻿namespace Microsoft.VisualStudio.Language.Intellisense
{
    using System;
    using Microsoft.VisualStudio.Text;
    using Microsoft.VisualStudio.Text.Adornments;

    /// <summary>
    /// The result generated by an <see cref="IAsyncQuickInfoSource"/>.
    /// </summary>
    public sealed class QuickInfoItem
    {
        /// <summary>
        /// Constructs a new instance of <see cref="QuickInfoItem"/>.
        /// </summary>
        /// <exception cref="ArgumentNullException">Thrown if item is null.</exception>
        /// <param name="applicableToSpan">The span to which <paramref name="item"/> is applicable.</param>
        /// <param name="item">The Quick Info item.</param>
        public QuickInfoItem(ITrackingSpan applicableToSpan, object item)
        {
            this.ApplicableToSpan = applicableToSpan;
            this.Item = item ?? throw new ArgumentNullException(nameof(item));
        }

        /// <summary>
        /// The <see cref="ITrackingSpan"/> to which <see cref="Item"/> is applicable.
        /// </summary>
        /// <remarks>
        /// This parameter can be null.
        /// </remarks>
        public ITrackingSpan ApplicableToSpan { get; }

        /// <summary>
        /// The item to be displayed in the Quick Info <see cref="IToolTipPresenter"/>.
        /// </summary>
        public object Item { get; }
    }
}
