// Autogenerated C header file for Indexed screen
#ifndef _JACDAC_SPEC_INDEXED_SCREEN_H
#define _JACDAC_SPEC_INDEXED_SCREEN_H 1

#define JD_SERVICE_CLASS_INDEXED_SCREEN  0x16fa36e5

/**
 * Sets the update window for subsequent `set_pixels` commands.
 */
#define JD_INDEXED_SCREEN_CMD_START_UPDATE 0x81
typedef struct jd_indexed_screen_start_update {
    uint16_t x; // px
    uint16_t y; // px
    uint16_t width; // px
    uint16_t height; // px
} jd_indexed_screen_start_update_t;


/**
 * Argument: pixels bytes. Set pixels in current window, according to current palette.
 * Each "line" of data is aligned to a byte.
 */
#define JD_INDEXED_SCREEN_CMD_SET_PIXELS 0x83

/**
 * Read-write ratio u0.8 (uint8_t). Set backlight brightness.
 * If set to `0` the display may go to sleep.
 */
#define JD_INDEXED_SCREEN_REG_BRIGHTNESS JD_REG_INTENSITY

/**
 * The current palette.
 * The color entry repeats `1 << bits_per_pixel` times.
 * This register may be write-only.
 */
#define JD_INDEXED_SCREEN_REG_PALETTE 0x80
typedef struct jd_indexed_screen_palette {
    uint8_t blue;
    uint8_t green;
    uint8_t red;
    uint8_t padding;
} jd_indexed_screen_palette_t;


/**
 * Constant bit uint8_t. Determines the number of palette entries.
 * Typical values are 1, 2, 4, or 8.
 */
#define JD_INDEXED_SCREEN_REG_BITS_PER_PIXEL 0x180

/**
 * Constant px uint16_t. Screen width in "natural" orientation.
 */
#define JD_INDEXED_SCREEN_REG_WIDTH 0x181

/**
 * Constant px uint16_t. Screen height in "natural" orientation.
 */
#define JD_INDEXED_SCREEN_REG_HEIGHT 0x182

/**
 * Read-write bool (uint8_t). If true, consecutive pixels in the "width" direction are sent next to each other (this is typical for graphics cards).
 * If false, consecutive pixels in the "height" direction are sent next to each other.
 * For embedded screen controllers, this is typically true iff `width < height`
 * (in other words, it's only true for portrait orientation screens).
 * Some controllers may allow the user to change this (though the refresh order may not be optimal then).
 * This is independent of the `rotation` register.
 */
#define JD_INDEXED_SCREEN_REG_WIDTH_MAJOR 0x81

/**
 * Read-write px uint8_t. Every pixel sent over wire is represented by `up_sampling x up_sampling` square of physical pixels.
 * Some displays may allow changing this (which will also result in changes to `width` and `height`).
 * Typical values are 1 and 2.
 */
#define JD_INDEXED_SCREEN_REG_UP_SAMPLING 0x82

/**
 * Read-write ° uint16_t. Possible values are 0, 90, 180 and 270 only.
 * Write to this register do not affect `width` and `height` registers,
 * and may be ignored by some screens.
 */
#define JD_INDEXED_SCREEN_REG_ROTATION 0x83

#endif
