// Autogenerated C header file for Arcade Gamepad
#ifndef _JACDAC_SPEC_ARCADE_GAMEPAD_H
#define _JACDAC_SPEC_ARCADE_GAMEPAD_H 1

#define JD_SERVICE_CLASS_ARCADE_GAMEPAD  0x1deaa06e

// enum Button (uint8_t)
#define JD_ARCADE_GAMEPAD_BUTTON_LEFT 0x1
#define JD_ARCADE_GAMEPAD_BUTTON_UP 0x2
#define JD_ARCADE_GAMEPAD_BUTTON_RIGHT 0x3
#define JD_ARCADE_GAMEPAD_BUTTON_DOWN 0x4
#define JD_ARCADE_GAMEPAD_BUTTON_A 0x5
#define JD_ARCADE_GAMEPAD_BUTTON_B 0x6
#define JD_ARCADE_GAMEPAD_BUTTON_MENU 0x7
#define JD_ARCADE_GAMEPAD_BUTTON_SELECT 0x8
#define JD_ARCADE_GAMEPAD_BUTTON_RESET 0x9
#define JD_ARCADE_GAMEPAD_BUTTON_EXIT 0xa

/**
 * Indicates which buttons are currently active (pressed).
 * `pressure` should be `0xff` for digital buttons, and proportional for analog ones.
 */
#define JD_ARCADE_GAMEPAD_REG_BUTTONS JD_REG_READING
typedef struct jd_arcade_gamepad_buttons {
    uint8_t button;  // Button
    uint8_t pressure;  // ratio u0.8
} jd_arcade_gamepad_buttons_t;


/**
 * Constant. Indicates number of players supported and which buttons are present on the controller.
 */
#define JD_ARCADE_GAMEPAD_REG_AVAILABLE_BUTTONS 0x180
typedef struct jd_arcade_gamepad_available_buttons {
    uint8_t button[0];  // Button
} jd_arcade_gamepad_available_buttons_t;


/**
 * Argument: button Button (uint8_t). Emitted when button goes from inactive to active.
 */
#define JD_ARCADE_GAMEPAD_EV_DOWN JD_EV_ACTIVE

/**
 * Argument: button Button (uint8_t). Emitted when button goes from active to inactive.
 */
#define JD_ARCADE_GAMEPAD_EV_UP JD_EV_INACTIVE

#endif
