# Introduction

From our previous lesson, we learned that computer programs process information. Some of the information that is input, stored, and used in a computer program has a value that is **constant**, meaning it does not change throughout the course of the program. An example of a constant in math is “pi” because “pi” has one value that never changes (it is 3.14). Other pieces of information have values that vary or change during the running of a program. Programmers create **variables** to hold the value of information that may change. In a game program, a variable may be created to hold the player’s current score, since that value would change (hopefully!) during the course of the game.

Try and think of some pieces of information from your daily life that are constants and others that are variables.

* What pieces of information have values that don’t change during the course of a single day (i.e., are constants)?
* What pieces of information have values that do change during the course of a single day (i.e., are variables)?

## Examples 

In one school day...

* Constants: The day of the week, the year, your name, your school’s address, your birthday
* Variables: The temperature/weather, the current time, the current class, whether you are standing or sitting…

Variables hold a specific type of information. The micro:bit’s variables can keep track of **numbers, strings, Booleans, sprites,** and **arrays**. The first time you use a variable, its type is assigned to match whatever it is holding. From that point forward, you can only change the value of that variable to another value of that same type.

* A **number** variable could hold numerical data such as the year, the temperature, or the degree of acceleration.
* A **string** variable holds a string of alphanumeric characters such as a person’s name, a password, or the day of the week.
* A **Boolean** variable has only two values: true or false. For example, you might have certain things that happen only when the variable called GameOver is false.
* A **sprite** is a special variable that represents a single dot on the screen and holds two separate values for the row and column the dot is currently in.
* An **array** is another special type of variable that holds a list of multiple items.