## Unplugged: Infection Simulation

For this activity, each student will need a micro:bit and battery pack, as well as the teacher who will be the Master controller.
 
There are four parts to this unplugged activity:
* Setup: Set up the code on all micro:bits
* Explore: Let students experience the game first
* Discuss: Talk about observations, theories, propose strategies
* Test: Play again, testing different strategies and approaches for containing outbreak
 
The goals of this activity are:
* Develop a common working vocabulary for talking about disease spread
* Make inferences based on observation
* Propose and test original hypotheses to explain complex behavior
* Explore a professionally developed micro:bit simulation
 

![Biohazard symbol](/static/courses/csintro/radio/biohazard.png)

## Setup
This site is the home page for the Infection game: [Infection](/projects/infection).
 
On that page you should be able to copy the JavaScript code, then go to your MakeCode JavaScript editor and paste the JavaScript code into the window.
 
Then click the Download button to download this program onto your micro:bit. This code should be downloaded onto all of your students’ micro:bits as well as your own.
 
This activity works best in an open area. If it’s possible to go outside, that works even better! To set up the game, the teacher should press the A + B buttons on his or her device. This will register all of the student devices and establish the teacher’s micro:bit as the Master device.
 
## Explore
In this phase, students should just play the game to get a feel for how it works. The object of the game is to meet as many people as possible without getting sick. If at any time players decide to stop meeting people, they should sit down and cover their micro:bit. 
 
To start the game, students should take their devices and spread out. When everyone is ready to begin, the teacher should press the A + B buttons again. All of the student devices will show a unique player icon.
 
One of the players is randomly chosen to have a virus that is transmitted when they meet other players. Players can meet each other by going up to another player and placing the two devices next to each other. Players who are healthy, or who are infected but are not showing symptoms yet, will have a smile. Once a player is sick, their micro:bit will display a frowny face.
 
After a certain period of time being sick, the player dies and the micro:bit will display a skull icon. That player should sit down and wait for the game to end, when all players are dead or the virus stops spreading.
 
## Discuss
After one round, it is good to have a discussion with the players:
* Did anyone manage to stay healthy? If so, how? If not, why not?
* How do you think the disease spread?
* Who do you think started it?
* What could we do to find out?
* What strategies might we adopt next time, to have a better outcome?
 
## Test
Play the game one more time, or more depending on available time, and attempt to test some of the theories students came up with. 
* What strategies worked well? 
* Which strategies seemed like a good idea at the time, but in practice, were less effective? Why? 
* Are there any real-world situations that this might remind you of?
 
## Vocabulary
As students talk through their theories, they will often talk about a scientific idea without knowing the specific word for it. This presents a nice opportunity, once students have surfaced an idea, to give it a proper name so that you can start to develop a common working vocabulary for talking about the problem. 
 
Here are some common terms that come up in discussion:
* Asymptomatic: Someone who has the virus but is not showing outward symptoms of being sick.
* Carrier: Someone who has the virus and can transmit it to others.
* Immunity: Someone who cannot contract or transmit the virus.
* Incubation: The period of time between when a person contracts the virus and when the person starts to show symptoms of being sick.
* Inoculation: Make someone immune to the virus.
* Patient Zero: The first person to introduce a virus to a community.
* Quarantine: A strategy to isolate those who are suspected of carrying a virus
 
## Reference
This game is a distributed simulation of a viral outbreak. It is modeled after the Thinking Tags participatory simulations developed at MIT Media Lab. Participatory Simulations have been found to enhance student understanding of complex dynamic relationships, inquiry skills, and scientific understanding. (Colella, V. (2000). Participatory Simulations: Building Collaborative Understanding Through Immersive Dynamic Modeling. _Journal of the Learning Sciences, 9(4), 471–500._ http://dx.doi.org/10.1207/S15327809JLS0904_4)

